#version unofficial MegaPov 1.0;

// Ground
#declare nrm = <0,0,0>;
#declare Ground = height_field { 
	png "lakeb.png" 
	smooth
	translate <-.5,-.5,-.5>
	texture { texGnd }
	scale <1e4, 260, 1e4>
}

#macro pAlt( ob, px, py, alt)
	#local nrm = <0,0,0>;
	#local ps = trace( ob, <px, 1e5, py>, -y, nrm);
	ps+nrm*alt
#end

#macro trnGnd( ob, ang, px, py, alt)
	rotate y*ang
	#local nrm = <0,0,0>;
	#local ps = trace( ob, <px, 1e5, py>, -y, nrm);
	#if (vlength(nrm)>.1) 
		Reorient(y,nrm)
	#end
	translate ps+nrm*alt
#end

#macro trnGndD( ob, ang, px, py, alt)
	rotate y*ang
	#local nrm = <0,0,0>;
	#local ps = trace( ob, <px, 1e5, py>, -y, nrm);
	#if (vlength(nrm)>.1) 
		#debug "Reorienting... \n"
		Reorient(nrm,y)
	#end
	translate ps+nrm*alt
#end

#declare src = pAlt(Ground,  250.0,- 950, 5);
//#declare src = pAlt(Ground, -650.0,- 700, 5);
//#declare src = pAlt(Ground, - 70.0,-1080, 90);
#declare trg = pAlt(Ground, -170.0,- 880, 6);
//#declare trg = pAlt(Ground,  170.0,- 930,-6);

// Test grid
#macro tMark( col, siz, pos, pnt )
	#local pns = pow(pnt,.3);
	union {
		intersection {
			sphere { 0, 1 }
			plane { y, 0 }
		}
		cone { 0, 1, y*pnt, 0 }
		cone { 0, 0.25, < pns, pns*3, pns>, 0 }
		cone { 0, 0.25, < pns, pns*3,-pns>, 0 }
		cone { 0, 0.25, <-pns, pns*3, pns>, 0 }
		cone { 0, 0.25, <-pns, pns*3,-pns>, 0 }
		texture { pigment { rgb col } finish { ambient 0.5 } }
		scale siz
		translate pos
	}
#end

#macro tGrid(num,scl,lgn)
	#local i =-num;
	#while (i<=num)
		#declare il = mod(i,lgn);
		#local j=-num;
		#while (j<=num)
			#declare jl = mod(j,lgn);
			#if (i=0)
				#if (j=0)
					tMark (<1.00, 1.00, 0.00>, 0.4*scl, <i*scl,0,j*scl>, 25)
				#else
					#if (jl=0)
						tMark (<1.00, 1.00, 0.00>, 0.3*scl, <i*scl,0,j*scl>, 20)
					#else
						tMark (<1.00, 0.00, 0.00>, 0.2*scl, <i*scl,0,j*scl>, 15)
					#end
				#end
			#else
				#if (j=0)
					#if (il=0)
						tMark (<1.00, 1.00, 0.00>, 0.3*scl, <i*scl,0,j*scl>, 20)
					#else
						tMark (<1.00, 0.00, 0.00>, 0.2*scl, <i*scl,0,j*scl>, 15)
					#end
				#else
					#if (il=0 & jl=0)
						tMark (<1.00, 0.00, 0.00>, 0.2*scl, <i*scl,0,j*scl>, 15)
					#end
				#end
			#end
			#set j = j + 1;
		#end
		#set i = i + 1;
	#end
#end

#declare wLev = -10;
#declare Water = plane { y, wLev material { matWater } }
