// Parametric variable form

#declare uMin = 0; // Minimum u value
#declare uMax = pi; // Maximum u value
#declare uNum = 46; // Number of points in u direction
#declare uWrap = 0; // u wraps around if != 0
#declare uSeed = 9135; // Random number seed for u parameter

#declare vMin = 0; // Minimum v value
#declare vMax = radians(357); // Maximum v value
#declare vNum = 120; // Number of points in v direction
#declare vWrap = 1; // v wraps around if != 0
#declare vSeed = 2252; // Random number seed for v parameter

#declare IsRnd = false; // True if random number used
#declare IsUV = true; // True if uv-mapping used
#declare Smooth = 0; // Smooth flag

#declare Detail = "Partial"
/* Detail values
  Verbose = Line by line details
  Partial = Operations only
  Other = Filename only
*/

/* For all macro functions
	i = Current value of u parameter
	j = Current value of v parameter
	p = Current value of u variance (0...1)
	q = Current value of v variance (0...1)
*/

// Optional functions
#declare mecc = 0.9; // eccentricity
#declare msqu = sqrt(1-mecc*mecc); // eccectric squash
#declare mhtz = 1.2+mecc; // bend height

// point function
#macro pnt(i, j, p, q)
	#if (i=uMin & j=vMin) // Initialization
		#declare _pc = mCen(lps); // mouse pos
		#declare _dr = mDir(lps); // mouse direction
		#local _n0 = vnormalize(vcross(_dr,y));
		#declare _or = vcross(_n0,_dr);
		#declare _nr = vcross(_or,_dr);
	#end
	#local rd0 = (1-mecc*mecc)/(1-cos(j)*mecc);
	#local ofz = sqrt(mhtz*mhtz-rd0*rd0);
	#local ofx = mhtz+rd0-ofz;
	#local pt0 = <sin(i)*sin(j)*ofx,sin(i)*cos(j)*rd0,cos(i)*rd0*.05+sin(i)*ofz>*lsq+ofs;
	#local trn = function { transform { rotate y*yro rotate x*xro rotate z*zro } }
	#local pt1 = trn(pt0.x,pt0.y,pt0.x);
	#local pt2 = (_pc+_dr*pt1.z+_nr*pt1.x+_or*pt1.y)*mScale;
	pAlt( Ground, cox+pt2.x, coz+pt2.z, pt2.y)
#end
