// Parametric variable form

#declare uMin = 0; // Minimum u value
#declare uMax = 6*pi; // Maximum u value
#declare uNum = 361; // Number of points in u direction
#declare uWrap = 0; // u wraps around if != 0
#declare uSeed = 9135; // Random number seed for u parameter

#declare vMin = 0; // Minimum v value
#declare vMax = radians(355); // Maximum v value
#declare vNum = 72; // Number of points in v direction
#declare vWrap = 1; // v wraps around if != 0
#declare vSeed = 2252; // Random number seed for v parameter

#declare IsRnd = false; // True if random number used
#declare IsUV = true; // True if uv-mapping used
#declare Smooth = 0; // Smooth flag

#declare Detail = "Partial"
/* Detail values
  Verbose = Line by line details
  Partial = Operations only
  Other = Filename only
*/

/* For all macro functions
	i = Current value of u parameter
	j = Current value of v parameter
	p = Current value of u variance (0...1)
	q = Current value of v variance (0...1)
*/

// Optional functions
#declare spRad = spline {
	natural_spline
	-.1, 0
	0, 0
	0.25, 0.20
	0.35, 0.19
	0.70, 0.30
	2.30, 0.25
	2.80, 0.05
	3.20, 0.04
	3.50, 0.03
	5.50, 0.02
	6.00, 0.00
	6.50, 0.00
}

// point function
#macro pnt(i, j, p, q)
	#if (j=vMin) // Calculate only at start of circle
		#declare _st = mCen(i);
		#declare _dr = mDir(i);
		#declare mrad = spRad(i/pi);
	#end

	#local mdir = <cos(j)*0.8,.6*pow(sin(j)+1.0,1.5)-.15,0>;
	#local pt0 = WorldTrans(mdir*mrad,_st,_dr)*mScale;
	pAlt( Ground, cox+pt0.x, coz+pt0.z, pt0.y)
#end
