#version unofficial MegaPov 1.0;

#include "screen.inc"
#include "macbasic.inc"
#include "lights.inc"
#include "param3.inc"
#include "oasistex.inc"
#include "ground.inc"
#include "trees.inc"
#include "Objects/scorpion.inc"
#include "Objects/ant.inc"
#include "Objects/skull.inc"
#include "mousedef.inc"

Set_Camera(src, trg, 90)

#declare osd = seed(582); // Object seed

#global_settings {
	max_trace_level 10
	#if (IsTest)
	#else
		radiosity {
			pretrace_start 1/8
			pretrace_end   1/128
			count 240
			
			nearest_count 6
			error_bound 0.02
			recursion_limit 1
			
			low_error_factor 0.2
			gray_threshold 0.9
			minimum_reuse 0.010
			brightness 1.0
			
			adc_bailout 0.003
		}
	#end
}

// Copyright notice
#declare cdir = vnormalize(trg-src);
#declare crgt = vnormalize(vcross(y,cdir));
#declare cup = vnormalize(vcross(cdir,crgt));
#declare cpt = vnormalize(cdir*10-cup*4.5);

#declare txtCopy = text {
	ttf "chancery.ttf" "(C) 2004 by David Wallace" 0.01,0
	h_align_right
	pigment { rgb <1.0, 1.0, 1.0> }
	scale .02
}

Screen_Object (txtCopy, <1.0,0.0>, 0.01, true, 1)

// Dust storm

#declare t4O = <0.5,sqrt(3)/6,sqrt(6)/12>;
#declare t4A = < sqrt(6),-sqrt(2),-1>;
#declare t4B = <-sqrt(6),-sqrt(2),-1>;
#declare t4C = < 0.0, sqrt(8),-1>;
#declare t4D = < 0.0, 0.0, 3>;

#declare dsd = seed(5823); // Dust seed

#macro vrCol(sd) 
	#local vBr = rand(sd);
	<pow(vBr, 0.20), pow(vBr, 0.23), pow(vBr, 0.54)> 
#end

#declare dSpore = mesh {
	triangle { t4A, t4B, t4C }
	triangle { t4A, t4B, t4D }
	triangle { t4A, t4D, t4C }
	triangle { t4D, t4B, t4C }
}

#macro vdPos(sd, Base, yRot, RadIn, RadOut, SpirLen, SpirPow, Height)
	#local sp = pow(rand(sd), SpirPow);
	#local sa = sp*SpirLen;
	#local lt = (rand(sd)-.5)*pi;
	#local lg = (rand(sd)-.5)*2*pi;
	#local ri = pow(rand(sd),.4)*pow(sp,.6)*RadIn;
	#local ro = pow(sp,.5)*RadOut;
	#local pc = <ro*cos(sa), sp*Height, ro*sin(sa)>;
	#local pd = <ri*cos(lt)*cos(lg), ri*sin(lt), ri*cos(lt)*sin(lg)>;
	object { dSpore
		rotate vRndRange(sd,<0,0,0>,<90,180,90>)
		scale (rand(sd)+2)*0.01
		translate Base+pc+pd
		texture {
			pigment { rgb vrCol(sd) }
			finish { ambient 0.3 }
		}
	}
#end
			
#macro Dust(npart, dcx, dcy)
	#local dri = 0;
	#local dcen = pAlt(Ground, dcx, dcy, 0);
	#local yr = rand(dsd)*360;
	#while (dri<npart)
		vdPos(dsd, dcen, yr, 25.84, 22.24, 41, 0.52, 148)
	  #set dri = dri + 1;
	#end
#end

// Mouse
/*#declare cry =  - 46;
#declare cox = 243.2;
#declare coz = -952;
#declare cox = 248.2;
#declare coz = -949;*/

// Other objects

//MakePara("dfly.inc", "dflyobj.inc")
#declare DragonFly = object { #include "dflyobj.inc" scale .4 }

#macro Flies(nants, arcx, arcz, arad) 
	#local ari = 0;
	#while (ari<nants)
		#local ard = pow(rand(osd),0.5)*arad;
		#local aang = rand(osd)*2*pi;
		#local ax = arcx+ard*cos(aang);
		#local ay = arcz+ard*sin(aang);
		object { DragonFly
			texture { #if (rand(osd)<.5) texDragonM #else texDragonF #end }
			trnGnd(Ground, 360*rand(osd), ax, ay, 0.4+rand(osd)*7 )
		}
	  #set ari = ari + 1;
	#end
#end

#macro Ants(nants, arcx, arcz, arad) 
	#local ari = 0;
	#while (ari<nants)
		#local ard = pow(rand(osd),0.7)*arad;
		#local aang = rand(osd)*2*pi;
		#local ax = arcx+ard*cos(aang);
		#local ay = arcz+ard*sin(aang);
		object { Ant
			scale 2e-4
			trnGnd(Ground, 360*rand(osd), ax, ay, 0.05)
		}
	  #set ari = ari + 1;
	#end
#end

//MakePara("coral.inc", "coral.pbj",0,0)
#declare Coral = object { #include "coral.pbj" texture { texCoral } }
