// Persistence Of Vision Raytracer Version 3.6
// File : GM_xx.POV - (IRTC Name "ABBIROOM.POV")
// Date : Sep-Oct 2004 
// Auth : James Coons
// Desc : IRTC Entry for "Toys and Games" (October 2004)
// Title: This Was Abbi's Room
//
// Render Time: Approx 41 min (Q=9, Cam=70, AA 0.3, No Radiosity, No Photons)

#include "Colors.inc"
#include "Textures.inc"
#include "Woods.inc"
#include "Metals.inc"
#include "Shapes.inc"

global_settings {max_trace_level 50}
   
#declare Axes     =  0; // 0=No, 1=Yes (Debugging Axes)                                                          /Axes
#declare GridLines=  0; // 0=No, 1=Yes (Projected Debugging Grid Lines)                                          /GridLines

// ************************************************************************************************************************
// /Q Choices: /Q00=Min Res All Objects, /Q09=Max Res All Objects, 99=Use Settings
// ************************************************************************************************************************
#declare Q        = 10; // /Q10=Final Render, Max Res, Optionals On
#declare Q        = 99; // /Q99=Use Settings
#declare Q        = 00; // /Q00=Min Res All Objects
#declare Q        = 09; // /Q09=Max Res All Objects

// ************************************************************************************************************************
// *** Scene Settings 
// ************************************************************************************************************************
#declare Normals_On     =  1;    // 0=No, 1=Yes
#declare Images_On      =  1;    // 0=Simple Color, 1=Image
// Manual Settings (Forced On for Render=Final)
#declare Radiosity_On   =  0;    // 0=No, 1=Yes (Manual/Final)
#declare Photons_On     =  0;    // 0=No, 1=Yes (Manual/Final)
// /Lighting
#declare Spotlights_On  =  1;    // 0=No, 1=Yes (Optional) (all special Lights)
#declare Light_Guitar   =  1;    // 0=No, 1=Yes (Optional) obj_Light_Guitar
#declare Light_Game     =  1;    // 0=No, 1=Yes (Optional) obj_Light_Game
#declare Light_Crayons  =  1;    // 0=No, 1=Yes (Optional) obj_Light_Crayons
#declare Room_Lights    =  1;    // 0=No, 1=Yes (Optional) 
   #include "_INIT.INC"

// ************************************************************************************************************************
// *** Object Settings 
// ************************************************************************************************************************
#declare Sun_On         =  1;    // 0=No, 1=Yes
#declare Sky_On         =  1;    // 0=No, 1=Yes
#declare Floor_Type     =  3;    // 0=None, 1=Flat, 2=Tiled, 3=Both
#declare Walls_On       =  1;    // 0=No, 1=Yes
#declare Ceiling_On     =  1;    // 0=No, 1=Yes
#declare Toys_On        =  1;    // 0=No, 1=Yes

// ************************************************************************************************************************ 
// /View /Cam (Move Desired View to bottom of list)
//     Various Camera Views (some set Quality, Lights, etc)
// ************************************************************************************************************************
#declare Cam=10; // /Cam10=Overhead Room (Lo-Res, No-Ceiling)
#declare Cam=12; // /Cam12=Outside House (No-Ceiling) /Outside
#declare Cam=13; // /Cam13=God View (No-Ceiling) /God
#declare Cam=21; // /Cam21=Look At Ceiling /Inside /Back
#declare Cam=22; // /Cam22=Back Wall Only
#declare Cam=53; // /Cam53=Guitar Closeup (Body)
#declare Cam=52; // /Cam52=Guitar Closeup (Neck)
#declare Cam=54; // /Cam54=Guitar Extreme (Neck/Strings)
#declare Cam=55; // /Cam55=Guitar Extreme (Sound Hole)
#declare Cam=62; // /Cam62=Board Game Overhead
#declare Cam=51; // /Cam51=Guitar Closeup (Head)
#declare Cam=50; // /Cam50=Guitar Portrait
#declare Cam=72; // /Cam72=Crayon Overhead
#declare Cam=61; // /Cam61=Board Game Red Side
#declare Cam=60; // /Cam60=Board Game Portrait
#declare Cam=25; // /Cam25=Left Wall
#declare Cam=24; // /Cam24=Corner Portrait /Corner
#declare Cam=71; // /Cam71=Crayon Overhead Closeup
#declare Cam=11; // /Cam11=Overhead Room (Hi-Res, No-Ceiling)
#declare Cam=23; // /Cam23=Baseboard Closeup
#declare Cam=20; // /Cam20=Entire Room /Inside /Back /Normal
#declare Cam=70; // /Cam70=Crayon Portrait

// ************************************************************************************************************************
// Setup For Specific Quality Settings
// ************************************************************************************************************************
   #if (Q=0) // /Q00=Min Res All Objects
      #declare Axes           = Axes         ;  // 0=No, 1=Yes (MANUAL)
      #declare GridLines      = GridLines    ;  // 0=No, 1=Yes (MANUAL)
      #declare Toys_On        = Toys_On      ;  // 0=No, 1=Yes (MANUAL)
      #declare Sun_On         =     1;          // 0=No, 1=Yes
      #declare Sky_On         =     1;          // 0=No, 1=Yes
      #declare Floor_Type     =     1;          // 0=None, 1=Flat, 2=Tiled, 3=Both
      #declare Walls_On       =     1;          // 0=No, 1=Yes
      #declare Normals_On     =     0;          // 0=No, 1=Yes
      #declare Images_On      =     0;          // 0=Simple Color, 1=Image
      // Use Manual Settings Verbatim
      #declare Radiosity_On   = Radiosity_On  ; // 0=No, 1=Yes (Manual/Final)
      #declare Photons_On     = Photons_On    ; // 0=No, 1=Yes (Manual/Final)
      #declare Spotlights_On  = Spotlights_On ; // 0=No, 1=Yes (Manual/Final)
      #declare Ceiling_On     =     1;          // 0=No, 1=Yes
   #end
   #if (Q=9) // /Q09=Max Res All Objects
      #declare Axes           = Axes          ; // 0=No, 1=Yes (MANUAL)
      #declare GridLines      = GridLines     ; // 0=No, 1=Yes (MANUAL)
      #declare Toys_On        = Toys_On       ; // 0=No, 1=Yes (MANUAL)
      #declare Sun_On         =     1;          // 0=No, 1=Yes
      #declare Sky_On         =     1;          // 0=No, 1=Yes
      #declare Floor_Type     =     3;          // 0=None, 1=Flat, 2=Tiled, 3=Both
      #declare Walls_On       =     1;          // 0=No, 1=Yes
      #declare Normals_On     =     1;          // 0=No, 1=Yes
      #declare Images_On      =     1;          // 0=Simple Color, 1=Image
      // Use Manual Settings Verbatim
      #declare Radiosity_On   = Radiosity_On  ; // 0=No, 1=Yes (Manual/Final)
      #declare Photons_On     = Photons_On    ; // 0=No, 1=Yes (Manual/Final)
      #declare Spotlights_On  = Spotlights_On ; // 0=No, 1=Yes (Manual/Final)
      #declare Ceiling_On     =     1;          // 0=No, 1=Yes
   #end
   #if (Q=10) // /Q10=Final Render, Max Res, Optionals On
      #declare Axes           =     0;          // 0=No, 1=Yes (MANUAL)
      #declare GridLines      =     0;          // 0=No, 1=Yes (MANUAL)
      #declare Toys_On        =     1;          // 0=No, 1=Yes (MANUAL)
      #declare Sun_On         =     1;          // 0=No, 1=Yes
      #declare Sky_On         =     1;          // 0=No, 1=Yes
      #declare Floor_Type     =     3;          // 0=None, 1=Flat, 2=Tiled, 3=Both
      #declare Walls_On       =     1;          // 0=No, 1=Yes
      #declare Normals_On     =     1;          // 0=No, 1=Yes
      #declare Images_On      =     1;          // 0=Simple Color, 1=Image
      // Force Manual Settings On
      #declare Radiosity_On   =     1;          // 0=No, 1=Yes (Manual/Final)
      #declare Photons_On     =     1;          // 0=No, 1=Yes (Manual/Final)
      #declare Spotlights_On  =     1;          // 0=No, 1=Yes (Manual/Final)
      #declare Ceiling_On     =     1;          // 0=No, 1=Yes
      #declare Normals_On     =     1;          // 0=No, 1=Yes
      #declare Images_On      =     1;          // 0=Simple Color, 1=Image
   #end
   // /Q99=Use All Settings as Defined

// ************************************************************************************************************************
// Available Cameras and Views /Views /Cameras
// ************************************************************************************************************************
#declare Cam_Pos            = <-12*ft, Room_High+(12*ft), -12*ft> ;
#declare Cam_Aim            = <Room_Wide/2, Room_High/2, Room_Deep/2> ;
#declare Cam_Angle          = 67.38               ; // Default
#switch (true)
   // *** OVERHEAD VIEWS **************************************************************************************************
   #case (Cam=10) // /Cam10=Overhead Room (Lo-Res, No-Ceiling) /High /Overhead
      #declare Cam_Pos      = <Room_Wide/2, Room_High*2.6, Room_Deep/2> ;
      #declare Cam_Aim      = <Room_Wide/2,        -1, Room_Deep/2> ;
      #declare Ceiling_On   =  0 ;   // 0=No, 1=Yes
      #declare Q            =  00;   // Force /Q00=Min Res All Objects
      #break
   #case (Cam=11) // /Cam11=Overhead Room (Hi-Res, No-Ceiling) /High /Overhead
      #declare Cam_Pos      = <Room_Wide/2, Room_High*2.6, Room_Deep/2> ;
      #declare Cam_Aim      = <Room_Wide/2,        -1, Room_Deep/2> ;
      #declare Ceiling_On   =  0 ;   // 0=No, 1=Yes
      #declare Q            =  09;   // Force /Q09=Max Res All Objects
      #break
   #case (Cam=12) // /Cam12=Outside View /Outside
      #declare Cam_Pos      = <-12*ft, Room_High+(12*ft), -12*ft> ;
      #declare Cam_Aim      = <Room_Wide/2, 0, Room_Deep/2> ;
      #declare Ceiling_On   =  0 ;   // 0=No, 1=Yes
      #break
   #case (Cam=13) // /Cam13=God View (No-Ceiling) /God
      #declare Cam_Pos      = <-12*ft, Room_High+(12*ft), -12*ft> ;
      #declare Cam_Aim      = <Room_Wide/2, 0, Room_Deep/2> ;
      #declare Ceiling_On   =  0 ;   // 0=No, 1=Yes
      #break

   // *** ROOM VIEWS ******************************************************************************************************
   #case (Cam=20) // /Cam20=Entire Room /Inside /Back /Normal 
      #declare Cam_Angle    = 85 ;
      #declare Cam_Aim      = <Room_Wide/2, 0, Room_Deep*0.20> ;
      #declare Cam_Pos      = <Room_Wide/2, 15*in, 4*in> ;
      #declare Ceiling_On   =  1 ;   // 0=No, 1=Yes
      #break
   #case (Cam=21) // /Cam21=Look At Ceiling /Inside /Back /Normal
      #declare Cam_Angle    = 85 ;
      #declare Cam_Aim      = <Room_Wide/2, Room_High, Room_Deep*0.5> ;
      #declare Cam_Pos      = <Room_Wide/2, 20*in, 5*in> ;
      #declare Ceiling_On   =  1 ;   // 0=No, 1=Yes
      #break
   #case (Cam=22) // /Cam22=Back Wall Only
      #declare Cam_Angle    = 85 ;   
      #declare Cam_Aim      = <Room_Wide/2, Room_High/2, Room_Deep> ;
      #declare Cam_Pos      = <Room_Wide/2, Room_High/2, 3.8*ft> ;
      #declare Ceiling_On   =  1 ;   // 0=No, 1=Yes
      #break
   #case (Cam=23) // /Cam23=Baseboard Closeup
      #declare Cam_Angle    =  8 ;   
      #declare Cam_Aim      = <Room_Wide/2, Room_High/2-60*in, Room_Deep> ;
      #declare Cam_Pos      = <Room_Wide/2, Room_High/2, 3.8*ft> ;
      #declare Ceiling_On   =  1 ;   // 0=No, 1=Yes
      #break
   #case (Cam=24) // /Cam24=Corner Portrait
      #declare Cam_Angle    = 27                  ; // Default
      #declare Cam_Aim      = <36*in, 20*in, Room_Deep-36*in> ;
      #declare Cam_Pos      = Cam_Aim + <+8*ft, +2*ft, -7*ft> ;
      #declare Light_Guitar = 1 ; // obj_Light_Guitar
      #declare Light_Crayons= 1 ; // obj_Light_Crayons
      #declare Light_Game   = 1 ; // obj_Light_Game
      #break
   #case (Cam=25) // /Cam25=Left Wall
      #declare Cam_Angle    = 60 ;
      #declare Cam_Aim      = <1*ft, 5*ft, Room_Deep/2> ;
      #declare Cam_Pos      = Cam_Aim + <13*ft, 0, 0*in> ;
      #declare Spotlights_On=  0;   // 0=No, 1=Yes (Optional) (all special Lights)
      #declare Ceiling_On   = 1 ;   // 0=No, 1=Yes
      #break
   
   // *** GUITAR VIEWS ****************************************************************************************************
   #case (Cam=50) // /Cam50=Guitar Portrait
      #declare Cam_Angle    = 67.38               ; // Default
      #declare Cam_Pos      = <4*ft, 1*ft, Room_Deep-4*ft >;
      #declare Cam_Aim      = <5*in, 15*in, Room_Deep-10*in> ;
      #declare Light_Guitar = 1 ; // obj_Light_Guitar
      #break
   #case (Cam=51) // /Cam51=Guitar Closeup (Head)
      #declare Cam_Angle    = 12;
      #declare Cam_Pos      = <4*ft, 1*ft, Room_Deep-4*ft >;
      #declare Cam_Aim      = <5*in, 32*in, Room_Deep-6*in> ;
      #declare Light_Guitar = 1 ; // obj_Light_Guitar
      #break
   #case (Cam=52) // /Cam52=Guitar Closeup (Neck)
      #declare Cam_Angle    = 25;
      #declare Cam_Pos      = <4*ft, 1*ft, Room_Deep-4*ft >;
      #declare Cam_Aim      = <6.5*in, 20*in, Room_Deep-6*in> ;
      #declare Light_Guitar = 1 ; // obj_Light_Guitar
      #break
   #case (Cam=53) // /Cam53=Guitar Closeup (Body)
      #declare Cam_Angle    = 22;
      #declare Cam_Pos      = <4*ft, 1*ft, Room_Deep-4*ft >;
      #declare Cam_Aim      = <5*in, 8*in, Room_Deep-6*in> ;
      #declare Light_Guitar = 1 ; // obj_Light_Guitar
      #break
   #case (Cam=54) // /Cam54=Guitar Extreme (Neck/Strings)
      #declare Cam_Angle    = 4;
      #declare Cam_Pos      = <4*ft, 1*ft, Room_Deep-4*ft >;
      #declare Cam_Aim      = <6.5*in, 20*in, Room_Deep-6*in> ;
      #declare Light_Guitar = 1 ; // obj_Light_Guitar
      #break
   #case (Cam=55) // /Cam55=Guitar Extreme (Sound Hole)
      #declare Cam_Angle    = 8;
      #declare Cam_Pos      = <4*ft, 1*ft, Room_Deep-4*ft >;
      #declare Cam_Aim      = <5*in, 9*in, Room_Deep-6*in> ;
      #declare Light_Guitar = 1 ; // obj_Light_Guitar
      #break
   
   // *** BOARD GAME VIEWS *********************************************************************************************
   #case (Cam=60) // /Cam60=Board Game Portrait
      #declare Cam_Angle    = 18.0 ; // 17.5;
      #declare Cam_Aim      = <33.5*in, 0*in, Room_Deep-12*in> ;
      #declare Cam_Pos      = Cam_Aim + <4*ft,4*ft,-4*ft> ;
      #declare Light_Game   = 1 ; // obj_Light_Game
      #break
   #case (Cam=61) // /Cam61=Board Game Red Side
      #declare Cam_Angle    = 22;
      #declare Cam_Aim      = <33.2*in, 0*in, Room_Deep-19*in> ;
      #declare Cam_Pos      = Cam_Aim + <0, 39*in, -30*in> ;
      #declare Light_Game   = 1 ; // obj_Light_Game
      #break
   #case (Cam=62) // /Cam62=Board Game Overhead
      #declare Cam_Angle    = 13;
      #declare Cam_Aim      = <30*in, 0*in, Room_Deep-15*in> ;
      #declare Cam_Pos      = Cam_Aim + <0, 6.5*ft, -21*in> ;
      #declare Light_Game   = 1 ; // obj_Light_Game
      #break

   // *** CRAYON VIEWS *************************************************************************************************
   #case (Cam=70) // /Cam70=Crayon Portrait
      #declare Cam_Angle    = 23 ;
      #declare Cam_Aim      = <13*in, 1*in, Room_Deep-19*in-17*in> ;
      #declare Cam_Pos      = Cam_Aim + <6*ft, 2.5*ft,-19*in> ;
         // #declare Cam_Pos   = Cam_Aim + <3*ft, 0.2*ft,-18*in> ; // Eye-Level
      #declare Spotlights_On= 1 ;    // 0=No, 1=Yes (Optional) (all special Lights)
      #declare Light_Crayons= 1 ;
      #break
   #case (Cam=71) // /Cam71=Crayon Overhead Closeup
      #declare Cam_Angle    = 23 ;
      #declare Cam_Aim      = <13*in, 1*in, Room_Deep-37.5*in> ;
      #declare Cam_Pos      = Cam_Aim + <1*in, 38*in,+6*in> ;
      #declare Spotlights_On= 1 ;    // 0=No, 1=Yes (Optional) (all special Lights)
      #declare Light_Crayons= 1 ;
      #break
   #case (Cam=72) // /Cam72=Crayon Overhead
      #declare Cam_Angle    = 49.5 ;
      #declare Cam_Aim      = <12*in, 1*in, Room_Deep-37.5*in> ;
      #declare Cam_Pos      = Cam_Aim + <2*in, 3*ft, 0> ;
      #declare Spotlights_On= 1;    // 0=No, 1=Yes (Optional) (all special Lights)
      #declare Light_Crayons= 1 ;
      #break

   // ******************************************************************************************************************
#end

// ************************************************************************************************************************
// /Light Choices:
// ************************************************************************************************************************
#declare Light=03; // /Light03=Sunset Right
#declare Light=02; // /Light02=Overhead Left
#declare Light=08; // /Light08=Sunset Left
#declare Light=09; // /Light09=Center Spotlight
#declare Light=04; // /Light04=Sunlight (3 Lights)
#declare Light=01; // /Light01=Room Lights Only
#declare Light=00; // /Light00=No Room Lights

// SPOTLIGHTS
#if (Spotlights_On=1 & Light_Guitar=1)
   // Special Spotlight on Guitar (Cameras 50-55)
   light_source {<5*ft,Room_High-10*in,Room_Deep-5*ft>  
      color White*2.5
      spotlight
      point_at <12*in, 21*in, Room_Deep-12*in>
      radius 5/14/10*2        // hotspot (inner, in degrees)
      tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
      falloff 9               // intensity falloff radius (outer, in degrees)
      #if (Photons_On=1) photons {refraction on reflection on} #end
   }
#end
#if (Spotlights_On=1 & Light_Game=1)
   // Special Spotlights on Board Game (Cameras 60-62)
   //    Front light for board reflection and rear light for highlighting.
   union {
      light_source {<5*ft,Room_High-10*in,Room_Deep-5*ft>  
         color White*1.4
         spotlight
         point_at <33*in, 1*in, Room_Deep-13*in>
         radius 5/14/10/3/4   // hotspot (inner, in degrees)
         tightness 50/2       // tightness of falloff (1...100) lower is softer, higher is tighter
         falloff 7            // intensity falloff radius (outer, in degrees)
         #if (Photons_On=1) photons {reflection on refraction on} #end
         }
      light_source {<1*ft,Room_High-10*in,Room_Deep-1*ft>  
         color White*1.4
         spotlight
         point_at <35*in, 1*in, Room_Deep-11*in>
         radius 5/14/10/2     // hotspot (inner, in degrees)
         tightness 50         // tightness of falloff (1...100) lower is softer, higher is tighter
         falloff 7            // intensity falloff radius (outer, in degrees)
         #if (Photons_On=1) photons {reflection on refraction on} #end
         }
      }
#end
#if (Spotlights_On=1 & Light_Crayons=1)
   // Special Spotlights on Crayons (Cameras 70-72)
   light_source {<5*ft, Room_High-10*in, Room_Deep-9*ft>  
      color White*1.0         // light's color
      spotlight               // this kind of light source
      point_at <12*in, 0*in, Room_Deep-32*in>
      radius 6.0              // hotspot (inner, in degrees)
      tightness 50/100        // tightness of falloff (1...100) lower is softer, higher is tighter
      falloff 7.0             // intensity falloff radius (outer, in degrees)
      #if (Photons_On=1) photons {reflection on refraction on} #end
   }
   light_source {<8*ft, Room_High-10*in, Room_Deep-2*ft>  
      color White*1.0         // light's color
      spotlight               // this kind of light source
      point_at <12*in, 0*in, Room_Deep-32*in>
      radius 6.0              // hotspot (inner, in degrees)
      tightness 50/100        // tightness of falloff (1...100) lower is softer, higher is tighter
      falloff 7.0             // intensity falloff radius (outer, in degrees)
      #if (Photons_On=1) photons {reflection on refraction on} #end
   }
#end

// ************************************************************************************************
// Camera 
// ************************************************************************************************
camera {
   //#if (Cam=72)
   //   orthographic
   //#end
   location Cam_Pos 
   look_at Cam_Aim 
   angle Cam_Angle
   }

// ************************************************************************************************************************
// Sun /Sun
// ************************************************************************************************************************
//#if (Sun_On=1)
   #declare Sun_Color         =                 // Color used for Sun
      (White*.9+Gold*.5+SkyBlue*.25)*1.1;  
   #declare Sun_Pos           = <2000,9000,-6000> ; // /Sun
   light_source {0 Sun_Color fade_distance 50000 fade_power 1 translate Sun_Pos}
//#end

// ************************************************************************************************
// Outside Sky (Used if Visible through a Window) /Sky
// ************************************************************************************************
#if (Sky_On=1)
   #declare Sky_Radius = 500000;       // Radius of Sky Sphere
   #declare Sky_Seed   =      2;       // Produce Variations of Sky
   #declare Sky_Color  = LightBlue ;   // Color to Tint Sky
   sphere { <0.0, 0.0, 0>, Sky_Radius*5 translate <0,-Sky_Radius,0> 
      #if (Images_On = 0)
         pigment {Sky_Color}
      #else
            pigment {
               agate scale 320000 turbulence 0.15
               // average scale 320000 turbulence 0.15
               pigment_map {
                  [+1.0  image_map {jpeg "_Clouds.jpg" map_type 1} 
                     rotate y*(Sky_Seed) warp {turbulence 0.1} ]
                  }
               }
      #end  
      finish {ambient 1.0 diffuse 0 reflection 0 }
      inverse
      no_shadow
      scale <100,20,100>
   }
#end

// ************************************************************************************************************************
// Room Lights /Lights
// ************************************************************************************************************************
#declare Bulb_Loc        = <Room_Wide/2, Room_High-(5*in), Room_Deep/2> ;
#declare Bulb_Color      = White ;  

#if (Room_Lights=1) // /Light01=Room Lights Only
   #declare Room_Light = 
      union {
         sphere {0 5*in
            pigment {color Bulb_Color*Room_Brightness filter 0.999}
            finish {ambient 10.0 diffuse 0.3 reflection 1.0} 
            no_shadow}
         light_source {<0,0,0> color Bulb_Color*Room_Brightness}
      }
   object {Room_Light translate <Room_Wide*0.25, Room_High-(15*in), Room_Deep/2> }
   object {Room_Light translate <Room_Wide*0.75, Room_High-(15*in), Room_Deep/2> }
#end
   
#switch (true)
   #case (Light=00) // /Light00=No Room Lights
      // Do not define any lights
      #break
   #case (Light=02) // /Light02=Overhead Left /Light02
      #declare Light_Transform = transform {translate <-5000,9000,-5000> }
      #break
   #case (Light=03) // /Light03=Sunset Right /Light03
      #declare Light_Transform = transform {translate <-500,2000,5000> rotate y*45} 
      #break
   #case (Light=04) // /Light04=Sunlight (3 Lights) OK
      light_source {10*<-30, 30, -10> color rgb White}
      light_source {10*<+30, 30, +10> color rgb White}
      light_source {10*<-10, 20, +80> color rgb White}
      #break
   #case (Light=08) // /Light08=Sunset Left /Light08
      #declare Light_Transform = transform {translate <-500,2000,5000> } 
      #break
   #case (Light=9) // /Light09=Center Spotlight /Light09
      light_source {
         <30,30,-60> 
         color White
         spotlight               // this kind of light source
         rotate y*-100
         point_at <0.2, 0, 0>    // direction of spotlight
         radius 5/14             // hotspot (inner, in degrees)
         tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
         falloff 8/20            // intensity falloff radius (outer, in degrees)
      }
      #break
   #else
      #declare Light_Transform = transform {translate <2000,9000,-6000> }
      #break
#end

// ************************************************************************************************
// Draw Reference Axes (For Debugging)
// ************************************************************************************************
#include "Axes.INC" // /Axes

// ************************************************************************************************
// Debugging Plane for outside Room View, normally not visible
// plane {y, -0.25 pigment { color rgb <0.7,0.5,0.3> } finish {ambient 0.3 diffuse 0.3 reflection 0} }

// ************************************************************************************************************************
// Walls with Self-Normals /Walls /Room
// ************************************************************************************************************************
#if (Walls_On=1)
   #declare Wall_Scale = 12.0*2.6/1/2 ; // _Paper11.JPG - Stucco  
   #declare Wall_Scale = 12.0*2.6/6   ; // _Paper15.JPG - Granny  
   #declare Wall_Scale = 12.0*2.6/4   ; // _Paper12.jpg - Squares
   #declare Wall_Scale = 12.0*2.6/2   ; // _Paper15.JPG - Gray/Black Fresco  
   #declare Wall_Scale = 12.0*2.6/2   ; // _Paper15.jpg - Black/White/Red Fresco
   #declare Wall_Transform = transform {scale Wall_Scale scale <1/2/1.414, 0.56, 1> rotate y*-45} ;

   #declare Wall_Pigment = 
      // pigment {image_map {jpeg "_Paper22.JPG" map_type 0} transform Wall_Transform scale 1.0} // Simple
      pigment {
         average
         pigment_map {
            [+1.0 image_map {jpeg "_Paper25.JPG" map_type 0} transform Wall_Transform scale 1.0]
            [+0.6 image_map {jpeg "_Paper26.JPG" map_type 0} transform Wall_Transform scale 0.5]
            [-0.4 image_map {jpeg "_Paper22.JPG" map_type 0} transform Wall_Transform scale 0.25]
            }
         }

   #declare Wall_Color = color rgb <118,119,116>/255 ;
   #declare Wall_Texture =
      texture {
         #if (Images_On=1)
            pigment {Wall_Pigment}
         #else   
            pigment {color Wall_Color}
         #end
         finish {ambient 0.2 diffuse 0.30}
         #if (Normals_On=1)
            // Air Bubbles under wallpaper
            #declare Wrinkled = pigment {agate color_map {[0.0 color 0.0] [0.7 color 0.0] [1.0 color 1.0] } }
            normal {pigment_pattern {Wrinkled scale 15} bump_size 1.82 }
         #end
         }
   
   #declare obj_Wall = 
      union {
         // Left Wall
         box {<0,0,0> <0,Room_High,Room_Deep>}
         // Back Wall
         box {<0,0,Room_Deep> <Room_Wide,Room_High,Room_Deep>}
         // Right Wall
         box {<Room_Wide,0,Room_Deep> <Room_Wide,Room_High,0>}
         // Front Wall
         box {<0,0,0> <Room_Wide,Room_High,0>}
         // photons {reflection 1 refraction 1 target}
         }

   // Peeling Wallpaper /Peel
   #declare obj_Peeling_Wallpaper =
      height_field {jpeg "_Peel.jpg" // water_level 0.01 // smooth 
         translate -.5 /* rotate y*180 */ translate +.5
         translate x*-0.5
            rotate x*-90 rotate y*-90
            scale <0.12*in, Room_High, 1.0*in>
         translate <0.01*in, 1.70*in, Room_Deep-33*in> 
         }

   // The walls are Unioned so the texture "Wraps" around the corners.
   union {
      object {obj_Wall}
      object {obj_Peeling_Wallpaper}
      object {obj_Peeling_Wallpaper translate z*3*ft}
      object {obj_Peeling_Wallpaper translate z*6*ft}
      object {obj_Peeling_Wallpaper translate z*-3*ft}
      object {obj_Peeling_Wallpaper translate z*-6*ft}
      object {obj_Peeling_Wallpaper translate z*-9*ft}
      texture {Wall_Texture}
      translate z*2*in
      }
      
   // Ceiling (not visible, so just wallpaper it /Ceiling
   #if (Ceiling_On=1)
      box {<0,Room_High,0> <Room_Wide,Room_High,Room_Deep>
         texture {
            #if (Images_On=1)
               pigment {Wall_Pigment rotate x*90}
            #else   
               pigment {color Wall_Color}
            #end
            finish {ambient 0.3 diffuse 0.3}
            }
   #end
#end

// ************************************************************************************************************************
// File generated by SpilinEditor v1.2 (POV-Ray v3.0 syntax)
// ************************************************************************************************************************
#declare adj_Baseboard   = <0.02*in, -0.08*in, 0> ;
#declare Baseboard_Prism = // /Baseboard
   prism {
   	cubic_spline 0, 1.000000, 20,
   	<0.150,0.210>,	<0.163,0.190>,	<0.178,0.170>,	<0.193,0.170>,
   	<0.215,0.170>,	<0.240,0.170>,	<0.265,0.162>,	<0.278,0.152>,
   	<0.293,0.150>,	<0.295,0.152>,	<0.308,0.167>,	<0.318,0.180>,
   	<0.340,0.197>,	<0.365,0.205>,	<0.383,0.215>,	<0.388,0.240>,
   	<0.135,0.242>,	<0.150,0.210>,	<0.163,0.190>,	<0.178,0.170>
   	translate x*-0.15 
   	translate y*-0.21 
   	rotate x*90 rotate y*90
   	translate y*0.25
   	scale <100,2,1>*10
   	translate <0,-0.30*in,1.1*in>
   }
#declare BaseBoard=
   object {Baseboard_Prism
      texture {
         #if (Images_On=1)
            // pigment {image_map {jpeg "_base.jpg" map_type 0} turbulence 0.1 scale <30,2,2> } // Simple Pigment
            pigment {
               average
               pigment_map {
                  [+1.00 image_map {jpeg "_base.jpg" map_type 0} turbulence 0.1 scale <29, 2.0, 1.9> ]
                  // [-0.40 image_map {jpeg "_base.jpg" map_type 0} turbulence 0.1 scale <31, 2.3, 1.7>*0.75 translate x*10]
                  [-0.35 image_map {jpeg "_base.jpg" map_type 0} turbulence 0.1 scale <31, 2.3, 1.7>*0.75 translate x*10]
                  [-0.15 image_map {jpeg "_base.jpg" map_type 0} turbulence 0.1 scale <31, 2.3, 1.7>*0.25 translate x*10] // Added
                  }
               }
         #else   
            pigment {Brown} finish {ambient 0.3*10 diffuse 0.3}
         #end
         #if (Normals_On=1)
            normal {bump_map {jpeg "_base.jpg"} accuracy 0.1 scale <1.0,2.0,29> bump_size 0.4} // Self-Normal
         #end
         finish {ambient 0.3 diffuse 0.3 
            #if (Images_On=1)
               reflection 0.12
               specular 0.10
               phong 0.55
               phong_size 25
            #end
            }
         }
      }
   }
union {
   object {BaseBoard rotate y*-90}                       // Left Wall
   object {BaseBoard translate z*Room_Deep}              // Back Wall
   object {BaseBoard rotate y*90 translate x*Room_Wide}  // Right Wall
   translate adj_Baseboard
   }

// *********************************************************************************************************************
// Crayon Macro /Crayons
//    MakeCrayon (CrayonColor, CrayonText)
// *********************************************************************************************************************
#if (Toys_On=1)
   #include "_Crayon.inc"
   #declare adj_Crayon = <7*in, 0.35*in, Room_Deep-33*in> ;
#declare BlueGreen    = (5*Green  + 2*Blue  )/7 ;
#declare YellowGreen  = (5*Green  + 2*Yellow)/7 ;
#declare BlueViolet   = (5*Violet + 2*Blue  )/7 ;
#declare RedViolet    = (5*Violet + 2*Red   )/7 ;
#declare RedOrange    = (5*Orange + 2*Red   )/7 ;
#declare YellowOrange = (5*Orange + 2*Yellow)/7 ;
   union {
      // On Floor
      object {MakeCrayon (NeonPink*0.8  , "Neon Pink      ") rotate z*+90 rotate y*180 rotate y*-5 translate <10, 0, -12> }
      object {MakeCrayon (Copper*0.8    , "Copper         ") rotate z*+90 rotate y*180 rotate y*-5 translate <8.0, 0, -14> }
      object {MakeCrayon (Scarlet*0.9   , "Scarlet        ") rotate z*+90 rotate y*180 rotate y*-10 translate <-1.2, 0, -13> }
      object {MakeCrayon (White*0.1     , "Black          ") rotate z*+90 rotate y*180 rotate y*-17 translate <8.0, 0, -11> }
      object {MakeCrayon (Brown*0.5     , "Brown          ") rotate z*+90 rotate y*180 rotate y*-5 translate <-2.0, 0, -9> }
      object {MakeCrayon (YellowOrange  , "Yellow Orange  ") rotate z*+90 rotate y*180 rotate y*20 translate <+11.0, -0.1*in, -3> }
      object {MakeCrayon (SkyBlue*0.7   , "Sky Blue       ") rotate z*+90 rotate y*180 rotate y*15 rotate y*-60 translate <+4.0, 0, -7.2> }
      object {MakeCrayon (RedOrange     , "Red Orange     ") rotate z*+90 rotate y*180 rotate y*15 rotate y*-60 translate <-4.0, 0.1, -8> }
      object {MakeCrayon (Green*0.6     , "Green          ") rotate z*+90 rotate y*180 rotate y*30 translate <14.9, 0, -6.4> }
                                        
      object {MakeCrayon (Yellow*0.8    , "Yellow         ") rotate z*+90 rotate y*180 translate <3.0, 0, 0> }
      object {MakeCrayon (White*0.7     , "Gray           ") rotate z*+90 rotate y*185 translate <4, 0, 2.2> }
      object {MakeCrayon (Sienna        , "Sienna         ") rotate z*+90 rotate y*180 translate <5.0, 0, 4> }
      object {MakeCrayon (BlueViolet*.7 , "Blue Violet    ") rotate z*+90 rotate y*-71 translate <16, -0.1, -17-01> }
      object {MakeCrayon (RedViolet*.7  , "Red Violet     ") rotate z*+90 rotate y*-55 translate <23, -0.1, -17-01+5> }
      object {MakeCrayon (Tan*0.8       , "Tan            ") rotate z*+90 rotate y*-80 translate <10-16, 0, -10> }
      // On Top of other Crayons        
      object {MakeCrayon (DustyRose     , "Dusty Rose     ") rotate z*+90 rotate y*71  translate <11.9, cra_R*2    ,-16.0> }
      object {MakeCrayon (Orange*0.8    , "Orange         ") rotate z*+90 rotate y*91  translate <14.0, cra_R*2    ,-15.2> }
      object {MakeCrayon (CadetBlue     , "Cadet Blue     ") rotate z*+90 rotate y*82  translate < 8.0, cra_R*2+0.1, -2.2> }
      object {MakeCrayon (MediumBlue    , "Medium Blue    ") rotate z*+90 rotate y*87  translate <10.0, cra_R*2+0.1, -3.2> }
      // Vertical                       
      object {MakeCrayon (BlueGreen     , "Blue Green     ") translate <12.0, -0.75, -20.2-6> }
      object {MakeCrayon (YellowGreen   , "Yellow Green   ") translate <14.0, -0.75, -22.2-6> }
      // On Crayon Box                  
      object {MakeCrayon (OldGold       , "Old Gold       ") rotate z*+90 rotate y*180 rotate x*-5 rotate y*-10 translate <+2.5*in, 10.9*in, -22*in> }
      object {MakeCrayon (DarkGreen     , "Dark Green     ") rotate z*+90 rotate y*000 rotate x*-5 rotate y*-30 translate <+8.0*in, 10.9*in, -23*in> }
      // In Drinking Glass              
      object {MakeCrayon (Red*0.6       , "Red            ") rotate z*+205 translate <21.2+(.2/.624), 8.35-0.4, 10.1> }
      // End Union
      scale 0.624*in // => S/b 5 inches long x .4" thick (inverse=1.6)
      translate adj_Crayon
   }

   // Crayon Box
   difference {
      union {
         // Generic Box
         box {1e-3 1-1e-3 pigment {color OldGold} }
         #if (Images_On=1)
            // Front Cover
            box {<0,0,0>, <1,1,0> pigment {image_map {jpeg "_Crayon1.jpg" map_type 0} } }
            // Right Cover
            box {<1,0,0>, <1,1,1> pigment {image_map {jpeg "_Crayon2.jpg" map_type 0} rotate y*-90} }
            // Top Cover
            box {<0,1,0>, <1,1,1> pigment {image_map {jpeg "_Crayon3.jpg" map_type 0} rotate x*90} }
         #end

         }   
      scale <8*in, 6.8*in, 3.5*in>
      rotate y*-50
      translate adj_Crayon
      translate <2*in, -0.45*in, -18*in>
      // finish {ambient 0.3 diffuse 0.3 reflection 0.5 phong 0.5}
      finish {ambient 0.3 diffuse 0.3 reflection 0.5 }
      normal {agate 0.1 scale 0.10 bump_size 0.03*10}
      }
   // Drawing 1 - "Dolphin" /Drawings
   height_field {jpeg "_Draw01b.jpg" smooth scale <1,0.6,1> 
         translate -0.5 rotate y*-90 translate +0.5
      #if (Images_On=1)
         pigment {image_map {jpeg "_Draw01.jpg" map_type 0} rotate x*90 rotate y*-90}
      #else
         pigment {rgb <250,250,250>/255}
      #end
      translate <-0.5,0,-0.5> scale <8.5*in, 1.28*in, 11*in> rotate y*30 
      translate adj_Crayon
      finish {ambient 0.3 diffuse 0.25 reflection 0.0}
      normal {agate 0.1 scale 0.10 bump_size 0.03}
      translate <0.9*in, -0.40*in, +1.5*in>
      }
   // Drawing 2 - "Elephant"
   height_field {jpeg "_Draw03b.jpg" smooth scale <1,0.6,1> 
      #if (Images_On=1)
         pigment {image_map {jpeg "_Draw03.jpg" map_type 0} rotate x*90 rotate y*90}
      #else
         pigment {rgb <245,224,197>/255}
      #end
      translate <-0.5,0,-0.5> scale <8.5*in, 0.08*in, 11*in> rotate y*-20 
      translate adj_Crayon
      finish {ambient 0.3 diffuse 0.25 reflection 0.0}
      normal {agate 0.1 scale 0.10 bump_size 0.03}
      translate <+6*in, -0.40*in, +4*in>
      }
   // Drawing 3 - "Tiger"
   height_field {jpeg "_Draw02b.jpg" smooth scale <1,0.6,1> 
      translate -0.5 rotate y*90 translate +.5
      #if (Images_On=1)
         pigment {image_map {jpeg "_Draw02.jpg" map_type 0} rotate x*90 rotate y*90}
      #else
         pigment {rgb <194,226,237>/255}
      #end
      translate <-0.5,0,-0.5> scale <8.5*in, 0.12*in, 11*in> rotate y*180 
         translate <-3.5*in,0,-8*in> rotate y*-15 translate <4*in,0,8*in>
      translate adj_Crayon
      finish {ambient 0.3 diffuse 0.3 reflection 0.0 }
      normal {agate 0.1 scale 0.10 bump_size 0.03}
      translate <11*in, -0.48*in, +2*in>
      }
   // Simple Drinking Glass /Glass - Borrowed from Pov Short Contest
   lathe {6, 0 u/3 u/3+v <.32,on> <.32,.5> v/2
      pigment {rgb <0.9, 0.9, 1.0> 
         #if (Images_On=1)
            filter 0.90
         #end
         } 
         scale 4*in
         translate adj_Crayon
         #if (Images_On=1)
            interior {ior 1.5}
            finish {phong 0.5 roughness 0.5}
         #end
         #if (Normals_On=1)
            normal {ripples 0.7 scale 0.375 bump_size 0.6 translate y*1000}
         #end
         photons {reflection 1 refraction 1 target}
         translate <14.7*in, -0.30*in, +6.5*in>
      }
#end

// ************************************************************************************************************************
// Guitar in Corner of Room /Guitar
// ************************************************************************************************************************
/*
#if (Toys_On=1)
   #ifndef (My_Guitar)
      #include "_Guitar.INC"
      // #include "_Guitar_202.INC"
      object {My_Guitar 
         scale 38 
         rotate x*-90
         rotate x*12 rotate z*1
         rotate y*-32
         translate x*6*in
         translate z*(Room_Deep-(5*in) )
            // translate z*-10*in // For Side View
         }
   #end
#end
*/

// ************************************************************************************************************************
// Board Game /Stratego /Board /Game
// ************************************************************************************************************************
/*
#if (Toys_On=1)
   #ifndef (My_Game)
      #declare Jitter_Pieces=1 ;
      #include "_Board.inc"
      object {My_Game 
         scale 1.5
         translate <x_Board, y_Board, z_Board> 
         translate y*-0.2*in // Lower to Floor
         }
   #end
#end
*/    

// ************************************************************************************************************************
// Floor (Plane or Manually-Placed Tiles) /Floor
// ************************************************************************************************************************
#include "_floor.inc"

// ************************************************************************************************************************
