// A Board Game (Stratego)
//    Created 10/2004 by James Coons for "Toys and Games" IRTC.
//
// Board Game Overhead: 88 Objects, 31793 Tokens (as of 10/18/2004)
//
// Requirements: 
//    #declare Images_On =0/1; 

#ifndef (Black)
   // #include "gm_04_61_07.pov" // Main Environment Scene
   stop // Run from GM File instead
#end
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"

// Declare Default Quality Settings
#ifndef (Images_On)     #declare Images_On    = 1 ; #end // 0=Pigments, 1=Image_Maps
#ifndef (Jitter_Pieces) #declare Jitter_Pieces= 1 ; #end // 0=Straight, 1=Randomized

#declare g_Ambient = 0.05 ;

// ----------------------------------------------------------------------
// 1. Board /Board
// ----------------------------------------------------------------------
#declare w_Board  = 12.0*in            ;  // Wide
#declare h_Board  =  0.2*in            ;  // High
#declare d_Board  = 12.0*in            ;  // Deep
#declare x_Board  = 2*ft               ;  // X Translate
#declare y_Board  = 0.2*in             ;  // Y Translate
#declare z_Board  = Room_Deep - 21*in  ;  // Z Translate (Room_Deep/2)

#declare tex_Board =
   texture {
      #if (Images_On=1)
         pigment {image_map {jpeg "_Game01.jpg" map_type 0} rotate x*90}
      #else
         pigment {color White*0.4}
      #end
      // Perhaps add some minor Normals to the board for realism?
      finish {ambient g_Ambient 
         diffuse 0.2 // 0.3
         // phong 0.05
         // phong 1.0
         reflection 0.15
         // reflection 0.5
         }
      }
#declare obj_Board = 
   box { <0,0,0>, <1,1,1> 
      texture {tex_Board} 
      scale <w_Board, h_Board, d_Board>
      }

#declare tex_Piece_Red  = 
   texture {pigment {Red/2 filter 0.7}  
      finish {ambient 0.1 diffuse 0.3 specular 0.25 roughness 0.003}
      // finish {ambient 0.4 reflection 0.02}
      normal {agate 0.02 scale 0.001}
      //finish {ambient 0.3 diffuse 0.3 reflection 0.1 
      //phong 1.0 // Try
      }
#declare tex_Piece_Blue = 
   texture {pigment {Blue/2 filter 0.7} 
      finish {ambient 0.1 diffuse 0.3 specular 0.25 roughness 0.003}
      // finish {ambient 0.4 reflection 0.02}
      normal {agate 0.02 scale 0.001}
      // finish {ambient 0.3 diffuse 0.3 
      // reflection 0.1 // Try removing - get plastic look
      //phong 1.0 // Try
      }

#declare R = 0.10*in ;
#declare H = 1.20*in ;
#declare obj_Piece = 
   merge {
      // Main Rectangle Shape
      box {<0,0,0> <1,1,1> scale <0.8*in, H, R*0.9> translate z*R*0.9/2 }
      // Left Tower
      cylinder {<0+R/2, 0, 0.1*in> <0+R/2, H*1.10, 0.1*in>, R }
      // Right Tower
      cylinder {<0.8-R/2, 0, 0.1*in> <0.8-R/2, H*1.10, 0.1*in>, R }
      }

// #declare Stickers = pigment {image_map {jpeg "_game10.jpg" map_type 0} scale <12*in, 5*in, 0.1*in> }

#declare rnd_Piece    = seed(15)       ; // Random Numbers (Piece Adjustment)
#declare obj_Pieces   =
   union {
      #declare x_Min  = 0.1*in         ;
      #declare x_Max  = w_Board-0.1*in ;
      #declare x_Step = 11.8*in/10     ;
      #declare z_Min  = 0.1*in         ;
      #declare z_Max  = d_Board-0.1*in ;  
      #declare z_Step = 11.8*in/10     ;
      #declare y_Pos  = 0.1*in         ;        // Float on Board Surface
      // Outer x_Pos Loop
      #declare x_Pos  = x_Min          ;        // Start x
      #while (x_Pos < x_Max)                    // ... Until X done
         // Inner z_Pos Loop
         #declare z_Pos = z_Min;                // Start z
         #while (z_Pos < z_Max)                 // ... Until Z done
            #declare Draw_Piece=0 ;

            // Decide which rows get pieces and which colors
            #declare Draw_Texture=texture{} ;
            #switch (1)
               #case (x_Pos > 11.8*in)
                  #declare Draw_Piece=0 ;    
                  #break
               #case (z_Pos > 11.8*in)
                  #declare Draw_Piece=0 ;    
                  #break
               #case (z_Pos > 7.0*in)
                  #declare Draw_Piece=1 ;    
                  #declare Draw_Texture=tex_Piece_Blue
                  #break
               #case (z_Pos < 4.0*in)
                  #declare Draw_Piece=1 ;    
                  #declare Draw_Texture=tex_Piece_Red
                  #break
            #end
   
            #if (Draw_Piece=1)
               union {
                  object {obj_Piece texture {Draw_Texture} }
/*
                  // sticker object 
                  box {0 1
                     scale <0.5,H*0.85,0.01> translate x*0.15 translate y*0.1 translate z*0.03
                     pigment {Stickers
                        //translate -x_Pos*x_Step*1.05                     // X Spacing of Piece in Source Image
                        //translate -z_Pos*z_Step                      // Z Spacing of Piece in Source Image
                        }
                     }
*/
/*
                     // pigment {image_map {jpeg "_piece01.jpg" map_type 0} }
                     pigment {image_map {jpeg "_game10.jpg" map_type 0} 
                        // scale 640/100*1.1 
                        scale 12*in *0.9 *0.75                    // Width of Board
                        }
                     // <0.1,0.1,0> <0.9,0.9,1> scale <0.8*in, H, R*0.9> // translate z*R*0.9/2 
                     // pigment {White*0.7} 
                     finish {ambient 0.3 diffuse 0.3}
                     }
*/
                  // Randomly Adjust Pieces
                  #if (Jitter_Pieces=1)
                     translate -0.5
                        rotate    y*rand(rnd_Piece)*10-5
                        translate x*rand(rnd_Piece)*0.3*in-0.15*in
                        translate z*rand(rnd_Piece)*0.3*in-0.15*in
                     translate +0.5
                  #else
                     translate x*-0.2*in
                  #end
                  translate <x_Pos, y_Pos, z_Pos> 
                  // Center Within Grid
                  translate <0.2*in, 0, 0.3*in>
                  }
            #end
         
            #declare z_Pos = z_Pos + z_Step;    // Next z_Pos
         #end
         #declare x_Pos = x_Pos + x_Step;       // Next x_Pos
      #end
      }
      
// Combine all objects to form the final Board Game
#declare My_Game = 
   union {
      object {obj_Board}
      object {obj_Pieces translate <0.2, 0.2, 0.1> }
      }
      
// End of File // 
