// A Simple Acoustic Guitar
// Original version by luisvaloyes, Bogota, Colombia
//    www.luisvaloyes.uni.cc
//    Scale is 1 POV unit = 10cm
//
// Modified 10/2004 by James Coons for "Toys and Games" IRTC.
//    1. Strings stop at top and do not go through to tuning pegs.
//    2. Add visible Support Brackets within body.
//    3. Bridge_Object needs checked in closeup - too "blocky".
//    4. Head is too "sharp" - should be more rounded. 
//    5. Check side view - verify Body thickness. 
//    6. Add Brown Swirly Pick Guard to Guitar.
//    7. Frets should go to ends of fret/neck instead of being same size.
//    8. Body is not really hollow.
//    9. Add Silver Position Markers to Fret Board.
//    10. Rework body to correct "wierd" shape.
//    11. Strings should be the same distance above the Fret Board.

// DONE
//    Split Guitar Head and Tuning Peg Objects.
//    Split Tuning Pegs and Head Objects.
//    Improved textures on Head (Real Wood, Self-Normals).
//    Improved textures on Tuning Pegs (Silver).
//    Improved textures on Frets (Silver).
//    Improved textures on Fret board (Dark Wood).
//    Improved textures on Body (Real Wood, Self-Normals).
//    Centered Strings within Nut instead of going clear to edge. 
//    Thickened B and E strings to keep from them disappearing.
//    Added Rose around Sound Hole.
//    Modified Rose to Fit better and made it more round.
// 10/24 Tweaked Guitar Rose.
//
// Guitar Overhead: 68 Objects, 17123 Tokens (as of 10/18/2004)
//
// Requirements: 
//    #declare Photons_On=0/1; 
//    #declare Images_On =0/1; 
//    #declare Normals_On=0/1; 

#ifndef (Black)
   #include "gm_04_60_57.pov" // Main Environment Scene
#end
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"

// Declare Default Quality Settings
#ifndef (Images_On)  #declare Images_On  = 1 ; #end // 0=Pigments, 1=Image_Maps
#ifndef (Normals_On) #declare Normals_On = 1 ; #end // 0=None    , 1=Normals
#ifndef (Photons_On) #declare Photons_On = 0 ; #end // 0=None    , 1=Photons

#declare g_Ambient = 0.05 ;

// Parts of the Guitar (Top to Bottom)
//    1. Head              obj_Head (Real Wood, Self-Normal)   CABEZA
//    2, Tuning Pegs (6)   obj_Pegs (Silver)                   CLAVIJA
//    3. Nut               obj_Nut (strings pass over)         CEJILLA
//    4. Strings           obj_Strings (Bronze and Silver)     -
//    5. Frets             obj_Frets (Silver)                  -
//    6. Neck              obj_Neck (Dark Wood)                MASTIL
//    7. Rose              obj_Rose (Image)                    ROSETA                                       
//                            (design around sound hole)              
//    8. Body              obj_Body (Sound Board)              -
//    9. Sound Hole        -                                   -
//
//    x. Finger Board (front of Neck) COMBINED WITH FRETS?     -
//    x. Bridge                                                PUENTE
//    x. Hollow Body                                           -
//    x. Heel (supports neck and connects to Body)             TALON
//    x. Rib (Side of Body)                                    REBORDE
//    x. Pick Guard        Not included                        -
//    x. Position Marker   Not included                        MARCA DE POSICION
//    x. Purfling          Not included                        FILETE 
//                            (design around outer edge of Body)

// ----------------------------------------------------------------------
// 1. Head /Head
// ----------------------------------------------------------------------
#declare tex_Head = 
   texture {
      #if (Images_On=1)
         pigment {image_map {jpeg "_Guitar1.jpg" map_type 0}
            rotate <-100,180,0> translate y*0.12 
            scale 3.2 rotate z*30 rotate <95,45,15> 
            }
      #else
         pigment {color rgb <77,39,15>/255}
      #end
      finish {ambient g_Ambient phong .5/10 reflection .0075*25} 
      #if (Normals_On=1)
         normal {bump_map {jpeg "_Guitar2.jpg" bump_size 0.3}
            rotate <-100,180,0> translate y*0.12 
            scale 3.2 rotate z*30 rotate <95,45,15> 
            accuracy 1e-9}
      #end      
      }
#declare obj_Head = 
   union {
      difference {
         box { <-0.5,0,-0.5> <0.5,2,0.5> scale <0.7,1,0.3>}
         union {
            cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.1,5,0.35> rotate <90,0,0> translate <0.35,0,-0.25>}
            cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.1,5,0.35> rotate <90,0,0> translate <-0.35,0,-0.25>}
            }
         }
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.25,0.3,0.175> rotate <-90,0,0> translate <0,2,0.15>} 
         texture {tex_Head}
      rotate <-100,180,0>
      }

// ----------------------------------------------------------------------
// 2. Tuning Pegs (6) /Pegs /Tuning_Pegs
// ----------------------------------------------------------------------
#declare tex_Pegs =
   texture {
      #if (Images_On=1)
         pigment {color (Silver+Brass)/2 } 
         finish {ambient g_Ambient reflection 0.5 specular 0.5 metallic}
      #else
         pigment {color (Silver+Brass)/2 }  
         finish {ambient g_Ambient reflection 0.5 specular 0.5}
      #end
      #if (Normals_On=1)
         normal {bumps scale 0.002 bump_size 0.25}
      #end      
      }
#declare obj_Pegs =
   union { 
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <90,0,0> translate <0.225,1.5,0.125>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <90,0,0> translate <-0.225,1.5,0.125>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <90,0,0> translate <0.225,1.0,0.125>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <90,0,0> translate <-0.225,1.0,0.125>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <90,0,0> translate <0.225,0.5,0.125>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <90,0,0> translate <-0.225,0.5,0.125>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.025,0.3,0.025> rotate <-90,0,0> translate <0.4,1.5,0.1>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.025,0.3,0.025> rotate <-90,0,0> translate <-0.4,1.5,0.1>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.025,0.3,0.025> rotate <-90,0,0> translate <0.4,1.0,0.1>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.025,0.3,0.025> rotate <-90,0,0> translate <-0.4,1.0,0.1>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.025,0.3,0.025> rotate <-90,0,0> translate <0.4,0.5,0.1>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.025,0.3,0.025> rotate <-90,0,0> translate <-0.4,0.5,0.1>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <-90,0,0> translate <0.4,1.5,0.1>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <-90,0,0> translate <-0.4,1.5,0.1>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <-90,0,0> translate <0.4,1.0,0.1>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <-90,0,0> translate <-0.4,1.0,0.1>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <-90,0,0> translate <0.4,0.5,0.1>}
      cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.05,0.1,0.05> rotate <-90,0,0> translate <-0.4,0.5,0.1>}
      sphere { <0,0,0>,1.0 scale <0.04,0.1,0.112> rotate <0,0,10> translate <0.4,1.5,-0.25>}
      sphere { <0,0,0>,1.0 scale <0.04,0.1,0.112> rotate <0,0,-110> translate <-0.4,1.5,-0.25>}
      sphere { <0,0,0>,1.0 scale <0.04,0.1,0.112> rotate <0,0,60> translate <0.4,1.0,-0.25>}
      sphere { <0,0,0>,1.0 scale <0.04,0.1,0.112> rotate <0,0,-40> translate <-0.4,1.0,-0.25>}
      sphere { <0,0,0>,1.0 scale <0.04,0.1,0.112> rotate <0,0,140> translate <0.4,0.5,-0.25>}
      sphere { <0,0,0>,1.0 scale <0.04,0.1,0.112> rotate <0,0,-130> translate <-0.4,0.5,-0.25>}
   texture {tex_Pegs}
   rotate <-100,180,0>
   }

// ----------------------------------------------------------------------
// 3. Nut /Nut
// ----------------------------------------------------------------------
#declare tex_Nut = texture {pigment {White} finish {ambient g_Ambient diffuse 0.2 reflection 0.2 phong 0.1 phong_size 100} }
#declare obj_Nut =
   // cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.075*0.85,0.50,0.075*0.85> rotate <0,0,90> translate <0,5,0>
   cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.08,0.499,0.08> rotate <0,0,90> translate <0,5,0>  
      texture {T_Brass_1A finish {ambient g_Ambient metallic reflection .125} } 
   texture {tex_Nut}
   }

// ----------------------------------------------------------------------
// 4. Strings (6) /Strings
// ----------------------------------------------------------------------
#declare tex_Brass_Strings = // Thicker "Brass" Strings
   #if (Images_On=1)
      texture {pigment {color (Brass*2+Silver)/3} finish {ambient g_Ambient diffuse 0.1 metallic 
         reflection .125*2 
         phong 0.8
         } }
   #else
      texture {pigment {color (Brass*2+Silver)/3} finish {ambient g_Ambient diffuse 0.1 metallic 
         reflection .125*2 
         phong 0.8
         } }
   #end
#declare tex_Silver_Strings = // Thinner "Silver" Strings
   #if (Images_On=1)
      texture {pigment {Silver} finish {ambient g_Ambient diffuse 0.1 metallic reflection .125*5 
         phong 0.9 // phong_size 0.8
         } }
   #else
      texture {pigment {Silver} finish {ambient g_Ambient diffuse 0.1 metallic reflection .125*5 
         phong 0.9 // phong_size 0.8
         } }  
   #end
#declare obj_Strings = 
   #declare T1 = 0.01000 ; // String 1 Thickness - E (Mi)
   #declare T2 = 0.00875 ; // String 2 Thickness - A (La)
   #declare T3 = 0.00750 ; // String 3 Thickness - D (Re)
   #declare T4 = 0.00750 ; // String 4 Thickness - G (Sol)
   #declare T5 = 0.00400 ; // String 5 Thickness - B (Ti)
   #declare T6 = 0.00350 ; // String 5 Thickness - E (Mi)
   #declare TA = .012    ; // Fret Adjustment to Center Strings withing Fret instead of going clear to edge.
   union {
      union {
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <T1 ,6.75, T1> rotate <90,0,0> translate <-0.2450+(TA*+3),0,T1>}  // E (Mi)
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <T2 ,6.75, T2> rotate <90,0,0> translate <-0.1475+(TA*+2),0,T2>}  // A (La)
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <T3 ,6.75, T3> rotate <90,0,0> translate <-0.0495+(TA*+1),0,T3>}  // D (Re)
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <T4 ,6.75, T4> rotate <90,0,0> translate <+0.0495+(TA*-1),0,T4>}  // G (Sol)
         texture {tex_Brass_Strings}
         }
      union {                                                     
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <T5, 6.75, T5> rotate <90,0,0> translate <+0.1475+(TA*-2),0,T5>}  // B (Ti)
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <T6, 6.75, T6> rotate <90,0,0> translate <+0.2450+(TA*-3),0,T6>}  // E (Mi)
         texture {tex_Silver_Strings}
         }
      }

// ----------------------------------------------------------------------
// 5. Frets (24) /Frets
// ----------------------------------------------------------------------
#declare tex_Frets =
   #if (Images_On=1)
      texture {pigment {Silver} finish {ambient g_Ambient diffuse 0.1 metallic reflection .125*5 phong 1.0 phong_size 100} }
   #else
      texture {pigment {Silver} finish {ambient g_Ambient diffuse 0.1 reflection 0} }  
   #end
#declare obj_Frets =
   union { 
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.68,0.02> rotate <0,0,90> translate <0,0.075,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.66,0.02> rotate <0,0,90> translate <0,0.175,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.65,0.02> rotate <0,0,90> translate <0,0.3,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.64,0.02> rotate <0,0,90> translate <0,0.425,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.63,0.02> rotate <0,0,90> translate <0,0.55,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.62,0.02> rotate <0,0,90> translate <0,0.7,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.61,0.02> rotate <0,0,90> translate <0,0.85,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.60,0.02> rotate <0,0,90> translate <0,1,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.60,0.02> rotate <0,0,90> translate <0,1.15,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.59,0.02> rotate <0,0,90> translate <0,1.3,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.59,0.02> rotate <0,0,90> translate <0,1.45,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.58,0.02> rotate <0,0,90> translate <0,1.625,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.58,0.02> rotate <0,0,90> translate <0,1.8,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.57,0.02> rotate <0,0,90> translate <0,1.975,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.57,0.02> rotate <0,0,90> translate <0,2.175,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.56,0.02> rotate <0,0,90> translate <0,2.375,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.56,0.02> rotate <0,0,90> translate <0,2.6,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.55,0.02> rotate <0,0,90> translate <0,2.825,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.55,0.02> rotate <0,0,90> translate <0,3.075,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.54,0.02> rotate <0,0,90> translate <0,3.325,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.53,0.02> rotate <0,0,90> translate <0,3.575,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.52,0.02> rotate <0,0,90> translate <0,3.9,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.51,0.02> rotate <0,0,90> translate <0,4.25,0>}
      cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.02,0.50,0.02> rotate <0,0,90> translate <0,4.65,0>}
      texture {tex_Frets}
      }

// ----------------------------------------------------------------------
// 6. Neck /Neck
// ----------------------------------------------------------------------
#declare tex_Neck =
   texture {
      #if (Images_On=1)
         T_Wood2 scale 2 rotate x*90 rotate y*45
         // finish {ambient g_Ambient phong .5 reflection .0075} 
      #else
         pigment {color (Brown+Black)/2} 
         // finish {ambient g_Ambient reflection .0075}  
      #end
      finish {ambient g_Ambient phong .3 reflection .0075} 
      }
#declare obj_Neck =
   difference {
      cone { <0,0,0>,  0.35, <0,5,0>, 0.25 scale <1,1,1.25> }
      box { <-0.5,-0.5,-0.5> <0.5,0.5,0.5> scale <2,11,1> translate <0,0,-0.5>} 
      texture {tex_Neck}
      }

// ----------------------------------------------------------------------
// 7. Rose /Rose (around Sound Hole)
// ----------------------------------------------------------------------
#declare tex_Rose =
   texture {
      #if (Images_On=1)
         pigment {image_map {jpeg "_Rose.jpg" map_type 0} 
            translate <0.5,0.5,0>
            scale 1.485
            rotate x*90 
            translate <0, 0.05, 2.25> }
         finish {ambient g_Ambient diffuse 0.3 reflection 0.15 phong 0.2}
      #else
         pigment {color (Brown+Black)/3} 
         finish {ambient g_Ambient reflection 0.15}  
      #end
      }
#declare obj_Rose =
   cylinder { <0,0,0>,<0,1,0>,1.0 
      scale <0.75*0.95, 1.2, 0.75*0.95>
      translate <0, 0.05, 2.25> 
      translate y*-0.1 
      translate y*-0.13
      texture {tex_Rose}
      }     
      
// ----------------------------------------------------------------------
// 8. Body /Body (Sound Board)
// ----------------------------------------------------------------------
   // // look inside sound hole (debugging), because the body is not really hollow.
   //   light_source {<24*in,2*ft,Room_Deep-30*in> color White}
#declare tex_Body = 
   texture {
      #if (Images_On=1)
         pigment {image_map {jpeg "_Guitar3.jpg" map_type 0}
            rotate <-100,180,0> translate y*0.12 
            scale 3.2/2 rotate z*30 rotate <95,45,0> }
         finish {ambient g_Ambient 
            reflection 0.2
            diffuse 0.2
            specular 0.02
            phong 0.25 
            reflection 0.035
            } 
      #else
         pigment {color (Brown+Black)/2} 
         finish {ambient g_Ambient reflection 0}
      #end
      finish {ambient g_Ambient reflection 0}
      /*
      normal {bump_map {jpeg "_Guitar3.jpg" bump_size 0.5}
         rotate <-100,180,0> translate y*0.12 
         scale 3.2/2 rotate z*30 rotate <95,45,0>  
         accuracy 2.0
         }
      */
      }
#declare obj_Body = 
   difference {
      union {
         // "Shoulders" of Body
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <1,1,0.075> translate <0,0,4>}
         // Upper "Lobes" of Body
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.4,1,0.75> translate <1,0,3.25>}
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.4,1,0.75> translate <-1,0,3.25>}
         // Lower "Lobes" of Body
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.9,1,1.125> translate <0.9,0,1.125>}
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.9,1,1.125> translate <-0.9,0,1.125>}
         // Remainder of Body
         box { <-0.5,0,-0.5> <0.5,1,0.5> scale <2,1,4> translate <0,0,2>}
         // Rose around Sound Hole
         object {obj_Rose}
         // Cut-Out "Waist" of Body
         difference { 
            union {
               box { <-0.5,0,-0.5> <0.5,1,0.5> scale <0.7,1,1> translate <1,0,2.4>}
               box { <-0.5,0,-0.5> <0.5,1,0.5> scale <0.7,1,1> translate <-1,0,2.4>} }
            union { 
               cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.55,2,0.65> translate <1.75,-0.5,2.475>}
               cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.55,2,0.65> translate <-1.75,-0.5,2.475>} }
            }
         }
         // Cut-Out Sound Hole (#9)
         cylinder { <0,0,0>,<0,1,0>,1.0 open scale <0.5,1.2,0.5> translate <0,0.05,2.25> } 
         texture {tex_Body}
      }

// ----------------------------------------------------------------------
// Front of Guitar Neck
#declare t_Bridge = 
   #if (Images_On=1)
      texture {T_Wood2 finish {ambient g_Ambient phong .5 reflection .0075} scale 2 rotate x*90 rotate y*45}
   #else
      texture {
         pigment {bozo color_map {[0.0 rgb <.3,.2,.1>][0.7 rgb <.35,.25,.15>]} }
         finish {ambient g_Ambient reflection 0} }
   #end
   // texture { pigment {bozo color_map {[0.0 rgb <.3,.2,.1>][0.7 rgb <.35,.25,.15>]}
   // scale 0.125} finish {phong .5 reflection .0075}}

// Fret_Board_And_Frets
#declare t_Fret_Board_And_Frets = 
   #if (Images_On=1)
      texture {pigment {Silver/2} 
         finish {ambient g_Ambient metallic reflection .0075} }
   #else
      texture {pigment {Silver} 
      finish {ambient g_Ambient reflection .0075} }
   #end

#declare Bridge_Object = 
   union { 
      box { <-0.5,0,-0.5> <0.5,1,0.5> scale <1.25,0.1,0.3>}
      box { <-0.5,0,-0.5> <0.5,1,0.5> scale <1.25,0.1,0.2> translate <0,0.1,-0.05>} 
      }

// Fret Board
#declare t_Fret_Board = // /Fret Board /Fret_Board
   #if (Images_On=1)
      texture {T_Wood2 finish {phong .35 reflection .0075} scale 2 rotate x*90}
   #else
      texture {pigment {color (Brown+Black)/2} finish {ambient g_Ambient reflection .0075} }
   #end

#declare Fret_Board_And_Frets = 
   union { 
      object {obj_Neck}
      object {obj_Nut}
      object {obj_Frets}

      /*
      union {
         sphere { <0,0,0>,1.0 scale <0.25,1,0.25> translate <0,1,0.3>}
         cylinder { <0,0,0>,<0,1,0>,1.0 scale <0.3,0.9,0.2> rotate <90,0,0> translate <0,1,0.225> } 
         texture {t_Bridge}
         }
      */
      
      // cylinder { <0,-0.5,0>,<0,0.5,0>,1.0 scale <0.075,0.50,0.075> rotate <0,0,90> translate <0,5,0> 
      //    texture {T_Brass_1A finish {ambient g_Ambient metallic reflection .125} } }
      rotate <90,0,0>
      }

// Combine all objects to form the final Guitar.
#declare Guitar_Object = 
   union {
      object {obj_Head translate <0,1.0,8>}                 // OK
      object {obj_Pegs translate <0,1.0,8>}                 // OK
      object {obj_Strings translate <0,1.15,1.25>}          // OK
      object {obj_Body}                                     // OK
      object {Fret_Board_And_Frets translate <0,1.1,3>}     // ?
      object {Bridge_Object translate <0,1,1.25>}           // OK
      // rotate z*-90 
      }

#declare My_Guitar = 
   object {Guitar_Object scale 0.1
   scale <0.9,1,1> // Corrects "Oblong" Body Shape
   // Photons don't have much of an effect
   #if (Photons_On=1)
      photons{target 1.0 reflection on} 
   #end
   }

/*
object {My_Guitar 
   scale 38 
   rotate x*-90
   rotate x*10
      rotate x*2 rotate z*2 // Lean Head into corner
   rotate y*-45
      rotate y*8 // Fix too-bright reflection by rotation
   translate x*5*in
      translate x*1*in
   translate z*(Room_Deep-(5*in) )
      translate z*-1*in
   //translate y*(1*in)
      //translate y*-1*in
   }
*/
