// ************************************************************************************************
// *** Init POV Measures: 1 POV Unit = 1 Inch
// ************************************************************************************************
#declare inch =  1; #declare inches =  1; #declare in =  1;
#declare foot = 12; #declare feet   = 12; #declare ft = 12;
#declare Room_Wide = 20*ft;
#declare Room_High = 10*ft;
#declare Room_Deep = 15*ft;

// Basic INCLUDE to Set Environment based on User Settings
#include "Grid.INC"
#declare Room_Brightness= 0.7 ;  // Room Brightness Multiplier

// ************************************************************************************************************************
// *** Photon Settings - Doesn't seem to affect scene very much
// ************************************************************************************************************************
#if (Photons_On=1)
   global_settings {
      photons {
         // spacing 0.01              // specify the density of photons
         spacing 0.05
         //count 100000               // alternatively use a total number of photons
         //gather min, max            // amount of photons gathered during render [20, 100]
         //media max_steps [,factor]  // media photons
         //jitter 1.0                 // jitter phor photon rays
         //max_trace_level 5          // optional separate max_trace_level
         //adc_bailout 1/255          // see global adc_bailout
         //save_file "filename"       // save photons to file
         //load_file "filename"       // load photons from file
         //autostop 0                 // photon autostop option
         //radius 10                  // manually specified search radius
         // (---Adaptive Search Radius---)
         //steps 1
         //expand_thresholds 0.2, 40
      }
   }
#end

// ************************************************************************************************************************
// *** Global Radiosity Settings - Doesn't seem to affect scene very much
// ************************************************************************************************************************
#if (Radiosity_On=1)
   global_settings {
      radiosity {
         pretrace_start 0.16           // start pretrace at this size
         pretrace_end   0.08           // end pretrace at this size
         count 35                      // higher -> higher quality (1..1600) [35]
         nearest_count 5               // higher -> higher quality (1..10) [5]
         error_bound 1.8               // higher -> smoother, less accurate [1.8]
         // recursion_limit 3          // how much interreflections are calculated (1..5+) [3]
         recursion_limit 1             // how much interreflections are calculated (1..5+) [3]
         low_error_factor .5           // reduce error_bound during last pretrace step
         gray_threshold 0.0            // increase for weakening colors (0..1) [0]
         minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
         brightness 1.0                // brightness of radiosity effects (0..1) [1]
         adc_bailout 0.01/2
         // normal on                  // take surface normals into account [off]
         // media on                   // take media into account [off]
         // save_file "GM"             // save radiosity data
         // load_file "file_name"      // load saved radiosity data
         always_sample on              // turn sampling in final trace off [on]
         max_sample 1.0                // maximum brightness of samples
      }
   }
#end

