#declare Ball =
difference{
	//Ball Itself
	sphere{
		<0, 0, 0>
		1
	}
	//Holes
	cylinder{
		<0, 0, 0>
		<0, 0, -3>
		0.085
		rotate<0, 0, 0>
	}
	cylinder{
		<0, 0, 0>
		<0, 0, -3>
		0.085
		rotate<30, 0, 20>
	}
	cylinder{
		<0, 0, 0>
		<0, 0, -3>
		0.085
		rotate<30, 0, -20>
	}
	texture{
		uv_mapping
		pigment{
			granite
			color_map{
				[0.00 rgbt <0, 0, 0.25> ]
				[0.20 rgbt <0, 0, 0.05> ]
				[0.40 rgbt <0, 0, 0.25> ]
				[0.60 rgbt <0, 0, 0.40> ]
				[0.80 rgbt <0, 0, 0.05> ]
				[1.00 rgbt <0, 0, 0.30> ]
			}
			turbulence 0.39
			scale 0.25
			rotate<10, 45, 10>
			translate<1, 5, 9>
		}
		finish{
			specular 1
			roughness 0.0005
		}
	}
	scale 0.80
}

#declare Pin =
lathe{
//sor{
//	quadratic_spline
	cubic_spline
//	linear_spline
	9
	<0.000, 0.000>
	<0.000, 0.000>
	<0.005, 0.000>
	//<0.050, 0.002>	
	<0.275, 0.045>  //Old Val 0.005
	<0.450, 1.000>
	<0.200, 2.000>
	<0.300, 2.765>
	<0.000, 2.900>
	<0.200, 2.200>
	sturm
	texture{ 
		pigment{ color rgb <0.80, 0.80, 1.00> }
		/*
		normal{
			marble 0.15
			slope_map{
				[0.00 <1, 1> ]
				[0.45 <1, 1> ]
				[0.50 <0, 1> ]
				[0.50 <0, 1> ]
				[0.55 <1, 1> ]
				[1.00 <1, 1> ]
			}
			no_bump_scale
			turbulence 0.15
			rotate<45, 0, 45>
			scale 0.25
			frequency 0.05
		}
*/
	}
	texture{
		pigment{
			planar
			color_map{
				[0.000 color rgbt <0, 0, 0, 1>]
				[0.250 color rgbt <0, 0, 0, 1>]
				[0.250 color rgbt<1, 0, 0, 0>]
				[0.325 color rgbt<1, 0, 0, 0>]
				[0.325 color rgbt<0, 0, 0, 1>]
				[0.400 color rgbt<0, 0, 0, 1>]
				[0.400 color rgbt<1, 0, 0, 0>]
				[0.475 color rgbt<1, 0, 0, 0>]
				[0.475 color rgbt<0, 0, 0, 1>]
				[1.000 color rgbt<0, 0, 0, 1>]
			}
		}
		scale<1, 1.25, 1>
		translate<0, 2.8, 0>
	}
	scale<1, 1.15, 1>
}

#declare Wood = 
texture{
	pigment{
		wood
		color_map{
			[0.00 rgb <1.00, 0.45, 0>]
			[0.10 rgb <1.00, 0.55, 0>]
			[0.25 rgb <1.00, 0.45, 0>]
			[0.45 rgb <0.90, 0.40, 0>]
			[0.55 rgb <1.00, 0.45, 0>]
			[0.65 rgb <0.90, 0.35, 0>]
			[0.80 rgb <0.85, 0.30, 0>]
			[0.90 rgb <1.00, 0.55, 0>]
			[1.00 rgb <1.00, 0.45, 0>]	
		}
		rotate<88, 0, 89>
		turbulence 0.001
		warp { repeat x*100 offset <0,50,0> }
		warp { repeat y*1	 offset <60,0,0> }
	}
}
texture{
	pigment{
		bozo
		color_map{
			[0.00 color rgbt <0.00,0.00,0.00, 1.00>]
			[0.20 color rgbt <0.00,0.00,0.00, 0.50>]	
			[0.80 color rgbt <0.00,0.00,0.00, 0.75>]
			[1.00 color rgbt <0.00,0.00,0.00, 1.00>]
		}
		scale 50
		warp { repeat x*100 offset <0,50,0> }
		warp { repeat y*1	 offset <60,0,0> }
		
	}
}	


#declare GlossyWoodSlats =
texture{		
	brick
	texture{ 
		pigment{ color rgb<0.25, 0.15, 0> } 
		finish{
			reflection 0.10
			specular 0.15
			roughness 0.001
		}
	}
	texture{ 
		Wood 
		finish{
			reflection 0.35
			specular 0.25
			roughness 0.001
		}
		normal{ bumps 0.0225 scale 0.35 turbulence <0.19, 0.19, 0.23> }
	}
	brick_size<50, 1, 1>
	mortar 0.05
	scale<1, 1, 1>
	rotate<90, 90, 0>
	scale 0.25
}	

//Gutters
#declare Gutter =
difference{
	box{
		<-1, -2, 5>
		<1, 0, -75>
	}
	cylinder{
		<0, 0, 6>
		<0, 0, -80>
		1
	}
	pigment{ color rgb <0.25, 0.15, 0> }
	finish{
		specular 0.20
		roughness 0.02
	}
}


//LaneSeperator
#declare LaneSeperator =
prism{
	0,
	75,
	6,
	<-1.5, -2>,
	<1.5, -2>,
	<1.5, .45>,
	<0, 0.65>,
	<-1.5, .45>,
	<-1.5, -2>
	rotate<-90, 0, 0>
	//pigment{ color rgb 0.90 } 
	pigment{ color rgb 0.25 }
	finish{ specular 0.25 roughness 0.5 }
}

//Lane
#declare Lane = 
box{
	<-5, -2, -75>
	<5, 0, 5>
	texture{ GlossyWoodSlats }
}
//union{
//#declare counter = -5;
//#while(counter <= 5)
//	box{
		//<-0.5, -2, 5>
		//<0.5, 0, -75>
		//texture{ GlossyWood translate<0, 0, counter>}	
		//translate<counter, 0, 0>
	//}
	//#declare counter = counter + 1;
//#end
//}

#declare StatusLight =
cylinder{
	<0, 0, -0.01>
	<0, 0, 0.10>
	0.075
	pigment{ color rgb<1, 0, 0> }
	finish{ ambient 0.5 }
}

#declare PinHood = 
union{
	box{
		<0, -2, 0>
		<1.5, 5, 5>
		translate<-8.5, 0, 0>
	}
	box{
		<-1.5, -2, 0>
		<0, 5, 5>
		translate<8.5, 0, 0>
	}
	box{
		<-9, 5, 0>
		//<9, 10, 0.5>
		<9, 10, 5>
	}
	//Lights on Hood
	//Set Lights
	union{
		object{ StatusLight }
		object{ StatusLight translate<-0.30, 0.25, 0> }
		object{ StatusLight translate<0.30, 0.25, 0> }
		object{ StatusLight translate<0, 0.50, 0> }
		object{ StatusLight translate<-0.60, 0.50, 0> }
		object{ StatusLight translate<0.60, 0.50, 0> }
		object{ StatusLight translate<0.90, 0.75, 0> }
		object{ StatusLight translate<0.30, 0.75, 0> }
		object{ StatusLight translate<-0.30, 0.75, 0> }
		object{ StatusLight translate<-0.90, 0.75, 0> }
		translate<-4, 5.5, 0>
	}
	//Shot Numbe
	union{
		object{ StatusLight translate<-0.25, 0, 0> }
		object{ StatusLight translate<0.25, 0, 0> pigment{ color rgb <0.5, 0, 0> } finish { ambient 0.10 } } 		
		translate<5.5, 5.5, 0>
	}
	pigment{ color rgb 0 }
	finish{ reflection 0.05 specular 0.2 roughness 0.3  }
}

#declare BackWall =
box{
	<-90, 10, 0.5>
	<90, 30, 5>
	pigment{ color rgb 0.75 } 
}

#declare Ceiling =
box{
	<-90, 30, -50>
	<90, 35, 50>
	pigment{ color rgb 0.75 }
}
