#declare UseRad=true;
#declare MainRender=true;
#declare FinalRender=true;
//units are in centimeters
         
#include "rad_def.inc"         
global_settings { max_trace_level 25 
  #if(UseRad=true)
    radiosity {             // --- Settings 3 (high quality) ---
		Rad_Settings(Radiosity_OutdoorLight,off,off)
      /*pretrace_start 1
      pretrace_end   0.005
      count 400
      error_bound 0.1
      recursion_limit 1   
      save_file "cassetetek.rad"
      //always_sample off*/
    }                
  #end                   
  //ambient_light 0.5

}
#include "transforms.inc"
#include "math.inc"
#include "colors.inc"                                   
#include "woods.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
//dclaration des points du dodecaedre
#include "iso.inc"

                        
/////////////////////////////////////////////////////////////////////////dclaration des constantes
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
#declare CylRadius=0.2;                        
//rayon des boules                         
#declare SphereRadius=1.3;                                      
//rayon de la sphre dans laquelle est inscrite le dodecaedre
#declare SphereSpace=2.5;                                    
#declare MainSphereRadius=4;                        
#declare RAngle = 5;   
#declare Rnd=seed(0);                            
#declare Rnd1=seed(1);       
#declare TableSize=40;
#declare CamLoc = <70,10,-200>;//<0,  min_extent(CasseTete).y/*-myVect.y/5+20*/,40>;
                     
#declare i=0;
#declare myVect=<0,0,0>;
#while(i<20)
  #declare myVect=myVect+SphereCoordinates[i];
  #declare i=i+1;       
#end

#declare GroundY=-61.6;  
#declare r_Colonne=3*y;
/////////////////////////////////////////////////////////////////////////   sources lumineuses                     
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>*0.75    // light's color
  translate <200,50,-500>/2.5
  fade_power 4
  fade_distance vlength(<200,50,-500>)  
  shadowless
} 

light_source {
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  //spotlight               // this kind of light source
  translate <-2000, 1400, -1400> // <x y z> position of light
  //point_at <0, 0, 0>      // direction of spotlight
  //radius                 // hotspot (inner, in degrees)
  //tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  //falloff 8               // intensity falloff radius (outer, in degrees)
}
light_source {
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <200, 200, 0> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 10                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 0               // intensity falloff radius (outer, in degrees)
}
                             
// create a regular point light source
/*light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>*0    // light's color
  translate <-20, +10, -200>
  fade_power 2
  fade_distance 200
}*/
                       
                       
//backlight                       
light_source {
  0*x                     // light's position (translated below)
  color rgb <1,1,1>*1.5       // light's color
  spotlight               // this kind of light source
  translate <-47.5,2.5,69.8> // <x y z> position of light
  point_at <0,0,0>      // direction of spotlight
  radius 10                // hotspot (inner, in degrees)
  tightness 1            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
  fade_power 2.5
  fade_distance vlength(<-47.5,2.5,69.8>)
}                                                                        

///////////////////////////////////////////////////////////////////////// camera
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
#declare MainCamera = camera {
  location CamLoc+15*y  //<0.0, 16.0, 40.0>
  look_at   -5*y - 3*x
   //<0.0, 0.0,  0.0>
  right     x*1.33
  angle 17//15
}                            
#declare DomeCamera = camera {
  location CamLoc+15*y  //<0.0, 16.0, 40.0>
  look_at   CamLoc+15*y+<0,1,1>
   //<0.0, 0.0,  0.0>
  right     x*image_width/image_height  
  angle 90

}
#declare OuterCamera = camera {
  location <70,GroundY,-200>+2*y-600*z  //<0.0, 16.0, 40.0>
  look_at   CamLoc+15*y+<0,1,1>*50
   //<0.0, 0.0,  0.0>
  right     x*image_width/image_height  
  angle 45

}
#declare SecCamera = camera {
  location CamLoc  //<0.0, 16.0, 40.0>
  look_at   -15*y - 3*x
   //<0.0, 0.0,  0.0>
  right     x*image_width/image_height  
  angle 15
}                            
#declare TreeCamera = camera {
  location <-1000,1000,-1000>  //<0.0, 16.0, 40.0>
  look_at   <300,0,134>
   //<0.0, 0.0,  0.0>
  right     x*1.25 
  up y
  angle 30
}
#declare CharCamera= camera {
  location <0,50,0>  //<0.0, 16.0, 40.0>
  look_at   <10,0,-32>
   //<0.0, 0.0,  0.0>
  right     x*1.25 
  up y
  angle 15
}                            
camera { MainCamera }                                                                         
///////////////////////////////////////////////////////////////////////// macros
/////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////// 
#macro JointBalls(N,C1,C2,C3,O1,O2,O3)
       sphere {
         (SphereCoordinates[N]-SphereCoordinates[O1])*MainSphereRadius*3,1
         pigment { color White }
         }                                                                                     
       sphere {
         (SphereCoordinates[N]-SphereCoordinates[O2])*MainSphereRadius*3,1
         pigment { color Red }
         }                                                                                     
       sphere {
         (SphereCoordinates[N]-SphereCoordinates[O3])*MainSphereRadius*3,1
         pigment { color Blue }
         }                                                                                     

#end
#macro Ball_and_Joints(N,C1,C2,C3,O1,O2,O3)
        sphere { 0 SphereRadius
                 texture { BallTex rotate <360*rand(Rnd),360*rand(Rnd),360*rand(Rnd)> scale 5 translate <rand(Rnd),rand(Rnd),rand(Rnd)>*100  }
        } 
//cylinders inside the hedra 
    #if(C1>N)       
       cylinder {
         0,  (SphereCoordinates[C1]-SphereCoordinates[N])*MainSphereRadius, CylRadius
         texture { CylTex
         }                                                                                     
       }     
    #end
    #if(C2>N)
       cylinder {
         0,  (SphereCoordinates[C2]-SphereCoordinates[N])*MainSphereRadius,  CylRadius
         texture { CylTex
           }
         }   
    #end 
    #if(C3>N)                                                                                 
       cylinder {
         0,  (SphereCoordinates[C3]-SphereCoordinates[N])*MainSphereRadius,  CylRadius
         texture { CylTex
           }
         }  
    #end               
//cylinders outside the hedra                                                                            
       cylinder {
         0,  (SphereCoordinates[N]-SphereCoordinates[O1])*MainSphereRadius*3,  CylRadius
         texture { CylTexO
           }
         }                                                                                     
       cylinder {
         0,  (SphereCoordinates[N]-SphereCoordinates[O2])*MainSphereRadius*3,  CylRadius
         texture { CylTexO
           }
         }                                                                                     
       cylinder {
         0,  (SphereCoordinates[N]-SphereCoordinates[O3])*MainSphereRadius*3,  CylRadius
         texture { CylTexO
           }
         }                                                                                     

#end
/////////////////////////////////////////////////////////////////////////
#macro BallPlusJoints(N,C1,C2,C3,O1,O2,O3)
  union {
    Ball_and_Joints(N,C1,C2,C3,O1,O2,O3)
  }      
#end                
/////////////////////////////////////////////////////////////////////////
#macro BallMinusJoints(N,C1,C2,C3,O1,O2,O3)
  difference {
    Ball_and_Joints(N,C1,C2,C3,O1,O2,O3)
  }      
#end                
/////////////////////////////////////////////////////////////////////////
                                                                                


///////////////////////////////////////////////////////////////////////// textures
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
#declare P_WoodGrain7A =
pigment {
    wood
    turbulence <0.05, 0.08, 1000>
    octaves 4
    scale <0.15, .15, 1>
}

#declare P_WoodGrain7B =
pigment {
    bozo
    scale <0.01, 0.01, 100000>
}
#declare M_Wood7A = 
color_map { 
    [0.0, 0.1 color rgb <0.60, 0.35, 0.20>
              color rgb <0.80, 0.55, 0.40>]
    [0.1, 0.9 color rgb <0.80, 0.55, 0.40>
              color rgb <0.95, 0.80, 0.50>]
    [0.9, 1.0 color rgb <0.95, 0.80, 0.50>
              color rgb <0.80, 0.55, 0.40>]
}
#declare M_Wood7B = 
color_map { 
    [0.0, 0.1 color rgbt <0.90, 0.65, 0.30, 0.00>
              color rgbt <0.90, 0.65, 0.30, 0.30>]
    [0.1, 1.0 color rgbt <0.90, 0.65, 0.30, 0.30>
              color rgbt <1.00, 1.00, 1.00, 1.00> ] 
}

#declare T_Wood7   =         
    texture { pigment { P_WoodGrain7A  color_map { M_Wood7A }}} 
    texture { pigment { P_WoodGrain7B  color_map { M_Wood7B }}}

#declare M_Wood14A = 
colour_map {
    [0.00 0.10 color rgb < 0.40, 0.232, 0.115 >
               color rgb < 0.40, 0.232, 0.115 >]
    [0.10 0.90 color rgb < 0.40, 0.232, 0.115 >
               color rgb < 0.22, 0.115, 0.060 >]
    [0.90 1.0  color rgb < 0.22, 0.115, 0.060 >
               color rgb < 0.22, 0.115, 0.060 >]
}

#declare M_Wood14B = 
colour_map {
    [0.00 0.10 color rgbt < 0.70, 0.232, 0.115, 0.5 >
               color rgbt < 0.70, 0.232, 0.115, 0.7 >]
    [0.10 0.15 color rgbt < 0.70, 0.232, 0.115, 0.7 >
               color rgbt < 0.35, 0.115, 0.060, 0.9 >]
    [0.15 0.20 color rgbt < 0.70, 0.232, 0.115, 0.9 >
               color rgbt < 0.35, 0.115, 0.060, 0.7 >]
    [0.20 1.0  color rgbt < 0.35, 0.115, 0.060, 0.7 >
               color rgbt < 0.35, 0.115, 0.060, 0.5 >]
}
#declare P_WoodGrain14A =
pigment {
    wood
    colour_map { M_Wood14A }
    turbulence 0.065
    octaves 2
    scale <0.15, .15, 1>
    translate < -1 0 0 >
    rotate <-3, -3, 0>
}

#declare P_WoodGrain14B=
pigment {
    wood
    colour_map { M_Wood14B }
    turbulence <0, 0.1, 0>
    lambda 2.75
    omega 1.15
    octaves 4
    scale <5, 0.075, 1>
    rotate x*90
}
#declare T_Wood14 = 
    texture {  pigment{ P_WoodGrain14A color_map { M_Wood14A }}} 
    texture {  pigment{ P_WoodGrain14B color_map { M_Wood14B }}}



#declare BallTex = texture { T_Wood14
                 finish {       
                   phong 0.3 
                   phong_size 10
                   ambient 0.1
                   diffuse 0.7
                                    
                 }     
                 normal { bumps 0.05 scale 0.01 }
}                 
#declare CylTex =          texture { T_Wood7
                                     scale <1,0.1,1>  
                                     finish { ambient 0.1 diffuse 0.9 }
                                     
         }                                                                                     
#declare CylTexO = CylTex //         texture {pigment { color rgb <1,0,0> }}                                                                                     

#macro Tx_Table ()
  texture { 
            pigment {
              color rgb <62,151,207>/255
            }                                
finish {
    ambient 0.30
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.70
    roughness 1/60
    reflection 0.25
} 
     
  }
#end          
#macro Tx_Dessous ()
  texture {
    T_Stone2
  }
#end
             
#declare T_Colonne = texture {
    T_Stone9
    scale 2
}             

#declare F_Colonne = finish {
    phong 0.8
    phong_size 80
    reflection 0.1

}


//these are from Gilles Tran's exgrass2.pov, shipped with the maketree macro
#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
#declare Green1=rgb<0.4,1,0.3>*0.4;
#declare Green2=rgb<60,160,8>/255;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare P_Spotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare P_Earth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare P_Green=pigment{Green2*1.3}
//#declare P_Spotted=pigment{Red}
//#declare P_Earth=pigment{Blue}
#declare T_Grass=texture {                  
    pigment {
        gradient y
        turbulence 0.2
        pigment_map {                                
            [0.0 P_Earth]
            [0.3 P_Green]
            [0.9 P_Spotted]
            [1.00 P_Earth]
        }
    }

    finish{ambient 0.01 diffuse 0.7 specular 0.2 roughness 0.015}
    scale <0.001,1,0.001>
 
} 

///////////////////////////////////////////////////////////////////////// dclarations d'objets
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
#declare _lego_RotateRightLeg=-45;
#declare _lego_RotateLeftLeg=+30;
#declare _lego_RotateHead=60;
#declare _lego_RotateLeftHand=0;
#declare _lego_RotateRightHand=0;
#declare _lego_RotateLeftArm=80;
#declare _lego_RotateRightArm=80;
#include "lego.inc"


#declare CasseTete=union
{
object { BallPlusJoints(0,1,11,14,4,17,19) 
         rotate vnormalize(SphereCoordinates[1]+SphereCoordinates[11]+SphereCoordinates[14]-3*SphereCoordinates[0])*RAngle
         translate SphereCoordinates[0]*MainSphereRadius } 
object { BallPlusJoints(1,0,11,14,2,8,5)  
         rotate vnormalize(SphereCoordinates[0]+SphereCoordinates[11]+SphereCoordinates[14]-3*SphereCoordinates[1])*RAngle
         translate SphereCoordinates[1]*MainSphereRadius }                                                      
object { BallPlusJoints(2,6,12,17,1,3,10)  
         rotate vnormalize(SphereCoordinates[6]+SphereCoordinates[12]+SphereCoordinates[17]-3*SphereCoordinates[2])*RAngle
         translate SphereCoordinates[2]*MainSphereRadius }                                                      
object { BallPlusJoints(3,8,13,19,2,4,18)  
         rotate vnormalize(SphereCoordinates[8]+SphereCoordinates[13]+SphereCoordinates[19]-3*SphereCoordinates[3])*RAngle
         translate SphereCoordinates[3]*MainSphereRadius }                                                      
object { BallPlusJoints(4,7,10,16,3,0,5) 
         rotate vnormalize(SphereCoordinates[7]+SphereCoordinates[10]+SphereCoordinates[16]-3*SphereCoordinates[4])*RAngle
         translate SphereCoordinates[4]*MainSphereRadius } 
object { BallPlusJoints(5,9,15,18,4,1,6)  
         rotate vnormalize(SphereCoordinates[9]+SphereCoordinates[15]+SphereCoordinates[18]-3*SphereCoordinates[5])*RAngle
         translate SphereCoordinates[5]*MainSphereRadius }                                                      
object { BallPlusJoints(6,2,12,17,5,19,7)  
         rotate vnormalize(SphereCoordinates[2]+SphereCoordinates[12]+SphereCoordinates[17]-3*SphereCoordinates[6])*RAngle
         translate SphereCoordinates[6]*MainSphereRadius }                                                      
object { BallPlusJoints(7,4,10,16,6,11,8)  
         rotate vnormalize(SphereCoordinates[4]+SphereCoordinates[10]+SphereCoordinates[16]-3*SphereCoordinates[7])*RAngle
         translate SphereCoordinates[7]*MainSphereRadius }                                                      
object { BallPlusJoints(8,3,13,19,1,7,9) 
         rotate vnormalize(SphereCoordinates[3]+SphereCoordinates[13]+SphereCoordinates[19]-3*SphereCoordinates[8])*RAngle
         translate SphereCoordinates[8]*MainSphereRadius } 
object { BallPlusJoints(9,5,15,18,8,12,10)  
         rotate vnormalize(SphereCoordinates[5]+SphereCoordinates[15]+SphereCoordinates[18]-3*SphereCoordinates[9])*RAngle
         translate SphereCoordinates[9]*MainSphereRadius }                                                      
object { BallPlusJoints(10,4,7,16,2,9,14)  
         rotate vnormalize(SphereCoordinates[4]+SphereCoordinates[07]+SphereCoordinates[16]-3*SphereCoordinates[10])*RAngle
         translate SphereCoordinates[10]*MainSphereRadius }                                                      
object { BallPlusJoints(11,0,1,14,7,15,12)  
         rotate vnormalize(SphereCoordinates[0]+SphereCoordinates[01]+SphereCoordinates[14]-3*SphereCoordinates[11])*RAngle
         translate SphereCoordinates[11]*MainSphereRadius }                                                      
object { BallPlusJoints(12,2,6,17,9,11,13) 
         rotate vnormalize(SphereCoordinates[2]+SphereCoordinates[06]+SphereCoordinates[17]-3*SphereCoordinates[12])*RAngle
         translate SphereCoordinates[12]*MainSphereRadius } 
object { BallPlusJoints(13,3,8,19,16,14,12)  
         rotate vnormalize(SphereCoordinates[3]+SphereCoordinates[08]+SphereCoordinates[19]-3*SphereCoordinates[13])*RAngle
         translate SphereCoordinates[13]*MainSphereRadius }                                                      
object { BallPlusJoints(14,0,1,11,18,10,13)  
         rotate vnormalize(SphereCoordinates[0]+SphereCoordinates[01]+SphereCoordinates[11]-3*SphereCoordinates[14])*RAngle
         translate SphereCoordinates[14]*MainSphereRadius }                                                      
object { BallPlusJoints(15,5,9,18,16,11,19)  
         rotate vnormalize(SphereCoordinates[5]+SphereCoordinates[09]+SphereCoordinates[18]-3*SphereCoordinates[15])*RAngle
         translate SphereCoordinates[15]*MainSphereRadius }                                                      
object { BallPlusJoints(16,4,7,10,15,17,13) 
         rotate vnormalize(SphereCoordinates[4]+SphereCoordinates[07]+SphereCoordinates[10]-3*SphereCoordinates[16])*RAngle
         translate SphereCoordinates[16]*MainSphereRadius } 
object { BallPlusJoints(17,2,6,12,0,18,16)  
         rotate vnormalize(SphereCoordinates[2]+SphereCoordinates[06]+SphereCoordinates[12]-3*SphereCoordinates[17])*RAngle
         translate SphereCoordinates[17]*MainSphereRadius }                                                      
object { BallPlusJoints(18,5,9,15,3,14,17)  
         rotate vnormalize(SphereCoordinates[5]+SphereCoordinates[09]+SphereCoordinates[15]-3*SphereCoordinates[18])*RAngle
         translate SphereCoordinates[18]*MainSphereRadius }                                                      
object { BallPlusJoints(19,3,8,13,6,0,15)  
         rotate vnormalize(SphereCoordinates[3]+SphereCoordinates[08]+SphereCoordinates[13]-3*SphereCoordinates[19])*RAngle
         translate SphereCoordinates[19]*MainSphereRadius }                                                      
}
/////////////////////////////////////////////////////////////////////////
#declare T_Plateau=union {
  //plateau
  box { <-TableSize,-11.6,-TableSize>,<TableSize,-9.6,TableSize> 
  }        
  //4 bords
  cylinder { <-TableSize,-10.6,-TableSize>,<-TableSize,-10.6,TableSize>, 1
  }
  cylinder { <-TableSize,-10.6,TableSize>,<TableSize,-10.6,TableSize>, 1
  }
  cylinder { <TableSize,-10.6,TableSize>,<TableSize,-10.6,-TableSize>, 1
  }
  cylinder { <TableSize,-10.6,-TableSize>,<-TableSize,-10.6,-TableSize>, 1
  } 
  sphere {
    <-TableSize,-10.6,-TableSize>, 1
  }
  sphere {
    <-TableSize,-10.6,TableSize>, 1
  }
  sphere {
    <TableSize,-10.6,TableSize>, 1
  }
  sphere {
    <TableSize,-10.6,-TableSize>, 1
  }
  Tx_Table  ()
}       
/////////////////////////////////////////////////////////////////////////
  //dessous       
#declare T_Dessous = difference {
    box { <-TableSize/11*10,-21.6,-TableSize/11*10>,<TableSize/11*10,-11.6,TableSize/11*10>
    }
    box { <-TableSize*53/60,-21.7,-TableSize*53/60>,<TableSize*53/60,-11.5,TableSize*53/60>
    }   
    Tx_Dessous()
  }                  
/////////////////////////////////////////////////////////////////////////
#declare T_Pieds = union {
  // pieds  
  box { <-TableSize*53/60,-11.6,-TableSize*53/60>,<-TableSize*48/60,GroundY,-TableSize*48/60>
  }                                     
  box { <-TableSize*53/60,-11.6,TableSize*53/60>,<-TableSize*48/60,GroundY,TableSize*48/60>
  }                                     
  box { <TableSize*53/60,-11.6,-TableSize*53/60>,<TableSize*48/60,GroundY,-TableSize*48/60>
  }                                     
  box { <TableSize*53/60,-11.6,TableSize*53/60>,<TableSize*48/60,GroundY,TableSize*48/60>
  }                                     
  Tx_Dessous()
}            
#declare T_Pieds = union {                                             
  #declare i=0;
  #while(i<5)
    cylinder { <0,-(GroundY+11.6)/2,0>,<0,(GroundY+11.6)/2,0>,2 rotate 15*x translate 2*x+((GroundY+11.6)/2-11.6)*y  rotate 72*i*y}
    #declare i=i+1;
  #end        
  Tx_Table()
}
/////////////////////////////////////////////////////////////////////////
#declare EmptyBall = union {       
  BallMinusJoints(0,1,11,14,4,17,19)
  sphere { 0, SphereRadius/2 
           texture {
             BallTex
           }
  }
}      

#declare Colonne = difference {
    cylinder {
      <0,GroundY,0>,<0,200,0>,25
    }                          
    #declare Angle=0;
    #while(Angle < 360)    
      union {
        sphere {
          <25,185,0>,5
        }              
        sphere {
          <25,GroundY+15,0>,5
        }                    
        cylinder {
          <25,185,0>,<25,GroundY+15,0>,5
        } 
        rotate Angle*y
      }
      #declare Angle=Angle+15;
    #end
  texture {
    T_Colonne
  }
  finish {
    F_Colonne
  }        
  scale <0.5,1,0.5>
}

//mirror                   
#declare MRad=0.5;
#declare mirror = union {
  box {           
    <-12.5,-11,-0.05>,<12.5,11,0.05>
    //pigment { color rgb <0.5,0.2,0.2> }
    finish {
       ambient 0
      diffuse 1
      reflection 1
    }
  }
  union { 
    cylinder {
      <-12.5,-11,0>,<12.5,-11,0>,MRad
    }                             
    cylinder {
      <-12.5,-11,0>,<-12.5,11,0>,MRad
    }                             
    cylinder {
      <-12.5,11,0>,<12.5,11,0>,MRad
    }                           
    cylinder {
      <12.5,-11,0>,<12.5,11,0>,MRad
    }     
    sphere {<-12.5,-11,0>,MRad}                      
    sphere {<-12.5,11,0>,MRad}                      
    sphere {<12.5,11,0>,MRad}                      
    sphere {<12.5,-11,0>,MRad}                      
    texture {
      BallTex
    }
  }

}


///////////////////////////////////////////////////////////////////////// round of columns
#declare Angle=0;
#declare LesColonnes = union {
  #while(Angle<360)
    object {
      Colonne
      translate <250,0,0>
      rotate Angle*y
    }
    #declare Angle=Angle+15;
  #end
}     

////////////////////////////////////////////////////////////////////////assise du dome
#declare D_Assise = difference {
  cylinder {
    <0,200,0>,<0,210,0>,250+12.5
  }                    
  cylinder {
    <0,199,0>,<0,211,0>,250-12.5
  }                    
  texture { T_Colonne }
  finish { F_Colonne }  
}               
///////////////////////////////////////////////////////////////////////////dome
#declare D_Dome = intersection {
  difference {
    sphere { <0,210,0>,255 }
    sphere { <0,210,0>,245 }
  }
  box { <-520,210,-520>,<520,999,520> }
  texture { T_Colonne }
  finish { F_Colonne }
}                   

///////////////////////////////////////////////////////////////////////////demi-tores du dme
#declare D_Tores_Int = intersection {
  union {
    #declare Angle=0;
    #while(Angle<180)        
      torus {
        245,5
        rotate 90*x
        rotate Angle*y
        translate 210*y
      }        
      #declare Angle=Angle+15;
    #end
  }                
  box { <-520,210,-520>,<520,900,520> }
  
  rotate r_Colonne
  texture {T_Colonne}
  finish {F_Colonne}
}         
///////////////////////////////////////////////////////////////////////////demi-tores extrieurs
#declare D_Tores_Ext = intersection {
  union {
    #declare Angle=0;
    #while(Angle<180)        
      torus {
        255,5
        rotate 90*x
        rotate Angle*y
        translate 210*y
      }        
      #declare Angle=Angle+15;
    #end
  }                
  box { <-520,210,-520>,<520,900,520> }
  
  rotate r_Colonne
  texture {T_Colonne}
  finish {F_Colonne}
} 

///////////////////////////////////////////////////////////////////////// cration des objets
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
       
#declare P1=(SphereCoordinates[5]-SphereCoordinates[4])*MainSphereRadius*3;
#declare P1=vtransform(P1,transform{ rotate vnormalize(SphereCoordinates[9]+SphereCoordinates[15]+SphereCoordinates[18]-3*SphereCoordinates[5])*RAngle
                                     translate SphereCoordinates[5]*MainSphereRadius });
//#debug concat("P1=",vstr(3,P1,",",5,5),"\n")
#declare P2=(SphereCoordinates[9]-SphereCoordinates[10])*MainSphereRadius*3;
#declare P2=vtransform(P2,transform{ rotate vnormalize(SphereCoordinates[5]+SphereCoordinates[15]+SphereCoordinates[18]-3*SphereCoordinates[9])*RAngle
                                     translate SphereCoordinates[9]*MainSphereRadius });
//#debug concat("P2=",vstr(3,P2,",",5,5),"\n")
#declare P3=(SphereCoordinates[15]-SphereCoordinates[16])*MainSphereRadius*3;  
#declare P3=vtransform(P3,transform{ rotate vnormalize(SphereCoordinates[5]+SphereCoordinates[09]+SphereCoordinates[18]-3*SphereCoordinates[15])*RAngle
                                     translate SphereCoordinates[15]*MainSphereRadius });
//#debug concat("P3=",vstr(3,P3,",",5,5),"\n")
#declare NormVect=vnormalize(vcross(P1-P2,P2-P3));
//#debug concat("NV=",vstr(3,NormVect,",",5,5),"\n")
#declare myTransformz=transform { rotate VAngleD(y,<NormVect.x,NormVect.y,0>)*z};
#declare TNV=vtransform(NormVect,transform myTransformz);
//#debug concat("NV(z)=",vstr(3,TNV,",",5,5),"\n")
#declare myTransform=transform { rotate VAngleD(y,<NormVect.x,NormVect.y,0>)*z rotate VAngleD(y,<0,TNV.y,TNV.z>)*x }
//#debug concat("NV((x)z)=",vstr(3,vtransform(NormVect,transform{myTransform}),",",5,5),"\n")
#declare P1T=vtransform(P1,transform{myTransform});
//#debug concat("P1T.y=",str(vtransform(P1,transform{myTransform}).y,5,5),"\n")    
//#debug concat("P2T.y=",str(vtransform(P2,transform{myTransform}).y,5,5),"\n")    
//#debug concat("P3T.y=",str(vtransform(P3,transform{myTransform}).y,5,5),"\n")    

#declare CTT=transform { 
         translate -myVect/5          
         transform { myTransform }
         rotate 35*y    
//         translate -9.6+9.57940
}   

// y minimum = -9.57940                        
#declare i=00000;
#declare j=00000;   
#declare TN=100;
#declare minY=vtransform(P1,transform{CTT}).y;  
#declare Norm=<0,0,0>;    
#declare TraceObj=object {CasseTete transform {CTT}}; 
//#debug concat("TraceObj min_extent=<",vstr(3,min_extent(TraceObj),",",5,5),">,max_extent=<",vstr(3,max_extent(TraceObj),",",5,5),">\n")
//#debug concat("trace=<",vstr(3,trace(CasseTete,CamLoc,-CamLoc,Norm),",",5,5),">,max_extent=<",vstr(3,max_extent(CasseTete),",",5,5),"\n")
#while(i<TN)     
  #declare j=0;
  #while(j<TN)              
    //#local X=(min_extent(TraceObj)).x+(max_extent(TraceObj).x-min_extent(TraceObj).x)/TN*i;
    //#local Z=min_extent(TraceObj).z+(max_extent(TraceObj).z-min_extent(TraceObj).z)/TN*j;     
    #local X=P1T.x-0.1+0.2/TN*i;
    #local Z=P1T.z-0.1+0.2/TN*j;     
    //#debug concat(str(X,10,10),",",str(Z,10,10),"\n")
    #local temp=trace(TraceObj,<X,-100,Z>,y,Norm);  
    #if(vlength(Norm)>0)
      #if(temp.y < minY)
        #declare minY=temp.y;
        //#debug concat("minY = ",str(minY,5,5)," at ", str(X,10,10),",",str(Z,10,10),"\n")
      #end
    #end  
    #declare j=j+1;
  #end            
  #declare i=i+1;
#end        


object { CasseTete 
         transform { CTT }
         translate (-9.6-minY)*y
         finish {
           ambient 0.5
         }
}                                  


        

#declare P1=(SphereCoordinates[0]-SphereCoordinates[17])*MainSphereRadius*3;
//#debug concat("P1=",vstr(3,P1,",",5,5),"\n")
#declare P2=(SphereCoordinates[11]-SphereCoordinates[0])*MainSphereRadius;
#declare P3=(SphereCoordinates[0]-SphereCoordinates[4])*MainSphereRadius*3;  
#declare NormVect=vnormalize(vcross(P1-P2,P2-P3));
#declare myTransformz=transform { rotate VAngleD(y,<NormVect.x,NormVect.y,0>)*z};
#declare TNV=vtransform(NormVect,transform myTransformz);
#declare myTransform=transform { rotate VAngleD(y,<NormVect.x,NormVect.y,0>)*z rotate VAngleD(y,<0,TNV.y,TNV.z>)*x }


#declare P1T=vtransform(P1,transform myTransform);
#declare P2T=vtransform(P2,transform myTransform);
#declare P3T=vtransform(P3,transform myTransform);

#declare P1angle=VAngleD(P1T-SphereCoordinates[0],<(P1T-SphereCoordinates[0]).x,P1T.y,(P1T-SphereCoordinates[0]).z>);
#declare P1offset=cosd(P1angle);


object {
  BallPlusJoints(0,1,11,14,4,17,19) 
  transform myTransform
  rotate 65*y
  translate <28,-9.6-P1T.y+CylRadius*P1offset-(9.6-9.5746),-49>
}     


    
#declare BallPositions=array[20];    
#declare i=0;
#while (i<20)
   #declare NewPosition=<5,-9.6+SphereRadius,-10>+rand(Rnd)*x*15+rand(Rnd)*40*z;
   #declare j=0;             
   #declare Collide=false;
   #while(j<i)
     #if(vlength(BallPositions[j]-NewPosition) < SphereRadius*2)
       #declare Collide=true;                                                          
//       #debug concat("Ball ",str(i,2,0)," and ",str(j,2,0)," collide (length=",str(vlength(BallPositions[j]-NewPosition),2,5),")\n")
     #end
     #declare j=j+1;
   #end             
   #if(!Collide)
     #declare BallPositions[i]=NewPosition;   
//     #debug concat("Fixed ball ",str(i,2,0)," at <", vstr(3,NewPosition,",",2,3),">\n")
     #declare i=i+1;
   #end
#end                             
                
#declare i=0;  
#declare MissingBall=int(rand(Rnd)*20);
#while(i<20)
 #if(i!=MissingBall)
  object {
    EmptyBall
    rotate <rand(Rnd)*360,rand(Rnd)*360,rand(Rnd)*360>
    translate BallPositions[i]-30*z+5*x
  }                 
 #end //if
  #declare i=i+1;
#end                
#declare Table = union {
   object { T_Plateau }
   //object { T_Dessous }
   object { T_Pieds }
}                         

#declare Rnd1=seed(3);
#declare InnerCylLength = vlength((SphereCoordinates[0]-SphereCoordinates[1])*MainSphereRadius)-SphereRadius;       
#declare Missing = array[3];                                     
#declare Missing[0]=int(rand(Rnd1)*30);
#declare Missing[1]=int(rand(Rnd1)*30);
#declare Missing[2]=int(rand(Rnd1)*30);
#declare i=0;
#declare j=0;
#while(j<3)
  #while(i<20)         
    #if(j*20+i!=Missing[0] & j*20+i!=Missing[1] & j*20+i!=Missing[2])
      object {
        cylinder {
          0,
          <0,0,InnerCylLength>,
          CylRadius 
          texture {
            CylTex
          }                   
          #if(i<18)
            rotate (rand(Rnd1)*2-1)*y
            translate <-17+0.5*i,-9.6+CylRadius,-10-10*j+rand(Rnd1)*2-1> + <-10,0,+20>
          #else
            translate <0,0,-InnerCylLength/2>
            rotate rand(Rnd1)*90*y
            translate <-14+rand(Rnd1)*6,-9.6+3*CylRadius,-10+InnerCylLength/2-10*j+rand(Rnd1)*4-2> + <-10,0,+20>  
          #end
        }
      }                                                               
     #end
     #declare i=i+1;
  #end              
  #declare i=0;
  #declare j=j+1;
#end                   
                                    
#declare Rnd2=seed(4);                                    
#declare Missing[0]=int(rand(Rnd2)*30);
#declare Missing[1]=int(rand(Rnd2)*30);
#declare Missing[2]=int(rand(Rnd2)*30);

#declare OuterCylLength = vlength((SphereCoordinates[0]-SphereCoordinates[4])*MainSphereRadius)*3-SphereRadius/2;
#declare i=0;
#declare j=0;
#while(j<2)
  #while(i<30)
    #if(30*j+i!=Missing[0] & 30*j+i!=Missing[1] & 30*j+i != Missing[2])
     object {
       cylinder {
         0,
         <0,0,OuterCylLength>,
         CylRadius 
         texture {
           CylTex
         } 
          #if(i<28)
         rotate (rand(Rnd2)-0.5)*y
         translate <-5+0.6*i,-9.6+CylRadius,-25-15*j+rand(Rnd2)*2-1> + <-10,0,+5>
          #else
            translate <0,0,-OuterCylLength/2>
            rotate rand(Rnd2)*90*y
            translate <-5+rand(Rnd2)*15+30-i,-9.6+3*CylRadius,-25+OuterCylLength/2-15*j+rand(Rnd2)*4-2> + <-10,0,+5>
          #end
       }
     }                                                                 
    #end  //if
     #declare i=i+1;
  #end              
  #declare i=0;
  #declare j=j+1;
#end

object { Table   
  rotate 10*y
  translate -15*z  
}                  
        

object {
  mirror
  rotate -28*y
  translate <-47.5,2.5,69.9>
}
object {
  bonhomme            
  scale 0.1   
  rotate -30*x       
  rotate -60*y
  translate <0,-9.6,0>
//  translate <-13,0,6>                           
  translate <7.5,0,-37.5>
}


object {
  LesColonnes
  rotate r_Colonne*y
}


object { D_Assise }
object { D_Dome }
object { D_Tores_Int }
object { D_Tores_Ext }

                       
#debug "generating ground\n"                       
#include "sol.pov"
object {
  _HF
  scale 2000 
  scale <1,0.5,1>
  translate GroundY*y 
}
                            
#debug "OK!\n"                            
isosurface  {
  function { y-f_noise3d(x,y,z)}
  threshold 1
  max_gradient 1.961
  contained_by { box {<-1000,-10,-1000>,<1000,10,1000>}}  
/*  pigment{ 
        bumps
        color_map{
          [0.0 color rgb<188,153,124>/255*1.3]
          [0.5 color rgb<188,153,124>/255*1.3]
          [0.6 color rgb<169,128, 80>/255*1.3]
          [1.0 color rgb<169,128, 80>/255*1.3]
  }
  //scale <.75,1,1>*.75 translate z*-4.45 translate x*7.75
  //finish{ambient 0 diffuse 1}
} */

  pigment { //color Yellow }
    bozo
    turbulence 0.6
    octaves 6
    omega 0.5
    lambda 3
    color_map {
      [ 0.0  0.05 color rgb <0,0,0>           
                  color rgb <0,0,0>]
      [ 0.05 0.1  color rgb <0,0,0>
                  color rgb <201,158,52>/256]
      [ 0.1  1    color rgb <201,158,52>/256
                  color rgb <255,202,106>/256]
    }
  }
  finish { ambient 0.5 diffuse 0.5}  
  translate GroundY*y
}                   
         
//sky_sphere texture taken in povray on-line help                                      
sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.000 0.015 color rgb <1.0, 1.0, 1.0>
                     color rgb <1.0, 1.0, 1.0>]
        [0.015 0.200 color SkyBlue
                     color SkyBlue]
      }
      scale 2
      translate -1
    }
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.02, 0.05, 0.02>
    }
    rotate -100*x
  }
                 
                 
#if(FinalRender)                 
	#debug "Including tree\n"        
	#include "tree.inc"
	#debug "Generating trees\n"
	#declare Rnd2=seed(40);                           
	#declare i=0;
	#while(i<512)    
	  #declare X=rand(Rnd2);
	  #declare Z=rand(Rnd2); 
	  #if(vlength(<X-0.5,0,Z-0.5>*2000) > 260)
	      #local temp=<0,0,0>;
	      #local Inter=trace(_HF,<X-0.5,-1,Z-0.5>,y,temp);         
	      #if(vlength(temp)>0)
	        object {
	          TREE          
	          translate -0.032*y
	          scale 100
	          scale <rand(Rnd2)+0.5,rand(Rnd2)+0.5,rand(Rnd2+0.5)>
	          rotate rand(Rnd2)*360*y
	          translate <X-0.5,0,Z-0.5>*2000 
	          //#debug concat("x=",str(X,0,-1),", z=",str(Z,0,-1))
	          //#debug concat(", Inter.y=",str(Inter.y,0,-1),"vlength=",str(vlength(temp),0,-1),"\n")
	          translate y*Inter.y*1000+GroundY*y    
	          //rotate -3*y                        
	        }
	//        pigment {color White}
	//        finish {ambient 1}    
	//      #else  
	        //translate GroundY*y
	      #end
	    //#debug concat("put a tree at ",str(X*2000-1000,4,3),",",str(Z*2000-1000,3,3),"\n")
	    #declare i=i+1;
	  #end
	    
	
	#end       
#end
#debug "starting grass\n"
#include "makegrass\mgrass.pov"
/*#declare i=0;
#declare Rnd3=seed(3);
#declare GrassBlades=array[10];
#while(i<10)
  #declare doSmooth = true;       // smooth triangles                           
  #declare posBlade = <0,0,0>;    // position of blade
  #declare rotBlade = 0;        // rotation of blade around y
  #declare segBlade= 20;          // number of blade segments - try low values (5 for instance) for tests
  #declare lBlade = 5+rand(Rnd3)*10;           // length of blade
  #declare xBladeStart = 0.5;       // width of blade at start
  #declare xBladeEnd = 0.1;       // width of blade at the end
  #declare zBladeStart = 0.5;     // depth of blade fold at start
  #declare startBend = <0,1,0>;   // bending of blade at start (<0,1,0>=no bending)
  #declare vBend = <0,1,1>-rand(Rnd3)*y;      // force bending the blade (<0,1,1> = 45)
  #declare pwBend = 1;           // bending power (how slowly the curve bends)
  #declare dofold = false;        // true creates a fold in the blade (twice more triangles)
  #declare dofile = false;        // true creates a mesh file
  #declare GrassBlades[i]=mesh{
    MakeBlade(doSmooth,posBlade,rotBlade,segBlade,lBlade,xBladeStart,xBladeEnd,zBladeStart,startBend,vBend,pwBend,dofold,dofile)
  }                                  
  #declare i=i+1;
#end         
    
union {    
#declare i=0;
#declare NbGrass=20000;                                
#while(i<NbGrass)  
  #declare X=0.25+rand(Rnd3)/2;
  #declare Z=0.25+rand(Rnd3)/2; 
  #local temp=<0,0,0>;
  #local Inter=trace(HF,<X-0.5,-1,Z-0.5>,y,temp);         
  #if(vlength(temp)>0)

     #declare posBlade=<(X-0.5)*2000,Inter.y*1000+GroundY,(Z-0.5)*2000>;
     #declare rotBlade=rand(Rnd3)*360;
     object {
       GrassBlades[int(rand(Rnd3)*10)]
//       pigment { color rgb <0.3+(rand(Rnd3)*0.4)-0.2,0.7+rand(Rnd3)*0.4-0.2,0.1>
//       }              
       rotate rotBlade*y  
       scale <rand(Rnd3),rand(Rnd3),rand(Rnd3)>
       translate posBlade
//       translate <X-0.5,0,Z-0.5>*2000  
//       translate y*Inter.y*1000+GroundY*y    
     }
     #declare i=i+1;
     #if(mod(i,NbGrass/100)=0)
       #debug concat(str(i/NbGrass*100,0,0),"%\n")
     #end
  #end
#end   
  texture { T_Grass }
} */                      

//2nd try
/*#declare lPatch=2000;               // size of patch
#declare nBlade=200;               // number of blades per line
#declare ryBlade = 60;            // initial y rotation of blade
#declare segBlade= 15;            // number of blade segments
#declare lBlade = 15;             // length of blade
#declare wBlade = 0.5;              // width of blade at start
#declare wBladeEnd = 0.3;         // width of blade at the end
#declare doSmooth=false;          // true makes smooth triangles
#declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,-1,2>;       // direction of the force bending the blade (<0,1,1> = 45)
#declare pwBend = 3;             // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 3;           // standard deviation of blade scale;
#declare stdBend = 0;             // standard deviation of blade bending;
#declare dofold = false;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;           // true creates a mesh file
#declare fname = "fgrass.inc"     // name of the mesh file to create
// --------------------------------------
        
        MakeGrassPatchHF(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname,HF)
        #declare objectPatch=#include fname
object {
  objectPatch
  //translate GroundY*y
  texture { T_Grass }
}*/


//3rd try
// GRASS TEX: SAMPLE GRASS SCENE
// 
// Copyright 2002 Rune S. Johansen
// *********************************************************
// This scene is an example of how Grass Tex can be used to
// cover a heightfield with grass.
/*   
   #include "grasstex\grasstex.inc"
   
   global_settings {noise_generator 3}
   
// Declare the camera location. It's needed for the grass effect.
   #declare camera_location = CamLoc+15*y;
   
// A height field object used for the ground
   #declare HF = object {
     _HF
     scale 2000 
     scale <1,0.5,1>
     translate GroundY*y 
   }
   
// A normal used for the grass texture layers.
   #declare GrassNormal = normal {bumps 0.7 scale 20 turbulence 2}
   
   
// Grass Tex Settings
// *********************************************************
   
   #declare gt_scale   = 0.5;
   #declare gt_height  = 1.10;
   #declare gt_turb    = 0.6;
   #declare gt_samples = 20;
   #declare gt_tweak   = 0.025;
   
// The function that is used as grass map.
   #declare gt_densitymap =
   function(x,y,z) {
      (0.1+f_noise3d(x/5,y/5+3.6,z/5))
      
   }
   
// The function used as height map for the grass.
// The function used here is constant.
   #declare gt_heightmap  = function(x,y,z) {1}
   
// Here is the ground, which is the height field that was declared.
   object {
      HF
      
//    The very first layer should be the ground layer.
//    The color map controls the colors according to the density map:
      texture {
         #declare gt_groundcolors =
         color_map {
            [0.0, color <0.70,0.55,0.40>]
            [0.5, color <0.50,0.40,0.30>]
            [1.0, color <0.30,0.25,0.20>]
         }
         gt_ground()
         normal {wrinkles 0.5 scale 1*gt_scale turbulence 1}
      }
      
//    On top of that is a grass tex layer:
      texture {
         #declare gt_color   = <0.15,0.65,0.00>;
         #declare gt_offset  = -0.00;
         #declare gt_seed    = 0;
         gt_grass()
         normal {GrassNormal scale gt_scale}
      }
   }
   
// Here is a copy of the ground, translated slightly upwards to simulate
// the height of the grass.
   object {
      HF translate 0.8*y
      
//    As this copy of the ground is semi-transparent, the following
//    line should be used for optimal results:
      no_shadow interior_texture {pigment {color transmit 1}}
      
//    Now another grass tex layer is added:
      texture {
         #declare gt_color   = <0.65,1.00,0.35>;
         #declare gt_offset  = -0.8;
         #declare gt_seed    = 1;
         gt_grass()
         normal {GrassNormal scale gt_scale}
      }
      
//    And finally a layer with some yellow flowers:
      texture {
         #declare gt_flowercolor = <1.2,1.0,0.0>;
         #declare gt_seed    = 1;
         gt_flowers()
      }
      
   }
*/
#if(FinalRender)
	#declare Rnd3=seed(3);
	//2nd try
	#include "makegrass\mgrass.pov"
	#include "transforms.inc"
	#declare lPatch=20;               // size of patch
	#declare nBlade=lPatch;               // number of blades per line
	#declare ryBlade = 60;            // initial y rotation of blade
	#declare segBlade= 15;            // number of blade segments
	#declare lBlade = 5;             // length of blade
	#declare wBlade = 0.12;              // width of blade at start
	#declare wBladeEnd = 0.01;         // width of blade at the end
	#declare doSmooth=true;          // true makes smooth triangles
	#declare startBend = <0,1,0>;   // bending of blade at start (<0,1,0>=no bending)
	#declare vBend = <0,1,0>;       // direction of the force bending the blade (<0,1,1> = 45)
	#declare pwBend = 2;             // bending power (how slowly the curve bends)
	#declare stdposBlade = 1;         // standard deviation of blade position 0..1
	#declare stdrotBlade = 360;       // standard deviation of rotation
	#declare stdBlade = 3;           // standard deviation of blade scale;
	#declare stdBend = 2;             // standard deviation of blade bending;
	#declare dofold = false;          // true creates a central fold in the blade (twice more triangles)
	#declare dofile = true;           // true creates a mesh file
	#declare fname = "fgrass.inc"     // name of the mesh file to create
	// --------------------------------------
	                                       
	#declare MaxIndex=8;                                       
	#declare PatchArray=array[MaxIndex];
	#declare i=0;
	#declare maxAngle=0;
	#while(i<MaxIndex)                   
	        #declare rd = 459+i;                // seed
	        #declare startBend=y-z*cosd(5+10*i);
	        #declare vBend=startBend;
	        #declare fname = concat("fgrass",str(i,0,0),".inc")     // name of the mesh file to create
	        #debug concat("mesh #",str(i,0,0),"\n")
	        #if(!file_exists(fname))
	          MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
	        #end
	        #declare PatchArray[i]=#include fname
	#declare i=i+1;        
	#end        
	  #declare X=0;
	  #declare Created=0;
	  #while(X<1)
	    #declare Z=0;
	    #while(Z<1)                  
	      #local Norm=<0,0,0>;
	      #local Inter=trace(_HF,<X-0.5,10,Z-0.5>,-y,Norm);
	      #if(vlength(Norm)>0)
	
			
	
	        object {
	          //PatchArray[int(rand(Rnd3)*MaxIndex)]
	          PatchArray[int(VAngleD(y,Norm)/10)]
	          texture {
	            T_Grass   
	            scale 40
	          }            
	          
	          #if(VAngleD(y,Norm)>maxAngle)
	          	#declare maxAngle=VAngleD(y,Norm);
				//#debug concat("Max angle=",str(maxAngle,0,0),"\n")                                            
	          #end
	//          #debug concat("Norm=<",vstr(3,Norm,",",0,3),">")
	          #if(!VEq(Norm,y))
	          	#declare NormP=vnormalize(VProject_Plane(Norm,y));
	//          #debug concat(" => <",vstr(3,NormP,",",0,3),">")
	//          #debug concat(" acosd=",str(acosd(NormP.x),0,0)," asind=",str(asind(NormP.z),0,0))
	          	#declare CurAngle=acosd(NormP.x);
	          	#if(NormP.z>0)
	           		#declare CurAngle=-CurAngle;
	          	#end                         
	//          #debug concat(" angle=",str(CurAngle,0,0),"\n")
	          //rotate 90*int(rand(Rnd3)*4)*y
	          	rotate CurAngle*y
	          #end
	          Reorient_Trans(y,Norm)  
	          scale 0.5
	          translate <(X-0.5)*2000,-61.6+1000*Inter.y,(Z-0.5)*2000>
	        }            
	        #declare Created=Created+1;
	//        #debug concat("created one at ",str((X-0.5)*2000,0,0),",",str((Z-0.5)*2000,0,0),"\n")
	      #end
	      #declare Z=Z+0.005;          
	    #end                           
	    #debug concat(str(int(X*10000)/100,0,1),"% (",str(Created,0,0)," created)\n")
	    #declare X=X+0.005;
	  #end
	//#end
	                                            
	//#debug concat("Max angle=",str(maxAngle,0,0),"\n")                                            
#end