#include "colors.inc"
//scale : mm
           
#ifndef(MainRender)           
 //create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-20, 40, -20>
}
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <0, 0, -100>
}
  
// perspective (default, not required) camera
camera {
  perspective
  location  <0, 0, -100>
  look_at   <0, 0,  0>
  right     x*image_width/image_height  // aspect
  // direction z                        // direction and zoom
  // angle 67                           // field (overides direction zoom)
} 

#declare _lego_RotateRightLeg=45;
#declare _lego_RotateLeftLeg=-45;
#declare _lego_RotateHead=60;
#declare _lego_RotateLeftHand=0;
#declare _lego_RotateRightHand=0;
#declare _lego_RotateLeftArm=90;
#declare _lego_RotateRightArm=90;
#end

// Capped Cylinder, closed [or open ended]
// cylinder { <END1>, <END2>, RADIUS [open] }
//  END1 = coord of one end of cylinder
//  END2 = coord of other end
// RADIUS = size of cylinder
// open = if present, cylinder is hollow, else capped
#declare Head = union {
  cylinder {
  0,  6*y,  5
  // open   
  }
  cylinder {
  0,  6*y,  5.00001
  // open   
  	pigment {image_map { png "visage.png" once interpolate 2.0 map_type 2 transmit 0,1} scale <1,4.5,1> rotate -90*y 
  		#ifdef(_lego_RotateHead)
  			rotate _lego_RotateHead*y
  		#end
  	}
  }
  // torus {MAJOR, MINOR} // (in the X-Z plane)
// MAJOR = float value giving the major radius
// MINOR = float specifying the minor radius
// The major radius extends from the center of the hole
// to the mid-line of the rim while the minor radius
// is the radius of the cross-section of the rim.
  torus {
    4,
    1
    translate <0,6,0>
  }                  
  torus {
    4,
    1
  }  
  difference {
    cylinder {
      6*y, 8*y, 2.5
    }              
    cylinder {
      6*y, 8*y, 2
    }
  }              
  cylinder {
    -y, -2*y, 3
  }  

}
         
#declare Body = object {
  prism {                                
    linear_sweep  // or conic_sweep for tapering to a point
    linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
    -3.5,         // height 1
    3.5,         // height 2
    5,           // number of points
  < -5.5,-2>, <5.5,-2>, <7.5,-14.5>, <-7.5,-14.5>,<-5.5,-2>
  rotate -90*x
  }

  
}         

#declare Belly = union
{
  box {
    <-7.5,-14.5,-3.5>,<7.5,-15.5,3.5>
  }                              
  cylinder {
    <-0.75,-19,0>,<0.75,-19,0>,3.5
  }
}                          

#declare Leg = difference {
  union {
    cylinder {
      <-7.5,-19,0>,<-0.75,-19,0>,3.5
    }                              
    box {
      <-7.5,-19,3.5>,<-0.75,-30,0>
    }
    box {
      <-7.5,-27,3.5>,<-0.75,-30,-2>
    }
  }
}       

#declare Arm = union {   
  sphere {
    <0,0,0>,1
  }
  cylinder {
    <0,0,0>,<0,-5,0>,1
    //scale <0.6,1,1>
  }                 
  sphere {
    <0,-5,0>,1
    //scale <0.6,1,1>
  }                 
  cylinder {
    <0,0,0>,<0,-4,0>,1
    rotate 30*x
    translate <0,-5,0>
  }  
}        
#declare RightArm=object {
  Arm
  rotate <0,0,-30>
  #ifdef(_lego_RotateRightArm)
  	rotate _lego_RotateRightArm*x
  #end
  translate <-5.25,-3,0>

}
#declare LeftArm=object {
  Arm
  rotate <0,0,+30>
  #ifdef(_lego_RotateLeftArm)
  	rotate _lego_RotateLeftArm*x
  #end
  translate <+5.25,-3,0>

}                               
#declare Hand = union {
  cylinder {
    <0,0,0>,<0,-1,0>,0.75
  }                     
  difference {
      cylinder {
        <0,-3.5,1>,<0,-3.5,-3.5>,2.5
      }                       
      cylinder {
        <0,-3.5,1.01>,<0,-3.5,-3.51>,2
      }
      box {
        <-1.25,-3.5,1.02>,<1.25,-6.01,-3.51>
      } 
  }      
  //scale 0.9
/*  translate -4*y
  rotate 30*x
  translate -5*y             */
}     

#declare LeftHand = object {
  Hand                    
  #ifdef(_lego_RotateLeftHand)
  	rotate _lego_RotateLeftHand*y
  #end                         
  translate -4*y
  rotate 30*x
  translate -5*y             
  rotate +30*z    
  #ifdef(_lego_RotateLeftArm)
  	rotate _lego_RotateLeftArm*x
  #end
  translate <5.25,-3,0>
}                      
#declare RightHand =object {
  Hand                     
  #ifdef(_lego_RotateRightHand)
  	rotate _lego_RotateRightHand*y
  #end
  translate -4*y
  rotate 30*x
  translate -5*y             
  rotate -30*z
  #ifdef(_lego_RotateRightArm)
  	rotate _lego_RotateRightArm*x
  #end
  translate <-5.25,-3,0>
}                   
#declare RedColor=color rgb <204,26,15>/256;
#declare YelColor=color rgb <204,158,2>/256;

#declare bonhomme = union {
  object { 
    Head   
    pigment { color YelColor}  
  } 
  object {
    Body
    pigment { color RedColor }
  }                                    
  object {
    Belly
    pigment { color RedColor }
  }                                
  object {
    Leg
    pigment { color RedColor }  
    #ifdef(_lego_RotateRightLeg) 
        translate <0,19,0>
    	rotate _lego_RotateRightLeg*x
    	translate <0,-19,0>
    #end
  }                          
  object {
    Leg 
    translate <7.5+0.75,0,0> 
    #ifdef(_lego_RotateLeftLeg)
        translate <0,19,0>
    	rotate _lego_RotateLeftLeg*x
    	translate <0,-19,0>
    #end
    pigment {color RedColor }
  }                           
  object {
    RightArm
    pigment { color RedColor }
  }   
  object {
    LeftArm
    pigment {
      color RedColor
    }
  }                             
  object {
    LeftHand               
    pigment { color YelColor }
  }                        
  object {
    RightHand
    pigment { color YelColor }
  }
  translate <0,30,0>  
  finish {
    phong 0.5
    phong_size 30
  }
}

#ifndef(MainRender)
	object { bonhomme rotate 45*y}
#end