#include "colors.inc"
#ifndef(MainRender)
#declare CamLoc = <70,10,-200>;//<0,  min_extent(CasseTete).y/*-myVect.y/5+20*/,40>;
  camera {
    location CamLoc+15*y  //<0.0, 16.0, 40.0>
    look_at   0
    right     x*image_width/image_height  
    angle 15
}                            
light_source {
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <-2000, 1400, -1400> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}
light_source {
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <200, 200, 0> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 10                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}

#end

#declare Ground = function {
  pigment {
    bumps
    turbulence 0.5
    scale 0.25
    color_map {
      [ 0 color rgb 0 ]
      [ 1 color rgb 1 ]
    }
  }
}

#declare _HF=height_field {    
#declare HFSize=1000;
  function HFSize,HFSize { 0.5+(Ground(x,y,0).gray-0.5)*sqrt(pow(x-0.5,2)+pow(y-0.5,2)) }   
  water_level 0.5         
  pigment {color Green}
  finish {ambient 0.5 diffuse 0.5}
  translate <-0.5,-0.5,-0.5>
}    
//#debug concat("minHF=<",vstr(3,min_extent(HF),",",3,3),"\n")
//#debug concat("maxHF=<",vstr(3,max_extent(HF),",",3,3),"\n")
       
#ifndef(MainRender)
object {_HF 
  scale 2000
  scale <1,0.5,1> 
}                     
cylinder {<-100000,0,0>,<100000,0,0>,.1 pigment {color Red}}
cylinder {<0,-100000,0>,<0,100000,0>,.1 pigment {color Green}}
cylinder {<0,0,-100000>,<0,0,100000>,.1 pigment {color Blue}}

#end  
