#macro roundedbox (x1,y1,z1,x2,y2,z2,rad)
#if (x1>x2)
  #local hold=x1;
  #local x1=x2;
  #local x2=hold;
#end
#if (y1>y2)
  #local hold=y1;
  #local y1=y2;
  #local y2=hold;
#end
#if (z1>z2)
  #local hold=z1;
  #local z1=z2;
  #local z2=hold;
#end
union {
  box { <x1+rad,y1+rad,z1> <x2-rad, y2-rad,z2> }
  box { <x1+rad,y1,z1+rad> <x2-rad, y2,z2-rad> }
  box { <x1,y1+rad,z1+rad> <x2, y2-rad,z2-rad> }
  sphere { <x1+rad,y1+rad,z1+rad> rad }
  sphere { <x2-rad,y1+rad,z1+rad> rad }
  sphere { <x1+rad,y2-rad,z1+rad> rad }
  sphere { <x2-rad,y2-rad,z1+rad> rad }
  sphere { <x1+rad,y1+rad,z2-rad> rad }
  sphere { <x2-rad,y1+rad,z2-rad> rad }
  sphere { <x1+rad,y2-rad,z2-rad> rad }
  sphere { <x2-rad,y2-rad,z2-rad> rad }
  cylinder { <x1+rad,y1+rad,z1+rad> <x2-rad,y1+rad,z1+rad> rad }
  cylinder { <x1+rad,y2-rad,z1+rad> <x2-rad,y2-rad,z1+rad> rad }
  cylinder { <x1+rad,y1+rad,z2-rad> <x2-rad,y1+rad,z2-rad> rad }
  cylinder { <x1+rad,y2-rad,z2-rad> <x2-rad,y2-rad,z2-rad> rad }

  cylinder { <x1+rad,y1+rad,z1+rad> <x1+rad,y2-rad,z1+rad> rad }
  cylinder { <x2-rad,y1+rad,z1+rad> <x2-rad,y2-rad,z1+rad> rad }
  cylinder { <x1+rad,y1+rad,z2-rad> <x1+rad,y2-rad,z2-rad> rad }
  cylinder { <x2-rad,y1+rad,z2-rad> <x2-rad,y2-rad,z2-rad> rad }

  cylinder { <x1+rad,y1+rad,z1+rad> <x1+rad,y1+rad,z2-rad> rad }
  cylinder { <x2-rad,y1+rad,z1+rad> <x2-rad,y1+rad,z2-rad> rad }
  cylinder { <x1+rad,y2-rad,z1+rad> <x1+rad,y2-rad,z2-rad> rad }
  cylinder { <x2-rad,y2-rad,z1+rad> <x2-rad,y2-rad,z2-rad> rad }
}
#end
