#ifndef (FULLSCENE)
  #declare QUICKRENDER = true;
#end

#local treeYOffset = 1.2;

#local branchTexture = texture
{
  pigment
  {
    granite
    color_map
    {
      [0.0 rgb <0.7, 0.4, 0.1>]
      [0.7 rgb <0.4, 0.5, 0.4>]
      [1.0 rgb <0.4, 0.5, 0.4>]
    }
  }
  normal
  {
    granite 1.5
  }
  scale 0.2
  finish
  {
    diffuse 1
  }
}

#local potTexture = texture
{
  pigment
  {
    granite
    //warp {turbulence 1}
    scale 0.5
    color_map
    {
      [0.0 rgb <0, 0.6, 0.4>]
      [0.5 rgb <0, 0, 0>]
      [1.0 rgb <0.5, 0.5, 0.5>]
    }
  }
  finish
  {
    specular 0.6
    roughness 0.4
    diffuse 1
    #ifndef (QUICKRENDER)
      reflection 0.3
    #end
  }
}

#local soilTexture = texture
{
  pigment
  {
    rgb <0.2, 0.12, 0.05>
  }
  normal
  {
    granite 0.8
    turbulence 0.5
    scale 0.1
  }
  finish
  {
    diffuse 1
  }
}

#macro BranchRadius(rawSize)
  sqrt(rawSize) * 0.2
#end

#macro BonsaiLeaf(rawSize)
sphere
{
  <0,25,0>,25
  scale<0.1,1,0.4>*rawSize
  texture
  {
    pigment
    {
      rgb <250*(0.005-rawSize),0.7,50*rawSize>
    }
    normal
    {
      radial 0.03
      frequency 36
      rotate z*90
      rotate x*5
      translate -y*3*rawSize
      slope_map
      {
        [0.0 <1, 0>]
        [0.45 <0, 1>]
        [0.5 <1, 0>]
        [0.55 <0, -1>]
        [1.0 <1, 0>]
      }
      accuracy 0.005
    }
  }
}
#end

#declare Bonsai = union
{
  // Pot
  
  union
  {
    lathe
    {
      cubic_spline
      12,
      <0, 0>,
      <1.2, 0>,
      <1.6, 0.7>,
      <1.6, 1.0>,
      <1.4, 1.2>,
      <1.5, 1.4>,
      <1.3, 1.4>,
      <1.4, 1.3>,
      <1.4, 1.2>,
      <1.5, 0.8>,
      <0.8, 0.2>,
      <0.8, 0>
      
      texture
      {
        potTexture
      }
    }
    
    torus
    {
      0.9, 0.6
      scale <1, 0.5, 1>
      translate y*0.9
      
      texture
      {
        soilTexture
      }
      #ifndef (FULLSCENE)
        finish
        {
          ambient 0.4
        }
      #end
    }
    
    scale <1, 1.2, 1>
    translate -y*treeYOffset
  }
  
  
union {
sphere_sweep
{
  #ifdef (QUICKRENDER) 
    linear_spline,
    23
  #else
    cubic_spline,
    24
    <0, -1, 0>, BranchRadius(5.0)
  #end
  
  <0.0, 0.0, 0.0>, BranchRadius(2.0)
  <0.03698388727786486, 0.9937133894049506, -0.001604299211729634>, BranchRadius(0.9944026759702618)
  <0.16393053028957108, 1.3960759668812803, -0.004736197499282058>, BranchRadius(0.42192523355710865)
  <0.2315093984894522, 1.5774866674494556, -0.008357563216419117>, BranchRadius(0.1936229841663183)
  <0.3507057821463858, 1.7157948841220276, 0.05304466226511352>, BranchRadius(0.1926322246409541)
  <0.4522910746302586, 1.8180005603455531, 0.10303390817639071>, BranchRadius(0.1525270356629285)
  <0.5604283436590641, 1.9017210111787433, 0.16787049177823252>, BranchRadius(0.15134915068767152)
  <0.6920732594169937, 1.9568080712817333, 0.2144449941050103>, BranchRadius(0.1501137978424696)
  <0.7541049933632914, 1.9838477354935817, 0.23774129738314284>, BranchRadius(0.07156673251938017)
  <0.8113779940299426, 2.0148419881611423, 0.2657398975536155>, BranchRadius(0.07088555505382463)
  <0.8606049904970303, 2.032878903461924, 0.2579124925473412>, BranchRadius(0.05300844992895456)
  <0.9086645309029125, 2.053140049426034, 0.2515296663064942>, BranchRadius(0.05254497055498681)
  <0.9519023161238813, 2.081840119803096, 0.255516357360522>, BranchRadius(0.05204895595516968)
  <0.9907388798207554, 2.108706215715956, 0.27615479564564016>, BranchRadius(0.05153650089236736)
  <1.0294795541859465, 2.138567774142431, 0.2909181563254089>, BranchRadius(0.051093143771826124)
  <1.072059830412941, 2.1655921666776448, 0.2862276686368525>, BranchRadius(0.05064976199569911)
  <1.1186038268823872, 2.178911553575667, 0.2727551859125905>, BranchRadius(0.050251939917206834)
  <1.14549053174083, 2.177296145741159, 0.270076270421567>, BranchRadius(0.0270680813657865)
  <1.1571817760469247, 2.176648630567911, 0.2687098662165478>, BranchRadius(0.01178861865427305)
  <1.1688164870485596, 2.17582069369602, 0.26749003713644576>, BranchRadius(0.011727743284198367)
  <1.1804070120001797, 2.1747104327725926, 0.2673773018125769>, BranchRadius(0.011644125438411767)
  <1.185192266392728, 2.1726686054886186, 0.26824982995593133>, BranchRadius(0.005275322134233073)
  <1.1872804706865319, 2.1710889120516694, 0.268596694410971>, BranchRadius(0.0026412768649975212)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.1688164870485596, 2.17582069369602, 0.26749003713644576>, BranchRadius(0.011727743284198367)
  <1.1804070120001797, 2.1747104327725926, 0.2673773018125769>, BranchRadius(0.011644125438411767)
  <1.1869386953306817, 2.176192061115392, 0.2660906407582667>, BranchRadius(0.006820088441129232)
  <1.19101632772167, 2.1746521088592092, 0.26746865383751256>, BranchRadius(0.004571373854098112)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.1186038268823872, 2.178911553575667, 0.2727551859125905>, BranchRadius(0.050251939917206834)
  <1.14549053174083, 2.177296145741159, 0.270076270421567>, BranchRadius(0.0270680813657865)
  <1.1652885524534664, 2.1747507473621224, 0.27307905249394526>, BranchRadius(0.020185573492476672)
  <1.1700082504654892, 2.1679633943105823, 0.270686913562513>, BranchRadius(0.008606162875417631)
  <1.1742312977277412, 2.16486222831996, 0.27007156925514775>, BranchRadius(0.005275415367268535)
  <1.177854891759477, 2.1637798567681363, 0.2685091675553759>, BranchRadius(0.00409182855878403)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <1.14549053174083, 2.177296145741159, 0.270076270421567>, BranchRadius(0.0270680813657865)
  <1.1652885524534664, 2.1747507473621224, 0.27307905249394526>, BranchRadius(0.020185573492476672)
  <1.1765297625745164, 2.1803972826729936, 0.27835023058115016>, BranchRadius(0.013639409240489104)
  <1.188217259789944, 2.1841632456218685, 0.2840190705198092>, BranchRadius(0.013524637309113416)
  <1.1988446244845758, 2.1867753302007857, 0.29177905857317293>, BranchRadius(0.013415710223035969)
  <1.2041962577680354, 2.1897329131165275, 0.2966887212855543>, BranchRadius(0.007841687538627637)
  <1.2092888613838415, 2.1908224095825526, 0.30247017675812604>, BranchRadius(0.007781185097305688)
  <1.2130498305423723, 2.1947085063456178, 0.3080020189324573>, BranchRadius(0.007736143412905203)
  <1.2157458587247385, 2.1972377268876215, 0.3116931252471049>, BranchRadius(0.00522396308718189)
  <1.2168821947540944, 2.200250611053561, 0.3157613827394626>, BranchRadius(0.00518839566659143)
  <1.2169468017043161, 2.2027315632106808, 0.32026626673202524>, BranchRadius(0.005143274973242282)
  <1.2162759643097314, 2.205681659011349, 0.3243810099619714>, BranchRadius(0.005107269318479286)
  <1.2158522429649223, 2.208424591221012, 0.3286347649575683>, BranchRadius(0.005079138553674213)
  <1.2140503308999568, 2.209731315185849, 0.3331556269093153>, BranchRadius(0.005039107797706023)
  <1.2111346762592388, 2.2083166098401397, 0.3354497254677035>, BranchRadius(0.003970556811672524)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <1.188217259789944, 2.1841632456218685, 0.2840190705198092>, BranchRadius(0.013524637309113416)
  <1.1988446244845758, 2.1867753302007857, 0.29177905857317293>, BranchRadius(0.013415710223035969)
  <1.2057461506811946, 2.18434705365238, 0.29430195635981454>, BranchRadius(0.0077390312106873915)
  <1.2118746600947068, 2.181706164272972, 0.29811062290398>, BranchRadius(0.0076836752397809365)
  <1.2181029127493623, 2.1791269742276507, 0.3016380956591253>, BranchRadius(0.007608312326554277)
  <1.2224088340180634, 2.1739645706224984, 0.305035648446529>, BranchRadius(0.007532246271726545)
  <1.224968919388677, 2.170357918319822, 0.3070869632482822>, BranchRadius(0.004875435401389582)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.072059830412941, 2.1655921666776448, 0.2862276686368525>, BranchRadius(0.05064976199569911)
  <1.1186038268823872, 2.178911553575667, 0.2727551859125905>, BranchRadius(0.050251939917206834)
  <1.1351139400329022, 2.192879580987232, 0.2629088539724793>, BranchRadius(0.023762152231813733)
  <1.1454942265118873, 2.212741923298587, 0.25547945940360206>, BranchRadius(0.023610567404010064)
  <1.1507161266582027, 2.2207651392507146, 0.2568264277302478>, BranchRadius(0.009667189820498339)
  <1.1525374316490682, 2.229618157374022, 0.2600419141112967>, BranchRadius(0.00959335365907411)
  <1.1513865100222416, 2.233967902808734, 0.26506300693047713>, BranchRadius(0.006742127189301524)
  <1.1509485996540834, 2.2363433567187827, 0.27131713373450467>, BranchRadius(0.00670437535122877)
  <1.1496918175072515, 2.2382220809425366, 0.27525974669785547>, BranchRadius(0.004544590526361768)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <1.1351139400329022, 2.192879580987232, 0.2629088539724793>, BranchRadius(0.023762152231813733)
  <1.1454942265118873, 2.212741923298587, 0.25547945940360206>, BranchRadius(0.023610567404010064)
  <1.1489219440331229, 2.2207299428476146, 0.24933515192679157>, BranchRadius(0.010644727243599113)
  <1.155898950901779, 2.2273894223415636, 0.24502346919924917>, BranchRadius(0.010564937288909339)
  <1.1604323871223257, 2.2341519882014813, 0.23837646051076433>, BranchRadius(0.010510331368719296)
  <1.1665997354032749, 2.239785040810447, 0.23215698622224076>, BranchRadius(0.010413900659191575)
  <1.1723770532186273, 2.2449654620540263, 0.2253662834661435>, BranchRadius(0.010311537679812036)
  <1.1780765614304622, 2.250137337794443, 0.21860460585710734>, BranchRadius(0.010244656002991424)
  <1.1837275369170341, 2.2552729667141516, 0.2119028111074084>, BranchRadius(0.010159835688527328)
  <1.1839150157526785, 2.25785631989431, 0.20718241508622134>, BranchRadius(0.005384329165651827)
  <1.1854651647130792, 2.259628834193527, 0.20237605084948612>, BranchRadius(0.005352187021818851)
  <1.1853947862048022, 2.261100493067146, 0.19728339306916917>, BranchRadius(0.005301499433382238)
  <1.1865154391921235, 2.2606105133275336, 0.19215328859727826>, BranchRadius(0.0052738899453570395)
  <1.1876835229720328, 2.2601601180679207, 0.1870825938516764>, BranchRadius(0.005222951350514696)
  <1.189532602074708, 2.259839146829505, 0.18225922799316874>, BranchRadius(0.005175613419572348)
  <1.1926585008023827, 2.259586590090191, 0.17818379407105742>, BranchRadius(0.005142391410204668)
  <1.1943021204223438, 2.258401722907406, 0.17557457033554602>, BranchRadius(0.0033035502414703074)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <1.1780765614304622, 2.250137337794443, 0.21860460585710734>, BranchRadius(0.010244656002991424)
  <1.1837275369170341, 2.2552729667141516, 0.2119028111074084>, BranchRadius(0.010159835688527328)
  <1.1878276985482534, 2.25864748198736, 0.20769587056285718>, BranchRadius(0.0067747344949179)
  <1.191754698125577, 2.259787897250892, 0.20237958622106758>, BranchRadius(0.006707067306681391)
  <1.1955052492126734, 2.262204676679044, 0.1974427522239078>, BranchRadius(0.006654305837333467)
  <1.1984299109907781, 2.2667386383978694, 0.19362833174584682>, BranchRadius(0.006607591010915474)
  <1.2002179607374925, 2.268743233888045, 0.19228466337072528>, BranchRadius(0.003003492912969772)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <1.1955052492126734, 2.262204676679044, 0.1974427522239078>, BranchRadius(0.006654305837333467)
  <1.1984299109907781, 2.2667386383978694, 0.19362833174584682>, BranchRadius(0.006607591010915474)
  <1.2003233124340171, 2.2702530107028673, 0.19041297424234416>, BranchRadius(0.005125846817719594)
  <1.2006763834349343, 2.2745393791051334, 0.18771156997900731>, BranchRadius(0.005078897341511189)
  <1.1997306111305872, 2.279364265121865, 0.186556856467088>, BranchRadius(0.005050482513654839)
  <1.1996018473028969, 2.2843543479082484, 0.18618328572811269>, BranchRadius(0.005005702891233279)
  <1.1993382294613044, 2.289095714070398, 0.18469086009715152>, BranchRadius(0.0049776883906017646)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  18
  <0.7541049933632914, 1.9838477354935817, 0.23774129738314284>, BranchRadius(0.07156673251938017)
  <0.8113779940299426, 2.0148419881611423, 0.2657398975536155>, BranchRadius(0.07088555505382463)
  <0.8247496843944833, 2.0270502263605037, 0.29070824722099126>, BranchRadius(0.03084253018560302)
  <0.8366459005707928, 2.035326279008707, 0.3176098678442378>, BranchRadius(0.030556671921307333)
  <0.8486708691949577, 2.0297816779158664, 0.34485012125363457>, BranchRadius(0.03028818049172046)
  <0.8686156020746603, 2.030423055181828, 0.3673127011083832>, BranchRadius(0.03004615163662294)
  <0.8766027892212079, 2.031624319466593, 0.39598298761208683>, BranchRadius(0.029786297564488917)
  <0.8748290881416897, 2.0417895894760227, 0.40653315425887665>, BranchRadius(0.014757531845099758)
  <0.8754317192611808, 2.0521862287920944, 0.4168418558054954>, BranchRadius(0.014653416015111671)
  <0.878532322741515, 2.0608219729520245, 0.4280941826336353>, BranchRadius(0.01451911423556214)
  <0.8804769934959001, 2.063281865154295, 0.4421727571392344>, BranchRadius(0.014423559688906708)
  <0.8814499095578305, 2.0642097576335394, 0.44778756964910765>, BranchRadius(0.005773531816629304)
  <0.8807099119743892, 2.066867081714832, 0.4527986869815888>, BranchRadius(0.005720162988622719)
  <0.8808784877161225, 2.0694719735834934, 0.45785020031800644>, BranchRadius(0.005686094126562143)
  <0.8794421394410887, 2.071280233358602, 0.4629890877694786>, BranchRadius(0.005633920839022046)
  <0.8780109213045124, 2.0730808454760274, 0.4680933256216389>, BranchRadius(0.005598556367788986)
  <0.8755272147361111, 2.075688613445606, 0.4723425085511776>, BranchRadius(0.0055699917118217325)
  <0.874485068933317, 2.0776347560293726, 0.47381758473750146>, BranchRadius(0.002655068471074152)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <0.878532322741515, 2.0608219729520245, 0.4280941826336353>, BranchRadius(0.01451911423556214)
  <0.8804769934959001, 2.063281865154295, 0.4421727571392344>, BranchRadius(0.014423559688906708)
  <0.8780136486118852, 2.0661139499567978, 0.45240463352730353>, BranchRadius(0.010898626829417427)
  <0.8748235461815319, 2.0648763126785825, 0.462645177731452>, BranchRadius(0.010797094291784819)
  <0.8727193114236516, 2.059731736470869, 0.4718153057956421>, BranchRadius(0.010723139325164575)
  <0.8728033576551903, 2.0563131426313426, 0.47847778782495903>, BranchRadius(0.007488825969379543)
  <0.8706387264688996, 2.0577027037671387, 0.4837254613118097>, BranchRadius(0.005844192446127456)
  <0.8670883177421203, 2.060425689878704, 0.48741562918626535>, BranchRadius(0.005799775377773912)
  <0.8634063650587601, 2.062739830689226, 0.49119016632579415>, BranchRadius(0.005758398550908886)
  <0.8606424288153324, 2.066281600809638, 0.49470397977887437>, BranchRadius(0.005703539613838405)
  <0.8559250060991965, 2.068196595203136, 0.4971671489043737>, BranchRadius(0.005655836167239582)
  <0.8529483992086383, 2.0708409887036665, 0.501143689146329>, BranchRadius(0.005627244251181605)
  <0.8512676827757275, 2.070579715256011, 0.5035534974511805>, BranchRadius(0.002949618214013054)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.8748235461815319, 2.0648763126785825, 0.462645177731452>, BranchRadius(0.010797094291784819)
  <0.8727193114236516, 2.059731736470869, 0.4718153057956421>, BranchRadius(0.010723139325164575)
  <0.8687469446643302, 2.0562934766329506, 0.4769591415483893>, BranchRadius(0.007352576054339236)
  <0.864624723145632, 2.056405539044876, 0.4793746085800382>, BranchRadius(0.004779095020437267)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.8686156020746603, 2.030423055181828, 0.3673127011083832>, BranchRadius(0.03004615163662294)
  <0.8766027892212079, 2.031624319466593, 0.39598298761208683>, BranchRadius(0.029786297564488917)
  <0.8842013564586672, 2.0233149258149052, 0.4079302939415895>, BranchRadius(0.01641713663986109)
  <0.8890816656210851, 2.0202541782123897, 0.4118150713566501>, BranchRadius(0.006948171627964425)
  <0.8939405728871509, 2.0172444359203228, 0.4156568202510392>, BranchRadius(0.0068866946391156975)
  <0.8988559032264897, 2.0143074735545157, 0.4193856849184266>, BranchRadius(0.006833055831081873)
  <0.9033776138496838, 2.0103209693604387, 0.4224575835353034>, BranchRadius(0.006765696103260154)
  <0.9073006789807623, 2.0066146261350686, 0.42646455221402413>, BranchRadius(0.0067218463326068345)
  <0.9086610054653488, 2.006029112039837, 0.4290582330274245>, BranchRadius(0.002986719783003404)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  20
  <0.8766027892212079, 2.031624319466593, 0.39598298761208683>, BranchRadius(0.029786297564488917)
  <0.8842013564586672, 2.0233149258149052, 0.4079302939415895>, BranchRadius(0.01641713663986109)
  <0.880967460609396, 2.0172781815589937, 0.41878018488544244>, BranchRadius(0.012830451943276115)
  <0.8815366567972228, 2.0134076906155314, 0.4260682586708742>, BranchRadius(0.008271680841616145)
  <0.8825218570179783, 2.009616561227209, 0.43328051700304504>, BranchRadius(0.008207310872870842)
  <0.8844791423002815, 2.006142103300852, 0.44038933244864864>, BranchRadius(0.008150955808860575)
  <0.8880794233653106, 2.000768394444569, 0.44526199701892566>, BranchRadius(0.008098248615208924)
  <0.8904130623939213, 1.9944506881160216, 0.44961793153612395>, BranchRadius(0.008020813542761197)
  <0.8943402800172865, 1.9886807349143751, 0.453414565051587>, BranchRadius(0.007945427884085119)
  <0.8952364300078641, 1.9828903628336354, 0.45867185099877>, BranchRadius(0.00787213752226608)
  <0.896459140384269, 1.976936848357503, 0.46360024140475947>, BranchRadius(0.007824857013130355)
  <0.8988707380338368, 1.9721592361520108, 0.46920579109737615>, BranchRadius(0.007750068965232658)
  <0.9035588766402254, 1.9679322092733902, 0.47359384204720223>, BranchRadius(0.007687742904361594)
  <0.9091754429350821, 1.9676388499213178, 0.4757454734608616>, BranchRadius(0.006021743467984564)
  <0.9139866416374143, 1.9662044657707325, 0.47900616223893394>, BranchRadius(0.005986416469994305)
  <0.9192892543797642, 1.9646430069327026, 0.4812157914752243>, BranchRadius(0.005953009067695253)
  <0.9246491501104726, 1.9624757130568629, 0.4824697216981934>, BranchRadius(0.005915909565941177)
  <0.9299555027773649, 1.960327697384984, 0.48372117962932587>, BranchRadius(0.005859820552326415)
  <0.9349331757957333, 1.9594291858655009, 0.4865944984097077>, BranchRadius(0.005817259874041294)
  <0.936405878607565, 1.9609747558668345, 0.4893076959970482>, BranchRadius(0.0034524022576967253)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.8842013564586672, 2.0233149258149052, 0.4079302939415895>, BranchRadius(0.01641713663986109)
  <0.880967460609396, 2.0172781815589937, 0.41878018488544244>, BranchRadius(0.012830451943276115)
  <0.877419117909394, 2.013672804144553, 0.42505725993652194>, BranchRadius(0.008061709087662685)
  <0.874744168925229, 2.013295128716877, 0.4325810087850466>, BranchRadius(0.007994047005880797)
  <0.8707782226570605, 2.011124631027962, 0.43909664222411604>, BranchRadius(0.00793052767045834)
  <0.8669248464131639, 2.008997170246505, 0.44562609912098305>, BranchRadius(0.007874541588036101)
  <0.8640512696946981, 2.005503325264706, 0.4519947434298641>, BranchRadius(0.00781178764731821)
  <0.8620772094475678, 2.000432322158766, 0.4574995948230831>, BranchRadius(0.007740502258973811)
  <0.8622733193218899, 1.996685274235869, 0.45944401309602534>, BranchRadius(0.004226060770912433)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  23
  <0.5604283436590641, 1.9017210111787433, 0.16787049177823252>, BranchRadius(0.15134915068767152)
  <0.6920732594169937, 1.9568080712817333, 0.2144449941050103>, BranchRadius(0.1501137978424696)
  <0.7977599465254408, 1.9765771594913417, 0.22132926815766657>, BranchRadius(0.10773989934017082)
  <0.8410363327404272, 1.9464038084799613, 0.22170520386650974>, BranchRadius(0.052758108786629426)
  <0.8771816117558607, 1.909300963026832, 0.2289442663031919>, BranchRadius(0.052302068417840866)
  <0.9157343241275367, 1.8752003547514555, 0.235908026458615>, BranchRadius(0.05193897449378566)
  <0.9441905182804226, 1.8525358673675985, 0.24035618281328325>, BranchRadius(0.03664996683484616)
  <0.9774732968357788, 1.838200451285093, 0.23646827129395914>, BranchRadius(0.036446719449156575)
  <1.0005910153311288, 1.8432846664032254, 0.2458209330218381>, BranchRadius(0.02545094169561951)
  <1.0255104452816934, 1.8466692395557636, 0.24772137570598377>, BranchRadius(0.02521993272952379)
  <1.050502945054224, 1.846840583642016, 0.24995812527249567>, BranchRadius(0.02509297615467584)
  <1.0743341818641805, 1.8441965963238622, 0.2433543309172977>, BranchRadius(0.02487023555812307)
  <1.08408213694679, 1.8526172512092796, 0.24180824388067523>, BranchRadius(0.012973836830971908)
  <1.086654674498808, 1.8583841003916233, 0.2472894238638744>, BranchRadius(0.008361688403466416)
  <1.0873955506589532, 1.865305139160117, 0.25183221059045724>, BranchRadius(0.008311834115457436)
  <1.0911094858784656, 1.8717574641256305, 0.25534305107251265>, BranchRadius(0.008231148957816502)
  <1.0939434454281693, 1.877868492622246, 0.2599805719906716>, BranchRadius(0.008178178053953348)
  <1.09588107099595, 1.884783786795642, 0.2638057780816555>, BranchRadius(0.008136822966245695)
  <1.0947876891016786, 1.8879230757892118, 0.2680728568941004>, BranchRadius(0.005409120163527991)
  <1.0928844767500037, 1.890267985372274, 0.2725220096559923>, BranchRadius(0.005377339352036032)
  <1.092192796998084, 1.8937655115136742, 0.276505439513792>, BranchRadius(0.00534591651833463)
  <1.092157307536733, 1.897478859098123, 0.28028268077383295>, BranchRadius(0.005296957742077527)
  <1.0921561468932768, 1.8979529621312181, 0.2825847178796234>, BranchRadius(0.0023503510098534775)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.0743341818641805, 1.8441965963238622, 0.2433543309172977>, BranchRadius(0.02487023555812307)
  <1.08408213694679, 1.8526172512092796, 0.24180824388067523>, BranchRadius(0.012973836830971908)
  <1.0908410381881484, 1.8578709298944713, 0.23976442221273822>, BranchRadius(0.008801198368858993)
  <1.0941685928952014, 1.8603912909898888, 0.23926513794967783>, BranchRadius(0.004204060555589663)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.08408213694679, 1.8526172512092796, 0.24180824388067523>, BranchRadius(0.012973836830971908)
  <1.0908410381881484, 1.8578709298944713, 0.23976442221273822>, BranchRadius(0.008801198368858993)
  <1.0944304775177194, 1.8610262186892266, 0.2358797058988416>, BranchRadius(0.006158810186913761)
  <1.097584109966561, 1.8640199303265224, 0.23159960942441613>, BranchRadius(0.00610138777820734)
  <1.0993329388601842, 1.865652774263872, 0.22920394624865129>, BranchRadius(0.003385821004516584)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <1.050502945054224, 1.846840583642016, 0.24995812527249567>, BranchRadius(0.02509297615467584)
  <1.0743341818641805, 1.8441965963238622, 0.2433543309172977>, BranchRadius(0.02487023555812307)
  <1.088201111749072, 1.8352144063979743, 0.23860681294391192>, BranchRadius(0.01719041614402743)
  <1.1030026173275673, 1.8270382330529165, 0.2409225659180783>, BranchRadius(0.017067427743981418)
  <1.113178691642313, 1.82555764239342, 0.24306857769923765>, BranchRadius(0.010504761002759063)
  <1.1232961114360323, 1.823566313828854, 0.24475951792043407>, BranchRadius(0.010449251244278684)
  <1.133450315979771, 1.8218087783297459, 0.24606781392000696>, BranchRadius(0.010387898698447645)
  <1.1368921561461942, 1.8162840733636096, 0.2448260470685368>, BranchRadius(0.006626508402429112)
  <1.140509644775632, 1.810986151649637, 0.24331849919171963>, BranchRadius(0.006589908881948945)
  <1.1388661775400315, 1.8062959818032722, 0.24273744310642284>, BranchRadius(0.005003629074632105)
  <1.1383479936843615, 1.8028099402858933, 0.2442555769816533>, BranchRadius(0.003837411944564876)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.1232961114360323, 1.823566313828854, 0.24475951792043407>, BranchRadius(0.010449251244278684)
  <1.133450315979771, 1.8218087783297459, 0.24606781392000696>, BranchRadius(0.010387898698447645)
  <1.1394304637673969, 1.821723963697685, 0.24716320666846406>, BranchRadius(0.0060802340709079595)
  <1.1452478472721204, 1.8229019592288362, 0.24829966740385295>, BranchRadius(0.00604327455238659)
  <1.1508025038302272, 1.8244717706664642, 0.2498817720849844>, BranchRadius(0.005985112584595701)
  <1.152128435039274, 1.8246446772845173, 0.2527081164535362>, BranchRadius(0.003126693582578133)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.088201111749072, 1.8352144063979743, 0.23860681294391192>, BranchRadius(0.01719041614402743)
  <1.1030026173275673, 1.8270382330529165, 0.2409225659180783>, BranchRadius(0.017067427743981418)
  <1.1085332214367576, 1.8211327945425617, 0.24140652211377417>, BranchRadius(0.008105306867202743)
  <1.110891780589435, 1.8194565654306971, 0.23845122230713622>, BranchRadius(0.0041359814142782215)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.1030026173275673, 1.8270382330529165, 0.2409225659180783>, BranchRadius(0.017067427743981418)
  <1.1085332214367576, 1.8211327945425617, 0.24140652211377417>, BranchRadius(0.008105306867202743)
  <1.1106368976873213, 1.8178564301331983, 0.2454578183352817>, BranchRadius(0.005618987327315344)
  <1.1130365166682483, 1.8139737679662358, 0.2486615673786225>, BranchRadius(0.005576490355868594)
  <1.11502783214036, 1.8103649100678125, 0.25235308009850943>, BranchRadius(0.005533214147452644)
  <1.114924415815217, 1.806594962666606, 0.2526243469391302>, BranchRadius(0.0037811088377604943)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  30
  <0.9441905182804226, 1.8525358673675985, 0.24035618281328325>, BranchRadius(0.03664996683484616)
  <0.9774732968357788, 1.838200451285093, 0.23646827129395914>, BranchRadius(0.036446719449156575)
  <0.9826588931766345, 1.8187010357666633, 0.2220267933723465>, BranchRadius(0.024812776941146628)
  <0.9862590780280927, 1.7982238120150809, 0.20892529256982464>, BranchRadius(0.02457493330236161)
  <0.9812870346892564, 1.7787398875635747, 0.19515581805516435>, BranchRadius(0.02437094490177065)
  <0.9707258149782356, 1.7619132237434327, 0.1813293244301402>, BranchRadius(0.024204295136676855)
  <0.9676844625831734, 1.7517480099753917, 0.1684113178779958>, BranchRadius(0.016716946151201357)
  <0.9598013953231, 1.74252953660025, 0.15711141046949395>, BranchRadius(0.01657742164016328)
  <0.9470933774676648, 1.7387553702319833, 0.14737081455912798>, BranchRadius(0.01645044857377625)
  <0.9355635706870782, 1.7319733834957456, 0.13801562779979645>, BranchRadius(0.01632333629470817)
  <0.9354338463237408, 1.7277794075608734, 0.12952341691197866>, BranchRadius(0.009472270494232174)
  <0.9353425061022702, 1.727577908175186, 0.1201451385973976>, BranchRadius(0.009380887441187643)
  <0.9318755654693555, 1.7253265090893106, 0.11179850629701088>, BranchRadius(0.009314222777768177)
  <0.9326939115264117, 1.722836355117135, 0.10292216661917557>, BranchRadius(0.009255266779005084)
  <0.9316198176235152, 1.7212398329719436, 0.09601242763072047>, BranchRadius(0.007172660145364644)
  <0.9295688978246253, 1.7224709921983201, 0.08931562505556248>, BranchRadius(0.007111201712285553)
  <0.925672380837529, 1.7250123397408113, 0.08398830810692057>, BranchRadius(0.007072594844450141)
  <0.920430484451455, 1.7263595027363516, 0.07949992560150504>, BranchRadius(0.007031209239797137)
  <0.915159892608334, 1.7279381276191437, 0.07521781232201362>, BranchRadius(0.0069719214737216945)
  <0.9097677987168311, 1.7294059059763365, 0.07110881425332306>, BranchRadius(0.006936347379502343)
  <0.9053336254441778, 1.7338532554050703, 0.06827654058232428>, BranchRadius(0.006889309377622943)
  <0.8992175865847408, 1.7367772680559241, 0.06732945002720124>, BranchRadius(0.006844907729991729)
  <0.8944903362876515, 1.7413986155191983, 0.0657574043225612>, BranchRadius(0.0067952244587738105)
  <0.8886075978584366, 1.7446806274699274, 0.06522806369205567>, BranchRadius(0.006757101107308807)
  <0.8821045690999804, 1.7462653414213414, 0.06561127616380129>, BranchRadius(0.0067042936346505206)
  <0.876119998356994, 1.746624576666266, 0.06846067924794255>, BranchRadius(0.00663801437742635)
  <0.8700873203614825, 1.747146284458376, 0.07106274745402155>, BranchRadius(0.006590610120995086)
  <0.863867802010755, 1.7490475324914891, 0.07162773495353483>, BranchRadius(0.0065281209756758475)
  <0.8574865220054666, 1.7497067947731575, 0.07079138445247023>, BranchRadius(0.00646953193226171)
  <0.8546132686567193, 1.7522501919374691, 0.06956539850637865>, BranchRadius(0.004028336565076233)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.9470933774676648, 1.7387553702319833, 0.14737081455912798>, BranchRadius(0.01645044857377625)
  <0.9355635706870782, 1.7319733834957456, 0.13801562779979645>, BranchRadius(0.01632333629470817)
  <0.9254239764742579, 1.7299752869698701, 0.13786677871857203>, BranchRadius(0.010335662367567737)
  <0.9219813268962331, 1.7283470665348033, 0.13481134306912101>, BranchRadius(0.004882481429578574)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.9355635706870782, 1.7319733834957456, 0.13801562779979645>, BranchRadius(0.01632333629470817)
  <0.9254239764742579, 1.7299752869698701, 0.13786677871857203>, BranchRadius(0.010335662367567737)
  <0.9209982010208977, 1.7307804405533205, 0.14310819412234346>, BranchRadius(0.006907111993547037)
  <0.9171403269244885, 1.7333097476781887, 0.14815694135873972>, BranchRadius(0.006838891411089388)
  <0.9123529131255004, 1.7327653875379627, 0.15295811307956178>, BranchRadius(0.006801978295895267)
  <0.9084887773724292, 1.7335570873559305, 0.15843786838593793>, BranchRadius(0.006751744362584444)
  <0.9076229780870658, 1.7342019572872232, 0.16289901185364622>, BranchRadius(0.004589909222446279)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  19
  <0.9812870346892564, 1.7787398875635747, 0.19515581805516435>, BranchRadius(0.02437094490177065)
  <0.9707258149782356, 1.7619132237434327, 0.1813293244301402>, BranchRadius(0.024204295136676855)
  <0.964429203662643, 1.7539756348651856, 0.176604474923539>, BranchRadius(0.011179303829834541)
  <0.9592501396298293, 1.7456385789031534, 0.17137583715726226>, BranchRadius(0.011120605166130837)
  <0.9518057835842781, 1.7403307506592949, 0.16520891090005743>, BranchRadius(0.011028257208690747)
  <0.9426320145001905, 1.7357445588111482, 0.16144540899957893>, BranchRadius(0.010924977868676654)
  <0.9335373943643669, 1.7310539492906596, 0.1577849202853671>, BranchRadius(0.010867985586827911)
  <0.9280091580832638, 1.7253844100137798, 0.1504409778418716>, BranchRadius(0.010799933453737679)
  <0.9249551552018892, 1.7207950772202878, 0.14577127148754748>, BranchRadius(0.007224615320173153)
  <0.9220594244068335, 1.716124943692214, 0.14114159187292652>, BranchRadius(0.007185355756085444)
  <0.9175877132198285, 1.710973779913992, 0.13906621568245164>, BranchRadius(0.0071300684107546905)
  <0.9132161686121308, 1.7054422110179321, 0.13856722860722506>, BranchRadius(0.007068072213141853)
  <0.9114347874370875, 1.6987472212616428, 0.13751537533889682>, BranchRadius(0.007007324883699206)
  <0.9078891682111863, 1.6928482457628018, 0.13849632276568255>, BranchRadius(0.006952092166040658)
  <0.9056869380368333, 1.6876837241927023, 0.14248131835894787>, BranchRadius(0.006884932146884013)
  <0.9050500648887191, 1.6830370067999771, 0.14746193119030446>, BranchRadius(0.00684135177508922)
  <0.9058110079606154, 1.6785472140583728, 0.15247858729969718>, BranchRadius(0.006775257319182551)
  <0.9070526406133853, 1.6750386214390567, 0.1580704244494091>, BranchRadius(0.00671718069740891)
  <0.9064126185808847, 1.6736117387677243, 0.16200205858796674>, BranchRadius(0.0042312373319522405)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.9335373943643669, 1.7310539492906596, 0.1577849202853671>, BranchRadius(0.010867985586827911)
  <0.9280091580832638, 1.7253844100137798, 0.1504409778418716>, BranchRadius(0.010799933453737679)
  <0.9241283979528452, 1.7249989860743435, 0.1467967626560593>, BranchRadius(0.00533752331362046)
  <0.9222961749382741, 1.727599626914823, 0.14522763350274434>, BranchRadius(0.00354718765447737)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <0.8771816117558607, 1.909300963026832, 0.2289442663031919>, BranchRadius(0.052302068417840866)
  <0.9157343241275367, 1.8752003547514555, 0.235908026458615>, BranchRadius(0.05193897449378566)
  <0.936835791464912, 1.849779453574868, 0.24158521754239037>, BranchRadius(0.03352200231224034)
  <0.9455449042715719, 1.8336641904435167, 0.24100403424863143>, BranchRadius(0.018327250903852347)
  <0.9515623264034562, 1.8236963222139848, 0.2428515871221479>, BranchRadius(0.011789029551877417)
  <0.9566459532981391, 1.8166411067633095, 0.24041319262266148>, BranchRadius(0.009031339612422862)
  <0.9636233907701236, 1.8111334264235726, 0.23912049972705332>, BranchRadius(0.00898277414402329)
  <0.9703787133793053, 1.805351682618274, 0.2388946516382496>, BranchRadius(0.008894602427508684)
  <0.9774946061495721, 1.8001357561082645, 0.23876081627037987>, BranchRadius(0.008823816134839136)
  <0.9841087473413931, 1.7946743488683903, 0.23691999686629908>, BranchRadius(0.008772824449601969)
  <0.987254628008563, 1.7914246939297174, 0.23607368578015267>, BranchRadius(0.0046014198729358085)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.9774946061495721, 1.8001357561082645, 0.23876081627037987>, BranchRadius(0.008823816134839136)
  <0.9841087473413931, 1.7946743488683903, 0.23691999686629908>, BranchRadius(0.008772824449601969)
  <0.9897769533388887, 1.792534204196393, 0.23522854768120355>, BranchRadius(0.006290451398181508)
  <0.9954624743494456, 1.7903831095654423, 0.23662454186953344>, BranchRadius(0.006237079207981838)
  <0.9997845446339089, 1.7869380426072183, 0.23943834794539035>, BranchRadius(0.0062021191961309325)
  <1.0045246552145117, 1.7841398975951877, 0.2422155950724128>, BranchRadius(0.006165335792091856)
  <1.009329796615478, 1.7816128970655516, 0.2450335841986801>, BranchRadius(0.006116876513043286)
  <1.0150406196753692, 1.7802731871894508, 0.24656832135040735>, BranchRadius(0.006063311034278082)
  <1.0207373837782108, 1.7788804100673414, 0.2452012213508537>, BranchRadius(0.006021786426308564)
  <1.023735449493802, 1.7786884770684728, 0.24304393807956262>, BranchRadius(0.0036985277373099076)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.9455449042715719, 1.8336641904435167, 0.24100403424863143>, BranchRadius(0.018327250903852347)
  <0.9515623264034562, 1.8236963222139848, 0.2428515871221479>, BranchRadius(0.011789029551877417)
  <0.9540924698933105, 1.8192985944305646, 0.24423319890745163>, BranchRadius(0.005258373024197557)
  <0.9534042637534906, 1.8168016640272056, 0.24392503955782047>, BranchRadius(0.002608304298748424)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  20
  <0.936835791464912, 1.849779453574868, 0.24158521754239037>, BranchRadius(0.03352200231224034)
  <0.9455449042715719, 1.8336641904435167, 0.24100403424863143>, BranchRadius(0.018327250903852347)
  <0.9474311279413958, 1.8267980935218484, 0.23437043992485088>, BranchRadius(0.009731685379359563)
  <0.95085746181927, 1.8193471064515856, 0.22929064303099578>, BranchRadius(0.009646828942544398)
  <0.9530142427739734, 1.8117161989910204, 0.2239101329908084>, BranchRadius(0.009582919234285517)
  <0.955204002748153, 1.804089712188694, 0.218624775812699>, BranchRadius(0.009533800406488926)
  <0.9575933289458113, 1.7973636240137538, 0.2124166914807041>, BranchRadius(0.009459886515653784)
  <0.9614906229653214, 1.791441139666063, 0.2062516610848484>, BranchRadius(0.009395335082102036)
  <0.9676054100957308, 1.7875919768793496, 0.20036127526878947>, BranchRadius(0.00932219506719674)
  <0.9736581522416738, 1.7837696505762541, 0.19452915979916557>, BranchRadius(0.009233603668321357)
  <0.9818160874742775, 1.7802861235958973, 0.19227773416280444>, BranchRadius(0.009151818665068402)
  <0.9892242564773155, 1.775025424531624, 0.19259598999563426>, BranchRadius(0.00909160103598653)
  <0.9937139318042847, 1.767391561710093, 0.19082690682549797>, BranchRadius(0.009031207083353145)
  <1.0004233492597039, 1.7616723454171512, 0.19239361601596636>, BranchRadius(0.008954345050534593)
  <1.0068336005132867, 1.7557243827919233, 0.1940829064774936>, BranchRadius(0.008906361927778196)
  <1.013672795382353, 1.7503838595978753, 0.19579961944064564>, BranchRadius(0.008845500429092885)
  <1.0206278007584475, 1.7509820378379088, 0.19692657931457963>, BranchRadius(0.007071064668478924)
  <1.0271978395271177, 1.7505059926905544, 0.19936171655534318>, BranchRadius(0.007022956769445755)
  <1.0325358887081386, 1.7503144350529058, 0.2005031849768165>, BranchRadius(0.005462088752918583)
  <1.0360722613847857, 1.7508263177913808, 0.20084532402882968>, BranchRadius(0.003589570277484097)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.9157343241275367, 1.8752003547514555, 0.235908026458615>, BranchRadius(0.05193897449378566)
  <0.936835791464912, 1.849779453574868, 0.24158521754239037>, BranchRadius(0.03352200231224034)
  <0.9508101593823627, 1.8466667640613978, 0.25248078455611167>, BranchRadius(0.01799125274265331)
  <0.9646726485037909, 1.848717535746254, 0.26359989858400007>, BranchRadius(0.017888794423054567)
  <0.9710766479984149, 1.8500409432950766, 0.2719829149049276>, BranchRadius(0.010631913266405184)
  <0.9779972954009593, 1.8519182410338624, 0.27975625557235057>, BranchRadius(0.010575652812106012)
  <0.9870245437361438, 1.8545536698811185, 0.2843823296014047>, BranchRadius(0.01048032721990732)
  <0.9927189264333184, 1.8600976514937164, 0.29112031962164886>, BranchRadius(0.010419320320232735)
  <0.9964137904824856, 1.860871504807523, 0.2938327808519933>, BranchRadius(0.004648474504527245)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.9870245437361438, 1.8545536698811185, 0.2843823296014047>, BranchRadius(0.01048032721990732)
  <0.9927189264333184, 1.8600976514937164, 0.29112031962164886>, BranchRadius(0.010419320320232735)
  <0.9959989138550092, 1.8650403163501654, 0.29602964325783315>, BranchRadius(0.007699981294420369)
  <1.0014595855866009, 1.869217280228088, 0.29932907997284863>, BranchRadius(0.007625761970719262)
  <1.00713890072986, 1.8734497679325643, 0.3019943373830716>, BranchRadius(0.007567837850254329)
  <1.0112350755684938, 1.8792392772473596, 0.30449894956442175>, BranchRadius(0.007521312956773441)
  <1.014040989989388, 1.8861549047352302, 0.30473835645584324>, BranchRadius(0.007467019147426476)
  <1.0152116267164468, 1.8934750287418072, 0.30455091439204207>, BranchRadius(0.007415506749082391)
  <1.0159769305549968, 1.8964234593369522, 0.3020804709736231>, BranchRadius(0.003921992302809442)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.9508101593823627, 1.8466667640613978, 0.25248078455611167>, BranchRadius(0.01799125274265331)
  <0.9646726485037909, 1.848717535746254, 0.26359989858400007>, BranchRadius(0.017888794423054567)
  <0.9717839343512806, 1.8491923193921413, 0.26432030896608444>, BranchRadius(0.007163434723212408)
  <0.9788297195690947, 1.8498089462885612, 0.26489975063944493>, BranchRadius(0.007096412524493107)
  <0.9854397694804672, 1.8478742059430528, 0.26341531280544905>, BranchRadius(0.007045533032948699)
  <0.9918103241950124, 1.8450376944293754, 0.26299550592453586>, BranchRadius(0.006986129311392702)
  <0.9956685124027618, 1.8415773363050738, 0.26120127097787976>, BranchRadius(0.005484430110653102)
  <0.9993965386045773, 1.8378002030039369, 0.2600219938646748>, BranchRadius(0.005436507136545583)
  <1.0037011307001467, 1.8351523277141244, 0.25813961492829157>, BranchRadius(0.005392968303242446)
  <1.0053893473076743, 1.8333412285278579, 0.25575347817393085>, BranchRadius(0.003438575895183756)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <0.6920732594169937, 1.9568080712817333, 0.2144449941050103>, BranchRadius(0.1501137978424696)
  <0.7977599465254408, 1.9765771594913417, 0.22132926815766657>, BranchRadius(0.10773989934017082)
  <0.8456908898014118, 2.046627802138149, 0.22835103889886177>, BranchRadius(0.08516908548820373)
  <0.8901212251862326, 2.0949676751892903, 0.23583518996323585>, BranchRadius(0.06608184732710232)
  <0.9185500412191963, 2.1528188479404737, 0.24801225803149152>, BranchRadius(0.065599060637042)
  <0.9472361233270825, 2.168220206970209, 0.24487095846745927>, BranchRadius(0.03271025725386732)
  <0.9558855305341527, 2.1772307624147413, 0.2391527000936675>, BranchRadius(0.013736842187422667)
  <0.9659682828455122, 2.1853019305976193, 0.23469268797946946>, BranchRadius(0.013663724165370254)
  <0.977485629507328, 2.192361480128536, 0.23318642056481612>, BranchRadius(0.013592474213047231)
  <0.9887863758843718, 2.198981296191579, 0.22985940893425524>, BranchRadius(0.013512876813494527)
  <0.9998359808808271, 2.204904955970464, 0.2251260696723326>, BranchRadius(0.013401045344380035)
  <1.0120535503463135, 2.209252366467044, 0.22218666169288648>, BranchRadius(0.013296958334122483)
  <1.0166267203956783, 2.2093644931366967, 0.21695326921180536>, BranchRadius(0.006950888687893813)
  <1.019864667600454, 2.208993135050489, 0.21085546397925206>, BranchRadius(0.006914147639677743)
  <1.0207957524678561, 2.2058574689226527, 0.20673594498706424>, BranchRadius(0.005260205112213834)
  <1.0212039244709241, 2.2025135141864034, 0.20276439816029776>, BranchRadius(0.005207861543798231)
  <1.019126021881966, 2.199399147035273, 0.2021808702208518>, BranchRadius(0.0037891248036126786)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.9998359808808271, 2.204904955970464, 0.2251260696723326>, BranchRadius(0.013401045344380035)
  <1.0120535503463135, 2.209252366467044, 0.22218666169288648>, BranchRadius(0.013296958334122483)
  <1.02044944129761, 2.212955549494845, 0.22211890292545716>, BranchRadius(0.009176553855016735)
  <1.025288568088779, 2.2161077133669065, 0.22269723154596316>, BranchRadius(0.005804114848160538)
  <1.0307938713786877, 2.217780982382567, 0.22307429667115886>, BranchRadius(0.00576631352089766)
  <1.0361963354260046, 2.218831986990069, 0.2215560062766493>, BranchRadius(0.005709328698682672)
  <1.0382537384094246, 2.220062571638151, 0.22323569237845406>, BranchRadius(0.0029272155733524163)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.9185500412191963, 2.1528188479404737, 0.24801225803149152>, BranchRadius(0.065599060637042)
  <0.9472361233270825, 2.168220206970209, 0.24487095846745927>, BranchRadius(0.03271025725386732)
  <0.9639306039707147, 2.175414848057712, 0.24497508045537517>, BranchRadius(0.018179091994017984)
  <0.9815009867627597, 2.177190818331574, 0.2414805079163215>, BranchRadius(0.01800234593333156)
  <0.9888360258232394, 2.1782154622286543, 0.23998008075943836>, BranchRadius(0.00755671719648808)
  <0.9960983040512317, 2.1789953807821494, 0.2382746598806052>, BranchRadius(0.00750049454268302)
  <1.0027521616314248, 2.1817171460790914, 0.2363988918022545>, BranchRadius(0.007429692652653322)
  <1.009846921229962, 2.183186472130168, 0.23497049900290146>, BranchRadius(0.007384770734061383)
  <1.0166583071302298, 2.181251421384836, 0.2330367422707842>, BranchRadius(0.0073402189591583265)
  <1.0180387442063688, 2.180634605909743, 0.2292377363834219>, BranchRadius(0.0040888278985189526)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <1.009846921229962, 2.183186472130168, 0.23497049900290146>, BranchRadius(0.007384770734061383)
  <1.0166583071302298, 2.181251421384836, 0.2330367422707842>, BranchRadius(0.0073402189591583265)
  <1.021931743182414, 2.1798972507628673, 0.23372302642283915>, BranchRadius(0.0054876125780927605)
  <1.0269695693683205, 2.1788028403625113, 0.23198874719000698>, BranchRadius(0.0054392234060798034)
  <1.0312974010057678, 2.177628370576043, 0.22900032099081782>, BranchRadius(0.005388895722633455)
  <1.0355968750993338, 2.1758469678536154, 0.2263903920536153>, BranchRadius(0.005335785059198394)
  <1.040020808353957, 2.176119034652371, 0.22347544831903093>, BranchRadius(0.005304913077529023)
  <1.04432510664675, 2.17726196070122, 0.22064400399426803>, BranchRadius(0.005277342201403048)
  <1.0489744647433692, 2.1762762582435125, 0.21846759560295562>, BranchRadius(0.005227321831636422)
  <1.0537883760284306, 2.177181792574555, 0.2167582613985692>, BranchRadius(0.005188020596279668)
  <1.0572333392814237, 2.1786180259643984, 0.21319762183547628>, BranchRadius(0.005158361393198166)
  <1.060431729133152, 2.179506887270006, 0.21158973830457853>, BranchRadius(0.003688503966810469)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.9639306039707147, 2.175414848057712, 0.24497508045537517>, BranchRadius(0.018179091994017984)
  <0.9815009867627597, 2.177190818331574, 0.2414805079163215>, BranchRadius(0.01800234593333156)
  <0.9909705609622379, 2.1747390953358363, 0.24009731818716185>, BranchRadius(0.009879119140596727)
  <1.0007069522430503, 2.1749740651668708, 0.24135178015070657>, BranchRadius(0.009819684354018575)
  <1.0040014785825968, 2.1752523112540283, 0.2470483215681732>, BranchRadius(0.006586494424798071)
  <1.0079066979659774, 2.175248836354415, 0.25229536406609054>, BranchRadius(0.006540810766427174)
  <1.0098520404702676, 2.1768060642679576, 0.25322891918615886>, BranchRadius(0.002660985042408192)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.9909705609622379, 2.1747390953358363, 0.24009731818716185>, BranchRadius(0.009879119140596727)
  <1.0007069522430503, 2.1749740651668708, 0.24135178015070657>, BranchRadius(0.009819684354018575)
  <1.0058993084321504, 2.174917241389302, 0.23718925661900028>, BranchRadius(0.006655102845801204)
  <1.0116786699290357, 2.1728309917082456, 0.2347601526407624>, BranchRadius(0.006607117615154112)
  <1.017895726434816, 2.170761046568621, 0.23504993975595104>, BranchRadius(0.006558996954508347)
  <1.0205220647604034, 2.168433189775984, 0.23547491910891455>, BranchRadius(0.00353513474961294)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.8901212251862326, 2.0949676751892903, 0.23583518996323585>, BranchRadius(0.06608184732710232)
  <0.9185500412191963, 2.1528188479404737, 0.24801225803149152>, BranchRadius(0.065599060637042)
  <0.9046225287556838, 2.175697667402717, 0.2604361565182061>, BranchRadius(0.029525738551565563)
  <0.892000244297193, 2.1831850233996244, 0.2541340998479675>, BranchRadius(0.01597180274891918)
  <0.877609820070337, 2.183958259940998, 0.24747165331123427>, BranchRadius(0.01587672504116092)
  <0.8697838762066299, 2.184007626622332, 0.2415445559912169>, BranchRadius(0.009817245900357095)
  <0.8677665437851383, 2.1820400468860406, 0.23537637210830722>, BranchRadius(0.006781407857580385)
  <0.8661760980713887, 2.180302961154223, 0.23125336867174628>, BranchRadius(0.00474827776630245)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.877609820070337, 2.183958259940998, 0.24747165331123427>, BranchRadius(0.01587672504116092)
  <0.8697838762066299, 2.184007626622332, 0.2415445559912169>, BranchRadius(0.009817245900357095)
  <0.8631779178158625, 2.1850698297646596, 0.23893278312405594>, BranchRadius(0.007182500907466632)
  <0.8563965083939887, 2.1872884527654284, 0.23898644199461386>, BranchRadius(0.007135312259530601)
  <0.8500187976161867, 2.1893115853567955, 0.24125979567826253>, BranchRadius(0.007066568984910727)
  <0.8433440715430763, 2.1915018197306475, 0.24154255601794516>, BranchRadius(0.007030579504789108)
  <0.8415915603743882, 2.1923604780887187, 0.24376486461183552>, BranchRadius(0.0029575741848245508)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  21
  <0.892000244297193, 2.1831850233996244, 0.2541340998479675>, BranchRadius(0.01597180274891918)
  <0.877609820070337, 2.183958259940998, 0.24747165331123427>, BranchRadius(0.01587672504116092)
  <0.8671294108201099, 2.185598124439135, 0.24930319604236134>, BranchRadius(0.010764881903692286)
  <0.8565810188411364, 2.183933448811641, 0.2493973840310882>, BranchRadius(0.010679353429120412)
  <0.8472727116331851, 2.1793145104651317, 0.24733426480229306>, BranchRadius(0.01059413212484518)
  <0.8406077617733538, 2.1714031584094755, 0.24544519582811372>, BranchRadius(0.010515684931178057)
  <0.8343813863508299, 2.163077359179069, 0.24453161479470792>, BranchRadius(0.010436537454148354)
  <0.8315480665699495, 2.153094571433027, 0.2447904590922434>, BranchRadius(0.010380305994219121)
  <0.8317968183727732, 2.14284627874558, 0.24374958686315587>, BranchRadius(0.010304018413428567)
  <0.8297257947586487, 2.1338100123467605, 0.23943972592328486>, BranchRadius(0.010223411884577566)
  <0.8294084564805668, 2.1301890058921624, 0.23331307602298373>, BranchRadius(0.007123779216668413)
  <0.8290009505266016, 2.1260583423090704, 0.22974109186828515>, BranchRadius(0.005476085603842994)
  <0.8294386016100364, 2.121523728915471, 0.22676246150963156>, BranchRadius(0.005443022681721827)
  <0.8291469136533365, 2.117118997486265, 0.22364977966751776>, BranchRadius(0.005401437686185142)
  <0.8287242945099441, 2.1127517294822216, 0.2205886374663853>, BranchRadius(0.005349974610692971)
  <0.8275311566365603, 2.1083310254213186, 0.21791445974145232>, BranchRadius(0.005302586999146409)
  <0.8263444718225862, 2.1039400153084595, 0.21526764946005494>, BranchRadius(0.005262584471973625)
  <0.8249082433895134, 2.1000535160766276, 0.2120695120214945>, BranchRadius(0.0052340912742251874)
  <0.8235851892697401, 2.096162053220127, 0.2088981193640733>, BranchRadius(0.005191501396987086)
  <0.8231125091516868, 2.092603349080064, 0.20521993816348377>, BranchRadius(0.005139729428177691)
  <0.8212863321604399, 2.090013573296118, 0.20457225625383355>, BranchRadius(0.0032344014702197377)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <0.9185500412191963, 2.1528188479404737, 0.24801225803149152>, BranchRadius(0.065599060637042)
  <0.9046225287556838, 2.175697667402717, 0.2604361565182061>, BranchRadius(0.029525738551565563)
  <0.9027704396784851, 2.190828350655671, 0.2781133313810834>, BranchRadius(0.023342029063126532)
  <0.8963308728012165, 2.2104365034093663, 0.28868108840919154>, BranchRadius(0.023186745450454765)
  <0.888085791329821, 2.223254539448979, 0.30596348276239643>, BranchRadius(0.02304266848614646)
  <0.8901469264733426, 2.228723319061991, 0.3131284999315005>, BranchRadius(0.009246258679547743)
  <0.8938756682264523, 2.2345154836262875, 0.31919882564659635>, BranchRadius(0.009181586991834625)
  <0.8977304789557191, 2.23989318543203, 0.3254762397593964>, BranchRadius(0.009120590464083972)
  <0.9006349289744503, 2.2429019297930006, 0.3301001795386567>, BranchRadius(0.006234516149887217)
  <0.9017554220480328, 2.2443627874736607, 0.336003779857811>, BranchRadius(0.00618402026350236)
  <0.9032945078700754, 2.2480903947960034, 0.3380761698542966>, BranchRadius(0.004534163849568044)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <0.8938756682264523, 2.2345154836262875, 0.31919882564659635>, BranchRadius(0.009181586991834625)
  <0.8977304789557191, 2.23989318543203, 0.3254762397593964>, BranchRadius(0.009120590464083972)
  <0.8977965360401806, 2.245588545959338, 0.3261523675140574>, BranchRadius(0.0057357339386554275)
  <0.8971554092907656, 2.251175228915859, 0.3270634922124806>, BranchRadius(0.005696684841341946)
  <0.899009896838605, 2.2565029258669513, 0.32685524082189826>, BranchRadius(0.0056450728524483716)
  <0.9009089279533947, 2.2609576401911466, 0.32401553841365577>, BranchRadius(0.005613796278144458)
  <0.9036547495859578, 2.264006338819078, 0.32025416255851313>, BranchRadius(0.005566151999851522)
  <0.9077717788419883, 2.264813973419108, 0.31667671160429917>, BranchRadius(0.005513652044877682)
  <0.9130511257182502, 2.265342155066704, 0.3153832695786009>, BranchRadius(0.005461087031589458)
  <0.9174553820705974, 2.266709722768434, 0.3125121530042957>, BranchRadius(0.005432405159711081)
  <0.9217016470048144, 2.2678112386653435, 0.3093739997293106>, BranchRadius(0.0053937101460871705)
  <0.9258387866970145, 2.266646326887395, 0.3061779143833658>, BranchRadius(0.005356109205546819)
  <0.930399104553328, 2.264346335649021, 0.3046698622993446>, BranchRadius(0.005325474601885537)
  <0.9351495926218784, 2.2635230796313666, 0.30253616851946197>, BranchRadius(0.005272336911309232)
  <0.9376457392975291, 2.2632375181706466, 0.301045442472052>, BranchRadius(0.0029213965363567695)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.8963308728012165, 2.2104365034093663, 0.28868108840919154>, BranchRadius(0.023186745450454765)
  <0.888085791329821, 2.223254539448979, 0.30596348276239643>, BranchRadius(0.02304266848614646)
  <0.8754723204405574, 2.2284098108008736, 0.31326168941046684>, BranchRadius(0.015457693581640869)
  <0.8752793956422398, 2.2312407721265224, 0.3226786691045678>, BranchRadius(0.00983519540040943)
  <0.8765114752066275, 2.2341116870104756, 0.3319495282674205>, BranchRadius(0.009783097768157957)
  <0.8751684347270297, 2.2397062047782295, 0.3398001974287163>, BranchRadius(0.009733210830125431)
  <0.873796080016055, 2.242083788122724, 0.34903892908758216>, BranchRadius(0.009637967766976766)
  <0.8723220141715834, 2.2437960530906564, 0.35553528044742494>, BranchRadius(0.006878030417552528)
  <0.8728757073034399, 2.2445212501639977, 0.36229067650117636>, BranchRadius(0.006816734021691603)
  <0.8745283823988663, 2.243033210207837, 0.36484149423659584>, BranchRadius(0.003384120122203829)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.8751684347270297, 2.2397062047782295, 0.3398001974287163>, BranchRadius(0.009733210830125431)
  <0.873796080016055, 2.242083788122724, 0.34903892908758216>, BranchRadius(0.009637967766976766)
  <0.877546272718749, 2.2429029701192085, 0.3535879952013096>, BranchRadius(0.0059522270586534354)
  <0.8819125467999527, 2.2420868262649685, 0.35749564591794125>, BranchRadius(0.0059160945112631015)
  <0.8864645856083483, 2.2410476120037996, 0.36107986221245586>, BranchRadius(0.005886223750387007)
  <0.8894404627351862, 2.240607197881141, 0.3615411367575004>, BranchRadius(0.003043449273337757)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.888085791329821, 2.223254539448979, 0.30596348276239643>, BranchRadius(0.02304266848614646)
  <0.8754723204405574, 2.2284098108008736, 0.31326168941046684>, BranchRadius(0.015457693581640869)
  <0.8690290400695574, 2.229394179899897, 0.3114139994134129>, BranchRadius(0.006774865518048269)
  <0.8647354855255043, 2.23005033365104, 0.3101817602452468>, BranchRadius(0.004514815803048992)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <0.7977599465254408, 1.9765771594913417, 0.22132926815766657>, BranchRadius(0.10773989934017082)
  <0.8456908898014118, 2.046627802138149, 0.22835103889886177>, BranchRadius(0.08516908548820373)
  <0.8723644744036877, 2.0959929361811884, 0.23164854619914804>, BranchRadius(0.05620738500426284)
  <0.8781229597270791, 2.1142273571451926, 0.21517124474223723>, BranchRadius(0.02524194375269354)
  <0.8821288314643321, 2.132357572490612, 0.1984133243270908>, BranchRadius(0.02501158958337098)
  <0.8830761445084231, 2.1423012746297543, 0.1857596833882612>, BranchRadius(0.01612108070956514)
  <0.8791149853278988, 2.1489685996681036, 0.17176126865709537>, BranchRadius(0.016003112828639674)
  <0.8746533171676983, 2.1568781360391176, 0.15872253913319823>, BranchRadius(0.015889484446434628)
  <0.8755851216672003, 2.164375824982115, 0.14491778779776437>, BranchRadius(0.0157370505033311)
  <0.8763995102213717, 2.1672788628429176, 0.13718473444978113>, BranchRadius(0.008300058531189685)
  <0.8777141945035156, 2.1696491081823868, 0.12940379069533028>, BranchRadius(0.008239511116620859)
  <0.8794693362393304, 2.1720209907777166, 0.12179271649884334>, BranchRadius(0.008163014148171987)
  <0.8810640519541304, 2.171593263105628, 0.11853488465254315>, BranchRadius(0.0036523331599496453)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.8777141945035156, 2.1696491081823868, 0.12940379069533028>, BranchRadius(0.008239511116620859)
  <0.8794693362393304, 2.1720209907777166, 0.12179271649884334>, BranchRadius(0.008163014148171987)
  <0.8792705778279847, 2.175886493171631, 0.11680024832851386>, BranchRadius(0.006317147465050223)
  <0.8786902246768643, 2.1798943175684076, 0.11202505092273791>, BranchRadius(0.006261148172623106)
  <0.8805577820753148, 2.184368129134574, 0.10814529059220811>, BranchRadius(0.0062092914884407)
  <0.8827906026214667, 2.189053571041809, 0.10483615468343531>, BranchRadius(0.00615542313087586)
  <0.8861965749440531, 2.1920874085398196, 0.1007515563371753>, BranchRadius(0.006122806633957188)
  <0.8880231427872128, 2.191133913096722, 0.09804706905145015>, BranchRadius(0.0033999639886801393)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.8746533171676983, 2.1568781360391176, 0.15872253913319823>, BranchRadius(0.015889484446434628)
  <0.8755851216672003, 2.164375824982115, 0.14491778779776437>, BranchRadius(0.0157370505033311)
  <0.8742929224500742, 2.174108556762767, 0.14016839185719993>, BranchRadius(0.010906539713910694)
  <0.8731478865209142, 2.1834177293845505, 0.1347137674734868>, BranchRadius(0.01085010273447339)
  <0.8732755546455134, 2.191304014957035, 0.12741846395462705>, BranchRadius(0.01074389374077667)
  <0.875022784525582, 2.1957386349392762, 0.12289531010867956>, BranchRadius(0.006570965481176229)
  <0.8765604014148402, 2.1999896925463216, 0.11820573977558954>, BranchRadius(0.006513664589579947)
  <0.8770776565777837, 2.2053737334827215, 0.11467228029190359>, BranchRadius(0.006460710923054318)
  <0.8782039167976854, 2.210214814297015, 0.11061857158553237>, BranchRadius(0.0064138194400497625)
  <0.8778869510402634, 2.2127334531413902, 0.10755709496643884>, BranchRadius(0.003977014962133115)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.8731478865209142, 2.1834177293845505, 0.1347137674734868>, BranchRadius(0.01085010273447339)
  <0.8732755546455134, 2.191304014957035, 0.12741846395462705>, BranchRadius(0.01074389374077667)
  <0.8689205370634069, 2.1947367828067126, 0.1253508406821035>, BranchRadius(0.0059182040559041275)
  <0.866420575344102, 2.1970905865574326, 0.12618623708538868>, BranchRadius(0.0035338488713463696)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.8781229597270791, 2.1142273571451926, 0.21517124474223723>, BranchRadius(0.02524194375269354)
  <0.8821288314643321, 2.132357572490612, 0.1984133243270908>, BranchRadius(0.02501158958337098)
  <0.887743888932258, 2.145737040977099, 0.19341328397708768>, BranchRadius(0.01534729457756859)
  <0.887841810607189, 2.1559926358702395, 0.18872075365330768>, BranchRadius(0.011278592824737841)
  <0.8906081548541505, 2.15796759236816, 0.18378610055087558>, BranchRadius(0.005991987558625066)
  <0.8941657259561601, 2.158982302093082, 0.1791107521057083>, BranchRadius(0.005961948595504063)
  <0.8958466912123556, 2.1619957259286045, 0.1743189982279967>, BranchRadius(0.005904851617915033)
  <0.8965055918413548, 2.163565108850752, 0.17219465390587924>, BranchRadius(0.002722122626579597)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.887743888932258, 2.145737040977099, 0.19341328397708768>, BranchRadius(0.01534729457756859)
  <0.887841810607189, 2.1559926358702395, 0.18872075365330768>, BranchRadius(0.011278592824737841)
  <0.885386640714905, 2.1613748636988612, 0.18993558971661256>, BranchRadius(0.006039210400364678)
  <0.8840273467633915, 2.1662628357400524, 0.1931122849408849>, BranchRadius(0.005985928772546766)
  <0.8832255692534529, 2.168545179345423, 0.1938720931611531>, BranchRadius(0.0025355961902493074)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.8821288314643321, 2.132357572490612, 0.1984133243270908>, BranchRadius(0.02501158958337098)
  <0.887743888932258, 2.145737040977099, 0.19341328397708768>, BranchRadius(0.01534729457756859)
  <0.8933207162818217, 2.1485577290901836, 0.1932572942904919>, BranchRadius(0.006251529212957662)
  <0.8958448025103307, 2.149922894177911, 0.19568772654962366>, BranchRadius(0.003760543573996588)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <0.8456908898014118, 2.046627802138149, 0.22835103889886177>, BranchRadius(0.08516908548820373)
  <0.8723644744036877, 2.0959929361811884, 0.23164854619914804>, BranchRadius(0.05620738500426284)
  <0.8881750833036554, 2.1212360795962026, 0.24271764369130883>, BranchRadius(0.031776037552685474)
  <0.9036000580323112, 2.1472854760235642, 0.25138199433280783>, BranchRadius(0.03148923421819528)
  <0.9090045885802477, 2.177352483204321, 0.25789164797006914>, BranchRadius(0.031234747665514467)
  <0.914370593653048, 2.2072502334100728, 0.2637974868211202>, BranchRadius(0.030944279121372847)
  <0.9211911826894202, 2.2366769835876816, 0.2695780589860513>, BranchRadius(0.0307549845614082)
  <0.9288711399295492, 2.253469567770533, 0.26871039692307497>, BranchRadius(0.01848581792087903)
  <0.9353213989115614, 2.2628646804946264, 0.26429699285178015>, BranchRadius(0.01222097048232964)
  <0.9378181008279225, 2.2673817604212627, 0.26243159042186354>, BranchRadius(0.0054879192549014905)
  <0.939102229632261, 2.269354585896881, 0.26015233097653234>, BranchRadius(0.003276591332850716)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.9288711399295492, 2.253469567770533, 0.26871039692307497>, BranchRadius(0.01848581792087903)
  <0.9353213989115614, 2.2628646804946264, 0.26429699285178015>, BranchRadius(0.01222097048232964)
  <0.9408143007172757, 2.262618413517161, 0.26201009736889946>, BranchRadius(0.005955040606161182)
  <0.9462863134171827, 2.2611973228733615, 0.26032123072819>, BranchRadius(0.005900397625240144)
  <0.9482299250522559, 2.2584353349451227, 0.25926094637310687>, BranchRadius(0.0035398314108672176)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.9211911826894202, 2.2366769835876816, 0.2695780589860513>, BranchRadius(0.0307549845614082)
  <0.9288711399295492, 2.253469567770533, 0.26871039692307497>, BranchRadius(0.01848581792087903)
  <0.9293937253900492, 2.261065900612372, 0.2737015342353639>, BranchRadius(0.009104329732476267)
  <0.9279590426225357, 2.2685700218797598, 0.27855629124972003>, BranchRadius(0.009052006203461025)
  <0.9254068128541226, 2.2739243048592295, 0.28105035734391526>, BranchRadius(0.0064344843380978265)
  <0.9239251182800826, 2.276284090320839, 0.28009621612023666>, BranchRadius(0.0029452320299570693)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.9293937253900492, 2.261065900612372, 0.2737015342353639>, BranchRadius(0.009104329732476267)
  <0.9279590426225357, 2.2685700218797598, 0.27855629124972003>, BranchRadius(0.009052006203461025)
  <0.930573151736652, 2.2711573326068693, 0.28220262766671506>, BranchRadius(0.00517914206457263)
  <0.9318184625283286, 2.2738240871597926, 0.2864026520943733>, BranchRadius(0.005128604489169476)
  <0.9323597162022053, 2.275245718282626, 0.2885982248776945>, BranchRadius(0.0026710541806100312)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.914370593653048, 2.2072502334100728, 0.2637974868211202>, BranchRadius(0.030944279121372847)
  <0.9211911826894202, 2.2366769835876816, 0.2695780589860513>, BranchRadius(0.0307549845614082)
  <0.9169040201563674, 2.2454817169588788, 0.27826817791605346>, BranchRadius(0.013092794176197357)
  <0.9204743508070066, 2.252944556925582, 0.28296990454890675>, BranchRadius(0.009515643680466363)
  <0.9235503192116373, 2.260305900768977, 0.28803192228234925>, BranchRadius(0.00944854424452051)
  <0.9240987033238305, 2.265595584970009, 0.28890775480663955>, BranchRadius(0.005389672224890881)
  <0.924407217314211, 2.270911066847249, 0.28928496209264415>, BranchRadius(0.005337772363649424)
  <0.9243562996822194, 2.27613512995156, 0.2884071599992379>, BranchRadius(0.005297543245530192)
  <0.9251918936415713, 2.2812689274764115, 0.289106382976199>, BranchRadius(0.005248143201417652)
  <0.9256769817874251, 2.284125723134064, 0.28865863178058837>, BranchRadius(0.0029320765801734844)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.9204743508070066, 2.252944556925582, 0.28296990454890675>, BranchRadius(0.009515643680466363)
  <0.9235503192116373, 2.260305900768977, 0.28803192228234925>, BranchRadius(0.00944854424452051)
  <0.9260285403859139, 2.264456793609088, 0.2921221627013921>, BranchRadius(0.006332579114727958)
  <0.92819431545874, 2.267856120423576, 0.29253897099575626>, BranchRadius(0.004052127047863376)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.9211911826894202, 2.2366769835876816, 0.2695780589860513>, BranchRadius(0.0307549845614082)
  <0.9169040201563674, 2.2454817169588788, 0.27826817791605346>, BranchRadius(0.013092794176197357)
  <0.9115467744587857, 2.2505724717231748, 0.2843570811071332>, BranchRadius(0.009575521270656766)
  <0.9081461983508293, 2.2538582299524923, 0.2859456307369023>, BranchRadius(0.004988347916271727)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.9169040201563674, 2.2454817169588788, 0.27826817791605346>, BranchRadius(0.013092794176197357)
  <0.9115467744587857, 2.2505724717231748, 0.2843570811071332>, BranchRadius(0.009575521270656766)
  <0.9089348724834152, 2.253014727337808, 0.2889896620810035>, BranchRadius(0.005852132166622522)
  <0.9061790335876263, 2.255970561323296, 0.2931655680814481>, BranchRadius(0.005811178322324733)
  <0.907109374102811, 2.2562981038473353, 0.2954553708242177>, BranchRadius(0.0024931935705122346)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <0.2315093984894522, 1.5774866674494556, -0.008357563216419117>, BranchRadius(0.1936229841663183)
  <0.3507057821463858, 1.7157948841220276, 0.05304466226511352>, BranchRadius(0.1926322246409541)
  <0.3969954816612644, 1.7984045389605394, 0.08120770318046046>, BranchRadius(0.09879396857761778)
  <0.4684784252677761, 1.854617563449509, 0.11807658041228322>, BranchRadius(0.09812761821823891)
  <0.5379952541572638, 1.8745915780869156, 0.18323520076543837>, BranchRadius(0.09735089401701581)
  <0.53813340185081, 1.8559610125506238, 0.245184976362395>, BranchRadius(0.06469073931793157)
  <0.5383344403950228, 1.8373108703777483, 0.30648202985270645>, BranchRadius(0.06407181116652497)
  <0.5164782179371961, 1.8584863112029935, 0.34065841414919357>, BranchRadius(0.04576154496791644)
  <0.5072791452898419, 1.8680388592499015, 0.38401158823176074>, BranchRadius(0.045336208650406176)
  <0.49838538105123686, 1.8777928665703423, 0.3971412103620352>, BranchRadius(0.018617912837450186)
  <0.4934223667140893, 1.8762484174037757, 0.40268709657438884>, BranchRadius(0.007600900500546965)
  <0.48811963419522414, 1.8755264594597134, 0.4079953309616408>, BranchRadius(0.007537741554977135)
  <0.48421332777780685, 1.876376595133156, 0.4143398076210538>, BranchRadius(0.0074989562321600076)
  <0.48317177661054767, 1.8778976075288807, 0.4215641897653015>, BranchRadius(0.007455870499686288)
  <0.48312837025506417, 1.8774486654907558, 0.42558359743796875>, BranchRadius(0.0040446348542715685)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.48421332777780685, 1.876376595133156, 0.4143398076210538>, BranchRadius(0.0074989562321600076)
  <0.48317177661054767, 1.8778976075288807, 0.4215641897653015>, BranchRadius(0.007455870499686288)
  <0.4823295989581742, 1.879153689266928, 0.4272153764458224>, BranchRadius(0.005850035506636735)
  <0.4817161098651661, 1.8782202149311933, 0.4300089945868645>, BranchRadius(0.0030086617491294544)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.5072791452898419, 1.8680388592499015, 0.38401158823176074>, BranchRadius(0.045336208650406176)
  <0.49838538105123686, 1.8777928665703423, 0.3971412103620352>, BranchRadius(0.018617912837450186)
  <0.4980772409013397, 1.8900461838505946, 0.4006329303834195>, BranchRadius(0.01274483595148427)
  <0.4973303796741872, 1.9007691762901382, 0.4073143440569583>, BranchRadius(0.012656289236110407)
  <0.4910608291598176, 1.9091099048264384, 0.41433020450800434>, BranchRadius(0.012573675438670912)
  <0.48561086350135785, 1.9105806429898544, 0.4216280454949545>, BranchRadius(0.009226249481480979)
  <0.4816542821489898, 1.908108881469822, 0.42274470306608636>, BranchRadius(0.004796985005290954)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.4973303796741872, 1.9007691762901382, 0.4073143440569583>, BranchRadius(0.012656289236110407)
  <0.4910608291598176, 1.9091099048264384, 0.41433020450800434>, BranchRadius(0.012573675438670912)
  <0.486408087857912, 1.9153514154952223, 0.4195260662580041>, BranchRadius(0.009359563898820812)
  <0.4833302114023359, 1.9186691133332832, 0.42429905629447867>, BranchRadius(0.006577376096039284)
  <0.48126454240684374, 1.919530213337159, 0.4304205903186139>, BranchRadius(0.0065177956721776615)
  <0.4781073915558298, 1.9228724517065112, 0.4326642274705061>, BranchRadius(0.005115864197081291)
  <0.4776282138685337, 1.9233548974891232, 0.4347050447375486>, BranchRadius(0.0021511160607046442)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  20
  <0.5164782179371961, 1.8584863112029935, 0.34065841414919357>, BranchRadius(0.04576154496791644)
  <0.5072791452898419, 1.8680388592499015, 0.38401158823176074>, BranchRadius(0.045336208650406176)
  <0.5130149231683989, 1.861128121034097, 0.40997308495233176>, BranchRadius(0.027471016772805206)
  <0.5190504897315406, 1.85388109552232, 0.43555515322717636>, BranchRadius(0.027265173018436423)
  <0.5288499192280791, 1.8476180464424516, 0.45999059306999385>, BranchRadius(0.027061879508755857)
  <0.5394686548868859, 1.8454630560874397, 0.48462993026852536>, BranchRadius(0.02691650920912198)
  <0.552950399635371, 1.846067316250275, 0.5077544594849732>, BranchRadius(0.02677436130498813)
  <0.5587441720215935, 1.853473214732324, 0.5326189327000568>, BranchRadius(0.026583023888440204)
  <0.566267207751137, 1.866954481068869, 0.5420691411421295>, BranchRadius(0.018101023402655167)
  <0.5737571056197261, 1.8795869471606448, 0.5524016484578536>, BranchRadius(0.01795657197438462)
  <0.5792007860724742, 1.8869426363986366, 0.5504932087301904>, BranchRadius(0.009347832007030451)
  <0.5855826688913276, 1.8932303006654059, 0.5481057912319615>, BranchRadius(0.009271618658898416)
  <0.5918791070368756, 1.8999190769079817, 0.5474423977965363>, BranchRadius(0.009210046242778866)
  <0.5960103186602481, 1.9041218978079475, 0.5468911902557306>, BranchRadius(0.005918990010746602)
  <0.6006043982125104, 1.9077670570990073, 0.5474016120018673>, BranchRadius(0.005886703963054718)
  <0.6056300010955908, 1.910300018607598, 0.5458827693516465>, BranchRadius(0.0058291904531039326)
  <0.6109268362155071, 1.911439054694133, 0.5438522179880594>, BranchRadius(0.005785931587408663)
  <0.6156456960326163, 1.9106313237026846, 0.5406551214476202>, BranchRadius(0.005756864912168957)
  <0.6211510640344581, 1.9099132207975034, 0.5393240973115688>, BranchRadius(0.005709323416034889)
  <0.6239867695080935, 1.90932217409126, 0.5402487115941261>, BranchRadius(0.0030406369914338996)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.5855826688913276, 1.8932303006654059, 0.5481057912319615>, BranchRadius(0.009271618658898416)
  <0.5918791070368756, 1.8999190769079817, 0.5474423977965363>, BranchRadius(0.009210046242778866)
  <0.5957298492894417, 1.9044843418072372, 0.547332811177907>, BranchRadius(0.00597343023086859)
  <0.599808160913265, 1.9087281310157846, 0.5466256408103187>, BranchRadius(0.0059281078327229324)
  <0.6038023328463261, 1.9129170600692265, 0.5455517022233952>, BranchRadius(0.005886754635119838)
  <0.6074819341385784, 1.9167403277110784, 0.5431252611791578>, BranchRadius(0.00583476282914197)
  <0.6126831445125195, 1.9192789720060712, 0.5427391572072648>, BranchRadius(0.005800550015955709)
  <0.6178036124478468, 1.921501118619022, 0.5413616681131209>, BranchRadius(0.005749313319923515)
  <0.6205260843149553, 1.9228038095844908, 0.5414442536187969>, BranchRadius(0.0030192179756451244)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.566267207751137, 1.866954481068869, 0.5420691411421295>, BranchRadius(0.018101023402655167)
  <0.5737571056197261, 1.8795869471606448, 0.5524016484578536>, BranchRadius(0.01795657197438462)
  <0.5775263064710948, 1.8861883061812756, 0.5588612677416588>, BranchRadius(0.009975544960999897)
  <0.5839501914605306, 1.8913913820007047, 0.564331424838455>, BranchRadius(0.009912664374619792)
  <0.5911756313060467, 1.895503007375768, 0.5696283246459414>, BranchRadius(0.009857463758826839)
  <0.5947282826234538, 1.9012853481520555, 0.5766508960771699>, BranchRadius(0.00976592574940537)
  <0.5999464558023062, 1.9072659091781783, 0.5822528555730672>, BranchRadius(0.00971485417828522)
  <0.6044052891498625, 1.9083609070327134, 0.5836530264183958>, BranchRadius(0.004800072241000602)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.5947282826234538, 1.9012853481520555, 0.5766508960771699>, BranchRadius(0.00976592574940537)
  <0.5999464558023062, 1.9072659091781783, 0.5822528555730672>, BranchRadius(0.00971485417828522)
  <0.5978787442347352, 1.9118316223426135, 0.5858826811507689>, BranchRadius(0.0061884409628840875)
  <0.5970170829231536, 1.9173737474859303, 0.5883649671111338>, BranchRadius(0.00613346190247272)
  <0.5966052767070196, 1.921008424870738, 0.5898508198958984>, BranchRadius(0.003948192314119409)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.552950399635371, 1.846067316250275, 0.5077544594849732>, BranchRadius(0.02677436130498813)
  <0.5587441720215935, 1.853473214732324, 0.5326189327000568>, BranchRadius(0.026583023888440204)
  <0.5568096340607176, 1.8468110852401687, 0.5490687432485496>, BranchRadius(0.017852805761941863)
  <0.5517153267494231, 1.8422785307839273, 0.5517810654346154>, BranchRadius(0.00733844046931814)
  <0.5492293300365116, 1.8360431210094594, 0.5545722145214254>, BranchRadius(0.007269871246242038)
  <0.5447881817534319, 1.8304319842532342, 0.5555803329543498>, BranchRadius(0.0072266836477159705)
  <0.5424957829734172, 1.8246732460946777, 0.5592195414161024>, BranchRadius(0.007187627951801553)
  <0.5382331025295031, 1.820527993510948, 0.5631753480637987>, BranchRadius(0.007141566339662715)
  <0.535187246185506, 1.8174667708651056, 0.5688101795231904>, BranchRadius(0.007099271126773333)
  <0.535805922063769, 1.8157932218607369, 0.5722434065313038>, BranchRadius(0.003869182575377895)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.5587441720215935, 1.853473214732324, 0.5326189327000568>, BranchRadius(0.026583023888440204)
  <0.5568096340607176, 1.8468110852401687, 0.5490687432485496>, BranchRadius(0.017852805761941863)
  <0.5620499578678092, 1.847469263682288, 0.558775443947687>, BranchRadius(0.011050530798449318)
  <0.5702177947403958, 1.847435280733498, 0.5661235805494387>, BranchRadius(0.010986802334437232)
  <0.5795231358852526, 1.8483722671306004, 0.571709967246579>, BranchRadius(0.010893807124256675)
  <0.585078532318826, 1.8497345272481764, 0.5808607460982448>, BranchRadius(0.010791428809670784)
  <0.5882817339807886, 1.850778216229645, 0.5862730556174672>, BranchRadius(0.00637517701002135)
  <0.5902418703279706, 1.8512483743151895, 0.59013734108965>, BranchRadius(0.0043584269335931285)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  23
  <0.53813340185081, 1.8559610125506238, 0.245184976362395>, BranchRadius(0.06469073931793157)
  <0.5383344403950228, 1.8373108703777483, 0.30648202985270645>, BranchRadius(0.06407181116652497)
  <0.5406710946059267, 1.8211266665320234, 0.3492998784264587>, BranchRadius(0.04583401099081435)
  <0.5581454679464384, 1.815509760224143, 0.367566302112164>, BranchRadius(0.025895281314957493)
  <0.5644419256432435, 1.815504841524486, 0.37874790824962473>, BranchRadius(0.01283252584390778)
  <0.5695530959374245, 1.8185646340943424, 0.3900138914703778>, BranchRadius(0.012743969957472292)
  <0.5793182850904987, 1.8220724867258138, 0.39724657079524617>, BranchRadius(0.012648146089281824)
  <0.5838178444403648, 1.826860039418177, 0.40279217388102634>, BranchRadius(0.008597697872694623)
  <0.5883696011001319, 1.832717640782326, 0.4069812651021808>, BranchRadius(0.008519299718296534)
  <0.5913664052241249, 1.8370698459480639, 0.41360160697130505>, BranchRadius(0.008470622835797564)
  <0.5948067740912331, 1.8419051677753318, 0.4195635324616707>, BranchRadius(0.008411957600207694)
  <0.5992511111504278, 1.846827612969242, 0.4246370315606114>, BranchRadius(0.008350029442447119)
  <0.6044002052751881, 1.8511351606776152, 0.4295139120428488>, BranchRadius(0.00829771660178743)
  <0.6100610026541367, 1.855423618774896, 0.4336450657416463>, BranchRadius(0.008215955860442083)
  <0.6152863704149549, 1.8579353736669435, 0.43938299881379606>, BranchRadius(0.008157037257116959)
  <0.6192008262703963, 1.8591512721662122, 0.4463657537678933>, BranchRadius(0.008096927846639897)
  <0.6228584307637511, 1.8624286327783992, 0.45274560613609083>, BranchRadius(0.00805119118218659)
  <0.6282166487393934, 1.8623032973208176, 0.4586600571373044>, BranchRadius(0.007981662702543867)
  <0.6319515834592356, 1.8644265071715673, 0.4653138408288409>, BranchRadius(0.00792026482168121)
  <0.6359274785632816, 1.8668259344324794, 0.47167457106394006>, BranchRadius(0.007875524248104974)
  <0.6388946085278016, 1.87026272203024, 0.47802621336783374>, BranchRadius(0.007807607135037294)
  <0.6395413617930311, 1.8746778160432214, 0.4843853877254116>, BranchRadius(0.007768554784490206)
  <0.64010816226907, 1.876977411029599, 0.48778214471517184>, BranchRadius(0.0041409368418868844)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.5695530959374245, 1.8185646340943424, 0.3900138914703778>, BranchRadius(0.012743969957472292)
  <0.5793182850904987, 1.8220724867258138, 0.39724657079524617>, BranchRadius(0.012648146089281824)
  <0.5879685983362766, 1.818189292621038, 0.3987753071109362>, BranchRadius(0.009604381834785397)
  <0.5966161869156198, 1.8146397397227156, 0.3968948550015002>, BranchRadius(0.00953499943111996)
  <0.6047080481245496, 1.8101036687478493, 0.39492437289821386>, BranchRadius(0.009483509763425078)
  <0.6107835226976384, 1.8044819511402161, 0.39042824673295257>, BranchRadius(0.009419673595309356)
  <0.6138972846395963, 1.7973565040076054, 0.3851997208257711>, BranchRadius(0.009370431870137282)
  <0.6181691353186715, 1.7979432187772464, 0.3797420148322371>, BranchRadius(0.006955537158055233)
  <0.6220884910344283, 1.7996550036743901, 0.3795338975231796>, BranchRadius(0.004281923583514176)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.6107835226976384, 1.8044819511402161, 0.39042824673295257>, BranchRadius(0.009419673595309356)
  <0.6138972846395963, 1.7973565040076054, 0.3851997208257711>, BranchRadius(0.009370431870137282)
  <0.6149370852774576, 1.7905246453670796, 0.38271664087151436>, BranchRadius(0.0073431031526090245)
  <0.6158854969666283, 1.7832868915194795, 0.38294872595861185>, BranchRadius(0.007303316300028187)
  <0.6197409667125994, 1.781128915156918, 0.3824331874588768>, BranchRadius(0.004448290557976376)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.6149370852774576, 1.7905246453670796, 0.38271664087151436>, BranchRadius(0.0073431031526090245)
  <0.6158854969666283, 1.7832868915194795, 0.38294872595861185>, BranchRadius(0.007303316300028187)
  <0.6154251845546914, 1.7775580813412173, 0.3833306268786949>, BranchRadius(0.005759948080313239)
  <0.617073448643104, 1.7720880011093372, 0.38327411192813204>, BranchRadius(0.005713295562807219)
  <0.618907564159049, 1.7667377649295093, 0.3829238061292623>, BranchRadius(0.005666720485297545)
  <0.6198336504264085, 1.7612245629041092, 0.38238591009103234>, BranchRadius(0.005616258941271357)
  <0.6202046638478825, 1.7557855270853024, 0.3812840494028318>, BranchRadius(0.0055619114136579925)
  <0.6204975031486651, 1.752087088174484, 0.3806504981602715>, BranchRadius(0.0037637205541974405)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <0.5406710946059267, 1.8211266665320234, 0.3492998784264587>, BranchRadius(0.04583401099081435)
  <0.5581454679464384, 1.815509760224143, 0.367566302112164>, BranchRadius(0.025895281314957493)
  <0.569295201173218, 1.8109638681816653, 0.3770298425691765>, BranchRadius(0.01531470807660818)
  <0.5793896536425152, 1.8062136586582658, 0.387367737381776>, BranchRadius(0.015209685411850842)
  <0.5865937999124955, 1.7955826157639823, 0.3953131018816558>, BranchRadius(0.015101245429941153)
  <0.5969368872694448, 1.7851552779403888, 0.39836644794481557>, BranchRadius(0.01500105837406946)
  <0.608888456123622, 1.7768457015782138, 0.40153830250259803>, BranchRadius(0.014897977001280371)
  <0.6226412567269953, 1.775010029933598, 0.4065951232645109>, BranchRadius(0.014767553996552964)
  <0.6364092772091479, 1.7728333125717948, 0.4111615793959042>, BranchRadius(0.014667958551553367)
  <0.6501558117759495, 1.7690776080790556, 0.41415186781974045>, BranchRadius(0.014560712677983308)
  <0.664125302381054, 1.7687470356647144, 0.4177667446716079>, BranchRadius(0.014433408486611756)
  <0.6688693995653122, 1.764263489595213, 0.42636582424685554>, BranchRadius(0.010795962809887243)
  <0.676278431644202, 1.7642093708862938, 0.4273549823228038>, BranchRadius(0.007474966145735101)
  <0.6786165752407259, 1.7647613216582145, 0.43053008461886066>, BranchRadius(0.0039815624725747685)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.6688693995653122, 1.764263489595213, 0.42636582424685554>, BranchRadius(0.010795962809887243)
  <0.676278431644202, 1.7642093708862938, 0.4273549823228038>, BranchRadius(0.007474966145735101)
  <0.6816452962871994, 1.7640746746620575, 0.4275910382884385>, BranchRadius(0.005373741860937447)
  <0.6867334849157628, 1.7650007423741862, 0.42892594378557564>, BranchRadius(0.005341276777473423)
  <0.6892316518387674, 1.7651403444213245, 0.4290833936827701>, BranchRadius(0.002507013597267904)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.664125302381054, 1.7687470356647144, 0.4177667446716079>, BranchRadius(0.014433408486611756)
  <0.6688693995653122, 1.764263489595213, 0.42636582424685554>, BranchRadius(0.010795962809887243)
  <0.6669062996534271, 1.760831378746849, 0.43227457914255335>, BranchRadius(0.007109608326548913)
  <0.6658678322143874, 1.7548846875076969, 0.4359387330206552>, BranchRadius(0.007061697739082576)
  <0.6660885298419046, 1.749882809035105, 0.44085715857971225>, BranchRadius(0.007018433277972689)
  <0.6672838697383812, 1.747457777211032, 0.4427058075259532>, BranchRadius(0.0032752281969832112)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <0.6501558117759495, 1.7690776080790556, 0.41415186781974045>, BranchRadius(0.014560712677983308)
  <0.664125302381054, 1.7687470356647144, 0.4177667446716079>, BranchRadius(0.014433408486611756)
  <0.6696943670811356, 1.7716232262208278, 0.4141353884833584>, BranchRadius(0.0072438733778765994)
  <0.6734821212170787, 1.7770981225770195, 0.411377314570747>, BranchRadius(0.0072061462108968756)
  <0.6763165643379183, 1.7830829858901092, 0.4087203053564914>, BranchRadius(0.0071352893877038555)
  <0.6770395210330065, 1.789492088032612, 0.4058007523856046>, BranchRadius(0.007079763146166678)
  <0.6777507852707043, 1.795869359942457, 0.40290892559663416>, BranchRadius(0.007038334746609874)
  <0.6782990901207872, 1.802488818237052, 0.400802413829655>, BranchRadius(0.006968160312946742)
  <0.6774466348850028, 1.8077004021425616, 0.3963387022399823>, BranchRadius(0.0069146227582536695)
  <0.6768948889552998, 1.8128245011794755, 0.39182170471603606>, BranchRadius(0.006853034447774329)
  <0.6763279517462516, 1.8170884970400516, 0.38653435185737184>, BranchRadius(0.006816097032029214)
  <0.677829219769895, 1.8205492645863959, 0.38535774160391967>, BranchRadius(0.003951598331963016)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <0.5383344403950228, 1.8373108703777483, 0.30648202985270645>, BranchRadius(0.06407181116652497)
  <0.5406710946059267, 1.8211266665320234, 0.3492998784264587>, BranchRadius(0.04583401099081435)
  <0.5240640489515116, 1.8132993270701772, 0.36638284220197376>, BranchRadius(0.025077656584584607)
  <0.5087470751915045, 1.8094301226019442, 0.37252085890083453>, BranchRadius(0.016948618745409056)
  <0.49771121243508726, 1.8078770551070056, 0.3851007692714244>, BranchRadius(0.016806440145205864)
  <0.4842522011901413, 1.808514407183567, 0.39491082316441845>, BranchRadius(0.01666698409264638)
  <0.4716313350880975, 1.8015939497125235, 0.4030733802205195>, BranchRadius(0.016547094321008298)
  <0.4694700293097827, 1.7976203929973242, 0.414355623971868>, BranchRadius(0.012155221910813644)
  <0.4664781977465984, 1.7967764668303317, 0.42598938501085404>, BranchRadius(0.012041912779539244)
  <0.4642835223140484, 1.793286719395468, 0.43231565885549395>, BranchRadius(0.0075509388933264815)
  <0.4617951815349145, 1.7907800405112855, 0.4389246300398653>, BranchRadius(0.00749358251955355)
  <0.45838444957651064, 1.785865705288383, 0.4433155497846919>, BranchRadius(0.007420509374742642)
  <0.4579788733882803, 1.7799958921377128, 0.44773799376409484>, BranchRadius(0.007360516912499914)
  <0.45706988345489336, 1.7752923134061955, 0.4532682283923065>, BranchRadius(0.0073166529660529675)
  <0.45779454194214336, 1.7687792208446447, 0.4564275751531144>, BranchRadius(0.0072750928924308865)
  <0.4567702454420525, 1.7673201267565983, 0.4593908000375467>, BranchRadius(0.0034581556635855655)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.4694700293097827, 1.7976203929973242, 0.414355623971868>, BranchRadius(0.012155221910813644)
  <0.4664781977465984, 1.7967764668303317, 0.42598938501085404>, BranchRadius(0.012041912779539244)
  <0.46559959870108836, 1.7993151784464172, 0.4315488572181444>, BranchRadius(0.006174522182003478)
  <0.4647441964201853, 1.803127614664816, 0.4362617737182505>, BranchRadius(0.006121924935713032)
  <0.46429353938657436, 1.8044879589395388, 0.4385859027122616>, BranchRadius(0.002730421924999354)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.4842522011901413, 1.808514407183567, 0.39491082316441845>, BranchRadius(0.01666698409264638)
  <0.4716313350880975, 1.8015939497125235, 0.4030733802205195>, BranchRadius(0.016547094321008298)
  <0.46510981318595235, 1.7991567026601107, 0.40325462952878305>, BranchRadius(0.0069644290811523325)
  <0.46091310128395335, 1.7980480228210542, 0.40128842402475173>, BranchRadius(0.004765241427041605)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.5406710946059267, 1.8211266665320234, 0.3492998784264587>, BranchRadius(0.04583401099081435)
  <0.5240640489515116, 1.8132993270701772, 0.36638284220197376>, BranchRadius(0.025077656584584607)
  <0.5207834132969257, 1.80849262091149, 0.3791180636680577>, BranchRadius(0.01400188773645568)
  <0.5139031397906779, 1.8022050418520892, 0.38943026978558676>, BranchRadius(0.013900122623897776)
  <0.5068574564914841, 1.7971867709746978, 0.3909749198281449>, BranchRadius(0.008786958490023157)
  <0.5025616875979003, 1.795140527719439, 0.39293760327157984>, BranchRadius(0.0051471223169754984)
  <0.49919820400393405, 1.7938192398844044, 0.39343465692534624>, BranchRadius(0.0036477233673365512)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.5139031397906779, 1.8022050418520892, 0.38943026978558676>, BranchRadius(0.013900122623897776)
  <0.5068574564914841, 1.7971867709746978, 0.3909749198281449>, BranchRadius(0.008786958490023157)
  <0.5033768768779038, 1.792874290133132, 0.38989096584982835>, BranchRadius(0.005646847056760978)
  <0.5004537183977319, 1.7882724984079568, 0.3885844522806309>, BranchRadius(0.005606096707031427)
  <0.49796513183789837, 1.7834130541978372, 0.3875454285290973>, BranchRadius(0.005557592235248962)
  <0.49562952188650566, 1.781738504207777, 0.3858631100764945>, BranchRadius(0.00333007310583771)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <0.5207834132969257, 1.80849262091149, 0.3791180636680577>, BranchRadius(0.01400188773645568)
  <0.5139031397906779, 1.8022050418520892, 0.38943026978558676>, BranchRadius(0.013900122623897776)
  <0.5115803465249067, 1.7995179100166225, 0.3964940518725152>, BranchRadius(0.007906520311002897)
  <0.5089282683495353, 1.7973528517225872, 0.4035351144577595>, BranchRadius(0.007829275726028598)
  <0.5053851584941883, 1.794144375048393, 0.4096448922905029>, BranchRadius(0.007757405183525419)
  <0.5029055609429731, 1.788833656780542, 0.41466061725850845>, BranchRadius(0.00771424847222015)
  <0.4986442630583558, 1.78294799557427, 0.4170647863910035>, BranchRadius(0.0076537374343585455)
  <0.49472645366399626, 1.777436550914495, 0.42050425917817036>, BranchRadius(0.00758651604769653)
  <0.49259607825386786, 1.771434024648712, 0.4245166661436031>, BranchRadius(0.007527830405618066)
  <0.4911280177900927, 1.767258176039201, 0.4272743603411704>, BranchRadius(0.0052151500862535494)
  <0.4905285025839735, 1.7623796347837744, 0.4289148350802479>, BranchRadius(0.00518177002893991)
  <0.48986420163968775, 1.7575430190059902, 0.4305573347124154>, BranchRadius(0.005150917682137806)
  <0.4875189255722234, 1.7557097192940714, 0.43174354878023236>, BranchRadius(0.0032044362189049365)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  26
  <0.4684784252677761, 1.854617563449509, 0.11807658041228322>, BranchRadius(0.09812761821823891)
  <0.5379952541572638, 1.8745915780869156, 0.18323520076543837>, BranchRadius(0.09735089401701581)
  <0.5966764846646624, 1.8978478595134014, 0.21706059287457566>, BranchRadius(0.07161353636699729)
  <0.6575568277464395, 1.9173647212320766, 0.24830198501622797>, BranchRadius(0.07115721079447446)
  <0.7211315895877312, 1.934666320657723, 0.27343887781242737>, BranchRadius(0.07051921061179076)
  <0.7756301223677864, 1.9704726099699734, 0.29900737797413407>, BranchRadius(0.07004233455568516)
  <0.8219761474761496, 2.0203570707765173, 0.3128547589057173>, BranchRadius(0.06948498709771055)
  <0.8395800205661262, 2.0507647034117222, 0.3332367406859584>, BranchRadius(0.04061952303432029)
  <0.8496578702719768, 2.0892408077388973, 0.3392844114768151>, BranchRadius(0.04023118169882588)
  <0.866279375135281, 2.12495491383417, 0.34550566507246144>, BranchRadius(0.03988076973187181)
  <0.8639580503838123, 2.144745703437662, 0.3395086597262847>, BranchRadius(0.020809324228660997)
  <0.8561654723588626, 2.152140012895291, 0.33685972803581593>, BranchRadius(0.011064218170792199)
  <0.8522968668368099, 2.1608919947062395, 0.3314289759314315>, BranchRadius(0.01100256164371298)
  <0.8473120465874638, 2.167593292373692, 0.324404618468548>, BranchRadius(0.010913176490484462)
  <0.8435919476833456, 2.1754428852081693, 0.31792342178905064>, BranchRadius(0.010837949710246405)
  <0.8399007228485691, 2.1832924202616892, 0.31153841591287057>, BranchRadius(0.010770730772615386)
  <0.8410877636430325, 2.191929699860951, 0.30534671658817647>, BranchRadius(0.010693400079065692)
  <0.8436638043052973, 2.199892539077684, 0.2987858969938175>, BranchRadius(0.010634244102657694)
  <0.8459261421636162, 2.2078708116382932, 0.29227359458549207>, BranchRadius(0.010544244320672556)
  <0.8495108267418221, 2.2158753366986685, 0.28652080507442834>, BranchRadius(0.010488897564854341)
  <0.8520981192097091, 2.2219956117974125, 0.28276406791552516>, BranchRadius(0.007633146381393004)
  <0.851685134740102, 2.2276701314063394, 0.2777694845315035>, BranchRadius(0.007570772229051719)
  <0.8514852014715751, 2.234482886990104, 0.27458107325354814>, BranchRadius(0.007524598224049596)
  <0.8514950455497862, 2.2416773962244725, 0.27259553314825985>, BranchRadius(0.007463473021254817)
  <0.8542437450081629, 2.2484265892037514, 0.27128121342502354>, BranchRadius(0.007405024707515628)
  <0.8549797238948549, 2.2526779446377323, 0.27279137622110755>, BranchRadius(0.004571244865282311)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.8459261421636162, 2.2078708116382932, 0.29227359458549207>, BranchRadius(0.010544244320672556)
  <0.8495108267418221, 2.2158753366986685, 0.28652080507442834>, BranchRadius(0.010488897564854341)
  <0.8511809825641556, 2.2164556280438834, 0.2802091552065878>, BranchRadius(0.006554622992241275)
  <0.8541919697085002, 2.21520600789567, 0.2782314198479817>, BranchRadius(0.0038130081624498506)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <0.866279375135281, 2.12495491383417, 0.34550566507246144>, BranchRadius(0.03988076973187181)
  <0.8639580503838123, 2.144745703437662, 0.3395086597262847>, BranchRadius(0.020809324228660997)
  <0.8699638855899086, 2.1518445448522527, 0.3377607592808805>, BranchRadius(0.009461435510499418)
  <0.8758808770752808, 2.159078857672946, 0.33667702371582753>, BranchRadius(0.009408536177353903)
  <0.8807803829377182, 2.166863528153239, 0.3351855807737889>, BranchRadius(0.009318296745229781)
  <0.8825307199163201, 2.17109693376819, 0.3377594211618239>, BranchRadius(0.0052545272843937)
  <0.8833819458630896, 2.1755249062995317, 0.3403699204232161>, BranchRadius(0.005210204673954975)
  <0.8849160065873477, 2.179636873680168, 0.3431034743123054>, BranchRadius(0.005170486912243826)
  <0.8868167851789533, 2.1821372473531824, 0.3471591639820845>, BranchRadius(0.005129663386282004)
  <0.8898261189505127, 2.1838069159539604, 0.35091829961439147>, BranchRadius(0.0050965658719525925)
  <0.8930523921587891, 2.1862155698541943, 0.35399934826793833>, BranchRadius(0.005069843511497776)
  <0.8962368836917625, 2.1886470343723925, 0.3570232114161553>, BranchRadius(0.005019636875908517)
  <0.8990417994994814, 2.1912306040298306, 0.36024686547045404>, BranchRadius(0.00499342871432279)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.8758808770752808, 2.159078857672946, 0.33667702371582753>, BranchRadius(0.009408536177353903)
  <0.8807803829377182, 2.166863528153239, 0.3351855807737889>, BranchRadius(0.009318296745229781)
  <0.8842413029572839, 2.1707610281647782, 0.330706473098704>, BranchRadius(0.006872472574465523)
  <0.8883073058585655, 2.1749490038158297, 0.3271701671421773>, BranchRadius(0.0068247329226276965)
  <0.891043627768901, 2.180506640767756, 0.32445639833079337>, BranchRadius(0.006763085630689508)
  <0.8943115775442507, 2.1848528641997373, 0.32053800761701173>, BranchRadius(0.006702457731367063)
  <0.8936140601005121, 2.187231169045658, 0.3188398200727874>, BranchRadius(0.003004447613091147)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <0.8496578702719768, 2.0892408077388973, 0.3392844114768151>, BranchRadius(0.04023118169882588)
  <0.866279375135281, 2.12495491383417, 0.34550566507246144>, BranchRadius(0.03988076973187181)
  <0.8788946103239972, 2.127404231327646, 0.35533034296053084>, BranchRadius(0.016176143256499426)
  <0.8928868686501985, 2.1301154081244227, 0.36275794475492695>, BranchRadius(0.01607180889342109)
  <0.9019274399799021, 2.1325465376308106, 0.37565478747352665>, BranchRadius(0.015936463621286444)
  <0.9098917478648734, 2.133991043682857, 0.38928265079584684>, BranchRadius(0.01585040871879505)
  <0.9172167849022447, 2.136315850984153, 0.39422355229675726>, BranchRadius(0.009136378069493368)
  <0.923514311588463, 2.1375525841481475, 0.39401961093787524>, BranchRadius(0.006421054692215088)
  <0.9298428032783415, 2.1381448302415036, 0.3941638303302257>, BranchRadius(0.006357779623192893)
  <0.9357741599230159, 2.140204871777967, 0.39463784989880313>, BranchRadius(0.00629678150563224)
  <0.9390404603432616, 2.141215714811281, 0.3934860815800739>, BranchRadius(0.0036079207770300754)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.9019274399799021, 2.1325465376308106, 0.37565478747352665>, BranchRadius(0.015936463621286444)
  <0.9098917478648734, 2.133991043682857, 0.38928265079584684>, BranchRadius(0.01585040871879505)
  <0.9125152375146937, 2.133624961523896, 0.40018853774385804>, BranchRadius(0.011222971273803766)
  <0.9187931992522953, 2.136106905164565, 0.4090602452597705>, BranchRadius(0.011148095894014668)
  <0.9229171075771889, 2.1401420001434563, 0.41846972880640326>, BranchRadius(0.011037526533383833)
  <0.9287389335676948, 2.1439525985792, 0.4269605593445824>, BranchRadius(0.010977637338257224)
  <0.9296835809261378, 2.1454483618931626, 0.4310838718496191>, BranchRadius(0.004486799810265855)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.9229171075771889, 2.1401420001434563, 0.41846972880640326>, BranchRadius(0.011037526533383833)
  <0.9287389335676948, 2.1439525985792, 0.4269605593445824>, BranchRadius(0.010977637338257224)
  <0.9328280916225292, 2.1460958680713027, 0.4312558751595795>, BranchRadius(0.0063059143400271645)
  <0.9362654568363409, 2.1503352527169124, 0.43432169617914285>, BranchRadius(0.006259961686028955)
  <0.9391301630149543, 2.1553048688026104, 0.43669854977834327>, BranchRadius(0.00620911093161076)
  <0.9423061250969097, 2.15721999548217, 0.4398702178299343>, BranchRadius(0.004879951185643414)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  18
  <0.7756301223677864, 1.9704726099699734, 0.29900737797413407>, BranchRadius(0.07004233455568516)
  <0.8219761474761496, 2.0203570707765173, 0.3128547589057173>, BranchRadius(0.06948498709771055)
  <0.8635176844506669, 2.0374947505149215, 0.28887807523334863>, BranchRadius(0.05093408211547669)
  <0.8996712173767956, 2.041576917663611, 0.2539194389466286>, BranchRadius(0.050456399819028816)
  <0.9084079870918413, 2.02711172262832, 0.23857820758207976>, BranchRadius(0.022823811956887614)
  <0.9051597554103306, 2.011828981864874, 0.2309729316633053>, BranchRadius(0.01737680626870668)
  <0.8991413948664899, 1.9962390047866791, 0.2266321497594713>, BranchRadius(0.017265874911829477)
  <0.8938005350032313, 1.9826067801202782, 0.21774514981693244>, BranchRadius(0.01712720354911695)
  <0.88961518070425, 1.9701870239358195, 0.20692168826685722>, BranchRadius(0.016997495527734646)
  <0.8869174414716774, 1.9553535209124704, 0.19943508723127612>, BranchRadius(0.016833294507512)
  <0.8792826480324133, 1.9410943467999056, 0.19534909772514988>, BranchRadius(0.016682608533345283)
  <0.8719945438495034, 1.9267490992117102, 0.19142917845964086>, BranchRadius(0.016561049423139913)
  <0.866488555400452, 1.9194886774974405, 0.186967674219619>, BranchRadius(0.010145671606840979)
  <0.8636213904132664, 1.911583222531866, 0.1813937390063636>, BranchRadius(0.010088885321879584)
  <0.8654482528251441, 1.906190052169947, 0.17621433351585988>, BranchRadius(0.007697399175024837)
  <0.8673675751809354, 1.8995747497216044, 0.17287555853412312>, BranchRadius(0.0076546354039340484)
  <0.8671809222840026, 1.8936231603082234, 0.16815286306445187>, BranchRadius(0.007600007128197743)
  <0.8668716951258503, 1.8913544857703124, 0.16517170455502625>, BranchRadius(0.0037589641728307784)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.8673675751809354, 1.8995747497216044, 0.17287555853412312>, BranchRadius(0.0076546354039340484)
  <0.8671809222840026, 1.8936231603082234, 0.16815286306445187>, BranchRadius(0.007600007128197743)
  <0.8680830209033382, 1.8888966896254067, 0.1696122215576949>, BranchRadius(0.005028223766533629)
  <0.8704423821476903, 1.8881348903684796, 0.17143379235480688>, BranchRadius(0.003076531124187833)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <0.866488555400452, 1.9194886774974405, 0.186967674219619>, BranchRadius(0.010145671606840979)
  <0.8636213904132664, 1.911583222531866, 0.1813937390063636>, BranchRadius(0.010088885321879584)
  <0.8588482662456016, 1.9071389005396775, 0.1794107337762852>, BranchRadius(0.006816672357735507)
  <0.8551406115949454, 1.9019256942812988, 0.17725830427939232>, BranchRadius(0.006749605561810748)
  <0.8522299217253041, 1.8968245728620614, 0.17404504010593905>, BranchRadius(0.0066946711569301634)
  <0.8498664235864674, 1.8960864283475654, 0.16950280264023526>, BranchRadius(0.005173287346688598)
  <0.8459450655125585, 1.8955358111033975, 0.16623257268046637>, BranchRadius(0.005135623865038652)
  <0.8430758331936695, 1.8970391676896263, 0.16230423005579975>, BranchRadius(0.005091605925627746)
  <0.8413091458987703, 1.8992998252467184, 0.15814039947768568>, BranchRadius(0.0050566037685024654)
  <0.8402871526578216, 1.9021435325754967, 0.15412167192042853>, BranchRadius(0.0050280525788569935)
  <0.8404313353260082, 1.9039578210421233, 0.15246283343497385>, BranchRadius(0.0024625548527423343)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.8792826480324133, 1.9410943467999056, 0.19534909772514988>, BranchRadius(0.016682608533345283)
  <0.8719945438495034, 1.9267490992117102, 0.19142917845964086>, BranchRadius(0.016561049423139913)
  <0.8675542864669912, 1.917067486245618, 0.1894359410604494>, BranchRadius(0.01083616678432437)
  <0.8648704342335449, 1.911700676311374, 0.1891930170402856>, BranchRadius(0.006005391224628765)
  <0.8611577129125199, 1.9073122376653633, 0.19077788604984347>, BranchRadius(0.005962759691187509)
  <0.8594420621549367, 1.9050694602537428, 0.19110929059473117>, BranchRadius(0.002843120998558274)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.8719945438495034, 1.9267490992117102, 0.19142917845964086>, BranchRadius(0.016561049423139913)
  <0.8675542864669912, 1.917067486245618, 0.1894359410604494>, BranchRadius(0.01083616678432437)
  <0.8665322449381623, 1.9131451143505307, 0.1856185246645678>, BranchRadius(0.005567965347374875)
  <0.865332866088647, 1.909351868307698, 0.181763551168835>, BranchRadius(0.0055396792162483175)
  <0.8662218319665466, 1.9052398049920158, 0.17820800504637246>, BranchRadius(0.005508287689764165)
  <0.8673659891002874, 1.9021250211309984, 0.1738623017426227>, BranchRadius(0.005467733648575728)
  <0.8681749968345309, 1.9021819078024553, 0.17022167127232762>, BranchRadius(0.003729868607430589)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.8996712173767956, 2.041576917663611, 0.2539194389466286>, BranchRadius(0.050456399819028816)
  <0.9084079870918413, 2.02711172262832, 0.23857820758207976>, BranchRadius(0.022823811956887614)
  <0.9160374130698719, 2.025025971692978, 0.2319748248039644>, BranchRadius(0.010303550933189904)
  <0.9188096427786769, 2.02580944373307, 0.22637444095026524>, BranchRadius(0.006297887368376948)
  <0.9198417872682265, 2.0289500615780725, 0.2210565638277374>, BranchRadius(0.006261678671567228)
  <0.9211835573905152, 2.030110892885806, 0.21910914468988713>, BranchRadius(0.0026344482694762215)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.9084079870918413, 2.02711172262832, 0.23857820758207976>, BranchRadius(0.022823811956887614)
  <0.9160374130698719, 2.025025971692978, 0.2319748248039644>, BranchRadius(0.010303550933189904)
  <0.9202961088866922, 2.021853186680874, 0.23246004927158134>, BranchRadius(0.005332775785386947)
  <0.9205520136881487, 2.0201575347709197, 0.23377359099779232>, BranchRadius(0.0021601191017250132)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  19
  <0.8635176844506669, 2.0374947505149215, 0.28887807523334863>, BranchRadius(0.05093408211547669)
  <0.8996712173767956, 2.041576917663611, 0.2539194389466286>, BranchRadius(0.050456399819028816)
  <0.9223004089602125, 2.0735651780653765, 0.2451687095219496>, BranchRadius(0.04014852899813526)
  <0.9475130494650902, 2.1031200454642884, 0.23672451142145678>, BranchRadius(0.0397551494747012)
  <0.9761590213383754, 2.1298677931775565, 0.23231979859391047>, BranchRadius(0.03943900616636832)
  <1.000161987046406, 2.135346194911375, 0.24733990641879983>, BranchRadius(0.02884023036331889)
  <1.0224698320878192, 2.138753101181298, 0.26490668437185494>, BranchRadius(0.028597878389413564)
  <1.0376243424922744, 2.1352093862007986, 0.2734067292516161>, BranchRadius(0.017733241791046368)
  <1.046644953872398, 2.1324980592869363, 0.27623437462180034>, BranchRadius(0.009834546336490429)
  <1.0555994937076396, 2.1298470629881456, 0.2790284019388235>, BranchRadius(0.00974772556473558)
  <1.0644551981703392, 2.127131629815078, 0.28174280146215597>, BranchRadius(0.009652204080951734)
  <1.0716235363252438, 2.1208483614814835, 0.2828860042666969>, BranchRadius(0.009600596101665968)
  <1.0767065003258351, 2.1128533348083045, 0.2817678445814259>, BranchRadius(0.009539772304301556)
  <1.080021467840029, 2.1041600277873007, 0.27995048241502873>, BranchRadius(0.009479736379533315)
  <1.0827600384032188, 2.095183570006608, 0.28070875709885373>, BranchRadius(0.0094154948629509)
  <1.0822010898977452, 2.0881078983603656, 0.2805591039803611>, BranchRadius(0.007099292129014475)
  <1.0814367235371578, 2.081676404027437, 0.28329702142849333>, BranchRadius(0.007031683101539253)
  <1.0813026513080695, 2.075315040447024, 0.2861785355926576>, BranchRadius(0.006984844009933128)
  <1.0786443554905196, 2.0742136844942802, 0.28899925705575263>, BranchRadius(0.004029390916827481)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.0814367235371578, 2.081676404027437, 0.28329702142849333>, BranchRadius(0.007031683101539253)
  <1.0813026513080695, 2.075315040447024, 0.2861785355926576>, BranchRadius(0.006984844009933128)
  <1.082552088283551, 2.070449578738195, 0.2871911841461893>, BranchRadius(0.005124379717463803)
  <1.0833334738402598, 2.065461846001458, 0.2865611808711227>, BranchRadius(0.005087724969762592)
  <1.0859285646877308, 2.0625607754601023, 0.2860367249731449>, BranchRadius(0.003927564230089098)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.0224698320878192, 2.138753101181298, 0.26490668437185494>, BranchRadius(0.028597878389413564)
  <1.0376243424922744, 2.1352093862007986, 0.2734067292516161>, BranchRadius(0.017733241791046368)
  <1.0463925057023127, 2.1339152390377363, 0.28112853988479874>, BranchRadius(0.011755078154238851)
  <1.0516996977191793, 2.128812415784497, 0.28343907487131315>, BranchRadius(0.007716454119710653)
  <1.0576193068715984, 2.1242832742735676, 0.2852482825098409>, BranchRadius(0.007669949649295901)
  <1.0607125522027916, 2.123964501681214, 0.2837471381083038>, BranchRadius(0.003453001181414611)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.0376243424922744, 2.1352093862007986, 0.2734067292516161>, BranchRadius(0.017733241791046368)
  <1.0463925057023127, 2.1339152390377363, 0.28112853988479874>, BranchRadius(0.011755078154238851)
  <1.0510163645344985, 2.1358159275036286, 0.28661392366860355>, BranchRadius(0.007421733112958707)
  <1.0531562539821393, 2.1334123466075945, 0.28947876627932917>, BranchRadius(0.004308555576539911)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <1.000161987046406, 2.135346194911375, 0.24733990641879983>, BranchRadius(0.02884023036331889)
  <1.0224698320878192, 2.138753101181298, 0.26490668437185494>, BranchRadius(0.028597878389413564)
  <1.0350017589218534, 2.140980536596944, 0.2749589839951669>, BranchRadius(0.01621910559868519)
  <1.0473692177473184, 2.145374266972872, 0.28430479551927335>, BranchRadius(0.016112203370738765)
  <1.0562469405609562, 2.1419459642229217, 0.28888161101547943>, BranchRadius(0.010560040823188815)
  <1.0582023655103916, 2.1374795958533337, 0.29079482754781294>, BranchRadius(0.005237607339742424)
  <1.061394826220018, 2.133768570955857, 0.29251655048573333>, BranchRadius(0.005189204278804329)
  <1.063341650644578, 2.129256078514782, 0.2940832628625966>, BranchRadius(0.005158226540453538)
  <1.0639293482580192, 2.124212643223436, 0.2946561449513365>, BranchRadius(0.0051097770900932135)
  <1.0646033440153977, 2.1227020889175527, 0.296697589531862>, BranchRadius(0.0026274589563573545)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <1.0473692177473184, 2.145374266972872, 0.28430479551927335>, BranchRadius(0.016112203370738765)
  <1.0562469405609562, 2.1419459642229217, 0.28888161101547943>, BranchRadius(0.010560040823188815)
  <1.0628427349616778, 2.1429060596791425, 0.2914266508020685>, BranchRadius(0.007134669899649728)
  <1.0697449020024872, 2.1440389489990705, 0.2925907125587464>, BranchRadius(0.007090725480781421)
  <1.076402011892075, 2.143510135335255, 0.29477565599203825>, BranchRadius(0.007026431084111644)
  <1.0820639210120653, 2.1444604577470217, 0.2987049282156969>, BranchRadius(0.006956975476236139)
  <1.084806168767703, 2.1474289964703765, 0.3025311545315899>, BranchRadius(0.00556526304192256)
  <1.0870645346707979, 2.150637552072376, 0.3064265753428432>, BranchRadius(0.005528955498114181)
  <1.089648017295406, 2.1531163820927843, 0.31058135398144904>, BranchRadius(0.005484630003705426)
  <1.0928224966064335, 2.1538197100548535, 0.31495488045678943>, BranchRadius(0.0054497452187118765)
  <1.096358016203632, 2.155120592898303, 0.3188176152898979>, BranchRadius(0.005395638552151704)
  <1.099048812926586, 2.1584305636412426, 0.32206274410067204>, BranchRadius(0.005359771853530086)
  <1.1001964173246082, 2.1599570196335662, 0.3239026269609883>, BranchRadius(0.0026518357208820914)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  20
  <1.0350017589218534, 2.140980536596944, 0.2749589839951669>, BranchRadius(0.01621910559868519)
  <1.0473692177473184, 2.145374266972872, 0.28430479551927335>, BranchRadius(0.016112203370738765)
  <1.0537283900382686, 2.148110560487401, 0.2892648040824397>, BranchRadius(0.008516340726528219)
  <1.061617481249301, 2.149760030201481, 0.2918618382544352>, BranchRadius(0.008467768121776237)
  <1.0699004690423959, 2.1512172165166787, 0.2918773569353591>, BranchRadius(0.008410203301182079)
  <1.0779661474843878, 2.153409583610794, 0.29165799356289646>, BranchRadius(0.00836120580383879)
  <1.0860556579635483, 2.1553248059500905, 0.29171219766557754>, BranchRadius(0.008313314290109243)
  <1.0934787203016083, 2.156720932565624, 0.29505727036131163>, BranchRadius(0.008260782973851225)
  <1.1008397533415804, 2.160078808744552, 0.29639379209335665>, BranchRadius(0.008200392075309726)
  <1.1077041592400516, 2.1643081470985557, 0.297618770111914>, BranchRadius(0.00815524018024976)
  <1.1132679036832167, 2.1697471731139983, 0.2998090165476148>, BranchRadius(0.00808303381624826)
  <1.1205150936999313, 2.1731305878029334, 0.2992327601186331>, BranchRadius(0.008018810982160278)
  <1.1275437737957794, 2.1768603316756834, 0.2991571419986159>, BranchRadius(0.007957326897027796)
  <1.132609616517155, 2.182712283853984, 0.2976100836777217>, BranchRadius(0.007893129684927272)
  <1.1375493790008844, 2.188549977168977, 0.2959669938807032>, BranchRadius(0.007821742818364836)
  <1.1414509451466164, 2.195185671422202, 0.29500855866734144>, BranchRadius(0.007757142171574238)
  <1.1468541605642462, 2.2005408178292085, 0.29628155743243056>, BranchRadius(0.007713161203145364)
  <1.1516494584381212, 2.2065125119005615, 0.2965827649473136>, BranchRadius(0.00766464204957051)
  <1.1562699036368707, 2.2125771253733064, 0.2966548590734243>, BranchRadius(0.007624516245078656)
  <1.159235144823355, 2.213373147087408, 0.296563829980902>, BranchRadius(0.0030715781219155386)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  26
  <0.9475130494650902, 2.1031200454642884, 0.23672451142145678>, BranchRadius(0.0397551494747012)
  <0.9761590213383754, 2.1298677931775565, 0.23231979859391047>, BranchRadius(0.03943900616636832)
  <0.9785511665525719, 2.142419444728639, 0.22055128120909312>, BranchRadius(0.01737136485202997)
  <0.9859503766271197, 2.1522931434531474, 0.20856282785852412>, BranchRadius(0.017203524347307965)
  <0.9929561320309547, 2.162968758805936, 0.19719094881763743>, BranchRadius(0.017098801269668503)
  <0.9962739077486594, 2.1783463669938286, 0.19074377055520178>, BranchRadius(0.017001311033004143)
  <1.0048769151349988, 2.1928492473114916, 0.18996904322478267>, BranchRadius(0.016880328078398243)
  <1.012386532857073, 2.2076675159030015, 0.19189908284667356>, BranchRadius(0.016724248722256148)
  <1.0236300611051121, 2.218829259252709, 0.19672856455563412>, BranchRadius(0.01656276956448953)
  <1.035368554375841, 2.2293797624540463, 0.20129895614719973>, BranchRadius(0.016431488714314234)
  <1.044839527923202, 2.236318986655258, 0.20585890056671427>, BranchRadius(0.012595446223082158)
  <1.0542328128633907, 2.239211903516568, 0.2135947086834454>, BranchRadius(0.012507817441620587)
  <1.0591518241495739, 2.2401881045857173, 0.22493920161511466>, BranchRadius(0.012403514035856895)
  <1.0628655351957736, 2.2353767049943474, 0.23564032856581693>, BranchRadius(0.01230671905007782)
  <1.0679198120426807, 2.239401608598344, 0.24177138062188022>, BranchRadius(0.008907040068440564)
  <1.0757507843898444, 2.2423061149920005, 0.24470633684204554>, BranchRadius(0.008852923432805705)
  <1.084065189555009, 2.2425534599983763, 0.2474831962538335>, BranchRadius(0.008769347809018072)
  <1.091748666168335, 2.2449741129993703, 0.25074347651472134>, BranchRadius(0.008690500629899497)
  <1.099104299351294, 2.247655037927188, 0.2543968861990712>, BranchRadius(0.008639450232077439)
  <1.1036887043184795, 2.251467039872114, 0.2565725832565906>, BranchRadius(0.006346793317682014)
  <1.1091722416031486, 2.254591408420861, 0.25650781899899683>, BranchRadius(0.006311501753926572)
  <1.1137598899907268, 2.2588607640360294, 0.256432460574165>, BranchRadius(0.006267343455485035)
  <1.1192054778003075, 2.2618635821664888, 0.25621348358071233>, BranchRadius(0.00622248296422984)
  <1.1249328187445802, 2.2641768095983306, 0.2560177449337748>, BranchRadius(0.006179948952966506)
  <1.130115372421831, 2.2673736586380486, 0.2553909865228477>, BranchRadius(0.0061213995545136325)
  <1.1330029070296825, 2.2672520481252794, 0.2563633314697172>, BranchRadius(0.0030492785907587153)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.091748666168335, 2.2449741129993703, 0.25074347651472134>, BranchRadius(0.008690500629899497)
  <1.099104299351294, 2.247655037927188, 0.2543968861990712>, BranchRadius(0.008639450232077439)
  <1.104715157002564, 2.2484537835986407, 0.257242656594193>, BranchRadius(0.006341776357790449)
  <1.1093994707586168, 2.251779838591815, 0.25978700595151183>, BranchRadius(0.0062832436555377985)
  <1.1137994487780858, 2.2545299138826094, 0.2632508690937939>, BranchRadius(0.006238675223579817)
  <1.1177050728196682, 2.2561043625135615, 0.26211507184052085>, BranchRadius(0.004361516140774563)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <1.0591518241495739, 2.2401881045857173, 0.22493920161511466>, BranchRadius(0.012403514035856895)
  <1.0628655351957736, 2.2353767049943474, 0.23564032856581693>, BranchRadius(0.01230671905007782)
  <1.0611562244432724, 2.227199724715445, 0.23900302856502548>, BranchRadius(0.009005137478953365)
  <1.0617737628530883, 2.220458969819146, 0.24482404339943048>, BranchRadius(0.008927672930945835)
  <1.0661971544202957, 2.216218794516738, 0.2477320038194643>, BranchRadius(0.006782456292264147)
  <1.0698338427555028, 2.2120521886495492, 0.25154113549231727>, BranchRadius(0.006715325055502126)
  <1.0723432565114173, 2.211354553660218, 0.25233202832717383>, BranchRadius(0.002722014594549397)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.0611562244432724, 2.227199724715445, 0.23900302856502548>, BranchRadius(0.009005137478953365)
  <1.0617737628530883, 2.220458969819146, 0.24482404339943048>, BranchRadius(0.008927672930945835)
  <1.0581803743062737, 2.2181264983590556, 0.24754936530877034>, BranchRadius(0.005077424925101628)
  <1.0545525340051558, 2.215406443391114, 0.24976447227060478>, BranchRadius(0.005046446584618434)
  <1.0527148087909446, 2.214475401110695, 0.250540046465797>, BranchRadius(0.002201269866037064)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <1.0236300611051121, 2.218829259252709, 0.19672856455563412>, BranchRadius(0.01656276956448953)
  <1.035368554375841, 2.2293797624540463, 0.20129895614719973>, BranchRadius(0.016431488714314234)
  <1.0422390416221747, 2.237994195142289, 0.20262133221601938>, BranchRadius(0.01109778013882451)
  <1.0434176081821103, 2.2441249393319223, 0.20580762907958022>, BranchRadius(0.007009103448919791)
  <1.0433269867249155, 2.248901234386659, 0.21084902106373596>, BranchRadius(0.006945274640812846)
  <1.0437146116494753, 2.2544729665412295, 0.21491615535622427>, BranchRadius(0.006909126836116873)
  <1.0443496244281176, 2.2599680891543783, 0.21898260982698145>, BranchRadius(0.00686554191053552)
  <1.04490655168348, 2.2655795997440267, 0.2227946565969823>, BranchRadius(0.006806681984798231)
  <1.0469816375829226, 2.2718087661226116, 0.22438156466513318>, BranchRadius(0.006754759246555304)
  <1.0497133673505383, 2.277944826680749, 0.22460218000687338>, BranchRadius(0.006720287034451401)
  <1.0498088336763307, 2.2824009090669244, 0.2247487065255157>, BranchRadius(0.004459512761772238)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.0469816375829226, 2.2718087661226116, 0.22438156466513318>, BranchRadius(0.006754759246555304)
  <1.0497133673505383, 2.277944826680749, 0.22460218000687338>, BranchRadius(0.006720287034451401)
  <1.0549914193098227, 2.2788604243006287, 0.22467040097655538>, BranchRadius(0.005357313280660323)
  <1.0594062166002611, 2.2816522603615814, 0.22367021029413503>, BranchRadius(0.005318379932657817)
  <1.0639361281399176, 2.2842119342400298, 0.2244836771271479>, BranchRadius(0.005266284953317249)
  <1.0685391133182545, 2.2848885819742817, 0.22688295013500137>, BranchRadius(0.005234676272175042)
  <1.0734870584190968, 2.285481775194348, 0.2283972075394998>, BranchRadius(0.005208360049416821)
  <1.0743817131151003, 2.2868960516946406, 0.23069651363317503>, BranchRadius(0.002843834305435722)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.035368554375841, 2.2293797624540463, 0.20129895614719973>, BranchRadius(0.016431488714314234)
  <1.0422390416221747, 2.237994195142289, 0.20262133221601938>, BranchRadius(0.01109778013882451)
  <1.0475735319874342, 2.2403663556867817, 0.20090272217202165>, BranchRadius(0.006085848633446435)
  <1.053031789647777, 2.24243908667537, 0.19934297996275405>, BranchRadius(0.006043309209126726)
  <1.05702064780576, 2.24442075928513, 0.1953403986190882>, BranchRadius(0.0059882111810994456)
  <1.060258964756871, 2.2440000872398853, 0.1939583325589936>, BranchRadius(0.003545950964123489)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  30
  <0.03698388727786486, 0.9937133894049506, -0.001604299211729634>, BranchRadius(0.9944026759702618)
  <0.16393053028957108, 1.3960759668812803, -0.004736197499282058>, BranchRadius(0.42192523355710865)
  <0.23708942792837845, 1.7179738845026318, -0.0011753661890609372>, BranchRadius(0.3301259959353514)
  <0.359807672317756, 2.0115867255808246, 0.07841277183730645>, BranchRadius(0.3280282604693126)
  <0.47773088587856144, 2.306513001551908, 0.15242293774726243>, BranchRadius(0.3261363169177855)
  <0.5986180504853503, 2.606690662049557, 0.14109489921904805>, BranchRadius(0.3238034263027604)
  <0.7029942432134747, 2.9083336341432013, 0.1777324102437601>, BranchRadius(0.32128675577432647)
  <0.8228775171995562, 3.193247059354079, 0.25734684085347687>, BranchRadius(0.3191960476076195)
  <0.9602025003769195, 3.4783547076866124, 0.2656819459318523>, BranchRadius(0.3165659427655448)
  <1.1203782008818886, 3.621351411560921, 0.2598339130876561>, BranchRadius(0.21479877057218266)
  <1.3028313888798053, 3.731637143879279, 0.2613123292597698>, BranchRadius(0.2132001272935303)
  <1.4766560576673946, 3.8515707838903936, 0.2803091309640916>, BranchRadius(0.2120376663718598)
  <1.5432887193782563, 3.8543367609883106, 0.35698397797833953>, BranchRadius(0.1016198523942968)
  <1.5944535210388093, 3.8235544444295937, 0.4384579666162911>, BranchRadius(0.1010118743824796)
  <1.6517552068056927, 3.792568166258554, 0.5147354640088464>, BranchRadius(0.10030896886665193)
  <1.687719941783021, 3.7499504836772153, 0.5287058987881059>, BranchRadius(0.05748827774872698)
  <1.6990944921267832, 3.7252489681712726, 0.5408309345780341>, BranchRadius(0.029775186930062373)
  <1.7149378001596647, 3.700315748369478, 0.5412782486074753>, BranchRadius(0.029544474084848792)
  <1.722310439203376, 3.689762582957367, 0.5310329794153612>, BranchRadius(0.016452679037260914)
  <1.7322435049706186, 3.6778355760828, 0.5259458122190618>, BranchRadius(0.016333969468730992)
  <1.742605107925859, 3.6662901008527875, 0.5212894186890727>, BranchRadius(0.01619700017889134)
  <1.7537536228363888, 3.6564424711121886, 0.5152699661047039>, BranchRadius(0.016046775552543094)
  <1.765842573947175, 3.646871929717867, 0.5111843682338149>, BranchRadius(0.015950865540841876)
  <1.7782351163386698, 3.6371196893177866, 0.512288306445319>, BranchRadius(0.01580822505282539)
  <1.790801968567137, 3.6279093043485955, 0.5139471512036738>, BranchRadius(0.015668718267463966)
  <1.7922669282724557, 3.620613204386109, 0.5118315711337517>, BranchRadius(0.007736592314000905)
  <1.7947367685740505, 3.613689301054172, 0.5095650228060451>, BranchRadius(0.007692710171793726)
  <1.797506190208151, 3.6071728212267593, 0.5067593091482937>, BranchRadius(0.007616182420202158)
  <1.8002462861324877, 3.6004899630227443, 0.504501731596127>, BranchRadius(0.007567388972002248)
  <1.801705636725004, 3.597474801006963, 0.5067594502407885>, BranchRadius(0.004039579137947358)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.797506190208151, 3.6071728212267593, 0.5067593091482937>, BranchRadius(0.007616182420202158)
  <1.8002462861324877, 3.6004899630227443, 0.504501731596127>, BranchRadius(0.007567388972002248)
  <1.8022629798514664, 3.5955243651893642, 0.502540912853284>, BranchRadius(0.005706927854925052)
  <1.8030737335964577, 3.5934970040624306, 0.5016542125590459>, BranchRadius(0.0023566400204149476)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.7782351163386698, 3.6371196893177866, 0.512288306445319>, BranchRadius(0.01580822505282539)
  <1.790801968567137, 3.6279093043485955, 0.5139471512036738>, BranchRadius(0.015668718267463966)
  <1.8001599721190198, 3.62671001000882, 0.5172824206276507>, BranchRadius(0.010006725714287528)
  <1.801719739053131, 3.6260454331533998, 0.5216660450282662>, BranchRadius(0.004700074272942812)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <1.6990944921267832, 3.7252489681712726, 0.5408309345780341>, BranchRadius(0.029775186930062373)
  <1.7149378001596647, 3.700315748369478, 0.5412782486074753>, BranchRadius(0.029544474084848792)
  <1.7237300987866782, 3.685376022676092, 0.5525129284420055>, BranchRadius(0.020657152512498316)
  <1.726560427926346, 3.668562188826228, 0.5638327827864302>, BranchRadius(0.020465944252554567)
  <1.7214130093242501, 3.651036629158402, 0.5727929015422942>, BranchRadius(0.020345144090295995)
  <1.7153319687594963, 3.6347993990853533, 0.5831441163788882>, BranchRadius(0.020193423270674922)
  <1.7090218177360577, 3.6162274667130654, 0.5873053656999471>, BranchRadius(0.02005120130793792)
  <1.7033730582066797, 3.598869684195163, 0.5952448335531528>, BranchRadius(0.019905683810199266)
  <1.701415491760633, 3.5907895922951756, 0.5956942718180236>, BranchRadius(0.008325980197962263)
  <1.6982452655111342, 3.5832316315075357, 0.5965792377052752>, BranchRadius(0.008243559326050509)
  <1.6973723391671531, 3.579025101857137, 0.5994309423962458>, BranchRadius(0.005156463104318764)
  <1.6985664656300452, 3.5766867288878155, 0.6024572145457012>, BranchRadius(0.004006525836133203)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.7090218177360577, 3.6162274667130654, 0.5873053656999471>, BranchRadius(0.02005120130793792)
  <1.7033730582066797, 3.598869684195163, 0.5952448335531528>, BranchRadius(0.019905683810199266)
  <1.7008173233963473, 3.5910404032610095, 0.5988638545271484>, BranchRadius(0.008995928700076814)
  <1.698721371417744, 3.590265571565032, 0.6052321830072611>, BranchRadius(0.006748998924604889)
  <1.6980745745104775, 3.5902227940525653, 0.6080863512251248>, BranchRadius(0.0029268502473966214)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.7008173233963473, 3.5910404032610095, 0.5988638545271484>, BranchRadius(0.008995928700076814)
  <1.698721371417744, 3.590265571565032, 0.6052321830072611>, BranchRadius(0.006748998924604889)
  <1.6953586916370837, 3.5873621922647465, 0.6079319943049127>, BranchRadius(0.005198673649260223)
  <1.6937272830340113, 3.5857473160850493, 0.6073891434336632>, BranchRadius(0.002358814569725524)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  20
  <1.6517552068056927, 3.792568166258554, 0.5147354640088464>, BranchRadius(0.10030896886665193)
  <1.687719941783021, 3.7499504836772153, 0.5287058987881059>, BranchRadius(0.05748827774872698)
  <1.7132089883615884, 3.72917424325337, 0.5321330231245981>, BranchRadius(0.033061894120748433)
  <1.726225036564094, 3.699939998295391, 0.5393449298319731>, BranchRadius(0.03280350876703523)
  <1.7442800476593807, 3.6771479929770505, 0.5539281417737075>, BranchRadius(0.03252889488777196)
  <1.7630653913931724, 3.6514738961443927, 0.5596889193344052>, BranchRadius(0.032330093496203006)
  <1.7701340135732866, 3.6314895908942577, 0.5720719792124875>, BranchRadius(0.02454950198680083)
  <1.781441413756122, 3.613424120599972, 0.5838971763347245>, BranchRadius(0.024373218967306494)
  <1.788108269299095, 3.5987586309248085, 0.5937949139137695>, BranchRadius(0.018907373149828127)
  <1.794016744682901, 3.5901603680549052, 0.6006911750691794>, BranchRadius(0.012505943533560838)
  <1.8024117497898355, 3.5836561343173865, 0.6071073125953708>, BranchRadius(0.012407577846329792)
  <1.8109006462340247, 3.576057579261996, 0.6117527433260092>, BranchRadius(0.012303634765512396)
  <1.8183801568214473, 3.5673928213383803, 0.6160371501624305>, BranchRadius(0.012221998627156228)
  <1.8256311726916494, 3.557915700866102, 0.6180439491141219>, BranchRadius(0.012100425018507202)
  <1.8246141420460715, 3.5511035644768407, 0.6179348598657582>, BranchRadius(0.006888501577560343)
  <1.8259788931600178, 3.544663055082744, 0.616042303206899>, BranchRadius(0.0068501443463227394)
  <1.8281852359002686, 3.539502613515594, 0.6122055823244348>, BranchRadius(0.0067984213303799255)
  <1.828058397980703, 3.5347088168278193, 0.6074823600169605>, BranchRadius(0.006730928874039644)
  <1.8305035080128051, 3.5300471794804156, 0.6033625633260007>, BranchRadius(0.006684470854349073)
  <1.8332441675438877, 3.5274032625836114, 0.6011134691519872>, BranchRadius(0.0044226616223832695)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.8183801568214473, 3.5673928213383803, 0.6160371501624305>, BranchRadius(0.012221998627156228)
  <1.8256311726916494, 3.557915700866102, 0.6180439491141219>, BranchRadius(0.012100425018507202)
  <1.831080508024098, 3.5554934086116163, 0.6194525952289681>, BranchRadius(0.006127563888568063)
  <1.8360734659174087, 3.5528844311590855, 0.621772201080036>, BranchRadius(0.006092369258055409)
  <1.8403661740416333, 3.548618364602149, 0.6219010268077313>, BranchRadius(0.006053367903581414)
  <1.8423042497568127, 3.546955304491386, 0.622155640907154>, BranchRadius(0.0025664634712780046)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.781441413756122, 3.613424120599972, 0.5838971763347245>, BranchRadius(0.024373218967306494)
  <1.788108269299095, 3.5987586309248085, 0.5937949139137695>, BranchRadius(0.018907373149828127)
  <1.7825168876606408, 3.5867038238892976, 0.5958777760120023>, BranchRadius(0.013450659307651007)
  <1.7812868366738486, 3.5737663813139027, 0.5989568690718665>, BranchRadius(0.013355570369439757)
  <1.7843857990861676, 3.564742194206163, 0.6012841201958448>, BranchRadius(0.009821182147914713)
  <1.7908499707187389, 3.5578083962629177, 0.6036287251838134>, BranchRadius(0.009765256850830765)
  <1.7968264108477257, 3.5530201209636743, 0.6095913463763197>, BranchRadius(0.009705579242993988)
  <1.8025533361891983, 3.546630412051062, 0.6139721258321552>, BranchRadius(0.009634172641975424)
  <1.8067699607477639, 3.5469524525764853, 0.6165057580154677>, BranchRadius(0.0049297996722208505)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.7825168876606408, 3.5867038238892976, 0.5958777760120023>, BranchRadius(0.013450659307651007)
  <1.7812868366738486, 3.5737663813139027, 0.5989568690718665>, BranchRadius(0.013355570369439757)
  <1.77549351388129, 3.5706193706423606, 0.5994566124406273>, BranchRadius(0.0066118082685601084)
  <1.7709900219269366, 3.5671823092378414, 0.6027613709386022>, BranchRadius(0.0065586781908627085)
  <1.7688883454879145, 3.5681620443649202, 0.6063415130752503>, BranchRadius(0.004265482679858862)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.7701340135732866, 3.6314895908942577, 0.5720719792124875>, BranchRadius(0.02454950198680083)
  <1.781441413756122, 3.613424120599972, 0.5838971763347245>, BranchRadius(0.024373218967306494)
  <1.7864934655887628, 3.6061559178325284, 0.5885951046722753>, BranchRadius(0.010021004433345101)
  <1.792969657097981, 3.5988636289857476, 0.5904206922897933>, BranchRadius(0.00992226300992819)
  <1.799635531779501, 3.59180785249527, 0.5920873501776588>, BranchRadius(0.009848635218571789)
  <1.8022003581037238, 3.5882227523452768, 0.5931295200913577>, BranchRadius(0.004529613149920115)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.792969657097981, 3.5988636289857476, 0.5904206922897933>, BranchRadius(0.00992226300992819)
  <1.799635531779501, 3.59180785249527, 0.5920873501776588>, BranchRadius(0.009848635218571789)
  <1.8052935111729487, 3.5918951631736853, 0.590702922421066>, BranchRadius(0.0058255466854595355)
  <1.8109737362062426, 3.5909349983855336, 0.5901698090842813>, BranchRadius(0.005785419836029341)
  <1.8166943664712243, 3.5907027589655414, 0.5906822161206795>, BranchRadius(0.005748226400184016)
  <1.8199664084740943, 3.5905741311925956, 0.5922563508080146>, BranchRadius(0.003633277306563706)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <1.7442800476593807, 3.6771479929770505, 0.5539281417737075>, BranchRadius(0.03252889488777196)
  <1.7630653913931724, 3.6514738961443927, 0.5596889193344052>, BranchRadius(0.032330093496203006)
  <1.7787365130224668, 3.632997624924518, 0.561583914399684>, BranchRadius(0.0243011863415749)
  <1.7930800837485548, 3.6136100245022496, 0.5631642417624928>, BranchRadius(0.024168460974614604)
  <1.8054015673979091, 3.61168779265227, 0.5727357778275828>, BranchRadius(0.01572031288657134)
  <1.8169735520089285, 3.612289953862629, 0.5831817751482379>, BranchRadius(0.015601034772862439)
  <1.8172962399279604, 3.609983741399859, 0.5911666958258971>, BranchRadius(0.008317553825797273)
  <1.8155571507661874, 3.6110520109289896, 0.5991643643139756>, BranchRadius(0.008253988862645147)
  <1.8155826798247232, 3.6135248473913757, 0.6069940904719324>, BranchRadius(0.008210979455042422)
  <1.814793623833531, 3.6142772866354633, 0.6150887076413648>, BranchRadius(0.00816771701841759)
  <1.8148999445052936, 3.6184767041301464, 0.617738010091008>, BranchRadius(0.00496640864705868)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.8054015673979091, 3.61168779265227, 0.5727357778275828>, BranchRadius(0.01572031288657134)
  <1.8169735520089285, 3.612289953862629, 0.5831817751482379>, BranchRadius(0.015601034772862439)
  <1.825052710744876, 3.614539320608231, 0.5844174216531157>, BranchRadius(0.00847698524959613)
  <1.8332671752171368, 3.616167836008759, 0.5851539561776751>, BranchRadius(0.00840666236277291)
  <1.8366444308674363, 3.618967237850533, 0.5843273473659112>, BranchRadius(0.004463831149012523)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.825052710744876, 3.614539320608231, 0.5844174216531157>, BranchRadius(0.00847698524959613)
  <1.8332671752171368, 3.616167836008759, 0.5851539561776751>, BranchRadius(0.00840666236277291)
  <1.8376567827507653, 3.612868029794623, 0.5877588353282114>, BranchRadius(0.006078056493570748)
  <1.8409310590903585, 3.607977141385687, 0.5890794755299669>, BranchRadius(0.006032061465135785)
  <1.8426599015133944, 3.6023086132156132, 0.5898907737316702>, BranchRadius(0.005981581104582195)
  <1.8429049181082051, 3.596434394412486, 0.5890928023119962>, BranchRadius(0.005933231671303503)
  <1.8454446303545722, 3.5912558024463186, 0.5879426966258793>, BranchRadius(0.005881385562572861)
  <1.849695845749825, 3.5874424382691434, 0.5868036211110711>, BranchRadius(0.0058234072254163835)
  <1.8530325844862703, 3.5842773058797226, 0.5863840767803674>, BranchRadius(0.0046182145774401615)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <1.7787365130224668, 3.632997624924518, 0.561583914399684>, BranchRadius(0.0243011863415749)
  <1.7930800837485548, 3.6136100245022496, 0.5631642417624928>, BranchRadius(0.024168460974614604)
  <1.8020304420597082, 3.5966876203276046, 0.5614603980834625>, BranchRadius(0.01921925493432691)
  <1.8069466469080004, 3.5802721300972817, 0.5529728313141568>, BranchRadius(0.019122661406708638)
  <1.8129302066812119, 3.5756346864560102, 0.547923876263249>, BranchRadius(0.009099495491050524)
  <1.8178734950447686, 3.5710208091706135, 0.5419434001559151>, BranchRadius(0.00902718438497655)
  <1.8214607718045754, 3.5685408330534734, 0.5396455012646632>, BranchRadius(0.004929419378329806)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <1.8129302066812119, 3.5756346864560102, 0.547923876263249>, BranchRadius(0.009099495491050524)
  <1.8178734950447686, 3.5710208091706135, 0.5419434001559151>, BranchRadius(0.00902718438497655)
  <1.8203829593615095, 3.5678443159926996, 0.5369453134450253>, BranchRadius(0.0064318263997019355)
  <1.824865744624, 3.5656307359413386, 0.5329559132983016>, BranchRadius(0.006396140545990394)
  <1.8289250848840604, 3.564451298764441, 0.5282130560884442>, BranchRadius(0.006353267656434158)
  <1.8335217642485375, 3.5628866554264214, 0.5241733839526629>, BranchRadius(0.00631636928303166)
  <1.8342556499689697, 3.5614570787852387, 0.5201206853872951>, BranchRadius(0.004359660914039439)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.8020304420597082, 3.5966876203276046, 0.5614603980834625>, BranchRadius(0.01921925493432691)
  <1.8069466469080004, 3.5802721300972817, 0.5529728313141568>, BranchRadius(0.019122661406708638)
  <1.80733329988342, 3.571946363879926, 0.5498836618478865>, BranchRadius(0.008888804847717438)
  <1.8077960392097163, 3.5694645333814425, 0.5460411994175426>, BranchRadius(0.004597621976185885)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.8069466469080004, 3.5802721300972817, 0.5529728313141568>, BranchRadius(0.019122661406708638)
  <1.80733329988342, 3.571946363879926, 0.5498836618478865>, BranchRadius(0.008888804847717438)
  <1.8072283543591703, 3.5654462393883795, 0.5508923528061911>, BranchRadius(0.006578760477326053)
  <1.806772719663081, 3.5599919052894102, 0.5544819719355711>, BranchRadius(0.0065454357328959675)
  <1.8062839115332017, 3.5541869785765807, 0.5573405485445966>, BranchRadius(0.0064890344242287375)
  <1.8084771438286258, 3.552187927484905, 0.5587921252236968>, BranchRadius(0.0033035659557711806)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  28
  <1.5944535210388093, 3.8235544444295937, 0.4384579666162911>, BranchRadius(0.1010118743824796)
  <1.6517552068056927, 3.792568166258554, 0.5147354640088464>, BranchRadius(0.10030896886665193)
  <1.684358777904398, 3.7806392316776756, 0.5664792401837049>, BranchRadius(0.06231140105516059)
  <1.7230768291531873, 3.7814816628424155, 0.614887081422224>, BranchRadius(0.06199287278506192)
  <1.751990903463849, 3.7950591293333256, 0.6673957963623596>, BranchRadius(0.061461666380099665)
  <1.7805648353457721, 3.8012865422506232, 0.7207708812616321>, BranchRadius(0.06086172806320777)
  <1.8124347638554252, 3.8110545370267053, 0.7711391569603163>, BranchRadius(0.06039924885306623)
  <1.8285157182910112, 3.838534009717834, 0.8219260405343731>, BranchRadius(0.05994185564450513)
  <1.8536436845384832, 3.88197983108643, 0.8537968050758462>, BranchRadius(0.059453340651170174)
  <1.8750446708544342, 3.9259911679053108, 0.8865171837011417>, BranchRadius(0.05886954357953826)
  <1.8837748851018086, 3.9699589215520614, 0.9237839389089256>, BranchRadius(0.058294005225780356)
  <1.8790993484640375, 4.01166874889348, 0.9411542763790436>, BranchRadius(0.0454235507586965)
  <1.8775908590386994, 4.056360965619043, 0.9465657845683968>, BranchRadius(0.045043914095852094)
  <1.8832280850708059, 4.099938246557161, 0.9548422038378891>, BranchRadius(0.04471305007736746)
  <1.9040595152212394, 4.138722458105636, 0.9608770118390891>, BranchRadius(0.04443627409178877)
  <1.9031052199817617, 4.165557275409644, 0.9673500062784074>, BranchRadius(0.027620965880197978)
  <1.9120040978195032, 4.187481201430957, 0.9811045454944156>, BranchRadius(0.027368520383896533)
  <1.9298217077074047, 4.206242259168393, 0.9894063148472932>, BranchRadius(0.02717285196539384)
  <1.947717763450869, 4.21029254096661, 0.987022035806602>, BranchRadius(0.01850292896711295)
  <1.9599806788053307, 4.212391061765605, 0.9794986441596025>, BranchRadius(0.014539061331758764)
  <1.9674077866915518, 4.21674508175292, 0.9723480306691036>, BranchRadius(0.011191545688331793)
  <1.9748970523283196, 4.217352426236529, 0.972374133356111>, BranchRadius(0.007513897021526769)
  <1.9823514741801096, 4.217632267057798, 0.9726866218997691>, BranchRadius(0.007466214912498179)
  <1.9896758117162614, 4.217442789489601, 0.9715958566971808>, BranchRadius(0.00740753608290304)
  <1.9957249860765611, 4.217193472979317, 0.9674271440472805>, BranchRadius(0.007350702981419323)
  <1.9988198058888726, 4.220772008252495, 0.9640722734006097>, BranchRadius(0.005799912191399472)
  <2.0031920747553764, 4.223876833594905, 0.9620161931876823>, BranchRadius(0.005743182157119993)
  <2.004950445811284, 4.225655042554264, 0.962121948975891>, BranchRadius(0.002503014214929121)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.9599806788053307, 4.212391061765605, 0.9794986441596025>, BranchRadius(0.014539061331758764)
  <1.9674077866915518, 4.21674508175292, 0.9723480306691036>, BranchRadius(0.011191545688331793)
  <1.9715579598054531, 4.219841834017544, 0.9670826395751738>, BranchRadius(0.007384995249547094)
  <1.9761463711212295, 4.223319155423473, 0.9625425885696822>, BranchRadius(0.007331940104457116)
  <1.9771156785175514, 4.224652141688562, 0.958943070318352>, BranchRadius(0.003958906522404819)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.947717763450869, 4.21029254096661, 0.987022035806602>, BranchRadius(0.01850292896711295)
  <1.9599806788053307, 4.212391061765605, 0.9794986441596025>, BranchRadius(0.014539061331758764)
  <1.9686803964103292, 4.207144298257861, 0.9798284790694545>, BranchRadius(0.010164762898399756)
  <1.9716485893354643, 4.203647782624121, 0.97849362359498>, BranchRadius(0.004776780291738615)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.9599806788053307, 4.212391061765605, 0.9794986441596025>, BranchRadius(0.014539061331758764)
  <1.9686803964103292, 4.207144298257861, 0.9798284790694545>, BranchRadius(0.010164762898399756)
  <1.9753641426469546, 4.204186009520065, 0.980991711699211>, BranchRadius(0.007401151678131295)
  <1.9819568274712016, 4.2009862065660215, 0.9806098361278298>, BranchRadius(0.007338123812567839)
  <1.9883746662814719, 4.197634226606556, 0.981489049699232>, BranchRadius(0.007293657597351979)
  <1.9937549057144246, 4.196652089528586, 0.980901061350555>, BranchRadius(0.005500663586695888)
  <1.9990025656572261, 4.195448096519824, 0.9799785324082819>, BranchRadius(0.00546247139029213)
  <2.002241146557075, 4.195950677718256, 0.9826055138815418>, BranchRadius(0.004200241155783047)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.9298217077074047, 4.206242259168393, 0.9894063148472932>, BranchRadius(0.02717285196539384)
  <1.947717763450869, 4.21029254096661, 0.987022035806602>, BranchRadius(0.01850292896711295)
  <1.961915053953422, 4.213801845580804, 0.987707361869301>, BranchRadius(0.014640626636223428)
  <1.9755390580354169, 4.218722051727031, 0.9885517923380622>, BranchRadius(0.014509823519400864)
  <1.9839860116426795, 4.220795885568145, 0.9885505673241044>, BranchRadius(0.008697805099245)
  <1.9875723282187658, 4.223501971394634, 0.9888872806946755>, BranchRadius(0.004505323848310714)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <1.961915053953422, 4.213801845580804, 0.987707361869301>, BranchRadius(0.014640626636223428)
  <1.9755390580354169, 4.218722051727031, 0.9885517923380622>, BranchRadius(0.014509823519400864)
  <1.9816006194941433, 4.224171644902048, 0.9906793137760651>, BranchRadius(0.008424187827931563)
  <1.987532227636811, 4.229709357237145, 0.9927272926811731>, BranchRadius(0.008369256278799118)
  <1.9902625194190546, 4.2364990095276855, 0.9966531044074672>, BranchRadius(0.008304569173228414)
  <1.991648253192592, 4.243440031519805, 1.0008448921044626>, BranchRadius(0.008226124754882701)
  <1.9943519863799957, 4.248984680171639, 1.0061688692541488>, BranchRadius(0.008148498911537953)
  <1.996455110463333, 4.254336095684904, 1.0118818364776185>, BranchRadius(0.008105477987260426)
  <1.997302382924615, 4.258287058307473, 1.018833563209047>, BranchRadius(0.008040801005934984)
  <1.9975473079789774, 4.260007798513451, 1.0218882386973787>, BranchRadius(0.003514538017682852)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <1.996455110463333, 4.254336095684904, 1.0118818364776185>, BranchRadius(0.008105477987260426)
  <1.997302382924615, 4.258287058307473, 1.018833563209047>, BranchRadius(0.008040801005934984)
  <2.002625168512062, 4.26019654137469, 1.0211230108631106>, BranchRadius(0.0061007985177858074)
  <2.007317743359985, 4.26015841776554, 1.0249304304759765>, BranchRadius(0.006043025419553386)
  <2.0123831061913866, 4.260262695942099, 1.0281386074776746>, BranchRadius(0.005996763646007268)
  <2.0174800878495156, 4.2605218161309155, 1.0312075207241092>, BranchRadius(0.005955215681207412)
  <2.022616621849033, 4.2611412200249, 1.0340779406483684>, BranchRadius(0.005916667411107945)
  <2.0275625130476236, 4.261692460959391, 1.0372145843319869>, BranchRadius(0.005882536860414854)
  <2.0325141015101775, 4.262435609626018, 1.0401997517746755>, BranchRadius(0.005829384436121365)
  <2.037467786928667, 4.26279250202085, 1.0431402453433742>, BranchRadius(0.005771730575347489)
  <2.0392677297494703, 4.264789453401937, 1.0440773685734595>, BranchRadius(0.0028470702353386684)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <1.9120040978195032, 4.187481201430957, 0.9811045454944156>, BranchRadius(0.027368520383896533)
  <1.9298217077074047, 4.206242259168393, 0.9894063148472932>, BranchRadius(0.02717285196539384)
  <1.9254226635801988, 4.221962934424623, 1.0021087619226936>, BranchRadius(0.020684375297510802)
  <1.9214596720656483, 4.236211347776292, 1.0162750876241746>, BranchRadius(0.02047943770382581)
  <1.9189329297406927, 4.253224389332507, 1.027076628375609>, BranchRadius(0.020310127827640818)
  <1.9175708577414587, 4.2693495244941975, 1.0391591649757836>, BranchRadius(0.020195616227499432)
  <1.9103020673932551, 4.287341601009488, 1.0442345083116071>, BranchRadius(0.020057647928775003)
  <1.9014346303490148, 4.300995986605395, 1.0556700312134404>, BranchRadius(0.019895850566729177)
  <1.8926823349768904, 4.314611268080883, 1.0670579286388575>, BranchRadius(0.019790471740448623)
  <1.8887181258456827, 4.3231064487257385, 1.0843647340786144>, BranchRadius(0.01968269703964056)
  <1.8842028957355774, 4.329455102267022, 1.088515953310483>, BranchRadius(0.00882753226250068)
  <1.877148654780637, 4.3332542930159414, 1.0921032586127652>, BranchRadius(0.008778663060444707)
  <1.872984364676208, 4.333492015989241, 1.0974446803051416>, BranchRadius(0.006777064997597977)
  <1.8713960172977036, 4.334200574479043, 1.100079340725816>, BranchRadius(0.0031569507535818644)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.877148654780637, 4.3332542930159414, 1.0921032586127652>, BranchRadius(0.008778663060444707)
  <1.872984364676208, 4.333492015989241, 1.0974446803051416>, BranchRadius(0.006777064997597977)
  <1.8692689274982077, 4.330115569531425, 1.0987412064934703>, BranchRadius(0.005185156146461558)
  <1.8655742795045263, 4.3266143191343955, 1.0994136603249927>, BranchRadius(0.005134332702059713)
  <1.8613190210095445, 4.323836388227388, 1.0989836373962687>, BranchRadius(0.005099906342517503)
  <1.8584535096367636, 4.323247763717635, 1.098114662042063>, BranchRadius(0.003051680259666065)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <1.8842028957355774, 4.329455102267022, 1.088515953310483>, BranchRadius(0.00882753226250068)
  <1.877148654780637, 4.3332542930159414, 1.0921032586127652>, BranchRadius(0.008778663060444707)
  <1.8723438785306235, 4.33728276638312, 1.0922301231669698>, BranchRadius(0.006271408701230671)
  <1.8664489503778523, 4.339212577223987, 1.092827756562944>, BranchRadius(0.006231493679997222)
  <1.8610664294669874, 4.342236788073142, 1.0930665656328247>, BranchRadius(0.006178544520184377)
  <1.8558549548006933, 4.345475810199721, 1.093095607728146>, BranchRadius(0.006136088002725719)
  <1.8512887487653884, 4.349188097452075, 1.0946342570382392>, BranchRadius(0.006082660265072851)
  <1.8476175077918626, 4.352362274241547, 1.0982209693098572>, BranchRadius(0.00603472563551125)
  <1.84640832157397, 4.3557301273099345, 1.103012538420066>, BranchRadius(0.005980275924879482)
  <1.8447450449244014, 4.3562428711526495, 1.1068151732451776>, BranchRadius(0.004182036235423258)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.8926823349768904, 4.314611268080883, 1.0670579286388575>, BranchRadius(0.019790471740448623)
  <1.8887181258456827, 4.3231064487257385, 1.0843647340786144>, BranchRadius(0.01968269703964056)
  <1.8902721538158718, 4.323122549066989, 1.0932302250453325>, BranchRadius(0.009000677320850867)
  <1.8944895311653769, 4.322946516943935, 1.101128571456909>, BranchRadius(0.008955508642937577)
  <1.8979988766488687, 4.32181413955549, 1.1047182386865904>, BranchRadius(0.005146211722443324)
  <1.9015445158632842, 4.3206230515373205, 1.1081864448338266>, BranchRadius(0.005100853064493524)
  <1.9041114493590099, 4.317927865955169, 1.111602534736583>, BranchRadius(0.005052013768531231)
  <1.905643808383799, 4.3135809799124925, 1.113583484841222>, BranchRadius(0.005016742545311296)
  <1.9071873739446072, 4.310365711457966, 1.1124445822236189>, BranchRadius(0.0037440145629478233)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  18
  <1.8832280850708059, 4.099938246557161, 0.9548422038378891>, BranchRadius(0.04471305007736746)
  <1.9040595152212394, 4.138722458105636, 0.9608770118390891>, BranchRadius(0.04443627409178877)
  <1.92467128725891, 4.141485211872337, 0.9584472104239317>, BranchRadius(0.020937571249441178)
  <1.9450733453070541, 4.145299137748915, 0.9573589210744258>, BranchRadius(0.020783993285702313)
  <1.9631480376258224, 4.1553234239683015, 0.9579367440195041>, BranchRadius(0.020676428511282582)
  <1.9757519965064692, 4.158980996315908, 0.9577883266357027>, BranchRadius(0.013124772099462154)
  <1.9881205084541915, 4.162768617613473, 0.9565398261187845>, BranchRadius(0.0129955729552593)
  <1.999832738219103, 4.167874393917415, 0.9547310317909857>, BranchRadius(0.012904147188104164)
  <2.005370393352937, 4.171693192814406, 0.9537641423108347>, BranchRadius(0.006795860847880615)
  <2.011255229356736, 4.173907255115003, 0.951306546630966>, BranchRadius(0.00675078833827901)
  <2.0178117233526724, 4.174889246324962, 0.9504168333688301>, BranchRadius(0.0066890589729801195)
  <2.024413264040251, 4.175065981607555, 0.9510439775023466>, BranchRadius(0.006633617759117236)
  <2.0306704801331086, 4.176968116710884, 0.950240588045326>, BranchRadius(0.006589105083672897)
  <2.0371733915861663, 4.176724327564377, 0.9508658753269811>, BranchRadius(0.0065374516976313725)
  <2.04279515949683, 4.177222784963118, 0.9540932403711995>, BranchRadius(0.006501432099804538)
  <2.048998582508026, 4.177430985685784, 0.9558851606940785>, BranchRadius(0.006460401151654588)
  <2.0537057619794687, 4.178852725763218, 0.9599803650465917>, BranchRadius(0.00639918605081924)
  <2.055665610904283, 4.179725171656625, 0.9614260312932716>, BranchRadius(0.002586913323211561)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.9881205084541915, 4.162768617613473, 0.9565398261187845>, BranchRadius(0.0129955729552593)
  <1.999832738219103, 4.167874393917415, 0.9547310317909857>, BranchRadius(0.012904147188104164)
  <2.00969532509306, 4.1701652780147676, 0.953367566938606>, BranchRadius(0.010216545707699812)
  <2.0149638387787943, 4.172038076218032, 0.9531475779627278>, BranchRadius(0.0055958024193522235)
  <2.017748516255888, 4.174355370340865, 0.9528155091557926>, BranchRadius(0.0036379321593029666)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.9450733453070541, 4.145299137748915, 0.9573589210744258>, BranchRadius(0.020783993285702313)
  <1.9631480376258224, 4.1553234239683015, 0.9579367440195041>, BranchRadius(0.020676428511282582)
  <1.9681945986499054, 4.170852639048086, 0.9602041843823775>, BranchRadius(0.016485314220941693)
  <1.9716208381880365, 4.178251604511788, 0.9622260244688357>, BranchRadius(0.008400693104792871)
  <1.9776504459929818, 4.1833315506639615, 0.964925449026536>, BranchRadius(0.008333601630336985)
  <1.9844783153971823, 4.187978392066182, 0.9652189860648026>, BranchRadius(0.008264326930309889)
  <1.9902991624683992, 4.192163760227787, 0.9691879590904692>, BranchRadius(0.008194651557762311)
  <1.9950451946041774, 4.198385248521371, 0.9713666839721414>, BranchRadius(0.008122719971231719)
  <1.9973339039144344, 4.201246783227822, 0.968605247695824>, BranchRadius(0.004588256912079732)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <1.9631480376258224, 4.1553234239683015, 0.9579367440195041>, BranchRadius(0.020676428511282582)
  <1.9681945986499054, 4.170852639048086, 0.9602041843823775>, BranchRadius(0.016485314220941693)
  <1.9660200773557277, 4.178242753284437, 0.957066636554608>, BranchRadius(0.008317844531890288)
  <1.9646050358492235, 4.185238649539984, 0.952920771926782>, BranchRadius(0.00825427770284977)
  <1.964081130775917, 4.192487869742612, 0.9491852405371016>, BranchRadius(0.008171894813035756)
  <1.9645136709187845, 4.200269689702702, 0.9469816251733277>, BranchRadius(0.008099366242978844)
  <1.965219752576109, 4.204008030549692, 0.9452936093920983>, BranchRadius(0.004162107744012037)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.964081130775917, 4.192487869742612, 0.9491852405371016>, BranchRadius(0.008171894813035756)
  <1.9645136709187845, 4.200269689702702, 0.9469816251733277>, BranchRadius(0.008099366242978844)
  <1.9619994951036268, 4.205100644574317, 0.949128552760726>, BranchRadius(0.005853930565581113)
  <1.9616243249570242, 4.209590869026318, 0.952788328977683>, BranchRadius(0.005804897090082821)
  <1.960554078651351, 4.211890508107652, 0.9545651853114727>, BranchRadius(0.0030969316250338973)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <1.8750446708544342, 3.9259911679053108, 0.8865171837011417>, BranchRadius(0.05886954357953826)
  <1.8837748851018086, 3.9699589215520614, 0.9237839389089256>, BranchRadius(0.058294005225780356)
  <1.9085972448268607, 3.9738180730140686, 0.9604405444187891>, BranchRadius(0.044438151624840924)
  <1.9169216918742802, 3.9882955407160043, 1.0012526812546245>, BranchRadius(0.04409675728228581)
  <1.9223105215834952, 3.9829366733653444, 1.044412043230417>, BranchRadius(0.04382336672454963)
  <1.934460084505629, 3.9800818271920875, 1.0627162525403733>, BranchRadius(0.022154144179690978)
  <1.9440795174321266, 3.985667995606088, 1.0648971954293944>, BranchRadius(0.011335575824021194)
  <1.9511155715701292, 3.994270881278372, 1.0665558544630014>, BranchRadius(0.01123685229559654)
  <1.9586364524181625, 4.001859186553589, 1.0696921780776656>, BranchRadius(0.01113474523714427)
  <1.965915996328984, 4.008743620433417, 1.0744022621764384>, BranchRadius(0.01107122764705026)
  <1.9754125835372258, 4.012232124059882, 1.078640766007617>, BranchRadius(0.010969035549332706)
  <1.9820827412157154, 4.0110415927341565, 1.0796548792192537>, BranchRadius(0.006851043270879687)
  <1.9868651101614556, 4.01027204075843, 1.0810279767508268>, BranchRadius(0.005034745257481836)
  <1.9888310760216732, 4.011690098670489, 1.08205358738242>, BranchRadius(0.0026320689909520344)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.965915996328984, 4.008743620433417, 1.0744022621764384>, BranchRadius(0.01107122764705026)
  <1.9754125835372258, 4.012232124059882, 1.078640766007617>, BranchRadius(0.010969035549332706)
  <1.9814814951651067, 4.014646930463498, 1.0814494107727222>, BranchRadius(0.007109955255170409)
  <1.9866184917020009, 4.018690310527481, 1.0841064988787024>, BranchRadius(0.00705675371292079)
  <1.9914386353573426, 4.023080373695804, 1.0866616335862624>, BranchRadius(0.007002510467952007)
  <1.9942148331695801, 4.025309771082317, 1.0884319479508948>, BranchRadius(0.003976367682858961)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.9223105215834952, 3.9829366733653444, 1.044412043230417>, BranchRadius(0.04382336672454963)
  <1.934460084505629, 3.9800818271920875, 1.0627162525403733>, BranchRadius(0.022154144179690978)
  <1.937091606623384, 3.9736016830975207, 1.075878214577308>, BranchRadius(0.014904845547817493)
  <1.9397803923434132, 3.974499035988521, 1.083679417340161>, BranchRadius(0.008300215383130857)
  <1.9393356440488736, 3.975305805618281, 1.091847605635101>, BranchRadius(0.008219974349266196)
  <1.9398534833250882, 3.9735359473354173, 1.0958277771578904>, BranchRadius(0.004386607026875746)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.934460084505629, 3.9800818271920875, 1.0627162525403733>, BranchRadius(0.022154144179690978)
  <1.937091606623384, 3.9736016830975207, 1.075878214577308>, BranchRadius(0.014904845547817493)
  <1.9380906846792911, 3.9697592054314237, 1.0819134610459897>, BranchRadius(0.007224056444545853)
  <1.937462895367697, 3.968176104834788, 1.0888687399063477>, BranchRadius(0.007160742345885742)
  <1.9368190575863327, 3.9658952386376556, 1.0933842977211483>, BranchRadius(0.005099719607658771)
  <1.936871591315411, 3.9643855942524184, 1.0982039433703996>, BranchRadius(0.005050818760054241)
  <1.9386538591882583, 3.9618856318669553, 1.102165525302234>, BranchRadius(0.00501202774353367)
  <1.941422089780511, 3.9598126401250395, 1.1057514202801118>, BranchRadius(0.004981870950386511)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.9380906846792911, 3.9697592054314237, 1.0819134610459897>, BranchRadius(0.007224056444545853)
  <1.937462895367697, 3.968176104834788, 1.0888687399063477>, BranchRadius(0.007160742345885742)
  <1.9374860557420246, 3.969613928132032, 1.0941053499810227>, BranchRadius(0.005430465662466019)
  <1.9380199516396721, 3.972063471342983, 1.098870761039811>, BranchRadius(0.00538464941579895)
  <1.9390772971744656, 3.9718486746192982, 1.102967816697842>, BranchRadius(0.004236741941334013)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <1.9169216918742802, 3.9882955407160043, 1.0012526812546245>, BranchRadius(0.04409675728228581)
  <1.9223105215834952, 3.9829366733653444, 1.044412043230417>, BranchRadius(0.04382336672454963)
  <1.9082601883651986, 3.981685438702306, 1.0622241168362987>, BranchRadius(0.02272107871269564)
  <1.894307964659648, 3.9810775781000887, 1.0658495602986253>, BranchRadius(0.014428370702888946)
  <1.8804873393023873, 3.9773685514599926, 1.0650023878999018>, BranchRadius(0.014334722353636758)
  <1.8726590987294989, 3.9782165105576137, 1.0568233832712806>, BranchRadius(0.011353259523734272)
  <1.8647188754295063, 3.9777858818201843, 1.0488733235893775>, BranchRadius(0.011244377977863727)
  <1.8568711954718755, 3.9776522025223175, 1.0409771191730497>, BranchRadius(0.01113346285108598)
  <1.8490753961025432, 3.9774909913668703, 1.0331503582407713>, BranchRadius(0.01104801627146539)
  <1.8417958072738918, 3.9749381351888875, 1.025367538876064>, BranchRadius(0.010958182579395088)
  <1.8383357307347938, 3.9715400951167648, 1.0192149280608513>, BranchRadius(0.007834119339889848)
  <1.8333736212426364, 3.967529971916027, 1.0147616073245864>, BranchRadius(0.007780468127131)
  <1.832777231332856, 3.9640758070721795, 1.009815416428902>, BranchRadius(0.0060623213433066234)
  <1.832376112845458, 3.9603814940569317, 1.00507059451509>, BranchRadius(0.0060267885054439314)
  <1.832462062267579, 3.9562332797750344, 1.0007510242579745>, BranchRadius(0.00598947044719799)
  <1.8350600647714765, 3.955209519116811, 0.998711145837534>, BranchRadius(0.0034581507870195143)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.8490753961025432, 3.9774909913668703, 1.0331503582407713>, BranchRadius(0.01104801627146539)
  <1.8417958072738918, 3.9749381351888875, 1.025367538876064>, BranchRadius(0.010958182579395088)
  <1.8369450600217614, 3.974852305481464, 1.0219954023271651>, BranchRadius(0.005908334837087902)
  <1.8337498791123714, 3.974601365738368, 1.017089137579566>, BranchRadius(0.005860340055997404)
  <1.8308364685682361, 3.97520665081802, 1.012101007521666>, BranchRadius(0.005808250382073138)
  <1.829053356938287, 3.975674023827488, 1.0066241955294826>, BranchRadius(0.00577870177570749)
  <1.8277206697293997, 3.9762940089735506, 1.0010696808447628>, BranchRadius(0.005745700145398852)
  <1.8262619971737248, 3.977819208870242, 0.9957826162012652>, BranchRadius(0.005692715774924084)
  <1.8258219867971097, 3.9787976491335075, 0.9929516483939197>, BranchRadius(0.0030274301323952066)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <1.894307964659648, 3.9810775781000887, 1.0658495602986253>, BranchRadius(0.014428370702888946)
  <1.8804873393023873, 3.9773685514599926, 1.0650023878999018>, BranchRadius(0.014334722353636758)
  <1.8739504800586426, 3.972456772914664, 1.0728456751062727>, BranchRadius(0.011330192030698433)
  <1.8648153839749602, 3.9666520479981284, 1.0759887439557663>, BranchRadius(0.011270478854397257)
  <1.856812103665458, 3.9593233775724808, 1.0786444094039567>, BranchRadius(0.011172039424068752)
  <1.8492594305817154, 3.955715342149836, 1.0805774082457065>, BranchRadius(0.008590534025492981)
  <1.8414920089009665, 3.9526113349064773, 1.0821450205566008>, BranchRadius(0.00851029428930992)
  <1.8336958149266387, 3.9493769050106606, 1.0826748829964732>, BranchRadius(0.008457123118501032)
  <1.826558559529822, 3.945393113502079, 1.0844902309158946>, BranchRadius(0.008372962286537698)
  <1.819234176618018, 3.941785751213965, 1.0860142549096519>, BranchRadius(0.008305558190150754)
  <1.8128820318265875, 3.937903895865854, 1.089579601066799>, BranchRadius(0.008254104289094056)
  <1.8103857517500253, 3.934295908089686, 1.088223848568914>, BranchRadius(0.004592064334168216)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <1.819234176618018, 3.941785751213965, 1.0860142549096519>, BranchRadius(0.008305558190150754)
  <1.8128820318265875, 3.937903895865854, 1.089579601066799>, BranchRadius(0.008254104289094056)
  <1.8095245736201389, 3.9383565776478564, 1.0947795696575942>, BranchRadius(0.006206216218362112)
  <1.805419945652121, 3.9379122449301627, 1.0993616619502615>, BranchRadius(0.006167736383663758)
  <1.8000623228526342, 3.9372773983328333, 1.1022473649969595>, BranchRadius(0.006118368600978769)
  <1.7947979768358473, 3.9364639721196504, 1.1051605773395181>, BranchRadius(0.00607139253726764)
  <1.7903495110885046, 3.9330764186313405, 1.10743681408454>, BranchRadius(0.006037020776908955)
  <1.784994542431078, 3.9305698405355405, 1.1084724848938885>, BranchRadius(0.006002602527046212)
  <1.7807949075512184, 3.9263804364474093, 1.1090958189821423>, BranchRadius(0.0059646110622036345)
  <1.777919128367631, 3.9251600740292107, 1.1111609228032573>, BranchRadius(0.0037448690413002927)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.8648153839749602, 3.9666520479981284, 1.0759887439557663>, BranchRadius(0.011270478854397257)
  <1.856812103665458, 3.9593233775724808, 1.0786444094039567>, BranchRadius(0.011172039424068752)
  <1.8561043179888828, 3.9532959629864397, 1.0798112829010003>, BranchRadius(0.006179990365209939)
  <1.8566115795012172, 3.947813833238278, 1.0825088203443332>, BranchRadius(0.0061308864836792255)
  <1.8542434280964337, 3.9430135953477765, 1.0853941415831654>, BranchRadius(0.006080748599690895)
  <1.8496999638406262, 3.939519470637983, 1.0872886048044377>, BranchRadius(0.006036635306869604)
  <1.8444002228352765, 3.937968736864981, 1.0895804831384057>, BranchRadius(0.005978690178979472)
  <1.841273147306697, 3.9373960916281674, 1.0903299574177778>, BranchRadius(0.0032662265114541795)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.9223105215834952, 3.9829366733653444, 1.044412043230417>, BranchRadius(0.04382336672454963)
  <1.9082601883651986, 3.981685438702306, 1.0622241168362987>, BranchRadius(0.02272107871269564)
  <1.9106179412251514, 3.9811120591543148, 1.0765924593607403>, BranchRadius(0.014571788824792575)
  <1.9109579626966922, 3.981334892354003, 1.0842108037771407>, BranchRadius(0.007629183500407684)
  <1.9118223173791238, 3.9812779401454677, 1.0917188125225137>, BranchRadius(0.007557813697868984)
  <1.911863431329766, 3.980705068122466, 1.0962917337859317>, BranchRadius(0.0046088481850779465)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.9109579626966922, 3.981334892354003, 1.0842108037771407>, BranchRadius(0.007629183500407684)
  <1.9118223173791238, 3.9812779401454677, 1.0917188125225137>, BranchRadius(0.007557813697868984)
  <1.9133442976935553, 3.9822333012965427, 1.0971336771708984>, BranchRadius(0.005705251805733571)
  <1.9151643632144018, 3.982951259001853, 1.10245275115878>, BranchRadius(0.005667508258074962)
  <1.917724087986854, 3.9832255938906416, 1.103195301181811>, BranchRadius(0.0026793340737234247)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.9082601883651986, 3.981685438702306, 1.0622241168362987>, BranchRadius(0.02272107871269564)
  <1.9106179412251514, 3.9811120591543148, 1.0765924593607403>, BranchRadius(0.014571788824792575)
  <1.9195115622000196, 3.9762394565021144, 1.0815997990033241>, BranchRadius(0.011309827626760647)
  <1.9225915764300885, 3.9757502053364044, 1.0886169955073042>, BranchRadius(0.007678990893082521)
  <1.9262908303052382, 3.9753727440919384, 1.0952544092709788>, BranchRadius(0.007608036388852436)
  <1.9253053061538026, 3.9753499508598553, 1.1002154482214856>, BranchRadius(0.005058031717272752)
  <1.9258307123477694, 3.976052771805819, 1.1051500033079056>, BranchRadius(0.005011969957178094)
  <1.9272685834355072, 3.975985237320942, 1.1076231608965297>, BranchRadius(0.0028615629697367915)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <1.9106179412251514, 3.9811120591543148, 1.0765924593607403>, BranchRadius(0.014571788824792575)
  <1.9195115622000196, 3.9762394565021144, 1.0815997990033241>, BranchRadius(0.011309827626760647)
  <1.9249115247104132, 3.972884500831262, 1.0828921460469774>, BranchRadius(0.006487332544912592)
  <1.930103491105012, 3.969256454417647, 1.0840411127333105>, BranchRadius(0.006437341086837674)
  <1.9358853626162853, 3.9665404757483116, 1.084259459099361>, BranchRadius(0.006391733211009988)
  <1.9398850694402703, 3.9615980358189, 1.0843313841862652>, BranchRadius(0.006358501423433264)
  <1.9415102812954004, 3.9600305170165284, 1.0830793299218047>, BranchRadius(0.0025818730896380315)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  25
  <1.3028313888798053, 3.731637143879279, 0.2613123292597698>, BranchRadius(0.2132001272935303)
  <1.4766560576673946, 3.8515707838903936, 0.2803091309640916>, BranchRadius(0.2120376663718598)
  <1.5478680135001128, 3.9609867560409002, 0.19127903520515027>, BranchRadius(0.15801694708482295)
  <1.5416702294515094, 4.067274233738972, 0.14384540991724173>, BranchRadius(0.11655637799144591)
  <1.5188740858686476, 4.1559922184657045, 0.07301645109219132>, BranchRadius(0.11578983713808388)
  <1.4811625892823364, 4.243383782636313, 0.008968145431502081>, BranchRadius(0.11472413835357402)
  <1.4369837693458347, 4.3304790887738465, -0.04999742529604781>, BranchRadius(0.11408023059846213)
  <1.3940958282112481, 4.423468361831447, -0.09868974166057912>, BranchRadius(0.11339013216099739)
  <1.3378003823025224, 4.49976342239936, -0.1592701951187437>, BranchRadius(0.1125171313103947)
  <1.2757738792287845, 4.534536991537625, -0.2450344203049728>, BranchRadius(0.11140911325364863)
  <1.2447372423833447, 4.534445384102566, -0.2824525416044091>, BranchRadius(0.048614781910209154)
  <1.2135874328158556, 4.538981794494708, -0.31887135924421744>, BranchRadius(0.04813751067118442)
  <1.181554225582158, 4.552150512316329, -0.3517684617786873>, BranchRadius(0.04776778045823277)
  <1.1488839622998979, 4.567138002692137, -0.3826560109810322>, BranchRadius(0.047392105528499276)
  <1.1179446365411525, 4.579258805152065, -0.4006847943474614>, BranchRadius(0.03780466585425648)
  <1.0985538101303964, 4.5948463476844, -0.42869935247134167>, BranchRadius(0.03746720029526718)
  <1.0914032992798233, 4.607405558874749, -0.4327809063359708>, BranchRadius(0.01501741233028627)
  <1.0863017902891021, 4.616167882900139, -0.4300231270965387>, BranchRadius(0.01050757168149554)
  <1.0813092543773772, 4.624721140514068, -0.4268087299212248>, BranchRadius(0.010412299450206322)
  <1.0754036085807173, 4.633141267810919, -0.4276489145656778>, BranchRadius(0.010318968272437404)
  <1.07178077571455, 4.63852743285401, -0.42344267441656425>, BranchRadius(0.007734865741537252)
  <1.074284327589377, 4.642150836900946, -0.4192001105049346>, BranchRadius(0.006115241403375857)
  <1.0750195886127192, 4.644689167271588, -0.4137530798540561>, BranchRadius(0.006054244193504462)
  <1.074002774742418, 4.64730031241923, -0.40845469292268904>, BranchRadius(0.0059937378574115175)
  <1.0729200485206527, 4.6479593424849845, -0.4049999694945848>, BranchRadius(0.0036799090564250386)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.0754036085807173, 4.633141267810919, -0.4276489145656778>, BranchRadius(0.010318968272437404)
  <1.07178077571455, 4.63852743285401, -0.42344267441656425>, BranchRadius(0.007734865741537252)
  <1.067671870263506, 4.641684168689278, -0.42154531211566054>, BranchRadius(0.005517976879271732)
  <1.0665825403375622, 4.642242750021336, -0.41864676347680796>, BranchRadius(0.003146464206673015)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.0813092543773772, 4.624721140514068, -0.4268087299212248>, BranchRadius(0.010412299450206322)
  <1.0754036085807173, 4.633141267810919, -0.4276489145656778>, BranchRadius(0.010318968272437404)
  <1.0713617031071414, 4.6387279926515905, -0.43198999391247217>, BranchRadius(0.008148218467730353)
  <1.0676074088514431, 4.644320494048326, -0.43646403709562476>, BranchRadius(0.008086276005404146)
  <1.0620495949738538, 4.646576109626414, -0.44179047399633337>, BranchRadius(0.008021722183625292)
  <1.0578862629599255, 4.648245159140228, -0.44836421981824187>, BranchRadius(0.007958215495249093)
  <1.0527377238302127, 4.6525752436091565, -0.45248821920175636>, BranchRadius(0.007890783078596388)
  <1.0470674709920569, 4.656605934747309, -0.45609991263872945>, BranchRadius(0.007838530970945475)
  <1.0444762899422362, 4.658496276981846, -0.4577361994080312>, BranchRadius(0.003600700957871316)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.0985538101303964, 4.5948463476844, -0.42869935247134167>, BranchRadius(0.03746720029526718)
  <1.0914032992798233, 4.607405558874749, -0.4327809063359708>, BranchRadius(0.01501741233028627)
  <1.088357584677453, 4.612977875553747, -0.44089918007581913>, BranchRadius(0.010306961682534596)
  <1.085092615617577, 4.617422274928916, -0.4495210465080072>, BranchRadius(0.01023471003704785)
  <1.0829691651459123, 4.623035559006189, -0.4577023137704186>, BranchRadius(0.010146483827256263)
  <1.082455085226525, 4.625838303101151, -0.4673579949625445>, BranchRadius(0.010067364695357963)
  <1.0802947077409926, 4.625590647702946, -0.47308300124487696>, BranchRadius(0.006124072257003614)
  <1.076174702412057, 4.6243577679226595, -0.4748908554952136>, BranchRadius(0.004665058783505055)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <1.0829691651459123, 4.623035559006189, -0.4577023137704186>, BranchRadius(0.010146483827256263)
  <1.082455085226525, 4.625838303101151, -0.4673579949625445>, BranchRadius(0.010067364695357963)
  <1.0861593901470583, 4.63074032462629, -0.4705173794698433>, BranchRadius(0.006908936274287714)
  <1.0881680488401215, 4.636276039698951, -0.4740278136418981>, BranchRadius(0.006855800404565896)
  <1.0879242597760657, 4.641761976849622, -0.4780317813414175>, BranchRadius(0.0067960795218760285)
  <1.087136519109787, 4.647102811545357, -0.4821029749031436>, BranchRadius(0.006761632023521766)
  <1.0870638075089154, 4.653105711625405, -0.4850987236173214>, BranchRadius(0.006709292563783127)
  <1.0884401326298787, 4.659123575873299, -0.48762937091963526>, BranchRadius(0.006671816597703608)
  <1.0910585868954905, 4.664301727496654, -0.49083624839456996>, BranchRadius(0.0066297526435600326)
  <1.0931155104332302, 4.6699907474222995, -0.49343453785776437>, BranchRadius(0.006583843124577591)
  <1.0942701141776392, 4.67417109611874, -0.49830592570043214>, BranchRadius(0.006522180965300254)
  <1.0944250920301188, 4.678213218790979, -0.5033777531422312>, BranchRadius(0.006487388336732344)
  <1.0919159828752043, 4.680260429201928, -0.5049105739460824>, BranchRadius(0.003582769715554285)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.0942701141776392, 4.67417109611874, -0.49830592570043214>, BranchRadius(0.006522180965300254)
  <1.0944250920301188, 4.678213218790979, -0.5033777531422312>, BranchRadius(0.006487388336732344)
  <1.0967539938377509, 4.680618120307457, -0.5072907123347068>, BranchRadius(0.005149619847671703)
  <1.0967055300291277, 4.682543471373391, -0.509991147704927>, BranchRadius(0.0033168775462134926)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <1.1179446365411525, 4.579258805152065, -0.4006847943474614>, BranchRadius(0.03780466585425648)
  <1.0985538101303964, 4.5948463476844, -0.42869935247134167>, BranchRadius(0.03746720029526718)
  <1.0908302137840609, 4.595931584513367, -0.4445584801230099>, BranchRadius(0.017673245581046573)
  <1.0845506726553054, 4.59606017123276, -0.4562072579577012>, BranchRadius(0.013234167762807354)
  <1.0782446803570906, 4.5949455696220705, -0.4676519980798968>, BranchRadius(0.013114493969661568)
  <1.069928413286475, 4.59217449994526, -0.4720765510681837>, BranchRadius(0.009819154459000242)
  <1.0623125554303703, 4.58700003741868, -0.4753233428556315>, BranchRadius(0.009763094296093146)
  <1.0553617482473812, 4.583870320867566, -0.48130126267937073>, BranchRadius(0.00968733046842435)
  <1.0502625706642976, 4.5785698605182015, -0.48751028834004967>, BranchRadius(0.00962540864555782)
  <1.043744902449557, 4.577550852063739, -0.49445138388489385>, BranchRadius(0.009575864689434591)
  <1.0395464390827929, 4.575142084920874, -0.50262086146687>, BranchRadius(0.009495768412983706)
  <1.0320496527577812, 4.57349031101072, -0.5080619053985812>, BranchRadius(0.009409310353047307)
  <1.0245370563481, 4.570835634181121, -0.5129702334331226>, BranchRadius(0.009358317048435162)
  <1.0182928849742727, 4.567927798555292, -0.5192255530034835>, BranchRadius(0.009304526162029808)
  <1.0180947266892768, 4.563838333545571, -0.5249270476322974>, BranchRadius(0.007019261483520609)
  <1.0169663350109301, 4.561984513143954, -0.5315418920489912>, BranchRadius(0.006961758723072719)
  <1.0175256389026268, 4.56282260534811, -0.5362409155275802>, BranchRadius(0.004805834062706098)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.0845506726553054, 4.59606017123276, -0.4562072579577012>, BranchRadius(0.013234167762807354)
  <1.0782446803570906, 4.5949455696220705, -0.4676519980798968>, BranchRadius(0.013114493969661568)
  <1.0761165585182122, 4.594809576485927, -0.47348348095865384>, BranchRadius(0.006209153666920003)
  <1.076784936375285, 4.593578914833912, -0.4794970374997113>, BranchRadius(0.006174473202959196)
  <1.0742744216491966, 4.591622440759244, -0.48308692741445847>, BranchRadius(0.0047976853371969)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.0985538101303964, 4.5948463476844, -0.42869935247134167>, BranchRadius(0.03746720029526718)
  <1.0908302137840609, 4.595931584513367, -0.4445584801230099>, BranchRadius(0.017673245581046573)
  <1.0879939388913815, 4.596884324623885, -0.4512978913379404>, BranchRadius(0.0073737258227414395)
  <1.0881839933408433, 4.596802958007972, -0.4552648443574549>, BranchRadius(0.003972336526401111)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  18
  <1.181554225582158, 4.552150512316329, -0.3517684617786873>, BranchRadius(0.04776778045823277)
  <1.1488839622998979, 4.567138002692137, -0.3826560109810322>, BranchRadius(0.047392105528499276)
  <1.127357784623041, 4.577883174111083, -0.4077183980594572>, BranchRadius(0.034741305103103824)
  <1.1007917712346251, 4.575541410645966, -0.41295625611358855>, BranchRadius(0.027178522411552716)
  <1.0923285729228196, 4.56744164110108, -0.4241396255529508>, BranchRadius(0.016195670543774382)
  <1.0786438859865346, 4.561046571407517, -0.4295794026142766>, BranchRadius(0.016054866782585938)
  <1.073559713912016, 4.552927497299049, -0.4375527771555882>, BranchRadius(0.012463662047654044)
  <1.0698990145879215, 4.542634062232897, -0.44337559221838985>, BranchRadius(0.012379850574950942)
  <1.0680512071501937, 4.532437656886902, -0.44999278321243597>, BranchRadius(0.012295051482544887)
  <1.065651355753742, 4.5253325186629185, -0.45349849119314845>, BranchRadius(0.008278421610004928)
  <1.060971266077072, 4.519612342851312, -0.45711680802315413>, BranchRadius(0.008228965146338677)
  <1.0540266997919145, 4.51570108737531, -0.4588190158396595>, BranchRadius(0.008149995812150972)
  <1.0477432667266025, 4.510615681373246, -0.45820660793859624>, BranchRadius(0.008106659529631096)
  <1.0449981373594932, 4.505705356816667, -0.46126124837240545>, BranchRadius(0.006401394431916756)
  <1.0423879356645023, 4.50016361755615, -0.4629546296515313>, BranchRadius(0.006355436025685634)
  <1.0389756469822335, 4.495212072492388, -0.46485186846954796>, BranchRadius(0.006305634599482813)
  <1.0347423750572036, 4.492446084871483, -0.46856359313313056>, BranchRadius(0.006272812661676606)
  <1.0309297427478907, 4.493235735467337, -0.4708512330974666>, BranchRadius(0.004515862021361457)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.0540266997919145, 4.51570108737531, -0.4588190158396595>, BranchRadius(0.008149995812150972)
  <1.0477432667266025, 4.510615681373246, -0.45820660793859624>, BranchRadius(0.008106659529631096)
  <1.0439285344623483, 4.510433842029988, -0.45424452180317243>, BranchRadius(0.005503033194449747)
  <1.039115098796312, 4.50920477615861, -0.4519981266530615>, BranchRadius(0.005452160764109875)
  <1.0359105539004727, 4.51065798913963, -0.45044094449182714>, BranchRadius(0.0038478243516200617)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <1.0698990145879215, 4.542634062232897, -0.44337559221838985>, BranchRadius(0.012379850574950942)
  <1.0680512071501937, 4.532437656886902, -0.44999278321243597>, BranchRadius(0.012295051482544887)
  <1.0685989019541293, 4.526111720792902, -0.45578170444627436>, BranchRadius(0.00859238302889362)
  <1.0711083847969465, 4.520360704622213, -0.46158005501218596>, BranchRadius(0.008543568365684533)
  <1.0741929236097179, 4.515920208809422, -0.4680969687248809>, BranchRadius(0.008467735653031473)
  <1.080327003945532, 4.512206785510073, -0.47248174211118193>, BranchRadius(0.00840492069061806)
  <1.0851952259523383, 4.514353110992511, -0.47530562337688315>, BranchRadius(0.006023338275980849)
  <1.091096248981551, 4.514955361432966, -0.47613558217477164>, BranchRadius(0.005989458238481854)
  <1.0968801562279842, 4.516113795094616, -0.47698025611887657>, BranchRadius(0.005958945011966087)
  <1.099557765112812, 4.516609307547315, -0.47793401604993435>, BranchRadius(0.002885269473893085)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.0741929236097179, 4.515920208809422, -0.4680969687248809>, BranchRadius(0.008467735653031473)
  <1.080327003945532, 4.512206785510073, -0.47248174211118193>, BranchRadius(0.00840492069061806)
  <1.0812521973132907, 4.506322201971702, -0.47382888052122235>, BranchRadius(0.006107297936371972)
  <1.080436287340528, 4.500355716681496, -0.47449197429061885>, BranchRadius(0.006058411437738213)
  <1.0803927379448606, 4.497094512411497, -0.47476167774904765>, BranchRadius(0.0032726273536732727)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <1.0923285729228196, 4.56744164110108, -0.4241396255529508>, BranchRadius(0.016195670543774382)
  <1.0786438859865346, 4.561046571407517, -0.4295794026142766>, BranchRadius(0.016054866782585938)
  <1.0698536546819695, 4.560187216532835, -0.4297067984577813>, BranchRadius(0.008833056486253177)
  <1.0611420009156936, 4.559246460013535, -0.4299752681102332>, BranchRadius(0.00876641375514326)
  <1.0534558931559606, 4.557980333292223, -0.433874772736411>, BranchRadius(0.00871122641757355)
  <1.0462360175936813, 4.556232974416051, -0.4382648215743336>, BranchRadius(0.008628580125158518)
  <1.0383335608450657, 4.556564053090217, -0.44150641703664395>, BranchRadius(0.008547887276602354)
  <1.0307741892209048, 4.560188009888282, -0.4429273327655374>, BranchRadius(0.008502715080197907)
  <1.0228322405352834, 4.561231100110866, -0.4455833557601398>, BranchRadius(0.008439019154223333)
  <1.0159872599578343, 4.5618229290832195, -0.45039753184113984>, BranchRadius(0.008389297466239037)
  <1.0096604909530356, 4.559151553097387, -0.45512300157104457>, BranchRadius(0.008336325321507602)
  <1.005091010507358, 4.559370911186081, -0.46203731858693986>, BranchRadius(0.008290720674995812)
  <1.0004508809905646, 4.558318354312632, -0.4687263420742177>, BranchRadius(0.008208636495656068)
  <0.9986143614213542, 4.556438415471, -0.4710505796538561>, BranchRadius(0.0035084262145546005)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.005091010507358, 4.559370911186081, -0.46203731858693986>, BranchRadius(0.008290720674995812)
  <1.0004508809905646, 4.558318354312632, -0.4687263420742177>, BranchRadius(0.008208636495656068)
  <0.9975592306605122, 4.561255836389771, -0.47368852028263564>, BranchRadius(0.006450864682885414)
  <0.9974333077080242, 4.560465261862562, -0.476950385430498>, BranchRadius(0.0033586647519326216)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.127357784623041, 4.577883174111083, -0.4077183980594572>, BranchRadius(0.034741305103103824)
  <1.1007917712346251, 4.575541410645966, -0.41295625611358855>, BranchRadius(0.027178522411552716)
  <1.083794036627093, 4.576252057442854, -0.4134494841377761>, BranchRadius(0.017019731917449838)
  <1.074311983322225, 4.572561426615465, -0.42134446509263246>, BranchRadius(0.01287869617073021)
  <1.0710358050924416, 4.563721753028097, -0.4247739826086321>, BranchRadius(0.010031687959514495)
  <1.0666176746355716, 4.554866384661287, -0.42594515204665895>, BranchRadius(0.009965393293712873)
  <1.0640905786699892, 4.547758775155224, -0.42618388781097966>, BranchRadius(0.007547272465937632)
  <1.0594248898038923, 4.5419270529991325, -0.42655420191445287>, BranchRadius(0.007477617831656749)
  <1.0564735215588044, 4.539933701801825, -0.42491624669227573>, BranchRadius(0.00392006643104149)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.0710358050924416, 4.563721753028097, -0.4247739826086321>, BranchRadius(0.010031687959514495)
  <1.0666176746355716, 4.554866384661287, -0.42594515204665895>, BranchRadius(0.009965393293712873)
  <1.0631288596427328, 4.551322077776393, -0.42759790888142674>, BranchRadius(0.0052407581992911295)
  <1.059648796217395, 4.547563386801503, -0.4284826768971132>, BranchRadius(0.0051982125515100674)
  <1.0556323823302969, 4.544775237102582, -0.4300920187588814>, BranchRadius(0.0051473624784069815)
  <1.0517094839854801, 4.542068195223281, -0.4319592993510678>, BranchRadius(0.005118978801480871)
  <1.0478107478420504, 4.539385052177545, -0.4337983739542511>, BranchRadius(0.005077558026850849)
  <1.0432548622739894, 4.537369630299369, -0.434546181941093>, BranchRadius(0.0050375823012117)
  <1.0400740754699347, 4.53844445036786, -0.43398253602011827>, BranchRadius(0.003404458781761002)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.083794036627093, 4.576252057442854, -0.4134494841377761>, BranchRadius(0.017019731917449838)
  <1.074311983322225, 4.572561426615465, -0.42134446509263246>, BranchRadius(0.01287869617073021)
  <1.0689501703238165, 4.576034172963538, -0.42529311283264104>, BranchRadius(0.00751004825567902)
  <1.0659531872280739, 4.578069318371439, -0.4282805129695203>, BranchRadius(0.004695560039579364)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <1.1007917712346251, 4.575541410645966, -0.41295625611358855>, BranchRadius(0.027178522411552716)
  <1.083794036627093, 4.576252057442854, -0.4134494841377761>, BranchRadius(0.017019731917449838)
  <1.072128529789309, 4.579916881003902, -0.4078646440920152>, BranchRadius(0.013442671603990217)
  <1.0608496389545194, 4.584638244294173, -0.4024822343252164>, BranchRadius(0.013359453008247013)
  <1.0494582798238978, 4.5906783801736575, -0.39949124262174623>, BranchRadius(0.01323602416345834)
  <1.0409828714042144, 4.5993068256159635, -0.39436547449568526>, BranchRadius(0.013136061720068242)
  <1.032580182210206, 4.604173360312429, -0.38562167239786377>, BranchRadius(0.013066844330934423)
  <1.0249611726170578, 4.608879889116782, -0.3762357203917987>, BranchRadius(0.012972926255353593)
  <1.0147408030457412, 4.615210512097994, -0.37164822435678574>, BranchRadius(0.012867706142735543)
  <1.0084031167735459, 4.6178130435561755, -0.3737614911375486>, BranchRadius(0.007169751304074216)
  <1.0063876680398578, 4.6168234090440805, -0.3776908975434483>, BranchRadius(0.004525665118894709)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.0249611726170578, 4.608879889116782, -0.3762357203917987>, BranchRadius(0.012972926255353593)
  <1.0147408030457412, 4.615210512097994, -0.37164822435678574>, BranchRadius(0.012867706142735543)
  <1.013344860078409, 4.618062148708072, -0.363576012442555>, BranchRadius(0.008674162398308581)
  <1.013232234122098, 4.61848102620792, -0.35933285653311253>, BranchRadius(0.004265268460220371)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.0147408030457412, 4.615210512097994, -0.37164822435678574>, BranchRadius(0.012867706142735543)
  <1.013344860078409, 4.618062148708072, -0.363576012442555>, BranchRadius(0.008674162398308581)
  <1.0115640810265536, 4.621368645768888, -0.3595808868919468>, BranchRadius(0.005483167424931821)
  <1.0098892842957436, 4.624132078503096, -0.35905238982097915>, BranchRadius(0.003274265371048086)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <1.1488839622998979, 4.567138002692137, -0.3826560109810322>, BranchRadius(0.047392105528499276)
  <1.127357784623041, 4.577883174111083, -0.4077183980594572>, BranchRadius(0.034741305103103824)
  <1.1124213860848757, 4.58738258089777, -0.42847365253139513>, BranchRadius(0.027278477207952085)
  <1.095868178608686, 4.599942087158075, -0.4459211342209743>, BranchRadius(0.027132351401244773)
  <1.090462692931525, 4.613792121308243, -0.46842646553889106>, BranchRadius(0.026972813332984263)
  <1.0789480455712357, 4.62521276020268, -0.4897994611182922>, BranchRadius(0.026829518009573904)
  <1.080202664589786, 4.63545875079117, -0.5012840698354483>, BranchRadius(0.015441846696795427)
  <1.0826132234681256, 4.648458657970794, -0.5089654390949564>, BranchRadius(0.015290906267638264)
  <1.079322817579349, 4.655345131416722, -0.5074119199311368>, BranchRadius(0.007788691111266167)
  <1.0762288317714905, 4.662406288943297, -0.5078539855164773>, BranchRadius(0.007721924357055252)
  <1.0733032754584557, 4.669400305799451, -0.5090427499154392>, BranchRadius(0.007673872055302001)
  <1.0699733819642863, 4.676132942561264, -0.5102577708591346>, BranchRadius(0.0076087360542103286)
  <1.067983948063609, 4.68339278310432, -0.5094525187970712>, BranchRadius(0.0075704400690593445)
  <1.0657558831471408, 4.68511146671085, -0.5113054860461499>, BranchRadius(0.0033692186390189382)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.0699733819642863, 4.676132942561264, -0.5102577708591346>, BranchRadius(0.0076087360542103286)
  <1.067983948063609, 4.68339278310432, -0.5094525187970712>, BranchRadius(0.0075704400690593445)
  <1.0666421434748468, 4.688589531597664, -0.5087804119070574>, BranchRadius(0.00540909993706022)
  <1.066564416498911, 4.692753153381067, -0.508425297630593>, BranchRadius(0.0041794609685172285)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.080202664589786, 4.63545875079117, -0.5012840698354483>, BranchRadius(0.015441846696795427)
  <1.0826132234681256, 4.648458657970794, -0.5089654390949564>, BranchRadius(0.015290906267638264)
  <1.0859001270890005, 4.650904533468869, -0.5138986380025489>, BranchRadius(0.006412682264612434)
  <1.088733333810403, 4.6527278042477604, -0.5193088553501835>, BranchRadius(0.006373525586989219)
  <1.0918471232686628, 4.6535870941269755, -0.5194577999950384>, BranchRadius(0.0032336122825907037)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <1.090462692931525, 4.613792121308243, -0.46842646553889106>, BranchRadius(0.026972813332984263)
  <1.0789480455712357, 4.62521276020268, -0.4897994611182922>, BranchRadius(0.026829518009573904)
  <1.0655982511085034, 4.628000065863169, -0.5020118924214044>, BranchRadius(0.018306544277264095)
  <1.0520585864772924, 4.629568515150673, -0.514030080701745>, BranchRadius(0.018171939935924707)
  <1.0424268607179419, 4.636058316918444, -0.5277907698008607>, BranchRadius(0.018006782960062993)
  <1.0336905014774493, 4.639723154606596, -0.5429358872807325>, BranchRadius(0.0178641985977137)
  <1.023018438910169, 4.644788545725088, -0.5562101742859951>, BranchRadius(0.01776957518122847)
  <1.0178234989916524, 4.653382576410345, -0.5706900611227599>, BranchRadius(0.01762134747916989)
  <1.0116068136057716, 4.661341755725107, -0.5849406869528199>, BranchRadius(0.01746642634026567)
  <1.0045510599462208, 4.662500067635464, -0.59511104338261>, BranchRadius(0.01243227638427144)
  <1.0017445407685603, 4.662589533458298, -0.6005528590749282>, BranchRadius(0.006123553874768432)
  <0.9988546394819734, 4.662817306499601, -0.6059040856437687>, BranchRadius(0.006085970407061379)
  <0.9998906174086738, 4.662334559369424, -0.6099872423748947>, BranchRadius(0.004240101879347242)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.0116068136057716, 4.661341755725107, -0.5849406869528199>, BranchRadius(0.01746642634026567)
  <1.0045510599462208, 4.662500067635464, -0.59511104338261>, BranchRadius(0.01243227638427144)
  <0.9977650017612358, 4.665598716769792, -0.5974280838379606>, BranchRadius(0.007811586818272477)
  <0.9927406263928833, 4.667902615094917, -0.5991837405471456>, BranchRadius(0.005799536689695729)
  <0.9892883849567761, 4.6684440674283145, -0.5994216062410994>, BranchRadius(0.003502530749455036)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.0178234989916524, 4.653382576410345, -0.5706900611227599>, BranchRadius(0.01762134747916989)
  <1.0116068136057716, 4.661341755725107, -0.5849406869528199>, BranchRadius(0.01746642634026567)
  <1.0091162745121893, 4.664851415735509, -0.590894545218406>, BranchRadius(0.007346354647848461)
  <1.0060394023887964, 4.668358611863571, -0.5916098559077633>, BranchRadius(0.004720088571914158)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  26
  <1.3378003823025224, 4.49976342239936, -0.1592701951187437>, BranchRadius(0.1125171313103947)
  <1.2757738792287845, 4.534536991537625, -0.2450344203049728>, BranchRadius(0.11140911325364863)
  <1.2530630261514812, 4.590228487833605, -0.2899357939340727>, BranchRadius(0.07505637188782913)
  <1.2297532743570307, 4.655076631750852, -0.31832454281569156>, BranchRadius(0.0745288357704215)
  <1.20206293872238, 4.677229480948277, -0.32001621958334614>, BranchRadius(0.03550162229264595)
  <1.1765282241656398, 4.697281210679423, -0.3339130576077637>, BranchRadius(0.03531594002404551)
  <1.1485743311232515, 4.705717561615834, -0.35336650724333935>, BranchRadius(0.035086020807031604)
  <1.1189668031568987, 4.717614662930918, -0.36748270753289425>, BranchRadius(0.034891458017609)
  <1.0891757553590382, 4.73223938695043, -0.3775364013374704>, BranchRadius(0.03467658923045149)
  <1.0658752189338505, 4.755406519777338, -0.38784610445263873>, BranchRadius(0.03443720400154522)
  <1.034366270750862, 4.767725981789598, -0.39215232848276876>, BranchRadius(0.03410464081715884)
  <1.02158232395563, 4.790351991440641, -0.3977492979803743>, BranchRadius(0.02658367310868783)
  <1.0102126609128008, 4.8014291718676425, -0.3877570556425213>, BranchRadius(0.018756813984741588)
  <1.0056738434902026, 4.816487136377935, -0.37780056312269533>, BranchRadius(0.018613836307603885)
  <0.9988217779367429, 4.831409431549888, -0.3693706703714199>, BranchRadius(0.018457756834074385)
  <0.9897521360524445, 4.845062681054812, -0.36127281183865684>, BranchRadius(0.018282366880953003)
  <0.9808122115909992, 4.857060819325147, -0.3509629509231277>, BranchRadius(0.01817060272605094)
  <0.9739424537243117, 4.870394637674681, -0.34100532710045317>, BranchRadius(0.018003848397472506)
  <0.9699205175233159, 4.882214270754502, -0.3281602045389807>, BranchRadius(0.017913036330162484)
  <0.967595999907723, 4.889888807435531, -0.31941368240896656>, BranchRadius(0.011866066946739067)
  <0.9615624515262511, 4.898246353651261, -0.31376565559129177>, BranchRadius(0.011753828812467775)
  <0.9543975785174709, 4.903446066060347, -0.306172753026558>, BranchRadius(0.011662957760649762)
  <0.9499216218932809, 4.903416012417033, -0.2998347371123817>, BranchRadius(0.007759222683456039)
  <0.9469001748844599, 4.903070015579907, -0.2927790305828834>, BranchRadius(0.007683218757058753)
  <0.9441776849958143, 4.905037282906753, -0.285944572580735>, BranchRadius(0.007615241828870817)
  <0.9416944845677581, 4.903820603039608, -0.2840143558408973>, BranchRadius(0.0033722886779996627)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.9469001748844599, 4.903070015579907, -0.2927790305828834>, BranchRadius(0.007683218757058753)
  <0.9441776849958143, 4.905037282906753, -0.285944572580735>, BranchRadius(0.007615241828870817)
  <0.9455547619511644, 4.9092324974430985, -0.2819833062961435>, BranchRadius(0.005931930252823432)
  <0.9433716131024072, 4.910963932148536, -0.27949853828619636>, BranchRadius(0.003733373420685123)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.9615624515262511, 4.898246353651261, -0.31376565559129177>, BranchRadius(0.011753828812467775)
  <0.9543975785174709, 4.903446066060347, -0.306172753026558>, BranchRadius(0.011662957760649762)
  <0.9503365292690802, 4.910475716588663, -0.3038548924423162>, BranchRadius(0.008442783026709288)
  <0.9477903521717904, 4.915334583317671, -0.30533468210427306>, BranchRadius(0.005681670629723476)
  <0.9448915799700919, 4.91984084125365, -0.3071263062635417>, BranchRadius(0.005649704239248353)
  <0.9424356313536788, 4.920122418113724, -0.309313310586145>, BranchRadius(0.003300599497315009)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.9543975785174709, 4.903446066060347, -0.306172753026558>, BranchRadius(0.011662957760649762)
  <0.9503365292690802, 4.910475716588663, -0.3038548924423162>, BranchRadius(0.008442783026709288)
  <0.9487774312153615, 4.9125605706543025, -0.2989763534121338>, BranchRadius(0.005529696762494142)
  <0.9462511175000894, 4.915539854231299, -0.2951203750008391>, BranchRadius(0.005488803251028477)
  <0.944217524709665, 4.919843059993431, -0.2924820045482524>, BranchRadius(0.005441881854063979)
  <0.9425354681715975, 4.9240172122835215, -0.28947614173730385>, BranchRadius(0.005411845597979098)
  <0.9407348482758171, 4.927884062411883, -0.2862249077400293>, BranchRadius(0.005363327738384911)
  <0.9395191355019183, 4.931708387511414, -0.28271951277145013>, BranchRadius(0.005328340632998026)
  <0.9382364463129501, 4.934538597595748, -0.278430507798071>, BranchRadius(0.005296314222044905)
  <0.9359064057629117, 4.937303599842363, -0.2772504103023402>, BranchRadius(0.003803545252529955)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <0.9739424537243117, 4.870394637674681, -0.34100532710045317>, BranchRadius(0.018003848397472506)
  <0.9699205175233159, 4.882214270754502, -0.3281602045389807>, BranchRadius(0.017913036330162484)
  <0.9649413173626243, 4.8906074372174055, -0.3220439699679492>, BranchRadius(0.011517204645317292)
  <0.9616024684306281, 4.900001067474121, -0.3164243544551871>, BranchRadius(0.011444137368183132)
  <0.9589172273178715, 4.909074261222244, -0.31014681943167205>, BranchRadius(0.011355210724423958)
  <0.9552409765714577, 4.916820866118784, -0.3027934391411797>, BranchRadius(0.011295880163590755)
  <0.9489728065407895, 4.924770918358054, -0.2979897899241738>, BranchRadius(0.011205727639940696)
  <0.9400887856202796, 4.9308853904652725, -0.2952119886439318>, BranchRadius(0.011136820767998538)
  <0.9316085626556376, 4.937147509109102, -0.29196314458662626>, BranchRadius(0.011031015327164113)
  <0.9240207365438493, 4.944742264067885, -0.28968358752661083>, BranchRadius(0.010975053001082086)
  <0.9152773446009671, 4.949681410323828, -0.2854071741804619>, BranchRadius(0.010914658927862992)
  <0.9089257243311694, 4.952165555756112, -0.28328385708519205>, BranchRadius(0.007143005954603906)
  <0.9025241411906623, 4.95314859287129, -0.28042351466980975>, BranchRadius(0.00708012622824464)
  <0.8971750944596074, 4.951133927545489, -0.27633322248316433>, BranchRadius(0.0070286319777129605)
  <0.8936564941100332, 4.948500761403611, -0.2709171528721766>, BranchRadius(0.006974806261238848)
  <0.8904730350808079, 4.945268683041781, -0.2656834635012023>, BranchRadius(0.0069261999941974)
  <0.8882179071799483, 4.942879277207798, -0.26260573913598534>, BranchRadius(0.004501916187242914)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.9240207365438493, 4.944742264067885, -0.28968358752661083>, BranchRadius(0.010975053001082086)
  <0.9152773446009671, 4.949681410323828, -0.2854071741804619>, BranchRadius(0.010914658927862992)
  <0.9091765781597063, 4.95355269038464, -0.28204475214906716>, BranchRadius(0.007969444296640905)
  <0.9056934355619696, 4.958256909893219, -0.27674529746248927>, BranchRadius(0.007895959948996225)
  <0.9050797878453577, 4.962572842787901, -0.2702134910813913>, BranchRadius(0.007852918875911698)
  <0.90471772727581, 4.968453484798005, -0.26512052031729144>, BranchRadius(0.00778790019909097)
  <0.9029913867635913, 4.972754236538862, -0.25891725630592005>, BranchRadius(0.007743203567993904)
  <0.9019326984098255, 4.97514050373312, -0.25506705173744987>, BranchRadius(0.004651791845284606)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.90471772727581, 4.968453484798005, -0.26512052031729144>, BranchRadius(0.00778790019909097)
  <0.9029913867635913, 4.972754236538862, -0.25891725630592005>, BranchRadius(0.007743203567993904)
  <0.9020206434789542, 4.977756766535854, -0.25590248137629534>, BranchRadius(0.005920854395419803)
  <0.903108267092958, 4.979651389097792, -0.2537056663549157>, BranchRadius(0.003098147190839054)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <1.034366270750862, 4.767725981789598, -0.39215232848276876>, BranchRadius(0.03410464081715884)
  <1.02158232395563, 4.790351991440641, -0.3977492979803743>, BranchRadius(0.02658367310868783)
  <1.0155643345947203, 4.80281541774887, -0.4033833194865567>, BranchRadius(0.014943071626035146)
  <1.0118034972167, 4.816494155999096, -0.40761295259082553>, BranchRadius(0.014803431159661299)
  <1.0099749578586794, 4.829316832828346, -0.4146094075542809>, BranchRadius(0.014721242451195639)
  <1.0080184771868048, 4.842144823951873, -0.42133039904398983>, BranchRadius(0.014613586126938102)
  <1.0044738232322543, 4.853872475896447, -0.42915354784260445>, BranchRadius(0.014536301074064036)
  <1.00158645303345, 4.867123832608315, -0.4341316155745941>, BranchRadius(0.0144470245972794)
  <1.0042217236637958, 4.8808455465622025, -0.4374344674707362>, BranchRadius(0.014357538639172558)
  <1.006701457075552, 4.8945144556193805, -0.4404716385585822>, BranchRadius(0.01422014630106243)
  <1.0093387612930083, 4.9001023604233485, -0.441933163480412>, BranchRadius(0.0063494967305097304)
  <1.0119524251455767, 4.905619645020061, -0.44344396605283803>, BranchRadius(0.006289212388542621)
  <1.0141434963813933, 4.906082843502504, -0.44460933330807434>, BranchRadius(0.0025245646821059897)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.0042217236637958, 4.8808455465622025, -0.4374344674707362>, BranchRadius(0.014357538639172558)
  <1.006701457075552, 4.8945144556193805, -0.4404716385585822>, BranchRadius(0.01422014630106243)
  <1.0056186814812815, 4.900571751444364, -0.4415220331805987>, BranchRadius(0.006242320446826478)
  <1.0024735704753942, 4.905217415739193, -0.44416701590627006>, BranchRadius(0.00620240708102111)
  <1.0003262964065547, 4.906585876012309, -0.44332007268780105>, BranchRadius(0.002683427334793797)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <1.0658752189338505, 4.755406519777338, -0.38784610445263873>, BranchRadius(0.03443720400154522)
  <1.034366270750862, 4.767725981789598, -0.39215232848276876>, BranchRadius(0.03410464081715884)
  <1.013004614126014, 4.77098721039319, -0.39395993919130756>, BranchRadius(0.02168463608724909)
  <0.999287292631341, 4.775276915497883, -0.3858051251123255>, BranchRadius(0.01652475329728737)
  <0.985596592005448, 4.780442575169074, -0.3784188238130462>, BranchRadius(0.016391362675206026)
  <0.9753381040388698, 4.776173938271155, -0.3769645252692891>, BranchRadius(0.011205927921465682)
  <0.967027659289364, 4.768928418279626, -0.37855197702806276>, BranchRadius(0.011139167606633528)
  <0.9571452656633043, 4.7640028558025485, -0.3785424289017834>, BranchRadius(0.01104187305952657)
  <0.950888847412913, 4.764637776973617, -0.3831717685879245>, BranchRadius(0.007808756632587604)
  <0.9443160031710071, 4.763644056520945, -0.38716510267438864>, BranchRadius(0.0077547713630081345)
  <0.9376570612788028, 4.760967838051536, -0.38993463134921774>, BranchRadius(0.007692460042174946)
  <0.932597418901788, 4.7596563946753765, -0.3955050425095289>, BranchRadius(0.00763867430953005)
  <0.9262783073070826, 4.759931686295499, -0.39969149816039456>, BranchRadius(0.007585075328506345)
  <0.9193968390124412, 4.759645942634988, -0.4026896555153749>, BranchRadius(0.007511671109340495)
  <0.9168686045916626, 4.758517100165051, -0.40440471401475714>, BranchRadius(0.003256943392913998)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.9262783073070826, 4.759931686295499, -0.39969149816039456>, BranchRadius(0.007585075328506345)
  <0.9193968390124412, 4.759645942634988, -0.4026896555153749>, BranchRadius(0.007511671109340495)
  <0.9145783014663333, 4.762870701198118, -0.4027367062816857>, BranchRadius(0.005798239875025803)
  <0.9133415755031121, 4.76653810742389, -0.4052634790585758>, BranchRadius(0.004622114256373843)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.967027659289364, 4.768928418279626, -0.37855197702806276>, BranchRadius(0.011139167606633528)
  <0.9571452656633043, 4.7640028558025485, -0.3785424289017834>, BranchRadius(0.01104187305952657)
  <0.9510196871150299, 4.760920093024906, -0.3784998738455962>, BranchRadius(0.006857692748082725)
  <0.9467741326561007, 4.755777677789792, -0.3798404731327682>, BranchRadius(0.006801938956123389)
  <0.9447310130345082, 4.749592493696114, -0.3816280191741112>, BranchRadius(0.006754713976975321)
  <0.9419740307096114, 4.743474325386056, -0.3814574724965746>, BranchRadius(0.006712825126517919)
  <0.9393320243121305, 4.737370511375326, -0.3808916136680081>, BranchRadius(0.006675098463376649)
  <0.9400298626716389, 4.7339982446685545, -0.37688980154081664>, BranchRadius(0.005279551251663326)
  <0.9405330746709906, 4.73105066334153, -0.3739530656601917>, BranchRadius(0.004191166380408167)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.999287292631341, 4.775276915497883, -0.3858051251123255>, BranchRadius(0.01652475329728737)
  <0.985596592005448, 4.780442575169074, -0.3784188238130462>, BranchRadius(0.016391362675206026)
  <0.979860205758724, 4.783279605976077, -0.37498678063207025>, BranchRadius(0.007261803589162415)
  <0.9780060235079954, 4.7822871372619415, -0.37289756288830905>, BranchRadius(0.0029644251969481758)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <1.034366270750862, 4.767725981789598, -0.39215232848276876>, BranchRadius(0.03410464081715884)
  <1.013004614126014, 4.77098721039319, -0.39395993919130756>, BranchRadius(0.02168463608724909)
  <1.00027308813111, 4.771173752768046, -0.40249283513360246>, BranchRadius(0.015327650354133509)
  <0.986863808025921, 4.767511986224651, -0.40871717966782134>, BranchRadius(0.015230226263532893)
  <0.9732683358973556, 4.765826509248668, -0.4150191877282752>, BranchRadius(0.01507955571723493)
  <0.9624602100841353, 4.75737887576107, -0.42097099369463686>, BranchRadius(0.014953330378093358)
  <0.9548310188503073, 4.75958173993637, -0.4240892312746046>, BranchRadius(0.008531153208228002)
  <0.9469771635406067, 4.762658013334755, -0.4234825125121476>, BranchRadius(0.008456631061128364)
  <0.9389831984910235, 4.765127436859368, -0.42271433396581226>, BranchRadius(0.00840188241032454)
  <0.9324231735471441, 4.770276828889164, -0.4227262103392865>, BranchRadius(0.008339682643188327)
  <0.9259730018372475, 4.775110027950732, -0.4245290109281897>, BranchRadius(0.00825921414053641)
  <0.9189087660740466, 4.778671197890315, -0.4267102112204605>, BranchRadius(0.008206277656262624)
  <0.9169975518529612, 4.783335493715308, -0.42614771066224966>, BranchRadius(0.005071962363810439)
  <0.9165383140765306, 4.785934374301127, -0.4243480381830774>, BranchRadius(0.0031943544992595963)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.9732683358973556, 4.765826509248668, -0.4150191877282752>, BranchRadius(0.01507955571723493)
  <0.9624602100841353, 4.75737887576107, -0.42097099369463686>, BranchRadius(0.014953330378093358)
  <0.9622924956534283, 4.749445412380406, -0.4220981424409217>, BranchRadius(0.00801488824868205)
  <0.9606698119136712, 4.74166450153453, -0.42192123527037206>, BranchRadius(0.007950281269096414)
  <0.9598870161879806, 4.735880876213357, -0.42200128116224284>, BranchRadius(0.00583690828681357)
  <0.959611203512951, 4.730438608640802, -0.4239552573187982>, BranchRadius(0.005788987112040398)
  <0.9598756706923375, 4.72716987653485, -0.42484956114807443>, BranchRadius(0.0033991663402245837)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.9622924956534283, 4.749445412380406, -0.4220981424409217>, BranchRadius(0.00801488824868205)
  <0.9606698119136712, 4.74166450153453, -0.42192123527037206>, BranchRadius(0.007950281269096414)
  <0.9567328501834684, 4.737502526548767, -0.4202931083216063>, BranchRadius(0.0059558795159478425)
  <0.9542862489990652, 4.737782921602971, -0.4174961822581553>, BranchRadius(0.0037265633157584875)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <1.2530630261514812, 4.590228487833605, -0.2899357939340727>, BranchRadius(0.07505637188782913)
  <1.2297532743570307, 4.655076631750852, -0.31832454281569156>, BranchRadius(0.0745288357704215)
  <1.212834261813031, 4.704193892431623, -0.3401255422362239>, BranchRadius(0.05633863557081309)
  <1.2042561407512546, 4.754340252600955, -0.3633554079489857>, BranchRadius(0.055927348052771476)
  <1.2130618260203614, 4.767662078694342, -0.38424170307048944>, BranchRadius(0.026291604504547792)
  <1.2163897292837018, 4.776053663347695, -0.4087001072027019>, BranchRadius(0.026071194177083007)
  <1.2263450038955408, 4.7797532656408865, -0.4322892157463208>, BranchRadius(0.02586968479915344)
  <1.2345275329058, 4.777234469209754, -0.4565116921433145>, BranchRadius(0.025690980504218634)
  <1.239849184237103, 4.768120464323141, -0.4797378934582664>, BranchRadius(0.02551159511845205)
  <1.2455464887655414, 4.771298165389229, -0.48998378330476805>, BranchRadius(0.012146411885895603)
  <1.2489981342622642, 4.773923617715196, -0.492941864072864>, BranchRadius(0.005249485534940728)
  <1.2521124308784626, 4.775946562043283, -0.49661373450987556>, BranchRadius(0.005222430437488291)
  <1.2551940353599391, 4.778140378439126, -0.500140788031127>, BranchRadius(0.005171965110158249)
  <1.2562073931760374, 4.779431646565061, -0.5014328065928129>, BranchRadius(0.0020889182368496995)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.239849184237103, 4.768120464323141, -0.4797378934582664>, BranchRadius(0.02551159511845205)
  <1.2455464887655414, 4.771298165389229, -0.48998378330476805>, BranchRadius(0.012146411885895603)
  <1.2485760202426865, 4.772504228101552, -0.49767624871610466>, BranchRadius(0.008355038739687537)
  <1.248534219684141, 4.774473617439081, -0.5030936491278548>, BranchRadius(0.0057644140093071495)
  <1.2463197595243147, 4.776223848700086, -0.5080831189931326>, BranchRadius(0.005732534588031252)
  <1.2427837555941768, 4.777946024973642, -0.5121795259519971>, BranchRadius(0.005678887644933903)
  <1.2390155355895625, 4.780428833330992, -0.5155779061478443>, BranchRadius(0.005649142173642892)
  <1.2367534364650778, 4.781644612995519, -0.5178695423432563>, BranchRadius(0.0034419193909493912)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.2455464887655414, 4.771298165389229, -0.48998378330476805>, BranchRadius(0.012146411885895603)
  <1.2485760202426865, 4.772504228101552, -0.49767624871610466>, BranchRadius(0.008355038739687537)
  <1.251236254668489, 4.772824890774857, -0.5023774246088518>, BranchRadius(0.005411166835796347)
  <1.2544081173287613, 4.774248536339135, -0.5064549663004618>, BranchRadius(0.005358528312431994)
  <1.2574050869671491, 4.77640531915191, -0.5102747718207191>, BranchRadius(0.0053126691340123385)
  <1.2606939239389412, 4.777986510389486, -0.5140791459190984>, BranchRadius(0.005271610440580193)
  <1.264555432328548, 4.778576009233224, -0.5175535082109747>, BranchRadius(0.005227805396625211)
  <1.265474559819718, 4.778499333875331, -0.5195514543722793>, BranchRadius(0.002200559774013071)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  21
  <1.2345275329058, 4.777234469209754, -0.4565116921433145>, BranchRadius(0.025690980504218634)
  <1.239849184237103, 4.768120464323141, -0.4797378934582664>, BranchRadius(0.02551159511845205)
  <1.2389847573166237, 4.758505493111919, -0.4885057054400926>, BranchRadius(0.013041067143533503)
  <1.2369760935827958, 4.749316978048149, -0.49735643252948425>, BranchRadius(0.012915065198581765)
  <1.242021363635096, 4.743715423854036, -0.5029578428695782>, BranchRadius(0.009391909129049482)
  <1.2480934269770745, 4.737196491484911, -0.5056695886475289>, BranchRadius(0.00931235725401786)
  <1.2542302915433345, 4.730573094704906, -0.5076979273986545>, BranchRadius(0.009254439458947356)
  <1.2626972570945525, 4.726960246905738, -0.5075402282855083>, BranchRadius(0.009206901969487445)
  <1.2714737424336513, 4.724532287945174, -0.5067286225103701>, BranchRadius(0.00914223077568249)
  <1.2805151510103645, 4.725017292405381, -0.5072504601358276>, BranchRadius(0.009069432886615656)
  <1.2894319976438717, 4.724125651959714, -0.5062245462197237>, BranchRadius(0.009019848997244584)
  <1.298282355373892, 4.723302115192129, -0.5051985946031261>, BranchRadius(0.008947604231105197)
  <1.3070831734652406, 4.72285250475811, -0.5042152521360802>, BranchRadius(0.00886698996429353)
  <1.3146565591117867, 4.7211548606927245, -0.5000486986831867>, BranchRadius(0.008808991610840856)
  <1.3214572177402206, 4.717433263811003, -0.4960232942846802>, BranchRadius(0.00873516580850341)
  <1.3263569014598013, 4.714783631108731, -0.49640597183707064>, BranchRadius(0.005583358856277697)
  <1.3302724003670294, 4.711010996242219, -0.49535085417698327>, BranchRadius(0.005538698295191095)
  <1.3322333513888858, 4.705879381750842, -0.49530831906558803>, BranchRadius(0.005493687780893016)
  <1.3321965824219435, 4.700447370730612, -0.49485062525160356>, BranchRadius(0.005451383247230557)
  <1.3313757450077912, 4.695140216056693, -0.49430842141785974>, BranchRadius(0.005397559614371794)
  <1.3310105048581886, 4.69297568030735, -0.49401667139625116>, BranchRadius(0.0022144375024316077)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.3146565591117867, 4.7211548606927245, -0.5000486986831867>, BranchRadius(0.008808991610840856)
  <1.3214572177402206, 4.717433263811003, -0.4960232942846802>, BranchRadius(0.00873516580850341)
  <1.3262467821714883, 4.714806912756728, -0.49263826106618724>, BranchRadius(0.006426203948821797)
  <1.3295125584282859, 4.71094818275635, -0.4887341603935489>, BranchRadius(0.00638726027631423)
  <1.333042583270884, 4.706920318591441, -0.4853332128982277>, BranchRadius(0.0063443840509734735)
  <1.3343416497732603, 4.701297399947016, -0.48284386925742145>, BranchRadius(0.006285031393831172)
  <1.3358105762382457, 4.696042207624655, -0.47980322090555527>, BranchRadius(0.006246625785513812)
  <1.338573881400209, 4.6936210408884955, -0.4792091655356196>, BranchRadius(0.0037216670411208005)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.2389847573166237, 4.758505493111919, -0.4885057054400926>, BranchRadius(0.013041067143533503)
  <1.2369760935827958, 4.749316978048149, -0.49735643252948425>, BranchRadius(0.012915065198581765)
  <1.230531328935928, 4.74601976100277, -0.500344571603512>, BranchRadius(0.007831705224507903)
  <1.2244486543097455, 4.743220412048329, -0.5042606395781106>, BranchRadius(0.007756988691393769)
  <1.2189644227367282, 4.740166986347588, -0.5086958522017073>, BranchRadius(0.007685786587782316)
  <1.2164081674396225, 4.738368055009897, -0.5110371518991037>, BranchRadius(0.003905416671077918)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <1.2244486543097455, 4.743220412048329, -0.5042606395781106>, BranchRadius(0.007756988691393769)
  <1.2189644227367282, 4.740166986347588, -0.5086958522017073>, BranchRadius(0.007685786587782316)
  <1.213203960343992, 4.7416791941483085, -0.5099125116449714>, BranchRadius(0.006078647844017103)
  <1.2080653623714657, 4.7443203551594975, -0.5116670170411143>, BranchRadius(0.006038146221761022)
  <1.2029959969866462, 4.747430681408757, -0.5124019876525187>, BranchRadius(0.005992726973695973)
  <1.19756453350466, 4.749515679319441, -0.5136613502195144>, BranchRadius(0.00595264696743032)
  <1.1921901684833833, 4.751681123650656, -0.5148844009451026>, BranchRadius(0.005921891725696964)
  <1.188463849158631, 4.755546714342922, -0.5173029622189462>, BranchRadius(0.005888776251947054)
  <1.1840707780888924, 4.758873788134366, -0.5192705219289452>, BranchRadius(0.005851477134014568)
  <1.1789804845952128, 4.7613362449757854, -0.5206152114187784>, BranchRadius(0.005812312050442281)
  <1.1733672094744951, 4.76154995867652, -0.5218782733803252>, BranchRadius(0.005757591219030255)
  <1.1679771619353847, 4.763452015053078, -0.5215464965859534>, BranchRadius(0.0057254263399993495)
  <1.1651111198691428, 4.7643441120687475, -0.5228045257483418>, BranchRadius(0.0032546384721277915)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <1.212834261813031, 4.704193892431623, -0.3401255422362239>, BranchRadius(0.05633863557081309)
  <1.2042561407512546, 4.754340252600955, -0.3633554079489857>, BranchRadius(0.055927348052771476)
  <1.1982448411643611, 4.7856990184050145, -0.37702314948169663>, BranchRadius(0.034732046787977)
  <1.20612061211198, 4.812961486609954, -0.3965959690899735>, BranchRadius(0.03447267335242259)
  <1.2133166017425356, 4.840013112593905, -0.41615990703436595>, BranchRadius(0.03415143339642847)
  <1.2114779744887494, 4.854177175581054, -0.41697925719677553>, BranchRadius(0.014306381973473272)
  <1.2162502561961372, 4.867389236847961, -0.4191233265384494>, BranchRadius(0.014210217062279202)
  <1.2197403155865698, 4.880474410363729, -0.4151993220289409>, BranchRadius(0.014099648643748342)
  <1.223179141794947, 4.892873916695014, -0.4096225145910768>, BranchRadius(0.014024053057159046)
  <1.2252284399011042, 4.904694906842289, -0.4026118225792396>, BranchRadius(0.01389551126352358)
  <1.2269375389271377, 4.908904208847845, -0.3965262565910565>, BranchRadius(0.007594297614085163)
  <1.2297989658970114, 4.9104509337913065, -0.38970628506165245>, BranchRadius(0.007555933695879564)
  <1.2336310217276554, 4.913273647237956, -0.3839305751304791>, BranchRadius(0.007484062285959506)
  <1.237452639821266, 4.915867896993228, -0.37809196259928785>, BranchRadius(0.00744474935343844)
  <1.2401897856034105, 4.914112741597506, -0.37664597693564006>, BranchRadius(0.0035585688184041273)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.223179141794947, 4.892873916695014, -0.4096225145910768>, BranchRadius(0.014024053057159046)
  <1.2252284399011042, 4.904694906842289, -0.4026118225792396>, BranchRadius(0.01389551126352358)
  <1.2250224966771517, 4.9112217837331436, -0.4036423354249593>, BranchRadius(0.006610937247097179)
  <1.2244694457860423, 4.917758543114491, -0.40383133241529995>, BranchRadius(0.006562835390297882)
  <1.2239507163769132, 4.924237732704752, -0.40428510305256177>, BranchRadius(0.006515741380508797)
  <1.2244152218586424, 4.926240026225015, -0.40776604814390477>, BranchRadius(0.004042514491352009)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.2244694457860423, 4.917758543114491, -0.40383133241529995>, BranchRadius(0.006562835390297882)
  <1.2239507163769132, 4.924237732704752, -0.40428510305256177>, BranchRadius(0.006515741380508797)
  <1.223422741036896, 4.929243295326889, -0.4039554223303309>, BranchRadius(0.00504411582959938)
  <1.2252141828674887, 4.932596396985186, -0.4045220723378327>, BranchRadius(0.0038436501914554085)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <1.20612061211198, 4.812961486609954, -0.3965959690899735>, BranchRadius(0.03447267335242259)
  <1.2133166017425356, 4.840013112593905, -0.41615990703436595>, BranchRadius(0.03415143339642847)
  <1.2225674604149672, 4.854086296740805, -0.4355952854084288>, BranchRadius(0.025717053306179134)
  <1.234114252095837, 4.869265251534326, -0.45264073841015845>, BranchRadius(0.025578829816458325)
  <1.2500861230459581, 4.881414184695148, -0.46817046992923694>, BranchRadius(0.02537458964492035)
  <1.263035701636293, 4.889907701906076, -0.4879649550337471>, BranchRadius(0.025132708983161025)
  <1.2756964343815955, 4.899434098951115, -0.5071679454045532>, BranchRadius(0.02489580754844029)
  <1.2858148559658, 4.904044784092907, -0.5133397267019648>, BranchRadius(0.012717380123890048)
  <1.2950109371854253, 4.911569020310629, -0.5175770087003259>, BranchRadius(0.012614935560344926)
  <1.3010969774027021, 4.910921614443784, -0.5190561576927863>, BranchRadius(0.006296578564953689)
  <1.3072451145175772, 4.911377971292844, -0.5180367248653862>, BranchRadius(0.006248767466194346)
  <1.313342085584915, 4.91176147646162, -0.5170265704428689>, BranchRadius(0.00619197418984956)
  <1.3190943483213526, 4.913107758424789, -0.5187719737279911>, BranchRadius(0.006160148889522081)
  <1.3248816819328348, 4.914232983970034, -0.5203824776337391>, BranchRadius(0.006111717081859562)
  <1.3294325361763302, 4.914901878090485, -0.5243525455423765>, BranchRadius(0.006076111658709604)
  <1.3316260760498901, 4.916104802468075, -0.5244616475794979>, BranchRadius(0.0025041061258666017)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.2858148559658, 4.904044784092907, -0.5133397267019648>, BranchRadius(0.012717380123890048)
  <1.2950109371854253, 4.911569020310629, -0.5175770087003259>, BranchRadius(0.012614935560344926)
  <1.2963169026161152, 4.920615150655498, -0.5200574220759727>, BranchRadius(0.009470505289402154)
  <1.2962743091147668, 4.92469831339189, -0.5199393730598573>, BranchRadius(0.004085090905772224)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.2950109371854253, 4.911569020310629, -0.5175770087003259>, BranchRadius(0.012614935560344926)
  <1.2963169026161152, 4.920615150655498, -0.5200574220759727>, BranchRadius(0.009470505289402154)
  <1.2975325731092602, 4.926128617554462, -0.5223910080112697>, BranchRadius(0.0061091566775862485)
  <1.3000117846672268, 4.927827133840562, -0.5233526601915219>, BranchRadius(0.0031553482278642506)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.263035701636293, 4.889907701906076, -0.4879649550337471>, BranchRadius(0.025132708983161025)
  <1.2756964343815955, 4.899434098951115, -0.5071679454045532>, BranchRadius(0.02489580754844029)
  <1.2744670754873255, 4.905105559136354, -0.5254592706757709>, BranchRadius(0.01918982449375604)
  <1.2754313462342681, 4.909859873084915, -0.5439001391527897>, BranchRadius(0.019068270749640452)
  <1.2770565599723005, 4.912885018940432, -0.5625234263759739>, BranchRadius(0.018937255718256944)
  <1.2807510732870426, 4.917461601893092, -0.5803978909123512>, BranchRadius(0.01881730646552791)
  <1.2870017276962822, 4.91440649430583, -0.5883042366292999>, BranchRadius(0.010531603178500626)
  <1.2933049701407084, 4.912012415678107, -0.5962892143070667>, BranchRadius(0.010450949540753261)
  <1.2958411518583801, 4.912410781925566, -0.6002362084306261>, BranchRadius(0.004708468539087746)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.2870017276962822, 4.91440649430583, -0.5883042366292999>, BranchRadius(0.010531603178500626)
  <1.2933049701407084, 4.912012415678107, -0.5962892143070667>, BranchRadius(0.010450949540753261)
  <1.2963052954656966, 4.906370049667573, -0.5976623185693251>, BranchRadius(0.006536333954720286)
  <1.2985963767921453, 4.903381234743762, -0.5980151875139461>, BranchRadius(0.003782404630030533)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <1.2770565599723005, 4.912885018940432, -0.5625234263759739>, BranchRadius(0.018937255718256944)
  <1.2807510732870426, 4.917461601893092, -0.5803978909123512>, BranchRadius(0.01881730646552791)
  <1.277435404130215, 4.925761583492937, -0.5900197389945662>, BranchRadius(0.013132528965607926)
  <1.2749807243074727, 4.9328946862855, -0.6006741572903984>, BranchRadius(0.013054625146054615)
  <1.2710196444949846, 4.9390395268613245, -0.6113995749681364>, BranchRadius(0.012980131098919637)
  <1.2670338641116745, 4.946723373148851, -0.620898489439374>, BranchRadius(0.012851354604328727)
  <1.259425930405121, 4.9505402406950125, -0.6304150327512412>, BranchRadius(0.01276768302218142)
  <1.252569165235563, 4.955271186627223, -0.6353644926419253>, BranchRadius(0.009689903570905725)
  <1.249046310286784, 4.960488061950319, -0.6360129366158035>, BranchRadius(0.0063282521057659875)
  <1.2457812212128474, 4.96530220072196, -0.6336493926612053>, BranchRadius(0.006278780040634699)
  <1.2430233955346763, 4.969611396472382, -0.6301061427781496>, BranchRadius(0.006223294161487273)
  <1.2411497694110527, 4.974938486054892, -0.627639520638612>, BranchRadius(0.00616218979344791)
  <1.238756797119456, 4.976870946542679, -0.6254302864662846>, BranchRadius(0.003787008787075119)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.2670338641116745, 4.946723373148851, -0.620898489439374>, BranchRadius(0.012851354604328727)
  <1.259425930405121, 4.9505402406950125, -0.6304150327512412>, BranchRadius(0.01276768302218142)
  <1.2586679875649953, 4.948949403505214, -0.6369017992888338>, BranchRadius(0.006721858405721892)
  <1.2572972175025339, 4.948579906648871, -0.6434376148326502>, BranchRadius(0.006688230207893462)
  <1.2549870682887665, 4.946521417107911, -0.6493100927888413>, BranchRadius(0.006637783208727456)
  <1.2506119262668234, 4.946564173250943, -0.65422265295666>, BranchRadius(0.0065785213537981144)
  <1.2452610022579922, 4.945461106738679, -0.6578016672240535>, BranchRadius(0.006531346461869012)
  <1.2416056813174885, 4.943045844063317, -0.6567808713065433>, BranchRadius(0.0044985430168320885)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  21
  <1.4766560576673946, 3.8515707838903936, 0.2803091309640916>, BranchRadius(0.2120376663718598)
  <1.5478680135001128, 3.9609867560409002, 0.19127903520515027>, BranchRadius(0.15801694708482295)
  <1.6075115090661478, 4.015203070019791, 0.1345444888289073>, BranchRadius(0.09856756067445029)
  <1.6517002757209962, 4.07487338620251, 0.1477426414064513>, BranchRadius(0.07541475295512415)
  <1.706767927655617, 4.121614648096034, 0.16720289752290865>, BranchRadius(0.07480570446904179)
  <1.7716199755128, 4.156373927975161, 0.17777860783946006>, BranchRadius(0.07433600270182304)
  <1.8276550618691916, 4.145546546457747, 0.17653993363962636>, BranchRadius(0.05708500159643733)
  <1.8838615189180163, 4.1444010754525715, 0.1698231737934093>, BranchRadius(0.056617954578356514)
  <1.938516818625164, 4.147654558988535, 0.18267293284354014>, BranchRadius(0.05623969460126316)
  <1.9908552458090158, 4.146032882617648, 0.2017929936490162>, BranchRadius(0.055745112068560344)
  <2.0185291481868064, 4.133960985684067, 0.1947213819901095>, BranchRadius(0.031009405989874676)
  <2.0475591176957275, 4.126405918639258, 0.20179590546930606>, BranchRadius(0.030819913208802924)
  <2.0744336198063658, 4.130588517571826, 0.2157838328337301>, BranchRadius(0.030584229751259434)
  <2.1006102719038733, 4.137937187749796, 0.2292365770362678>, BranchRadius(0.03033473907910618)
  <2.108338499518841, 4.148760073845009, 0.24312126517342753>, BranchRadius(0.019226152245441643)
  <2.1166023835771006, 4.150098576655715, 0.24486514437331655>, BranchRadius(0.008551285527125975)
  <2.1228985540981706, 4.153715757851613, 0.24927350813929733>, BranchRadius(0.008494670925207073)
  <2.12933680818845, 4.156665883533471, 0.2538174209261104>, BranchRadius(0.008414362761607088)
  <2.1370139026166, 4.157518315676292, 0.25699940359866275>, BranchRadius(0.008354007011325371)
  <2.144976879639224, 4.1578057727855455, 0.2592607185428988>, BranchRadius(0.00828282439325604)
  <2.1482317587167405, 4.155678468301194, 0.2616917903614289>, BranchRadius(0.004585822975785986)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <2.1006102719038733, 4.137937187749796, 0.2292365770362678>, BranchRadius(0.03033473907910618)
  <2.108338499518841, 4.148760073845009, 0.24312126517342753>, BranchRadius(0.019226152245441643)
  <2.102758392509928, 4.154906273171366, 0.2509697897613625>, BranchRadius(0.01142421544779548)
  <2.098381557190512, 4.158109519124599, 0.25074296925809275>, BranchRadius(0.0054285283080125315)
  <2.0932535626153426, 4.159702737659764, 0.2510874813422319>, BranchRadius(0.005380832857455458)
  <2.089998857250322, 4.159591549275132, 0.24939777814753983>, BranchRadius(0.0036688645050103504)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <2.108338499518841, 4.148760073845009, 0.24312126517342753>, BranchRadius(0.019226152245441643)
  <2.102758392509928, 4.154906273171366, 0.2509697897613625>, BranchRadius(0.01142421544779548)
  <2.102024675010321, 4.157067797803193, 0.25734203933896205>, BranchRadius(0.006768758732769333)
  <2.1012797914452923, 4.1593028897349384, 0.2636505711649365>, BranchRadius(0.00673409691555862)
  <2.100473154108575, 4.161576978082157, 0.2698966771153127>, BranchRadius(0.006695967528839035)
  <2.099040450355271, 4.166024712821794, 0.27461540662052425>, BranchRadius(0.006640887930259205)
  <2.096652108128673, 4.1712827522583265, 0.2777901255835899>, BranchRadius(0.0065901439894691365)
  <2.093737343171028, 4.176012154393274, 0.281234885006585>, BranchRadius(0.0065367780132626445)
  <2.09343847779942, 4.180895238042509, 0.28547764756873695>, BranchRadius(0.006475713134054909)
  <2.093496275814206, 4.183226931617993, 0.2914669348503033>, BranchRadius(0.0064274176526502745)
  <2.0954839182519924, 4.1865814736899845, 0.29652211642218523>, BranchRadius(0.006384241199856467)
  <2.0965983245073843, 4.191191336419167, 0.30072867099025646>, BranchRadius(0.006339387747892325)
  <2.098005374082565, 4.1953346242377485, 0.30523842794840544>, BranchRadius(0.0062836717193210075)
  <2.1011624054935734, 4.199398385178034, 0.30875035514803667>, BranchRadius(0.006230139080742491)
  <2.1041187386465032, 4.202270069117457, 0.3133456213392247>, BranchRadius(0.006172758356434274)
  <2.1040214086600586, 4.2057449113460175, 0.31587555678719864>, BranchRadius(0.00429936914099788)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <2.0744336198063658, 4.130588517571826, 0.2157838328337301>, BranchRadius(0.030584229751259434)
  <2.1006102719038733, 4.137937187749796, 0.2292365770362678>, BranchRadius(0.03033473907910618)
  <2.1184415225917452, 4.132413250021841, 0.2263378350904614>, BranchRadius(0.01889100563719212)
  <2.136158915673879, 4.126924275067739, 0.22340012353616828>, BranchRadius(0.01877937732859689)
  <2.1529371927447114, 4.120843700246009, 0.21814145669009957>, BranchRadius(0.018604772200331274)
  <2.1668741138639187, 4.110180943183485, 0.21233139851250288>, BranchRadius(0.018484829847322803)
  <2.182202043265541, 4.107347477304547, 0.20265158268089684>, BranchRadius(0.01834864526775865)
  <2.194335139108669, 4.097516872786121, 0.19331899349676815>, BranchRadius(0.01819203179460545)
  <2.1988832984602564, 4.091556456596007, 0.18887775698358192>, BranchRadius(0.008714177896558182)
  <2.2030523742479833, 4.0886204095464524, 0.18189212762100793>, BranchRadius(0.00864873301659041)
  <2.206961489342951, 4.085568352930979, 0.17488978283219575>, BranchRadius(0.008580737902486375)
  <2.2086594279208183, 4.081821415497861, 0.1735683556227069>, BranchRadius(0.004320729731409724)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <2.182202043265541, 4.107347477304547, 0.20265158268089684>, BranchRadius(0.01834864526775865)
  <2.194335139108669, 4.097516872786121, 0.19331899349676815>, BranchRadius(0.01819203179460545)
  <2.205724923353153, 4.097593763453315, 0.18841405292202368>, BranchRadius(0.012401271682870621)
  <2.216914448315524, 4.094161533986023, 0.18459176650868248>, BranchRadius(0.012312414118493462)
  <2.2205146921753025, 4.095922827582297, 0.1780135258198849>, BranchRadius(0.007703061829032563)
  <2.224439499412919, 4.095103776755792, 0.17650297317623692>, BranchRadius(0.004284474926764704)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <2.205724923353153, 4.097593763453315, 0.18841405292202368>, BranchRadius(0.012401271682870621)
  <2.216914448315524, 4.094161533986023, 0.18459176650868248>, BranchRadius(0.012312414118493462)
  <2.222382621534551, 4.0888771013691985, 0.18945627831889963>, BranchRadius(0.009027160217188477)
  <2.2273589447426136, 4.083202818468086, 0.19425253964328235>, BranchRadius(0.008942337602927498)
  <2.2333812256254046, 4.078715633377596, 0.19901854100285635>, BranchRadius(0.008894799943057608)
  <2.2389672042552706, 4.07311903000289, 0.2029750242252074>, BranchRadius(0.008841882496156084)
  <2.2418260473944374, 4.065288776693605, 0.20566783059104704>, BranchRadius(0.008759969012835628)
  <2.2417799009522033, 4.056620132473739, 0.20651201334037964>, BranchRadius(0.008709774200231418)
  <2.241554646666452, 4.048003335389103, 0.2069299809377137>, BranchRadius(0.008629868388536816)
  <2.2386917576245633, 4.039927974427252, 0.20644578083975504>, BranchRadius(0.00858149392968416)
  <2.239243113933051, 4.031423567605188, 0.20686760216123887>, BranchRadius(0.008532693736525883)
  <2.2372066572986555, 4.028389488215831, 0.20690487493795914>, BranchRadius(0.0036543375083011452)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <2.2386917576245633, 4.039927974427252, 0.20644578083975504>, BranchRadius(0.00858149392968416)
  <2.239243113933051, 4.031423567605188, 0.20686760216123887>, BranchRadius(0.008532693736525883)
  <2.2436192973519185, 4.027304603204955, 0.2072802326302287>, BranchRadius(0.0060238785636742296)
  <2.245146189670447, 4.024194122722385, 0.20776646064855414>, BranchRadius(0.003498986520499683)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.938516818625164, 4.147654558988535, 0.18267293284354014>, BranchRadius(0.05623969460126316)
  <1.9908552458090158, 4.146032882617648, 0.2017929936490162>, BranchRadius(0.055745112068560344)
  <2.002295257414877, 4.1641607193562, 0.23428843170448468>, BranchRadius(0.038928727500120455)
  <2.018834992728468, 4.179036612588611, 0.2659080558743087>, BranchRadius(0.038660776975464974)
  <2.029344437531352, 4.199274132404747, 0.2968352938892103>, BranchRadius(0.038425248074719295)
  <2.0389452375633654, 4.2116196256245955, 0.2975261389335611>, BranchRadius(0.01565451471529346)
  <2.0459006902648653, 4.219943560732639, 0.29752179096394643>, BranchRadius(0.01084740691919349)
  <2.0508202574668446, 4.2197216743607555, 0.2994331223884357>, BranchRadius(0.005282476959822737)
  <2.053993316477755, 4.219196853764582, 0.3014468810103064>, BranchRadius(0.0037945966758069364)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <2.0389452375633654, 4.2116196256245955, 0.2975261389335611>, BranchRadius(0.01565451471529346)
  <2.0459006902648653, 4.219943560732639, 0.29752179096394643>, BranchRadius(0.01084740691919349)
  <2.0489557608884725, 4.225460951815021, 0.29693665245176837>, BranchRadius(0.006333833590299449)
  <2.053263855485914, 4.229295196459763, 0.29439911840247857>, BranchRadius(0.006300808686790822)
  <2.058345770879915, 4.232774690870743, 0.29325999266825487>, BranchRadius(0.006263413834818571)
  <2.0617287284406736, 4.237992000769296, 0.2928827563227533>, BranchRadius(0.00622952901075189)
  <2.064836469850535, 4.2433142819847935, 0.29246059126180834>, BranchRadius(0.006177617448991941)
  <2.069499419466787, 4.247242279403204, 0.29310255678872515>, BranchRadius(0.0061306102942928)
  <2.0745360509292503, 4.250657431294601, 0.29308430189484935>, BranchRadius(0.006085330900710597)
  <2.0783552570941306, 4.2552718876126665, 0.292271453912656>, BranchRadius(0.006044854397199654)
  <2.082691018585273, 4.25939142922937, 0.29178503049957355>, BranchRadius(0.006000504860144665)
  <2.0870669640080726, 4.263266541352148, 0.2906661124863949>, BranchRadius(0.005951249434163752)
  <2.0912549159362754, 4.267221063635768, 0.289425048297566>, BranchRadius(0.0058921497066336944)
  <2.0950697706249457, 4.271523415809501, 0.28835810281800006>, BranchRadius(0.005848223933713383)
  <2.0989247307889998, 4.275278445120419, 0.28619780945689194>, BranchRadius(0.0057989508015110856)
  <2.1011450368909816, 4.277475813548011, 0.284920536620643>, BranchRadius(0.003374850084269955)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <2.029344437531352, 4.199274132404747, 0.2968352938892103>, BranchRadius(0.038425248074719295)
  <2.0389452375633654, 4.2116196256245955, 0.2975261389335611>, BranchRadius(0.01565451471529346)
  <2.04410363840704, 4.222361378248795, 0.30124308859130294>, BranchRadius(0.012482390134173491)
  <2.0452610154803117, 4.228495704718726, 0.3002831396172318>, BranchRadius(0.006315931044766145)
  <2.046561025678961, 4.234501496039485, 0.29910077143570174>, BranchRadius(0.006257599413656451)
  <2.048440490451298, 4.24040317392925, 0.29969245339726314>, BranchRadius(0.006221919100136103)
  <2.050399246968931, 4.246241238777579, 0.3002138634649642>, BranchRadius(0.0061799350099632794)
  <2.0531366774369277, 4.247225183182848, 0.2999582770769969>, BranchRadius(0.002920102149153277)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <2.0389452375633654, 4.2116196256245955, 0.2975261389335611>, BranchRadius(0.01565451471529346)
  <2.04410363840704, 4.222361378248795, 0.30124308859130294>, BranchRadius(0.012482390134173491)
  <2.047383991207583, 4.223662631082782, 0.3062703662983833>, BranchRadius(0.006142271125413996)
  <2.0497893491120474, 4.224053539437722, 0.31185799426790545>, BranchRadius(0.006095911934757347)
  <2.0521086336560814, 4.223610432753837, 0.3160359026772976>, BranchRadius(0.004798993957775659)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <2.018834992728468, 4.179036612588611, 0.2659080558743087>, BranchRadius(0.038660776975464974)
  <2.029344437531352, 4.199274132404747, 0.2968352938892103>, BranchRadius(0.038425248074719295)
  <2.0283279651421107, 4.201406436966465, 0.3121956899481471>, BranchRadius(0.015540968629703108)
  <2.028420329453159, 4.199336058159544, 0.3275110366805434>, BranchRadius(0.015454929475854199)
  <2.0239742614016607, 4.192961598821334, 0.3317896563743516>, BranchRadius(0.008871743879152273)
  <2.0222335891359715, 4.185274602187295, 0.33567855302126043>, BranchRadius(0.00878882098569598)
  <2.020999039349435, 4.177537960865641, 0.33954903268167325>, BranchRadius(0.008738440645620028)
  <2.021872410564121, 4.171687721975035, 0.3459185748198921>, BranchRadius(0.00869247602276538)
  <2.0228022251762874, 4.165759258420052, 0.35213916393636985>, BranchRadius(0.008643319055305269)
  <2.02425465704534, 4.164925192773927, 0.35675197673308934>, BranchRadius(0.004907470400712127)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <2.0283279651421107, 4.201406436966465, 0.3121956899481471>, BranchRadius(0.015540968629703108)
  <2.028420329453159, 4.199336058159544, 0.3275110366805434>, BranchRadius(0.015454929475854199)
  <2.030148646077469, 4.200286423900841, 0.3365301452022479>, BranchRadius(0.009232258224420453)
  <2.0306444441146505, 4.200903433537236, 0.34210688749566626>, BranchRadius(0.005632634480620804)
  <2.0308300271558797, 4.200933878338537, 0.34768707018024503>, BranchRadius(0.005583350852704014)
  <2.0328056788622395, 4.200823231476774, 0.35286565959763516>, BranchRadius(0.005543756014361218)
  <2.0335620093078806, 4.199474497968313, 0.3581328937561199>, BranchRadius(0.0054895239775555925)
  <2.0329865421718574, 4.196291424754994, 0.3625291244816574>, BranchRadius(0.0054580181474737305)
  <2.032589945688862, 4.193838335297073, 0.36734784913791446>, BranchRadius(0.005421719650785039)
  <2.03185388769597, 4.193111449543308, 0.37262467950694045>, BranchRadius(0.005377274682532164)
  <2.0313922235148727, 4.19296825461546, 0.37795106881489776>, BranchRadius(0.005348276513363126)
  <2.0296597095784836, 4.193046026741765, 0.3829752004499197>, BranchRadius(0.005315030736452991)
  <2.0270578010157454, 4.192536370412711, 0.38752115113254243>, BranchRadius(0.005262636729951521)
  <2.024951487018013, 4.190103511543972, 0.3916372189365737>, BranchRadius(0.00522468899549296)
  <2.023053420525497, 4.188669611947836, 0.3962488466543105>, BranchRadius(0.005189010952851138)
  <2.0213109930691506, 4.187773314719022, 0.40100133733164856>, BranchRadius(0.005140580687159259)
  <2.0189913492482394, 4.18837146367303, 0.4030649037768464>, BranchRadius(0.0031617773642079296)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <2.028420329453159, 4.199336058159544, 0.3275110366805434>, BranchRadius(0.015454929475854199)
  <2.030148646077469, 4.200286423900841, 0.3365301452022479>, BranchRadius(0.009232258224420453)
  <2.033866390233166, 4.2008054364703495, 0.34269034551077704>, BranchRadius(0.0072138106085292385)
  <2.0389284350894403, 4.199301333173873, 0.34753271940643066>, BranchRadius(0.007164859370477162)
  <2.040462306770578, 4.196344314582566, 0.34818031843014235>, BranchRadius(0.0033935388282794066)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <2.033866390233166, 4.2008054364703495, 0.34269034551077704>, BranchRadius(0.0072138106085292385)
  <2.0389284350894403, 4.199301333173873, 0.34753271940643066>, BranchRadius(0.007164859370477162)
  <2.0426110092396326, 4.199533996404903, 0.35149032974568784>, BranchRadius(0.005410930063134666)
  <2.0449499804610314, 4.198881580249066, 0.35628677822154003>, BranchRadius(0.0053760906983080755)
  <2.0468006869853874, 4.197202364681676, 0.3610016689262601>, BranchRadius(0.005336204073919293)
  <2.0491174450235814, 4.195971088560774, 0.3656083431151859>, BranchRadius(0.005301401303085324)
  <2.050406173788449, 4.194817549986811, 0.3705864765510538>, BranchRadius(0.005270036582066897)
  <2.0505909273565246, 4.192274103825826, 0.3751443107579973>, BranchRadius(0.005222748788973922)
  <2.0527998623900308, 4.189786215394793, 0.3791246847663004>, BranchRadius(0.005187712412373475)
  <2.0553309911992703, 4.18592554880413, 0.38140323964142686>, BranchRadius(0.005148123142678986)
  <2.055795620233732, 4.18120645135338, 0.3833349679032301>, BranchRadius(0.005120286609828531)
  <2.0555041053196663, 4.176712465419764, 0.38567993681740015>, BranchRadius(0.005077378233408082)
  <2.0557310320050557, 4.171757759360533, 0.3865317507607589>, BranchRadius(0.005032513770276266)
  <2.054895109602705, 4.166939719424203, 0.3875381510457002>, BranchRadius(0.004992506046501639)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  19
  <1.706767927655617, 4.121614648096034, 0.16720289752290865>, BranchRadius(0.07480570446904179)
  <1.7716199755128, 4.156373927975161, 0.17777860783946006>, BranchRadius(0.07433600270182304)
  <1.8023609223941377, 4.193392413908791, 0.1880082744232727>, BranchRadius(0.04919370075930002)
  <1.817800016508554, 4.214472827332354, 0.18382003990075227>, BranchRadius(0.026463007493438467)
  <1.8294559124629934, 4.237712871947919, 0.1870881103629254>, BranchRadius(0.02620381401208389)
  <1.8416481377694396, 4.260287692648429, 0.1916155203774571>, BranchRadius(0.02605322108728578)
  <1.8506523637598198, 4.284131187103474, 0.19621376429504495>, BranchRadius(0.02589849726604298)
  <1.8658872691490336, 4.304767261038229, 0.19692470562533812>, BranchRadius(0.02566038439373166)
  <1.8762991598007455, 4.320207500517349, 0.2017902664499112>, BranchRadius(0.019247912724588947)
  <1.8856771261023129, 4.321013216740303, 0.20819047672641555>, BranchRadius(0.01138236013174488)
  <1.895103998221871, 4.318750909059059, 0.21400740990317801>, BranchRadius(0.01130578018475657)
  <1.9051277096404267, 4.3143484497357685, 0.2165675021507108>, BranchRadius(0.01124324290458876)
  <1.910114282253447, 4.310889013756354, 0.21610221293656243>, BranchRadius(0.006086879148906499)
  <1.915603956789859, 4.309038827958601, 0.21442148540858538>, BranchRadius(0.006031961457539009)
  <1.9214646537338882, 4.308119914580702, 0.21511913981622174>, BranchRadius(0.005973181073626362)
  <1.9272452180848823, 4.309020239708961, 0.21425399876547788>, BranchRadius(0.005913880163669303)
  <1.9330177657037115, 4.30987604934117, 0.2135216002173771>, BranchRadius(0.00588142191748663)
  <1.9385982162546325, 4.311378070292062, 0.21261017072158125>, BranchRadius(0.0058504870749365515)
  <1.9415190720387518, 4.311187740811986, 0.21211638121439885>, BranchRadius(0.0029684089846268914)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.895103998221871, 4.318750909059059, 0.21400740990317801>, BranchRadius(0.01130578018475657)
  <1.9051277096404267, 4.3143484497357685, 0.2165675021507108>, BranchRadius(0.01124324290458876)
  <1.9087598709475826, 4.316185367897397, 0.22219704526985007>, BranchRadius(0.006946842435522052)
  <1.9114823053257688, 4.317105885907675, 0.22447575893932156>, BranchRadius(0.003667633888246138)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.8658872691490336, 4.304767261038229, 0.19692470562533812>, BranchRadius(0.02566038439373166)
  <1.8762991598007455, 4.320207500517349, 0.2017902664499112>, BranchRadius(0.019247912724588947)
  <1.8777194225452296, 4.328097390387879, 0.20156317886483094>, BranchRadius(0.00801991753098257)
  <1.8780357570790112, 4.331159506896746, 0.19901724777115448>, BranchRadius(0.003994795387111926)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <1.8762991598007455, 4.320207500517349, 0.2017902664499112>, BranchRadius(0.019247912724588947)
  <1.8777194225452296, 4.328097390387879, 0.20156317886483094>, BranchRadius(0.00801991753098257)
  <1.8789192888858637, 4.333420417208551, 0.20393879132692924>, BranchRadius(0.005951287956321373)
  <1.8800985867871935, 4.338706702968482, 0.2062926013071045>, BranchRadius(0.0059055890560136375)
  <1.8817835087228207, 4.343984018274415, 0.2082310971045153>, BranchRadius(0.005869138328917543)
  <1.8837774529365197, 4.3485920129272255, 0.21115913481583423>, BranchRadius(0.005812300154549891)
  <1.8857214169775416, 4.352178367859362, 0.21219602741368704>, BranchRadius(0.00420904789133216)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  18
  <1.8506523637598198, 4.284131187103474, 0.19621376429504495>, BranchRadius(0.02589849726604298)
  <1.8658872691490336, 4.304767261038229, 0.19692470562533812>, BranchRadius(0.02566038439373166)
  <1.8770129082275901, 4.31700249216206, 0.18815842768720795>, BranchRadius(0.018717060518372096)
  <1.880463593093615, 4.3332396484039695, 0.17977754521955816>, BranchRadius(0.018595474175329953)
  <1.8839898715237389, 4.345561693478651, 0.16650790965282017>, BranchRadius(0.01844859513522036)
  <1.8880117749707157, 4.360354582832209, 0.1565372115306717>, BranchRadius(0.018287156799416265)
  <1.892862408732255, 4.375529053706683, 0.14779149210214063>, BranchRadius(0.01817362986668944)
  <1.8911011488461933, 4.391270715278596, 0.13915881867811247>, BranchRadius(0.01803953979115885)
  <1.8894181426250052, 4.406879259486954, 0.13058955895281688>, BranchRadius(0.017885507386830767)
  <1.8829042738263915, 4.414552287164749, 0.1286193098413388>, BranchRadius(0.010256106572723158)
  <1.8748344290777355, 4.420705787537054, 0.1292579685953545>, BranchRadius(0.01016837480148334)
  <1.8705213125486926, 4.4298476124211765, 0.12926536530878524>, BranchRadius(0.010108214041878519)
  <1.865899971489154, 4.438732537033885, 0.12874402092285311>, BranchRadius(0.01002848336144763)
  <1.8592028045116735, 4.445615983911027, 0.12622234335556556>, BranchRadius(0.009929387906012107)
  <1.8521281686748667, 4.452161757730691, 0.12413409581352651>, BranchRadius(0.009861967598732594)
  <1.8474195376569396, 4.460748355362762, 0.12462630859956393>, BranchRadius(0.009805260750475222)
  <1.8437501400910317, 4.466179759924475, 0.1278747313230079>, BranchRadius(0.007315523508257603)
  <1.841912542551062, 4.468482667666691, 0.13150654366599793>, BranchRadius(0.004676559598974087)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.8474195376569396, 4.460748355362762, 0.12462630859956393>, BranchRadius(0.009805260750475222)
  <1.8437501400910317, 4.466179759924475, 0.1278747313230079>, BranchRadius(0.007315523508257603)
  <1.840965361804175, 4.470474639006395, 0.1295089507547172>, BranchRadius(0.005373234555297)
  <1.8387315647840892, 4.475307321603971, 0.12972697249189802>, BranchRadius(0.005328433512181764)
  <1.8365538788706712, 4.480097531461401, 0.1303311238360891>, BranchRadius(0.005296548429157251)
  <1.834991760702979, 4.485055059664487, 0.13104820871327816>, BranchRadius(0.0052470477199390315)
  <1.8321212725847504, 4.4893514745420235, 0.13173584606795616>, BranchRadius(0.005212650762170551)
  <1.8305740646309565, 4.4906537325761535, 0.13012992068069634>, BranchRadius(0.002582387420427988)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <1.8521281686748667, 4.452161757730691, 0.12413409581352651>, BranchRadius(0.009861967598732594)
  <1.8474195376569396, 4.460748355362762, 0.12462630859956393>, BranchRadius(0.009805260750475222)
  <1.8439358984072673, 4.467516184226378, 0.12404668291273485>, BranchRadius(0.007633820530106682)
  <1.8414844874463898, 4.474035781968923, 0.12104070484797555>, BranchRadius(0.007586202907220908)
  <1.8412504444386077, 4.481460559141178, 0.11970470824772877>, BranchRadius(0.007547647256132452)
  <1.838310204690723, 4.48821619967923, 0.11830719242976014>, BranchRadius(0.007499115902284075)
  <1.8342096718676935, 4.494422119145545, 0.11867852373226925>, BranchRadius(0.007447529307855001)
  <1.8277704028128279, 4.498015780336297, 0.11805095575739728>, BranchRadius(0.007400839700868433)
  <1.8205082366898808, 4.499016010455405, 0.1173839810054429>, BranchRadius(0.007361003491929385)
  <1.8138176282115481, 4.500316378574046, 0.11473564921168107>, BranchRadius(0.007312240446276661)
  <1.80818049202352, 4.499873716509175, 0.11019441666467027>, BranchRadius(0.007252313227659222)
  <1.8042938272558007, 4.501261544669436, 0.10428213004244344>, BranchRadius(0.007210226287878017)
  <1.8004113084582223, 4.502032008167777, 0.0983307752224401>, BranchRadius(0.0071474604167776085)
  <1.7989925683056973, 4.500209358145876, 0.09486286445630446>, BranchRadius(0.004166687149835207)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.8911011488461933, 4.391270715278596, 0.13915881867811247>, BranchRadius(0.01803953979115885)
  <1.8894181426250052, 4.406879259486954, 0.13058955895281688>, BranchRadius(0.017885507386830767)
  <1.8985746347189065, 4.4131325849561165, 0.12327991689425238>, BranchRadius(0.013280673699526358)
  <1.9023575485180289, 4.420410204243794, 0.11295260069939815>, BranchRadius(0.0131881628400796)
  <1.905422048481027, 4.428274809998988, 0.10981897486377415>, BranchRadius(0.009003487912222597)
  <1.9090790975891414, 4.435900697235258, 0.10686975302465658>, BranchRadius(0.008956900902421436)
  <1.9116173900046225, 4.443889974325042, 0.10388039975638484>, BranchRadius(0.008899871334259131)
  <1.914211596730916, 4.44763854484792, 0.10206006530142292>, BranchRadius(0.004908697080861174)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.8985746347189065, 4.4131325849561165, 0.12327991689425238>, BranchRadius(0.013280673699526358)
  <1.9023575485180289, 4.420410204243794, 0.11295260069939815>, BranchRadius(0.0131881628400796)
  <1.9035289269697728, 4.420651830006636, 0.10440857057908147>, BranchRadius(0.008627338012582914)
  <1.9078869780800354, 4.421832043892112, 0.09712987547183867>, BranchRadius(0.008565332262051027)
  <1.909691913561865, 4.422353222250838, 0.09402137153146295>, BranchRadius(0.003632108991000093)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <1.7716199755128, 4.156373927975161, 0.17777860783946006>, BranchRadius(0.07433600270182304)
  <1.8023609223941377, 4.193392413908791, 0.1880082744232727>, BranchRadius(0.04919370075930002)
  <1.8233903758150392, 4.218089994510582, 0.19735314581808625>, BranchRadius(0.03375699957267325)
  <1.8424777112651798, 4.243631732736659, 0.2075468313186939>, BranchRadius(0.03347563278387591)
  <1.8546058885296874, 4.264975516292104, 0.22995430147346202>, BranchRadius(0.033237696956285284)
  <1.8721462871133878, 4.288075581910075, 0.24557973428988034>, BranchRadius(0.032945906646047206)
  <1.8829991036764768, 4.311961056395361, 0.2650622867899564>, BranchRadius(0.03267827061913705)
  <1.9007541132539965, 4.337047368995794, 0.2755532461287649>, BranchRadius(0.03247496994352653)
  <1.9133799390469328, 4.338343577272796, 0.28231968238224636>, BranchRadius(0.01438319479195677)
  <1.9203357540117618, 4.339007466639976, 0.28592738363300785>, BranchRadius(0.007863817090417335)
  <1.9234980746197392, 4.339067832874101, 0.28694353287208735>, BranchRadius(0.0033221190505372767)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <1.9007541132539965, 4.337047368995794, 0.2755532461287649>, BranchRadius(0.03247496994352653)
  <1.9133799390469328, 4.338343577272796, 0.28231968238224636>, BranchRadius(0.01438319479195677)
  <1.9187209737126822, 4.340949593231713, 0.2901016492981995>, BranchRadius(0.0097916790980842)
  <1.9224362677507003, 4.340767208765573, 0.2991019555388003>, BranchRadius(0.009738695308254585)
  <1.920769686245507, 4.3404371297809945, 0.30514548828451415>, BranchRadius(0.006277796914366425)
  <1.918803711924973, 4.341164194646427, 0.31100378465426876>, BranchRadius(0.006222002467327237)
  <1.9163810094499663, 4.343274752884134, 0.31629398644067114>, BranchRadius(0.006189521653408179)
  <1.91541540882744, 4.344094472408725, 0.32230297029236776>, BranchRadius(0.006141026916662261)
  <1.916589845201097, 4.345410785788117, 0.3281300569696883>, BranchRadius(0.006088260905508365)
  <1.9183729290512517, 4.345507771926842, 0.33390938516822527>, BranchRadius(0.006048919635289595)
  <1.9169610871969918, 4.346052061402845, 0.33639707944076264>, BranchRadius(0.002911729940901576)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <1.9187209737126822, 4.340949593231713, 0.2901016492981995>, BranchRadius(0.0097916790980842)
  <1.9224362677507003, 4.340767208765573, 0.2991019555388003>, BranchRadius(0.009738695308254585)
  <1.9274564233533278, 4.340960673553689, 0.3004968496778426>, BranchRadius(0.005213935227634471)
  <1.9315804937310668, 4.341678087582573, 0.30355630359062125>, BranchRadius(0.005184871995893457)
  <1.935604025839034, 4.34215466820385, 0.30671612317468333>, BranchRadius(0.005138131909190562)
  <1.9395188570723774, 4.342830145639629, 0.3099231709112479>, BranchRadius(0.0051056173511547604)
  <1.9429780772184366, 4.341506831396356, 0.3133707368808081>, BranchRadius(0.00505994819339321)
  <1.9463653246457264, 4.338334534997006, 0.3153138609726298>, BranchRadius(0.005031166943684551)
  <1.9496457316496338, 4.335887037574372, 0.31818622847537725>, BranchRadius(0.005000180878321094)
  <1.9523088254631176, 4.332056431379577, 0.319904902494259>, BranchRadius(0.0049718661347822974)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <1.8829991036764768, 4.311961056395361, 0.2650622867899564>, BranchRadius(0.03267827061913705)
  <1.9007541132539965, 4.337047368995794, 0.2755532461287649>, BranchRadius(0.03247496994352653)
  <1.9085012060225166, 4.348850557707262, 0.28016674756821486>, BranchRadius(0.014853185034004825)
  <1.9161243509744579, 4.361362780189814, 0.28194595068300643>, BranchRadius(0.014759187448327285)
  <1.9265966633964047, 4.371464138651091, 0.28386240119825573>, BranchRadius(0.014675815234714276)
  <1.9321367866791648, 4.3776834241753555, 0.2826007626185137>, BranchRadius(0.008424025779067512)
  <1.9366690546416723, 4.3791069295867695, 0.2820139247210747>, BranchRadius(0.004786668910439441)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.9161243509744579, 4.361362780189814, 0.28194595068300643>, BranchRadius(0.014759187448327285)
  <1.9265966633964047, 4.371464138651091, 0.28386240119825573>, BranchRadius(0.014675815234714276)
  <1.93202278548421, 4.374944618624464, 0.2894131897606231>, BranchRadius(0.008506926320412556)
  <1.93451149651429, 4.379303877903025, 0.29198859018236684>, BranchRadius(0.005641764917229639)
  <1.9364596614565626, 4.384235736993981, 0.29378974217242865>, BranchRadius(0.005600243675648925)
  <1.9370939187133196, 4.388040150009951, 0.29402685735161554>, BranchRadius(0.003864202928423643)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  25
  <1.5478680135001128, 3.9609867560409002, 0.19127903520515027>, BranchRadius(0.15801694708482295)
  <1.6075115090661478, 4.015203070019791, 0.1345444888289073>, BranchRadius(0.09856756067445029)
  <1.6429210187831216, 4.038003707618868, 0.07427809387186379>, BranchRadius(0.0735237432020382)
  <1.6672967430606378, 4.0880897577292385, 0.0703005080535208>, BranchRadius(0.05584451216238119)
  <1.6726118625681479, 4.139509376147154, 0.05035151618308485>, BranchRadius(0.05540929461985426)
  <1.6868969319898248, 4.185224383211997, 0.023067929146570833>, BranchRadius(0.05512095065308483)
  <1.6913683824966783, 4.2340887858089555, -0.0012658376776398216>, BranchRadius(0.05477094045794627)
  <1.6924793060163268, 4.285066578103176, -0.0203175164788511>, BranchRadius(0.05443285702040363)
  <1.7003257098499456, 4.326720554042534, -0.053783633510752785>, BranchRadius(0.05400556224936339)
  <1.7242587588295848, 4.350592033192215, -0.09532476619509928>, BranchRadius(0.05355655006583146)
  <1.7433716032566273, 4.363275311158812, -0.14336891594581752>, BranchRadius(0.05323914619281325)
  <1.7606193109884192, 4.3533378305490755, -0.19243721812478667>, BranchRadius(0.05295219751433199)
  <1.7528977627716054, 4.341026238273751, -0.24281813425232573>, BranchRadius(0.05243504859412762)
  <1.7481252230925453, 4.306942803406475, -0.28178775395565403>, BranchRadius(0.05199123894621171)
  <1.726350735989793, 4.309330543373132, -0.3122933039101149>, BranchRadius(0.03755553446245181)
  <1.709893274646784, 4.291608052536275, -0.3290377817883686>, BranchRadius(0.02941619035045912)
  <1.6938014351220914, 4.270372237802686, -0.34101429224785906>, BranchRadius(0.029212051100086546)
  <1.674008740221426, 4.255655981736649, -0.3563427492228754>, BranchRadius(0.029039293332774323)
  <1.6667171471092872, 4.236938423444014, -0.37708386955633855>, BranchRadius(0.028874008922184044)
  <1.6609543929109523, 4.229255141271131, -0.38637060853179994>, BranchRadius(0.013359853356116296)
  <1.654179878881735, 4.220535008056645, -0.3937368787780384>, BranchRadius(0.013273910537255549)
  <1.647902719584558, 4.211434963651138, -0.4009145088493625>, BranchRadius(0.01318074013343397)
  <1.644158029799359, 4.205110053848159, -0.4117687292064464>, BranchRadius(0.01310882470564499)
  <1.641764653821623, 4.204661974672806, -0.4173157317066944>, BranchRadius(0.0060579089012583924)
  <1.6409798922622558, 4.203986696304312, -0.4219558908875993>, BranchRadius(0.004754253758914515)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.647902719584558, 4.211434963651138, -0.4009145088493625>, BranchRadius(0.01318074013343397)
  <1.644158029799359, 4.205110053848159, -0.4117687292064464>, BranchRadius(0.01310882470564499)
  <1.6427637513283069, 4.200610866978865, -0.4166395287511992>, BranchRadius(0.006775793912512)
  <1.6427819818861988, 4.195133616446429, -0.42053549875528995>, BranchRadius(0.00672154654979669)
  <1.6441115232924515, 4.190521959734408, -0.4251566961061>, BranchRadius(0.0066626213261455165)
  <1.6453396132437408, 4.185029236137675, -0.4286307162777681>, BranchRadius(0.006614154034471809)
  <1.645399304423255, 4.178732860738864, -0.43052560461660117>, BranchRadius(0.00657559944159507)
  <1.6451293213331564, 4.17223022294856, -0.4309859200805772>, BranchRadius(0.006524498404261488)
  <1.6449874991558793, 4.167924268138487, -0.4312372872139886>, BranchRadius(0.004315616501975163)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.674008740221426, 4.255655981736649, -0.3563427492228754>, BranchRadius(0.029039293332774323)
  <1.6667171471092872, 4.236938423444014, -0.37708386955633855>, BranchRadius(0.028874008922184044)
  <1.6712287364991716, 4.225955454488885, -0.3868015231611844>, BranchRadius(0.01534316908190863)
  <1.6749577889251535, 4.211567517805518, -0.38997264780218394>, BranchRadius(0.015197848054544959)
  <1.6777282094239698, 4.208546243879161, -0.39611866831313713>, BranchRadius(0.0073876176132363055)
  <1.6776962167513076, 4.2069598532692, -0.3990250364019436>, BranchRadius(0.0033112888980142766)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <1.6712287364991716, 4.225955454488885, -0.3868015231611844>, BranchRadius(0.01534316908190863)
  <1.6749577889251535, 4.211567517805518, -0.38997264780218394>, BranchRadius(0.015197848054544959)
  <1.6756692340229007, 4.200718859140592, -0.38657217828920737>, BranchRadius(0.01139134504191148)
  <1.6792564233061724, 4.190587494828102, -0.38302917007208453>, BranchRadius(0.01131659741322494)
  <1.6833686741575487, 4.180157730065516, -0.3820501540232119>, BranchRadius(0.01125384700853299)
  <1.686776470307345, 4.169572323846401, -0.3810930766006361>, BranchRadius(0.011161536480926092)
  <1.6900107469230967, 4.159109631491289, -0.37932529937610426>, BranchRadius(0.011092948790131604)
  <1.6895699847391428, 4.148506046161867, -0.3764995495708884>, BranchRadius(0.010982493118724424)
  <1.6932803067102251, 4.138816607284145, -0.37322740233017887>, BranchRadius(0.010879276743381742)
  <1.6948369371262282, 4.132532005662754, -0.37284972545829365>, BranchRadius(0.006485518916106291)
  <1.6976072741883124, 4.12682721886509, -0.3717106945272361>, BranchRadius(0.006443349385705303)
  <1.6962512546924355, 4.122750822338855, -0.36975909878654717>, BranchRadius(0.004718529797233)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.6895699847391428, 4.148506046161867, -0.3764995495708884>, BranchRadius(0.010982493118724424)
  <1.6932803067102251, 4.138816607284145, -0.37322740233017887>, BranchRadius(0.010879276743381742)
  <1.6956496964299177, 4.137767740785598, -0.36883383786261864>, BranchRadius(0.005100738898058331)
  <1.6966892691355124, 4.13714048975514, -0.36673645170331953>, BranchRadius(0.0024234652806771964)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <1.7481252230925453, 4.306942803406475, -0.28178775395565403>, BranchRadius(0.05199123894621171)
  <1.726350735989793, 4.309330543373132, -0.3122933039101149>, BranchRadius(0.03755553446245181)
  <1.7141361697516448, 4.323134651251686, -0.33343476199903943>, BranchRadius(0.028048355973828567)
  <1.697943329279668, 4.337569113080601, -0.35092184663732057>, BranchRadius(0.027863235633854663)
  <1.6940842187556089, 4.339654935157634, -0.36952519240779624>, BranchRadius(0.019113551779557265)
  <1.69054115685407, 4.3495121394214635, -0.37968778953198257>, BranchRadius(0.014594387409052188)
  <1.689731607893694, 4.351917827290233, -0.3856007251764629>, BranchRadius(0.006434711460272189)
  <1.6873471512166989, 4.353967121541688, -0.3911614103646512>, BranchRadius(0.006387993451440674)
  <1.6844144963827425, 4.356307710870533, -0.39627958224464604>, BranchRadius(0.006346219833460258)
  <1.6800756484989747, 4.357405615349704, -0.4007326099003479>, BranchRadius(0.006313513325107124)
  <1.680255949238101, 4.3576484371262705, -0.40502596105749905>, BranchRadius(0.0043039905820430715)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.6940842187556089, 4.339654935157634, -0.36952519240779624>, BranchRadius(0.019113551779557265)
  <1.69054115685407, 4.3495121394214635, -0.37968778953198257>, BranchRadius(0.014594387409052188)
  <1.68874674066505, 4.354496052932596, -0.38463911854268024>, BranchRadius(0.007250860798418607)
  <1.6855895785033932, 4.360478858694107, -0.38708091262209426>, BranchRadius(0.007191939656394269)
  <1.6844759557679552, 4.363281185594961, -0.3853050525959356>, BranchRadius(0.0034995528983928067)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <1.697943329279668, 4.337569113080601, -0.35092184663732057>, BranchRadius(0.027863235633854663)
  <1.6940842187556089, 4.339654935157634, -0.36952519240779624>, BranchRadius(0.019113551779557265)
  <1.6929606696237447, 4.335241742565411, -0.37931393699463545>, BranchRadius(0.010796210080122545)
  <1.693177254902725, 4.331205844285233, -0.38923020055154484>, BranchRadius(0.01070829897981477)
  <1.6939333988688434, 4.328884653697441, -0.3946964275031746>, BranchRadius(0.005986594735663592)
  <1.6946726429302714, 4.3276820102083695, -0.4004589872357307>, BranchRadius(0.005932952706320818)
  <1.6954390218480373, 4.326487213370629, -0.4061733753388657>, BranchRadius(0.005888047853263514)
  <1.6965421934632012, 4.325803951370877, -0.41187611352043874>, BranchRadius(0.005848508984380527)
  <1.6975351909189373, 4.3263544135444665, -0.41757072679462864>, BranchRadius(0.005806692078475572)
  <1.69886358098506, 4.327835501994533, -0.4190717082091464>, BranchRadius(0.0024922255859818644)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <1.7141361697516448, 4.323134651251686, -0.33343476199903943>, BranchRadius(0.028048355973828567)
  <1.697943329279668, 4.337569113080601, -0.35092184663732057>, BranchRadius(0.027863235633854663)
  <1.6894610221585127, 4.345928750274654, -0.351571098380607>, BranchRadius(0.011927053112145872)
  <1.6821715072825412, 4.355114912606062, -0.35306166461625293>, BranchRadius(0.0118213532731595)
  <1.6757330990146646, 4.363256514245016, -0.3585214276980221>, BranchRadius(0.01172807704529317)
  <1.6695690487279402, 4.371594236637361, -0.36378378478370443>, BranchRadius(0.011627791395029091)
  <1.6682852813145461, 4.37931433195516, -0.36685980098420806>, BranchRadius(0.00840891230501063)
  <1.666076669254563, 4.382270288004364, -0.36907192952132184>, BranchRadius(0.004302226872334416)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.6757330990146646, 4.363256514245016, -0.3585214276980221>, BranchRadius(0.01172807704529317)
  <1.6695690487279402, 4.371594236637361, -0.36378378478370443>, BranchRadius(0.011627791395029091)
  <1.662097355303768, 4.371450329610443, -0.3667705401072943>, BranchRadius(0.008047833200322312)
  <1.6547120715728352, 4.371088056470065, -0.3697995365869729>, BranchRadius(0.00799052421863079)
  <1.651761157799616, 4.372095025854251, -0.37065889683258485>, BranchRadius(0.0032342509904765794)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.662097355303768, 4.371450329610443, -0.3667705401072943>, BranchRadius(0.008047833200322312)
  <1.6547120715728352, 4.371088056470065, -0.3697995365869729>, BranchRadius(0.00799052421863079)
  <1.6517285733143863, 4.367216897585753, -0.37215812450808367>, BranchRadius(0.005426791865123195)
  <1.6497450116307821, 4.3653501579135305, -0.3747010062156499>, BranchRadius(0.003726322763152209)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  30
  <1.7528977627716054, 4.341026238273751, -0.24281813425232573>, BranchRadius(0.05243504859412762)
  <1.7481252230925453, 4.306942803406475, -0.28178775395565403>, BranchRadius(0.05199123894621171)
  <1.7522756100552923, 4.28252845148701, -0.2983238497177399>, BranchRadius(0.029777991111572536)
  <1.7601696770999453, 4.254346100301808, -0.3020269668804755>, BranchRadius(0.029500411684457193)
  <1.7761161981271432, 4.229885353802468, -0.30424114370777455>, BranchRadius(0.029283480517151364)
  <1.7822482925493974, 4.2024877737292865, -0.3117417271271925>, BranchRadius(0.029060088222533687)
  <1.7839698050558819, 4.174257913222163, -0.3175245329048437>, BranchRadius(0.02886744658302275)
  <1.7917106731603087, 4.14717904998127, -0.3120105015404937>, BranchRadius(0.028698265022752033)
  <1.7960292366989994, 4.1190007843872545, -0.31150760642229874>, BranchRadius(0.028511708935532086)
  <1.7996468405359876, 4.10866413367007, -0.3043907963042593>, BranchRadius(0.01306071942224806)
  <1.801529521424232, 4.097608736339821, -0.2978685288227027>, BranchRadius(0.01297329066033752)
  <1.8013664589661111, 4.086274741618776, -0.29173751622993005>, BranchRadius(0.01288702219733805)
  <1.7984080015524777, 4.076130207508215, -0.28449742435489495>, BranchRadius(0.012809487614559686)
  <1.7977090530456539, 4.064219800304021, -0.2801250552652687>, BranchRadius(0.012706846195686374)
  <1.7996119055661561, 4.051734231703442, -0.2803001695660444>, BranchRadius(0.012630951508610856)
  <1.801471560557904, 4.03961238846573, -0.2776599335851913>, BranchRadius(0.012544650102836072)
  <1.8030454455723417, 4.02723941524309, -0.27800601239742906>, BranchRadius(0.012477473740750263)
  <1.8026388729396516, 4.014875554345404, -0.27851841695636925>, BranchRadius(0.01238115164413279)
  <1.8048439633352027, 4.002796602395075, -0.2785156540397294>, BranchRadius(0.012278579376484107)
  <1.8036371864317944, 3.9914438429355013, -0.2828578968235149>, BranchRadius(0.012214603155030658)
  <1.8017666645178227, 3.9813019857550893, -0.2891898127324862>, BranchRadius(0.012101622964578078)
  <1.7950753659900394, 3.9720171132730244, -0.29291952901614043>, BranchRadius(0.012037155667045085)
  <1.7866078611690908, 3.9636653142777947, -0.2919377292300017>, BranchRadius(0.011933780422379624)
  <1.7800858418084258, 3.954753906200128, -0.2875850763619908>, BranchRadius(0.011869941762999254)
  <1.7744107255819674, 3.944462259271343, -0.2875741205169801>, BranchRadius(0.011752661856835609)
  <1.766862069983135, 3.9357074692829976, -0.28581849246103946>, BranchRadius(0.01169233847271893)
  <1.762195747576085, 3.9333195009018413, -0.2816980272695797>, BranchRadius(0.006667472623863626)
  <1.7581881531627834, 3.929361159920799, -0.2782227628414103>, BranchRadius(0.006618665964484416)
  <1.752791410135829, 3.9272892623351097, -0.2750715553829479>, BranchRadius(0.006583897276752849)
  <1.748989849512232, 3.927313144397884, -0.2724914598209359>, BranchRadius(0.004594488724213035)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.7581881531627834, 3.929361159920799, -0.2782227628414103>, BranchRadius(0.006618665964484416)
  <1.752791410135829, 3.9272892623351097, -0.2750715553829479>, BranchRadius(0.006583897276752849)
  <1.7497935908458195, 3.9231821416123767, -0.27403920589467395>, BranchRadius(0.005188555347357867)
  <1.7475793566203675, 3.920264334020697, -0.2733667758251232>, BranchRadius(0.0037240564638126097)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.7744107255819674, 3.944462259271343, -0.2875741205169801>, BranchRadius(0.011752661856835609)
  <1.766862069983135, 3.9357074692829976, -0.28581849246103946>, BranchRadius(0.01169233847271893)
  <1.7624463553201002, 3.9299878485024218, -0.2853920913128522>, BranchRadius(0.007238398704002973)
  <1.760777302387042, 3.923364875410788, -0.2831225187462521>, BranchRadius(0.007197254330709441)
  <1.7581103266678473, 3.9170327167118533, -0.2812353603226056>, BranchRadius(0.007125332286371846)
  <1.7541833070340098, 3.9114210531139535, -0.27947245594860104>, BranchRadius(0.0070724877781743615)
  <1.7496243087230907, 3.9067161643190738, -0.27697366507843824>, BranchRadius(0.007011733022866461)
  <1.7448531839237584, 3.902355292226568, -0.27442420264111117>, BranchRadius(0.006948423992341204)
  <1.7417585218319331, 3.9020596140570287, -0.2737875990929766>, BranchRadius(0.003173266947488148)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.7496243087230907, 3.9067161643190738, -0.27697366507843824>, BranchRadius(0.007011733022866461)
  <1.7448531839237584, 3.902355292226568, -0.27442420264111117>, BranchRadius(0.006948423992341204)
  <1.7441295409595738, 3.897704551407082, -0.27243567778686506>, BranchRadius(0.0051095283936584005)
  <1.7454328168318063, 3.895068079341994, -0.2722678892048498>, BranchRadius(0.0029457878330568835)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  19
  <1.7917106731603087, 4.14717904998127, -0.3120105015404937>, BranchRadius(0.028698265022752033)
  <1.7960292366989994, 4.1190007843872545, -0.31150760642229874>, BranchRadius(0.028511708935532086)
  <1.798866354119827, 4.0966873691931776, -0.313095601176628>, BranchRadius(0.022549045661016228)
  <1.7979036430762496, 4.0752388643783775, -0.3067836634798865>, BranchRadius(0.02237868916696179)
  <1.7893840964881629, 4.065925017184069, -0.30825161807411>, BranchRadius(0.012707687213501843)
  <1.7840317078963426, 4.054918096191707, -0.305182438961206>, BranchRadius(0.012618250029106244)
  <1.7787285944564097, 4.044003217037228, -0.30209797484500894>, BranchRadius(0.012520843342114486)
  <1.7736336548177118, 4.033472325829958, -0.2979272948977482>, BranchRadius(0.012419849063648911)
  <1.7684075727724409, 4.0238045711622386, -0.2923070917902279>, BranchRadius(0.012343585250197943)
  <1.7628122844210032, 4.013095805209276, -0.29043419191979475>, BranchRadius(0.012226719670284526)
  <1.756653882455267, 4.0030692077832075, -0.28755341230658976>, BranchRadius(0.012114349421074045)
  <1.7504080352920723, 3.9929174584482827, -0.2859784514171882>, BranchRadius(0.012022858360152211)
  <1.7429569819043564, 3.9835805809923586, -0.28545498996806734>, BranchRadius(0.01195698495032301)
  <1.7359895601136213, 3.974115219369049, -0.2869687893173993>, BranchRadius(0.011850300651885371)
  <1.7345830370548434, 3.9656262814113137, -0.28777738006009457>, BranchRadius(0.008642580271789463)
  <1.7344156204199965, 3.957255749995704, -0.2858174218685466>, BranchRadius(0.008598561543766809)
  <1.7344169279124442, 3.951500330787682, -0.2868273129592845>, BranchRadius(0.005843349380685481)
  <1.7343820788793884, 3.9458704901951203, -0.28826903601685777>, BranchRadius(0.005811616378211734)
  <1.7355369553634057, 3.943731809740868, -0.29017798975582293>, BranchRadius(0.0030905983492272716)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <1.7429569819043564, 3.9835805809923586, -0.28545498996806734>, BranchRadius(0.01195698495032301)
  <1.7359895601136213, 3.974115219369049, -0.2869687893173993>, BranchRadius(0.011850300651885371)
  <1.729696338201831, 3.972993267194902, -0.28776816336730987>, BranchRadius(0.006442237001521961)
  <1.7239990231631435, 3.970452838696668, -0.2892215299691415>, BranchRadius(0.006405111246810331)
  <1.7178127464956037, 3.96925086102743, -0.2899892696523544>, BranchRadius(0.00634855838327682)
  <1.7117909132055213, 3.9676251392071618, -0.29096073508163983>, BranchRadius(0.0063126216971030585)
  <1.705804959296898, 3.9660202504537976, -0.2918079099424956>, BranchRadius(0.0062549993886254285)
  <1.6997949908013352, 3.964762050248433, -0.2926345296541687>, BranchRadius(0.006195650831201111)
  <1.694494836970445, 3.9617983508251924, -0.2916864489936365>, BranchRadius(0.006146055795491384)
  <1.6921468137974292, 3.9602787233087104, -0.2912531448495553>, BranchRadius(0.0028302355186707075)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <1.798866354119827, 4.0966873691931776, -0.313095601176628>, BranchRadius(0.022549045661016228)
  <1.7979036430762496, 4.0752388643783775, -0.3067836634798865>, BranchRadius(0.02237868916696179)
  <1.7990682793994273, 4.066959887860921, -0.3035491978803603>, BranchRadius(0.008964351491121684)
  <1.8004005649929606, 4.058719690949992, -0.3004810637065352>, BranchRadius(0.008893215242094184)
  <1.8009045431139439, 4.050414101913333, -0.2975737961804367>, BranchRadius(0.008814136807459435)
  <1.8007649612268561, 4.041873815232945, -0.2956831804515504>, BranchRadius(0.008748165951827827)
  <1.802139428176196, 4.03362320317848, -0.293425621906625>, BranchRadius(0.008663621024252983)
  <1.803734840451548, 4.0254865403485365, -0.2911655907070906>, BranchRadius(0.008594088861501684)
  <1.8052783496885707, 4.017371232263952, -0.28901816774158035>, BranchRadius(0.00853534249255994)
  <1.8076938019382929, 4.010673772879728, -0.2844374705274159>, BranchRadius(0.00846600016193438)
  <1.8084100224788953, 4.007076049499775, -0.28118041589750853>, BranchRadius(0.004905608040156238)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <1.8052783496885707, 4.017371232263952, -0.28901816774158035>, BranchRadius(0.00853534249255994)
  <1.8076938019382929, 4.010673772879728, -0.2844374705274159>, BranchRadius(0.00846600016193438)
  <1.8104079006749902, 4.0054638797612006, -0.28201835724990865>, BranchRadius(0.006353064402981664)
  <1.8102494082973541, 4.001134194910204, -0.28251606774722415>, BranchRadius(0.004361078591570604)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <1.6075115090661478, 4.015203070019791, 0.1345444888289073>, BranchRadius(0.09856756067445029)
  <1.6429210187831216, 4.038003707618868, 0.07427809387186379>, BranchRadius(0.0735237432020382)
  <1.657587273006042, 4.044804483683143, 0.04643363239669636>, BranchRadius(0.03219726079730754)
  <1.681094304580189, 4.050049727456865, 0.02537324432911254>, BranchRadius(0.031994266068015045)
  <1.7034801752142743, 4.059798971940738, 0.005033068503060064>, BranchRadius(0.03177888803415049)
  <1.7166692931355225, 4.050695057926811, -0.007237607337410355>, BranchRadius(0.020184240572671455)
  <1.7248076760142002, 4.04018501912084, -0.013222380623058142>, BranchRadius(0.014577781136495925)
  <1.7287466042108093, 4.027334162176497, -0.018565249867061807>, BranchRadius(0.014463952824195114)
  <1.7304198079877664, 4.0187599350305065, -0.025070094442990846>, BranchRadius(0.010891739300371392)
  <1.731010987437587, 4.010523982781961, -0.032017658714151576>, BranchRadius(0.010791156188478023)
  <1.7340103345554918, 4.00480321573426, -0.031207367632054006>, BranchRadius(0.006509979292246295)
  <1.736664608291664, 3.9993534319194137, -0.029011367186872965>, BranchRadius(0.006447304138190207)
  <1.7363542142783999, 3.9932176216777786, -0.02717491458994187>, BranchRadius(0.006412259344848574)
  <1.7351809290578157, 3.987046661748712, -0.026157169034901305>, BranchRadius(0.006363422873720751)
  <1.73522593339008, 3.9835158578135466, -0.026736028830779725>, BranchRadius(0.003578223089996806)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <1.7304198079877664, 4.0187599350305065, -0.025070094442990846>, BranchRadius(0.010891739300371392)
  <1.731010987437587, 4.010523982781961, -0.032017658714151576>, BranchRadius(0.010791156188478023)
  <1.7289680187005554, 4.008732978623325, -0.03825633441219926>, BranchRadius(0.006804593420782097)
  <1.7268042861025623, 4.006931885455111, -0.04438731642412244>, BranchRadius(0.00674645208881894)
  <1.7243193874773488, 4.007061366467994, -0.05062039778843116>, BranchRadius(0.006711392538391532)
  <1.7237142182505296, 4.00765168570489, -0.05722307072047873>, BranchRadius(0.006656575429012452)
  <1.7240691667243295, 4.009880171344115, -0.06344601117527479>, BranchRadius(0.006619450473205612)
  <1.7255509904619488, 4.009288037654304, -0.0698180867981061>, BranchRadius(0.006568848577875867)
  <1.7281541150926287, 4.009831015404775, -0.07577239507359691>, BranchRadius(0.0065211095466905025)
  <1.7295203626945415, 4.010592825898678, -0.08205839284494258>, BranchRadius(0.006477712228844006)
  <1.7313997581893623, 4.012488206985338, -0.08791171319199943>, BranchRadius(0.006433191740877106)
  <1.7309196583426496, 4.014485442143056, -0.09129417787899229>, BranchRadius(0.003957336414407481)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.7248076760142002, 4.04018501912084, -0.013222380623058142>, BranchRadius(0.014577781136495925)
  <1.7287466042108093, 4.027334162176497, -0.018565249867061807>, BranchRadius(0.014463952824195114)
  <1.730720952688262, 4.0210400369547035, -0.021043141694606998>, BranchRadius(0.007046560304648968)
  <1.7335552924245206, 4.014667165075536, -0.02150968223780615>, BranchRadius(0.006990324585258728)
  <1.7367515954101933, 4.008679793555589, -0.022981656640069494>, BranchRadius(0.006944903104796002)
  <1.7382958984207495, 4.005607157700593, -0.024199938109625972>, BranchRadius(0.0036483109276602816)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <1.7034801752142743, 4.059798971940738, 0.005033068503060064>, BranchRadius(0.03177888803415049)
  <1.7166692931355225, 4.050695057926811, -0.007237607337410355>, BranchRadius(0.020184240572671455)
  <1.724723878724075, 4.052761721432658, -0.017204958406153912>, BranchRadius(0.012980582975248027)
  <1.7282703368551928, 4.054736886615121, -0.02945814289129021>, BranchRadius(0.012908104926772641)
  <1.731013267333483, 4.055797403820917, -0.041924114357289655>, BranchRadius(0.012808154002182949)
  <1.7353188901762775, 4.058599188995119, -0.05358185918433389>, BranchRadius(0.012739364296512158)
  <1.7374448375711062, 4.061928742469888, -0.06108875393609262>, BranchRadius(0.008482867880670373)
  <1.7364597835447473, 4.065713984280052, -0.06853347155332244>, BranchRadius(0.00840964965956062)
  <1.7341757842792056, 4.066722714155842, -0.07285776935487968>, BranchRadius(0.004993369612181684)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <1.731013267333483, 4.055797403820917, -0.041924114357289655>, BranchRadius(0.012808154002182949)
  <1.7353188901762775, 4.058599188995119, -0.05358185918433389>, BranchRadius(0.012739364296512158)
  <1.7386676496115552, 4.055756854084792, -0.05813150458434134>, BranchRadius(0.006323948984901216)
  <1.743409926974707, 4.054549319635357, -0.06206471203794313>, BranchRadius(0.006278332175721778)
  <1.7463100032598668, 4.053834395398342, -0.0659228208359944>, BranchRadius(0.004879196923881972)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <1.681094304580189, 4.050049727456865, 0.02537324432911254>, BranchRadius(0.031994266068015045)
  <1.7034801752142743, 4.059798971940738, 0.005033068503060064>, BranchRadius(0.03177888803415049)
  <1.7143040974017607, 4.067330891752149, -0.004747291288281854>, BranchRadius(0.016417750918270475)
  <1.7212171793052125, 4.07250360163054, -0.01855190185629835>, BranchRadius(0.016282349395109932)
  <1.7255979354433664, 4.076879527190526, -0.0252721140732658>, BranchRadius(0.009137888218269516)
  <1.7302234631958051, 4.081687851135239, -0.03141789195025569>, BranchRadius(0.009071167061584806)
  <1.7332927544889896, 4.086797321893022, -0.038144797151162084>, BranchRadius(0.008987685689266358)
  <1.7358028204712812, 4.089305632932664, -0.04634414384631521>, BranchRadius(0.00893427902711613)
  <1.738164062261642, 4.094454272535645, -0.053148408144285064>, BranchRadius(0.008853358977843501)
  <1.7375225451838034, 4.096057547614845, -0.05669326974727912>, BranchRadius(0.0039431052389102906)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.7358028204712812, 4.089305632932664, -0.04634414384631521>, BranchRadius(0.00893427902711613)
  <1.738164062261642, 4.094454272535645, -0.053148408144285064>, BranchRadius(0.008853358977843501)
  <1.7422460500507848, 4.097779229500012, -0.05489401605430962>, BranchRadius(0.005546630517813269)
  <1.7463613631866854, 4.100237407344906, -0.057584015218585895>, BranchRadius(0.005496775057017556)
  <1.750761031532184, 4.103292498257091, -0.058681458171250346>, BranchRadius(0.005467635966891736)
  <1.7535147244732572, 4.103729220675464, -0.05995630667784178>, BranchRadius(0.00306574460762537)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <1.7143040974017607, 4.067330891752149, -0.004747291288281854>, BranchRadius(0.016417750918270475)
  <1.7212171793052125, 4.07250360163054, -0.01855190185629835>, BranchRadius(0.016282349395109932)
  <1.724358291022351, 4.072724925938041, -0.028755812314227525>, BranchRadius(0.01067873381548919)
  <1.7283435235551632, 4.074204575362965, -0.03845181343232347>, BranchRadius(0.010586967386526727)
  <1.7329901857395327, 4.076747757637056, -0.04752760044324843>, BranchRadius(0.010508527746672037)
  <1.7363659101644002, 4.076484553116113, -0.05229446044478652>, BranchRadius(0.005847028842647878)
  <1.7415160134154886, 4.076348111087161, -0.054953118257335724>, BranchRadius(0.005797468524137352)
  <1.7472125645818606, 4.076193653259048, -0.05580182400679532>, BranchRadius(0.005761497536311637)
  <1.7521005563656764, 4.076426853782986, -0.05874645057595803>, BranchRadius(0.005711188299717926)
  <1.757085973022007, 4.0752152621633595, -0.06116837152104787>, BranchRadius(0.005673449969307299)
  <1.7621976653880806, 4.075093597567599, -0.06353025597337636>, BranchRadius(0.005632290767120287)
  <1.7672722886498768, 4.074774207826316, -0.06586342717736408>, BranchRadius(0.0055944167634451964)
  <1.7726900688938687, 4.07593412717864, -0.06623873941919228>, BranchRadius(0.005553252646418248)
  <1.778069692806061, 4.077017227539687, -0.06660069658568515>, BranchRadius(0.005499497506055189)
  <1.782393165309617, 4.080214014907138, -0.06746119094016802>, BranchRadius(0.005445393878848243)
  <1.7866143907931118, 4.083551637226874, -0.06789215522833023>, BranchRadius(0.00539853661183985)
  <1.7883398536993662, 4.085153295230676, -0.06878157222306844>, BranchRadius(0.002516663106681966)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <1.7283435235551632, 4.074204575362965, -0.03845181343232347>, BranchRadius(0.010586967386526727)
  <1.7329901857395327, 4.076747757637056, -0.04752760044324843>, BranchRadius(0.010508527746672037)
  <1.7334400941177752, 4.080227866210799, -0.05120475659618693>, BranchRadius(0.005082819159378144)
  <1.732309042122734, 4.083505787748717, -0.05487721562338297>, BranchRadius(0.0050508418635575566)
  <1.730415795511049, 4.087591622568113, -0.05705679476593802>, BranchRadius(0.005002898574097665)
  <1.7291727495171243, 4.0916832326344865, -0.05959790364401449>, BranchRadius(0.004974301017077667)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  20
  <0.8228775171995562, 3.193247059354079, 0.25734684085347687>, BranchRadius(0.3191960476076195)
  <0.9602025003769195, 3.4783547076866124, 0.2656819459318523>, BranchRadius(0.3165659427655448)
  <0.9119701779984378, 3.651453425052639, 0.28519841761684056>, BranchRadius(0.18074959347897926)
  <0.8750349508579319, 3.7200582355319423, 0.27083932978260156>, BranchRadius(0.07922761152687408)
  <0.8359287938030616, 3.7869396169146095, 0.25756096643682763>, BranchRadius(0.07860487025875916)
  <0.8252740275554448, 3.8079651447434117, 0.23166280074358425>, BranchRadius(0.03501873570741503)
  <0.8229586806335216, 3.8215457350348063, 0.1997513720377762>, BranchRadius(0.03475820113408417)
  <0.829225251448064, 3.845986373443794, 0.17626020454390076>, BranchRadius(0.034473898326674086)
  <0.8191318159700529, 3.8691573537382564, 0.1753447631426132>, BranchRadius(0.025290508111035125)
  <0.8192376078867017, 3.89417403344386, 0.17332043225623836>, BranchRadius(0.0250986726931909)
  <0.8231325109858421, 3.917592969238267, 0.1657623386386899>, BranchRadius(0.024914686492626664)
  <0.826573849191532, 3.940876315389594, 0.1582163693004119>, BranchRadius(0.02471636441515383)
  <0.8192624537251731, 3.9635106937798, 0.15240819499781053>, BranchRadius(0.02448482136969611)
  <0.8160057466201727, 3.9873845973334583, 0.14936824240353583>, BranchRadius(0.024286019102203134)
  <0.821856705424544, 4.002348897476606, 0.15684421934041753>, BranchRadius(0.01772157523657136)
  <0.8315942601685475, 4.006576586508552, 0.15985516058505148>, BranchRadius(0.01103445033166303)
  <0.8407088659453098, 4.010391213085866, 0.16456809590210658>, BranchRadius(0.010947108005901774)
  <0.84593341929154, 4.0098177360156555, 0.16666425865132548>, BranchRadius(0.005658509687972105)
  <0.851460515830843, 4.008929354400285, 0.16615795032692607>, BranchRadius(0.0056208865998754525)
  <0.8532054723514344, 4.010707678006736, 0.1661577498737388>, BranchRadius(0.0024914469988732636)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <0.8315942601685475, 4.006576586508552, 0.15985516058505148>, BranchRadius(0.01103445033166303)
  <0.8407088659453098, 4.010391213085866, 0.16456809590210658>, BranchRadius(0.010947108005901774)
  <0.8456710737594376, 4.0142743039323285, 0.16753008484731619>, BranchRadius(0.0069624190784537375)
  <0.8502912764085329, 4.018625346117248, 0.1702415904143075>, BranchRadius(0.006901456589262976)
  <0.8548603628394363, 4.0225756301428675, 0.17350632313974013>, BranchRadius(0.006865841133076481)
  <0.8590617547494392, 4.02569915427046, 0.17213441893901255>, BranchRadius(0.005412043799994794)
  <0.8632550755304036, 4.028735630318247, 0.17074231362505304>, BranchRadius(0.005361164347975416)
  <0.8677020400206181, 4.030094757467838, 0.16814100314035216>, BranchRadius(0.005328183182267757)
  <0.8726057589962422, 4.031832320408631, 0.16713037183000085>, BranchRadius(0.005299713238522955)
  <0.8778490763914804, 4.031537680408648, 0.16668413972017956>, BranchRadius(0.005270513554923586)
  <0.8828352934297853, 4.0302585461146325, 0.1675614518665154>, BranchRadius(0.005221898265699513)
  <0.887766239421678, 4.0287107673316305, 0.16798281357459263>, BranchRadius(0.00518530550933197)
  <0.8897062898946355, 4.02821896202798, 0.16645968809029144>, BranchRadius(0.002515070483157486)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.8160057466201727, 3.9873845973334583, 0.14936824240353583>, BranchRadius(0.024286019102203134)
  <0.821856705424544, 4.002348897476606, 0.15684421934041753>, BranchRadius(0.01772157523657136)
  <0.8243685590556186, 4.014232167809028, 0.16254364530683296>, BranchRadius(0.01341659341278556)
  <0.8262228568306876, 4.022265528066562, 0.17303894199759567>, BranchRadius(0.013346330952478853)
  <0.8290460413577886, 4.032828870277006, 0.18056492514100683>, BranchRadius(0.013273846157159219)
  <0.8340666022883164, 4.042211143166454, 0.18836045418654246>, BranchRadius(0.013191032928811902)
  <0.8314808570432345, 4.050404845758566, 0.19100132544008572>, BranchRadius(0.00898871746236525)
  <0.830764891359799, 4.05506097291292, 0.19465272939741182>, BranchRadius(0.0059602749766219775)
  <0.8298173755485917, 4.057505807240615, 0.19995550324769024>, BranchRadius(0.00591560745904903)
  <0.8292258692217059, 4.058930907398796, 0.20230224418476248>, BranchRadius(0.002808555361983487)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.8290460413577886, 4.032828870277006, 0.18056492514100683>, BranchRadius(0.013273846157159219)
  <0.8340666022883164, 4.042211143166454, 0.18836045418654246>, BranchRadius(0.013191032928811902)
  <0.8367294563649433, 4.045534099171535, 0.19165033534886122>, BranchRadius(0.005381091572096882)
  <0.8400678266843259, 4.047383639681022, 0.19537327453147083>, BranchRadius(0.005331584440199629)
  <0.8428298302523823, 4.0469065463574605, 0.197945806386764>, BranchRadius(0.0038044975878349296)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <0.8192624537251731, 3.9635106937798, 0.15240819499781053>, BranchRadius(0.02448482136969611)
  <0.8160057466201727, 3.9873845973334583, 0.14936824240353583>, BranchRadius(0.024286019102203134)
  <0.8090388212605604, 3.992418345790898, 0.14126202877159746>, BranchRadius(0.011814709981451418)
  <0.8021535963423831, 3.9969416071312023, 0.13293095283327844>, BranchRadius(0.01171635786482386)
  <0.7959157230350333, 4.005244376561769, 0.1277304625171594>, BranchRadius(0.011614307691108825)
  <0.7937950926488399, 4.012424910202097, 0.11896319427944296>, BranchRadius(0.011529185962018462)
  <0.7881070312710841, 4.016693265722384, 0.11684396150802905>, BranchRadius(0.007420515388038361)
  <0.784242142972307, 4.022604987880174, 0.11470055835805336>, BranchRadius(0.0073810566652928325)
  <0.7815602419526869, 4.027054106190932, 0.10955037254788323>, BranchRadius(0.00731516648487466)
  <0.7823308648530751, 4.032119475081804, 0.10441062262947616>, BranchRadius(0.0072573308370900485)
  <0.7829694537144165, 4.0363922458501325, 0.09863249779733334>, BranchRadius(0.0072146442981158)
  <0.7815613960635467, 4.040474540104228, 0.092922758188723>, BranchRadius(0.007158832245787395)
  <0.7807868924304697, 4.0465736509023404, 0.08934548234054204>, BranchRadius(0.007113080268019339)
  <0.780641862226282, 4.0534772628931846, 0.08784028564558805>, BranchRadius(0.0070672844410528506)
  <0.7801668565268062, 4.06031664073167, 0.08938811425456619>, BranchRadius(0.0070284061518149045)
  <0.776982794890995, 4.065898431184513, 0.09208333462689525>, BranchRadius(0.006968417755524679)
  <0.7746542878856552, 4.0691791276031495, 0.09421020204979896>, BranchRadius(0.0045506569745240215)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.7959157230350333, 4.005244376561769, 0.1277304625171594>, BranchRadius(0.011614307691108825)
  <0.7937950926488399, 4.012424910202097, 0.11896319427944296>, BranchRadius(0.011529185962018462)
  <0.7967114576484561, 4.014100982115805, 0.11453411905116498>, BranchRadius(0.00556157434982686)
  <0.796954215462152, 4.016894508006752, 0.11313860333509689>, BranchRadius(0.0031321210661943797)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <0.8229586806335216, 3.8215457350348063, 0.1997513720377762>, BranchRadius(0.03475820113408417)
  <0.829225251448064, 3.845986373443794, 0.17626020454390076>, BranchRadius(0.034473898326674086)
  <0.8426948390716801, 3.850204687146932, 0.15570687508061914>, BranchRadius(0.024933176959115184)
  <0.8558070645143898, 3.8610617303957024, 0.13774077645551963>, BranchRadius(0.02475048573206032)
  <0.8684065865137885, 3.8661734922306317, 0.11722708980906704>, BranchRadius(0.024610757881447256)
  <0.8880884971205466, 3.8739033549018616, 0.10494993316899587>, BranchRadius(0.02445111361908346)
  <0.9005988782891737, 3.876524181903928, 0.10000748265456136>, BranchRadius(0.013704239790908996)
  <0.9137065275938997, 3.875670722834251, 0.09657119630797277>, BranchRadius(0.01357744182587601)
  <0.9262142289988889, 3.87061579375707, 0.09669252877355203>, BranchRadius(0.013491094246906154)
  <0.9361256881525514, 3.8620809980102417, 0.09392680728662846>, BranchRadius(0.013368955693622042)
  <0.9469122062232318, 3.8564757663743188, 0.08868785291683129>, BranchRadius(0.013236851463633037)
  <0.9566262503446447, 3.8512063744978944, 0.0815705843887172>, BranchRadius(0.013144757709496439)
  <0.9632967814907257, 3.8469634916126534, 0.08004913071637335>, BranchRadius(0.008050643590781741)
  <0.9691600877847572, 3.8417085498167824, 0.08144669509313292>, BranchRadius(0.007996621796909497)
  <0.9732391169287757, 3.8381402986145647, 0.0815844603417545>, BranchRadius(0.0054212429076374025)
  <0.9750939913010619, 3.836560054813507, 0.08159555031573591>, BranchRadius(0.0024367708951125427)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.9632967814907257, 3.8469634916126534, 0.08004913071637335>, BranchRadius(0.008050643590781741)
  <0.9691600877847572, 3.8417085498167824, 0.08144669509313292>, BranchRadius(0.007996621796909497)
  <0.971332704312728, 3.839357186029812, 0.08581718786519477>, BranchRadius(0.005417599219851165)
  <0.9719987497082452, 3.8369572185363534, 0.0905904868881726>, BranchRadius(0.005384036032690501)
  <0.9736646004324322, 3.836700541016629, 0.09567366492389529>, BranchRadius(0.005355337610950398)
  <0.9743100523309778, 3.8355047015799166, 0.1008015442019934>, BranchRadius(0.005304883222322598)
  <0.9758116035576274, 3.8337485933774107, 0.10552303875061221>, BranchRadius(0.00525652764453857)
  <0.9779244104510714, 3.8349930851695517, 0.10858924696230346>, BranchRadius(0.00392611074565326)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.9469122062232318, 3.8564757663743188, 0.08868785291683129>, BranchRadius(0.013236851463633037)
  <0.9566262503446447, 3.8512063744978944, 0.0815705843887172>, BranchRadius(0.013144757709496439)
  <0.9604348607598501, 3.850138396799592, 0.07340063924047219>, BranchRadius(0.009077119222760863)
  <0.964675790891868, 3.8483183285153437, 0.06565193486596006>, BranchRadius(0.009018899956622669)
  <0.9686814703947441, 3.8464442576431583, 0.05784985020839026>, BranchRadius(0.00896828494850731)
  <0.9703401106117653, 3.8443428780142335, 0.049375752204619705>, BranchRadius(0.00888691288873073)
  <0.968567292508067, 3.84275700280377, 0.04516729769781879>, BranchRadius(0.0048341466204260795)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <0.8684065865137885, 3.8661734922306317, 0.11722708980906704>, BranchRadius(0.024610757881447256)
  <0.8880884971205466, 3.8739033549018616, 0.10494993316899587>, BranchRadius(0.02445111361908346)
  <0.8893207642965342, 3.8850713108656056, 0.0908465846433768>, BranchRadius(0.01803180973824396)
  <0.890115159338207, 3.896176715098445, 0.07686234155596673>, BranchRadius(0.017875125772558138)
  <0.8944392047968615, 3.902097089189893, 0.06069086819367549>, BranchRadius(0.017755696247077856)
  <0.899772331789789, 3.906542435727772, 0.04451187267718215>, BranchRadius(0.017605773067015166)
  <0.9085473567468153, 3.9062799770082606, 0.029429499886073424>, BranchRadius(0.01745130128631841)
  <0.9135622501142767, 3.9111463855460897, 0.013555229178433291>, BranchRadius(0.017344265854843926)
  <0.9230005647196742, 3.9082716925526313, 0.00555448768782202>, BranchRadius(0.012702657469863802)
  <0.9341089298294906, 3.904352565258508, 0.001136442642509991>, BranchRadius(0.01258071763386074)
  <0.9410311702747752, 3.9025286817905833, 0.004373767747323175>, BranchRadius(0.007856477424466804)
  <0.9480560093208577, 3.901647403482572, 0.007629706516948851>, BranchRadius(0.007792698656504516)
  <0.9550590955230152, 3.900834880343215, 0.010815399990453313>, BranchRadius(0.007736410867706622)
  <0.9607724722079648, 3.900258310894199, 0.01591040315711731>, BranchRadius(0.007676858911168103)
  <0.9670078994031022, 3.8977485675745154, 0.019501956873265162>, BranchRadius(0.007620933140536675)
  <0.9698992918397844, 3.8926806733524364, 0.018566550841718286>, BranchRadius(0.005909203543028326)
  <0.9716068067719258, 3.890801429611044, 0.015377851736070975>, BranchRadius(0.004076146006880236)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.9230005647196742, 3.9082716925526313, 0.00555448768782202>, BranchRadius(0.012702657469863802)
  <0.9341089298294906, 3.904352565258508, 0.001136442642509991>, BranchRadius(0.01258071763386074)
  <0.9395348975510893, 3.9018731466767753, -0.006496133972862889>, BranchRadius(0.009687356089708355)
  <0.9433432456208669, 3.8996117180759944, -0.015030805160487819>, BranchRadius(0.009615518010896938)
  <0.9497034217736046, 3.898841784774368, -0.022117036099293358>, BranchRadius(0.00955297372030773)
  <0.9519371568940521, 3.8977525090656275, -0.025686988127107995>, BranchRadius(0.004349787539509373)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <0.9085473567468153, 3.9062799770082606, 0.029429499886073424>, BranchRadius(0.01745130128631841)
  <0.9135622501142767, 3.9111463855460897, 0.013555229178433291>, BranchRadius(0.017344265854843926)
  <0.9141507245005747, 3.916343487075979, 0.003282856222090985>, BranchRadius(0.011527263880448857)
  <0.9123255818267584, 3.9238538703313437, -0.005165675732742896>, BranchRadius(0.011450532503516766)
  <0.9128122373024155, 3.9295186335952854, -0.01501634068533001>, BranchRadius(0.01137374065101792)
  <0.9149616161669384, 3.9353017691335763, -0.02445499795517837>, BranchRadius(0.011276202251430436)
  <0.9172701350888474, 3.938520892305923, -0.03489620601946067>, BranchRadius(0.011167400747406842)
  <0.9202375067546583, 3.9412662994179555, -0.04521207516609283>, BranchRadius(0.011079698148609166)
  <0.9192641211419186, 3.9432702432284623, -0.055974139654438565>, BranchRadius(0.010990236685261565)
  <0.9149226283248709, 3.946008642746498, -0.06558499418713652>, BranchRadius(0.010895683395250516)
  <0.9165683463384204, 3.950776366179504, -0.06991703353886543>, BranchRadius(0.006648769770316893)
  <0.9194062904661753, 3.9555321844391838, -0.07349533408859142>, BranchRadius(0.006593630943230901)
  <0.9219800615495396, 3.9600921643775755, -0.07740909872143881>, BranchRadius(0.006537221751587329)
  <0.9229011306249966, 3.9645648191801635, -0.082038436420409>, BranchRadius(0.0065025976929210805)
  <0.9228948033790981, 3.970588787831829, -0.08431746880330881>, BranchRadius(0.006440669759628787)
  <0.9232111268373878, 3.9744204210910854, -0.08537745830605571>, BranchRadius(0.003988113803496306)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.9192641211419186, 3.9432702432284623, -0.055974139654438565>, BranchRadius(0.010990236685261565)
  <0.9149226283248709, 3.946008642746498, -0.06558499418713652>, BranchRadius(0.010895683395250516)
  <0.9097915747405732, 3.9450469688840673, -0.07117692654324922>, BranchRadius(0.007649982678278297)
  <0.9063525938000501, 3.9444082000145704, -0.07377994984838941>, BranchRadius(0.004360085538727663)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.9149226283248709, 3.946008642746498, -0.06558499418713652>, BranchRadius(0.010895683395250516)
  <0.9097915747405732, 3.9450469688840673, -0.07117692654324922>, BranchRadius(0.007649982678278297)
  <0.9104816781712288, 3.945141906805522, -0.07724749690785858>, BranchRadius(0.006110407556424215)
  <0.9108130166370606, 3.9437572450732095, -0.07996952253317627>, BranchRadius(0.003071888148477328)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <0.8750349508579319, 3.7200582355319423, 0.27083932978260156>, BranchRadius(0.07922761152687408)
  <0.8359287938030616, 3.7869396169146095, 0.25756096643682763>, BranchRadius(0.07860487025875916)
  <0.8184369503059729, 3.816618256461829, 0.2535039652771007>, BranchRadius(0.034687829172642945)
  <0.8033454176550627, 3.8473502650495357, 0.25647281193633>, BranchRadius(0.03436604079719343)
  <0.7831453439676873, 3.8740474159737506, 0.2503848309939032>, BranchRadius(0.03402711207847441)
  <0.7612620985396904, 3.8983595853043385, 0.24164796108710815>, BranchRadius(0.03385691810825946)
  <0.7484445521283629, 3.9130409380154094, 0.24273916237704105>, BranchRadius(0.01951979338232237)
  <0.7374664624703564, 3.928876777642459, 0.24031514831166137>, BranchRadius(0.01942081649730585)
  <0.7241664512432687, 3.9424864320871733, 0.24339686716292935>, BranchRadius(0.01927718817212323)
  <0.7166119256715711, 3.9499193585854364, 0.2449853307689285>, BranchRadius(0.010716457883535977)
  <0.7128620969370044, 3.955314189611238, 0.24847231320132787>, BranchRadius(0.0074380416656129825)
  <0.7098455437235824, 3.955982569807263, 0.24932319007138795>, BranchRadius(0.003204733502781227)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.7241664512432687, 3.9424864320871733, 0.24339686716292935>, BranchRadius(0.01927718817212323)
  <0.7166119256715711, 3.9499193585854364, 0.2449853307689285>, BranchRadius(0.010716457883535977)
  <0.7116523334086398, 3.9531601308058275, 0.2434346711377497>, BranchRadius(0.006124108530288544)
  <0.706741490830584, 3.9563762916381977, 0.24187622281442925>, BranchRadius(0.006073617250253543)
  <0.7019539513838015, 3.9598805472439373, 0.24287529571529337>, BranchRadius(0.006016517927015527)
  <0.6980945771756755, 3.962676166430443, 0.24647311496549432>, BranchRadius(0.005971143882994433)
  <0.694183928989591, 3.965326054448483, 0.2500644226377391>, BranchRadius(0.005934017740132311)
  <0.6919984839409041, 3.965140967634435, 0.25164450478195044>, BranchRadius(0.002703162365086499)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.7374664624703564, 3.928876777642459, 0.24031514831166137>, BranchRadius(0.01942081649730585)
  <0.7241664512432687, 3.9424864320871733, 0.24339686716292935>, BranchRadius(0.01927718817212323)
  <0.7253344359955649, 3.951485533653198, 0.2486771197983639>, BranchRadius(0.010499004013297458)
  <0.7221819359036039, 3.9555981609859354, 0.25057622856318307>, BranchRadius(0.005518928746451321)
  <0.7193926588844449, 3.959106581095697, 0.2537201039844274>, BranchRadius(0.0054747630652379805)
  <0.715860401920164, 3.9602983987192264, 0.25413411224737065>, BranchRadius(0.0037508227565764287)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <0.7241664512432687, 3.9424864320871733, 0.24339686716292935>, BranchRadius(0.01927718817212323)
  <0.7253344359955649, 3.951485533653198, 0.2486771197983639>, BranchRadius(0.010499004013297458)
  <0.7294169859746866, 3.956902104255066, 0.25232653035095276>, BranchRadius(0.007702249593358632)
  <0.7333269700385353, 3.962510693976728, 0.2557392915576796>, BranchRadius(0.00764141303029914)
  <0.7374747798227149, 3.967807093813006, 0.2592313504318973>, BranchRadius(0.00757962086205244)
  <0.7433127005110763, 3.971394884369259, 0.26234523226601436>, BranchRadius(0.0075266074107781375)
  <0.7484776675444306, 3.9737869021425016, 0.2671621637856609>, BranchRadius(0.007456638837177838)
  <0.7550429603093659, 3.975089266251479, 0.2703003584100354>, BranchRadius(0.00739239385193451)
  <0.7596333798190857, 3.9734047240495416, 0.27189674604933345>, BranchRadius(0.005143742528570813)
  <0.7628444547572989, 3.969689687283204, 0.2733134851263972>, BranchRadius(0.005110738698714698)
  <0.7646020014970035, 3.965158119301444, 0.27475386995039924>, BranchRadius(0.005069397139381951)
  <0.7649421522177776, 3.963829005101036, 0.2771609266525594>, BranchRadius(0.002770590016221055)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.7831453439676873, 3.8740474159737506, 0.2503848309939032>, BranchRadius(0.03402711207847441)
  <0.7612620985396904, 3.8983595853043385, 0.24164796108710815>, BranchRadius(0.03385691810825946)
  <0.7538389228783924, 3.9056605215068045, 0.22536744805360054>, BranchRadius(0.019325172986681936)
  <0.7540175309062713, 3.909391094192405, 0.2065153739280051>, BranchRadius(0.019218474763287415)
  <0.7550379724377267, 3.9127094797238544, 0.19487750793804956>, BranchRadius(0.012144665835444634)
  <0.7532747654345885, 3.912106100091797, 0.1829563661912064>, BranchRadius(0.012065926672436895)
  <0.7560037867835994, 3.9111035035713178, 0.17136120548424133>, BranchRadius(0.011954100096894842)
  <0.7565449793453992, 3.9142825406068456, 0.16396143157552304>, BranchRadius(0.008071915495243604)
  <0.7575742746599301, 3.919118128863128, 0.1576348698950561>, BranchRadius(0.008029180862675967)
  <0.7571673815344568, 3.920647296005399, 0.1539043086806538>, BranchRadius(0.004052283447509806)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.7532747654345885, 3.912106100091797, 0.1829563661912064>, BranchRadius(0.012065926672436895)
  <0.7560037867835994, 3.9111035035713178, 0.17136120548424133>, BranchRadius(0.011954100096894842)
  <0.7575430809200651, 3.9104109462399133, 0.16501283054380378>, BranchRadius(0.006568936480147705)
  <0.7543780280943139, 3.9101855145704603, 0.16090449341633015>, BranchRadius(0.0051910319571706045)
  <0.7525127896374394, 3.910404275214604, 0.15610600531492483>, BranchRadius(0.005152907798491834)
  <0.7497415928294093, 3.9109058520762536, 0.1518423618365124>, BranchRadius(0.005109771698225555)
  <0.7467983344014922, 3.9111330742019925, 0.14772263666540814>, BranchRadius(0.005068188586996399)
  <0.7449131596027198, 3.9108947940359364, 0.14542843379386342>, BranchRadius(0.0029789307268324643)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <0.7538389228783924, 3.9056605215068045, 0.22536744805360054>, BranchRadius(0.019325172986681936)
  <0.7540175309062713, 3.909391094192405, 0.2065153739280051>, BranchRadius(0.019218474763287415)
  <0.7472490222198153, 3.904196088661283, 0.193937736128408>, BranchRadius(0.015198610624819314)
  <0.7384757511758098, 3.896979145246922, 0.1839922654028602>, BranchRadius(0.015098574270784688)
  <0.7340471464698972, 3.888727502646205, 0.1723044212302232>, BranchRadius(0.01497691045092554)
  <0.7320226807369575, 3.882325201010304, 0.15906249831570107>, BranchRadius(0.014847102418150397)
  <0.7328247672015886, 3.880826542340562, 0.14791276575597465>, BranchRadius(0.01127855738375085)
  <0.7331052162927856, 3.8805718918134233, 0.1367077620083778>, BranchRadius(0.011211405244989777)
  <0.7321006722053695, 3.876861745648913, 0.12629240233844197>, BranchRadius(0.011101982275238838)
  <0.7310577582528373, 3.8757858164023045, 0.11538075305782608>, BranchRadius(0.011014053898508904)
  <0.7310463891823711, 3.878288430324111, 0.10476675630258034>, BranchRadius(0.01090505079390964)
  <0.7309319225620445, 3.880949814887368, 0.09427262821627105>, BranchRadius(0.010826947616598881)
  <0.7275472001034484, 3.886312740461231, 0.0893614789861362>, BranchRadius(0.008021016369087924)
  <0.7271851483434761, 3.8861938489813452, 0.08508095661676487>, BranchRadius(0.004297451386063228)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.7310463891823711, 3.878288430324111, 0.10476675630258034>, BranchRadius(0.01090505079390964)
  <0.7309319225620445, 3.880949814887368, 0.09427262821627105>, BranchRadius(0.010826947616598881)
  <0.7308710682689916, 3.8827417275742517, 0.08712344968920907>, BranchRadius(0.00737057717782008)
  <0.7331607898519701, 3.8830514031598455, 0.08019151315608268>, BranchRadius(0.00730687812921239)
  <0.7327458097893959, 3.882905406551062, 0.07672373072790127>, BranchRadius(0.003495574120414849)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.7340471464698972, 3.888727502646205, 0.1723044212302232>, BranchRadius(0.01497691045092554)
  <0.7320226807369575, 3.882325201010304, 0.15906249831570107>, BranchRadius(0.014847102418150397)
  <0.7299495377704895, 3.8781306107091744, 0.15509815649983055>, BranchRadius(0.006132578216933497)
  <0.728018827744891, 3.873621454524166, 0.1514770250157757>, BranchRadius(0.0060969438187144735)
  <0.7260755520614313, 3.8683443407253253, 0.14924362667026833>, BranchRadius(0.006050811399932501)
  <0.7223595516798734, 3.8663670061808006, 0.14724263792131756>, BranchRadius(0.004660736713239297)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <0.9602025003769195, 3.4783547076866124, 0.2656819459318523>, BranchRadius(0.3165659427655448)
  <0.9119701779984378, 3.651453425052639, 0.28519841761684056>, BranchRadius(0.18074959347897926)
  <0.9111951044927882, 3.7298301460016057, 0.3201524769548745>, BranchRadius(0.08582131081414564)
  <0.9188115368066295, 3.765639395201884, 0.34826255887098023>, BranchRadius(0.046157221263948625)
  <0.9173670838407965, 3.7800828066485566, 0.35986040513492573>, BranchRadius(0.01857979054108238)
  <0.9124869075655156, 3.796202055213981, 0.3673815429371871>, BranchRadius(0.018444885703965613)
  <0.912068813063212, 3.810190091635319, 0.3792051322901858>, BranchRadius(0.018320404775164684)
  <0.91350411717602, 3.8253195506505016, 0.38922086635970055>, BranchRadius(0.018200976812786155)
  <0.9096805444567181, 3.8426914839947144, 0.3924970848677577>, BranchRadius(0.018086939602046995)
  <0.9010266808571779, 3.850465587602266, 0.3994754464489684>, BranchRadius(0.013565528830772205)
  <0.8929509832512729, 3.858516679174165, 0.40665547566843474>, BranchRadius(0.013475525478196023)
  <0.8885929513261739, 3.8628490142035212, 0.406219712121162>, BranchRadius(0.0061604755446230805)
  <0.8858972959753721, 3.8652468160398974, 0.40590096158238015>, BranchRadius(0.0036218245847651114)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.9010266808571779, 3.850465587602266, 0.3994754464489684>, BranchRadius(0.013565528830772205)
  <0.8929509832512729, 3.858516679174165, 0.40665547566843474>, BranchRadius(0.013475525478196023)
  <0.8895428797947584, 3.8619305869510723, 0.41530470903176303>, BranchRadius(0.009903492982420017)
  <0.8892848643488734, 3.8629564308629036, 0.4250753603260279>, BranchRadius(0.0098277441163207)
  <0.8868459118748588, 3.8645023749335796, 0.4343813137317786>, BranchRadius(0.00974367492428617)
  <0.8866625599214742, 3.863258463240921, 0.44041430808943965>, BranchRadius(0.006162625670727847)
  <0.8874629651543232, 3.8610646052022757, 0.44605174070617826>, BranchRadius(0.006101992145092344)
  <0.8875482053719145, 3.860368066670704, 0.45207410456738584>, BranchRadius(0.0060631096227462605)
  <0.8896565306952869, 3.8611248337689306, 0.4576683501823049>, BranchRadius(0.006026053112126809)
  <0.8908671038480519, 3.8593408645549103, 0.4591804570924927>, BranchRadius(0.002633344038025745)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.8892848643488734, 3.8629564308629036, 0.4250753603260279>, BranchRadius(0.0098277441163207)
  <0.8868459118748588, 3.8645023749335796, 0.4343813137317786>, BranchRadius(0.00974367492428617)
  <0.8842845593981249, 3.8675209768370706, 0.43868386364440565>, BranchRadius(0.00584674436866168)
  <0.8815554834705892, 3.8704483489359593, 0.44289255195624916>, BranchRadius(0.005807789607919408)
  <0.8799520976081345, 3.8707764387653794, 0.4461515780734371>, BranchRadius(0.0036468809128625797)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.91350411717602, 3.8253195506505016, 0.38922086635970055>, BranchRadius(0.018200976812786155)
  <0.9096805444567181, 3.8426914839947144, 0.3924970848677577>, BranchRadius(0.018086939602046995)
  <0.9148148156279755, 3.853152094441757, 0.3885655405105867>, BranchRadius(0.012298054822499073)
  <0.9163433277484565, 3.8637254934777916, 0.3826327509214634>, BranchRadius(0.012220110833641246)
  <0.9131695610963485, 3.8730134924869466, 0.37551687040847065>, BranchRadius(0.012123344251124935)
  <0.910741435055516, 3.880457815872254, 0.36638164858294336>, BranchRadius(0.012031875354108046)
  <0.9068497512077144, 3.885076146310845, 0.3658570974368156>, BranchRadius(0.006062122822589289)
  <0.9044215725796145, 3.886160286566267, 0.36465313106938707>, BranchRadius(0.00291906604195364)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.9131695610963485, 3.8730134924869466, 0.37551687040847065>, BranchRadius(0.012123344251124935)
  <0.910741435055516, 3.880457815872254, 0.36638164858294336>, BranchRadius(0.012031875354108046)
  <0.914190120726305, 3.880527921907567, 0.3588108908020017>, BranchRadius(0.008319538514231522)
  <0.9187955532451006, 3.880101314143111, 0.35198155206245346>, BranchRadius(0.008248143457128336)
  <0.9232528279052787, 3.8787563789652553, 0.3514980143321825>, BranchRadius(0.00468080727711529)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.914190120726305, 3.880527921907567, 0.3588108908020017>, BranchRadius(0.008319538514231522)
  <0.9187955532451006, 3.880101314143111, 0.35198155206245346>, BranchRadius(0.008248143457128336)
  <0.9200848211583923, 3.8805281686831288, 0.34647916704358395>, BranchRadius(0.005667508927779193)
  <0.9229299652220938, 3.8812057484024765, 0.34168982039343115>, BranchRadius(0.005611755550147999)
  <0.9270296836799803, 3.8825358192001542, 0.33814287550912453>, BranchRadius(0.005581899118855389)
  <0.9317975766396488, 3.8838283986453725, 0.3356386205636972>, BranchRadius(0.005538488758565317)
  <0.9349506802778139, 3.885751754243206, 0.33154936765762905>, BranchRadius(0.0055102947868979)
  <0.9376919776585266, 3.888445275350642, 0.33037831923581806>, BranchRadius(0.004017601484957517)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.9111951044927882, 3.7298301460016057, 0.3201524769548745>, BranchRadius(0.08582131081414564)
  <0.9188115368066295, 3.765639395201884, 0.34826255887098023>, BranchRadius(0.046157221263948625)
  <0.9375352837495, 3.775535523287293, 0.3550748599886827>, BranchRadius(0.022246786221423828)
  <0.9469801098833651, 3.7805208466217115, 0.3536249347199392>, BranchRadius(0.010777776799163048)
  <0.9516551947685804, 3.779259316645459, 0.35351174027642546>, BranchRadius(0.004843623596750076)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.9188115368066295, 3.765639395201884, 0.34826255887098023>, BranchRadius(0.046157221263948625)
  <0.9375352837495, 3.775535523287293, 0.3550748599886827>, BranchRadius(0.022246786221423828)
  <0.941476259838819, 3.7776272642635598, 0.3630417857447634>, BranchRadius(0.009131187154542305)
  <0.9456605890093857, 3.780284310230504, 0.370623387472371>, BranchRadius(0.009058100718923967)
  <0.9469036390696506, 3.7824345851679655, 0.37927079471033365>, BranchRadius(0.008997027714649365)
  <0.9477516365092774, 3.7840492164248594, 0.38260965062012003>, BranchRadius(0.0038044832158478955)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.9456605890093857, 3.780284310230504, 0.370623387472371>, BranchRadius(0.009058100718923967)
  <0.9469036390696506, 3.7824345851679655, 0.37927079471033365>, BranchRadius(0.008997027714649365)
  <0.9455278337680583, 3.7791531022278013, 0.3853246145031615>, BranchRadius(0.007022086911916729)
  <0.9452817594496107, 3.7761581538287636, 0.39160030891613407>, BranchRadius(0.006958060710292264)
  <0.9442420961441934, 3.773805266263741, 0.39800910611550927>, BranchRadius(0.006905770139889358)
  <0.9462704801875816, 3.7724809761123588, 0.40441403063562886>, BranchRadius(0.0068477108832769576)
  <0.9488144929600736, 3.7727110393751735, 0.40621170713024357>, BranchRadius(0.0031235510033916832)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  21
  <0.9119701779984378, 3.651453425052639, 0.28519841761684056>, BranchRadius(0.18074959347897926)
  <0.9111951044927882, 3.7298301460016057, 0.3201524769548745>, BranchRadius(0.08582131081414564)
  <0.8910107925706964, 3.7810744257109103, 0.31303501093814856>, BranchRadius(0.05553414240980955)
  <0.8573462112815271, 3.8226289113690957, 0.32648085339616617>, BranchRadius(0.05514408391747242)
  <0.8388069774737192, 3.873806044532575, 0.3205528837995615>, BranchRadius(0.05475347452492268)
  <0.8184616937141531, 3.9239223850593334, 0.3159431378617701>, BranchRadius(0.05428469320777516)
  <0.807774872571103, 3.9516725931465797, 0.3081743789221189>, BranchRadius(0.03073492818425665)
  <0.8015997649249699, 3.967074221022313, 0.30937950314576823>, BranchRadius(0.016637139779971884)
  <0.7971165800552019, 3.9826960326916567, 0.3067053966072692>, BranchRadius(0.0164709074488385)
  <0.7977588371979092, 3.9989269790295516, 0.3049310314203947>, BranchRadius(0.016340271878930578)
  <0.8015691751359939, 4.013972063110627, 0.3001940401688681>, BranchRadius(0.016226901008081475)
  <0.8070430480899474, 4.028082404543171, 0.2946464080600752>, BranchRadius(0.016119591882969648)
  <0.8117034845442778, 4.036623822363758, 0.29045852900956604>, BranchRadius(0.010593102344090865)
  <0.8189273151607666, 4.041416903084251, 0.284478192240272>, BranchRadius(0.010531940915284699)
  <0.8271703610605226, 4.042749802982935, 0.27821021854283823>, BranchRadius(0.01044087745915632)
  <0.8300293815823848, 4.0465926351338855, 0.27554286834115127>, BranchRadius(0.00548234570081536)
  <0.8325870731519412, 4.050422159058406, 0.2726514712140043>, BranchRadius(0.0054375745512432625)
  <0.8335837904703334, 4.054044809570792, 0.26879434181386636>, BranchRadius(0.00538465313247603)
  <0.8324336405839674, 4.057008326666316, 0.26451368256245467>, BranchRadius(0.0053319154122385744)
  <0.8327049154837567, 4.061159151620721, 0.26125596861186046>, BranchRadius(0.005283525154408715)
  <0.8331828494433849, 4.063234858729248, 0.2616717317032453>, BranchRadius(0.002170216537194458)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.8189273151607666, 4.041416903084251, 0.284478192240272>, BranchRadius(0.010531940915284699)
  <0.8271703610605226, 4.042749802982935, 0.27821021854283823>, BranchRadius(0.01044087745915632)
  <0.8313373966092801, 4.038082197208406, 0.27582116597081985>, BranchRadius(0.006697633994396159)
  <0.8318809447077994, 4.035180805181445, 0.27391566821455354>, BranchRadius(0.003513465800126073)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <0.8015691751359939, 4.013972063110627, 0.3001940401688681>, BranchRadius(0.016226901008081475)
  <0.8070430480899474, 4.028082404543171, 0.2946464080600752>, BranchRadius(0.016119591882969648)
  <0.8027633350112354, 4.037126921031984, 0.29588820178864494>, BranchRadius(0.010082721567951165)
  <0.7983306541126423, 4.045864779851579, 0.2979114423878087>, BranchRadius(0.010004615895776978)
  <0.7936293461151329, 4.053655425826986, 0.3019473047962292>, BranchRadius(0.009954127133067902)
  <0.7926420137629401, 4.059778053819122, 0.3038770580502509>, BranchRadius(0.0064950247363028055)
  <0.7938414071967846, 4.066108929550052, 0.3039025063204633>, BranchRadius(0.0064435378282496555)
  <0.7924110757985526, 4.072316197735936, 0.30431143623599377>, BranchRadius(0.006383043938128264)
  <0.7895428014755533, 4.077888138159567, 0.30523014705457713>, BranchRadius(0.0063338414287584174)
  <0.7869561779474095, 4.083570864041544, 0.3058641382195406>, BranchRadius(0.006275821820549761)
  <0.7845149932298388, 4.088949670125681, 0.30784348026957803>, BranchRadius(0.006229665534127199)
  <0.7824558742925163, 4.093692822285568, 0.31124708738859674>, BranchRadius(0.006190476930780479)
  <0.7809985280543478, 4.099053355405421, 0.3138572059177302>, BranchRadius(0.006137743243494981)
  <0.7799293479640935, 4.104934747894195, 0.314965078183455>, BranchRadius(0.006079580958385388)
  <0.7797128802742934, 4.107034150649856, 0.31618841573019346>, BranchRadius(0.002439447672008233)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <0.8184616937141531, 3.9239223850593334, 0.3159431378617701>, BranchRadius(0.05428469320777516)
  <0.807774872571103, 3.9516725931465797, 0.3081743789221189>, BranchRadius(0.03073492818425665)
  <0.8039623126279235, 3.9635167178735746, 0.287917870453918>, BranchRadius(0.023772779374554433)
  <0.7987959971001286, 3.9775377380821557, 0.26963198592188126>, BranchRadius(0.02361468604367103)
  <0.7983531089765782, 3.992790603378112, 0.25187352479881725>, BranchRadius(0.02341386322429411)
  <0.8002326697146823, 4.003836832736297, 0.23150440319073823>, BranchRadius(0.02324764604613895)
  <0.7940738262904508, 3.999698417371622, 0.21639370204599012>, BranchRadius(0.016834224756152923)
  <0.7931384850024492, 4.0017348600132685, 0.1998040937440894>, BranchRadius(0.01674028272067855)
  <0.7947875135008566, 4.005283990190155, 0.18832006991061115>, BranchRadius(0.012132535736973777)
  <0.8000831949540312, 4.011242695004205, 0.17927290453763448>, BranchRadius(0.012058258846137815)
  <0.807170700807008, 4.015472389071187, 0.17064079588834782>, BranchRadius(0.011943046129415047)
  <0.8125930963343689, 4.01888542807303, 0.16691234416611822>, BranchRadius(0.007412999442077739)
  <0.8173883152013137, 4.022242299287903, 0.16247222520456317>, BranchRadius(0.007346928931731146)
  <0.8208692405778734, 4.024975659091598, 0.15879581928069486>, BranchRadius(0.005753612587816718)
  <0.8237127772484828, 4.025126726773865, 0.15863549901098>, BranchRadius(0.0028520562460455593)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.8000831949540312, 4.011242695004205, 0.17927290453763448>, BranchRadius(0.012058258846137815)
  <0.807170700807008, 4.015472389071187, 0.17064079588834782>, BranchRadius(0.011943046129415047)
  <0.8073252238131091, 4.015235978137266, 0.16511506890151895>, BranchRadius(0.005532940106495004)
  <0.8081175661176473, 4.015988675746949, 0.15973271178194734>, BranchRadius(0.005492187923021822)
  <0.8097642571840797, 4.016247548724446, 0.15664916423026026>, BranchRadius(0.0035052634979787396)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.7940738262904508, 3.999698417371622, 0.21639370204599012>, BranchRadius(0.016834224756152923)
  <0.7931384850024492, 4.0017348600132685, 0.1998040937440894>, BranchRadius(0.01674028272067855)
  <0.7872298836347328, 3.997447981514883, 0.19285773764297875>, BranchRadius(0.010076743544714162)
  <0.7785748891289094, 3.9952476005617243, 0.1883417271268222>, BranchRadius(0.010007245236172293)
  <0.7700736499419947, 3.9933375627803853, 0.18352649327977336>, BranchRadius(0.009955189050994526)
  <0.7646311909753051, 3.992973448345703, 0.17530213990447746>, BranchRadius(0.009868785506200108)
  <0.7616355548022103, 3.992547394517966, 0.17258782488075433>, BranchRadius(0.004064832591102899)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.7700736499419947, 3.9933375627803853, 0.18352649327977336>, BranchRadius(0.009955189050994526)
  <0.7646311909753051, 3.992973448345703, 0.17530213990447746>, BranchRadius(0.009868785506200108)
  <0.766108726409569, 3.99417493883209, 0.1686775087627691>, BranchRadius(0.00689292594709075)
  <0.767711364235708, 3.9957212271209643, 0.16221843040922987>, BranchRadius(0.00683221403728255)
  <0.7664333033243527, 3.997461168534978, 0.15579674185974274>, BranchRadius(0.006774874142295752)
  <0.7673122781857604, 3.9969981992466748, 0.1491449089586504>, BranchRadius(0.006725609140661766)
  <0.7693676704082693, 3.99635727895615, 0.14283077529858632>, BranchRadius(0.006671109344352729)
  <0.7724978363739303, 3.995739924340415, 0.1403568604633107>, BranchRadius(0.00403724167054051)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.7983531089765782, 3.992790603378112, 0.25187352479881725>, BranchRadius(0.02341386322429411)
  <0.8002326697146823, 4.003836832736297, 0.23150440319073823>, BranchRadius(0.02324764604613895)
  <0.8079091346530377, 4.018162741163681, 0.22692966834504597>, BranchRadius(0.016884548117375164)
  <0.8155253441121535, 4.032360818983798, 0.22236634082055998>, BranchRadius(0.01674562684425277)
  <0.8279459054953588, 4.041138210192277, 0.21570136215085567>, BranchRadius(0.016605266699703424)
  <0.8330980823331263, 4.047524430917036, 0.2078186269568883>, BranchRadius(0.011378323929788093)
  <0.8414071470544483, 4.05152487255309, 0.2013249994155406>, BranchRadius(0.011278798183864099)
  <0.8459142062470184, 4.055166032607024, 0.19763803321824822>, BranchRadius(0.006867703316515061)
  <0.848677315567597, 4.057466212808344, 0.19182921178354495>, BranchRadius(0.006831398724732895)
  <0.8475519042499318, 4.061724343047411, 0.18957915840102932>, BranchRadius(0.004945802663972419)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <0.8330980823331263, 4.047524430917036, 0.2078186269568883>, BranchRadius(0.011378323929788093)
  <0.8414071470544483, 4.05152487255309, 0.2013249994155406>, BranchRadius(0.011278798183864099)
  <0.8469549509249633, 4.052197783759027, 0.1972129436076696>, BranchRadius(0.006938295197224074)
  <0.8529010880447776, 4.049985339852233, 0.1945431493790778>, BranchRadius(0.006883259105348742)
  <0.858479268161392, 4.048478420048175, 0.19091220642416087>, BranchRadius(0.0068242690048910025)
  <0.8641963010833219, 4.046458441894267, 0.18791941544391177>, BranchRadius(0.006761773068075717)
  <0.8690946033285059, 4.04497983458605, 0.18655293995285963>, BranchRadius(0.0052959323753928485)
  <0.872883140774473, 4.041355244105394, 0.18607941530236344>, BranchRadius(0.005264494061786107)
  <0.8770370950846067, 4.038234435202738, 0.18653075029651228>, BranchRadius(0.005215216955651656)
  <0.8807185059991989, 4.03461163885652, 0.1866332595229156>, BranchRadius(0.005166037923762354)
  <0.8843480600413579, 4.031119780270213, 0.18562997121932198>, BranchRadius(0.005135496699623122)
  <0.888272725001762, 4.027885220048997, 0.18605720744721463>, BranchRadius(0.005103714889227312)
  <0.8930451790925114, 4.0261856916709196, 0.1860553047965842>, BranchRadius(0.005066035765396934)
  <0.8978581195068746, 4.025374606079339, 0.18485136973346916>, BranchRadius(0.005027098060042047)
  <0.9027694238223121, 4.024541965328963, 0.18484673130663515>, BranchRadius(0.004981387579081329)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.8155253441121535, 4.032360818983798, 0.22236634082055998>, BranchRadius(0.01674562684425277)
  <0.8279459054953588, 4.041138210192277, 0.21570136215085567>, BranchRadius(0.016605266699703424)
  <0.8377673446164852, 4.044617021469084, 0.2168850142280928>, BranchRadius(0.010486363838317818)
  <0.8412879434820937, 4.0460072674001175, 0.21483746269981915>, BranchRadius(0.0043034715500644425)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.8279459054953588, 4.041138210192277, 0.21570136215085567>, BranchRadius(0.016605266699703424)
  <0.8377673446164852, 4.044617021469084, 0.2168850142280928>, BranchRadius(0.010486363838317818)
  <0.8431337482503957, 4.046512563175375, 0.21762270577729903>, BranchRadius(0.005738950700616512)
  <0.8474100820273412, 4.049907350722829, 0.21921910555960927>, BranchRadius(0.005688594319263363)
  <0.8518667992393686, 4.052810869321166, 0.22115346371758532>, BranchRadius(0.005659901946341438)
  <0.8546311892160063, 4.055044180409664, 0.22289904420823717>, BranchRadius(0.003959366314233121)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  19
  <0.8388069774737192, 3.873806044532575, 0.3205528837995615>, BranchRadius(0.05475347452492268)
  <0.8184616937141531, 3.9239223850593334, 0.3159431378617701>, BranchRadius(0.05428469320777516)
  <0.8078522432552134, 3.9477894344146613, 0.32204395542058184>, BranchRadius(0.026821939878693548)
  <0.7978708159240496, 3.971884692493394, 0.3272380998946165>, BranchRadius(0.02659303461933561)
  <0.7841638303294602, 3.9938699293626962, 0.32221325072550777>, BranchRadius(0.026390930325812606)
  <0.7691678792229133, 4.010087177329185, 0.30819385170271113>, BranchRadius(0.026161445490586126)
  <0.7593482407082816, 4.025979637346542, 0.2901603940209313>, BranchRadius(0.025965384301448038)
  <0.744112162172518, 4.037920195312804, 0.2732331770766107>, BranchRadius(0.025714697882217287)
  <0.727535700751377, 4.051373465674201, 0.25935941393816053>, BranchRadius(0.025460771007281915)
  <0.7200374603242902, 4.0655340389087975, 0.24870661478583217>, BranchRadius(0.0192412986467805)
  <0.7130037452656532, 4.068797336161189, 0.2417627620216037>, BranchRadius(0.010408618913902233)
  <0.7060539698514116, 4.071317352566105, 0.23454942786069838>, BranchRadius(0.01032870033965201)
  <0.7016928378083618, 4.071792014217477, 0.22525778657262238>, BranchRadius(0.010275182441517929)
  <0.6989495295908534, 4.069118746832164, 0.21579332981891006>, BranchRadius(0.010210192952756535)
  <0.7013956173274145, 4.067685753971968, 0.21109039621852718>, BranchRadius(0.005491302049781637)
  <0.7045093797948554, 4.0647533278660655, 0.20773128770313065>, BranchRadius(0.005438588933577955)
  <0.7084899481672501, 4.061826545964519, 0.20557268152980668>, BranchRadius(0.00539171192461557)
  <0.7121449884642141, 4.058492406722079, 0.2035158709248188>, BranchRadius(0.005357823618335631)
  <0.7122231450348808, 4.055893950906609, 0.20291323966440408>, BranchRadius(0.002668566190020752)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.7016928378083618, 4.071792014217477, 0.22525778657262238>, BranchRadius(0.010275182441517929)
  <0.6989495295908534, 4.069118746832164, 0.21579332981891006>, BranchRadius(0.010210192952756535)
  <0.6962838296473368, 4.06771229577414, 0.21069830152200283>, BranchRadius(0.005919744429767718)
  <0.6952124726748518, 4.066253649202707, 0.20872752698661406>, BranchRadius(0.0026757069817492127)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <0.727535700751377, 4.051373465674201, 0.25935941393816053>, BranchRadius(0.025460771007281915)
  <0.7200374603242902, 4.0655340389087975, 0.24870661478583217>, BranchRadius(0.0192412986467805)
  <0.7207976719742611, 4.073945241504386, 0.24679034317116053>, BranchRadius(0.008660158645082077)
  <0.721324959649285, 4.0822921184007495, 0.24487248496587402>, BranchRadius(0.008580592421905493)
  <0.7255320273893213, 4.089667278039729, 0.24422372178275592>, BranchRadius(0.008515473700121899)
  <0.7275723849643343, 4.097858494906357, 0.24439810126321992>, BranchRadius(0.008443311020757268)
  <0.7294257667966662, 4.106026329174753, 0.24445300109744525>, BranchRadius(0.008375652502593624)
  <0.7309147203979589, 4.114200344401746, 0.24422594502817563>, BranchRadius(0.00831162211704169)
  <0.73064508922906, 4.122353079881791, 0.24288333210915516>, BranchRadius(0.008266946608340993)
  <0.7308321925845316, 4.1302525978158116, 0.24066653319423895>, BranchRadius(0.008206801367445338)
  <0.7276079223353806, 4.137718060307727, 0.2402553215903146>, BranchRadius(0.008142367213591357)
  <0.7213371837229672, 4.142791329719068, 0.2402831098932212>, BranchRadius(0.008066039762797765)
  <0.7139903775928078, 4.145193062521487, 0.24233926954939117>, BranchRadius(0.007998229385309067)
  <0.7114631252334327, 4.148949000419887, 0.24276164460691266>, BranchRadius(0.004546699316408007)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.7213371837229672, 4.142791329719068, 0.2402831098932212>, BranchRadius(0.008066039762797765)
  <0.7139903775928078, 4.145193062521487, 0.24233926954939117>, BranchRadius(0.007998229385309067)
  <0.7091064450498464, 4.144311108893633, 0.24394719045119095>, BranchRadius(0.005216900316502797)
  <0.7067537924225953, 4.145802819210194, 0.24460866670615672>, BranchRadius(0.002863166933472163)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.744112162172518, 4.037920195312804, 0.2732331770766107>, BranchRadius(0.025714697882217287)
  <0.727535700751377, 4.051373465674201, 0.25935941393816053>, BranchRadius(0.025460771007281915)
  <0.7166478769417255, 4.053605844574692, 0.2538265208888287>, BranchRadius(0.012415358567545016)
  <0.706452814830354, 4.055000984716066, 0.24710149975250145>, BranchRadius(0.0122927465097447)
  <0.7041132498655974, 4.055640493645197, 0.24204724565294966>, BranchRadius(0.005606069960104959)
  <0.7014542505284285, 4.055889936785145, 0.23717051464994404>, BranchRadius(0.0055601263142853255)
  <0.6999641668655984, 4.05696934716436, 0.2354599672687453>, BranchRadius(0.002512259626773422)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.7166478769417255, 4.053605844574692, 0.2538265208888287>, BranchRadius(0.012415358567545016)
  <0.706452814830354, 4.055000984716066, 0.24710149975250145>, BranchRadius(0.0122927465097447)
  <0.6974741103992553, 4.056011721970929, 0.2435750093904797>, BranchRadius(0.00969921941873844)
  <0.6924552229115881, 4.055650469157026, 0.23948386646277384>, BranchRadius(0.006485151167423386)
  <0.6868229295218151, 4.053865715372329, 0.23692349804019017>, BranchRadius(0.006439220555302671)
  <0.6818207542456203, 4.05146200067312, 0.23376350262246096>, BranchRadius(0.006386327026471418)
  <0.6792267078399681, 4.050613947258387, 0.23075146508711974>, BranchRadius(0.004064559196668457)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  33
  <0.0, 0.0, 0.0>, BranchRadius(1.0)
  <0.03698388727786486, 0.9937133894049506, -0.001604299211729634>, BranchRadius(0.9944026759702618)
  <-0.028417943933630244, 1.4493819790534814, -5.140901784074167E-4>, BranchRadius(0.46033949610459707)
  <-0.13356186916662127, 1.8923576631223678, -0.023425641034545138>, BranchRadius(0.45585923359336694)
  <-0.21426274790908323, 2.108061895037176, 0.14031966706284293>, BranchRadius(0.2825835689131119)
  <-0.289813135462318, 2.227507993057049, 0.21659907063628564>, BranchRadius(0.16060441712835047)
  <-0.37875012255467205, 2.35279537121765, 0.2597843749816974>, BranchRadius(0.1595985128716079)
  <-0.4675865159731754, 2.4772120302762115, 0.3026031213811855>, BranchRadius(0.15876036939401839)
  <-0.4312846452876305, 2.561418366515724, 0.3817212105867911>, BranchRadius(0.12111236484231512)
  <-0.37441545973036133, 2.655118952068968, 0.431348134850108>, BranchRadius(0.12031930689130836)
  <-0.3396632017137683, 2.7610673175242106, 0.4738115151879147>, BranchRadius(0.11931435056020198)
  <-0.30193850219164625, 2.8655304236249797, 0.5154124384896331>, BranchRadius(0.11860156116093239)
  <-0.29661376560723757, 2.94563326747329, 0.5283955738495376>, BranchRadius(0.08132269188888026)
  <-0.3210741405145747, 3.0213834435968443, 0.5417672823125051>, BranchRadius(0.08071679943218504)
  <-0.34077280363841167, 3.098565920914213, 0.5518975785110432>, BranchRadius(0.08029816333380668)
  <-0.37993997617543407, 3.1614534181903076, 0.5809654691265332>, BranchRadius(0.07958546967273467)
  <-0.3883221662817893, 3.199882375372654, 0.5944590152733124>, BranchRadius(0.04158270853031264)
  <-0.3962155932223337, 3.238268137791932, 0.6075024296151732>, BranchRadius(0.04130258591260878)
  <-0.4016257744231014, 3.273154877881813, 0.6283885332757486>, BranchRadius(0.041019312778791915)
  <-0.40386609024178527, 3.288004958162918, 0.6540606880122702>, BranchRadius(0.029742283505787)
  <-0.41019252869999145, 3.293510574498543, 0.682426681670891>, BranchRadius(0.029579811206995408)
  <-0.4160774633165457, 3.298416070195033, 0.7108438416160467>, BranchRadius(0.029431808011366894)
  <-0.4264031135173243, 3.306698079255115, 0.7368580375343665>, BranchRadius(0.029188167387090937)
  <-0.43886302865650595, 3.313512051733261, 0.7621615811573365>, BranchRadius(0.029016357905293364)
  <-0.4491944911452264, 3.314111076759571, 0.7890081650284242>, BranchRadius(0.02877215691750158)
  <-0.45644124578356704, 3.3047056031870867, 0.814976301158726>, BranchRadius(0.028553852279384246)
  <-0.46847779716693216, 3.3004762887137242, 0.8402141174436268>, BranchRadius(0.028279198025216123)
  <-0.4807556624267878, 3.2955929969440616, 0.8649726382479258>, BranchRadius(0.028063799925593266)
  <-0.487998734382737, 3.299574232933748, 0.8784738268497607>, BranchRadius(0.015830174510312572)
  <-0.4947138667691519, 3.3086995544671534, 0.8893868051597035>, BranchRadius(0.01573078483891969)
  <-0.4947601865528307, 3.312311318131894, 0.8953810625344998>, BranchRadius(0.006998435808636172)
  <-0.4943889406627761, 3.31547044226827, 0.9015484413222679>, BranchRadius(0.006939340741866541)
  <-0.4952899239244515, 3.3178180648718922, 0.9043522043088189>, BranchRadius(0.0037661903313043568)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <-0.487998734382737, 3.299574232933748, 0.8784738268497607>, BranchRadius(0.015830174510312572)
  <-0.4947138667691519, 3.3086995544671534, 0.8893868051597035>, BranchRadius(0.01573078483891969)
  <-0.5008600754929173, 3.3125348378726867, 0.8918415603388348>, BranchRadius(0.007649255092250578)
  <-0.5073091368796884, 3.3152291679936234, 0.8947938460533942>, BranchRadius(0.007587212828919478)
  <-0.512938311914739, 3.31928394315858, 0.8977619328063958>, BranchRadius(0.007545750604607213)
  <-0.5158720534874792, 3.323473283319256, 0.9032573437819462>, BranchRadius(0.007507126773118687)
  <-0.5179574115972025, 3.3267801924894838, 0.9096097223278473>, BranchRadius(0.0074590267392166685)
  <-0.5227433181288786, 3.3283319138866343, 0.9150560882026065>, BranchRadius(0.007414556080174755)
  <-0.5272568251685205, 3.3308201068695436, 0.9203285017356327>, BranchRadius(0.007373004447328983)
  <-0.526511046088701, 3.3333551149840353, 0.9237931311110195>, BranchRadius(0.004357305277947288)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.46847779716693216, 3.3004762887137242, 0.8402141174436268>, BranchRadius(0.028279198025216123)
  <-0.4807556624267878, 3.2955929969440616, 0.8649726382479258>, BranchRadius(0.028063799925593266)
  <-0.4825001058347368, 3.2829716352068745, 0.870410324138258>, BranchRadius(0.013853168689739782)
  <-0.4854915339486286, 3.2702129259882065, 0.8746179053167945>, BranchRadius(0.013763612987187661)
  <-0.4853395788387439, 3.2613552623866204, 0.8694094956785334>, BranchRadius(0.010276615483427058)
  <-0.4812593728056552, 3.2530017184118045, 0.8652478287009633>, BranchRadius(0.010185737589582551)
  <-0.4770368519279624, 3.2446890556819152, 0.8613054215368248>, BranchRadius(0.010122875998020201)
  <-0.4726910964007447, 3.2425163651487887, 0.8620964196429249>, BranchRadius(0.0049225860336752775)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.4825001058347368, 3.2829716352068745, 0.870410324138258>, BranchRadius(0.013853168689739782)
  <-0.4854915339486286, 3.2702129259882065, 0.8746179053167945>, BranchRadius(0.013763612987187661)
  <-0.48763693207791486, 3.26351741148169, 0.8789253488255843>, BranchRadius(0.008245405825156954)
  <-0.49246962312243553, 3.2582081940087337, 0.8828454343629811>, BranchRadius(0.008179838844833063)
  <-0.49658265952902253, 3.257213501173207, 0.8851813811875137>, BranchRadius(0.004833542167603593)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.48763693207791486, 3.26351741148169, 0.8789253488255843>, BranchRadius(0.008245405825156954)
  <-0.49246962312243553, 3.2582081940087337, 0.8828454343629811>, BranchRadius(0.008179838844833063)
  <-0.4938003587104457, 3.2537078547792486, 0.8847874252641338>, BranchRadius(0.005078901362085846)
  <-0.49550370940449584, 3.252034129742419, 0.8862961890572202>, BranchRadius(0.0028247349024570338)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <-0.3962155932223337, 3.238268137791932, 0.6075024296151732>, BranchRadius(0.04130258591260878)
  <-0.4016257744231014, 3.273154877881813, 0.6283885332757486>, BranchRadius(0.041019312778791915)
  <-0.405372604179893, 3.296699322737142, 0.6168622677977436>, BranchRadius(0.026480831041367912)
  <-0.4021041903951829, 3.308828909541913, 0.6116235760828831>, BranchRadius(0.013610778655385682)
  <-0.3987606459954409, 3.3207783254321885, 0.6062895850141653>, BranchRadius(0.013506268544382524)
  <-0.3983837444645292, 3.324745185079664, 0.5972267451174694>, BranchRadius(0.009900156424012554)
  <-0.40176112778504747, 3.330574442144321, 0.5900652843347438>, BranchRadius(0.009832267112018714)
  <-0.40825016133291053, 3.3338905881066205, 0.5835647259057196>, BranchRadius(0.009765328479765769)
  <-0.41230063283297524, 3.3361918045450434, 0.5790446245538823>, BranchRadius(0.006491011685414333)
  <-0.4155818958861117, 3.3381107288548297, 0.573833870824567>, BranchRadius(0.00644987691030929)
  <-0.4201644615611814, 3.3406664548905383, 0.570168337322126>, BranchRadius(0.006400607751881245)
  <-0.4228852286653262, 3.3422976254515944, 0.5704388238771231>, BranchRadius(0.003183779830749279)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.40176112778504747, 3.330574442144321, 0.5900652843347438>, BranchRadius(0.009832267112018714)
  <-0.40825016133291053, 3.3338905881066205, 0.5835647259057196>, BranchRadius(0.009765328479765769)
  <-0.41573286492702227, 3.3347853142821045, 0.5819258731738525>, BranchRadius(0.007712147968184847)
  <-0.42338178366211615, 3.334794896735349, 0.5815002103416682>, BranchRadius(0.007660759654641511)
  <-0.42627695313496916, 3.337089366446054, 0.5782029026071392>, BranchRadius(0.004951649808505013)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-0.41573286492702227, 3.3347853142821045, 0.5819258731738525>, BranchRadius(0.007712147968184847)
  <-0.42338178366211615, 3.334794896735349, 0.5815002103416682>, BranchRadius(0.007660759654641511)
  <-0.4292720474145447, 3.3346995632463776, 0.5813130317390269>, BranchRadius(0.005894008090983587)
  <-0.43494484737446665, 3.3337737732483537, 0.58247187844834>, BranchRadius(0.005863503406788206)
  <-0.44052349663843476, 3.332133768447973, 0.5824208726142306>, BranchRadius(0.005814941525996337)
  <-0.4456935450500382, 3.330686149027615, 0.5802983102703894>, BranchRadius(0.005773237693704703)
  <-0.4507294910009604, 3.329093613614848, 0.5780779692124133>, BranchRadius(0.005729470750013563)
  <-0.4544976656273177, 3.3267567915991685, 0.57450456153327>, BranchRadius(0.0056946571089967835)
  <-0.45834984639460824, 3.3273611776579117, 0.5743863278447322>, BranchRadius(0.003901097073515539)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <-0.4021041903951829, 3.308828909541913, 0.6116235760828831>, BranchRadius(0.013610778655385682)
  <-0.3987606459954409, 3.3207783254321885, 0.6062895850141653>, BranchRadius(0.013506268544382524)
  <-0.39595815685499663, 3.3300919977988124, 0.6040863029143202>, BranchRadius(0.009972606998504384)
  <-0.39258357389580484, 3.339406239024902, 0.603527680365732>, BranchRadius(0.009922447224251021)
  <-0.39252141236089255, 3.3487056922960954, 0.6002336398091181>, BranchRadius(0.009865819701786172)
  <-0.3908870323510174, 3.3571315627750744, 0.5955014767801354>, BranchRadius(0.009801013125084513)
  <-0.38834424064997125, 3.3623720154154113, 0.5877224500625968>, BranchRadius(0.009718096016334823)
  <-0.38329109958263446, 3.3637785518843843, 0.5824003083212751>, BranchRadius(0.00747246761114934)
  <-0.37947091685366285, 3.3642409175574817, 0.576050799634714>, BranchRadius(0.007424542993282957)
  <-0.37568215393115806, 3.364703931745765, 0.5697665031122703>, BranchRadius(0.007352651861981219)
  <-0.37304536502311886, 3.3670915085427366, 0.5634112755376115>, BranchRadius(0.007283000496546695)
  <-0.37268618435125894, 3.371689573757705, 0.5578554776252654>, BranchRadius(0.007220672054522931)
  <-0.37326333134434614, 3.376649385368767, 0.5526976895945246>, BranchRadius(0.007178830492420929)
  <-0.3740493321526025, 3.3816401861321657, 0.5476730953191951>, BranchRadius(0.007125478030433738)
  <-0.3746702938883237, 3.380983799654218, 0.5434763665216767>, BranchRadius(0.004292897539609148)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.3908870323510174, 3.3571315627750744, 0.5955014767801354>, BranchRadius(0.009801013125084513)
  <-0.38834424064997125, 3.3623720154154113, 0.5877224500625968>, BranchRadius(0.009718096016334823)
  <-0.39162685009873843, 3.36711957786291, 0.5848088534416972>, BranchRadius(0.0064655950426356626)
  <-0.3950576307899026, 3.3717928913024067, 0.5820852567037265>, BranchRadius(0.006405317622548474)
  <-0.39810682566830036, 3.372562099086354, 0.5805687257239786>, BranchRadius(0.003491294349359257)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <-0.4016257744231014, 3.273154877881813, 0.6283885332757486>, BranchRadius(0.041019312778791915)
  <-0.405372604179893, 3.296699322737142, 0.6168622677977436>, BranchRadius(0.026480831041367912)
  <-0.41597841809528713, 3.3095408088758065, 0.6094237805497518>, BranchRadius(0.018240563247773272)
  <-0.4187846408591937, 3.320116319369874, 0.6074077852449343>, BranchRadius(0.011125670563154607)
  <-0.42075231967471394, 3.3232789256526094, 0.6037612684365734>, BranchRadius(0.005212573573034938)
  <-0.42200838961481824, 3.3268649361981097, 0.6002422017763854>, BranchRadius(0.005178900798984405)
  <-0.42201726018055713, 3.3301739742742673, 0.5963030275800009>, BranchRadius(0.005144599598205804)
  <-0.4234123562117806, 3.3341084721259215, 0.5933411418050968>, BranchRadius(0.005118528462809241)
  <-0.4245898836281201, 3.338122848193265, 0.590453294253101>, BranchRadius(0.0050834485843629625)
  <-0.4257029960958184, 3.3422669026915908, 0.5877910220790251>, BranchRadius(0.005049742585488583)
  <-0.42629658779328494, 3.346676876815824, 0.5854975307865832>, BranchRadius(0.005006028884076954)
  <-0.4273190596251812, 3.3499574410746353, 0.5819187290784215>, BranchRadius(0.004961388129299532)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.41597841809528713, 3.3095408088758065, 0.6094237805497518>, BranchRadius(0.018240563247773272)
  <-0.4187846408591937, 3.320116319369874, 0.6074077852449343>, BranchRadius(0.011125670563154607)
  <-0.41824232382092885, 3.324731499743159, 0.6112936918154735>, BranchRadius(0.006057579345159955)
  <-0.4182037198337981, 3.3272810653685165, 0.6167534010858781>, BranchRadius(0.006025794591849916)
  <-0.4190683372927694, 3.328544771881851, 0.622528594707243>, BranchRadius(0.0059747283508503335)
  <-0.4217170815839904, 3.328667540062838, 0.6257969995580028>, BranchRadius(0.004208727671756549)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.405372604179893, 3.296699322737142, 0.6168622677977436>, BranchRadius(0.026480831041367912)
  <-0.41597841809528713, 3.3095408088758065, 0.6094237805497518>, BranchRadius(0.018240563247773272)
  <-0.421424373847425, 3.3129637287695024, 0.6056253365421641>, BranchRadius(0.007470139994115395)
  <-0.42757057206268306, 3.3170403266359676, 0.6048106006855297>, BranchRadius(0.0074201211029332435)
  <-0.43391556350191557, 3.3202640626530746, 0.6029875520763602>, BranchRadius(0.007346760953190265)
  <-0.44092113983821074, 3.322311563391278, 0.6031252724215339>, BranchRadius(0.007299953833420899)
  <-0.44691003712984745, 3.3247593891603597, 0.5998490630062937>, BranchRadius(0.007252054184716317)
  <-0.44972433377478327, 3.32567611812349, 0.598352902929673>, BranchRadius(0.0033164970333792124)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  23
  <-0.34077280363841167, 3.098565920914213, 0.5518975785110432>, BranchRadius(0.08029816333380668)
  <-0.37993997617543407, 3.1614534181903076, 0.5809654691265332>, BranchRadius(0.07958546967273467)
  <-0.41815239574848906, 3.1901688591886583, 0.5998185380136607>, BranchRadius(0.05138291318930576)
  <-0.4450034612664715, 3.1977904164815767, 0.6176135961016316>, BranchRadius(0.03310184205409843)
  <-0.47211333933691707, 3.2007169576289365, 0.6360183702433836>, BranchRadius(0.03289750512258519)
  <-0.5011039912477085, 3.2031588533672135, 0.6508483625950415>, BranchRadius(0.032655006142389954)
  <-0.5241624669792059, 3.213959751238775, 0.6708776175143455>, BranchRadius(0.032396353969458)
  <-0.5500720614152574, 3.2275837599194426, 0.6841912962085982>, BranchRadius(0.03215858729399306)
  <-0.5753614616448262, 3.242463901429906, 0.6969110674856942>, BranchRadius(0.03198069662600188)
  <-0.5919646281423051, 3.266883110997851, 0.7083659171190848>, BranchRadius(0.03167296187270458)
  <-0.6000335754581051, 3.2782398693974324, 0.713536756756494>, BranchRadius(0.014860062405232943)
  <-0.6081110937088153, 3.2850704066404344, 0.7238358918499516>, BranchRadius(0.014763967075006828)
  <-0.6178626368295155, 3.291639385503521, 0.732569796108473>, BranchRadius(0.014646677443556102)
  <-0.6213734001823764, 3.2949872216587726, 0.7373748929379816>, BranchRadius(0.0068280613488130885)
  <-0.6247096888094658, 3.29852790694499, 0.7421040882376235>, BranchRadius(0.006784730081693547)
  <-0.6287527654693505, 3.3029690570042054, 0.7451120861205961>, BranchRadius(0.006717018236549715)
  <-0.6342856202663505, 3.3065682389296467, 0.7459234215698706>, BranchRadius(0.0066501772869869205)
  <-0.6405723188490717, 3.3083523242717274, 0.7449485372724747>, BranchRadius(0.006607264106354853)
  <-0.6461661258599731, 3.309538605295376, 0.7417332700190582>, BranchRadius(0.006560174010890993)
  <-0.6512500962141108, 3.3097989286063463, 0.7376899150903878>, BranchRadius(0.00650101852536872)
  <-0.6555058072529991, 3.3078240662641094, 0.7332581746647625>, BranchRadius(0.00645379585340471)
  <-0.6583460984763185, 3.305471343787797, 0.7280201712992971>, BranchRadius(0.006406187363825515)
  <-0.6589768158182553, 3.3040666837893187, 0.7254728006854165>, BranchRadius(0.0029765703622135087)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.6081110937088153, 3.2850704066404344, 0.7238358918499516>, BranchRadius(0.014763967075006828)
  <-0.6178626368295155, 3.291639385503521, 0.732569796108473>, BranchRadius(0.014646677443556102)
  <-0.6255609836535749, 3.293810508795674, 0.734370865871559>, BranchRadius(0.008198912883104571)
  <-0.6280889516150158, 3.2976990133512962, 0.7349974619124009>, BranchRadius(0.004680140199990006)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-0.5753614616448262, 3.242463901429906, 0.6969110674856942>, BranchRadius(0.03198069662600188)
  <-0.5919646281423051, 3.266883110997851, 0.7083659171190848>, BranchRadius(0.03167296187270458)
  <-0.5934011124683485, 3.278632097470785, 0.716830668242354>, BranchRadius(0.014551775903271863)
  <-0.5898444284544074, 3.291299616710868, 0.7227481528372127>, BranchRadius(0.014426803831870953)
  <-0.5876453229180723, 3.303711629445936, 0.7294720274264315>, BranchRadius(0.01428651863775663)
  <-0.5907602671758805, 3.308348703298298, 0.7308581696017041>, BranchRadius(0.00575558179262349)
  <-0.5933133735035024, 3.308874182228288, 0.7304843231250678>, BranchRadius(0.002633294745010576)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <-0.5898444284544074, 3.291299616710868, 0.7227481528372127>, BranchRadius(0.014426803831870953)
  <-0.5876453229180723, 3.303711629445936, 0.7294720274264315>, BranchRadius(0.01428651863775663)
  <-0.5814323578721878, 3.311034860993948, 0.7348450440642277>, BranchRadius(0.01100454282363468)
  <-0.5802613972260283, 3.316613387783535, 0.7333058426445328>, BranchRadius(0.005904257022469622)
  <-0.5794913660998582, 3.322235436778648, 0.7318686114800402>, BranchRadius(0.005853718156771226)
  <-0.581228034878799, 3.3274378599880885, 0.7299230821735959>, BranchRadius(0.005819476778895682)
  <-0.5824875968632806, 3.332982288816957, 0.7289422811291633>, BranchRadius(0.005769675737846816)
  <-0.582197599188566, 3.3386521707408687, 0.7297106822410974>, BranchRadius(0.005729057509858398)
  <-0.5808712551627023, 3.343747210802179, 0.731857016735019>, BranchRadius(0.005685540736033674)
  <-0.5792392597250201, 3.349028398379559, 0.733056642704116>, BranchRadius(0.005656275612257754)
  <-0.5775712202872666, 3.354051285296553, 0.7349128728134141>, BranchRadius(0.005608684227648836)
  <-0.5749175373473681, 3.355045021382524, 0.7362214458315688>, BranchRadius(0.003121202956859947)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-0.5876453229180723, 3.303711629445936, 0.7294720274264315>, BranchRadius(0.01428651863775663)
  <-0.5814323578721878, 3.311034860993948, 0.7348450440642277>, BranchRadius(0.01100454282363468)
  <-0.5783726686461144, 3.3140341448748947, 0.7378601446946638>, BranchRadius(0.005239106199564254)
  <-0.5758868810240397, 3.3168031700029825, 0.7415006114438795>, BranchRadius(0.005205731304455241)
  <-0.5736106423792395, 3.3196076759495523, 0.745204594959908>, BranchRadius(0.005173587716414861)
  <-0.5695764524834952, 3.322044150227055, 0.7472671633296358>, BranchRadius(0.005144441981367773)
  <-0.565805574352703, 3.325464567639404, 0.7476451260410528>, BranchRadius(0.005105059545510792)
  <-0.5615475789581423, 3.328225343088957, 0.7476473711137783>, BranchRadius(0.005074683330347374)
  <-0.5589741499627489, 3.3286038025315956, 0.7486330942681492>, BranchRadius(0.00278162155605631)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  23
  <-0.37993997617543407, 3.1614534181903076, 0.5809654691265332>, BranchRadius(0.07958546967273467)
  <-0.41815239574848906, 3.1901688591886583, 0.5998185380136607>, BranchRadius(0.05138291318930576)
  <-0.4343689741398421, 3.2277510427365668, 0.5986218962420853>, BranchRadius(0.040949113378448615)
  <-0.45151561085789405, 3.264446320755906, 0.5947117768211839>, BranchRadius(0.040692009209956095)
  <-0.4669777162330312, 3.3011704726935376, 0.5882500896861703>, BranchRadius(0.04036698451458719)
  <-0.47624988808849855, 3.3394410297158563, 0.580454859717601>, BranchRadius(0.04014192715825627)
  <-0.49183407873116847, 3.3716096684027925, 0.5629910812076296>, BranchRadius(0.03978280875960205)
  <-0.5195435922227382, 3.3949941518200566, 0.5476004087253588>, BranchRadius(0.039389389460720264)
  <-0.536828016168389, 3.397166325279615, 0.53863544462538>, BranchRadius(0.019591840903429875)
  <-0.5519565131951967, 3.400289983484481, 0.5268933229745937>, BranchRadius(0.01940376467938166)
  <-0.5698657925366126, 3.397995833477085, 0.5201950588621077>, BranchRadius(0.019258041253095343)
  <-0.5881555404628944, 3.396073442214712, 0.5151388256291695>, BranchRadius(0.019072911730473787)
  <-0.6024794564299585, 3.393812893738862, 0.5107462132090302>, BranchRadius(0.015151887404437101)
  <-0.6114511675442983, 3.3924955419946543, 0.5109135950659854>, BranchRadius(0.009069456026861503)
  <-0.6203260869957509, 3.393652029733312, 0.5101939557058967>, BranchRadius(0.008978838453164608)
  <-0.6289630908116652, 3.3943583221254188, 0.5122174690890406>, BranchRadius(0.008898948829554566)
  <-0.6370951416197188, 3.3977182594659863, 0.5127040147405607>, BranchRadius(0.008812273029605858)
  <-0.6451845602544718, 3.401062502184075, 0.5131874284013906>, BranchRadius(0.00876677489007518)
  <-0.6514919183663624, 3.407028380822991, 0.5131656980982277>, BranchRadius(0.00868187459549978)
  <-0.6573985336906198, 3.413315121033557, 0.513448461639033>, BranchRadius(0.008630826280484725)
  <-0.6636281076227725, 3.418891189833709, 0.5152952384493963>, BranchRadius(0.008562167904653655)
  <-0.6695780442066229, 3.4245890628968905, 0.5173676848614321>, BranchRadius(0.008494853555343412)
  <-0.673527357116256, 3.427293651376291, 0.5164440439270025>, BranchRadius(0.00487493424333645)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.6636281076227725, 3.418891189833709, 0.5152952384493963>, BranchRadius(0.008562167904653655)
  <-0.6695780442066229, 3.4245890628968905, 0.5173676848614321>, BranchRadius(0.008494853555343412)
  <-0.6717892969496949, 3.428543537892842, 0.5220579034689251>, BranchRadius(0.006521170276370928)
  <-0.673723576589039, 3.430240036175789, 0.5279982154140427>, BranchRadius(0.006473550042482858)
  <-0.6757994504281678, 3.428752714625319, 0.5338861250815454>, BranchRadius(0.006417854613743072)
  <-0.6764558042935853, 3.430094545871461, 0.5380273798084986>, BranchRadius(0.004402420039396796)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.5881555404628944, 3.396073442214712, 0.5151388256291695>, BranchRadius(0.019072911730473787)
  <-0.6024794564299585, 3.393812893738862, 0.5107462132090302>, BranchRadius(0.015151887404437101)
  <-0.6058532663789845, 3.3931179456270426, 0.5048978786097249>, BranchRadius(0.006787382708798759)
  <-0.6077697089018038, 3.394425872468829, 0.5026362902566718>, BranchRadius(0.003240093585901766)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-0.5698657925366126, 3.397995833477085, 0.5201950588621077>, BranchRadius(0.019258041253095343)
  <-0.5881555404628944, 3.396073442214712, 0.5151388256291695>, BranchRadius(0.019072911730473787)
  <-0.5972892694800883, 3.403703322298166, 0.5175372571627989>, BranchRadius(0.012140533335439936)
  <-0.607825457165226, 3.4095007442565626, 0.5184056823776969>, BranchRadius(0.012057176894033404)
  <-0.6128515224748898, 3.4093492011287263, 0.5173117832424899>, BranchRadius(0.005145960856303488)
  <-0.617683668284043, 3.4078314811301986, 0.5167037681485824>, BranchRadius(0.005101253715437731)
  <-0.6220696749094327, 3.407361680635079, 0.5142363570534153>, BranchRadius(0.005054293633707013)
  <-0.6257075670454932, 3.406347472072009, 0.5109419293465552>, BranchRadius(0.0050115997564393324)
  <-0.6301162735050332, 3.4062578700629325, 0.5086343645922803>, BranchRadius(0.00497690428495387)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.5972892694800883, 3.403703322298166, 0.5175372571627989>, BranchRadius(0.012140533335439936)
  <-0.607825457165226, 3.4095007442565626, 0.5184056823776969>, BranchRadius(0.012057176894033404)
  <-0.6098737978375776, 3.4169229454039782, 0.5218291619451452>, BranchRadius(0.008426445379366416)
  <-0.6135777061792064, 3.422204399813728, 0.5271192289674016>, BranchRadius(0.008342512018895624)
  <-0.6166177256403415, 3.427532336755474, 0.5326576131375199>, BranchRadius(0.008264522345248708)
  <-0.6203850002048601, 3.432027342671717, 0.5383822077469297>, BranchRadius(0.008195634159332048)
  <-0.624895559567412, 3.4334697204084614, 0.545001229065694>, BranchRadius(0.008138614287261594)
  <-0.62659179973303, 3.4338661856778985, 0.548190454684777>, BranchRadius(0.003633947641166642)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.49183407873116847, 3.3716096684027925, 0.5629910812076296>, BranchRadius(0.03978280875960205)
  <-0.5195435922227382, 3.3949941518200566, 0.5476004087253588>, BranchRadius(0.039389389460720264)
  <-0.5250477396293479, 3.4161612188184, 0.5436977274632809>, BranchRadius(0.0222164642780849)
  <-0.5329379542258588, 3.43621121507655, 0.5392608871444322>, BranchRadius(0.02199871333386988)
  <-0.5416071959366368, 3.443483069236782, 0.5462733091592586>, BranchRadius(0.013312012518083009)
  <-0.5497489357071336, 3.451426783294603, 0.5530043063732762>, BranchRadius(0.013217293331769091)
  <-0.5527208293929873, 3.4554150132374923, 0.5572008134007721>, BranchRadius(0.006507595668847168)
  <-0.5543061036241338, 3.4556853910900416, 0.5599571720892416>, BranchRadius(0.003191192847602265)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.5497489357071336, 3.451426783294603, 0.5530043063732762>, BranchRadius(0.013217293331769091)
  <-0.5527208293929873, 3.4554150132374923, 0.5572008134007721>, BranchRadius(0.006507595668847168)
  <-0.5532508568227827, 3.4603975800055946, 0.5567581662090655>, BranchRadius(0.0050301925620456385)
  <-0.5537119894991055, 3.465361886664824, 0.5563622421366929>, BranchRadius(0.005001373793581618)
  <-0.5539756069870249, 3.470262515948964, 0.5556056396042566>, BranchRadius(0.0049656931996044495)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.5416071959366368, 3.443483069236782, 0.5462733091592586>, BranchRadius(0.013312012518083009)
  <-0.5497489357071336, 3.451426783294603, 0.5530043063732762>, BranchRadius(0.013217293331769091)
  <-0.5542926034781656, 3.4556833900338293, 0.5564785635278213>, BranchRadius(0.007129802277893015)
  <-0.5573126331658989, 3.459357189818431, 0.5617024144459282>, BranchRadius(0.007064418064266658)
  <-0.5595601650572711, 3.464250494633962, 0.5661713928966577>, BranchRadius(0.006997685332559608)
  <-0.5576836340849046, 3.467216501064977, 0.5683305196530217>, BranchRadius(0.004120726997645192)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.5250477396293479, 3.4161612188184, 0.5436977274632809>, BranchRadius(0.0222164642780849)
  <-0.5329379542258588, 3.43621121507655, 0.5392608871444322>, BranchRadius(0.02199871333386988)
  <-0.5300447604636931, 3.446732994067824, 0.5264905434034199>, BranchRadius(0.01679762133607776)
  <-0.523642124481066, 3.453138992180159, 0.5199049580798473>, BranchRadius(0.011198236173403589)
  <-0.519903088511519, 3.455682071095648, 0.5167441941377764>, BranchRadius(0.0055170706946228365)
  <-0.5161612196740067, 3.4582826043403085, 0.5137152671799141>, BranchRadius(0.005471631755682622)
  <-0.5133200251719587, 3.4620164121927286, 0.5109665448586187>, BranchRadius(0.005437755205675268)
  <-0.5128395091374575, 3.4647477717586117, 0.5097456507420631>, BranchRadius(0.0030301490361685666)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.5300447604636931, 3.446732994067824, 0.5264905434034199>, BranchRadius(0.01679762133607776)
  <-0.523642124481066, 3.453138992180159, 0.5199049580798473>, BranchRadius(0.011198236173403589)
  <-0.523313925657528, 3.457949907822539, 0.5170037364045355>, BranchRadius(0.005627584827896435)
  <-0.5243016998883294, 3.4603578155523396, 0.5157685393901994>, BranchRadius(0.0028808729979805147)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.5329379542258588, 3.43621121507655, 0.5392608871444322>, BranchRadius(0.02199871333386988)
  <-0.5300447604636931, 3.446732994067824, 0.5264905434034199>, BranchRadius(0.01679762133607776)
  <-0.53208017283371, 3.4520787992169972, 0.5191039757259913>, BranchRadius(0.00934247923530888)
  <-0.5351604103038825, 3.458181414114646, 0.5128468569668322>, BranchRadius(0.009267216768149917)
  <-0.5388082153492653, 3.4578537577437376, 0.5110561352108502>, BranchRadius(0.004076827780746145)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-0.53208017283371, 3.4520787992169972, 0.5191039757259913>, BranchRadius(0.00934247923530888)
  <-0.5351604103038825, 3.458181414114646, 0.5128468569668322>, BranchRadius(0.009267216768149917)
  <-0.5326946738403922, 3.4626766442800423, 0.5108784127942392>, BranchRadius(0.0054919689554741484)
  <-0.5300302965262005, 3.4670586546276714, 0.5089944457811155>, BranchRadius(0.005463538493105586)
  <-0.5278027579577785, 3.470916661841858, 0.5059007475740324>, BranchRadius(0.005423754818853206)
  <-0.5278728159964815, 3.475258976617355, 0.5027126918045564>, BranchRadius(0.005387421027502629)
  <-0.5280477544610911, 3.4770008652905235, 0.5014117594067095>, BranchRadius(0.002181101721580059)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  27
  <-0.3396632017137683, 2.7610673175242106, 0.4738115151879147>, BranchRadius(0.11931435056020198)
  <-0.30193850219164625, 2.8655304236249797, 0.5154124384896331>, BranchRadius(0.11860156116093239)
  <-0.2701851951717961, 2.910754869254171, 0.545782080326122>, BranchRadius(0.06305424755273184)
  <-0.23473210841114478, 2.961323466320615, 0.5565028513736867>, BranchRadius(0.0626820492803237)
  <-0.19458214425213682, 3.008638320251459, 0.5607902519833744>, BranchRadius(0.06220206450315519)
  <-0.17535058337367815, 3.0670932004562306, 0.5644232965935813>, BranchRadius(0.0616443425361632)
  <-0.15528654369715417, 3.1248892269382256, 0.5678230248934139>, BranchRadius(0.06127401176486876)
  <-0.1312544560908941, 3.1805680699895604, 0.5656661672451122>, BranchRadius(0.06068217887621674)
  <-0.10872494697070198, 3.231044655414004, 0.5892405983254458>, BranchRadius(0.06009341276770193)
  <-0.07278921358932763, 3.276559120020274, 0.6036758376393019>, BranchRadius(0.059760518372089795)
  <-0.05460647664729914, 3.328192597758948, 0.6263866143868774>, BranchRadius(0.059265566111962306)
  <-0.04831523024056956, 3.3498079155711267, 0.650034026513374>, BranchRadius(0.0326496837006434)
  <-0.03436160049400656, 3.364357267925466, 0.6754525240447877>, BranchRadius(0.03244206303226353)
  <-0.019288356048608048, 3.368599080477559, 0.7035263629787231>, BranchRadius(0.032145545637403274)
  <0.005778105655424755, 3.3647187951465907, 0.7229500099150632>, BranchRadius(0.03194780394513941)
  <0.030446349633297863, 3.353727443069648, 0.7396240595305107>, BranchRadius(0.0317388722548484)
  <0.05981126225273476, 3.3427846654518922, 0.7424488813659784>, BranchRadius(0.03146461653255857)
  <0.08271310795600285, 3.322294090469729, 0.7369468047193041>, BranchRadius(0.03121908145897055)
  <0.1120065531402491, 3.312121125405658, 0.7361743374014154>, BranchRadius(0.031019217506482216)
  <0.13958548840067558, 3.3007634470896425, 0.7283625343001363>, BranchRadius(0.03083210655342967)
  <0.15621857498728553, 3.286880156314916, 0.7295823333202329>, BranchRadius(0.021700074695325294)
  <0.17335083003837803, 3.275272658203407, 0.7356602134316725>, BranchRadius(0.02156823595460243)
  <0.17700899166159595, 3.266423172062056, 0.7470629434795354>, BranchRadius(0.0148901915357723)
  <0.18186118022463363, 3.2619796106428276, 0.7602732716125921>, BranchRadius(0.014758107647010608)
  <0.18231629931286536, 3.252801070007022, 0.7673298227539653>, BranchRadius(0.011586529057419649)
  <0.1859404650086242, 3.2484914265052707, 0.7696438823149108>, BranchRadius(0.006087895839623462)
  <0.18766343090525964, 3.2465149042772485, 0.7696509354429794>, BranchRadius(0.00262207958411822)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.18186118022463363, 3.2619796106428276, 0.7602732716125921>, BranchRadius(0.014758107647010608)
  <0.18231629931286536, 3.252801070007022, 0.7673298227539653>, BranchRadius(0.011586529057419649)
  <0.1804663488573932, 3.2492968883809255, 0.7706167984312279>, BranchRadius(0.005148379809152449)
  <0.1786302590031179, 3.2459654759144425, 0.7740240881136569>, BranchRadius(0.005106775690668052)
  <0.17686208024579678, 3.242656058303173, 0.7774418640998286>, BranchRadius(0.005075420547626872)
  <0.17660890604732943, 3.242920877170495, 0.779670767028386>, BranchRadius(0.002258812624409328)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.17700899166159595, 3.266423172062056, 0.7470629434795354>, BranchRadius(0.0148901915357723)
  <0.18186118022463363, 3.2619796106428276, 0.7602732716125921>, BranchRadius(0.014758107647010608)
  <0.18560626994960608, 3.2597615086873644, 0.7696650145929849>, BranchRadius(0.010351353029564934)
  <0.1871483375878102, 3.2586782828167578, 0.774299000921707>, BranchRadius(0.005002517384510705)
  <0.187019081226415, 3.256889276986052, 0.7760446132190767>, BranchRadius(0.0025028806128118454)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.18186118022463363, 3.2619796106428276, 0.7602732716125921>, BranchRadius(0.014758107647010608)
  <0.18560626994960608, 3.2597615086873644, 0.7696650145929849>, BranchRadius(0.010351353029564934)
  <0.18845824144703702, 3.258239586453285, 0.7760623292120382>, BranchRadius(0.007167679055586738)
  <0.18986747626732067, 3.2611680680283124, 0.779622446743807>, BranchRadius(0.004820413255518707)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.18560626994960608, 3.2597615086873644, 0.7696650145929849>, BranchRadius(0.010351353029564934)
  <0.18845824144703702, 3.258239586453285, 0.7760623292120382>, BranchRadius(0.007167679055586738)
  <0.19050881820221238, 3.256012643222909, 0.7805392161528687>, BranchRadius(0.005404318445573186)
  <0.19358545285223389, 3.2574079666948443, 0.7831042134116987>, BranchRadius(0.00424167647267594)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <0.15621857498728553, 3.286880156314916, 0.7295823333202329>, BranchRadius(0.021700074695325294)
  <0.17335083003837803, 3.275272658203407, 0.7356602134316725>, BranchRadius(0.02156823595460243)
  <0.1864182006809462, 3.272138658148527, 0.7312244915276768>, BranchRadius(0.014151104573983934)
  <0.19985983428242074, 3.2682746281147583, 0.7326957105713602>, BranchRadius(0.014063169182394471)
  <0.21340037505973514, 3.2668938599160784, 0.7296983899421857>, BranchRadius(0.013936882589541837)
  <0.22710592208972374, 3.2674754776997816, 0.7281389631531101>, BranchRadius(0.013806234481133394)
  <0.2340678700957283, 3.2649140455490224, 0.7279021996417264>, BranchRadius(0.007421974916528354)
  <0.24073771073088743, 3.2618050457499046, 0.7283784680033507>, BranchRadius(0.007374244734318196)
  <0.24782843302337537, 3.2602067505714327, 0.7290812257636005>, BranchRadius(0.007302517276686369)
  <0.254083165008239, 3.2578583992903076, 0.7319253850880258>, BranchRadius(0.0072612442600944035)
  <0.2589323783156056, 3.253642601867577, 0.735164728568375>, BranchRadius(0.007195912992353759)
  <0.26279507080040926, 3.249712328793926, 0.7397246005687418>, BranchRadius(0.007152612971869246)
  <0.26483776654692054, 3.2477000087033066, 0.7391807285178315>, BranchRadius(0.0029185329992458832)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.21340037505973514, 3.2668938599160784, 0.7296983899421857>, BranchRadius(0.013936882589541837)
  <0.22710592208972374, 3.2674754776997816, 0.7281389631531101>, BranchRadius(0.013806234481133394)
  <0.23374782550789985, 3.269060590852884, 0.7271298923895709>, BranchRadius(0.006902585640928166)
  <0.23746028950493878, 3.267569296269146, 0.7284786569240912>, BranchRadius(0.004222027265944108)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <0.1120065531402491, 3.312121125405658, 0.7361743374014154>, BranchRadius(0.031019217506482216)
  <0.13958548840067558, 3.3007634470896425, 0.7283625343001363>, BranchRadius(0.03083210655342967)
  <0.15274049607104817, 3.2999407612813556, 0.7207615500825912>, BranchRadius(0.01521532121981284)
  <0.1587535530434671, 3.3033520112819943, 0.7153455052017798>, BranchRadius(0.008782199204719699)
  <0.16675591423655756, 3.305693722559626, 0.7128781201697761>, BranchRadius(0.008695365735184684)
  <0.1726718557754131, 3.307494561782992, 0.7114933088826322>, BranchRadius(0.0063371198900265486)
  <0.17864099537805048, 3.309197101008999, 0.7104414859358329>, BranchRadius(0.006295680973753412)
  <0.18453555966090615, 3.310923718898474, 0.7093460497573796>, BranchRadius(0.006239156821401202)
  <0.19061171001864496, 3.311466433491932, 0.7104918155893171>, BranchRadius(0.006207005851571038)
  <0.19650485540603746, 3.3119046789858486, 0.7087710370366279>, BranchRadius(0.0061548599088264095)
  <0.20249256342011845, 3.3120814004129895, 0.7099008603465544>, BranchRadius(0.006095931301807268)
  <0.20806935582106495, 3.312147386293469, 0.7122658005699891>, BranchRadius(0.006057879982312024)
  <0.21352825614316215, 3.312256559624878, 0.7147701591609438>, BranchRadius(0.006006939611397179)
  <0.21928572137256017, 3.312070880435839, 0.7162943093959707>, BranchRadius(0.005958684130569606)
  <0.22258074380395548, 3.3120237461168767, 0.7171669361837896>, BranchRadius(0.0034089400080144472)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.13958548840067558, 3.3007634470896425, 0.7283625343001363>, BranchRadius(0.03083210655342967)
  <0.15274049607104817, 3.2999407612813556, 0.7207615500825912>, BranchRadius(0.01521532121981284)
  <0.15856545246189752, 3.2959105684884196, 0.7192753418248243>, BranchRadius(0.007237498593366713)
  <0.1654217124076154, 3.294234766664099, 0.7179014010950302>, BranchRadius(0.007190571974929238)
  <0.1723612798248313, 3.292603282612981, 0.7180530874346048>, BranchRadius(0.007130381819562704)
  <0.17864555267232898, 3.290624473428135, 0.7206482355928898>, BranchRadius(0.007081141502277575)
  <0.18263116670036286, 3.2898730971494654, 0.7227803198909849>, BranchRadius(0.004582081289849791)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.1723612798248313, 3.292603282612981, 0.7180530874346048>, BranchRadius(0.007130381819562704)
  <0.17864555267232898, 3.290624473428135, 0.7206482355928898>, BranchRadius(0.007081141502277575)
  <0.18294623790046108, 3.286968188988381, 0.7202018724650465>, BranchRadius(0.005662468488014715)
  <0.18821340454132374, 3.285659167957761, 0.7187071191714279>, BranchRadius(0.005629464263143129)
  <0.19160711432899358, 3.285975383014022, 0.7188921266989516>, BranchRadius(0.003413427290857757)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  18
  <-0.07278921358932763, 3.276559120020274, 0.6036758376393019>, BranchRadius(0.059760518372089795)
  <-0.05460647664729914, 3.328192597758948, 0.6263866143868774>, BranchRadius(0.059265566111962306)
  <-0.039723020976985206, 3.364125172305191, 0.6183162736539551>, BranchRadius(0.03972150004414433)
  <-0.02629186503466935, 3.381610316195597, 0.6376504408056428>, BranchRadius(0.02932466924390478)
  <-0.007451246266202877, 3.394626114026186, 0.6556387261539>, BranchRadius(0.02911972387430524)
  <0.01122781911003752, 3.4073936269116434, 0.673592105090972>, BranchRadius(0.028883224956162457)
  <0.027109112830847697, 3.422885859796466, 0.6918285243863752>, BranchRadius(0.028719187988555262)
  <0.03495303767294947, 3.427864277917387, 0.7128292382530302>, BranchRadius(0.022963923593854234)
  <0.042230557770213506, 3.43953485895182, 0.7309949065140614>, BranchRadius(0.022785000851814508)
  <0.04249938575306633, 3.4502029353136665, 0.7509066469952632>, BranchRadius(0.022591094057997457)
  <0.03904755540228219, 3.4593653550090746, 0.7710782054379638>, BranchRadius(0.022422239795628844)
  <0.03316308564531741, 3.4654990507389396, 0.7916732171391767>, BranchRadius(0.022280119268089513)
  <0.02598297697235106, 3.4704289646921165, 0.8120291240476776>, BranchRadius(0.02214093399585674)
  <0.02014386134051832, 3.484191555630815, 0.8281942305105825>, BranchRadius(0.022018511477048485)
  <0.016092825422335255, 3.492658371723292, 0.847956021484056>, BranchRadius(0.021877528407786277)
  <0.01555035551454037, 3.489711030334928, 0.8567740905613803>, BranchRadius(0.009313400942345864)
  <0.01618032281966374, 3.490101266274725, 0.8622460896879799>, BranchRadius(0.005521948690067667)
  <0.016555164438767884, 3.490338068708449, 0.8658708344389916>, BranchRadius(0.0036517606906829)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.02014386134051832, 3.484191555630815, 0.8281942305105825>, BranchRadius(0.022018511477048485)
  <0.016092825422335255, 3.492658371723292, 0.847956021484056>, BranchRadius(0.021877528407786277)
  <0.014048652532131976, 3.501909701049513, 0.8503983966083113>, BranchRadius(0.009784218586827457)
  <0.016318928793537493, 3.5056529923587876, 0.8505736237477322>, BranchRadius(0.00438144823997515)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.016092825422335255, 3.492658371723292, 0.847956021484056>, BranchRadius(0.021877528407786277)
  <0.014048652532131976, 3.501909701049513, 0.8503983966083113>, BranchRadius(0.009784218586827457)
  <0.011313657955789693, 3.507482416954585, 0.8522642893731776>, BranchRadius(0.006482045487440434)
  <0.010955167772812217, 3.5127163025529486, 0.855983029756224>, BranchRadius(0.0064304823850586225)
  <0.011733814279914162, 3.515831769933605, 0.8572930299123247>, BranchRadius(0.003468216802903064)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  32
  <0.01122781911003752, 3.4073936269116434, 0.673592105090972>, BranchRadius(0.028883224956162457)
  <0.027109112830847697, 3.422885859796466, 0.6918285243863752>, BranchRadius(0.028719187988555262)
  <0.037326638367132334, 3.43636154860174, 0.6878210206264883>, BranchRadius(0.017379646234797562)
  <0.04592221910828449, 3.451272486989564, 0.6867812873155866>, BranchRadius(0.017242422603594747)
  <0.055753215619962736, 3.4636967175888804, 0.6804056686651097>, BranchRadius(0.017078012518262235)
  <0.06878015607545182, 3.4744785860631215, 0.6807572819853396>, BranchRadius(0.016913707380514034)
  <0.08420655086020348, 3.48067856584815, 0.6832320237566181>, BranchRadius(0.016808859337393588)
  <0.09933008529627271, 3.486540956437714, 0.6794517595696652>, BranchRadius(0.01665470848098954)
  <0.11373109531561298, 3.4920212375460964, 0.6734666562622879>, BranchRadius(0.01653009474274148)
  <0.1286144926640385, 3.497384568181279, 0.6691476124592389>, BranchRadius(0.01639923691840768)
  <0.14357772379954611, 3.5026876556816418, 0.6654122224141688>, BranchRadius(0.01630871429144357)
  <0.1561698599658141, 3.511915558396917, 0.661136646380187>, BranchRadius(0.01618631002343566)
  <0.1685698079235664, 3.5205402713244176, 0.6557129956592948>, BranchRadius(0.016048687472157843)
  <0.18157322412648236, 3.528974517976723, 0.6518890215645566>, BranchRadius(0.01596396339933835)
  <0.19669571296064936, 3.5325155453748716, 0.6488406105936901>, BranchRadius(0.015827866344559637)
  <0.21137521057489597, 3.533359526176006, 0.6433320555962555>, BranchRadius(0.01570172385310343)
  <0.2252590336747452, 3.527711405927342, 0.6389258488851467>, BranchRadius(0.015622946706440988)
  <0.238190526928131, 3.5229128881112057, 0.6319006655517686>, BranchRadius(0.015479098548097498)
  <0.2521328570991812, 3.5222619985014454, 0.6254312019408915>, BranchRadius(0.015383958765387175)
  <0.2624567477377592, 3.5216620280399376, 0.6141481190745557>, BranchRadius(0.015305248819950627)
  <0.2744264980275901, 3.521524570526916, 0.6048426259840294>, BranchRadius(0.015161992554629043)
  <0.28451645005063425, 3.520693823349119, 0.5936789084355975>, BranchRadius(0.015070695478375116)
  <0.2943448630097367, 3.519150241445832, 0.5824785535892707>, BranchRadius(0.014980931048184027)
  <0.2987521514824349, 3.5196663142265967, 0.5736947222395833>, BranchRadius(0.00984104750401985)
  <0.30556949971937525, 3.5218987030800815, 0.5670799711299509>, BranchRadius(0.009757803503824958)
  <0.3077348718039493, 3.5278840618055702, 0.5626554873762474>, BranchRadius(0.007751736052280529)
  <0.3097491578812033, 3.533894134549542, 0.5583266303610145>, BranchRadius(0.007675762232324586)
  <0.31484816164124196, 3.537739255512641, 0.5541521687435976>, BranchRadius(0.007629608401552396)
  <0.31826615880728326, 3.5437020374123187, 0.5510094521434047>, BranchRadius(0.00755738977685534)
  <0.3221679019756888, 3.5496209635632647, 0.5485919910664075>, BranchRadius(0.007490087088368698)
  <0.3254236095270305, 3.5562571780447763, 0.549511422345339>, BranchRadius(0.0074487803150020794)
  <0.3267462669028029, 3.5574518323016484, 0.5519345697738062>, BranchRadius(0.0030080333753525128)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <0.2987521514824349, 3.5196663142265967, 0.5736947222395833>, BranchRadius(0.00984104750401985)
  <0.30556949971937525, 3.5218987030800815, 0.5670799711299509>, BranchRadius(0.009757803503824958)
  <0.3101068569617822, 3.5220812761667064, 0.5632513374620655>, BranchRadius(0.005939644723386125)
  <0.313717665657669, 3.5227032162277814, 0.5586512136797677>, BranchRadius(0.005880976763287212)
  <0.31554255117225627, 3.525258928628226, 0.5537256953904732>, BranchRadius(0.00584145559200028)
  <0.3176932472679625, 3.5253556100940493, 0.5483505331217972>, BranchRadius(0.005790268596232686)
  <0.31893766070905244, 3.525672520485338, 0.5427513645646962>, BranchRadius(0.005744535276182028)
  <0.31772127871719263, 3.526816034590283, 0.5372850913809604>, BranchRadius(0.005715536035889999)
  <0.3172519978064165, 3.5277664269187423, 0.5317038288640553>, BranchRadius(0.0056810176406893185)
  <0.3181327896986801, 3.5297143310849988, 0.5264759690718711>, BranchRadius(0.00564806542146362)
  <0.3179430777054622, 3.530581072331715, 0.52424209441279>, BranchRadius(0.0024036278875096823)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <0.28451645005063425, 3.520693823349119, 0.5936789084355975>, BranchRadius(0.015070695478375116)
  <0.2943448630097367, 3.519150241445832, 0.5824785535892707>, BranchRadius(0.014980931048184027)
  <0.30414752079540663, 3.514361456263818, 0.5814225871971831>, BranchRadius(0.010960822423689323)
  <0.3144586366384971, 3.5117978682807816, 0.5791201410605031>, BranchRadius(0.010871630580952994)
  <0.3234651887078568, 3.5059178668481783, 0.5780898493999156>, BranchRadius(0.010805271765734483)
  <0.3319478346835148, 3.500696462149053, 0.5741577137307086>, BranchRadius(0.010708876724542417)
  <0.3398091636449626, 3.494743906771365, 0.570180265225189>, BranchRadius(0.010632662186799651)
  <0.3477037436333452, 3.4887275084674987, 0.5666306524556947>, BranchRadius(0.0105414037280189)
  <0.34926496295378145, 3.4843119725119207, 0.5625462952298605>, BranchRadius(0.006214204493716627)
  <0.35153370495063163, 3.479910628957153, 0.5588706714904805>, BranchRadius(0.006166784024826993)
  <0.35289800500009055, 3.477624155512746, 0.5533682879364035>, BranchRadius(0.006112732630592439)
  <0.35487016027748225, 3.4733034284215822, 0.5495970451407879>, BranchRadius(0.006064680639402373)
  <0.35558445487218826, 3.4716620449437428, 0.5475600411454872>, BranchRadius(0.0027117783401711176)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.3398091636449626, 3.494743906771365, 0.570180265225189>, BranchRadius(0.010632662186799651)
  <0.3477037436333452, 3.4887275084674987, 0.5666306524556947>, BranchRadius(0.0105414037280189)
  <0.3551262727646585, 3.4856910659883065, 0.5660407386234262>, BranchRadius(0.008041263580068715)
  <0.3619741927962633, 3.4843275110228156, 0.5621986187016077>, BranchRadius(0.007969640920192297)
  <0.36520562896777625, 3.4826638660547613, 0.5633833698748714>, BranchRadius(0.0038227646609284485)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-0.05460647664729914, 3.328192597758948, 0.6263866143868774>, BranchRadius(0.059265566111962306)
  <-0.039723020976985206, 3.364125172305191, 0.6183162736539551>, BranchRadius(0.03972150004414433)
  <-0.03651011921639428, 3.376532789781508, 0.6082888988913439>, BranchRadius(0.01627328958114068)
  <-0.039253567375757054, 3.3860184173873815, 0.5954948150629309>, BranchRadius(0.016161442382685933)
  <-0.042147415757273064, 3.398876550682262, 0.5863103526440517>, BranchRadius(0.016064255358027784)
  <-0.0411384605317329, 3.4046982314013596, 0.5837061318984893>, BranchRadius(0.006456928273867774)
  <-0.04094582062898001, 3.4110997680435484, 0.5836323497174026>, BranchRadius(0.006404859508503143)
  <-0.04078994576951302, 3.417413731683887, 0.582928619708129>, BranchRadius(0.006354972049449591)
  <-0.041744914868551905, 3.4206198677425657, 0.5809039268090438>, BranchRadius(0.003910326807631934)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <-0.039253567375757054, 3.3860184173873815, 0.5954948150629309>, BranchRadius(0.016161442382685933)
  <-0.042147415757273064, 3.398876550682262, 0.5863103526440517>, BranchRadius(0.016064255358027784)
  <-0.04475600259456771, 3.4055548966667692, 0.5807991911994035>, BranchRadius(0.009043115107388113)
  <-0.048344615391517125, 3.4122271835017104, 0.5759448577449315>, BranchRadius(0.008997894570474035)
  <-0.0531935439766415, 3.419010781484013, 0.5726890385978527>, BranchRadius(0.008951517654991534)
  <-0.05916988477270964, 3.425552128743386, 0.5718241515257141>, BranchRadius(0.008902466114847171)
  <-0.0668311300760061, 3.4295486396048753, 0.5699939496661779>, BranchRadius(0.008832690275897587)
  <-0.07416907959906173, 3.434106210804344, 0.5684944416350896>, BranchRadius(0.008767296206724133)
  <-0.07912626451467336, 3.440529659723929, 0.5653188487271092>, BranchRadius(0.008713137702762367)
  <-0.07980630146477169, 3.4454720104715713, 0.5633406298802719>, BranchRadius(0.00536680826676347)
  <-0.07987804006666795, 3.4477682212623817, 0.5624609995424156>, BranchRadius(0.0024599756003083994)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  25
  <-0.37875012255467205, 2.35279537121765, 0.2597843749816974>, BranchRadius(0.1595985128716079)
  <-0.4675865159731754, 2.4772120302762115, 0.3026031213811855>, BranchRadius(0.15876036939401839)
  <-0.567140403282517, 2.4998845848395623, 0.26705972779276355>, BranchRadius(0.10811269137622408)
  <-0.6660954128509913, 2.522800064142034, 0.23175201443396642>, BranchRadius(0.10753533248651728)
  <-0.771472448791815, 2.517499001222768, 0.21409991143915008>, BranchRadius(0.10697671574640556)
  <-0.8647875248009951, 2.5322747744155536, 0.1657301388832323>, BranchRadius(0.10613982184437146)
  <-0.9133856126005587, 2.5406540502634702, 0.14187798219099787>, BranchRadius(0.05478057849621961)
  <-0.9388632890975, 2.5544603879482963, 0.13354743325859877>, BranchRadius(0.030151699876878282)
  <-0.960312656834701, 2.571503882827568, 0.12133911032996482>, BranchRadius(0.02999331996887379)
  <-0.9823984987566452, 2.5779022236410793, 0.10248259251938663>, BranchRadius(0.02973703822689145)
  <-1.0087886475507217, 2.5846635468030867, 0.09126170017564783>, BranchRadius(0.02946292363741887)
  <-1.0348132103831504, 2.5787738847992485, 0.07942326310040314>, BranchRadius(0.029191001721815085)
  <-1.057135353548251, 2.5662654860561576, 0.0656843400522571>, BranchRadius(0.02904300468481669)
  <-1.0713477448404545, 2.556678520990212, 0.04245084868815445>, BranchRadius(0.02887381315975064)
  <-1.0832582197144105, 2.5459898696861756, 0.030830003798854977>, BranchRadius(0.01977753054260267)
  <-1.0972687885971169, 2.5358124106432065, 0.02157514955922962>, BranchRadius(0.019634893429430367)
  <-1.1115600778815256, 2.5261009763269855, 0.012559898745965768>, BranchRadius(0.019489167583942087)
  <-1.1175667712854904, 2.5227170617750683, 0.0017472310463908219>, BranchRadius(0.012823612054540011)
  <-1.1235257196127153, 2.5193518289336465, -0.008981780589562583>, BranchRadius(0.012725782802167632)
  <-1.1268177279229417, 2.5186541579975277, -0.014866464123866222>, BranchRadius(0.0067789057928701706)
  <-1.1316630619324324, 2.516970778158864, -0.01924564535286316>, BranchRadius(0.006744498319456073)
  <-1.1343283201471177, 2.5129155422934577, -0.0238326795180741>, BranchRadius(0.006677531108713679)
  <-1.1350702224274964, 2.5071187280973346, -0.026972966266979703>, BranchRadius(0.006634370707411212)
  <-1.1382827978966081, 2.50200852604942, -0.029600007169722747>, BranchRadius(0.006583019825272768)
  <-1.1403958800946046, 2.4993375363515655, -0.031011771595075267>, BranchRadius(0.003686784660679839)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-1.1175667712854904, 2.5227170617750683, 0.0017472310463908219>, BranchRadius(0.012823612054540011)
  <-1.1235257196127153, 2.5193518289336465, -0.008981780589562583>, BranchRadius(0.012725782802167632)
  <-1.1278777524775245, 2.5149298178378374, -0.016889499098142212>, BranchRadius(0.010051188198356039)
  <-1.1326406888929608, 2.512241309168008, -0.02524756604336221>, BranchRadius(0.009988539694370547)
  <-1.13797635221129, 2.5088371311002855, -0.03286779138096716>, BranchRadius(0.009905834924891796)
  <-1.1431374544604165, 2.5063697276276633, -0.040885057093710306>, BranchRadius(0.009848939325195006)
  <-1.1500472784998725, 2.504326304657549, -0.04745573867068431>, BranchRadius(0.009751671758063954)
  <-1.1515494734769247, 2.5033772746333165, -0.05136028249448296>, BranchRadius(0.004289838016515228)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-1.1431374544604165, 2.5063697276276633, -0.040885057093710306>, BranchRadius(0.009848939325195006)
  <-1.1500472784998725, 2.504326304657549, -0.04745573867068431>, BranchRadius(0.009751671758063954)
  <-1.1560516748630267, 2.5031395416640274, -0.05027677892411019>, BranchRadius(0.006739395388319414)
  <-1.1608565998019296, 2.5019929042900633, -0.05479498251379199>, BranchRadius(0.006694493603975929)
  <-1.1643876700564924, 2.4997919259332857, -0.05998122713416154>, BranchRadius(0.006649052273217124)
  <-1.1671747626678768, 2.498375440395077, -0.06580544070633561>, BranchRadius(0.006610278378304768)
  <-1.169349489178404, 2.4973566364721766, -0.07051480407527225>, BranchRadius(0.005286350363870029)
  <-1.171979395890663, 2.495305402173933, -0.07454949396753272>, BranchRadius(0.005234758254990006)
  <-1.1744464048473524, 2.4958370012769837, -0.07776319019709191>, BranchRadius(0.004086144179374074)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-1.0972687885971169, 2.5358124106432065, 0.02157514955922962>, BranchRadius(0.019634893429430367)
  <-1.1115600778815256, 2.5261009763269855, 0.012559898745965768>, BranchRadius(0.019489167583942087)
  <-1.1229068246912186, 2.517659171871142, 0.012762258264444522>, BranchRadius(0.01414403319455579)
  <-1.1273254927037084, 2.5165226778025267, 0.018012553176652287>, BranchRadius(0.006955705746921264)
  <-1.1301721810624161, 2.5145622264012233, 0.021010664553401413>, BranchRadius(0.0045755520034052935)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-1.1115600778815256, 2.5261009763269855, 0.012559898745965768>, BranchRadius(0.019489167583942087)
  <-1.1229068246912186, 2.517659171871142, 0.012762258264444522>, BranchRadius(0.01414403319455579)
  <-1.129637298348541, 2.510549926877695, 0.007828730622039124>, BranchRadius(0.01096267919019516)
  <-1.1375019396449493, 2.5036833824403324, 0.004700884109539504>, BranchRadius(0.010898873292097898)
  <-1.1440262558128673, 2.4955925870188995, 0.001770004144107139>, BranchRadius(0.01079896890365982)
  <-1.1482109253956052, 2.4857727201468767, 0.0029892363842385005>, BranchRadius(0.010743731761185963)
  <-1.14904248476464, 2.4772688785937937, 0.00262769446580112>, BranchRadius(0.008552047982966408)
  <-1.1469513473132429, 2.4736215552868357, 0.0024128448906378104>, BranchRadius(0.0042097486250444035)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <-1.1440262558128673, 2.4955925870188995, 0.001770004144107139>, BranchRadius(0.01079896890365982)
  <-1.1482109253956052, 2.4857727201468767, 0.0029892363842385005>, BranchRadius(0.010743731761185963)
  <-1.1537379320872412, 2.4847370802556337, 0.005699324518157518>, BranchRadius(0.006242189571563197)
  <-1.1588227804337021, 2.4866340017107422, 0.008685826535020817>, BranchRadius(0.006194609593032241)
  <-1.1625436046068927, 2.490724475542766, 0.011351027866174694>, BranchRadius(0.006138387967036436)
  <-1.1646364973122918, 2.496103079931527, 0.013311188943107335>, BranchRadius(0.006095228994437332)
  <-1.1651669678644352, 2.502102634106741, 0.01384240664335881>, BranchRadius(0.006046341170748064)
  <-1.1674722325558287, 2.5076436796665202, 0.013888008634618754>, BranchRadius(0.006001625674310084)
  <-1.1701112289208717, 2.512986183175159, 0.013625282379361555>, BranchRadius(0.00596453440259448)
  <-1.1714677082285823, 2.51873363987172, 0.01398354054019437>, BranchRadius(0.005916218682646327)
  <-1.1722087530613534, 2.524406219729623, 0.012701249246451368>, BranchRadius(0.005862728089419404)
  <-1.1725953060993128, 2.5299062600916784, 0.010853951111362342>, BranchRadius(0.005814841153057997)
  <-1.1734621431939833, 2.535302659838046, 0.008975963718941559>, BranchRadius(0.005779219101001866)
  <-1.1760738072410735, 2.5380100416527975, 0.007959587954995278>, BranchRadius(0.0038966299643727943)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <-1.057135353548251, 2.5662654860561576, 0.0656843400522571>, BranchRadius(0.02904300468481669)
  <-1.0713477448404545, 2.556678520990212, 0.04245084868815445>, BranchRadius(0.02887381315975064)
  <-1.0760557302916691, 2.556345525474734, 0.02634799017803477>, BranchRadius(0.016780287995714245)
  <-1.0803541827521086, 2.5554080635245997, 0.010301576245442506>, BranchRadius(0.016638597553841426)
  <-1.0848026428256845, 2.5547801359488616, -0.005605873044492917>, BranchRadius(0.01652967129069538)
  <-1.0853195526533348, 2.5563799374406, -0.021948243653212633>, BranchRadius(0.016428622513638694)
  <-1.0839821357546247, 2.562058710342453, -0.025611851374588133>, BranchRadius(0.006889061414147397)
  <-1.084125968606808, 2.5688448963334425, -0.026483041990906547>, BranchRadius(0.006843389604840259)
  <-1.0855615628894844, 2.5752921218350235, -0.028034123457476093>, BranchRadius(0.006784799284328475)
  <-1.086364796702269, 2.5819585544054076, -0.027401198144874874>, BranchRadius(0.0067444126671496055)
  <-1.0873579004587148, 2.588572956886412, -0.026932144039560065>, BranchRadius(0.0067049673381380384)
  <-1.0904077194536688, 2.5940368748189706, -0.024716930196054282>, BranchRadius(0.006637994233816127)
  <-1.0923448578897754, 2.600339653614882, -0.024465618522140634>, BranchRadius(0.006598536461085822)
  <-1.0927141587740645, 2.6068359193584265, -0.02516299633563391>, BranchRadius(0.006544019221291761)
  <-1.0921297856271859, 2.6131994637134666, -0.026244420001317232>, BranchRadius(0.006481177815648344)
  <-1.0928381281664525, 2.615244232397565, -0.02912967751079074>, BranchRadius(0.0036065965979545814)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  20
  <-1.0848026428256845, 2.5547801359488616, -0.005605873044492917>, BranchRadius(0.01652967129069538)
  <-1.0853195526533348, 2.5563799374406, -0.021948243653212633>, BranchRadius(0.016428622513638694)
  <-1.0860857641255925, 2.5558364973333783, -0.03253151918873952>, BranchRadius(0.010624882504349797)
  <-1.0864614020125567, 2.5554702400089653, -0.04306834914053821>, BranchRadius(0.010549883112287595)
  <-1.0874913940775592, 2.5535618911804128, -0.053326079008960435>, BranchRadius(0.010484450436666973)
  <-1.0887466442495588, 2.5512562087401256, -0.06338742197244843>, BranchRadius(0.010398194398004018)
  <-1.0927629108847123, 2.547746584551932, -0.06946899319171872>, BranchRadius(0.008089089449502988)
  <-1.0940177999677714, 2.5464210438350317, -0.07729885990743562>, BranchRadius(0.008039814524529293)
  <-1.0959081406150808, 2.5458814052041308, -0.08504897012232855>, BranchRadius(0.00799554913422577)
  <-1.0990246053848534, 2.547642696705109, -0.09214046087700281>, BranchRadius(0.007943786347597844)
  <-1.1011950885792179, 2.5479906083424964, -0.09972318560758042>, BranchRadius(0.007894919514736164)
  <-1.100975825356229, 2.550140540003631, -0.10723873878853386>, BranchRadius(0.007820090928131514)
  <-1.1010110251689136, 2.5529506067518746, -0.11445858769348159>, BranchRadius(0.007747511366024005)
  <-1.1010980804248058, 2.5557359281801575, -0.12161670736124149>, BranchRadius(0.007681423777816295)
  <-1.101145207405747, 2.5580097527017625, -0.12890392822618202>, BranchRadius(0.007633877575767723)
  <-1.1017731548219245, 2.5596524543979733, -0.13628024416990273>, BranchRadius(0.007583061632467867)
  <-1.1006550961005281, 2.5608371023975485, -0.1436434932969762>, BranchRadius(0.007541278664439853)
  <-1.0985723073628524, 2.5603117753834486, -0.15082300494521897>, BranchRadius(0.0074939552243649)
  <-1.094726685687883, 2.560529302956308, -0.15717181706601152>, BranchRadius(0.007425869622951233)
  <-1.0943705117887135, 2.561454512395536, -0.16189775680908164>, BranchRadius(0.0048288071827332505)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-1.0874913940775592, 2.5535618911804128, -0.053326079008960435>, BranchRadius(0.010484450436666973)
  <-1.0887466442495588, 2.5512562087401256, -0.06338742197244843>, BranchRadius(0.010398194398004018)
  <-1.0863198422396467, 2.5521669098089736, -0.06788128365379614>, BranchRadius(0.005187825868627374)
  <-1.0828624889210663, 2.553153407881662, -0.07156281559634169>, BranchRadius(0.005145886499029963)
  <-1.0797794603541693, 2.5540576314682886, -0.07552396639677651>, BranchRadius(0.005100333430541733)
  <-1.0779651534044097, 2.5557609580288303, -0.0799344661065949>, BranchRadius(0.005064142451600366)
  <-1.0769670535798412, 2.556589085201616, -0.0822720972245576>, BranchRadius(0.0026732970500446605)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  21
  <-0.8647875248009951, 2.5322747744155536, 0.1657301388832323>, BranchRadius(0.10613982184437146)
  <-0.9133856126005587, 2.5406540502634702, 0.14187798219099787>, BranchRadius(0.05478057849621961)
  <-0.9416875104022084, 2.522124377633226, 0.11760734588937777>, BranchRadius(0.041634240397112686)
  <-0.9604498618785791, 2.5022069946349035, 0.08667790378604692>, BranchRadius(0.04129598488047017)
  <-0.9661961210401423, 2.5020336392223173, 0.05976301475912067>, BranchRadius(0.027522005700578528)
  <-0.9629706265196203, 2.5013389837132207, 0.03266774636457427>, BranchRadius(0.027295419589204714)
  <-0.9526765180775937, 2.5062787829404938, 0.00804791463098703>, BranchRadius(0.027138651396340936)
  <-0.953857576350049, 2.5192104565348954, -0.00433507772139872>, BranchRadius(0.017943287886959924)
  <-0.9543531751228934, 2.5314091596867647, -0.017250398599177673>, BranchRadius(0.017772436245688472)
  <-0.9545433901992357, 2.536153211228702, -0.03423214077880768>, BranchRadius(0.017632974061775584)
  <-0.9504312902708819, 2.5404580215482966, -0.05065565249821698>, BranchRadius(0.017469187013310895)
  <-0.9510127667318258, 2.5408254082312696, -0.06800716963399567>, BranchRadius(0.0173651442482543)
  <-0.9496213298635905, 2.5408553226681416, -0.08517126926916607>, BranchRadius(0.017220432855125166)
  <-0.9494122894527236, 2.540124168879801, -0.10226484153816506>, BranchRadius(0.017110479147910255)
  <-0.9495361372977836, 2.5450993163917874, -0.11853264146018616>, BranchRadius(0.017012017674504696)
  <-0.9547059715667089, 2.5531846879054414, -0.13238062852277133>, BranchRadius(0.01684835791902248)
  <-0.9636972041919608, 2.555665876034807, -0.14193622652181723>, BranchRadius(0.013353202304094362)
  <-0.9727030046348624, 2.5583476851979325, -0.15130458421234844>, BranchRadius(0.013268860833640624)
  <-0.9771697630839031, 2.5570634766791502, -0.15822830846910454>, BranchRadius(0.008339009542228819)
  <-0.9824052514081315, 2.5577221189135315, -0.16460113458974596>, BranchRadius(0.008273878192841111)
  <-0.984654290525524, 2.555367262311523, -0.16600808041446014>, BranchRadius(0.003547255716926197)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.9636972041919608, 2.555665876034807, -0.14193622652181723>, BranchRadius(0.013353202304094362)
  <-0.9727030046348624, 2.5583476851979325, -0.15130458421234844>, BranchRadius(0.013268860833640624)
  <-0.9776995303018272, 2.56024317686068, -0.1561472417429943>, BranchRadius(0.007211760488487165)
  <-0.9813088818198538, 2.561165327948725, -0.1600944990979465>, BranchRadius(0.005427579721762474)
  <-0.985830215129179, 2.560347105708616, -0.16289449328226027>, BranchRadius(0.0053806979064442905)
  <-0.9873417348012337, 2.5611505783550923, -0.16455376262795665>, BranchRadius(0.002383995548278499)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.9495361372977836, 2.5450993163917874, -0.11853264146018616>, BranchRadius(0.017012017674504696)
  <-0.9547059715667089, 2.5531846879054414, -0.13238062852277133>, BranchRadius(0.01684835791902248)
  <-0.9520501207171783, 2.559080776921026, -0.1378744212683098>, BranchRadius(0.008485232356605126)
  <-0.9484691955798333, 2.561262320679017, -0.13824198304296603>, BranchRadius(0.004209187530330086)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.9547059715667089, 2.5531846879054414, -0.13238062852277133>, BranchRadius(0.01684835791902248)
  <-0.9520501207171783, 2.559080776921026, -0.1378744212683098>, BranchRadius(0.008485232356605126)
  <-0.9545854433617025, 2.5615543889948116, -0.14251811556836436>, BranchRadius(0.005840420734482603)
  <-0.9559161972136264, 2.56378412745758, -0.14631361935361703>, BranchRadius(0.004598748570059906)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.9629706265196203, 2.5013389837132207, 0.03266774636457427>, BranchRadius(0.027295419589204714)
  <-0.9526765180775937, 2.5062787829404938, 0.00804791463098703>, BranchRadius(0.027138651396340936)
  <-0.9476253328197088, 2.5073569672834934, -0.0025166053023991993>, BranchRadius(0.011759508297963723)
  <-0.9496036623247076, 2.507715323454907, -0.0070244564786751>, BranchRadius(0.004935881785799891)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.9526765180775937, 2.5062787829404938, 0.00804791463098703>, BranchRadius(0.027138651396340936)
  <-0.9476253328197088, 2.5073569672834934, -0.0025166053023991993>, BranchRadius(0.011759508297963723)
  <-0.9443650692054715, 2.507914803528092, -0.007806270607115937>, BranchRadius(0.00623867447027267)
  <-0.9410664691948732, 2.508682592086145, -0.012971985332821267>, BranchRadius(0.006176962840034253)
  <-0.9405489643566459, 2.509890289681488, -0.015530322750103851>, BranchRadius(0.002876010271201204)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.9416875104022084, 2.522124377633226, 0.11760734588937777>, BranchRadius(0.041634240397112686)
  <-0.9604498618785791, 2.5022069946349035, 0.08667790378604692>, BranchRadius(0.04129598488047017)
  <-0.9698505843841523, 2.487567362838981, 0.08489601017660627>, BranchRadius(0.017489069374393446)
  <-0.9753435566983167, 2.482683393095594, 0.08403544549801066>, BranchRadius(0.007400437613043134)
  <-0.9774704607381659, 2.4808140587199747, 0.08212022933718169>, BranchRadius(0.003418506215483488)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-0.9604498618785791, 2.5022069946349035, 0.08667790378604692>, BranchRadius(0.04129598488047017)
  <-0.9698505843841523, 2.487567362838981, 0.08489601017660627>, BranchRadius(0.017489069374393446)
  <-0.9755569752536769, 2.477890962224125, 0.08377549811843193>, BranchRadius(0.011289427482715336)
  <-0.9814129186574045, 2.468855481261916, 0.0806168340306841>, BranchRadius(0.01122092456909541)
  <-0.9867345226045661, 2.4610934141713288, 0.07461013665641436>, BranchRadius(0.011164657067518145)
  <-0.992443830618375, 2.454008632912718, 0.06827473016199101>, BranchRadius(0.011087276443224757)
  <-0.9965219961930296, 2.45036221980434, 0.0659430424959223>, BranchRadius(0.005946808419929648)
  <-0.9997984534750414, 2.446219698751969, 0.06327576290403014>, BranchRadius(0.0059169277003790705)
  <-1.001430225520326, 2.4442159935147743, 0.061744895872073005>, BranchRadius(0.0030035093731946008)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.9867345226045661, 2.4610934141713288, 0.07461013665641436>, BranchRadius(0.011164657067518145)
  <-0.992443830618375, 2.454008632912718, 0.06827473016199101>, BranchRadius(0.011087276443224757)
  <-0.9940732360842915, 2.4502042117309735, 0.0637017975033244>, BranchRadius(0.006167681558022083)
  <-0.9957430899848171, 2.448325873698965, 0.061408746526139917>, BranchRadius(0.003402153523219783)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <-0.771472448791815, 2.517499001222768, 0.21409991143915008>, BranchRadius(0.10697671574640556)
  <-0.8647875248009951, 2.5322747744155536, 0.1657301388832323>, BranchRadius(0.10613982184437146)
  <-0.93070877657596, 2.539871616066659, 0.1260003254156642>, BranchRadius(0.07734197771467982)
  <-0.9874773493833456, 2.5465547398285038, 0.07502259531745012>, BranchRadius(0.07659023415403521)
  <-1.042201598226196, 2.5680696189095484, 0.0267092984324961>, BranchRadius(0.07610392952522153)
  <-1.0930639837269533, 2.6150340101181655, -0.003246867958457581>, BranchRadius(0.0754321430509975)
  <-1.1049364405061035, 2.6497493023132255, -0.01832000653437809>, BranchRadius(0.03966492466512548)
  <-1.1197204784491785, 2.6758737520086147, -0.043721782207589516>, BranchRadius(0.039323083006566915)
  <-1.130931303216924, 2.708633778720064, -0.06167348809268952>, BranchRadius(0.03900212412539964)
  <-1.1375458239910197, 2.7252483565660515, -0.07187844499680672>, BranchRadius(0.020589735974174656)
  <-1.1452341426908896, 2.728735522835496, -0.08173561385484493>, BranchRadius(0.012978226031218657)
  <-1.1556422951411778, 2.7326385652401393, -0.08821294289108164>, BranchRadius(0.012865425328552291)
  <-1.1604480648188642, 2.7370418682436126, -0.0863543011449586>, BranchRadius(0.006777835102434832)
  <-1.1637513608642394, 2.740278839428417, -0.08486116862402106>, BranchRadius(0.004859958018308912)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-1.1452341426908896, 2.728735522835496, -0.08173561385484493>, BranchRadius(0.012978226031218657)
  <-1.1556422951411778, 2.7326385652401393, -0.08821294289108164>, BranchRadius(0.012865425328552291)
  <-1.1633158933227095, 2.7354939782532326, -0.0930298131656658>, BranchRadius(0.009499459551422862)
  <-1.171023228011424, 2.7379431032618413, -0.09787093371094557>, BranchRadius(0.009425373703232565)
  <-1.1756094695393136, 2.735805560314049, -0.09712651405630475>, BranchRadius(0.005114377951228206)
  <-1.178465602983946, 2.7355205184644893, -0.09559934697176384>, BranchRadius(0.00325130533996006)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-1.130931303216924, 2.708633778720064, -0.06167348809268952>, BranchRadius(0.03900212412539964)
  <-1.1375458239910197, 2.7252483565660515, -0.07187844499680672>, BranchRadius(0.020589735974174656)
  <-1.1365699444706217, 2.7391212921775376, -0.07244058157216361>, BranchRadius(0.013918573233206447)
  <-1.135561546602819, 2.746796675707285, -0.07293943241173943>, BranchRadius(0.007757398452358205)
  <-1.135670359056081, 2.7542491017327437, -0.07100609122923969>, BranchRadius(0.0076998897357604705)
  <-1.1337235340053522, 2.7569071739126287, -0.06983359110415416>, BranchRadius(0.003497174864794504)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-1.1375458239910197, 2.7252483565660515, -0.07187844499680672>, BranchRadius(0.020589735974174656)
  <-1.1365699444706217, 2.7391212921775376, -0.07244058157216361>, BranchRadius(0.013918573233206447)
  <-1.1405539538743243, 2.742800839190613, -0.07088846952427318>, BranchRadius(0.0056409617051907356)
  <-1.1445679078677036, 2.7463552274288214, -0.06926895732666481>, BranchRadius(0.005600743001342142)
  <-1.1485398799931188, 2.748241542398168, -0.06586964854706708>, BranchRadius(0.005557881512564481)
  <-1.150399675644796, 2.750931661370537, -0.06319003557604327>, BranchRadius(0.004227990731538833)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <-1.1197204784491785, 2.6758737520086147, -0.043721782207589516>, BranchRadius(0.039323083006566915)
  <-1.130931303216924, 2.708633778720064, -0.06167348809268952>, BranchRadius(0.03900212412539964)
  <-1.1264221523309519, 2.7365988092447853, -0.06031553173645213>, BranchRadius(0.028358762656831814)
  <-1.119626189226598, 2.7613442532599386, -0.07196608487529454>, BranchRadius(0.02818257444705547)
  <-1.1206041600780083, 2.7792471129859457, -0.07419527455201193>, BranchRadius(0.018067598068644143)
  <-1.1258814992783153, 2.7963023406340994, -0.07571671342544399>, BranchRadius(0.017917753079307288)
  <-1.133998768784345, 2.8118927542054344, -0.07277686271801988>, BranchRadius(0.01782116106601162)
  <-1.1362197634861426, 2.827702723933336, -0.06513630890883397>, BranchRadius(0.017699322664261313)
  <-1.1347026221556185, 2.838717385873612, -0.051569098125057174>, BranchRadius(0.017541200184901407)
  <-1.132115400400144, 2.8497818503377825, -0.038429630426310465>, BranchRadius(0.017371289580721965)
  <-1.1323800126376173, 2.862772065390163, -0.027133293818984203>, BranchRadius(0.01721693722731601)
  <-1.1324390987508044, 2.870910497842677, -0.02287685515208999>, BranchRadius(0.009184489320475824)
  <-1.1359772111300717, 2.873378973845549, -0.0176311070421852>, BranchRadius(0.006791869125479884)
  <-1.1394346976187415, 2.875755388483709, -0.012358804998470991>, BranchRadius(0.00673785783405601)
  <-1.1445988276277181, 2.8769848042623414, -0.0083053183582854>, BranchRadius(0.00667910591685196)
  <-1.1467922863019646, 2.8775021144503357, -0.006315892368493893>, BranchRadius(0.003006108207481586)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-1.132115400400144, 2.8497818503377825, -0.038429630426310465>, BranchRadius(0.017371289580721965)
  <-1.1323800126376173, 2.862772065390163, -0.027133293818984203>, BranchRadius(0.01721693722731601)
  <-1.1326536627728307, 2.866406470063833, -0.018695377697495585>, BranchRadius(0.009191420467031992)
  <-1.1329917703795158, 2.869488241618021, -0.010137097824591927>, BranchRadius(0.00910251542425769)
  <-1.134936429152643, 2.8725018067442334, -0.0018352260135710528>, BranchRadius(0.009043469913724822)
  <-1.1380934608818785, 2.8767728318679886, 0.005374690481179641>, BranchRadius(0.008954965148364673)
  <-1.1417406701810453, 2.877460222000282, 0.013440942482354884>, BranchRadius(0.008879136343832486)
  <-1.145141091037718, 2.8769988857108286, 0.021578241230831328>, BranchRadius(0.008831269676349885)
  <-1.1497567973497789, 2.876592958095467, 0.023453061160948467>, BranchRadius(0.004998446934646485)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-1.1264221523309519, 2.7365988092447853, -0.06031553173645213>, BranchRadius(0.028358762656831814)
  <-1.119626189226598, 2.7613442532599386, -0.07196608487529454>, BranchRadius(0.02818257444705547)
  <-1.1143454637398331, 2.7781526411839605, -0.08057868926007529>, BranchRadius(0.019610836814366712)
  <-1.1014082752844787, 2.7814287204818795, -0.08326156744897167>, BranchRadius(0.01361254480514437)
  <-1.0897647049815664, 2.7875624669209818, -0.08617122852505099>, BranchRadius(0.013478193586519971)
  <-1.0830504250985824, 2.7911150229466046, -0.08782699550814128>, BranchRadius(0.007774559342144257)
  <-1.0764805434996783, 2.7937678390179657, -0.09083634586418834>, BranchRadius(0.007697854694493238)
  <-1.0754346521960338, 2.7971911976634503, -0.09412892056263804>, BranchRadius(0.004863570826000614)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-1.0830504250985824, 2.7911150229466046, -0.08782699550814128>, BranchRadius(0.007774559342144257)
  <-1.0764805434996783, 2.7937678390179657, -0.09083634586418834>, BranchRadius(0.007697854694493238)
  <-1.0711896103867602, 2.7937888873384327, -0.09127671563875862>, BranchRadius(0.005309269420129407)
  <-1.065965889531353, 2.7941291826702086, -0.09180678452689879>, BranchRadius(0.005261561889231904)
  <-1.0608809752686226, 2.795001792928776, -0.0910364042883044>, BranchRadius(0.0052164439453226425)
  <-1.0585856132467362, 2.795257608187046, -0.09042386070917804>, BranchRadius(0.002389422083728793)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-1.1014082752844787, 2.7814287204818795, -0.08326156744897167>, BranchRadius(0.01361254480514437)
  <-1.0897647049815664, 2.7875624669209818, -0.08617122852505099>, BranchRadius(0.013478193586519971)
  <-1.0843056945503318, 2.7886393554947086, -0.090095591635892>, BranchRadius(0.0068088993026979554)
  <-1.0784503573109752, 2.78943026504849, -0.0933664435596319>, BranchRadius(0.0067534424122732625)
  <-1.0745009462260333, 2.789783192130778, -0.09875760554221143>, BranchRadius(0.006692311481519997)
  <-1.0703820635963397, 2.789685602359111, -0.10395812878416422>, BranchRadius(0.00663476901412683)
  <-1.0678231388157187, 2.788531215721993, -0.10658536271886168>, BranchRadius(0.0038448748599217717)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <-1.119626189226598, 2.7613442532599386, -0.07196608487529454>, BranchRadius(0.02818257444705547)
  <-1.1143454637398331, 2.7781526411839605, -0.08057868926007529>, BranchRadius(0.019610836814366712)
  <-1.1137304416039535, 2.7852224948730377, -0.0840658288748748>, BranchRadius(0.007907036493256116)
  <-1.1137452400420793, 2.7930597036437983, -0.08387616523542342>, BranchRadius(0.007839517370756305)
  <-1.1140031625656364, 2.800466378690276, -0.08156593365922882>, BranchRadius(0.007762894383406257)
  <-1.1162701386609828, 2.807658446377193, -0.08008055933370627>, BranchRadius(0.007685789166831818)
  <-1.1187420934740573, 2.811498173338261, -0.08326766932181541>, BranchRadius(0.005568817990358494)
  <-1.121883150377123, 2.8139583983391683, -0.08709113089632911>, BranchRadius(0.005526102056166571)
  <-1.1245493091025047, 2.815851682041917, -0.09150529549936287>, BranchRadius(0.0054934301370545245)
  <-1.125448158664816, 2.8175377026651676, -0.0965991225289153>, BranchRadius(0.005440374057423997)
  <-1.1251546614400574, 2.81790851151587, -0.10197866300407468>, BranchRadius(0.005400286617261957)
  <-1.125643595672341, 2.8180040283953933, -0.10732605539088905>, BranchRadius(0.0053705479698381645)
  <-1.1260254613256282, 2.818183043740136, -0.11264632850308946>, BranchRadius(0.005336962980873727)
  <-1.1269886672199971, 2.8199029070196184, -0.11755549204327821>, BranchRadius(0.00529014006992049)
  <-1.128000128546298, 2.8211095182395685, -0.12146365874943915>, BranchRadius(0.004213399061785649)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <-1.042201598226196, 2.5680696189095484, 0.0267092984324961>, BranchRadius(0.07610392952522153)
  <-1.0930639837269533, 2.6150340101181655, -0.003246867958457581>, BranchRadius(0.0754321430509975)
  <-1.1440433538810821, 2.604544111831951, -0.013689231350411446>, BranchRadius(0.05308462207246484)
  <-1.1608746970541846, 2.5933860278556415, -0.028289814185153507>, BranchRadius(0.024919349312276948)
  <-1.1721469959718638, 2.589447112806351, -0.04991566777862519>, BranchRadius(0.02470338677795643)
  <-1.1823739256031496, 2.5851163346673354, -0.07175064908334537>, BranchRadius(0.02449718631904747)
  <-1.1775329276489443, 2.586397419521842, -0.08311548428229441>, BranchRadius(0.012419175443496067)
  <-1.1716986376483252, 2.59218233519819, -0.0923151274702329>, BranchRadius(0.01233440813250338)
  <-1.1633532808811344, 2.59376095327928, -0.10112617925802675>, BranchRadius(0.012238122741042726)
  <-1.1551299796161905, 2.5942123401234203, -0.11007196595713829>, BranchRadius(0.012159503832109755)
  <-1.145447581947965, 2.5983522360498803, -0.11594066701565542>, BranchRadius(0.012055256737283407)
  <-1.1390542435179403, 2.6062916027546765, -0.12218210579388245>, BranchRadius(0.011952567840276523)
  <-1.129678121420942, 2.6122634561670224, -0.12625066351574882>, BranchRadius(0.01183756143352707)
  <-1.1187798249885637, 2.616555504583866, -0.12705843226021213>, BranchRadius(0.011740827700168849)
  <-1.108966736384975, 2.6198564027303908, -0.13235627795792448>, BranchRadius(0.011630124915596689)
  <-1.1031550244169717, 2.613974639935746, -0.13615561823898784>, BranchRadius(0.009099786598751047)
  <-1.0996161719208681, 2.613854331839033, -0.1381160075388423>, BranchRadius(0.004047354349979257)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <-1.1721469959718638, 2.589447112806351, -0.04991566777862519>, BranchRadius(0.02470338677795643)
  <-1.1823739256031496, 2.5851163346673354, -0.07175064908334537>, BranchRadius(0.02449718631904747)
  <-1.1926265964207765, 2.581420790188145, -0.07540535047545839>, BranchRadius(0.011494831454084226)
  <-1.2029681454083994, 2.5779809057007044, -0.07870263678594736>, BranchRadius(0.011386506828860145)
  <-1.2127429238066874, 2.5742308870719945, -0.08303005885380337>, BranchRadius(0.011328526568123247)
  <-1.2227764343446237, 2.572977593297551, -0.08789186426907551>, BranchRadius(0.0112195913872078)
  <-1.2316937254448603, 2.575584322177857, -0.09402233766760273>, BranchRadius(0.011130849927648408)
  <-1.2388797237325093, 2.579642489600255, -0.10135893929956714>, BranchRadius(0.011042328455740297)
  <-1.238070622658268, 2.579715187753629, -0.1100160223888963>, BranchRadius(0.008695114558497257)
  <-1.2370892582485888, 2.58041319092731, -0.11854497545745889>, BranchRadius(0.008613554723852267)
  <-1.236117835034342, 2.5820981549088953, -0.12688110455931514>, BranchRadius(0.008560012563263676)
  <-1.2342791233423254, 2.5851856117975616, -0.13455706137639428>, BranchRadius(0.008475468351860808)
  <-1.2322945824617282, 2.5910762707342587, -0.1402538145026422>, BranchRadius(0.0084315634016871)
  <-1.2316712249261215, 2.5930161166504795, -0.14556889358765945>, BranchRadius(0.0056922440632727975)
  <-1.2291667154159445, 2.5943353733569943, -0.15046644449468383>, BranchRadius(0.005656766835494135)
  <-1.226674266291832, 2.593090840756202, -0.15232318019235966>, BranchRadius(0.0033479294320142364)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-1.2342791233423254, 2.5851856117975616, -0.13455706137639428>, BranchRadius(0.008475468351860808)
  <-1.2322945824617282, 2.5910762707342587, -0.1402538145026422>, BranchRadius(0.0084315634016871)
  <-1.230133251608299, 2.5973515550470134, -0.14094079031556994>, BranchRadius(0.006672516768914124)
  <-1.22848498613544, 2.6037504660635533, -0.14073347687140997>, BranchRadius(0.006611037749910579)
  <-1.2282054284765616, 2.6102751948016243, -0.14144594605114091>, BranchRadius(0.006569463442482469)
  <-1.2276119137088333, 2.616467145858218, -0.14343137851346888>, BranchRadius(0.006529506851917078)
  <-1.2258442317004, 2.6181768139320547, -0.14495601240736783>, BranchRadius(0.0028934707733207403)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <-1.2316937254448603, 2.575584322177857, -0.09402233766760273>, BranchRadius(0.011130849927648408)
  <-1.2388797237325093, 2.579642489600255, -0.10135893929956714>, BranchRadius(0.011042328455740297)
  <-1.2454905468298514, 2.5829199115079744, -0.09994477411240406>, BranchRadius(0.0075129447996196965)
  <-1.251784686605169, 2.5863924962452036, -0.10190726393812159>, BranchRadius(0.0074516042960234745)
  <-1.257933172186306, 2.589515212826911, -0.10462540758404004>, BranchRadius(0.007412390887626481)
  <-1.262198811713867, 2.591965776277109, -0.10647968335962302>, BranchRadius(0.005257307338785522)
  <-1.2659242485489721, 2.594238222593126, -0.10935592266348108>, BranchRadius(0.005226437065974826)
  <-1.2695845116327418, 2.5966572996076835, -0.11214127261262244>, BranchRadius(0.0051968869319958385)
  <-1.2731011949732767, 2.5970427066636366, -0.11589774545821976>, BranchRadius(0.005160105479162601)
  <-1.2749034887172284, 2.5978201348598002, -0.12062660148353452>, BranchRadius(0.005120032875659474)
  <-1.2762577814982652, 2.5979717781770937, -0.12552552342305737>, BranchRadius(0.005084932723447447)
  <-1.2763831314132474, 2.5986806028686846, -0.12747329907175564>, BranchRadius(0.0020765295620955916)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-1.0930639837269533, 2.6150340101181655, -0.003246867958457581>, BranchRadius(0.0754321430509975)
  <-1.1440433538810821, 2.604544111831951, -0.013689231350411446>, BranchRadius(0.05308462207246484)
  <-1.178473487151366, 2.6058737177955416, -0.008545982888253265>, BranchRadius(0.03483755062818586)
  <-1.1942004768694434, 2.6076190165563244, -0.005088212962977765>, BranchRadius(0.016196927060805152)
  <-1.1975456086698264, 2.6126615681430665, -9.897256792349568E-4>, BranchRadius(0.00730854508653332)
  <-1.2008747632150796, 2.6176350009248637, 0.0030959559871793036>, BranchRadius(0.007246454188119032)
  <-1.2034924190609395, 2.62048289723431, 0.005668720430262744>, BranchRadius(0.0046456164710742135)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-1.178473487151366, 2.6058737177955416, -0.008545982888253265>, BranchRadius(0.03483755062818586)
  <-1.1942004768694434, 2.6076190165563244, -0.005088212962977765>, BranchRadius(0.016196927060805152)
  <-1.1996342148894128, 2.6036570665159613, -0.007179981177095876>, BranchRadius(0.007042588391606329)
  <-1.2045351073999464, 2.598857092476839, -0.008458170512738531>, BranchRadius(0.006977984390481497)
  <-1.2099782704710607, 2.595106425981112, -0.01052605076085432>, BranchRadius(0.006926157094771684)
  <-1.2158560023542526, 2.5916484280362653, -0.009744526521731163>, BranchRadius(0.00686412864197581)
  <-1.220548047606416, 2.587118335495044, -0.007800193284594115>, BranchRadius(0.006805693118075055)
  <-1.2232534084537667, 2.5847389948957904, -0.005850075702481343>, BranchRadius(0.0040967301089649254)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  18
  <-1.1440433538810821, 2.604544111831951, -0.013689231350411446>, BranchRadius(0.05308462207246484)
  <-1.178473487151366, 2.6058737177955416, -0.008545982888253265>, BranchRadius(0.03483755062818586)
  <-1.193677744362263, 2.5941624684620797, -0.01825406303180518>, BranchRadius(0.021507431700676184)
  <-1.2090691828625408, 2.5847444089101415, -0.029607279731118312>, BranchRadius(0.0213188122148784)
  <-1.2267142873739327, 2.5809701469246926, -0.040739484161763276>, BranchRadius(0.02120190421255632)
  <-1.244701759030042, 2.5818548066488223, -0.05154435799727686>, BranchRadius(0.021001834634340723)
  <-1.2574451217102882, 2.5765804003026496, -0.0671912937329097>, BranchRadius(0.020857594602922472)
  <-1.2740177549242508, 2.574870670117619, -0.0795347277994001>, BranchRadius(0.020734891210323143)
  <-1.2934492983344992, 2.5719888369768897, -0.08569877851929646>, BranchRadius(0.020588476457300615)
  <-1.3133791488990216, 2.571247561222922, -0.09027750116511435>, BranchRadius(0.020462481138291567)
  <-1.331320307130956, 2.5628172161645217, -0.09459113684851292>, BranchRadius(0.020287023668248853)
  <-1.3506593321184928, 2.557153235935077, -0.09368048768402402>, BranchRadius(0.020171956806638663)
  <-1.3703479297451868, 2.5560861814715676, -0.09692576427093588>, BranchRadius(0.019982775129083554)
  <-1.3899684839716864, 2.557241236971662, -0.09965669277102496>, BranchRadius(0.019843343262563144)
  <-1.4067405665539436, 2.5673176559481186, -0.1018513562119844>, BranchRadius(0.01968891874009945)
  <-1.4081057441961287, 2.578213331790087, -0.10206056111550685>, BranchRadius(0.010982860681062738)
  <-1.4107755200267844, 2.588408383254768, -0.09917357253767257>, BranchRadius(0.010927098443868886)
  <-1.410141413620616, 2.591536318552517, -0.0960364926008336>, BranchRadius(0.0044751916932532455)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-1.4081057441961287, 2.578213331790087, -0.10206056111550685>, BranchRadius(0.010982860681062738)
  <-1.4107755200267844, 2.588408383254768, -0.09917357253767257>, BranchRadius(0.010927098443868886)
  <-1.4134065493559795, 2.5937285486484956, -0.09958469192480757>, BranchRadius(0.005949411256433534)
  <-1.417035527183729, 2.5964744592712936, -0.0990811311051202>, BranchRadius(0.004578545481025092)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-1.3899684839716864, 2.557241236971662, -0.09965669277102496>, BranchRadius(0.019843343262563144)
  <-1.4067405665539436, 2.5673176559481186, -0.1018513562119844>, BranchRadius(0.01968891874009945)
  <-1.4178579947150223, 2.5634721613369034, -0.10327416459902952>, BranchRadius(0.011849448148663896)
  <-1.423540260630589, 2.5598131827072277, -0.09773485499718602>, BranchRadius(0.008738433578892162)
  <-1.4269011359338737, 2.555386977794655, -0.09109666638037721>, BranchRadius(0.008657500842890036)
  <-1.428899615463122, 2.5485753769383175, -0.08628015168435406>, BranchRadius(0.008578498730657398)
  <-1.4312809489145444, 2.546081101615828, -0.08724278001470427>, BranchRadius(0.0035803368128762224)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-1.4269011359338737, 2.555386977794655, -0.09109666638037721>, BranchRadius(0.008657500842890036)
  <-1.428899615463122, 2.5485753769383175, -0.08628015168435406>, BranchRadius(0.008578498730657398)
  <-1.427011092596575, 2.5464195796519626, -0.08058903568464215>, BranchRadius(0.006372031220851167)
  <-1.4251191642683319, 2.544066260432303, -0.07504920740641602>, BranchRadius(0.006309294849748377)
  <-1.4209147714823016, 2.5433670717334396, -0.07345537054385323>, BranchRadius(0.004550395530094663)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-1.4067405665539436, 2.5673176559481186, -0.1018513562119844>, BranchRadius(0.01968891874009945)
  <-1.4178579947150223, 2.5634721613369034, -0.10327416459902952>, BranchRadius(0.011849448148663896)
  <-1.424183324729789, 2.562121518588901, -0.10718189304796638>, BranchRadius(0.007556743826481801)
  <-1.42924695541574, 2.5599320462738677, -0.11228526621581363>, BranchRadius(0.007515222048103828)
  <-1.4347103044420177, 2.5613902963100403, -0.11714814022985603>, BranchRadius(0.00745803053274618)
  <-1.4408990812458387, 2.5624142873244886, -0.12107491736547582>, BranchRadius(0.0074006144743533715)
  <-1.4449313895034521, 2.562758422121541, -0.12209018408248405>, BranchRadius(0.00417237404239167)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  32
  <-0.13356186916662127, 1.8923576631223678, -0.023425641034545138>, BranchRadius(0.45585923359336694)
  <-0.21426274790908323, 2.108061895037176, 0.14031966706284293>, BranchRadius(0.2825835689131119)
  <-0.14297050518255044, 2.2221579580093174, 0.2800929406012852>, BranchRadius(0.19400274084242689)
  <-0.028108250794599554, 2.2279153810901047, 0.3075907728414121>, BranchRadius(0.11824811280320577)
  <0.08302393468849811, 2.2617343791194022, 0.3233148807782122>, BranchRadius(0.11722343984188217)
  <0.1896718068238818, 2.2550571059677122, 0.3691194592175942>, BranchRadius(0.1162601135977293)
  <0.28836468453813546, 2.2963350183829094, 0.4131126660859772>, BranchRadius(0.11567001519599478)
  <0.3604780443461617, 2.345652559991822, 0.4876934614005953>, BranchRadius(0.11486884522319199)
  <0.3722166997027725, 2.366624950752886, 0.5317024318836331>, BranchRadius(0.05014405933700354)
  <0.3906987868192775, 2.4036746121282992, 0.5591679408466912>, BranchRadius(0.04968520036001365)
  <0.41091422776162634, 2.4404335931286174, 0.5848987241393825>, BranchRadius(0.049213412252462084)
  <0.42291582317438514, 2.4871602296431776, 0.5928588078103022>, BranchRadius(0.048895600870256496)
  <0.43086239405275045, 2.528456541480379, 0.6168539591992656>, BranchRadius(0.04841797858502072)
  <0.4394042112590604, 2.5695167943220185, 0.6401615401051425>, BranchRadius(0.047980728759465095)
  <0.43575772496737264, 2.5992539005687445, 0.6773167697875535>, BranchRadius(0.0477294819053931)
  <0.4320824613406759, 2.5940888969270035, 0.6959026138230775>, BranchRadius(0.019637169446173827)
  <0.4308596998564936, 2.5894251806899478, 0.7105017887117545>, BranchRadius(0.015374696817080903)
  <0.4324878661079186, 2.583122606780984, 0.7242765616376595>, BranchRadius(0.015235410476271269)
  <0.4326730482567525, 2.575779593210321, 0.7374784962310822>, BranchRadius(0.015107786659077416)
  <0.4273794295786167, 2.571541915703063, 0.7442203647634422>, BranchRadius(0.009562065711584336)
  <0.4258854441897683, 2.568507268122365, 0.7530954556478602>, BranchRadius(0.009497805877559608)
  <0.424444371266075, 2.5651985834501505, 0.761808372137026>, BranchRadius(0.00943074754082232)
  <0.42693420273812765, 2.5631631834635566, 0.7706001113523446>, BranchRadius(0.009361452467155983)
  <0.42658370973647763, 2.5640849386186733, 0.779845853891833>, BranchRadius(0.009298184393562791)
  <0.42826783269126456, 2.5638821351204477, 0.7864638555795503>, BranchRadius(0.006831935723084753)
  <0.43226517624983707, 2.5625127250143698, 0.7917486054390147>, BranchRadius(0.006766285586715811)
  <0.43500180780917574, 2.5626235396747057, 0.7978944896907662>, BranchRadius(0.006728545564714617)
  <0.4353857191635032, 2.565021889014857, 0.8040974542294059>, BranchRadius(0.006661549110605462)
  <0.433525674915439, 2.5681159149721595, 0.8096172790176229>, BranchRadius(0.006595545991184705)
  <0.43150844733713695, 2.5716483459326382, 0.8147333669950956>, BranchRadius(0.006536178683791554)
  <0.4292184262663452, 2.5746703591123175, 0.8199917061730916>, BranchRadius(0.006482815057802673)
  <0.4255982822973047, 2.576587158490642, 0.8227505858762305>, BranchRadius(0.004938722449147996)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.4324878661079186, 2.583122606780984, 0.7242765616376595>, BranchRadius(0.015235410476271269)
  <0.4326730482567525, 2.575779593210321, 0.7374784962310822>, BranchRadius(0.015107786659077416)
  <0.439084343825165, 2.5738705673997337, 0.7419440591904088>, BranchRadius(0.00804303070706207)
  <0.4435679239456489, 2.5732694205049977, 0.7485023464842538>, BranchRadius(0.007967119963604061)
  <0.44576415869565944, 2.5715114295509722, 0.7558837651142373>, BranchRadius(0.007899324038337423)
  <0.44809024491948996, 2.570227129275136, 0.7632519958453761>, BranchRadius(0.007832683347774594)
  <0.45093674603700173, 2.5684611682344896, 0.7702617634458513>, BranchRadius(0.007769042979785117)
  <0.452836323957153, 2.569362712804707, 0.7776601602769346>, BranchRadius(0.0076913883374199144)
  <0.45272184870261606, 2.566942639825471, 0.7799366272771737>, BranchRadius(0.003324478878246699)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.45093674603700173, 2.5684611682344896, 0.7702617634458513>, BranchRadius(0.007769042979785117)
  <0.452836323957153, 2.569362712804707, 0.7776601602769346>, BranchRadius(0.0076913883374199144)
  <0.45459111564247384, 2.571340389399926, 0.783177244016431>, BranchRadius(0.006117900911486005)
  <0.45701601689392857, 2.572937333103357, 0.7884931685887298>, BranchRadius(0.006057179981608955)
  <0.45975406685307496, 2.572005611423739, 0.7913156742269477>, BranchRadius(0.004041232602167806)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <0.43575772496737264, 2.5992539005687445, 0.6773167697875535>, BranchRadius(0.0477294819053931)
  <0.4320824613406759, 2.5940888969270035, 0.6959026138230775>, BranchRadius(0.019637169446173827)
  <0.42642710258031563, 2.592558541023082, 0.7061654937037065>, BranchRadius(0.011817435227039437)
  <0.42501144885716474, 2.5939597365961253, 0.7177491018629643>, BranchRadius(0.0117536123164332)
  <0.42098271092404466, 2.597030312505976, 0.7282421169877032>, BranchRadius(0.011651717991777713)
  <0.41526104148271653, 2.5994956429959646, 0.7379785722319567>, BranchRadius(0.011559148599444838)
  <0.40842308484512607, 2.605559245542584, 0.7448909047525055>, BranchRadius(0.011458851063504437)
  <0.4046568074215672, 2.6154407596246836, 0.7490683985127432>, BranchRadius(0.011370163600527597)
  <0.40396480189958156, 2.6250065442214767, 0.7550117787920685>, BranchRadius(0.01128303486387317)
  <0.4061807256726984, 2.6321616291769696, 0.7633536911462057>, BranchRadius(0.01121129165674908)
  <0.4032310369237477, 2.6392273172784586, 0.7714353906836982>, BranchRadius(0.01113276602994575)
  <0.4025043182854399, 2.648343361629098, 0.7776546335969017>, BranchRadius(0.011059356536232934)
  <0.39794416235181573, 2.656576670129888, 0.7832546224830084>, BranchRadius(0.0109518156728766)
  <0.3927227804485839, 2.6643669629711564, 0.7887723855670421>, BranchRadius(0.01088104778886868)
  <0.38800142378378827, 2.664384047029204, 0.7905806274062326>, BranchRadius(0.0050558124144640115)
  <0.38340589038574535, 2.664701662937154, 0.7925901435800441>, BranchRadius(0.005025730029589783)
  <0.37876975665977625, 2.6662982186196262, 0.7934573093922428>, BranchRadius(0.004979427930811797)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.39794416235181573, 2.656576670129888, 0.7832546224830084>, BranchRadius(0.0109518156728766)
  <0.3927227804485839, 2.6643669629711564, 0.7887723855670421>, BranchRadius(0.01088104778886868)
  <0.39041919621821025, 2.6684898661325898, 0.7915172533772811>, BranchRadius(0.005462520487894752)
  <0.38666786736688546, 2.6712366660911893, 0.7943015280353916>, BranchRadius(0.005419369293113335)
  <0.38284329901262226, 2.673500959603524, 0.7973172031731702>, BranchRadius(0.005371093440171194)
  <0.38031511579412625, 2.6721335554299452, 0.798276658118667>, BranchRadius(0.003030191141272135)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  27
  <0.4394042112590604, 2.5695167943220185, 0.6401615401051425>, BranchRadius(0.047980728759465095)
  <0.43575772496737264, 2.5992539005687445, 0.6773167697875535>, BranchRadius(0.0477294819053931)
  <0.43744255676092514, 2.635906986136717, 0.6872020690404026>, BranchRadius(0.03800008527811541)
  <0.4324909165435831, 2.6724897038645072, 0.6948272304463625>, BranchRadius(0.03769558414005716)
  <0.42598648612508094, 2.7086698906461764, 0.7014959820489828>, BranchRadius(0.0373602165218973)
  <0.4221485241099727, 2.7367853558364295, 0.7074368743430727>, BranchRadius(0.028991439021609694)
  <0.4223665580614475, 2.765360974741044, 0.7107429420538135>, BranchRadius(0.028767057866486135)
  <0.4167165760198743, 2.793274224510078, 0.7135863753161684>, BranchRadius(0.028620917568380606)
  <0.4096580912476779, 2.8199134357197613, 0.720180609284077>, BranchRadius(0.028336437722073837)
  <0.40884108291189175, 2.842898528463293, 0.7364057009982485>, BranchRadius(0.02814667994955691)
  <0.40474898557257183, 2.8567891693434917, 0.7603657772157275>, BranchRadius(0.02799607860119917)
  <0.40205224280931756, 2.87061877473351, 0.7843259920790122>, BranchRadius(0.0277960843118156)
  <0.3899618590418221, 2.889209599814854, 0.8006325146230086>, BranchRadius(0.027526329837599096)
  <0.3789016649885276, 2.9081234755763337, 0.816967977071713>, BranchRadius(0.02732965280112893)
  <0.3743571377741337, 2.9284006537677274, 0.8343716609560378>, BranchRadius(0.02710544033498444)
  <0.36385172084271344, 2.9482163586863472, 0.8491077158796128>, BranchRadius(0.026836118591096508)
  <0.3589440471028953, 2.9620613107129725, 0.8627396830574626>, BranchRadius(0.02003992233752485)
  <0.3510520551258676, 2.977985448157709, 0.8716667898750604>, BranchRadius(0.019888562714714255)
  <0.33810456917488724, 2.9882218447655506, 0.8824336766594492>, BranchRadius(0.019706523259867763)
  <0.3369513495180884, 2.9915879674148123, 0.894502844366869>, BranchRadius(0.012582746378137144)
  <0.33613325910883524, 2.991436505205496, 0.9069575240607557>, BranchRadius(0.012482438022913503)
  <0.33833283014003385, 2.989572038010908, 0.9125128333040022>, BranchRadius(0.0062590583500302345)
  <0.3427578084591881, 2.988451016260461, 0.9167299501508206>, BranchRadius(0.006214595512958155)
  <0.34778331679305324, 2.986919288733634, 0.9199473636822887>, BranchRadius(0.006160655246210483)
  <0.3529292579585366, 2.9855420251278977, 0.9229337239949778>, BranchRadius(0.006107038024730729)
  <0.3580986308501085, 2.984246060740047, 0.9258177633893389>, BranchRadius(0.006059671857033391)
  <0.35948730451986544, 2.980534771982693, 0.9267056888105906>, BranchRadius(0.004060848477257262)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.3369513495180884, 2.9915879674148123, 0.894502844366869>, BranchRadius(0.012582746378137144)
  <0.33613325910883524, 2.991436505205496, 0.9069575240607557>, BranchRadius(0.012482438022913503)
  <0.33374571552661003, 2.9926623606977754, 0.9146411046311032>, BranchRadius(0.008138826477201622)
  <0.33193624956435397, 2.991127444625169, 0.9223566081817036>, BranchRadius(0.008072120505656224)
  <0.3300286160906684, 2.9863753168130827, 0.9285387142775986>, BranchRadius(0.008027466598699382)
  <0.32767688882814694, 2.979539642884829, 0.9318541851816216>, BranchRadius(0.007952949546307726)
  <0.3268988528317828, 2.9723841726632316, 0.93508261153615>, BranchRadius(0.00788852526334392)
  <0.3263784352513085, 2.9702255233065493, 0.939506146543649>, BranchRadius(0.004949572048747199)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.32767688882814694, 2.979539642884829, 0.9318541851816216>, BranchRadius(0.007952949546307726)
  <0.3268988528317828, 2.9723841726632316, 0.93508261153615>, BranchRadius(0.00788852526334392)
  <0.3263531492849926, 2.966697765473838, 0.9367716795834319>, BranchRadius(0.005957010152158237)
  <0.3245488292431502, 2.96167150467685, 0.9393385725659928>, BranchRadius(0.0059251842162628765)
  <0.32465239841358956, 2.9578385600685664, 0.9383176484298278>, BranchRadius(0.003967931077405688)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.3510520551258676, 2.977985448157709, 0.8716667898750604>, BranchRadius(0.019888562714714255)
  <0.33810456917488724, 2.9882218447655506, 0.8824336766594492>, BranchRadius(0.019706523259867763)
  <0.3300624063797986, 2.9924749092186214, 0.8795920981046125>, BranchRadius(0.009530976253668265)
  <0.3218286274616482, 2.9969282579811987, 0.8782057659333444>, BranchRadius(0.009463051693994903)
  <0.3160996621930331, 3.00015729834258, 0.8762880089432891>, BranchRadius(0.006850221644394781)
  <0.31046136779180206, 3.0035288342304476, 0.8745120451483503>, BranchRadius(0.006805267474468881)
  <0.3042719371900413, 3.004828393567045, 0.8721094422643402>, BranchRadius(0.006765382935326247)
  <0.3014312753316073, 3.0079976897719587, 0.8708056895122027>, BranchRadius(0.004451243586588762)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <0.3743571377741337, 2.9284006537677274, 0.8343716609560378>, BranchRadius(0.02710544033498444)
  <0.36385172084271344, 2.9482163586863472, 0.8491077158796128>, BranchRadius(0.026836118591096508)
  <0.3499337111104984, 2.9586955454322745, 0.8454309670151792>, BranchRadius(0.0178056966158071)
  <0.33880610881177126, 2.9667472672579516, 0.8343092909597871>, BranchRadius(0.017673297246348918)
  <0.33508178617795265, 2.963175671014335, 0.8251749873083928>, BranchRadius(0.010491062005539127)
  <0.33264482224317865, 2.9606524731647226, 0.8153508816188635>, BranchRadius(0.010431604536538021)
  <0.332427689623005, 2.9590408697883746, 0.8082140035655291>, BranchRadius(0.007319797836386316)
  <0.33336644154739864, 2.9576145104357807, 0.8011685888449134>, BranchRadius(0.007249387888901604)
  <0.33333459364416745, 2.954741975701507, 0.7945650116610452>, BranchRadius(0.007201368044465785)
  <0.3316563583086022, 2.9520027541247997, 0.7881870658294362>, BranchRadius(0.007141288519502342)
  <0.3326876133948839, 2.9477025145292792, 0.7826479456560684>, BranchRadius(0.00708783464302565)
  <0.334615955439705, 2.9421603096202262, 0.7787419221983937>, BranchRadius(0.007049223896831475)
  <0.33827697921812244, 2.9375762255641447, 0.774946309632965>, BranchRadius(0.006987388388103261)
  <0.34193931107211534, 2.9330723108238446, 0.7711717596720998>, BranchRadius(0.006924243641274424)
  <0.3462219082923272, 2.9305479642365997, 0.7705000154033901>, BranchRadius(0.005016393625468895)
  <0.35052938255124344, 2.9280827479370486, 0.7701304932418985>, BranchRadius(0.004976763257643547)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <0.33508178617795265, 2.963175671014335, 0.8251749873083928>, BranchRadius(0.010491062005539127)
  <0.33264482224317865, 2.9606524731647226, 0.8153508816188635>, BranchRadius(0.010431604536538021)
  <0.3263234145961165, 2.958925595798301, 0.8116224425387871>, BranchRadius(0.00753946669551864)
  <0.3193948722889464, 2.9570254705507084, 0.8094827153889325>, BranchRadius(0.007496239506219811)
  <0.3120615134640465, 2.9565560798405035, 0.8083226932845343>, BranchRadius(0.007439363586776515)
  <0.3049633357816953, 2.956485026944298, 0.806289483672603>, BranchRadius(0.007383976994163559)
  <0.2990570646628308, 2.958309910325062, 0.8023493566082333>, BranchRadius(0.007330677947250176)
  <0.2932357803367982, 2.960705838837885, 0.798672030058663>, BranchRadius(0.007290442729714227)
  <0.28749944852335013, 2.9606374391335284, 0.7942441850839169>, BranchRadius(0.007246791863570876)
  <0.28213454372404434, 2.961366198241309, 0.7894850110031991>, BranchRadius(0.007208538775186276)
  <0.27969350827779993, 2.9612633863388758, 0.7859694640223548>, BranchRadius(0.0042811557915622645)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.3499337111104984, 2.9586955454322745, 0.8454309670151792>, BranchRadius(0.0178056966158071)
  <0.33880610881177126, 2.9667472672579516, 0.8343092909597871>, BranchRadius(0.017673297246348918)
  <0.33414578491373675, 2.9706978425838293, 0.8301510255831964>, BranchRadius(0.007390320370740343)
  <0.33105495341772617, 2.973393841942673, 0.8273841521178101>, BranchRadius(0.004947447892911701)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  19
  <0.4324909165435831, 2.6724897038645072, 0.6948272304463625>, BranchRadius(0.03769558414005716)
  <0.42598648612508094, 2.7086698906461764, 0.7014959820489828>, BranchRadius(0.0373602165218973)
  <0.41788306765251904, 2.726051673217193, 0.7015953411036998>, BranchRadius(0.019178154981887977)
  <0.4082318300338933, 2.7424076396222308, 0.6998330051713226>, BranchRadius(0.019072751572661074)
  <0.39924530667477237, 2.758245131961007, 0.6947929389249292>, BranchRadius(0.018894074029516875)
  <0.3900572920913105, 2.7727545042214876, 0.6872576353287083>, BranchRadius(0.018754260733666223)
  <0.3778531433667453, 2.7867164576547876, 0.688223923667282>, BranchRadius(0.01856908998627025)
  <0.3648296356162672, 2.799666961419206, 0.6894323211525586>, BranchRadius(0.018406181743137205)
  <0.35811636179291534, 2.8073905913820343, 0.6904017932002654>, BranchRadius(0.010279220849913133)
  <0.35590054228970397, 2.8172645005317127, 0.6917971182465644>, BranchRadius(0.010215227356830975)
  <0.35255198110380853, 2.8266584699583124, 0.6934944612362959>, BranchRadius(0.010116347998579509)
  <0.35008581252071386, 2.836335486131722, 0.6944220729412955>, BranchRadius(0.010029311690037816)
  <0.3510353543827723, 2.846227030061509, 0.6937928534962778>, BranchRadius(0.009956916599665584)
  <0.3510061583049577, 2.855974178097429, 0.6923104220364937>, BranchRadius(0.009859277370986843)
  <0.3516154366443358, 2.8641090297540828, 0.6869490787456408>, BranchRadius(0.00976171262909185)
  <0.3557482454788367, 2.8719299628968233, 0.6830405965628904>, BranchRadius(0.009670746458191444)
  <0.3583458074362372, 2.877788845428379, 0.6808297871580106>, BranchRadius(0.006779491932719277)
  <0.359963348146471, 2.882374540857716, 0.6761693548747761>, BranchRadius(0.006735329953797149)
  <0.3617128934097414, 2.8845955895061683, 0.6720862318642332>, BranchRadius(0.004966473522153155)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.3516154366443358, 2.8641090297540828, 0.6869490787456408>, BranchRadius(0.00976171262909185)
  <0.3557482454788367, 2.8719299628968233, 0.6830405965628904>, BranchRadius(0.009670746458191444)
  <0.358431622513624, 2.8762453772029763, 0.6803041782367003>, BranchRadius(0.005771594077937471)
  <0.36041942077722916, 2.8809824281157166, 0.677801606284036>, BranchRadius(0.005714355577398769)
  <0.36224016311890944, 2.8863449109594326, 0.6774938199318512>, BranchRadius(0.005671512793120129)
  <0.360842704271662, 2.890525796092657, 0.6775488606016259>, BranchRadius(0.004408596284793745)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.3778531433667453, 2.7867164576547876, 0.688223923667282>, BranchRadius(0.01856908998627025)
  <0.3648296356162672, 2.799666961419206, 0.6894323211525586>, BranchRadius(0.018406181743137205)
  <0.3536255403458869, 2.8086822998133223, 0.6897688393853553>, BranchRadius(0.014384760050455853)
  <0.3431180065823414, 2.8182914555334926, 0.6892210379529222>, BranchRadius(0.01424935878753512)
  <0.33626266891691103, 2.825775779416452, 0.6902520386422302>, BranchRadius(0.010201652852036103)
  <0.3308735471706209, 2.8323032866938083, 0.6957721501762705>, BranchRadius(0.010105573501811863)
  <0.3244373403322578, 2.8382664035395986, 0.7006219937885303>, BranchRadius(0.010025193466767586)
  <0.3160182119316139, 2.8412592053176233, 0.7050332127543553>, BranchRadius(0.00996480999686047)
  <0.30774803799829364, 2.8418581263551337, 0.7103916254107102>, BranchRadius(0.009872541187167927)
  <0.30543133921914256, 2.841892098590465, 0.7139088824112256>, BranchRadius(0.004211810080448595)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.3536255403458869, 2.8086822998133223, 0.6897688393853553>, BranchRadius(0.014384760050455853)
  <0.3431180065823414, 2.8182914555334926, 0.6892210379529222>, BranchRadius(0.01424935878753512)
  <0.33465905049777206, 2.8252046629042056, 0.6878402137547799>, BranchRadius(0.011011496249707856)
  <0.32409901957651366, 2.828014861106694, 0.6882193268088206>, BranchRadius(0.010934129764318101)
  <0.3137113038013786, 2.8304555323296627, 0.690283750177557>, BranchRadius(0.01086845706110128)
  <0.3032321561703617, 2.830706711287714, 0.687764387961473>, BranchRadius(0.010780668435558482)
  <0.2940893224081835, 2.830460559043425, 0.6822064569416905>, BranchRadius(0.010702457537914153)
  <0.2890127272890971, 2.832631998373823, 0.6842286688972965>, BranchRadius(0.005880162239439257)
  <0.2852589660882744, 2.8342630515941294, 0.6856292580655114>, BranchRadius(0.004325818740816061)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.3032321561703617, 2.830706711287714, 0.687764387961473>, BranchRadius(0.010780668435558482)
  <0.2940893224081835, 2.830460559043425, 0.6822064569416905>, BranchRadius(0.010702457537914153)
  <0.29100855649505514, 2.828595289521353, 0.6763890511067829>, BranchRadius(0.006841970450789724)
  <0.2891206356978434, 2.8264148196660113, 0.673933868739735>, BranchRadius(0.0037876924613886825)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  23
  <0.28836468453813546, 2.2963350183829094, 0.4131126660859772>, BranchRadius(0.11567001519599478)
  <0.3604780443461617, 2.345652559991822, 0.4876934614005953>, BranchRadius(0.11486884522319199)
  <0.4083624935286228, 2.3633852934167625, 0.5002502639928837>, BranchRadius(0.052583681875363164)
  <0.45340412447273687, 2.3841031480963224, 0.5163259258205446>, BranchRadius(0.05211914162595586)
  <0.5032647708240993, 2.393645817291462, 0.526271290211567>, BranchRadius(0.05173061823343793)
  <0.5458289253790337, 2.421520192430039, 0.532139379216844>, BranchRadius(0.051216428135085)
  <0.5806085772644903, 2.426862379162022, 0.5457472109891874>, BranchRadius(0.03772712856681932)
  <0.6154186241107461, 2.4383109169530597, 0.5536489699926561>, BranchRadius(0.03748661326847526)
  <0.6489484848172823, 2.454309389419652, 0.5527852502549698>, BranchRadius(0.037161118013984744)
  <0.6806592238706535, 2.472690728466143, 0.5486883984981987>, BranchRadius(0.036881279679127424)
  <0.7008759529677434, 2.4847100218995815, 0.5462812609630979>, BranchRadius(0.02364262805055973)
  <0.717221799252107, 2.5005990404470424, 0.5404755766020868>, BranchRadius(0.023523468537894093)
  <0.7255723964217993, 2.505284526950283, 0.5326743149680757>, BranchRadius(0.012350948949162366)
  <0.7323391972370985, 2.5084180468779063, 0.5229474505376656>, BranchRadius(0.012256444511289724)
  <0.7376973442879577, 2.5093276506023, 0.5120360295056213>, BranchRadius(0.012190005237595208)
  <0.7400930774964396, 2.512066410112125, 0.5004820867706631>, BranchRadius(0.012113378305888614)
  <0.7435963000483997, 2.5156422787091657, 0.4895208365032649>, BranchRadius(0.012050245304407754)
  <0.745054791891132, 2.522141418741351, 0.4795856048398145>, BranchRadius(0.011961389878258026)
  <0.7474338363382603, 2.5280142620926482, 0.46953699388539993>, BranchRadius(0.011879592738114685)
  <0.7465221523149554, 2.5353089226690235, 0.4676366737542121>, BranchRadius(0.007593053225407282)
  <0.7446450632832445, 2.5414476679644955, 0.46365498423758694>, BranchRadius(0.0075539068330534595)
  <0.744171117576385, 2.5440219905628836, 0.4586208246517348>, BranchRadius(0.0056740218636738724)
  <0.7426331533333381, 2.546854945376779, 0.4558749722101412>, BranchRadius(0.004234462494988822)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.745054791891132, 2.522141418741351, 0.4795856048398145>, BranchRadius(0.011961389878258026)
  <0.7474338363382603, 2.5280142620926482, 0.46953699388539993>, BranchRadius(0.011879592738114685)
  <0.7501274094338148, 2.5290544742351133, 0.46153939749705053>, BranchRadius(0.008502877472559862)
  <0.7560900635805432, 2.5291481504538473, 0.45556931069419254>, BranchRadius(0.008438243664478534)
  <0.7630203041805094, 2.527341848957352, 0.45118997669690075>, BranchRadius(0.008394612923148824)
  <0.7697542820028854, 2.5253471045518467, 0.44673733233714097>, BranchRadius(0.008315738352668774)
  <0.7753098429336788, 2.523140323882885, 0.44105257731246633>, BranchRadius(0.008249277414854227)
  <0.7799433459649884, 2.5193231087827903, 0.43549897928895664>, BranchRadius(0.008178198607778898)
  <0.7824535569971945, 2.5170597150986116, 0.4281391602975319>, BranchRadius(0.008098829914396657)
  <0.7850170061697727, 2.516204544367389, 0.4249961182446098>, BranchRadius(0.0041450334119724685)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <0.7008759529677434, 2.4847100218995815, 0.5462812609630979>, BranchRadius(0.02364262805055973)
  <0.717221799252107, 2.5005990404470424, 0.5404755766020868>, BranchRadius(0.023523468537894093)
  <0.7224681494365746, 2.513002485169001, 0.5489031358086095>, BranchRadius(0.015886893510318245)
  <0.723226769449468, 2.518743841951276, 0.5582904291577138>, BranchRadius(0.011029957318479297)
  <0.7199852968111837, 2.521691863755271, 0.5683142255152257>, BranchRadius(0.010939582754312248)
  <0.7156390629297127, 2.5234276839597407, 0.5781290439834916>, BranchRadius(0.010873522074273168)
  <0.7108838451572574, 2.525893434492069, 0.5874733994878748>, BranchRadius(0.01077074749232608)
  <0.7099368542431983, 2.5254601783384105, 0.592638778486016>, BranchRadius(0.00526931142374708)
  <0.7090983072134093, 2.525004069596258, 0.5977935318475868>, BranchRadius(0.005242392442812881)
  <0.7082621325194254, 2.524551747729698, 0.6029030930114693>, BranchRadius(0.0051972491259592735)
  <0.7061859907897112, 2.5262117439526004, 0.6073380559391509>, BranchRadius(0.005170575220594185)
  <0.7060628477522409, 2.528261974640749, 0.6094528453108303>, BranchRadius(0.0029480407339235676)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.7156390629297127, 2.5234276839597407, 0.5781290439834916>, BranchRadius(0.010873522074273168)
  <0.7108838451572574, 2.525893434492069, 0.5874733994878748>, BranchRadius(0.01077074749232608)
  <0.7083320515595398, 2.5274639749438337, 0.5916035857486054>, BranchRadius(0.00510261564536363)
  <0.7066927483426803, 2.527739235735628, 0.5963968132971726>, BranchRadius(0.00507327447243391)
  <0.7054695944611876, 2.529216479418289, 0.6010490957926222>, BranchRadius(0.005032105596391952)
  <0.703080772390271, 2.529190414787281, 0.6054344746180852>, BranchRadius(0.00499386600684348)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.717221799252107, 2.5005990404470424, 0.5404755766020868>, BranchRadius(0.023523468537894093)
  <0.7224681494365746, 2.513002485169001, 0.5489031358086095>, BranchRadius(0.015886893510318245)
  <0.7284284201180627, 2.5206229933091757, 0.5450884238748808>, BranchRadius(0.010399471046567929)
  <0.7276645923277101, 2.525945358888301, 0.543939843002945>, BranchRadius(0.0054982039131475325)
  <0.7273326061401926, 2.531115999937319, 0.5422520406381396>, BranchRadius(0.005449258711892543)
  <0.7275287242516841, 2.536498709763555, 0.5417848960925808>, BranchRadius(0.0054065008474575285)
  <0.7274066586439397, 2.5418500654068508, 0.5417692686889798>, BranchRadius(0.0053527704461679496)
  <0.7274941281098832, 2.54715963246515, 0.5418129114878683>, BranchRadius(0.0053104668295685395)
  <0.7280794658879659, 2.5518173171687337, 0.5394421861289128>, BranchRadius(0.005258990952648558)
  <0.7270986709034241, 2.5557959117069586, 0.5391763610757611>, BranchRadius(0.0041063166293137665)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.7224681494365746, 2.513002485169001, 0.5489031358086095>, BranchRadius(0.015886893510318245)
  <0.7284284201180627, 2.5206229933091757, 0.5450884238748808>, BranchRadius(0.010399471046567929)
  <0.7361664886970907, 2.520772875947881, 0.5426687896001533>, BranchRadius(0.008108933355414894)
  <0.7400232531262394, 2.52089061891438, 0.5415866913464367>, BranchRadius(0.004007422101401738)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  21
  <0.6489484848172823, 2.454309389419652, 0.5527852502549698>, BranchRadius(0.037161118013984744)
  <0.6806592238706535, 2.472690728466143, 0.5486883984981987>, BranchRadius(0.036881279679127424)
  <0.7043841602318361, 2.477405419280242, 0.539465974833833>, BranchRadius(0.02588733306193922)
  <0.7233911369333613, 2.4924899707783528, 0.5308852004988889>, BranchRadius(0.025737881525461827)
  <0.7380649427091851, 2.505548890804736, 0.5145377627787551>, BranchRadius(0.02555571732931245)
  <0.7393544734392778, 2.504844794315224, 0.5032822587782865>, BranchRadius(0.011350991660421618)
  <0.7364468125246582, 2.507712714459007, 0.4927685801649033>, BranchRadius(0.011279046765176215)
  <0.7328733552189363, 2.505642765365346, 0.482388921533533>, BranchRadius(0.011171016053606975)
  <0.7277849301243533, 2.5029189934861042, 0.4729046705570355>, BranchRadius(0.011102342985988384)
  <0.7239553637499273, 2.499410276365736, 0.4631957867751359>, BranchRadius(0.011010862760807202)
  <0.7206587964325335, 2.4955974420433074, 0.45351331992533706>, BranchRadius(0.010915824565549475)
  <0.7223226011089133, 2.491958885528464, 0.4434376392723258>, BranchRadius(0.010840972287314413)
  <0.725599345164877, 2.4850671139981544, 0.4358693837150464>, BranchRadius(0.010747653632982777)
  <0.7264215462903634, 2.481500550185433, 0.4258227513153766>, BranchRadius(0.01069257755151033)
  <0.723439249417365, 2.4766548083040143, 0.4168350824553555>, BranchRadius(0.010637363421328658)
  <0.7213306522227741, 2.4683788492704606, 0.41066671811207833>, BranchRadius(0.010535008245156057)
  <0.7196269849534657, 2.460142757874296, 0.4044657619022828>, BranchRadius(0.010449284260957398)
  <0.7185832512147431, 2.4503300878677736, 0.4012904022471366>, BranchRadius(0.010366329230435557)
  <0.7150669014059783, 2.4432216834505223, 0.3947424384942483>, BranchRadius(0.010284452277391342)
  <0.7082250772648406, 2.436603086334046, 0.39099048203460796>, BranchRadius(0.010231987228467214)
  <0.708015438507946, 2.432268518377436, 0.3895765216932772>, BranchRadius(0.00456417699325045)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.7233911369333613, 2.4924899707783528, 0.5308852004988889>, BranchRadius(0.025737881525461827)
  <0.7380649427091851, 2.505548890804736, 0.5145377627787551>, BranchRadius(0.02555571732931245)
  <0.7461631683731222, 2.514211825934222, 0.5132361506223212>, BranchRadius(0.011929874189089659)
  <0.7535690749500226, 2.516476580137248, 0.5097384911111562>, BranchRadius(0.008497657670319653)
  <0.7584331761764221, 2.519517451772599, 0.5035674367582815>, BranchRadius(0.008425455054148545)
  <0.763773556870034, 2.522901628034003, 0.4981108477031431>, BranchRadius(0.008351447721060768)
  <0.767720098584887, 2.5286943489092732, 0.49365158119159686>, BranchRadius(0.008307578736723557)
  <0.7698987873893881, 2.5344508770616763, 0.4881344363127327>, BranchRadius(0.008265784227200862)
  <0.7719766494547672, 2.5405278910396807, 0.483021768092226>, BranchRadius(0.008208957667364371)
  <0.7762481783723287, 2.5414766180370307, 0.48194695232092577>, BranchRadius(0.004505693193205766)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.7380649427091851, 2.505548890804736, 0.5145377627787551>, BranchRadius(0.02555571732931245)
  <0.7461631683731222, 2.514211825934222, 0.5132361506223212>, BranchRadius(0.011929874189089659)
  <0.7495876359793436, 2.518605127976942, 0.5129834725386686>, BranchRadius(0.005576013579483653)
  <0.7529903240107114, 2.5229719330312186, 0.5127137718851422>, BranchRadius(0.005542563546174508)
  <0.7548860909055642, 2.5252364362887296, 0.5125349788638761>, BranchRadius(0.002958694655984486)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.5032647708240993, 2.393645817291462, 0.526271290211567>, BranchRadius(0.05173061823343793)
  <0.5458289253790337, 2.421520192430039, 0.532139379216844>, BranchRadius(0.051216428135085)
  <0.549841016436514, 2.4450987301129197, 0.522101816507078>, BranchRadius(0.025938330306113047)
  <0.5536446186783244, 2.467993169922587, 0.5110463691913331>, BranchRadius(0.0257069189045205)
  <0.5530097062362914, 2.4772135962187662, 0.5054252277343247>, BranchRadius(0.010817421419729169)
  <0.5531451198233666, 2.4865345955929947, 0.5001380395180279>, BranchRadius(0.010716983036679792)
  <0.5534281921794696, 2.4920800777637173, 0.5004979694021947>, BranchRadius(0.005564355487035999)
  <0.5538141143554802, 2.4969046499941907, 0.5031820826111133>, BranchRadius(0.005534428321993303)
  <0.5564887087841053, 2.499080266346213, 0.503387788292302>, BranchRadius(0.0034538495474024777)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <0.5530097062362914, 2.4772135962187662, 0.5054252277343247>, BranchRadius(0.010817421419729169)
  <0.5531451198233666, 2.4865345955929947, 0.5001380395180279>, BranchRadius(0.010716983036679792)
  <0.5531627820810172, 2.4909518394432464, 0.4968273097919729>, BranchRadius(0.0055202614527680455)
  <0.5529826798100809, 2.49623845589178, 0.4953506917605349>, BranchRadius(0.005491916888725477)
  <0.5528596514830589, 2.50149592595358, 0.4939382265655939>, BranchRadius(0.0054452901985931985)
  <0.5526744519876374, 2.50663009925825, 0.4923013301908709>, BranchRadius(0.005391981464830105)
  <0.5523780016583051, 2.5119144183846043, 0.4915675991428572>, BranchRadius(0.0053432455191328235)
  <0.5500540638234814, 2.5166823576849606, 0.49170373699714554>, BranchRadius(0.005305889722504415)
  <0.5468185147378375, 2.5204758480588714, 0.4900024762052235>, BranchRadius(0.005268171920571376)
  <0.5432755983915846, 2.524273363453457, 0.48937055771672167>, BranchRadius(0.005231892619767006)
  <0.5387502926868787, 2.5263228345263906, 0.4878225744490117>, BranchRadius(0.005203361951368076)
  <0.5359068466950163, 2.5280827082243187, 0.486696999237456>, BranchRadius(0.0035283509034910172)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.549841016436514, 2.4450987301129197, 0.522101816507078>, BranchRadius(0.025938330306113047)
  <0.5536446186783244, 2.467993169922587, 0.5110463691913331>, BranchRadius(0.0257069189045205)
  <0.5646821616211307, 2.4776106068305688, 0.5114938363017983>, BranchRadius(0.014646592563058997)
  <0.5717811002001917, 2.4812798209228824, 0.5063058401225224>, BranchRadius(0.009527505726090908)
  <0.5751601914229059, 2.4830431869190592, 0.5038036165909424>, BranchRadius(0.004559478010681718)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <0.5646821616211307, 2.4776106068305688, 0.5114938363017983>, BranchRadius(0.014646592563058997)
  <0.5717811002001917, 2.4812798209228824, 0.5063058401225224>, BranchRadius(0.009527505726090908)
  <0.5771748202963335, 2.4832387217431005, 0.5039773787460303>, BranchRadius(0.006192837902027734)
  <0.582314192553607, 2.486005786951431, 0.5020746982615555>, BranchRadius(0.0061392173843241435)
  <0.587399364168518, 2.4890133395230887, 0.5005352521535622>, BranchRadius(0.006105263069172047)
  <0.5926614741677306, 2.491676446237337, 0.49914694611808036>, BranchRadius(0.00605882271265979)
  <0.5971446673923014, 2.495354076573577, 0.4975121212515951>, BranchRadius(0.006024669179544348)
  <0.6012873203297877, 2.4988886762149636, 0.49507800773523947>, BranchRadius(0.005964886972597181)
  <0.6053468990931999, 2.503151186359904, 0.49456322973267874>, BranchRadius(0.0059088212753465475)
  <0.6083768045045684, 2.5079846441188742, 0.49314186385717074>, BranchRadius(0.005879023869797655)
  <0.6092544578723063, 2.510706867061289, 0.4899833507315722>, BranchRadius(0.004261100602742071)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  16
  <0.5536446186783244, 2.467993169922587, 0.5110463691913331>, BranchRadius(0.0257069189045205)
  <0.5646821616211307, 2.4776106068305688, 0.5114938363017983>, BranchRadius(0.014646592563058997)
  <0.5700418045302116, 2.4852638032548233, 0.5182026295900158>, BranchRadius(0.011502395185574023)
  <0.5765685493338641, 2.4925908598964197, 0.5240599656819631>, BranchRadius(0.011427709431692685)
  <0.5843418733937936, 2.495071290140783, 0.5242718560645838>, BranchRadius(0.008162230006075423)
  <0.5921499743068177, 2.4970944655362373, 0.5236201316915079>, BranchRadius(0.008092244633425194)
  <0.5995433721855828, 2.4986514613330204, 0.5263580510090317>, BranchRadius(0.00803634060342137)
  <0.6070258720479854, 2.5008759755528462, 0.5280376148291628>, BranchRadius(0.007984810726057048)
  <0.6148175303148623, 2.501262059316036, 0.5294687082734013>, BranchRadius(0.007931395064308254)
  <0.6222628604734385, 2.49899232533407, 0.5307456698305454>, BranchRadius(0.007887665328696536)
  <0.6299395994818845, 2.5002378538384855, 0.5317714034044135>, BranchRadius(0.007844475280327537)
  <0.6377225022408435, 2.500494698669914, 0.5313720167784485>, BranchRadius(0.007797374833868284)
  <0.6454080889145537, 2.5014806932027254, 0.5315439623770142>, BranchRadius(0.007750483406001978)
  <0.6495374253299836, 2.5001660018613534, 0.5346398186210979>, BranchRadius(0.005325801201594615)
  <0.6530954999739299, 2.4991416577167476, 0.5384251053138863>, BranchRadius(0.005295051599850833)
  <0.6535181316947557, 2.497419225493851, 0.5403132118535278>, BranchRadius(0.0025904317475968276)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.5700418045302116, 2.4852638032548233, 0.5182026295900158>, BranchRadius(0.011502395185574023)
  <0.5765685493338641, 2.4925908598964197, 0.5240599656819631>, BranchRadius(0.011427709431692685)
  <0.5779010672214941, 2.498642089365249, 0.530188995467464>, BranchRadius(0.008715388007245401)
  <0.5784201786058175, 2.506136698440571, 0.5344995132727228>, BranchRadius(0.00866136280100826)
  <0.582169366409281, 2.507748790790436, 0.5386630976590387>, BranchRadius(0.00583015316026153)
  <0.5849155702951617, 2.5112104907573762, 0.542389863171552>, BranchRadius(0.005780465693107845)
  <0.5865687870940455, 2.51588401001604, 0.5452697603478185>, BranchRadius(0.005733124435338657)
  <0.5866513069459147, 2.5177874715705686, 0.5488771694958425>, BranchRadius(0.004079629416597706)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.5779010672214941, 2.498642089365249, 0.530188995467464>, BranchRadius(0.008715388007245401)
  <0.5784201786058175, 2.506136698440571, 0.5344995132727228>, BranchRadius(0.00866136280100826)
  <0.5758012577124834, 2.5106105960538, 0.5344668477479315>, BranchRadius(0.005184165654732715)
  <0.5765548362171578, 2.5125683789753217, 0.5354011990319462>, BranchRadius(0.002296477052454526)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  27
  <-0.21426274790908323, 2.108061895037176, 0.14031966706284293>, BranchRadius(0.2825835689131119)
  <-0.14297050518255044, 2.2221579580093174, 0.2800929406012852>, BranchRadius(0.19400274084242689)
  <-0.1761367755873321, 2.288913387684701, 0.34811291383831783>, BranchRadius(0.10091087970518774)
  <-0.21062585647233503, 2.3467736464834217, 0.42244653647406893>, BranchRadius(0.1003134771738147)
  <-0.24083777871672052, 2.434051887241073, 0.4594164677439409>, BranchRadius(0.09948380457918937)
  <-0.3023191386796874, 2.5094979883968307, 0.4761080490561213>, BranchRadius(0.09874553503425812)
  <-0.3225152113274927, 2.5635845456820783, 0.4417538280571696>, BranchRadius(0.06718221140905252)
  <-0.35522898747949716, 2.6214469575206696, 0.4364184455902956>, BranchRadius(0.06668370235649808)
  <-0.37066688315463253, 2.685749281285167, 0.43629475450073074>, BranchRadius(0.06612966629188646)
  <-0.37172021116957576, 2.7286869767483197, 0.4119371546692793>, BranchRadius(0.049376592239062135)
  <-0.386952423722544, 2.770889370843431, 0.3919827491958647>, BranchRadius(0.04910438538883598)
  <-0.38706105547950687, 2.797225442740062, 0.37447120968468245>, BranchRadius(0.03162680034171706)
  <-0.3887025264386688, 2.826171352767976, 0.362256771422745>, BranchRadius(0.0314603343324343)
  <-0.3857973198456518, 2.8499120679717733, 0.34228000381290047>, BranchRadius(0.031163007362474748)
  <-0.38598886037163627, 2.871701454578621, 0.3204213141074409>, BranchRadius(0.030864483992371038)
  <-0.39336376134546036, 2.897831809264008, 0.30621886275926746>, BranchRadius(0.030641380919519297)
  <-0.39597875203858857, 2.927378748987988, 0.2992112132592523>, BranchRadius(0.030478959544130352)
  <-0.39125971547962807, 2.956827247202233, 0.29442182935373856>, BranchRadius(0.03020631641418058)
  <-0.3855613677595338, 2.968501589595987, 0.28712117436809204>, BranchRadius(0.014901711320689123)
  <-0.3784205889260853, 2.9783982218749445, 0.27877973128959593>, BranchRadius(0.014782209761903569)
  <-0.3698704504791803, 2.9837570015482333, 0.2801448564605354>, BranchRadius(0.01018258089977342)
  <-0.3613105162460785, 2.9889856923315516, 0.281514092777648>, BranchRadius(0.010123561106383785)
  <-0.35264595731501674, 2.9939473938827064, 0.2827713680318361>, BranchRadius(0.010063488700116129)
  <-0.3429139923153126, 2.996225847377815, 0.2830473364927235>, BranchRadius(0.009998932526837282)
  <-0.3362697588498354, 2.999464067293358, 0.2838981680898265>, BranchRadius(0.007440149257361479)
  <-0.3317320693737565, 3.005268365700235, 0.28375976946857095>, BranchRadius(0.00736883029766307)
  <-0.3309069875379742, 3.008311953092023, 0.28179190118154557>, BranchRadius(0.003717080822670971)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.3362697588498354, 2.999464067293358, 0.2838981680898265>, BranchRadius(0.007440149257361479)
  <-0.3317320693737565, 3.005268365700235, 0.28375976946857095>, BranchRadius(0.00736883029766307)
  <-0.3279160680405845, 3.0093005947188542, 0.2844728916874216>, BranchRadius(0.0055972565004995135)
  <-0.3240690848098952, 3.0132353526216646, 0.2837947161412192>, BranchRadius(0.005544503747171556)
  <-0.32214579331889864, 3.016256892744667, 0.2857446043656696>, BranchRadius(0.004078090112062495)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.35264595731501674, 2.9939473938827064, 0.2827713680318361>, BranchRadius(0.010063488700116129)
  <-0.3429139923153126, 2.996225847377815, 0.2830473364927235>, BranchRadius(0.009998932526837282)
  <-0.3370147917754441, 2.9925710154456784, 0.2812320974414657>, BranchRadius(0.0071731064591961805)
  <-0.3345993124044297, 2.9906348079363263, 0.27865304162243726>, BranchRadius(0.004029264080292139)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.3855613677595338, 2.968501589595987, 0.28712117436809204>, BranchRadius(0.014901711320689123)
  <-0.3784205889260853, 2.9783982218749445, 0.27877973128959593>, BranchRadius(0.014782209761903569)
  <-0.37648910862261625, 2.984248492079356, 0.27097330468496>, BranchRadius(0.009944675658908041)
  <-0.37631150391088664, 2.98889561949432, 0.2622889982147274>, BranchRadius(0.009851117475366157)
  <-0.37641922825126056, 2.991647854071293, 0.25914039843486214>, BranchRadius(0.0041833097272330946)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.37648910862261625, 2.984248492079356, 0.27097330468496>, BranchRadius(0.009944675658908041)
  <-0.37631150391088664, 2.98889561949432, 0.2622889982147274>, BranchRadius(0.009851117475366157)
  <-0.3762155061906831, 2.991300023799509, 0.2577573095585328>, BranchRadius(0.0051309431590865874)
  <-0.3743395029344634, 2.993584536546276, 0.2536021810041516>, BranchRadius(0.005099360745321128)
  <-0.37435010007634206, 2.9949777289667856, 0.2518178701225235>, BranchRadius(0.0022638159691719052)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <-0.39597875203858857, 2.927378748987988, 0.2992112132592523>, BranchRadius(0.030478959544130352)
  <-0.39125971547962807, 2.956827247202233, 0.29442182935373856>, BranchRadius(0.03020631641418058)
  <-0.3990683336373986, 2.9757512482630477, 0.30664459795665866>, BranchRadius(0.02384299490425048)
  <-0.40637087463130356, 2.982354742156164, 0.3108201362363768>, BranchRadius(0.010694314213145106)
  <-0.4111988420431093, 2.9888670725802844, 0.3135417832936626>, BranchRadius(0.008551437281931907)
  <-0.4181148212552894, 2.9937377601200668, 0.31316640896948106>, BranchRadius(0.008467306033016285)
  <-0.42565686073684955, 2.9956844299806353, 0.30999221308197056>, BranchRadius(0.008411147520983502)
  <-0.43370477139195274, 2.9971046223674667, 0.3082934066823911>, BranchRadius(0.008346960854789535)
  <-0.4384687886518044, 2.9988477364413506, 0.3089083105478807>, BranchRadius(0.005110030713266864)
  <-0.4402717254459281, 2.9975813509178377, 0.3097022140047429>, BranchRadius(0.0023419214497045213)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.3990683336373986, 2.9757512482630477, 0.30664459795665866>, BranchRadius(0.02384299490425048)
  <-0.40637087463130356, 2.982354742156164, 0.3108201362363768>, BranchRadius(0.010694314213145106)
  <-0.4120733267014168, 2.9811609500081233, 0.3141959825596857>, BranchRadius(0.006733456593998466)
  <-0.4186597949019084, 2.98002621063269, 0.3144729103971923>, BranchRadius(0.006689236565814675)
  <-0.4220857864604847, 2.9786406380030477, 0.3124047870044249>, BranchRadius(0.004234898350511177)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.39125971547962807, 2.956827247202233, 0.29442182935373856>, BranchRadius(0.03020631641418058)
  <-0.3990683336373986, 2.9757512482630477, 0.30664459795665866>, BranchRadius(0.02384299490425048)
  <-0.39018009878056686, 2.9882003655171676, 0.3149597543838817>, BranchRadius(0.017410429796136925)
  <-0.3781752893449715, 2.9971879025213477, 0.3235950987979816>, BranchRadius(0.017304925429963352)
  <-0.37274131839062125, 3.000954178217874, 0.33014462142854034>, BranchRadius(0.009306402078309774)
  <-0.3690347792413005, 3.002591717564812, 0.3304589224854753>, BranchRadius(0.004064326848643895)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.39018009878056686, 2.9882003655171676, 0.3149597543838817>, BranchRadius(0.017410429796136925)
  <-0.3781752893449715, 2.9971879025213477, 0.3235950987979816>, BranchRadius(0.017304925429963352)
  <-0.37113094302208605, 3.002727575270396, 0.3263371392001282>, BranchRadius(0.009371743426401522)
  <-0.3678063046716295, 3.005270258864002, 0.32787434517200204>, BranchRadius(0.004458863332564162)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.3781752893449715, 2.9971879025213477, 0.3235950987979816>, BranchRadius(0.017304925429963352)
  <-0.37113094302208605, 3.002727575270396, 0.3263371392001282>, BranchRadius(0.009371743426401522)
  <-0.36803608640006136, 3.00613509287349, 0.32424583679861946>, BranchRadius(0.005055972652303368)
  <-0.3649423782695091, 3.0094865178775008, 0.32217238496222683>, BranchRadius(0.0050102177669633634)
  <-0.36519702151980904, 3.013044964525764, 0.32167206998295816>, BranchRadius(0.003602457607236906)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  22
  <-0.37172021116957576, 2.7286869767483197, 0.4119371546692793>, BranchRadius(0.049376592239062135)
  <-0.386952423722544, 2.770889370843431, 0.3919827491958647>, BranchRadius(0.04910438538883598)
  <-0.39971474144072505, 2.7947782930960856, 0.3829163644257178>, BranchRadius(0.028561454667672573)
  <-0.4036517291369851, 2.808327863191985, 0.3895852614873266>, BranchRadius(0.015606566243812944)
  <-0.4079441856302582, 2.8218624938354497, 0.39582117033250264>, BranchRadius(0.015507996921814399)
  <-0.41269426278044563, 2.8349435509245686, 0.40246644385575353>, BranchRadius(0.015421963159738874)
  <-0.41002032370235464, 2.8488518453863967, 0.40830685938795147>, BranchRadius(0.015319956221184296)
  <-0.4119652018383834, 2.862038388092591, 0.4156707298987685>, BranchRadius(0.015228067783089624)
  <-0.4169470051326086, 2.8754472318266324, 0.420519302066599>, BranchRadius(0.015103777885448168)
  <-0.4215351776691655, 2.8839825335675715, 0.42028496502831153>, BranchRadius(0.009693173725958138)
  <-0.4282814233021811, 2.8847942958038724, 0.4184730333663374>, BranchRadius(0.00703234558429344)
  <-0.43513625276117984, 2.8852220173715533, 0.41973342048937573>, BranchRadius(0.006982851018841577)
  <-0.4413410909633968, 2.8874221101690414, 0.42192275599120044>, BranchRadius(0.006937839387936262)
  <-0.44643967168475746, 2.8916306615402747, 0.4237931648608215>, BranchRadius(0.0068706520328204145)
  <-0.4525267331219385, 2.8946881915009026, 0.4233086874719799>, BranchRadius(0.006829020774639071)
  <-0.4585617717420844, 2.896800052480118, 0.42109483159371025>, BranchRadius(0.00676629926857607)
  <-0.46479713587013144, 2.8992602276725883, 0.42101532832540006>, BranchRadius(0.006703622047569182)
  <-0.4697433376754617, 2.903619717694101, 0.42181694488085586>, BranchRadius(0.00664173581593718)
  <-0.4735628696697646, 2.9080611909304057, 0.424862016283805>, BranchRadius(0.006602118524638478)
  <-0.4760344635203476, 2.912594521181691, 0.4288954029704766>, BranchRadius(0.006551951426382768)
  <-0.48104054273318403, 2.915699814307114, 0.431616303206154>, BranchRadius(0.006488988563135287)
  <-0.4821788009370744, 2.9178458150345934, 0.43436042166350197>, BranchRadius(0.00366485156166301)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <-0.4119652018383834, 2.862038388092591, 0.4156707298987685>, BranchRadius(0.015228067783089624)
  <-0.4169470051326086, 2.8754472318266324, 0.420519302066599>, BranchRadius(0.015103777885448168)
  <-0.4194908749024032, 2.883618779748793, 0.42462730341572713>, BranchRadius(0.009493215679329986)
  <-0.4184483324633449, 2.8928920874565622, 0.4259947379056436>, BranchRadius(0.009431384186026423)
  <-0.4156068314790298, 2.9014451899939884, 0.42844648423747167>, BranchRadius(0.009340275741926578)
  <-0.4123131765172264, 2.9100683518088237, 0.42778025785291324>, BranchRadius(0.009254779321395628)
  <-0.4102136691289313, 2.915121249686146, 0.42472597602773277>, BranchRadius(0.006266446018261027)
  <-0.4081627997166225, 2.920143572192721, 0.42166880636658916>, BranchRadius(0.0062270438446676455)
  <-0.40548057011608357, 2.9251177732691813, 0.4191444518490297>, BranchRadius(0.006189458595821529)
  <-0.4023798588268404, 2.9264234694663562, 0.41606977456414834>, BranchRadius(0.004557728981052089)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.4156068314790298, 2.9014451899939884, 0.42844648423747167>, BranchRadius(0.009340275741926578)
  <-0.4123131765172264, 2.9100683518088237, 0.42778025785291324>, BranchRadius(0.009254779321395628)
  <-0.4110164416969036, 2.914251708423614, 0.4321886067083398>, BranchRadius(0.006214139795006819)
  <-0.4118615886362837, 2.917816897195442, 0.43191193192834987>, BranchRadius(0.0036744242081983383)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  18
  <-0.386952423722544, 2.770889370843431, 0.3919827491958647>, BranchRadius(0.04910438538883598)
  <-0.39971474144072505, 2.7947782930960856, 0.3829163644257178>, BranchRadius(0.028561454667672573)
  <-0.40416184050020454, 2.798176327066005, 0.3722120457428042>, BranchRadius(0.012079145804688513)
  <-0.4103269055624709, 2.8014555056554418, 0.36250277682118814>, BranchRadius(0.011959554441351751)
  <-0.41167093932728877, 2.8056725864341012, 0.3514844825838755>, BranchRadius(0.011874047538843052)
  <-0.4120921113242737, 2.814295930945034, 0.3434726297302306>, BranchRadius(0.011778337851910016)
  <-0.4119696420361344, 2.8189447911916594, 0.33996413806351744>, BranchRadius(0.005825496896796721)
  <-0.41129888677465154, 2.8226884354152606, 0.33560611852797984>, BranchRadius(0.005784212908066075)
  <-0.4106015283037209, 2.826563782839524, 0.3314121585486307>, BranchRadius(0.0057527321164908465)
  <-0.41159083188783957, 2.8300997277114797, 0.32704202484093936>, BranchRadius(0.005707862677233991)
  <-0.4140287718196716, 2.833392575465095, 0.32314705380634673>, BranchRadius(0.005653069679389008)
  <-0.4166054731574027, 2.835562084689107, 0.3186625628205428>, BranchRadius(0.005608637932573006)
  <-0.41711319650052686, 2.839383446764709, 0.31464813081525295>, BranchRadius(0.005565631629123249)
  <-0.41683918672097336, 2.8433877077598377, 0.3108472921564228>, BranchRadius(0.0055277085656588705)
  <-0.4167887607697433, 2.8473751890913834, 0.30709645866031005>, BranchRadius(0.005474605196865239)
  <-0.4149953045976917, 2.8505774345917114, 0.3030730973462533>, BranchRadius(0.005445943219396409)
  <-0.41295600989176473, 2.8538264254885366, 0.29928109145921533>, BranchRadius(0.005393882960595763)
  <-0.41139393903918803, 2.8560470870474597, 0.2961504943516948>, BranchRadius(0.004143916186093209)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.41167093932728877, 2.8056725864341012, 0.3514844825838755>, BranchRadius(0.011874047538843052)
  <-0.4120921113242737, 2.814295930945034, 0.3434726297302306>, BranchRadius(0.011778337851910016)
  <-0.4142153669908601, 2.813966647089495, 0.33881641913960636>, BranchRadius(0.00512805416775709)
  <-0.4163142595435329, 2.813633505346327, 0.33419572723435753>, BranchRadius(0.005085973559893804)
  <-0.41895480258207046, 2.8134149467081806, 0.32991307289419675>, BranchRadius(0.005036006713059027)
  <-0.42173690071816256, 2.8131648992594624, 0.32577945524888474>, BranchRadius(0.004988926598286683)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  23
  <-0.35522898747949716, 2.6214469575206696, 0.4364184455902956>, BranchRadius(0.06668370235649808)
  <-0.37066688315463253, 2.685749281285167, 0.43629475450073074>, BranchRadius(0.06612966629188646)
  <-0.38764774012402137, 2.715353359009478, 0.4621340814691072>, BranchRadius(0.04280679548273338)
  <-0.40733425031475756, 2.747911421098438, 0.48126405782015025>, BranchRadius(0.04258570283170163)
  <-0.4224482497276265, 2.773438650586878, 0.5113129944419281>, BranchRadius(0.04222571510001116)
  <-0.4364774053081086, 2.7998205026266985, 0.5407068117732223>, BranchRadius(0.04191438679806535)
  <-0.45164825996743696, 2.826515187861874, 0.5686250953051403>, BranchRadius(0.04149929645509838)
  <-0.46675010748941564, 2.851875324765928, 0.597442108208351>, BranchRadius(0.04125072817579415)
  <-0.48405094960406664, 2.873817407346981, 0.6273320554408192>, BranchRadius(0.04091678227120943)
  <-0.4982370821162075, 2.90820172183937, 0.6434325435974563>, BranchRadius(0.0405308913995923)
  <-0.4950218196929753, 2.919572220773945, 0.6565575632015084>, BranchRadius(0.017660472759192067)
  <-0.4947646154618128, 2.9322355589019597, 0.6686991004115236>, BranchRadius(0.01754546130436996)
  <-0.4945191407066774, 2.939914060676001, 0.6737072965175203>, BranchRadius(0.009170696570353049)
  <-0.4948624602807571, 2.9484117344886074, 0.6769759092425266>, BranchRadius(0.009111100795264847)
  <-0.49490504580805467, 2.9554360727264477, 0.6826350227627015>, BranchRadius(0.00902046046723495)
  <-0.4910281199612316, 2.9623676965384123, 0.6868094516181715>, BranchRadius(0.00897239204235629)
  <-0.4840865967926827, 2.967556736608121, 0.6888070053066001>, BranchRadius(0.008893880001590882)
  <-0.4757455551190017, 2.970373056394553, 0.688237243524318>, BranchRadius(0.008822089425418565)
  <-0.4680642531439344, 2.972576471348328, 0.6846984478060182>, BranchRadius(0.008739594534447772)
  <-0.4598554682946994, 2.973023415828248, 0.6818854733823453>, BranchRadius(0.008688885611941167)
  <-0.45194366103403927, 2.972383328147068, 0.6785627512272486>, BranchRadius(0.008605050196797383)
  <-0.44622260460083113, 2.9709693849156587, 0.6760060892463795>, BranchRadius(0.006423880654092401)
  <-0.4417266372066188, 2.9711782271845957, 0.6746809858450892>, BranchRadius(0.004691826608819431)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.4598554682946994, 2.973023415828248, 0.6818854733823453>, BranchRadius(0.008688885611941167)
  <-0.45194366103403927, 2.972383328147068, 0.6785627512272486>, BranchRadius(0.008605050196797383)
  <-0.4469051573186143, 2.9722310623598727, 0.6764880758996323>, BranchRadius(0.005451053317967207)
  <-0.44340890389361215, 2.9721282710219894, 0.6750422711233564>, BranchRadius(0.0037847992710427374)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <-0.4950218196929753, 2.919572220773945, 0.6565575632015084>, BranchRadius(0.017660472759192067)
  <-0.4947646154618128, 2.9322355589019597, 0.6686991004115236>, BranchRadius(0.01754546130436996)
  <-0.4950092055051036, 2.9351128416216716, 0.679426185542726>, BranchRadius(0.011108957446605604)
  <-0.4946383071464052, 2.9378595453945358, 0.6901084656541878>, BranchRadius(0.01103598910782727)
  <-0.49172157131520433, 2.9358541598467407, 0.7004849556131015>, BranchRadius(0.010963597172997306)
  <-0.4867024794951463, 2.93744852942425, 0.7099849511232023>, BranchRadius(0.010862007721401879)
  <-0.4813341360405802, 2.938202232857281, 0.7193056755599331>, BranchRadius(0.010782536080932771)
  <-0.4791676581903457, 2.935217332550672, 0.7293236941050296>, BranchRadius(0.01067539000158071)
  <-0.47479065563064143, 2.934525283619211, 0.7389360302550855>, BranchRadius(0.010584615694150826)
  <-0.4702515749946523, 2.933180483917408, 0.7483392657744861>, BranchRadius(0.010527705233872123)
  <-0.46342635300287643, 2.931577355570988, 0.7560981385187189>, BranchRadius(0.010457235867728915)
  <-0.45954169103201964, 2.9303290222929887, 0.760762762789947>, BranchRadius(0.006197390918161623)
  <-0.45602464710889445, 2.9298109211853207, 0.7657738637894466>, BranchRadius(0.006144034500403104)
  <-0.45426690068665476, 2.927916661260085, 0.7712938294827493>, BranchRadius(0.006094908892222094)
  <-0.4524469611726144, 2.9252451644913715, 0.7764079881542946>, BranchRadius(0.006050098655208405)
  <-0.45095513727252345, 2.9226328553798777, 0.7816125571863849>, BranchRadius(0.006011425475930828)
  <-0.45156837326524796, 2.921414085719903, 0.7836421020437757>, BranchRadius(0.0024455081670297484)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.4702515749946523, 2.933180483917408, 0.7483392657744861>, BranchRadius(0.010527705233872123)
  <-0.46342635300287643, 2.931577355570988, 0.7560981385187189>, BranchRadius(0.010457235867728915)
  <-0.45777555528541064, 2.9312000973632517, 0.7618189115954295>, BranchRadius(0.008049911999161061)
  <-0.45662393809229, 2.9313217492409533, 0.7676498962410153>, BranchRadius(0.005944863604482241)
  <-0.4555920227711217, 2.93124771559976, 0.7734690914718692>, BranchRadius(0.005910445274671168)
  <-0.4551803772034791, 2.931234634752833, 0.775853604318291>, BranchRadius(0.0024198191454459237)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <-0.48405094960406664, 2.873817407346981, 0.6273320554408192>, BranchRadius(0.04091678227120943)
  <-0.4982370821162075, 2.90820172183937, 0.6434325435974563>, BranchRadius(0.0405308913995923)
  <-0.5226018877734936, 2.927786245967664, 0.6365359777652576>, BranchRadius(0.03201187217778563)
  <-0.5419296227988645, 2.9512228097129913, 0.6270608446995534>, BranchRadius(0.0318215651408372)
  <-0.5575607201386221, 2.9617148645470808, 0.6186521102647926>, BranchRadius(0.02061846826223644)
  <-0.5702316336678447, 2.977713115363878, 0.6167473100076716>, BranchRadius(0.020496934963104015)
  <-0.5765265192465052, 2.986881475339861, 0.6138584240795345>, BranchRadius(0.011490433890999388)
  <-0.5809324446037477, 2.993559883976043, 0.6117064744157253>, BranchRadius(0.008285179993276576)
  <-0.5850604783199043, 3.000374439164326, 0.6096611813351817>, BranchRadius(0.008225694412096831)
  <-0.5849286990250737, 3.0041650375834625, 0.6078224487142768>, BranchRadius(0.004215084792609081)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.5809324446037477, 2.993559883976043, 0.6117064744157253>, BranchRadius(0.008285179993276576)
  <-0.5850604783199043, 3.000374439164326, 0.6096611813351817>, BranchRadius(0.008225694412096831)
  <-0.5909770406161352, 3.003204592802084, 0.6100250392403719>, BranchRadius(0.006568703950831209)
  <-0.5962204095418424, 3.0069607599079546, 0.6109579214326286>, BranchRadius(0.006517052877100548)
  <-0.598212881949057, 3.0087302607008444, 0.6133288864708338>, BranchRadius(0.0035668690138467595)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.5702316336678447, 2.977713115363878, 0.6167473100076716>, BranchRadius(0.020496934963104015)
  <-0.5765265192465052, 2.986881475339861, 0.6138584240795345>, BranchRadius(0.011490433890999388)
  <-0.584977331753023, 2.988730479156084, 0.6151825334393719>, BranchRadius(0.008751474888813471)
  <-0.5920377721783616, 2.9937003740011714, 0.616248541668123>, BranchRadius(0.008699772831214899)
  <-0.5987068629913666, 2.997405042442567, 0.6202709840376373>, BranchRadius(0.008624464223871682)
  <-0.6021598312293202, 3.000860724860608, 0.6211252749263992>, BranchRadius(0.004959288613228327)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  18
  <-0.5575607201386221, 2.9617148645470808, 0.6186521102647926>, BranchRadius(0.02061846826223644)
  <-0.5702316336678447, 2.977713115363878, 0.6167473100076716>, BranchRadius(0.020496934963104015)
  <-0.5769343329767772, 2.9849851898407764, 0.6176349676559575>, BranchRadius(0.009929611338017234)
  <-0.5810897265110705, 2.9895034301038557, 0.6181907320453897>, BranchRadius(0.006163656751987375)
  <-0.5851429620794323, 2.994093078111921, 0.6182982701521876>, BranchRadius(0.006124144989709375)
  <-0.5872438350805809, 2.9994028461649274, 0.6162412328253072>, BranchRadius(0.006069489822700238)
  <-0.5884403473460661, 3.0050519005447898, 0.6145696520473041>, BranchRadius(0.0060114589980711135)
  <-0.5898003649399582, 3.0100764991661397, 0.6116684369417614>, BranchRadius(0.005959302664741598)
  <-0.5935028738348068, 3.0144463108083905, 0.6102108351636067>, BranchRadius(0.005910027821327263)
  <-0.5981692410157926, 3.0177519998813818, 0.6088610423862796>, BranchRadius(0.005875755564759289)
  <-0.6032771621019767, 3.020482622355013, 0.608208497760902>, BranchRadius(0.005828633751085496)
  <-0.6081525803221253, 3.0232992821181277, 0.6094801187978909>, BranchRadius(0.0057723734376959905)
  <-0.6130575094473332, 3.0248478406313164, 0.6120127985331743>, BranchRadius(0.00573330880326514)
  <-0.616533696948659, 3.0280922490750983, 0.6151493660627488>, BranchRadius(0.005696325268279435)
  <-0.6178753217970548, 3.031903347732449, 0.6191015576240624>, BranchRadius(0.00565192430480175)
  <-0.620531495742335, 3.034905091898477, 0.6230104067590337>, BranchRadius(0.005598645338457758)
  <-0.621831332618121, 3.0364930205133738, 0.6281852862420582>, BranchRadius(0.00556690855443924)
  <-0.6233032703798621, 3.037346934609182, 0.6297302471156162>, BranchRadius(0.0022984068739638737)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <-0.5702316336678447, 2.977713115363878, 0.6167473100076716>, BranchRadius(0.020496934963104015)
  <-0.5769343329767772, 2.9849851898407764, 0.6176349676559575>, BranchRadius(0.009929611338017234)
  <-0.5820265828708825, 2.985097425195506, 0.6153149213908307>, BranchRadius(0.005596983154449805)
  <-0.5857937993968527, 2.9858712216800862, 0.6113106245687701>, BranchRadius(0.0055520333565510765)
  <-0.5896506453726491, 2.9867206730904208, 0.607477945050341>, BranchRadius(0.005503295455499494)
  <-0.5936976396049612, 2.9893520190017804, 0.6049367260424837>, BranchRadius(0.005455266965739731)
  <-0.5981163371400877, 2.989760106328501, 0.6018172437047871>, BranchRadius(0.005424259694037855)
  <-0.6019315716246525, 2.9898904066059497, 0.5980076776532484>, BranchRadius(0.005393123940310591)
  <-0.6046544994118426, 2.9889443743613597, 0.5934980986742016>, BranchRadius(0.005352159873389129)
  <-0.6072173439841135, 2.9877486504109574, 0.5889880921674614>, BranchRadius(0.005323352961998897)
  <-0.6083745809201803, 2.9861549608256897, 0.5840988203476496>, BranchRadius(0.00527105518358453)
  <-0.6095716524906842, 2.9848911200155346, 0.5810569335061402>, BranchRadius(0.0035047609754261457)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <-0.5226018877734936, 2.927786245967664, 0.6365359777652576>, BranchRadius(0.03201187217778563)
  <-0.5419296227988645, 2.9512228097129913, 0.6270608446995534>, BranchRadius(0.0318215651408372)
  <-0.5484174299474833, 2.9726201136670243, 0.6250728218336092>, BranchRadius(0.02244746072531269)
  <-0.5567784802178782, 2.9848074165534952, 0.6179204313797741>, BranchRadius(0.016419324056573353)
  <-0.5629918643109701, 2.999157171836934, 0.6134545138267232>, BranchRadius(0.01626241181908495)
  <-0.5729911905270111, 3.0116764386726356, 0.6114884835383612>, BranchRadius(0.016142609515597508)
  <-0.5830029400234988, 3.0179470515687825, 0.6071787180303246>, BranchRadius(0.012574966910811548)
  <-0.5928524591645793, 3.0242345712344996, 0.6028495619716289>, BranchRadius(0.012461441451045207)
  <-0.5994466700117194, 3.0310009288802355, 0.6008488753740311>, BranchRadius(0.00965763735850306)
  <-0.6069877731791673, 3.036271523273739, 0.5981941959362687>, BranchRadius(0.009575736272486084)
  <-0.609109183949109, 3.038738200090772, 0.5944885974805538>, BranchRadius(0.004931159913195582)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-0.5830029400234988, 3.0179470515687825, 0.6071787180303246>, BranchRadius(0.012574966910811548)
  <-0.5928524591645793, 3.0242345712344996, 0.6028495619716289>, BranchRadius(0.012461441451045207)
  <-0.6000089751248298, 3.026609297410224, 0.598933905935941>, BranchRadius(0.00849631727802168)
  <-0.6054669066882472, 3.0272789917811855, 0.5925620488909765>, BranchRadius(0.008416535492880057)
  <-0.6087453166384141, 3.0251281177589093, 0.5852019073346546>, BranchRadius(0.008339419319721987)
  <-0.6116582199064844, 3.0226528661855867, 0.5778445615378635>, BranchRadius(0.00829110444837905)
  <-0.6148530648914255, 3.0197927558225413, 0.5708115276631839>, BranchRadius(0.00823716160148595)
  <-0.6184031402867427, 3.0144346911852913, 0.5657774282584557>, BranchRadius(0.008164193088485407)
  <-0.622126478259315, 3.0115681113032804, 0.5661091925487739>, BranchRadius(0.004710689272524578)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-0.5629918643109701, 2.999157171836934, 0.6134545138267232>, BranchRadius(0.01626241181908495)
  <-0.5729911905270111, 3.0116764386726356, 0.6114884835383612>, BranchRadius(0.016142609515597508)
  <-0.5718426747341471, 3.020100985551685, 0.6154004809258867>, BranchRadius(0.009359262909212773)
  <-0.572934311260998, 3.027844838217411, 0.6204107862468974>, BranchRadius(0.009287738358985836)
  <-0.5756675002828555, 3.029734212429516, 0.6243164470577445>, BranchRadius(0.005127791289820242)
  <-0.5796996482990472, 3.031386048584701, 0.6269446035079298>, BranchRadius(0.005088613429482073)
  <-0.5837565128316144, 3.032378268039514, 0.6297913976518252>, BranchRadius(0.005054392760740846)
  <-0.5875867212375552, 3.0334543108220275, 0.6328434289179561>, BranchRadius(0.005014305470569035)
  <-0.5914749962314478, 3.0343919561164974, 0.6357866613205958>, BranchRadius(0.004965931745636583)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <-0.5419296227988645, 2.9512228097129913, 0.6270608446995534>, BranchRadius(0.0318215651408372)
  <-0.5484174299474833, 2.9726201136670243, 0.6250728218336092>, BranchRadius(0.02244746072531269)
  <-0.5515875699648236, 2.9837662945445387, 0.6243074850350044>, BranchRadius(0.011613478217102319)
  <-0.554481409195527, 2.994945085477739, 0.6244968951358915>, BranchRadius(0.011548833205466173)
  <-0.5567359268453556, 3.0061597776682394, 0.6244045418674788>, BranchRadius(0.011439436169988458)
  <-0.5599852364199192, 3.016306833398426, 0.6283303329229765>, BranchRadius(0.011354848661003425)
  <-0.566311067483411, 3.0253243885147576, 0.6305950498665176>, BranchRadius(0.01124550495772761)
  <-0.5748722778767261, 3.03062907460384, 0.6353643753100179>, BranchRadius(0.011143629708866357)
  <-0.576640926260903, 3.034560419298786, 0.6393729922985059>, BranchRadius(0.005886645766285377)
  <-0.5795022354303871, 3.036572520271199, 0.6440460164161259>, BranchRadius(0.00583719066764299)
  <-0.582090039342455, 3.037918314765378, 0.6472205154710086>, BranchRadius(0.004311071346814646)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.566311067483411, 3.0253243885147576, 0.6305950498665176>, BranchRadius(0.01124550495772761)
  <-0.5748722778767261, 3.03062907460384, 0.6353643753100179>, BranchRadius(0.011143629708866357)
  <-0.5814421742383351, 3.0321360313711536, 0.6362906177094741>, BranchRadius(0.006803850518889089)
  <-0.5854138872639086, 3.0346903139078836, 0.6365893920405112>, BranchRadius(0.004731609634769286)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  19
  <-0.24083777871672052, 2.434051887241073, 0.4594164677439409>, BranchRadius(0.09948380457918937)
  <-0.3023191386796874, 2.5094979883968307, 0.4761080490561213>, BranchRadius(0.09874553503425812)
  <-0.34634409868751015, 2.5318682399374466, 0.5310941324579809>, BranchRadius(0.07390598504557713)
  <-0.4079637343632035, 2.5306996580282846, 0.5705738339112031>, BranchRadius(0.0731914743075937)
  <-0.4335236196054717, 2.530913850331249, 0.5870529710201593>, BranchRadius(0.030412424628699825)
  <-0.46110242946033364, 2.5308818152992765, 0.5993793467483154>, BranchRadius(0.03020813330620712)
  <-0.4899689084065172, 2.529014986728587, 0.6074141950617788>, BranchRadius(0.030021949355149603)
  <-0.5153084620604478, 2.53755229446579, 0.6205364961924364>, BranchRadius(0.029785456010338083)
  <-0.5399062069264304, 2.5465088005063268, 0.6341246325280352>, BranchRadius(0.029494160473235564)
  <-0.5643873162217917, 2.5484684786906118, 0.6501558789298314>, BranchRadius(0.02932858523885005)
  <-0.5831356129737596, 2.554120561389424, 0.6717230293449282>, BranchRadius(0.029130510585320537)
  <-0.6089149393488368, 2.55115479492322, 0.6845798297306598>, BranchRadius(0.028959743701271884)
  <-0.6332117567597879, 2.540951512693002, 0.6962140020389753>, BranchRadius(0.02880618457675642)
  <-0.6443404090853252, 2.5317459528114945, 0.6877231237700095>, BranchRadius(0.01675363390709927)
  <-0.6441122162532102, 2.5303007324935707, 0.6803916531083632>, BranchRadius(0.0074760414524365935)
  <-0.6439986080413147, 2.5294019421595983, 0.675342911905354>, BranchRadius(0.005129377995938184)
  <-0.6423006701825958, 2.527937981393087, 0.6707822337767951>, BranchRadius(0.005081924742680812)
  <-0.6398924682074579, 2.525044246927067, 0.6674349086500272>, BranchRadius(0.005037630535994231)
  <-0.6382012520106985, 2.5220929610282368, 0.6637765604022963>, BranchRadius(0.004995379122998879)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.6332117567597879, 2.540951512693002, 0.6962140020389753>, BranchRadius(0.02880618457675642)
  <-0.6443404090853252, 2.5317459528114945, 0.6877231237700095>, BranchRadius(0.01675363390709927)
  <-0.6527027776377767, 2.526251803750082, 0.6878800197317659>, BranchRadius(0.01000697247217505)
  <-0.6581413399769594, 2.522110086880704, 0.6881181662061318>, BranchRadius(0.006840211450424576)
  <-0.6622728386365531, 2.5202824247060183, 0.6868162530538285>, BranchRadius(0.004701553791582165)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.6527027776377767, 2.526251803750082, 0.6878800197317659>, BranchRadius(0.01000697247217505)
  <-0.6581413399769594, 2.522110086880704, 0.6881181662061318>, BranchRadius(0.006840211450424576)
  <-0.6601342685214521, 2.518060462082774, 0.691052548334656>, BranchRadius(0.005383476912151311)
  <-0.6633030840154516, 2.5141731993377663, 0.6929281773108833>, BranchRadius(0.0053544549059824816)
  <-0.6641295400411934, 2.5112562289208507, 0.6917995344370934>, BranchRadius(0.003235054978234771)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-0.6443404090853252, 2.5317459528114945, 0.6877231237700095>, BranchRadius(0.01675363390709927)
  <-0.6527027776377767, 2.526251803750082, 0.6878800197317659>, BranchRadius(0.01000697247217505)
  <-0.6578630403706851, 2.5251984595673447, 0.6874173596613103>, BranchRadius(0.0052869556250023046)
  <-0.6629010735822923, 2.524083683505188, 0.6865285999875974>, BranchRadius(0.0052358760554117355)
  <-0.6670500780488415, 2.520944476167517, 0.6864049292872951>, BranchRadius(0.00520424396184945)
  <-0.6710275799831814, 2.5176942683869905, 0.6869699310379821>, BranchRadius(0.0051675525379574734)
  <-0.6728478373298322, 2.5157677265119607, 0.6851853664841434>, BranchRadius(0.003195241939368232)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  21
  <-0.6089149393488368, 2.55115479492322, 0.6845798297306598>, BranchRadius(0.028959743701271884)
  <-0.6332117567597879, 2.540951512693002, 0.6962140020389753>, BranchRadius(0.02880618457675642)
  <-0.6411290679980194, 2.541280899560254, 0.7111476698265128>, BranchRadius(0.016905819901438596)
  <-0.6460187854974176, 2.54067905947697, 0.727194382338913>, BranchRadius(0.016785962324674483)
  <-0.6472451609245998, 2.540416273536263, 0.743812000424112>, BranchRadius(0.01666488175669306)
  <-0.6425187350651581, 2.5382624996755094, 0.7594763711693407>, BranchRadius(0.016503040752905006)
  <-0.6346728220875099, 2.5395536935558938, 0.7737702929751982>, BranchRadius(0.01635670298934169)
  <-0.6304096122441222, 2.5387180282546282, 0.7894039556258796>, BranchRadius(0.016226050121326753)
  <-0.6329527510558222, 2.537740984619476, 0.7994135600252902>, BranchRadius(0.010373733634196785)
  <-0.6364624409670269, 2.5375082605951587, 0.8090825316647805>, BranchRadius(0.010288882170069534)
  <-0.6397948731612388, 2.5388179903873653, 0.814607015024016>, BranchRadius(0.006583343591525891)
  <-0.6430206706682533, 2.540081494309296, 0.8201359256947514>, BranchRadius(0.00652465055937604)
  <-0.6478296736291039, 2.5419798988154545, 0.8240587418058198>, BranchRadius(0.0064899102757844124)
  <-0.6531228608766974, 2.5426415230281987, 0.8276551574954697>, BranchRadius(0.006433489228228718)
  <-0.6583288383353758, 2.543485682576334, 0.8312516975419448>, BranchRadius(0.006383565379071133)
  <-0.6615786128342228, 2.5441383472913692, 0.8366486971718771>, BranchRadius(0.0063336095971489)
  <-0.6645348236195534, 2.5438574062918695, 0.842198288917899>, BranchRadius(0.006294130488003915)
  <-0.6671863617729046, 2.5450467117821605, 0.8477451107981047>, BranchRadius(0.006261975335199031)
  <-0.6684420644685484, 2.5449401008950736, 0.8538317788971772>, BranchRadius(0.006215760909925655)
  <-0.6672556268258812, 2.544042189341776, 0.8598339115317044>, BranchRadius(0.006183807532575645)
  <-0.6673928154881609, 2.543537245297374, 0.8625479338552404>, BranchRadius(0.00276400187946526)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-0.6329527510558222, 2.537740984619476, 0.7994135600252902>, BranchRadius(0.010373733634196785)
  <-0.6364624409670269, 2.5375082605951587, 0.8090825316647805>, BranchRadius(0.010288882170069534)
  <-0.6355026559257747, 2.5341071093801895, 0.8147142202096539>, BranchRadius(0.0066486790251114)
  <-0.6333742513426003, 2.529151200297535, 0.8185119712296032>, BranchRadius(0.006596518302463651)
  <-0.632544490318788, 2.5251894973982663, 0.8236416361050571>, BranchRadius(0.006534298352017696)
  <-0.6318057859487739, 2.523945913650393, 0.8299738823190043>, BranchRadius(0.006495346549515305)
  <-0.6295074866655325, 2.521471250687748, 0.8354653664877633>, BranchRadius(0.006446901174189435)
  <-0.6271274199423361, 2.5192428419409314, 0.840973402681268>, BranchRadius(0.006400701981713589)
  <-0.6255451077276603, 2.5200328702753345, 0.844077816914906>, BranchRadius(0.003572848226259636)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.6346728220875099, 2.5395536935558938, 0.7737702929751982>, BranchRadius(0.01635670298934169)
  <-0.6304096122441222, 2.5387180282546282, 0.7894039556258796>, BranchRadius(0.016226050121326753)
  <-0.6232218038766524, 2.538637550266808, 0.7983542541626284>, BranchRadius(0.01147949954183199)
  <-0.6192468040717223, 2.54057435423523, 0.80393620687528>, BranchRadius(0.007121097467916514)
  <-0.6164897218781703, 2.539809027302888, 0.8042862584108952>, BranchRadius(0.0028826660599098617)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.6232218038766524, 2.538637550266808, 0.7983542541626284>, BranchRadius(0.01147949954183199)
  <-0.6192468040717223, 2.54057435423523, 0.80393620687528>, BranchRadius(0.007121097467916514)
  <-0.6165724617362768, 2.542061446559462, 0.8079990276207312>, BranchRadius(0.005086262175469893)
  <-0.6142173908697052, 2.543254055027578, 0.8123120056978639>, BranchRadius(0.005056723607102115)
  <-0.6138646285995428, 2.543203631285952, 0.8173187809506055>, BranchRadius(0.00501944042742173)
  <-0.6118143981698763, 2.545240705035405, 0.8191338392028209>, BranchRadius(0.003412850822168398)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <-0.6304096122441222, 2.5387180282546282, 0.7894039556258796>, BranchRadius(0.016226050121326753)
  <-0.6232218038766524, 2.538637550266808, 0.7983542541626284>, BranchRadius(0.01147949954183199)
  <-0.6196026045660628, 2.5353661374544623, 0.8018298829476502>, BranchRadius(0.005990053496407575)
  <-0.6146977865165308, 2.533853993596003, 0.804853491462648>, BranchRadius(0.005957014990719469)
  <-0.6111621220688584, 2.53016738323141, 0.8078250541558027>, BranchRadius(0.005909501155445147)
  <-0.6084304077805711, 2.525563801545483, 0.8102108868752187>, BranchRadius(0.005860667628937446)
  <-0.6075379347192614, 2.5211521993862758, 0.8138723848905974>, BranchRadius(0.00580218144260463)
  <-0.6084254660742828, 2.5158863738269996, 0.8160443234150955>, BranchRadius(0.005764889216721246)
  <-0.6104791200946863, 2.5105466274596298, 0.8158272934098478>, BranchRadius(0.005725162716162514)
  <-0.6136216283078325, 2.5059289354895333, 0.8168921373911513>, BranchRadius(0.005686152451781732)
  <-0.6147536293115772, 2.500457370029525, 0.8176663161666449>, BranchRadius(0.005640816220376173)
  <-0.6146442994768542, 2.4981191452193308, 0.8169188966307775>, BranchRadius(0.0024572106621870483)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  18
  <-0.34634409868751015, 2.5318682399374466, 0.5310941324579809>, BranchRadius(0.07390598504557713)
  <-0.4079637343632035, 2.5306996580282846, 0.5705738339112031>, BranchRadius(0.0731914743075937)
  <-0.4410477069533878, 2.492797880828301, 0.5862819732757661>, BranchRadius(0.05270521415914942)
  <-0.4438022431132999, 2.4691783123141864, 0.5892580677339808>, BranchRadius(0.023965154380338125)
  <-0.44392776213730967, 2.44624326442659, 0.5831543538218577>, BranchRadius(0.02373367860557623)
  <-0.4460134019572168, 2.4330880510243493, 0.5773153711611008>, BranchRadius(0.014543151365144003)
  <-0.4425393178825848, 2.4271994804857733, 0.5690045567217168>, BranchRadius(0.010761698740964044)
  <-0.43849701141692543, 2.4212816797474783, 0.5611041072252015>, BranchRadius(0.010666663460870172)
  <-0.4369790848850134, 2.41909256385012, 0.5508326514468206>, BranchRadius(0.010611273871481466)
  <-0.4388035432704627, 2.420812457970527, 0.5406199822791391>, BranchRadius(0.01051595434157835)
  <-0.44076940306113355, 2.4242070017833957, 0.5309633260551704>, BranchRadius(0.010422981427690214)
  <-0.43906386334418573, 2.429329797887432, 0.5221302632728749>, BranchRadius(0.01035253127334524)
  <-0.43518697424987224, 2.4331782968898916, 0.5134043566042275>, BranchRadius(0.010294788041115072)
  <-0.43283630651683763, 2.435570384972456, 0.5037336334774084>, BranchRadius(0.010235751559190381)
  <-0.4333755894635716, 2.436554535082124, 0.49361350227197626>, BranchRadius(0.010182162498711123)
  <-0.4339908333183217, 2.439226343489314, 0.48386484362262555>, BranchRadius(0.010126866772457244)
  <-0.4356126596840615, 2.4394321266598262, 0.47696013582166>, BranchRadius(0.007095608310116116)
  <-0.4358078151979432, 2.4373787269852265, 0.4740495047197438>, BranchRadius(0.0035673953116646282)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.4333755894635716, 2.436554535082124, 0.49361350227197626>, BranchRadius(0.010182162498711123)
  <-0.4339908333183217, 2.439226343489314, 0.48386484362262555>, BranchRadius(0.010126866772457244)
  <-0.43074852363567223, 2.4451056301179666, 0.4803775451160521>, BranchRadius(0.007565701171339282)
  <-0.4268354169737216, 2.450188868408029, 0.4764642658716217>, BranchRadius(0.007514350917161423)
  <-0.4227921908876644, 2.455506915361084, 0.47314872413650927>, BranchRadius(0.007458023704383358)
  <-0.4224629477497872, 2.457097742304869, 0.46905237158261864>, BranchRadius(0.0044067261833109946)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.4268354169737216, 2.450188868408029, 0.4764642658716217>, BranchRadius(0.007514350917161423)
  <-0.4227921908876644, 2.455506915361084, 0.47314872413650927>, BranchRadius(0.007458023704383358)
  <-0.41898650729429965, 2.4591456974508907, 0.47454523963543266>, BranchRadius(0.0054474047259807454)
  <-0.4152042274557883, 2.462700211358045, 0.4760723010289389>, BranchRadius(0.005410372112202705)
  <-0.4132790565931933, 2.4649236238216425, 0.4780434675793666>, BranchRadius(0.0035405286897567446)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.44392776213730967, 2.44624326442659, 0.5831543538218577>, BranchRadius(0.02373367860557623)
  <-0.4460134019572168, 2.4330880510243493, 0.5773153711611008>, BranchRadius(0.014543151365144003)
  <-0.4492326997719619, 2.4272715309391715, 0.5777028753063693>, BranchRadius(0.006659275019392239)
  <-0.452285262880715, 2.421730017694527, 0.5795881342259953>, BranchRadius(0.006601568886826831)
  <-0.4540572547368589, 2.4202138267182893, 0.5830042477532066>, BranchRadius(0.004136256984939389)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <-0.4438022431132999, 2.4691783123141864, 0.5892580677339808>, BranchRadius(0.023965154380338125)
  <-0.44392776213730967, 2.44624326442659, 0.5831543538218577>, BranchRadius(0.02373367860557623)
  <-0.4430726053574799, 2.4321906368543122, 0.5804967131490814>, BranchRadius(0.014327270806012598)
  <-0.4439038337060739, 2.4186960926245757, 0.575995900652452>, BranchRadius(0.014249595701830688)
  <-0.44060258571913297, 2.4080328707031082, 0.5672735810142042>, BranchRadius(0.014166206263128818)
  <-0.43469212014302006, 2.400583772606152, 0.5630097012227816>, BranchRadius(0.01042129246591767)
  <-0.42702161067735334, 2.394220601614023, 0.5602464360803021>, BranchRadius(0.010342257721871074)
  <-0.42001146438482195, 2.386919802068687, 0.5584419908156205>, BranchRadius(0.010281043125923626)
  <-0.4128106043217653, 2.3797017176809843, 0.5585452110527662>, BranchRadius(0.010196263153385093)
  <-0.4051771615001475, 2.3740308254606908, 0.5619706704701446>, BranchRadius(0.010107533829040685)
  <-0.3972470237978341, 2.369046174244661, 0.565568584823348>, BranchRadius(0.010033883566003036)
  <-0.39665894519474293, 2.3647708184774983, 0.5655699267724741>, BranchRadius(0.0043156117967274215)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.4051771615001475, 2.3740308254606908, 0.5619706704701446>, BranchRadius(0.010107533829040685)
  <-0.3972470237978341, 2.369046174244661, 0.565568584823348>, BranchRadius(0.010033883566003036)
  <-0.3913159923412037, 2.368284073474022, 0.5684610983962444>, BranchRadius(0.0066426324972511585)
  <-0.3852427959046324, 2.367651684654622, 0.57090620037575>, BranchRadius(0.0065773972258232095)
  <-0.38267331901435797, 2.368043007221978, 0.5695692455615019>, BranchRadius(0.0029228056754970035)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.4439038337060739, 2.4186960926245757, 0.575995900652452>, BranchRadius(0.014249595701830688)
  <-0.44060258571913297, 2.4080328707031082, 0.5672735810142042>, BranchRadius(0.014166206263128818)
  <-0.4403588284416216, 2.4033833276494763, 0.5628634636583048>, BranchRadius(0.006413018268391328)
  <-0.4403757748349023, 2.40078859563704, 0.5606749183822815>, BranchRadius(0.0033945031774634325)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <-0.4079637343632035, 2.5306996580282846, 0.5705738339112031>, BranchRadius(0.0731914743075937)
  <-0.4410477069533878, 2.492797880828301, 0.5862819732757661>, BranchRadius(0.05270521415914942)
  <-0.4635761548884122, 2.4902135782713435, 0.5950850657204584>, BranchRadius(0.024324967063837872)
  <-0.4720939710750572, 2.487272518667743, 0.5995319308872912>, BranchRadius(0.01004876280909219)
  <-0.480692494622822, 2.482903783141536, 0.6020754856497954>, BranchRadius(0.009974473827188489)
  <-0.48948993590317946, 2.481968359824343, 0.6065669866908892>, BranchRadius(0.00992187338489224)
  <-0.49932860365339626, 2.4818858136488244, 0.6070667332939943>, BranchRadius(0.009851697500307458)
  <-0.504856367062186, 2.482090961732887, 0.6071778052416231>, BranchRadius(0.0055326838891716044)
  <-0.5102460911601847, 2.4811334728906957, 0.6069735996424906>, BranchRadius(0.005477920286220514)
  <-0.5156651448312336, 2.4806330427463443, 0.6069920870889681>, BranchRadius(0.005442142482952928)
  <-0.5208898757393129, 2.4804444439889877, 0.60832914648598>, BranchRadius(0.005396397908258162)
  <-0.5230506111953258, 2.4799244905907565, 0.6097542041111629>, BranchRadius(0.0026400603179275142)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.48948993590317946, 2.481968359824343, 0.6065669866908892>, BranchRadius(0.00992187338489224)
  <-0.49932860365339626, 2.4818858136488244, 0.6070667332939943>, BranchRadius(0.009851697500307458)
  <-0.5059018175411779, 2.4789288267874556, 0.6093585011649959>, BranchRadius(0.007563273900063954)
  <-0.5128268383188734, 2.479627632548765, 0.6121204437119837>, BranchRadius(0.007488161917080574)
  <-0.5158444128822584, 2.480929889822755, 0.6165731579310697>, BranchRadius(0.005534283528163169)
  <-0.5180241984625256, 2.483527949969196, 0.6208836894801876>, BranchRadius(0.0054847118371345255)
  <-0.5193462486275106, 2.486713587844111, 0.6250844512709136>, BranchRadius(0.005435301733230209)
  <-0.5200294133456262, 2.488885910197589, 0.6278448232130848>, BranchRadius(0.003578456608459054)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.4410477069533878, 2.492797880828301, 0.5862819732757661>, BranchRadius(0.05270521415914942)
  <-0.4635761548884122, 2.4902135782713435, 0.5950850657204584>, BranchRadius(0.024324967063837872)
  <-0.4752079910226128, 2.4910168260658345, 0.5984128942000168>, BranchRadius(0.012125149948005141)
  <-0.48512331886735927, 2.4871595194950995, 0.6040312144374593>, BranchRadius(0.012031544478573726)
  <-0.48585413997731397, 2.4840663835397665, 0.6079938239018419>, BranchRadius(0.005079750318681342)
  <-0.48591843132898277, 2.481032142242332, 0.6120163904348427>, BranchRadius(0.005039027201888773)
  <-0.4862016373742032, 2.478503361403778, 0.6163251173212643>, BranchRadius(0.005004004953560743)
  <-0.48666804421045545, 2.4761102911722723, 0.6206627275694169>, BranchRadius(0.0049758600397017795)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-0.4752079910226128, 2.4910168260658345, 0.5984128942000168>, BranchRadius(0.012125149948005141)
  <-0.48512331886735927, 2.4871595194950995, 0.6040312144374593>, BranchRadius(0.012031544478573726)
  <-0.491314871229119, 2.4875508351424043, 0.604002204397579>, BranchRadius(0.006203973740003428)
  <-0.49729656477523415, 2.4890319858239294, 0.6042269611885722>, BranchRadius(0.006166439867226136)
  <-0.5031909016971282, 2.490725637602829, 0.6042550827296376>, BranchRadius(0.006132899389199672)
  <-0.5089978396990199, 2.49250176173937, 0.6048311642785957>, BranchRadius(0.0060997553932324)
  <-0.5115648999825304, 2.4948031592816675, 0.6038558633161131>, BranchRadius(0.0035829374979602546)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <-0.028417943933630244, 1.4493819790534814, -5.140901784074167E-4>, BranchRadius(0.46033949610459707)
  <-0.13356186916662127, 1.8923576631223678, -0.023425641034545138>, BranchRadius(0.45585923359336694)
  <-0.14853042299744493, 2.0537015694794234, -0.1700700913235149>, BranchRadius(0.21854177752295956)
  <-0.06599597597670302, 2.140211762746538, -0.26612906344608606>, BranchRadius(0.15337299178596608)
  <-0.025753988395509957, 2.1669471011143853, -0.34925937121627904>, BranchRadius(0.09615011155529246)
  <0.0031484397890617598, 2.1762620659794103, -0.3900663756215884>, BranchRadius(0.05086580908563151)
  <0.012551970909371652, 2.1908991669167848, -0.40880718518502607>, BranchRadius(0.025571254651943896)
  <0.024737913534218017, 2.2056034012218744, -0.4255563057059567>, BranchRadius(0.025401668102305423)
  <0.028215769707038735, 2.2095568399963637, -0.43823992330903516>, BranchRadius(0.013733146660674147)
  <0.03139514055468345, 2.2149817691086784, -0.45034260763981304>, BranchRadius(0.013638666462339697)
  <0.034887306680938826, 2.2208020234722117, -0.46205208378086743>, BranchRadius(0.013534489890923687)
  <0.039544421301235026, 2.2278988009148812, -0.47247829829136967>, BranchRadius(0.013444661233231795)
  <0.04407079294106518, 2.2288128849390274, -0.4785852462209526>, BranchRadius(0.0076562655935968746)
  <0.04656200280606279, 2.230111011553852, -0.48072004759834513>, BranchRadius(0.003528262493139373)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.039544421301235026, 2.2278988009148812, -0.47247829829136967>, BranchRadius(0.013444661233231795)
  <0.04407079294106518, 2.2288128849390274, -0.4785852462209526>, BranchRadius(0.0076562655935968746)
  <0.0468934346836306, 2.2289309543738898, -0.48309065848892135>, BranchRadius(0.005317893051076238)
  <0.049019555119575314, 2.2301592813577322, -0.4877774930687701>, BranchRadius(0.00529108624634335)
  <0.051470753205457236, 2.2312470962033735, -0.4922911596997965>, BranchRadius(0.005250228533184971)
  <0.05495332468528138, 2.2315871071824533, -0.4961486601450054>, BranchRadius(0.0052080919022965185)
  <0.05699568828875458, 2.2314256932888408, -0.5008801658114107>, BranchRadius(0.005156010997376617)
  <0.05715311584511517, 2.2324729775708354, -0.503509382198327>, BranchRadius(0.002834495830309804)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <0.034887306680938826, 2.2208020234722117, -0.46205208378086743>, BranchRadius(0.013534489890923687)
  <0.039544421301235026, 2.2278988009148812, -0.47247829829136967>, BranchRadius(0.013444661233231795)
  <0.04200450906573702, 2.2318204281988536, -0.4781021610526121>, BranchRadius(0.007284162595709935)
  <0.044426376084647175, 2.2357056374593327, -0.4836788584552704>, BranchRadius(0.007215250846354027)
  <0.047194144685441246, 2.241476955579085, -0.4868520441939258>, BranchRadius(0.007144071920055892)
  <0.04969625937715634, 2.2474211469878185, -0.4898328326407514>, BranchRadius(0.007104863770606868)
  <0.05297895386876031, 2.2532272841045033, -0.4921486380087165>, BranchRadius(0.007060472069575106)
  <0.05609634279699882, 2.258939233831585, -0.49479283558606885>, BranchRadius(0.007023977807673531)
  <0.05993219647610185, 2.2630695376127794, -0.4989002129223543>, BranchRadius(0.006974505814397787)
  <0.06428252319733235, 2.2672244048806998, -0.5023152001082128>, BranchRadius(0.006917398504861993)
  <0.06847118100353135, 2.2725349282660336, -0.5035019507689896>, BranchRadius(0.006866941821106797)
  <0.07437630229670207, 2.2759692630097805, -0.5035075174330836>, BranchRadius(0.006831189033170802)
  <0.07840466257343974, 2.2786222054727303, -0.5037230939227627>, BranchRadius(0.004828277483101142)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <0.012551970909371652, 2.1908991669167848, -0.40880718518502607>, BranchRadius(0.025571254651943896)
  <0.024737913534218017, 2.2056034012218744, -0.4255563057059567>, BranchRadius(0.025401668102305423)
  <0.03144725700629426, 2.2140551661386496, -0.4232090849237451>, BranchRadius(0.011043417289732769)
  <0.038166199667512564, 2.2224188567825736, -0.4209509036374547>, BranchRadius(0.010963343212439877)
  <0.0435384118009463, 2.2246607713838977, -0.41483781379719636>, BranchRadius(0.00844136906439426)
  <0.04736855466552423, 2.2232601431179377, -0.40751196156182506>, BranchRadius(0.008384501468601336)
  <0.05061372015123619, 2.2212117253714343, -0.4021927299569307>, BranchRadius(0.006559065418209654)
  <0.05419670664988962, 2.222071222046084, -0.39683281193120057>, BranchRadius(0.00650424845972325)
  <0.055914453355590935, 2.2238948108622636, -0.3908729536502738>, BranchRadius(0.0064649857419931695)
  <0.055670382287208865, 2.2267317462611973, -0.38513362844642673>, BranchRadius(0.006406842197187133)
  <0.05546608829287784, 2.2295529390971924, -0.3794459936299451>, BranchRadius(0.006352169303446246)
  <0.058462571131938965, 2.2293985306895068, -0.3764509894662232>, BranchRadius(0.004239434078018352)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.03144725700629426, 2.2140551661386496, -0.4232090849237451>, BranchRadius(0.011043417289732769)
  <0.038166199667512564, 2.2224188567825736, -0.4209509036374547>, BranchRadius(0.010963343212439877)
  <0.03961291375834374, 2.226937017935506, -0.4230977189269094>, BranchRadius(0.0052072620206315345)
  <0.040345163180017254, 2.2312068647861865, -0.42589323659891265>, BranchRadius(0.00515584138606788)
  <0.04055646256594706, 2.236217109457381, -0.4269181243298772>, BranchRadius(0.0051183585217144285)
  <0.041628863721020655, 2.2407816026459857, -0.4288941367717495>, BranchRadius(0.005088149710519137)
  <0.042885926151677904, 2.2453004582137046, -0.4307557181508919>, BranchRadius(0.005046359760029217)
  <0.04410879275230538, 2.24981722089013, -0.4325508663596507>, BranchRadius(0.005011896336666175)
  <0.04590990918510604, 2.254205580711571, -0.4340255708778776>, BranchRadius(0.004967542223577192)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-0.025753988395509957, 2.1669471011143853, -0.34925937121627904>, BranchRadius(0.09615011155529246)
  <0.0031484397890617598, 2.1762620659794103, -0.3900663756215884>, BranchRadius(0.05086580908563151)
  <0.017082317168760536, 2.1751528117691032, -0.40710308880536233>, BranchRadius(0.02203708192664675)
  <0.02311764546950125, 2.1767218091818212, -0.41350652788015696>, BranchRadius(0.008938175013023852)
  <0.02678567840022138, 2.1814340036726754, -0.4200549226312554>, BranchRadius(0.008862320030144241)
  <0.03212701344174326, 2.181017147817362, -0.42185644180837617>, BranchRadius(0.005652353507649041)
  <0.034486618793368284, 2.1811735570000645, -0.4216458860183365>, BranchRadius(0.0023741387888180235)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.02311764546950125, 2.1767218091818212, -0.41350652788015696>, BranchRadius(0.008938175013023852)
  <0.02678567840022138, 2.1814340036726754, -0.4200549226312554>, BranchRadius(0.008862320030144241)
  <0.028655650393571843, 2.184889789045324, -0.42451273118407873>, BranchRadius(0.005942331603954075)
  <0.03058303390331588, 2.1867696340299436, -0.42975205366190733>, BranchRadius(0.005890596267485464)
  <0.03380764011164484, 2.1897008777952798, -0.4336534105433831>, BranchRadius(0.005849005105763991)
  <0.03563064311403081, 2.192036441112691, -0.43529930897803476>, BranchRadius(0.0033892739065371925)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <0.0031484397890617598, 2.1762620659794103, -0.3900663756215884>, BranchRadius(0.05086580908563151)
  <0.017082317168760536, 2.1751528117691032, -0.40710308880536233>, BranchRadius(0.02203708192664675)
  <0.02038974527216164, 2.1655357142830867, -0.4156008485597564>, BranchRadius(0.013252907815196955)
  <0.024789852958439426, 2.1559474370244027, -0.4234192397975615>, BranchRadius(0.013131003388455288)
  <0.02948796123533027, 2.152215542240127, -0.43030566583674285>, BranchRadius(0.009133571243243724)
  <0.034722929545075776, 2.147274750638713, -0.43580450795637343>, BranchRadius(0.009058343088516016)
  <0.037717527619630174, 2.141650918101698, -0.4338797352998092>, BranchRadius(0.0066558139856797245)
  <0.041741490818895284, 2.1365973981302293, -0.4325617390985048>, BranchRadius(0.0065929855086845545)
  <0.04470617684633554, 2.1331939348301456, -0.43147127918159306>, BranchRadius(0.004643493136282865)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.037717527619630174, 2.141650918101698, -0.4338797352998092>, BranchRadius(0.0066558139856797245)
  <0.041741490818895284, 2.1365973981302293, -0.4325617390985048>, BranchRadius(0.0065929855086845545)
  <0.04259102725916043, 2.131638714602853, -0.43373690799889714>, BranchRadius(0.005166360075765339)
  <0.04475014655815747, 2.1278437047184497, -0.43643810902043495>, BranchRadius(0.005134236372507294)
  <0.04471546561102748, 2.1251011109526527, -0.4374888816506851>, BranchRadius(0.002937200444771346)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.02948796123533027, 2.152215542240127, -0.43030566583674285>, BranchRadius(0.009133571243243724)
  <0.034722929545075776, 2.147274750638713, -0.43580450795637343>, BranchRadius(0.009058343088516016)
  <0.03742105125096778, 2.14596772934783, -0.44088511071755304>, BranchRadius(0.005899210948214432)
  <0.03929208791771691, 2.1434970015911303, -0.4458621755777676>, BranchRadius(0.005863143225167552)
  <0.041276189570866234, 2.1423714713099122, -0.451206075622905>, BranchRadius(0.00581039976906826)
  <0.04211492543235694, 2.140198989576261, -0.45648871972618166>, BranchRadius(0.00577316927261639)
  <0.04361655308003048, 2.1378596658115487, -0.4594003788629656>, BranchRadius(0.0040255534026047085)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.02038974527216164, 2.1655357142830867, -0.4156008485597564>, BranchRadius(0.013252907815196955)
  <0.024789852958439426, 2.1559474370244027, -0.4234192397975615>, BranchRadius(0.013131003388455288)
  <0.023610030122351452, 2.146022621224718, -0.42412994074726046>, BranchRadius(0.01001993245596624)
  <0.02320201254217368, 2.1399265349935024, -0.42460321391925>, BranchRadius(0.006128028490426459)
  <0.022770921152521537, 2.134196719691509, -0.4266000290169101>, BranchRadius(0.006083082583315491)
  <0.02345614138487624, 2.1287703302421317, -0.4291403687275107>, BranchRadius(0.006030634715218103)
  <0.026219132912963183, 2.1266079996979834, -0.4300232289202937>, BranchRadius(0.0036179051516641633)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.024789852958439426, 2.1559474370244027, -0.4234192397975615>, BranchRadius(0.013131003388455288)
  <0.023610030122351452, 2.146022621224718, -0.42412994074726046>, BranchRadius(0.01001993245596624)
  <0.02030019722022224, 2.140888100702053, -0.424184401374075>, BranchRadius(0.006109112930496772)
  <0.01680189525797139, 2.1360732738505943, -0.42310672589152093>, BranchRadius(0.006048310398310481)
  <0.017914592105579646, 2.1322419146514755, -0.4230178126179942>, BranchRadius(0.003990653224418319)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  19
  <-0.06599597597670302, 2.140211762746538, -0.26612906344608606>, BranchRadius(0.15337299178596608)
  <-0.025753988395509957, 2.1669471011143853, -0.34925937121627904>, BranchRadius(0.09615011155529246)
  <-0.02254475606273685, 2.188009623218128, -0.3920742233478494>, BranchRadius(0.04782301300194922)
  <-0.0237825745053624, 2.2173107709743545, -0.42950763115477647>, BranchRadius(0.04755364838126346)
  <-0.027653110005572794, 2.237090137941748, -0.4721526574234738>, BranchRadius(0.04716781390044589)
  <-0.03837144460812489, 2.2562407079780615, -0.5136134279326972>, BranchRadius(0.04691079322060659)
  <-0.047121179709061226, 2.257404543099647, -0.5496433424581747>, BranchRadius(0.037095378650716215)
  <-0.05477893399312375, 2.266561181564574, -0.5844391378549755>, BranchRadius(0.03678631003442001)
  <-0.04709698246226284, 2.268443438852538, -0.6073657235208672>, BranchRadius(0.024252496822308046)
  <-0.04630108967066089, 2.2682005070630407, -0.6257296194653806>, BranchRadius(0.018382740150777087)
  <-0.04107573426561923, 2.26620156937014, -0.6319832374647636>, BranchRadius(0.008390937318994988)
  <-0.03533877299926419, 2.2645619463594486, -0.6377634773630294>, BranchRadius(0.008307361883916689)
  <-0.02946207940456255, 2.2617149046944522, -0.6427885083704212>, BranchRadius(0.008239666890929555)
  <-0.024555442910199857, 2.2589196695327773, -0.6486819614180994>, BranchRadius(0.008162181701117864)
  <-0.017305537986668718, 2.2566122732093126, -0.6515071246634371>, BranchRadius(0.008115833078408382)
  <-0.01331761443485835, 2.253036321608059, -0.6484188184825895>, BranchRadius(0.006182928042299397)
  <-0.008111778792019573, 2.2501511214787326, -0.6469564050187648>, BranchRadius(0.006128927937714116)
  <-0.0038892774489955864, 2.2462889617225374, -0.6449141814060907>, BranchRadius(0.006075892762251245)
  <-3.7216833246115104E-4, 2.2435799779981274, -0.6434519526356941>, BranchRadius(0.004674052025138657)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.024555442910199857, 2.2589196695327773, -0.6486819614180994>, BranchRadius(0.008162181701117864)
  <-0.017305537986668718, 2.2566122732093126, -0.6515071246634371>, BranchRadius(0.008115833078408382)
  <-0.01339691049030084, 2.256395674019684, -0.6550978725330069>, BranchRadius(0.005312038627225041)
  <-0.009498762546089763, 2.25536884749256, -0.6551656184066565>, BranchRadius(0.004031689424442205)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <-0.04709698246226284, 2.268443438852538, -0.6073657235208672>, BranchRadius(0.024252496822308046)
  <-0.04630108967066089, 2.2682005070630407, -0.6257296194653806>, BranchRadius(0.018382740150777087)
  <-0.04970158989236615, 2.269545476314019, -0.6341446551593928>, BranchRadius(0.009175247668340785)
  <-0.053826966291896386, 2.2698424563024098, -0.642243011217634>, BranchRadius(0.009093420610384118)
  <-0.055786591135920355, 2.269404649314248, -0.6510606278467437>, BranchRadius(0.009043349352211776)
  <-0.05518718467765965, 2.268080520748768, -0.6599009439258285>, BranchRadius(0.008959006247249197)
  <-0.0542907726294756, 2.2673748711302677, -0.6665663425942401>, BranchRadius(0.006762324700358736)
  <-0.055081463033287835, 2.2658546983119874, -0.6730408012337105>, BranchRadius(0.006697367496735672)
  <-0.054649360367415224, 2.263807656982293, -0.679343438329513>, BranchRadius(0.006640807577450053)
  <-0.05391621072500061, 2.2622577333439047, -0.6857006369181311>, BranchRadius(0.006584356124795687)
  <-0.05424244470106475, 2.2594639743019904, -0.691585818608921>, BranchRadius(0.0065227970783263865)
  <-0.054555937620688257, 2.256638791845394, -0.697416919733757>, BranchRadius(0.0064870389278760135)
  <-0.050706639136178816, 2.2557091744599465, -0.7002147049310843>, BranchRadius(0.004848596633723687)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.055786591135920355, 2.269404649314248, -0.6510606278467437>, BranchRadius(0.009043349352211776)
  <-0.05518718467765965, 2.268080520748768, -0.6599009439258285>, BranchRadius(0.008959006247249197)
  <-0.0567262357582122, 2.265963116625712, -0.6655780960185893>, BranchRadius(0.00625157054932788)
  <-0.05696255100836732, 2.26446380354932, -0.6715900741301001>, BranchRadius(0.006200618147554333)
  <-0.05433257710160903, 2.262261743466162, -0.673612402011033>, BranchRadius(0.0039819142906479255)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.05477893399312375, 2.266561181564574, -0.5844391378549755>, BranchRadius(0.03678631003442001)
  <-0.04709698246226284, 2.268443438852538, -0.6073657235208672>, BranchRadius(0.024252496822308046)
  <-0.04326927711995256, 2.269407306119249, -0.6178405547770871>, BranchRadius(0.01119385805438276)
  <-0.04316614806470308, 2.2653117699109258, -0.6215764659469848>, BranchRadius(0.005544464329859867)
  <-0.041221161899206354, 2.26212378995562, -0.6234415910121578>, BranchRadius(0.0041743117861682034)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.04709698246226284, 2.268443438852538, -0.6073657235208672>, BranchRadius(0.024252496822308046)
  <-0.04326927711995256, 2.269407306119249, -0.6178405547770871>, BranchRadius(0.01119385805438276)
  <-0.04103241409227397, 2.2724973732033464, -0.6218445412266609>, BranchRadius(0.005530278318239519)
  <-0.03936741097074431, 2.273822633960891, -0.626891259454467>, BranchRadius(0.005477035360581573)
  <-0.038396428307102236, 2.2722383846487815, -0.6285441217428966>, BranchRadius(0.002486887001961596)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  19
  <-0.047121179709061226, 2.257404543099647, -0.5496433424581747>, BranchRadius(0.037095378650716215)
  <-0.05477893399312375, 2.266561181564574, -0.5844391378549755>, BranchRadius(0.03678631003442001)
  <-0.06704367583522494, 2.274753597038052, -0.6063455577222239>, BranchRadius(0.026408915069416294)
  <-0.08205150261436132, 2.280160003459267, -0.627068305720421>, BranchRadius(0.026151412574098257)
  <-0.103407882085612, 2.2886647368663207, -0.6392330962366728>, BranchRadius(0.02600783656418575)
  <-0.12364964423389291, 2.2977228966405874, -0.6523227993028062>, BranchRadius(0.025751107155290776)
  <-0.14244627667224674, 2.303756036665757, -0.6686200292001727>, BranchRadius(0.025599059981051966)
  <-0.15824733906195992, 2.3078499225289733, -0.6881178162620807>, BranchRadius(0.025428275097146427)
  <-0.17540865892205787, 2.3072116996758973, -0.7065656741271189>, BranchRadius(0.025204001419604664)
  <-0.19236400966356648, 2.304674942872391, -0.7246969814413861>, BranchRadius(0.024953223414463085)
  <-0.20381231765862148, 2.3115021390957335, -0.7456180572215803>, BranchRadius(0.024806567195448253)
  <-0.21563629154270325, 2.3107385689422983, -0.7558295194891653>, BranchRadius(0.01564171855753004)
  <-0.22000375311993864, 2.318456607393802, -0.7613802534972548>, BranchRadius(0.010462002016635179)
  <-0.2195775860296562, 2.3246176790406845, -0.7647290176708217>, BranchRadius(0.00702528602385863)
  <-0.2181628984065659, 2.330677374517885, -0.7679123635197549>, BranchRadius(0.006989630973180603)
  <-0.2165746762068258, 2.3347834989450917, -0.773267428164584>, BranchRadius(0.006932490527779389)
  <-0.21722334056277465, 2.337094839130339, -0.7797338103387182>, BranchRadius(0.006897619685121723)
  <-0.21794243901064533, 2.3413300283160368, -0.7850570789444257>, BranchRadius(0.0068404033992806295)
  <-0.21990388486375062, 2.344267620250298, -0.7864238216130045>, BranchRadius(0.0037874399967543384)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.21563629154270325, 2.3107385689422983, -0.7558295194891653>, BranchRadius(0.01564171855753004)
  <-0.22000375311993864, 2.318456607393802, -0.7613802534972548>, BranchRadius(0.010462002016635179)
  <-0.22730140978310712, 2.318530083339461, -0.763440121541406>, BranchRadius(0.007583155533641189)
  <-0.23429841987041114, 2.316547506008219, -0.7653137623805893>, BranchRadius(0.007509946273472601)
  <-0.24121045378657313, 2.316956345829106, -0.7680714066761294>, BranchRadius(0.007453050712160841)
  <-0.24794567283029248, 2.318290841154547, -0.7708263755771617>, BranchRadius(0.007398236748452907)
  <-0.2552791124270924, 2.3179555144477093, -0.7711981975395152>, BranchRadius(0.007350512355742305)
  <-0.258372974368892, 2.3178360346774576, -0.7713699028264999>, BranchRadius(0.0031009256418034026)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.20381231765862148, 2.3115021390957335, -0.7456180572215803>, BranchRadius(0.024806567195448253)
  <-0.21563629154270325, 2.3107385689422983, -0.7558295194891653>, BranchRadius(0.01564171855753004)
  <-0.2210802966594393, 2.309670635018567, -0.760371799008436>, BranchRadius(0.007170075160532824)
  <-0.22543004487241422, 2.3079850450373898, -0.7616157785883474>, BranchRadius(0.004827940378273201)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.21563629154270325, 2.3107385689422983, -0.7558295194891653>, BranchRadius(0.01564171855753004)
  <-0.2210802966594393, 2.309670635018567, -0.760371799008436>, BranchRadius(0.007170075160532824)
  <-0.22463007189969963, 2.3091857477608255, -0.7639396205164509>, BranchRadius(0.005056220942773369)
  <-0.22877607994417484, 2.3105983628734412, -0.7663689247299115>, BranchRadius(0.005008630863098254)
  <-0.23303767824814658, 2.3102121014557837, -0.7689101552626996>, BranchRadius(0.004976773111963245)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  20
  <-0.19236400966356648, 2.304674942872391, -0.7246969814413861>, BranchRadius(0.024953223414463085)
  <-0.20381231765862148, 2.3115021390957335, -0.7456180572215803>, BranchRadius(0.024806567195448253)
  <-0.2039571662154752, 2.321653730254673, -0.7605606042791432>, BranchRadius(0.018065311974338086)
  <-0.19733893855503493, 2.328543617672433, -0.7757240239758059>, BranchRadius(0.017922075295343384)
  <-0.19440091613816274, 2.331630553059291, -0.7929582512591762>, BranchRadius(0.01775330211142546)
  <-0.18486907474676986, 2.3357496066707597, -0.8071940806460105>, BranchRadius(0.017620483571567504)
  <-0.1744010162896876, 2.339771946877109, -0.8206094093964585>, BranchRadius(0.01748515124553118)
  <-0.16309523219231525, 2.3363785070068817, -0.8333257231070555>, BranchRadius(0.017350528020655846)
  <-0.15193684265867033, 2.332620611483226, -0.84592488248669>, BranchRadius(0.017244426717774517)
  <-0.13775272478368825, 2.329793199361564, -0.855138129888621>, BranchRadius(0.01714839312840407)
  <-0.1233875880702013, 2.3271270893687883, -0.8638703384449257>, BranchRadius(0.01702106816746673)
  <-0.11131372165664176, 2.327477125283619, -0.875682340880427>, BranchRadius(0.016894501379160015)
  <-0.0994556332350304, 2.327858245481989, -0.8875053212484268>, BranchRadius(0.016749399344527818)
  <-0.09510578334382085, 2.3263690533555654, -0.8998410564744143>, BranchRadius(0.013164697141640687)
  <-0.09219308398299508, 2.3247944668208507, -0.9075917305126451>, BranchRadius(0.008428290951833882)
  <-0.08991273864785337, 2.3227558646766977, -0.9153819055019201>, BranchRadius(0.008369151684201603)
  <-0.08885972066264, 2.3224360441899545, -0.9236225523787408>, BranchRadius(0.008313807369032478)
  <-0.08745444178959454, 2.3215802567500274, -0.9317052959211897>, BranchRadius(0.00824851041257537)
  <-0.08660306751519616, 2.3205435921853446, -0.9397903384689097>, BranchRadius(0.0081955734743348)
  <-0.08614161175723106, 2.3215400143412426, -0.9446285282064176>, BranchRadius(0.0049612375941341805)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.0994556332350304, 2.327858245481989, -0.8875053212484268>, BranchRadius(0.016749399344527818)
  <-0.09510578334382085, 2.3263690533555654, -0.8998410564744143>, BranchRadius(0.013164697141640687)
  <-0.09256728276934376, 2.326672599540379, -0.9080745825668667>, BranchRadius(0.008621315292229507)
  <-0.09088897563260992, 2.326999513989737, -0.9112406572365435>, BranchRadius(0.0035982796884593796)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.09510578334382085, 2.3263690533555654, -0.8998410564744143>, BranchRadius(0.013164697141640687)
  <-0.09256728276934376, 2.326672599540379, -0.9080745825668667>, BranchRadius(0.008621315292229507)
  <-0.09182792020514204, 2.326613029921246, -0.9131425958613771>, BranchRadius(0.00512200783816285)
  <-0.09112138337175052, 2.3250360935093544, -0.9167932656018106>, BranchRadius(0.004038974164042828)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <-0.11131372165664176, 2.327477125283619, -0.875682340880427>, BranchRadius(0.016894501379160015)
  <-0.0994556332350304, 2.327858245481989, -0.8875053212484268>, BranchRadius(0.016749399344527818)
  <-0.09109513384393401, 2.329036931505479, -0.8913728546734195>, BranchRadius(0.009286822147749419)
  <-0.08325747693176616, 2.330726589174258, -0.895942489873583>, BranchRadius(0.009228508805494565)
  <-0.0758032083061145, 2.3345834742316502, -0.8996177761310031>, BranchRadius(0.009162391181525247)
  <-0.0678935213514402, 2.3363310102856047, -0.9037216375074056>, BranchRadius(0.009080677737787235)
  <-0.05975553495712317, 2.33481607316858, -0.9072901522402252>, BranchRadius(0.009014219568047935)
  <-0.05229318677927689, 2.332549483890119, -0.911638242197513>, BranchRadius(0.008929163094115176)
  <-0.04789975968545205, 2.3286852212647053, -0.9155140870974352>, BranchRadius(0.007018326079285238)
  <-0.04508923658349723, 2.325737725709309, -0.9152651902169044>, BranchRadius(0.00408028428088574)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <-0.05975553495712317, 2.33481607316858, -0.9072901522402252>, BranchRadius(0.009014219568047935)
  <-0.05229318677927689, 2.332549483890119, -0.911638242197513>, BranchRadius(0.008929163094115176)
  <-0.04703792991894609, 2.333815889841992, -0.9132112877514909>, BranchRadius(0.005629918384655612)
  <-0.04254040119194062, 2.336381604778142, -0.9153465355356695>, BranchRadius(0.00560088750857051)
  <-0.03731589527985618, 2.3370690215226464, -0.9171149744766424>, BranchRadius(0.005558361277749025)
  <-0.03357549705269057, 2.3374824211263787, -0.9211373640760115>, BranchRadius(0.005508275249046926)
  <-0.03071561789708033, 2.3399112837093408, -0.9250987925462344>, BranchRadius(0.005456298906429153)
  <-0.028150758024945266, 2.3398182222846375, -0.9298622255183165>, BranchRadius(0.005410865020676107)
  <-0.02505616374075784, 2.3378902956606487, -0.9338125651162219>, BranchRadius(0.00537574160372228)
  <-0.02421766508759191, 2.335770560139178, -0.9356200820086277>, BranchRadius(0.002909205387847025)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  33
  <-0.027653110005572794, 2.237090137941748, -0.4721526574234738>, BranchRadius(0.04716781390044589)
  <-0.03837144460812489, 2.2562407079780615, -0.5136134279326972>, BranchRadius(0.04691079322060659)
  <-0.04229131650839038, 2.269086367471382, -0.5278944925922046>, BranchRadius(0.019604213101827108)
  <-0.047521591089859115, 2.2823296319739512, -0.5412051751139744>, BranchRadius(0.019491385175967296)
  <-0.050097529004444655, 2.2977536019973654, -0.5526085209533861>, BranchRadius(0.019353826592077666)
  <-0.05493528941631838, 2.3108697820000725, -0.565719944930757>, BranchRadius(0.01916631269651218)
  <-0.05501238150873496, 2.324615467896643, -0.5789174138942013>, BranchRadius(0.019055786811332784)
  <-0.05661215864131965, 2.340779564138556, -0.588543471492459>, BranchRadius(0.018881162016061086)
  <-0.05914836549880405, 2.35737654619061, -0.5968508486428807>, BranchRadius(0.01873244974848474)
  <-0.06096965296312265, 2.3731772687832624, -0.6065596600027203>, BranchRadius(0.01863440206979012)
  <-0.06431856083727769, 2.3867397139365014, -0.6186974570458676>, BranchRadius(0.01850624812177839)
  <-0.0718304613537204, 2.396152740416145, -0.6325303289255698>, BranchRadius(0.018340721395726574)
  <-0.07934710272421285, 2.4054289828297315, -0.6463152871335185>, BranchRadius(0.018236601755894758)
  <-0.08751095123100525, 2.4141547554203364, -0.659931702100428>, BranchRadius(0.018116133315249278)
  <-0.09544159679184844, 2.422589096388343, -0.6736372479241308>, BranchRadius(0.017940881608826603)
  <-0.10937054244939162, 2.428766351881929, -0.6828663407835897>, BranchRadius(0.017814324785754447)
  <-0.12313107769948435, 2.439207341064071, -0.6868396471999383>, BranchRadius(0.017724382904599215)
  <-0.13746644008333425, 2.447513333804156, -0.6927110080261711>, BranchRadius(0.01757740049115527)
  <-0.1508148348611171, 2.457190395654027, -0.6984647510243713>, BranchRadius(0.017462265823171674)
  <-0.16549720314199065, 2.4663259716910164, -0.6982967662117403>, BranchRadius(0.01729331971485199)
  <-0.18002159577430618, 2.4750343826356667, -0.6955365257235687>, BranchRadius(0.01715847691583097)
  <-0.19592121689219014, 2.4795004385384694, -0.6995474081551516>, BranchRadius(0.01699502235653722)
  <-0.20792301327421886, 2.481581019067153, -0.7033549483612347>, BranchRadius(0.012762025472195002)
  <-0.21838943986757597, 2.487202445217534, -0.7078359378835432>, BranchRadius(0.012697471586790724)
  <-0.22845498450680113, 2.49421320162716, -0.71059968291489>, BranchRadius(0.012573948501470918)
  <-0.2369966649860579, 2.5031538297233213, -0.7123040092321248>, BranchRadius(0.012481981587841013)
  <-0.24537814393061522, 2.512099167691999, -0.7141279623092383>, BranchRadius(0.0123933476308639)
  <-0.24836500941065892, 2.5161500906208154, -0.7151195288275258>, BranchRadius(0.005129770572966814)
  <-0.2507020398813905, 2.5205098167935858, -0.7163776445883507>, BranchRadius(0.005104094335952651)
  <-0.2526751029626278, 2.5245716205907898, -0.7186915450374782>, BranchRadius(0.0050739888941536675)
  <-0.25463943051402776, 2.5285730612563713, -0.7210388121718648>, BranchRadius(0.0050378341705071585)
  <-0.25673189508222943, 2.53284316728997, -0.7226143452255116>, BranchRadius(0.0050094428742614465)
  <-0.2594218280787028, 2.536600142167511, -0.7244661237420064>, BranchRadius(0.004977919588557063)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.2369966649860579, 2.5031538297233213, -0.7123040092321248>, BranchRadius(0.012481981587841013)
  <-0.24537814393061522, 2.512099167691999, -0.7141279623092383>, BranchRadius(0.0123933476308639)
  <-0.2512225636140606, 2.5119113688317, -0.712856996332584>, BranchRadius(0.005983967276145958)
  <-0.2560723086674678, 2.511268668404263, -0.7094884065507134>, BranchRadius(0.005939738044812979)
  <-0.26040376444504365, 2.5084927903101515, -0.7065920841131156>, BranchRadius(0.0059038709343104435)
  <-0.26470574370155475, 2.505675866897255, -0.7037914027657403>, BranchRadius(0.005855416214677835)
  <-0.2693463472614236, 2.50217064875447, -0.7036450796330276>, BranchRadius(0.005817487953364512)
  <-0.2726180495854695, 2.500734641914581, -0.7030303900658431>, BranchRadius(0.0036254647985301336)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <-0.18002159577430618, 2.4750343826356667, -0.6955365257235687>, BranchRadius(0.01715847691583097)
  <-0.19592121689219014, 2.4795004385384694, -0.6995474081551516>, BranchRadius(0.01699502235653722)
  <-0.20271548840170237, 2.4889930644548452, -0.6966781332949135>, BranchRadius(0.012021015362972154)
  <-0.2045581055196152, 2.49528593424125, -0.6923119867789392>, BranchRadius(0.00787773339170764)
  <-0.20614853754520585, 2.5014586360303652, -0.6878071065181007>, BranchRadius(0.007805489579126911)
  <-0.20781930624720235, 2.5076583640110224, -0.6834766532391756>, BranchRadius(0.0077447350303719055)
  <-0.20952619140610437, 2.51373765225618, -0.6790968934198046>, BranchRadius(0.0076846274202962365)
  <-0.2079949319509299, 2.519180272976206, -0.6739990007241581>, BranchRadius(0.007612843473856682)
  <-0.2061444530204419, 2.52461159618546, -0.6690951630738426>, BranchRadius(0.0075479247330778945)
  <-0.20589175111318253, 2.5272691051051828, -0.6676795478660782>, BranchRadius(0.0030216184949117017)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.19592121689219014, 2.4795004385384694, -0.6995474081551516>, BranchRadius(0.01699502235653722)
  <-0.20271548840170237, 2.4889930644548452, -0.6966781332949135>, BranchRadius(0.012021015362972154)
  <-0.20974003009677264, 2.4928192448144353, -0.6994896896196778>, BranchRadius(0.008478719899679238)
  <-0.21199012459656869, 2.49540939346313, -0.6980916490109593>, BranchRadius(0.003704903888628538)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  33
  <-0.14853042299744493, 2.0537015694794234, -0.1700700913235149>, BranchRadius(0.21854177752295956)
  <-0.06599597597670302, 2.140211762746538, -0.26612906344608606>, BranchRadius(0.15337299178596608)
  <-0.003091271426050035, 2.2386064198262114, -0.2630653917427427>, BranchRadius(0.11682421187723621)
  <0.05484164899300301, 2.2913185935596787, -0.2920725493469249>, BranchRadius(0.08352371950686482)
  <0.08831445577861496, 2.363323737488934, -0.31658008188416265>, BranchRadius(0.08310107518825195)
  <0.10390312645097097, 2.443798751889104, -0.32435549358028887>, BranchRadius(0.08233888281415375)
  <0.10224509788452102, 2.523644925970163, -0.3422515941565549>, BranchRadius(0.08184394290322154)
  <0.07463322090023419, 2.594831956583397, -0.3700972824944879>, BranchRadius(0.0812735592744538)
  <0.05894810003641711, 2.6640456356427604, -0.4087070349408469>, BranchRadius(0.0807915179298806)
  <0.03566937209061914, 2.700278936680846, -0.4527241663107994>, BranchRadius(0.06158132129900005)
  <0.03032506186928293, 2.7464035075310074, -0.49225415297329883>, BranchRadius(0.060980796431260094)
  <0.024147909967465582, 2.7681640962012004, -0.5032482581071074>, BranchRadius(0.02515056207293793)
  <0.021369930910428585, 2.7783842809394184, -0.5003830291410526>, BranchRadius(0.010971730982509325)
  <0.014399556707337582, 2.786666355466323, -0.4989982283497885>, BranchRadius(0.010913136498358568)
  <0.01181298802634529, 2.797113964750022, -0.4977408872746348>, BranchRadius(0.010836225535932624)
  <0.009313860051226686, 2.8070372449470686, -0.49448563271688933>, BranchRadius(0.010738426921148223)
  <0.005777451202295459, 2.81706929891411, -0.4947455268271326>, BranchRadius(0.010640293195817711)
  <0.0031636813336634725, 2.8272485560595984, -0.4935331221881401>, BranchRadius(0.010579177376752603)
  <0.005166257619102868, 2.8349989077961584, -0.49162043429601016>, BranchRadius(0.008230227140978721)
  <0.009452597560470687, 2.8419469433466653, -0.49198524042519975>, BranchRadius(0.00817196375517939)
  <0.013698523815747684, 2.84882431855102, -0.4923418976811025>, BranchRadius(0.008090326561079664)
  <0.01627914735357486, 2.8562310628859824, -0.49062856054284004>, BranchRadius(0.008028387362156544)
  <0.018622645649071665, 2.8636588758876678, -0.4888781238851306>, BranchRadius(0.007983008126117531)
  <0.019257075434364015, 2.8714951746401574, -0.48799169755885535>, BranchRadius(0.007911752708638746)
  <0.021717942625923758, 2.8788048909393775, -0.48649173175107285>, BranchRadius(0.007857335243840531)
  <0.025113072295979973, 2.885111594431423, -0.48337211292546034>, BranchRadius(0.00781238990515644)
  <0.026711159563786644, 2.889854129260892, -0.4774369416190495>, BranchRadius(0.007763490063154192)
  <0.028047610898309705, 2.895372863089368, -0.47221738645392775>, BranchRadius(0.007712735011710519)
  <0.028113579020825695, 2.901849868471954, -0.4681269089891496>, BranchRadius(0.007660806511659946)
  <0.02728570800715763, 2.9077810586335455, -0.4634537174487756>, BranchRadius(0.007596256072648874)
  <0.023917875133147918, 2.912546018416667, -0.4586706882938912>, BranchRadius(0.007544833192225096)
  <0.023480801795620405, 2.9168778407856624, -0.4525756332921398>, BranchRadius(0.007490354705438241)
  <0.024526528701084144, 2.919397766295813, -0.4493229061597193>, BranchRadius(0.004245444986748042)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.005777451202295459, 2.81706929891411, -0.4947455268271326>, BranchRadius(0.010640293195817711)
  <0.0031636813336634725, 2.8272485560595984, -0.4935331221881401>, BranchRadius(0.010579177376752603)
  <-0.0023144652625068365, 2.832149924805847, -0.493995167531115>, BranchRadius(0.007365255706002327)
  <-0.008079821790187687, 2.836601534696175, -0.4936484972813336>, BranchRadius(0.007292211377149019)
  <-0.013891394605640404, 2.8408722189096407, -0.4932630455712921>, BranchRadius(0.007222305397948022)
  <-0.018717699400545636, 2.8461276383125216, -0.4938449596252679>, BranchRadius(0.00715899958372094)
  <-0.01814051834432803, 2.84950173023661, -0.49560578150782375>, BranchRadius(0.0038494321640914772)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <0.03032506186928293, 2.7464035075310074, -0.49225415297329883>, BranchRadius(0.060980796431260094)
  <0.024147909967465582, 2.7681640962012004, -0.5032482581071074>, BranchRadius(0.02515056207293793)
  <0.020553633920328773, 2.7803976432008892, -0.517349719028544>, BranchRadius(0.019011304337562308)
  <0.014482114253391819, 2.786183434842272, -0.5299958992203835>, BranchRadius(0.015174472294876317)
  <0.005747070277844789, 2.7940007470391124, -0.5394530322119043>, BranchRadius(0.015061498187661433)
  <0.005596183876951871, 2.79390780719602, -0.5473085713924568>, BranchRadius(0.007857537803765469)
  <0.007287893215699127, 2.7933948340766435, -0.5548891839056324>, BranchRadius(0.007784003339087292)
  <0.009396474218056877, 2.7922882019860134, -0.562253701652969>, BranchRadius(0.007739952847295163)
  <0.008310707070084213, 2.7893442574789806, -0.569266134495085>, BranchRadius(0.00768244192462867)
  <0.006469161085385831, 2.788434008775073, -0.5746414693405811>, BranchRadius(0.005754482515216168)
  <0.0061915235437227465, 2.787718559025993, -0.5803150000375791>, BranchRadius(0.005725198819061056)
  <0.005557936319040455, 2.787134194792249, -0.5859186948683167>, BranchRadius(0.005669595231142626)
  <0.0038620096859231737, 2.785888838267571, -0.5911438904807377>, BranchRadius(0.005632916580825431)
  <0.0021130283295986256, 2.7824613478119007, -0.5951917063425853>, BranchRadius(0.005584929709486519)
  <0.0015107473943646154, 2.777913733426719, -0.598301402858635>, BranchRadius(0.0055419988581006125)
  <-2.5196570037942464E-4, 2.7733926386365555, -0.6008821194151458>, BranchRadius(0.0054961398727722925)
  <-0.0028311496425067334, 2.7707442485132145, -0.6014864819875343>, BranchRadius(0.003745852929793218)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  20
  <0.014482114253391819, 2.786183434842272, -0.5299958992203835>, BranchRadius(0.015174472294876317)
  <0.005747070277844789, 2.7940007470391124, -0.5394530322119043>, BranchRadius(0.015061498187661433)
  <-0.0028282638233319436, 2.8020024660617815, -0.5376923986824599>, BranchRadius(0.011860172540463045)
  <-0.01103654378104045, 2.810043854166766, -0.5350861423042601>, BranchRadius(0.011782714238579036)
  <-0.018380533338669566, 2.815839831077654, -0.5280231784539452>, BranchRadius(0.01172232866477329)
  <-0.02762123838076671, 2.821005681023833, -0.523194333736523>, BranchRadius(0.01163590893082498)
  <-0.03582130662793202, 2.82710526114755, -0.5178670932032822>, BranchRadius(0.011524994084285508)
  <-0.04283401983438384, 2.8292240836233646, -0.5090780914628387>, BranchRadius(0.011441770264844605)
  <-0.04638670940629581, 2.8343329644979356, -0.5024859616572903>, BranchRadius(0.009065232614672876)
  <-0.04961397195842205, 2.8391409480200305, -0.49562366184971557>, BranchRadius(0.008979036016084027)
  <-0.053194880613133315, 2.843540278744445, -0.4887249770594822>, BranchRadius(0.00893134197369898)
  <-0.05493049054496624, 2.8491924725077054, -0.48698925740008453>, BranchRadius(0.006162171606579724)
  <-0.05776840713486905, 2.854537009899327, -0.4861850041847351>, BranchRadius(0.0061044798088029885)
  <-0.059323256241777915, 2.8603583184257957, -0.4856348910922879>, BranchRadius(0.006050439084899445)
  <-0.05887963163940216, 2.865714859745046, -0.48298352171687114>, BranchRadius(0.005993254312772416)
  <-0.05703580071766324, 2.87013844931403, -0.4794846272633071>, BranchRadius(0.00593381155244805)
  <-0.05636961009948021, 2.8757036794000967, -0.47770947176759365>, BranchRadius(0.005879351399991194)
  <-0.056409317116543206, 2.8812449360059262, -0.4758531915236108>, BranchRadius(0.005844046351891241)
  <-0.05667174102503107, 2.88695152523544, -0.4749071334336942>, BranchRadius(0.005790427691599705)
  <-0.05582198263073605, 2.8890825330202383, -0.4753240471260887>, BranchRadius(0.0023317591072948424)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <-0.03582130662793202, 2.82710526114755, -0.5178670932032822>, BranchRadius(0.011524994084285508)
  <-0.04283401983438384, 2.8292240836233646, -0.5090780914628387>, BranchRadius(0.011441770264844605)
  <-0.047929164103157854, 2.8241426655254505, -0.5062026770781389>, BranchRadius(0.007749149171952194)
  <-0.053051685848810294, 2.8188815363710082, -0.503951493859896>, BranchRadius(0.00768033429588213)
  <-0.0560146797147109, 2.8124965379775904, -0.5010132012345192>, BranchRadius(0.007627653681549754)
  <-0.059344309343762766, 2.8072380249729876, -0.4966943515546542>, BranchRadius(0.007575675220302537)
  <-0.05999618079716431, 2.800172224367577, -0.4941608608327392>, BranchRadius(0.007534523861878228)
  <-0.061209218186887814, 2.7947573859732118, -0.4928677184551835>, BranchRadius(0.00569773215890224)
  <-0.06040855047652087, 2.789234418199811, -0.491906805377313>, BranchRadius(0.005662825774440522)
  <-0.05851972679187378, 2.7841648322369474, -0.4934631785022312>, BranchRadius(0.005629445270230307)
  <-0.05690975482472345, 2.7823743308480178, -0.4926075655930903>, BranchRadius(0.002555382243238327)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.059344309343762766, 2.8072380249729876, -0.4966943515546542>, BranchRadius(0.007575675220302537)
  <-0.05999618079716431, 2.800172224367577, -0.4941608608327392>, BranchRadius(0.007534523861878228)
  <-0.06012815934542799, 2.7953785368720703, -0.49216008567930336>, BranchRadius(0.005196148511771302)
  <-0.05968168737279782, 2.7911077385563643, -0.4893135170222622>, BranchRadius(0.005151893690191228)
  <-0.058943472034258364, 2.7882979661213287, -0.4877666094813792>, BranchRadius(0.0032913076372135743)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <0.024147909967465582, 2.7681640962012004, -0.5032482581071074>, BranchRadius(0.02515056207293793)
  <0.020553633920328773, 2.7803976432008892, -0.517349719028544>, BranchRadius(0.019011304337562308)
  <0.020444956174573575, 2.7889797278462183, -0.5239433846670609>, BranchRadius(0.010823142531842175)
  <0.021943877205655386, 2.797589785102845, -0.5302172854053865>, BranchRadius(0.010758330757797223)
  <0.01938215374782187, 2.8045592317105528, -0.5378632005323504>, BranchRadius(0.010658125126908708)
  <0.01907566094373849, 2.809887775838445, -0.5469776121243028>, BranchRadius(0.010562188174302031)
  <0.016492250011819327, 2.8182000747631597, -0.5527874111702933>, BranchRadius(0.010465280235701492)
  <0.011215224780747624, 2.825645254478848, -0.5576979201383329>, BranchRadius(0.01036295298712974)
  <0.007976947030844117, 2.8307572322970307, -0.5660312505208145>, BranchRadius(0.01029869677496637)
  <0.007267056261680398, 2.830635687632704, -0.5714755075216147>, BranchRadius(0.00549168938490986)
  <0.006681228609706297, 2.828707047040704, -0.5765374935479225>, BranchRadius(0.005448536601828497)
  <0.004689940239183727, 2.8258752535750484, -0.5807082021946637>, BranchRadius(0.005420248538831717)
  <0.0011373712709143863, 2.8230413617777548, -0.58358894666167>, BranchRadius(0.005380555517534156)
  <0.001870464221341117, 2.8202335552669506, -0.5856075441303741>, BranchRadius(0.003534959464652784)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.011215224780747624, 2.825645254478848, -0.5576979201383329>, BranchRadius(0.01036295298712974)
  <0.007976947030844117, 2.8307572322970307, -0.5660312505208145>, BranchRadius(0.01029869677496637)
  <0.005637459643518373, 2.8358348307538956, -0.5680198866826297>, BranchRadius(0.005933791461510282)
  <0.002827741450310726, 2.840492731344092, -0.570260373005628>, BranchRadius(0.00588305475046239)
  <-5.415858888102899E-4, 2.8423456447713518, -0.5683821199948521>, BranchRadius(0.004279426276915644)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <0.03566937209061914, 2.700278936680846, -0.4527241663107994>, BranchRadius(0.06158132129900005)
  <0.03032506186928293, 2.7464035075310074, -0.49225415297329883>, BranchRadius(0.060980796431260094)
  <0.03805584051343798, 2.7528272261538795, -0.5155062847724913>, BranchRadius(0.025331615278102106)
  <0.039170585384616555, 2.7510530557631547, -0.5405395744142862>, BranchRadius(0.02512082655871708)
  <0.040713734374125336, 2.7478474752607145, -0.5578294101840713>, BranchRadius(0.01765206719077352)
  <0.04729712151360874, 2.7492568533881574, -0.5739931908458157>, BranchRadius(0.017509858315115256)
  <0.057482370824440215, 2.750654463151237, -0.588055347689715>, BranchRadius(0.017419439476517945)
  <0.07023520659713406, 2.745720241899584, -0.5985647356200463>, BranchRadius(0.017246118237903705)
  <0.0814971361741194, 2.7392106057413574, -0.6097064320415032>, BranchRadius(0.017127282909363467)
  <0.09644643589162047, 2.7390186677603854, -0.6177239737834168>, BranchRadius(0.016964650830934996)
  <0.10347909044695355, 2.735948365198564, -0.6163444636639137>, BranchRadius(0.007796668268278869)
  <0.10680611233983606, 2.7358738009641437, -0.6179198869893318>, BranchRadius(0.0036819279127985917)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.09644643589162047, 2.7390186677603854, -0.6177239737834168>, BranchRadius(0.016964650830934996)
  <0.10347909044695355, 2.735948365198564, -0.6163444636639137>, BranchRadius(0.007796668268278869)
  <0.10795122103273237, 2.7327472043622536, -0.6134481061646634>, BranchRadius(0.006215808027895291)
  <0.11241319825846785, 2.7299349796271852, -0.6102388855418935>, BranchRadius(0.006173892267372554)
  <0.11627209895012103, 2.726661247230545, -0.6067739524632412>, BranchRadius(0.006133041626501056)
  <0.11855281590297838, 2.721651607111436, -0.6041454522238857>, BranchRadius(0.006099768639082203)
  <0.1209326297968226, 2.7180219034379496, -0.6023067589394515>, BranchRadius(0.004713709358973659)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.0814971361741194, 2.7392106057413574, -0.6097064320415032>, BranchRadius(0.017127282909363467)
  <0.09644643589162047, 2.7390186677603854, -0.6177239737834168>, BranchRadius(0.016964650830934996)
  <0.10242535457434838, 2.7389719176770138, -0.6209824442967611>, BranchRadius(0.0068093527057498235)
  <0.10437598079611791, 2.741262145103724, -0.62525935953158>, BranchRadius(0.005228966269630675)
  <0.10642505876871512, 2.7438018029065754, -0.6292963708808079>, BranchRadius(0.005190957804409755)
  <0.10889486900849997, 2.747024784997775, -0.6324883167020388>, BranchRadius(0.005164890541571207)
  <0.11129003531230242, 2.7477349637166273, -0.63518796094906>, BranchRadius(0.0036782134924520835)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  19
  <0.03805584051343798, 2.7528272261538795, -0.5155062847724913>, BranchRadius(0.025331615278102106)
  <0.039170585384616555, 2.7510530557631547, -0.5405395744142862>, BranchRadius(0.02512082655871708)
  <0.03632923631318769, 2.7588368300479593, -0.5522875499343973>, BranchRadius(0.0143762072704738)
  <0.03631214363533346, 2.761897767672994, -0.5609673308112343>, BranchRadius(0.009203707262505342)
  <0.036900159948185976, 2.7678677020004976, -0.5678730170507716>, BranchRadius(0.009147370195735003)
  <0.03731656746149638, 2.771176905797899, -0.5763103460333218>, BranchRadius(0.00907263717723002)
  <0.039518087116134505, 2.7718242219645632, -0.5850087591978977>, BranchRadius(0.008996004590430824)
  <0.0426046268159962, 2.7698747082526074, -0.5931381949975397>, BranchRadius(0.008911512635485992)
  <0.04437349836935559, 2.7656840056076457, -0.6007336068205756>, BranchRadius(0.008853314407174732)
  <0.04799093360759992, 2.763529374267016, -0.6084302754625007>, BranchRadius(0.008773082816234446)
  <0.05106426257967503, 2.7622561146080113, -0.6164733154441291>, BranchRadius(0.008703851634530411)
  <0.05170780833221505, 2.7601461073702294, -0.6248330101180645>, BranchRadius(0.008645853151686589)
  <0.052747224374111536, 2.75842446802899, -0.6331861651885415>, BranchRadius(0.008591834923978218)
  <0.0545478452268469, 2.756443745905546, -0.6412628626114021>, BranchRadius(0.008508732975364017)
  <0.05259513049360515, 2.754192105734526, -0.6491614412931466>, BranchRadius(0.008442187126620555)
  <0.05033682938382943, 2.751921796966924, -0.6569159956014743>, BranchRadius(0.008389716224251541)
  <0.04571238623189287, 2.7494621009044895, -0.6633627379353993>, BranchRadius(0.008306387054855355)
  <0.03952767497074708, 2.747811982223162, -0.6685624512555898>, BranchRadius(0.00824685174223327)
  <0.036454087318982656, 2.74478451627585, -0.6705098667712407>, BranchRadius(0.004733383388846727)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.039170585384616555, 2.7510530557631547, -0.5405395744142862>, BranchRadius(0.02512082655871708)
  <0.03632923631318769, 2.7588368300479593, -0.5522875499343973>, BranchRadius(0.0143762072704738)
  <0.03096377918656687, 2.765812028931481, -0.5524120797417922>, BranchRadius(0.008800967976036508)
  <0.025768884558996452, 2.7727278201610317, -0.5511159606685885>, BranchRadius(0.008746143331446897)
  <0.02137567604602814, 2.780108951349133, -0.5499128272739932>, BranchRadius(0.008673460014294624)
  <0.018420061205064668, 2.7845254403945705, -0.5504925201412826>, BranchRadius(0.0053457533049121216)
  <0.01608013335850691, 2.787294213210128, -0.5505356739451407>, BranchRadius(0.0036253589452705176)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.025768884558996452, 2.7727278201610317, -0.5511159606685885>, BranchRadius(0.008746143331446897)
  <0.02137567604602814, 2.780108951349133, -0.5499128272739932>, BranchRadius(0.008673460014294624)
  <0.020183929033873726, 2.7839582881087823, -0.5449155047578969>, BranchRadius(0.0064195706055817925)
  <0.020365172985777613, 2.787623277095465, -0.5443928708069095>, BranchRadius(0.003706499681550574)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  12
  <0.07463322090023419, 2.594831956583397, -0.3700972824944879>, BranchRadius(0.0812735592744538)
  <0.05894810003641711, 2.6640456356427604, -0.4087070349408469>, BranchRadius(0.0807915179298806)
  <0.06722111952508737, 2.6967011582325813, -0.4021613590580999>, BranchRadius(0.034317224244338085)
  <0.08871587090432496, 2.709135071603109, -0.41146602865330256>, BranchRadius(0.026517982857617885)
  <0.11345319217923522, 2.7162230748157556, -0.4167106963501922>, BranchRadius(0.026261785785650894)
  <0.12533035180119814, 2.7116038354980865, -0.4205926901480485>, BranchRadius(0.013321943116755903)
  <0.1378105137726428, 2.7110703878288636, -0.4250172760676313>, BranchRadius(0.013252017575035989)
  <0.14801233894043972, 2.7146865226999637, -0.4325276196652542>, BranchRadius(0.0131741766010114)
  <0.15915352536018856, 2.7197697609312965, -0.4371526859896116>, BranchRadius(0.013090324070120878)
  <0.17025547155844845, 2.7218583823313907, -0.4435723750580661>, BranchRadius(0.012993381256532991)
  <0.1755448175047414, 2.7216459920385465, -0.44242298678147307>, BranchRadius(0.005416953349109609)
  <0.1775728946188939, 2.721211783669776, -0.4431775294376113>, BranchRadius(0.002207027029374909)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.15915352536018856, 2.7197697609312965, -0.4371526859896116>, BranchRadius(0.013090324070120878)
  <0.17025547155844845, 2.7218583823313907, -0.4435723750580661>, BranchRadius(0.012993381256532991)
  <0.17323635843003296, 2.7231150926332464, -0.44772125472733093>, BranchRadius(0.005261008442686071)
  <0.17492522514925693, 2.7239292334364573, -0.44991549588580976>, BranchRadius(0.0028861376100798703)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <0.08871587090432496, 2.709135071603109, -0.41146602865330256>, BranchRadius(0.026517982857617885)
  <0.11345319217923522, 2.7162230748157556, -0.4167106963501922>, BranchRadius(0.026261785785650894)
  <0.12341317971657959, 2.7312149118036246, -0.41675881402925996>, BranchRadius(0.01799885672274567)
  <0.1352723900956567, 2.7433148963346246, -0.4224172083439868>, BranchRadius(0.017862472468462492)
  <0.14085514109539185, 2.749721317959092, -0.42252636892075474>, BranchRadius(0.00849830940758254)
  <0.14712009405846496, 2.754996955906928, -0.4204841549326768>, BranchRadius(0.008441127256431162)
  <0.15220704774890323, 2.761630639416163, -0.42053903671412474>, BranchRadius(0.008359776717071808)
  <0.15802242969948505, 2.767517378330549, -0.42111756882489515>, BranchRadius(0.008295002210999857)
  <0.16185573160242747, 2.7744909093902677, -0.4189362901009132>, BranchRadius(0.008251200869671217)
  <0.16408983590019743, 2.7802827797108125, -0.41362263505117297>, BranchRadius(0.008171408312582994)
  <0.16878712575616892, 2.7852749049609344, -0.40925095864451494>, BranchRadius(0.008130030818419315)
  <0.1726163251512321, 2.7907898077208118, -0.4048105965584472>, BranchRadius(0.008049455628391359)
  <0.1707316713398936, 2.794411591500094, -0.40338477466072914>, BranchRadius(0.004324604700602884)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.12341317971657959, 2.7312149118036246, -0.41675881402925996>, BranchRadius(0.01799885672274567)
  <0.1352723900956567, 2.7433148963346246, -0.4224172083439868>, BranchRadius(0.017862472468462492)
  <0.14435948127979156, 2.752390557582798, -0.42745753488000965>, BranchRadius(0.013796657017919546)
  <0.15345562540650445, 2.752626356824351, -0.4287093966427198>, BranchRadius(0.009184911383850485)
  <0.15573951087796684, 2.7517889709888332, -0.4318686423377006>, BranchRadius(0.003987252342846933)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.1352723900956567, 2.7433148963346246, -0.4224172083439868>, BranchRadius(0.017862472468462492)
  <0.14435948127979156, 2.752390557582798, -0.42745753488000965>, BranchRadius(0.013796657017919546)
  <0.1486318882149635, 2.7576310705242393, -0.43024463255530726>, BranchRadius(0.007313299553605875)
  <0.15096492348054893, 2.7645036587654346, -0.4307251789778306>, BranchRadius(0.007273681842621547)
  <0.15239677007550753, 2.7715522080571917, -0.42997368532187197>, BranchRadius(0.007231664711860661)
  <0.15536148357816804, 2.778087699845706, -0.43007931586513726>, BranchRadius(0.007177279211669691)
  <0.15639829679340309, 2.7810270358326283, -0.43179502031339034>, BranchRadius(0.003557853206788929)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.05894810003641711, 2.6640456356427604, -0.4087070349408469>, BranchRadius(0.0807915179298806)
  <0.06722111952508737, 2.6967011582325813, -0.4021613590580999>, BranchRadius(0.034317224244338085)
  <0.0665368111636059, 2.7150092552480176, -0.3950687987164554>, BranchRadius(0.01964584196363429)
  <0.06976193055723526, 2.7318701473014513, -0.3858709932334568>, BranchRadius(0.01947538707301554)
  <0.06884898601687355, 2.732930366979271, -0.3765197560808905>, BranchRadius(0.00945532494325549)
  <0.06632030155895037, 2.7325520942558836, -0.37092340750097647>, BranchRadius(0.006152759768502832)
  <0.06340429123335203, 2.730364563938178, -0.3691456610525521>, BranchRadius(0.00405571048581657)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.06976193055723526, 2.7318701473014513, -0.3858709932334568>, BranchRadius(0.01947538707301554)
  <0.06884898601687355, 2.732930366979271, -0.3765197560808905>, BranchRadius(0.00945532494325549)
  <0.07316307336413937, 2.7359179948919183, -0.37172022156352624>, BranchRadius(0.007111455671494977)
  <0.07921459228422158, 2.7363206824740356, -0.368086739698171>, BranchRadius(0.007070023266918546)
  <0.08475709819526588, 2.736659961368101, -0.3638102118446384>, BranchRadius(0.007008792508268427)
  <0.09005339474024474, 2.737799452018167, -0.3594409882948792>, BranchRadius(0.006959835519731301)
  <0.0949197727924156, 2.7396583355496498, -0.35491278605216237>, BranchRadius(0.006902296638164219)
  <0.0965704589790962, 2.7409704876757224, -0.3525622628949596>, BranchRadius(0.0031577630058953108)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <0.0665368111636059, 2.7150092552480176, -0.3950687987164554>, BranchRadius(0.01964584196363429)
  <0.06976193055723526, 2.7318701473014513, -0.3858709932334568>, BranchRadius(0.01947538707301554)
  <0.07379099736779479, 2.7458810822767354, -0.38883546105988104>, BranchRadius(0.014877088012762886)
  <0.0769990784285676, 2.7597810437751833, -0.39264302606882673>, BranchRadius(0.014764764307233917)
  <0.08268356890959455, 2.773266877496277, -0.3913966629470736>, BranchRadius(0.014687905371874328)
  <0.08886770674851528, 2.7861833140730634, -0.38884981895660736>, BranchRadius(0.014545250391955861)
  <0.09413820349426849, 2.7991070868164623, -0.39266734511235935>, BranchRadius(0.01446981492002787)
  <0.10111655550673858, 2.80833258054176, -0.4011587741315367>, BranchRadius(0.014349616652481842)
  <0.10734195791516253, 2.8205324864105816, -0.405059890365379>, BranchRadius(0.014241209436872482)
  <0.11817339440678476, 2.8294526099314043, -0.40690385272325624>, BranchRadius(0.01415234317263567)
  <0.12569665186798798, 2.8367191968182577, -0.40841372320970715>, BranchRadius(0.010567989245717063)
  <0.12900532419827807, 2.8405869658846, -0.41193832428098925>, BranchRadius(0.0061911035245312005)
  <0.13224223879775535, 2.841330038770153, -0.4135156590856707>, BranchRadius(0.003676650448929374)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.10734195791516253, 2.8205324864105816, -0.405059890365379>, BranchRadius(0.014241209436872482)
  <0.11817339440678476, 2.8294526099314043, -0.40690385272325624>, BranchRadius(0.01415234317263567)
  <0.12474086448407326, 2.8285976220533486, -0.40668191986574886>, BranchRadius(0.0066266071017484635)
  <0.1273847471943444, 2.8282750080757997, -0.406781200084518>, BranchRadius(0.002665342778334414)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <-0.06599597597670302, 2.140211762746538, -0.26612906344608606>, BranchRadius(0.15337299178596608)
  <-0.003091271426050035, 2.2386064198262114, -0.2630653917427427>, BranchRadius(0.11682421187723621)
  <0.031757481062089865, 2.31736989737512, -0.24100289655268914>, BranchRadius(0.08890936193443376)
  <0.05444314979581713, 2.3963979933020547, -0.20941279341520713>, BranchRadius(0.0880795897354771)
  <0.0576927951898422, 2.4837493783202684, -0.2031973797072374>, BranchRadius(0.0876325055407428)
  <0.052488688316492005, 2.524817183720102, -0.19778390711205485>, BranchRadius(0.04174868925183921)
  <0.06126229055161816, 2.539140459137447, -0.190165205844966>, BranchRadius(0.01844388581233555)
  <0.06723756301475431, 2.5490352349180827, -0.1848484754916171>, BranchRadius(0.012723132098975748)
  <0.07155846446065875, 2.5522999879947643, -0.18333822178725528>, BranchRadius(0.005622247611806211)
  <0.07630472773364566, 2.5551688963487256, -0.18278495885797166>, BranchRadius(0.005573486347776696)
  <0.07859436621156014, 2.555858395190268, -0.18199005365789925>, BranchRadius(0.0025198665220874266)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.06126229055161816, 2.539140459137447, -0.190165205844966>, BranchRadius(0.01844388581233555)
  <0.06723756301475431, 2.5490352349180827, -0.1848484754916171>, BranchRadius(0.012723132098975748)
  <0.06766598266351621, 2.555334202814081, -0.1811133284328317>, BranchRadius(0.007335656991777294)
  <0.06830419734575047, 2.561902747635961, -0.17801876318377963>, BranchRadius(0.007288993972991496)
  <0.0714681929231149, 2.568282701226832, -0.17667247263907396>, BranchRadius(0.0072475633192138796)
  <0.07168358972307826, 2.5750035586528672, -0.17416127103809925>, BranchRadius(0.007177914307322378)
  <0.07300348330915706, 2.5814384192170237, -0.17138671727677732>, BranchRadius(0.007130757192134011)
  <0.07389690556018301, 2.5854378065375427, -0.16947871186764113>, BranchRadius(0.004520374641492793)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <0.052488688316492005, 2.524817183720102, -0.19778390711205485>, BranchRadius(0.04174868925183921)
  <0.06126229055161816, 2.539140459137447, -0.190165205844966>, BranchRadius(0.01844388581233555)
  <0.06759069316413424, 2.5446443058156336, -0.18908715926232886>, BranchRadius(0.008455956026223222)
  <0.07374709899758296, 2.5503056702327958, -0.18819082496134215>, BranchRadius(0.008411646392303728)
  <0.07807889994834091, 2.5574249686321524, -0.1879692680201181>, BranchRadius(0.008336545846708768)
  <0.08238974091490105, 2.5645081501572005, -0.18774739841728308>, BranchRadius(0.008294819857984677)
  <0.08491867916613187, 2.5716661251015562, -0.1845200900239422>, BranchRadius(0.008249100159913812)
  <0.087009489068513, 2.5768530305007777, -0.17854139384966608>, BranchRadius(0.008186591574805143)
  <0.08697821320804822, 2.577619809561903, -0.17223245991040528>, BranchRadius(0.006355436708675915)
  <0.08757148559389882, 2.5773497636524376, -0.16595008468076558>, BranchRadius(0.006316101285050957)
  <0.08834228854822167, 2.577209770272577, -0.15973971065763343>, BranchRadius(0.00625959110869012)
  <0.08811796188512733, 2.578425378139983, -0.15365873291610752>, BranchRadius(0.006205345698025821)
  <0.08816081662004395, 2.580243788392261, -0.14778148307447464>, BranchRadius(0.006152277470568765)
  <0.08782185185860152, 2.580042397121229, -0.14482613945031197>, BranchRadius(0.002981528381623515)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.08491867916613187, 2.5716661251015562, -0.1845200900239422>, BranchRadius(0.008249100159913812)
  <0.087009489068513, 2.5768530305007777, -0.17854139384966608>, BranchRadius(0.008186591574805143)
  <0.08949943387704005, 2.5821816448983954, -0.1778508097328636>, BranchRadius(0.005922065768833398)
  <0.09220907864461654, 2.587223181127001, -0.17923333050898851>, BranchRadius(0.005888176798229899)
  <0.09409037431661282, 2.5914266793790244, -0.17971975819905864>, BranchRadius(0.004630905187747294)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.0576927951898422, 2.4837493783202684, -0.2031973797072374>, BranchRadius(0.0876325055407428)
  <0.052488688316492005, 2.524817183720102, -0.19778390711205485>, BranchRadius(0.04174868925183921)
  <0.04015372167711059, 2.5353828969252206, -0.20234229995392075>, BranchRadius(0.016869043921581593)
  <0.03111212417889178, 2.545921874755689, -0.21162631818502703>, BranchRadius(0.016703698199692838)
  <0.023361504732862606, 2.5578814939485106, -0.22007659554084869>, BranchRadius(0.016568397038482174)
  <0.018811838031204113, 2.5630855672536095, -0.22311268007083598>, BranchRadius(0.007549811609189375)
  <0.015943955901323692, 2.5692081176843042, -0.22631406290153627>, BranchRadius(0.007480589797334967)
  <0.015513291597546068, 2.5722937787641973, -0.2288385332868728>, BranchRadius(0.004009953462193433)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.03111212417889178, 2.545921874755689, -0.21162631818502703>, BranchRadius(0.016703698199692838)
  <0.023361504732862606, 2.5578814939485106, -0.22007659554084869>, BranchRadius(0.016568397038482174)
  <0.019485867890190554, 2.5664128278643594, -0.22700477098523528>, BranchRadius(0.011653490220023915)
  <0.015193189788483824, 2.5686772769790434, -0.23332516980948137>, BranchRadius(0.00796883030158109)
  <0.012655528065601298, 2.5713751279944943, -0.24032551167788047>, BranchRadius(0.007919779883040514)
  <0.007883706824597454, 2.574952002596839, -0.245420373453511>, BranchRadius(0.007843591421649563)
  <0.003961306334359023, 2.576242312162852, -0.2520422559679847>, BranchRadius(0.007803810121822573)
  <0.003684724876821132, 2.574183113746127, -0.2565310278614148>, BranchRadius(0.004946298467879346)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  17
  <0.023361504732862606, 2.5578814939485106, -0.22007659554084869>, BranchRadius(0.016568397038482174)
  <0.019485867890190554, 2.5664128278643594, -0.22700477098523528>, BranchRadius(0.011653490220023915)
  <0.017371031755436202, 2.57207820536765, -0.2309755434237662>, BranchRadius(0.0072343671381985535)
  <0.015518097664856477, 2.577606729409385, -0.2351479613768565>, BranchRadius(0.007169868506419478)
  <0.014927801275410182, 2.5845130301123156, -0.23677649039668866>, BranchRadius(0.007120220923196403)
  <0.013329834027992923, 2.5912742121183183, -0.23809100862346524>, BranchRadius(0.0070707170506702595)
  <0.011736843866240552, 2.596566166660436, -0.2423917296104633>, BranchRadius(0.007002756709988162)
  <0.009972844864845834, 2.601699833001425, -0.24674147109557268>, BranchRadius(0.006956038640261414)
  <0.006660084127753572, 2.6063287457183146, -0.2506188239499344>, BranchRadius(0.006887313104471825)
  <0.001784284185527626, 2.610123506781791, -0.25355966209845227>, BranchRadius(0.006842672403473939)
  <-0.0027678885013343443, 2.6133490689574557, -0.2574345682703567>, BranchRadius(0.006792747997766057)
  <-0.008342280674346104, 2.615922396947774, -0.26019322880151274>, BranchRadius(0.006730978604218575)
  <-0.012466129938855552, 2.6204244982304306, -0.26289521843414876>, BranchRadius(0.006676510817078515)
  <-0.01384370232632907, 2.626373119815953, -0.26549974438425744>, BranchRadius(0.006638325080564936)
  <-0.013678602152760616, 2.631094857113045, -0.270103153067656>, BranchRadius(0.0065964712291081504)
  <-0.015069073446909697, 2.6333992291830977, -0.27605961571150484>, BranchRadius(0.00653628245141367)
  <-0.015318796564020803, 2.631274216466747, -0.27929809472642525>, BranchRadius(0.0038814671208129196)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  25
  <0.05444314979581713, 2.3963979933020547, -0.20941279341520713>, BranchRadius(0.0880795897354771)
  <0.0576927951898422, 2.4837493783202684, -0.2031973797072374>, BranchRadius(0.0876325055407428)
  <0.08513631061988729, 2.535603543304986, -0.20895005576762332>, BranchRadius(0.0589499300023094)
  <0.09196469910339457, 2.593122290277918, -0.19992262683781895>, BranchRadius(0.0586219038901036)
  <0.09449928432192027, 2.650453491078195, -0.19122184489118513>, BranchRadius(0.05804303846211503)
  <0.10477249545760992, 2.667778899623153, -0.17097143305155757>, BranchRadius(0.028561999719254223)
  <0.09703613391041806, 2.6764167443040385, -0.15238896693798018>, BranchRadius(0.021903691414513194)
  <0.08709663662377164, 2.6825087473362834, -0.13410254635099136>, BranchRadius(0.021686384787243364)
  <0.07945852988382363, 2.68896322682384, -0.13081286139410978>, BranchRadius(0.010527250692448496)
  <0.0714591705378521, 2.6950356552668744, -0.12787692068682266>, BranchRadius(0.010463454734381901)
  <0.06368919317524639, 2.6998444896806904, -0.12296624701708068>, BranchRadius(0.010373627741807638)
  <0.055747695641813144, 2.7058476657445745, -0.12035700471764003>, BranchRadius(0.010291435823280773)
  <0.04907315591711742, 2.713565527313872, -0.12010276513383564>, BranchRadius(0.010206836214290785)
  <0.04035462224620083, 2.718339404814829, -0.12206095658497032>, BranchRadius(0.010131004368982574)
  <0.03791492231210058, 2.724903779010877, -0.12435608284554664>, BranchRadius(0.00736958268195551)
  <0.03608568236321913, 2.7317155046615085, -0.1263193441155135>, BranchRadius(0.007321210278649533)
  <0.03286404595056678, 2.7378785440109525, -0.1283816068200404>, BranchRadius(0.007253614454918607)
  <0.028662618080969822, 2.742045184531262, -0.13246066008800728>, BranchRadius(0.0071869023182328145)
  <0.02629467638873861, 2.745061667737097, -0.13849557905352883>, BranchRadius(0.007150284309683402)
  <0.02106160905802905, 2.747471752550521, -0.14266064808070564>, BranchRadius(0.007109240641361466)
  <0.017403661353029988, 2.7507437064628606, -0.1477117466685793>, BranchRadius(0.007042716859380541)
  <0.014504534316223438, 2.755523740487348, -0.1518846648360383>, BranchRadius(0.006976167205787876)
  <0.011048363313796182, 2.7599867479156917, -0.1558824541276431>, BranchRadius(0.006917071094295623)
  <0.009342437862744824, 2.762947111578646, -0.16013314454682454>, BranchRadius(0.005453650493128845)
  <0.007349016984158414, 2.7639980253363126, -0.16363364351015422>, BranchRadius(0.004163128573261852)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.014504534316223438, 2.755523740487348, -0.1518846648360383>, BranchRadius(0.006976167205787876)
  <0.011048363313796182, 2.7599867479156917, -0.1558824541276431>, BranchRadius(0.006917071094295623)
  <0.00834144007222623, 2.7633490127529914, -0.158613019052266>, BranchRadius(0.00510766512992709)
  <0.00531636857113762, 2.766686292954165, -0.1609359589133334>, BranchRadius(0.005067992336811398)
  <0.0036145744628288175, 2.766401577546549, -0.16454956209386926>, BranchRadius(0.004004409319336293)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.04907315591711742, 2.713565527313872, -0.12010276513383564>, BranchRadius(0.010206836214290785)
  <0.04035462224620083, 2.718339404814829, -0.12206095658497032>, BranchRadius(0.010131004368982574)
  <0.033641848625902096, 2.7198661648986837, -0.1228505872691532>, BranchRadius(0.006929346480616558)
  <0.02717740474705655, 2.721719763370956, -0.12425249006999223>, BranchRadius(0.00686951187655676)
  <0.02079897375097883, 2.7238234399975148, -0.1254569567539509>, BranchRadius(0.006823531146966498)
  <0.01843060046341885, 2.7250141774062455, -0.12664184495443392>, BranchRadius(0.002903619750143334)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.09703613391041806, 2.6764167443040385, -0.15238896693798018>, BranchRadius(0.021903691414513194)
  <0.08709663662377164, 2.6825087473362834, -0.13410254635099136>, BranchRadius(0.021686384787243364)
  <0.0839745767979745, 2.6834453533650167, -0.12242842923241391>, BranchRadius(0.012120622876204792)
  <0.08124223942886637, 2.683801562419999, -0.11072171186626888>, BranchRadius(0.012026628117651178)
  <0.07806929386746571, 2.683463858771489, -0.0992103680006992>, BranchRadius(0.01194540350432824)
  <0.07866751072574517, 2.67991274038124, -0.0947813662977778>, BranchRadius(0.005708271307110087)
  <0.0798011892038579, 2.678019302339885, -0.0926177714713063>, BranchRadius(0.003090546404977704)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.08124223942886637, 2.683801562419999, -0.11072171186626888>, BranchRadius(0.012026628117651178)
  <0.07806929386746571, 2.683463858771489, -0.0992103680006992>, BranchRadius(0.01194540350432824)
  <0.07495776091004416, 2.6871324783288038, -0.09522401098118664>, BranchRadius(0.006247515433230195)
  <0.07271917382308023, 2.6911066050199586, -0.0910377227071186>, BranchRadius(0.0061911198192951605)
  <0.07090987741622573, 2.694042916870947, -0.08758214359565625>, BranchRadius(0.004882264614877745)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <0.09449928432192027, 2.650453491078195, -0.19122184489118513>, BranchRadius(0.05804303846211503)
  <0.10477249545760992, 2.667778899623153, -0.17097143305155757>, BranchRadius(0.028561999719254223)
  <0.12465756559599452, 2.6769914043089527, -0.1697223005135245>, BranchRadius(0.021951004284358457)
  <0.14204851272721597, 2.6884192995488716, -0.17617916468804667>, BranchRadius(0.021788366774582464)
  <0.1569256528769721, 2.7020486928642997, -0.1838317657946852>, BranchRadius(0.021578970431404925)
  <0.172779389185415, 2.7135374211444288, -0.19248956138200501>, BranchRadius(0.02140769153514894)
  <0.18969687317573916, 2.7110681101780436, -0.19328890679087965>, BranchRadius(0.01711542328703189)
  <0.19796628383477188, 2.715562362448443, -0.20266248855931993>, BranchRadius(0.013283278634710254)
  <0.20851605006539262, 2.7185297032792706, -0.21003562127279912>, BranchRadius(0.013208548941409841)
  <0.2181691456585841, 2.722025083203278, -0.21817902282141133>, BranchRadius(0.013104004125700907)
  <0.2246118763678529, 2.7258269790960763, -0.22367405811237476>, BranchRadius(0.009282165922928047)
  <0.22346038653662842, 2.728868468670071, -0.22872656575444866>, BranchRadius(0.006008695460193368)
  <0.2243805179784782, 2.7324339862001477, -0.23343248463069366>, BranchRadius(0.005975385309531338)
  <0.22638847057490022, 2.735537846253235, -0.23492779400756067>, BranchRadius(0.0039877024702421006)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.2181691456585841, 2.722025083203278, -0.21817902282141133>, BranchRadius(0.013104004125700907)
  <0.2246118763678529, 2.7258269790960763, -0.22367405811237476>, BranchRadius(0.009282165922928047)
  <0.23002317424305302, 2.725919886213631, -0.22326132850876826>, BranchRadius(0.005427810069662612)
  <0.23292369202504845, 2.7263883519587413, -0.2242822508078383>, BranchRadius(0.003110425356563299)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.20851605006539262, 2.7185297032792706, -0.21003562127279912>, BranchRadius(0.013208548941409841)
  <0.2181691456585841, 2.722025083203278, -0.21817902282141133>, BranchRadius(0.013104004125700907)
  <0.22390184468605603, 2.7189176792859646, -0.2228037546428429>, BranchRadius(0.007994244283550113)
  <0.22519286995863905, 2.7150077183017993, -0.2234642210396158>, BranchRadius(0.0041702226575337726)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.2181691456585841, 2.722025083203278, -0.21817902282141133>, BranchRadius(0.013104004125700907)
  <0.22390184468605603, 2.7189176792859646, -0.2228037546428429>, BranchRadius(0.007994244283550113)
  <0.22791412559872137, 2.7194526257516527, -0.2263622244671637>, BranchRadius(0.005389552238720069)
  <0.2316487536648307, 2.7215131979619036, -0.22960786732916666>, BranchRadius(0.005359813636079201)
  <0.23361710863868765, 2.722441154652151, -0.23142063168574462>, BranchRadius(0.0028322499067987747)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <0.172779389185415, 2.7135374211444288, -0.19248956138200501>, BranchRadius(0.02140769153514894)
  <0.18969687317573916, 2.7110681101780436, -0.19328890679087965>, BranchRadius(0.01711542328703189)
  <0.19398977649679502, 2.7076197757663993, -0.18904585665523083>, BranchRadius(0.006951510885562289)
  <0.19762648253945997, 2.7053395484118763, -0.185852768660917>, BranchRadius(0.0053498484621999085)
  <0.19887093351384852, 2.704531160073689, -0.18388978378242293>, BranchRadius(0.0024607843396303565)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.1569256528769721, 2.7020486928642997, -0.1838317657946852>, BranchRadius(0.021578970431404925)
  <0.172779389185415, 2.7135374211444288, -0.19248956138200501>, BranchRadius(0.02140769153514894)
  <0.17298814546317065, 2.722325697740624, -0.1975523903394022>, BranchRadius(0.010144437971942961)
  <0.1719052970059349, 2.731424055183179, -0.20169694992803555>, BranchRadius(0.010056343426791138)
  <0.16962357135253897, 2.7402984680939757, -0.20569626500105634>, BranchRadius(0.009997799634018222)
  <0.17163951154967322, 2.7419547244453155, -0.20951639821358267>, BranchRadius(0.0046260801702112785)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <0.1719052970059349, 2.731424055183179, -0.20169694992803555>, BranchRadius(0.010056343426791138)
  <0.16962357135253897, 2.7402984680939757, -0.20569626500105634>, BranchRadius(0.009997799634018222)
  <0.16549464680551265, 2.745230216700641, -0.20431746678835216>, BranchRadius(0.006578088380809133)
  <0.16232249193636886, 2.750686806182801, -0.20592866390671102>, BranchRadius(0.006514053380565904)
  <0.15947660207882217, 2.7562842319542766, -0.2075229517599044>, BranchRadius(0.006478581488822115)
  <0.15561739382464673, 2.761274395125349, -0.20883606546151517>, BranchRadius(0.006443561469900072)
  <0.15383218453083003, 2.7634830968563824, -0.20959180358671575>, BranchRadius(0.0029387881300428163)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.15947660207882217, 2.7562842319542766, -0.2075229517599044>, BranchRadius(0.006478581488822115)
  <0.15561739382464673, 2.761274395125349, -0.20883606546151517>, BranchRadius(0.006443561469900072)
  <0.1532919215755385, 2.765660167466562, -0.20757559149114863>, BranchRadius(0.005121680860839861)
  <0.15078043787093368, 2.7699423025843837, -0.20651758120261277>, BranchRadius(0.005075787361230449)
  <0.1487457675542299, 2.7744963540225815, -0.2058756413241231>, BranchRadius(0.0050290510642688685)
  <0.1464482106922667, 2.778915090267764, -0.20583792387825312>, BranchRadius(0.0049805040050345415)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <0.09196469910339457, 2.593122290277918, -0.19992262683781895>, BranchRadius(0.0586219038901036)
  <0.09449928432192027, 2.650453491078195, -0.19122184489118513>, BranchRadius(0.05804303846211503)
  <0.0869852612934471, 2.672835524373487, -0.20358575392913586>, BranchRadius(0.026651120111595584)
  <0.08702737784494292, 2.6901310013391715, -0.22359111450190158>, BranchRadius(0.02644522166518553)
  <0.07842108555131622, 2.704447811404038, -0.24383433690257933>, BranchRadius(0.026245520963396666)
  <0.07877816139100584, 2.7037686359851665, -0.25703294736042126>, BranchRadius(0.01322089635473871)
  <0.08195689445491566, 2.7047315866748654, -0.26971269118956515>, BranchRadius(0.013107536820283911)
  <0.08659017533300353, 2.70350652883468, -0.2817766179073414>, BranchRadius(0.012981000972919224)
  <0.08773210223201701, 2.6998437104383615, -0.28750850689888297>, BranchRadius(0.006897447865584444)
  <0.09035015579739131, 2.6951320740805507, -0.2917430613944847>, BranchRadius(0.0068545731753067414)
  <0.09489126358830066, 2.6911028269952575, -0.29481657549582097>, BranchRadius(0.0068046293781597374)
  <0.09684094371133772, 2.6854977206174953, -0.2980354992547059>, BranchRadius(0.006751291747044564)
  <0.09946901418497639, 2.6793212609451182, -0.29811429980076537>, BranchRadius(0.006712795097794382)
  <0.10041512436471284, 2.6732482200387646, -0.30068598180288114>, BranchRadius(0.006662619503052319)
  <0.09904216050349461, 2.6721724851188835, -0.3031686139096285>, BranchRadius(0.003034089247124379)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <0.08195689445491566, 2.7047315866748654, -0.26971269118956515>, BranchRadius(0.013107536820283911)
  <0.08659017533300353, 2.70350652883468, -0.2817766179073414>, BranchRadius(0.012981000972919224)
  <0.08864347463307416, 2.703346567280201, -0.28680859220533006>, BranchRadius(0.005437130773689412)
  <0.09073424659816903, 2.703856597524566, -0.29176819382133684>, BranchRadius(0.005406394958721657)
  <0.09309931569084016, 2.7037628574463786, -0.29659561630433495>, BranchRadius(0.005376462298270343)
  <0.09422820480821129, 2.701772420191666, -0.30141889998352117>, BranchRadius(0.005338566900786267)
  <0.09544264629824477, 2.6988254627461314, -0.3056675797625269>, BranchRadius(0.005311375168733489)
  <0.0946675523480617, 2.6970718788613275, -0.3079789311268055>, BranchRadius(0.003003027173005108)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <0.08702737784494292, 2.6901310013391715, -0.22359111450190158>, BranchRadius(0.02644522166518553)
  <0.07842108555131622, 2.704447811404038, -0.24383433690257933>, BranchRadius(0.026245520963396666)
  <0.06983101489381759, 2.7188619270808836, -0.24355258012342046>, BranchRadius(0.01678199724493233)
  <0.056633266341169164, 2.7287883833647824, -0.24600963138899407>, BranchRadius(0.016695873805726406)
  <0.05130594675406074, 2.7370397535934736, -0.2472761294007992>, BranchRadius(0.009903002668283218)
  <0.04440643918067268, 2.7439050482261944, -0.2487320909343201>, BranchRadius(0.009841508986755758)
  <0.03721883840961481, 2.7505117711492506, -0.2484585876620276>, BranchRadius(0.009766534526949658)
  <0.03153683247670457, 2.7583467112584543, -0.2481516846593454>, BranchRadius(0.009683267392233307)
  <0.027282213063989973, 2.766869904672619, -0.24698927720641134>, BranchRadius(0.009596760047481733)
  <0.024792188246967786, 2.77116290122809, -0.24723807941593942>, BranchRadius(0.004969099068658231)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.03153683247670457, 2.7583467112584543, -0.2481516846593454>, BranchRadius(0.009683267392233307)
  <0.027282213063989973, 2.766869904672619, -0.24698927720641134>, BranchRadius(0.009596760047481733)
  <0.026337539053445408, 2.770883843138132, -0.24389598503997284>, BranchRadius(0.005154858622511114)
  <0.025383527133566057, 2.772936325443056, -0.24410688449642734>, BranchRadius(0.0022731697992079522)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <0.06983101489381759, 2.7188619270808836, -0.24355258012342046>, BranchRadius(0.01678199724493233)
  <0.056633266341169164, 2.7287883833647824, -0.24600963138899407>, BranchRadius(0.016695873805726406)
  <0.04637245117941628, 2.7282171181077723, -0.24738346932418487>, BranchRadius(0.010368129168258558)
  <0.03634540476813782, 2.7262257673277372, -0.24833371522947367>, BranchRadius(0.010266942336625704)
  <0.03127861253185442, 2.7236525568209204, -0.2464741113372607>, BranchRadius(0.005979291138085558)
  <0.028353826346975367, 2.722047983761419, -0.24660979687758797>, BranchRadius(0.0033387781442306154)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <0.04637245117941628, 2.7282171181077723, -0.24738346932418487>, BranchRadius(0.010368129168258558)
  <0.03634540476813782, 2.7262257673277372, -0.24833371522947367>, BranchRadius(0.010266942336625704)
  <0.031663944410226436, 2.7276613832084213, -0.2523092957382665>, BranchRadius(0.006307321493428223)
  <0.02895493629178517, 2.728412067278154, -0.2546214804175204>, BranchRadius(0.0036398419676282445)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  43
  <-0.13356186916662127, 1.8923576631223678, -0.023425641034545138>, BranchRadius(0.45585923359336694)
  <-0.14853042299744493, 2.0537015694794234, -0.1700700913235149>, BranchRadius(0.21854177752295956)
  <-0.2813375307556701, 2.138186590913989, -0.22280484018744837>, BranchRadius(0.16600120618732253)
  <-0.3759279375624162, 2.209226620230681, -0.33748101206022924>, BranchRadius(0.16475635107812317)
  <-0.4491134743292156, 2.270738683508181, -0.4698401245782228>, BranchRadius(0.16327520138419838)
  <-0.534105093602064, 2.283396817576132, -0.6071570329048884>, BranchRadius(0.16198684211100894)
  <-0.6462653213689109, 2.3223804886898423, -0.7156221208032835>, BranchRadius(0.16082387446837443)
  <-0.7546447526744084, 2.4136879310946435, -0.7893712664996632>, BranchRadius(0.15975633527204794)
  <-0.814010975879771, 2.48462035883218, -0.8493816861365829>, BranchRadius(0.11025882380748032)
  <-0.7997745135846165, 2.5220419844263864, -0.8796306452732969>, BranchRadius(0.05018021970506818)
  <-0.7814142248230054, 2.552926157506913, -0.9139421010863455>, BranchRadius(0.049681066315936245)
  <-0.7479281716856557, 2.564546004868971, -0.9482250268781849>, BranchRadius(0.04931182016802557)
  <-0.7019994540671773, 2.5678876858058355, -0.964550559747747>, BranchRadius(0.048858335594214486)
  <-0.6557992410509158, 2.5783365905130315, -0.9744124123746218>, BranchRadius(0.04838280096854885)
  <-0.6144499989700678, 2.5816469767725776, -0.9987285366629695>, BranchRadius(0.04808318186491336)
  <-0.5871331348178285, 2.599646358546459, -1.0333755877117112>, BranchRadius(0.047650886221852706)
  <-0.5630049102528205, 2.628795364306873, -1.0616744225603179>, BranchRadius(0.04725102973765542)
  <-0.5483417988350652, 2.6447334885541705, -1.0777718891975998>, BranchRadius(0.026984422786307697)
  <-0.5331138161707635, 2.6647499198509754, -1.0868477162720518>, BranchRadius(0.02673798075714289)
  <-0.5160193110227305, 2.67829903710895, -1.1019570907417542>, BranchRadius(0.02653476741168404)
  <-0.49991916954525045, 2.693768895766601, -1.1158031000820128>, BranchRadius(0.02627247717922874)
  <-0.48459101076202526, 2.702453529671034, -1.1350682463026907>, BranchRadius(0.02610596055773262)
  <-0.4714393850662005, 2.7205556550242584, -1.1481693017883638>, BranchRadius(0.025928552901880723)
  <-0.4645834917866794, 2.741211925488864, -1.1619255043287942>, BranchRadius(0.025747191895437185)
  <-0.46367912987698034, 2.7597908331383616, -1.179434099851514>, BranchRadius(0.025544952477749416)
  <-0.461103749913828, 2.782398542062467, -1.1906485928236177>, BranchRadius(0.02536741881573777)
  <-0.45368878289795017, 2.806003776103865, -1.1954619563978799>, BranchRadius(0.02520629443003794)
  <-0.44417664633172815, 2.8281552441753077, -1.1887868527451935>, BranchRadius(0.02501450156506634)
  <-0.43814011614100173, 2.851921806552049, -1.1849701630416807>, BranchRadius(0.02481645228964023)
  <-0.4274208955620253, 2.872167638209747, -1.1758587901409931>, BranchRadius(0.02465385376504003)
  <-0.4164088157175308, 2.888785338847251, -1.1616645892713349>, BranchRadius(0.024472213126471288)
  <-0.4196059747634199, 2.891090926148008, -1.1454341843784828>, BranchRadius(0.016702203499899107)
  <-0.4244751937055841, 2.8931538484092614, -1.1296813151325702>, BranchRadius(0.01661679363901255)
  <-0.43075867075518803, 2.887443137989277, -1.1155162179572522>, BranchRadius(0.01651497124793205)
  <-0.43891787617430206, 2.8764659047904204, -1.1065467590414901>, BranchRadius(0.016356144870198683)
  <-0.44790701064655597, 2.8712259771894653, -1.1002750936338843>, BranchRadius(0.0121488751252318)
  <-0.4565953831877911, 2.8642980305064834, -1.095522155738208>, BranchRadius(0.01208613591259345)
  <-0.46371859490430933, 2.8553958871575427, -1.0918029978719728>, BranchRadius(0.011992515857709224)
  <-0.47331681836234063, 2.851171092504522, -1.0861284953647075>, BranchRadius(0.011923705888500195)
  <-0.48366619720885695, 2.8466609847917197, -1.082650514859282>, BranchRadius(0.011813003956907753)
  <-0.48894788691361146, 2.844203827631967, -1.080485568074614>, BranchRadius(0.006214568530918132)
  <-0.49389008145344, 2.841558625729597, -1.0779339036731075>, BranchRadius(0.006159007321941482)
  <-0.4963598943881174, 2.837600179974138, -1.0773852337014835>, BranchRadius(0.004697904582787316)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.47331681836234063, 2.851171092504522, -1.0861284953647075>, BranchRadius(0.011923705888500195)
  <-0.48366619720885695, 2.8466609847917197, -1.082650514859282>, BranchRadius(0.011813003956907753)
  <-0.49092543385222914, 2.8447970884756595, -1.0834709046415765>, BranchRadius(0.007539473822250073)
  <-0.49451424255635434, 2.845000927090763, -1.0875070917478997>, BranchRadius(0.005404803831136072)
  <-0.4981799942582677, 2.845457790151533, -1.0913935158491503>, BranchRadius(0.005361972742485632)
  <-0.5026944493787362, 2.844854757607483, -1.0941278213458696>, BranchRadius(0.005312285744695739)
  <-0.5072730024521331, 2.8442279939417006, -1.0966905331537637>, BranchRadius(0.005284266528949712)
  <-0.509181310533857, 2.845592335439167, -1.0970112462437043>, BranchRadius(0.002367683328179907)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.43075867075518803, 2.887443137989277, -1.1155162179572522>, BranchRadius(0.01651497124793205)
  <-0.43891787617430206, 2.8764659047904204, -1.1065467590414901>, BranchRadius(0.016356144870198683)
  <-0.43980147907455247, 2.8691778728441104, -1.1023627541375247>, BranchRadius(0.008449974010147855)
  <-0.44146479410057554, 2.8643906960700725, -1.099858946553475>, BranchRadius(0.005652674655384646)
  <-0.4438478964265807, 2.8599632113431785, -1.0973407601384502>, BranchRadius(0.005623438496498768)
  <-0.44630325313261227, 2.8556537414696246, -1.0948038231391544>, BranchRadius(0.005571028314711792)
  <-0.4484424213014898, 2.851378517351883, -1.09203766191539>, BranchRadius(0.005523153956528411)
  <-0.45013286573835015, 2.8503840952201984, -1.0904475008821086>, BranchRadius(0.0025248940337888417)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-0.4274208955620253, 2.872167638209747, -1.1758587901409931>, BranchRadius(0.02465385376504003)
  <-0.4164088157175308, 2.888785338847251, -1.1616645892713349>, BranchRadius(0.024472213126471288)
  <-0.40910050079863425, 2.8963838197278946, -1.1620347004156677>, BranchRadius(0.010549187689411422)
  <-0.404239431740846, 2.9051812175111777, -1.1650216899136712>, BranchRadius(0.010485528427460752)
  <-0.4052816436908579, 2.9104076338447316, -1.1659166748900196>, BranchRadius(0.005403945923884978)
  <-0.4058014556746168, 2.915750379613356, -1.1656971369545526>, BranchRadius(0.005372460679402088)
  <-0.4057153383419297, 2.919193307730431, -1.1658974406200113>, BranchRadius(0.0034498248901546533)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.5871331348178285, 2.599646358546459, -1.0333755877117112>, BranchRadius(0.047650886221852706)
  <-0.5630049102528205, 2.628795364306873, -1.0616744225603179>, BranchRadius(0.04725102973765542)
  <-0.5518979968986402, 2.6436104632507047, -1.0755664866140975>, BranchRadius(0.023148220766337657)
  <-0.540700063876003, 2.651924226473371, -1.0727045594951006>, BranchRadius(0.014237380016578823)
  <-0.528686545385178, 2.659135048883305, -1.071119857910939>, BranchRadius(0.014100775349882272)
  <-0.5197803667087896, 2.657006730073998, -1.0739657268964378>, BranchRadius(0.009588990032971487)
  <-0.5110976348157041, 2.6548657606903094, -1.0772607765653992>, BranchRadius(0.00953052649909849)
  <-0.5079261264426225, 2.655658775887605, -1.0802277198977916>, BranchRadius(0.004414758340079016)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.5197803667087896, 2.657006730073998, -1.0739657268964378>, BranchRadius(0.009588990032971487)
  <-0.5110976348157041, 2.6548657606903094, -1.0772607765653992>, BranchRadius(0.00953052649909849)
  <-0.5049714762609233, 2.652235110648294, -1.0783316133036942>, BranchRadius(0.006752542454657511)
  <-0.49903334391889753, 2.6492467330702154, -1.0791716710024093>, BranchRadius(0.006700560662940597)
  <-0.4929229799160232, 2.6465826554605343, -1.0791378312159086>, BranchRadius(0.006665958512410389)
  <-0.49047561282708013, 2.6479306254266683, -1.0783823172754297>, BranchRadius(0.002894379037358377)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.540700063876003, 2.651924226473371, -1.0727045594951006>, BranchRadius(0.014237380016578823)
  <-0.528686545385178, 2.659135048883305, -1.071119857910939>, BranchRadius(0.014100775349882272)
  <-0.5251787110980115, 2.664344879708738, -1.0689871510180056>, BranchRadius(0.006632923737464655)
  <-0.5229707093608874, 2.670370650797354, -1.0675162118329313>, BranchRadius(0.006583984429639068)
  <-0.5207548858813277, 2.673610766979625, -1.0657215290518742>, BranchRadius(0.004316145601321395)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  26
  <-0.5630049102528205, 2.628795364306873, -1.0616744225603179>, BranchRadius(0.04725102973765542)
  <-0.5518979968986402, 2.6436104632507047, -1.0755664866140975>, BranchRadius(0.023148220766337657)
  <-0.5468087137534698, 2.653481068158045, -1.089782174965042>, BranchRadius(0.01803927491502101)
  <-0.5496287700851018, 2.6609780511475036, -1.1057693879714061>, BranchRadius(0.017881511439715198)
  <-0.5486671139296766, 2.668815435405551, -1.1216769891828136>, BranchRadius(0.017759536899106677)
  <-0.5451414395207411, 2.682416343494716, -1.132326729148277>, BranchRadius(0.01763042943945861)
  <-0.545469460057954, 2.696934817303956, -1.1420314997315248>, BranchRadius(0.0174664321283967)
  <-0.5438006962473789, 2.71361059768428, -1.1464258598655452>, BranchRadius(0.017325611819954914)
  <-0.546113890179158, 2.7302264064102246, -1.150035449524478>, BranchRadius(0.017159985527064645)
  <-0.5431491471062019, 2.7406529468682694, -1.153150557268556>, BranchRadius(0.011278578973838056)
  <-0.5398829126628445, 2.750990534461272, -1.1558848519380762>, BranchRadius(0.011180803728790725)
  <-0.5346536375947172, 2.759182504959184, -1.1612340797171674>, BranchRadius(0.011093598884464697)
  <-0.5340434225750975, 2.7678586408857253, -1.1679652435288903>, BranchRadius(0.01099801178605688)
  <-0.5319027181740301, 2.773185051057727, -1.1702257387456438>, BranchRadius(0.006169529907385183)
  <-0.5279421561261246, 2.777634991431134, -1.1715863129315138>, BranchRadius(0.006110579610596755)
  <-0.5263674565702801, 2.7835001780838553, -1.1717839596975934>, BranchRadius(0.006076113676238925)
  <-0.5255102399059592, 2.788986912049611, -1.1693966108119624>, BranchRadius(0.0060447088203064965)
  <-0.5260538293993445, 2.7948125330014926, -1.1680086715169455>, BranchRadius(0.006013295643735826)
  <-0.5256926311072251, 2.8002458327460733, -1.1655818072691748>, BranchRadius(0.0059616172636122264)
  <-0.5239991984770651, 2.8059039689981913, -1.1656342058169058>, BranchRadius(0.0059063495941425155)
  <-0.5225568084269265, 2.8110529695426534, -1.1680290445707173>, BranchRadius(0.005859005745036169)
  <-0.5192486533582273, 2.8157288801291696, -1.1690139532675168>, BranchRadius(0.005811890820781528)
  <-0.5161058787093029, 2.819931293077135, -1.1714430631948152>, BranchRadius(0.00578254979382372)
  <-0.5113110910554567, 2.822395335942739, -1.1734276576144882>, BranchRadius(0.005744572299101776)
  <-0.5064951781156705, 2.8252994670706997, -1.174293757393934>, BranchRadius(0.005690089971164403)
  <-0.5028717155620029, 2.8243478763701346, -1.1766956041164816>, BranchRadius(0.004450154313936223)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.5346536375947172, 2.759182504959184, -1.1612340797171674>, BranchRadius(0.011093598884464697)
  <-0.5340434225750975, 2.7678586408857253, -1.1679652435288903>, BranchRadius(0.01099801178605688)
  <-0.5367147576284248, 2.769990367121541, -1.172609340318671>, BranchRadius(0.005766101170154124)
  <-0.5389482434150283, 2.7723120299762387, -1.1773460122630899>, BranchRadius(0.005728406259937149)
  <-0.5427392984469097, 2.7717861152942675, -1.1792626394859436>, BranchRadius(0.004280437409757259)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-0.5438006962473789, 2.71361059768428, -1.1464258598655452>, BranchRadius(0.017325611819954914)
  <-0.546113890179158, 2.7302264064102246, -1.150035449524478>, BranchRadius(0.017159985527064645)
  <-0.5515946424740485, 2.737444213290219, -1.150741892396315>, BranchRadius(0.009090348915526066)
  <-0.555066255224843, 2.74557232143722, -1.1488282970280599>, BranchRadius(0.009043234176677909)
  <-0.5564960401311196, 2.754434945174014, -1.1483791719549028>, BranchRadius(0.008988442451812118)
  <-0.554976935203779, 2.7632039415879333, -1.1478642809853958>, BranchRadius(0.008914487680067841)
  <-0.5528962202104346, 2.7716960768723453, -1.1492919935841017>, BranchRadius(0.008859125229772408)
  <-0.5518571451134792, 2.7748740435340675, -1.1512286903726083>, BranchRadius(0.003863928520397623)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.554976935203779, 2.7632039415879333, -1.1478642809853958>, BranchRadius(0.008914487680067841)
  <-0.5528962202104346, 2.7716960768723453, -1.1492919935841017>, BranchRadius(0.008859125229772408)
  <-0.5524884549128128, 2.776688989606977, -1.1457393503444457>, BranchRadius(0.006141394312521006)
  <-0.5526882827364928, 2.7783441394273285, -1.1434156910763609>, BranchRadius(0.0028598679132231875)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  24
  <-0.7546447526744084, 2.4136879310946435, -0.7893712664996632>, BranchRadius(0.15975633527204794)
  <-0.814010975879771, 2.48462035883218, -0.8493816861365829>, BranchRadius(0.11025882380748032)
  <-0.8650825534089353, 2.486894161415655, -0.8528277989305355>, BranchRadius(0.05123818793531529)
  <-0.9119367005953896, 2.4916540415624993, -0.8337274295905953>, BranchRadius(0.05082117350577774)
  <-0.9561704921930977, 2.515624200994894, -0.8292767315894822>, BranchRadius(0.05050748038678049)
  <-0.9984955915409012, 2.5361676006077607, -0.8462372783490271>, BranchRadius(0.050011053266633756)
  <-1.0237629833193451, 2.5700764690611453, -0.8721615113313893>, BranchRadius(0.04960159576866566)
  <-1.025779940936725, 2.6115052458803687, -0.8988924941915664>, BranchRadius(0.04934528459172585)
  <-1.0263162379843815, 2.6303536900450193, -0.9093397956929329>, BranchRadius(0.021556845098755464)
  <-1.0235907138149996, 2.6476264973067782, -0.9216616945632007>, BranchRadius(0.021391763472628052)
  <-1.0151929986115564, 2.666041203545109, -0.928116170560975>, BranchRadius(0.021243429263845346)
  <-1.008932588181387, 2.6749055816716028, -0.91993928989833>, BranchRadius(0.013587910644936032)
  <-1.0007421566208148, 2.6794815274912196, -0.9102724830675321>, BranchRadius(0.013471065421727072)
  <-0.9924902316352276, 2.6846896970947536, -0.9011411009904655>, BranchRadius(0.013364184794603357)
  <-0.9911224585663905, 2.6929543192508194, -0.8945867682515759>, BranchRadius(0.01063644960512888)
  <-0.9918716381383563, 2.6997342976048433, -0.8897950468470462>, BranchRadius(0.008336064450969167)
  <-0.9927484770717119, 2.7060064217495414, -0.8844803094811587>, BranchRadius(0.008267697446684647)
  <-0.9937121844529427, 2.710909918739965, -0.8779648369500023>, BranchRadius(0.008211236018772404)
  <-0.9948228464962819, 2.71541165935512, -0.8712628072462584>, BranchRadius(0.008149628267014089)
  <-0.9923537849760652, 2.7190065921971414, -0.8644520285049336>, BranchRadius(0.008087429380992625)
  <-0.9882411856482879, 2.7238227322702424, -0.8595384860945847>, BranchRadius(0.008015708169142814)
  <-0.9816301122739935, 2.7277264968815937, -0.8574932463468822>, BranchRadius(0.007945355556973293)
  <-0.9748158479661351, 2.730967217236582, -0.8552017304603501>, BranchRadius(0.007885905879150362)
  <-0.9701179341439428, 2.7300211715053355, -0.8539765196919603>, BranchRadius(0.004946366164502396)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.9924902316352276, 2.6846896970947536, -0.9011411009904655>, BranchRadius(0.013364184794603357)
  <-0.9911224585663905, 2.6929543192508194, -0.8945867682515759>, BranchRadius(0.01063644960512888)
  <-0.9892533395647817, 2.6964728094727213, -0.8913939673392564>, BranchRadius(0.0051056201336863935)
  <-0.9869746413822728, 2.7007184363971444, -0.8898101509089893>, BranchRadius(0.005072108819134134)
  <-0.9847464788342917, 2.704906001688657, -0.8881524168939164>, BranchRadius(0.005024787903547494)
  <-0.9829817080810324, 2.709546871071689, -0.8876405335018194>, BranchRadius(0.004991403514947222)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-1.0007421566208148, 2.6794815274912196, -0.9102724830675321>, BranchRadius(0.013471065421727072)
  <-0.9924902316352276, 2.6846896970947536, -0.9011411009904655>, BranchRadius(0.013364184794603357)
  <-0.9844607853441737, 2.681015654164619, -0.8982096188352839>, BranchRadius(0.00930398768375911)
  <-0.9774818551664594, 2.6785229975905525, -0.8926643325335921>, BranchRadius(0.009255755149601733)
  <-0.9688156237064566, 2.6766319393483684, -0.8903649552564965>, BranchRadius(0.009163340267396987)
  <-0.9602169987051843, 2.6748065761920237, -0.888045206851311>, BranchRadius(0.009091178979010631)
  <-0.9515443628886667, 2.6726325431164635, -0.8892709628716917>, BranchRadius(0.00902460578867973)
  <-0.9473777796068888, 2.673362567090962, -0.8854190165975867>, BranchRadius(0.0057210874268730436)
  <-0.9444540559303688, 2.674106545919169, -0.8836930571340474>, BranchRadius(0.0034757158547909224)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <-0.9602169987051843, 2.6748065761920237, -0.888045206851311>, BranchRadius(0.009091178979010631)
  <-0.9515443628886667, 2.6726325431164635, -0.8892709628716917>, BranchRadius(0.00902460578867973)
  <-0.9469204687107068, 2.670788014668522, -0.8916398221524516>, BranchRadius(0.005513091406486988)
  <-0.9423376069236483, 2.668957309366228, -0.8939993953679739>, BranchRadius(0.005470072195368043)
  <-0.9375985420457601, 2.6665386195448524, -0.8951426587394896>, BranchRadius(0.005442044423331103)
  <-0.9325013498972043, 2.6652922784816404, -0.8964556425155573>, BranchRadius(0.005409127493539379)
  <-0.9274216384114851, 2.6641060901419364, -0.8977252589977296>, BranchRadius(0.005368653235887059)
  <-0.9224946049625463, 2.6642741356761546, -0.8997717146469418>, BranchRadius(0.005337778436084106)
  <-0.9173866350560969, 2.663193472923118, -0.9005926296021414>, BranchRadius(0.0052851764317441395)
  <-0.9123705232853234, 2.6618850412684028, -0.9013135736144284>, BranchRadius(0.005233844758951664)
  <-0.9099339558170435, 2.6619463112036983, -0.8991539462990301>, BranchRadius(0.0032564712763765782)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-1.0235907138149996, 2.6476264973067782, -0.9216616945632007>, BranchRadius(0.021391763472628052)
  <-1.0151929986115564, 2.666041203545109, -0.928116170560975>, BranchRadius(0.021243429263845346)
  <-1.013117000236721, 2.673520593287596, -0.9375288162691245>, BranchRadius(0.012200366363330365)
  <-1.013966408503217, 2.6772240583168974, -0.9490233686553393>, BranchRadius(0.012106274496552957)
  <-1.0151372230881135, 2.6776965141871236, -0.9609747671604152>, BranchRadius(0.012017901129924787)
  <-1.0197730009230273, 2.679436773056602, -0.9653745941441906>, BranchRadius(0.0066240029102223276)
  <-1.0253664338885389, 2.680614704834667, -0.9686135502817165>, BranchRadius(0.006569996383124138)
  <-1.0267659231409922, 2.680703687552297, -0.973185777502347>, BranchRadius(0.004782441829112407)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-1.013966408503217, 2.6772240583168974, -0.9490233686553393>, BranchRadius(0.012106274496552957)
  <-1.0151372230881135, 2.6776965141871236, -0.9609747671604152>, BranchRadius(0.012017901129924787)
  <-1.015218558936426, 2.677744233678935, -0.9667085880641355>, BranchRadius(0.0057345963089009)
  <-1.0152228333382853, 2.677623918088596, -0.9704787007103431>, BranchRadius(0.0037720343949763434)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <-1.0237629833193451, 2.5700764690611453, -0.8721615113313893>, BranchRadius(0.04960159576866566)
  <-1.025779940936725, 2.6115052458803687, -0.8988924941915664>, BranchRadius(0.04934528459172585)
  <-1.0309360289869658, 2.6134423908725597, -0.9228966202882642>, BranchRadius(0.024627948440111222)
  <-1.0335331550859561, 2.6168880533983643, -0.9469865600098104>, BranchRadius(0.024473308930414817)
  <-1.0401183342912153, 2.6228418381135485, -0.96960178559168>, BranchRadius(0.024295278671358864)
  <-1.0517643360366495, 2.63231456371949, -0.9792632051201144>, BranchRadius(0.017852308376356527)
  <-1.059273446126701, 2.64426805335485, -0.990017352872175>, BranchRadius(0.01774610781778146)
  <-1.0646492450187561, 2.65862605823392, -0.9987273266578102>, BranchRadius(0.017632786540466728)
  <-1.070237892182917, 2.668908482895972, -1.0010703220711963>, BranchRadius(0.01193527802623037)
  <-1.0738739754245006, 2.680096243611849, -0.9996940885865394>, BranchRadius(0.011844032665428472)
  <-1.0734225191819382, 2.6853397569627004, -1.0050320576869105>, BranchRadius(0.007496142949278632)
  <-1.0737760270016161, 2.690559793537183, -1.0103307850621766>, BranchRadius(0.0074464932293600876)
  <-1.070343741945048, 2.6939973436204587, -1.0113356184382363>, BranchRadius(0.004960546481811323)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-1.0734225191819382, 2.6853397569627004, -1.0050320576869105>, BranchRadius(0.007496142949278632)
  <-1.0737760270016161, 2.690559793537183, -1.0103307850621766>, BranchRadius(0.0074464932293600876)
  <-1.0762662147972604, 2.693193211627026, -1.0145710905545577>, BranchRadius(0.005578182209484144)
  <-1.0787050672538188, 2.6962266519333373, -1.0185272836226484>, BranchRadius(0.005549885132939516)
  <-1.0802063562922095, 2.6976259079078058, -1.0236336977677742>, BranchRadius(0.005503385456282303)
  <-1.0821700475268892, 2.6989456186955487, -1.0285428551347342>, BranchRadius(0.005449545474809827)
  <-1.083404104418051, 2.6977784587215488, -1.0299837672004097>, BranchRadius(0.0022274169785967764)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  8
  <-1.070237892182917, 2.668908482895972, -1.0010703220711963>, BranchRadius(0.01193527802623037)
  <-1.0738739754245006, 2.680096243611849, -0.9996940885865394>, BranchRadius(0.011844032665428472)
  <-1.0775304042705982, 2.6853075260757744, -0.9936054284238788>, BranchRadius(0.008809013531704806)
  <-1.0827116189118144, 2.6875861104743737, -0.991619961372234>, BranchRadius(0.005998250697750171)
  <-1.0880568995181696, 2.6889902365067333, -0.9894363460815037>, BranchRadius(0.0059423707738023145)
  <-1.0920087404372674, 2.692545450666476, -0.986858833100366>, BranchRadius(0.0059076363750170955)
  <-1.0972239930572767, 2.6952036210484787, -0.9863635388361776>, BranchRadius(0.005874525178974689)
  <-1.1000701560680508, 2.6967387823649074, -0.9851497098551293>, BranchRadius(0.0034540910449191854)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-1.0738739754245006, 2.680096243611849, -0.9996940885865394>, BranchRadius(0.011844032665428472)
  <-1.0775304042705982, 2.6853075260757744, -0.9936054284238788>, BranchRadius(0.008809013531704806)
  <-1.076503297645415, 2.6882399116127202, -0.9895966552713114>, BranchRadius(0.005071892659109686)
  <-1.0755209234857732, 2.6914167069336785, -0.9858190338159104>, BranchRadius(0.005032644569319254)
  <-1.0742487094211441, 2.6951036787435876, -0.9827002322620353>, BranchRadius(0.004993917589003512)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-1.059273446126701, 2.64426805335485, -0.990017352872175>, BranchRadius(0.01774610781778146)
  <-1.0646492450187561, 2.65862605823392, -0.9987273266578102>, BranchRadius(0.017632786540466728)
  <-1.0653828616076886, 2.663436808352056, -1.0040368789365415>, BranchRadius(0.007202281263549869)
  <-1.0631358052353679, 2.6654562644810014, -1.0053705657792487>, BranchRadius(0.003302451512366864)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-1.0335331550859561, 2.6168880533983643, -0.9469865600098104>, BranchRadius(0.024473308930414817)
  <-1.0401183342912153, 2.6228418381135485, -0.96960178559168>, BranchRadius(0.024295278671358864)
  <-1.0375896383633443, 2.6213304904178467, -0.9831631301047967>, BranchRadius(0.013877627317246077)
  <-1.029937353219309, 2.6221700542415465, -0.9946042114062392>, BranchRadius(0.013789875876377743)
  <-1.0279772822272537, 2.6158624549208436, -0.99964718380374>, BranchRadius(0.008310190015058951)
  <-1.0297785694877981, 2.6103021056674134, -1.005461773013472>, BranchRadius(0.008244487084898324)
  <-1.0308632507248445, 2.604442100237719, -1.0110702456356746>, BranchRadius(0.008183591031817414)
  <-1.0322747568567514, 2.599894515425803, -1.0145052554764822>, BranchRadius(0.005871300519342294)
  <-1.0318336323793924, 2.5983561457722293, -1.0167820662280003>, BranchRadius(0.0027829910516905406)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-1.0297785694877981, 2.6103021056674134, -1.005461773013472>, BranchRadius(0.008244487084898324)
  <-1.0308632507248445, 2.604442100237719, -1.0110702456356746>, BranchRadius(0.008183591031817414)
  <-1.0307276013166586, 2.6006044602370006, -1.0161053187968812>, BranchRadius(0.006332285786014181)
  <-1.0311125084210804, 2.596859168856763, -1.0211314560970703>, BranchRadius(0.006279921748100857)
  <-1.0309512670510985, 2.5939351274324935, -1.0266269734777176>, BranchRadius(0.006227096298535577)
  <-1.027922315575183, 2.5936012144578324, -1.0296302232448613>, BranchRadius(0.004278499045453432)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <-1.0375896383633443, 2.6213304904178467, -0.9831631301047967>, BranchRadius(0.013877627317246077)
  <-1.029937353219309, 2.6221700542415465, -0.9946042114062392>, BranchRadius(0.013789875876377743)
  <-1.026396579677846, 2.6235146477456333, -0.9995884409148168>, BranchRadius(0.006259996226622868)
  <-1.022491770096865, 2.625593276143452, -1.0039388161490121>, BranchRadius(0.006204353194188819)
  <-1.0202694087919562, 2.6283280603887316, -1.0089744064586705>, BranchRadius(0.006146145491648464)
  <-1.01803707646497, 2.6307081190943755, -1.014120472158769>, BranchRadius(0.0060934373919939305)
  <-1.015772743459638, 2.633134061489927, -1.0191648235866517>, BranchRadius(0.0060380362530837025)
  <-1.013722248136356, 2.637034087634572, -1.0232466811619514>, BranchRadius(0.006006354656923524)
  <-1.0125486589040196, 2.641843628309403, -1.0265762463954085>, BranchRadius(0.005966154358793753)
  <-1.0141195819365516, 2.645677736436735, -1.0276403952278752>, BranchRadius(0.004277919709842248)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  11
  <-0.6462653213689109, 2.3223804886898423, -0.7156221208032835>, BranchRadius(0.16082387446837443)
  <-0.7546447526744084, 2.4136879310946435, -0.7893712664996632>, BranchRadius(0.15975633527204794)
  <-0.8209509819626264, 2.422774136234515, -0.7906318330636882>, BranchRadius(0.06693776358923191)
  <-0.8359213905239509, 2.428497185623942, -0.8155499389938781>, BranchRadius(0.02962732573073311)
  <-0.8378068179488696, 2.41793602664905, -0.8299775352958767>, BranchRadius(0.017979111505328153)
  <-0.8367987288991977, 2.4115929570349826, -0.8466288133904629>, BranchRadius(0.017847012014458367)
  <-0.8322250257941876, 2.4024041909097744, -0.8610154550429425>, BranchRadius(0.017672793809508845)
  <-0.8267109991803858, 2.394516051804715, -0.8756871224852675>, BranchRadius(0.01754665362901598)
  <-0.8203619882936983, 2.3867653893913814, -0.8898789657413998>, BranchRadius(0.017372136370963975)
  <-0.8159413011509077, 2.387445439028984, -0.8966822129634966>, BranchRadius(0.008141812764305352)
  <-0.8138152454716995, 2.3886301670074666, -0.9010342661525939>, BranchRadius(0.004986387479410768)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.8267109991803858, 2.394516051804715, -0.8756871224852675>, BranchRadius(0.01754665362901598)
  <-0.8203619882936983, 2.3867653893913814, -0.8898789657413998>, BranchRadius(0.017372136370963975)
  <-0.8177744168558091, 2.380853630686736, -0.8970574701598062>, BranchRadius(0.009652737570928443)
  <-0.8138233503383856, 2.379028139162187, -0.9030775658314294>, BranchRadius(0.00742865383678639)
  <-0.8112747410584524, 2.3753792444764565, -0.9048574544647602>, BranchRadius(0.004793521173039214)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.8203619882936983, 2.3867653893913814, -0.8898789657413998>, BranchRadius(0.017372136370963975)
  <-0.8177744168558091, 2.380853630686736, -0.8970574701598062>, BranchRadius(0.009652737570928443)
  <-0.8193871678755326, 2.3753820287077603, -0.8988656219161744>, BranchRadius(0.0059840460260601955)
  <-0.8220749981005165, 2.3740266691750223, -0.8989994523123694>, BranchRadius(0.0030131945433820623)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <-0.8209509819626264, 2.422774136234515, -0.7906318330636882>, BranchRadius(0.06693776358923191)
  <-0.8359213905239509, 2.428497185623942, -0.8155499389938781>, BranchRadius(0.02962732573073311)
  <-0.8491350239516584, 2.4428901219948314, -0.8281963129681782>, BranchRadius(0.023274180983144335)
  <-0.8615710052319944, 2.4523811611369837, -0.8452051246502331>, BranchRadius(0.0231091568266421)
  <-0.8766194838437937, 2.46183041628184, -0.8597368707394883>, BranchRadius(0.022954667841747656)
  <-0.885381015958013, 2.4646701631505494, -0.8659544692499912>, BranchRadius(0.011112476704346607)
  <-0.8958804103474968, 2.4673627351854375, -0.8679400677400212>, BranchRadius(0.011019520319532733)
  <-0.9064402811382909, 2.4682417946936455, -0.8706391241989582>, BranchRadius(0.010934739251841701)
  <-0.9158924224513575, 2.4702087788848046, -0.8755928277899401>, BranchRadius(0.010851321646590145)
  <-0.9241745377814786, 2.4728251202620246, -0.8819607564447476>, BranchRadius(0.010769827848962991)
  <-0.9322610681905281, 2.4753912354786483, -0.8884820432733784>, BranchRadius(0.0107006590106752)
  <-0.9379011018420264, 2.472847401012988, -0.8887385990915211>, BranchRadius(0.006192486920982253)
  <-0.9433307335801471, 2.4712630207492117, -0.8863681492058194>, BranchRadius(0.006132715083262484)
  <-0.9447244326493177, 2.469664340886609, -0.8846913462874637>, BranchRadius(0.0027036720262459462)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <-0.9241745377814786, 2.4728251202620246, -0.8819607564447476>, BranchRadius(0.010769827848962991)
  <-0.9322610681905281, 2.4753912354786483, -0.8884820432733784>, BranchRadius(0.0107006590106752)
  <-0.9331100968425514, 2.479358823770452, -0.892829212797098>, BranchRadius(0.005946468647287291)
  <-0.9330443131987445, 2.481210747198244, -0.8984368914151151>, BranchRadius(0.005905929846617241)
  <-0.9331660468840077, 2.4831199400431894, -0.9039660225924565>, BranchRadius(0.005850737388190233)
  <-0.9346495257642597, 2.484345044707937, -0.9094574191600627>, BranchRadius(0.005818679170607258)
  <-0.9343178947004726, 2.485463956190389, -0.9151239270965603>, BranchRadius(0.005785434664951333)
  <-0.9333680090819798, 2.487382663802613, -0.9204623504012978>, BranchRadius(0.005751737560945421)
  <-0.9323767821135073, 2.489752352652186, -0.9255553544982877>, BranchRadius(0.005704090363833178)
  <-0.9325963130342498, 2.4914213051628002, -0.9281995837791395>, BranchRadius(0.0031345725063494623)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  9
  <-0.8615710052319944, 2.4523811611369837, -0.8452051246502331>, BranchRadius(0.0231091568266421)
  <-0.8766194838437937, 2.46183041628184, -0.8597368707394883>, BranchRadius(0.022954667841747656)
  <-0.8876470362042824, 2.4691839379214797, -0.870747351825356>, BranchRadius(0.017231131283529218)
  <-0.8986598079417697, 2.476327577094179, -0.8817425931464431>, BranchRadius(0.017123319003063228)
  <-0.8989274350193805, 2.4819328079082363, -0.893153801455729>, BranchRadius(0.012716363938227086)
  <-0.9011307332761452, 2.490747186844889, -0.9019574526771589>, BranchRadius(0.012651168881797395)
  <-0.9061444796261481, 2.500729918244685, -0.9077076182262213>, BranchRadius(0.012564114871500475)
  <-0.9097244545433378, 2.507057519774508, -0.9092993630118487>, BranchRadius(0.007442339214957988)
  <-0.9092831784351987, 2.5100770651660516, -0.9110840190307461>, BranchRadius(0.0035351628082725514)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  14
  <-0.9011307332761452, 2.490747186844889, -0.9019574526771589>, BranchRadius(0.012651168881797395)
  <-0.9061444796261481, 2.500729918244685, -0.9077076182262213>, BranchRadius(0.012564114871500475)
  <-0.9063730483205614, 2.5036267063640447, -0.915639234832892>, BranchRadius(0.008447139578090712)
  <-0.9065969699938191, 2.507102056345724, -0.9232791781459346>, BranchRadius(0.008396245127282497)
  <-0.9085279056859775, 2.508811917781771, -0.9311921909077499>, BranchRadius(0.00832273451134809)
  <-0.9062572662295584, 2.505777683245529, -0.9361716818913642>, BranchRadius(0.006257612421512493)
  <-0.9022586359113806, 2.502710828647152, -0.9397960634035067>, BranchRadius(0.0062073168836943495)
  <-0.8991405318985517, 2.4977806035437076, -0.9417531860926137>, BranchRadius(0.006153049766227376)
  <-0.8969848662681921, 2.4925180036934265, -0.9439473060752164>, BranchRadius(0.006095573311194556)
  <-0.8944315475946762, 2.487793813222644, -0.9467530423182009>, BranchRadius(0.006058842110333842)
  <-0.8918097267163014, 2.484095507765109, -0.9506875402673156>, BranchRadius(0.006002639593304179)
  <-0.8895677372911247, 2.4801600407097113, -0.9545730541230631>, BranchRadius(0.005967548529331868)
  <-0.886592387692171, 2.476856008326388, -0.9584744992625891>, BranchRadius(0.005915286079537717)
  <-0.88437856456205, 2.4744026323116994, -0.9616725682145966>, BranchRadius(0.0045986641258850105)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  10
  <-0.8876470362042824, 2.4691839379214797, -0.870747351825356>, BranchRadius(0.017231131283529218)
  <-0.8986598079417697, 2.476327577094179, -0.8817425931464431>, BranchRadius(0.017123319003063228)
  <-0.9057052064556562, 2.4769251950186635, -0.8806264251871055>, BranchRadius(0.0071582552564567505)
  <-0.912195505140418, 2.479464512157408, -0.8792357516278236>, BranchRadius(0.007106763081532152)
  <-0.9188791875233483, 2.481432415423491, -0.8803458816620766>, BranchRadius(0.007055256349240714)
  <-0.9251994511869773, 2.4834490676803846, -0.8825779140870648>, BranchRadius(0.006999613407126257)
  <-0.9316152146399295, 2.4846248434607867, -0.8849943193335724>, BranchRadius(0.0069558237244316595)
  <-0.9380955310639679, 2.4857471686616774, -0.8870933055705363>, BranchRadius(0.0069036119557214825)
  <-0.9443602573765176, 2.4840886671436455, -0.8893364962412759>, BranchRadius(0.0068577931903608036)
  <-0.9451185477622226, 2.4815413921970237, -0.8918802464077158>, BranchRadius(0.003678896420396034)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  24
  <-0.7546447526744084, 2.4136879310946435, -0.7893712664996632>, BranchRadius(0.15975633527204794)
  <-0.8209509819626264, 2.422774136234515, -0.7906318330636882>, BranchRadius(0.06693776358923191)
  <-0.849189884700594, 2.4252046117950217, -0.7815127090986929>, BranchRadius(0.02977417104108131)
  <-0.8774217875776349, 2.428834089376237, -0.7734340571751364>, BranchRadius(0.02958847857652026)
  <-0.894912495650822, 2.4352018785064278, -0.7610099009640385>, BranchRadius(0.022379304387442255)
  <-0.9127284621322456, 2.4414819261474148, -0.7493688020486668>, BranchRadius(0.022189250640743632)
  <-0.9313422852709986, 2.445125676973299, -0.7381489414614074>, BranchRadius(0.02203716414422342)
  <-0.9436611953020324, 2.4476588959564562, -0.7328191570142223>, BranchRadius(0.013659405002517068)
  <-0.955657417906262, 2.4498128296822026, -0.7269181933495832>, BranchRadius(0.013541423833427832)
  <-0.9674632636132913, 2.4520474150611915, -0.7209293830247885>, BranchRadius(0.013425245389956207)
  <-0.9753200660810447, 2.4575228481651514, -0.7116660077290192>, BranchRadius(0.013323656951584533)
  <-0.9839969390044694, 2.460286114171948, -0.7020549408929949>, BranchRadius(0.013239953492369378)
  <-0.9885365545261153, 2.4637003801089468, -0.6902199467876116>, BranchRadius(0.013127543808625323)
  <-0.994606306978019, 2.4666596582754994, -0.6790979907217674>, BranchRadius(0.013011423013067982)
  <-0.9949192089758807, 2.4645639880206396, -0.6720317500200766>, BranchRadius(0.007377092864509809)
  <-0.9952393748335021, 2.4624719007191627, -0.6650168238913227>, BranchRadius(0.00732724532449019)
  <-0.9925795154583343, 2.4615505036928926, -0.6583227187975093>, BranchRadius(0.007261877676104544)
  <-0.9929773976115482, 2.464093888517155, -0.6534451676156184>, BranchRadius(0.005515217321565784)
  <-0.9937082966595487, 2.4666721628980612, -0.6486628711086454>, BranchRadius(0.0054819770231377875)
  <-0.994052652906181, 2.468644217792998, -0.6436035621697885>, BranchRadius(0.005440973136492797)
  <-0.9937132868580089, 2.4718930654390032, -0.6393096207579408>, BranchRadius(0.005395193526648011)
  <-0.9937805643505309, 2.4751318603331653, -0.6350434599354013>, BranchRadius(0.0053567197790457596)
  <-0.9935253603322395, 2.4781891529147315, -0.6307006970127671>, BranchRadius(0.005317119222140726)
  <-0.9932296845729256, 2.4806553292600295, -0.6287179776662718>, BranchRadius(0.0031781481915919684)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.9952393748335021, 2.4624719007191627, -0.6650168238913227>, BranchRadius(0.00732724532449019)
  <-0.9925795154583343, 2.4615505036928926, -0.6583227187975093>, BranchRadius(0.007261877676104544)
  <-0.9893718788620061, 2.458689705865638, -0.6545259541952404>, BranchRadius(0.005734851191405954)
  <-0.9864908965551363, 2.4562915111982027, -0.650251294397066>, BranchRadius(0.0056854298962823275)
  <-0.9843762281616294, 2.4570551710282627, -0.6481369928663555>, BranchRadius(0.003086303567912435)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  7
  <-0.9885365545261153, 2.4637003801089468, -0.6902199467876116>, BranchRadius(0.013127543808625323)
  <-0.994606306978019, 2.4666596582754994, -0.6790979907217674>, BranchRadius(0.013011423013067982)
  <-1.0011010067730184, 2.4731547660970903, -0.6768105479415917>, BranchRadius(0.009465724774882991)
  <-1.001625873535634, 2.4789647509022554, -0.6748171832331872>, BranchRadius(0.0061648123584955895)
  <-1.0001699923312706, 2.4845469291717848, -0.6728006441471912>, BranchRadius(0.006111197443985498)
  <-0.9987108182178318, 2.4901286000063902, -0.6709194424752821>, BranchRadius(0.006068208807350616)
  <-0.9958895962214165, 2.493273184866087, -0.6732798295710751>, BranchRadius(0.0048393320546207584)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.994606306978019, 2.4666596582754994, -0.6790979907217674>, BranchRadius(0.013011423013067982)
  <-1.0011010067730184, 2.4731547660970903, -0.6768105479415917>, BranchRadius(0.009465724774882991)
  <-1.0074698974475165, 2.4750816381116425, -0.6760875687920166>, BranchRadius(0.00669315344474435)
  <-1.010732903219264, 2.4755378021134713, -0.6746516961802117>, BranchRadius(0.003594025934847203)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  6
  <-0.9127284621322456, 2.4414819261474148, -0.7493688020486668>, BranchRadius(0.022189250640743632)
  <-0.9313422852709986, 2.445125676973299, -0.7381489414614074>, BranchRadius(0.02203716414422342)
  <-0.9335165643399702, 2.4449186521652777, -0.7259466616566176>, BranchRadius(0.0123962083386528)
  <-0.9392323789387671, 2.4494523188035076, -0.7196427993833818>, BranchRadius(0.009641750322132589)
  <-0.9397164097809908, 2.4509721279088685, -0.7139092312944237>, BranchRadius(0.0059512946997843244)
  <-0.9405502905056335, 2.4511066310246274, -0.7114410722575829>, BranchRadius(0.0026086887860031645)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  5
  <-0.9335165643399702, 2.4449186521652777, -0.7259466616566176>, BranchRadius(0.0123962083386528)
  <-0.9392323789387671, 2.4494523188035076, -0.7196427993833818>, BranchRadius(0.009641750322132589)
  <-0.9451417136529808, 2.452783937887795, -0.7193307745001967>, BranchRadius(0.006790970623933363)
  <-0.951881483250452, 2.453222207061252, -0.7191658244853885>, BranchRadius(0.006756018250625381)
  <-0.9535033681841973, 2.4554512920150624, -0.720574270325813>, BranchRadius(0.003095650199073629)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.9313422852709986, 2.445125676973299, -0.7381489414614074>, BranchRadius(0.02203716414422342)
  <-0.9335165643399702, 2.4449186521652777, -0.7259466616566176>, BranchRadius(0.0123962083386528)
  <-0.9327833745417102, 2.443058808128981, -0.7202670548216293>, BranchRadius(0.006021172719634208)
  <-0.9312439348705467, 2.4406049761662065, -0.717840190297669>, BranchRadius(0.00377899949991306)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  15
  <-0.849189884700594, 2.4252046117950217, -0.7815127090986929>, BranchRadius(0.02977417104108131)
  <-0.8774217875776349, 2.428834089376237, -0.7734340571751364>, BranchRadius(0.02958847857652026)
  <-0.8913797670544649, 2.4293363539060606, -0.771767271296273>, BranchRadius(0.014066116589148034)
  <-0.905147152070559, 2.426945832389445, -0.7716617572540073>, BranchRadius(0.013973783185518847)
  <-0.9182025193886495, 2.4255482882351314, -0.7760294663704114>, BranchRadius(0.013837363491613642)
  <-0.9304072250878246, 2.429076344163161, -0.781215422729819>, BranchRadius(0.013722104911290483)
  <-0.9427237077728815, 2.4338277291919233, -0.7844584497561189>, BranchRadius(0.013593698161875084)
  <-0.9545947995842408, 2.438347920156745, -0.7890699256995269>, BranchRadius(0.013513721083728473)
  <-0.9601447834280535, 2.442299145834838, -0.785397929587058>, BranchRadius(0.007739383727131881)
  <-0.966373809627351, 2.4432008700045524, -0.780967731119156>, BranchRadius(0.007696787143658213)
  <-0.9730206647498104, 2.4455633632818, -0.778024557807883>, BranchRadius(0.007643580747542005)
  <-0.9775231142534246, 2.4487748411203123, -0.7728233732810046>, BranchRadius(0.007591966933706313)
  <-0.9819434423714933, 2.452057587716262, -0.7676668026125254>, BranchRadius(0.007543603047856345)
  <-0.9855987587513383, 2.4548390899695804, -0.7644252418456747>, BranchRadius(0.005621904377269791)
  <-0.9888293922942719, 2.4543405374490583, -0.7632234179414054>, BranchRadius(0.0034828046745862583)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  4
  <-0.9427237077728815, 2.4338277291919233, -0.7844584497561189>, BranchRadius(0.013593698161875084)
  <-0.9545947995842408, 2.438347920156745, -0.7890699256995269>, BranchRadius(0.013513721083728473)
  <-0.9574259678470012, 2.437400821285917, -0.7965912482843426>, BranchRadius(0.008092144550614728)
  <-0.9588830903413195, 2.4350681857812564, -0.7995158834004611>, BranchRadius(0.004014708572671825)
}

sphere_sweep
{
  #ifdef (QUICKRENDER) linear_spline #else cubic_spline #end
  13
  <-0.9545947995842408, 2.438347920156745, -0.7890699256995269>, BranchRadius(0.013513721083728473)
  <-0.9574259678470012, 2.437400821285917, -0.7965912482843426>, BranchRadius(0.008092144550614728)
  <-0.9579843825445701, 2.441306352876847, -0.8001736542211193>, BranchRadius(0.005329037087323295)
  <-0.9574086765300828, 2.4435294537087477, -0.8049514981801814>, BranchRadius(0.00530107608142539)
  <-0.9566901229640269, 2.44508167522538, -0.8099399308875971>, BranchRadius(0.005273535032632496)
  <-0.9578997657643642, 2.44505470891469, -0.8150284809674753>, BranchRadius(0.005230421092201732)
  <-0.9566876723683816, 2.44586190272491, -0.8199989571705038>, BranchRadius(0.0051794175283244965)
  <-0.9560850874424736, 2.447127417831616, -0.8249558460659876>, BranchRadius(0.00515125078018957)
  <-0.9540479931077732, 2.448784275407188, -0.8293443347548879>, BranchRadius(0.005114075021624495)
  <-0.9514555744950722, 2.4490965915934457, -0.8336886779080084>, BranchRadius(0.0050686776476455775)
  <-0.9505309015713682, 2.4493324301585893, -0.8386375054835712>, BranchRadius(0.005039993473933392)
  <-0.949657580879244, 2.4496385605030606, -0.8435529225917312>, BranchRadius(0.005001772702381654)
  <-0.9483191157551252, 2.450439420238902, -0.8451698640421865>, BranchRadius(0.0022466341177805565)
}

  texture {branchTexture}
}

object
{
  BonsaiLeaf(0.0026412768649975212)
  matrix <0.5790798006674782, 0.799987842061197, 0.15711790799645725,
          0.7906040905734032, -0.5980794584177577, 0.1313245345977837,
          0.19902702436482428, 0.04817067544670056, -0.9788093939064401,
          1.1872804706865319, 2.1710889120516694, 0.268596694410971>
}

object
{
  BonsaiLeaf(0.002411565006763415)
  matrix <0.04662094331656097, -0.9981257594541708, -0.039641593791233165,
          0.9788844320024496, 0.03774326881768092, 0.2008997621755649,
          -0.19902702436482422, -0.048170675446700506, 0.97880939390644,
          1.1875529098346105, 2.1727596258349404, 0.268734312792261>
}

object
{
  BonsaiLeaf(0.004571373854098112)
  matrix <0.45204097555804446, 0.6688404587422919, -0.5901791229499161,
          0.8919927621611516, -0.3368685881602832, 0.30144396919331085,
          0.0028051147305392515, -0.6627005319601745, -0.7488792534655039,
          1.19101632772167, 2.1746521088592092, 0.26746865383751256>
}

object
{
  BonsaiLeaf(0.0036022127861560335)
  matrix <0.9252003071749133, -0.28245858555932746, 0.2534196895414227,
          0.3794687377568742, 0.6935741866473447, -0.6123384069954122,
          -0.0028051147305392793, 0.6627005319601746, 0.7488792534655039,
          1.1883056224697761, 2.178690462918681, 0.2638848675191334>
}

object
{
  BonsaiLeaf(0.00409182855878403)
  matrix <-0.010604110456689686, -0.8333158247342904, 0.5526954759076927,
          0.8855683906788181, -0.2645202594083318, -0.38183459480916265,
          0.46438796094639545, 0.4854006269154973, 0.7407631558859358,
          1.177854891759477, 2.1637798567681363, 0.2685091675553759>
}

object
{
  BonsaiLeaf(0.00255819637285342)
  matrix <0.42652983956105117, 0.6104477472147279, -0.667402310367957,
          0.7761546995877002, -0.6258911880754552, -0.07644673307226765,
          -0.4643879609463958, -0.48540062691549796, -0.7407631558859351,
          1.1762168538649995, 2.163261075752825, 0.2698760034998858>
}

object
{
  BonsaiLeaf(0.004789894355559881)
  matrix <0.9004435058635291, 0.2656496872649716, 0.34442958119798567,
          0.385531329910526, -0.8540766270717159, -0.3491685964505146,
          0.20141272652347098, 0.4471949896251336, -0.8714640295781332,
          1.171854904806519, 2.163872457495356, 0.2690144328732359>
}

object
{
  BonsaiLeaf(0.003970556811672524)
  matrix <0.20411768294001498, 0.6958736351980201, 0.6885461896978965,
          -0.7343188320959853, -0.35629898092645473, 0.5777775428484202,
          0.6473884647878649, -0.6235470471640946, 0.4382661926644011,
          1.2111346762592388, 2.2083166098401397, 0.3354497254677035>
}

object
{
  BonsaiLeaf(0.0036195775987346974)
  matrix <-0.6986061726894828, -0.2555997737312068, 0.6682949731583417,
          0.30469261746843346, 0.7388219241748943, 0.6010861612271081,
          -0.6473884647878649, 0.6235470471640947, -0.4382661926644011,
          1.2151531894726455, 2.2124055384720465, 0.3353313049134024>
}

object
{
  BonsaiLeaf(0.003343849695207162)
  matrix <0.9642881185384302, -0.10057722210119036, 0.24501560529897456,
          -0.10700508944652215, 0.6982880794946578, 0.7077737412960474,
          -0.24227739324616504, -0.708715726106081, 0.6625886237264964,
          1.2126920216066408, 2.1970434767274027, 0.31036870794156574>
}

object
{
  BonsaiLeaf(0.004875435401389582)
  matrix <0.6197704998421203, 0.6712107160881985, 0.4066456714804868,
          0.5250988188427288, -0.7397600431026939, 0.42074494539883817,
          0.5832287355535736, -0.04723614333397205, -0.8109334058894804,
          1.224968919388677, 2.170357918319822, 0.3070869632482822>
}

object
{
  BonsaiLeaf(0.0035986330663051774)
  matrix <-0.09603144601130309, -0.9953165173051746, -0.01109016485341624,
          0.8066115566997285, -0.08434321041097642, 0.5850333490118416,
          -0.5832287355535735, 0.04723614333397225, 0.8109334058894804,
          1.225311533037667, 2.173661050356595, 0.30714096880117425>
}

object
{
  BonsaiLeaf(0.004544590526361768)
  matrix <0.8972440766446103, -0.21226834180176501, 0.3871630380019383,
          -0.27654463906962556, 0.41339790963696904, 0.8675397575383134,
          -0.34420361637846253, -0.8854627713102984, 0.3122171537495572,
          1.1496918175072515, 2.2382220809425366, 0.27525974669785547>
}

object
{
  BonsaiLeaf(0.0049921347624786)
  matrix <-0.7483442897915127, 0.45955810190420765, 0.47831702343805327,
          0.5670138396974319, 0.06900747494067994, 0.8208125693444799,
          0.3442036163784627, 0.8854627713102983, -0.31221715374955716,
          1.1537792091540433, 2.236687851333305, 0.2754147406954086>
}

object
{
  BonsaiLeaf(0.004772336119369059)
  matrix <-0.47057278878998726, 0.11703622943172967, 0.8745649040813485,
          0.3542354169272617, 0.9328408177478607, 0.06576684679891343,
          -0.8081327365258655, 0.3407499519352956, -0.4804278826330862,
          1.15422796212403, 2.234069987302182, 0.26035577560973217>
}

object
{
  BonsaiLeaf(0.0033035502414703074)
  matrix <0.4232470808157902, 0.8951511157772076, -0.13987990743395823,
          0.49753129204102153, -0.358664798831035, -0.7898241421477863,
          -0.7571819609716712, 0.26469613144569004, -0.5971695203012133,
          1.1943021204223438, 2.258401722907406, 0.17557457033554602>
}

object
{
  BonsaiLeaf(0.0027323064181264995)
  matrix <0.09322631634783438, -0.8610656143244687, -0.49987484610474275,
          0.6465170778249479, 0.43416813082688605, -0.6273067050932734,
          0.7571819609716711, -0.26469613144569015, 0.5971695203012132,
          1.194424983563552, 2.2607728704605954, 0.17646979993459727>
}

object
{
  BonsaiLeaf(0.003003492912969772)
  matrix <-0.7019794786730658, 0.16114778075892686, -0.6937263179946134,
          0.5953234445778525, 0.6674214150862103, -0.4473685851960121,
          0.39091534615291335, -0.7270351074334678, -0.564451188944939,
          1.2002179607374925, 2.268743233888045, 0.19228466337072528>
}

object
{
  BonsaiLeaf(0.0049776883906017646)
  matrix <0.11247312705895703, 0.3040236151006716, 0.9460018166741005,
          -0.0529598924050987, 0.9525236997762873, -0.2998230330727343,
          -0.9922424328187247, -0.01637812033209637, 0.12323437705594759,
          1.1993382294613044, 2.289095714070398, 0.18469086009715152>
}

object
{
  BonsaiLeaf(0.002655068471074152)
  matrix <-0.22695366026211247, -0.6625562779536573, 0.7138005426152504,
          -0.3925118369442356, 0.7329914858954958, 0.5555699231090323,
          -0.8913060607626835, -0.15408653461256827, -0.4264162824034726,
          0.874485068933317, 2.0776347560293726, 0.47381758473750146>
}

object
{
  BonsaiLeaf(0.0035541577749496605)
  matrix <0.07122422794512301, 0.8812218500367974, -0.4673062811169419,
          -0.4477729507253979, 0.4468840910894178, 0.7744636813497815,
          0.8913060607626835, 0.15408653461256894, 0.42641628240347235,
          0.8739357590218783, 2.0772769100124524, 0.4750950746656631>
}

object
{
  BonsaiLeaf(0.002949618214013054)
  matrix <-0.09500180979099213, 0.9946084516342547, 0.04157744670067626,
          -0.5698081280234926, -0.08857873416100265, 0.8169899051351847,
          0.8162679421457151, 0.05392435249630442, 0.5751511199963489,
          0.8512676827757275, 2.070579715256011, 0.5035534974511805>
}

object
{
  BonsaiLeaf(0.0041490631585133515)
  matrix <-0.32780885142332733, -0.7765641898427139, 0.5380422065065606,
          -0.4756553411386439, 0.6277262327334939, 0.6162075731314062,
          -0.8162679421457151, -0.05392435249630431, -0.575151119996349,
          0.8509748751565699, 2.0734454644895335, 0.5037003732860055>
}

object
{
  BonsaiLeaf(0.0036245005672048422)
  matrix <-0.4853027145099704, 0.5583365632949988, 0.6728607265825408,
          0.1863859125503201, -0.6858076939502014, 0.7035112639620571,
          0.854249124607125, 0.46682768663248464, 0.22875826564590784,
          0.873478913500948, 2.0538274322556265, 0.4810276648002245>
}

object
{
  BonsaiLeaf(0.004779095020437267)
  matrix <0.267247986132707, -0.8270984389189547, 0.49445594975269624,
          -0.8625527429502955, 0.023448458640495717, 0.5054235208380266,
          -0.42962923496537664, -0.5615677538153463, -0.7071494738298627,
          0.864624723145632, 2.056405539044876, 0.4793746085800382>
}

object
{
  BonsaiLeaf(0.00463525085410882)
  matrix <-0.8514301722787758, -0.008946383072782171, 0.5243916703793546,
          0.3008078825370102, -0.8273823904971043, 0.47429210166193786,
          0.4296292349653773, 0.5615677538153458, 0.7071494738298629,
          0.8701412646587826, 2.052458351700724, 0.4791576044177149>
}

object
{
  BonsaiLeaf(0.002986719783003404)
  matrix <0.3920630295278379, -0.8315982906952626, -0.3933584418697175,
          0.4554583567992424, -0.19603917935778614, 0.868404471072357,
          -0.7992773399134925, -0.5196276773512394, 0.3018986764319581,
          0.9086610054653488, 2.006029112039837, 0.4290582330274245>
}

object
{
  BonsaiLeaf(0.0027504333125258906)
  matrix <0.027645164716866732, 0.47003516552994973, 0.8822146496363628,
          0.6003261436657492, -0.7134802170318313, 0.361323264038758,
          0.7992773399134925, 0.5196276773512398, -0.3018986764319575,
          0.9089518360046808, 2.004652246378316, 0.4274583477560269>
}

object
{
  BonsaiLeaf(0.0034524022576967253)
  matrix <0.7730238240289602, -0.6315493134367479, -0.059830027421163334,
          0.4265733544080542, 0.4476795824959092, 0.7858868650927748,
          -0.4695416283916746, -0.6330311651995194, 0.6154690919074924,
          0.936405878607565, 1.9609747558668345, 0.4893076959970482>
}

object
{
  BonsaiLeaf(0.002744535967853462)
  matrix <0.1319384352006947, 0.6389559042540552, 0.7578440484266367,
          0.8729965111752096, -0.43704335746584966, 0.21649525438422756,
          0.46954162839167485, 0.6330311651995186, -0.615469091907493,
          0.9373291461204643, 1.9582297046514243, 0.4871886774222348>
}

object
{
  BonsaiLeaf(0.0038351852509403692)
  matrix <0.9543763017070457, 0.24102868937284316, 0.17626980921074636,
          0.10158418487906229, -0.8171682274234332, 0.5673770716834625,
          0.28079623950907934, -0.5235850064591745, -0.8043706937032862,
          0.9039484708078024, 1.9647982177400387, 0.4757698382242444>
}

object
{
  BonsaiLeaf(0.004226060770912433)
  matrix <-0.668734368934226, 0.3145817432834115, 0.6736710403445535,
          0.04640488742420712, -0.8866526361115229, 0.46010182492534624,
          0.7420518379663851, 0.3389475323250746, 0.5783369606911288,
          0.8622733193218899, 1.996685274235869, 0.45944401309602534>
}

object
{
  BonsaiLeaf(0.004756753492128231)
  matrix <0.4961117400460014, -0.8578931809579431, -0.13376259362912904,
          -0.4508128338448668, -0.38617853435503746, 0.8047570617547605,
          -0.7420518379663851, -0.3389475323250746, -0.5783369606911289,
          0.85993280392588, 1.9985953660668876, 0.4613276257868999>
}

object
{
  BonsaiLeaf(0.0023503510098534775)
  matrix <-0.011578922624769613, 0.9793772683346434, -0.20170794436566308,
          -4.938170729968027E-4, 0.20171584206246168, 0.9794439622590623,
          0.9999328400925478, 0.011440512680982118, -0.0018520189114228924,
          1.0921561468932768, 1.8979529621312181, 0.2825847178796234>
}

object
{
  BonsaiLeaf(0.0023112347214242625)
  matrix <-4.801284349857018E-4, 0.20055790747157393, 0.979681731598232,
          -0.011579498311148923, 0.979615047056863, -0.2005499309365183,
          -0.9999328400925478, -0.011440512680982007, 0.001852018911422837,
          1.0921305445981797, 1.8997429794085106, 0.27981916281007324>
}

object
{
  BonsaiLeaf(0.004793880034945227)
  matrix <-0.33890018499293806, 0.43680591712957506, 0.8332750178496557,
          0.64196729723817, 0.7548269134123721, -0.1345894500511477,
          -0.6877678779126516, 0.48932292154459933, -0.5362260946304148,
          1.0989585852052677, 1.888402336465689, 0.26316057240414104>
}

object
{
  BonsaiLeaf(0.004204060555589663)
  matrix <-0.15763760506371985, 0.012516314751954333, -0.9874177066139767,
          0.7915096995044142, 0.5995063729675278, -0.11876238614035879,
          0.590476740490434, -0.800272110370185, -0.10441153338326037,
          1.0941685928952014, 1.8603912909898888, 0.23926513794967783>
}

object
{
  BonsaiLeaf(0.003385821004516584)
  matrix <0.03700809438845738, 0.8129727829532071, 0.5811244747272766,
          0.5165154599992644, 0.48225937968114757, -0.7075575385022083,
          -0.85547774987517, 0.3263451315507446, -0.4020655103109988,
          1.0993329388601842, 1.865652774263872, 0.22920394624865129>
}

object
{
  BonsaiLeaf(0.0038164228080101426)
  matrix <0.014608274725981502, -0.7609109301807808, -0.6486918795861016,
          0.5176334782237785, 0.5608149529430775, -0.6461750310692974,
          0.85547774987517, -0.3263451315507445, 0.40206551031099885,
          1.099559618179044, 1.8661602373040074, 0.22913353229787659>
}

object
{
  BonsaiLeaf(0.003837411944564876)
  matrix <-0.4055613606635446, -0.3136185701454137, -0.8585821889584485,
          -0.13503472213971598, -0.9084355726563176, 0.3956139964020965,
          -0.9040384983801215, 0.2763841579984901, 0.3260769704442218,
          1.1383479936843615, 1.8028099402858933, 0.2442555769816533>
}

object
{
  BonsaiLeaf(0.002953750002763522)
  matrix <-0.03158539754080206, -0.8039480973067928, 0.5938601009488489,
          -0.42628248393384116, -0.526573123169283, -0.7355297341691508,
          0.9040384983801214, -0.27638415799849003, -0.3260769704442219,
          1.1376070456519338, 1.8047406164392557, 0.24056487215208805>
}

object
{
  BonsaiLeaf(0.004941495496236571)
  matrix <-0.4087462047553994, -0.9073400871406119, -0.09828787496799178,
          0.9000157222872445, -0.3828877676237817, -0.20825142746172848,
          0.15132164330930153, -0.17358261339127135, 0.9731242657515171,
          1.1449570684138566, 1.80909411347036, 0.24228942570083267>
}

object
{
  BonsaiLeaf(0.003126693582578133)
  matrix <0.8573398581749084, 0.29706739744846067, -0.420379981633078,
          0.4240681646691896, 0.05530014805944029, 0.9039403107167584,
          0.2917782707789145, -0.9532538250632945, -0.07856580492468951,
          1.152128435039274, 1.8246446772845173, 0.2527081164535362>
}

object
{
  BonsaiLeaf(0.0027246383562201564)
  matrix <0.23430381021352367, -0.008404044367063976, 0.9721270989730214,
          0.9273441460540376, 0.30205383136201736, -0.22089888577997494,
          -0.2917782707789144, 0.9532538250632946, 0.07856580492468918,
          1.1533291812599822, 1.8252947581210364, 0.249279902507942>
}

object
{
  BonsaiLeaf(0.0041359814142782215)
  matrix <0.41254728055357115, -0.610888052685928, 0.6757370260637257,
          0.5702538083307371, -0.4052796528722326, -0.714534111888337,
          0.7103628195451567, 0.6801207172652202, 0.18116421985176343,
          1.110891780589435, 1.8194565654306971, 0.23845122230713622>
}

object
{
  BonsaiLeaf(0.0037811088377604943)
  matrix <0.5220601220659647, 0.0469569938310041, 0.8516150947927273,
          -0.027350793002878987, -0.9970481049256044, 0.07174266921696593,
          0.8524700364649684, -0.060746334824550385, -0.5192347443447908,
          1.114924415815217, 1.806594962666606, 0.2526243469391302>
}

object
{
  BonsaiLeaf(0.002929410435880685)
  matrix <0.08973473392177211, -0.9614812460815583, 0.25981049047612154,
          0.5150170040468617, 0.2680740499168796, 0.8141828967153253,
          -0.8524700364649684, 0.060746334824550496, 0.5192347443447908,
          1.1165365283266708, 1.8111502089872278, 0.25473815597286287>
}

object
{
  BonsaiLeaf(0.004028336565076233)
  matrix <-0.6956351655164583, -0.6908027106303967, 0.19718856833646872,
          -0.7132604990499227, 0.6313765305415803, -0.3043404954591682,
          0.08573900507905059, -0.3523567675907089, -0.9319300034557755,
          0.8546132686567193, 1.7522501919374691, 0.06956539850637865>
}

object
{
  BonsaiLeaf(0.004182417263301006)
  matrix <-0.0784753972346163, 0.9300799980667946, -0.3588771506030161,
          -0.993222248561179, -0.10390334705435658, -0.05209279637318584,
          -0.08573900507905062, 0.35235676759070883, 0.9319300034557756,
          0.8533324521267897, 1.7492722276207227, 0.07057351064162538>
}

object
{
  BonsaiLeaf(0.003983032151322162)
  matrix <-0.6681647674166427, -0.060849060098464414, -0.7415208934805533,
          0.719401785157242, -0.3070613557209645, -0.6230364317882041,
          -0.18978122956614646, -0.9497424470391626, 0.24894250178791275,
          0.9355593119664115, 1.72161331986487, 0.10044059247991811>
}

object
{
  BonsaiLeaf(0.004882481429578574)
  matrix <-0.6857587385817727, 0.09609229126370751, 0.7214577077129519,
          -0.7051024417970829, -0.3334821562664738, -0.625795651969279,
          0.180459133962589, -0.9378464282661387, 0.29644321202874346,
          0.9219813268962331, 1.7283470665348033, 0.13481134306912101>
}

object
{
  BonsaiLeaf(0.004589909222446279)
  matrix <-0.9820480205976835, -0.027133743356918726, -0.1866693472737634,
          -0.1886310258881212, 0.1404973170578261, 0.9719459038300164,
          -1.4598824243289288E-4, 0.9897091814624099, -0.14309337796152374,
          0.9076229780870658, 1.7342019572872232, 0.16289901185364622>
}

object
{
  BonsaiLeaf(0.004524719997976676)
  matrix <0.6000514498129034, 0.11455587991511465, 0.7917166209915685,
          -0.7999613967341586, 0.08574780758643485, 0.5938931530412301,
          1.4598824243283737E-4, -0.9897091814624098, 0.1430933779615237,
          0.9048691760430168, 1.7339450721756995, 0.161125068612165>
}

object
{
  BonsaiLeaf(0.0042312373319522405)
  matrix <0.8359712350966788, -0.5452812831627389, -0.06180951644635291,
          -0.15126119909828656, -0.33722586548318056, 0.9291925340296646,
          -0.5275150649396506, -0.7674288487420298, -0.3643910240115688,
          0.9064126185808847, 1.6736117387677243, 0.16200205858796674>
}

object
{
  BonsaiLeaf(0.0029044042537944084)
  matrix <-0.44080823372298755, -0.11940881000258752, 0.8896233119561263,
          0.7262340926614075, -0.6299162628574131, 0.27529900915915817,
          0.5275150649396511, 0.7674288487420295, 0.3643910240115686,
          0.9091619180013616, 1.6732090899656793, 0.15887000406267635>
}

object
{
  BonsaiLeaf(0.00354718765447737)
  matrix <-0.5178909450359306, -0.6788985713641221, -0.5204668085954616,
          -0.5165283579678596, 0.7331556979222366, -0.44235865315283013,
          0.6818998639571786, 0.03974232509444514, -0.73036506154886,
          0.9222961749382741, 1.727599626914823, 0.14522763350274434>
}

object
{
  BonsaiLeaf(0.0026366179167599453)
  matrix <-0.31095091315289136, 0.9195514938800698, -0.24028021082127332,
          -0.6620589891728422, -0.39095472589421354, -0.6393999508573762,
          -0.6818998639571785, -0.039742325094445086, 0.7303650615488599,
          0.9223828013600401, 1.7239681878394089, 0.1451109092896533>
}

object
{
  BonsaiLeaf(0.0046014198729358085)
  matrix <0.665061509598174, 0.7066934649331582, -0.24140740475752875,
          0.6836760726125131, -0.7062287355662451, -0.1839238994737597,
          -0.3004666640213672, -0.042723760149004836, -0.9528349616437263,
          0.987254628008563, 1.7914246939297174, 0.23607368578015267>
}

object
{
  BonsaiLeaf(0.0036985277373099076)
  matrix <0.503494576610302, -0.44683307218913226, 0.7394818570607633,
          0.8106105803526782, -0.05189443273129554, -0.5832816256936203,
          0.29900451224740454, 0.8931109524854784, 0.33607905053152676,
          1.023735449493802, 1.7786884770684728, 0.24304393807956262>
}

object
{
  BonsaiLeaf(0.003704974040291919)
  matrix <0.3055248321355274, 0.2440525057850732, -0.9203765269543683,
          0.9040192910575808, -0.37787723002386353, 0.19989477338150374,
          -0.29900451224740454, -0.8931109524854786, -0.33607905053152654,
          1.0240867517835022, 1.7774803847396856, 0.24594182629702221>
}

object
{
  BonsaiLeaf(0.002608304298748424)
  matrix <0.8492993494296108, -0.2886363666060359, 0.44201771789251465,
          -0.2638519363519454, -0.9573002676708977, -0.11814547473583858,
          0.45724476021248167, -0.016286355936607794, -0.8891917587722776,
          0.9534042637534906, 1.8168016640272056, 0.24392503955782047>
}

object
{
  BonsaiLeaf(0.003444643580341504)
  matrix <-0.048641900553323736, -0.9987936821799162, -0.006719073451395469,
          0.888009681686406, -0.046324238232169745, 0.45748537701594105,
          -0.4572447602124814, 0.016286355936608002, 0.8891917587722777,
          0.9571513467426127, 1.819139023940724, 0.2458090729744897>
}

object
{
  BonsaiLeaf(0.003589570277484097)
  matrix <0.06696693317775076, -0.8313736945135214, 0.5516640371926618,
          0.9851799528287076, 0.14260279055843197, 0.09531476627141135,
          -0.1579110205311606, 0.5371054125550101, 0.8286023686901465,
          1.0360722613847857, 1.7508263177913808, 0.20084532402882968>
}

object
{
  BonsaiLeaf(0.002437353319651181)
  matrix <0.8790288627443243, 0.45874753205668595, -0.1298420590345065,
          0.4498581643776489, -0.7078619057669464, 0.5445724509252742,
          0.15791102053116055, -0.5371054125550103, -0.8286023686901461,
          1.0336323519984567, 1.7485891254870303, 0.2018305004478698>
}

object
{
  BonsaiLeaf(0.004514358561307707)
  matrix <0.7426891033503915, 0.16193091643923216, -0.6497624751135935,
          0.6694978566044044, -0.15982295308659333, 0.7254166000780446,
          0.013620417273361551, -0.9737735886579758, -0.22711116719674623,
          1.030220192907857, 1.7497844945739944, 0.20263650719442022>
}

object
{
  BonsaiLeaf(0.004051805690678454)
  matrix <0.9329207853062048, 0.3377880373381668, 0.12473191321744215,
          0.3187162308143339, -0.9358242734903189, 0.15050878167675907,
          0.1675672180325217, -0.10065868555443838, -0.9807084462077887,
          1.0149641716200781, 1.7465920814810723, 0.1964094517787406>
}

object
{
  BonsaiLeaf(0.004648474504527245)
  matrix <-0.38858926728758003, 0.8782272312072273, 0.27877466117814403,
          0.7948551821826078, 0.16647468175914426, 0.5835164262389242,
          0.4660510923776017, 0.448333704621099, -0.7627537404656666,
          0.9964137904824856, 1.860871504807523, 0.2938327808519933>
}

object
{
  BonsaiLeaf(0.003921992302809442)
  matrix <0.006408617415654114, 0.6412497165480056, 0.7673055002083083,
          0.1951313973772164, 0.75176858277694, -0.6298950195922857,
          -0.980756171217105, 0.15376215066346463, -0.12031015602563076,
          1.0159769305549968, 1.8964234593369522, 0.3020804709736231>
}

object
{
  BonsaiLeaf(0.003924673899795919)
  matrix <0.14997073390069063, 0.19877463467669512, -0.9685026709216833,
          0.12500444629233642, 0.9679079737415602, 0.21800927222174246,
          0.980756171217105, -0.15376215066346463, 0.12031015602563086,
          1.0157022284041688, 1.897273751903755, 0.30540652969264426>
}

object
{
  BonsaiLeaf(0.003438575895183756)
  matrix <0.7986165377108886, -0.04616242093872516, 0.6000672100587979,
          0.49096389289887654, -0.5267003670918905, -0.6939316819218216,
          0.34808918622136825, 0.8487966506757334, -0.3979675416882666,
          1.0053893473076743, 1.8333412285278579, 0.25575347817393085>
}

object
{
  BonsaiLeaf(0.0028708885905627517)
  matrix <0.029707965593473107, -0.4342905478673336, -0.9002828204588758,
          0.9369905843796104, -0.301555908306814, 0.17638786508490228,
          -0.3480891862213682, -0.8487966506757334, 0.3979675416882667,
          1.0063911262783067, 1.8342865942975495, 0.2586460048376775>
}

object
{
  BonsaiLeaf(0.004838958457839272)
  matrix <0.5477426325832964, -0.7077971162184056, -0.44609556232227765,
          0.8019614744864509, 0.292241504033695, 0.5210112251762352,
          -0.23840260462133808, -0.6431315150053155, 0.7276991497292885,
          0.9956909824548398, 1.846451838927051, 0.2655166575992316>
}

object
{
  BonsaiLeaf(0.0037891248036126786)
  matrix <0.5118449414202764, -0.1842872301945812, -0.8390786451398248,
          -0.5483858929579305, -0.8219225579904336, -0.1540007177619478,
          -0.6612773006441458, 0.538963380438478, -0.5217574208376161,
          1.019126021881966, 2.199399147035273, 0.2021808702208518>
}

object
{
  BonsaiLeaf(0.003270422770119754)
  matrix <-0.6604375543952209, -0.748127773472489, 0.06424228594590525,
          0.3557169779434942, -0.38707016044307074, -0.8506715714641719,
          0.6612773006441458, -0.5389633804384779, 0.521757420837616,
          1.0223672693753088, 2.2012476311200566, 0.19998234248308777>
}

object
{
  BonsaiLeaf(0.004543645992974217)
  matrix <0.05516146913517678, -0.7364536829070224, -0.6742352595760119,
          0.5749078196817687, 0.5755226227056796, -0.581596689831305,
          0.8163566691046291, -0.3555413951801661, 0.45513965452565985,
          1.0224768452116806, 2.211608106109012, 0.208212894509973>
}

object
{
  BonsaiLeaf(0.0029272155733524163)
  matrix <0.6584042703855534, -0.07912326615492682, -0.7484940383804305,
          0.7028532514480064, 0.42039426794685253, 0.573817014741107,
          0.2692603269459385, -0.9038850414905684, 0.33240142614399243,
          1.0382537384094246, 2.220062571638151, 0.22323569237845406>
}

object
{
  BonsaiLeaf(0.004201162532191103)
  matrix <0.8390019374974136, 0.3896158181401177, 0.37983583708043306,
          0.47283678495708603, -0.1766107188836516, -0.8632693836612347,
          -0.2692603269459385, 0.9038850414905684, -0.33240142614399254,
          1.038182799610808, 2.2180900166551116, 0.217929271286824>
}

object
{
  BonsaiLeaf(0.004223455651360407)
  matrix <0.3860910352568556, 0.8320389111607087, 0.3983026020612868,
          0.8934879584362081, -0.2299424755768696, -0.38575345242146414,
          -0.22937519618255814, 0.5048145285548775, -0.8321954765174648,
          1.0242230480650898, 2.2119843976468823, 0.22048969032679594>
}

object
{
  BonsaiLeaf(0.0040888278985189526)
  matrix <0.9058118890374866, -0.21635866851758986, 0.3642715309156568,
          0.33761192948204183, -0.1508538609112522, -0.9291185595603945,
          0.25597462130014675, 0.964589051983001, -0.06359995318223015,
          1.0180387442063688, 2.180634605909743, 0.2292377363834219>
}

object
{
  BonsaiLeaf(0.003688503966810469)
  matrix <-0.4779796523051386, 0.156396345133903, -0.8643353719540905,
          0.8671238747491228, 0.24098152356772568, -0.43591752790986227,
          0.14011294666206542, -0.9578455452356267, -0.25079926963597593,
          1.060431729133152, 2.179506887270006, 0.21158973830457853>
}

object
{
  BonsaiLeaf(0.0025874800195292338)
  matrix <0.8086181143144567, -0.03548300378365309, 0.58726288972233,
          0.5714062542361658, 0.2850839664287601, -0.7695596303763861,
          -0.1401129466620658, 0.9578455452356267, 0.25079926963597554,
          1.0587118415472938, 2.1793556750314207, 0.21120640166804108>
}

object
{
  BonsaiLeaf(0.002660985042408192)
  matrix <0.10401154917548006, -0.6037524383242936, 0.7903572552052567,
          0.7310610444204094, 0.5852073156087859, 0.3508306530064027,
          -0.6743377098821166, 0.5413089607381618, 0.502248207618021,
          1.0098520404702676, 2.1768060642679576, 0.25322891918615886>
}

object
{
  BonsaiLeaf(0.004925002879409629)
  matrix <0.5067944503869044, 0.833951409635221, -0.21836765196444063,
          0.5370549674735157, -0.10728306199954672, 0.8366972609731809,
          0.6743377098821164, -0.5413089607381623, -0.5022482076180209,
          1.0105516952271858, 2.174720466965155, 0.2564161004855776>
}

object
{
  BonsaiLeaf(0.00353513474961294)
  matrix <0.6690064125692425, 0.72448187714264, -0.16600129407058456,
          0.7429245309177637, -0.6584916721751717, 0.12021588512575235,
          -0.02221623959751217, -0.20375163157094672, -0.97877051004325,
          1.0205220647604034, 2.168433189775984, 0.23547491910891455>
}

object
{
  BonsaiLeaf(0.004446194588192786)
  matrix <-0.14000999243055967, -0.9687300932283527, 0.20483947005736364,
          0.989900823677676, -0.14158841444823286, 0.007005724537480759,
          0.022216239597512063, 0.2037516315709464, 0.9787705100432501,
          1.0222970181198994, 2.1701315169265505, 0.23508108857047597>
}

object
{
  BonsaiLeaf(0.00474827776630245)
  matrix <0.38333219725790335, 0.7889287406408099, -0.4802581271944638,
          -0.33495212201707875, -0.36583490210818326, -0.8683155534457233,
          -0.8607342810076086, 0.49371678783529516, 0.12401705893914125,
          0.8661760980713887, 2.180302961154223, 0.23125336867174628>
}

object
{
  BonsaiLeaf(0.003208571775750865)
  matrix <-0.4503892653169909, -0.8521362240557967, 0.2664833303213361,
          -0.23724672218080678, -0.17351538566227448, -0.9558276014810078,
          0.8607342810076088, -0.49371678783529477, -0.1240170589391415,
          0.8670053206484596, 2.181483310316946, 0.23230953064371163>
}

object
{
  BonsaiLeaf(0.0029575741848245508)
  matrix <-0.7457322823925354, 0.15498670128807596, -0.6479679663544033,
          -0.5925501979562554, 0.29032521398003025, 0.7513957233239046,
          0.3045777830039864, 0.9442935944669382, -0.12466748392859246,
          0.8415915603743882, 2.1923604780887187, 0.24376486461183552>
}

object
{
  BonsaiLeaf(0.004718821102560584)
  matrix <-0.12285411802164785, 0.1687401301459002, 0.9779742502558382,
          -0.9445312275332672, 0.28255331519388405, -0.1674048514453693,
          -0.3045777830039864, -0.9442935944669382, 0.1246674839285928,
          0.8388869976545649, 2.192835138276983, 0.24075260247227373>
}

object
{
  BonsaiLeaf(0.0032344014702197377)
  matrix <0.5005277420253341, -0.13925621663484916, -0.8544470057245033,
          -0.5646104876160507, -0.8006970710936077, -0.2002478404779522,
          -0.6562674582340544, 0.5826593399840655, -0.47939661741854983,
          0.8212863321604399, 2.090013573296118, 0.20457225625383355>
}

object
{
  BonsaiLeaf(0.002762171919743575)
  matrix <-0.7498714554399919, -0.5741340636816458, 0.3287291852524022,
          0.08370079796108379, -0.5752201060896027, -0.8137051099574985,
          0.6562674582340544, -0.5826593399840655, 0.4793966174185498,
          0.8233437051454751, 2.0910144922553515, 0.20297234475780732>
}

object
{
  BonsaiLeaf(0.004499700734731433)
  matrix <-0.09974469220911225, -0.943553710407631, -0.31584393606986033,
          0.04707214660572227, 0.3125968268050816, -0.9487188397440642,
          0.9938989935552002, -0.10949712072646728, 0.013235224311462748,
          0.829620267053234, 2.131595598063412, 0.2290441251627338>
}

object
{
  BonsaiLeaf(0.004305228303001306)
  matrix <-0.004233557524226106, -0.3913585634773009, -0.9202285323677337,
          -0.2940325472974442, -0.8790701680715517, 0.3752072770302172,
          -0.9557860315575166, 0.27216560105868953, -0.11135056120153675,
          0.8284599175140201, 2.1300254145788546, 0.2410550789118474>
}

object
{
  BonsaiLeaf(0.004534163849568044)
  matrix <-0.07441800628990025, -0.46091648071903757, 0.8843177925052813,
          0.33944203895259195, 0.8221157077722098, 0.45706111760453394,
          -0.9376785496808298, 0.334188211694811, 0.09527421809010551,
          0.9032945078700754, 2.2480903947960034, 0.3380761698542966>
}

object
{
  BonsaiLeaf(0.004214448897060076)
  matrix <0.3160806745429382, 0.9341352762436358, -0.16578387393744654,
          0.1444020243934898, 0.12533764335366288, 0.9815490464106276,
          0.9376785496808295, -0.33418821169481155, -0.09527421809010536,
          0.9023639970004712, 2.2448910165664526, 0.3401404681538666>
}

object
{
  BonsaiLeaf(0.0029213965363567695)
  matrix <0.41631024141710626, -0.4587983724685229, 0.7849776024266334,
          0.8544361043036116, -0.09774827113207851, -0.5102785701488537,
          0.3108451810044661, 0.8831473993116468, 0.3513202876797413,
          0.9376457392975291, 2.2632375181706466, 0.301045442472052>
}

object
{
  BonsaiLeaf(0.003627945362517945)
  matrix <0.4609879810607329, 0.1831576509375059, -0.8682991167913308,
          0.8311831054369736, -0.43186102624817907, 0.3501866634296905,
          -0.31084518100446606, -0.8831473993116468, -0.3513202876797411,
          0.9381650795146517, 2.2619563114239374, 0.30380662660106733>
}

object
{
  BonsaiLeaf(0.003384120122203829)
  matrix <-0.4163450983744905, 0.641712197195502, 0.6440979855814317,
          0.4883618298839164, -0.4397125109116521, 0.7537609905402393,
          0.7669155639129835, 0.6283775646204212, -0.1303155942692181,
          0.8745283823988663, 2.243033210207837, 0.36484149423659584>
}

object
{
  BonsaiLeaf(0.004941347956653779)
  matrix <0.4196880103417985, -0.33747464581903075, 0.8425988591285072,
          -0.4854920100304163, 0.7008940716763328, 0.5225370881436062,
          -0.7669155639129837, -0.6283775646204212, 0.1303155942692181,
          0.8704767223517044, 2.2479846116529063, 0.36487271407395055>
}

object
{
  BonsaiLeaf(0.003043449273337757)
  matrix <-0.1672354869024027, -0.10305049109072811, 0.9805166435132435,
          0.9777975118258551, -0.1447088757210548, 0.15156307978764544,
          0.12627081130524362, 0.9840934597758023, 0.12496297307125664,
          0.8894404627351862, 2.240607197881141, 0.3615411367575004>
}

object
{
  BonsaiLeaf(0.0027315858967452986)
  matrix <0.9081344001199025, -0.06398385277585315, -0.41376077376042336,
          0.3991836588979833, -0.1657290831762786, 0.9017684167558592,
          -0.12627081130524362, -0.9840934597758023, -0.12496297307125664,
          0.8875549900612052, 2.2405949087775148, 0.3635431201017965>
}

object
{
  BonsaiLeaf(0.004514815803048992)
  matrix <-0.2954037512891411, -0.1661601040694417, 0.9408121191502248,
          -0.9509921846985434, 0.14533344875336227, -0.2729323236916915,
          -0.09138100659653516, -0.9753302048481254, -0.2009490063282671,
          0.8647354855255043, 2.23005033365104, 0.3101817602452468>
}

object
{
  BonsaiLeaf(0.004033416683970429)
  matrix <-0.5071219165362848, 0.21924545341828458, -0.8335219210818493,
          -0.8570162620405581, -0.025737573046515666, 0.5146461929633854,
          0.0913810065965351, 0.9753302048481254, 0.20094900632826723,
          0.865572336379809, 2.2292903695433663, 0.3134897819544533>
}

object
{
  BonsaiLeaf(0.0036523331599496453)
  matrix <-0.3846975421078855, 0.8719658734735272, -0.3027925306108132,
          0.4366293119935265, -0.11711080379488287, -0.8919864929148744,
          -0.8132420580640256, -0.4753531057351626, -0.3356736210424104,
          0.8810640519541304, 2.171593263105628, 0.11853488465254315>
}

object
{
  BonsaiLeaf(0.0033999639886801393)
  matrix <0.25618329945395496, 0.9528033031419489, -0.16289868815517417,
          0.5372315263458898, -0.28044280653327436, -0.7954458619942699,
          -0.8035872100655607, 0.1162656345853399, -0.5837207363401761,
          0.8880231427872128, 2.191133913096722, 0.09804706905145015>
}

object
{
  BonsaiLeaf(0.002903940411990065)
  matrix <0.4979574187674647, -0.40586857255462494, -0.7663609534070194,
          0.3260153445982151, 0.9065059316005271, -0.2682554585829856,
          0.8035872100655607, -0.1162656345853399, 0.5837207363401761,
          0.8871433040781608, 2.194719847748303, 0.09997255847025924>
}

object
{
  BonsaiLeaf(0.003977014962133115)
  matrix <0.809269994036528, 0.49199517998804554, 0.32097168040288043,
          -0.07969941286116006, 0.6332988103782253, -0.7697925826890719,
          -0.5820052236378167, 0.5973887843289787, 0.5517214514736949,
          0.8778869510402634, 2.2127334531413902, 0.10755709496643884>
}

object
{
  BonsaiLeaf(0.0041002972471566165)
  matrix <-0.36190105375614434, 0.4172955956464276, -0.833601831298544,
          0.7282153163374747, 0.6848291949180012, 0.026672585916515335,
          0.5820052236378165, -0.5973887843289788, -0.5517214514736951,
          0.8811898160546012, 2.2130228175597098, 0.1107279371161404>
}

object
{
  BonsaiLeaf(0.0035338488713463696)
  matrix <-0.2697507623672686, 0.05470408497941376, -0.9613750513139205,
          -0.7074331162193807, 0.6660736880418373, 0.2363984521406231,
          0.6532785870349759, 0.7438772110939481, -0.14097440383514753,
          0.866420575344102, 2.1970905865574326, 0.12618623708538868>
}

object
{
  BonsaiLeaf(0.004541440702987205)
  matrix <-0.18201258676112278, 0.3350412492587538, 0.9244559370546869,
          -0.7349139446099189, 0.5782681524260378, -0.35427028933805094,
          -0.6532785870349758, -0.743877211093948, 0.1409744038351476,
          0.8655829689621625, 2.1973629533313814, 0.12374194317024463>
}

object
{
  BonsaiLeaf(0.002722122626579597)
  matrix <0.5142018621588765, -0.7583026594745951, -0.4007162606958959,
          0.2420539848445772, 0.5765291052003457, -0.7803999354675464,
          0.8228039337370756, 0.3042881323526186, 0.4800025199268744,
          0.8965055918413548, 2.163565108850752, 0.17219465390587924>
}

object
{
  BonsaiLeaf(0.0026134721869927207)
  matrix <-0.23426646354707384, 0.9510918235825644, -0.20135433238830475,
          0.5177962057450235, -0.05322664392714743, -0.8538465984544953,
          -0.8228039337370756, -0.3042881323526186, -0.4800025199268744,
          0.8971999371946006, 2.1618566195750937, 0.17208749389097755>
}

object
{
  BonsaiLeaf(0.0025355961902493074)
  matrix <0.30230418728543634, -0.20379524809019356, 0.9311711309987809,
          -0.3162086743235705, 0.9001210895281553, 0.2996566342819357,
          -0.8992353710971467, -0.3850318441927932, 0.20766854919624744,
          0.8832255692534529, 2.168545179345423, 0.1938720931611531>
}

object
{
  BonsaiLeaf(0.0028820896163794523)
  matrix <-0.38795152516109493, 0.48250353855247435, -0.7852922700558832,
          -0.20216172113671438, 0.7867279162720984, 0.583257939736104,
          0.8992353710971465, 0.38503184419279335, -0.20766854919624775,
          0.8834446985660739, 2.168530256098456, 0.1947932865926692>
}

object
{
  BonsaiLeaf(0.003760543573996588)
  matrix <0.5876628098544958, 0.2708307276411, -0.7624323831523108,
          0.6712024947570123, 0.3630233398084717, 0.6462981245418138,
          0.4518181414528223, -0.8915518895272979, 0.03155305586504631,
          0.8958448025103307, 2.149922894177911, 0.19568772654962366>
}

object
{
  BonsaiLeaf(0.004226847441639641)
  matrix <0.14280143182048774, 0.10719092257573272, 0.9839298029775206,
          0.8806066761750885, 0.44005151334550374, -0.17574568978554084,
          -0.4518181414528223, 0.8915518895272979, -0.03155305586504642,
          0.8970429063581032, 2.150417759703558, 0.19251444407124269>
}

object
{
  BonsaiLeaf(0.003276591332850716)
  matrix <0.2372107727089527, 0.6644082541563234, 0.7087261256083113,
          0.3919099679791937, 0.602096897418718, -0.6956190790348561,
          -0.8888968592077316, 0.4427651724421195, -0.1175643473291593,
          0.939102229632261, 2.269354585896881, 0.26015233097653234>
}

object
{
  BonsaiLeaf(0.0032834630315203926)
  matrix <0.14530172606023084, 0.029116892030146724, -0.9889588540492587,
          0.4344534291435029, 0.896164721840134, 0.0902164576706837,
          0.8888968592077316, -0.44276517244211944, 0.11756434732915938,
          0.9392446126014324, 2.2703242841555777, 0.2627278128254599>
}

object
{
  BonsaiLeaf(0.0035398314108672176)
  matrix <0.7996717944981636, 0.5946513256399508, -0.08315540871606601,
          0.5490689836545132, -0.7802597377263304, -0.29952961935648165,
          -0.24299850261408507, 0.19386733246704352, -0.9504563036402177,
          0.9482299250522559, 2.2584353349451227, 0.25926094637310687>
}

object
{
  BonsaiLeaf(0.003016759629028129)
  matrix <0.025354799388998484, -0.9782207490671426, -0.20601286426449633,
          0.9696952417513744, 0.07415944644231764, -0.23279070992656242,
          0.24299850261408512, -0.19386733246704335, 0.9504563036402178,
          0.949211650874959, 2.2614210440974998, 0.2596189571124708>
}

object
{
  BonsaiLeaf(0.0029452320299570693)
  matrix <-0.03575153459119271, 0.3552370170693152, 0.9340923345569592,
          -0.5030824597074766, 0.8012222594372824, -0.3239613089813219,
          -0.8634986198651688, -0.4815075832070671, 0.15006858700287257,
          0.9239251182800826, 2.276284090320839, 0.28009621612023666>
}

object
{
  BonsaiLeaf(0.0032634729576187923)
  matrix <-0.4872680581045851, 0.7196791873017023, -0.4946025747160526,
          -0.1301536516657777, 0.5002122696204585, 0.8560652500126456,
          0.8634986198651688, 0.481507583207067, -0.1500685870028724,
          0.924982059931576, 2.275556734074205, 0.2838441031372887>
}

object
{
  BonsaiLeaf(0.0026710541806100312)
  matrix <0.9584453475366342, -0.2799183080104358, -0.05502959772664382,
          0.2026367259061309, 0.5322359737789819, 0.821987363363685,
          -0.20080058042601603, -0.7989809816610863, 0.5668408223165138,
          0.9323597162022053, 2.275245718282626, 0.2885982248776945>
}

object
{
  BonsaiLeaf(0.002130622143394167)
  matrix <-0.6411591311669209, 0.5446692203939739, 0.5406018949991768,
          0.7406713815329006, 0.25488199485116003, 0.6216438476160109,
          0.20080058042601534, 0.7989809816610866, -0.5668408223165138,
          0.9333965533748009, 2.274367144381975, 0.2877271402414087>
}

object
{
  BonsaiLeaf(0.0029320765801734844)
  matrix <0.0019184338981781332, 0.15452343146297598, 0.9879872614261206,
          0.16544184048055716, 0.9743250490011555, -0.15270787899549,
          -0.9862176823753388, 0.1637473908732669, -0.023695462696757763,
          0.9256769817874251, 2.284125723134064, 0.28865863178058837>
}

object
{
  BonsaiLeaf(0.003607704985282735)
  matrix <0.10447617730165956, 0.5052817000769178, -0.8566067545518258,
          0.12829423738675097, 0.8472763395431132, 0.5154254486380888,
          0.9862176823753388, -0.16374739087326695, 0.023695462696757874,
          0.9256547414013745, 2.2843256505504934, 0.29096588593679223>
}

object
{
  BonsaiLeaf(0.004052127047863376)
  matrix <-0.08833987780951183, -0.06558752663648676, 0.9939287410766978,
          0.5344785706973502, 0.8388993667611877, 0.1028616056310403,
          -0.8405526297941841, 0.5403203945784264, -0.03905314006191596,
          0.92819431545874, 2.267856120423576, 0.29253897099575626>
}

object
{
  BonsaiLeaf(0.0038110703525047838)
  matrix <0.5412694792313018, 0.8346815999099577, -0.10165617356771006,
          0.022329966385049804, 0.10658563681081312, 0.9940527524366483,
          0.840552629794184, -0.5403203945784265, 0.03905314006191607,
          0.9261136414587764, 2.2648629989695404, 0.29591056767502916>
}

object
{
  BonsaiLeaf(0.004988347916271727)
  matrix <0.21646387172377882, -0.2341931595868708, 0.9477852901586256,
          -0.6817038757188328, 0.6586866602868124, 0.3184520519483715,
          -0.6988728196662637, -0.7150422697735594, -0.01706851981872004,
          0.9081461983508293, 2.2538582299524923, 0.2859456307369023>
}

object
{
  BonsaiLeaf(0.0024931935705122346)
  matrix <-0.8133949248374113, 0.5224791037523727, 0.2557426096505239,
          0.373152139564338, 0.13137468663227664, 0.9184215657587905,
          0.44625797134314527, 0.8424703424182887, -0.3018236988016548,
          0.907109374102811, 2.2562981038473353, 0.2954553708242177>
}

object
{
  BonsaiLeaf(0.0025374568435359494)
  matrix <0.43993548856386444, 0.08717428821681922, 0.8937882351966628,
          -0.7793013466655726, 0.5316430810416914, 0.3317303806794359,
          -0.44625797134314527, -0.8424703424182887, 0.3018236988016547,
          0.904201590052353, 2.257319582697604, 0.2940073196061119>
}

object
{
  BonsaiLeaf(0.0040446348542715685)
  matrix <-0.3853662552918758, 0.9175109447824872, 0.09831843919969155,
          -0.010731835393658976, -0.11099692662012739, 0.9937628036860553,
          0.9227012934809402, 0.381907512999198, 0.05262104639179164,
          0.48312837025506417, 1.8774486654907558, 0.42558359743796875>
}

object
{
  BonsaiLeaf(0.0030086617491294544)
  matrix <0.06135197146118543, 0.9425379202776589, 0.3284177285660605,
          -0.20390763208445167, -0.31026230715528247, 0.9285251630065785,
          0.9770658182412983, -0.12393373066823155, 0.17315547125954855,
          0.4817161098651661, 1.8782202149311933, 0.4300089945868645>
}

object
{
  BonsaiLeaf(0.0028364669499060594)
  matrix <-0.21008566112902669, -0.42841390933831525, 0.8788205375805924,
          0.0347332954446023, 0.8950429892961091, 0.44462528661721673,
          -0.9770658182412982, 0.12393373066823171, -0.17315547125954858,
          0.4824281188027641, 1.8816924491248115, 0.4284765413764047>
}

object
{
  BonsaiLeaf(0.004796985005290954)
  matrix <-0.12961029342818264, 0.5730429795372007, 0.809211292210253,
          -0.8248058620162473, -0.5152739725694985, 0.2327832106834232,
          0.5503603018215389, -0.6372711171829262, 0.5394340194901779,
          0.4816542821489898, 1.908108881469822, 0.42274470306608636>
}

object
{
  BonsaiLeaf(0.0046846024401299355)
  matrix <-0.7786923038017357, -0.6248792649423931, 0.056251224386673904,
          -0.30123385297613947, 0.4510115602171175, 0.8401468552411958,
          -0.5503603018215385, 0.6372711171829268, -0.5394340194901777,
          0.4841997026586561, 1.9126934528453743, 0.42556379950308487>
}

object
{
  BonsaiLeaf(0.0021511160607046442)
  matrix <-0.6458479608075044, 0.6950242596511148, -0.31594570738848143,
          -0.22275770984627674, 0.22427696553666607, 0.9487248523327021,
          0.7302461326325734, 0.6831113534600967, 0.009973191519535324,
          0.4776282138685337, 1.9233548974891232, 0.4347050447375486>
}

object
{
  BonsaiLeaf(0.0020925588803229183)
  matrix <0.27355996173075514, -0.3057500273948665, 0.9119659358144397,
          -0.626023588304017, 0.6632313318307221, 0.4101446907677927,
          -0.7302461326325734, -0.6831113534600965, -0.009973191519535435,
          0.47679740033683266, 1.924260302319642, 0.4335224793853895>
}

object
{
  BonsaiLeaf(0.0030157772520432507)
  matrix <-0.636157087628458, 0.7406345785412782, 0.21625119867658793,
          0.003221414547732948, -0.2777259690209796, 0.9606549373316469,
          0.7715528383386259, 0.6118240819061808, 0.17429145260531062,
          0.4812742574755562, 1.9186926536774838, 0.4333177116256817>
}

object
{
  BonsaiLeaf(0.0038722489291908757)
  matrix <-0.18319951685058616, -0.2128237051318545, 0.9597624745527726,
          -0.4665811658796587, 0.8781441296853991, 0.10566410528391768,
          -0.8652976093068153, -0.4284494813079158, -0.26017511275079297,
          0.48460136943795384, 1.9187518081610717, 0.41993522397654365>
}

object
{
  BonsaiLeaf(0.0030406369914338996)
  matrix <0.32348439184609057, 0.07660529230975388, -0.9431274979673228,
          0.932602438773265, -0.19438252836773992, 0.3040857179472967,
          -0.16003293231745497, -0.9779299882177158, -0.1343219964055591,
          0.6239867695080935, 1.90932217409126, 0.5402487115941261>
}

object
{
  BonsaiLeaf(0.0023610229948425273)
  matrix <0.4159229400852031, -0.19020987623923055, 0.8892852809374151,
          0.8952081146218219, -0.08644733151205175, -0.43718336014730474,
          0.1600329323174549, 0.9779299882177158, 0.1343219964055589,
          0.6232646709782498, 1.9097091166599607, 0.5382918973452985>
}

object
{
  BonsaiLeaf(0.0030192179756451244)
  matrix <0.0819680760890926, -0.10849645448212901, -0.9907117410564286,
          0.9017142482158035, 0.4314663518755495, 0.027353277021466726,
          0.42449104709859453, -0.8955809882774486, 0.1331992656478514,
          0.6205260843149553, 1.9228038095844908, 0.5414442536187969>
}

object
{
  BonsaiLeaf(0.004201825331992717)
  matrix <0.47071787649683405, 0.34395223496862154, 0.8124786402154839,
          0.7734546086742584, 0.28219063325361876, -0.5675706254066286,
          -0.42449104709859453, 0.8955809882774486, -0.13319926564785153,
          0.6210535336157208, 1.922686834370278, 0.5389768354815924>
}

object
{
  BonsaiLeaf(0.004800072241000602)
  matrix <-0.3612403068724908, 0.7314674232932312, 0.5783259023694418,
          0.9289096337905911, 0.22812111975775862, 0.29169786932971664,
          0.08143913642530037, 0.6425855300123298, -0.7618736796064517,
          0.6044052891498625, 1.9083609070327134, 0.5836530264183958>
}

object
{
  BonsaiLeaf(0.003948192314119409)
  matrix <-0.7408262655639504, -0.32438157489157526, 0.5881777266451294,
          -0.10430247145290761, 0.9205927917466104, 0.3763374898053567,
          -0.6635491230492183, 0.21745230662157355, -0.7158331199697107,
          0.5966052767070196, 1.921008424870738, 0.5898508198958984>
}

object
{
  BonsaiLeaf(0.0031229312931213334)
  matrix <0.6658391304618715, 0.6079246293195593, -0.432534273107294,
          -0.3411170087321831, 0.7636374397655167, 0.5481761094228516,
          0.6635491230492183, -0.2174523066215736, 0.7158331199697108,
          0.595951797941968, 1.9197585347431732, 0.590076883437392>
}

object
{
  BonsaiLeaf(0.003869182575377895)
  matrix <-0.9847150615949, -0.13277431397387238, 0.11272634570906565,
          0.15989834188751456, -0.43253296316865664, 0.8873261835616963,
          -0.069056264956742, 0.8917882132666413, 0.44715211611812306,
          0.535805922063769, 1.8157932218607369, 0.5722434065313038>
}

object
{
  BonsaiLeaf(0.0033487454528666884)
  matrix <0.28323036082037434, -0.41225254288034097, 0.8659263268882944,
          -0.9565624888002795, -0.18644469305234618, 0.22411287658863255,
          0.06905626495674189, -0.8917882132666413, -0.44715211611812317,
          0.5319839619007531, 1.8168424150470355, 0.5695606764995954>
}

object
{
  BonsaiLeaf(0.0043584269335931285)
  matrix <0.6361638235256896, 0.6580890523116634, -0.4027584746032187,
          0.44973481878839705, 0.10787334345813474, 0.8866238968923245,
          0.626924383324291, -0.7451725578674376, -0.22734044205718681,
          0.5902418703279706, 1.8512483743151895, 0.59013734108965>
}

object
{
  BonsaiLeaf(0.0037285902907276147)
  matrix <-0.3537344485248777, -0.5322545464100387, 0.7691404538526394,
          0.6941453432244994, 0.4017747588228305, 0.5972765570927747,
          -0.6269243833242908, 0.7451725578674377, 0.22734044205718665,
          0.5908699175678893, 1.852276269694451, 0.5885000551891225>
}

object
{
  BonsaiLeaf(0.0049371677118397505)
  matrix <-0.049548768840881274, 0.9126993994185291, 0.4056164762523937,
          0.5951585102672226, -0.29915611617597127, 0.7458498279218204,
          0.8020793396933081, 0.2783620384599244, -0.5283779976319812,
          0.588016929699144, 1.848257543330593, 0.5845431317865416>
}

object
{
  BonsaiLeaf(0.0041409368418868844)
  matrix <-0.9679882654600891, 0.25085796439216146, -0.008306601747297526,
          0.13687735352674635, 0.5553320599137163, 0.8202870798223643,
          0.21038846932063898, 0.7928912819126015, -0.5718916917073624,
          0.64010816226907, 1.876977411029599, 0.48778214471517184>
}

object
{
  BonsaiLeaf(0.003460630086423109)
  matrix <0.9444049387141251, -0.013652443398311953, 0.32850102362340444,
          -0.2526578787793636, 0.6092101655884002, 0.7516827591706926,
          -0.21038846932063868, -0.7928912819126016, 0.5718916917073625,
          0.6386670063361554, 1.8767860670712113, 0.48698668369724324>
}

object
{
  BonsaiLeaf(0.004281923583514176)
  matrix <0.04374700788647634, -0.21868167336126879, -0.9748151235167085,
          0.9153259368865878, 0.39977007150110483, -0.04860369527815395,
          0.40033064904360044, -0.8901472999835004, 0.2176537520200666,
          0.6220884910344283, 1.7996550036743901, 0.3795338975231796>
}

object
{
  BonsaiLeaf(0.004098418701418917)
  matrix <0.7633252661429146, 0.4553438976075545, 0.4582537211844645,
          0.5070206203934686, 0.017312401440701175, -0.861760042733578,
          -0.40033064904360044, 0.8901472999835003, -0.2176537520200666,
          0.6202471181112971, 1.7980141722470775, 0.3762101613569622>
}

object
{
  BonsaiLeaf(0.004448290557976376)
  matrix <-0.47197686655152316, -0.8728532219522659, 0.1239560017415591,
          0.8667306453391936, -0.4851248663808536, -0.11589586898963561,
          0.1612942214405396, 0.052736296291133494, 0.9854963506697446,
          0.6197409667125994, 1.781128915156918, 0.3824331874588768>
}

object
{
  BonsaiLeaf(0.0037637205541974405)
  matrix <-0.3442426719615322, 0.13197866404068825, -0.9295582902856713,
          0.07780580321139557, -0.9826550238151439, -0.1683311057335739,
          -0.9356512383294395, -0.1302717790194532, 0.32800308505209613,
          0.6204975031486651, 1.752087088174484, 0.3806504981602715>
}

object
{
  BonsaiLeaf(0.0038753698961894196)
  matrix <0.34984588240825026, -0.46487114211675606, 0.8133281501270293,
          -0.04652546372233868, -0.875742019557226, -0.48053230526911717,
          0.9356512383294393, 0.1302717790194533, -0.32800308505209663,
          0.6200243604663668, 1.7523917028258822, 0.37942180897284533>
}

object
{
  BonsaiLeaf(0.0039815624725747685)
  matrix <0.80873084300109, -0.14086952575992848, -0.5710605924864006,
          0.5872427250932961, 0.1386266762665434, 0.7974513317139112,
          -0.033172359031969655, -0.9802746662744392, 0.19483627294934164,
          0.6786165752407259, 1.7647613216582145, 0.43053008461886066>
}

object
{
  BonsaiLeaf(0.002507013597267904)
  matrix <-0.08283866134509874, 0.5319066318712284, 0.8427414141704186,
          0.9964712300432206, 0.05568459911443445, 0.06280376674703594,
          -0.01352197776596905, 0.8449701535515141, -0.534642493377048,
          0.6892316518387674, 1.7651403444213245, 0.4290833936827701>
}

object
{
  BonsaiLeaf(0.003474900932872473)
  matrix <0.8578193049412423, -0.2649324212556416, -0.4404053272131788,
          0.5137734872367599, 0.46458180310334274, 0.7212492995059515,
          0.013521977765969015, -0.8449701535515141, 0.5346424933770481,
          0.6885187968858469, 1.7666151181151857, 0.4314322136492625>
}

object
{
  BonsaiLeaf(0.0032752281969832112)
  matrix <-0.8712959488169643, -0.05798278434055701, 0.48732059908776937,
          0.3649638512448049, -0.7404161414788838, 0.5644336318134145,
          0.3280926040917503, 0.6696431394090714, 0.6662832047880667,
          0.6672838697383812, 1.747457777211032, 0.4427058075259532>
}

object
{
  BonsaiLeaf(0.003703940221293995)
  matrix <0.8184565971191701, -0.5536952544194149, 0.1534612780655999,
          -0.47168214061208846, -0.49497437416070506, 0.7297371630606575,
          -0.3280926040917512, -0.6696431394090712, -0.6662832047880665,
          0.6643414473896254, 1.7480494535421414, 0.4435600614089456>
}

object
{
  BonsaiLeaf(0.003951598331963016)
  matrix <-0.5523566845080004, -0.043419488961510544, -0.8324763306290761,
          0.3799141252541323, 0.8757893023568276, -0.29775552943602607,
          0.7420022577537867, -0.4807367739789225, -0.4672523982095981,
          0.677829219769895, 1.8205492645863959, 0.38535774160391967>
}

object
{
  BonsaiLeaf(0.0033359344264713878)
  matrix <0.3303074703097457, 0.8686683200454396, -0.36920499022495595,
          -0.5833777717275999, -0.11961397867210793, -0.8033448024107515,
          -0.7420022577537868, 0.4807367739789225, 0.4672523982095981,
          0.6743818417539074, 1.8166894726507121, 0.38385444627468296>
}

object
{
  BonsaiLeaf(0.0034581556635855655)
  matrix <0.4512218535955133, -0.8525270831327075, -0.2638113177311883,
          -0.29619733746421517, -0.42192840056641107, 0.8568801328509027,
          -0.8418230075953842, -0.3085028319492498, -0.442899567128208,
          0.4567702454420525, 1.7673201267565983, 0.4593908000375467>
}

object
{
  BonsaiLeaf(0.003669797910268867)
  matrix <-0.3540149654639678, -0.3038287789854182, 0.8845119995159909,
          0.4074400914375101, -0.9013956266476569, -0.14655543712148805,
          0.8418230075953843, 0.3085028319492498, 0.4428995671282079,
          0.4592897647382605, 1.7654712810576476, 0.4558897463162274>
}

object
{
  BonsaiLeaf(0.002730421924999354)
  matrix <0.1558107660433001, 0.8653680591566781, -0.47629940938069976,
          -0.16505032774779166, 0.4982176059559438, 0.8511977481325207,
          0.9739000947198567, -0.05401239956649588, 0.2204569486265348,
          0.46429353938657436, 1.8044879589395388, 0.4385859027122616>
}

object
{
  BonsaiLeaf(0.004132143932478008)
  matrix <-0.2200219496738069, 0.01394601943382312, 0.9753952276916719,
          0.0557579336632027, 0.9984428722941636, -0.0016981161883844464,
          -0.9739000947198568, 0.05401239956649562, -0.22045694862653462,
          0.4649745962274592, 1.8072533243214923, 0.436254756857746>
}

object
{
  BonsaiLeaf(0.004765241427041605)
  matrix <-0.33202760949873833, -0.31805811089485503, 0.8880296755314823,
          -0.8806923985390658, -0.23265974159567948, -0.4126140373231853,
          0.33784399607816124, -0.9190802373757294, -0.2028619027301865,
          0.46091310128395335, 1.7980480228210542, 0.40128842402475173>
}

object
{
  BonsaiLeaf(0.004841146755446323)
  matrix <-0.30918702898273465, 0.09519939628103408, -0.9462243159296618,
          -0.8889683995636566, -0.3823984730789323, 0.2520051435271355,
          -0.33784399607816124, 0.9190802373757294, 0.2028619027301865,
          0.46080618670271045, 1.7973054555328771, 0.40447462341172524>
}

object
{
  BonsaiLeaf(0.0036477233673365512)
  matrix <0.21394104633851652, -0.18368714316557327, 0.9594207951296712,
          -0.9220774864904752, -0.3622225980363631, 0.13626407589381165,
          0.3224939342049517, -0.9138127942349333, -0.2468680609020832,
          0.49919820400393405, 1.7938192398844044, 0.39343465692534624>
}

object
{
  BonsaiLeaf(0.0025730569385479045)
  matrix <-0.8882494093389455, -0.20202018781023226, -0.41255403346244496,
          -0.32712482206342264, -0.3523265826043515, 0.8768439598812967,
          -0.3224939342049518, 0.9138127942349333, 0.24686806090208308,
          0.5017199768047188, 1.794233971361434, 0.39519377270657624>
}

object
{
  BonsaiLeaf(0.00333007310583771)
  matrix <0.27774497190352265, -0.8455217112164286, 0.45601619098882096,
          -0.7013689721400708, -0.5028568253125814, -0.5051896457328988,
          0.6564596678406766, -0.17952172319302462, -0.7326886483359188,
          0.49562952188650566, 1.781738504207777, 0.3858631100764945>
}

object
{
  BonsaiLeaf(0.003409295641529174)
  matrix <-0.7365851146099323, -0.36215053271838504, -0.5712174372223436,
          0.1627976456635079, -0.9146687611116909, 0.36997024746974216,
          -0.6564596678406764, 0.17952172319302456, 0.732688648335919,
          0.49852015714171016, 1.7802946779771363, 0.38880676648129137>
}

object
{
  BonsaiLeaf(0.0032044362189049365)
  matrix <0.6340944660129376, -0.770724263053648, 0.0625165459072834,
          -0.7318841466177739, -0.5721130291510103, 0.37017871063207797,
          -0.24953918349898369, -0.28048314069844843, -0.9268545752611866,
          0.4875189255722234, 1.7557097192940714, 0.43174354878023236>
}

object
{
  BonsaiLeaf(0.002417220317341695)
  matrix <-0.9571904961391785, -0.07353994209314033, 0.27996112411863655,
          0.14668520715973288, -0.9570376610671448, 0.2501246994993383,
          0.24953918349898296, 0.28048314069844854, 0.9268545752611868,
          0.4902187721026877, 1.7552296481271976, 0.4311619412179142>
}

object
{
  BonsaiLeaf(0.0036222271807153155)
  matrix <0.028730713626752363, -0.968332033721983, -0.2480072953812954,
          -0.38851978660112685, -0.2394194118102541, 0.8897925155157502,
          -0.9209923569248072, 0.07079136752655261, -0.383094845658106,
          0.49118877132259553, 1.7705667931476619, 0.4277396967785013>
}

object
{
  BonsaiLeaf(0.004571244865282311)
  matrix <0.44357546853765445, 0.2308300957071835, -0.8660013109848116,
          0.16100185143911436, 0.9300213747613677, 0.33036138745342547,
          0.8816570804710736, -0.28596802164365775, 0.3753705942830827,
          0.8549797238948549, 2.2526779446377323, 0.27279137622110755>
}

object
{
  BonsaiLeaf(0.003501018496275413)
  matrix <0.08677741212659248, 0.8801473057719053, 0.4667016186891437,
          0.46384315581868174, 0.3788970978242879, -0.8008036688605378,
          -0.8816570804710736, 0.2859680216436577, -0.37537059428308284,
          0.8558676684760549, 2.249753114951419, 0.2684775849684576>
}

object
{
  BonsaiLeaf(0.0038130081624498506)
  matrix <-0.37195686538873163, 0.41660398903351387, -0.8295114264502644,
          0.7896618669732988, -0.3277255371544444, -0.5186811237601332,
          -0.48793670300401965, -0.8479605466165242, -0.2070765202609227,
          0.8541919697085002, 2.21520600789567, 0.2782314198479817>
}

object
{
  BonsaiLeaf(0.0033285780506546554)
  matrix <0.7826822237190157, -0.3200024075067662, -0.5338604647884405,
          -0.38642762651733914, 0.4225652264108796, -0.8198245659240136,
          0.4879367030040188, 0.8479605466165246, 0.20707652026092252,
          0.8498947280483634, 2.2178621693814846, 0.27748030515106564>
}

object
{
  BonsaiLeaf(0.00499342871432279)
  matrix <0.8272483080866778, -0.34053168947316953, -0.4468762750832464,
          0.5617214079122643, 0.5173939201390049, 0.6455792680192385,
          0.011370868954993563, -0.7850743276071004, 0.6192971850989366,
          0.8990417994994814, 2.1912306040298306, 0.36024686547045404>
}

object
{
  BonsaiLeaf(0.003004447613091147)
  matrix <0.9624077676990271, 0.10272702225679109, -0.25143278937089264,
          -0.23216162621685504, 0.7915947129708566, -0.5652245480416892,
          0.14096903200675015, 0.6023495407940804, 0.7856861731761864,
          0.8936140601005121, 2.187231169045658, 0.3188398200727874>
}

object
{
  BonsaiLeaf(0.004008205349278371)
  matrix <-0.3538928933773106, 0.7718345316092483, -0.5282341108188369,
          0.9246012935488004, 0.20358410183678938, -0.3219719886064507,
          -0.14096903200675, -0.6023495407940805, -0.7856861731761864,
          0.8980175693950028, 2.1856688710857477, 0.31924747776996154>
}

object
{
  BonsaiLeaf(0.0036079207770300754)
  matrix <0.2780578561608328, 0.1772144178342322, 0.9440756742650006,
          0.9053137865555778, 0.28017328976565303, -0.31923326201117075,
          -0.3210775241271846, 0.9434500399139134, -0.08253027133598578,
          0.9390404603432616, 2.141215714811281, 0.3934860815800739>
}

object
{
  BonsaiLeaf(0.0025198745167198523)
  matrix <0.5921976557618537, 0.13200217266189745, -0.7949071410691335,
          0.739060998842803, 0.3041010499800568, 0.6010918327431382,
          0.3210775241271846, -0.9434500399139134, 0.0825302713359859,
          0.9376365009003015, 2.1409711682643193, 0.396152525890341>
}

object
{
  BonsaiLeaf(0.004879844758282671)
  matrix <0.8252817956191905, 0.07075036718655052, -0.5602716692485288,
          0.5299108323621564, 0.24591932078283396, 0.8116145620988796,
          0.19520365663790976, -0.9667047497600687, 0.16546135266735568,
          0.9198026674999044, 2.1375158990926355, 0.39818410536336135>
}

object
{
  BonsaiLeaf(0.004486799810265855)
  matrix <0.9614892381971281, 0.09927188254110647, -0.2562879984857866,
          0.2105392258156144, 0.33336974619195453, 0.9189874029152267,
          0.17666827452620743, -0.9375551747287493, 0.2996307980086091,
          0.9296835809261378, 2.1454483618931626, 0.4310838718496191>
}

object
{
  BonsaiLeaf(0.004879951185643414)
  matrix <-0.19884008060598132, 0.9142702686860616, -0.35294829386373616,
          0.650818412138823, 0.39244791734674256, 0.649938479081909,
          0.732733250757537, -0.1004714286099278, -0.6730583000508739,
          0.9423061250969097, 2.15721999548217, 0.4398702178299343>
}

object
{
  BonsaiLeaf(0.0044327260466973375)
  matrix <0.6748642319330449, -0.019920718798661974, 0.7376729854210234,
          0.08752286382262009, 0.9947404973135575, -0.053208000457284244,
          -0.7327332507575371, 0.10047142860992814, 0.6730583000508735,
          0.9395181278931024, 2.159714280914757, 0.4364626932888236>
}

object
{
  BonsaiLeaf(0.0037589641728307784)
  matrix <0.21754187110564185, -0.7874618843778677, 0.5766969004320321,
          -0.08226392802234833, -0.6035371537479972, -0.7930797880365502,
          0.9725781102113034, 0.1250867087176849, -0.1960743094849165,
          0.8668716951258503, 1.8913544857703124, 0.16517170455502625>
}

object
{
  BonsaiLeaf(0.003076531124187833)
  matrix <-0.2813289891567873, -0.9589116466009842, -0.03663951245593311,
          0.7668900944322181, -0.2476163010144256, 0.5920859317140347,
          -0.5768306362544936, 0.13847245749578288, 0.8050414868771137,
          0.8704423821476903, 1.8881348903684796, 0.17143379235480688>
}

object
{
  BonsaiLeaf(0.003231924924709063)
  matrix <0.6578482574123995, -0.505493675176512, 0.5583115748182297,
          -0.4842541556844975, -0.8516463602174439, -0.2004903734114764,
          0.5768306362544935, -0.1384724574957829, -0.8050414868771139,
          0.8665179478276875, 1.886144232526782, 0.16896425172270213>
}

object
{
  BonsaiLeaf(0.0024625548527423343)
  matrix <-0.7779267844200378, -0.3892110460319662, -0.4932997868726503,
          0.058550033119492556, 0.7367504787176815, -0.6736249889448672,
          0.6256211407102593, -0.5529136404140961, -0.5503496111931259,
          0.8404313353260082, 1.9039578210421233, 0.15246283343497385>
}

object
{
  BonsaiLeaf(0.0035309361964390613)
  matrix <0.456620469718089, 0.8315256732373664, -0.31632704813464096,
          -0.6325313707088562, 0.053400009280669125, -0.7726917264200515,
          -0.62562114071026, 0.5529136404140954, 0.5503496111931255,
          0.8380537247456025, 1.902332084601156, 0.15139334673492297>
}

object
{
  BonsaiLeaf(0.0037184911482044084)
  matrix <-0.30432589838643626, 0.39857142516081434, -0.8651742984026775,
          -0.3717848224213073, -0.8859185886449458, -0.2773523032363408,
          -0.8770186961453246, 0.23725318404317164, 0.41779077691223776,
          0.8508474431540937, 1.8935302924321555, 0.1730137080214206>
}

object
{
  BonsaiLeaf(0.002843120998558274)
  matrix <-0.1691246971283067, 0.26946270841550235, 0.9480436095426413,
          -0.6034392340154161, -0.7888434620819137, 0.11656364433865146,
          0.7792675584625258, -0.5523729185106754, 0.2960172819682187,
          0.8594420621549367, 1.9050694602537428, 0.19110929059473117>
}

object
{
  BonsaiLeaf(0.003967942512793382)
  matrix <0.005303768105414594, -0.466519524237598, -0.8844949991656305,
          -0.6266689256471375, -0.6908282654908693, 0.36061387276024076,
          -0.7792675584625259, 0.5523729185106755, -0.2960172819682186,
          0.858671126640998, 1.9045710708216828, 0.19220878116627188>
}

object
{
  BonsaiLeaf(0.003729868607430589)
  matrix <0.05665670153259357, -0.9983891808149892, -0.0030102828804244863,
          0.21689979444096041, 0.015251655606231984, -0.9760747236624547,
          0.9745483555693455, 0.05464824455407938, 0.21741451659041022,
          0.8681749968345309, 1.9021819078024553, 0.17022167127232762>
}

object
{
  BonsaiLeaf(0.004306893641921145)
  matrix <0.15440676151522253, 0.5394789065704718, -0.8277204004758542,
          0.16252401255034735, -0.8402238265680666, -0.517310222798515,
          -0.9745483555693455, -0.054648244554079475, -0.21741451659041017,
          0.8680659627366, 1.8985062664745618, 0.17163430163315097>
}

object
{
  BonsaiLeaf(0.0026344482694762215)
  matrix <-0.8605253151383501, 0.25118903098856094, -0.44317068124715786,
          0.5093173162042693, 0.44063545342051175, -0.7392132768040494,
          0.009594447379730697, -0.8618262399694769, -0.507112885538861,
          0.9211835573905152, 2.030110892885806, 0.21910914468988713>
}

object
{
  BonsaiLeaf(0.004548298697392941)
  matrix <0.8955958487136779, 0.23297303031908623, -0.37898765535406054,
          -0.44476513166648224, 0.4505320180009567, -0.7740832503094754,
          -0.00959444737973042, 0.861826239969477, 0.507112885538861,
          0.9178188625992221, 2.03099921576868, 0.2175358019886811>
}

object
{
  BonsaiLeaf(0.0021601191017250132)
  matrix <0.921866568717206, -0.1406009121763071, -0.3611002810532763,
          0.11846791283503888, -0.7849807487930383, 0.6080876397796867,
          -0.36895444584673875, -0.6033544625835715, -0.7069908127906719,
          0.9205520136881487, 2.0201575347709197, 0.23377359099779232>
}

object
{
  BonsaiLeaf(0.0037374991793008554)
  matrix <0.31397210625430105, -0.7968497823110448, 0.5161898303193098,
          0.874810912931568, 0.031524861797144255, -0.48343774129096234,
          0.36895444584673875, 0.6033544625835715, 0.7069908127906718,
          0.9235657139558174, 2.0219710108259683, 0.2306532011102633>
}

object
{
  BonsaiLeaf(0.004029390916827481)
  matrix <0.4119137513393784, -0.9106382799129582, 0.03263410202057254,
          -0.6597264629868183, -0.2733306287419961, 0.7000366857718294,
          -0.6285603037835134, -0.3098843180102429, -0.7133608161084426,
          1.0786443554905196, 2.0742136844942802, 0.28899925705575263>
}

object
{
  BonsaiLeaf(0.003927564230089098)
  matrix <-0.74704449788052, -0.6644392661819243, -0.021094542945198136,
          0.6607379779024466, -0.738643691459173, -0.1335320996051193,
          0.07314261920267218, -0.11369238595082487, 0.9908199627747623,
          1.0859285646877308, 2.0625607754601023, 0.2860367249731449>
}

object
{
  BonsaiLeaf(0.002163032773098568)
  matrix <0.9717810831403733, -0.2152699395688155, -0.09643847556116136,
          -0.22425807389410765, -0.9699138593168193, -0.09473870274844162,
          -0.07314261920267201, 0.11369238595082487, -0.9908199627747621,
          1.082848396276795, 2.0633638905366736, 0.286356257952197>
}

object
{
  BonsaiLeaf(0.004760063127396619)
  matrix <-0.8890738702806043, -0.38713792659620494, -0.24427828183254036,
          0.3731446848160379, -0.9220216480927798, 0.10314613246173313,
          -0.2651616438661644, 5.533887104221796E-4, 0.9642038147524247,
          1.0845362306585957, 2.0907946887568603, 0.2811997392007184>
}

object
{
  BonsaiLeaf(0.003453001181414611)
  matrix <0.25532691348546216, -0.6937450788565582, 0.6734433404617602,
          0.895813574534021, -0.09231754511682566, -0.4347361389902868,
          0.36376669299231645, 0.7142795226141581, 0.5978951050506462,
          1.0607125522027916, 2.123964501681214, 0.2837471381083038>
}

object
{
  BonsaiLeaf(0.0034769454036786933)
  matrix <0.9029876133746788, -0.11283878790815316, -0.414585067308652,
          0.22866386501004993, -0.6907041128569513, 0.6860325541263743,
          -0.3637666929923165, -0.7142795226141581, -0.5978951050506462,
          1.0584143586460326, 2.1218817337830678, 0.2876335802456846>
}

object
{
  BonsaiLeaf(0.004308555576539911)
  matrix <0.3933682533429337, 0.8275656121290333, 0.40049541181320275,
          0.4966605187345219, -0.5578623400198148, 0.6649194979228474,
          0.7736858189163637, -0.06264796252962973, -0.6304645005062548,
          1.0531562539821393, 2.1334123466075945, 0.28947876627932917>
}

object
{
  BonsaiLeaf(0.003229480165132716)
  matrix <0.45688285061988954, -0.6342415028332955, 0.6236952596366322,
          0.4389399895397532, 0.7705925959121642, 0.4620808768042586,
          -0.7736858189163637, 0.06264796252962945, 0.6304645005062548,
          1.0524339125244007, 2.138304541007525, 0.28810620469493003>
}

object
{
  BonsaiLeaf(0.0026274589563573545)
  matrix <-0.08288782011521847, -0.8139870985909733, -0.5749387903107562,
          0.2565199946312296, -0.574910714486341, 0.7769653549053516,
          -0.962978245668582, -0.08308233083064889, 0.2564570620451029,
          1.0646033440153977, 2.1227020889175527, 0.296697589531862>
}

object
{
  BonsaiLeaf(0.0032141560252441376)
  matrix <0.24812715455751105, 0.098726256899594, 0.9636835794853975,
          0.10538412375804992, -0.9916402838238981, 0.07445625532758238,
          0.962978245668582, 0.08308233083064887, -0.25645706204510305,
          1.0642680692743611, 2.1210253566303083, 0.2948954589730148>
}

object
{
  BonsaiLeaf(0.0026518357208820914)
  matrix <0.6050444877786163, 0.38508342489093034, -0.6968729609354796,
          0.4327584808459976, 0.5756223812446234, 0.6938147962288878,
          0.6683122511704958, -0.7213665019146234, 0.18162903085928786,
          1.1001964173246082, 2.1599570196335662, 0.3239026269609883>
}

object
{
  BonsaiLeaf(0.0027301864000929023)
  matrix <-0.1929133713997111, 0.06774045089732633, 0.978874691902607,
          0.7184310447569906, 0.6892326176463839, 0.09388947066466946,
          -0.6683122511704958, 0.7213665019146234, -0.1816290308592878,
          1.1010102635943861, 2.1603122971604414, 0.32231907985659264>
}

object
{
  BonsaiLeaf(0.0046164380822251916)
  matrix <0.34970329733983446, 0.6375246753133986, 0.6864909993555575,
          0.842718739268753, -0.5341932657328152, 0.06680330329402234,
          0.4093076230843134, 0.5551574940611491, -0.7240631370763289,
          1.0859542798926303, 2.1419943876118244, 0.29901332152904186>
}

object
{
  BonsaiLeaf(0.0030715781219155386)
  matrix <-0.2573568561299307, 0.9648203831951176, 0.05375013278257203,
          0.9653803578452654, 0.25915724181705424, -0.029635935961656538,
          -0.04252309125010301, 0.044262311112310104, -0.9981145397826505,
          1.159235144823355, 2.213373147087408, 0.296563829980902>
}

object
{
  BonsaiLeaf(0.004180169275312133)
  matrix <0.9793314370331887, 0.19957286145590503, -0.032872624002518364,
          -0.19774155645448976, 0.9788827921591526, 0.05183392774676227,
          0.04252309125010295, -0.044262311112310104, 0.9981145397826505,
          1.1554433104581272, 2.216669021145222, 0.2968715336656101>
}

object
{
  BonsaiLeaf(0.0030492785907587153)
  matrix <0.20812410426355948, 0.8321719424035086, -0.5139788084161266,
          0.9469566397123316, -0.039881732399796754, 0.3188770451530181,
          0.24486216475646055, -0.5530816446937656, -0.7963310960734974,
          1.1330029070296825, 2.2672520481252794, 0.2563633314697172>
}

object
{
  BonsaiLeaf(0.004346424082079654)
  matrix <0.7052853173068178, -0.46197676293117, 0.5377267816494344,
          0.6652932747760198, 0.6933095735776874, -0.27695973303591137,
          -0.2448621647564608, 0.553081644693766, 0.7963310960734971,
          1.133007019132963, 2.270387076064983, 0.2541872020694141>
}

object
{
  BonsaiLeaf(0.004361516140774563)
  matrix <0.16601757830446895, 0.27196519001120145, 0.9478782090100444,
          0.8954739396857865, 0.36098654232480976, -0.26041340135253,
          -0.4129946573958741, 0.8920334364151088, -0.18360762859945617,
          1.1177050728196682, 2.2561043625135615, 0.26211507184052085>
}

object
{
  BonsaiLeaf(0.004878713157959078)
  matrix <0.6180251781155055, 0.12642475001074713, -0.7759263249819641,
          0.6689396775328562, 0.4339275641189099, 0.6035118697424817,
          0.41299465739587393, -0.8920334364151088, 0.18360762859945626,
          1.1170630135847461, 2.2566469219992773, 0.26619523039369103>
}

object
{
  BonsaiLeaf(0.002722014594549397)
  matrix <-0.38253319702105587, -0.7210732357954576, 0.5776865428554809,
          0.9218957756286362, -0.2562936255845633, 0.2905542227584972,
          -0.06145349505866021, 0.6437134192357548, 0.7627951899696843,
          1.0723432565114173, 2.211354553660218, 0.25233202832717383>
}

object
{
  BonsaiLeaf(0.00313242047221595)
  matrix <0.9975414970678638, 0.06540009959769261, 0.025175158395062236,
          0.033681294106370996, -0.7624669572305566, 0.6461499126045718,
          0.06145349505865977, -0.6437134192357549, -0.7627951899696841,
          1.0699393467306924, 2.209663821543332, 0.2535651487066804>
}

object
{
  BonsaiLeaf(0.002201269866037064)
  matrix <0.5499991300004468, -0.6676578569844158, 0.5017309468288045,
          -0.8348477588164218, -0.42295690082510706, 0.3523303558361346,
          -0.023025564009352455, -0.6126503456714901, -0.790018593041109,
          1.0527148087909446, 2.214475401110695, 0.250540046465797>
}

object
{
  BonsaiLeaf(0.003158442162980308)
  matrix <-0.7811810763068555, 0.5041637269384699, -0.3682051907015632,
          -0.6238797555796418, -0.6086694426272063, 0.4901995105972376,
          0.02302556400935254, 0.6126503456714901, 0.790018593041109,
          1.0525820458805033, 2.2134839961602024, 0.2513127390731474>
}

object
{
  BonsaiLeaf(0.004459512761772238)
  matrix <0.9997445917983983, -0.021633347374915735, 0.006538306448153999,
          0.021407344454903443, 0.9992307734544172, 0.03285706902744738,
          -0.0072440853972630115, -0.03270870928425032, 0.9994386742385524,
          1.0498088336763307, 2.2824009090669244, 0.2247487065255157>
}

object
{
  BonsaiLeaf(0.002843834305435722)
  matrix <0.9469939490085766, -0.2228130330769827, -0.23142344918390645,
          0.31459452271660393, 0.49731325681993255, 0.8085232284034037,
          -0.06505956361560533, -0.8384711544723443, 0.5410484047661174,
          1.0743817131151003, 2.2868960516946406, 0.23069651363317503>
}

object
{
  BonsaiLeaf(0.002997731859385963)
  matrix <0.039984179325532554, 0.539571250126258, 0.840989971070315,
          0.9970799960814629, -0.07634781696289741, 0.0015786890730327685,
          0.06505956361560536, 0.8384711544723442, -0.5410484047661175,
          1.0764760368897066, 2.2852529049110437, 0.2284019400260301>
}

object
{
  BonsaiLeaf(0.003545950964123489)
  matrix <-0.16386281509230027, 0.7689197293352074, -0.6179898281275328,
          0.9132435794727335, -0.11863447901595375, -0.3897589318289465,
          -0.37300823366496194, -0.6282422384937862, -0.6827712262467276,
          1.060258964756871, 2.2440000872398853, 0.1939583325589936>
}

object
{
  BonsaiLeaf(0.004156776288946558)
  matrix <0.9272284771165309, -0.278855109319881, -0.24997435714559868,
          0.03334979523630399, 0.7263274177521544, -0.6865393458347333,
          0.37300823366496194, 0.6282422384937864, 0.6827712262467276,
          1.0571592754438395, 2.2474399398732543, 0.1924866081448935>
}

object
{
  BonsaiLeaf(0.004039579137947358)
  matrix <0.17510871663586636, -0.5344103391551484, -0.8268872515417192,
          0.3612630283207532, -0.7464049874545398, 0.5588994713465982,
          -0.9158744246492846, -0.39659196172775363, 0.062360678045335044,
          1.801705636725004, 3.597474801006963, 0.5067594502407885>
}

object
{
  BonsaiLeaf(0.0023566400204149476)
  matrix <0.2703668456501505, -0.29298511319220166, 0.9170940476423016,
          0.34402952422428307, -0.8602761174261816, -0.37625614712340266,
          0.8991915564745928, 0.4172346165335371, -0.13179461116036406,
          1.8030737335964577, 3.5934970040624306, 0.5016542125590459>
}

object
{
  BonsaiLeaf(0.0025591836685597406)
  matrix <-0.15999454917154748, 0.03317660441090317, -0.9865602146626202,
          0.4072545751740459, -0.9081930343742319, -0.09658738692982821,
          -0.8991915564745926, -0.41723461653353744, 0.131794611160365,
          1.803305219109198, 3.593200132407894, 0.5022937279900642>
}

object
{
  BonsaiLeaf(0.004700074272942812)
  matrix <0.9395836514337123, -0.03846647841680797, -0.34015127810534634,
          0.33186006082721986, -0.14139709647698684, 0.9326713039091699,
          -0.08397298366883088, -0.9892053331569168, -0.12008891234276103,
          1.801719739053131, 3.6260454331533998, 0.5216660450282662>
}

object
{
  BonsaiLeaf(0.004724722239971001)
  matrix <0.2036923634447932, -0.13501000970520904, 0.9696812457471129,
          0.9754270649761714, -0.0569658330344817, -0.2128307655830302,
          0.08397298366883085, 0.9892053331569167, 0.12008891234276112,
          1.8047685940663822, 3.6264408622705635, 0.5162768543761506>
}

object
{
  BonsaiLeaf(0.004006525836133203)
  matrix <-0.7829141960895588, -0.6021610140726674, -0.15635688245938079,
          0.29804536691681216, -0.5836410558576387, 0.7553357380508374,
          -0.5460900299592203, 0.5447616277312098, 0.636412168433932,
          1.6985664656300452, 3.5766867288878155, 0.6024572145457012>
}

object
{
  BonsaiLeaf(0.003337505466838557)
  matrix <0.552409486845035, -0.33695087387303446, 0.7624354841163961,
          -0.6297852316645274, -0.7679185357496204, 0.11692597841975294,
          0.5460900299592202, -0.5447616277312098, -0.6364121684339321,
          1.6952704275135386, 3.576462169545986, 0.5998211834884372>
}

object
{
  BonsaiLeaf(0.004198906722091062)
  matrix <0.11660947727906507, -0.46411354610893985, 0.8780665385532511,
          -0.4999324022852591, -0.7913545798661288, -0.35188850801097843,
          0.8581781999992731, -0.3979403790055584, -0.3243048439399557,
          1.6961460959865875, 3.5799088074425782, 0.5951016906835613>
}

object
{
  BonsaiLeaf(0.0029268502473966214)
  matrix <-0.665664172044311, -0.7285069021523308, -0.16176805485934564,
          -0.22098735930953597, -0.014615545330507532, 0.9751671512413085,
          -0.7127803287703438, 0.6848825295998622, -0.15126177166400617,
          1.6980745745104775, 3.5902227940525653, 0.6080863512251248>
}

object
{
  BonsaiLeaf(0.002358814569725524)
  matrix <-0.22108894956721992, -0.10266380320366264, 0.9698349446637928,
          -0.6916222343252393, -0.6846134496639646, -0.23013715372831445,
          0.6875888025311541, -0.7216401929292502, 0.0803558994897534,
          1.6937272830340113, 3.5857473160850493, 0.6073891434336632>
}

object
{
  BonsaiLeaf(0.0035038746403849397)
  matrix <-0.4717910283082947, -0.5281464258810411, -0.706027321310502,
          -0.551937373477802, -0.4475452879632586, 0.703610937223341,
          -0.6875888025311541, 0.7216401929292502, -0.08035589948975326,
          1.6934247722710742, 3.585794049679828, 0.610397358824547>
}

object
{
  BonsaiLeaf(0.004452504382867068)
  matrix <-0.3338373895463548, -0.36354506598337694, 0.8697054572325145,
          -0.04626627718479534, -0.9152050940124453, -0.40032370338156403,
          0.9414945719101808, -0.17388105386387903, 0.28870980269268964,
          1.700611322594403, 3.5869654485686966, 0.5970814114832764>
}

object
{
  BonsaiLeaf(0.0044226616223832695)
  matrix <-0.7834072880143154, -0.43186811540714, -0.4469484891805099,
          0.6196855570437354, -0.5978112554266515, -0.5085386054928424,
          -0.04756922826207703, -0.6753603732674105, 0.7359521280237284,
          1.8332441675438877, 3.5274032625836114, 0.6011134691519872>
}

object
{
  BonsaiLeaf(0.004833634554680181)
  matrix <0.8368861186072776, -0.4291764872952438, -0.33974868246302226,
          -0.5453061461280214, -0.599746537274722, -0.5856153157337889,
          0.047569228262076074, 0.6753603732674103, -0.7359521280237287,
          1.8278676973820012, 3.5271482238937946, 0.6005319129001199>
}

object
{
  BonsaiLeaf(0.0025664634712780046)
  matrix <-0.3909730193452281, -0.566667059571601, -0.7252782512529597,
          0.7551542178055113, -0.6479967976847932, 0.0992081524916083,
          -0.5261959763002951, -0.508909219592973, 0.6812702846438043,
          1.8423042497568127, 3.546955304491386, 0.622155640907154>
}

object
{
  BonsaiLeaf(0.0027901454196899923)
  matrix <0.8475944967294405, -0.24928388543442248, 0.46844542219631435,
          0.06856649064480391, -0.823935040325382, -0.5625208313339756,
          0.5261959763002954, 0.5089092195929731, -0.6812702846438041,
          1.84055748452145, 3.546319466023263, 0.6203315118867045>
}

object
{
  BonsaiLeaf(0.0049297996722208505)
  matrix <-0.004585780377608428, -0.9910250739339472, 0.13359743056115286,
          0.8553338551109718, 0.06532527624556483, 0.5139422191107119,
          -0.5180569147490749, 0.1166272314584133, 0.8473577296295907,
          1.8067699607477639, 3.5469524525764853, 0.6165057580154677>
}

object
{
  BonsaiLeaf(0.00424110162698813)
  matrix <0.8498769339685877, 0.18203588463294623, 0.4945423478470298,
          0.09657240904534425, -0.9763508721705765, 0.19342374265568418,
          0.5180569147490748, -0.11662723145841336, -0.8473577296295907,
          1.8029629095903228, 3.542489608778588, 0.6147924555818304>
}

object
{
  BonsaiLeaf(0.004265482679858862)
  matrix <-0.4831352477585541, -0.8744230076355795, -0.04432534366282864,
          -0.4927171428795001, 0.22968915844039722, 0.8393287244027833,
          -0.7237472967037193, 0.4273491479019106, -0.5418141344608576,
          1.7688883454879145, 3.5681620443649202, 0.6063415130752503>
}

object
{
  BonsaiLeaf(0.003694069645788116)
  matrix <-0.5049767964412726, 0.20712972695893933, 0.8379115175636529,
          -0.47030658678139586, -0.8800397616002504, -0.0658918237159028,
          0.7237472967037194, -0.4273491479019107, 0.5418141344608575,
          1.7692526766404932, 3.563931381067427, 0.6025179619527076>
}

object
{
  BonsaiLeaf(0.004529613149920115)
  matrix <0.7967980915020106, 0.45418942105722787, -0.3985282564366715,
          0.5662351815337913, -0.7914804269889462, 0.23007923175895034,
          -0.21092776150176828, -0.4089874123895449, -0.887828122969056,
          1.8022003581037238, 3.5882227523452768, 0.5931295200913577>
}

object
{
  BonsaiLeaf(0.003633277306563706)
  matrix <0.43277450890865166, -0.020656156619151045, -0.9012655255986437,
          0.9005759062097979, -0.03540268525980259, 0.43325475996322976,
          -0.04085659791607351, -0.9991596334270718, 0.0032810572387451664,
          1.8199664084740943, 3.5905741311925956, 0.5922563508080146>
}

object
{
  BonsaiLeaf(0.002933550271685912)
  matrix <0.44210265513013813, -0.015132954791001293, 0.8968367945207059,
          0.8960334707663579, -0.03809226442695487, -0.4423494078861417,
          0.040856597916073496, 0.9991596334270716, -0.003281057238745111,
          1.8193229257028305, 3.5905910133928827, 0.589384561894995>
}

object
{
  BonsaiLeaf(0.00496640864705868)
  matrix <-0.137518035991495, -0.5260045167979696, 0.8392901989688527,
          0.021407958812576282, 0.845564228221544, 0.5334443131682853,
          -0.9902678875317124, 0.09132570426905828, -0.10501964893885138,
          1.8148999445052936, 3.6184767041301464, 0.617738010091008>
}

object
{
  BonsaiLeaf(0.004337974521473568)
  matrix <-0.007353942507534503, 0.7192003583972082, 0.6947638188700695,
          -0.13897996421454023, -0.6887746077063874, 0.7115294156433992,
          0.9902678875317124, -0.09132570426905795, 0.10501964893885135,
          1.814190732289773, 3.611289399936195, 0.6181753041177048>
}

object
{
  BonsaiLeaf(0.004463831149012523)
  matrix <0.6315214753929171, -0.6273285343823416, 0.4556748139487804,
          0.7565823028603407, 0.6271298685644411, -0.18517922926961933,
          -0.16959907168406232, 0.46170016017329873, 0.8706716470517768,
          1.8366444308674363, 3.618967237850533, 0.5843273473659112>
}

object
{
  BonsaiLeaf(0.0046182145774401615)
  matrix <0.10829232928550704, 0.24197300597850077, -0.9642208438919211,
          0.722517042136872, -0.6853584510521049, -0.09084556892465244,
          -0.6828190794344458, -0.6868281138313918, -0.24904868361649385,
          1.8530325844862703, 3.5842773058797226, 0.5863840767803674>
}

object
{
  BonsaiLeaf(0.004009444736070688)
  matrix <0.15102134290609312, -0.46621851863101205, 0.8716839145426201,
          0.7148081272251564, -0.5575907414370477, -0.4220686038033945,
          0.6828190794344459, 0.6868281138313919, 0.24904868361649352,
          1.8525618294328283, 3.585206809006007, 0.5851113603692909>
}

object
{
  BonsaiLeaf(0.004929419378329806)
  matrix <-0.5839469788351315, -0.09798589531639512, -0.8058564948105629,
          0.7277280516193856, -0.5030970032784283, -0.46616015292870827,
          -0.35974686766610553, -0.8586571898093615, 0.3650890598102278,
          1.8214607718045754, 3.5685408330534734, 0.5396455012646632>
}

object
{
  BonsaiLeaf(0.004359660914039439)
  matrix <0.9851388844808384, 0.02331676156401216, 0.1701696415757381,
          0.16833550473362452, -0.32791005295361797, -0.9295903156864485,
          0.03412530043712303, 0.9444211591245311, -0.3269619826034119,
          1.8342556499689697, 3.5614570787852387, 0.5201206853872951>
}

object
{
  BonsaiLeaf(0.00448483268445231)
  matrix <-0.26692849221161946, -0.30665536005212807, -0.9136255634541597,
          0.9631119581417864, -0.11845321586675926, -0.24162820972542776,
          -0.03412530043712325, -0.9444211591245311, 0.3269619826034117,
          1.8378411602371987, 3.5623554125723236, 0.5230897218602006>
}

object
{
  BonsaiLeaf(0.004597621976185885)
  matrix <-0.06183443944751617, -0.8417854075984478, 0.5362591068247952,
          0.10064753663812236, -0.5398074290009571, -0.8357499703643751,
          0.9929987791870081, 0.002295027165916591, 0.11810231743458094,
          1.8077960392097163, 3.5694645333814425, 0.5460411994175426>
}

object
{
  BonsaiLeaf(0.0033035659557711806)
  matrix <-0.7273909764870696, -0.6589403719460479, 0.19157231935953437,
          0.6638984433147829, -0.6051191707505569, 0.439396911862573,
          -0.17361228150506577, 0.44679791339011726, 0.8776277116755385,
          1.8084771438286258, 3.552187927484905, 0.5587921252236968>
}

object
{
  BonsaiLeaf(0.0029810251011270026)
  matrix <0.49421065573472994, -0.7312961815981863, 0.47006565768854097,
          -0.8518301494246685, -0.5153421381666264, 0.09385029121423472,
          0.17361228150506586, -0.44679791339011726, -0.8776277116755385,
          1.80374458447587, 3.5526507307270374, 0.5576203186184543>
}

object
{
  BonsaiLeaf(0.002503014214929121)
  matrix <0.295312220995296, -0.2369725176209053, -0.9255456325990822,
          0.7025014262483549, 0.7104270318373594, 0.04225137339528423,
          0.6475202222709757, -0.6626744738762536, 0.37627131623733595,
          2.004950445811284, 4.225655042554264, 0.962121948975891>
}

object
{
  BonsaiLeaf(0.004251584423007844)
  matrix <0.4181085127745556, 0.7217496138055313, 0.5516001871981335,
          0.6371050410219626, 0.19985003538753066, -0.7444173090814095,
          -0.6475202222709757, 0.6626744738762536, -0.3762713162373361,
          2.0059007806236053, 4.224726512892296, 0.9588512401521744>
}

object
{
  BonsaiLeaf(0.004941890201389438)
  matrix <0.614965810628423, 0.5109315183990211, -0.6006380234921845,
          0.5600621240661239, -0.8192038432710911, -0.12343208803392822,
          -0.5551103214178866, -0.26048809315656746, -0.7899357469940114,
          1.998492751599653, 4.213145057533315, 0.9668171562208886>
}

object
{
  BonsaiLeaf(0.003958906522404819)
  matrix <0.852608401213192, 0.3717275773327615, 0.3672567527371025,
          0.24484220348126617, 0.3367056679780035, -0.9092203190348999,
          -0.461639696706342, 0.8651288351464205, 0.1960634821252391,
          1.9771156785175514, 4.224652141688562, 0.958943070318352>
}

object
{
  BonsaiLeaf(0.0031783824327238394)
  matrix <-0.021296355031780623, 0.2101518403056386, -0.9774367853106993,
          0.886811849090458, 0.4553990586445597, 0.07859034099946566,
          0.46163969670634203, -0.8651288351464205, -0.19606348212523902,
          1.97896499832351, 4.224766587791348, 0.9627923787288967>
}

object
{
  BonsaiLeaf(0.004776780291738615)
  matrix <0.6815630350179949, 0.3290554874744056, 0.6536010369178136,
          0.6213794112047657, -0.7319816738875142, -0.27944669692743135,
          0.38647051197714805, 0.5965947663664293, -0.7033599562928694,
          1.9716485893354643, 4.203647782624121, 0.97849362359498>
}

object
{
  BonsaiLeaf(0.004200241155783047)
  matrix <0.6192732761200924, -0.36961916725874233, -0.6927353612155523,
          0.7710464184633574, 0.11965531972836174, 0.6254358680436651,
          -0.14828361358665954, -0.9214468382145861, 0.3590928769636414,
          2.002241146557075, 4.195950677718256, 0.9826055138815418>
}

object
{
  BonsaiLeaf(0.002312523925470963)
  matrix <0.3936098106543125, 0.2781173912295521, 0.8761974855318545,
          0.9072393768451408, -0.271268208679179, -0.3214502637448454,
          0.14828361358665965, 0.9214468382145862, -0.359092876963641,
          2.0011005784223097, 4.194820782297033, 0.979235170982523>
}

object
{
  BonsaiLeaf(0.0038143632393492937)
  matrix <0.564195757329947, 0.5977022463015002, -0.5695921103535662,
          0.8030102968454349, -0.5576552705389579, 0.2102262172050112,
          -0.19198336014117176, -0.5759970694424259, -0.7945877959185141,
          1.991437639238578, 4.195507126842382, 0.9822909288540863>
}

object
{
  BonsaiLeaf(0.004505323848310714)
  matrix <0.6036211209852586, -0.778651452748314, -0.17129932117039973,
          0.796017488827339, 0.6006418001457877, 0.07473677407170612,
          0.044695634926883845, -0.181469950819875, 0.982380250803076,
          1.9875723282187658, 4.223501971394634, 0.9888872806946755>
}

object
{
  BonsaiLeaf(0.004058675734453364)
  matrix <0.4743279305398108, 0.8693052284203885, 0.1390015616847419,
          0.8792128948828626, -0.4597576283112752, -0.12493041535706127,
          -0.04469563492688382, 0.18146995081987488, -0.9823802508030761,
          1.9875544516845591, 4.218929878438388, 0.9880435152787995>
}

object
{
  BonsaiLeaf(0.003514538017682852)
  matrix <0.9920349178232793, 0.05763112752518207, -0.11200613804402125,
          0.06968911792393835, 0.48960637139802166, 0.8691542026185258,
          0.10492925551219501, -0.8700369269327821, 0.48169035397339816,
          1.9975473079789774, 4.260007798513451, 1.0218882386973787>
}

object
{
  BonsaiLeaf(0.0028470702353386684)
  matrix <0.5808874425909865, -0.7102128900645852, 0.3977026902426152,
          0.6322087872866378, 0.7014057315130888, 0.3291535342027315,
          -0.5127200291754394, 0.06022998079610725, 0.8564406115403668,
          2.0392677297494703, 4.264789453401937, 1.0440773685734595>
}

object
{
  BonsaiLeaf(0.004356988444964209)
  matrix <0.18661930543468128, 0.9815040483598688, 0.04269704781675859,
          0.838028285036618, -0.18171998367403036, 0.5144768614933968,
          0.5127200291754394, -0.060229980796107405, -0.8564406115403667,
          2.041119066483125, 4.262000750151763, 1.0453818150841023>
}

object
{
  BonsaiLeaf(0.0031569507535818644)
  matrix <-0.5559022422103576, -0.8234374303609626, -0.11368155253176193,
          -0.5031270686444252, 0.224443947691758, 0.8345586061756278,
          -0.6616916577249293, 0.521129266713235, -0.5390625543220019,
          1.8713960172977036, 4.334200574479043, 1.100079340725816>
}

object
{
  BonsaiLeaf(0.003051680259666065)
  matrix <0.05502559967416576, -0.9015222494139487, 0.4292200102419652,
          -0.9389946288457165, -0.19288538105799946, -0.28475308035736163,
          0.33950150276455926, -0.3873665752045788, -0.8571381837457019,
          1.8584535096367636, 4.323247763717635, 1.098114662042063>
}

object
{
  BonsaiLeaf(0.0028046208301667932)
  matrix <-0.604232750479865, 0.6085575864626214, -0.5143543984514243,
          -0.7208616461347793, -0.692535053533801, 0.027453356056994796,
          -0.3395015027645592, 0.3873665752045786, 0.857138183745702,
          1.8592972774211265, 4.321894089990627, 1.0990606336505242>
}

object
{
  BonsaiLeaf(0.004182036235423258)
  matrix <0.30711892267232743, 0.9516521403629454, 0.006014239703726942,
          -0.3977193299952684, 0.12260626495097654, 0.9092783063192947,
          0.8645792629277572, -0.2816485532314977, 0.41614515565833576,
          1.8447450449244014, 4.3562428711526495, 1.1068151732451776>
}

object
{
  BonsaiLeaf(0.0029670699563797004)
  matrix <-0.484383085523197, -0.2467785605704816, 0.8393291181067104,
          0.13370012929808106, 0.9272402248098198, 0.3497854212518165,
          -0.8645792629277572, 0.28164855323149773, -0.4161451556583358,
          1.8468050192107743, 4.358481313923314, 1.1040503762346419>
}

object
{
  BonsaiLeaf(0.0037440145629478233)
  matrix <-0.005631307964065635, -0.3362849441897664, 0.9417434495030478,
          0.41227552266596174, -0.8587756271958138, -0.3041928920026646,
          0.911041811214569, 0.3865447690057681, 0.14347808115930272,
          1.9071873739446072, 4.310365711457966, 1.1124445822236189>
}

object
{
  BonsaiLeaf(0.0022132895310419103)
  matrix <0.3203565843531105, -0.4445470662424583, -0.836510349461877,
          0.2595659397542102, -0.8080600518832132, 0.5288331262979021,
          -0.9110418112145691, -0.38654476900576795, -0.14347808115930222,
          1.9062183029608721, 4.311792509059206, 1.1147539456633253>
}

object
{
  BonsaiLeaf(0.004170071285099241)
  matrix <0.7069123088739593, -0.5940239029596597, -0.38394086820115997,
          0.4667197673111284, -0.016115506874054702, 0.8842584176807357,
          -0.5314580381963703, -0.804285952352001, 0.26585044759356863,
          1.8964357858652292, 4.322879314131474, 1.1048159920930867>
}

object
{
  BonsaiLeaf(0.002586913323211561)
  matrix <-0.10073193556779643, -0.7855038710098269, 0.6106035913629582,
          0.7576013108863636, 0.33725362406967385, 0.5588383011168209,
          -0.6448979228529338, 0.5188869449894147, 0.5611265520535657,
          2.055665610904283, 4.179725171656625, 0.9614260312932716>
}

object
{
  BonsaiLeaf(0.0030246422689543086)
  matrix <0.6544718876983214, 0.7540941552609106, 0.05485027998040687,
          0.39468115905445367, -0.4026143853874138, 0.8259106727525367,
          0.6448979228529338, -0.5188869449894149, -0.5611265520535657,
          2.054899531295905, 4.1776349612750865, 0.9624784493777795>
}

object
{
  BonsaiLeaf(0.0036379321593029666)
  matrix <0.6432935372593875, -0.7539989371941497, 0.13288727414766716,
          0.7654561314378641, 0.6369811259146063, -0.09127954903887331,
          -0.015822002543431996, 0.16043892276705418, 0.9869189512299692,
          2.017748516255888, 4.174355370340865, 0.9528155091557926>
}

object
{
  BonsaiLeaf(0.0026004169589840392)
  matrix <-0.14547353694946305, 0.9761704727031487, -0.1610237816905444,
          0.9892356212161636, 0.1461183092013394, -0.007894645857352674,
          0.015822002543431773, -0.16043892276705352, -0.9869189512299694,
          2.0175362638646357, 4.172418044747297, 0.9531270485917551>
}

object
{
  BonsaiLeaf(0.004416231590517408)
  matrix <0.1570562426695905, 0.8012688737972672, 0.5773227247581455,
          0.9568656969406447, 0.021216775392386006, -0.28975487305693975,
          -0.24442048739171812, 0.5979281230429021, -0.7633744723381751,
          2.0139210656117714, 4.170258976208505, 0.9520879423147056>
}

object
{
  BonsaiLeaf(0.004588256912079732)
  matrix <0.3540265453930118, 0.4872182486318485, 0.7983004342709601,
          0.49881890968910947, 0.6236648821730133, -0.6018486604460377,
          -0.7911035965622066, 0.6112777543345054, -0.022239751844524702,
          1.9973339039144344, 4.201246783227822, 0.968605247695824>
}

object
{
  BonsaiLeaf(0.004051841600286475)
  matrix <0.5760422026025674, 0.7322875479550641, -0.363222146806528,
          0.20574372487909587, 0.30015738232754463, 0.9314370969137694,
          0.7911035965622065, -0.6112777543345055, 0.022239751844525646,
          1.9958788355876405, 4.199601438689719, 0.9751407195494667>
}

object
{
  BonsaiLeaf(0.004162107744012037)
  matrix <-0.6058522740902473, 0.41963149423828755, 0.675908596648258,
          0.16964521361573925, 0.8981845442056172, -0.4055675357414819,
          -0.7772795658429128, -0.13104935556304614, -0.6153556231396312,
          1.965219752576109, 4.204008030549692, 0.9452936093920983>
}

object
{
  BonsaiLeaf(0.0030969316250338973)
  matrix <0.9344994729468561, 0.21672353619856366, 0.28238562980371157,
          -0.345582801060918, 0.7425540372751446, 0.5737473567148458,
          -0.08534203344741054, -0.6337542193815936, 0.7688122831635094,
          1.960554078651351, 4.211890508107652, 0.9545651853114727>
}

object
{
  BonsaiLeaf(0.0045579273292623585)
  matrix <-0.9957370259588492, 0.08135088168056541, -0.04347193559552634,
          0.034993034473850576, 0.7692448397394822, 0.6379951912612584,
          0.08534203344741026, 0.6337542193815936, -0.7688122831635094,
          1.9617838206651863, 4.213097031104261, 0.9556962646958707>
}

object
{
  BonsaiLeaf(0.0026320689909520344)
  matrix <0.5914634674078314, -0.8061030710261448, -0.019204312123142053,
          0.7469279365304358, 0.5387616802347498, 0.38965947895696607,
          -0.3037591551744411, -0.24481358375884157, 0.9207587549705203,
          1.9888310760216732, 4.011690098670489, 1.08205358738242>
}

object
{
  BonsaiLeaf(0.0020247429931310786)
  matrix <0.6916061142892157, 0.6080413814894732, 0.3898290151773534,
          0.6552948636495497, -0.755216517035695, 0.015383564963673713,
          0.303759155174441, 0.2448135837588406, -0.9207587549705206,
          1.9881919138450648, 4.008742921407265, 1.0810591245161965>
}

object
{
  BonsaiLeaf(0.004990509514432373)
  matrix <0.15408130112101098, 0.0973577366965895, 0.9832499294432591,
          0.9690423060954392, -0.20918596382008206, -0.13114206624076163,
          0.19291438941170128, 0.973017319293948, -0.12657541116634713,
          1.9869187560641721, 4.009997648191427, 1.079000413489937>
}

object
{
  BonsaiLeaf(0.003976367682858961)
  matrix <-0.0575463579172614, 0.6637992195014005, -0.7456936454602456,
          0.6981743223105135, 0.5606617808818097, 0.4452089207604589,
          0.7136112613718436, -0.495004003668424, -0.4957116137387916,
          1.9942148331695801, 4.025309771082317, 1.0884319479508948>
}

object
{
  BonsaiLeaf(0.003101332627408321)
  matrix <0.6453206633113358, 0.18912292709094924, 0.7401309073075986,
          0.27261733097274626, 0.8480586977331124, -0.45439656254478233,
          -0.7136112613718436, 0.495004003668424, 0.4957116137387916,
          1.9922841123806854, 4.025710485805042, 1.08525239870106>
}

object
{
  BonsaiLeaf(0.004386607026875746)
  matrix <-0.2997001164335664, 0.8566497637696082, 0.4199178758319071,
          0.11805007219520842, -0.403468619828553, 0.9073462697715517,
          0.946701653460272, 0.32150311825411176, 0.019792025880897186,
          1.9398534833250882, 3.9735359473354173, 1.0958277771578904>
}

object
{
  BonsaiLeaf(0.004828053927667496)
  matrix <0.2883731479742336, -0.8733173860388176, 0.39262917717581586,
          -0.14351622508628842, 0.36599520242102845, 0.9194838796530216,
          -0.9467016534602719, -0.3215031182541121, -0.019792025880897155,
          1.9386427399746617, 3.977072850192837, 1.0962869233916868>
}

object
{
  BonsaiLeaf(0.004981870950386511)
  matrix <-0.8206734209031493, -0.41318580206106054, 0.3946804140038892,
          0.5556608390343694, -0.4161070735393413, 0.7197888129959692,
          -0.13317720595786353, 0.8100199974850522, 0.5710791849538667,
          1.941422089780511, 3.9598126401250395, 1.1057514202801118>
}

object
{
  BonsaiLeaf(0.004236741941334013)
  matrix <-0.223238141757934, 0.9687178949340521, 0.10839913329452211,
          0.24956571569249375, -0.050698561927791985, 0.9670297872192706,
          0.9422747399858271, 0.24293064000449444, -0.23044092199878285,
          1.9390772971744656, 3.9718486746192982, 1.102967816697842>
}

object
{
  BonsaiLeaf(0.004266722788698984)
  matrix <0.3198442766008428, -0.4493587896953324, 0.8341320739842284,
          -0.09908558477561462, 0.8596867931232592, 0.501119411536932,
          -0.9422747399858273, -0.24293064000449438, 0.23044092199878277,
          1.9375971809170784, 3.9757315165743456, 1.101008898652875>
}

object
{
  BonsaiLeaf(0.0034581507870195143)
  matrix <-0.6090926353637622, -0.6551818702493178, -0.44692603240607204,
          0.7512692950375509, -0.2960428047458548, -0.5898754988063062,
          0.25416649637473415, -0.6950506274040866, 0.672535513906722,
          1.8350600647714765, 3.955209519116811, 0.998711145837534>
}

object
{
  BonsaiLeaf(0.004651496204417629)
  matrix <0.6729148867650034, -0.3723789345178208, -0.6391552896576971,
          -0.6946833431792029, -0.6150110197976608, -0.37306366512541433,
          -0.25416649637473426, 0.6950506274040866, -0.672535513906722,
          1.8292307453335086, 3.9533725583507704, 0.9990157200356374>
}

object
{
  BonsaiLeaf(0.00311763704541666)
  matrix <0.44758070079175005, -0.4353038955335149, -0.7811414947447819,
          -0.8786359135191096, -0.37656249816419995, -0.293597711930418,
          -0.1663443649577745, 0.8177476404794357, -0.551015742730742,
          1.8306343533692158, 3.966355986721836, 1.0138462762214226>
}

object
{
  BonsaiLeaf(0.0030274301323952066)
  matrix <-0.9045762516299741, -0.42625877524376976, -0.006727667853532224,
          -0.14534121593981952, 0.3231916907992521, -0.9351059094816245,
          0.40077142604756677, -0.8448967910496541, -0.354304496920088,
          1.8258219867971097, 3.9787976491335075, 0.9929516483939197>
}

object
{
  BonsaiLeaf(0.003257438621100514)
  matrix <0.8563503567302744, 0.48291181055057636, -0.18292143056158391,
          -0.32564755578958515, 0.23009909974783138, -0.9170649233852024,
          -0.40077142604756705, 0.844896791049654, 0.35430449692008803,
          1.825201220248629, 3.978568742564441, 0.9927953335017736>
}

object
{
  BonsaiLeaf(0.004592064334168216)
  matrix <-0.5467739873525133, 0.0646182476953367, 0.8347830190051886,
          -0.5436073832825286, -0.7857006160218282, -0.29523813240101926,
          0.6368117615083406, -0.6152227434415147, 0.46472761522954564,
          1.8103857517500253, 3.934295908089686, 1.088223848568914>
}

object
{
  BonsaiLeaf(0.0037448690413002927)
  matrix <-0.12254718738490472, -0.7702651808335949, -0.6258384280782362,
          -0.7679251669075329, -0.32587585967353866, 0.5514488753384754,
          -0.6287075034498047, 0.5481755879984272, -0.5515708475150698,
          1.777919128367631, 3.9251600740292107, 1.1111609228032573>
}

object
{
  BonsaiLeaf(0.003746735851585326)
  matrix <-0.6947540748796623, -0.07731032349524486, 0.7150803376678485,
          -0.34934746391525073, -0.8327824677571201, -0.4294528039870542,
          0.6287075034498049, -0.5481755879984275, 0.5515708475150695,
          1.7794859948835067, 3.923260220518892, 1.10748677276488>
}

object
{
  BonsaiLeaf(0.0032662265114541795)
  matrix <0.2858715678438159, -0.4630246869455245, 0.8389788948343799,
          -0.9573970199596403, -0.17532318557992999, 0.2294618198535545,
          0.040845965173049475, -0.868832503925299, -0.4934183693904969,
          1.841273147306697, 3.9373960916281674, 1.0903299574177778>
}

object
{
  BonsaiLeaf(0.0041111931432497775)
  matrix <-0.5409998725682766, 0.39594776336077747, -0.7419868641497005,
          -0.8400302048201542, -0.2972464445750255, 0.45386540535418224,
          -0.04084596517304925, 0.8688325039252988, 0.4934183693904973,
          1.840946696417097, 3.936746699320189, 1.0914464114808562>
}

object
{
  BonsaiLeaf(0.0046088481850779465)
  matrix <0.6729906029498655, 0.7346366103315106, 0.08598080658964095,
          0.008920656309591712, -0.12429830621385098, 0.9922047938623226,
          0.7395972351436843, -0.6669774972463437, -0.0902050327577168,
          1.911863431329766, 3.980705068122466, 1.0962917337859317>
}

object
{
  BonsaiLeaf(0.0026793340737234247)
  matrix <-0.2858083494188684, 0.08261465536606083, 0.954719019461333,
          0.9553585712046087, 0.10238920613853421, 0.2771397677927321,
          -0.07485711608357865, 0.9913078579256136, -0.10819030911584418,
          1.917724087986854, 3.9832255938906416, 1.103195301181811>
}

object
{
  BonsaiLeaf(0.0030651995927174908)
  matrix <0.8918506760562647, 0.1150888986615766, 0.43744361582134117,
          -0.446092797285086, 0.06374383279814294, 0.8927138063178867,
          0.07485711608357853, -0.9913078579256136, 0.10819030911584421,
          1.9137969997538493, 3.9831466465721843, 1.105189097154319>
}

object
{
  BonsaiLeaf(0.0028615629697367915)
  matrix <-0.798391457514439, 0.3709500851427711, 0.47430698382012004,
          0.5024775281706201, -0.023600558712534248, 0.8642680992099618,
          0.3317942348075281, 0.928352868235472, -0.16755159738856568,
          1.9272685834355072, 3.975985237320942, 1.1076231608965297>
}

object
{
  BonsaiLeaf(0.0030124150598143736)
  matrix <0.8345229852734248, -0.20603252724207843, 0.5110009635691244,
          -0.43986813114707246, 0.30937283293336304, 0.8430922117087586,
          -0.33179423480752746, -0.928352868235472, 0.16755159738856562,
          1.9245056469651696, 3.9769847311868447, 1.1076897469832692>
}

object
{
  BonsaiLeaf(0.004060165911941589)
  matrix <-0.6719598476948742, 0.03290198800238715, 0.7398563524572668,
          0.7373689600009896, -0.06331463797588263, 0.6725163741092425,
          0.06897086278234034, 0.9974511094802961, 0.018283989815844462,
          1.929284670621158, 3.9751156761571016, 1.0979849373283597>
}

object
{
  BonsaiLeaf(0.0025818730896380315)
  matrix <0.17024384969265127, -0.5011759290423894, 0.8484336861477889,
          0.629470078003699, -0.6071246525099712, -0.4849402821097286,
          0.758145403296652, 0.6166217190978153, 0.21211601306127842,
          1.9415102812954004, 3.9600305170165284, 1.0830793299218047>
}

object
{
  BonsaiLeaf(0.0041092654404521756)
  matrix <0.3540357232745893, -0.1160620890366791, -0.9280023158020028,
          0.5476077557025607, -0.7786573360762084, 0.3062980556077814,
          -0.758145403296652, -0.6166217190978152, -0.21211601306127872,
          1.9421353350657025, 3.9583983261378073, 1.0855900442006519>
}

object
{
  BonsaiLeaf(0.0036799090564250386)
  matrix <0.3903705302533418, 0.9191315207681844, -0.052991477051404945,
          -0.2942263531960724, 0.17908868280425597, 0.9388067409091061,
          0.8723770413041974, -0.350890996210791, 0.34034365953185286,
          1.0729200485206527, 4.6479593424849845, -0.4049999694945848>
}

object
{
  BonsaiLeaf(0.0032078502027328526)
  matrix <-0.4881547619589566, -0.5886539954410446, 0.6443534759959706,
          0.025753178097660534, 0.7282595570464514, 0.6848173416235726,
          -0.8723770413041972, 0.35089099621079123, -0.34034365953185297,
          1.0740853870799996, 4.649636459986943, -0.4062579014745269>
}

object
{
  BonsaiLeaf(0.003146464206673015)
  matrix <-0.692952380784569, 0.6135414010328176, -0.37866072833565007,
          -0.3462076332009497, 0.1775266760935379, 0.9212082033875821,
          0.6324217522179281, 0.7694486522789337, 0.08939518347057829,
          1.0665825403375622, 4.642242750021336, -0.41864676347680796>
}

object
{
  BonsaiLeaf(0.0024980189457790474)
  matrix <0.14665268852508861, -0.2322482999088976, 0.9615371631600054,
          -0.7606153536906608, 0.5949869735511523, 0.25972059031673145,
          -0.6324217522179282, -0.7694486522789337, -0.0893951834705784,
          1.0657718386995363, 4.643170457421701, -0.4208965251604404>
}

object
{
  BonsaiLeaf(0.003600700957871316)
  matrix <-0.2920888796303723, -0.8226319352542019, -0.4878122441023796,
          -0.7196323938416294, 0.5249928435196314, -0.45443561918817266,
          0.6299311899962087, 0.21830990209584525, -0.745337160295167,
          1.0444762899422362, 4.658496276981846, -0.4577361994080312>
}

object
{
  BonsaiLeaf(0.0042974330072023306)
  matrix <0.10920207967500004, 0.9252501995744525, 0.36330011558226866,
          -0.768935368977533, 0.31024644209778984, -0.5590040639396533,
          -0.6299311899962088, -0.21830990209584572, 0.7453371602951666,
          1.0437630227570076, 4.657939198047947, -0.45850219515426394>
}

object
{
  BonsaiLeaf(0.004665058783505055)
  matrix <0.34536723616611487, 0.19268147265932947, -0.9184744537965175,
          -0.8831625752505812, -0.2642795809231135, -0.38753086171796053,
          -0.31740406087468437, 0.9450027265574079, 0.07889555715833316,
          1.076174702412057, 4.6243577679226595, -0.4748908554952136>
}

object
{
  BonsaiLeaf(0.004219075094975949)
  matrix <-0.9244076473825474, -0.3268918709758046, 0.19649988842389127,
          -0.21148324661996978, 0.010561793834504493, -0.9773245545416702,
          0.31740406087468476, -0.9450027265574079, -0.07889555715833327,
          1.0794024440421737, 4.625635208704272, -0.4772064069326522>
}

object
{
  BonsaiLeaf(0.003582769715554285)
  matrix <0.6708982309553713, 0.32218738624663357, -0.6679003307713778,
          -0.7003266618061981, 0.5714044087347481, -0.42783123827261527,
          0.2437993651844478, 0.7547796299729185, 0.6089906236664113,
          1.0919159828752043, 4.680260429201928, -0.5049105739460824>
}

object
{
  BonsaiLeaf(0.0033168775462134926)
  matrix <0.9914428769536263, -0.0972242285487036, -0.08711183111968773,
          -0.014611274594214074, 0.5804709517032731, -0.8141498540707535,
          0.12972097899972918, 0.8084558884761779, 0.5740832204441667,
          1.0967055300291277, 4.682543471373391, -0.509991147704927>
}

object
{
  BonsaiLeaf(0.0028922853829995983)
  matrix <-0.4456543303723836, 0.5647385491133046, -0.6945952698987676,
          0.8857565610412904, 0.16573909476521817, -0.4335503050843261,
          -0.1297209789997294, -0.8084558884761778, -0.5740832204441668,
          1.0993158545921466, 4.681097485068638, -0.5085446635448972>
}

object
{
  BonsaiLeaf(0.004805834062706098)
  matrix <-0.5211284949063326, -0.8273438812673207, -0.20958815311506884,
          0.1163801921579099, 0.17439058303325636, -0.977774808134577,
          0.8455062049860711, -0.5339382236540531, 0.005406537820603408,
          1.0175256389026268, 4.56282260534811, -0.5362409155275802>
}

object
{
  BonsaiLeaf(0.004393396466615116)
  matrix <0.4109553235659196, 0.644227715310423, -0.6450475741049976,
          -0.3409325143820723, -0.5476135719164251, -0.7641232861849271,
          -0.8455062049860711, 0.5339382236540531, -0.005406537820603435,
          1.0154684833068897, 4.559578629612026, -0.5348989885945743>
}

object
{
  BonsaiLeaf(0.00480735028941419)
  matrix <-0.09659365192557079, -0.5682551978244155, -0.8171632006846712,
          -0.9734855103826701, 0.22497551743028826, -0.04137605143033829,
          0.20735387018976445, 0.7914998715745365, -0.5749194081041429,
          1.013612999124194, 4.569009334674122, -0.519424462176302>
}

object
{
  BonsaiLeaf(0.0047976853371969)
  matrix <0.7641404934308038, 0.1641096400816123, -0.6238247609157644,
          -0.523276236276719, -0.40779541323775564, -0.7482545566117985,
          -0.37718866214057695, 0.8982042790894126, -0.22573831349168433,
          1.0742744216491966, 4.591622440759244, -0.48308692741445847>
}

object
{
  BonsaiLeaf(0.0047532150105101265)
  matrix <-0.43105746859452604, -0.3859939668288222, -0.8155967853913043,
          0.8197061497399424, 0.21032767434937813, -0.532770210767551,
          0.3771886621405766, -0.8982042790894127, 0.22573831349168433,
          1.0806811759504364, 4.594578647492755, -0.48202940886268425>
}

object
{
  BonsaiLeaf(0.003972336526401111)
  matrix <-0.9440136890195581, 0.325796788403727, -0.0519096099918116,
          0.04784449862154483, -0.02048331388157623, -0.998644750551507,
          -0.32641853332085474, -0.9452179042518427, 0.0037489447070066517,
          1.0881839933408433, 4.596802958007972, -0.4552648443574549>
}

object
{
  BonsaiLeaf(0.003768275975854373)
  matrix <0.5929151262209481, -0.2078410608718515, -0.7779805566426838,
          -0.7361403359435337, 0.25172446622729694, -0.6282771672594218,
          0.326418533320855, 0.9452179042518427, -0.0037489447070067905,
          1.085219958948588, 4.597832891882504, -0.45366541309350195>
}

object
{
  BonsaiLeaf(0.004515862021361457)
  matrix <-0.009581266541724698, -0.9500439444748241, -0.3119690736245725,
          -0.8442756424527071, 0.17486154185363628, -0.5065788001304798,
          0.535823514687928, 0.25853422355132505, -0.8037743566201828,
          1.0309297427478907, 4.493235735467337, -0.4708512330974666>
}

object
{
  BonsaiLeaf(0.00394376116459274)
  matrix <-0.8426256374124775, 0.10328164477991364, -0.5285025421194973,
          0.0536208567881164, -0.9604649692228597, -0.2731882988215994,
          -0.5358235146879273, -0.25853422355132594, 0.8037743566201827,
          1.0349538429098166, 4.48865824042591, -0.4696409825366443>
}

object
{
  BonsaiLeaf(0.0038478243516200617)
  matrix <-0.3511442647391576, -0.9256150139097631, 0.1411897707542097,
          -0.8328199530444022, 0.3776713405350194, 0.40469159164677604,
          -0.42791194322186904, 0.024519473145055537, -0.9034877776067436,
          1.0359105539004727, 4.51065798913963, -0.45044094449182714>
}

object
{
  BonsaiLeaf(0.0023888912049046533)
  matrix <-0.8193664283902762, 0.4114000799892949, 0.3992350563412034,
          -0.38148397721928784, -0.9111250021931632, 0.15595257453297595,
          0.4279119432218691, -0.024519473145055648, 0.9034877776067437,
          1.0382037750783208, 4.507028197654302, -0.45162557291937744>
}

object
{
  BonsaiLeaf(0.002885269473893085)
  matrix <0.3104933889800935, 0.13366577727496984, 0.9411308704878052,
          0.9280273156651722, 0.17173870835382285, -0.33056182089324204,
          -0.20581340281660868, 0.9760324154649983, -0.07072175890494684,
          1.099557765112812, 4.516609307547315, -0.47793401604993435>
}

object
{
  BonsaiLeaf(0.004429577777742076)
  matrix <0.5263420030518376, 0.04948335439773259, -0.8488318405084291,
          0.8249878417555181, 0.21192480175550404, 0.523911194150748,
          0.20581340281660868, -0.9760324154649983, 0.07072175890494696,
          1.1005345040387318, 4.517052532487025, -0.4746595507357561>
}

object
{
  BonsaiLeaf(0.0032726273536732727)
  matrix <-0.9745242370310823, 0.03137940945277298, -0.22207621237174982,
          -0.013307166066000867, -0.9965095067540927, -0.08241190617870364,
          -0.22388709380015426, -0.07735719495373916, 0.9715402377763926,
          1.0803927379448606, 4.497094512411497, -0.47476167774904765>
}

object
{
  BonsaiLeaf(0.0033901427566962175)
  matrix <0.5351482729555966, -0.8428860258354123, 0.05620919323409075,
          -0.8145495044393335, -0.5325025932709386, -0.23010887200923474,
          0.2238870938001538, 0.07735719495373924, -0.9715402377763928,
          1.0776748482380825, 4.498550456871997, -0.4752720762163125>
}

object
{
  BonsaiLeaf(0.0035084262145546005)
  matrix <-0.2152744731693488, 0.8354513370086218, -0.5056460864005243,
          -0.5234596531036255, -0.5358353651085598, -0.6624729828993854,
          -0.8244069946175195, 0.12207180259783192, 0.5526767429847441,
          0.9986143614213542, 4.556438415471, -0.4710505796538561>
}

object
{
  BonsaiLeaf(0.0033586647519326216)
  matrix <-0.5617263376660385, 0.8087475327904164, -0.1743300025173939,
          -0.03749196832329177, -0.23538357817771072, -0.9711791407539104,
          -0.8264731537585142, -0.5390009270211633, 0.16254269219741177,
          0.9974333077080242, 4.560465261862562, -0.476950385430498>
}

object
{
  BonsaiLeaf(0.0046471319961576005)
  matrix <0.11520953057351138, -0.44453984174576133, -0.8883192518265524,
          -0.5510616028916243, 0.715445546335276, -0.42949828875972573,
          0.826473153758514, 0.5390009270211633, -0.16254269219741171,
          0.9949983746538607, 4.564580606279654, -0.4756844555226259>
}

object
{
  BonsaiLeaf(0.00392006643104149)
  matrix <0.023838915240317338, -0.6555219979388813, -0.7547997193549968,
          -0.7528873035714729, -0.508499341113988, 0.4178386389594871,
          -0.6577175793918246, 0.5583183055434032, -0.5056562621525631,
          1.0564735215588044, 4.539933701801825, -0.42491624669227573>
}

object
{
  BonsaiLeaf(0.004159636839213647)
  matrix <-0.6817139599373601, -0.1556377426570987, 0.7148726948814916,
          -0.32042731248362993, -0.8148972712899126, -0.48297906233994514,
          0.6577175793918246, -0.5583183055434032, 0.5056562621525629,
          1.058092028550595, 4.5385373762893, -0.42856321941473097>
}

object
{
  BonsaiLeaf(0.003404458781761002)
  matrix <-0.3554699882304701, -0.860123804752996, -0.3658252697185624,
          -0.9343002832331144, 0.3157095260628166, 0.16556109417285375,
          -0.02690851571437461, 0.40064265330893173, -0.9158391759100659,
          1.0400740754699347, 4.53844445036786, -0.43398253602011827>
}

object
{
  BonsaiLeaf(0.003942796006849874)
  matrix <-0.5726277709430299, 0.7447805384383634, 0.3426359372691034,
          -0.8193737655837325, -0.533654770345998, -0.20937817068666575,
          0.026908515714374637, -0.4006426533089318, 0.9158391759100657,
          1.0400242386629284, 4.535265538401813, -0.4353717173563979>
}

object
{
  BonsaiLeaf(0.004695560039579364)
  matrix <-0.5976652472601557, 0.24190742750454597, 0.7643801729084745,
          -0.638258923425687, 0.4334191003302587, -0.6362180680681677,
          -0.4852028430305614, -0.8681178952118439, -0.1046399595184292,
          1.0659531872280739, 4.578069318371439, -0.4282805129695203>
}

object
{
  BonsaiLeaf(0.004765672424290918)
  matrix <0.22341838163853164, -0.007385199567646938, -0.9746946627397552,
          -0.84537709210806, 0.4963031118583723, -0.1975368150462491,
          0.4852028430305612, 0.868117895211844, 0.1046399595184295,
          1.0649213800278299, 4.578399391017811, -0.4262345085848892>
}

object
{
  BonsaiLeaf(0.004525665118894709)
  matrix <-0.7669036615736518, 0.5936302838033177, 0.24384802647656684,
          -0.44533757596726015, -0.21867161756247896, -0.8682494843673756,
          -0.46209654542804063, -0.7744583977362509, 0.4320659358006248,
          1.0063876680398578, 4.6168234090440805, -0.3776908975434483>
}

object
{
  BonsaiLeaf(0.0035279060720326124)
  matrix <-0.551473739063941, -0.13060373209445825, -0.823904958284531,
          -0.6945095376064361, 0.6189966521224468, 0.36674193492822066,
          0.4620965454280407, 0.774458397736251, -0.4320659358006245,
          1.0059529523587396, 4.619996805603766, -0.37246766003844634>
}

object
{
  BonsaiLeaf(0.004265268460220371)
  matrix <-0.49835081444186224, 0.8613889481788022, -0.09826263634031346,
          -0.02640536166978466, 0.09820659678395563, 0.9948156719831072,
          0.8665732644273185, 0.4983618608035033, -0.026196050775830843,
          1.013232234122098, 4.61848102620792, -0.35933285653311253>
}

object
{
  BonsaiLeaf(0.003274265371048086)
  matrix <0.13234361978052459, -0.10822333713126575, 0.9852780701931614,
          -0.5115030521407573, 0.8439855726548335, 0.1614093578488604,
          -0.8490287356468428, -0.5253342387953265, 0.05633953847217872,
          1.0098892842957436, 4.624132078503096, -0.35905238982097915>
}

object
{
  BonsaiLeaf(0.0028601603267514966)
  matrix <-0.5018704743123835, 0.7685519740532084, -0.39680459951011005,
          -0.16515517872408775, 0.36517365831649373, 0.9161724544060266,
          0.8490287356468429, 0.5253342387953264, -0.05633953847217858,
          1.0110917107366093, 4.622413100978779, -0.3569604867853921>
}

object
{
  BonsaiLeaf(0.0033692186390189382)
  matrix <0.17190590972536848, 0.8167221122569139, 0.5508296919666712,
          -0.6613001871309838, 0.510113409271373, -0.5499694284067632,
          -0.7301578053421185, -0.2697207834634569, 0.6277899953534143,
          1.0657558831471408, 4.68511146671085, -0.5113054860461499>
}

object
{
  BonsaiLeaf(0.0041794609685172285)
  matrix <-0.9834443492765945, -0.03354728646663671, 0.1780780487501497,
          -0.01859736854137528, 0.9962102325552851, 0.0849665253819423,
          -0.18025357072544085, 0.08024806616280208, -0.9803412151480007,
          1.066564416498911, 4.692753153381067, -0.508425297630593>
}

object
{
  BonsaiLeaf(0.0027541891302753385)
  matrix <0.8487769288306636, 0.5163607049884095, -0.11379519949742985,
          -0.4970778362847363, 0.8526029968402661, 0.16118856799872963,
          0.18025357072544085, -0.08024806616280208, 0.9803412151480007,
          1.0652730971012505, 4.690937761504002, -0.5083364681051507>
}

object
{
  BonsaiLeaf(0.0032336122825907037)
  matrix <-0.09351736874659405, 0.1688002415127528, -0.9812038423324428,
          0.9629445914168443, 0.26573683055353226, -0.046061380226928406,
          0.2529668270816546, -0.9491524721311106, -0.18739628876698824,
          1.0918471232686628, 4.6535870941269755, -0.5194577999950384>
}

object
{
  BonsaiLeaf(0.003001690538905586)
  matrix <0.9280194746282081, 0.2928064857672601, -0.23031330096937802,
          -0.27347328773945023, 0.11564578046789094, -0.9549023061826523,
          -0.2529668270816542, 0.9491524721311108, 0.18739628876698844,
          1.087912451629952, 4.653074937092855, -0.5221751765682311>
}

object
{
  BonsaiLeaf(0.004240101879347242)
  matrix <-0.9492389105780752, 0.1748108185791067, -0.26150844795579903,
          0.24432854591217512, -0.11385271956050387, -0.9629855242427681,
          -0.19811373576052282, -0.9779973087674525, 0.06536215836881368,
          0.9998906174086738, 4.662334559369424, -0.6099872423748947>
}

object
{
  BonsaiLeaf(0.0037176681740392205)
  matrix <0.2691405892953263, -0.11839839200417877, -0.9557955659891861,
          -0.942504265718078, 0.17176462038046397, -0.28667511975890225,
          0.19811373576052277, 0.9779973087674525, -0.06536215836881365,
          0.995350721369417, 4.663455870362216, -0.6069698486127852>
}

object
{
  BonsaiLeaf(0.003502530749455036)
  matrix <0.15920362356167317, 0.7168641527924408, -0.6787930411296281,
          -0.9856420066103369, 0.15458888790114328, -0.06791252125076266,
          0.056249809332837936, 0.6798588546004705, 0.731182533141592,
          0.9892883849567761, 4.6684440674283145, -0.5994216062410994>
}

object
{
  BonsaiLeaf(0.004597639076378014)
  matrix <-0.9814955729295676, -0.0966045443212506, 0.16532998014922357,
          -0.18303660636517077, 0.7269521991422954, -0.6618444688085728,
          -0.056249809332838074, -0.6798588546004708, -0.7311825331415918,
          0.9918990901390512, 4.671244878932352, -0.6022266625394246>
}

object
{
  BonsaiLeaf(0.0031396987153181166)
  matrix <-0.11222286765480849, 0.27227256725935833, -0.9556535340244022,
          -0.9329780262174758, 0.30212275593923993, 0.19563701832480584,
          0.34199127265278784, 0.9135586951376888, 0.22011924033952573,
          0.9948357318509008, 4.666547291198483, -0.5968138425428576>
}

object
{
  BonsaiLeaf(0.004720088571914158)
  matrix <0.16286925495493593, -0.05799827633388466, -0.9849415240168939,
          -0.6518674547128616, 0.7430360838842771, -0.15154603106677622,
          0.7406365014476389, 0.6667335134731235, 0.08321054461536301,
          1.0060394023887964, 4.668358611863571, -0.5916098559077633>
}

object
{
  BonsaiLeaf(0.003963654067180749)
  matrix <-0.6718234316676042, 0.7367853253938386, 0.07616207026242378,
          0.010528503491175567, 0.11231120289659419, -0.9936173027469659,
          -0.7406365014476395, -0.6667335134731232, -0.08321054461536258,
          1.0091580058578735, 4.66529657849166, -0.5948329004816602>
}

object
{
  BonsaiLeaf(0.0033722886779996627)
  matrix <0.20003139358974908, 0.6920626660432017, 0.6935680989259221,
          -0.7363546437338788, -0.3607875787984955, 0.5723758919069452,
          0.6463507408753353, -0.6252052377051028, 0.43743471571882686,
          0.9416944845677581, 4.903820603039608, -0.2840143558408973>
}

object
{
  BonsaiLeaf(0.003733373420685123)
  matrix <0.7838740141939948, 0.534218852794293, 0.3164676084381178,
          -0.5847657340305763, 0.46377217340323246, 0.665555713280655,
          0.20878353904241026, -0.7067712419842719, 0.6759318348242935,
          0.9433716131024072, 4.910963932148536, -0.27949853828619636>
}

object
{
  BonsaiLeaf(0.004404438851968689)
  matrix <-0.7738789320575281, 0.30318077436038837, 0.5560510916954785,
          0.5979304577811921, 0.6391837212900872, 0.4836562189151811,
          -0.2087835390424097, 0.7067712419842718, -0.6759318348242938,
          0.9481883100901913, 4.912047743058695, -0.2798530720545572>
}

object
{
  BonsaiLeaf(0.003300599497315009)
  matrix <-0.02930834804877802, 0.9866901110873068, 0.15994888376343502,
          -0.7440916774091935, 0.08531082317121164, -0.6626082093214842,
          -0.6674343386019516, -0.13843658523803481, 0.7316875805441876,
          0.9424356313536788, 4.920122418113724, -0.309313310586145>
}

object
{
  BonsaiLeaf(0.003612866385989155)
  matrix <-0.6889559111524937, -0.25810637812806125, -0.6772893399852472,
          -0.2826148547812245, 0.9561466464079899, -0.07689235605533867,
          0.6674343386019517, 0.13843658523803487, -0.7316875805441876,
          0.9438705302610716, 4.923295271332533, -0.3074041080720735>
}

object
{
  BonsaiLeaf(0.003803545252529955)
  matrix <0.39084029777292284, -0.0625834506998384, 0.9183284670178062,
          -0.6125970365381062, 0.7269539503379103, 0.3102625096798439,
          -0.6869998052849087, -0.6838283891347349, 0.24578446198222226,
          0.9359064057629117, 4.937303599842363, -0.2772504103023402>
}

object
{
  BonsaiLeaf(0.002746922079393454)
  matrix <-0.7221201206009018, 0.680211120814826, -0.12591807869871557,
          0.0810789674443137, 0.2639916008762968, 0.9611111463847108,
          0.6869998052849084, 0.683828389134735, -0.24578446198222242,
          0.9384591639187974, 4.935263761952969, -0.2757904103693157>
}

object
{
  BonsaiLeaf(0.004501916187242914)
  matrix <0.36806256921162755, 0.5842745950963143, 0.7232932618726469,
          -0.5009262294242367, -0.5307530692717921, 0.6836476374078894,
          0.7833280652575597, -0.6139416722976286, 0.09732813157683731,
          0.8882179071799483, 4.942879277207798, -0.26260573913598534>
}

object
{
  BonsaiLeaf(0.00364964148447931)
  matrix <-0.6075708550009356, -0.7892821988032142, -0.0888328025325939,
          -0.13135752103811962, -0.010451491221482034, 0.9912799644893302,
          -0.7833280652575593, 0.6139416722976293, -0.09732813157683667,
          0.8899936272227288, 4.945230538845844, -0.26206564702006885>
}

object
{
  BonsaiLeaf(0.004651791845284606)
  matrix <0.08654447576595341, 0.8572797073768864, -0.5075249324261774,
          -0.2275872156315232, 0.5129780681558623, 0.827682040926447,
          0.9699041772234438, 0.043874877901577125, 0.2395013196072938,
          0.9019326984098255, 4.97514050373312, -0.25506705173744987>
}

object
{
  BonsaiLeaf(0.003098147190839054)
  matrix <-0.7898426739480854, 0.6001173691433204, -0.12652151462512934,
          0.3510561464670972, 0.6115340702793653, 0.7090738063948092,
          0.5028997240387085, 0.5156405958999454, -0.6936905963192376,
          0.903108267092958, 4.979651389097792, -0.2537056663549157>
}

object
{
  BonsaiLeaf(0.003201588728427415)
  matrix <0.8032414425324131, 0.017588250798020233, 0.5953938515237738,
          -0.3192100445791728, 0.8566244388842839, 0.40533876960629717,
          -0.5028997240387088, -0.5156405958999454, 0.6936905963192376,
          0.9009986641982287, 4.980499325683881, -0.25460475334032917>
}

object
{
  BonsaiLeaf(0.0025245646821059897)
  matrix <-0.17222083154299767, 0.9827889446535965, 0.0668272059067819,
          0.8679006132608829, 0.18347657547687063, -0.46161116944097347,
          -0.46592758094367115, -0.021499686461652318, -0.8845616161681609,
          1.0141434963813933, 4.906082843502504, -0.44460933330807434>
}

object
{
  BonsaiLeaf(0.002585127063416799)
  matrix <0.8188978607288033, 0.3681737629227388, -0.44028896646304894,
          -0.335138453493132, 0.9295083882232373, 0.15393626347573217,
          0.4659275809436705, 0.02149968646165276, 0.8845616161681613,
          1.01108604965946, 4.90802254231013, -0.44304602125208564>
}

object
{
  BonsaiLeaf(0.002683427334793797)
  matrix <0.020551616437589015, 0.5492728682668353, -0.8353902963571733,
          -0.8001983288303212, 0.5099673299784877, 0.3156199564219167,
          0.5993832376693254, 0.6619914187816448, 0.4500078842203779,
          1.0003262964065547, 4.906585876012309, -0.44332007268780105>
}

object
{
  BonsaiLeaf(0.0044188569460107165)
  matrix <-0.6944284256707269, 0.15041588851777085, 0.7036648506937692,
          -0.39813175711253246, 0.734263183021506, -0.5498624210087589,
          -0.5993832376693252, -0.6619914187816448, -0.4500078842203782,
          1.00071428319505, 4.908462019705687, -0.4465967792846949>
}

object
{
  BonsaiLeaf(0.003256943392913998)
  matrix <-0.5356917109360004, 0.8030191583738485, 0.2611410004557222,
          -0.7762598595600909, -0.3465956677026989, -0.5265852956221508,
          -0.33234774148504176, -0.48480065430471125, 0.8090199653380106,
          0.9168686045916626, 4.758517100165051, -0.40440471401475714>
}

object
{
  BonsaiLeaf(0.004622114256373843)
  matrix <-0.876611859855371, 0.03504413114583915, 0.4799203642617594,
          -0.2675671553371432, 0.7934477648871012, -0.5466703410470091,
          -0.39994932747248896, -0.6076286310468727, -0.6861690623938145,
          0.9133415755031121, 4.76653810742389, -0.4052634790585758>
}

object
{
  BonsaiLeaf(0.004325021641344738)
  matrix <-0.38009027283372426, 0.791201506151535, -0.4790945221568791,
          -0.8340095442808126, -0.0691926542029292, 0.5473942424367144,
          0.3999493274724889, 0.6076286310468726, 0.6861690623938146,
          0.9109711921382307, 4.762571441471268, -0.4003692143367994>
}

object
{
  BonsaiLeaf(0.004191166380408167)
  matrix <0.1443627232644373, 0.7106684418289178, 0.6885562939369104,
          0.12006490644320521, -0.7032842553812575, 0.7006965636947389,
          0.9822137355853156, -0.018483017104589994, -0.18685437031616745,
          0.9405330746709906, 4.73105066334153, -0.3739530656601917>
}

object
{
  BonsaiLeaf(0.002725638469478064)
  matrix <-0.040637229173124914, -0.9924829211818411, -0.1154394506548353,
          0.18331610194598585, -0.1209794579301412, 0.9755814561205323,
          -0.9822137355853156, 0.018483017104590105, 0.1868543703161675,
          0.9405295160911776, 4.733668498404003, -0.3742307191939051>
}

object
{
  BonsaiLeaf(0.003763490203902279)
  matrix <0.21456972487138964, -0.5381417637184052, 0.8150848270644356,
          -0.566343586240738, -0.7484562042250681, -0.3450626793511335,
          0.795747934645511, -0.3875780598783263, -0.4653691781890542,
          0.9372005957732705, 4.734553703782676, -0.38219025368147835>
}

object
{
  BonsaiLeaf(0.0029644251969481758)
  matrix <-0.49377625025883976, 0.8692205976821207, -0.025309429970981234,
          -0.6254778338267848, -0.33479296936113767, 0.7047631850896479,
          0.6041212577551568, 0.3638258102876829, 0.7089910335800012,
          0.9780060235079954, 4.7822871372619415, -0.37289756288830905>
}

object
{
  BonsaiLeaf(0.004206224840061567)
  matrix <-0.7152816471249912, -0.1446390954966844, 0.6837043932432061,
          -0.35129712668122853, 0.9201686322747651, -0.17285837255713388,
          -0.6041212577551569, -0.36382581028768285, -0.7089910335800012,
          0.9783825710582352, 4.787150042134196, -0.3757138618125327>
}

object
{
  BonsaiLeaf(0.0031943544992595963)
  matrix <-0.5029232502702854, 0.4302412886342154, -0.7496403390239497,
          -0.14376543885062876, 0.8135855260966894, 0.5633915958887378,
          0.8522908558289584, 0.3911151048992402, -0.34731724948524895,
          0.9165383140765306, 4.785934374301127, -0.4243480381830774>
}

object
{
  BonsaiLeaf(0.003381974011364769)
  matrix <0.2035801306319729, 0.36361067500078936, 0.9090337768407393,
          -0.48182510051076644, 0.8454680666619688, -0.23027878923744372,
          -0.8522908558289588, -0.39111510489924023, 0.34731724948524795,
          0.9153680318850106, 4.786194844744197, -0.42692650754281924>
}

object
{
  BonsaiLeaf(0.0038186681276508646)
  matrix <-0.3670954612764945, 0.9228661571780215, 0.1164430257493729,
          -0.836739050847255, -0.2729360979925082, -0.4747353443760629,
          -0.4063356778544466, -0.27170561707130003, 0.8723917552077572,
          0.9157135373294153, 4.777628945512025, -0.4285230679490987>
}

object
{
  BonsaiLeaf(0.0033991663402245837)
  matrix <-0.8473552134750489, 0.0752608763546948, -0.5256661894082377,
          0.07780354149098437, -0.9616275812311637, -0.26309504736304357,
          -0.5252958700847689, -0.26383365120057234, 0.8089845816615175,
          0.9598756706923375, 4.72716987653485, -0.42484956114807443>
}

object
{
  BonsaiLeaf(0.0028912782950309313)
  matrix <0.8347830832868449, -0.3440549829531836, 0.42984110152845184,
          -0.16492862920061502, -0.9011203988365036, -0.4009745304514321,
          0.5252958700847685, 0.2638336512005724, -0.8089845816615177,
          0.9591343489471141, 4.727833218790437, -0.42511458627555265>
}

object
{
  BonsaiLeaf(0.0037265633157584875)
  matrix <-0.34068416743341756, -0.9173209815016015, -0.20604978756877596,
          -0.6565301531460161, 0.07524226222537062, 0.7505376472804521,
          -0.6729802791094752, 0.3909741920794095, -0.6278827319313585,
          0.9542862489990652, 4.737782921602971, -0.4174961822581553>
}

object
{
  BonsaiLeaf(0.0027045679977005447)
  matrix <-0.6775852169766565, 0.014530701868798401, 0.7353007088517571,
          -0.2966071773649948, -0.920286933424056, -0.2551394569730786,
          0.6729802791094752, -0.39097419207940953, 0.6278827319313582,
          0.9559306559036788, 4.735013547959927, -0.4209831503318864>
}

object
{
  BonsaiLeaf(0.0020889182368496995)
  matrix <0.5367936027324574, -0.768870681000192, -0.3474053885071584,
          0.4851112878531729, 0.618151588298733, -0.6185108344088969,
          0.690304039147204, 0.16348238370557033, 0.7048076643702164,
          1.2562073931760374, 4.779431646565061, -0.5014328065928129>
}

object
{
  BonsaiLeaf(0.002156493163112854)
  matrix <-0.1950371508118968, 0.980123174360031, -0.03631904301594974,
          0.6967358490419683, 0.11239249663728396, -0.7084681244483803,
          -0.6903040391472042, -0.16348238370556967, -0.7048076643702161,
          1.2566965414548938, 4.778382752089709, -0.5016685946977834>
}

object
{
  BonsaiLeaf(0.0034419193909493912)
  matrix <-0.12662261622066018, 0.8190772027664845, 0.5595348505407556,
          -0.6572202505476624, 0.35322723353826446, -0.6658018201814803,
          -0.7429860397958383, -0.4520432030184014, 0.49358756798906644,
          1.2367534364650778, 4.781644612995519, -0.5178695423432563>
}

object
{
  BonsaiLeaf(0.003126481276487623)
  matrix <-0.26416858443751423, -0.47953214703977687, -0.8368177095112774,
          -0.6149688639799389, 0.752134205152436, -0.23687007783790898,
          0.7429860397958384, 0.4520432030184012, -0.49358756798906667,
          1.2370928469507063, 4.782780366840807, -0.5163184760111647>
}

object
{
  BonsaiLeaf(0.002200559774013071)
  matrix <0.8577730469904592, 0.34463652098248554, 0.3813804770328342,
          0.41767894788601456, -0.034843569712847314, -0.907926330790388,
          -0.2996159147133802, 0.93808933159628, -0.17383529444767498,
          1.265474559819718, 4.778499333875331, -0.5195514543722793>
}

object
{
  BonsaiLeaf(0.0022198396101106386)
  matrix <-0.10425556082088344, -0.21330737610359007, -0.9714065788009281,
          0.9483464987484204, 0.27292557455292993, -0.16171131397204597,
          0.29961591471338034, -0.9380893315962799, 0.17383529444767504,
          1.2666606094505795, 4.779181860234229, -0.5179124813911329>
}

object
{
  BonsaiLeaf(0.0022144375024316077)
  matrix <0.3718741891617262, -0.18534988550463183, -0.9095905712894827,
          -0.16493585806853556, -0.9774652691559291, 0.13174904294575918,
          -0.913512862612511, 0.1010300328483931, -0.3940649468097207,
          1.3310105048581886, 4.69297568030735, -0.49401667139625116>
}

object
{
  BonsaiLeaf(0.003278486253751266)
  matrix <-0.39196715957416806, 0.040680154163356394, 0.9190793604866795,
          -0.10888524076684362, -0.994051335455015, -0.0024386109259829647,
          0.9135128626125114, -0.10103003284839328, 0.3940649468097198,
          1.3310187662427007, 4.691881232417881, -0.4943164163702588>
}

object
{
  BonsaiLeaf(0.0037216670411208005)
  matrix <-0.5970500643810354, -0.5346878683796376, 0.5980301865543589,
          0.742491236166901, -0.6505597382590291, 0.15962077299553085,
          0.3037070707737112, 0.5393337652734007, 0.7854177899679047,
          1.338573881400209, 4.6936210408884955, -0.4792091655356196>
}

object
{
  BonsaiLeaf(0.003625606846142658)
  matrix <0.9403028204310099, -0.3025687487768856, -0.155829259617946,
          -0.15359889664818258, -0.7858570111029148, 0.5990293290389501,
          -0.3037070707737113, -0.5393337652734007, -0.7854177899679047,
          1.3352536870269982, 4.6931929990651104, -0.4776313760691514>
}

object
{
  BonsaiLeaf(0.003905416671077918)
  matrix <-0.6898294622075858, 0.6883616944522868, 0.22426210264146018,
          -0.6545409907312475, -0.46062468852874183, -0.5995006153210819,
          -0.30937259820958535, -0.5603419259064737, 0.7683134266355591,
          1.2164081674396225, 4.738368055009897, -0.5110371518991037>
}

object
{
  BonsaiLeaf(0.0032546384721277915)
  matrix <-0.3425045027074133, 0.19552545234617652, 0.9189452993023955,
          -0.8806022821847053, 0.274100187565954, -0.38653422589390085,
          -0.327460358266823, -0.9416150405877833, 0.0782996111269545,
          1.1651111198691428, 4.7643441120687475, -0.5228045257483418>
}

object
{
  BonsaiLeaf(0.0037690057714879375)
  matrix <-0.8305130454918366, 0.24732231891446493, -0.4990789034157284,
          -0.45057496050228796, 0.2284574050138009, 0.8630118301985906,
          0.327460358266823, 0.9416150405877834, -0.07829961112695488,
          1.1662789423087636, 4.764313072331114, -0.5182938000170726>
}

object
{
  BonsaiLeaf(0.0035585688184041273)
  matrix <0.11505328492476136, 0.7323456466503547, 0.6711427534141257,
          0.7691703945667032, -0.4932194613307401, 0.40633910356587133,
          0.6286013408752187, 0.4694724877954911, -0.6200451092081839,
          1.2401897856034105, 4.914112741597506, -0.37664597693564006>
}

object
{
  BonsaiLeaf(0.003183336728733023)
  matrix <0.6878360600578716, -0.7076695385852357, 0.1615096859096172,
          0.3629626822883317, 0.5280145901030306, 0.767762127162044,
          -0.6286013408752189, -0.4694724877954909, 0.620045109208184,
          1.2386080722589539, 4.917548745231209, -0.3756479172209627>
}

object
{
  BonsaiLeaf(0.004042514491352009)
  matrix <-0.16920122280974192, 0.8639174911540798, 0.47436011075735196,
          0.1149050875941105, 0.4953089282789159, -0.8610841343400658,
          -0.9788604430891448, -0.09119009839468191, -0.18307539132851902,
          1.2244152218586424, 4.926240026225015, -0.40776604814390477>
}

object
{
  BonsaiLeaf(0.0038436501914554085)
  matrix <-0.8149135485434434, 0.4881745083384872, 0.3124124802385586,
          0.4660782697070323, 0.8723743034034165, -0.14742496826624135,
          -0.3445097312228359, 0.025470064190723007, -0.9384371694060759,
          1.2252141828674887, 4.932596396985186, -0.4045220723378327>
}

object
{
  BonsaiLeaf(0.00371804482747801)
  matrix <0.8836638707556475, 0.346281622618828, -0.31500349419906015,
          -0.31694038653020395, 0.9377847906991197, 0.14180436424698842,
          0.34450973122283574, -0.025470064190723014, 0.938437169406076,
          1.2222443424721385, 4.932730021217235, -0.40342818734732855>
}

object
{
  BonsaiLeaf(0.0025041061258666017)
  matrix <0.1524952471900004, -0.3615009067548157, -0.9198164458194392,
          0.8759772003676347, 0.48038074950751597, -0.043569254511377775,
          0.4576124386645766, -0.7990941308244247, 0.3899223333709116,
          1.3316260760498901, 4.916104802468075, -0.5244616475794979>
}

object
{
  BonsaiLeaf(0.0027607915720622594)
  matrix <0.847731706202585, 0.5243919693145965, 0.07977478810509481,
          0.2682197052386584, -0.2940435896262935, -0.9173857188344332,
          -0.4576124386645767, 0.7990941308244246, -0.38992233337091164,
          1.330173034878014, 4.914090085026426, -0.5268852563032649>
}

object
{
  BonsaiLeaf(0.004085090905772224)
  matrix <0.45471870772689305, 0.030477620107507652, -0.8901134823806265,
          -0.010426573687315449, 0.9995279984155239, 0.02889752488706951,
          0.8905740751921356, -0.003859411359039555, 0.4548218569282201,
          1.2962743091147668, 4.92469831339189, -0.5199393730598573>
}

object
{
  BonsaiLeaf(0.0031553482278642506)
  matrix <-0.6093387116558452, 0.7583864601525079, -0.23142236610782257,
          0.785717258105805, 0.538297570804033, -0.30476895442477864,
          -0.10655855100502676, -0.3675400690044895, -0.9238828783367962,
          1.3000117846672268, 4.927827133840562, -0.5233526601915219>
}

object
{
  BonsaiLeaf(0.002504997305504217)
  matrix <0.9915085641569354, 0.0303781426563135, -0.12644340889190298,
          -0.07453886510513374, 0.929511412584551, -0.3611820752251016,
          0.10655855100502754, 0.3675400690044893, 0.923882878336796,
          1.2973458534530165, 4.928457041138421, -0.523295768136505>
}

object
{
  BonsaiLeaf(0.004708468539087746)
  matrix <0.28861808724701565, -0.9532762413515348, 0.08924128746585899,
          0.5386425961259829, 0.08460633094424005, -0.8382755647177208,
          0.7915578016497182, 0.290010648836976, 0.5378941068729243,
          1.2958411518583801, 4.912410781925566, -0.6002362084306261>
}

object
{
  BonsaiLeaf(0.003782404630030533)
  matrix <-0.6714742296109815, -0.4447402048327665, -0.5927297100480515,
          0.6057208444222428, -0.7901891035351926, -0.09329222522082448,
          -0.4268777548675303, -0.42167206554330516, 0.79998003196311,
          1.2985963767921453, 4.903381234743762, -0.5980151875139461>
}

object
{
  BonsaiLeaf(0.004614355769494744)
  matrix <0.8749200510502475, -0.41627533381895, 0.24744646031849674,
          -0.22867069482005842, -0.8055479598350207, -0.5466280250189763,
          0.42687775486753027, 0.4216720655433051, -0.7999800319631101,
          1.2952501275257393, 4.902652964791503, -0.6001846547503389>
}

object
{
  BonsaiLeaf(0.003787008787075119)
  matrix <0.48857677206255756, 0.8465525720313758, -0.21128530613365745,
          -0.6318898175688943, 0.5102867715495644, 0.5833718104556226,
          0.601671003334614, -0.15151288251691375, 0.7842422139732943,
          1.238756797119456, 4.976870946542679, -0.6254302864662846>
}

object
{
  BonsaiLeaf(0.00490199474045452)
  matrix <-0.7954412109582949, -0.024462288436505164, 0.605536849707472,
          0.07256227432709239, 0.988152540287108, 0.13523784037248823,
          -0.6016710033346139, 0.1515128825169138, -0.7842422139732944,
          1.2415054692981595, 4.979782404610146, -0.6269765854563956>
}

object
{
  BonsaiLeaf(0.004257649786969531)
  matrix <-0.08378160189652797, 0.8676059237732894, 0.49014345269231896,
          -0.7075311616412446, 0.2945704249742702, -0.6423612068276445,
          -0.7016981534037566, -0.4006098173584547, 0.5891786450184553,
          1.2495567453359269, 4.956525364334362, -0.6380994416973325>
}

object
{
  BonsaiLeaf(0.0044985430168320885)
  matrix <-0.3944887092904948, 0.21995149917710913, -0.8921883188273989,
          -0.8125566270738374, -0.5368988728851248, 0.22691700706000673,
          -0.4291041668880741, 0.8144697282922333, 0.39052359167515943,
          1.2416056813174885, 4.943045844063317, -0.6567808713065433>
}

object
{
  BonsaiLeaf(0.004953744587302551)
  matrix <-0.8500220170615783, -0.5103540840703166, 0.1303889542227935,
          -0.3055031660553739, 0.2760032075326728, -0.9113122653414787,
          0.4291041668880742, -0.8144697282922332, -0.3905235916751595,
          1.2437476176027416, 4.9468283561340725, -0.6623160754258313>
}

object
{
  BonsaiLeaf(0.004585822975785986)
  matrix <0.6593661311676275, 0.7023528284123303, -0.2682103828904362,
          0.7097698918390035, -0.4638871791571219, 0.5301277069277717,
          0.24791733644076702, -0.539915909595973, -0.8043803856741333,
          2.1482317587167405, 4.155678468301194, 0.2616917903614289>
}

object
{
  BonsaiLeaf(0.004330266274684491)
  matrix <0.2104495952595311, -0.780459537400471, 0.5887222420936222,
          0.9456468485366064, 0.31523597676311427, 0.07986436506346425,
          -0.247917336440767, 0.5399159095959731, 0.8043803856741332,
          2.1490717822952035, 4.15917082850429, 0.25960655250948217>
}

object
{
  BonsaiLeaf(0.0036688645050103504)
  matrix <-0.40152207066786494, 0.5427560510520345, 0.7376963439064822,
          -0.8871151716221857, -0.030305939202648097, -0.46055208427145955,
          -0.22761085001451567, -0.8393434452567352, 0.493655630840187,
          2.089998857250322, 4.159591549275132, 0.24939777814753983>
}

object
{
  BonsaiLeaf(0.00349074227437335)
  matrix <-0.744454603995177, -0.17679287295155716, -0.6438413023905181,
          -0.6276787741719914, 0.5140494732786789, 0.5846131160655383,
          0.22761085001451586, 0.8393434452567357, -0.49365563084018615,
          2.0910624977836134, 4.161497151887257, 0.25312821506063504>
}

object
{
  BonsaiLeaf(0.00429936914099788)
  matrix <0.8345318499186362, -0.30882391996812597, 0.45627226293836926,
          -0.022638201850708195, 0.8082214191438695, 0.58844341227856,
          -0.5504944171273185, -0.5014039530085395, 0.6674952978254333,
          2.1040214086600586, 4.2057449113460175, 0.31587555678719864>
}

object
{
  BonsaiLeaf(0.004000184605974668)
  matrix <-0.6275228800215948, 0.7758571742516627, 0.06527388613854988,
          0.5506096001352113, 0.38293566178881144, 0.7417474955598484,
          0.5504944171273186, 0.5014039530085395, -0.6674952978254332,
          2.106321278692866, 4.2038018824568235, 0.3163127482524835>
}

object
{
  BonsaiLeaf(0.004320729731409724)
  matrix <0.24551095118160568, 0.4194657502229553, -0.8739409918523081,
          0.39297495641156294, -0.8672001411890226, -0.30583426680976905,
          -0.8861687516964437, -0.2683512614310435, -0.37774666643814936,
          2.2086594279208183, 4.081821415497861, 0.1735683556227069>
}

object
{
  BonsaiLeaf(0.004975591095526764)
  matrix <0.1410933586511973, -0.9327892291457249, 0.3316578329155645,
          0.4413588196255866, -0.24060726189808143, -0.8644712475615463,
          0.8861687516964438, 0.26835126143104276, 0.37774666643814975,
          2.2091575103558125, 4.08437118958116, 0.1705885273904896>
}

object
{
  BonsaiLeaf(0.004284474926764704)
  matrix <-0.22057321762950893, 0.4940490247615863, -0.8409893083724018,
          0.9160532631661253, -0.19116714194977338, -0.3525642393684427,
          -0.33495354111765835, -0.848157228920959, -0.4104088696919946,
          2.224439499412919, 4.095103776755792, 0.17650297317623692>
}

object
{
  BonsaiLeaf(0.004853015671384879)
  matrix <0.9386379189360129, -0.33838090812818417, -0.06676240071938916,
          0.08224951323997065, 0.40758762989505043, -0.909454419709049,
          0.33495354111765824, 0.848157228920959, 0.4104088696919945,
          2.22091385035202, 4.09790085673764, 0.17359992926862663>
}

object
{
  BonsaiLeaf(0.0036543375083011452)
  matrix <0.8287886546354657, -0.5554459728642628, 0.06774317069939148,
          -0.5572710866934857, -0.8302679712709338, 0.010199598869999361,
          0.05057965878687207, -0.04620462217700048, -0.9976506557941431,
          2.2372066572986555, 4.028389488215831, 0.20690487493795914>
}

object
{
  BonsaiLeaf(0.003498986520499683)
  matrix <0.8946484081785946, 0.412253015962303, -0.17219662184111362,
          0.43638130915420953, -0.8889661232894164, 0.1389625297144632,
          -0.09578924138109016, -0.19946599327647274, -0.9752116379339744,
          2.245146189670447, 4.024194122722385, 0.20776646064855414>
}

object
{
  BonsaiLeaf(0.0038440112001725778)
  matrix <-0.26335457473264867, -0.9397272304722857, 0.21807590485028855,
          0.9599316586106641, -0.2777157716715351, -0.03748547667914216,
          0.09578924138109027, 0.19946599327647285, 0.9752116379339744,
          2.247309285399018, 4.026237060668185, 0.20713613803803027>
}

object
{
  BonsaiLeaf(0.0037945966758069364)
  matrix <0.5330312767431584, 0.4325782360776955, -0.7271545418172586,
          0.8362045513665762, -0.1383073462113767, 0.5306910836426304,
          0.1289945978999949, -0.8909248832847106, -0.43544603116430214,
          2.053993316477755, 4.219196853764582, 0.3014468810103064>
}

object
{
  BonsaiLeaf(0.003801736130706926)
  matrix <0.010688478732223172, -0.4378400427443999, 0.8989893511004301,
          0.9915876916012065, 0.12061902550470799, 0.046956368591333564,
          -0.1289945978999945, 0.8909248832847111, 0.43544603116430136,
          2.054590012220769, 4.220180236068067, 0.2996116381114762>
}

object
{
  BonsaiLeaf(0.003374850084269955)
  matrix <0.707568700587822, -0.3622935313442018, 0.6067041545058096,
          0.6578976981319732, 0.6511010482611768, -0.37846802209149377,
          -0.2579091947587608, 0.6669413933017982, 0.6990508029889838,
          2.1011450368909816, 4.277475813548011, 0.284920536620643>
}

object
{
  BonsaiLeaf(0.0037161723106621672)
  matrix <0.08346726708859775, 0.7362036780254754, -0.671593150491071,
          0.9625570438076116, 0.11486218856707137, 0.24554147318515165,
          0.257909194758761, -0.6669413933017984, -0.6990508029889836,
          2.1025017586226307, 4.275705292805114, 0.2871102838806618>
}

object
{
  BonsaiLeaf(0.002920102149153277)
  matrix <-0.31876452459881516, 0.9318538156270051, 0.17331371601429113,
          0.9374433934752242, 0.33695547450421953, -0.08752652301612457,
          -0.1399609298588257, 0.13457144757721617, -0.9809696547855216,
          2.0531366774369277, 4.247225183182848, 0.2999582770769969>
}

object
{
  BonsaiLeaf(0.004838454028702302)
  matrix <0.9565671310641879, 0.2742376036571431, -0.09885879074729093,
          -0.25571519681216, 0.9521996966169229, 0.16710917354220217,
          0.13996092985882558, -0.13457144757721617, 0.9809696547855216,
          2.049161980744715, 4.250848413235805, 0.30102241351892256>
}

object
{
  BonsaiLeaf(0.004798993957775659)
  matrix <-0.4347906528558178, 0.8378008938444105, 0.33022227432854656,
          0.4832855728597044, -0.09233324479741022, 0.870580052017532,
          0.7598632398365374, 0.5381117301998609, -0.3647514531382059,
          2.0521086336560814, 4.223610432753837, 0.3160359026772976>
}

object
{
  BonsaiLeaf(0.004796589976759292)
  matrix <0.6412232276640019, -0.5280935389695243, 0.5567315209351836,
          -0.10696087625519923, 0.6569269212933474, 0.7463286079407405,
          -0.7598632398365376, -0.5381117301998604, 0.36475145313820595,
          2.0492763016450963, 4.2272045485238605, 0.3154378265881227>
}

object
{
  BonsaiLeaf(0.004907470400712127)
  matrix <-0.24158696616200764, -0.9653685685903435, -0.09848484430848725,
          0.2959634496912742, -0.16995836510892876, 0.939957334444676,
          -0.9241435896155299, 0.19793352648636897, 0.32677353758404637,
          2.02425465704534, 4.164925192773927, 0.35675197673308934>
}

object
{
  BonsaiLeaf(0.004342289836171153)
  matrix <0.3684506468144423, 0.6878906669761479, 0.6253403482497579,
          0.10100864633555671, -0.6983041954476422, 0.7086384861025253,
          0.9241435896155299, -0.19793352648636905, -0.32677353758404654,
          2.0232408339946355, 4.162727019209604, 0.35521627763209257>
}

object
{
  BonsaiLeaf(0.0031617773642079296)
  matrix <0.4566328407237865, -0.5740303026455466, 0.6796879139849307,
          -0.7336518526478427, 0.18918123735663914, 0.6526602627237224,
          -0.5032309687200431, -0.796680407112458, -0.33475202918610436,
          2.0189913492482394, 4.18837146367303, 0.4030649037768464>
}

object
{
  BonsaiLeaf(0.003742840201743134)
  matrix <-0.8551870230616854, 0.40347241697899555, 0.3253692737859852,
          0.12415211519736297, -0.45001148614258113, 0.8843505609382318,
          0.5032309687200431, 0.796680407112458, 0.3347520291861044,
          2.0217756745970425, 4.1860889936374415, 0.40431132016356225>
}

object
{
  BonsaiLeaf(0.0033935388282794066)
  matrix <0.5430605361962343, 0.43852382576680105, 0.7160880590130703,
          0.451997681109572, -0.8713672484501049, 0.19083294946120327,
          0.7076604767102852, 0.2200362982858523, -0.6714169175250435,
          2.040462306770578, 4.196344314582566, 0.34818031843014235>
}

object
{
  BonsaiLeaf(0.004992506046501639)
  matrix <0.9722053891967487, -0.19556509861478852, -0.1287282930073521,
          -0.16743543113715798, -0.9650544018281915, 0.20158218649460402,
          -0.1636522459873761, -0.1744256108368815, -0.9709756169273602,
          2.054895109602705, 4.166939719424203, 0.3875381510457002>
}

object
{
  BonsaiLeaf(0.0029684089846268914)
  matrix <0.06603562587216386, 0.9977991384288808, 0.00601460441375519,
          0.9839802396658692, -0.06411834793033647, -0.16634820529775077,
          -0.1655964494268221, 0.016903159742090668, -0.9860487306051173,
          1.9415190720387518, 4.311187740811986, 0.21211638121439885>
}

object
{
  BonsaiLeaf(0.0034389427559570595)
  matrix <0.4268058140747491, -0.9001383213567032, -0.087107976082137,
          0.8890526491773255, 0.43527610273924866, -0.14184534315553135,
          0.16559644942682208, -0.016903159742090557, 0.9860487306051174,
          1.9416556174221853, 4.312874959892419, 0.2121223727062703>
}

object
{
  BonsaiLeaf(0.003667633888246138)
  matrix <-0.6560755065016356, 0.08362483257304784, 0.750047876569057,
          0.7422862971440143, 0.2509841599041997, 0.6213034721852204,
          -0.1362937373500711, 0.9643722511843196, -0.22673812715297156,
          1.9114823053257688, 4.317105885907675, 0.22447575893932156>
}

object
{
  BonsaiLeaf(0.00393079105973866)
  matrix <0.9487580342017798, 0.06119642632614689, -0.3100212733708487,
          0.2851003502220296, 0.2573735778019874, 0.923296610928839,
          0.13629373735007105, -0.9643722511843196, 0.22673812715297165,
          1.9098805408553636, 4.317197049656034, 0.22582633133357616>
}

object
{
  BonsaiLeaf(0.003994795387111926)
  matrix <0.18581796313827284, 0.6167643705395321, 0.7649009058748181,
          0.07918666743283839, 0.7665264956364546, -0.6373120139995615,
          -0.9793881540410954, 0.1789939739775346, 0.09359487701634606,
          1.8780357570790112, 4.331159506896746, 0.19901724777115448>
}

object
{
  BonsaiLeaf(0.00420904789133216)
  matrix <-0.3469372861663191, -0.08206818078937875, 0.9342908183052379,
          0.46185362847148925, 0.852058476103801, 0.24634849130325068,
          -0.8162877834044003, 0.5169730815057875, -0.2577073682748335,
          1.8857214169775416, 4.352178367859362, 0.21219602741368704>
}

object
{
  BonsaiLeaf(0.00441724551265224)
  matrix <0.5004017841825883, 0.4099881564956003, -0.7625665649110388,
          0.2885694180810116, 0.7514309978512657, 0.5933625758477166,
          0.8162877834044002, -0.5169730815057878, 0.257707368274834,
          1.8850521349036267, 4.351911268130552, 0.21378016299137334>
}

object
{
  BonsaiLeaf(0.004676559598974087)
  matrix <-0.34523422585790775, 0.703752230556248, -0.6209236082509636,
          -0.39293790682635915, 0.4924363078194207, 0.7765991785471418,
          0.8522987332357184, 0.5120930391328136, 0.10652506088478954,
          1.841912542551062, 4.468482667666691, 0.13150654366599793>
}

object
{
  BonsaiLeaf(0.002582387420427988)
  matrix <-0.20467292189896832, 0.6544430811258287, 0.7278827162447736,
          -0.5991385884065399, 0.5042845329203038, -0.6218762431059489,
          -0.7740426001994705, -0.5633838508724597, 0.28888871499690044,
          1.8305740646309565, 4.4906537325761535, 0.13012992068069634>
}

object
{
  BonsaiLeaf(0.003914075021140935)
  matrix <-0.4455840280403759, 0.1605850358792793, -0.8807197739388867,
          -0.4497920931183159, 0.8104388211504726, 0.37533450432977156,
          0.7740426001994705, 0.5633838508724597, -0.28888871499690033,
          1.8303607525883694, 4.492523592888052, 0.13320493347592563>
}

object
{
  BonsaiLeaf(0.004166687149835207)
  matrix <-0.46772959784413154, 0.8466936486253005, -0.2536511160593283,
          -0.3404959627413175, -0.4374338548487021, -0.8322944923457491,
          -0.815654045939472, -0.3029215872297325, 0.49289653004742234,
          1.7989925683056973, 4.500209358145876, 0.09486286445630446>
}

object
{
  BonsaiLeaf(0.004464615749306837)
  matrix <0.06927044301351495, -0.896972227257438, -0.4366261893811938,
          -0.5743779966775202, 0.32199275693569535, -0.7526025388036297,
          0.8156540459394717, 0.30292158722973345, -0.492896530047422,
          1.7978469314082006, 4.503469582101555, 0.0949706940747291>
}

object
{
  BonsaiLeaf(0.004908697080861174)
  matrix <-0.802960327162332, 0.5914627577097471, 0.07366491190343592,
          0.5284919161966661, 0.7636589630868237, -0.37083862071247736,
          -0.27559210351194136, -0.2588373897634133, -0.9257711370216326,
          1.914211596730916, 4.44763854484792, 0.10206006530142292>
}

object
{
  BonsaiLeaf(0.0045999405333554885)
  matrix <0.938010304118923, 0.13818430548087074, -0.31787067666819235,
          -0.21020385783469503, 0.9559855142099336, -0.2047096352695179,
          0.2755921035119412, 0.2588373897634133, 0.9257711370216325,
          1.910650464758701, 4.448287450841157, 0.10293874760754017>
}

object
{
  BonsaiLeaf(0.003632108991000093)
  matrix <0.8224224983204659, -0.3925700471059063, 0.4117159122156795,
          0.4969386894231588, 0.14349193815982872, -0.8558399398471239,
          0.27689921128583217, 0.9084595873226289, 0.3130942429858491,
          1.909691913561865, 4.422353222250838, 0.09402137153146295>
}

object
{
  BonsaiLeaf(0.004095034660620124)
  matrix <-0.24574852469824887, 0.38195042370041393, -0.890910509784068,
          0.928942672826433, -0.16974996918017926, -0.3290143744054501,
          -0.27689921128583206, -0.9084595873226289, -0.31309424298584904,
          1.9116910305229886, 4.42113691188468, 0.09578255020480611>
}

object
{
  BonsaiLeaf(0.0033221190505372767)
  matrix <-0.29042491225575084, 0.3717447325199015, 0.8817364822808148,
          0.951898640557733, 0.018171002666342848, 0.30587381837358973,
          0.09768494482559488, 0.9281571356757464, -0.35914061737516395,
          1.9234980746197392, 4.339067832874101, 0.28694353287208735>
}

object
{
  BonsaiLeaf(0.0034309395051678924)
  matrix <0.8575426946398546, -0.26163231204587867, -0.4429097652607641,
          0.5050526491606968, 0.2647127967963043, 0.821491909143383,
          -0.09768494482559502, -0.9281571356757464, 0.35914061737516423,
          1.922068559097957, 4.339915680232028, 0.28874587267726365>
}

object
{
  BonsaiLeaf(0.002911729940901576)
  matrix <0.8454412146522781, -0.14988012746708707, 0.5126061840806558,
          -0.4848807694791454, 0.1869299306770621, 0.8543698498931129,
          -0.22387450046084656, -0.9708723646327142, 0.08536427611060808,
          1.9169610871969918, 4.346052061402845, 0.33639707944076264>
}

object
{
  BonsaiLeaf(0.004680256771693785)
  matrix <-0.6125771946705248, 0.20829536078898864, 0.7624711294490925,
          0.7580431311033674, -0.11840563443631662, 0.6413662893547937,
          0.22387450046084673, 0.9708723646327142, -0.08536427611060812,
          1.9219207655488342, 4.344953603154464, 0.33691114408711414>
}

object
{
  BonsaiLeaf(0.0049718661347822974)
  matrix <0.425481009571241, 0.5998286003609565, 0.6776219895216303,
          0.5356326460306775, -0.7704564223876771, 0.3456798659276469,
          0.7294268839303997, 0.21587624091269653, -0.6491023568043719,
          1.9523088254631176, 4.332056431379577, 0.319904902494259>
}

object
{
  BonsaiLeaf(0.004786668910439441)
  matrix <-0.3087410827684912, 0.9471676082866092, -0.08690492289601916,
          0.9468521945653864, 0.29738957050267056, -0.12259838907159112,
          -0.09027660526211537, -0.1201372763502671, -0.9886441065284755,
          1.9366690546416723, 4.3791069295867695, 0.2820139247210747>
}

object
{
  BonsaiLeaf(0.004787245739340372)
  matrix <0.9958497336184731, -0.022403715954342318, -0.08821213954696841,
          0.01155173555639627, 0.9925044626310632, -0.12166120607267725,
          0.09027660526211528, 0.12013727635026718, 0.9886441065284755,
          1.932192087675989, 4.382434786935362, 0.28201834052809927>
}

object
{
  BonsaiLeaf(0.003864202928423643)
  matrix <0.5840761574100972, -0.14712718057184393, 0.7982534904916077,
          0.1641366327041712, 0.9845272327669304, 0.061361989413848406,
          -0.7949303165369853, 0.09518256498576377, 0.5991878429784262,
          1.9370939187133196, 4.388040150009951, 0.29402685735161554>
}

object
{
  BonsaiLeaf(0.0035085663629773225)
  matrix <-0.16516714679308725, 0.9163627216193775, -0.3646905209167858,
          0.5837855817598097, 0.3888696976482695, 0.7127234756764392,
          0.7949303165369854, -0.09518256498576383, -0.5991878429784262,
          1.9385079119119162, 4.385600112134731, 0.29629037978529127>
}

object
{
  BonsaiLeaf(0.0038140607743288087)
  matrix <-0.26537719880401767, 0.9284991275197716, -0.2597389315253964,
          0.6493122238736984, 0.37125899901196235, 0.6637472347067279,
          0.7127191440414139, 0.007491718605051101, -0.7014095065432299,
          1.934499301767579, 4.376360623009712, 0.29194476205258724>
}

object
{
  BonsaiLeaf(0.004754253758914515)
  matrix <-0.9576912844304877, 0.259625501506357, 0.12418535619571264,
          -0.16506513938087752, -0.14203666920971234, -0.9760015801016836,
          -0.23575602534623524, -0.9552068799832752, 0.17888239976465492,
          1.6409798922622558, 4.203986696304312, -0.4219558908875993>
}

object
{
  BonsaiLeaf(0.004381634253948092)
  matrix <0.8268983090356267, -0.293875768495764, -0.4794540845639402,
          -0.5105470429127631, -0.034883364568815425, -0.8591419369634992,
          0.2357560253462356, 0.955206879983275, -0.17888239976465503,
          1.6395276234101446, 4.204509128527719, -0.42108017744669696>
}

object
{
  BonsaiLeaf(0.004315616501975163)
  matrix <-0.5678123100491466, 0.06659729893166376, -0.8204596152959994,
          -0.03286255329039841, -0.9977612255636112, -0.05824593851107196,
          -0.8225018134617624, -0.006110363066667457, 0.5687296636498805,
          1.6449874991558793, 4.167924268138487, -0.4312372872139886>
}

object
{
  BonsaiLeaf(0.004546107413108759)
  matrix <0.5565929122611641, -0.21439098270028045, 0.8026461465412047,
          -0.11702605211126924, -0.9767288108784347, -0.17973795683507948,
          0.8225018134617618, 0.006110363066667533, -0.5687296636498813,
          1.6445973083301264, 4.167789908860828, -0.43180302813856214>
}

object
{
  BonsaiLeaf(0.0033112888980142766)
  matrix <0.9946724297388159, 0.08548586041516537, -0.057610113578778654,
          -0.009661697800321889, -0.4790855340086674, -0.8777150464126984,
          -0.10263239797011592, 0.873595569341276, -0.47570723361558775,
          1.6776962167513076, 4.2069598532692, -0.3990250364019436>
}

object
{
  BonsaiLeaf(0.003042696293396747)
  matrix <-0.6713848910332461, -0.41370743987986064, -0.6148889999669273,
          0.7339679277592317, -0.25627511665267594, -0.6289786527422669,
          0.10263239797011603, -0.873595569341276, 0.4757072336155878,
          1.679961450917235, 4.207766476531632, -0.3980324593284617>
}

object
{
  BonsaiLeaf(0.004718529797233)
  matrix <0.9079249778979166, -0.38325399468966725, -0.1696720662439189,
          -0.28738178079793086, -0.8639124264141819, 0.4136025042871112,
          -0.30509661842517743, -0.32675938401455584, -0.8945078861496691,
          1.6962512546924355, 4.122750822338855, -0.36975909878654717>
}

object
{
  BonsaiLeaf(0.0033483146632585117)
  matrix <-0.6173767111409278, -0.6473085426389662, 0.4470320426629715,
          0.7250945110579268, -0.6886363013848781, 0.004241986400463832,
          0.30509661842517716, 0.3267593840145557, 0.8945078861496694,
          1.7000351187719358, 4.124521447839511, -0.37169649102197005>
}

object
{
  BonsaiLeaf(0.0024234652806771964)
  matrix <0.5686409112001601, 0.8217942542923155, -0.03607932540372817,
          0.42896125390506157, -0.25882402172602914, 0.8654492292594418,
          0.7018830078849677, -0.5076064709887971, -0.49969582132798607,
          1.6966892691355124, 4.13714048975514, -0.36673645170331953>
}

object
{
  BonsaiLeaf(0.0025468849801114765)
  matrix <-0.31385289335019484, -0.8501545168503024, 0.4227690371996743,
          0.6394189585694672, 0.1399034241515484, 0.7560227690569977,
          -0.7018830078849678, 0.5076064709887966, 0.49969582132798607,
          1.6972782229714969, 4.138124058715236, -0.3669083348274851>
}

object
{
  BonsaiLeaf(0.0043039905820430715)
  matrix <-0.9821477717586327, 0.1855807512373449, -0.03074962113160018,
          0.04189152733711393, 0.05641782246919724, -0.9975280092534736,
          -0.1833871706715552, -0.9810080601493631, -0.0631848997392973,
          1.680255949238101, 4.3576484371262705, -0.40502596105749905>
}

object
{
  BonsaiLeaf(0.004511587770605089)
  matrix <0.012900968106799249, 0.06186770746417347, -0.9980009778527448,
          -0.9829561082037135, 0.1838357220322277, -0.0013102098687101105,
          0.18338717067155474, 0.981008060149363, 0.06318489973929775,
          1.6756409557421612, 4.358235006345025, -0.4007385210271685>
}

object
{
  BonsaiLeaf(0.0034995528983928067)
  matrix <-0.3068097728437945, 0.419481518219918, -0.8543436189025189,
          -0.31821857470692466, 0.8007671214634885, 0.5074534026830165,
          0.896997604232605, 0.42755967192310207, -0.11219636779315281,
          1.6844759557679552, 4.363281185594961, -0.3853050525959356>
}

object
{
  BonsaiLeaf(0.004207291598156962)
  matrix <-0.26629474208584725, 0.7252710596475809, 0.634877153766858,
          -0.35282064613398056, 0.5396059830864401, -0.7644232954841952,
          -0.8969976042326051, -0.4275596719231022, 0.11219636779315251,
          1.6841051591632574, 4.3627491384130614, -0.3902970643306204>
}

object
{
  BonsaiLeaf(0.0024922255859818644)
  matrix <-0.32968110555509517, -0.5096770843846361, -0.7946946824366872,
          0.5330135737288748, 0.594283462298745, -0.6022654702529358,
          0.7792348162529342, -0.6221385987795588, 0.0757407753318086,
          1.69886358098506, 4.327835501994533, -0.4190717082091464>
}

object
{
  BonsaiLeaf(0.0029573307518965105)
  matrix <0.6241883629300615, 0.7812612537356838, -0.004443083843175544,
          0.056409119138187885, -0.05073871618354818, -0.9971176429880776,
          -0.7792348162529342, 0.6221385987795588, -0.0757407753318086,
          1.697702011341652, 4.326204362378785, -0.42051953346349585>
}

object
{
  BonsaiLeaf(0.004789714199305451)
  matrix <0.8900165216334394, -0.2800491967539642, -0.3597819320324094,
          -0.43419422108304306, -0.2798867626840554, -0.8562352354653068,
          0.13908978969573466, 0.918278741707385, -0.3706995858248264,
          1.6910975886767472, 4.329865266683807, -0.39333132261679865>
}

object
{
  BonsaiLeaf(0.004302226872334416)
  matrix <0.6975058557610547, 0.6831170426096096, 0.21641785341172587,
          -0.5133648516273273, 0.6870758183887307, -0.5141822137132992,
          -0.49994210694108493, 0.24754378578699285, 0.8299276859013394,
          1.666076669254563, 4.382270288004364, -0.36907192952132184>
}

object
{
  BonsaiLeaf(0.0043128789033526635)
  matrix <-0.7468368657268208, 0.3619805420559603, -0.5578573143414116,
          0.4385117851308527, 0.8987169528228097, -0.003905510240176213,
          0.4999421069410854, -0.24754378578699265, -0.829927685901339,
          1.6701765295415085, 4.383190389341075, -0.36687664497692973>
}

object
{
  BonsaiLeaf(0.0032342509904765794)
  matrix <-0.20614419146772467, -0.9103479753224893, -0.35884695365902486,
          -0.9123947961701838, 0.31134546674030217, -0.2657061088154221,
          0.3536103904662409, 0.27263632217022704, -0.894778814896623,
          1.651761157799616, 4.372095025854251, -0.37065889683258485>
}

object
{
  BonsaiLeaf(0.003726322763152209)
  matrix <-0.1423257661254811, -0.7416742927620004, 0.6554865519236698,
          -0.5323107550474762, -0.5009602739412725, -0.6824104805712405,
          0.8344990331675533, -0.44604713583731476, -0.3235016479923204,
          1.6497450116307821, 4.3653501579135305, -0.3747010062156499>
}

object
{
  BonsaiLeaf(0.0033492225242815255)
  matrix <-0.4017062497593224, -0.09062985820012437, -0.9112729106622928,
          -0.377151763281998, -0.8904089967054206, 0.254810451197211,
          -0.8344990331675533, 0.4460471358373146, 0.32350164799232056,
          1.6504654081337298, 4.364234719718165, -0.37130470760551165>
}

object
{
  BonsaiLeaf(0.004594488724213035)
  matrix <-0.11495266558719125, -0.9803520389574614, -0.16029898435843848,
          -0.8274175543326161, 0.005197980495349863, 0.5615631503054677,
          -0.5496963484112214, 0.19718737462301567, -0.811758008172788,
          1.748989849512232, 3.927313144397884, -0.2724914598209359>
}

object
{
  BonsaiLeaf(0.0037240564638126097)
  matrix <0.6336904031287585, -0.31841153227487534, 0.7050181338780428,
          -0.5945759004913711, -0.7835025113160429, 0.18056387600051252,
          0.4948898579859825, -0.5336083871865392, -0.6858178457774293,
          1.7475793566203675, 3.920264334020697, -0.2733667758251232>
}

object
{
  BonsaiLeaf(0.0024093210986209303)
  matrix <-0.8494704706535647, -0.4632876885160732, -0.25251621167173555,
          0.18298619606468897, -0.7075497203685504, 0.6825609461844133,
          -0.49488985798598245, 0.5336083871865392, 0.6858178457774293,
          1.7502344633487545, 3.9214774271427695, -0.2723946974059372>
}

object
{
  BonsaiLeaf(0.003173266947488148)
  matrix <0.15931046764068935, -0.9250644166002795, 0.34478399040571717,
          -0.9752290440849989, -0.09317784303441068, 0.20061455864546146,
          -0.1534551611160848, -0.3682033605325181, -0.9169938924657007,
          1.7417585218319331, 3.9020596140570287, -0.2737875990929766>
}

object
{
  BonsaiLeaf(0.0029457878330568835)
  matrix <-0.7647956022462884, -0.3433640258853839, 0.545150284336822,
          0.4424201422815727, -0.894997268812767, 0.056958814254170737,
          0.4683504078019891, 0.2847473170118897, 0.8364011363970287,
          1.7454328168318063, 3.895068079341994, -0.2722678892048498>
}

object
{
  BonsaiLeaf(0.0026919068626385266)
  matrix <0.8116286334607697, -0.5127418489960787, -0.2799191984031918,
          -0.3491516244532057, -0.8099473820826962, 0.47125192986244013,
          -0.46835040780198994, -0.2847473170118894, -0.8364011363970284,
          1.743189657305607, 3.895524248490877, -0.27116711148283673>
}

object
{
  BonsaiLeaf(0.0030905983492272716)
  matrix <-0.5485392626675398, -0.7018417022726379, 0.4544479092956618,
          0.37367407651205736, -0.6919955984533344, -0.617664776609508,
          0.7479788512083834, -0.1689979783081985, 0.6418468052991533,
          1.7355369553634057, 3.943731809740868, -0.29017798975582293>
}

object
{
  BonsaiLeaf(0.0028603602702368842)
  matrix <0.40051982105918393, -0.6561961822064235, -0.6395236065982507,
          -0.5292556197941656, -0.7354225001898274, 0.423133826502724,
          -0.7479788512083834, 0.1689979783081985, -0.6418468052991533,
          1.7328682171317296, 3.943766916893739, -0.2870587208305361>
}

object
{
  BonsaiLeaf(0.0047087255285306944)
  matrix <0.009822478845638756, -0.9335113326218843, -0.3584133239373799,
          -0.04906171531291259, -0.35844884278878936, 0.9322592853889593,
          -0.9987474490580097, 0.008427275353987143, -0.04932052341800924,
          1.7341846022686291, 3.9555679127789922, -0.2814276687722258>
}

object
{
  BonsaiLeaf(0.0028302355186707075)
  matrix <-0.5401808429952485, 0.8412322889904588, 0.023084471421643868,
          -0.8296211242937391, -0.5369261697328886, 0.1530982638097557,
          0.14118585972587744, 0.06354938407131239, 0.9879413083769814,
          1.6921468137974292, 3.9602787233087104, -0.2912531448495553>
}

object
{
  BonsaiLeaf(0.004440313682194438)
  matrix <-0.2751260600572645, -0.9561072332436162, 0.10081968863572245,
          -0.9509848600744553, 0.28604271415890775, 0.11750473005702469,
          -0.1411858597258779, -0.0635493840713115, -0.9879413083769812,
          1.6902721658846964, 3.9630684702025643, -0.2911646911330417>
}

object
{
  BonsaiLeaf(0.004905608040156238)
  matrix <0.7338740279480083, -0.36977019595371724, -0.5698235808456111,
          0.1460003601469087, -0.7333898979501099, 0.6639451426297958,
          -0.6634099832986678, -0.5704465441819035, -0.4842292166841903,
          1.8084100224788953, 4.007076049499775, -0.28118041589750853>
}

object
{
  BonsaiLeaf(0.004361078591570604)
  matrix <0.6935758579607092, -0.10727598627895185, 0.7123513122202725,
          -0.0363424722366702, -0.9928013816043636, -0.11412555102251765,
          0.7194662980055375, 0.053266119178560424, -0.6924817445838279,
          1.8102494082973541, 4.001134194910204, -0.28251606774722415>
}

object
{
  BonsaiLeaf(0.0032416051597169092)
  matrix <-0.41923751670765685, -0.7616088468912525, -0.49415773688345027,
          0.5537220878915741, -0.6458441645510407, 0.525620742072042,
          -0.7194662980055375, -0.05326611917856037, 0.6924817445838279,
          1.812202849052149, 4.003370307985019, -0.2803145023403537>
}

object
{
  BonsaiLeaf(0.003578223089996806)
  matrix <-0.5287431542042056, -0.14387967885617792, 0.836498245601526,
          0.012577285186577719, -0.986747848404425, -0.16177297539012206,
          0.8486886877881215, -0.0750154762797704, 0.5235457855230967,
          1.73522593339008, 3.9835158578135466, -0.026736028830779725>
}

object
{
  BonsaiLeaf(0.003441437149937897)
  matrix <0.24538040879508163, -0.8210574614682351, -0.5154154634340102,
          -0.46852531009544723, -0.5658951522021164, 0.678414851336635,
          -0.8486886877881217, 0.07501547627977054, -0.5235457855230963,
          1.7335685286499671, 3.985099169148954, -0.023822446962441814>
}

object
{
  BonsaiLeaf(0.003957336414407481)
  matrix <0.8813336275164808, -0.3413785949489628, -0.3266675556576031,
          -0.1213189368901671, 0.5046917796646077, -0.8547326617667134,
          0.45665386515443085, 0.7929355979205643, 0.40338614873328965,
          1.7309196583426496, 4.014485442143056, -0.09129417787899229>
}

object
{
  BonsaiLeaf(0.003029708160855331)
  matrix <-0.7491913857223262, 0.5872797852139464, -0.3062918892796896,
          0.4797702731505775, 0.1623440526456627, -0.8622441032396814,
          -0.45665386515443074, -0.7929355979205643, -0.4033861487332896,
          1.7328533221012623, 4.012980062086505, -0.09052406118823408>
}

object
{
  BonsaiLeaf(0.0036483109276602816)
  matrix <0.3143518287187686, -0.20915244091988955, 0.9259795808971266,
          0.4232925979109341, -0.8422077821548698, -0.3339302745059021,
          0.8497095411580232, 0.49693189486591355, -0.17621687640516825,
          1.7382958984207495, 4.005607157700593, -0.024199938109625972>
}

object
{
  BonsaiLeaf(0.0028504253339508004)
  matrix <-0.04269022080058413, -0.2682781604005671, -0.9623951234810392,
          0.5255199717546601, -0.8252790561483189, 0.20674438026200656,
          -0.8497095411580233, -0.4969318948659135, 0.17621687640516753,
          1.73824955085118, 4.006327397226365, -0.022392347220918714>
}

object
{
  BonsaiLeaf(0.004993369612181684)
  matrix <0.7271145632125444, 0.645606498194544, -0.23344520010745431,
          -0.45740640948541106, 0.2020138612069842, -0.8660079540292397,
          -0.511941196355495, 0.7364663260253138, 0.44219177073401117,
          1.7341757842792056, 4.066722714155842, -0.07285776935487968>
}

object
{
  BonsaiLeaf(0.003653508777559172)
  matrix <-0.8534822850450396, -0.3777157605060878, -0.3590247810104563,
          0.09738686045048273, 0.5612024188259392, -0.8219292211106218,
          0.5119411963554958, -0.7364663260253135, -0.44219177073401106,
          1.7368155872942221, 4.06776434224322, -0.07153639717718248>
}

object
{
  BonsaiLeaf(0.004879196923881972)
  matrix <0.7613759705209138, -0.21400737372631187, 0.611970158998054,
          0.5943757405988117, -0.14652498109193945, -0.7907261908547233,
          0.2588901514174509, 0.9657801374571614, 0.015640191567748984,
          1.7463100032598668, 4.053834395398342, -0.0659228208359944>
}

object
{
  BonsaiLeaf(0.003913857889429095)
  matrix <-0.508241959089538, 0.14997469780372752, -0.8480552464547986,
          0.8213805454963476, -0.21160414956211773, -0.5296769613341841,
          -0.25889015141745086, -0.9657801374571615, -0.015640191567748873,
          1.7466246937029215, 4.053721131065157, -0.06413779239190975>
}

object
{
  BonsaiLeaf(0.0039431052389102906)
  matrix <0.8781438340034092, 0.4751118252904396, 0.05596570620460434,
          -0.16269336955763272, 0.40660215288658896, -0.8990025343512524,
          -0.44988251166696486, 0.7803482829718905, 0.43435271722304847,
          1.7375225451838034, 4.096057547614845, -0.05669326974727912>
}

object
{
  BonsaiLeaf(0.00306574460762537)
  matrix <0.019416056098701395, 0.9322484110325282, 0.3612975462038164,
          0.8982134174594713, 0.14245231559303873, -0.41583649969424175,
          -0.4391305881641019, 0.3325962085014019, -0.8345921690437446,
          1.7535147244732572, 4.103729220675464, -0.05995630667784178>
}

object
{
  BonsaiLeaf(0.0027532920073504536)
  matrix <0.8193607225796377, -0.23278992843095742, -0.5238863001786589,
          0.3685272484259804, 0.9138865418155593, 0.17029109153439134,
          0.4391305881641021, -0.33259620850140215, 0.8345921690437444,
          1.751775694659766, 4.105808694768297, -0.05821259707000572>
}

object
{
  BonsaiLeaf(0.002516663106681966)
  matrix <0.43563895974895006, 0.03025129474856142, 0.8996130034158517,
          0.6856153696826788, 0.6364212991202449, -0.3534112263086493,
          -0.5832240235138944, 0.7707482009010046, 0.256509160078404,
          1.7883398536993662, 4.085153295230676, -0.06878157222306844>
}

object
{
  BonsaiLeaf(0.003360531011438438)
  matrix <-0.12129556161931701, 0.22960471840384833, -0.9656961530513337,
          0.8032042860491458, 0.5943306185066979, 0.040422651789901856,
          0.5832240235138944, -0.7707482009010045, -0.2565091600784039,
          1.7893135837049001, 4.085548903701413, -0.06775631365342569>
}

object
{
  BonsaiLeaf(0.004974301017077667)
  matrix <-0.883590024647242, 0.022054749066721197, 0.46774165560434144,
          -0.24989360106217254, 0.8225497516789212, -0.5108474274782296,
          -0.3960073944916509, -0.5682653377222203, -0.7212854146947553,
          1.7291727495171243, 4.0916832326344865, -0.05959790364401449>
}

object
{
  BonsaiLeaf(0.0024914469988732636)
  matrix <0.7094238978456264, -0.6961252309293939, -0.11012445699759896,
          0.7003787443122481, 0.7137713976073463, -8.045653283200033E-5,
          0.07865969540442418, -0.07707175112291739, 0.9939178021837272,
          0.8532054723514344, 4.010707678006736, 0.1661577498737388>
}

object
{
  BonsaiLeaf(0.002373779261994296)
  matrix <0.27235452679574396, 0.9607392394860201, 0.052944550670389896,
          0.9589763626141937, -0.26653341045855783, -0.09656229624744977,
          -0.07865969540442412, 0.0770717511229177, -0.9939178021837273,
          0.8537369140331593, 4.00829666291791, 0.16592873275060332>
}

object
{
  BonsaiLeaf(0.002515070483157486)
  matrix <0.5645719638337847, -0.2288784103302176, 0.7930152400411841,
          0.7713702204170403, -0.19554334836519793, -0.6055995227573195,
          0.2936775114077179, 0.9536128523645426, 0.06615169762394824,
          0.8897062898946355, 4.02821896202798, 0.16645968809029144>
}

object
{
  BonsaiLeaf(0.0029239213801068834)
  matrix <0.19893442247975285, 0.006717004437306648, -0.9799897843365697,
          0.9349751947757848, -0.3009608108318254, 0.18773378890714779,
          -0.2936775114077179, -0.9536128523645426, -0.06615169762394812,
          0.8905000333835525, 4.027830781582265, 0.16853173241374672>
}

object
{
  BonsaiLeaf(0.00446619374430784)
  matrix <0.7047648046811201, 0.491174683927876, -0.5119121017822621,
          0.3568395978203116, 0.3782234851165996, 0.8541735752958483,
          0.6131656150749327, -0.7846619814764852, 0.09128802394167096,
          0.8564540776189428, 4.024264849506046, 0.1773212278182795>
}

object
{
  BonsaiLeaf(0.002808555361983487)
  matrix <0.3981899789682093, -0.7360914683097735, 0.5473701589700146,
          -0.21060874743378866, 0.5074139457857282, 0.8355686944390205,
          -0.892798239331635, -0.447996024428476, 0.04701984626317521,
          0.8292258692217059, 4.058930907398796, 0.20230224418476248>
}

object
{
  BonsaiLeaf(0.0036564983383536504)
  matrix <-0.43315183301452415, 0.8251560096031543, -0.3626252188857759,
          -0.12365594770365776, 0.3441178895554249, 0.9307481317120284,
          0.8927982393316353, 0.4479960244284756, -0.047019846263174986,
          0.8293652277812857, 4.058764073731972, 0.20335878224472104>
}

object
{
  BonsaiLeaf(0.004039790979621254)
  matrix <0.3793302324067753, -0.13720899780070184, 0.915031292199753,
          -0.30098670030984065, 0.916857484771049, 0.26225819120839583,
          -0.8749374726337967, -0.37489470994111446, 0.30649367928123983,
          0.8302649336863368, 4.054108758355142, 0.1920607937152612>
}

object
{
  BonsaiLeaf(0.0038044975878349296)
  matrix <-0.03212760712715912, 0.97597624331361, 0.21549521885122047,
          0.725983787422563, -0.1254024513216394, 0.6761817548574609,
          0.686960957595025, 0.17817013691967656, -0.7045140488664154,
          0.8428298302523823, 4.0469065463574605, 0.197945806386764>
}

object
{
  BonsaiLeaf(0.0034117164661207284)
  matrix <0.664776351553489, -0.5456673508289074, 0.5102151944568041,
          0.29352520361181644, 0.8188421975871695, 0.49329545943101527,
          -0.6869609575950251, -0.17817013691967648, 0.7045140488664154,
          0.8410692514547098, 4.050177297089684, 0.1970562587730742>
}

object
{
  BonsaiLeaf(0.0045506569745240215)
  matrix <0.40268206203957774, 0.6817680376801131, -0.6107695962548904,
          -0.511685899063693, 0.7209280851102341, 0.46737590523974465,
          0.7589629092458563, 0.12431829671089761, 0.6391558992076717,
          0.7746542878856552, 4.0691791276031495, 0.09421020204979896>
}

object
{
  BonsaiLeaf(0.0041983453106677225)
  matrix <-0.5594578909415745, -0.37771491168297466, 0.7377928664303606,
          -0.33313986650095107, 0.9175382316804155, 0.2171207561531242,
          -0.7589629092458563, -0.12431829671089761, -0.6391558992076717,
          0.7755841586946742, 4.069750573516846, 0.09299488253533934>
}

object
{
  BonsaiLeaf(0.0031321210661943797)
  matrix <0.6326273593588224, -0.38939740909329623, -0.669441768925507,
          0.07750588453171975, 0.8918958852193821, -0.44554973660826075,
          0.7705682721561015, 0.22998127689045234, 0.5944183293154731,
          0.796954215462152, 4.016894508006752, 0.11313860333509689>
}

object
{
  BonsaiLeaf(0.00363207020938695)
  matrix <-0.17263350024191337, 0.9730787613028768, -0.15269380765271365,
          0.6135325684432622, -0.015044486734207219, -0.7895260925886607,
          -0.7705682721561014, -0.2299812768904524, -0.5944183293154731,
          0.7989398510127875, 4.014046339483722, 0.11166650485074002>
}

object
{
  BonsaiLeaf(0.0024367708951125427)
  matrix <-0.3474274212820952, -0.4018610545384297, 0.8472318925692862,
          0.7612017920956279, -0.6484991281810911, 0.004551094238549467,
          0.5476002361683912, 0.6464956098796225, 0.5312037346957357,
          0.9750939913010619, 3.836560054813507, 0.08159555031573591>
}

object
{
  BonsaiLeaf(0.002173086553912078)
  matrix <0.6238175805477946, 0.10767496529378748, -0.7741173864786125,
          0.5576608355872033, -0.7552810922135916, 0.3443324907655755,
          -0.5476002361683912, -0.6464956098796224, -0.5312037346957357,
          0.9744509621922337, 3.8364990074286514, 0.08233272464751222>
}

object
{
  BonsaiLeaf(0.00392611074565326)
  matrix <-0.1775595835223831, -0.8631591201875576, 0.4726826922327474,
          0.5381424596295753, 0.3169782700396418, 0.7809785332942942,
          -0.8239388857452891, 0.3930408497341164, 0.4082200423755486,
          0.9779244104510714, 3.8349930851695517, 0.10858924696230346>
}

object
{
  BonsaiLeaf(0.003887460469326037)
  matrix <0.5612053376229009, 0.6658335296152428, 0.4916444648968128,
          0.07857023342447697, -0.6341802592957229, 0.7691827592576628,
          0.8239388857452891, -0.39304084973411635, -0.4082200423755486,
          0.9761170422341308, 3.8312832426889716, 0.1085132063209135>
}

object
{
  BonsaiLeaf(0.0048341466204260795)
  matrix <0.909291388111152, 0.07147826764385187, -0.4099756441077058,
          -0.3667282444863118, -0.32805691158867095, -0.8705682382529764,
          -0.19672205316863267, 0.9419498500522924, -0.2720862249059674,
          0.968567292508067, 3.84275700280377, 0.04516729769781879>
}

object
{
  BonsaiLeaf(0.003920034178031349)
  matrix <-0.8916312366559737, -0.2872940182527327, -0.3499369727472899,
          0.407791823871515, -0.17376025743150056, -0.8963889788037791,
          0.19672205316863192, -0.9419498500522925, 0.2720862249059673,
          0.9719386684988633, 3.8436617318663187, 0.04586187677089827>
}

object
{
  BonsaiLeaf(0.004076146006880236)
  matrix <0.26962809236357066, -0.7595034625868848, 0.5919925524252099,
          0.41890426134374315, -0.4610344522057679, -0.7822828476372097,
          0.8670754936200397, 0.4589136347918421, 0.19385139712084953,
          0.9716068067719258, 3.890801429611044, 0.015377851736070975>
}

object
{
  BonsaiLeaf(0.0029548552049720395)
  matrix <0.4261157401087101, -0.4816166289997557, -0.7658138146459095,
          0.25808034484472364, -0.7466215229104045, 0.613148299460887,
          -0.8670754936200397, -0.4589136347918421, -0.19385139712084926,
          0.9706618818900499, 3.8904745148593203, 0.020378315285800044>
}

object
{
  BonsaiLeaf(0.004631828134634018)
  matrix <0.5949770928371291, -0.8030750213849562, -0.03275315292655551,
          0.5617461241124291, 0.38634651063218917, 0.7315583816531643,
          -0.5748421966450813, -0.4536594358655882, 0.6809916043582145,
          0.9696098109052878, 3.8995380582121792, 0.022890409567533618>
}

object
{
  BonsaiLeaf(0.004349787539509373)
  matrix <0.6978961628555227, 0.6783679234792007, 0.22969089286703387,
          0.5135274079845015, -0.2504204398138288, -0.8207187122103218,
          -0.49922995414964566, 0.6907290088869625, -0.5231279854507664,
          0.9519371568940521, 3.8977525090656275, -0.025686988127107995>
}

object
{
  BonsaiLeaf(0.0042901264754024926)
  matrix <-0.44220920967157096, -0.7223084595383176, -0.531715623393772,
          0.7451311748688196, 0.03411635328425852, -0.6660447482543472,
          0.49922995414964544, -0.6907290088869629, 0.5231279854507662,
          0.9529001287545571, 3.898988148244837, -0.02497445230758212>
}

object
{
  BonsaiLeaf(0.003988113803496306)
  matrix <-0.6552965566824414, -0.1506696170888664, -0.7401926028314731,
          0.07931655761989805, 0.9607632700694931, -0.2657871753352742,
          0.7511959175125122, -0.23287895003986214, -0.6176342672981046,
          0.9232111268373878, 3.9744204210910854, -0.08537745830605571>
}

object
{
  BonsaiLeaf(0.0038080164241033883)
  matrix <0.5815505062357652, 0.6761345967290686, 0.45237265147546757,
          -0.31225582814330205, 0.6990060097984502, -0.6433404200391812,
          -0.7511959175125125, 0.23287895003986203, 0.6176342672981043,
          0.9217057280570065, 3.9732506141976884, -0.08676731968910759>
}

object
{
  BonsaiLeaf(0.004360085538727663)
  matrix <0.588090447312462, 0.10294436526490612, -0.802216980274062,
          -0.7887416221486748, -0.14650374719101691, -0.5970119810768191,
          -0.17898681311790932, 0.9838389653389399, -0.004960948568409396,
          0.9063525938000501, 3.9444082000145704, -0.07377994984838941>
}

object
{
  BonsaiLeaf(0.003071888148477328)
  matrix <0.037507169443039466, 0.8925187422992337, -0.4494480024262711,
          0.10786150075027015, -0.45075265289150496, -0.8861083131125509,
          -0.9934581565905384, -0.015242721406110327, -0.11317486712104026,
          0.9108130166370606, 3.9437572450732095, -0.07996952253317627>
}

object
{
  BonsaiLeaf(0.0047555344893678575)
  matrix <0.036711497988286976, -0.9810737232807316, -0.19012263253894426,
          0.10813490194745358, 0.19303369895491865, -0.9752152757461285,
          0.9934581565905384, 0.015242721406110216, 0.11317486712104026,
          0.9109959174269443, 3.9460598852185123, -0.08188516678622768>
}

object
{
  BonsaiLeaf(0.003204733502781227)
  matrix <0.3056634896358778, 0.860392659405159, 0.4077919846506741,
          -0.9412805185841822, 0.20856030476325177, 0.2655062797956999,
          0.14339043356343661, -0.465002226789053, 0.8736201191843693,
          0.7098455437235824, 3.955982569807263, 0.24932319007138795>
}

object
{
  BonsaiLeaf(0.004550589517141145)
  matrix <-0.9111368493243632, 0.28258437415677307, 0.29995951941169874,
          0.3863532391034942, 0.8389988084399447, 0.38316076791679876,
          -0.1433904335634365, 0.465002226789053, -0.8736201191843693,
          0.7146202319367823, 3.9591321287938186, 0.2502159205751898>
}

object
{
  BonsaiLeaf(0.002703162365086499)
  matrix <0.06388217247187022, 0.9771309889066855, 0.2028154297841197,
          -0.8084771661938067, -0.06847047607597123, 0.5845309792039779,
          0.5850502027890473, -0.20131275276090405, 0.7856140501495127,
          0.6919984839409041, 3.965140967634435, 0.25164450478195044>
}

object
{
  BonsaiLeaf(0.004129819632474878)
  matrix <-0.8067208859269833, -0.24380657271223294, 0.5382933840495326,
          -0.08317254610553526, 0.9486999160314826, 0.30504228706227077,
          -0.5850502027890473, 0.20131275276090405, -0.7856140501495127,
          0.6938404413758015, 3.969244013987037, 0.2513241922635839>
}

object
{
  BonsaiLeaf(0.0037508227565764287)
  matrix <0.29141235739116844, 0.6067833683924276, 0.739521995482258,
          -0.9417285735743567, 0.31774831840284656, 0.11037798632775803,
          -0.16800634414607457, -0.728594503132231, 0.6640210225076973,
          0.715860401920164, 3.9602983987192264, 0.25413411224737065>
}

object
{
  BonsaiLeaf(0.003374085275544122)
  matrix <-0.9828309156750161, 0.07168471764302503, -0.17001380076290562,
          -0.07627096118497456, 0.6811837866992556, 0.7281286900115823,
          0.16800634414607468, 0.728594503132231, -0.6640210225076972,
          0.7191353141573591, 3.9614049532803386, 0.2561768722760967>
}

object
{
  BonsaiLeaf(0.002770590016221055)
  matrix <0.3715439713636996, -0.7895309559635351, -0.4884628408779894,
          0.12277194344259051, -0.47972243912903245, 0.8687884847875349,
          -0.9202619883742995, -0.3827626561870914, -0.08130573031455221,
          0.7649421522177776, 3.963829005101036, 0.2771609266525594>
}

object
{
  BonsaiLeaf(0.002534899874585407)
  matrix <0.051013642088310746, -0.32336380880284105, 0.944898648256735,
          0.3879632470663503, -0.8654066074309356, -0.3171055388046885,
          0.9202619883742995, 0.3827626561870913, 0.0813057303145521,
          0.7655854494833357, 3.9629644002008018, 0.2739500391598529>
}

object
{
  BonsaiLeaf(0.004356789025536521)
  matrix <0.841942226048226, -0.47585452303988096, 0.25435361389106576,
          0.37471919219478045, 0.8548481008723169, 0.35891538199955114,
          -0.38822521169786084, -0.20687483495456832, 0.8980445354572737,
          0.756675532773578, 3.9788136590758603, 0.2718640770074273>
}

object
{
  BonsaiLeaf(0.004052283447509806)
  matrix <0.6511859465873585, 0.7245020976958847, 0.22595037818376867,
          -0.10041082533930021, 0.37735937332095226, -0.9206071743808534,
          -0.7522463221058682, 0.5767985903251504, 0.318478974309315,
          0.7571673815344568, 3.920647296005399, 0.1539043086806538>
}

object
{
  BonsaiLeaf(0.003245805809015261)
  matrix <-0.5696935954490615, -0.32655044199392014, -0.7541975975418488,
          0.331020661262276, 0.7487778008411405, -0.5742448317442576,
          0.7522463221058684, -0.5767985903251502, -0.3184789743093149,
          0.7586487034451592, 3.9215485161987598, 0.15577098268438358>
}

object
{
  BonsaiLeaf(0.0029789307268324643)
  matrix <0.32326448634465266, 0.8765206133958885, -0.35666747280965083,
          -0.6328360648980345, -0.07998848845649406, -0.770143075459889,
          -0.7035755729363391, 0.47467194567041837, 0.5288364181490921,
          0.7449131596027198, 3.9108947940359364, 0.14542843379386342>
}

object
{
  BonsaiLeaf(0.002549567838019851)
  matrix <-0.6164646650445268, -0.777881637881407, -0.12194865394287407,
          -0.35348653428219967, 0.4118090594443003, -0.8399170010428176,
          0.7035755729363392, -0.47467194567041826, -0.5288364181490921,
          0.7458970965025132, 3.912183009335357, 0.14558121129294327>
}

object
{
  BonsaiLeaf(0.00334722797323167)
  matrix <-0.6054446838811367, -0.043967385376508204, -0.7946720101923962,
          0.7941066589813321, -0.10012650829085452, -0.5994741833465282,
          -0.053210421174574446, -0.9940027924310046, 0.09553585566576203,
          0.7602011369427369, 3.9100757999905, 0.16300625378807607>
}

object
{
  BonsaiLeaf(0.004297451386063228)
  matrix <-0.47384771867771397, 0.8804681948576315, 0.015623615076840125,
          -0.0842480175916448, -0.027665578782731792, -0.9960606845380929,
          -0.8765675165301318, -0.47329734163077625, 0.08728697136134572,
          0.7271851483434761, 3.8861938489813452, 0.08508095661676487>
}

object
{
  BonsaiLeaf(0.0038896796130570613)
  matrix <0.0030590502952894116, -0.18684010630279685, -0.9823855744503022,
          -0.4812691878517538, 0.8608602680354107, -0.1652258083427442,
          0.8765675165301319, 0.47329734163077597, -0.08728697136134597,
          0.7256752171550689, 3.8896612110954996, 0.08871880352787455>
}

object
{
  BonsaiLeaf(0.003495574120414849)
  matrix <0.9747128074205054, 0.1855960721395624, -0.12445497602266431,
          -0.1187158527552506, -0.0417661316149996, -0.9920494627560221,
          -0.18931848656438494, 0.9817380955510913, -0.01867678742947773,
          0.7327458097893959, 3.882905406551062, 0.07672373072790127>
}

object
{
  BonsaiLeaf(0.004382130585949288)
  matrix <-0.5499719672843311, -0.12177555072414101, -0.8262575569683064,
          0.8134428964877447, 0.14615412067248498, -0.562982794731846,
          0.189318486564385, -0.9817380955510913, 0.01867678742947776,
          0.7367254028485922, 3.883691869602307, 0.07772444903192505>
}

object
{
  BonsaiLeaf(0.004660736713239297)
  matrix <0.4908174635844164, -0.8697054496037767, -0.05206388738898057,
          -0.7972989272280047, -0.424253646190294, -0.42932885336920135,
          0.3513013493877193, 0.25223258041683144, -0.9016463205130018,
          0.7223595516798734, 3.8663670061808006, 0.14724263792131756>
}

object
{
  BonsaiLeaf(0.003158398745003421)
  matrix <-0.9005760250553209, 0.3543812893632612, -0.2517473432725561,
          -0.25602770360631893, -0.9004402407297771, -0.35164923981230994,
          -0.35130134938771934, -0.25223258041683144, 0.9016463205130018,
          0.725266914483675, 3.865500391399054, 0.14813297815256374>
}

object
{
  BonsaiLeaf(0.0036218245847651114)
  matrix <0.6151198438007822, 0.7308492735064771, 0.2957818743222026,
          -0.74428103507299, 0.6620425093093488, -0.08800827630432825,
          -0.26014095908406876, -0.16600920240286374, 0.9511927386835888,
          0.8858972959753721, 3.8652468160398974, 0.40590096158238015>
}

object
{
  BonsaiLeaf(0.0037823281553159343)
  matrix <-0.8529874620302131, -0.4221264132290713, -0.30695550308410197,
          -0.4524810173102025, 0.8912071790397134, 0.03179139823914989,
          0.26014095908406887, 0.16600920240286388, -0.9511927386835887,
          0.8868815196346556, 3.866219852209023, 0.4063399576218188>
}

object
{
  BonsaiLeaf(0.002633344038025745)
  matrix <0.08821783621739768, 0.6782262367665769, 0.7295387482064039,
          0.4597094550822681, -0.677453909652413, 0.5742154797675034,
          0.8836768811511841, 0.28471981325174167, -0.3715505317730127,
          0.8908671038480519, 3.8593408645549103, 0.4591804570924927>
}

object
{
  BonsaiLeaf(0.0046797906368754565)
  matrix <0.467542338132125, -0.49821557480076845, 0.730195455395256,
          -0.02278885194258498, 0.8189724470138371, 0.5733801524811489,
          -0.8836768811511841, -0.28471981325174145, 0.37155053177301267,
          0.8895498836393408, 3.864957453358325, 0.4603516492512564>
}

object
{
  BonsaiLeaf(0.0036468809128625797)
  matrix <-0.17033394707674096, 0.9685627766118075, -0.18130773352310042,
          -0.439659506511316, 0.08996450316287274, 0.8936475292333567,
          0.8818649923925335, 0.23193217959714602, 0.4105138234698475,
          0.8799520976081345, 3.8707764387653794, 0.4461515780734371>
}

object
{
  BonsaiLeaf(0.0037819493777917442)
  matrix <-0.397631079385197, -0.1020590872093215, 0.9118516696398394,
          -0.25338441131900585, 0.967363120438916, -0.002221106751937374,
          -0.8818649923925334, -0.23193217959714552, -0.41051382346984777,
          0.8805971964538591, 3.874106867287402, 0.44288415184295066>
}

object
{
  BonsaiLeaf(0.00291906604195364)
  matrix <0.12878877178329845, 0.8519974446619503, 0.5074581820722333,
          -0.8318340843274579, 0.3713997010826702, -0.41244917042806983,
          -0.5398754563912391, -0.3690021901360611, 0.756552625572829,
          0.9044215725796145, 3.886160286566267, 0.36465313106938707>
}

object
{
  BonsaiLeaf(0.002579890413930991)
  matrix <-0.7105314357557395, -0.28211770506030875, -0.6446353072043074,
          -0.4513087306813798, 0.8855772039558688, 0.10987923117890441,
          0.5398754563912391, 0.36900219013606117, -0.7565526255728289,
          0.9056854241397061, 3.8873608384501264, 0.36614057381202414>
}

object
{
  BonsaiLeaf(0.00468080727711529)
  matrix <-0.05619309542280815, 0.16763077432655127, -0.9842470520786354,
          0.9522448578410723, -0.2873297485310362, -0.10330220870982004,
          -0.30012008720183797, -0.9430490650585325, -0.1434795948913595,
          0.9232528279052787, 3.8787563789652553, 0.3514980143321825>
}

object
{
  BonsaiLeaf(0.004017601484957517)
  matrix <-0.002676480290972172, -0.39641885426168233, -0.918065862800217,
          0.6823218756206868, 0.6704301353733588, -0.29147948749908154,
          0.7310469851539775, -0.6271965605526825, 0.26869086312743473,
          0.9376919776585266, 3.888445275350642, 0.33037831923581806>
}

object
{
  BonsaiLeaf(0.0022676125087865047)
  matrix <0.6043381423011813, 0.7779908390528212, 0.17177212844301698,
          0.3167739182086131, -0.03680664044398535, -0.9477866616290765,
          -0.7310469851539776, 0.6271965605526824, -0.2686908631274349,
          0.935669000777201, 3.885668291044929, 0.32940015476805795>
}

object
{
  BonsaiLeaf(0.004843623596750076)
  matrix <0.2527883649830375, 0.9521954402516193, -0.17152809126562119,
          0.9652040031252882, -0.26045169511083577, -0.023369785296630072,
          -0.06692738512836774, -0.15965199052287748, -0.984902008852638,
          0.9516551947685804, 3.779259316645459, 0.35351174027642546>
}

object
{
  BonsaiLeaf(0.004692440625640548)
  matrix <0.9561924701157066, -0.2922085904955437, -0.017609648907088424,
          0.28498541228263297, 0.9429344524211056, -0.17221478805087256,
          0.06692738512836767, 0.1596519905228776, 0.984902008852638,
          0.948317387009675, 3.7849455105535683, 0.3528168270521532>
}

object
{
  BonsaiLeaf(0.0038044832158478955)
  matrix <-0.3622767347992986, -0.7997229661330959, 0.4787470572885447,
          0.22289425173291894, 0.4244022552572064, 0.8776108922962491,
          -0.9050269167088789, 0.42464797558905154, 0.024502588853827598,
          0.9477516365092774, 3.7840492164248594, 0.38260965062012003>
}

object
{
  BonsaiLeaf(0.0031235510033916832)
  matrix <-0.5082099717288876, -0.38803766454066685, 0.7688624035112834,
          0.8144617359311649, 0.07365439609109595, 0.5755233363126546,
          -0.27995482731918775, 0.9186957063327772, 0.2786099313133024,
          0.9488144929600736, 3.7727110393751735, 0.40621170713024357>
}

object
{
  BonsaiLeaf(0.0035987791040203573)
  matrix <0.8344308552742399, 0.08935393980644998, 0.5438207620230817,
          -0.4747109040531762, -0.38472597079841697, 0.7916031107608353,
          0.27995482731918764, -0.9186957063327772, -0.27860993131330236,
          0.9445621005056245, 3.7710964323278753, 0.40726283536931246>
}

object
{
  BonsaiLeaf(0.002170216537194458)
  matrix <-0.11851799795949414, 0.22117975113248123, -0.9680046497040429,
          0.22022408890407807, 0.9564516134459651, 0.19157677782805266,
          0.9682225130753992, -0.19047264587227297, -0.16206583954792553,
          0.8331828494433849, 4.063234858729248, 0.2616717317032453>
}

object
{
  BonsaiLeaf(0.003190743899267209)
  matrix <0.24974592327906978, 0.7024010079653971, 0.6665281673077883,
          0.013120174520290281, 0.6858228599161814, -0.7276502359217284,
          -0.9682225130753992, 0.19047264587227294, 0.16206583954792542,
          0.8327467786005647, 4.063347436726977, 0.25893422306079283>
}

object
{
  BonsaiLeaf(0.003513465800126073)
  matrix <0.9738596932841689, 0.03504810208968118, 0.22443023044227967,
          0.15470425199523136, -0.8257920218996779, -0.5423413417594476,
          0.16632465905890087, 0.5628846836668707, -0.8096276555813708,
          0.8318809447077994, 4.035180805181445, 0.27391566821455354>
}

object
{
  BonsaiLeaf(0.004397909615799689)
  matrix <-0.034490051157847756, -0.8172409370104095, -0.5752631460866204,
          0.9854676778870368, -0.12360454590181819, 0.11651339868159324,
          -0.16632465905890065, -0.5628846836668706, 0.8096276555813711,
          0.8356713943859193, 4.037538595587428, 0.2763335813672511>
}

object
{
  BonsaiLeaf(0.002439447672008233)
  matrix <-0.2701008406204761, 0.4638126990028458, -0.843755483620585,
          -0.08873635302121023, 0.8606057755414617, 0.5014813643169351,
          0.9587342674321214, 0.2103223225156451, -0.19129329602214884,
          0.7797128802742934, 4.107034150649856, 0.31618841573019346>
}

object
{
  BonsaiLeaf(0.0036266559971872775)
  matrix <0.2065825364582877, -0.05309266840587712, 0.9769876274508306,
          -0.19532603534053794, 0.9761893715940412, 0.09435067940920534,
          -0.9587342674321213, -0.21032232251564514, 0.19129329602214912,
          0.779220967626619, 4.108475050933077, 0.31530725564077305>
}

object
{
  BonsaiLeaf(0.004658863382765616)
  matrix <0.3426881636253748, 0.9369275734486844, 0.06878622407595872,
          -0.8465686975383949, 0.2762348411024753, 0.45498983824832384,
          0.4072913734161496, -0.21415189626209324, 0.887835965969016,
          0.7896852982091757, 4.054942366213242, 0.3040670402931748>
}

object
{
  BonsaiLeaf(0.0028520562460455593)
  matrix <-0.07664308692893779, 0.5884800787357714, -0.8048708183038711,
          0.9970128304980093, 0.05296798843876033, -0.05621216970637788,
          0.00955264614389778, -0.8067748069516618, -0.590781819134406,
          0.8237127772484828, 4.025126726773865, 0.15863549901098>
}

object
{
  BonsaiLeaf(0.0026731629999259044)
  matrix <0.9986875139298355, -0.022032810735487962, 0.04623640093841802,
          0.0503189474481876, 0.5904481062034174, -0.8055054546112669,
          -0.009552646143898239, 0.8067748069516619, 0.5907818191344058,
          0.821003751326387, 4.026554023122477, 0.15664257190318953>
}

object
{
  BonsaiLeaf(0.004022741291350556)
  matrix <-0.6659913485292775, 0.36346269216948296, -0.6514218257665805,
          0.7418071383323255, 0.4147046937653864, -0.527012510751085,
          0.07859830280203128, -0.8342151331460417, -0.5458089578110383,
          0.8203724134069018, 4.02391054898323, 0.16035219021650646>
}

object
{
  BonsaiLeaf(0.0035052634979787396)
  matrix <-0.871415754170536, 0.19821033585333311, -0.44871733434792144,
          0.46977668508573256, 0.07385264407264772, -0.8796906576253604,
          -0.1412248191121374, -0.9773732397218512, -0.15747095205896322,
          0.8097642571840797, 4.016247548724446, 0.15664916423026026>
}

object
{
  BonsaiLeaf(0.004080551277288218)
  matrix <0.8938394470183076, -0.057508751087781765, -0.4446839175215684,
          -0.42556620333474465, 0.20355415452389014, -0.8817364190932085,
          0.14122481911213708, 0.9773732397218513, 0.1574709520589632,
          0.806381021403059, 4.016819288912189, 0.156134741110785>
}

object
{
  BonsaiLeaf(0.004064832591102899)
  matrix <0.6298370720693154, 0.2520815560150099, -0.7346837086557745,
          -0.7369642183177793, -0.10481460630614718, -0.6677556732998615,
          -0.24533447284557533, 0.9620128831891692, 0.11975896213496967,
          0.7616355548022103, 3.992547394517966, 0.17258782488075433>
}

object
{
  BonsaiLeaf(0.00403724167054051)
  matrix <-0.6121425275459726, 0.05681897516053585, -0.7887034487253964,
          0.775322911308888, -0.15291495186918505, -0.6127735313265048,
          -0.1554217139563783, -0.9866045923046124, 0.04955269189771956,
          0.7724978363739303, 3.995739924340415, 0.1403568604633107>
}

object
{
  BonsaiLeaf(0.0029697502810370185)
  matrix <0.984115113859977, -0.15899628179206202, -0.07897863665994642,
          -0.08579937938718563, -0.03649055795336579, -0.9956439653194433,
          0.1554217139563782, 0.9866045923046124, -0.0495526918977196,
          0.7691128676772213, 3.9962489111114126, 0.13987396135276609>
}

object
{
  BonsaiLeaf(0.004945802663972419)
  matrix <0.6625793021958315, -0.20547517807594928, -0.7202559402714721,
          -0.22754877097366874, 0.8609583779161563, -0.45494200545163294,
          0.713589675605006, 0.46532851050697255, 0.5236975770225637,
          0.8475519042499318, 4.061724343047411, 0.18957915840102932>
}

object
{
  BonsaiLeaf(0.004919947604084763)
  matrix <-0.5055788719393444, 0.8595293256712897, -0.07482875489808549,
          0.4849533782937103, 0.2113734032947841, -0.8486115161020962,
          -0.7135896756050056, -0.465328510506973, -0.5236975770225638,
          0.8510632607792259, 4.058506158877451, 0.1876540875880997>
}

object
{
  BonsaiLeaf(0.004981387579081329)
  matrix <-2.476667982498626E-4, 0.004109840290274405, -0.9999915239010507,
          0.985930975550238, -0.16715036466403868, -9.311515637733248E-4,
          -0.16715277476522097, -0.985922849317058, -0.004010621251103463,
          0.9027694238223121, 4.024541965328963, 0.18484673130663515>
}

object
{
  BonsaiLeaf(0.0033236714432545167)
  matrix <0.7718177012954763, -0.05432274760539511, 0.6335191197269161,
          0.5922154131733819, -0.30128975150113096, -0.7473321818577516,
          0.23146995564618553, 0.9519839939478955, -0.2003699950096458,
          0.8661646305403414, 4.045457053751058, 0.18543552881244607>
}

object
{
  BonsaiLeaf(0.0043034715500644425)
  matrix <0.4644122491241982, 0.11687292356401137, 0.8778735572968376,
          0.8180834530103543, 0.32305219515446415, -0.47579065051400177,
          -0.3392060240827962, 0.939136837177353, 0.05441759166353288,
          0.8412879434820937, 4.0460072674001175, 0.21483746269981915>
}

object
{
  BonsaiLeaf(0.003959366314233121)
  matrix <0.6764389032484187, -0.31810247705306416, -0.6642599071634395,
          0.6981900024507203, 0.5640577080400162, 0.4408737035461585,
          0.23443790361189237, -0.7620037507081889, 0.6036465466286647,
          0.8546311892160063, 4.055044180409664, 0.22289904420823717>
}

object
{
  BonsaiLeaf(0.0028139682203403922)
  matrix <-0.5350296593418293, 0.41730879772602264, 0.7345724136972663,
          0.8116539490291578, 0.49518042292392067, 0.3098616074609106,
          -0.2344379036118923, 0.7620037507081889, -0.6036465466286648,
          0.8541507676578505, 4.054204291294609, 0.2220254044336839>
}

object
{
  BonsaiLeaf(0.002668566190020752)
  matrix <0.9426450276026705, 0.10205950141045955, -0.31781159530106495,
          0.029287851640668106, -0.9737273241293221, -0.2258258620933923,
          -0.3325095091606153, 0.20356560715356148, -0.9208683238671895,
          0.7122231450348808, 4.055893950906609, 0.20291323966440408>
}

object
{
  BonsaiLeaf(0.003989643108792149)
  matrix <-0.1137828458441153, -0.9779537414348207, -0.17509981040894837,
          0.9362109219131016, -0.04655666652411311, -0.3483411926441977,
          0.33250950916061545, -0.2035656071535613, 0.9208683238671896,
          0.7158801359172007, 4.058306662238313, 0.20212611388607743>
}

object
{
  BonsaiLeaf(0.0026757069817492127)
  matrix <-0.21904225781192832, 0.8374270254786558, -0.5007359247054509,
          -0.40040145643475816, -0.5451443604931379, -0.7365434813420393,
          -0.8897747821654514, 0.03916124641144979, 0.4547166522153384,
          0.6952124726748518, 4.066253649202707, 0.20872752698661406>
}

object
{
  BonsaiLeaf(0.0036459909433578758)
  matrix <-0.10299649649190133, -0.9878398602773303, -0.11646515426365844,
          -0.4446263135857083, 0.15046197933951883, -0.8829884676712467,
          0.8897747821654513, -0.039161246411449635, -0.4547166522153384,
          0.6946627261348247, 4.068260878788132, 0.207478933565784>
}

object
{
  BonsaiLeaf(0.004546699316408007)
  matrix <-0.776698205729375, -0.5559176284855103, 0.2961342390805475,
          -0.5558433015912938, 0.8260801159307468, 0.0928970728275839,
          -0.29627372697027815, -0.09245124338206145, -0.9506180338623134,
          0.7114631252334327, 4.148949000419887, 0.24276164460691266>
}

object
{
  BonsaiLeaf(0.002863166933472163)
  matrix <-0.48266838267437584, -0.851709108135549, 0.20401673334667636,
          -0.8216959338790797, 0.5210001202240757, 0.23102958029889853,
          -0.3030627403906465, -0.05612904636144713, -0.9513161964044681,
          0.7067537924225953, 4.145802819210194, 0.24460866670615672>
}

object
{
  BonsaiLeaf(0.003663655072258988)
  matrix <-0.3903554000991678, 0.9179844657678488, 0.07019389020659292,
          -0.869353574214962, -0.39262456719297484, 0.3001171641812558,
          0.30306274039064646, 0.05612904636144745, 0.9513161964044681,
          0.7059214334180873, 4.142872667906543, 0.2450467162220156>
}

object
{
  BonsaiLeaf(0.002512259626773422)
  matrix <0.12775230435936763, -0.7847574306388461, -0.6064941251059139,
          -0.593124869320861, 0.429657177033565, -0.6808800185176964,
          0.7949102075857264, 0.44671074005519945, -0.4105694540456619,
          0.6999641668655984, 4.05696934716436, 0.2354599672687453>
}

object
{
  BonsaiLeaf(0.003803712400436083)
  matrix <-0.5171238554429922, 0.8527585899656227, -0.07338736520422476,
          -0.31733370449385334, -0.27065162471187704, -0.9088712879352215,
          -0.7949102075857264, -0.4467107400551994, 0.4105694540456619,
          0.7002472043815688, 4.054860455844031, 0.23371342966162453>
}

object
{
  BonsaiLeaf(0.004064559196668457)
  matrix <-0.5510853817586663, -0.548333716166498, 0.6289952604964073,
          -0.6382110039825227, -0.20864585154237267, -0.7410490017736868,
          0.5375794047464292, -0.8098129687459916, -0.23497093276249775,
          0.6792267078399681, 4.050613947258387, 0.23075146508711974>
}

object
{
  BonsaiLeaf(0.0033430997199591504)
  matrix <-0.41589037580429616, -0.012234188757782316, -0.9093324584214506,
          -0.7335145389873577, -0.586560551244492, 0.34337026781292757,
          -0.5375794047464292, 0.8098129687459917, 0.23497093276249786,
          0.6793685419957457, 4.049501070258516, 0.23491142366862866>
}

object
{
  BonsaiLeaf(0.00419147908827939)
  matrix <0.25705418468089714, -0.4473278015077423, -0.8566335179855435,
          -0.9329623187570455, 0.11627662965562299, -0.3406773505465331,
          0.2520009085648616, 0.8867793318487855, -0.3874505887055859,
          0.6935636183500326, 4.056499093032587, 0.24214706739981348>
}

object
{
  BonsaiLeaf(0.0037661903313043568)
  matrix <0.766503892254701, -0.3494059252590703, 0.5388759435642378,
          -0.23922934913470614, 0.623341466337696, 0.744455999275012,
          -0.5960210580767926, -0.6995433622998821, 0.39420550806805915,
          -0.4952899239244515, 3.3178180648718922, 0.9043522043088189>
}

object
{
  BonsaiLeaf(0.004115299444679106)
  matrix <-0.4149699619888606, 0.6886403598030226, 0.5946212117788332,
          0.6874291446949168, -0.19082331910052264, 0.7007336383473227,
          0.5960210580767928, 0.6995433622998821, -0.39420550806805915,
          -0.4915599638853569, 3.314685147169144, 0.9044321700750265>
}

object
{
  BonsaiLeaf(0.004357305277947288)
  matrix <-0.9654229103387735, -0.06203289496474634, 0.2532005610880546,
          0.17115603159454318, 0.5817834539437818, 0.7951312002217317,
          -0.1966321871968595, 0.810974680652569, -0.5510497711628624,
          -0.526511046088701, 3.3333551149840353, 0.9237931311110195>
}

object
{
  BonsaiLeaf(0.004043537112811697)
  matrix <0.4882255602835615, 0.5683751918264238, 0.6622578377052846,
          -0.8502773578333029, 0.1388153761538643, 0.5076994249546467,
          0.19663218719685874, -0.8109746806525695, 0.5510497711628619,
          -0.5306949532211029, 3.3313814119948506, 0.92238140320259>
}

object
{
  BonsaiLeaf(0.0049225860336752775)
  matrix <-0.2320973649392709, -0.7073212930846344, -0.6677030788736323,
          0.8828196190962503, -0.44137177456385235, 0.16068751276035276,
          -0.40836299211240945, -0.5521662294702898, 0.7268783403744838,
          -0.4726910964007447, 3.2425163651487887, 0.8620964196429249>
}

object
{
  BonsaiLeaf(0.004236881506592008)
  matrix <0.8410839956250606, -0.5370367991776122, 0.06456925454462586,
          -0.35470745548463417, -0.6377334328397943, -0.6837241327187367,
          0.40836299211241006, 0.5521662294702898, -0.7268783403744834,
          -0.47853970538635554, 3.2419870546941807, 0.8584085634032981>
}

object
{
  BonsaiLeaf(0.004833542167603593)
  matrix <0.29741979061231116, -0.947127507349972, 0.1203783741922008,
          -0.8509362831577837, -0.2057896261241962, 0.4832784619505405,
          -0.4329537044046926, -0.2461709052684578, -0.8671510682929261,
          -0.49658265952902253, 3.257213501173207, 0.8851813811875137>
}

object
{
  BonsaiLeaf(0.0028247349024570338)
  matrix <0.5918607697080245, -0.7812285876176421, -0.19845080793377678,
          -0.6030125844972323, -0.5925246420021433, 0.5341258012474218,
          -0.5348613392446624, -0.1964597732595039, -0.8217827603887975,
          -0.49550370940449584, 3.252034129742419, 0.8862961890572202>
}

object
{
  BonsaiLeaf(0.004041362631814817)
  matrix <-0.7691367415894486, -0.2894292115469063, 0.5697889120020697,
          0.34978853685987576, -0.9368213751800074, -0.003700065846288514,
          0.5348613392446625, 0.19645977325950387, 0.8217827603887975,
          -0.492386736388543, 3.249921819880911, 0.8847724719562874>
}

object
{
  BonsaiLeaf(0.003183779830749279)
  matrix <-0.09341527764939933, 0.009276085277751006, -0.9955840196304908,
          -0.8545713738956794, 0.5123377393442535, 0.08495768218161398,
          0.5108633406496672, 0.8587339489536561, -0.03993309523092749,
          -0.4228852286653262, 3.3422976254515944, 0.5704388238771231>
}

object
{
  BonsaiLeaf(0.004564309097646882)
  matrix <-0.7637212911182902, 0.4746846777369495, 0.4374977099532996,
          -0.3946497645671101, 0.19300378658520814, -0.8983324004459019,
          -0.510863340649667, -0.8587339489536562, 0.039933095230927224,
          -0.4219657650719793, 3.3415473838295293, 0.5660680705740598>
}

object
{
  BonsaiLeaf(0.004951649808505013)
  matrix <-0.8106349606043887, -0.3658780010229564, 0.45716982513434506,
          -0.5846878484581526, 0.46337479414720506, -0.6659008334687775,
          0.031797492217136174, -0.8071041373431815, -0.5895522292148683,
          -0.42627695313496916, 3.337089366446054, 0.5782029026071392>
}

object
{
  BonsaiLeaf(0.003901097073515539)
  matrix <-0.07625036127790813, -0.6361904938623529, -0.767754868381937,
          -0.9874608846426592, 0.15492720313122854, -0.03030780478149725,
          0.1382276517406223, 0.7558169204570053, -0.6400264830811007,
          -0.45834984639460824, 3.3273611776579117, 0.5743863278447322>
}

object
{
  BonsaiLeaf(0.003312939647277543)
  matrix <-0.9901262304775121, 0.09025127864060906, -0.10726021827373322,
          0.023305879401277763, -0.648533337196034, -0.7608293806962961,
          -0.13822765174062251, -0.7558169204570051, 0.6400264830811008,
          -0.4544204546554345, 3.3246082397937906, 0.5719839797131476>
}

object
{
  BonsaiLeaf(0.004292897539609148)
  matrix <-0.029670991599302782, 0.9882147311293588, -0.15017082751468097,
          -0.1446486271782052, -0.1529005693454129, -0.9775981743790798,
          -0.9890381220726405, -0.0072843031772816536, 0.14748061572371687,
          -0.3746702938883237, 3.380983799654218, 0.5434763665216767>
}

object
{
  BonsaiLeaf(0.0044811226912249945)
  matrix <-0.13825205948618835, -0.30513444600140943, -0.9422204295764556,
          -0.051864835243666835, 0.9522814231048693, -0.3007825295367285,
          0.9890381220726405, 0.007284303177281792, -0.14748061572371676,
          -0.37428174484268956, 3.385907476025673, 0.5463252519009639>
}

object
{
  BonsaiLeaf(0.003491294349359257)
  matrix <0.30010780150487065, 0.9458565977566104, -0.12365518167955344,
          -0.8733708972311018, 0.22032166496893768, -0.43437499906769045,
          -0.3836125432590204, 0.2383561629696314, 0.8922038759323683,
          -0.39810682566830036, 3.372562099086354, 0.5805687257239786>
}

object
{
  BonsaiLeaf(0.003688884830457662)
  matrix <-0.9022779219137196, 0.10916173596539763, -0.4171070210726274,
          0.19681455302239786, 0.9650233442644878, -0.17318769223931083,
          0.3836125432590205, -0.23835616296963136, -0.8922038759323683,
          -0.39433160457084493, 3.3753527512781014, 0.5814463872530029>
}

object
{
  BonsaiLeaf(0.004961388129299532)
  matrix <0.2142401675303692, 0.7497589122505786, 0.6260692646324278,
          -0.20608583832778915, 0.6612190325199718, -0.7213307273879885,
          -0.9547930549900808, 0.025514006627369773, 0.2961743702762389,
          -0.4273190596251812, 3.3499574410746353, 0.5819187290784215>
}

object
{
  BonsaiLeaf(0.004208727671756549)
  matrix <0.7335307148016552, 0.35228934845917004, 0.5812270687130693,
          -0.6293456117381835, 0.029169903724343887, 0.7765778890121736,
          0.2566257809115539, -0.9354364391442778, 0.24310877584449553,
          -0.4217170815839904, 3.328667540062838, 0.6257969995580028>
}

object
{
  BonsaiLeaf(0.002513152191397151)
  matrix <-0.9649200747604898, -0.2335407024367539, 0.11994994635079448,
          0.05542975641067194, 0.26536278681537373, 0.9625539639302476,
          -0.25662578091155375, 0.9354364391442778, -0.24310877584449547,
          -0.4189290338789773, 3.329211668951051, 0.6249476393110323>
}

object
{
  BonsaiLeaf(0.0033164970333792124)
  matrix <0.32137225510180756, 0.9466364368894893, -0.02448121737068118,
          -0.8485750527170792, 0.2764148298352536, -0.4511266138827929,
          -0.4202859188183505, 0.16575372756086024, 0.8921241215451441,
          -0.44972433377478327, 3.32567611812349, 0.598352902929673>
}

object
{
  BonsaiLeaf(0.004511482469643267)
  matrix <-0.6090416303709882, -0.7803340639568599, -0.14194027301516624,
          -0.6726277119759962, 0.602996227540647, -0.4289143395291012,
          0.4202859188183504, -0.16575372756086054, -0.8921241215451442,
          -0.44994458526102343, 3.3274797960701705, 0.5979140234825295>
}

object
{
  BonsaiLeaf(0.0029765703622135087)
  matrix <-0.9360644299834309, 0.34966548007972603, 0.038954267550686816,
          -0.2118939803820701, -0.4719055246636287, -0.8558072895633622,
          -0.2808635326945076, -0.8093449374849765, 0.5158259863265913,
          -0.6589768158182553, 3.3040666837893187, 0.7254728006854165>
}

object
{
  BonsaiLeaf(0.004872305081270609)
  matrix <0.6714602677323493, -0.5497272440707416, -0.4969316512189472,
          -0.6857527140734948, -0.2067866758130877, -0.697841304199608,
          0.2808635326945073, 0.8093449374849766, -0.5158259863265912,
          -0.6616872949095939, 3.304463816016494, 0.7246200755669249>
}

object
{
  BonsaiLeaf(0.004680140199990006)
  matrix <-0.8109611787385268, -0.5563886211329769, 0.1810349934481291,
          -0.5401479129719814, 0.8308521517432734, 0.13388403211580469,
          -0.22490486586784394, 0.010789078612996217, -0.9743209928415016,
          -0.6280889516150158, 3.2976990133512962, 0.7349974619124009>
}

object
{
  BonsaiLeaf(0.004601216872569099)
  matrix <-0.11193164785329385, 0.9930330216054539, 0.0368337373882824,
          -0.9679303216233153, -0.1173414410335297, 0.22213031917854215,
          0.22490486586784392, -0.010789078612996272, 0.9743209928415018,
          -0.6300146409808993, 3.293270595377339, 0.7353929356440725>
}

object
{
  BonsaiLeaf(0.002633294745010576)
  matrix <0.11895770158558938, 0.8904610015650398, 0.4392360070910179,
          -0.9695482560239286, 0.19955188494784082, -0.14196909682999018,
          -0.21406831730649256, -0.40897218720293255, 0.8870831447051711,
          -0.5933133735035024, 3.308874182228288, 0.7304843231250678>
}

object
{
  BonsaiLeaf(0.003895501330324212)
  matrix <-0.8754419804012781, -0.3225381800926165, -0.35995897173654706,
          -0.4333313910584553, 0.8536456363603068, 0.2889862160144524,
          0.21406831730649273, 0.4089721872029326, -0.887083144705171,
          -0.5924483101862199, 3.311674081010365, 0.7319839157906338>
}

object
{
  BonsaiLeaf(0.003121202956859947)
  matrix <-0.37755986044453416, 0.9237601411716927, 0.06415413754045357,
          0.8502115935992292, 0.318382399256229, 0.41925278049561937,
          0.36686345946491355, 0.2128376128091618, -0.9055999959602098,
          -0.5749175373473681, 3.355045021382524, 0.7362214458315688>
}

object
{
  BonsaiLeaf(0.003925490582951163)
  matrix <0.9190159433780113, 0.06807649975112345, 0.3882979345794425,
          -0.1442944833542193, 0.9747131581933905, 0.1706263793151762,
          -0.36686345946491344, -0.21283761280916186, 0.9055999959602099,
          -0.5781376469228454, 3.35787751262012, 0.7355826650586189>
}

object
{
  BonsaiLeaf(0.00278162155605631)
  matrix <0.09937213769835002, 0.8141897055138843, -0.5720317313615335,
          0.9251542467344315, 0.1360571289126009, 0.3543699725164472,
          0.36635337858208383, -0.5644320872410379, -0.7397307759544804,
          -0.5589741499627489, 3.3286038025315956, 0.7486330942681492>
}

object
{
  BonsaiLeaf(0.0024733320283978344)
  matrix <0.5758438305750911, -0.48693636150497205, 0.6567319564578115,
          0.7308824014778977, 0.6665653746910537, -0.1466339540245587,
          -0.36635337858208383, 0.5644320872410379, 0.7397307759544802,
          -0.5597398641055747, 3.3298739805792015, 0.7472846966588388>
}

object
{
  BonsaiLeaf(0.00487493424333645)
  matrix <0.051828423293611925, 0.38969355108629417, 0.9194850465236784,
          -0.8101263960701444, 0.5547948637660788, -0.18946736270180503,
          -0.5839597905072722, -0.7350793123061836, 0.34445517515370555,
          -0.673527357116256, 3.427293651376291, 0.5164440439270025>
}

object
{
  BonsaiLeaf(0.004402420039396796)
  matrix <-0.36577478115303275, -0.9008299306614966, 0.23391076396107463,
          -0.14908933258160872, 0.30479400741719614, 0.9406768754215951,
          -0.9186844835866234, 0.30920227856044213, -0.24579009449164008,
          -0.6764558042935853, 3.430094545871461, 0.5380273798084986>
}

object
{
  BonsaiLeaf(0.0043602062143203255)
  matrix <-0.039964445113348734, 0.5463102759325177, 0.8366289055114684,
          -0.39296521823688274, -0.7784208587541618, 0.4895296762326788,
          0.9186844835866232, -0.30920227856044263, 0.24579009449163983,
          -0.677512859814736, 3.4253586391596227, 0.5360205754179493>
}

object
{
  BonsaiLeaf(0.003240093585901766)
  matrix <0.015600617700078923, -0.8597696566465586, -0.5104436876260057,
          -0.5914775212537484, 0.40366946420243244, -0.6980009351870828,
          0.8061705542742786, 0.3128052128408037, -0.5022369323742744,
          -0.6077697089018038, 3.394425872468829, 0.5026362902566718>
}

object
{
  BonsaiLeaf(0.0029192951112496143)
  matrix <-0.3503747568189933, 0.936378788437403, 0.020791689410269702,
          -0.47678775907644044, -0.15920949526997813, -0.864480057266068,
          -0.8061705542742786, -0.3128052128408038, 0.5022369323742744,
          -0.60724515055316, 3.3926531661258363, 0.5023742062047752>
}

object
{
  BonsaiLeaf(0.00497690428495387)
  matrix <0.37990986760258516, -0.6018392112436467, -0.7024656976022466,
          -0.8858330815941815, -0.01800356284673471, -0.46365463793450756,
          0.2663986562495051, 0.7984143257322286, -0.5399688142976482,
          -0.6301162735050332, 3.4062578700629325, 0.5086343645922803>
}

object
{
  BonsaiLeaf(0.003633947641166642)
  matrix <-0.7136381951657746, 0.5396549785554919, -0.4466464267413408,
          -0.4667761710164222, 0.10910043528030534, 0.8776201349062674,
          0.5223413946565831, 0.8347871579881428, 0.1740398468348445,
          -0.62659179973303, 3.4338661856778985, 0.548190454684777>
}

object
{
  BonsaiLeaf(0.004633001146907938)
  matrix <0.1733454384110994, -0.30378149752722616, 0.9368394530239313,
          -0.834931629781912, 0.4591810129112445, 0.30338419697064656,
          -0.5223413946565832, -0.8347871579881427, -0.17403984683484458,
          -0.6287637987657814, 3.4355971065679176, 0.5464068083982128>
}

object
{
  BonsaiLeaf(0.003191192847602265)
  matrix <-0.07557122963144972, 0.9872204580620458, -0.14030237501823084,
          -0.4967654124499708, 0.08472626552560608, 0.8637393037968657,
          0.8645884074202019, 0.1349712084625833, 0.4840141099603901,
          -0.5543061036241338, 3.4556853910900416, 0.5599571720892416>
}

object
{
  BonsaiLeaf(0.0049656931996044495)
  matrix <-0.4727760231506494, 0.10955735387892855, 0.8743454798561627,
          -0.05308775176452388, 0.9868973146650503, -0.15236594409349397,
          -0.8795820158157197, -0.11845200090315369, -0.4607652340786946,
          -0.5539756069870249, 3.470262515948964, 0.5556056396042566>
}

object
{
  BonsaiLeaf(0.004120726997645192)
  matrix <-0.8808741454921759, 0.2788922012809705, 0.38246552768593933,
          0.45538832672945284, 0.7197774646828663, 0.5239674352602983,
          -0.12915963642709133, 0.6357197034852397, -0.7610376120262787,
          -0.5576836340849046, 3.467216501064977, 0.5683305196530217>
}

object
{
  BonsaiLeaf(0.0033952557221470546)
  matrix <0.905480328863165, 0.3884833966611052, 0.17083917747549993,
          -0.40425630775521215, 0.6670390611645544, 0.6258080604473178,
          0.12915963642709033, -0.63571970348524, 0.7610376120262786,
          -0.5609327185993911, 3.4665152628232767, 0.5682961712948572>
}

object
{
  BonsaiLeaf(0.0030301490361685666)
  matrix <0.8927555588759545, -0.3052008980066517, -0.3314210674534982,
          0.15857835003020776, 0.9013944638632783, -0.4029155338508691,
          0.42171129816235603, 0.30714887656081075, 0.853123173187584,
          -0.5128395091374575, 3.4647477717586117, 0.5097456507420631>
}

object
{
  BonsaiLeaf(0.0030728235442485144)
  matrix <-0.1681631123802494, 0.9510495311738976, -0.2592796885382629,
          0.8909998589432039, 0.03412267400633617, -0.452719443454606,
          -0.42171129816235536, -0.3071488765608114, -0.8531231731875842,
          -0.5105821398274759, 3.462121265148808, 0.5095754178938323>
}

object
{
  BonsaiLeaf(0.0028808729979805147)
  matrix <0.9256478090630119, 0.22285319586559033, -0.30579827774096185,
          -0.3428732302652253, 0.8358257137640069, -0.4287578852667071,
          0.1600439987763857, 0.5017288404142045, 0.8500906358455445,
          -0.5243016998883294, 3.4603578155523396, 0.5157685393901994>
}

object
{
  BonsaiLeaf(0.0032429837007659328)
  matrix <-0.8798562784992913, 0.4629072813745748, -0.10756290269316048,
          0.4474805556010696, 0.7307427861751485, -0.5155348027164983,
          -0.16004399877638553, -0.5017288404142045, -0.8500906358455445,
          -0.521862753509304, 3.4603196947675574, 0.5153318654421483>
}

object
{
  BonsaiLeaf(0.004076827780746145)
  matrix <0.18042093649551333, 0.8347306776874135, -0.5202624159033529,
          -0.8947655485008288, -0.08037042242885195, -0.43924390538130326,
          -0.4084640729490089, 0.5447616826889718, 0.732387745790293,
          -0.5388082153492653, 3.4578537577437376, 0.5110561352108502>
}

object
{
  BonsaiLeaf(0.002181101721580059)
  matrix <0.9894805314525665, 0.1360676211509567, 0.049131256351398686,
          -0.08020646762078537, 0.7986278933870246, -0.5964565453207799,
          -0.12039601500109168, 0.5862414949306505, 0.8011402556315174,
          -0.5280477544610911, 3.4770008652905235, 0.5014117594067095>
}

object
{
  BonsaiLeaf(0.0028689347459986175)
  matrix <-0.9846526590173744, 0.032191577106205474, -0.17153088192343077,
          0.12634848895761175, 0.8094965175866367, -0.5733685092095974,
          0.12039601500109093, -0.5862414949306506, -0.8011402556315175,
          -0.5275103304264066, 3.4775813693034245, 0.5010677349662235>
}

object
{
  BonsaiLeaf(0.00262207958411822)
  matrix <-0.034514221594827116, -0.02652152483854911, 0.9990522394889775,
          0.6570990091495817, -0.75379948037952, 0.002689898548981995,
          0.7530137187876069, 0.6565690764114653, 0.043444069996431134,
          0.18766343090525964, 3.2465149042772485, 0.7696509354429794>
}

object
{
  BonsaiLeaf(0.0040619809196318106)
  matrix <0.6130460000651781, -0.6760463536865376, -0.4088226136984389,
          0.2390500807817152, -0.33448225000339415, 0.9115792249228378,
          -0.7530137187876069, -0.6565690764114652, -0.04344406999643102,
          0.18691148187559598, 3.2471327659878013, 0.7733466997332801>
}

object
{
  BonsaiLeaf(0.002258812624409328)
  matrix <-0.35701226488511634, -0.9314643889784382, 0.07011657996953691,
          -0.11208286855292145, 0.11723808538170333, 0.9867586644732242,
          -0.9273508900618732, 0.34442607828249233, -0.14625663506451358,
          0.17660890604732943, 3.242920877170495, 0.779670767028386>
}

object
{
  BonsaiLeaf(0.0040331498700841425)
  matrix <0.056466471202295615, 0.5151901553673213, 0.8552137986740839,
          -0.36990791331277606, -0.7848246813215919, 0.49721057436165733,
          0.9273508900618732, -0.3444260782824923, 0.14625663506451364,
          0.17537018619327627, 3.239490742741662, 0.7794471888632198>
}

object
{
  BonsaiLeaf(0.0025028806128118454)
  matrix <0.5629335863467452, 0.556013474881248, 0.6115184323577433,
          -0.05164303911802201, -0.7147787319731912, 0.6974412956152305,
          0.8248871279596052, -0.4241938001306449, -0.37365872940060796,
          0.187019081226415, 3.256889276986052, 0.7760446132190767>
}

object
{
  BonsaiLeaf(0.002813142523952572)
  matrix <-0.43081898357737414, -0.8996959679705075, 0.0703005590800712,
          0.36600031354619394, -0.10298924773166807, 0.9248983648681365,
          -0.8248871279596052, 0.424193800130645, 0.37365872940060796,
          0.18817794863362697, 3.258388559384454, 0.7769008718422518>
}

object
{
  BonsaiLeaf(0.004820413255518707)
  matrix <0.2738063747572956, -0.793132711684872, 0.5440317737022986,
          0.29234730417983756, 0.6075167044390638, 0.7385502742307265,
          -0.9162767719859807, -0.043173550733079095, 0.398212156564876,
          0.18986747626732067, 3.2611680680283124, 0.779622446743807>
}

object
{
  BonsaiLeaf(0.00424167647267594)
  matrix <-0.11097970422758952, -0.8110685035009654, 0.5743268998386382,
          0.7253345864166166, 0.32895565725582837, 0.6047130834596038,
          -0.6793918184651566, 0.48369004350729716, 0.5517886359961729,
          0.19358545285223389, 3.2574079666948443, 0.7831042134116987>
}

object
{
  BonsaiLeaf(0.003535065900865329)
  matrix <0.7014082759705692, 0.6489653977036423, 0.29473775289797516,
          0.21553001508514177, -0.5872715337859167, 0.7801659811874234,
          0.6793918184651566, -0.4836900435072973, -0.5517886359961729,
          0.19127073100915284, 3.2539365996492733, 0.7832971543099795>
}

object
{
  BonsaiLeaf(0.0029185329992458832)
  matrix <0.12138744696051484, -0.14228236439038916, 0.9823547304837942,
          0.699904968365645, -0.6894971176064678, -0.1863511740490491,
          0.7038452407862785, 0.7101756498190105, 0.015887838954762035,
          0.26483776654692054, 3.2477000087033066, 0.7391807285178315>
}

object
{
  BonsaiLeaf(0.004084111823553797)
  matrix <0.6932171530392857, -0.6818111842260215, -0.23363109338531707,
          0.155086607270305, -0.17545385566711602, 0.9721954992576998,
          -0.7038452407862786, -0.7101756498190104, -0.015887838954761896,
          0.26342846184683677, 3.248995755627508, 0.7436951557020659>
}

object
{
  BonsaiLeaf(0.004222027265944108)
  matrix <0.47522810360352596, 0.6947234532012055, -0.5399236734183722,
          0.8793083898307692, -0.3532176582010589, 0.3194589825129047,
          0.03122507195535809, -0.6265753023437431, -0.7787351188781911,
          0.23746028950493878, 3.267569296269146, 0.7284786569240912>
}

object
{
  BonsaiLeaf(0.0033267068948118626)
  matrix <0.7972264292816094, -0.45432318041129066, 0.3975178841207845,
          0.6028723043367299, 0.6332407427146629, -0.4853361169642166,
          -0.031225071955358008, 0.6265753023437429, 0.7787351188781915,
          0.23575340495942798, 3.2711671971977485, 0.7255153213829648>
}

object
{
  BonsaiLeaf(0.0034089400080144472)
  matrix <-0.011905092137220592, -0.9998881330219903, -0.009054845277788836,
          0.9665826983310652, -0.013826678924220962, 0.2559818552885409,
          -0.25607841781032875, -0.0057047692089081115, 0.9666391775321505,
          0.22258074380395548, 3.3120237461168767, 0.7171669361837896>
}

object
{
  BonsaiLeaf(0.002729455127568945)
  matrix <0.6954432987774402, 0.6934635046781679, 0.1883268060182235,
          0.6714033527748511, -0.72046916886689, 0.17361369356978323,
          0.25607841781032875, 0.005704769208908, -0.9666391775321503,
          0.22111828669645847, 3.31010439216862, 0.716768180182101>
}

object
{
  BonsaiLeaf(0.003953040821404682)
  matrix <0.8733622964794998, 0.351723649248172, 0.3369403116986802,
          0.36753258574403525, -0.021944131777560633, -0.9297517160494153,
          -0.3196218038625624, 0.9358466378846905, -0.14843507959900698,
          0.16820878555120014, 3.3056069765109193, 0.7092027736824618>
}

object
{
  BonsaiLeaf(0.004582081289849791)
  matrix <0.18236946759398748, -0.7694749867529553, -0.6120862864425455,
          0.8698261283279277, -0.16398143794046144, 0.4653091386261675,
          -0.4584145326748853, -0.6172668246168092, 0.6394042410400071,
          0.18263116670036286, 3.2898730971494654, 0.7227803198909849>
}

object
{
  BonsaiLeaf(0.003413427290857757)
  matrix <0.10392773731407956, -0.7048213955692705, -0.7017305934363717,
          0.9942235467441402, 0.09263857973706213, 0.05419993213836502,
          0.026806053724468967, -0.7033099557748962, 0.7103777457040963,
          0.19160711432899358, 3.285975383014022, 0.7188921266989516>
}

object
{
  BonsaiLeaf(0.002537444590027247)
  matrix <0.41252809666324625, 0.6550828271823159, 0.6329984668182254,
          0.9105503857267433, -0.2760825884382029, -0.30769530287955615,
          -0.026806053724468953, 0.7033099557748963, -0.7103777457040962,
          0.19052387569153328, 3.2849586236873276, 0.7179263593897595>
}

object
{
  BonsaiLeaf(0.0036517606906829)
  matrix <0.8845557840660325, 0.45049228354170867, -0.12090395917712041,
          0.102646819124954, 0.06484609857599796, 0.9926019413757969,
          0.45499966527334396, -0.8904221953482788, 0.011118391623621417,
          0.016555164438767884, 3.490338068708449, 0.8658708344389916>
}

object
{
  BonsaiLeaf(0.004284789401874939)
  matrix <-0.8425149754530544, -0.4264093482661116, 0.32915586558438903,
          0.28834670231941884, 0.1591332201095081, 0.944210144787216,
          -0.4549996652733438, 0.8904221953482789, -0.011118391623621438,
          0.017415827713827575, 3.4907831186097367, 0.8662918313095069>
}

object
{
  BonsaiLeaf(0.003799534964352388)
  matrix <0.33000704097325617, 0.6203324334938577, 0.7115356806679933,
          -0.23562714304687463, -0.675771866610581, 0.6984355616355873,
          0.9140980266730931, -0.3981457726175672, -0.07684231502965898,
          0.01465508194598331, 3.4871434114998157, 0.8594278208981618>
}

object
{
  BonsaiLeaf(0.00438144823997515)
  matrix <-0.8182413406863667, 0.4815592435941054, 0.31397739297734484,
          0.518156585918813, 0.8543502294793219, 0.03999297260256543,
          -0.24898767210594255, 0.19541335752118638, -0.9485877707632333,
          0.016318928793537493, 3.5056529923587876, 0.8505736237477322>
}

object
{
  BonsaiLeaf(0.003468216802903064)
  matrix <-0.7621198274112496, -0.0796895451166365, 0.642512992137708,
          0.224509179025423, 0.8982908386951111, 0.37771576304115884,
          -0.6072635319200199, 0.4321147365174409, -0.6667142246003794,
          0.011733814279914162, 3.515831769933605, 0.8572930299123247>
}

object
{
  BonsaiLeaf(0.004894836252042113)
  matrix <0.7872087320837795, 0.4406792812729162, -0.4313979406393055,
          -0.10739373785780464, 0.7868154965055331, 0.6077729506383788,
          0.6072635319200197, -0.43211473651744103, 0.6667142246003795,
          0.010429493011503527, 3.5165676355689124, 0.8589579788280193>
}

object
{
  BonsaiLeaf(0.0030080333753525128)
  matrix <0.20066617960514135, 0.8308033461950941, -0.519132819530523,
          0.43970834453172936, 0.3971545883303246, 0.8055586910445052,
          0.875436837305721, -0.38991541764747445, -0.28561567003396715,
          0.3267462669028029, 3.5574518323016484, 0.5519345697738062>
}

object
{
  BonsaiLeaf(0.004876123221167472)
  matrix <0.4134081822011415, 0.29791059777278645, 0.8604318396153228,
          0.2504077051076996, 0.8713295833468848, -0.42199613553590554,
          -0.8754368373057209, 0.3899154176474744, 0.28561567003396726,
          0.3266446283526654, 3.5605058884594243, 0.5474537171896094>
}

object
{
  BonsaiLeaf(0.0024036278875096823)
  matrix <0.9952689831556083, -0.024482745709789644, -0.09402258415355151,
          -0.07892735568750853, 0.3605971004164795, -0.9293762444217109,
          0.05665795348033209, 0.9324003036967206, 0.3569587510815274,
          0.3179430777054622, 3.530581072331715, 0.52424209441279>
}

object
{
  BonsaiLeaf(0.0031862828258969484)
  matrix <-0.9171376517165845, 0.18988845552110412, -0.3504295967289267,
          0.3945230083419846, 0.30752568693699783, -0.865898116271607,
          -0.05665795348033159, -0.9324003036967206, -0.3569587510815273,
          0.31938985158458133, 3.5306941948998083, 0.5237169727750184>
}

object
{
  BonsaiLeaf(0.0027117783401711176)
  matrix <0.3702816287092132, -0.6555856256772653, 0.6581025777534988,
          0.2634044914824841, -0.6052793672420089, -0.7511690631661867,
          0.8907915521081833, 0.45149127898162245, -0.05143963157170646,
          0.35558445487218826, 3.4716620449437428, 0.5475600411454872>
}

object
{
  BonsaiLeaf(0.004445731878767009)
  matrix <-0.19784321933870247, 0.28343421586630113, -0.93836192689066,
          0.4090824748805454, -0.8460618596058995, -0.3418052932091809,
          -0.8907915521081831, -0.4514912789816227, 0.05143963157170692,
          0.3566888312771036, 3.4695420642409234, 0.5480774704524365>
}

object
{
  BonsaiLeaf(0.0038227646609284485)
  matrix <0.40675727810465234, 0.14811945137244373, -0.9014483594937764,
          0.8453139175792488, -0.43519418944561133, 0.30991998680240007,
          -0.34639990972244444, -0.8880690545210452, -0.30222583765518707,
          0.36520562896777625, 3.4826638660547613, 0.5633833698748714>
}

object
{
  BonsaiLeaf(0.004180968447776168)
  matrix <0.8925748498921461, -0.4111521575165141, 0.18510548535775007,
          0.2886472585774821, 0.20563865826155242, -0.9350911732788909,
          0.3463999097224443, 0.8880690545210455, 0.3022258376551866,
          0.36318101787691287, 3.48518727976465, 0.5582890320103346>
}

object
{
  BonsaiLeaf(0.003910326807631934)
  matrix <0.47193829008492155, 0.5669419870014988, 0.6751674116295255,
          -0.24421720894914462, 0.8199151161537488, -0.5177809934283741,
          -0.8471317519753409, 0.07947317583547787, 0.5254063276339684,
          -0.041744914868551905, 3.4206198677425657, 0.5809039268090438>
}

object
{
  BonsaiLeaf(0.004310775264211636)
  matrix <-0.4496883147704612, 0.41955924648880305, -0.788511546043969,
          0.2831045996696141, 0.9042422534964681, 0.3196838010246013,
          0.8471317519753407, -0.07947317583547789, -0.5254063276339686,
          -0.03956954546407271, 3.4213117168231144, 0.584306704729955>
}

object
{
  BonsaiLeaf(0.0024599756003083994)
  matrix <-0.9883461494088706, -0.08039536329998595, -0.12926126453242617,
          -0.029162322539810298, 0.9334282789318609, -0.3575768547241111,
          0.14940364082826985, -0.34964014879611194, -0.9248947607469136,
          -0.07987804006666795, 3.4477682212623817, 0.5624609995424156>
}

object
{
  BonsaiLeaf(0.004066125150426305)
  matrix <0.8834258265755888, 0.4673384704507675, -0.03396414250316296,
          -0.44411413065392896, 0.8120015519606906, -0.37870320643867644,
          -0.14940364082826996, 0.34964014879611194, 0.9248947607469136,
          -0.08161212510108334, 3.448773710404184, 0.5618007752480245>
}

object
{
  BonsaiLeaf(0.0040443856520306605)
  matrix <0.6307582753760805, 0.7518588161171449, -0.19196957746350918,
          -0.7637130127204002, 0.5576775237384759, -0.3251741283042845,
          -0.1374279165458126, 0.3517159367214496, 0.9259640746865024,
          -0.08221501446558886, 3.442785122699397, 0.5640037191481838>
}

object
{
  BonsaiLeaf(0.003686784660679839)
  matrix <0.8154618267555154, -0.5503048458593932, -0.1794062031486889,
          -0.5731504257714625, -0.7244767307244467, -0.3829256534587492,
          0.0807502231733756, 0.4150879946017335, -0.90619057498683,
          -1.1403958800946046, 2.4993375363515655, -0.031011771595075267>
}

object
{
  BonsaiLeaf(0.004572336276854946)
  matrix <-0.9964435232236888, 0.05558009226057847, -0.06333370642768955,
          -0.024077094571669844, -0.9080819401804106, -0.4180998486428452,
          -0.08075022317337538, -0.4150879946017336, 0.90619057498683,
          -1.1383928864695594, 2.4978564700519765, -0.03151170027501999>
}

object
{
  BonsaiLeaf(0.004289838016515228)
  matrix <-0.9314037152900174, -0.020794987182105984, 0.36339329610223764,
          -0.35017522136478013, -0.22122747306041146, -0.9101844425749281,
          0.09931985444048999, -0.9750004993185399, 0.19877020109291743,
          -1.1515494734769247, 2.5033772746333165, -0.05136028249448296>
}

object
{
  BonsaiLeaf(0.004086144179374074)
  matrix <0.031088686662112397, -0.9820000443908885, -0.18630460643236718,
          -0.6037498552161202, 0.13009797983493115, -0.7864862541515801,
          0.7965673894204677, 0.1369322038790149, -0.5888378092927596,
          -1.1744464048473524, 2.4958370012769837, -0.07776319019709191>
}

object
{
  BonsaiLeaf(0.0026136814692218524)
  matrix <-0.43992691212863166, 0.799370117480285, -0.40923309649211403,
          -0.4146621589882884, -0.58502733852393, -0.696992329285466,
          -0.7965673894204677, -0.136932203879015, 0.5888378092927598,
          -1.1730631906915983, 2.4937763270602447, -0.07637120990277592>
}

object
{
  BonsaiLeaf(0.0030369584466247526)
  matrix <-0.1053935177860156, 0.3240757380337197, -0.9401420756601571,
          -0.5658264465987828, -0.7969901630065617, -0.2112986332188876,
          -0.8177607466356429, 0.5096877437104755, 0.26736822020060863,
          -1.1688931540741987, 2.4959550143876577, -0.06644714587524997>
}

object
{
  BonsaiLeaf(0.0045755520034052935)
  matrix <-0.1357846288427395, 0.8833206435533663, 0.4486726816316178,
          -0.6221518969927577, -0.4284622707477238, 0.6552458314358184,
          0.7710314855039017, -0.190170247983674, 0.6077382044461872,
          -1.1301721810624161, 2.5145622264012233, 0.021010664553401413>
}

object
{
  BonsaiLeaf(0.0036683953223827313)
  matrix <-0.30186337565411336, -0.949476460048866, 0.0858659085538534,
          -0.5607039778709897, 0.24965922493451573, 0.7894816784477936,
          -0.7710314855039017, 0.19017024798367416, -0.6077382044461872,
          -1.1293823765533717, 2.517438526535466, 0.02090868407297704>
}

object
{
  BonsaiLeaf(0.0042097486250444035)
  matrix <-0.8675583658390924, -0.4973340673457611, -0.0011433809190962603,
          0.49673689278186106, -0.866399310699827, -0.051036200566736564,
          0.024391416769556973, -0.04484484224733201, 0.9986961494427549,
          -1.1469513473132429, 2.4736215552868357, 0.0024128448906378104>
}

object
{
  BonsaiLeaf(0.004273141665358043)
  matrix <0.9815386706358443, -0.18849329010188387, -0.032436362819953074,
          -0.1897021265942851, -0.9810500597372086, -0.03941932844718042,
          -0.024391416769557084, 0.04484484224733202, -0.9986961494427549,
          -1.1498531088257973, 2.4730767127077287, 0.00245925009099304>
}

object
{
  BonsaiLeaf(0.0038966299643727943)
  matrix <0.7414475162229012, 0.6421468007434944, -0.19468710019358337,
          -0.6702366072654415, 0.6948008508648253, -0.2608345604378881,
          -0.032225315641618554, 0.32388155849385913, 0.9455486582399588,
          -1.1760738072410735, 2.5380100416527975, 0.007959587954995278>
}

object
{
  BonsaiLeaf(0.003622985807539096)
  matrix <-0.8129114000337128, 0.5419101896962367, -0.21332698375643636,
          0.5814951287216669, 0.7755218129562697, -0.2458237842479727,
          0.03222531564161879, -0.32388155849385913, -0.9455486582399588,
          -1.1713553945954716, 2.5381123643598236, 0.008085347637455602>
}

object
{
  BonsaiLeaf(0.0036065965979545814)
  matrix <0.3002520663606886, 0.8114662808785564, 0.5013692966698905,
          -0.19640193185687937, 0.5669524241380499, -0.7999945186855191,
          -0.9334211149363519, 0.14173010887286036, 0.32960218207691616,
          -1.0928381281664525, 2.615244232397565, -0.02912967751079074>
}

object
{
  BonsaiLeaf(0.003298556438780264)
  matrix <-0.19832025106045353, 0.5617454431170744, -0.8031881069565964,
          0.29898846166749676, 0.8150795257986113, 0.4962371070502637,
          0.933421114936352, -0.14173010887286036, -0.32960218207691605,
          -1.0911435553118316, 2.6158880495314074, -0.024607553896694893>
}

object
{
  BonsaiLeaf(0.0048288071827332505)
  matrix <0.9556416537631429, -0.29417815520201795, 0.014430613111827362,
          0.07376022394168019, 0.1916020673876908, -0.9786971324862643,
          0.2851463816304159, 0.9363481514771633, 0.20480156314926154,
          -1.0943705117887135, 2.561454512395536, -0.16189775680908164>
}

object
{
  BonsaiLeaf(0.004660595198474684)
  matrix <-0.4649605453315744, 0.3219776284672343, -0.8247072802222507,
          0.8381546589550445, -0.13993765037299682, -0.5271757028544071,
          -0.28514638163041556, -0.9363481514771635, -0.20480156314926132,
          -1.090820386108778, 2.559877110214894, -0.15962876961548728>
}

object
{
  BonsaiLeaf(0.0026732970500446605)
  matrix <-0.48498544390300447, 0.8687082410566838, 0.10067328902150975,
          0.37335911643328734, 0.30977746104651377, -0.8744374733528582,
          -0.7908173552586978, -0.3865021559419535, -0.47457770077602784,
          -1.0769670535798412, 2.556589085201616, -0.0822720972245576>
}

object
{
  BonsaiLeaf(0.0028209649903891227)
  matrix <0.5985346512470475, -0.3262997954618666, -0.7316315430174667,
          -0.12792256203740845, 0.8626381204965183, -0.48937847438155635,
          0.7908173552586977, 0.38650215594195353, 0.47457770077602784,
          -1.078326018473398, 2.558194429966126, -0.08131498564987531>
}

object
{
  BonsaiLeaf(0.003547255716926197)
  matrix <-0.2884127821768867, 0.6788808634331347, -0.6752324343078233,
          -0.6340222687247805, -0.6638530711986905, -0.3966293769013446,
          -0.7175192191419478, 0.3137194178312007, 0.621889296448799,
          -0.984654290525524, 2.555367262311523, -0.16600808041446014>
}

object
{
  BonsaiLeaf(0.003367327364420093)
  matrix <-0.6785217277951417, -0.5165648268400016, -0.522272959841552,
          -0.15739896782325452, 0.7967062862482079, -0.5835106326201456,
          0.7175192191419477, -0.31371941783120105, -0.6218892964487989,
          -0.9829352652596143, 2.5604048897926206, -0.16656600591039786>
}

object
{
  BonsaiLeaf(0.002383995548278499)
  matrix <-0.5688331233624875, -0.8129731655500176, 0.12451309112402864,
          -0.6340278920177398, 0.3370277461535206, -0.6960035419925819,
          0.5238678362995947, -0.4748546413569752, -0.7071602079249933,
          -0.9873417348012337, 2.5611505783550923, -0.16455376262795665>
}

object
{
  BonsaiLeaf(0.0027152759590108244)
  matrix <-0.008025619034843973, 0.8274070988275023, -0.5615452628675297,
          -0.8517617504501416, -0.2998509002681069, -0.42964096415323016,
          -0.5238678362995947, 0.4748546413569751, 0.7071602079249935,
          -0.9881429833329812, 2.55953292776783, -0.16406108706323178>
}

object
{
  BonsaiLeaf(0.003239948552828061)
  matrix <0.07892915621294785, -0.754642113198976, -0.6513719899459115,
          -0.7197191184154188, 0.40897204328743036, -0.5610225114882975,
          0.6897641472901046, 0.5130859078126082, -0.5108505381393531,
          -0.9800313832179799, 2.5615682252404763, -0.15796492581719476>
}

object
{
  BonsaiLeaf(0.004209187530330086)
  matrix <-0.366915829959656, 0.46669477211820676, -0.8047165733365704,
          0.8507402227964252, 0.518281436089825, -0.08732368705544752,
          0.3763161530432971, -0.7166451999994166, -0.5872016776853505,
          -0.9484691955798333, 2.561262320679017, -0.13824198304296603>
}

object
{
  BonsaiLeaf(0.004598748570059906)
  matrix <-0.9303165881743755, -0.34542648343433363, 0.1232541695431845,
          -0.28937303956728866, 0.48485765829542954, -0.8253340506509234,
          0.2253315107551063, -0.8034883917857573, -0.551028233874054,
          -0.9559161972136264, 2.56378412745758, -0.14631361935361703>
}

object
{
  BonsaiLeaf(0.004259022335877581)
  matrix <0.7787149657607305, 0.4884223361474613, -0.39375960134645704,
          -0.585515766108041, 0.34036748642870385, -0.735745378389236,
          -0.22533151075510638, 0.8034883917857572, 0.551028233874054,
          -0.9570791680875651, 2.563004021721918, -0.1456516715684428>
}

object
{
  BonsaiLeaf(0.004935881785799891)
  matrix <0.9158355344469752, 0.058404817074266875, -0.39728346452721336,
          -0.4008056900167876, 0.0726022597308946, -0.9132818353236503,
          -0.02449638125093412, 0.9956494308864388, 0.08990071235045775,
          -0.9496036623247076, 2.507715323454907, -0.0070244564786751>
}

object
{
  BonsaiLeaf(0.002876010271201204)
  matrix <0.826930402326046, -0.5543232032670048, -0.09440283909232416,
          0.1799384527271351, 0.4199211690711081, -0.8895439084138113,
          0.5327365793138754, 0.7186042012719945, 0.4469896407918089,
          -0.9405489643566459, 2.509890289681488, -0.015530322750103851>
}

object
{
  BonsaiLeaf(0.004652233386417092)
  matrix <-0.20195824879734586, 0.6208735830995373, -0.7574489154734143,
          0.8218300327948971, -0.3132474991494424, -0.4758901149141037,
          -0.5327365793138747, -0.7186042012719951, -0.4469896407918086,
          -0.9372431240783445, 2.5072252916123903, -0.015185937213690527>
}

object
{
  BonsaiLeaf(0.003418506215483488)
  matrix <-0.4126005694025008, -0.37913800858335994, 0.8282603096709246,
          -0.6221735184262062, -0.5468278416907523, -0.5602494306297772,
          0.6653276509344014, -0.746480865126011, -0.010268149922669244,
          -0.9774704607381659, 2.4808140587199747, 0.08212022933718169>
}

object
{
  BonsaiLeaf(0.0049513327687751045)
  matrix <-0.13182899597465728, -0.10393708856653865, -0.9858083979357375,
          -0.7348198641316294, -0.6572392255648121, 0.16756004194479107,
          -0.6653276509344014, 0.7464808651260109, 0.010268149922669369,
          -0.9789818943707386, 2.479429182981131, 0.08486509102442924>
}

object
{
  BonsaiLeaf(0.0030035093731946008)
  matrix <-0.171682605551065, -0.5059935726671815, 0.8452784082009304,
          -0.5432884810840856, -0.6671213531335269, -0.5096927765964903,
          0.8218045444462724, -0.5467354064012993, -0.1603673474079467,
          -1.001430225520326, 2.4442159935147743, 0.061744895872073005>
}

object
{
  BonsaiLeaf(0.003066029028237495)
  matrix <-0.1049519240520526, 0.13138665654806553, -0.9857599302664377,
          -0.5600199856837499, -0.8269328520915872, -0.05059321858160476,
          -0.8218045444462724, 0.5467354064012993, 0.16036734740794678,
          -1.001515491007541, 2.4436842986230527, 0.06312064262722698>
}

object
{
  BonsaiLeaf(0.003402153523219783)
  matrix <0.8708628084932246, -0.3342267914585379, -0.3604031362996506,
          -0.4908226184176391, -0.5521026664989803, -0.6739998537791893,
          0.0262892760065096, 0.7638554166306912, -0.6448517476529055,
          -0.9957430899848171, 2.448325873698965, 0.061408746526139917>
}

object
{
  BonsaiLeaf(0.0025556576944957437)
  matrix <-0.9339907758314977, -0.21116943435369703, -0.2882164128852094,
          0.356328646938092, -0.6098625849145798, -0.707882421658128,
          -0.026289276006509432, -0.7638554166306913, 0.6448517476529056,
          -0.993162582035975, 2.4486456117232516, 0.06189269234561553>
}

object
{
  BonsaiLeaf(0.004859958018308912)
  matrix <-0.6391203117191665, -0.33225985950271725, -0.693634351017329,
          -0.6796964156748994, 0.6660492071350549, 0.307231567703354,
          0.35991389201681406, 0.6678187174959989, -0.6515214124611017,
          -1.1637513608642394, 2.740278839428417, -0.08486116862402106>
}

object
{
  BonsaiLeaf(0.0046842672413670945)
  matrix <-0.07377250451798517, 0.7165029265833205, 0.6936722380019847,
          -0.9300643031051423, 0.2015979086189571, -0.30714601630170885,
          -0.359913892016814, -0.6678187174959989, 0.6515214124611017,
          -1.1648047345662644, 2.7379862067228844, -0.08779305516743709>
}

object
{
  BonsaiLeaf(0.00325130533996006)
  matrix <-0.24967321268402232, -0.7539297514573888, -0.6076620909152061,
          -0.8784574643079837, -0.0876699724434496, 0.4697089091483718,
          -0.40740123989701854, 0.6510790319148403, -0.6404063740557298,
          -1.178465602983946, 2.7355205184644893, -0.09559934697176384>
}

object
{
  BonsaiLeaf(0.0031152101338047565)
  matrix <-0.5767977259307595, 0.3602306660254574, 0.733170001170234,
          -0.7080456292439617, -0.6680793077589595, -0.22878248502198048,
          0.4074012398970186, -0.6510790319148404, 0.6404063740557296,
          -1.1778151804587305, 2.733724352884333, -0.09783921957208226>
}

object
{
  BonsaiLeaf(0.00472708854759441)
  matrix <-0.9757452880734934, -0.19014107966515556, -0.10847812049508121,
          -0.055570582265555724, 0.6944519776603778, -0.7173899644616293,
          0.21173814769437163, -0.6939616852156609, -0.6881744955050265,
          -1.1712859150744348, 2.741225839252294, -0.10126209959611131>
}

object
{
  BonsaiLeaf(0.003497174864794504)
  matrix <-0.7985462212219497, 0.6008434235682882, -0.03620929337731793,
          0.556685074666169, 0.7600627027957934, 0.33527066000871053,
          0.2289665045723232, 0.24757194544918298, -0.9414257653211109,
          -1.1337235340053522, 2.7569071739126287, -0.06983359110415416>
}

object
{
  BonsaiLeaf(0.003985784710034984)
  matrix <0.9492189844390324, 0.15758807838346767, 0.2723037222146238,
          -0.21577223955936758, 0.9559676403403591, 0.19891759916513724,
          -0.22896650457232356, -0.24757194544918298, 0.9414257653211109,
          -1.1365303807493667, 2.7580593829369007, -0.07021324850393042>
}

object
{
  BonsaiLeaf(0.004227990731538833)
  matrix <-0.7836045793010935, -0.6166868448563897, 0.07524093752358499,
          -0.43987694622981915, 0.6362641602552068, 0.6337792916704256,
          -0.43871646364581074, 0.46353560138980515, -0.7698458357166754,
          -1.150399675644796, 2.750931661370537, -0.06319003557604327>
}

object
{
  BonsaiLeaf(0.003225262188930572)
  matrix <0.10061759187664393, 0.876644155332168, 0.4705009299957823,
          -0.892974783927889, -0.1289564700437401, 0.43123805966403117,
          0.43871646364581063, -0.4635356013898053, 0.7698458357166753,
          -1.1514199577993898, 2.747825623971318, -0.06447879273880489>
}

object
{
  BonsaiLeaf(0.003006108207481586)
  matrix <-0.6385302024189331, 0.1748251649578577, -0.7494767123108595,
          -0.729667238453855, 0.1720863496220486, 0.6617945371494725,
          0.24467305067367567, 0.9694444027231359, 0.017681863669338216,
          -1.1467922863019646, 2.8775021144503357, -0.006315892368493893>
}

object
{
  BonsaiLeaf(0.0029523021759688935)
  matrix <-0.04448625569324843, -0.006993013600662304, 0.9989855208235884,
          -0.9685845710770089, 0.24521143486706548, -0.04141594960885325,
          -0.24467305067367576, -0.9694444027231359, -0.017681863669338327,
          -1.1474583819645188, 2.877708742515072, -0.008427590756435436>
}

object
{
  BonsaiLeaf(0.00493129455539435)
  matrix <-0.5840674898449272, 0.23474134476077618, 0.7770210218302651,
          0.39931075647722464, 0.9165203492964228, 0.02326733949448112,
          -0.7066937717765976, 0.32386254859966024, -0.6290444837582632,
          -1.130469979791478, 2.875430129651071, -0.022762117047522346>
}

object
{
  BonsaiLeaf(0.004998446934646485)
  matrix <0.3757762893386524, 0.007121586204680244, 0.9266830436458863,
          -0.9234280912471874, -0.08121074819216867, 0.375080490926475,
          0.07792779136130534, -0.9966715092687256, -0.023940800854428783,
          -1.1497567973497789, 2.876592958095467, 0.023453061160948467>
}

object
{
  BonsaiLeaf(0.003830745286096872)
  matrix <-0.9443091285211054, -0.08149171913178303, 0.31880929958936016,
          0.3196991228096521, 0.0022365877915006133, 0.9475164740255393,
          -0.07792779136130523, 0.9966715092687256, 0.02394080085442884,
          -1.1439164051300457, 2.877007453508968, 0.025207935497203793>
}

object
{
  BonsaiLeaf(0.004863570826000614)
  matrix <0.9748859524265867, -0.1958189597682273, 0.10607692848398959,
          0.21504596952778499, 0.7038776174870061, -0.6769870978022188,
          0.0579017335764916, 0.6827966275517963, 0.7283104795708566,
          -1.0754346521960338, 2.7971911976634503, -0.09412892056263804>
}

object
{
  BonsaiLeaf(0.002389422083728793)
  matrix <0.17356580932820503, 0.48922696740761873, -0.8547115795362721,
          0.9606348068501805, 0.10706156104100122, 0.25635637307346365,
          0.21692320691931996, -0.865560394489379, -0.4513862268514949,
          -1.0585856132467362, 2.795257608187046, -0.09042386070917804>
}

object
{
  BonsaiLeaf(0.002814628633923536)
  matrix <0.02126145109301327, -0.4580976375291827, 0.8886475708556234,
          0.9759571061257036, 0.20236540707732836, 0.08096893861950946,
          -0.21692320691931996, 0.865560394489379, 0.4513862268514949,
          -1.05813401845224, 2.7955713763980516, -0.09080850679520752>
}

object
{
  BonsaiLeaf(0.0038448748599217717)
  matrix <-0.04490917894841917, 0.8977516315533041, -0.4382067704743504,
          0.665541759835859, -0.30024036650737856, -0.6833080478335548,
          -0.7450082761693108, -0.3223317085905399, -0.5840076524124802,
          -1.0678231388157187, 2.788531215721993, -0.10658536271886168>
}

object
{
  BonsaiLeaf(0.0028885272517494265)
  matrix <0.646802918583429, -0.5631649387866754, -0.5142871145900499,
          0.16312158946991473, 0.7608860107522706, -0.6280476301128001,
          0.7450082761693106, 0.32233170859054017, 0.5840076524124801,
          -1.0699108824398071, 2.7918834423366437, -0.10577226147914168>
}

object
{
  BonsaiLeaf(0.004213399061785649)
  matrix <0.8236525252489674, 0.5657874106263986, -0.038485369007904585,
          -0.24005827871241167, 0.2863747777640223, -0.9275567419205369,
          -0.5137786882234738, 0.7732231842342046, 0.37169526078507453,
          -1.128000128546298, 2.8211095182395685, -0.12146365874943915>
}

object
{
  BonsaiLeaf(0.003941697818893395)
  matrix <-0.8356874045415835, -0.3530553968652459, -0.42068806571481954,
          0.19405674793193525, 0.5267616103201163, -0.8275652146357046,
          0.5137786882234741, -0.7732231842342046, -0.37169526078507453,
          -1.1262237541599323, 2.821979242110094, -0.12081750404479981>
}

object
{
  BonsaiLeaf(0.004507982395606839)
  matrix <-0.42329429971057786, 0.4639798038493975, -0.778167512462713,
          -0.13365106279219977, 0.8175357280145426, 0.5601541991579181,
          0.8960799792691767, 0.3411129945334942, -0.2840468195797044,
          -1.1168726352992042, 2.8113438830468622, -0.07755539406507712>
}

object
{
  BonsaiLeaf(0.004047354349979257)
  matrix <-0.06905191077393402, -0.9955867265655525, -0.06355236820887819,
          0.8743619140047783, -0.02972512073565875, -0.48436314943970726,
          0.48033642060161397, -0.08901397128394317, 0.8725556921823909,
          -1.0996161719208681, 2.613854331839033, -0.1381160075388423>
}

object
{
  BonsaiLeaf(0.004546844703895705)
  matrix <0.7347174138918037, 0.5841747275144845, -0.34486259503970323,
          0.4790273945900908, -0.8067319261375736, -0.34600051240220864,
          -0.4803364206016143, 0.08901397128394274, -0.8725556921823907,
          -1.1009769612448588, 2.610306555149924, -0.13772882883634902>
}

object
{
  BonsaiLeaf(0.0048567658914841745)
  matrix <0.34685654478685257, -0.8973431526634631, -0.27288423132626,
          0.7980541383158826, 0.43521766262382183, -0.4167675352725448,
          0.49274753135395954, -0.07321784282710256, 0.8670865111604059,
          -1.1050907742664444, 2.6219701530295936, -0.1343804203079141>
}

object
{
  BonsaiLeaf(0.0033479294320142364)
  matrix <-0.1383488185633187, 0.7267400035256505, -0.6728362146003074,
          0.7444748089009166, -0.37173202902403696, -0.5545922443648281,
          -0.6531591408792184, -0.577636794078433, -0.48961093820778895,
          -1.226674266291832, 2.593090840756202, -0.15232318019235966>
}

object
{
  BonsaiLeaf(0.0023231474956787335)
  matrix <0.6292911520735421, -0.7737043686400509, 0.07330890716178506,
          0.42116004393564754, 0.2602254485520009, -0.8688538043411176,
          0.6531591408792183, 0.5776367940784332, 0.48961093820778895,
          -1.2281882985145953, 2.5949399154561097, -0.15248492003434982>
}

object
{
  BonsaiLeaf(0.0028934707733207403)
  matrix <-0.6076782708784433, 0.7765812797828271, 0.16627878696049092,
          0.6109209827630667, 0.5908710361275628, -0.5269221683373635,
          -0.5074472109707516, -0.21861595220021535, -0.8334892881864757,
          -1.2258442317004, 2.6181768139320547, -0.14495601240736783>
}

object
{
  BonsaiLeaf(0.004172423467049653)
  matrix <0.6718002851344544, 0.5053680237472633, -0.5415602805478359,
          -0.5396125507910937, 0.8347515953967257, 0.10958133514130511,
          0.5074472109707523, 0.21861595220021518, 0.8334892881864753,
          -1.2298634057788687, 2.6199500830040083, -0.14297415877917466>
}

object
{
  BonsaiLeaf(0.0020765295620955916)
  matrix <-0.5716405625870193, -0.7821728432025031, -0.24785622962053777,
          -0.0603651001509139, 0.3413506383581142, -0.937995627056053,
          0.8182805887279541, -0.5212344818304144, -0.2423458129657149,
          -1.2763831314132474, 2.5986806028686846, -0.12747329907175564>
}

object
{
  BonsaiLeaf(0.003459380378105252)
  matrix <0.507565733662276, 0.8530758942842837, -0.12098985330574312,
          -0.26980345461633576, 0.024002781964791466, -0.9626162071848995,
          -0.818280588727954, 0.5212344818304143, 0.2423458129657149,
          -1.2771911342751099, 2.5980548129300427, -0.12885557904183892>
}

object
{
  BonsaiLeaf(0.003190952187531481)
  matrix <0.1571608916149242, 0.9699301630760236, 0.185838459157733,
          -0.882199493048568, 0.2224618038923812, -0.41501180739082344,
          -0.4438744288778668, -0.09872296877761572, 0.8906341936081735,
          -1.2607482285884886, 2.590225077806684, -0.10594969041868518>
}

object
{
  BonsaiLeaf(0.0046456164710742135)
  matrix <0.780624372842847, 0.6145126756014446, 0.11401649024972749,
          -0.5634679190929208, 0.6130287179706775, 0.5538047445592373,
          0.2704246524945649, -0.4965581159022398, 0.8248033370778829,
          -1.2034924190609395, 2.62048289723431, 0.005668720430262744>
}

object
{
  BonsaiLeaf(0.004981596208490186)
  matrix <-0.9427099733107223, 0.03727716599819869, 0.3315242360908789,
          0.19536738096133638, 0.8672026582216877, 0.4580296235283778,
          -0.27042465249456477, 0.4965581159022398, -0.8248033370778829,
          -1.19990152181082, 2.6219550543990535, 0.005377674623124457>
}

object
{
  BonsaiLeaf(0.0040967301089649254)
  matrix <-0.2087419993763231, -0.46694036934802724, -0.8592982422706932,
          -0.6603707775209192, -0.5807901755712488, 0.47601807545127406,
          -0.7213440329640168, 0.6668204131796255, -0.18711847229539375,
          -1.2232534084537667, 2.5847389948957904, -0.005850075702481343>
}

object
{
  BonsaiLeaf(0.004629635394882654)
  matrix <-0.4763729606402126, -0.2815930674664208, 0.8329310576066487,
          -0.5027241673901173, -0.689968028912794, -0.5207806933826442,
          0.721344032964017, -0.6668204131796255, 0.18711847229539375,
          -1.2228754772056283, 2.583924035087052, -0.010211218015649936>
}

object
{
  BonsaiLeaf(0.0044751916932532455)
  matrix <-0.60040947195379, 0.6236942032601946, -0.5005137428760595,
          0.1416936859094444, 0.698950014245026, 0.700993421481453,
          0.7870396212145655, 0.34996345295831865, -0.5080297395152413,
          -1.410141413620616, 2.591536318552517, -0.0960364926008336>
}

object
{
  BonsaiLeaf(0.004578545481025092)
  matrix <0.5344889235198016, 0.770198488742683, -0.3480170664969331,
          -0.7926049534265898, 0.5997342680503619, 0.10998270559379192,
          0.2934262742807421, 0.21705551286383912, 0.931014460627298,
          -1.417035527183729, 2.5964744592712936, -0.0990811311051202>
}

object
{
  BonsaiLeaf(0.004190630603243977)
  matrix <-0.9546790397762399, 0.11735522937172604, 0.2735245531045179,
          0.04988940342035658, 0.9690792818312264, -0.2416534563208966,
          -0.2934262742807423, -0.21705551286383923, -0.9310144606272979,
          -1.4131974812952286, 2.5977896019439073, -0.1005973722942456>
}

object
{
  BonsaiLeaf(0.0035803368128762224)
  matrix <0.1657151600920933, -0.4887750716285112, 0.8565263656596894,
          -0.6651143665753132, -0.6966594074387633, -0.26886529973611595,
          0.7281218064930981, -0.5251329349618203, -0.440538347397378,
          -1.4312809489145444, 2.546081101615828, -0.08724278001470427>
}

object
{
  BonsaiLeaf(0.004550395530094663)
  matrix <-0.3824436210705219, -0.35781011752097064, 0.8518854362542518,
          0.9239620508203896, -0.15365448876686177, 0.3502633676614993,
          0.005568244449329934, 0.9210658054023201, 0.389367149066699,
          -1.4209147714823016, 2.5433670717334396, -0.07345537054385323>
}

object
{
  BonsaiLeaf(0.0046860586353699735)
  matrix <0.8719818338519257, -0.19507597391309478, 0.44899114226685,
          -0.4895065638844751, -0.3370209882491505, 0.8042388808019547,
          -0.005568244449329837, -0.92106580540232, -0.38936714906669906,
          -1.427413020729093, 2.5424869603200175, -0.07128049685413373>
}

object
{
  BonsaiLeaf(0.00417237404239167)
  matrix <0.2549376339666449, 0.1901427994714843, -0.9480783293571459,
          -0.9664301945714334, 0.08247937350670628, -0.24333070493993048,
          0.0319293252060137, 0.9782856784984071, 0.20478683902243452,
          -1.4449313895034521, 2.562758422121541, -0.12209018408248405>
}

object
{
  BonsaiLeaf(0.003814146408515912)
  matrix <-0.9754060953023254, -0.01420876395112046, 0.21995695095643875,
          -0.21809050286282616, 0.20677340803859, -0.9537721375093461,
          -0.03192932520601359, -0.9782856784984072, -0.20478683902243475,
          -1.4417309103540643, 2.5632029513761356, -0.12471274393829963>
}

object
{
  BonsaiLeaf(0.004938722449147996)
  matrix <0.6693918511496726, 0.2656660896552708, 0.693783884521465,
          -0.73301223268075, 0.38811644065062556, 0.558622139945306,
          -0.12086197232710694, -0.882489182542182, 0.4545384761945177,
          0.4255982822973047, 2.576587158490642, 0.8227505858762305>
}

object
{
  BonsaiLeaf(0.0031238672030530295)
  matrix <-0.9888208772164621, 0.14731146875782997, 0.023078213823410187,
          0.0873250045867151, 0.44666785631881306, 0.8904280822758722,
          0.12086197232710705, 0.8824891825421819, -0.4545384761945176,
          0.4294912179841801, 2.57606569017933, 0.8227732852559906>
}

object
{
  BonsaiLeaf(0.004036819916004091)
  matrix <0.8220101263791305, -0.32788537775033066, 0.46560770095402154,
          -0.3993308391433816, 0.2510212499221241, 0.8817727672119263,
          -0.40599782393408196, -0.9107576577471413, 0.07540726633244807,
          0.424971683051949, 2.565098266199699, 0.7834054117599042>
}

object
{
  BonsaiLeaf(0.003324478878246699)
  matrix <0.32286102932596217, 0.6403249069916885, 0.69695392188341,
          -0.034434044771958106, -0.7279555887907025, 0.6847590505491876,
          0.9458197779192525, -0.24508095445070438, -0.21297951418460154,
          0.45272184870261606, 2.566942639825471, 0.7799366272771737>
}

object
{
  BonsaiLeaf(0.004041232602167806)
  matrix <-0.2776448630595578, 0.7991675669741132, 0.5331458805180033,
          0.6775284247874338, -0.2305538362523819, 0.6984269197234375,
          0.6810789701801835, 0.5551361350929946, -0.477446654499028,
          0.45975406685307496, 2.572005611423739, 0.7913156742269477>
}

object
{
  BonsaiLeaf(0.004683362510926191)
  matrix <0.7063521200252977, -0.32637802316194725, 0.6281274301705565,
          -0.19286813867009928, 0.7650498398868626, 0.614410793830169,
          -0.681078970180184, -0.5551361350929939, 0.47744665449902807,
          0.45611274548372893, 2.576520338842473, 0.7913706770668624>
}

object
{
  BonsaiLeaf(0.004979427930811797)
  matrix <-0.1126391775652027, -0.7065506581626871, 0.6986405249678186,
          -0.9310575010598251, 0.3206303424120195, 0.1741496863189454,
          -0.3470509262308209, -0.6308584238754573, -0.6939548282328645,
          0.37876975665977625, 2.6662982186196262, 0.7934573093922428>
}

object
{
  BonsaiLeaf(0.003030191141272135)
  matrix <-0.2787966946449551, 0.8409144832953168, 0.46382672932811775,
          -0.8343312684343109, -0.4512600393270496, 0.31663182313113253,
          0.47556675406071375, -0.2987092377057, 0.8274110548822976,
          0.38031511579412625, 2.6721335554299452, 0.798276658118667>
}

object
{
  BonsaiLeaf(0.0032865282907295714)
  matrix <-0.8313359501315309, -0.460128610875863, 0.3117085168428262,
          -0.2876052858538296, 0.836094763027929, 0.4671495978658328,
          -0.4755667540607137, 0.2987092377057001, -0.8274110548822977,
          0.38189807610410026, 2.676248808695946, 0.7988525035425592>
}

object
{
  BonsaiLeaf(0.004060848477257262)
  matrix <0.8070667297246872, 0.4048235085255753, 0.42983859844893263,
          0.3419663840042757, -0.9139195363084646, 0.21865514712615686,
          0.4813546363987159, -0.029478943311530892, -0.8760300827703895,
          0.35948730451986544, 2.980534771982693, 0.9267056888105906>
}

object
{
  BonsaiLeaf(0.0037420726498953627)
  matrix <0.33686514423125646, -0.9164566858482234, 0.21593753162927803,
          0.8092092366128281, 0.39904653220561404, 0.43121024630121985,
          -0.48135463639871584, 0.029478943311531003, 0.8760300827703895,
          0.36112675060248006, 2.985739321854249, 0.9274313834583773>
}

object
{
  BonsaiLeaf(0.004949572048747199)
  matrix <-0.027495845556128745, -0.8970836634112549, -0.44100439829756316,
          -0.10514395494173422, -0.43612848452799113, 0.8937207023016346,
          -0.994076821586926, 0.07094255298450652, -0.08233120283146864,
          0.3263784352513085, 2.9702255233065493, 0.939506146543649>
}

object
{
  BonsaiLeaf(0.003967931077405688)
  matrix <-0.45200503630837074, -0.24097261204789666, 0.8588501891451626,
          0.026101554794917742, -0.965980641677346, -0.25729381792400435,
          0.8916334201840785, -0.09388077624006091, 0.4429178748519943,
          0.32465239841358956, 2.9578385600685664, 0.9383176484298278>
}

object
{
  BonsaiLeaf(0.004355167823410914)
  matrix <0.21752146114768034, -0.7691438353422881, -0.6009177768173726,
          -0.39708218034938525, -0.632142515899317, 0.6653732648983266,
          -0.8916334201840787, 0.09388077624006097, -0.4429178748519943,
          0.3228194697080427, 2.958918417931795, 0.942236384799836>
}

object
{
  BonsaiLeaf(0.004451243586588762)
  matrix <-0.6869892592365487, -0.6983662131563794, -0.20082427645888992,
          -0.6381726371912602, 0.7120024198321656, -0.2928962944345545,
          0.34753624679156936, -0.07305605022692896, -0.9348162229504091,
          0.3014312753316073, 3.0079976897719587, 0.8708056895122027>
}

object
{
  BonsaiLeaf(0.003995344482694126)
  matrix <-0.36466810618286893, 0.90794445777423, -0.20652853054737866,
          -0.8638493673662263, -0.4126738120141623, -0.28890239766860776,
          -0.34753624679156936, 0.07305605022692888, 0.9348162229504091,
          0.30082056138625585, 3.003179619529062, 0.8709551776637778>
}

object
{
  BonsaiLeaf(0.004008422699959209)
  matrix <-0.43892490961751596, 0.3410557209786489, -0.831279687533016,
          -0.7739386561645146, 0.3264978625996423, 0.5426030798033963,
          0.4564689257896108, 0.8815214920270519, 0.12064816153957555,
          0.31872635418390244, 2.9982369994251314, 0.8803807484354962>
}

object
{
  BonsaiLeaf(0.004976763257643547)
  matrix <-0.1659125561472368, -0.14365908578972628, -0.9756203620172914,
          0.8655172118747311, -0.4953453021428522, -0.07424949557808068,
          -0.4726023483450781, -0.8567351391854237, 0.206523416647242,
          0.35052938255124344, 2.9280827479370486, 0.7701304932418985>
}

object
{
  BonsaiLeaf(0.0039167624399308034)
  matrix <0.8842748048116886, -0.08278813074928865, 0.45956957577965196,
          0.3004927876522459, -0.6524384315501692, -0.6957213361722768,
          0.35743832215395255, 0.7533061916932544, -0.5520576305172971,
          0.34311626993626176, 2.9305168644807815, 0.7684467844739218>
}

object
{
  BonsaiLeaf(0.0042811557915622645)
  matrix <-0.7323657305913818, 0.467729845654488, 0.4948426296706676,
          -0.5701814101358964, -0.024014987409652716, -0.8211677294652753,
          -0.3722010158379389, -0.8835451725088785, 0.2842786167573333,
          0.27969350827779993, 2.9612633863388758, 0.7859694640223548>
}

object
{
  BonsaiLeaf(0.0028915332432484)
  matrix <-0.016277616724496735, -0.30002357408435754, -0.9537928990024085,
          -0.9280093981221192, 0.35963006427425503, -0.09728706937264803,
          0.37220101583793885, 0.8835451725088785, -0.28427861675733324,
          0.2794511736993273, 2.9624060805274297, 0.7892037022079699>
}

object
{
  BonsaiLeaf(0.004947447892911701)
  matrix <-0.477319788826062, -0.8333345374400841, -0.2787819361159644,
          -0.62473250106158, 0.5449272871992338, -0.5592526743637682,
          0.6179604528708835, -0.09277823222720871, -0.7807157474474349,
          0.33105495341772617, 2.973393841942673, 0.8273841521178101>
}

object
{
  BonsaiLeaf(0.0041940796138863895)
  matrix <0.3986705321639955, 0.8928551147931282, 0.20945536701604814,
          -0.6776331496257323, 0.4406834959611544, -0.5887370983009014,
          -0.6179604528708834, 0.09277823222720888, 0.7807157474474349,
          0.3313037375351978, 2.972546104250416, 0.8276818153212739>
}

object
{
  BonsaiLeaf(0.004966473522153155)
  matrix <-0.33908758282897966, 0.879750514546819, 0.3332546223622527,
          0.3522711347330147, 0.44720839415434965, -0.8221372755396766,
          -0.8723099556952876, -0.16138055754177927, -0.4615535254359889,
          0.3617128934097414, 2.8845955895061683, 0.6720862318642332>
}

object
{
  BonsaiLeaf(0.0031662685465733333)
  matrix <0.4834236417170845, -0.42621704942132027, -0.7646179499668944,
          0.0733275106892261, 0.8901097361730679, -0.4498085523264682,
          0.8723099556952871, 0.16138055754178, 0.46155352543598943,
          0.3601955227371648, 2.8851928673183593, 0.6747451402035651>
}

object
{
  BonsaiLeaf(0.004408596284793745)
  matrix <0.9426969506351307, 0.31648666400400877, -0.10563451505469121,
          -0.3169849895458999, 0.9483483773838282, 0.012484851462713387,
          0.10412960993786341, 0.02171512424726514, 0.9943266453802361,
          0.360842704271662, 2.890525796092657, 0.6775488606016259>
}

object
{
  BonsaiLeaf(0.0043561475439127155)
  matrix <-0.6212858367261419, 0.7821135222149526, 0.04798278287071725,
          0.7766343627587479, 0.622757490318219, -0.09493247513294586,
          -0.1041296099378633, -0.021715124247265197, -0.9943266453802362,
          0.3656232969907592, 2.8890577344713355, 0.6770802800634632>
}

object
{
  BonsaiLeaf(0.004211810080448595)
  matrix <-0.8272592232565574, 0.13172445308240988, -0.5461600919117928,
          -0.5500482535775467, 0.00806594663159603, 0.8350939224070714,
          0.11440758835518408, 0.9912535543265795, 0.0657821766261546,
          0.30543133921914256, 2.841892098590465, 0.7139088824112256>
}

object
{
  BonsaiLeaf(0.004289614052780429)
  matrix <0.22471117885379516, -0.09032252241998784, 0.9702302448603778,
          -0.9676857908561485, 0.09621971200650381, 0.2330793366999679,
          -0.11440758835518404, -0.9912535543265795, -0.06578217662615454,
          0.3035970394311612, 2.8422708717839114, 0.7113914458088312>
}

object
{
  BonsaiLeaf(0.004325818740816061)
  matrix <0.19090740808850554, -0.3486033236561306, 0.917621972422646,
          -0.8677573947803828, 0.3770507545581814, 0.3237743539736741,
          -0.45885887301096484, -0.8580841749053559, -0.23052132967710875,
          0.2852589660882744, 2.8342630515941294, 0.6856292580655114>
}

object
{
  BonsaiLeaf(0.0035706073381551397)
  matrix <-0.4327039855658169, 0.4424140579498627, -0.7855170667807239,
          -0.7760256410290614, 0.26069397788466536, 0.5743020584675844,
          0.45885887301096484, 0.8580841749053558, 0.2305213296771088,
          0.2862418444406422, 2.8335628342042707, 0.6862792760415785>
}

object
{
  BonsaiLeaf(0.0037876924613886825)
  matrix <0.04020596484660624, 0.731544152340742, -0.6806075473919009,
          -0.4984356086078694, -0.5756723592448634, -0.6482000299854637,
          -0.8659938940099159, 0.3653005447265561, 0.341482192156524,
          0.2891206356978434, 2.8264148196660113, 0.673933868739735>
}

object
{
  BonsaiLeaf(0.0033522052326834775)
  matrix <-0.2556032974081999, -0.910305528112783, 0.3255929972240848,
          -0.4297924265172654, -0.19467757320705703, -0.8816910528062603,
          0.8659938940099159, -0.3653005447265562, -0.3414821921565239,
          0.28956780407391625, 2.827942690341762, 0.6734334417459555>
}

object
{
  BonsaiLeaf(0.004234462494988822)
  matrix <0.5925150341696805, -0.3712598246098999, -0.7149070407497249,
          -0.3632017628841664, 0.6690234751748583, -0.6484535982649724,
          0.7190343619888672, 0.6438740034320252, 0.2615642444671673,
          0.7426331533333381, 2.546854945376779, 0.4558749722101412>
}

object
{
  BonsaiLeaf(0.004154832960555173)
  matrix <-0.6717902089033071, 0.7403432168042039, 0.024286550880188995,
          0.17800983540500082, 0.19317916304928093, -0.9648804638206034,
          -0.7190343619888668, -0.6438740034320256, -0.26156424446716753,
          0.7449107187078287, 2.544824617716813, 0.45461190749765723>
}

object
{
  BonsaiLeaf(0.004875000096014449)
  matrix <0.0300200226367206, 0.16851803816043676, -0.9852413252880978,
          -0.35215219940011444, 0.9242694780778984, 0.1473592900066808,
          0.935461183961448, 0.34253117041835546, 0.08709058843111894,
          0.7429283212773573, 2.5459534817588683, 0.4643733607905181>
}

object
{
  BonsaiLeaf(0.0041450334119724685)
  matrix <-0.7826459896166122, -0.2485209969757527, -0.5707035736695653,
          0.6184387235996447, -0.2063121442525687, -0.7582670006576506,
          0.0707021929608817, -0.9463998167772893, 0.31516438046587214,
          0.7850170061697727, 2.516204544367389, 0.4249961182446098>
}

object
{
  BonsaiLeaf(0.003716303321411738)
  matrix <0.8650679262056366, -0.09913725676691626, -0.49176141305618004,
          -0.49664744332454136, -0.30740720734011, -0.8116909054033756,
          -0.07070219296088187, 0.9463998167772893, -0.3151643804658722,
          0.7806078644539969, 2.5159172966729475, 0.4251226706898216>
}

object
{
  BonsaiLeaf(0.0029480407339235676)
  matrix <-0.7060957718570098, -0.5285198975550928, 0.47127006997475207,
          -0.04177114517222036, 0.6954553458357626, 0.7173541896298238,
          -0.7068832523102068, 0.48683526971329255, -0.5131349605771671,
          0.7060628477522409, 2.528261974640749, 0.6094528453108303>
}

object
{
  BonsaiLeaf(0.0032410492375539736)
  matrix <0.5822699555320957, 0.8123900911824429, -0.03136939006792673,
          -0.4015940319377234, 0.3209575671514346, 0.8577345006470447,
          0.7068832523102062, -0.4868352697132934, 0.5131349605771671,
          0.7048844047586933, 2.527251983230904, 0.6101180156884968>
}

object
{
  BonsaiLeaf(0.00499386600684348)
  matrix <0.532350380197067, 0.79357075022031, 0.29470075856504446,
          -0.47835125484804325, -0.005219329267655615, 0.8781530820917828,
          0.6984147404582333, -0.6084556047870462, 0.37682705225857827,
          0.703080772390271, 2.529190414787281, 0.6054344746180852>
}

object
{
  BonsaiLeaf(0.0041063166293137665)
  matrix <0.6224477717410118, 0.10159439464335474, -0.7760395289105438,
          -0.23885030626723153, 0.9688961902798577, -0.06473564441039281,
          0.7453249644622804, 0.22565183677122908, 0.6273531269636514,
          0.7270986709034241, 2.5557959117069586, 0.5391763610757611>
}

object
{
  BonsaiLeaf(0.0037979811927835497)
  matrix <-0.42368156452149897, 0.8868506410625433, 0.1843634246036131,
          0.5147665774250662, 0.4032086172302472, -0.7565964457736734,
          -0.7453249644622799, -0.2256518367712293, -0.6273531269636518,
          0.7300345396676998, 2.5533486959137424, 0.5365686470573375>
}

object
{
  BonsaiLeaf(0.004007422101401738)
  matrix <-0.24365135638592098, -0.345971833398849, -0.9060560175982166,
          0.9624053397818146, 0.02938122401870912, -0.2700235279278703,
          0.12004156984458347, -0.937784748313707, 0.32580636479271924,
          0.7400232531262394, 2.52089061891438, 0.5415866913464367>
}

object
{
  BonsaiLeaf(0.0045027254174542265)
  matrix <0.8390203564624864, 0.27126316015429264, 0.471657862634208,
          0.5306928141126572, -0.21673962206598307, -0.8193833494011723,
          -0.1200415698445835, 0.9377847483137068, -0.32580636479271935,
          0.7385560527200561, 2.519796956942635, 0.5389793313661658>
}

object
{
  BonsaiLeaf(0.00456417699325045)
  matrix <-0.9728279442402283, 0.1129748283882912, -0.2020952227440534,
          -0.045931338159025115, -0.9496932224626202, -0.30979524751597876,
          -0.22692752825572665, -0.29209496976018123, 0.9290771903133479,
          0.708015438507946, 2.432268518377436, 0.3895765216932772>
}

object
{
  BonsaiLeaf(0.004327025154723469)
  matrix <0.28085563804817215, -0.9330637239173531, -0.22474918839906097,
          -0.9325363303894932, -0.20993478928057885, -0.29377436367630605,
          0.2269275282557266, 0.29209496976018134, -0.9290771903133479,
          0.7041899691055518, 2.4356946932199772, 0.3897193129731677>
}

object
{
  BonsaiLeaf(0.004505693193205766)
  matrix <-0.3135353462110887, 0.7458813034399547, -0.5876705436339374,
          0.9480292453118382, 0.21056182848411661, -0.23854615154911343,
          -0.05418613023422106, -0.631921512186554, -0.773135864984997,
          0.7762481783723287, 2.5414766180370307, 0.48194695232092577>
}

object
{
  BonsaiLeaf(0.003769463174864518)
  matrix <0.8063501612055457, 0.42898816561375464, -0.4071468669744823,
          -0.58895100035065, 0.645479942522776, -0.48630480460999287,
          0.054186130234220975, 0.631921512186554, 0.773135864984997,
          0.7697566203471458, 2.542961003913134, 0.48118866003948896>
}

object
{
  BonsaiLeaf(0.002958694655984486)
  matrix <-0.7145792432934551, 0.6232986776017669, 0.31760866416715106,
          0.6407443536014463, 0.7653724093936478, -0.06042969689505192,
          -0.2807546587004722, 0.160324151140281, -0.946294345422781,
          0.7548860909055642, 2.5252364362887296, 0.5125349788638761>
}

object
{
  BonsaiLeaf(0.003467938389829491)
  matrix <0.9499676112536821, -0.09420205895075018, -0.29780448226716316,
          0.13688812653753218, 0.9825589746425344, 0.1258550839754073,
          0.2807546587004721, -0.16032415114028092, 0.9462943454227811,
          0.7534650435998428, 2.526379387019653, 0.5131502295624157>
}

object
{
  BonsaiLeaf(0.0034538495474024777)
  matrix <-0.541542058115891, 0.6111663424718968, 0.5772416314864426,
          0.7743806995404684, 0.6299105743209049, 0.059558379241911236,
          -0.32721053080672813, 0.479258145667064, -0.814398488665682,
          0.5564887087841053, 2.499080266346213, 0.503387788292302>
}

object
{
  BonsaiLeaf(0.004085884081728939)
  matrix <0.8343425872137191, 0.5511387097497328, -0.01088897501687941,
          -0.4436279022905318, 0.6830503293514819, 0.5802038709644526,
          0.3272105308067284, -0.47925814566706393, 0.8143984886656819,
          0.5520015021713005, 2.4996955144619077, 0.5055527283716444>
}

object
{
  BonsaiLeaf(0.0035283509034910172)
  matrix <-0.5631626695403622, -0.8120608804465809, 0.15298671211741732,
          -0.805885261879423, 0.4987808032888264, -0.31900886344439977,
          0.1827477833564808, -0.30294361970320216, -0.9353226239963488,
          0.5359068466950163, 2.5280827082243187, 0.486696999237456>
}

object
{
  BonsaiLeaf(0.004081985023320008)
  matrix <0.14871524937439434, 0.9489145730017244, -0.2782892519456466,
          -0.9718472216772577, 0.08823999334812999, -0.21846437076126968,
          -0.18274778335648095, 0.3029436197032017, 0.9353226239963488,
          0.5347832268830369, 2.5266830288576956, 0.4869308061594352>
}

object
{
  BonsaiLeaf(0.004559478010681718)
  matrix <0.659685276276206, -0.267579652474357, 0.7022937176467471,
          0.7411136131806687, 0.38674734082408907, -0.5487960520300694,
          -0.12476357089583817, 0.8825121098020126, 0.45343844943952527,
          0.5751601914229059, 2.4830431869190592, 0.5038036165909424>
}

object
{
  BonsaiLeaf(0.004261100602742071)
  matrix <0.5949717095044413, 0.5196334744800426, 0.6131800038236425,
          0.20596870376000923, 0.6388544172514858, -0.7412435002276152,
          -0.7769076894720406, 0.5673148030485933, 0.27307207158761604,
          0.6092544578723063, 2.510706867061289, 0.4899833507315722>
}

object
{
  BonsaiLeaf(0.003574961867732725)
  matrix <-0.35110680509751785, -0.030362308297008034, -0.9358430112198797,
          0.5226264951697621, 0.8229410941718819, -0.2227767987689852,
          0.7769076894720406, -0.5673148030485933, -0.2730720715876158,
          0.6102451742958671, 2.510926627149929, 0.49234544529655605>
}

object
{
  BonsaiLeaf(0.0025904317475968276)
  matrix <0.8422635654893527, 0.47859558759668985, 0.24806924392625312,
          0.1631510736454878, -0.6649209053643481, 0.7288771616519347,
          0.5137838197311091, -0.5734339134917248, -0.638122036478977,
          0.6535181316947557, 2.497419225493851, 0.5403132118535278>
}

object
{
  BonsaiLeaf(0.003984748722390253)
  matrix <-0.1731031060393664, -0.797794437915563, 0.5775459717723906,
          0.8402746582291033, 0.18627286890085715, 0.5091570652062175,
          -0.513783819731109, 0.573433913491725, 0.638122036478977,
          0.6564437833447653, 2.4998839082931164, 0.5404539682789627>
}

object
{
  BonsaiLeaf(0.004763405180203326)
  matrix <0.7146688617453321, -0.2895164656975177, 0.6367327807971332,
          0.6890656900285782, 0.4477873065137249, -0.5698025999858404,
          -0.12015362198898563, 0.8459708885152029, 0.5195155078606667,
          0.6486903879919362, 2.5036136855782023, 0.5288297617205483>
}

object
{
  BonsaiLeaf(0.004079629416597706)
  matrix <0.48734994993023484, 0.7676398696789293, -0.41619593556678913,
          0.020227291119502666, 0.46657707359024037, 0.8842492245368014,
          0.8729724411440289, -0.43935733165532254, 0.21185903833386577,
          0.5866513069459147, 2.5177874715705686, 0.5488771694958425>
}

object
{
  BonsaiLeaf(0.003978754580656184)
  matrix <-0.19776680607333016, 0.07822196879707333, 0.9771231314491862,
          0.4458782428181369, 0.89490025070855, 0.01860467315450104,
          -0.8729724411440289, 0.4393573316553227, -0.21185903833386605,
          0.588342827195073, 2.5194445984877767, 0.5453437837763536>
}

object
{
  BonsaiLeaf(0.002296477052454526)
  matrix <-0.8395832318490648, 0.4606104665632572, -0.28798957427354666,
          0.3281454538676755, 0.8525157782131854, 0.40686288722805003,
          0.4329209603424824, 0.2470927882192159, -0.8669051828811479,
          0.5765548362171578, 2.5125683789753217, 0.5354011990319462>
}

object
{
  BonsaiLeaf(0.0038809395221528005)
  matrix <0.591068101328045, 0.6482924857760137, 0.4799534899121142,
          -0.6806011619800569, 0.7201819262494801, -0.1346107403403821,
          -0.4329209603424826, -0.247092788219216, 0.866905182881148,
          0.5731598857641318, 2.5134055785545217, 0.5339444316056383>
}

object
{
  BonsaiLeaf(0.003717080822670971)
  matrix <0.7202144432493777, 0.2283228104910503, 0.6551029308013031,
          0.2219703781392156, 0.8188111953941509, -0.5294122944605031,
          -0.6572825168553649, 0.5267038261743205, 0.5390387486346487,
          -0.3309069875379742, 3.008311953092023, 0.28179190118154557>
}

object
{
  BonsaiLeaf(0.004078090112062495)
  matrix <0.525552335249465, 0.19922710725471002, -0.827105375782768,
          0.47161574122840544, 0.740920391647252, 0.47813760139405914,
          0.7080772101539607, -0.6413622478570147, 0.2954338022034404,
          -0.32214579331889864, 3.016256892744667, 0.2857446043656696>
}

object
{
  BonsaiLeaf(0.004011030153213483)
  matrix <0.43892838585998994, 0.7274978012432445, 0.5273412759045022,
          0.5531442276178321, 0.2437240575118542, -0.7966367097008712,
          -0.7080772101539607, 0.6413622478570148, -0.29543380220344007,
          -0.3218504066338441, 3.014212937165408, 0.28059938227745224>
}

object
{
  BonsaiLeaf(0.004029264080292139)
  matrix <0.6486779963370861, -0.1767750506197775, 0.7402482276550743,
          0.5994840057341755, -0.48053626438202834, -0.6400811085188127,
          0.46886648839196343, 0.858973503719492, -0.20573948568723624,
          -0.3345993124044297, 2.9906348079363263, 0.27865304162243726>
}

object
{
  BonsaiLeaf(0.0030805848243326077)
  matrix <0.09173234698784638, -0.279024941692245, -0.9558923885196178,
          0.8784926821431644, -0.42931294159563693, 0.20962110008157794,
          -0.46886648839196343, -0.858973503719492, 0.20573948568723613,
          -0.3343085205505466, 2.991248480512909, 0.2818778530212369>
}

object
{
  BonsaiLeaf(0.0041833097272330946)
  matrix <0.18811043942455397, -0.736268222938758, -0.6500181278011439,
          -0.025750983646435605, 0.6579083922608635, -0.7526575809981365,
          0.9818102410449503, 0.1583213544766751, 0.10479980580100673,
          -0.37641922825126056, 2.991647854071293, 0.25914039843486214>
}

object
{
  BonsaiLeaf(0.0022638159691719052)
  matrix <0.928910373387739, -0.2891763694347518, -0.23130617279525412,
          -0.00468109688374968, 0.6154177015630681, -0.7881872492845816,
          0.3702750404018844, 0.7332380786370596, 0.5703142243465582,
          -0.37435010007634206, 2.9949777289667856, 0.2518178701225235>
}

object
{
  BonsaiLeaf(0.004071386253044359)
  matrix <-0.6618638836130794, 0.6390362069364811, -0.39187871311522826,
          0.6517918333517196, 0.2323674810744145, -0.7219229596813885,
          -0.3702750404018843, -0.7332380786370596, -0.5703142243465582,
          -0.3716858066243086, 2.994530594314377, 0.2506629537903477>
}

object
{
  BonsaiLeaf(0.0023419214497045213)
  matrix <-0.5988486956165738, 0.7957088518200823, -0.090706465555081,
          -0.7698536577096335, -0.5407463703246107, 0.33899662047262036,
          0.22069341963327288, 0.27283838827394746, 0.9364046285739124,
          -0.4402717254459281, 2.9975813509178377, 0.3097022140047429>
}

object
{
  BonsaiLeaf(0.003955652244757715)
  matrix <-0.50204169258338, -0.791344850418149, 0.3488946354197673,
          -0.8362108307350415, 0.5471129148546507, 0.03766835489718806,
          -0.2206934196332728, -0.27283838827394724, -0.9364046285739124,
          -0.4417765479014922, 3.0010119248711313, 0.3090573134604861>
}

object
{
  BonsaiLeaf(0.004035869820214543)
  matrix <-0.39574738468190845, 0.5328686805253298, 0.7479538600960784,
          -0.8840164690318252, -3.978394928420559E-4, -0.467455585274412,
          -0.2487948753450017, -0.8461978557281576, 0.47122213335446445,
          -0.4372725467798909, 2.9971030167390644, 0.30640681679349135>
}

object
{
  BonsaiLeaf(0.004234898350511177)
  matrix <-0.561581575954623, 0.1847301270009306, 0.8065363685082911,
          -0.8089902696632093, -0.32717966641991936, -0.48835254629375985,
          0.17366887210600207, -0.9267298668218101, 0.3331829479458077,
          -0.4220857864604847, 2.9786406380030477, 0.3124047870044249>
}

object
{
  BonsaiLeaf(0.004390271331895386)
  matrix <-0.6793987222124083, -0.3576659090506364, -0.6406968657322504,
          -0.7129211030104082, 0.11509496706377438, 0.6917345223704046,
          -0.17366887210600207, 0.9267298668218102, -0.3331829479458074,
          -0.42178971198235826, 2.9805315087670357, 0.3175098126400374>
}

object
{
  BonsaiLeaf(0.004064326848643895)
  matrix <-0.15126333623397858, 0.1550022599609735, 0.976265180429148,
          0.911968768101772, 0.4029054276194165, 0.0773316390732352,
          -0.38135596116791515, 0.9020207956592832, -0.2023020392380901,
          -0.3690347792413005, 3.002591717564812, 0.3304589224854753>
}

object
{
  BonsaiLeaf(0.004996525547070549)
  matrix <0.802247791115986, 0.214197886251017, -0.5572411929991521,
          0.4593104750941548, 0.3748036148755646, 0.8053298316497358,
          0.3813559611679153, -0.9020207956592832, 0.20230203923808984,
          -0.3704463618677762, 3.002826894054734, 0.33416847250619625>
}

object
{
  BonsaiLeaf(0.004458863332564162)
  matrix <0.1278973692355172, 0.38527533864771646, -0.9138956047451594,
          0.7456246362555852, 0.5702537628898371, 0.34475287920292846,
          0.6539771897790945, -0.7255160641501118, -0.21433682816718605,
          -0.3678063046716295, 3.005270258864002, 0.32787434517200204>
}

object
{
  BonsaiLeaf(0.003602457607236906)
  matrix <0.9010516226639855, 0.0035018789348735813, -0.4336977174698124,
          -0.07068598108924262, 0.9877830737312889, -0.13888157303047305,
          0.4279129179775384, 0.15579581539275325, 0.8902910751737635,
          -0.36519702151980904, 3.013044964525764, 0.32167206998295816>
}

object
{
  BonsaiLeaf(0.00323154150091684)
  matrix <0.13895168864232144, 0.9619810417581312, -0.2351274197565822,
          0.8930750040457954, -0.22432150856315108, -0.389996022985563,
          -0.4279129179775383, -0.15579581539275333, -0.8902910751737636,
          -0.3620563693305036, 3.008761613613031, 0.32091209662875647>
}

object
{
  BonsaiLeaf(0.00366485156166301)
  matrix <-0.9283301824907497, -0.017554959372335532, -0.3713420198120967,
          -0.3105878054645851, 0.5855627960292271, 0.7487666038246676,
          0.204299504094808, 0.8104369409817583, -0.5490479736040796,
          -0.4821788009370744, 2.9178458150345934, 0.43436042166350197>
}

object
{
  BonsaiLeaf(0.0048121535108419135)
  matrix <-0.21404085151291025, 0.5842888188674841, 0.7828110180816752,
          -0.9552215588596418, 0.04240920700238293, -0.2928365288880225,
          -0.20429950409480804, -0.8104369409817582, 0.5490479736040794,
          -0.48563721551128236, 2.9159038939214823, 0.4302071288755628>
}

object
{
  BonsaiLeaf(0.0038954409971626663)
  matrix <-0.9133953266252985, -0.28131499009157984, -0.29422925355722,
          -0.3038359735931332, 0.9521577750142971, 0.03285228501240134,
          0.2709108311784101, 0.11940455531342822, -0.9551700758088191,
          -0.422718752777113, 2.8876916080001296, 0.4204129391661993>
}

object
{
  BonsaiLeaf(0.004557728981052089)
  matrix <-0.18512485634026576, 0.9577651615654987, 0.22003336759775768,
          0.6803193656607883, 0.28647956089600035, -0.6746073093998737,
          -0.709150441212511, 0.024806379829568403, -0.7046206747235375,
          -0.4023798588268404, 2.9264234694663562, 0.41606977456414834>
}

object
{
  BonsaiLeaf(0.004531886709531961)
  matrix <0.7049376246687225, 0.043350987220725834, -0.7079432443589015,
          -0.012984492848055362, 0.9987518888226141, 0.04822932218826165,
          0.7091504412125106, -0.024806379829568057, 0.7046206747235377,
          -0.4055394143666517, 2.9296440036802567, 0.41936302167326445>
}

object
{
  BonsaiLeaf(0.0036744242081983383)
  matrix <0.40238530866429156, 0.16526498983498017, 0.9004296455059589,
          -0.23000799349579365, 0.9702714139193084, -0.07529745187630915,
          -0.8861051778988666, -0.1768074276320712, 0.4284352310851055,
          -0.4118615886362837, 2.917816897195442, 0.43191193192834987>
}

object
{
  BonsaiLeaf(0.003975767161146919)
  matrix <-0.2534511154709229, 0.9587714979060097, -0.12852916738861786,
          0.38804657680150134, 0.2224777479596471, 0.8943844284732605,
          0.8861051778988663, 0.1768074276320714, -0.42843523108510567,
          -0.4094736588598607, 2.915136228148038, 0.43574447094850494>
}

object
{
  BonsaiLeaf(0.004143916186093209)
  matrix <0.029215114911002222, 0.8083516426788858, 0.5879745732929992,
          0.37695522361648287, 0.5358847667758692, -0.7554682495815551,
          -0.9257706176202531, 0.24371117847960747, -0.28905643918635837,
          -0.41139393903918803, 2.8560470870474597, 0.2961504943516948>
}

object
{
  BonsaiLeaf(0.0023917507282538377)
  matrix <0.21764800332555576, -0.2816251418636914, -0.9345141123164781,
          0.3091570963109444, 0.9280582637713737, -0.20767703013633548,
          0.9257706176202531, -0.24371117847960747, 0.28905643918635837,
          -0.4122165831815182, 2.856046109516774, 0.29878437977114514>
}

object
{
  BonsaiLeaf(0.004988926598286683)
  matrix <0.8135189980664206, 0.16535336629873373, -0.5575348455824835,
          -0.5576546540186665, -0.05012049060896647, -0.8285585213323429,
          -0.16494886066999265, 0.9849599995303325, 0.05143610297133848,
          -0.42173690071816256, 2.8131648992594624, 0.32577945524888474>
}

object
{
  BonsaiLeaf(0.004691826608819431)
  matrix <-0.08701306362782302, -0.8955496598963668, -0.43637086682958276,
          0.958255231717436, 0.04451193241979509, -0.28242804173526864,
          0.272352047255503, -0.4427295952743129, 0.8542920272506233,
          -0.4417266372066188, 2.9711782271845957, 0.6746809858450892>
}

object
{
  BonsaiLeaf(0.004116241934437983)
  matrix <0.6774121507938562, 0.7187571350943145, 0.15652782087493458,
          0.683327988825702, -0.5360771271181568, -0.4956653845773018,
          -0.27235204725550305, 0.44272959527431277, -0.8542920272506234,
          -0.4434098612782516, 2.9687627617649217, 0.6739658106049331>
}

object
{
  BonsaiLeaf(0.0037847992710427374)
  matrix <0.32845852319376084, -0.4567238728522133, 0.8267516570943473,
          0.9237619156587147, -0.02715899325755267, -0.3820030265112806,
          0.19692364439019505, 0.8891938444749331, 0.41298351689622237,
          -0.44340890389361215, 2.9721282710219894, 0.6750422711233564>
}

object
{
  BonsaiLeaf(0.004040805265389505)
  matrix <0.4282898248236806, 0.3008931871390364, -0.8520745952590146,
          0.8819234117725788, -0.34467027269725536, 0.3215796929008648,
          -0.19692364439019472, -0.8891938444749335, -0.4129835168962214,
          -0.4433414765526534, 2.9708383169071344, 0.6777875168159485>
}

object
{
  BonsaiLeaf(0.0024455081670297484)
  matrix <0.9571031780966822, 9.206716153259686E-4, 0.28974585215496673,
          -0.25076014915513445, -0.4983707175490701, 0.8299072089609287,
          0.14516492025598177, -0.8669635403253136, -0.47676132988495656,
          -0.45156837326524796, 2.921414085719903, 0.7836421020437757>
}

object
{
  BonsaiLeaf(0.004262677493418787)
  matrix <-0.6336936146464898, -0.45153026259525586, 0.6281344002018396,
          0.7598417918773229, -0.2109375303431266, 0.6149356141982687,
          -0.14516492025598157, 0.8669635403253135, 0.47676132988495656,
          -0.447716176767729, 2.9217336967167666, 0.7842338293889295>
}

object
{
  BonsaiLeaf(0.0024198191454459237)
  matrix <0.5303850393845875, -0.8422829899676813, -0.09618250780735628,
          0.17011418742485035, -0.005405712634239779, 0.9854095298441649,
          -0.8305136201374383, -0.539008481456478, 0.1404171773117122,
          -0.4551803772034791, 2.931234634752833, 0.775853604318291>
}

object
{
  BonsaiLeaf(0.003225456661253766)
  matrix <-0.23397238901843445, 0.5663739569795347, 0.7902388639091029,
          0.50547408236547, -0.6234503972035991, 0.5964943874702096,
          0.8305136201374383, 0.5390084814564777, -0.1404171773117122,
          -0.45396163802506484, 2.929236803363138, 0.7753930582673354>
}

object
{
  BonsaiLeaf(0.004510537199797389)
  matrix <-0.14236642677154748, 0.05769103788853835, 0.9881313397902345,
          0.9837838580495508, -0.1017803050389609, 0.1476823961998111,
          0.10909225989704083, 0.9931326767625356, -0.04226541348475399,
          -0.45333816159711793, 2.9307410135111667, 0.7624850385372439>
}

object
{
  BonsaiLeaf(0.004215084792609081)
  matrix <-0.9671285527748168, 0.13741102544246947, 0.21396395139027005,
          0.03126373520684461, 0.8992935149923706, -0.43622672173261257,
          -0.25235875508609823, -0.4151980057508886, -0.8740284175882839,
          -0.5849286990250737, 3.0041650375834625, 0.6078224487142768>
}

object
{
  BonsaiLeaf(0.0035668690138467595)
  matrix <-0.6115481393604751, 0.29505907085515576, -0.7341314718433161,
          -0.5586054322375468, 0.4960935728282641, 0.6647188413706889,
          0.560329228507174, 0.8165973987863169, -0.13856350160116182,
          -0.598212881949057, 3.0087302607008444, 0.6133288864708338>
}

object
{
  BonsaiLeaf(0.003974413063270009)
  matrix <-0.35599567323528125, 0.38849114080911806, 0.8499068855766428,
          -0.7478624447840087, 0.4268996624597518, -0.5083880819545596,
          -0.560329228507174, -0.8165973987863169, 0.1385635016011617,
          -0.599192723811921, 3.00865743550314, 0.6089373771984976>
}

object
{
  BonsaiLeaf(0.004959288613228327)
  matrix <-0.3381713775649274, -0.5301295143749135, 0.7775620987319644,
          -0.6962628125217799, 0.696810104744344, 0.1722607727413203,
          -0.6331336472618565, -0.48313391095512426, -0.6047506997020388,
          -0.6021598312293202, 3.000860724860608, 0.6211252749263992>
}

object
{
  BonsaiLeaf(0.0042068593058302095)
  matrix <-0.561211767680435, 0.8246022374876483, -0.07122149778939929,
          -0.5330883008675968, -0.2943004825269066, 0.7932238583543287,
          0.6331336472618565, 0.4831339109551238, 0.6047506997020392,
          -0.6009494904707006, 2.9961669617189384, 0.6236079652077617>
}

object
{
  BonsaiLeaf(0.0022984068739638737)
  matrix <0.6963918787064842, -0.08819353310367539, 0.7122220524459666,
          -0.6404165330408061, 0.37152433952451747, 0.6721877188322208,
          -0.3238904374624983, -0.9242248459436482, 0.2022459360797887,
          -0.6233032703798621, 3.037346934609182, 0.6297302471156162>
}

object
{
  BonsaiLeaf(0.003273658783319656)
  matrix <-0.8910275360419898, 0.36985366694354016, 0.263207513310995,
          0.31806432452460465, 0.09495630146996561, 0.9433018532134092,
          0.32389043746249846, 0.9242248459436482, -0.20224593607978864,
          -0.6207900985484803, 3.0368038750437125, 0.6312733346391519>
}

object
{
  BonsaiLeaf(0.0035047609754261457)
  matrix <0.8026031719503044, 0.3686064632330954, -0.4689961872319423,
          -0.3415558375870216, -0.36060684851734554, -0.8679298995959386,
          -0.4890478076686766, 0.8567916760013345, -0.16352451115745484,
          -0.6095716524906842, 2.9848911200155346, 0.5810569335061402>
}

object
{
  BonsaiLeaf(0.0024705643066268187)
  matrix <-0.8660632625040772, -0.4992673523143506, -0.025817363417133865,
          0.10376255179618266, -0.1289966466534748, -0.98620139829393,
          0.4890478076686767, -0.8567916760013344, 0.1635245111574548,
          -0.6081182288633481, 2.985836266314793, 0.5816623463738791>
}

object
{
  BonsaiLeaf(0.004931159913195582)
  matrix <-0.7624352940918252, 0.2443633645047384, 0.5991485361836715,
          -0.43020522702272795, 0.5002224345700028, -0.7514658865146056,
          -0.48333827177809513, -0.8307009462139686, -0.27626084230991044,
          -0.609109183949109, 3.038738200090772, 0.5944885974805538>
}

object
{
  BonsaiLeaf(0.004030170248509472)
  matrix <-0.035400993804493686, 0.33385877153878635, -0.9419581149415647,
          -0.8747176028137419, 0.44550449899617045, 0.19077436070382242,
          0.4833382717780951, 0.8307009462139685, 0.2762608423099105,
          -0.6105130340378747, 3.0380669822511708, 0.5989630490889556>
}

object
{
  BonsaiLeaf(0.004710689272524578)
  matrix <0.1653739914242034, -0.32266077642189417, -0.931955721222445,
          -0.7904019469696133, -0.6085266329771137, 0.07042797160349629,
          -0.5898442211186555, 0.7249726617717094, -0.3556661840779486,
          -0.622126478259315, 3.0115681113032804, 0.5661091925487739>
}

object
{
  BonsaiLeaf(0.003550757687280612)
  matrix <-0.7634419616630046, -0.6441688679681247, -0.04693442992952318,
          0.2631352617667792, -0.2438464870042363, -0.9334338352505875,
          0.5898442211186555, -0.7249726617717094, 0.3556661840779486,
          -0.6174688107332297, 3.0135688513970447, 0.5624630308923718>
}

object
{
  BonsaiLeaf(0.004965931745636583)
  matrix <0.5195971549596539, 0.7223584799362823, 0.45630803523713787,
          -0.7829900194075784, 0.18881558235141432, 0.5926848280236439,
          0.3419728440475269, -0.6652419877949974, 0.6637075196263835,
          -0.5914749962314478, 3.0343919561164974, 0.6357866613205958>
}

object
{
  BonsaiLeaf(0.0038022739224617716)
  matrix <-0.6286694196857663, 0.15748586906582812, 0.7615595589292687,
          0.3424286328798461, 0.9352939699703134, 0.08926265244327836,
          -0.6982244568446468, 0.3168964985318559, -0.6419183881789395,
          -0.5716323037998947, 3.031401082089265, 0.6207501873025322>
}

object
{
  BonsaiLeaf(0.004311071346814646)
  matrix <0.7992418261273168, 0.2684572765414132, 0.5377203678871014,
          -0.6002693307267642, 0.31217170534031274, 0.7363596654989757,
          0.02982002611526441, -0.9113064890896407, 0.41064735355971416,
          -0.582090039342455, 3.037918314765378, 0.6472205154710086>
}

object
{
  BonsaiLeaf(0.004156340899778707)
  matrix <-0.989558597833077, 0.03104261033104519, 0.1407484912831024,
          0.14101257921589755, 0.41055674307816004, 0.9008654800889719,
          -0.029820026115263465, 0.911306489089641, -0.4106473535597137,
          -0.5789161390800088, 3.038278934054135, 0.6477903204562185>
}

object
{
  BonsaiLeaf(0.004731609634769286)
  matrix <-0.5153777439853111, -0.8274518801145211, 0.22295552717875106,
          -0.8393999784741732, 0.5398337424035317, 0.06314433228845476,
          -0.17260781309711576, -0.15460568119425888, -0.972781386643623,
          -0.5854138872639086, 3.0346903139078836, 0.6365893920405112>
}

object
{
  BonsaiLeaf(0.004553323143568279)
  matrix <-0.303286719769678, 0.9479650786216718, -0.09684717510157803,
          -0.9371359071496408, -0.2783150967092264, 0.21051602902048533,
          0.1726078130971157, 0.15460568119425877, 0.972781386643623,
          -0.5857092568530284, 3.030868772800103, 0.6372491652165052>
}

object
{
  BonsaiLeaf(0.004995379122998879)
  matrix <0.9234220624657206, 0.059104020969092966, 0.3792076070661572,
          0.33855612459382367, -0.5908031855365399, -0.7323464661346355,
          0.18075244134331178, 0.8046479420623418, -0.565570724386677,
          -0.6382012520106985, 2.5220929610282368, 0.6637765604022963>
}

object
{
  BonsaiLeaf(0.0032541726282384006)
  matrix <-0.4097700894810016, 0.8745704379072278, -0.259258602375103,
          0.06046158444142545, -0.25755068095091443, -0.964371320368121,
          -0.9101828775436096, -0.41084570811982457, 0.05265865119764644,
          -0.643915463820061, 2.529462618117236, 0.6772534223541632>
}

object
{
  BonsaiLeaf(0.004701553791582165)
  matrix <0.045230162748185865, -0.6454033424637676, 0.7625016445322391,
          -0.8787517579806995, -0.3887357787882595, -0.2769112531763856,
          0.47513111898043847, -0.6575249195479075, -0.5847319043372909,
          -0.6622728386365531, 2.5202824247060183, 0.6868162530538285>
}

object
{
  BonsaiLeaf(0.003235054978234771)
  matrix <-0.571572299746335, -0.1501852933205528, 0.806690451060942,
          -0.2554689275150508, -0.9016756860518926, -0.3488790395784175,
          0.7797696667843627, -0.40549393935429956, 0.47700516968889956,
          -0.6641295400411934, 2.5112562289208507, 0.6917995344370934>
}

object
{
  BonsaiLeaf(0.0027751027152421444)
  matrix <-0.1483656727042888, -0.8598906635012518, -0.4884420886721184,
          -0.6082325985394142, -0.31010113184299853, 0.7306780372391684,
          -0.7797696667843627, 0.40549393935429967, -0.4770051696888995,
          -0.6649909919511571, 2.5133126368447893, 0.6949558839159935>
}

object
{
  BonsaiLeaf(0.003195241939368232)
  matrix <-0.5179721075035733, -0.2642163943413179, 0.8135690461230566,
          -0.5696774708117168, -0.6029408450400049, -0.5585068635495996,
          0.6381006778697801, -0.7527629336940801, 0.16178841293000357,
          -0.6728478373298322, 2.5157677265119607, 0.6851853664841434>
}

object
{
  BonsaiLeaf(0.0028933671577673244)
  matrix <-0.573311799565722, -0.6047869592767007, -0.5527624393603066,
          -0.5139465977909, -0.2599628810909824, 0.817482840843791,
          -0.6381006778697802, 0.7527629336940801, -0.16178841293000307,
          -0.6725146161900758, 2.516942100324603, 0.6893352090417179>
}

object
{
  BonsaiLeaf(0.00276400187946526)
  matrix <0.9884662316232882, 0.13185159211184944, 0.07449608444761521,
          -0.04963406982422422, -0.18268585421509956, 0.9819176838118268,
          0.1430767907563617, -0.9742900165388482, -0.17403446675756637,
          -0.6673928154881609, 2.543537245297374, 0.8625479338552404>
}

object
{
  BonsaiLeaf(0.004942508944093569)
  matrix <-0.6502435244363675, -0.22510354022210197, 0.7256112975333603,
          0.7461316176623474, -0.00934664925021124, 0.6657328663002616,
          -0.14307679075636115, 0.9742900165388482, 0.1740344667575663,
          -0.663567864632114, 2.5439959934442595, 0.8631243021777705>
}

object
{
  BonsaiLeaf(0.003572848226259636)
  matrix <0.0033955403779693527, -0.9695177663462927, 0.2449974919145828,
          0.442871377251963, 0.2211200376765335, 0.8688905984926285,
          -0.8965787268926757, 0.10555202355626842, 0.4301224904683381,
          -0.6255451077276603, 2.5200328702753345, 0.844077816914906>
}

object
{
  BonsaiLeaf(0.004749004652330637)
  matrix <0.32199911060583825, 0.8221565762519737, 0.4694413029279395,
          0.3040775546674863, -0.5593901451123435, 0.7711157541502005,
          0.8965787268926757, -0.10555202355626844, -0.4301224904683381,
          -0.6256833542205509, 2.516586295539325, 0.8446354349852128>
}

object
{
  BonsaiLeaf(0.0028826660599098617)
  matrix <0.030820855443650597, 0.5054421860122438, 0.8623098465568428,
          0.9564348197994865, -0.2654927474901796, 0.121433259468894,
          0.2903145024707612, 0.8210004857667745, -0.4916052196894111,
          -0.6164897218781703, 2.539809027302888, 0.8042862584108952>
}

object
{
  BonsaiLeaf(0.003412850822168398)
  matrix <-0.32790524290617745, -0.42274524165535615, 0.8448459104075694,
          0.6007383669831631, 0.596883325875491, 0.5318305272605321,
          -0.7291032616228265, 0.6819213707969319, 0.058238114164091304,
          -0.6118143981698763, 2.545240705035405, 0.8191338392028209>
}

object
{
  BonsaiLeaf(0.0021627294578307954)
  matrix <0.5121007379685439, 0.48711531081472337, 0.7074401092261796,
          -0.45404985195794306, -0.5456206722809428, 0.7043697991230612,
          0.729103261622826, -0.6819213707969323, -0.058238114164091276,
          -0.614846615589696, 2.5420236013852087, 0.8188421422643754>
}

object
{
  BonsaiLeaf(0.0024572106621870483)
  matrix <-0.4898807352453079, -0.28613757834650927, 0.8234938685221111,
          0.04449347237722173, -0.9515768615920496, -0.30417397554433,
          0.8706533157068514, -0.1123688690902442, 0.4788904270373816,
          -0.6146442994768542, 2.4981191452193308, 0.8169188966307775>
}

object
{
  BonsaiLeaf(0.0028278565918187495)
  matrix <0.304136706803539, -0.6421919820536952, -0.703626549925914,
          -0.386605312202722, -0.7582629461112589, 0.5249510807030597,
          -0.8706533157068516, 0.11236886909024424, -0.47889042703738144,
          -0.6158468936921218, 2.4983131111590327, 0.8191508025405934>
}

object
{
  BonsaiLeaf(0.0035673953116646282)
  matrix <-0.3021812279478079, 0.788347989744269, -0.5359047980211833,
          -0.05470532330510888, -0.575601943492352, -0.8158981126647561,
          -0.9516794802232731, -0.21723224832882687, 0.2170629337495562,
          -0.4358078151979432, 2.4373787269852265, 0.4740495047197438>
}

object
{
  BonsaiLeaf(0.00420137851244729)
  matrix <0.06720472311086619, -0.8370221696299482, -0.543026162113361,
          -0.29964928185055506, 0.5021992013474106, -0.8111758564284751,
          0.9516794802232732, 0.21723224832882687, -0.2170629337495562,
          -0.4368715997380987, 2.4415420555933354, 0.4735520790086454>
}

object
{
  BonsaiLeaf(0.0044067261833109946)
  matrix <0.6955656790589879, 0.6491017479807599, 0.3079858874746235,
          0.07471377257885525, 0.36099972578508993, -0.9295682063034028,
          -0.7145671685028953, 0.6695865282033471, 0.2026021790266423,
          -0.4224629477497872, 2.457097742304869, 0.46905237158261864>
}

object
{
  BonsaiLeaf(0.0035405286897567446)
  matrix <0.5838929238508668, 0.19342946715370768, -0.7884504389709723,
          0.5437523690077083, 0.6279888283436704, 0.5567435609632587,
          0.6028286777148149, -0.7538004196816135, 0.26150050212653886,
          -0.4132790565931933, 2.4649236238216425, 0.4780434675793666>
}

object
{
  BonsaiLeaf(0.003944027994636287)
  matrix <0.3267187618689905, 0.5322260647208876, 0.7810187364426747,
          0.7279096344790355, 0.38538337187733046, -0.567121874655754,
          -0.6028286777148149, 0.7538004196816135, -0.26150050212653897,
          -0.4123333314798375, 2.464220174165397, 0.473835556478926>
}

object
{
  BonsaiLeaf(0.004136256984939389)
  matrix <-0.2156766262285517, -0.8461169447405508, -0.4874112316325767,
          -0.42840468147794203, -0.36656111594565655, 0.8258948947441548,
          -0.8774696700094277, 0.3869354779541293, -0.28342179541093326,
          -0.4540572547368589, 2.4202138267182893, 0.5830042477532066>
}

object
{
  BonsaiLeaf(0.0035394425833848854)
  matrix <-0.2786530988116594, 0.06969790344738686, 0.9578594118020133,
          -0.3903836942499095, -0.9194689435513568, -0.04666297363376121,
          0.8774696700094275, -0.3869354779541294, 0.283421795410933,
          -0.45366700355200223, 2.418475610161621, 0.5794229733100487>
}

object
{
  BonsaiLeaf(0.0043156117967274215)
  matrix <0.8856903735276627, 0.12196802742233798, 0.4479691535442302,
          0.13626772536333054, -0.9906719993686168, 3.109522332475634E-4,
          0.4438284232276412, 0.06076833018679438, -0.8940489588280807,
          -0.39665894519474293, 2.3647708184774983, 0.5655699267724741>
}

object
{
  BonsaiLeaf(0.0029228056754970035)
  matrix <0.4765549192118165, -0.23192289845276046, 0.8480018739061195,
          0.8791131452273162, 0.13388593386020217, -0.45742172511033846,
          -0.007448950500270508, 0.9634761677839533, 0.267690469103389,
          -0.38267331901435797, 2.368043007221978, 0.5695692455615019>
}

object
{
  BonsaiLeaf(0.00434461254350248)
  matrix <0.847595185891004, 0.14812549338717484, -0.5095500358779316,
          0.5305910986728292, -0.2230975399262714, 0.8177411410024609,
          0.007448950500270803, -0.9634761677839531, -0.26769046910338967,
          -0.38293758316186766, 2.366682412284234, 0.5744589687942874>
}

object
{
  BonsaiLeaf(0.0033945031774634325)
  matrix <0.5940141164261856, 0.5163938189784242, -0.6168343806949291,
          -0.004992304438892946, -0.7643922768029179, -0.6447321335721071,
          -0.804439125343123, 0.38605941367220925, -0.45148180775338276,
          -0.4403757748349023, 2.40078859563704, 0.5606749183822815>
}

object
{
  BonsaiLeaf(0.0036325728821868957)
  matrix <-0.5394289433713562, -0.7930446698926741, 0.28301336824977386,
          0.24878526618442415, -0.4712093809230561, -0.8462077822022533,
          0.804439125343123, -0.3860594136722092, 0.4514818077533827,
          -0.43945509783019243, 2.4016716252305033, 0.5597895522159814>
}

object
{
  BonsaiLeaf(0.0026400603179275142)
  matrix <-0.5685350736600684, 0.41359057881183087, -0.7111333933492617,
          -0.8184417004945999, -0.19694754498619388, 0.539782222211346,
          0.0831928657388886, 0.8889063491965878, 0.450471363627196,
          -0.5230506111953258, 2.4799244905907565, 0.6097542041111629>
}

object
{
  BonsaiLeaf(0.0031200629328318004)
  matrix <-0.389357865064222, -0.38711318762896635, 0.8357893471900512,
          -0.9173218628173989, 0.24492627936122904, -0.3138976229210457,
          -0.0831928657388886, -0.8889063491965878, -0.450471363627196,
          -0.5237519776809657, 2.4812086293944993, 0.6073497661480001>
}

object
{
  BonsaiLeaf(0.003578456608459054)
  matrix <-0.9337577711290574, -0.3546698717035183, 0.04801777756107881,
          -0.19091043789681603, 0.6070556642611992, 0.7713861712465687,
          -0.302736898243576, 0.7111207370019552, -0.6345531245275331,
          -0.5200294133456262, 2.488885910197589, 0.6278448232130848>
}

object
{
  BonsaiLeaf(0.004149718944244153)
  matrix <0.4510099347019644, 0.6934218256955467, 0.5619218899893343,
          -0.8396072946574425, 0.11607527322755096, 0.5306468898459317,
          0.3027368982435759, -0.7111207370019553, 0.6345531245275331,
          -0.5228303829238762, 2.4871952676043816, 0.6272864867224115>
}

object
{
  BonsaiLeaf(0.004520219620057532)
  matrix <-0.527998800395212, 0.23886981440509986, 0.8149591882709774,
          -0.8489950306632077, -0.17175511622500836, -0.49970753242242927,
          0.020608364573544063, -0.9557412787028751, 0.29348578073391707,
          -0.5166644823138086, 2.4788512617025598, 0.6098616559196373>
}

object
{
  BonsaiLeaf(0.0049758600397017795)
  matrix <0.8105600435406561, -0.5452835927801813, -0.21367783989011968,
          -0.09373391384219829, -0.4809360014975877, 0.8717307588122241,
          -0.5781058460275197, -0.6865612615843174, -0.4409390716193756,
          -0.48666804421045545, 2.4761102911722723, 0.6206627275694169>
}

object
{
  BonsaiLeaf(0.0035829374979602546)
  matrix <-0.6471879277838573, -0.4663251425483984, 0.6030660391350632,
          -0.7164680614640812, 0.6423214313974628, -0.27220708232780644,
          -0.2604252350152343, -0.6082466935337427, -0.7498097470508968,
          -0.5115648999825304, 2.4948031592816675, 0.6038558633161131>
}

object
{
  BonsaiLeaf(0.00264054587597282)
  matrix <-0.3554019574891533, 0.7824702128859867, -0.5113020776009396,
          -0.8977015904966079, -0.13332788812333302, 0.41994705460145043,
          0.2604252350152344, 0.6082466935337429, 0.7498097470508964,
          -0.51136826193166, 2.492149703334234, 0.6059400537417505>
}

object
{
  BonsaiLeaf(0.003528262493139373)
  matrix <-0.22821522981332473, -0.6906195979817263, -0.6862669886893951,
          0.7060727113817958, 0.3679223462961383, -0.6050574132575388,
          0.6703574681639726, -0.6226377100525664, 0.40366216926693227,
          0.04656200280606279, 2.230111011553852, -0.48072004759834513>
}

object
{
  BonsaiLeaf(0.002834495830309804)
  matrix <0.6861992509517167, -0.6889699506804621, -0.23334736992875033,
          0.05553987932428256, 0.3694781522681514, -0.9275781459268845,
          0.7252902245294279, 0.6235433441677284, 0.2918009392482793,
          0.05715311584511517, 2.2324729775708354, -0.503509382198327>
}

object
{
  BonsaiLeaf(0.0037139623575101807)
  matrix <-0.335154315267574, 0.6900434857061671, -0.6414916778821114,
          0.6013532033335959, -0.3674692990966838, -0.7094650372370828,
          -0.7252902245294277, -0.6235433441677288, -0.2918009392482792,
          0.05922909144950372, 2.230060926144455, -0.5035150922536787>
}

object
{
  BonsaiLeaf(0.004828277483101142)
  matrix <0.4551763690408054, -0.6409384046995881, 0.6180715447648241,
          0.8343265876571585, 0.5494594029102196, -0.04464873662162567,
          -0.3109881319201606, 0.535996572689315, 0.7848528880434326,
          0.07840466257343974, 2.2786222054727303, -0.5037230939227627>
}

object
{
  BonsaiLeaf(0.0029581522406475157)
  matrix <0.3437183304620434, 0.8333339030082361, -0.4329114405989354,
          0.8860835689195434, -0.13513800413787325, 0.44338880086041615,
          0.31098813192016067, -0.5359965726893151, -0.7848528880434325,
          0.07699747239150237, 2.2755695042200434, -0.5021959058583404>
}

object
{
  BonsaiLeaf(0.004239434078018352)
  matrix <-0.5613832681207651, 0.5787723978168647, 0.5914992289085146,
          0.7068119904489182, -0.03642193859939086, 0.7064631997112809,
          0.43042494866316544, 0.8146753671947986, -0.38863660359561103,
          0.058462571131938965, 2.2293985306895068, -0.3764509894662232>
}

object
{
  BonsaiLeaf(0.0026036956672759416)
  matrix <0.5800473699447357, 0.08024073350613617, 0.810621041736885,
          -0.6915774809726718, 0.5743391600547701, 0.43801269050003105,
          -0.4304249486631664, -0.8146753671947983, 0.3886366035956108,
          0.05366543100208368, 2.231048343479774, -0.37830554188547827>
}

object
{
  BonsaiLeaf(0.0038094186097301346)
  matrix <0.48791151850327413, -0.833918872713142, 0.25791794013730873,
          0.21026313951036077, 0.39905539872489915, 0.8924932497849822,
          -0.8471905112045794, -0.38122710092719664, 0.37004612583240104,
          0.048169534982115285, 2.2247803121801537, -0.4041120811670356>
}

object
{
  BonsaiLeaf(0.004967542223577192)
  matrix <-0.8580388396278052, 0.19210370187752998, -0.4763040178448213,
          0.36257697503850345, 0.8834066473784319, -0.29686803893233193,
          0.3637406862891467, -0.4274211776369407, -0.827649593756532,
          0.04590990918510604, 2.254205580711571, -0.4340255708778776>
}

object
{
  BonsaiLeaf(0.0023741387888180235)
  matrix <0.10506355124461403, -0.31536119549472247, -0.9431378301054467,
          0.9938784382524508, 0.06588038721205901, 0.08868722883064872,
          0.03416577493254071, -0.9466821488529977, 0.3203523199015895,
          0.034486618793368284, 2.1811735570000645, -0.4216458860183365>
}

object
{
  BonsaiLeaf(0.002675350518645837)
  matrix <0.36884654213257273, 0.30985486442961413, 0.876323108987861,
          0.9288621685589872, -0.08822058734998549, -0.3597668686629165,
          -0.03416577493254047, 0.9466821488529978, -0.32035231990158886,
          0.03461204532614805, 2.18078112682324, -0.4228189442870451>
}

object
{
  BonsaiLeaf(0.0033892739065371925)
  matrix <0.12275906304921663, -0.6339275227893582, -0.7635876559304939,
          0.5378742033418372, 0.6891043278934688, -0.48561977581012383,
          0.8340392999245679, -0.35109987343865384, 0.4255670629321526,
          0.03563064311403081, 2.192036441112691, -0.43529930897803476>
}

object
{
  BonsaiLeaf(0.004126842322842612)
  matrix <0.298528272771727, 0.9358897052873394, 0.1870596960681447,
          0.46396046872257013, 0.028971337707105305, -0.8853820333924753,
          -0.8340392999245678, 0.35109987343865307, -0.42556706293215313,
          0.035722331810095036, 2.189820437937879, -0.4373072425906716>
}

object
{
  BonsaiLeaf(0.004643493136282865)
  matrix <-0.4844591263253216, -0.6198047350900925, -0.6173665404603711,
          0.6384603014215927, -0.7329532315854792, 0.23483612119316852,
          -0.598053340788893, -0.2803955254070644, 0.7508066001993732,
          0.04470617684633554, 2.1331939348301456, -0.43147127918159306>
}

object
{
  BonsaiLeaf(0.002937200444771346)
  matrix <0.8848016246204793, 0.15691156014581042, -0.43875374341601864,
          -0.011807483956951526, -0.9337441612741043, -0.3577463132013054,
          -0.4658182782926921, 0.3217150969089385, -0.824325620146132,
          0.04471546561102748, 2.1251011109526527, -0.4374888816506851>
}

object
{
  BonsaiLeaf(0.002285299144065097)
  matrix <-0.5224508575987015, -0.8518563187532833, -0.037227860460767925,
          0.7141837529675497, -0.41332820932157244, -0.5648905720369298,
          0.46581827829269246, -0.3217150969089382, 0.824325620146132,
          0.04638227007751941, 2.126899126115469, -0.4377290529612014>
}

object
{
  BonsaiLeaf(0.0040255534026047085)
  matrix <-0.5722633876618834, 0.4695182057988884, -0.6723594794194088,
          0.37302390441570654, -0.5811185520973604, -0.7232941276843954,
          -0.730320328264391, -0.6647209059685582, 0.15741135693504532,
          0.04361655308003048, 2.1378596658115487, -0.4594003788629656>
}

object
{
  BonsaiLeaf(0.0029522295083804625)
  matrix <0.6813324008899998, -0.7254108937370565, 0.09780181360830964,
          -0.049177002971530465, -0.17867611036718073, -0.9826782128259455,
          0.7303203282643909, 0.6647209059685583, -0.15741135693504538,
          0.04196974363305067, 2.1396714966907924, -0.459389811343329>
}

object
{
  BonsaiLeaf(0.0036179051516641633)
  matrix <-0.6438659210847806, -0.6777047040111182, -0.35518024977024043,
          0.7636992713355196, -0.5976747464354515, -0.24402524548684634,
          -0.0469052089564051, -0.428370437395628, 0.9023849897567195,
          0.026219132912963183, 2.1266079996979834, -0.4300232289202937>
}

object
{
  BonsaiLeaf(0.0032477655860570134)
  matrix <0.9960319621934562, -0.08845706399630672, 0.009781519217745963,
          -0.07563221312251715, -0.8992630962041264, -0.43081974437525355,
          0.04690520895640471, 0.428370437395628, -0.9023849897567195,
          0.023210505685899597, 2.125849734505469, -0.43053957026708656>
}

object
{
  BonsaiLeaf(0.003990653224418319)
  matrix <-0.9407612979658211, -0.26840618042454956, 0.20718663701978696,
          0.2788257423120099, -0.9600832203799059, 0.022280380811515565,
          0.19293622177761632, 0.07872948783558548, 0.9780476890578116,
          0.017914592105579646, 2.1322419146514755, -0.4230178126179942>
}

object
{
  BonsaiLeaf(0.003398253565107738)
  matrix <0.434929501890214, -0.9003659737631322, -0.013320723520046263,
          -0.879552126204985, -0.4279518442940904, 0.2079549861233859,
          -0.19293622177761643, -0.0787294878355854, -0.9780476890578116,
          0.01381295410939721, 2.1346189849700274, -0.4224000421185452>
}

object
{
  BonsaiLeaf(0.004674052025138657)
  matrix <-0.6568346541329457, -0.6953292946785445, 0.29169403334983013,
          0.7524753891523275, -0.5795792836365635, 0.31283964374641127,
          -0.048466749943724796, 0.4249765004575728, 0.9039059399122938,
          -3.7216833246115104E-4, 2.2435799779981274, -0.6434519526356941>
}

object
{
  BonsaiLeaf(0.004329079323403232)
  matrix <0.7207418242594784, 0.6414094308531142, -0.2629166498641791,
          0.6915071922352015, -0.6387401005663556, 0.3373853687039051,
          0.0484667499437247, -0.42497650045757285, -0.9039059399122938,
          -8.956879611055515E-4, 2.243523805160147, -0.6434536133824158>
}

object
{
  BonsaiLeaf(0.004031689424442205)
  matrix <0.039576624973628904, 0.2146304830578106, -0.9758931532181523,
          0.9668770418124149, -0.2546888956522397, -0.016803346319013757,
          -0.2521556598051511, -0.9429036653729865, -0.21760101344988184,
          -0.009498762546089763, 2.25536884749256, -0.6551656184066565>
}

object
{
  BonsaiLeaf(0.003352813885968832)
  matrix <0.9601209968904378, -0.21571299485346, -0.17786392321508954,
          -0.12076917884270533, 0.25377269687170334, -0.9596948597153794,
          0.25215565980515076, 0.9429036653729866, 0.21760101344988148,
          -0.013801827070121715, 2.257246526641635, -0.6583155507849535>
}

object
{
  BonsaiLeaf(0.004848596633723687)
  matrix <-0.6004856893303347, -0.3964303995756747, -0.6944493323502762,
          0.7938995085167991, -0.19172916529735906, -0.577029893117474,
          0.09560600026284258, -0.8978211767755584, 0.4298565193725611,
          -0.050706639136178816, 2.2557091744599465, -0.7002147049310843>
}

object
{
  BonsaiLeaf(0.002653095186890055)
  matrix <0.5368681428888752, -0.31713485935811314, -0.7817915822845374,
          -0.8382315252153149, -0.3055202374856058, -0.45169159237465034,
          -0.09560600026284269, 0.8978211767755583, -0.4298565193725611,
          -0.056779845645736515, 2.255828217573823, -0.6986153005234449>
}

object
{
  BonsaiLeaf(0.0039819142906479255)
  matrix <-0.5443021104047264, 0.11328834372982624, -0.8312045258442201,
          0.6604797880595142, -0.5530154399178934, -0.5078783050862463,
          -0.5172056285210178, -0.8254330223509181, 0.2261828097774187,
          -0.05433257710160903, 2.262261743466162, -0.673612402011033>
}

object
{
  BonsaiLeaf(0.002879108242648126)
  matrix <0.845068997553535, -0.5343636808889848, -0.017715697012509274,
          -0.13548700011456338, -0.18197742211440204, -0.9739237601786672,
          0.5172056285210175, 0.8254330223509183, -0.22618280977741873,
          -0.05735263274716883, 2.2639398708533345, -0.6743941060557413>
}

object
{
  BonsaiLeaf(0.0041743117861682034)
  matrix <-0.7992490086658921, -0.14663299823148462, -0.5828377012309987,
          0.4659417564211502, -0.7637139050967625, -0.4468101954801687,
          -0.3796041382410936, -0.6286810280193752, 0.6787200182982219,
          -0.041221161899206354, 2.26212378995562, -0.6234415910121578>
}

object
{
  BonsaiLeaf(0.004359604502643043)
  matrix <0.8633399093737517, -0.5043795638881918, 0.01566704868442753,
          -0.3324829305584876, -0.5919133556023708, -0.7342299914514397,
          0.3796041382410935, 0.6286810280193752, -0.6787200182982219,
          -0.04461564214581781, 2.262731261780667, -0.624777418323692>
}

object
{
  BonsaiLeaf(0.002486887001961596)
  matrix <0.09638843425990523, 0.7462510640909852, -0.6586490864519562,
          0.3904410063168069, -0.6370411324920644, -0.6646310375686253,
          -0.9155681789617005, -0.19310086705217133, -0.352770413748739,
          -0.038396428307102236, 2.2722383846487815, -0.6285441217428966>
}

object
{
  BonsaiLeaf(0.0028753347391628613)
  matrix <0.3114296809683297, -0.8954369816255047, -0.3181260218048339,
          0.25445326385157996, 0.4011292398730173, -0.8799709480625902,
          0.9155681789617003, 0.19310086705217222, 0.3527704137487392,
          -0.038635772661698486, 2.2749760147991918, -0.6294214704908855>
}

object
{
  BonsaiLeaf(0.0037874399967543384)
  matrix <0.5480499437800134, -0.02308023850894697, -0.8361271205463283,
          -0.517881697079335, 0.7756141184490353, -0.36086186705269035,
          0.6568407774742315, 0.6307852581131681, 0.4131224409229687,
          -0.21990388486375062, 2.344267620250298, -0.7864238216130045>
}

object
{
  BonsaiLeaf(0.004861095718857763)
  matrix <-0.7149009563292718, 0.6951682408926425, 0.07521794661995024,
          0.23974322865628733, 0.3447478426347771, -0.9075638320868269,
          -0.6568407774742314, -0.630785258113168, -0.41312244092296874,
          -0.2167770242281991, 2.3430058805779543, -0.7894688336031731>
}

object
{
  BonsaiLeaf(0.0031009256418034026)
  matrix <9.612128023825366E-4, -0.8288687771593666, 0.5594422457414926,
          -0.9977220672728896, -0.038530356433192615, -0.05537226841879643,
          0.06745185354503347, -0.5581146494076885, -0.827017705717279,
          -0.258372974368892, 2.3178360346774576, -0.7713699028264999>
}

object
{
  BonsaiLeaf(0.003442023800233831)
  matrix <-0.5893475085895755, 0.6465530863063181, -0.4843951080544009,
          -0.8050588559680592, -0.5200741723103615, 0.2853122740491426,
          -0.06745185354503347, 0.5581146494076884, 0.8270177057172791,
          -0.25805014416992345, 2.31616540676873, -0.7702161459017393>
}

object
{
  BonsaiLeaf(0.004827940378273201)
  matrix <0.11651332497306222, 0.37734903601430025, -0.9187123326280104,
          -0.9009531750950684, -0.34913231090486374, -0.2576625812343443,
          -0.4179808863929511, 0.8577379171409574, 0.29929524571709226,
          -0.22543004487241422, 2.3079850450373898, -0.7616157785883474>
}

object
{
  BonsaiLeaf(0.004976773111963245)
  matrix <-0.0772626825252562, 0.9967693694352798, -0.02193859714284685,
          -0.8562974859608625, -0.07761282440809614, -0.5106181205406886,
          -0.510671218521378, -0.020665760160050672, 0.859527680142355,
          -0.23303767824814658, 2.3102121014557837, -0.7689101552626996>
}

object
{
  BonsaiLeaf(0.0049612375941341805)
  matrix <0.04907338477195397, -0.9791784389818737, -0.19698067808809172,
          0.09301222713273988, 0.20084145074526438, -0.9751981528214381,
          0.9944548901337015, 0.029534662611214735, 0.10093153716064324,
          -0.08614161175723106, 2.3215400143412426, -0.9446285282064176>
}

object
{
  BonsaiLeaf(0.004793216505378869)
  matrix <-0.011313729499250053, 0.9842294428789912, -0.17653442524031415,
          0.10455367527727773, -0.1744136103477934, -0.9791059296682159,
          -0.9944548901337014, -0.029534662611214846, -0.10093153716064324,
          -0.08610191911315908, 2.319707589989463, -0.9444834051715097>
}

object
{
  BonsaiLeaf(0.0035982796884593796)
  matrix <-0.8369262592328702, -0.2767030379585985, -0.47221802738878715,
          0.4664193120164082, 0.09085298466551545, -0.8798856519772944,
          0.2863694501594326, -0.956651014718455, 0.0530223920012486,
          -0.09088897563260992, 2.326999513989737, -0.9112406572365435>
}

object
{
  BonsaiLeaf(0.004038974164042828)
  matrix <-0.04529463159158464, 0.9138524755263642, -0.4035121427210321,
          0.1749297729313299, -0.3904299329097883, -0.9038606319727901,
          -0.9835384948700161, -0.11152632183656927, -0.14217562606308434,
          -0.09112138337175052, 2.3250360935093544, -0.9167932656018106>
}

object
{
  BonsaiLeaf(0.002472576617671573)
  matrix <0.13256048033015833, -0.9800227052967873, -0.14826738062501857,
          0.12279962607215769, 0.16467354566041423, -0.9786740392981547,
          0.9835384948700161, 0.11152632183656938, 0.14217562606308434,
          -0.09152428872105721, 2.327020197879795, -0.9155624424072679>
}

object
{
  BonsaiLeaf(0.00408028428088574)
  matrix <0.12902776063941324, 0.03936007779745082, -0.9908595365944441,
          0.6888057077593429, -0.7223750485240468, 0.06099988711490695,
          -0.7133712455254485, -0.6903803832277242, -0.12031788109758063,
          -0.04508923658349723, 2.325737725709309, -0.9152651902169044>
}

object
{
  BonsaiLeaf(0.0038599805907963154)
  matrix <0.43705920416215027, -0.5725094985410049, 0.6936945481532014,
          0.5477962377696829, -0.4422757064712771, -0.7101489149120159,
          0.7133712455254484, 0.6903803832277243, 0.12031788109758051,
          -0.04578527683994983, 2.3269780456219453, -0.9182552481255707>
}

object
{
  BonsaiLeaf(0.002909205387847025)
  matrix <0.6859338331021542, 0.6098391678319453, -0.3969772864835309,
          0.28822256987034767, -0.7286304123888021, -0.6213094819487759,
          -0.6681485813972217, 0.31175938080539684, -0.6755616638447709,
          -0.02421766508759191, 2.335770560139178, -0.9356200820086277>
}

object
{
  BonsaiLeaf(0.0024573357296206644)
  matrix <0.21352665074589566, -0.7894378758970307, -0.5754947519486379,
          0.7127298524673437, 0.5287664215691272, -0.46089286045984645,
          0.6681485813972218, -0.3117593808053965, 0.675561663844771,
          -0.02330474720872257, 2.3391896522809943, -0.934945133609757>
}

object
{
  BonsaiLeaf(0.004977919588557063)
  matrix <0.6917647833970849, 0.6501716885710618, 0.31422644674221467,
          -0.5403729306228244, 0.7547279160911117, -0.3719984791942944,
          -0.4790183506940877, 0.0875359814785982, 0.8734293741596365,
          -0.2594218280787028, 2.536600142167511, -0.7244661237420064>
}

object
{
  BonsaiLeaf(0.0036254647985301336)
  matrix <0.2632020521565275, -0.8183553585452179, -0.5109003688400703,
          -0.902422863234625, -0.3960890312523013, 0.16954779630839972,
          -0.3411123797988189, 0.41642284574929445, -0.8427540316640708,
          -0.2726180495854695, 2.500734641914581, -0.7030303900658431>
}

object
{
  BonsaiLeaf(0.0037317742153905645)
  matrix <-0.9217072715668251, 0.027946068583178774, 0.3868781756465237,
          -0.1846565728286555, -0.9087414543140435, -0.37428721501324597,
          0.34111237979881903, -0.41642284574929456, 0.8427540316640708,
          -0.27003544389860795, 2.4987794308268043, -0.7050418350111644>
}

object
{
  BonsaiLeaf(0.0030216184949117017)
  matrix <0.573939400790469, -0.4268448675912345, 0.698854078639668,
          0.08363130808370264, 0.8794984953255662, 0.4684956787722524,
          -0.8146160865883301, -0.21044204839120476, 0.5404764340287443,
          -0.20589175111318253, 2.5272691051051828, -0.6676795478660782>
}

object
{
  BonsaiLeaf(0.003132438060602074)
  matrix <-0.4739963516384299, 0.7785813562599981, -0.4112645502809595,
          0.33425752064085484, 0.5912065763785579, 0.7339936606959034,
          0.8146160865883304, 0.21044204839120456, -0.5404764340287442,
          -0.205097412040744, 2.5264635141669864, -0.6667959733948382>
}

object
{
  BonsaiLeaf(0.003704903888628538)
  matrix <-0.5653453429286288, -0.046616503905259565, -0.8235360009086194,
          -0.607328710119113, 0.6991135874387686, 0.37734868453931075,
          0.5581545315537311, 0.7134893786330286, -0.4235521520236787,
          -0.21199012459656869, 2.49540939346313, -0.6980916490109593>
}

object
{
  BonsaiLeaf(0.004445820159356515)
  matrix <-0.05856405798846344, 0.5430684504048775, 0.837643664863985,
          -0.8276676688248482, 0.44272967457885476, -0.34490094988176306,
          -0.5581545315537311, -0.713489378633029, 0.42355215202367813,
          -0.21341969170408176, 2.4947875413268235, -0.7010230572156434>
}

object
{
  BonsaiLeaf(0.004245444986748042)
  matrix <-0.9603211931468102, 0.04277660924967566, 0.27559638548824983,
          0.246317384568149, 0.5935598077508153, 0.7661687155465968,
          -0.13080883782296243, 0.8036522359353677, -0.5805446852943279,
          0.024526528701084144, 2.919397766295813, -0.4493229061597193>
}

object
{
  BonsaiLeaf(0.0031310160908203833)
  matrix <0.9190158299711371, 0.3179480120638636, 0.23306429560767117,
          -0.37188567088537927, 0.5030428861446323, 0.780159536562497,
          0.13080883782296238, -0.8036522359353677, 0.5805446852943279,
          0.02231642177613275, 2.918452876156554, -0.4501329412297556>
}

object
{
  BonsaiLeaf(0.0038494321640914772)
  matrix <-0.9338832477129299, 0.27746323938787265, 0.22555759891774768,
          0.14993927197930745, 0.8765167900769205, -0.4574237984971567,
          -0.3246233114849685, -0.39336048035058147, -0.8601669827067846,
          -0.01814051834432803, 2.84950173023661, -0.49560578150782375>
}

object
{
  BonsaiLeaf(0.0033170732720043047)
  matrix <0.5647263594507144, 0.6489247113521124, -0.5098831806778106,
          -0.7587515038417234, 0.651278935245827, -0.011484943316618368,
          0.3246233114849684, 0.3933604803505814, 0.8601669827067846,
          -0.02123453373403209, 2.848287978261245, -0.49388305602377397>
}

object
{
  BonsaiLeaf(0.003745852929793218)
  matrix <0.5936101373840014, -0.4216839195849619, -0.685426638494894,
          -0.6885438351338815, -0.7070192484804769, -0.16134177815193385,
          -0.4165745934332453, 0.5677204014667473, -0.7100416564289466,
          -0.0028311496425067334, 2.7707442485132145, -0.6014864819875343>
}

object
{
  BonsaiLeaf(0.0026073421266664364)
  matrix <-0.8651296814373791, -0.007594823452789744, 0.5014907306748344,
          -0.2793138779258655, -0.8231864092750535, -0.49431558055847147,
          0.41657459343324543, -0.5677204014667473, 0.7100416564289465,
          -9.802325408581002E-4, 2.771246310033553, -0.6021709692522035>
}

object
{
  BonsaiLeaf(0.0035438006764143336)
  matrix <-0.5182829611756791, 0.1659161793811995, -0.8389604243195957,
          0.4127018013404167, -0.8106911473063613, -0.4152795285701806,
          -0.7490393816918746, -0.5614727821530102, 0.3516935023227084,
          0.009773239992831795, 2.786471329642793, -0.570737802369333>
}

object
{
  BonsaiLeaf(0.0023317591072948424)
  matrix <-0.6880145115075408, 0.39362800562966566, 0.6096663227857129,
          0.36442803702859844, 0.9139056337902336, -0.17879792603370606,
          -0.6275573581614061, 0.09916393351659968, -0.7722294196072779,
          -0.05582198263073605, 2.8890825330202383, -0.4753240471260887>
}

object
{
  BonsaiLeaf(0.0032263893442066147)
  matrix <0.7733391512697144, 0.19417748528999074, -0.6035243667988008,
          -0.09010171658140655, 0.9759414011588873, 0.19854486186530546,
          0.6275573581614053, -0.0991639335165998, 0.7722294196072785,
          -0.056962444243304045, 2.890100292172709, -0.474266550407025>
}

object
{
  BonsaiLeaf(0.004698297375963531)
  matrix <-0.2933939418852733, 0.9015342004641428, 0.31805043665824584,
          -0.27804610966733806, -0.3987808596719455, 0.8738788170325242,
          0.9146640671655801, 0.16795806426838789, 0.36766796553865905,
          -0.05450122392058024, 2.8416666876778636, -0.4846192345065082>
}

object
{
  BonsaiLeaf(0.002555382243238327)
  matrix <-0.20688201625891023, -0.5670219939820885, -0.7972991218414989,
          0.6300317580316601, -0.700678496795345, 0.3348277587061036,
          -0.7485050535702378, -0.4330539255903272, 0.502199643877436,
          -0.05690975482472345, 2.7823743308480178, -0.4926075655930903>
}

object
{
  BonsaiLeaf(0.0028252330952133736)
  matrix <0.6235171671162051, -0.2017858209860416, 0.7553203457873837,
          0.2257576733827639, -0.8784911951635014, -0.4210542636395038,
          0.7485050535702378, 0.43305392559032724, -0.5021996438774361,
          -0.05788190874153443, 2.781682889838518, -0.49465275494274624>
}

object
{
  BonsaiLeaf(0.0032913076372135743)
  matrix <-0.8321655282291549, 0.08320064431012161, 0.5482501130081718,
          0.22429241502457292, -0.8536948668262898, 0.46999785841734354,
          0.5071424318567095, 0.5140843580005372, 0.6917541663550998,
          -0.058943472034258364, 2.7882979661213287, -0.4877666094813792>
}

object
{
  BonsaiLeaf(0.004111011259184216)
  matrix <0.8437593513189054, -0.45978770543039504, -0.27688521628457063,
          -0.17571770221683322, -0.7240942886076568, 0.6669413394995163,
          -0.5071424318567096, -0.5140843580005372, -0.6917541663550998,
          -0.060404064825049196, 2.788130978783187, -0.4865717136663643>
}

object
{
  BonsaiLeaf(0.003534959464652784)
  matrix <-0.966092475655839, -0.07451234443929955, -0.24721092008107506,
          0.20738369357758324, -0.7942966641853779, -0.5710383637743621,
          -0.15380940192098652, -0.6029433802523594, 0.7828166759149733,
          0.001870464221341117, 2.8202335552669506, -0.5856075441303741>
}

object
{
  BonsaiLeaf(0.0035024708576670894)
  matrix <0.2162411339972054, -0.793579387857809, -0.5687455732881166,
          -0.9641485569393917, -0.08179874923912273, -0.2524411313051105,
          0.15380940192098647, 0.6029433802523594, -0.7828166759149733,
          -0.0022395309522276114, 2.822754864042351, -0.5844731143673427>
}

object
{
  BonsaiLeaf(0.004279426276915644)
  matrix <-0.051836057825195125, 0.6628828388305901, -0.7469266129232788,
          -0.7873315536000837, 0.43298173805556245, 0.43890299522339005,
          0.6143468465084051, 0.6108298916181842, 0.49946450894022054,
          -5.415858888102899E-4, 2.8423456447713518, -0.5683821199948521>
}

object
{
  BonsaiLeaf(0.0031439935121721873)
  matrix <-0.7742660633560268, 0.5885974675114464, 0.2325189978781801,
          0.1519539908009646, 0.5295657322229503, -0.8345478535918904,
          -0.6143468465084049, -0.6108298916181844, -0.4994645089402209,
          0.003305483811537631, 2.8421576825704697, -0.5728841860429181>
}

object
{
  BonsaiLeaf(0.0036819279127985917)
  matrix <0.3412040115708836, -0.5698852185843604, 0.7475363938478136,
          0.9036086451659153, -0.020251410724506758, -0.42788000274035565,
          0.2589811554328927, 0.8214747214630063, 0.5080433476859236,
          0.10680611233983606, 2.7358738009641437, -0.6179198869893318>
}

object
{
  BonsaiLeaf(0.004713709358973659)
  matrix <-0.8596219689011935, -0.40744259151227474, 0.30828656345062677,
          0.5048707318608159, -0.7700312847197688, 0.3900735375069015,
          0.0784577255135564, 0.4909606452401096, 0.8676416484543921,
          0.1209326297968226, 2.7180219034379496, -0.6023067589394515>
}

object
{
  BonsaiLeaf(0.0027951681245557696)
  matrix <0.9535635108295318, 0.2169090557396008, -0.20896672546750658,
          0.29079376905583343, -0.8437464704302892, 0.4511439653976691,
          -0.07845772551355651, -0.4909606452401096, -0.8676416484543921,
          0.11936563337706267, 2.719293193872083, -0.6028844289922205>
}

object
{
  BonsaiLeaf(0.0036782134924520835)
  matrix <-0.21174289201424684, 0.9749146377801158, 0.06860318304211266,
          0.6511765314105521, 0.193077079487035, -0.7339552890448297,
          -0.7287894569912259, -0.11073703273441793, -0.6757242314432798,
          0.11129003531230242, 2.7477349637166273, -0.63518796094906>
}

object
{
  BonsaiLeaf(0.0037026856554208255)
  matrix <0.6744009911584914, 0.05474139736688649, -0.7363332686622037,
          -0.11852944993915898, 0.9923410144680596, -0.03478621137208815,
          0.7287894569912255, 0.11073703273441837, 0.6757242314432801,
          0.10845599171446532, 2.7506991118373314, -0.6326171191078926>
}

object
{
  BonsaiLeaf(0.0028943098702305537)
  matrix <-0.1813385773859699, 0.619947370180903, -0.7634013220825699,
          0.9338628997446011, -0.1347626810890494, -0.3312689304270723,
          -0.3082473111516758, -0.7729840088847079, -0.5545081759327701,
          0.10512824318252131, 2.7385818727189988, -0.6219412392317969>
}

object
{
  BonsaiLeaf(0.004733383388846727)
  matrix <-0.37543197181552473, 0.7400726633010486, -0.5579814401691159,
          -0.6493426370250761, -0.6395987180006467, -0.41142146233910737,
          -0.661365991172836, 0.20786036891726561, 0.7206865426477385,
          0.036454087318982656, 2.74478451627585, -0.6705098667712407>
}

object
{
  BonsaiLeaf(0.004282263353899982)
  matrix <-0.39728428023333634, -0.9120622733753114, -0.10152640131974702,
          -0.6362076912451251, 0.3534635434087041, -0.6857866264965451,
          0.661365991172836, -0.20786036891726542, -0.7206865426477385,
          0.03680326608905876, 2.749325606202041, -0.6714991701948306>
}

object
{
  BonsaiLeaf(0.0036253589452705176)
  matrix <0.5809832645777904, 0.48076079881400335, -0.6567552821289333,
          -0.6454334265605128, 0.7637237739367356, -0.011903318956711609,
          0.4958569734902286, 0.43080744126297427, 0.7540098211519264,
          0.01608013335850691, 2.787294213210128, -0.5505356739451407>
}

object
{
  BonsaiLeaf(0.0022384361553619983)
  matrix <-0.7851887282340726, -0.14847580139412475, 0.6011934775548817,
          -0.3709508362239813, 0.8901459908087105, -0.2646423854032231,
          -0.4958569734902288, -0.4308074412629744, -0.7540098211519262,
          0.01758971144139914, 2.7865179753639473, -0.5510849052250104>
}

object
{
  BonsaiLeaf(0.003706499681550574)
  matrix <-0.30478940451717534, -0.11966773695085453, 0.9448719763159064,
          0.04889895250930279, 0.9888005669947444, 0.141004720326537,
          -0.9511636616994783, 0.0891799946396788, -0.2955243090145182,
          0.020365172985777613, 2.787623277095465, -0.5443928708069095>
}

object
{
  BonsaiLeaf(0.00329664268667517)
  matrix <0.060009384120778705, 0.9925145724916328, 0.10636586486836835,
          -0.30279789048123507, -0.08343711373134938, 0.9493954316154547,
          0.9511636616994782, -0.08917999463967846, 0.295524309014518,
          0.019185712582678094, 2.7836832257580024, -0.5417856872514989>
}

object
{
  BonsaiLeaf(0.002207027029374909)
  matrix <0.38168533769280966, 0.2248029539629413, 0.896537748