#declare FULLSCENE = true;
#declare QUICKRENDER = true;

global_settings
{
  #ifdef (QUICKRENDER)
    
    ambient_light 5
    
  #else
    
    ambient_light 0
    max_trace_level 20
    radiosity
    {
      count 500
      brightness 1.2
      normal on
    }
    photons
    {
      count 10000
      autostop 0
      jitter 0.4
    }
    
  #end
}

#include "goban.pov"
#include "room.pov"
#include "strawmat.pov"
#include "bonsai.pov"
#include "wineglass.pov"
#include "winebottle.pov"
#include "garden.pov"

object
{
  Room
}

object
{
  GoBan
  rotate y*20
  translate <0.5, 0, -2>
}

object
{
  BlackBowl
  rotate -y*130
  translate <1.95, 0, -4.2>
}

object
{
  WhiteBowl
  translate <1.8, 0, -0.6>
}

object
{
  StrawMat
  translate <0.7, 0, -4.2>
}

object
{
  StrawMat
  translate <1.5, 0, 0.6>
}

object
{
  Bonsai
  scale 0.4
  translate <-1.8, 0, 1.2>
}

object
{
  WineGlass
  scale 0.06
  translate <1.55, 0, -3.4>
}

object
{
  WineGlass
  scale 0.06
  translate <2.15, 0, -0.3>
}

object
{
  WineBottle
  rotate -y*45
  scale 0.12
  translate <1.9, 0, -3>
}

object
{
  Garden
}

sky_sphere
{
  pigment
  {
    rgb 0.7
  }
}

light_source
{
  <72, 770, 1000>
  rgb 1
  #ifndef (QUICKRENDER)
    area_light x*30, z*30, 5, 5
    adaptive 1
    jitter
    circular
    orient
  #end
}

camera
{
  location <3, 5.5, -9.5>
  look_at <0, 0, 0>
  angle 30
  up y*4/3
  right x
}
