#local rseed = seed(20796);
#local colseed = seed(201004);

#local xmin = -4;
#local xmax = 9;
#local zmin = 3.5;
#local zmax = 32;
#local xskew = -0.8;

#local blobMin = 0.3;
#local blobMax = 1;
#local blobOffset = 0.4;
#local stoneScale = 0.15;

#macro Stone(xpos, zpos, rot)
blob
{
  threshold 0.5
  sphere
  {
    #local rad1 = blobMin+rand(rseed)*(blobMax-blobMin);
    0, rad1, 1
    scale <1, 1/rad1, 1>
    rotate y*360*rand(rseed)
  }
  sphere
  {
    #local rad2 = blobMin+rand(rseed)*(blobMax-blobMin);
    x*blobOffset, rad2, 1
    scale <1, 1/rad2, 1>
    rotate y*360*rand(rseed)
  }
  sphere
  {
    #local rad3 = blobMin+rand(rseed)*(blobMax-blobMin);
    x*blobOffset, rad3, 1
    scale <1, 1/rad3, 1>
    rotate y*360*rand(rseed)
  }
  rotate y*rot
  scale <1, stoneScale, 1>
  translate <xpos, 0, zpos>
  
  pigment
  {
    granite
    warp {turbulence 0.5}
    scale 0.1+0.1*rand(colseed)
    color_map
    {
      [0.0                   rgb <0.95, 0.7, 0.35> + <0, 0, 0.15>*rand(colseed)]
      [0.1+rand(colseed)*0.1 rgb <0.95, 0.7, 0.35> + <0, 0, 0.15>*rand(colseed)]
      [0.2+rand(colseed)*0.1 rgb <0.85, 0.7, 0.45> + <0, 0.1, 0.2>*rand(colseed)]
      [0.3+rand(colseed)*0.2 rgb <0.85, 0.7, 0.45> + <0, 0.1, 0.2>*rand(colseed)]
      [1.0                   rgb <0.35, 0.25, 0.1> + <0.2, 0.1, 0>*rand(colseed)]
    }
  }
  finish
  {
    diffuse 0.8
  }
  normal
  {
    granite 0.2 scale 0.03
  }
}
    
#end

#local Path = union
{
  object {Stone(-2.5, 11.5, 0)}
  object {Stone(-1, 12, 0)}
  object {Stone(-1, 10.5, 0)}
  object {Stone(0.4, 11, -45)}
  object {Stone(0.25, 9.8, 180)}
  object {Stone(-3, 12.5, 0)}
  object {Stone(-4, 14, 0)}
  object {Stone(-4, 12, -90)}
  object {Stone(-4.5, 15.7, 0)}
  object {Stone(-5, 14, 0)}
  object {Stone(-6, 17, -90)}
  object {Stone(-6.2, 15.5, 0)}
  object {Stone(-5.3, 17.8, 90)}
  object {Stone(-7.5, 16.5, 90)}
  object {Stone(-7, 19, 0)}
  object {Stone(-8, 18.3, 0)}
  object {Stone(-9.8, 19.3, 0)}
  object {Stone(-8.5, 20.2, 0)}
  object {Stone(-11, 19.5, 0)}
  object {Stone(-8.8, 16.8, 0)}
  object {Stone(1.9, 11, 0)}
  object {Stone(1.3, 8.5, -90)}
  object {Stone(1.7, 9.7, -50)}
  object {Stone(2.2, 9.2, -90)}
}

#macro Tuft()

#local zrand = rand(rseed);
#local xrand = rand(rseed);
#local xrand = xrand + zrand*xskew;
#local pos = <xmin+xrand*(xmax-xmin), 0, zmin+zrand*(zmax-zmin)>;

#if (!inside(Path, pos))
  union
  {
    difference
    {
      sphere {<1,0,0>, 1}
      sphere {<1.7,-.5,0>, 1.7}
      scale <.1,1,.1>
      rotate -z*10
    }
    difference
    {
      sphere {<-.7,0,0>, .7}
      sphere {<-3,-.5,0>, 2.7}
      scale<.1,1,.1>
      rotate z*30
      rotate y*30
    }
    difference
    {
      sphere {<-.7,0,0>, .7}
      sphere {<-1.5,-.5,0>, 1.4}
      scale <.05,.6,.1>
      rotate -y*90
    }
    pigment
    {
      onion
      color_map
      {
        [0 rgb <.6,1,.4> + <.3, 0, .2>*rand(rseed)]
        [.2 rgb <.5,.9,.3> + <.4, .1, .3>*rand(rseed)]
        [1 rgb <.3,.7,.2> + <.5, .2, .4>*rand(rseed)]
      }
      scale <1,2,1>
    }
    finish
    {
      diffuse 0.8
    }
    scale <1, 0.7, 1>*(rand(rseed)*0.15 + 0.15)
    rotate y*rand(rseed)*360
    
    translate pos
  }
#end
#end

#declare soilTexture = texture
{
  pigment
  {
    rgb<.2,.15,.05>
  }
  normal
  {
    granite scale .3
  }
}

#ifdef (QUICKRENDER)
  #local grassCount = 0;
#else
  #local grassCount = 40000;
#end

#declare Garden = union
{
  #while (grassCount > 0)
    Tuft()
    #local grassCount = grassCount - 1;
  #end
  
  object {Path}
  
  plane
  {
    y, 0
    texture {soilTexture}
    clipped_by
    {
      plane
      {
        -z, -zmin
      }
    }
  }
}

#ifndef (FULLSCENE)
  object {Garden}
  
  sky_sphere
  {
    pigment
    {
      //rgb <0.5, 0.75, 1>
      rgb 0.7
    }
  }

  light_source
  {
    //<10, 80, 100>
    <10, 80, 100>
    rgb 1
  }

  camera
  {
    location <3, 5.5, -9.5>
    //location <10, 20, 50>
    //location <0, 100, -1>
    look_at <0, 0, 0>
    angle 30
    up y*4/3
    right x
  }
  
  global_settings
  {
    #ifndef (QUICKRENDER)
      ambient_light 0
      max_trace_level 20
      radiosity
      {
        count 200
        brightness 1.4
        //gray_threshold 0.4
        normal on
      }
    #end
  }

  #declare FULLSCENE = true;
  #include "room.pov"
  object {Room}

#end
