#local gbLength = 2.2;
#local gbWidth  = 2;
#local gbHeight = 1.2;

#local marginX = 1;
#local marginY = 1;

#local linesX = 19;
#local linesZ = 19;
#local lineWidth = gbWidth/(linesX+marginX-1);
#local lineLength = gbLength/(linesZ+marginY-1);
#local lineRadius = 0.005;

#local lineRight  = lineWidth*(linesX-1)/2; 
#local lineLeft   = -lineRight;
#local lineTop    = lineLength*(linesZ-1)/2;
#local lineBottom = -lineTop;

#local gbLegHeight = 0.5;
#local gbLegRadius = 0.2;

#local blackRadius = 0.048;
#local whiteRadius = 0.046;
#local stoneThick  = 0.015;
#local stonePosJitter = 0.005;

#local rseed = seed(180980);

#local woodLight = rgb <1, 0.9, 0.4>;
#local woodDark = rgb <0.8, 0.5, 0>;

#local gbTexture = texture
{
  pigment
  {
    average
    pigment_map
    {
      [2.0, wood
        warp {turbulence 0.5}
        scale <1,1,2>*0.04
        warp {turbulence 0.1}
        color_map
        {
          [0.0 woodLight]
          [1.0 woodDark]
        }
      ]
      [2.0, marble
        warp {turbulence 1}
        rotate z*20
        scale <1,1,2>*1.5
        color_map
        {
          [0.0 woodLight]
          [0.5 woodDark]
          [1.0 woodDark]
        }
      ]
      [1.0, radial
        rotate x*90
        frequency 400
        warp {turbulence 0.1}
        color_map
        {
          [0.0 woodLight]
          [0.5 woodDark]
          [1.0 woodLight]
        }
      ]
      [0.3, radial
        rotate x*90
        frequency 50
        warp {turbulence 0.1}
        color_map
        {
          [0.0 woodLight]
          [0.5 woodDark]
          [1.0 woodLight]
        }
      ]
      [2.0, cylindrical
        rotate x*90
        scale 1.5
        color_map
        {
          [0.0 woodLight]
          [1.0 woodDark]
        }
      ]        
    }
    translate <gbWidth/2+0.1, gbHeight+0.2, 0>
  }
  finish
  {
    specular 0.1
    diffuse 1
    roughness 0.08
  }
}

#local lineTexture = texture
{
  pigment
  {
    rgb 0.01
  }
  finish
  {
    specular 0.5
    roughness 0.05
  }
}

#local GoBanLeg = lathe
{
  cubic_spline
  7,
  <0,               gbLegHeight * 1.2>,
  <gbLegRadius/2,   gbLegHeight>,
  <gbLegRadius,     gbLegHeight*0.8>,
  <gbLegRadius/2,   gbLegHeight*0.3>,
  <gbLegRadius,     gbLegHeight*0.1>,
  <gbLegRadius*0.7, 0>,
  <0, 0>
  
  texture {gbTexture}
}

#local Table = union
{
  object{GoBanLeg translate <-gbWidth/2+gbLegRadius, 0, -gbLength/2+gbLegRadius>}
  object{GoBanLeg translate < gbWidth/2-gbLegRadius, 0, -gbLength/2+gbLegRadius>}
  object{GoBanLeg translate <-gbWidth/2+gbLegRadius, 0,  gbLength/2-gbLegRadius>}
  object{GoBanLeg translate < gbWidth/2-gbLegRadius, 0,  gbLength/2-gbLegRadius>}

  difference
  {
    /*
    box
    {
      <-gbWidth/2, gbLegHeight, -gbLength/2>,
      <gbWidth/2, gbHeight, gbLength/2>
      texture {gbTexture}
    }
    */
    superellipsoid
    {
      <0.02, 0.02>
      scale <gbWidth/2, (gbHeight-gbLegHeight)/2, gbLength/2>
      translate <0, gbHeight-(gbHeight-gbLegHeight)/2, 0>
      texture {gbTexture}
    }
    
    #local lx = 0;
    #while (lx < linesX)
      #local curx = lineLeft + lx*lineWidth;
      cylinder
      {
        <curx, gbHeight, lineBottom>,
        <curx, gbHeight, lineTop>,
        lineRadius
        texture {lineTexture}
      }
      #local lx = lx + 1;
    #end

    #local lz = 0;
    #while (lz < linesZ)
      #local curz = lineBottom + lz*lineLength;
      cylinder
      {
        <lineLeft, gbHeight, curz>,
        <lineRight, gbHeight, curz>,
        lineRadius
        texture {lineTexture}
      }
      #local lz = lz + 1;
    #end
    
    sphere {<lineLeft, gbHeight, lineBottom>, lineRadius texture{lineTexture}}
    sphere {<lineRight, gbHeight, lineBottom>, lineRadius texture{lineTexture}}
    sphere {<lineLeft, gbHeight, lineTop>, lineRadius texture{lineTexture}}
    sphere {<lineRight, gbHeight, lineTop>, lineRadius texture{lineTexture}}
  }
}

// Stones

#macro BoardBlackStone(boardx, boardz)
BlackStone
(
  <lineLeft + boardx*lineWidth + ((rand(rseed)*2-1)*stonePosJitter),
  gbHeight,
  lineBottom + boardz*lineLength + ((rand(rseed)*2-1)*stonePosJitter)>
)
#end

#macro BlackStone(pos)
sphere
{
  <0, blackRadius, 0>, blackRadius
  scale <1, stoneThick/blackRadius, 1>
  translate pos
  
  pigment
  {
    rgb <.1,0,.05>
  }
  finish
  {
    diffuse 0.7
    specular .3
    roughness .03
  }
}
#end

#macro BoardWhiteStone(boardx, boardz)
WhiteStone
(
  <lineLeft + boardx*lineWidth + ((rand(rseed)*2-1)*stonePosJitter),
  gbHeight,
  lineBottom + boardz*lineLength + ((rand(rseed)*2-1)*stonePosJitter)>
)
#end

#macro WhiteStone(pos)
  #local turb = rand(rseed)*0.1 + 0.05;
  #local scl  = rand(rseed)*0.003 + 0.007;
  #local zrot = rand(rseed)*30;
  #local yrot = rand(rseed)*360;
  #local lnst = rand(rseed)*0.05 + 0.4;
  #local lncl = rand(rseed)*0.2 + 0.6;

sphere
{
  <0, whiteRadius, 0>, whiteRadius
  scale <1, stoneThick/whiteRadius, 1>
  translate pos

  pigment
  {
    gradient x
    color_map {
      [0.0    rgb <1,1,1>]
      [lnst   rgb <1,1,1>]
      [lnst   rgb <1,1,1>-<.7,1,0>*lncl]
      [0.5    rgb <1,1,1>-<.8,1,0>*lncl]
      [1-lnst rgb <1,1,1>-<.8,1,0>*lncl]
      [1-lnst rgb <1,1,1>]
      [1.0    rgb <1,1,1>]
    }
    turbulence turb
    scale scl
    rotate z*zrot
    rotate y*yrot
  }
  
  finish
  {
    diffuse 1.1
    specular .5
    roughness .01
    /* Iridescence makes stones too bright with radiosity.
    irid
    {
      .15
      thickness 3
      turbulence .05
    }
    */
  }
}
#end

#local stoneArray = array[linesZ][linesX]
{//A B C D E F G H J K L M N O P Q R S T
  {0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,0,0,0,0}, // 19
  {0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,0,0,0,0}, // 18
  {0,1,2,1,0,0,0,0,0,1,1,1,2,2,0,2,0,1,0}, // 17
  {1,1,2,1,0,0,0,0,0,1,2,2,1,2,0,2,0,2,0}, // 16
  {1,2,1,1,0,0,0,0,1,2,2,0,1,2,2,0,0,2,0}, // 15
  {2,2,2,2,1,1,1,1,1,1,2,0,0,1,2,0,1,0,0}, // 14
  {0,2,0,2,1,0,2,2,1,2,2,2,0,0,2,0,0,0,0}, // 13
  {2,2,0,2,1,1,1,2,2,2,2,1,2,2,1,0,0,0,0}, // 12
  {2,1,2,2,2,1,2,0,2,1,2,1,1,2,0,0,0,1,0}, // 11
  {2,1,1,1,0,2,2,2,0,1,1,0,1,2,2,2,2,2,2}, // 10
  {1,1,0,0,1,1,1,2,2,2,1,1,1,1,1,1,1,1,2}, // 9
  {0,0,0,0,0,1,0,0,0,1,1,2,2,2,1,0,2,1,1}, // 8
  {0,0,0,1,2,1,2,2,2,1,1,1,1,2,2,1,0,0,0}, // 7
  {0,0,1,0,0,1,1,1,2,2,1,1,2,2,2,1,0,2,0}, // 6
  {1,1,0,0,1,1,2,2,2,1,1,2,2,2,1,1,0,0,0}, // 5
  {1,2,1,1,0,2,0,0,2,0,1,2,0,1,1,2,1,1,0}, // 4
  {2,2,2,1,1,2,0,0,2,1,1,2,2,1,2,2,1,0,0}, // 3
  {0,2,2,1,2,0,2,0,1,2,1,2,0,2,2,2,1,1,1}, // 2
  {0,0,0,2,0,2,0,0,0,2,2,0,2,0,1,2,2,2,0}  // 1
}

#declare GoBan = union
{
  object {Table}
  
  #local stoneX = 0;
  
  #while (stoneX < linesX)
    #local stoneZ = 0;
    #while (stoneZ < linesZ)
      #if (stoneArray[linesZ-stoneZ-1][stoneX] = 1)
      //#if (rand(rseed) < 1/6)
        BoardWhiteStone(stoneX, stoneZ)
      #else
        #if (stoneArray[linesZ-stoneZ-1][stoneX] = 2)
        //#if (rand(rseed) < 1/4)
          BoardBlackStone(stoneX, stoneZ)
        #end
      #end
      #local stoneZ = stoneZ + 1;
    #end
    #local stoneX = stoneX + 1;
  #end
}

#local bowlTexture = texture
{
  pigment
  {
    wood
    rotate -x*30
    warp {turbulence 0.5}
    scale 0.05
    warp {turbulence 0.5}
    color_map
    {
      [0.0 rgb <0.4, 0.25, 0.1>]
      [0.2 rgb <0.3, 0.15, 0.08>]
      [1.0 rgb <0.2, 0.1, 0.05>]
    }
  }
  finish
  {
    diffuse 1
    specular 0.3
    roughness 0.07
    reflection 0.1
  }
}

#local Bowl = difference
{
  sphere {<0, 1, 0>, 1.2}
  plane {y, 0}
  cone {y*3, 4 y, 0}
  difference
  {
    sphere {<0, 1, 0>, 1.1}
    plane {y, 0.1}
  }
  scale <0.2, 0.15, 0.2>
}

#local BowlInside = sphere
{
  <0, 1, 0>, 0.9
  scale <0.2, 0.1, 0.2>
}

#local BowlLid = difference
{
  sphere {<0, 1, 0>, 1.1}
  plane {y, 0}
  cone {y*3, 6 y, 0}
  difference
  {
    sphere {<0, 1, 0>, 1.0}
    plane {y, 0.1}
  }
  scale <0.2, 0.05, 0.2>
}

#declare BlackBowl = union
{
  object
  {
    Bowl
    texture {bowlTexture translate <100, 200, 300>}
  }
  object
  {
    BowlLid
    translate <-0.5, 0, 0>
    texture {bowlTexture translate <300, 200, 100>}
  }
  
  #local stones = 80;
  #while (stones > 0)
    #local pos = <rand(rseed)*0.4-0.2, rand(rseed)*0.15, rand(rseed)*0.4-0.2>;
    #if (inside(BowlInside, pos))
      BlackStone(pos)
      #local stones = stones-1;
    #end
  #end
  
  #local rseed2 = seed(14); 
  #local excludeStone = union {}
  
  #local stones = 8;
  #while (stones > 0)
    #local zangle = rand(rseed2)*16;
    #local yangle = rand(rseed2)*360;
    #local pos = vrotate(vrotate(-y*0.5, z*zangle), y*yangle) + <-0.5, 0.51, 0>;
    
    #if (!inside(excludeStone, pos))
      
      object
      {
        WhiteStone(-y*0.5)
        rotate z*zangle
        rotate y*yangle
        translate <-0.5, 0.51, 0>
      }
      
      #local excludeStone = union
      {
        object {excludeStone}
        sphere {pos, whiteRadius*2}
      }
      #local stones = stones-1;
    #end
  #end
  
  #local rseed3 = seed(0);
  #local excludeStone = union {}
  
  #local stones = 10;
  #while (stones > 0)
    #local pos = vrotate(x*rand(rseed3)*0.3, y*rand(rseed3)*360) + <-0.25, 0, -0.46>;
    #if (!inside(excludeStone, pos))
      BlackStone(pos)
      
      #local excludeStone = union
      {
        object {excludeStone}
        sphere {pos, blackRadius*2}
      }
      #local stones = stones - 1;
    #end
  #end
}


#declare WhiteBowl = union
{
  object
  {
    Bowl
    texture {bowlTexture translate <200, 100, 300>}
  }
  object
  {
    BowlLid
    translate <-0.5, 0, 0>
    texture {bowlTexture translate <300, 100, 200>}
  }
  
  #local stones = 80;
  #while (stones > 0)
    #local pos = <rand(rseed)*0.4-0.2, rand(rseed)*0.15, rand(rseed)*0.4-0.2>;
    #if (inside(BowlInside, pos))
      WhiteStone(pos)
      #local stones = stones-1;
    #end
  #end
  
  #local rseed4 = seed(0);
  #local excludeStone = union {}
  
  #local stones = 16;
  #while (stones > 0)
    #local pos = vrotate(x*rand(rseed4)*0.35, y*rand(rseed4)*360) + <0.25, 0, -0.45>;
    #if (!inside(excludeStone, pos))
      WhiteStone(pos)
      
      #local excludeStone = union
      {
        object {excludeStone}
        sphere {pos, whiteRadius*2}
      }
      #local stones = stones - 1;
    #end
  #end
}

#ifndef (FULLSCENE)
  
  object {GoBan}
  
  object
  {
    BlackBowl
    rotate -y*90
    translate <1.5, 0, -1.2>
  }
  
  object
  {
    WhiteBowl
    translate <0, 0, -1.5>
  }

  plane
  {
    y, 0
    pigment {rgb 0.5}
  }
  
  light_source
  {
    <100, 300, -200>
    rgb 1
  }
  
  camera
  {
    location <4, 4, -7>
    look_at <-0.2, 0, 0>
    angle 30
  }
  
  /*
  camera
  {
    location <4, 4, -7>
    look_at <1.5, 0, -1.5>
    angle 10
  }
  */
#end
