#local floorWood = texture
{
  pigment
  {
    wood
    warp {turbulence 1}
    scale <1, 1, 5>*0.05
    warp {turbulence 0.05}
    color_map
    {
      [0.0 rgb <0.9, 0.7, 0.4>]
      [0.2 rgb <0.9, 0.7, 0.4>]
      [0.8 rgb <0.8, 0.55, 0.3>]
      [1.0 rgb <0.8, 0.55, 0.3>]
    }
  }
  #ifndef (QUICKRENDER)
    normal
    {
      wood 0.1
      warp {turbulence 1}
      scale <1, 1, 5>*0.05
      warp {turbulence 0.05}
      slope_map
      {
        [0.0 <0, 1>]
        [0.5 <1, 0>]
        [1.0 <0, -1>]
      }
    }
    finish
    {
      diffuse 1
      specular 0.2
      roughness 0.1
      reflection 0.2
    }
  #end
}

#local boardWidth = 0.3;
#local boardLength = 2;
#local boardThick = 0.01;
#local boardXGap = 0.007;
#local boardZGap = 0.015;
#local rseed = seed(161202);

#macro FloorBoard(xpos, zpos)
box
{
  <0, -boardThick, 0>, <boardWidth-boardXGap, 0, boardLength-boardZGap>
  
  texture
  {
    average
    texture_map
    {
      [1.0 floorWood translate <rand(rseed)*100, rand(rseed)*0.2-0.1, rand(rseed)*100>]
      [rand(rseed)*0.1 pigment {rgb <1, 1, 0>}]
    }
  }
  translate <xpos, 0, zpos>
}
#end

#local wallWidth = 13;

#local floorLeft = -wallWidth/2;
#local floorRight = wallWidth/2;
#local floorFront = -11;
#local floorBack = 3;

#local curx = floorLeft;

#declare Floor = union
{
  #while (curx < floorRight)
    
    #local curz = floorFront - rand(rseed)*boardLength;
    
    #while (curz < floorBack)
      FloorBoard(curx, curz)
      #local curz = curz + boardLength;
    #end
    
    #local curx = curx + boardWidth;
  #end
  
  // Black underneath
  
  box
  {
    <floorLeft, -boardThick*2, floorFront>,
    <floorRight, -boardThick, floorBack>
    pigment
    {
      rgb 0
    }
    finish
    {
      diffuse 0
    }
  }
}

#local wallWood = texture
{
  pigment
  {
    wood
    warp {turbulence 1}
    scale <1, 1, 10>*0.02
    warp {turbulence 0.02}
    color_map
    {
      [0.0 rgb <0.6, 0.3, 0.1>]
      [0.2 rgb <0.6, 0.3, 0.1>]
      [0.8 rgb <0.4, 0.2, 0.1>]
      [1.0 rgb <0.4, 0.2, 0.1>]
    }
  }
  finish
  {
    diffuse 1
    specular 0.2
  }
}

#local wallTexture = texture
{
  pigment
  {
    rgb 1
  }
  finish
  {
    diffuse 1
  }
  normal
  {
    bumps 0.5
    scale 0.01
  }
}

#local wallHeight = 7.5;
#local wallThick = 0.05;
#local supportWidth = 0.15;
#local supportThick = 0.18;
#local supportGap = 1;
#local crossHeight = 0.05;
#local crossThick = 0.07;
#local crossGap = 1.5;
#local skirtingHeight = 0.2;
#local skirtingThick = 0.15;
#local skirtingYCut = 0.16;
#local skirtingZCut = 0.1;

#local windowLeft = -2.5+supportWidth/2;
#local windowRight = 2.5-supportWidth/2;
#local windowBottom = 1.5+crossHeight/2;
#local windowTop = 6-crossHeight/2;

#macro WallSupport(xpos)
#if (xpos >= windowLeft & xpos <= windowRight)
  union
  {
    box
    {
      <xpos-supportWidth/2, 0, -supportThick>, <xpos+supportWidth/2, windowBottom, 0>
    }
    box
    {
      <xpos-supportWidth/2, windowTop, -supportThick>, <xpos+supportWidth/2, wallHeight, 0>
    }
    texture
    {
      wallWood
      rotate x*90
    }
  }
#else
  box
  {
    <xpos-supportWidth/2, 0, -supportThick>, <xpos+supportWidth/2, wallHeight, 0>
    texture
    {
      wallWood
      rotate x*90
    }
  }
#end
#end

#macro WallCross(ypos)
#if (ypos >= windowBottom & ypos <= windowTop)
  union
  {
    box
    {
      <-wallWidth/2, ypos-crossHeight/2, -crossThick>, <windowLeft, ypos+crossHeight/2, 0>
    }
    box
    {
      <windowRight, ypos-crossHeight/2, -crossThick>, <wallWidth/2, ypos+crossHeight/2, 0>
    }
    texture
    {
      wallWood
      rotate y*90
    }
  }
#else
  box
  {
    <-wallWidth/2, ypos-crossHeight/2, -crossThick>, <wallWidth/2, ypos+crossHeight/2, 0>
    texture
    {
      wallWood
      rotate y*90
    }
  }
#end
#end

#local Wall = union
{
  #local curx = -wallWidth/2;
  #while (curx <= wallWidth/2)
    WallSupport(curx)
    #local curx = curx + supportGap;
  #end
  
  #local cury = crossGap;
  #while (cury <= wallHeight)
    WallCross(cury)
    #local cury = cury + crossGap;
  #end
  
  difference
  {
    box
    {
      <-wallWidth/2, 0, -skirtingThick>,
      <wallWidth/2, skirtingHeight, 0>
    }
    cylinder
    {
      <-wallWidth, 0, 0>, <wallWidth, 0, 0>, 1
      scale <1, skirtingYCut, skirtingZCut>
      translate <0, skirtingHeight, -skirtingThick>
    }
    texture
    {
      wallWood
      rotate y*90
    }
  }
    
  difference
  {
    box
    {
      <-wallWidth/2, 0, 0>,
      <wallWidth/2, wallHeight, wallThick>
    }
    box
    {
      <windowLeft-supportWidth/2, windowBottom-crossHeight/2, -1>,
      <windowRight+supportWidth/2, windowTop+crossHeight/2, 1>
    }
    texture
    {
      wallTexture
    }
  }
}

#declare Room = union
{
  object {Floor}
  object {Wall translate z*floorBack}
  
  // Off-camera walls
  union
  {
    box
    {
      <floorLeft-wallThick, 0, floorFront>, <floorLeft, wallHeight, floorBack>
    }
    box
    {
      <floorRight, 0, floorFront>, <floorRight+wallThick, wallHeight, floorBack>
    }
    box
    {
      <floorLeft, 0, floorFront-wallThick>, <floorRight, wallHeight, floorFront>
    }
    box
    {
      <floorLeft, wallHeight, floorFront>, <floorRight, wallHeight+wallThick, floorBack>
    }
    texture
    {
      wallTexture
    }
  }
}

#ifndef (FULLSCENE)
  object {Room}
  
  global_settings
  {
    ambient_light 0
    radiosity
    {
      count 200
      brightness 2
      gray_threshold 0.3
    }
  }

  light_source
  {
    <0, 50, 100>
    rgb 1
  }
  
  camera
  {
    location <2, 5, -10>
    look_at <0, 0, 1>
    angle 30
    up y*4/3
    right x
  }
#end

