#local strawRadius = 0.01;
#local matRadius = 0.8;
#local midGap = 0.15;
#local ringGap = strawRadius * 4;
#local spokeGap = strawRadius * 2;
#local strawBend = strawRadius * 0.7;

#local spokeCount = 2*pi*midGap / spokeGap;
#local spokeCount = floor(spokeCount/2) * 2; // Round down to even number
#local spokeAngle = 360 / spokeCount;
#local ringCount = floor((matRadius-midGap)/ringGap + 1);

#local strawCol = rgb <1, 0.9, 0.5>;

#declare StrawMat = union
{

  // Rings
  
  #local rad = midGap;
  #local dy = strawBend;
  
  #while (rad <= matRadius)

    sphere_sweep
    {
      cubic_spline
      spokeCount + 3
      
      #local spoke = 0;
      
      #while (spoke <= spokeCount + 2)
        vrotate(<rad, dy, 0>, y*spoke*spokeAngle), strawRadius
        #local spoke = spoke + 1;
        #local dy = -dy;
      #end
    }
    
    #local rad = rad + ringGap;
  #end
  
  // Spokes
  
  sphere_sweep
  {
    cubic_spline
    (ringCount+2) * spokeCount + 3
    
    #local spoke = 0;
    #local ring = 0;
    #local dy = -strawBend;
    
    // Outward
    
    #while (spoke < spokeCount)
      vrotate(<midGap - strawRadius*2, 0, 0>, y*spoke*spokeAngle), strawRadius
      
      #while (ring < ringCount)
        vrotate(<ring*ringGap + midGap, dy, 0>, y*spoke*spokeAngle),
        strawRadius
        
        #local ring = ring + 1;
        #local dy = -dy;
      #end
      
      vrotate(<matRadius + strawRadius*2, 0, 0>, y*spoke*spokeAngle), strawRadius

      #local spoke = spoke + 1;
      
      // Inward
      
      vrotate(<matRadius + strawRadius*2, 0, 0>, y*spoke*spokeAngle), strawRadius

      #while (ring > 0)
        #local ring = ring - 1;
        
        vrotate(<ring*ringGap + midGap, dy, 0>, y*spoke*spokeAngle),
        strawRadius
        
        #local dy = -dy;
      #end
      
      vrotate(<midGap - strawRadius*2, 0, 0>, y*spoke*spokeAngle), strawRadius
      
      #local spoke = spoke+1;
      
    #end
    
    // Final points to join up
    
    <midGap - strawRadius*2, 0, 0>, strawRadius
    <midGap, dy, 0>, strawRadius
    <midGap + ringGap, -dy, 0>, strawRadius
  }
  
  translate y*(strawRadius+strawBend)
  
  pigment
  {
    strawCol
  }
  finish
  {
    diffuse 1
  }
}

#ifdef (QUICKRENDER)
  #declare StrawMat = torus
  {
    (matRadius + midGap)/2, matRadius - (matRadius + midGap)/2
    scale <1, strawRadius/(matRadius/2-midGap), 1>
    translate y*strawRadius
    pigment
    {
      strawCol
    }
    finish
    {
      diffuse 1
    }
  }
#end
  
#ifndef (FULLSCENE)
  object {StrawMat}
  
  light_source
  {
    <100,400,-200>
    rgb 1
  }
  
  camera
  {
    location <0,4,-4>
    look_at 0
    angle 25
  }
#end
