#ifndef (FULLSCENE)
  #declare QUICKRENDER = true;
#end

#local glassThick = 0.1;

#local p1 = <-0.5, 0.5>;
#local p2 = <0, 0.5>;
#local p3 = <1, 0>;
#local p4 = <1.32, 0>;
#local p5 = <1.32, 1.25>;
#local p6 = <1.31, 2.9>;
#local p7 = <1.1, 4.4>;
#local p8 = <0.52, 6.1>;
#local p9 = <0.4, 8.5>;
#local p10 = p8 + <-glassThick, 0>;
#local p11 = p7 + <-glassThick, 0>;
#local p12 = p6 + <-glassThick, 0>;
#local p13 = p5 + <-glassThick, 0>;
#local p14 = p4 + <-glassThick, 0>;
#local p15 = p4 + <-glassThick, glassThick>;
#local p16 = p3 + <0, glassThick>;
#local p17 = p2 + <0, glassThick>;
#local p18 = p1 + <0, glassThick>;

#local labelThick = 0.002;
#local capThick = 0.03;
#local rimThick = 0.07;
#local labelz1 = -2.15;
#local labelz2 = -2.05;

#local q1 = p7 + <capThick, 0>;
#local q2 = p8 + <capThick, 0>;
#local q3 = p9 + <capThick, -0.5>;
#local q4 = p9 + <rimThick, -0.4>;
#local q5 = p9 + <rimThick, -0.15>;
#local q6 = p9 + <capThick, -0.05>;
#local q7 = p9 + <capThick, capThick>;
#local q8 = p10 + <0, capThick>;
#local q9 = p11 + <-capThick, 0>;

#local yoffset = y*0.1141;
#local winelevel = 6;

#local disp = 1.02;
#local refl = 0.05;

#local LabelTemplate = difference
{
  lathe
  {
    cubic_spline
    6,
    p3, p4, p5, p6, p7, p8
    scale <1+labelThick, 1, 1+labelThick>
  }
  lathe
  {
    cubic_spline
    6,
    p3, p4, p5, p6, p7, p8
    scale <1+labelThick/2, 1, 1+labelThick/2>
  }
}

#declare WineBottle = union
{
  lathe
  {
    cubic_spline
    18,
    p1, p2, p3, p4,
    p5, p6, p7, p8,
    p9, p10, p11, p12,
    p13, p14, p15, p16,
    p17, p18

    pigment
    {
      rgbf <0.8, 1, 0.6, 0.9>
    }
    interior
    {
      ior 1.5
      #ifndef (QUICKRENDER)
        dispersion disp
      #end
    }
    finish
    {
      diffuse 0
      specular 0.4
      reflection refl
      roughness 0.02
    }
    #ifndef (QUICKRENDER)
      photons
      {
        target
        reflection on
        refraction on
      }
    #end
  }
  
  intersection
  {
    lathe
    {
      cubic_spline
      9,
      q1, q2, q3, q4, q5, q6, q7, q8, q9
    }
    plane
    {
      -y, -6.6
    }
    pigment
    {
      rgb <0.05, 0, 0.3>
    }
    finish
    {
      diffuse 0.8
    }
  }

  intersection
  {
    object {LabelTemplate}
    cylinder
    {
      <-10, 2, labelz1>, <10, 2, labelz1>, 1.32
    }
    pigment
    {
      image_map
      {
        png "mcleishsemillon.png"
        map_type 2 // cylindrical
      }
      translate -y*.5
      scale 2.3
      translate y*1.95
      rotate y*270
    }
    finish
    {
      diffuse 0.8
    }
  }
  
  intersection
  {
    object {LabelTemplate}
    difference
    {
      cylinder
      {
        <-10, 2, labelz2>, <10, 2, labelz2>, 1.32
      }
      cylinder
      {
        <-11, 2, labelz1>, <11, 2, labelz1>, 1.32
      }
    }
    pigment
    {
      rgb <1, .95, .2>
    }
    finish
    {
      specular 0.3
      roughness 0.06
      reflection 0.3
    }
  }

  intersection
  {
    lathe
    {
      cubic_spline
      8,
      p11, p12, p13, p14, p15, p16, p17, p18
      
      translate -y*winelevel
      scale 0.999
      translate y*winelevel
    }
    plane
    {
      y, winelevel
    }
    pigment
    {
      rgbf <0.95, 1, 0.85, 1>
    }
    finish
    {
      diffuse 0
      specular 0.3
      roughness 0.04
      reflection refl
    }
    interior
    {
      ior 1.33
      #ifndef (QUICKRENDER)
        dispersion disp
      #end
    }
    #ifndef (QUICKRENDER)
    photons
    {
      target
      reflection on
      refraction on
    }
    #end
  }
  
  translate yoffset
}

#ifndef (FULLSCENE)
  
  object {WineBottle rotate -y*45}
  
  plane
  {
    y,0
    pigment
    {
      rgb 1
    }
  }

  sky_sphere
  {
    pigment
    {
      rgb <0.375, 0.4, 0.45>
    }
  }
  
  light_source
  {
    <300,300,-200>
    rgb 1
  }
  
  camera
  {
    location <0, 5, -30>
    look_at <0, 5, 0>
    angle 30
  }
  
  global_settings
  {
    #ifdef (QUICKRENDER)
      
      max_trace_level 10
      
    #else
      
      max_trace_level 50
      photons
      {
        count 20000
        autostop 0
        jitter 0.4
      }
      //radiosity
      //{
      //}
    #end
  }
#end
