#ifndef (FULLSCENE)
  #declare QUICKRENDER = true;
#end

#local glassThick = 0.05;
#local baseThick = 0.5;

#local p1 = <-1, 0.1>;
#local p2 = <0, 0.1>;
#local p3 = <1, 0>;
#local p4 = <1.9, 0>;
#local p5 = <0.35, 0.7>;
#local p6 = <0.35, 3.0>;
#local p7 = <1.8, 4.1>;
#local p8 = <2.1, 5.7>;
#local p9 = <1.5, 9.4>;
#local p10 = p9+<-glassThick/2, 0>; //<1.4, 9.4>;
#local p11 = p8+<-glassThick, 0>; //<1.8, 5.7>;
#local p12 = p7+<-glassThick, glassThick>; //<1.6, 4.3>;
#local p13 = p6+<-glassThick, baseThick>; //<0.8, 3.8>;
#local p14 = <0, p6.y+baseThick-glassThick>;
#local p15 = <-1, p14.y-glassThick>;

#local yoffset = y*0.05576;
#local winelevel = 7;

#local disp = 1.02;
#local refl = 0.02;

#declare WineGlass = union
{
  lathe
  {
    cubic_spline
    15,
    p1, p2, p3, p4,
    p5, p6, p7, p8,
    p9, p10, p11, p12,
    p13, p14, p15

    translate yoffset

    pigment
    {
      rgbf 1
    }
    finish
    {
      diffuse 0
      specular 0.4
      reflection refl
      roughness 0.02
    }
    interior
    {
      ior 1.5
      #ifndef (QUICKRENDER)
        dispersion disp
      #end
    }
    #ifndef (QUICKRENDER)
      photons
      {
        target
        reflection on
        refraction on
      }
    #end
  }

  intersection
  {
    lathe
    {
      cubic_spline
      7,
      p9, p10, p11, p12, p13, p14, p15
      
      translate -y*winelevel
      scale 0.999
      translate y*winelevel + yoffset
    }
    plane
    {
      y, winelevel
    }
    pigment
    {
      rgbf <0.95, 1, 0.85, 1>
    }
    finish
    {
      diffuse 0
      specular 0.3
      roughness 0.04
      reflection refl
    }
    interior
    {
      ior 1.33
      #ifndef (QUICKRENDER)
        dispersion disp
      #end
    }
    #ifndef (QUICKRENDER)
    photons
    {
      target
      reflection on
      refraction on
    }
    #end
  }
}

#ifndef (FULLSCENE)
  
  object {WineGlass}
  
  plane
  {
    y,0
    pigment
    {
      wood
      turbulence 0.2
      translate <-1, -1, 1>
      rotate x*5
      rotate y*30
      scale 1.5
      color_map
      {
        [0 rgb <0.4, 0.15, 0>]
        [1 rgb <0.5, 0.2, 0.02>]
      }
    }
    finish
    {
      diffuse 0.8
      reflection 0.2
    }
  }

  sky_sphere
  {
    pigment
    {
      rgb <0.375, 0.4, 0.45>
    }
  }
  
  light_source
  {
    <300,300,-200>
    rgb 1
  }
  
  camera
  {
    location <0, 25, -35>
    look_at <-3, 5, 0>
    angle 30
  }
  
  global_settings
  {
    #ifdef (QUICKRENDER)
      
      max_trace_level 10
      
    #else
      
      max_trace_level 50
      photons
      {
        count 20000
        autostop 0
        jitter 0.4
      }
      //radiosity
      //{
      //}
    #end
  }
#end
