// Persistence Of Vision raytracer version 3.5
// Hang glider include file
// Ron Gow 2004

#version 3.5;

#ifndef(SHAPES_INC_TEMP)
    #include "shapes.inc" 
#end

#macro Glider ( Sail_Color )
	// *******************************
	// *********  textures  **********
	// *******************************
	#local P_Sail = array [3] {
		pigment { 
			gradient x
			color_map {
				[0.00 rgbf <0.976, 0.318, 0.416, 0.465> ]
				[1.00 rgbf <0.976, 0.922, 0.773, 0.445> ]
			}
			scale <5.25,1,1> rotate -y*31.5
			},
		
		pigment { 
			gradient z 
			color_map {
				[0.00 rgbf <0.012, 0.475, 1.000, 0.460> ]
				[0.50 rgbf <0.012, 0.475, 1.000, 0.460> ]
				[0.50 rgbf <0.975, 0.980, 0.985, 0.445> ]
				[1.00 rgbf <0.975, 0.980, 0.985, 0.445> ]
			}
			scale <4,1,8> rotate -y*15 
			},
		
		pigment { 
			gradient x
			color_map {
				[0.00 rgbf <0.992, 0.992, 0.137, 0.460> ]
				[0.30 rgbf <0.992, 0.992, 0.137, 0.460> ]
				[0.90 rgbf <0.290, 0.800, 0.553, 0.465> ]
				[0.90 rgbf <0.290, 0.800, 0.553, 0.465> ]
				[1.00 rgbf <0.992, 0.992, 0.137, 0.460> ]
			}
			scale <5.5,1,1> rotate -y*55
		}
	}
	
	#local T_Sail_Fabric = texture {
		pigment { P_Sail [ Sail_Color ] }
		finish { ambient 0 phong .1 phong_size 30 }
	}
	
	#local T_Brushed_Alum = texture {
		pigment { 
			wrinkles scale <.1,.1,1> 
			color_map {
				[0.00 rgb <0.718, 0.800, 0.780> ]
				[1.00 rgb <0.694, 0.757, 0.757> ]
			}
		}
		normal { granite .01 scale <.01,.01,.1> }
		finish { ambient 0 phong .6 phong_size 60 reflection .3 brilliance 2 }
	}
	
	#local T_Cast_Alum = texture {
		pigment { 
			bozo scale .095
			color_map {
				[0.00 rgb <0.722, 0.800, 0.796> ]
				[0.50 rgb <0.490, 0.545, 0.514> ]
				[1.00 rgb <0.557, 0.588, 0.498> ]
			}
		}
		normal { bozo .05 scale .5 }
		finish { ambient 0 phong .3 phong_size 45 reflection .05 brilliance 2 }
	}
	
	#local T_Brass = texture {
		pigment { rgb <0.925, 0.737, 0.431> }
		finish { ambient 0 phong .6 phong_size 60 reflection .35 brilliance 2 }
	}
	
	// *******************************
	// ***********  bends  ***********
	// *******************************
	#macro Makebend ( Maj_Rad, Min_Rad, Bnd_Ang )
		#local Cut_Rad = Maj_Rad+Min_Rad;
		intersection {
			intersection {
				torus { Maj_Rad Min_Rad }
				box { <-Cut_Rad, -Min_Rad*1.01, 0> <Cut_Rad, Min_Rad*1.01, Cut_Rad> }
				rotate -y*Bnd_Ang
			}
			box { <-Cut_Rad, -Min_Rad*1.01, 0> <Cut_Rad, Min_Rad*1.01, Cut_Rad> }
			rotate y*Bnd_Ang*.5
		}
	#end
	// *******************************
	// ***********  wing  ************
	// *******************************
	#local F_Rad = .05;
	#local W_Rad = 20*In;
	#local WE_Rad = 2.5*In;
	#local W_Len = 22*Ft;
	#local F_Scale = 1.5;
	#local R_Scale = 4.5;
	
	#local R_Half = intersection {
		Round_Cone3_Union(<0,0,0>, W_Rad, <0,0,W_Len>, WE_Rad)
		box { <-W_Rad,-W_Rad,W_Len*1.001> <.001,W_Rad,-.001>  }
		scale <R_Scale,1,1>
	}
	
	
	#local F_Half = intersection {
		Round_Cone3_Union(<0,0,0>, W_Rad, <0,0,W_Len>, WE_Rad)
		box { <-.001,-W_Rad,W_Len*1.001> <W_Rad,W_Rad,-.001>  }
		scale <F_Scale,1,1>
	}
	
	#local W_Base = intersection {
		merge {
			object { R_Half }
			object { F_Half }
			rotate z*15
			translate y*1.75*In
		}
		box { <-W_Rad*R_Scale,0,W_Len> <W_Rad*F_Scale,W_Rad*1.35,0> }
		translate y*.05*In
	}
	
	#local W_Shape = difference {
		object { W_Base }
		object { W_Base scale <.97,.98,1.001> translate <0,0,-.01*In> }
		rotate -z*7
	}
	
	#local W_Half = intersection {
		object { W_Shape
			rotate -y*30
			translate -z*.85*Ft
		}
		box { <-W_Rad*R_Scale*1.75,-2*In,W_Len-4.25*Ft> <W_Rad*F_Scale,W_Rad*1.25,0> }
		//texture { T_Sail_Fabric scale <5.25,1,1> rotate -y*31.5 }
		texture { T_Sail_Fabric }
		rotate -x*1
	}
	
	#local Wing = union {
		object { W_Half }
		object { W_Half scale <1,1,-1> }
		scale <1,.3,1>
	}
	// *******************************
	// ***********  frame  ***********
	// *******************************
	#local U_Hgt = 3*Ft;
	#local G_Rad = .065*In;
	#local G_Set = 7.15*Ft;
	#local Guys = union {
		cylinder  { 0 <-3*Ft,U_Hgt*.95,0> G_Rad }
		cylinder  { <-3*Ft,U_Hgt*.95,0> <-10*Ft,0,0> G_Rad }
		cylinder  { <-3*Ft,U_Hgt*.95,0> <-G_Set,0,-10*Ft> G_Rad }
		cylinder  { <-3*Ft,U_Hgt*.95,0> <-G_Set,0,10*Ft> G_Rad }
	}
	
	#local G_Rad = .65*In;
	#local GM_Rad = 3*In;
	#local G_Ang = 29;
	#local G_Len = 4*Ft;
	#local G_Wid = 2*Ft;
	#local G_Half =  union {
		object { Makebend ( GM_Rad, G_Rad, G_Ang ) }
		cylinder { 0 <0,0,-G_Wid> G_Rad translate x*GM_Rad rotate -y*G_Ang }
		cylinder { 0 <0,0,-G_Len> G_Rad translate -x*GM_Rad rotate y*G_Ang }
		rotate <0, G_Ang, -90>
		texture { T_Cast_Alum }
	}
	#local Guide  = union {
		object { G_Half translate z*G_Wid }
		object { G_Half scale <1,1,-1> translate -z*G_Wid }
		translate -y*G_Len*.95
		rotate z*5
		texture { T_Brushed_Alum }
	}
	#local S_Sec = cylinder { 0 <0, -2.5*Ft, 0> .65*In scale <1, 1, .20> }
	#local S_Rot = 14;
	#local H_Strap = union {
		object { S_Sec rotate x*S_Rot }
		object { S_Sec rotate -x*S_Rot }
	}
	#local Harness = union {
		object { H_Strap scale <1,.8,1.035> rotate z*19 translate x*1*In }
		//object { H_Strap scale <1,.95,.95> rotate -z*1 translate x*0*In }
		object { H_Strap scale <1,1.09,.95> rotate -z*17 translate -x*In }
		sphere { 0 1.55*In scale <1.15, 1, .45> pigment { rgb .85 } }
		sphere { 0 1.55*In scale <1, 1, .65> translate <In,13*In,0> pigment { rgb .85 } }
		cylinder { 0 <In,13*In,0> .35*In }
		pigment { rgb <0.706, 0.655, 0.533> }
	}
	//Guide
	#local P_Set = 3*Ft;
	#local F_Large = cylinder { 0 <0,0,-W_Len> In texture { T_Brushed_Alum } }
	#local F_Small = cylinder { 0 <-12*Ft,0,0> .65*In texture { T_Brushed_Alum rotate y*90} }
	#local WS_Ang = 36.01;
	#local Frame = union {
		object { Guys }
		object { F_Small }
		object { F_Small scale <.30,1,1> rotate z*90 translate <-P_Set, U_Hgt, 0>}
		object { F_Large rotate y*WS_Ang }
		object { F_Large rotate -y*(180+WS_Ang)}
		object { Guide translate <-P_Set, 0, 0> }
	}
	// *******************************
	// ***********  pilot  ***********
	// *******************************
	#local Pilot = union {
		sphere_sweep {
			cubic_spline, 7
			<6*In,0,0>, 6*In, <0,0,0>, 9*In, <-15*In,-7*In,0>, 7*In, <-21*In,-10*In,0>, 8*In, 
			<-36*In,-12*In,0>, 6*In, <-52*In,-12*In,0>, 5*In, <-58*In,-11*In,0>, 6*In
			scale <1,.6,1>
			pigment { rgb <0.490, 0.561, 0.710> }
		}
		sphere_sweep {
			linear_spline, 7
			<13*In,-15*In,18*In>, 2.25*In, <6*In,-12*In,14*In>, 2.55*In, <2*In,0,4*In>, 3*In, 
			<0,0,0>, 3*In, <2*In,0,-4*In>, 3*In, <6*In,-12*In,-14*In>, 2.55*In, <13*In,-15*In,-18*In>, 2.25*In
			translate <In,3.5*In,0>
			pigment { rgb <0.570, 0.520, 0.710> }
		}
		sphere { 0 4.5*In  scale <1,1.1,.85> rotate -z*15 translate <10.5*In,5.5*In,0> pigment { rgb <0.670, 0.520, 0.510> } }
	}
	// *******************************
	// **********  glider  ***********
	// *******************************
	union {
		object { Wing }
		object { Frame 	translate <28*In,1.5*In,0> }
		object { Harness translate <-3.07,-1,0> }
		object { Pilot rotate z*5 translate <-P_Set*.61,-2.92*Ft,0> }
	}
#end

