#include "functions.inc"
#include "colors.inc"
#include "metals.inc"
#include "woods.inc"
#include "blouse_pov.inc" 
#include "Hands.inc"
#include "Judy_pov.inc" 
 
#declare RollingPin =
union{

   #declare L = 7;
   #declare R = 0.7;
   #declare r = 0.1;
   
   cylinder{<0,0,0><0,L,0>R-r}
   cylinder{<0,r,0><0,L-r,0>R}
   
   torus{R-r,r translate r*y}
   torus{R-r,r translate (L-r)*y}

lathe
{
  cubic_spline 
  8
  <-0.5,1.82>
  <0.01,1.78>
  <0.22,1.76>
  <0.28,1.55>
  <0.22,1.>
  <0.23,0.12>
  <0.38,-0.27>
  <0.72,-0.55>
  translate L*y
}
lathe
{
  cubic_spline 
  8
  <-0.5,1.82>
  <0.01,1.78>
  <0.22,1.76>
  <0.28,1.55>
  <0.22,1.>
  <0.23,0.12>
  <0.38,-0.27>
  <0.72,-0.55>
  rotate 180*x
}
   scale .3                           
   texture{T_Wood23 rotate 90*x}  
}                           
                      

#declare ruff =

isosurface {
  function {y + x*z*sin(x*z)  + 0.1*f_noise3d(2*x, 0, 2*z)}
  open 
  max_gradient 2
  contained_by { sphere {0,1} }    
  pigment{
     cylindrical
     color_map{
       [0    White]
       [0.05 White]
       [0.05 rgbt<1,1,1,0.5>]
       [.35  rgbt<1,1,1,0.5>]
       [.35  White]
       [1 White]
     }
  } 
  scale 2*y
}  

#declare JudyCollar = 
union{
  
  #declare N=0;
  #while (N<90)
     object{ruff rotate N*y}   
     #declare N = N + 22.5;
  #end
}   


#declare brim =  
  isosurface{
  function { - f_witch_of_agnesi(x,y ,z,1,0.1) + 7*(x*x+z*z-0.25)*f_noise3d(6*x,0,6*z) + 18*y*(x*x+z*z-0.25)}  
    max_gradient 14
    all_intersections 
    contained_by { sphere {0,.7} }  
    
    rotate 90*y
    scale <2,1,2>  
  }
#declare JudyBonnet =
union{
  difference{
    isosurface {
     function { f_piriform_2d(x+0.05*f_noise3d(0,6*y,6*z), y, z, -1, 1, -1, 1, 1, 0, -90)}
      max_gradient 8
      contained_by { sphere {0,2} } 
      translate <0,-0.65,0>
      scale 2.3 
      scale <1,1,1.25>
    }
    box{<-10,-10,-10><10,-0.3,10> rotate 20*x} 
    texture{ 
      gradient y
      texture_map{
      
      [ 0   pigment{White} normal{bumps bump_size 0.125 scale<.1,10,.1>} ]
      [ 0.3 pigment{White} normal{bumps bump_size 0.025 scale<.1,10,.1>} ]
      [ 0.7   pigment{White}    ]  
      [ 1   pigment{White}    ]  
      }                 
      scale <1,1.2,1> 
      rotate 10*x
      translate 0.7*y
    }
    rotate 40*x   
  }  
  
  isosurface{
    function{ f_torus(x+ 0.1*f_noise3d(0, 3*y, 3*z),y,z, .62,.05)}
    contained_by { sphere {0,2} }  
    scale <1,2,1.3>
    rotate 55*x 
    translate<-0.03,-0.15,-0.34>
    pigment{Blue} 
  }
  
 
  difference{
    object{brim}
    object{brim translate -.02*y}  
    rotate 90*y
    scale 0.55  
    scale <1,1,1.1>
    rotate 61*x 
    translate<-0.1,-0.2,-0.5> 
  }  
  pigment{White} 
  translate <-0.05,0,0>
}  
  


#declare EarRing = 
union{

  sphere{<0,0,0>1 texture{pigment{White} finish { phong 13 phong_size 100 } } }
  sphere{<0,0,0>0.5 scale 2*y translate .6*y texture{T_Brass_4A}}
  torus{.5,.1 translate 1*y texture{T_Brass_4A}}
  torus{.3,.1 rotate 90*z translate 1.75*y texture{T_Brass_4A}}
  torus{.5,.1 rotate 90*x translate 2.3*y texture{T_Brass_4A}}
  scale 0.1
}

#declare Ms_Judy =
difference{
    object{ Judy translate <-0.065,-.275,0.11> scale 20  rotate 90*y }
    box{<-10,.8,-10><10,10,10>rotate 60*x}
}
 
#declare JudyTex =  
  texture{pigment {color rgb <1,0.768627,0.713725> transmit 0} 
        finish{phong 0.019608 phong_size 30 ambient rgb <0,0,0> reflection{0 metallic}}};
 

#declare handTex =
texture{pigment {color rgb <1,0.768627,0.713725> transmit 0} 
        finish{phong 0.019608 phong_size 30 ambient rgb <0,0,0> reflection{0 metallic}}}
texture{pigment{p_map} 
        finish{phong 0.0504766 phong_size 30 ambient rgb <0,0,0> reflection{0 metallic}}}
    
//Ms Judy  
#declare MsJudy =
union{ 
    object{ Ms_Judy }
    object{ Blouse translate <-0.065,-.275,0.11> scale 15  rotate 90*y translate <0,-1,0.25> }     
#if (highdef > 0)
    object{ JudyCollar  scale<.75,1,.75>rotate -20*x translate<0,-0.0,.65>}
#end
    object{ JudyBonnet  scale<1,1,1> rotate -20*x translate<0.05,1,.65>} 
    object{ EarRing rotate 9*z translate <-0.52,-.005,0.555> }
    object{ rightHand(.95, 0) texture{handTex} scale 0.8 rotate  90*z rotate  -90*y translate  <-0.15,-1.5,-2.5> no_shadow }
    object{ leftHand(.95, 0)  texture{handTex} scale 0.8 rotate  -90*z rotate  90*y translate  < 0.15,-1.5,-2.5> no_shadow }
    object{ RollingPin  translate -0.05*y rotate -10*x  translate<0,-1.25,-2.6>                   no_shadow }
}


