
#include "functions.inc"
#include "colors.inc"
#include "metals.inc"

#declare redClothTex = texture{pigment{Red}}   
#include "punch_pov.inc"    
#include "shirt_pov.inc"
#include "Hands.inc"                      

#declare eyePig1 = pigment{White}
#declare eyePig2 = 
pigment{ 
  radial   
  turbulence 0.5
  color_map{
   [0.5  White]
   [0.75 Green]
   [1    White]
  }
  frequency 10
}    
#declare eyePig3 = pigment{Black}
#declare eyeTex = 
texture{

   pigment{
     cylindrical   
     pigment_map{
       [0    eyePig1]
       [0.55 eyePig1]
       [0.55 eyePig3] 
       [0.65  eyePig2] 
       [0.8  eyePig2] 
       [0.8  eyePig3]
       [1    eyePig3]  
     }
     scale 0.135
     rotate 90*x
   } 
   finish{ phong 1 phong_size 100 }
}

#declare bell =

union{
  
  difference{
    sphere{<0,0,0> 1 scale<1,1.1,1>} 
    
    union{
       cylinder{<0,0,-10><0,0,10> 0.15 translate -0.3*y}
       cylinder{<0,0,-10><0,0,10> 0.15 translate -0.3*y rotate 90*y}  
       box{<-0.05,0,-10><0.05,-10,10>  translate -0.4*y}
       box{<-0.05,0,-10><0.05,-10,10>  translate -0.4*y rotate 90*y}
    } 
  }
  torus{1 0.1 scale<1,0.5,1>}
  
  torus{.2,.05 rotate 90*x translate <0,1.25,0>}
  torus{.07,.05 rotate 90*z translate <0,1.45,0> texture{redClothTex}}
  
  texture{T_Brass_4B}
  
  translate -1.4*y
  scale .1
}
#declare eye =

   sphere{<0,0,0> 
          0.15 
          texture{eyeTex}
   }
 

#macro collarbase(X)
isosurface {
   function { f_torus(x+0.1*f_noise3d(0,3*y,3*z), y+0.1*f_noise3d(3*x,0,3*z), z+0.1*f_noise3d(3*x,3*y,0), 0.6, X) }
   max_gradient 1
   all_intersections 
   contained_by {  sphere{0,2} } 
   
}
#end

#declare collar =
union{
difference{
  intersection{
    difference{
      object{collarbase(.4)}
      object{collarbase(.38)}
    } 
    cylinder{<0,-0.1,0><0,3,0>2}
  }
  union{
    #declare N = 0;
    #while (N<360)
    
       cylinder{<0,-2,0><0,2,0> .3 scale <1.55,1,1> translate 1.15*z rotate N*y}
       #declare N = N + 45;
    #end
  }

    matrix 
     < 1, 0, 0,
       0.2, 1, 0,
       0, 0, 1,
       0, 0, 0 >


  texture{redClothTex}   
  rotate -90*y
}
isosurface{
      function { f_torus(x + .1*f_noise3d(0, 18*y, 0), y, z + .1*f_noise3d(0, 18*y, 0), 0.55, .075) }
      max_gradient 1.583
      contained_by { box { -6, 6 } }
      scale <1,2.9,1>
      rotate -6*x  
      pigment{Red}
}
}

#declare hat =

union{
  
  difference{
    #declare N = 0.15;  
    isosurface {
      function { f_torus(x + N*f_noise3d(0, 2*y, 3*z), y+N*f_noise3d(2*x, 0, 3*z), z, 1, x/2.25+.425) }
      max_gradient 1.583
      contained_by { box { -3, 3 } }
    }
  
    box{<-100,-100,0.2><100,100,-100>}
    rotate -90*x   
    rotate -90*y
    translate <0,1.5,-1.3>
    scale <1.125,1.35,1.05>  
    scale 0.65       
  }
  
  isosurface {
  function { f_torus(x, y, z+ 0.5*x*x, 1.125*(y/1+0.55) + 0.05*(1+2*z),0.05) } 
    max_gradient 1.583
    contained_by { box { -2, 2 } } 
    
    
    matrix 
     < 1, 0, 0,
       0, 1, -0.3,
       0, 0, 1,
       0, 0, 0 >

    
    scale <1,4,.775> 
    scale <0.925,1,1.65>
    translate <0,1.3,0.15>
  }

  texture{redClothTex}
}


#declare Mr_Punch = 
union{
  difference{
    object{ Punch translate <-0.065,-.275,0.11> scale 20  rotate 90*y } 
    box{<-3,-3,-3><3,0.1,3> rotate -20*x }
  }
  object{ eye rotate -27*y rotate -15*x translate < 0.265,1.1,-0.525> }                                                                 
  object{ eye rotate -25*y rotate -15*x translate <-0.265,1.1,-0.525> }                                                                 
}




#declare stickShape =

union{

   #declare L = 4.5;
   #declare R = 0.09;
   
   cylinder{<0,0,0><0,L,0>R}  
   

   sphere{<0,0,0>R}
   sphere{<0,L,0>R}    
}

#declare stick = 
union{
  difference{
    object{stickShape texture{ pigment{White} finish{phong 3 phong_size 150} } }
     isosurface {
        function{    f_helix1(x,y,z, 5, -4, R*1.3, R*1.29, .52, 1, 45) }
        max_gradient 4
        contained_by { sphere {0,L/2 + 2*R} } 
        translate L/2*y
        pigment{Red}
    }
  }
  
  intersection{
    object{stickShape }
     isosurface {
        function{    f_helix1(x,y,z, 5, -4, R*1.3, R*1.29, .52, 1, 45) }
        max_gradient 4
        contained_by { sphere {0,L/2 + 2*R} } 
        translate L/2*y
        
   } 
   texture{ pigment{Red} finish{phong 3 phong_size 150} } 
  }   
}


#declare handTex =
texture{
   pigment{ rgb<0.843137254901961, 0.611764705882353, 0.517647058823529>}
   finish{phong 0.052875817 phong_size 30 }
}

//Mr Punch   

#declare MrPunch =
union{
  object{ hat   scale 1.1 rotate 25*x translate <0,0.2,-0.55>  }
//#if (highdef > 0)
  object{ collar  scale < 1,1,1.2>  rotate -25*x translate<0,0,0.4> }//no_shadow}                                                                    
//#end
  object{ Mr_Punch }
  object{bell rotate 45*y rotate 55*x translate <0.97,-0.32,-0.01> } 
  object{bell rotate 45*y  rotate 20*x translate <.4,-0.6,-0.63> } 
  object{bell rotate 12*y  rotate 20*x translate <-.37,-0.59,-0.58> } 
  object{bell rotate 12*y rotate 50*x rotate -40*y translate <-.9,-0.3,-0.> } 
  object{bell  rotate 20*x translate <0.9,0.05,0.85> }  
  object{bell rotate 37*y rotate 23*x scale 1.25 translate <-0.05,2.65,-1.26> }  
  object{Shirt translate <-0.065,-.275,0.11> scale 15  rotate 90*y translate <0,-0.05,0> }
  object{rightHand(1.1, -10)   texture{handTex} rotate 90*z rotate  80*y  rotate 180*y rotate -13*x translate  <-0.0,-1.46,-3.2> }   
  object{leftHand(1.1, -10)    texture{handTex} rotate -90*z rotate 80*y  rotate -13*x              translate  < 0.3,-1.46,-3.0> }     
  object{stick  rotate -30*x  translate<0.15,-2,-2.6>}  
}




