#include "functions.inc"
#include "colors.inc"     
#include "woods.inc"

#declare tex1 = texture{ pigment{ rgb<0.6, 0, 0> }}
#declare tex2 = texture{ pigment{ rgb<0.95, 0.93, 0.8> }}
#declare tex3 = texture{ 
     pigment{ 
        gradient y 
        turbulence 0.25
        color_map{
          [0 rgb<0, 0.15, 0>]
          [1 rgb<0, 0.35, 0>]
        } 
        translate 0.5*y 
        scale 9
     }
  }
 
#declare topBit =
intersection{

   #declare T = 0.1;
   #declare W = 1;
   #declare R = .7;
   
   union{
     box{<-W/2,0,0><W/2,10,T>}
     cylinder{<0,0,0><0,0,T>R}
   }
   
   box{<-W/2,-1,-1><W/2,10,T+1>}
}

#declare botBit =box{<-W/2,-2.75,0><W/2,-10,T>};

#declare curtain =
intersection{
isosurface{

   function{ f_rounded_box(x - (1-y)*(1-y)/2,y,z+ 1*f_noise3d(4*(x - (1-y)*(1-y)/2)+1.2,0,0),.1, 1 , 1 ,.1) }
   max_gradient 4
   open                  
   contained_by { box{-2,2} }
   scale<1.5,8,1>    
   texture{tex3}
}
box{<-3,-10,-10><1.25,10,10>}}     
     
#macro rail(X,Y)  
    //Rail
    isosurface{
     function{f_rounded_box(x,y,z,.01*X,X,.025*Y,.05*X)}   
   contained_by { box{-X,X} }
     texture{T_Wood13 rotate 90*y rotate 90*x scale .3}  
    }
#end   

#declare lid = 
union{
object{ 
#declare X = 2.85;
#declare Y=6; 
#declare M = .35;
  rail(X,Y)
  translate -X*x
  matrix        
     < 1, 0, 0,
       M, 1, 0,
       0, 0, 1,
       0, 0, 0 > 
  rotate 20*z
}
object{ 

  rail(X,Y)
  
  translate X*x/1
  
  matrix 
     < 1, 0, 0,
       -M, 1, 0,
       0, 0, 1,
       0, 0, 0 > 
  rotate -20*z
}
}
     
#declare Theatre =
union{

object{lid translate <0,5.9,-1.75>}

intersection{

  union{
  
    union{
  
      #declare N = -2;
      #while (N<2)
        object{topBit texture{tex1}  translate 2*W*N*x     translate <0,3.85,-2>}
        object{topBit texture{tex2}  translate (2*W*N+1)*x translate <0,3.85,-2>}
        object{botBit texture{tex1}  translate 2*W*N*x     translate <0,0,-2>}
        object{botBit texture{tex2}  translate (2*W*N+1)*x translate <0,0,-2>}
        #declare N = N+1;
      #end
      
      object{topBit texture{tex1}  translate 2*W*N*x translate   <0,3.85,-2>}  
      object{botBit texture{tex1}  translate 2*W*N*x translate   <0,0,-2>}
    
      box{<-1,-10,0><0,10,T> translate <-4.25,0,-2> texture{tex1}  }
      box{< 1,-10,0><0,10,T> translate < 4.25,0,-2> texture{tex1}  }
    
    }
    
    object{curtain rotate 180*y translate <-3.6,0.5,-1.55>}
    object{curtain translate <3.6,0.5,-.7>} 
  
  
    object { rail(4.4,4.4) translate <0,-2.75,-2> }
    
    box{<-5.6,0,-2><0,.1,7> rotate 20*z translate  5.75*y 
      pigment{
        gradient x 
        turbulence .7
        pigment_map{
          [0 Gray10]
          [1 Gray30]
        }
        translate<.1,0,0>
        scale 6.5  
        
      }
    }
    
    box{< 5.6,0,-2><0,.1,7> rotate -20*z translate 5.75*y 
          pigment{
        gradient x 
        turbulence .7
        pigment_map{
          [0 Gray10]
          [1 Gray20]
        }
        translate<-.15,0,0>
        scale 6.5  
        
      }
    }

    //side 
    box{<5.,-10,-1.9><5.1,6,4>pigment{Gray10}}
  
    //Back 
    box{<-6,-100,4><6,100,11>
    texture{
      pigment{
        gradient y
      turbulence .6
        color_map{
          [0 White*0.01]
          [1 White*0.2]
        }
      }     
      translate 0.5*y
      scale 15
    } 
    

    
  }
  
  rotate 3.75*x
  }

  union{

   box{<-10,-10,-10><0,0,10>rotate  20*z translate 6.25*y}
   box{< 10,-10,-10><0,0,10>rotate -20*z translate 6.25*y}
   
  }

 }
}

