//*PMRawBegin
#include "colors.inc"
#include "woods.inc"
#include "stones.inc"
#include "stones1.inc"
#include "stones2.inc"
#include "textures.inc"
//*PMRawEnd

global_settings {
   adc_bailout 0.0039216
   assumed_gamma 1.5
   max_trace_level 100
   noise_generator 3
   
   radiosity {
      adc_bailout 0.005
      count 150
      pretrace_start 0.04
      pretrace_end 0.02
      recursion_limit 4
   }
}

// T_Filler is used as a filler for making sure 
// KPovModeler recognizes externally referenced 
// textures. Pay it no mind.
#declare T_Filler = texture {
   pigment {
      color rgb <1, 1, 1>
   }
}

#declare T_WhitePiece = texture {
   T_Filler
}
//*PMRawBegin
#declare T_WhitePiece = texture {T_Stone17}
//*PMRawEnd

#declare T_BlackPiece = texture {
   pigment {
      color rgb <0, 0, 0>
   }
}

#declare T_Table = texture {
   T_Filler
}
//*PMRawBegin
#declare T_Table = texture {T_Wood7}
//*PMRawEnd

#declare T_Bookshelf = texture {
   pigment {
      color rgb <0.741176, 0.431373, 0.239216>
   }
}
//*PMRawBegin
#declare T_Bookshelf = texture {DMFWood5}
//*PMRawEnd

#declare T_Walls = texture {
   pigment {
      color rgb <1, 1, 0.827451>
   }
   
   normal {
      marble
      turbulence <1, 0.1, 0>
      bump_size 0.2
   }
}

#declare T_SandStone = texture {
   pigment {
      color rgb <1, 0.796078, 0.533333>
   }
}

#declare T_Leather = texture {
   pigment {
      color rgb <0.0352941, 0.313725, 0>
   }
}

#declare M_Glass = material {
   interior {
      ior 1.52
   }
   
   texture {
      pigment {
         color rgbt <0, 0.05098, 1, 0.9>
      }
      
      finish {
         reflection {
            rgb <0.15, 0.15, 0.15>
         }
      }
   }
}

#declare O_CheckersGlob = lathe {
   cubic_spline
   8,
   <-0.05, 0.38108>, <0, 0.38108>, <0.05, 0.38108>, <0.1079, 0.36686>, <0.36106, 0.30844>, <0.52211, 0.1495>, <0.40527, 0.0031722>, <0, 0>
   scale <0.07, 0.085, 0.07>
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

#declare O_Chessboard = union {
   union {
      //*PMName Board
      
      difference {
         superellipsoid {
            <0.01, 0.01>
            scale <0.5, 0.1, 0.5>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <0.92, 0.2, 0.92>
            rotate <0, 0, 0>
            translate y*0.04
         }
         
         texture {
            pigment {
               color rgb <0.564706, 0.231373, 0.164706>
            }
         }
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         
         texture {
            checker 
            
            texture {
               T_WhitePiece
            }
            
            texture {
               T_BlackPiece
            }
            scale 0.125
         }
         scale <0.91, 0.01, 0.91>
         rotate <0, 0, 0>
         translate y*0.09
      }
   }
   
   union {
      //*PMName Pieces
      
      union {
         //*PMName RowWhite
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate y*0.096
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <-0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.455, 0.096, 0>
         }
         
         texture {
            T_WhitePiece
         }
         translate <-0.056875, 0, 0.398125>
      }
      
      union {
         //*PMName RowWhite
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate y*0.096
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <-0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.455, 0.096, 0>
         }
         
         texture {
            T_WhitePiece
         }
         translate <-0.17062, 0, 0.28438>
      }
      
      union {
         //*PMName RowWhite
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate y*0.096
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <-0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.455, 0.096, 0>
         }
         
         texture {
            T_WhitePiece
         }
         translate <-0.056875, 0, 0.17035>
      }
      
      union {
         //*PMName RowBlack
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate y*0.096
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <-0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.455, 0.096, 0>
         }
         
         texture {
            T_BlackPiece
         }
         translate <-0.056875, 0, -0.28438>
      }
      
      union {
         //*PMName RowBlack
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate y*0.096
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <-0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.455, 0.096, 0>
         }
         
         texture {
            T_BlackPiece
         }
         translate <-0.17062, 0, -0.39813>
      }
      
      union {
         //*PMName RowBlack
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate y*0.096
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <-0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.2275, 0.096, 0>
         }
         
         object {
            O_CheckersGlob
            scale 1
            rotate <0, 0, 0>
            translate <0.455, 0.096, 0>
         }
         
         texture {
            T_BlackPiece
         }
         translate <-0.17062, 0, -0.17035>
      }
   }
}

#declare O_Kalidascope = merge {
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale <0.3, 0.01, 0.0002>
      rotate x*90
      translate y*(-0.002886)
   }
   
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale <0.3, 0.01, 0.0002>
      rotate x*30
      translate <0, 0.0014436, -0.0025>
   }
   
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale <0.3, 0.01, 0.0002>
      rotate x*(-30)
      translate <0, 0.0014436, 0.0025>
   }
   
   texture {
      pigment {
         color rgb <0, 0, 0>
      }
      
      finish {
         reflection {
            rgb <0.956863, 0.956863, 0.956863>
         }
      }
   }
   rotate x*20
}

#declare O_Book = union {
   difference {
      superellipsoid {
         <0.01, 0.15>
         scale <0.45, 0.5, 0.15>
         rotate <0, 0, 0>
         translate y*0.5
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <0.9, 1.1, 0.2>
         rotate <0, 0, 0>
         translate <-0.05, 0.5, 0>
      }
      
      texture {
         T_Leather
      }
   }
   
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale <0.81, 0.9, 0.201>
      rotate <0, 0, 0>
      translate y*0.5
      
      pigment {
         color rgb <1, 1, 1>
      }
   }
   scale <1.2, 1, 1>
}

#declare O_Bookshelf1 = union {
   union {
      difference {
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <2.5, 8, 6>
            rotate <0, 0, 0>
            translate y*4
         }
         
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <2.5, 7.8, 5.8>
            rotate <0, 0, 0>
            translate <0.1, 4, 0>
         }
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <2.49, 0.2, 5.99>
         rotate <0, 0, 0>
         translate y*2
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <2.49, 0.2, 5.99>
         rotate <0, 0, 0>
         translate y*4
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <2.49, 0.2, 5.99>
         rotate <0, 0, 0>
         translate y*6
      }
      
      texture {
         T_Bookshelf
         
         normal {
            marble
            turbulence <1, 0.1, 0>
            bump_size 0.2
         }
      }
   }
   
   sphere {
      <0, 0, 0>, 0.5
      
      pigment {
         color rgb <1, 0, 0>
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 6.6, -2>
   }
   
   sphere {
      <0, 0, 0>, 0.5
      
      pigment {
         color rgb <1, 0, 0>
      }
      scale 1
      rotate <0, 0, 0>
      translate y*4.6
   }
   
   sphere {
      <0, 0, 0>, 0.5
      
      pigment {
         color rgb <1, 0, 0>
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 2.6, 2>
   }
   
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate y*6.6
      
      pigment {
         color rgb <0, 1, 0>
      }
   }
   
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 4.6, 2>
      
      pigment {
         color rgb <0, 1, 0>
      }
   }
   
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 2.6, -2>
      
      pigment {
         color rgb <0, 1, 0>
      }
   }
   
   cone {
      <0, 0.5, 0>, 0,
      <0, -0.5, 0>, 0.5
      scale 1
      rotate <0, 0, 0>
      translate <0, 6.6, 2>
      
      pigment {
         color rgb <0, 0, 1>
      }
   }
   
   cone {
      <0, 0.5, 0>, 0,
      <0, -0.5, 0>, 0.5
      scale 1
      rotate <0, 0, 0>
      translate <0, 4.6, -2>
      
      pigment {
         color rgb <0, 0, 1>
      }
   }
   
   cone {
      <0, 0.5, 0>, 0,
      <0, -0.5, 0>, 0.5
      scale 1
      rotate <0, 0, 0>
      translate y*2.6
      
      pigment {
         color rgb <0, 0, 1>
      }
   }
   
   sphere {
      <0, 0, 0>, 0.5
      scale 1
      rotate <0, 0, 0>
      translate <0, 0.6, -2>
      
      material {
         M_Glass
      }
   }
   
   box {
      <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate y*0.6
      
      material {
         M_Glass
      }
   }
   
   cone {
      <0, 0.5, 0>, 0,
      <0, -0.5, 0>, 0.5
      scale 1
      rotate <0, 0, 0>
      translate <0, 0.6, 2>
      
      material {
         M_Glass
      }
   }
}

#declare O_Bookshelf2 = union {
   union {
      difference {
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <2.5, 8, 6>
            rotate <0, 0, 0>
            translate y*4
         }
         
         box {
            <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
            scale <2.5, 7.8, 5.8>
            rotate <0, 0, 0>
            translate <0.1, 4, 0>
         }
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <2.49, 0.2, 5.99>
         rotate <0, 0, 0>
         translate y*2
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <2.49, 0.2, 5.99>
         rotate <0, 0, 0>
         translate y*4
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <2.49, 0.2, 5.99>
         rotate <0, 0, 0>
         translate y*6
      }
      
      texture {
         T_Bookshelf
         rotate x*90
      }
   }
   
   union {
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-2.7)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-2.35)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-2)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-1.65)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-1.3)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.95)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.6)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.25)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*0.1
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*0.45
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*0.8
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*1.15
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*1.5
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*1.85
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*2.2
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*2.55
      }
      translate y*0.1
   }
   
   union {
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-2.7)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-2.35)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-2)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-1.65)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-1.3)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.95)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.6)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.25)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*0.1
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*0.45
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*0.8
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*1.15
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*1.5
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*1.85
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*2.2
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*2.55
      }
      translate <0, 2.1, 0.15>
   }
   
   union {
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-2.7)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-2.35)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-2)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-1.65)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-1.3)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.95)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.6)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.25)
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*0.1
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*0.45
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*0.8
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*1.15
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*1.5
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*1.85
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*2.2
      }
      
      object {
         O_Book
         scale 1
         rotate <0, 0, 0>
         translate z*2.55
      }
      translate <0, 4.1, 0.07>
   }
}

#declare O_CupCoaster = union {
   difference {
      superellipsoid {
         <1, 0.1>
         rotate x*90
         scale <0.2, 0.3, 0.2>
         translate <0, 0, 0>
      }
      
      superellipsoid {
         <1, 0.1>
         rotate x*90
         scale <0.18, 0.3, 0.18>
         translate y*0.05
      }
      
      material {
         M_Glass
      }
      translate y*0.4
   }
   
   cylinder {
      <0, 0.1, 0>, <0, 0, 0>, 0.26
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
      
      texture {
         T_SandStone
      }
   }
}

#declare O_TableLeg = lathe {
   linear_spline
   6,
   <0, 1>, <0.1, 1>, <0.1, 0.7>, <0.1, 0.3>, <0.1, 0>, <0, 0>
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

#declare O_Table = union {
   superellipsoid {
      <0.02, 0.02>
      scale <2.5, 0.07, 1.5>
      rotate <0, 0, 0>
      translate y*2.93
      
      texture {
         T_Table
         rotate <0, 90, 1>
      }
   }
   
   object {
      //*PMName TableLeg
      O_TableLeg
      scale <1, 2.95, 1>
      rotate <0, 0, 0>
      translate <-2, 0, -1>
      
      texture {
         T_Table
         rotate <0, 1, 90>
      }
   }
   
   object {
      //*PMName TableLeg
      O_TableLeg
      scale <1, 2.95, 1>
      rotate <0, 0, 0>
      translate <2, 0, -1>
      
      texture {
         T_Table
         rotate <0, 1, 90>
      }
   }
   
   object {
      //*PMName TableLeg
      O_TableLeg
      scale <1, 2.95, 1>
      rotate <0, 0, 0>
      translate <2, 0, 1>
      
      texture {
         T_Table
         rotate <0, 1, 90>
      }
   }
   
   object {
      //*PMName TableLeg
      O_TableLeg
      scale <1, 2.95, 1>
      rotate <0, 0, 0>
      translate <-2, 0, 1>
      
      texture {
         T_Table
         rotate <0, 1, 90>
      }
   }
}

#declare O_Lamp = union {
   lathe {
      linear_spline
      7,
      <0, 1>, <0.15, 1>, <0.15, 0.7>, <0.15, 0.3>, <0.15, 0.15>, <0.6, 0>, <0, 0>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
      
      pigment {
         color rgb <0.239216, 0.14902, 0.0352941>
      }
      hollow
   }
   
   lathe {
      linear_spline
      2,
      <0.2537, 1.5526>, <0.77788, 0.84943>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
      
      texture {
         pigment {
            color rgbt <0.90588, 0.45882, 0.043137, 0.1>
         }
      }
      hollow
   }
   
   light_source {
      <0, 1.25, 0>, rgb <0.8, 0.764706, 0.580392>
      area_light <0.5, 0, 0>, <0, 0, 0.5>, 10, 10
      adaptive 1
      circular
   }
}

#declare O_EndTable = lathe {
   linear_spline
   7,
   <0, 3.5>, <1.5, 3.5>, <1.5, 3.2>, <0.4, 3.2>, <0.4, 0.7>, <0.4, 0>, <0, 0>
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
   
   texture {
      T_Table
   }
}

#declare O_BlindSlat = box {
   <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
   scale <0.1, 0.01, 3.9>
   rotate z*(-30)
   translate <0, 0, 0>
}

#declare O_Blinds = union {
   union {
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.05
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.15
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.25
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.35
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.45
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.55
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.65
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.75
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.85
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.95
      }
   }
   
   union {
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.05
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.15
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.25
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.35
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.45
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.55
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.65
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.75
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.85
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.95
      }
      translate y*1
   }
   
   union {
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.05
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.15
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.25
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.35
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.45
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.55
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.65
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.75
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.85
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.95
      }
      translate y*2
   }
   
   union {
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.05
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.15
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.25
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.35
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.45
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.55
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.65
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.75
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.85
      }
      
      object {
         //*PMName BlindSlat
         O_BlindSlat
         scale 1
         rotate <0, 0, 0>
         translate y*0.95
      }
      translate y*3
   }
   
   cylinder {
      <0, 4, 0>, <0, 0, 0>, 0.01
      scale 1
      rotate <0, 0, 0>
      translate z*(-1.8)
   }
   
   cylinder {
      <0, 4, 0>, <0, 0, 0>, 0.01
      scale 1
      rotate <0, 0, 0>
      translate z*1.8
   }
   
   pigment {
      color rgb <0.960784, 0.960784, 0.960784>
   }
}

#declare O_Artwork1 = union {
   difference {
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <2.1, 2.1, 0.1>
         rotate <0, 0, 0>
         translate x*1
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <1.9, 1.9, 0.3>
         rotate <0, 0, 0>
         translate x*1
      }
      
      pigment {
         color rgb <0.576471, 0.313725, 0.113725>
      }
   }
   
   box {
      <0, 0, 0>, <1, 1, 1>
      
      pigment {
         image_map {
            png
            "artwork1.png"
            map_type 0
         }
      }
      rotate <0, 0, 0>
      scale <2, 2, 0.05>
      translate <0, -1, -0.025>
   }
}

#declare O_Artwork2 = union {
   difference {
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <2.1, 2.1, 0.1>
         rotate <0, 0, 0>
         translate x*1
      }
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <1.9, 1.9, 0.3>
         rotate <0, 0, 0>
         translate x*1
      }
      
      pigment {
         color rgb <0.576471, 0.313725, 0.113725>
      }
   }
   
   box {
      <0, 0, 0>, <1, 1, 1>
      
      pigment {
         image_map {
            jpeg
            "artwork2.jpg"
            map_type 0
         }
      }
      rotate <0, 0, 0>
      scale <2, 2, 0.05>
      translate <0, -1, -0.025>
   }
}

#declare O_Room = union {
   difference {
      //*PMName Structure
      
      box {
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <50, 11, 50>
         rotate <0, 0, 0>
         translate <-9, 5.45, 11.5>
      }
      
      superellipsoid {
         <0.02, 0.02>
         scale <15, 5, 12.5>
         rotate <0, 0, 0>
         translate y*5
      }
      
      superellipsoid {
         <0.02, 0.02>
         scale <15, 5, 4>
         rotate <0, 0, 0>
         translate <-8, 5, 17>
      }
      
      box {
         //*PMName Door
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale <4, 7, 1.5>
         rotate <0, 0, 0>
         translate <-8.5, 3.5001, 12.5>
      }
      
      box {
         //*PMName Window
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale 4
         rotate <0, 0, 0>
         translate <15, 6, 6>
      }
      
      box {
         //*PMName Window
         <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
         scale 4
         rotate <0, 0, 0>
         translate <15, 6, -6>
      }
      
      texture {
         T_Walls
      }
   }
   
   object {
      //*PMName WindowBlinds
      O_Blinds
      scale 1
      rotate <0, 0, 0>
      translate <15, 4, -6>
   }
   
   object {
      //*PMName WindowBlinds
      O_Blinds
      scale 1
      rotate <0, 0, 0>
      translate <15, 4, 6>
   }
   
   object {
      //*PMName Bookshelf1
      O_Bookshelf1
      scale 1
      rotate y*90
      translate <6, 0, 11.15>
   }
   
   object {
      //*PMName Bookshelf2
      O_Bookshelf2
      scale 1
      rotate <0, 0, 0>
      translate x*(-13)
   }
   
   union {
      //*PMName Lamp & Table
      
      object {
         //*PMName EndTable
         O_EndTable
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Lamp
         O_Lamp
         scale 1
         rotate <0, 0, 0>
         translate y*3.5
      }
      translate <-12, 0, 9>
   }
   
   union {
      //*PMName Lamp & Table
      
      object {
         //*PMName EndTable
         O_EndTable
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Lamp
         O_Lamp
         scale 1
         rotate <0, 0, 0>
         translate y*3.5
      }
      translate <12, 0, 9>
   }
   
   object {
      //*PMName Artwork1
      O_Artwork1
      scale 1
      rotate <0, 0, 0>
      translate <-5, 6, 12>
   }
   
   object {
      //*PMName Artwork2
      O_Artwork2
      scale 1
      rotate <0, 0, 0>
      translate <-1, 6, 12>
   }
}

light_source {
   //*PMName Sun
   <45, 12, -18>, rgb <1, 0.996078, 0.882353>
   area_light <0, 0, 2>, <0, 2, 0>, 20, 20
   adaptive 1
   jitter
   circular
}

union {
   object {
      //*PMName Table
      O_Table
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      //*PMName CupCoaster
      O_CupCoaster
      scale 1
      rotate <0, 0, 0>
      translate <-1.235, 3, -0.9314>
   }
   
   object {
      //*PMName Chessboard
      O_Chessboard
      scale 1
      rotate <0, 0, 0>
      translate y*3.1
   }
}

object {
   //*PMName Room
   O_Room
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

object {
   //*PMName Kalidascope
   O_Kalidascope
   scale <0.2, 1, 1>
   rotate <90, 70.4, 90>
   translate <0, 4.6, -4>
}

sky_sphere {
   pigment {
      color rgb <0.607843, 0.952941, 1>
   }
}

camera {
   //*PMName camera2
   perspective
   location <0, 3, 0>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <45, 12, -18>
   angle 20
}

camera {
   perspective
   location <-3.97345, 4.77593, -3.78148>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0.181455, 3.23713, -0.0607774>
}

camera {
   //*PMName KCamera
   perspective
   location <0, 4.6, -4>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0, 3, 0>
   angle 80
}
