 
 
#declare DoorPt =
                 
prism {                                
  linear_sweep 
  linear_spline
  -0.5,        
   0.5,                             
    7
  < -.15, .175>, < .26,  .175>, < .3,.185>, <.36, .2>,
  <.3615,.31>, < .362,  .63>, < -.15,.64> 
    
  
  pigment {color Red}
}

#declare DoorOutline=
difference{
object{DoorPt}
object{DoorPt scale <.98,2,.98> translate .01*z}
rotate -90*x}

 
                   
#declare BodyCutterC1 =
                  
prism {                                
  linear_sweep 
  linear_spline
  -0.5,        
   0.5,                             
    4
  < -1, .2>, < 1.3,  .2>, < 1.3,-2>, <-1, -2>
  
  rotate -90*x 
  pigment {color Red}
}  

#declare BodyCutterC2 =                  
prism {                                
  linear_sweep 
  linear_spline
  -0.5,        
   0.5,                             
    9
  < -1, .27>, < .6,  .27>, < .9,.29>, <1.5, .29>,
  <1.5,.31>, < .9,  .31>, < .6,.33>, <.2, .34>,
  < -1,.34>  
  rotate -90*x 
  pigment {color Red}
}  

#declare BodyCutterC3 =
                  
prism {                                
  linear_sweep 
  linear_spline
  -0.5,        
   0.5,                             
    4
  < -1, .4>, < .2,  .4>, < 0,.415>, <-1, .415>
  
  rotate -90*x 
  pigment {color Red}
}  

 
        
#declare PropellerBlade =  
difference{
sphere { <0, 0, 0>, 0.5 } 
sphere { <0, 0, 0>, 0.49 } 
box { <-1, -1, -1>, <1, 1, 1> translate 1*z}
scale <.2,1,.2>} 
#declare Propeller =
union{
object {PropellerBlade pigment {color Red}}

object {PropellerBlade pigment {color Red} rotate 180*z  translate -1*y}

difference{
sphere { <0, 0, 0>, 0.2 } 
box { <-1, -1, -1>, <1, 1, 1> translate .92*z} 
scale <1,1,5>
pigment {color Red} 
translate .5*z translate -.5*y }

}
 

#declare WheelCoverTop =
difference{ 
sphere { <0, 0, 0>, 0.2 }  
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate -10*y   } 
scale <4,1,1> pigment {color Red} }

#declare WheelCoverBottom =
difference{ 
sphere { <0, 0, 0>, 0.2 }  
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate 10*y} 
scale <4,1,1 > pigment {color White} }

#declare WheelCover =
union{
object {WheelCoverTop}
object {WheelCoverBottom}
}




#declare Wheel =  
union{  
object {WheelCover scale .5  translate .1*y translate .04*x} 
union{
torus { 0.1, 0.03  pigment {color Black}}
cylinder { <0, -.0075, 0>, <0, .0075, 0>, .09 pigment {color Silver} }  
rotate -90*x}
scale .65}

 #declare Wheel2 =  
union{  
object {WheelCover scale .5  translate .1*y translate .05*x} 
union{
torus { 0.1, 0.03  pigment {color Black}}
cylinder { <0, -.0075, 0>, <0, .0075, 0>, .09 pigment {color Silver} }  
rotate -90*x translate .05*y}
scale .65}


   
#declare OutlineCutter =  
difference{
box { <-1, -1, -1>, <1, 1, 1>  scale 10}
prism {                                
  linear_sweep 
  linear_spline
  -100,        
   100,                             
    18
  < .04, .00>, <.04,  -.1>, < .045,-.15>, <.05, -.2>,
  <.06,-.23>, < .1,  -.24>, < .46,-.26>, <.83, -.3>,
  < 1.4,-.3>, < 3.45,  0>,  < 1.4,.3>, <.83, .3>,
    < .46,.26>,  < .1,.24>,<.06,.23>,<.05, .2>, 
    < .045,.15>, <.04,  -.1>
   
   
  
} 
 
  }



 
#declare Outline =   

prism {                                
  linear_sweep 
  linear_spline
  -0.5,        
   0.5,                             
    26
  < 0, .02>, < 2.41,  .185>, < 2.41,.36>, <2.2, .375>,
  <.94,.47>, < .8,  .54>, < .7,.59>, <.6, .63>,
  < .5,.67>, < .4,  .72>, < -.1,.77>, <-.47, .51>, 
   < -.6,  .505>, < -.7,  .5>,< -.8,  .49>,
  < -.915,.47>, < -.915,  .3>, < -.9,  .21>,< -.85,  .13>,
  
  < -.8,.1>, < -.7,  .0665>, < -.6,  .05>,< -.5,  .05>,
 
  < -.4,.04>, < -.3,  .03>, < -.2,  .02>
  rotate -90*x 
  pigment {color Red}
}  


#declare Body = 
  
union{
difference{
cone { <-.22, 0, 0>, 0.2, <2.5,0 , 0>, 0 scale <1,1,1.5>  } 
object {OutlineCutter  translate -2.2*x}
translate -.55*x translate -.05*y} 
difference{
union{
cone { <-1.7, 0, 0>, .23, <-.22, 0, 0>, .2  translate -.55*x translate -.05*y  scale <1,1,1.5>} 
cone { <-1.8, 0, 0>, .225, <-1.7, 0, 0>, .23  translate -.55*x translate -.05*y  scale <1,1,1.5>}   
cone { <-1.9, 0, 0>, .22, <-1.8, 0, 0>, .225  translate -.55*x translate -.05*y  scale <1,1,1.5>}     
cone { <-2, 0, 0>, .21, <-1.9, 0, 0>, .22  translate -.55*x translate -.05*y  scale <1,1,1.5>}  
cone { <-2.1, 0, 0>, .20, <-2, 0, 0>, .21  translate -.55*x translate -.05*y  scale <1,1,1.5>}    
sphere { <0,0, 0>, 0.2 scale <.1,1,1.5> translate -2.65*x translate -.05*y } 
   }
object {OutlineCutter translate -2.8*x}}
   }

#declare BodyRed =
difference{
object {Body scale 1.001 pigment {color Red}}
object {BodyCutterC1 scale <2,1,1>  translate -1.85*x translate -.3*y }
object {BodyCutterC2 scale <1,1,100>  translate -1.85*x translate -.3*y }
object {BodyCutterC3 scale <1,1,100>  translate -1.85*x translate -.35*y }

text {
  ttf             
  "crystal.ttf",  
  "N5125C",      
  2,              
  0 
  scale <.2,.2,10>  translate -.075*y 
  translate -20*z translate -.8*x            
}

text {
  ttf             
  "crystal.ttf",  
  "N5125C",      
  2,              
  0 
  scale <.2,.2,10>  translate -.075*y
  rotate 180*y 
  translate 20*z translate -.2*x            
}


} 

#declare WingPt1 =   
difference{
prism {                                
  linear_sweep 
  linear_spline
  -0.05,        
   0.05,                             
    27
  < 0, 0>, < .24,  .00>, < 1.2,.00>, <2.84, .24>,
  < 2.86,.3>, < 2.885,  .4>, < 2.9,.5>, <2.91, .6>,
  < 2.905,.7>, < 2.9,  .8>, < 2.89,.86>, <2.85, .88>, 
  < 2.825,.89>,
   < 1.25,  .97>, < -1.25,  .97>,< -2.825,  .89>,
  < -2.85,.88>, < -2.89,  .86>, < -2.9,  .8>,< -2.905,  .7>,
  
  < -2.91,.6>, < -2.9,  .5>, < -2.885,  .4>,< -2.86,  .3>,
 
  < -2.84,.24>, < -1.2,  .00>, < -.24,  .00>
  rotate -90*y 
  
}
difference{ 

box { <-1, -1, -1>, <1, 1, 1> scale 10 }
cylinder { <0, 0, -10>,  <0 , 0, 10>,  1 scale <.5,.025,1>  translate -.5*x} 
 
 }
 
difference{ 

box { <-1, -1, -1>, <1, 1, 1> scale 10 }
cylinder { <0, 0,1.5>,  <0 , 0, 10>,  1 scale <.5,.025,1>  rotate 2*y translate -.5*x} 
 
 } 
 }
 
  
#declare WingPt2 =   
difference{
prism {                                
  linear_sweep 
  linear_spline
  -0.05,        
   0.05,                             
    27
  < 0, 0>, < .24,  .00>, < 1.2,.00>, <2.84, .24>,
  < 2.86,.3>, < 2.885,  .4>, < 2.9,.5>, <2.91, .6>,
  < 2.905,.7>, < 2.9,  .8>, < 2.89,.86>, <2.85, .88>, 
  < 2.825,.89>,
   < 1.25,  .97>, < -1.25,  .97>,< -2.825,  .89>,
  < -2.85,.88>, < -2.89,  .86>, < -2.9,  .8>,< -2.905,  .7>,
  
  < -2.91,.6>, < -2.9,  .5>, < -2.885,  .4>,< -2.86,  .3>,
 
  < -2.84,.24>, < -1.2,  .00>, < -.24,  .00>
  rotate -90*y 
  
}
difference{ 

box { <-1, -1, -1>, <1, 1, 1> scale 10 }
cylinder { <0, 0, -10>,  <0 , 0, 10>,  1 scale <.5,.025,1>  translate -.5*x} 
translate .025*x 
 }
box { <-1, -1, -1>, <1, 1, 1>  translate 2.52*z} 
box { <-1, -1, -1>, <1, 1, 1>  translate -2.52*z} 
 }


#declare WingPt3 =   
difference{
prism {                                
  linear_sweep 
  linear_spline
  -0.05,        
   0.05,                             
    27
  < 0, 0>, < .24,  .00>, < 1.2,.00>, <2.84, .24>,
  < 2.86,.3>, < 2.885,  .4>, < 2.9,.5>, <2.91, .6>,
  < 2.905,.7>, < 2.9,  .8>, < 2.89,.86>, <2.85, .88>, 
  < 2.825,.89>,
   < 1.25,  .97>, < -1.25,  .97>,< -2.825,  .89>,
  < -2.85,.88>, < -2.89,  .86>, < -2.9,  .8>,< -2.905,  .7>,
  
  < -2.91,.6>, < -2.9,  .5>, < -2.885,  .4>,< -2.86,  .3>,
 
  < -2.84,.24>, < -1.2,  .00>, < -.24,  .00>
  rotate -90*y 
  
}
difference{ 

box { <-1, -1, -1>, <1, 1, 1> scale 10 }
cylinder { <0, 0, -10>,  <0 , 0, 10>,  1 scale <.5,.025,1>  translate -.5*x} 
 
 }
 
difference{ 

box { <-1, -1, -1>, <1, 1, 1> scale 10 }
cylinder { <0, 0,-1.5>,  <0 , 0, -10>,  1 scale <.5,.025,1>  rotate -2*y translate -.5*x} 
 
translate -.01*x } 
 } 
 
  declare WingPt4 =
  union{
  object {WingPt2}       
  object {WingPt1 scale 1 }
  object {WingPt3}
  }       
#declare Wing =
union{
object {WingPt4 scale .99 pigment {color Black}} 
difference{
object {WingPt4 scale 1 pigment {color White}}

box { <-1, -1, -1>, <1, 1, 1>scale <1,1,.005> translate 1.3*z  translate -1.245*x}
box { <-1, -1, -1>, <1, 1, 1>scale <1,1,.005> translate -1.3*z  translate -1.245*x}
box { <-1, -1, -1>, <1, 1, 1>scale <1,1,.005> translate .33*z  translate -1.245*x}
box { <-1, -1, -1>, <1, 1, 1>scale <1,1,.005> translate -.33*z  translate -1.245*x} 

box { <-1, -1, -1>, <1, 1, 1>scale <1,1,.005> rotate 15*y translate .07*z  translate .78*x} 
box { <-1, -1, -1>, <1, 1, 1>scale <1,1,.005> rotate -15*y translate -.07*z  translate .78*x}  
 
box { <-1, -1, -1>, <1, 1, 1>scale <.005,1.0,.49> translate -.18*x  translate .815*z} 
box { <-1, -1, -1>, <1, 1, 1>scale <.005,1,.4875> translate -.24*x  translate .815*z}
box { <-1, -1, -1>, <1, 1, 1>scale <.005,1.0,.49> translate -.18*x  translate -.815*z} 
box { <-1, -1, -1>, <1, 1, 1>scale <.005,1,.4875> translate -.24*x  translate  - .815*z}
difference{
box { <-1, -1, -1>, <1, 1, 1>scale <.005,1,.785> rotate -8.5*y translate -.295*x  translate 2.075*z}
    
box { <-1, -1, -1>, <1, 1, 1> scale 10  translate 12.8*z}   
 }   
difference{ 
box { <-1, -1, -1>, <1, 1, 1>scale <.005,1,.785> rotate 8.5*y translate -.295*x  translate -2.075*z}
box { <-1, -1, -1>, <1, 1, 1>  scale 10 translate -12.8*z}   
 } 
 
 
box { <-1, -1, -1>, <1, 1, 1>scale <1,1,.005> translate 1.3*z  translate .825*x} 
box { <-1, -1, -1>, <1, 1, 1>scale <1,1,.005> translate 2.8*z  translate .6*x} 

box { <-1, -1, -1>, <1, 1, 1>scale <1,1,.005> translate -1.3*z  translate .825*x} 
box { <-1, -1, -1>, <1, 1, 1>scale <1,1,.005> translate -2.8*z  translate .6*x} 

} 
}


#declare Tail =
union{
difference{
prism {                                
  linear_sweep 
  linear_spline
  -0.011,        
   0.011,                             
    4
  < .78, .13>, < 1.03,  .13>, < 1.04,.17>, <.81, .17> pigment{color Red} 
  
  
  rotate -90*x 
} 

text {
  ttf            
  "crystal.ttf",  
  "cessna",      
  5,             
  0
  scale <.06,.06,1> 
  translate -2*z translate .825*x translate .135*y              
}
}


prism {                                
  linear_sweep 
  linear_spline
  -0.011,        
   0.011,                             
    4
  < .83, .2>, < .85,  .2>, < 1.03,.3>, <.88, .3> pigment{color Red} 
  
  
  rotate -90*x 
}

prism {                                
  linear_sweep 
  linear_spline
  -0.011,        
   0.011,                             
    4
  < .93, .2>, < 1.05,  .2>, < 1.1,.3>, <.93, .2> pigment{color Red} 
  
  
  rotate -90*x 
}



prism {                                
  linear_sweep 
  linear_spline
  -0.01,        
   0.01,                             
    21
  < 0, 0>, < .68,  -.1>, < .68,-.23>, <.8, -.2>,<.825,-.195> ,
  <.85,-.18> ,  <.875,-.17> , <.90,-.166> , <.902,-.16> ,
  < 1.2,.56>, <1.21, .57>,
  < 1.215,.575>, < 1.225,  .59>, < 1.215,.595>, <1.20, .6>,  < 1.1,.615>,
   < 1.0,  .62>, < .9,.615>, <.88, .61>,   < .42,.13>, < 0,  0>
  
  
  rotate -90*x 
} 
 }
 

#declare Stabilizer = 
union{   

prism {                                
  linear_sweep 
  linear_spline
  -0.01,        
   0.01,                             
    19
  < 0, .26>, < .14,  .0>, < .83,.085>, <.86, .2>,
  < .88,.3>, <.885,  .35>, < .88,.4>, <.86, .45>,
  < .84,.5>, < 0,  .64>, < -.84,.5>, <-.86, .45>,
  < -.88,.4>, < -.885,  .35> ,< -.88,.3>, < -.86,  .2>,
  < -.83,.085>, < -.14,  0> ,<0,.26>
  
  scale .99 pigment {color Black}  
} 
difference{
prism {                                
  linear_sweep 
  linear_spline
  -0.01,        
   0.01,                             
    19
  < 0, .26>, < .14,  .0>, < .83,.085>, <.86, .2>,
  < .88,.3>, <.885,  .35>, < .88,.4>, <.86, .45>,
  < .84,.5>, < 0,  .64>, < -.84,.5>, <-.86, .45>,
  < -.88,.4>, < -.885,  .35> ,< -.88,.3>, < -.86,  .2>,
  < -.83,.085>, < -.14,  0> ,<0,.26>
  
    
} 

prism {                                
  linear_sweep 
  linear_spline
  -1,        
   1,                             
    11
  < -.84, .09>, < -.83,  .14>, < 0,.08>, <.83, .14>,
  < .84,.09>, <.83,  .08>, < .82,.13>, <0, .07>,
  < -.82,.13>, < -.83,  .08>, < -.84,.09>
  
   
} 
 

prism {                                
  linear_sweep 
  linear_spline
  -1,        
   1,                             
    12
  < -1, .34>, < -.83,  .34>, < -.83,.27>, <.83, .27>,
  < .83,.34>, <1,  .34>, < 1,.33>, <.84, .33>, 
  <.84,.26>,<-.84,.26>,
  < -.84,.33>, < -1, .33>
  
    
}  

}
translate 2*x }
#declare Cessna = 
difference{
union{ 




#declare Window =
cone { <0, 0, 0>, .52<0, .5>, .3
 
 translate .5*x translate -.125*y scale <1.5,1,.5> } 
 

object {Window texture {T_Glass3} } 
  
difference{
 object {Window scale 1.01 pigment {color White}} 
 
 box { <-1, -1, -1>, <1, 1, 1> scale <.2,.08,2> translate .68*x translate .22*y }
 box { <-1, -1, -1>, <1, 1, 1> rotate -30*z scale <1,1,2> translate -.825*x translate .25*y }
 box { <-1, -1, -1>, <1, 1, 1> rotate 30*z scale <1,1,2> translate  2.2*x translate .25*y }
 
 
prism {                                
  linear_sweep  
  linear_spline 
  -10,         
   10,         
  4,           
  
  < -0.15, 0>, < 0.15,  0>, < .12, .32>, < -.12,.32> 
  rotate -90*x rotate 90*y  
}

 
 }
 
 


union{
union{
cylinder { <0, -.5, 0>, <0, .0, 0>, .02  pigment {color White} }
cylinder { <0, -.37, 0>, <0, -.355, 0>, .025  pigment {color White} }
cylinder { <0, -.33, 0>, <0, -.315, 0>, .025  pigment {color White} }
rotate -5*z translate -.06*x}   
cylinder { <0, -.04, 0>, <0, .0, 0>, .004  pigment {color White } rotate 60*z translate -.07*x translate -.32*y}
cylinder { <0, -.04, 0>, <0, .0, 0>, .004  pigment {color White} rotate -60*z translate -.04*x translate -.345*y}
sphere { <0, 0, 0>, 0.008  pigment {color White} translate -.033*x translate -.34*y }
object {Wheel2  translate -.5*y translate -.1*x translate -.01*y} 


} 
union{
 difference{ 
box { <-1, -1, -1>, <1, 1, 1> scale <.1,.2,.01>}   

box { <-1, -1, -1>, <1, 1, 1>  translate 1.0*x rotate -10*z}
rotate 60*x rotate -20*z translate .6*x translate -.3*y 
} 




object {Wheel scale 2.5/2.3  translate -.2*z translate -.5*y translate .45*x} 
translate -.272*z translate -.01*y} 


union{ 
difference{ 
box { <-1, -1, -1>, <1, 1, 1> scale <.1,.2,.01>}   

box { <-1, -1, -1>, <1, 1, 1>  translate 1.0*x rotate -10*z}
rotate -60*x rotate -20*z translate .6*x translate -.3*y pigment {color White}
}
object {Wheel scale  2.5/2.3 rotate 180*y translate .2*z translate -.5*y translate .45*x} 

translate .272*z translate -.01*y}





object {Body pigment {color White} translate 2.225*x translate -.02*y }  
object {BodyRed scale 1.001  translate 2.225*x translate -.001*y }

difference{
object {Wing }  

box { <-1, -1, -1>, <1, 1, 1>  scale 1 pigment {color Red} rotate 20*x translate 3.05*z translate 1*y}
box { <-1, -1, -1>, <1, 1, 1> scale 1  pigment {color Red}  rotate -20*x translate -3.05*z translate 1*y } 
  
translate  .365*y translate 1.2*x  }
object {Stabilizer rotate -90*y translate 2.85*x pigment {color Red} translate -2*z}

object {Propeller scale .494  rotate 90*y  translate -.49*x translate .26*y rotate 30*x} 

box { <-1, -1, -1>, <1, 1, 1> scale <.005,.3,.02> pigment {color Black} rotate -30*z translate 3.05*x translate .28*y}                                                                                               
box { <-1, -1, -1>, <1, 1, 1> scale <.005,.05,.02> pigment {color Black} rotate 60*z translate 3.16*x translate .57*y} 
box { <-1, -1, -1>, <1, 1, 1> scale <.005,.05,.02> pigment {color Black} rotate -30*z translate 3.14*x translate .626*y}                                


object {Tail pigment {color White}  translate 2.225*x translate .065*y  }    


}
object {DoorOutline scale <1,1,5>  translate .57*x translate -.3*y}
box { <-1, -1, -1>, <1, 1, 1>scale <.002,2,2>  rotate -5*z translate 1.7*y translate .1*x} 
box { <-1, -1, -1>, <1, 1, 1>scale <.002,2,2>  rotate -5*z translate 1.7*y translate -.2*x}
}
 



 




