// File: Lbatrain.pov
// Vers: 3.6
// Desc: The Abanded Train
// Date: Start 09/23/04  Finished 10/29/04
// Auth: Larry Boston


#include "colors.inc"
#include "woods.inc"   
#include "metals.inc"
#include "skies.inc" 
#include "stones.inc" 
#include "glass.inc"
#include "trainparts.inc" 
#include "traintracks.inc" 
#include "trainengine.inc" 
#include "traincaboose.inc"
#include "traintankcar.inc"
#include "traincoalcar.inc"
#include "trainflatcar.inc"
#include "trainpassengercar.inc"     
#include "blocks.inc"
#include "cessna.inc" 
#include "toytruck.inc" 
#include "clownsketch.inc"   
#include "firehat.inc"   
#include "blankets.inc"
// ----------------------------------------


camera {   location  <-2, .1, -3.6>   look_at <.1, -.2,  0>   }
 
light_source {  <0, 0, 0> color rgb <1, 1, 1>*.5  translate <-.5, 1.5, -3>} 

light_source {  <0, 0, 0> color rgb <1, 1, 1>*.5 translate <1, .1, -3.5> shadowless}

background {SkyBlue*1.5}

object{O_Cloud1}    

//ceiling
box { <-1, -1, -1>, <1, 1, 1>  scale <3,.01,2.995>   translate -.94*z   translate 2.55*y texture{pigment {color White*2.25} finish {crand .03}}}

#declare FloorTex =
texture {
    pigment {
        wood
        turbulence 0.03725
        omega 0.65725
        lambda 2.425
        color_map {
            [0.250 color rgbt <1.00000, 0.53373, 0.11665, 0.000>*1.5]
            [0.350 color rgbt <0.66275, 0.28607, 0.00000, 0.000>*1.5]
            [0.525 color rgbt <1.00000, 0.53363, 0.11715, 0.000>*1.5]
            [0.600 color rgbt <0.66475, 0.28647, 0.00000, 0.000>*1.5]
            [0.750 color rgbt <1.00000, 0.53353, 0.11565, 0.000>*1.5]
            [0.850 color rgbt <0.66275, 0.28667, 0.00000, 0.000>*1.5]
            [1.000 color rgbt <1.00000, 0.53143, 0.11795, 0.000>*1.5]
        }
        scale <0.25, 0.225, 1.0>
    }
}
texture {
    pigment {
        wood
        scale 1.01275
        turbulence 0.0435
        omega 0.65
        lambda 3.15
        color_map {
            [0.200 color rgbt <0.56695, 0.17347, 0.00000, 0.8250>]
            [0.350 color rgbt <0.96471, 0.54510, 0.22753, 0.7710>]
            [0.400 color rgbt <0.56341, 0.17547, 0.00000, 0.9150>]
            [0.615 color rgbt <0.96472, 0.54510, 0.22553, 0.7590>]
            [0.700 color rgbt <0.56671, 0.17687, 0.00000, 0.7920>]
            [0.850 color rgbt <0.96485, 0.54510, 0.22453, 0.8975>]
            [1.000 color rgbt <0.56478, 0.17247, 0.00000, 0.9750>]
        }
        scale <0.225, 0.2725, 1.0>
        translate <-0.35, 0.095, 1.25>
    }
}




#declare Floorboard =   

box { <-1, -1, -1>, <1, 1, 1> scale <4.05,.025,.05>} 

#declare Floor =  
union{ 
box { <-1, -1, -1>, <1, 1, 1>  scale <4,.0249,3.1> pigment {color Gray20}translate -.225*z } 
object {Floorboard  texture {		FloorTex	scale .5	rotate	92	*y	translate 	2	*x	}	translate 	0	*z}
object {Floorboard  texture {		FloorTex	scale .6	rotate	90	*y	translate 	0	*x	}	translate 	0.103	*z}
object {Floorboard  texture {		FloorTex	scale .7	rotate	92	*y	translate 	2	*x	}	translate 	0.206	*z}
object {Floorboard  texture {		FloorTex	scale .8	rotate	97	*y	translate 	7	*x	}	translate 	0.309	*z}
object {Floorboard  texture {		FloorTex	scale .9	rotate	100	*y	translate 	10	*x	}	translate 	0.412	*z}
object {Floorboard  texture {		FloorTex	scale .10	rotate	95	*y	translate 	5	*x	}	translate 	0.515	*z}
object {Floorboard  texture {		FloorTex	scale .11	rotate	96	*y	translate 	6	*x	}	translate 	0.618	*z}
object {Floorboard  texture {		FloorTex	scale .12	rotate	98	*y	translate 	8	*x	}	translate 	0.721	*z}
object {Floorboard  texture {		FloorTex	scale .13	rotate	91	*y	translate 	1	*x	}	translate 	0.824	*z}
object {Floorboard  texture {		FloorTex	scale .14	rotate	91	*y	translate 	1	*x	}	translate 	0.927	*z}
object {Floorboard  texture {		FloorTex	scale .15	rotate	98	*y	translate 	8	*x	}	translate 	1.03	*z}
object {Floorboard  texture {		FloorTex	scale .16	rotate	96	*y	translate 	6	*x	}	translate 	1.133	*z}
object {Floorboard  texture {		FloorTex	scale .17	rotate	98	*y	translate 	8	*x	}	translate 	1.236	*z}
object {Floorboard  texture {		FloorTex	scale .18	rotate	91	*y	translate 	1	*x	}	translate 	1.339	*z}
object {Floorboard  texture {		FloorTex	scale .19	rotate	90	*y	translate 	0	*x	}	translate 	1.442	*z}
object {Floorboard  texture {		FloorTex	scale .20	rotate	91	*y	translate 	1	*x	}	translate 	1.545	*z}
object {Floorboard  texture {		FloorTex	scale .21	rotate	91	*y	translate 	1	*x	}	translate 	1.648	*z}
object {Floorboard  texture {		FloorTex	scale .22	rotate	91	*y	translate 	1	*x	}	translate 	1.751	*z}
object {Floorboard  texture {		FloorTex	scale .23	rotate	97	*y	translate 	7	*x	}	translate 	1.854	*z}
object {Floorboard  texture {		FloorTex	scale .24	rotate	97	*y	translate 	7	*x	}	translate 	1.957	*z}
object {Floorboard  texture {		FloorTex	scale .25	rotate	94	*y	translate 	4	*x	}	translate 	2.06	*z}
object {Floorboard  texture {		FloorTex	scale .26	rotate	94	*y	translate 	4	*x	}	translate 	2.163	*z}
object {Floorboard  texture {		FloorTex	scale .27	rotate	96	*y	translate 	6	*x	}	translate 	2.266	*z}
object {Floorboard  texture {		FloorTex	scale .28	rotate	91	*y	translate 	1	*x	}	translate 	2.369	*z}
object {Floorboard  texture {		FloorTex	scale .29	rotate	98	*y	translate 	8	*x	}	translate 	2.472	*z}
object {Floorboard  texture {		FloorTex	scale .30	rotate	91	*y	translate 	1	*x	}	translate 	2.575	*z}
object {Floorboard  texture {		FloorTex	scale .31	rotate	99	*y	translate 	9	*x	}	translate 	2.678	*z}
object {Floorboard  texture {		FloorTex	scale .32	rotate	95	*y	translate 	5	*x	}	translate 	2.781	*z}
object {Floorboard  texture {		FloorTex	scale .33	rotate	97	*y	translate 	7	*x	}	translate 	2.884	*z}
object {Floorboard  texture {		FloorTex	scale .34	rotate	99	*y	translate 	9	*x	}	translate 	2.987	*z}
object {Floorboard  texture {		FloorTex	scale .35	rotate	97	*y	translate 	7	*x	}	translate 	3.09	*z}
object {Floorboard  texture {		FloorTex	scale .39	rotate	91	*y	translate 	1	*x	}	translate 	0	*z}
object {Floorboard  texture {		FloorTex	scale .40	rotate	100	*y	translate 	10	*x	}	translate 	-0.103	*z}
object {Floorboard  texture {		FloorTex	scale .41	rotate	97	*y	translate 	7	*x	}	translate 	-0.206	*z}
object {Floorboard  texture {		FloorTex	scale .42	rotate	98	*y	translate 	8	*x	}	translate 	-0.309	*z}
object {Floorboard  texture {		FloorTex	scale .43	rotate	95	*y	translate 	5	*x	}	translate 	-0.412	*z}
object {Floorboard  texture {		FloorTex	scale .44	rotate	97	*y	translate 	7	*x	}	translate 	-0.515	*z}
object {Floorboard  texture {		FloorTex	scale .45	rotate	94	*y	translate 	4	*x	}	translate 	-0.618	*z}
object {Floorboard  texture {		FloorTex	scale .46	rotate	95	*y	translate 	5	*x	}	translate 	-0.721	*z}
object {Floorboard  texture {		FloorTex	scale .47	rotate	92	*y	translate 	2	*x	}	translate 	-0.824	*z}
object {Floorboard  texture {		FloorTex	scale .48	rotate	92	*y	translate 	2	*x	}	translate 	-0.927	*z}
object {Floorboard  texture {		FloorTex	scale .49	rotate	95	*y	translate 	5	*x	}	translate 	-1.03	*z}
object {Floorboard  texture {		FloorTex	scale .50	rotate	99	*y	translate 	9	*x	}	translate 	-1.133	*z}
object {Floorboard  texture {		FloorTex	scale .51	rotate	93	*y	translate 	3	*x	}	translate 	-1.236	*z}
object {Floorboard  texture {		FloorTex	scale .52	rotate	93	*y	translate 	3	*x	}	translate 	-1.339	*z}
object {Floorboard  texture {		FloorTex	scale .53	rotate	93	*y	translate 	3	*x	}	translate 	-1.442	*z}
object {Floorboard  texture {		FloorTex	scale .54	rotate	91	*y	translate 	1	*x	}	translate 	-1.545	*z}
object {Floorboard  texture {		FloorTex	scale .55	rotate	99	*y	translate 	9	*x	}	translate 	-1.648	*z}
object {Floorboard  texture {		FloorTex	scale .56	rotate	92	*y	translate 	2	*x	}	translate 	-1.751	*z}
object {Floorboard  texture {		FloorTex	scale .57	rotate	98	*y	translate 	8	*x	}	translate 	-1.854	*z}
object {Floorboard  texture {		FloorTex	scale .58	rotate	98	*y	translate 	8	*x	}	translate 	-1.957	*z}
object {Floorboard  texture {		FloorTex	scale .59	rotate	98	*y	translate 	8	*x	}	translate 	-2.06	*z}
object {Floorboard  texture {		FloorTex	scale .60	rotate	92	*y	translate 	2	*x	}	translate 	-2.163	*z}
object {Floorboard  texture {		FloorTex	scale .61	rotate	95	*y	translate 	5	*x	}	translate 	-2.266	*z}
object {Floorboard  texture {		FloorTex	scale .62	rotate	95	*y	translate 	5	*x	}	translate 	-2.369	*z}
object {Floorboard  texture {		FloorTex	scale .63	rotate	97	*y	translate 	7	*x	}	translate 	-2.472	*z}
object {Floorboard  texture {		FloorTex	scale .64	rotate	98	*y	translate 	8	*x	}	translate 	-2.575	*z}
object {Floorboard  texture {		FloorTex	scale .65	rotate	94	*y	translate 	4	*x	}	translate 	-2.678	*z}
object {Floorboard  texture {		FloorTex	scale .66	rotate	94	*y	translate 	4	*x	}	translate 	-2.781	*z}
object {Floorboard  texture {		FloorTex	scale .67	rotate	94	*y	translate 	4	*x	}	translate 	-2.884	*z}
object {Floorboard  texture {		FloorTex	scale .68	rotate	97	*y	translate 	7	*x	}	translate 	-2.987	*z}
object {Floorboard  texture {		FloorTex	scale .69	rotate	99	*y	translate 	9	*x	}	translate 	-3.09	*z}
object {Floorboard  texture {		FloorTex	scale .70	rotate	93	*y	translate 	3	*x	}	translate 	-3.193	*z}
object {Floorboard  texture {		FloorTex	scale .71	rotate	99	*y	translate 	9	*x	}	translate 	-3.296	*z}

rotate 90*y translate -1*y translate -2*z} 
 
#declare Mopboard  = 
union{
box { <-1, -1, -1>, <1, 1, 1> scale <5,.2,.02>  }
cylinder { <-6 0, 0>, <6, 0, 0>, .04 translate .2*y   translate .02*z}
}
 

difference{
object {Floor}  
box { <-1, -1, -1>, <1, 1, 1>  scale 10 translate -14*z}
} 

difference{
object {Mopboard texture {pigment {color White} finish {roughness .5}} translate -1*x } 
box { <-1, -1, -1>, <1, 1, 1> rotate 45*y translate 3.87*x  translate -.5*z }
box { <-1, -1, -1>, <1, 1, 1> scale 2 translate -5.5*x}
translate -1*y translate 1.96*z   }
difference{
object {Mopboard }
box { <-1, -1, -1>, <1, 1, 1>  scale 10 rotate -45*y translate -15.625*x  translate -.5*z }
 rotate 90*y texture {pigment {color White} finish {roughness .5}}  translate -1*y translate 2.97*x}

#declare Car =
union{
cylinder { <0, 0, -.01>, <0, 0, .01>, .075  translate .3*x} 
cylinder { <0, 0, -.01>, <0, 0, .01>, .075  translate -.2*x}

difference{ 
union{
cylinder { <0, 0, -.01>, <0, 0, .01>, .4 translate .10*x}
cylinder { <0, 0, -.01>, <0, 0, .01>, .25 translate -.2*x}
}  
difference{
cylinder { <0, 0, -1>, <0, 0, 1>, .05}
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate 10*x } 
 box { <-1, -1, -1>, <1, 1, 1>scale 10 translate -10*y } 
scale 2 translate .2*y translate .1*x}  

difference{
cylinder { <0, 0, -1>, <0, 0, 1>, .05}
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate -10*x } 
 box { <-1, -1, -1>, <1, 1, 1>scale 10 translate -10*y } 
scale 2 translate .2*y translate .2*x}  



box { <-1, -1, -1>, <1, 1, 1>  translate -1*y}
}
scale <.75,.75,1> 
}
 
     

#declare Boat =
union{


prism {                                
  linear_sweep  
  linear_spline 
  -0.02,         
   0.02,         
  4,           
  
  < -.2, 0>, < 0, 0>, < 0, .5>, < -.2,  0> rotate -90*x translate -.02*x}


prism {                                
  linear_sweep  
  linear_spline 
  -0.02,         
   0.02,         
  4,           
  
  < .02, 0>, < .2,  0>, < .02, .5>, < .02,  0>
rotate -90*x} 

 prism {                                
  linear_sweep  
  linear_spline 
  -0.02,         
   0.02,         
  4,           
  
  < .00, 0>, < .02,  .01>, < .0, .02>, < 0,  0>
rotate -90*x  scale <5,1,1> translate .52*y } 


difference{
cylinder { <0, 0, -.02>, <0, 0, .02>, .1 } 
box { <-1, -1, -1>, <1, 1, 1> translate 1*y}
scale <3,1.25,1> translate -.05*y}

box { <-1, -1, -1>, <1, 1, 1> scale <.01,.3,.02> translate .25*y}

}         
     
     
     
     
#declare Bracket = 
union{ 
 union{      
difference{ 
union{
cylinder { <-.005, 0, 0>, <.005, 0, 0>, .03 } 
box { <-1, -1, -1>, <1, 1, 1> scale <.005,.03,.03> translate .03*z rotate 10*x}  
}  

box { <-1, -1, -1>, <1, 1, 1>  translate -1*y}
translate .05*z
 }  
 
difference{
cylinder { <-.005, 0, 0>, <.005, 0, 0>, .02 }
cylinder { <-.006, 0, 0>, <.006, 0, 0>, .01 }       
translate .03*z translate -.01*y} 
translate .1*y translate -.005*z}     
       
cylinder { <0, 0, 0>, <0, 0, -.01>, .03 scale < 1,1,1.5> translate -.125*y translate .02*z translate .015*x }
cylinder { <0, 0, 0>, <0, 0, -.01>, .03 scale < 1,1,1.5> translate -.125*y translate .02*z translate -.015*x } 
box { <-1, -1, -1>, <1, 1, 1> scale <.014,.01,.005>  translate -.15*y translate .02*z}

box { <-1, -1, -1>, <1, 1, 1> scale <.01,.1,.025> } 

cylinder { <-.01, .1, 0>, <0.01, .1, 0>, .025 }
cylinder { <-.01, -.1, 0>, <0.01, -.1, 0>, .025 }

difference{  
 union{
 cylinder { <-.02, 0, 0>, <0.02, 0, 0>, .04  } 
 torus { 0.04, 0.02  rotate 90*x rotate 90*y}
 translate .02*z
 }   
 
box { <-1, -1, -1>, <1, 1, 1> translate 1*y  }  
 box { <-1, -1, -1>, <1, 1, 1>translate  1.02*z } 
 translate -.10*y}
 

}

#declare Trimtex = T_Wood1

#declare Toybox = 
union{  
object {Bracket  pigment {color Gray10}  translate .7*y translate .525*z}
#declare Top =
union{  

box { <-1, -1, -1>, <1, 1, 1> scale <.02,.05,.05> pigment {color Gray10} translate .56*y translate .4*z}

box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.04,.04,.6> translate .56*y translate 1.48*x }
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.04,.04,.6> translate .56*y translate 0*x }
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.04,.04,.6> translate .56*y translate -1.48*x}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <1.52,.04,.04> translate .56*y translate .6*z }
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <1.52,.04,.04> translate .56*y translate -.6*z }
box { <-1, -1, -1>, <1, 1, 1>   scale <1.49,.002,.59> translate .56*y }
translate .1*y}
object {Top rotate 80*x translate 1.1375*y translate -.175*z}

object {Boat pigment {color Red} translate -.58*z translate -.65*x translate -.2*y} 
object {Car pigment {color Red} translate -.590*z translate .65*x translate -.1*y}     

box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <1.5,.04,.02> translate .56*y translate -.6*z}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <1.5,.04,.02> translate .56*y translate .6*z}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <1.5,.04,.02> translate -.56*y translate -.6*z}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <1.5,.04,.02> translate -.56*y translate .6*z}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.04,.6,.02> translate 0*y translate -.6*z translate -1.48*x}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.04,.6,.02> translate 0*y translate -.6*z translate 0*x} 
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.04,.6,.02> translate 0*y translate  .6*z translate 0*x} 
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.04,.6,.02> translate 0*y translate -.6*z translate 1.48*x}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.02,.04,.6> translate -.56*y  translate -1.5*x}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.02,.04,.6> translate .56*y  translate -1.5*x}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.02,.04,.6> translate -.56*y  translate 1.45*x}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.02,.04,.6> translate .56*y  translate 1.45*x  }
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.02,.6,.04> translate 0*y translate -.58*z translate -1.5*x}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.02,.6,.04> translate 0*y translate  .58*z translate -1.5*x}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.02,.6,.04> translate 0*y translate -.58*z translate 1.5*x}
box { <-1, -1, -1>, <1, 1, 1>  texture{Trimtex} scale <.02,.6,.04> translate 0*y translate  .58*z translate 1.5*x}

#declare Foot =
difference{
box { <-1, -1, -1>, <1, 1, 1> scale <.06,.05,.06> }
cylinder { <0, 0, -5>, <0, 0, 5>, .04 translate .06*x translate -.04*y }
cylinder { <-5, 0, 0>, <5, 0, 0>, .04 translate .06*z translate -.04*y  }
}
object {Foot translate -.6*y translate -.58*z translate -1.46*x  texture{Trimtex}}
object {Foot translate -.6*y translate  .58*z translate -1.46*x  texture{Trimtex}}  

object {Foot translate -.6*y rotate 180*y translate -.58*z  translate 1.46*x  texture{Trimtex}}
object {Foot translate -.6*y rotate 180*y translate  .58*z  translate 1.46*x  texture{Trimtex}}
 
 
 
difference{
box { <-1, -1, -1>, <1, 1, 1>  scale <1.5,.6,.6>}
box { <-1, -1, -1>, <1, 1, 1> scale <1.5,.6,.6> *.999 translate .1*y}

object {Boat scale <1,1,1000> translate -10*z translate -.65*x translate -.2*y}
object {Car pigment {color Green}scale <1,1,10000> translate -.590*z translate .65*x translate -.1*y}  
 

}

}  
//window trim 


#declare WTBoardH =  
union{
box { <-1, -1, -1>, <1, 1, 1>  scale <.72,.0625,.02>pigment {color White*.96}} 
box { <-1, -1, -1>, <1, 1, 1>  scale <.72,.055,.0205> pigment {color White} translate .00*y  } 
box { <-1, -1, -1>, <1, 1, 1>    scale <.72,.02,.0275> translate .0426*y pigment {color White*.96} }  
 
cylinder { <-.72, 0, 0>, <.72, 0, 0>, .02 scale <1,1.5,.5> translate -.012*z pigment {color White*1.03}}
     } 

#declare WTBoardV =
 union{
 box { <-1, -1, -1>, <1, 1, 1>  scale <.0625,1.06,.02> pigment {color White*.5} }
 box { <-1, -1, -1>, <1, 1, 1>  scale <.055,1.06,.0205>  } 
 box { <-1, -1, -1>, <1, 1, 1>    scale <.02,1.06,.0275> translate -.0426*x pigment {color White*.96} }  
 
 cylinder { <0, -1.06, 0>, <0, 1.06, 0>, .02 scale <1.5,1,.5> translate -.012*z pigment {color White*1.03}}
     }
 #declare Windowtrim =
union{ 
 
difference{
object {WTBoardH }
box { <-1, -1, -1>, <1, 1, 1>  rotate 5*z translate -1.71*x}

box { <-1, -1, -1>, <1, 1, 1>  rotate -5*z translate 1.71*x}
translate 1.99*z  translate -.4*y}

union{ 
box { <-1, -1, -1>, <1, 1, 1>  scale <.74,.01,.1>}
cylinder { <-.74, 0, 0>, <.74, 0, 0>, .01  translate -.1*z pigment {color White} }
 translate 1.97*z pigment {color White} translate -.34*y translate .08*z} 
        
difference{  
union{
object {WTBoardH }

box { <-1, -1, -1>, <1, 1, 1> scale <.72,.01,.1> pigment {color White}translate -.053*y translate .080*z }
}
box { <-1, -1, -1>, <1, 1, 1>  rotate 45*z translate -1.58*x translate -.5*y}
box { <-1, -1, -1>, <1, 1, 1> rotate -45*z translate 1.58*x translate -.5*y}

translate 1.99*z pigment {color Green} translate 1.61*y} 

difference{  
union{
object {WTBoardV  scale <1,1.1,1>}  
box { <-1, -1, -1>, <1, 1, 1> scale <.01,1.1*1.06,.1> translate -.053*x pigment {color White}  translate .080*z}  
  
translate .1*y  } 
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate -10.95*y}
box { <-1, -1, -1>, <1, 1, 1>  rotate 45*z translate 1.92*y translate -.5*x}
 translate 1.99*z pigment {color White} translate .66*x translate .6*y}

difference{
union{
object {WTBoardV  scale <1,1.1,1>} 
box { <-1, -1, -1>, <1, 1, 1> scale <.01,1.1*1.06,.1> translate .053*x pigment {color White}  translate .080*z}  
translate .1*y }  

box { <-1, -1, -1>, <1, 1, 1> scale 10 translate -10.95*y}

box { <-1, -1, -1>, <1, 1, 1>  rotate -45*z translate 1.92*y translate .5*x}

 translate 1.99*z pigment {color White} translate -.66*x translate .6*y}
 
 
 
 translate .3*y   }



  #declare WindowPt1 =
  union{
  box { <-1, -1, -1>, <1, 1, 1> scale <.04,.5,.02> }
  box { <-1, -1, -1>, <1, 1, 1>  scale .001}
   
  }      
  
  #declare WindowPt2 =
  union{
  box { <-1, -1, -1>, <1, 1, 1> scale <.6,.02,.02> }
  box { <-1, -1, -1>, <1, 1, 1> scale .001}
  cylinder { <0, 0, 0>, <3, 0, 0>, 1  scale .001}
   pigment {color White}
  }  
  
  
  #declare WindowPt3 =
  union{
  box { <-1, -1, -1>, <1, 1, 1> scale <.7,.04,.02> pigment {color White} }
  box { <-1, -1, -1>, <1, 1, 1>  scale .001}
   
  }   
  
  #declare Window = 
  
  union{
  
 object {Windowtrim}  
  
  
  object {WindowPt1 translate 2.15*z  translate .57*x pigment {color White} translate .35*y }
  object {WindowPt1 translate 2.15*z  translate -.57*x pigment {color White}translate .35*y}
   
   object {WindowPt1 translate 2.15*z  translate .57*x pigment {color White} translate 1.35*y }
   object {WindowPt1 translate 2.15*z  translate -.57*x pigment {color White}translate 1.35*y}
  
                                                     
  object {WindowPt3 translate 2.15*z translate 1.82*y translate .05*z} 
  
 object {WindowPt3 translate 2.15*z translate .9*y}
  
  object {WindowPt3 translate 2.15*z translate 0*y} 
  
  
  object {WindowPt2 translate 2.15*z translate .425*y } 
  
  object {WindowPt2 translate 2.2*z translate 1.39*y }
  
  
   
  box { <-1, -1, -1>, <1, 1, 1> scale <.7,.5,.001> texture{T_Glass3}    translate 2.15*z translate .425*y} 
 box { <-1, -1, -1>, <1, 1, 1> scale < .7,.5,.001> texture {T_Glass3}  translate 2.2*z translate 1.425*y}
  
  }
  
  object {Window }
  
//walls 

difference{
box { <-1, -1, -1>, <1, 1, 1>  scale <3.0,1.8,.02> translate  .775*y translate 0*x  translate 2*z texture{pigment {color rgb <.8,1,.8>} finish {crand .15}} } 
box { <-1, -1, -1>, <1, 1, 1>scale <.72,.95,20> translate .925*y }   //window opening
}
box { <-1, -1, -1>, <1, 1, 1>  scale <.02,1.8,2.975> translate .775*y  translate -.9475*z translate 3*x pigment {color rgb <.8,1,.8>}finish {crand .15} } 
box { <-1, -1, -1>, <1, 1, 1>  scale <.02,1.8,2.975> translate .775*y  translate -.9475*z translate -3*x pigment {color rgb <.8,1,.8>}finish {crand .15} } 


box { <-1, -1, -1>, <1, 1, 1>  scale <3.0,1.8,.02>  translate .775*y translate -3.95*z texture{pigment {color rgb <.8,1,.8>} finish {crand .15}} } 

 
object {Toybox scale .5 translate 1.5*x pigment {color SummerSky*1.2} 



translate -.65*y translate 1.2*z}   



#declare Curtainrod =  
difference{
union{  
difference{
cylinder { <0, -.02, 0>, <0, .02, 0>, .04  }

cylinder { <0, -.05, 0>, <0, .05, 0>, .02} 

box { <-1, -1, -1>, <1, 1, 1> translate -1*x } 
box { <-1, -1, -1>, <1, 1, 1> translate 1*z}

 translate .675*x translate .032*z }
 
difference{
cylinder { <0, -.02, 0>, <0, .02, 0>, .04  }

cylinder { <0, -.05, 0>, <0, .05, 0>, .02} 

box { <-1, -1, -1>, <1, 1, 1> translate -1*x } 
box { <-1, -1, -1>, <1, 1, 1> translate 1*z}

rotate -180*z  translate -.675*x translate .032*z }
  
box { <-1, -1, -1>, <1, 1, 1> scale <.675,.02,.01> }      
box { <-1, -1, -1>, <1, 1, 1> scale <.01,.02,.025> translate .055*z translate -.705*x }
box { <-1, -1, -1>, <1, 1, 1> scale <.01,.02,.025> translate .055*z translate .705*x}

} 
box { <-1, -1, -1>, <1, 1, 1> scale <.001,1,1> }  
}



#declare Curtain =   
union{ 
cylinder { <0, 0, 0>, <3.5, 0, 0>, .017 
 translate .985*y  }
//top   
union{
#declare TopFold1 =
difference{

cone { <0, 0, 0>,0, <0, .05, 0>, .1 } 
cone { <0, -.01, 0>,0, <0, .06, 0>, .1 translate .01*z } 
box { <-1, -1, -1>, <1, 1, 1>scale 10 translate 10*z} 
 translate .99*y

}
#declare TopFold2 =
difference{

cone { <0, 0, 0>,0, <0, .05, 0>, .1 } 
cone { <0, -.01, 0>,0, <0, .06, 0>, .1 translate -.01*z } 
box { <-1, -1, -1>, <1, 1, 1>scale 10 translate -10*z} 
 translate .99*y

}
#declare TopfoldPair =
union{

prism {                                
  linear_sweep  
  linear_spline 
  0,         
   -0.001,        
 4,           
  
  < -.15, 0>, < -.05,  .046>, < .05,  .046>,
   < .15,0>
  rotate -90*x 
  translate .995*y translate .15*x
  scale <1,1,5>
} 
object {TopFold1}
object {TopFold2 translate .15*x}
}
union{
object {TopfoldPair}
object {TopfoldPair translate .3*x}

   }
 union{
object {TopfoldPair}
object {TopfoldPair translate .3*x}

 translate .6*x  }
 union{
object {TopfoldPair}
object {TopfoldPair translate .3*x}

 translate 1.2*x  }
 union{
object {TopfoldPair}
object {TopfoldPair translate .3*x}

 translate 1.8*x  } 
 
  union{
object {TopfoldPair}
object {TopfoldPair translate .3*x}
translate 2.4*x  }
object {TopfoldPair translate 3.0*x}
object {TopFold2 translate 3.3*x}
scale <1.06,1,1> translate .00*x    }
//bottom folds 
 
difference{
cone { <0, 0, 0>, .3, <0, 1, 0>, 0   }
cone { <0, -.001, 0>, .3, <0, 1.002, 0>, 0 translate .002*z }  
 box { <-1, -1, -1>, <1, 1, 1> scale 10 translate 10*z  }
 
} 

prism {                                
  linear_sweep  
  linear_spline 
  0,         
   -0.001,        
 3,           
  
  < .3, 0>, < 0,  1>, < .8,1>
  rotate -90*x
} 


difference{
cone { <.8, 0, 0>, .5, <.8, 1, 0>, 0 }
cone { <.8, -.001, 0>, .5, <.8, 1.001, 0>, 0 translate -.002*z }  
 box { <-1, -1, -1>, <1, 1, 1> scale 10 translate -10*z  }

scale <1,1,.5>}

prism {                                
  linear_sweep  
  linear_spline 
  0,         
   -.001,        
 3,           
  
  < 1.3, 0>, < .8,  1>, < 2,1>
  rotate -90*x

 }

difference{
cone { <2, 0, 0>, .7, <2, 1, 0>, 0 }
cone { <2, -.001, 0>, .7, <2, 1.001, 0>, 0 translate .002*z }  
 box { <-1, -1, -1>, <1, 1, 1> scale 10 translate 10*z  }
scale <1,1,.5>} 

prism {                                
 linear_sweep  
 linear_spline 
 0,         
 -.001,        
3,           
  
  < 2.7, 0>, < 2,  1>, < 2.9,1>
  rotate -90*x

 }

difference{
cone { <2.9, 0, 0>, .2, <2.9, 1, 0>, 0 }
cone { <2.9, -.001, 0>, .2, <2.9, 1.001, 0>, 0 translate -.001*z }  
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate -10*z  }
scale <1,1,1>}
 
prism {                                
 linear_sweep  
 linear_spline 
 0,         
 -.001,        
3,           
  
  < 3.1, 0>, < 2.9,  1>, < 3.5,1>
  rotate -90*x

 }

difference{
cone { <3.5, 0, 0>, .4, <3.5, 1, 0>, 0 }
cone { <3.5, -.001, 0>, .4, <3.5, 1.001, 0>, 0 translate .001*z }  
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate 10*z  }
scale <1,1,1>}
 


scale  <1.5,1.5,1> translate -.15*y}  


#declare Star =

prism {                                
  linear_sweep  
  linear_spline 
  -1000,        
  1000,         
  10,           
  
  < 0, 1>,     
  <.15,.18>,  
  < .951,.309>,
  <.25,-.1>
  < .588,-.81>, 
  <0,-.25> 
  <-.588,-.81>, 
  <-.25,-.1>
  < -.95,  .309>, 
  <-.15,.18>
rotate -90*x 
}
#declare RocketTrail = 
union{
cylinder { <0, 0, -100>, <0, 0, .1>, .1 } 

prism {                                
  linear_sweep  
  linear_spline 
  -.1,        
  .1,         
  3,           
< -.1, 0>,     
<.1,.0>,  
< 0,-.5>
 rotate -90*x  
}
}
  
#declare Rocket =
union{

prism {                                
  linear_sweep  
  linear_spline 
  -20,        
  20,         
  7,           
  
< -.2, 0>,     
<.0,.1>,  
< .2,0>,
<.2,.1>
< .0,.3>, 
<-.2,.1> 
<-.2,0> 
scale 2
rotate -90*x  
translate -.75*y
}
difference{
cylinder { <0, 0, -1>, <0, 0, 1>, 1 scale <.2,1,1> } 
box { <-1, -1, -1>, <1, 1, 1>  scale 10 translate -10.7*y} 
  }
cone { <0, 1, 0>, 0.0, <0, -1, 0>, 1.0 scale .0001 } 
}
  
 #declare Moon =  
 difference{
 cylinder { <0, 0, -100>, <0, 0, 100>, 1 }  
 cylinder { <0, 0, -101>, <0, 0, 101>, 1 translate .5*x }
 }
 
#declare Curtaincutter1 =
union{
object {Star pigment {color Yellow} scale .025 translate 1.8*y translate .15*x} 
 object {Star pigment {color Yellow} scale .05 translate 1.6*y translate .1*x}  
object {Star pigment {color Yellow} scale .075 translate 1.4*y translate .3*x}


object {Star pigment {color Yellow} scale .1 translate 1.2*y translate .1*x} 
object {Moon pigment {color Yellow} scale .1 translate .8*y translate .1*x}
object {Rocket  pigment {color Red} scale <.2,.2,100> translate .45*y rotate 15*z translate .2*x}  
object {RocketTrail  pigment {color Red} scale <.25,.45,100> translate .215*y rotate 15*z translate .2*x}  
translate .1*x

 }    
 
#declare Curtainmaker1 = 
difference{
box { <-1, -1, -1>, <1, 1, 1>  scale 50}
union{   
object {Star pigment {color Yellow} scale .025 translate 1.8*y translate .15*x} 
 object {Star pigment {color Yellow} scale .05 translate 1.6*y translate .1*x}  
object {Star pigment {color Yellow} scale .075 translate 1.4*y translate .3*x}


object {Star pigment {color Yellow} scale .1 translate 1.2*y translate .1*x} 
object {Moon pigment {color Yellow} scale .1 translate .8*y translate .1*x}
  
object {Rocket  pigment {color Red} scale <.2,.2,100> translate .45*y rotate 15*z translate .2*x}  
object {RocketTrail  pigment {color Red} scale <.25,.45,100> translate .215*y rotate 15*z translate .2*x}  
  
   }    
translate .1*x  } 
  
#declare Curtain1 =  
union{  
difference{
object {Curtain texture {pigment {rgbt <1,1,0,0>} finish {crand .2}} translate 20*z scale <.1,1.5,.05> } 
object {Curtainmaker1}  
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate -9.35*y }
}     
  
  
  
  
difference{
object {Curtain texture 
{pigment{rgbt <.9,.91,.98,0>*1}
 
finish {crand .2}} translate 20*z scale <.1,1.5,.05> } 
object {Curtainmaker1 }  
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate 10.65*y}
box { <-1, -1, -1>, <1, 1, 1> scale 10  rotate 20*z translate -10.45*y}
}  

difference{
object {Curtain 
texture{
pigment{  
bozo
color_map {
  
  [ 0.1  color rgb <1,0,0>   ]
  [ 0.3  color rgb <1,.2,0>  ]
  [ 0.5  color rgb <1,.5,0>  ]
  [ 0.7  color rgb <1,.75,0> ]
  [ 1.0  color rgb <1,1,0>   ]
  
} scale <.02,.05,.01> rotate 20*z}


finish {crand .2}} translate 20*z scale <.1,1.5,.05> } 
object {Curtainmaker1 }  

box { <-1, -1, -1>, <1, 1, 1> scale 10  rotate 20*z translate 10.85*y}
}  

difference{
object {Curtain texture {pigment {rgbt <0,0,1,0>} finish {crand .1}} translate 20*z scale <.1,1.5,.05> }

object {Curtaincutter1}  
}
translate -.64*x translate -.08*y   translate .45*z} 
 
#declare Curtaincutter2 =
union{
object {Star pigment {color Yellow} scale <.025,.025,10> translate 1.8*y translate .05*x} 
 object {Star pigment {color Yellow} scale <.05,.05,10> translate 1.6*y translate .2*x}  
object {Star pigment {color Yellow} scale <.075,.075,10> translate 1.4*y translate 0*x}
object {Star pigment {color Yellow} scale <.1,.1,10> translate 1.2*y translate .2*x}
 
object {Moon rotate 180*y pigment {color Yellow} scale <.1,.1,10> translate .8*y translate .1*x}
object {Rocket  pigment {color Red} scale <.2,.2,100> translate .45*y rotate -15*z translate .05*x}  
object {RocketTrail  pigment {color Red} scale <.25,.45,100> translate .215*y rotate -15*z translate .05*x}  
 translate .2*x  }    
  
#declare Curtainmaker2 = 

difference{
box { <-1, -1, -1>, <1, 1, 1>  scale 50}
union{ 
object {Star pigment {color Yellow} scale  <.025,.025,10> translate 1.8*y translate .05*x} 
 object {Star pigment {color Yellow} scale <.05,.05,10> translate 1.6*y translate .2*x}  
object {Star pigment {color Yellow} scale <.075,.075,10> translate 1.4*y translate 0*x}
object {Star pigment {color Yellow} scale <.1,.1,10> translate 1.2*y translate .2*x}
 
object {Moon rotate 180*y pigment {color Yellow} scale <.1,.1,10> translate .8*y translate .1*x}
 object {Rocket  pigment {color Red} scale <.2,.2,100> translate .45*y rotate -15*z translate .05*x} 
 object {RocketTrail  pigment {color Red} scale <.25,.45,100> translate .215*y rotate -15*z translate .05*x}  
  
   }    
translate .2*x  }

#declare Curtain2 =  
union{  
difference{
object {Curtain texture {pigment {rgbt <1,1,0,0>} finish {crand .2}} translate 20*z scale <.1,1.5,.05> } 
object {Curtainmaker2  scale <1,1,10>} 
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate -9.35*y }
}    
difference{
object {Curtain texture {pigment{rgbt <.9,.91,.98,0>*1} 
finish {crand .2}} translate 20*z scale <.1,1.5,.05> } 
object {Curtainmaker2  scale <1,1,10>}  
box { <-1, -1, -1>, <1, 1, 1> scale 10 translate 10.65*y}
box { <-1, -1, -1>, <1, 1, 1> scale 10  rotate -20*z translate -10.6*y translate 1*x}
}  

difference{
object {Curtain 
texture{
pigment{  
bozo
color_map {
  
  [ 0.1  color rgb <1,0,0>   ]
  [ 0.3  color rgb <1,.2,0>  ]
  [ 0.5  color rgb <1,.5,0>  ]
  [ 0.7  color rgb <1,.75,0> ]
  [ 1.0  color rgb <1,1,0>   ]
  
} scale <.02,.05,.01> rotate -20*z}


finish {crand .2}} translate 20*z scale <.1,1.5,.05> } 
object {Curtainmaker2 scale <1,1,10>}  

box { <-1, -1, -1>, <1, 1, 1> scale 10  rotate -20*z translate 11.05*y}
}  
  
 
difference{
object {Curtain texture {pigment {rgbt <0,0,1,0>} finish {crand .1}} translate 20*z scale <.1,1.5,.05> }

object {Curtaincutter2 scale <1,1,10> }  
}

translate .07*x translate -.08*y  translate .45*z } 
 
#declare Ball =
union{
difference {  
sphere { <0, 0, 0>, 1  scale 1 pigment {color Blue}} 
object {Star scale .5 rotate -90*x }
object {Star scale .2 rotate -25*x rotate -15*y}
object {Star scale .2 rotate -25*x rotate -45*y}
object {Star scale .2 rotate -25*x rotate -75*y}
object {Star scale .2 rotate -25*x rotate -105*y}
object {Star scale .2 rotate -25*x rotate 15*y}
object {Star scale .2 rotate -25*x rotate 45*y}
object {Star scale .2 rotate -25*x rotate 75*y}
object {Star scale .2 rotate -25*x rotate 105*y}
object {Star scale .2 rotate 25*x rotate -15*y}
object {Star scale .2 rotate 25*x rotate -45*y}
object {Star scale .2 rotate 25*x rotate -75*y}
object {Star scale .2 rotate 25*x rotate -105*y}
object {Star scale .2 rotate 25*x rotate 15*y}
object {Star scale .2 rotate 25*x rotate 45*y}
object {Star scale .2 rotate 25*x rotate 75*y}
object {Star scale .2 rotate 25*x rotate 105*y}

box { <-1, -1, -1>, <1, 1, 1>  scale <2,.02,2> translate .7*y}
box { <-1, -1, -1>, <1, 1, 1>  scale <2,.02,2> translate -.7*y}   

box { <-1, -1, -1>, <1, 1, 1>  scale <2,.02,2> translate .8*y}
box { <-1, -1, -1>, <1, 1, 1>  scale <2,.02,2> translate -.8*y}

box { <-1, -1, -1>, <1, 1, 1>  scale <2,.05,2> translate .1*y }
box { <-1, -1, -1>, <1, 1, 1>  scale <2,.05,2> translate  -.1*y }
} 
sphere { <0, 0, 0>, .999 pigment {color Yellow}    }
} 

 
object {Truck scale .045   rotate 200*y translate .9*z    translate .1*x translate .4*z texture {pigment {color rgb<.1,.1,.3>}finish{metallic specular .5 }} translate -.94*y translate .125*x translate -.25*z  }


 

object {Ball scale .15 rotate -30*x translate 1.3*x translate 1.1*z translate -.3*y} 
object {Curtainrod  translate 1*y  pigment {color White} translate .925*y translate 1.96*z } 

#declare Picture1 =
union{

box { <-1, -1, -1>, <1, 1, 1>scale <.02,.32,.02> translate -.4*x }  
box { <-1, -1, -1>, <1, 1, 1>scale <.02,.32,.02> translate  .4*x }  
box { <-1, -1, -1>, <1, 1, 1> scale <.4,.02,.02> translate  .3*y}  
box { <-1, -1, -1>, <1, 1, 1> scale <.4,.02,.02> translate  -.3*y}
box { <-1, -1, -1>, <1, 1, 1> scale <.4,.3,.01> 

  texture {
    pigment {
      image_map {
        png "cessnapic.png"
        interpolate 2 
        once   
        
      }
      
      translate -0.5*(x+y) 
      scale <.8,.6,1>             
    }
    finish { ambient 1 }
  }

 }  
pigment {color Black} }
#declare Picture2 =
union{

box { <-1, -1, -1>, <1, 1, 1>scale <.02,.32,.02> translate -.4*x }  
box { <-1, -1, -1>, <1, 1, 1>scale <.02,.32,.02> translate  .4*x }  
box { <-1, -1, -1>, <1, 1, 1> scale <.4,.02,.02> translate  .3*y}  
box { <-1, -1, -1>, <1, 1, 1> scale <.4,.02,.02> translate  -.3*y}
box { <-1, -1, -1>, <1, 1, 1> scale <.4,.3,.01> 

  texture {
    pigment {
      image_map { 
        png "habpic.png"
        
        interpolate 2 
        once   
        
      }
      
      translate -0.5*(x+y) 
      scale <.8,.6,1>             
    }
    finish { ambient 0.3 }
  }

 }  
pigment {color Black} }
object {Cessna scale .15  rotate -20*y  translate -1*x translate -1*z    translate -.88*y   }  
object{BlanketP scale .75 rotate -30*x translate 1.1*x translate -.4*y translate 1.25*z}  
object{BlanketB scale .75 rotate -30*x translate 1.8*x translate -.4*y translate 1.25*z}
object {Picture2 scale <1,1,1.5> pigment {color Black} translate 1.96*z translate 1.25*y translate 1.55*x}
object {Picture1 scale <1,1,1.5> pigment {color Black} translate 1.96*z translate 1.25*y translate -1.55*x}
object {Tower rotate 90*y translate 2*x translate -.9425*y}  
object {Bridge translate -1.675*x translate -.9425*y}
object {Curtain1 rotate 1*x translate .05*y translate .45*z}
object {Curtain2 rotate 1*x  translate .05*y translate .45*z}
object {Engine scale .1 translate -.84*y translate -1.74*z translate -.7*x} 
object {Coalcar scale <.2,.2,.125>  translate -.84*y translate -.35*x translate -1.735*z pigment {color Blue}}
object {Passengercar scale .1 translate -.875*y translate -1.735*z translate -.03*x}
object {Flatcar  scale .1 translate -.885*y translate -1.73*z translate .315*x pigment {color Green}} 
object {Tankcar scale .275 translate -.88*y translate .7*x translate -1.735*z pigment {color Silver}}
object {Caboose  scale .1 translate -.86*y translate -1.735*z translate 1.05*x pigment {color Red}} 
object {ClownSketch rotate 80*y  scale .5 translate .4*x translate -.95*y translate -2.2*z}
object {Tracks  scale <.75,.7,.75> rotate -180*y translate -.945*y translate 1*x translate -1.75*z}
object {Firehat scale .15   rotate 30*y translate -.964*y translate 1.5*x translate .2*z}
 