// boats.inc

#declare hull_shape=
difference {
sphere {0,1}
box { < -1.1,-1.1,-1.1>,<-.8,1.1,1.1> rotate 15*z }
 box { <-1.1,0,-1.1>,<1.1,1.1,1.1> }
} 

#declare hull_cabin_shape=
difference {
sphere {0,1}
 box { <-1.1,-1.1,-1.1>,<1.1,0,1.1> }
 box { <-1.1,-1.5,-1.1>,<0.2,1.5,1.1> rotate -10*z }
 box { <0.25,0.05,-1.1>,<0.6,0.7,1.1> rotate -10*z }
}

#declare cabin_shell=
difference {
object { hull_cabin_shape scale 1.00 }
object { hull_cabin_shape scale 0.95 }
}

#declare boat_outer=
difference {
 object { hull_shape scale 1.0 }
 object { hull_shape scale 0.97 translate 0.001*y }
 }
 
#declare boat_inner=
difference {
 object { hull_shape scale 0.969 }
 object { hull_shape scale 0.950 translate 0.001*y }
 }
 
 #declare boat=
 union {
 cylinder { <0,-1,0>,<0,6,0>,0.07
 texture { pigment { color rgb <.8,.8,.8> }}
 finish { phong 0.7 ambient amb }
 }
 union {
 object { boat_outer
 texture { pigment { color rgb <.8,.8,.8> }}
 finish { ambient amb reflection 0.1 }
 }
 object { boat_inner 
 texture { pigment { color rgb <.4,.4,.0> }}
 finish { ambient amb reflection 0.1 } 
 }
 scale <4,1,1> 
 }
 box { <-0.3,-0.2,-0.95>,<0.3,-0.1,0.95> // bench
 texture { pigment { color rgb <.0,.4,.0> }}
 finish { ambient amb reflection 0.1 } 
 }
 translate .8*y 
 } 
 
 #declare boat_with_cabin=
 union {
  object { boat }
  object { cabin_shell scale <4,1,1> translate 0.8*y
  texture { pigment { color rgb <.8,.8,.8> }}
  finish { ambient amb reflection 0.2 }
  }
 }

 object { boat
 scale 1.5 
 rotate <0,-20,0>
 translate <-11,0,150>
 }

// object { boat
// scale 1.7 
// rotate <0,40,0>
// translate <-7,0,125>
// }
 
// object { boat
// scale 2 
// rotate <0,-60,0>
// translate <-11,0,ds+41>
// }
 
// object { boat  // _with_cabin
// rotate <0,-0,0>
// translate <0,0,ds>
// } 

