// clouds.inc 

// choose 4 layers or less
#declare cloud_layer1=1;
#declare cloud_layer2=1;
#declare cloud_layer3=1;
#declare cloud_layer4=1;
#declare cloud_layer5=1;

#declare cloud_dist=10000; 
#declare cloud_lower=0; // lowest /4
#declare cloud_scale=cloud_dist/10;

#declare ctran=0.0;
#declare pat=pigment {bumps}

union {
#if (cloud_layer1>0)
sphere { <0,cloud_lower,0>,cloud_dist-(5*layer_spread) // lowest layer
    hollow on
    no_shadow
    pigment {
      pat
      turbulence 0.3 
      octaves 2  
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 1,1,1,ctran>]
      [cloud_area color rgbt < 1,1,1,1>]
      }
      scale (cloud_scale*0.95)*<1.5,1,1>
    }
    finish { cloud_light }
}
#end


#if (rain_cloud>0)
#if (cloud_layer1>0)
sphere { <0,cloud_lower,0>,cloud_dist-(4.5*layer_spread) 
    hollow on
    no_shadow
    pigment {
      pat
      turbulence 0.3 
      octaves 4  
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 0,0,0,ctran>] 
      [cloud_area*0.8 color rgbt < 0,0,0,1>]
      }
      scale (cloud_scale*0.95)*<1.5,1,1>
    }
    rotate 0.5*x
    rotate -0.5*y
    //finish { cloud_light }
    finish { ambient 0 }
}
#end
// 
#if (cloud_layer1>0)
sphere { <0,cloud_lower,0>,cloud_dist-(3.5*layer_spread)
    hollow on
    no_shadow
    pigment {
      pat
      turbulence 0.3 
      octaves 5  
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 0,0,0,ctran>] 
      [cloud_area*0.8 color rgbt < 0,0,0,1>]
      }
      scale (cloud_scale*0.95)*<1.5,1,1>
    }
    //finish { cloud_light }
    finish { ambient 0.0 }
}
#end
#end // rain_cloud


#if (cloud_layer2>0)
sphere { <0,cloud_lower,0>,cloud_dist-(4*layer_spread)
   hollow on 
   no_shadow
    pigment {
      pat
      turbulence 0.3
      octaves 4
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 1,1,1,ctran>]
      [cloud_area color rgbt < 1,1,1,1>]
      }
      scale (cloud_scale*0.95)*<1.5,1,1>
    }
    finish { cloud_light }
}
#end



#if (cloud_layer3>0)
sphere { <0,cloud_lower,0>,cloud_dist-(3*layer_spread)
   hollow on 
   no_shadow
    pigment {
      pat
      turbulence 0.9 
      octaves 5
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 1,1,1,ctran>]
      [cloud_area color rgbt < 1,1,1,1>]
      }
      scale (cloud_scale*0.95)*<1.5,1,1>
    }
    finish { cloud_light }
}
#end
#if (cloud_layer4>0)
sphere { <0,cloud_lower,0>,cloud_dist-(2*layer_spread)
   hollow on 
   no_shadow
    pigment {
      pat
      turbulence 0.9 
      octaves 5
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 1,1,1,ctran>]
      [cloud_area color rgbt < 1,1,1,1>]
      }
      scale (cloud_scale*0.95)*<1.5,1,1>
    }
    finish { cloud_light }
}
#end
#if (cloud_layer5>0)
sphere { <0,cloud_lower,0>,cloud_dist-(1*layer_spread)
   hollow on 
   no_shadow
    pigment {
      pat
      turbulence 0.9 
      octaves 5
      omega 0.50
      lambda 4.0
      color_map {
      [0.0 color rgbt < 1,1,1,ctran>]
      [cloud_area color rgbt < 1,1,1,1>]
      }
      scale (cloud_scale*0.95)*<1.5,1,1>
    }
    finish { cloud_light }
}
#end  

rotate 20*y
scale <1.2,1,1>
} // union cloud