//#include "stdinc.inc"
// Example of tracing to place an object on the surface of another.

#declare floral_amb=amb; // 0.4
#declare petal_tex=
//texture { pigment { color rgbt <0.9,1.0,1.0> }}
//texture { pigment { color rgbt <1.0,0.9,1.0> }}
texture { pigment { color rgbt <1.0,1.0,0.9> }}

#declare leaf_form=
//merge {
difference {
 sphere { 0,1 }
 sphere { <0,0,0.1>,1 }
 //
 //sphere { 0,1 translate 1*y rotate  30*z translate -1*y }
 //sphere { 0,1 translate 1*y rotate -30*z translate -1*y }
 //
 //sphere { 0,1 }
 //sphere { <0,1,0>,0.3 }
 //sphere { <-0.866, 0.5,0>,0.3 }
 //sphere { < 0.866, 0.5,0>,0.3 }
 //sphere { <-0.866,-0.5,0>,0.3 }
 //sphere { < 0.866,-0.5,0>,0.3 }
}


#declare leaf=
object { leaf_form
translate 1.1*y
scale <0.4,1.0,0.05>
texture { pigment { color rgbt <0.4,0.8,0.2> }}
finish {ambient floral_amb }
}
#declare leaf_right=
object { leaf_form
 translate 1.1*x
 scale <1.0, 0.40, 0.05>
 rotate 10*y
 rotate 20*z
}
#declare leaf_left=
 object { leaf_form
 translate -1.1*x
 scale < 1.0, 0.40, 0.05>
 rotate -10*y
 rotate -20*z
}

#declare leaf_row_right=
union {
 object { leaf_right scale 1.4 translate <0.0,1,0> }
 object { leaf_right scale 1.3 translate <0.0,2,0> }
 object { leaf_right scale 1.2 translate <0.0,3,0> }
 object { leaf_right scale 1.1 translate <0.0,4,0> }
 object { leaf_right scale 1.0 rotate 20*z translate <0.0,5,0> }
}

#declare leaf_row_left=
union {
 object { leaf_left scale 1.4 translate <0.0,1,0> }
 object { leaf_left scale 1.3 translate <0.0,2,0> }
 object { leaf_left scale 1.2 translate <0.0,3,0> }
 object { leaf_left scale 1.1 translate <0.0,4,0> }
 object { leaf_left scale 1.0 rotate -20*z translate <0.0,5,0> }
}

// LEVEL 1

#declare frond=
union {
cone { <0.0,0.0,0.0>,0.2, < 0.0, 5.5, 0.0 >,0.1 scale <1,1,0.5>}
object { leaf translate <0,5.5,0> }
object { leaf_row_right translate -0.1*y }
object { leaf_row_left }
scale 0.15
texture { pigment { color rgbt <0.4,0.8,0.2> }}
finish {ambient floral_amb }
}

// LEVEL 2

#declare fronds=                       
union {
cone { <0.0,0.0,0.0>,0.1, < 0.0, 5.5, 0.0 >,0.03 scale <0.5,1,0.5>
texture { pigment { color rgbt < 0.8, 0.5, 0.3 > }}
finish {ambient floral_amb }
}
object { frond rotate -00*z scale 1.0 translate <0,5.5,0> }

union {
 // right side
 object { frond rotate -60*z scale 1.4 translate <0,1,0> }
 object { frond rotate -60*z scale 1.3 translate <0,2,0> }
 object { frond rotate -60*z scale 1.2 translate <0,3,0> }
 object { frond rotate -60*z scale 1.1 translate <0,4,0> }
 object { frond rotate -50*z scale 1.0 translate <0,5,0> }
 translate -0.05*y
}
union {       
 // left side
 object { frond rotate  60*z scale 1.4 translate <0,1,0> }
 object { frond rotate  60*z scale 1.3 translate <0,2,0> }
 object { frond rotate  60*z scale 1.2 translate <0,3,0> }
 object { frond rotate  60*z scale 1.1 translate <0,4,0> }
 object { frond rotate  50*z scale 1.0 translate <0,5,0> }
}
scale 0.3
}

/* ////////////////////////////////////////////////////////////

// LEVEL 3  

#declare twig=
union {
cone { <0.0,0.0,0.0>,0.10, < 0.0, 5.5, 0.0 >,0.03 scale <0.5,1,0.5>
texture { pigment { color rgbt < 0.8, 0.5, 0.3 > }}
finish {ambient floral_amb }
}
object { fronds rotate -00*z scale 1.0 translate <0,5.5,0> }
//
union {
 // right side
 object { fronds rotate -60*z scale 1.4 translate <0,1,0> } 
 object { fronds rotate -60*z scale 1.3 translate <0,2,0> }
 object { fronds rotate -60*z scale 1.2 translate <0,3,0> }
 object { fronds rotate -60*z scale 1.1 translate <0,4,0> }
 object { fronds rotate -50*z scale 1.0 translate <0,5,0> }
 translate -0.05*y
}  
union {
 // left side
 object { fronds rotate  60*z scale 1.4 translate <0,1,0> }
 object { fronds rotate  60*z scale 1.3 translate <0,2,0> }
 object { fronds rotate  60*z scale 1.2 translate <0,3,0> }
 object { fronds rotate  60*z scale 1.1 translate <0,4,0> }
 object { fronds rotate  50*z scale 1.0 translate <0,5,0> }
}
scale 0.3
}


// LEVEL 4  

#declare branch=  
union {
cone { <0.0,0.0,0.0>,0.10, < 0.0, 5.5, 0.0 >,0.03 scale <0.5,1,0.5>
texture { pigment { color rgbt < 0.8, 0.5, 0.3 > }}
finish {ambient floral_amb }
}
object { twig rotate -00*z scale 1.0 translate <0,5.5,0> }
// 
#declare y4=0;
union {
 // right side
 object { twig rotate y4*y rotate -60*z scale 1.4 translate <0,1,0> } 
 object { twig rotate y4*y rotate -60*z scale 1.3 translate <0,2,0> }
 object { twig rotate y4*y rotate -60*z scale 1.2 translate <0,3,0> }
 object { twig rotate y4*y rotate -60*z scale 1.1 translate <0,4,0> }
 object { twig rotate y4*y rotate -50*z scale 1.0 translate <0,5,0> }
 translate -0.05*y
}  
union {
 // left side
 object { twig rotate -y4*y rotate  60*z scale 1.4 translate <0,1,0> }
 object { twig rotate -y4*y rotate  60*z scale 1.3 translate <0,2,0> }
 object { twig rotate -y4*y rotate  60*z scale 1.2 translate <0,3,0> }
 object { twig rotate -y4*y rotate  60*z scale 1.1 translate <0,4,0> }
 object { twig rotate -y4*y rotate  50*z scale 1.0 translate <0,5,0> }
}
scale 0.3
}


// LEVEL 5

#declare trunk=  
union {
cone { <0.0,0.0,0.0>,0.10, < 0.0, 5.5, 0.0 >,0.03 scale <0.5,1,0.5>
texture { pigment { color rgbt < 0.8, 0.5, 0.3 > }}
finish {ambient floral_amb }
}
object { branch rotate 00*y rotate -00*z scale 1.0 translate <0,5.5,0> }
#declare y5=00;

 // tiers
 #declare ij=0;
 #while (ij<360)
  object { branch rotate y5*y rotate -60*z rotate ij*y scale 1.4 translate <0,1,0> }
  object { branch rotate y5*y rotate -60*z rotate ij*y scale 1.3 translate <0,2,0> }
  object { branch rotate y5*y rotate -60*z rotate ij*y scale 1.2 translate <0,3,0> }
  object { branch rotate y5*y rotate -60*z rotate ij*y scale 1.1 translate <0,4,0> }
  object { branch rotate y5*y rotate -60*z rotate ij*y scale 1.0 translate <0,5,0> }
  #declare ij=ij+180;
 #end 
 
//union {
// right side
 //object { branch rotate 60*y rotate -60*z rotate 000*y scale 1.4 translate <0,1,0> } 
 //object { branch rotate 60*y rotate -60*z rotate 000*y scale 1.3 translate <0,2,0> }
 //object { branch rotate 60*y rotate -60*z rotate 000*y scale 1.2 translate <0,3,0> }
 //object { branch rotate 60*y rotate -60*z rotate 000*y scale 1.1 translate <0,4,0> }
 //object { branch rotate 60*y rotate -50*z rotate 000*y scale 1.0 translate <0,5,0> }
 //translate -0.05*y
//}  
//union {
 // left side
 //object { branch rotate -60*y rotate  60*z scale 1.4 translate <0,1,0> }
 //object { branch rotate -60*y rotate  60*z scale 1.3 translate <0,2,0> }
 //object { branch rotate -60*y rotate  60*z scale 1.2 translate <0,3,0> }
 //object { branch rotate -60*y rotate  60*z scale 1.1 translate <0,4,0> }
 //object { branch rotate -60*y rotate  50*z scale 1.0 translate <0,5,0> }
//}
scale 0.3
} // union
*/ ////////////////////////////////////////////////////////////////////////////


//#macro herb()
// object { trunk no_shadow
// //translate <0,ht-5,ds>
// }           
//#end

#declare rr=seed(100);

//union {     
// #declare ii=5;
// #while (ii>0)
//  #declare ii=ii-1;
//  object { twig 
//  rotate rand(rr)*60-30*z translate 1*x 
//  rotate rand(rr)*360*y }
// #end
// translate <0,ht,ds>
//}



#declare sepal=
sphere { 0,1
scale <1,0.5,0.2>
translate 0.9*x
rotate 10*y
//finish { ambient floral_amb }
}


#declare sepals5=
union {
object {sepal rotate 000*z }
object {sepal rotate 072*z }
object {sepal rotate 144*z }
object {sepal rotate 216*z }
object {sepal rotate 288*z }
translate 0.15*z
rotate 36*z
scale 0.4
}


#declare petal=
sphere { 0,1
scale <1,0.5,0.2>
translate 0.9*x
rotate 10*y
texture { petal_tex }
finish { ambient floral_amb }
}

#declare petals5=
union {
object {petal rotate 000*z }
object {petal rotate 072*z }
object {petal rotate 144*z }
object {petal rotate 216*z }
object {petal rotate 288*z }
scale 0.5
}

#declare ovary=
sphere { 0,1
scale <0.5,0.5,1>
}

#declare ovaries5=
union {
object {ovary translate 0.3*x rotate 000*z }
object {ovary translate 0.3*x rotate 072*z }
object {ovary translate 0.3*x rotate 144*z }
object {ovary translate 0.3*x rotate 216*z }
object {ovary translate 0.3*x rotate 288*z }
sphere { 0,1 scale <0.2,0.2,4.0> }// pistil
sphere { 0,1 scale <0.3,0.2,0.2> translate <0.1,0,-4> rotate 000*z }
sphere { 0,1 scale <0.3,0.2,0.2> translate <0.1,0,-4> rotate 072*z }
sphere { 0,1 scale <0.3,0.2,0.2> translate <0.1,0,-4> rotate 144*z }
sphere { 0,1 scale <0.3,0.2,0.2> translate <0.1,0,-4> rotate 216*z }
sphere { 0,1 scale <0.3,0.2,0.2> translate <0.1,0,-4> rotate 288*z }
scale 0.20
}

#declare stamen=
union {
 cone { <0,0,0>,0.13,<0,0,-2>,0.06 }
 union {
  sphere { 0,1 scale <0.3,0.15,0.15> translate <0, 0.04,-2> }
  sphere { 0,1 scale <0.3,0.15,0.15> translate <0,-0.04,-2> }
  texture { pigment { color rgb < 1.0, 1.0, 0.2 > } }
  finish { ambient floral_amb }
 } 
 rotate -30*y
}

#declare stamens5=
union {
object { stamen translate 0.5*x rotate 000*z }
object { stamen translate 0.5*x rotate 072*z }
object { stamen translate 0.5*x rotate 144*z }
object { stamen translate 0.5*x rotate 216*z }
object { stamen translate 0.5*x rotate 288*z }
scale 0.25
}


#declare flower=
union {               
object { petals5 }
object { sepals5 }
object { ovaries5 rotate 36*z }               
object { stamens5 rotate 00*z }               
texture { pigment { color rgbt <0.4,0.8,0.2> }}
finish { ambient floral_amb }
}

//object { flower
//scale 4.5
//rotate 60*x
//translate <0,ht,ds>
//}





#declare CtrlPtrn = function {pattern { agate scale < 1, 1, 1>*0.7 }} // bozo


#declare MySurf= 
 //sphere { <0, 0, 0>, 1
 isosurface { 
 function { f_sphere(x, y, z, 1.2)-f_noise3d(x, y, z)*0.9 }
 max_gradient 2
 contained_by { sphere{0,2}} 
}

#declare MyShape =
object { 
 MySurf scale < 1.0, 0.7, 0.5 >
 pigment { rgb < 0.3, 0.3, 0.15 > }
 normal { granite 1 scale 0.1 }
 finish { ambient floral_amb } // 0.2
}

#declare petalet=
union {
 sphere { 0,1 scale <1.0,0.1,0.7> translate 1.4*x rotate 25*z }
 // vein
 cone { <0,0.1,0>,0.02,<1,0.1,0>,0.01 scale <1.5,1.0,1.0> translate 0.4*x rotate 25*z 
 pigment { rgb 1.0 } finish { ambient 0.15 } } // 0.5                                    
 // stamen
 cone { <0,0,0>,0.02,<1,0,0>,0.04 scale <1.0,1.0,1.0> translate 0.4*x rotate 65*z rotate 36*y 
 pigment { rgb 1.0 } finish { ambient 0.15 } } // 0.5
} // union

#macro floret(pp)
 //sphere {0,1}
 object { petalet rotate 000*y }
 object { petalet rotate 072*y }
 object { petalet rotate 144*y }
 object { petalet rotate 216*y }
 object { petalet rotate 288*y }
 #declare pp=0; // force color
 #if (pp=0)
  pigment { rgb 1 }
 #else
  pigment { rgb <1-pp,0.5,pp> }
 #end
 finish { ambient 0.15 }  // 0.5
#end // macro

#declare leaflet=
sphere { 0,1 scale <1.0,0.1,0.7> translate 1.4*x rotate 25*z }

#macro leaf_whorl(pp)
 object { leaflet rotate 000*y }
 object { leaflet rotate 072*y }
 object { leaflet rotate 144*y }
 object { leaflet rotate 216*y }
 object { leaflet rotate 288*y }
 pigment { rgb <0.4,1,0> } 
 finish { ambient 0.1 } // 0.3
#end // macro


#declare pp=0;

#macro plantlet()
union {
 cone { 0,0.010, Norm/4, 0.008 }
 // also Reorient_Trans (<>,<>)
 //sphere { Norm/4, 0.02 pigment {color rgbt <0.9,0.9,0,0.0>} finish {reflection 0.2}}
 //box { -0.02,0.02 Point_At_Trans ( Norm ) translate Norm/4 }
 union { floret(pp) scale 0.05 Point_At_Trans ( Norm ) translate Norm*0.25 }
 union { leaf_whorl(pp) scale 0.04 rotate 36*y Point_At_Trans ( Norm ) translate Norm*0.24 }
 //
 union { leaf_whorl(pp) scale 0.05 rotate 36*y Point_At_Trans ( Norm ) translate Norm*0.030 }
 union { leaf_whorl(pp) scale 0.06 rotate 00*y Point_At_Trans ( Norm ) translate Norm*0.015 }
 union { leaf_whorl(pp) scale 0.07 rotate 36*y Point_At_Trans ( Norm ) }
 texture { pigment {color rgb <0.9,0.6,0.0> } }
 // scale pp // z optional?
 translate Inter
 finish { ambient 0.15 } // 0.6
 //no_shadow
 } // union
#end


#macro herblet()
 object { fronds scale 0.5 rotate rand(rr)*360*y Point_At_Trans ( Norm )
 translate Inter
 }
#end

#declare plantleto=
union {
 cone { 0,0.010, 0.25*y, 0.008 }
 union { floret(pp) scale 0.05 translate 0.25*y }
 union { leaf_whorl(pp) scale 0.04 rotate 36*y translate 0.24*y }
 union { leaf_whorl(pp) scale 0.05 rotate 36*y translate 0.030*y }
 union { leaf_whorl(pp) scale 0.06 rotate 00*y translate 0.015*y }
 union { leaf_whorl(pp) scale 0.07 rotate 36*y }
 texture { pigment {color rgb <0.9,0.6,0.0> } }
 finish { ambient 0.15 } // 0.6
 scale 3
} // union


#declare herbleto=
 object { fronds scale 0.5 rotate rand(rr)*360*y
}

#macro put_plant_on_surface(Start, Aim, MyShape)
 #declare Norm = <0, 0, 0>; 
 #declare Inter= trace ( MyShape, Start, Aim-Start, Norm );
 #if (vlength(Norm)!=0)
  // trace was successful, Surface intersection located
  #declare pp=CtrlPtrn ( Inter.x, Inter.y, Inter.z );
  #if (pp>0.5)
   plantlet ()
  #else
   herblet()
  #end
 #end // if
#end // macro


#macro plants_on_surface (ii,tp,sc)
union {   
 object { MyShape  }
  #while (ii>0)
   #declare ii=ii-1;
   #declare xx=(rand(rr)-0.5)*2;
   #declare yy=(rand(rr)-0.5)*2;
   #declare zz=(rand(rr)-10.5)*2;
   put_plant_on_surface(< xx, yy, zz>*10, <xx,yy,10>,MyShape)
  #end
  scale sc translate tp 
} // union
#end

#declare rr=seed(1234);
//plants_on_surface(300,<0,ht,ds>,3)