
#if (scattered_rocks>0)

#declare cuboid_rock=
 isosurface {
 function {
   1
  -sqrt((x*x*x*x)+(y*y*y*y)+(z*z*z*z)) // rounded cube
   -f_wrinkles  (x,y/4,z)*0.8
   //-f_granite (x*400,0,z*400)*0.002 // more craggy
 }
 max_gradient 4 
 open
 contained_by  { box { -2,2 } }
 texture { 
  pigment { color rgb <0.52,0.55,0.55>*1.5 }
  normal { granite 0.5 scale 0.1 }
 }
}

#declare rr=seed(145);

#macro scattered_cuboid_rocks(qq,dp,pp)
#local ii=0;
 #while (ii<qq)
  #local ii=ii+1;
  object { cuboid_rock
   scale <rand(rr)*4,rand(rr)*1,rand(rr)*4>
   rotate (rand(rr)-0.5)*20*z
   rotate (rand(rr)-0.5)*90*y
   translate <(rand(rr)-0.5)*dp,(rand(rr)+0.5)-1,(rand(rr)-0.5)*dp>+pp
  }
 #end // while       
#end // macro

scattered_cuboid_rocks(20,40,<0.0,0.3,10>)
scattered_cuboid_rocks(40,80,<0.0,0.0,40>)
#end // if scattered_rocks



///////////////////////////////////////////////////////////////


#if (dunes=1)
 #declare dunes1=
 isosurface {
  function { 
   y
   // f_sphere(x,y,z,1)
   -(f_noise3d(x,y,z)*1.55) // 1.25
   //-(f_wrinkles(x,y,z)*1.25)// 1.25
   -(f_wrinkles(x*10,y*10,z*10)*0.035)
  }
  max_gradient 2
  open
  // max_gradient 1
  contained_by { sphere {0,20}}
  texture {
   pigment { colour rgb <0.60, 0.55, 0.50> }
    normal {
    average 
     //crackle 1 scale 1
     //waves 0.16
     //frequency 3000.0
     //scale 600.0   // 100
     //wrinkles 0.5 scale 1 
     //ripples 0.2 scale 1
     //normal_map {
     //[1  bumps 1.5 scale 0.02 ]
     //[1  bumps 0.5 scale 0.05 ]
     //[1  bumps 0.5 scale 0.10 ]
     //[1  bumps 0.5 scale 0.20 ]
     //[1  bumps 0.5 scale 0.40 ]
     //[2  bumps 1.5 scale 0.80 ]
     //} // normal_map
      normal_map {
      [2  bumps 0.8 scale 0.02 ]
      //[1  bumps 0.5 scale 0.05 ]
      //[1  bumps 0.5 scale 0.10 ]
      [2  bumps 0.5 scale 0.20 ]
      } // normal_map     
   } // normal
   scale <1/4,1/4,1/3>*0.2
  } // texture
  finish { ambient 0.1 }
  scale <16,4.5,6>
 }
 //object { dunes1 translate <2,-3.4,1> }
 object { dunes1 translate <40,-3.7,199> }
#end // dunes

/////////////////////////////////////////

#if (undulating_ground>0)
 #declare undulating_sand=
 isosurface {
  function { y 
  - (f_snoise3d(x/10, 0, z/2)*0.7) // was x/7 z/2 *0.5
  - (f_snoise3d(x, 0, z)*0.05)
  }  
  threshold 0
  max_gradient 1.1
  contained_by {box {<-100,-3,-100>, < 100, 1, 1000>}}
  /*	texture {
  pigment {color rgb < 1, 0.9, 0.65>}
  normal {granite bump_size 0.1 scale 0.01}
  }*/
  texture {
   pigment {color rgb < 1.0, 1.0, 0.8>}   // was 1 .9 .65
   normal { average // {granite 0.2 scale 0.7}  // was .2 .02
   normal_map {
   [1  bumps 1.0 scale 0.001 ]
   [1  bumps 1.0 scale 0.002 ]
   [1  bumps 1.0 scale 0.005 ]
   //[1  bumps 1.0 scale 0.01 ]
   //[1  bumps 0.2 scale 0.02 ]
   //[1  bumps 0.2 scale 0.05 ]
   //[1  bumps 0.1 scale 0.10 ]
   //[1  bumps 0.5 scale 0.20 ]
   //[1  bumps 0.5 scale 0.40 ]
   //[1  bumps 0.5 scale 0.80 ]
   } // normal
   } // normal
   finish {
    brilliance 1.8 // was 1.6
    specular 0.3
   } // finish
  } // texture
 } // isosurface


 #declare Ground=
 object { undulating_sand }
 
 object {Ground}
#end // undulating_ground


// setup for pebbles and cacti
#include "arrays.inc"
#declare RS = seed(464786);
                
                
#if (pebbles>0)
 #include "pebbles.inc"
#end

#if (cacti>0)
#include "cacti.inc"
#end



///////////////////////////////////////////////////////////////////////


#declare hill_texture=
texture { pigment { color rgb <0.4,0.55,0.55>*0.7 }} // blue grey hills gamma 1
//texture { pigment { color rgb <0.4,0.55,0.55>*1.3 }} // blue grey hills
//texture { pigment { color rgb <0.80,0.40,0.45>  }} // desert hills
//texture { pigment { color rgb <0.60,0.50,0.45>  }} // preseli hills

#declare vegetation =
texture {
pigment {
//agate
wrinkles
octaves 3
omega 0.7
lambda 10
turbulence .5
color_map {
[ 0.0 color rgb < 0.2, 0.2, 0.1> ]
[ 0.6 color rgb < 0.7, 0.9, 0.6> ]
[ 0.9 color rgb < 0.4, 0.9, 0.5> ]
} // end color map

}  // end pigment
scale < .003, 003, .003 >
finish { ambient 0.1 }
normal { bumps 1 scale 0.001 }
} // end texture
  
// land elements
  
#declare iso1= 
 // for hills
 isosurface {
 function {
 //y-f_noise3d(x,0,z) 
 y-(z/7)
 -f_wrinkles  (x,0,z) 
 -f_noise3d(x*10,0,z*10)*0.1
 // -f_wrinkles  (x*4,0,z*4)*0.1 
 //-f_granite (x*400,0,z*400)*0.002 // more craggy
 }
 max_gradient 8 
 // open
 contained_by  { box { <-5,-1,-2>, <5,2,2>  } }
}

#declare iso2=
 isosurface {
 function {
 //y-f_agate  (x,0,z)
 y-f_granite  (x,0,z)
 } 
 open
 contained_by  { box { <-5,-1,-2>, <5,1,2>  } }
}    

#declare iso3=
 isosurface {
 function {
 //y-f_agate  (x,y,z)
 y-(f_granite  (x*5,y,z*5) * f_noise3d(x,y,z) )
 //y-f_granite  (x*5,y,z*5) 
 } 
 open
 contained_by  { box { <-5,-1,-.4>, <5,1,.4>  } }
}
#declare iso4=
 isosurface {
 function {
 y-f_noise3d(x*60,0,z*60)*0.1
// -f_noise3d(5*x,0,5*z)*0.3
 -f_crackle(3*x,0,3*z)*0.3
 } 
 max_gradient 2
 open
 contained_by  { box { <-2,-1,-1>, <2,1,1>  } }
}
#if (forground_rocks>0)
 #if (far_vegetation>0)
  object { 
   iso1
   scale <2,1,2> 
   translate  <0,-0.3,0>
   texture {vegetation} 
  }
 #end
 object { 
  iso1
  scale <2.2,0.95,2.2> 
  translate  <0,-0.25,0>
  texture { pigment { color rgb <0.4,0.55,0.55> }}
 }
 object { 
  iso2
  scale <2.2,0.7,2.2> 
  translate  <0,-0.25,0>
  texture { pigment { color rgb <0.4,0.55,0.55> }}
 } 
#end

#if (middle_land>0)

object { 
 iso1  
 //no_shadow
 scale <200,30,100> 
 translate  <0,0,1500>
 texture { hill_texture }
 finish { ambient 0.04 } //
}
#end // middle ground

#if (far_vegetation>0)
 // fir tree like objects
 object { 
  iso3  
  no_shadow
  //scale <80,140,80>  
  //scale <80,60,80>
  scale <80,60,80>  
  // rotate 20*x
  translate  <0,-40,2500>
 texture {vegetation}
 }


 object { 
  iso4  
  //no_shadow
  rotate -0*x
  scale <160,160,80>  
  translate  <-100,-20,1300>
  texture { pigment { color rgb <0.2,0.55,0.2> }}
 } 
 
#end // far vegetation

////////////////////////////////////////////////////////////////

// dist trees by shore
#declare qq=250;
#declare rd=seed(30);
union {
#declare ii=0; #while (ii<qq)
 #declare xx=rand(rd)*1000-500;
 #declare yy=0;
 #declare zz=rand(rd)*400+1500;
 //sphere { 0,1
 isosurface {
  function { f_sphere(x, y, z, 0.8)-f_noise3d(x*2, y*2, z*2)*1.5 }
  contained_by { sphere {0,2} }
  open
  // allow holes with low gradient 
  // max_gradient 3.5
  scale <4,10,4>*(0.3*rand(rd)+0.7)*0.9  translate <xx,yy,zz>
  pigment { rgb <0.4,0.5,0.1>*(0.4*rand(rd)+0.6)*1.2 } 
  normal { agate 1 scale 3 }
 }
#declare ii=ii+1; #end
}
//////////////////////////////////////////////////////////////////////

// Towers
#declare wall_tex=
texture {
 pigment { 
 crackle
 octaves 0
 turbulence 0.4 // was 0.2
 color_map {
 [ 0.0 0.1  color rgb <.8,.9,.9> color rgb <.8,.8,.8>] // mortar
 [ 0.1 1.0 color rgb <.3,.5,.5>  color rgb <.5,.4,.5>*1.2 ] // stones
 } // pigment
 scale 0.5
 } // pigment
 normal { crackle 5 scale .01 }
} // texture

#declare stone_base=
union {
 // capping
 difference {
  cylinder { <0,16.8,0>,<0,17.0,0>,5.1 }
  cylinder { <0,0,0>,<0,17.1,0>,4.5 }
  texture { pigment { color rgb < 0.9, 0.9, 0.9> } }
  normal { crackle 2 scale .001 }
 }
 //base  
 difference {
  cone { <0,0,0 >,5.1,< 0,16.8,0>, 5}
  cone { <0,-1,0 >,4.6,< 0,17.0,0>, 4.5}
 } // diff
} // union

union {            
 object { stone_base translate <0,0,0> }
 box {<0,0,0>,<11,10,1> translate <4.5,0,0>}
 object { stone_base translate <20,0,0> }
 translate <0,0,1490>
 texture {wall_tex}
}

////////////////////////////////////////////////////////////////

#if (middle_hills>0)


#declare iso_hills= 
 isosurface {
 function {
 y-(z/7)
 -f_wrinkles  (x,0,z) 
 -f_noise3d(x*10,0,z*10)*0.1
 // -f_wrinkles  (x*4,0,z*4)*0.1 
 //-f_granite (x*400,0,z*400)*0.002 // more craggy
 }
 max_gradient 8 
 contained_by  { box { <-5,-1,-2>, <5,2,2>  } }
}


#declare hills=
union {
object { iso_hills 
 scale <22,10,22>*20 
 translate  <0,-100.,3000> 
 //texture { pigment { color rgb <0.4,0.55,0.55>*0.7 }} 
 pigment { bumps  octaves 2
   color_map { 
   [ 0.0 colour rgb <0.50,0.60,0.20>*.6 ]
   [ 0.5 colour rgb <0.50,0.60,0.20>*.4 ]
   [ 1.0 colour rgb <0.50,0.60,0.20>*.1 ]
  } // map
 scale 0.02 
 } // pigment
 finish { ambient 0.05 } //
}

object { iso_hills 
 scale <22-0.1,10.1,22-0.1>*20 
 translate  <0,-104,3000> 
 //texture { pigment { color rgb <0.4,0.55,0.55>*0.7 }} 
 pigment { bumps
   color_map { 
   [ 0.0 colour rgb <0.70,0.70,0.60>*.9 ]
   [ 0.7 colour rgb <0.70,0.70,0.60>*.5 ]
   [ 1.0 colour rgb <0.70,0.70,0.60>*.0 ]
  } // map
 scale 0.02 
 } // pigment
 finish { ambient 0.05 } //
}

}

object { hills }

///////////////////////////////////////////////////////////////////////

// land veg
#declare CtrlPtrn1 = function {pattern { bozo scale < 1, 1, 1>*0.7 }} //or bozo

#macro put_on_surface(Start, Aim, MyShape)
 #declare Norm = <0, 0, 0>; 
 #declare Inter= trace ( MyShape, Start, Aim-Start, Norm );
 #if (vlength(Norm)!=0)
  // trace was successful, Surface intersection located
  #declare pp=CtrlPtrn1 ( Inter.x, Inter.y, Inter.z );
  #if (pp>0.0)
   //sphere { 0,10 scale <0.5,1,0.5>*(0.3*rand(rd)+0.7)*0.9
   isosurface {
    function { f_sphere(x, y, z, 0.8)-f_noise3d(x*2, y*2, z*2)*1.5 }
    contained_by { sphere {0,2} }
    open
    scale <4,10,4>*(0.3*rand(rd)+0.7)*0.9  
    pigment { rgb <0.4,0.5,0.1>*(0.4*rand(rd)+0.6)*1.0 } 
    normal { agate 1 scale 3 }
    translate Inter 
    }
  #else
  #end // if
 #end // if
#end // macro

#local rd=seed(134);
#local mn=min_extent(hills);
#local mx=max_extent(hills);
#local sz=mx-mn;
//#local sz=<sz.x,sz.y,sz.z/10>;
#local ps=sz/2+mn;
#local qq=20000;
#local ii=0; #while (ii<qq)
 #local xx=rand(rd)*sz.x-sz.x/2+ps.x;
 // #local zz=rand(rd)*sz.z-sz.z/2+ps.z;
 #local zz=rand(rd)*sz.z/2+mn.z;
 put_on_surface (<xx,175,zz>,<xx,0,zz>,hills)
#local ii=ii+1; #end   

#end // if middle hills                         

////////////////////////////////////////////////////////////////

#declare cliff_rock=
isosurface {
function {
 f_rounded_box (x,y,z, .02, 2,1,1)
  -f_wrinkles  (x,y/4,z)*0.8
  //-f_granite (x*400,0,z*400)*0.002 // more craggy
 }
 max_gradient 1 
 open
 contained_by  { box { -2,2 } }
 texture { 
  pigment { color rgb <0.52,0.55,0.55>*0.9 }
  normal { granite 0.5 scale 0.1 }
 }
 translate <0,ht,0>  
}


////////////////////////////////////////////////////////////////