#if (garden_trees>0)

 #declare iso_tree_foliage=
 isosurface {
  function { 
   max( f_sphere ( x,y,z,1.0 )/3,
   -y+0.7 -f_noise3d(x*1,0,z*1)*2.0  )
   //
   -f_noise3d(x*2,y*1,z*2)*1.0 
   -f_noise3d(x*10,y*50,z*10)*0.5 
   -f_noise3d(x*80,y*300,z*80)*0.2 
  }
  threshold 0
  contained_by {sphere {0,5}}
  open
  max_gradient 3 
  //no_shadow
  pigment { rgb <0.6,0.65,0.3>*1.5 }
  finish { ambient 0.05 }
  translate <0,4.0,0>
 }

#declare garden_tree=
union {
 // object { iso_tree_foliage }
 #include "branches.inc"
 #declare lt=0.8;  // leaf size
 #declare fs=1.2;  // foliage size
 #declare tp=1.5;  // dominance of centre (0 for no centre branch)
 #declare sc=0.8;  // starting scale
 #declare tl=0.5;  // height growth factor
 #declare th=0.15; // branch thickness
 #declare dd=0.45; // recursive size reduction
 #declare re=4;    // number of recursions 1 2 3 4

 union {
  cone { <0,0,0>,0.25*sc,<0,tl*2,0>,0.2*sc }  // trunk
  branching( tp,  <0,tl*2,0>, sc, th, dd, tl, rr, re, fln) // fln=null foliage 
  texture {
   pigment { rgb 0.8 }
   normal { bumps 0.5 scale 0.01 }
   finish { ambient 0.05}          
  }
 }
} // union top and branches
        
 //object { garden_tree rotate  45*y scale 1.0 translate < -10,-0.1,35> }
 object { garden_tree rotate -45*y scale 1.0 translate <-7,-0.1,15> } 
 
#end // garden trees


#if (maketrees>0)

#include "maketree\txttree.inc"
#declare txtTree=texture{txtTree_5}
#declare txtLeaf=texture{txtLeaf_1}
#declare Leaf=object{#include "maketree\gtleaf7.inc"} // declares the Leaf object
#declare Tree1=object{#include "maketree\gttree7.inc"
 texture{txtTree} // remove if the tree was textured with dotexture=true
}                        
// remove the following for leafless tree or for test
#declare Foliage1=object{#include "maketree\gtfoliage7.inc"
        texture{txtLeaf_0} 
}
union{
     object{Tree1}
     object{Foliage1} 
     scale 1/5
     translate <-10,0,35>
}

#end // if maketrees


#if (heath>0)
 #declare heath=
 isosurface {
   #declare p0=0.0001; // suppress higher frequencies
   #declare p1=1.7 ; // lacunarity  1.7
   #declare p2=5; //6; // 8; // octaves
   #declare p3=0.0; // base altitude
   #declare p4=0.0;// heterogeneity 0 to 1 
   #declare p5=2; // noise type 0 to 3      
  function { y-                     
   f_hetero_mf (x,0,z,p0,p1,p2,p3,p4,p5)*0.2 // higher freq
   +f_hetero_mf (x,0,z,p0,p1,4,p3,p4,p5)*0.4 // lower freq
   -f_noise3d(x*100,y*400,z*100)*0.1 // 0.07 
  }
  threshold 0
  contained_by {sphere {0,10}}
  open
  max_gradient 3 
  //no_shadow
  pigment { image_map {jpeg "jpeg\gorse.jpg" } 
   rotate 90*x translate -0.5*x scale 15 }
  // pigment { rgb <0.6,0.65,0.3>*1.0 }
  finish { ambient 0.15 } // 0.35
 }
 object { heath scale <4,1.0,4> translate <  00,0.3,060> }
 //object { heath scale <4,4,4> translate <  00,00,200>  }
 //object { heath scale <4,8,4> translate <  00,00,300>  }
 //object { heath scale <4,8,4> translate <-100,00,600>  }
 //heath flowers 
 
 #macro flower_heads(qq,cc,aa,ca,sc)
  // quantity, area,scale
  #local ii=0; 
  #while (ii<qq)
   #local ii=ii+1;
   #local xx=(rand(rr)-0.5)*aa;
   #local yy=(rand(rr)+0.5)*0.5;
   #local zz=(rand(rr)-0.5)*aa;
   #local jj=0;
   #while (jj<cc)
    #local jj=jj+1;
    sphere { 0,1 scale <sc,sc/2,sc> 
     translate <rand(rr)*ca+xx,rand(rr)*sc*2+yy,rand(rr)*ca+zz> }
   #end //while < cc
  #end // while <qq
 #end // macro
 
#declare rr=seed(1);
#declare heath_flowers=
 union {
  union {
   flower_heads(2,30,80,0.2,0.025)  // 2 2000
   pigment { rgb <1,1,0> }
   finish { ambient 0.1 }
   translate <0,0.02,50>
  } 
 union {
  flower_heads(2000,30,80,0.2,0.017)
  pigment { rgb <1,0,1> }
  finish { ambient 0.1 }
  translate <0,0,50>
 }
} 
// object { heath_flowers }

#end // if heath

#if (plants_in_forground>0)

 //#include "mushrooms.inc"
 #include "flowers.inc"
 //#include "scaleable detail.inc"
 //scaleable_detail (mushroom,mushroom,spotty_toadstool_tex) 
 //scaleable_detail (plantleto,mushroom,spotty_toadstool_tex) 
 //plants_on_surface(300,<-2,0,9>,1)  // density <position> scale
 plants_on_surface(300,<-4,0.5,15>,1)  
 plants_on_surface(300,<-2,0.5,14>,1)  
 plants_on_surface(300,<0,0.5,17>,1)  
 plants_on_surface(300,<8,0.5,16>,0)  
 //plants_on_surface(300,< 0,0,3>,1) 
 
#end // if plants_in_forground


#if (grasses>0)
 #include "grasses.inc"
 // object { iso_grass_patch translate <0,0,4> }
  object { iso_grass_patch scale 0.85 translate <6, 0, 14> }
  //object { iso_grass_patch scale 0.85 translate <6, 0, 22> }
 //
 #include "objects\grass\exgrass1.pov"
 object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
  texture{txtGrass scale 40} scale 0.01 translate <0,0,10>
 }  
 object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
  texture{txtGrass scale 40} scale 0.01 translate <5,0,10>
 }  
 object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
  texture{txtGrass scale 40} scale 0.01 translate <2,0,6>
 }  

 //
 //object { scattered_clumps_of_grass translate < 00,00,6> }
 object { scattered_clumps_of_grass translate < 05,00,16> }
 object { scattered_clumps_of_grass translate < -05,00,8> }
 //object { scattered_clumps_of_grass translate < 0,00,40> }
 //object { forground_grass }
#end

#if (tomtrees=1)
 #include "tomtree/PALM straight.inc"
 #include "tomtree/TOMTREE.inc"
 object { TREE scale 10 translate <7.3,0,9> }
 object { TREE rotate 90*y scale 8 translate <17.5,0,120> }
 object { TREE rotate 45*y scale 10 translate <23.5,0,120> }
#end

#if (wide_trees=1)
 #include "wide trees.inc"
// row of trees 
#declare ij=0;
#while (ij<500)
 object { wide_tree
 scale 0.7+(rand(rr)*0.3) 
 rotate 300*rand(rr)*y 
 translate <-ij+(rand(rr)*1),0,600+(rand(rr)*4)> }
 #declare ij=ij+10;
#end
//  object { wide_tree rotate 30*y 

 object { wide_tree rotate 30*y translate <-17,0,50> }
 object { wide_tree translate <-19,0,40> }
 //object { litter translate <0,0,40> }
 object { wide_tree rotate 5*y translate <10,0,15> }
 //object { litter rotate 5*y translate <10,0,15> }
 //object { litter translate 10*z }
#end

#if (slender_trees>0)
 #include "slender trees.inc"
#end
 
