// Persistence of Vision Ray Tracer Scene Description File
// File: RouterMacros.pov
// Vers: 3.5
// Desc: Example of the use of four tabletop macros in SS_RouterBits.inc (version 1.0)
// Date: 05/26/2004
// Auth: Copyright  2004 by Sherry K. Shaw


//------------------------------------------------------------------------------
// Initialization
//------------------------------------------------------------------------------

global_settings {
  assumed_gamma 1.0
}

#include "SS_RouterBits.inc"


//------------------------------------------------------------------------------
// A shiny red texture
//------------------------------------------------------------------------------

#declare RED_PLASTIC_TEX =
texture {
  pigment {
    color rgb < 1, 0, 0 >
  }
  finish {
    ambient 0.3
    diffuse 0.6
    specular 1.0
    roughness 0.05
  }
}


//------------------------------------------------------------------------------
// Four table tops
//------------------------------------------------------------------------------

// A round table top, built using macEdgedCircle ( Rad, Thickness, NumCuts )
// (RB_EDGE_CUTTER_OBJ must be declared first.)

#declare RB_EDGE_CUTTER_OBJ =
object {
  RB_03_OBJ
  scale < 0.5, 0.5, 2 > // Z-scale increased for use with "Fast but rough" setting below.
  translate < 0, RB_SMIDGEN, 0 >
}

#declare ROUND_TABLE_OBJ =
object {
  //macEdgedCircle ( 8, 1.5, 360 )  // Smooth but slow.
  macEdgedCircle ( 8, 1.5, 36 )   // Fast but rough.
  texture {
    RED_PLASTIC_TEX
  }
}

// An octagonal table top, built using macEdgedPolygon ( OuterRad, Thickness, NumSides )
// (RB_EDGE_CUTTER_OBJ must be declared first.)

#declare RB_EDGE_CUTTER_OBJ =
object {
  RB_04_OBJ
  scale < 0.5, 0.5, 1.5 >
  translate < 0, RB_SMIDGEN, 0 >
}

#declare OCTAGONAL_TABLE_OBJ =
object {
  macEdgedPolygon ( 8, 1.5, 8 )
  texture {
    RED_PLASTIC_TEX
  }
}

// An oval table top, built using macCutTracedEdge ( TargetObj, MaxRad, NumCuts, DropAmt )
// (RB_EDGE_CUTTER_OBJ and the target object must be declared first.)

#declare RB_EDGE_CUTTER_OBJ =
object {
  RB_12_OBJ
  scale < 0.5, 0.5, 2 > // Z-scale increased for use with "Fast but rough" setting below.
  translate < 0, RB_SMIDGEN, 0 >
}

#declare TargetObj =
cylinder {
  < 0, -1.5, 0 >, < 0, 0, 0 >, 8
  scale < 1, 1, 0.75 >
}

#declare OVAL_TABLE_OBJ =
object {
  //macCutTracedEdge ( TargetObj, 9, 360, -0.5 ) // Smooth but slow
  macCutTracedEdge ( TargetObj, 9, 36, -0.5 )  // Fast but rough.
  texture {
    RED_PLASTIC_TEX
  }
}

// A kidney-shaped table top (circa 1955), built using macCutCSplineEdge ( TargetObj, NumCuts )
// (RB_EDGE_CUTTER_OBJ, an array of points defining the spline, and the target object must be
// declared first.)

#declare RB_EDGE_CUTTER_OBJ =
object {
  RB_05_OBJ
  //scale < 0.6, 1, 0.2 > // Use with "Smooth but very slow" setting below.
  scale < 0.6, 1, 0.9 > // Use with "Fast but rough" setting below.
  translate < 0, RB_SMIDGEN, 0 >
}

#declare RB_ECS_NUM_PTS = 11 ;
#declare RB_ECS_PT= array[ RB_ECS_NUM_PTS ] {
	<  8.0, -1.5 >,
	<  5.0,  3.5 >,
	<  0.0,  5.2 >,
	< -5.0,  3.4 >,
	< -8.0, -1.7 >,
	< -4.2, -5.2 >,
	<  1.0, -3.0 >,
	<  4.8, -4.0 >,
	<  8.0, -1.5 >,
	<  5.0,  3.5 >,
	<  0.0,  5.2 >
}

#declare TargetObj =
prism {
  cubic_spline
  -1.5, 0, RB_ECS_NUM_PTS
	RB_ECS_PT[ 0 ],
	RB_ECS_PT[ 1 ],
	RB_ECS_PT[ 2 ],
	RB_ECS_PT[ 3 ],
	RB_ECS_PT[ 4 ],
	RB_ECS_PT[ 5 ],
	RB_ECS_PT[ 6 ],
	RB_ECS_PT[ 7 ],
	RB_ECS_PT[ 8 ],
	RB_ECS_PT[ 9 ],
	RB_ECS_PT[ 10 ]
}

#declare KIDNEY_SHAPED_TABLE_OBJ =
object {
  //macCutCSplineEdge ( TargetObj, 360 ) // Smooth but very slow
  macCutCSplineEdge ( TargetObj, 88 )  // Fast but rough.  (Please note that "fast" is a relative term.)
  texture {
    RED_PLASTIC_TEX
  }
}


//------------------------------------------------------------------------------
// The scene
//------------------------------------------------------------------------------

camera {
  right x*image_width/image_height
  location < 0.0, 16.0, -28.0 >
  look_at  < 0.0, 16.0,   0.0 >
}

light_source {
  < -1500, 1000, -1500 >
  color rgb 1
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [ 0.5 color rgb < 0.3, 0.4, 1.0 > ]
      [ 1.0 color rgb < 0.0, 0.0, 0.4 > ]
    }
    scale 2
    translate -1
  }
  pigment {
    spotted
    turbulence 3.5
    color_map {
      [ 0.5 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
      [ 1.0 color rgbf < 1.0, 1.0, 1.0, 0.2 > ]
    }
    scale < 0.8, 0.1, 0.8 >
  }
}

object {
  ROUND_TABLE_OBJ
  rotate y*30
  rotate x*-30
  translate < -8, 25, 0 >
}

object {
  OCTAGONAL_TABLE_OBJ
  rotate y*30
  rotate x*-25
  translate < 8, 20, 0 >
}

object {
  OVAL_TABLE_OBJ
  rotate y*30
  rotate x*-20
  translate < -8, 15, 0 >
}

object {
  KIDNEY_SHAPED_TABLE_OBJ
  rotate y*30
  rotate x*-15
  translate < 8, 10, 0 >
}


