#declare Queue = union { // the cue
	cone {
		0, 10,
		-400*z, 12
		pigment { //a wood-like pigment
			gradient y
			rotate <2,2,4>
			turbulence 0.1
			color_map {
				[ 0 color rgb <0.3,0.2,0.0> ]
				[ 0.5 color rgb <0.8,0.5,0.3> ]
			}
			warp {
		    	black_hole <10,2,-100>, 30   
    			strength 0.3               
    			repeat <0, 0, 64>             
    			turbulence <7, 5, 4>       
  			}
		}
		finish {
			reflection { 0.0, <0.8,0.5,0.3> fresnel on }
		}
		normal {
			bumps 0.1
			scale 3
		}
		interior {
			ior 1.8
		}
	}
	cylinder { // the white and blue cylinder
		-20*z, z,10.5
		pigment {
			gradient z
			scale 27
			translate 1.1*z
			color_map {
				[ 0.9 color rgb 1 ]
				[ 0.95 color rgb <0.3,0.4,1> ]
			}
		}
		finish {
			specular 0.4
			roughness 0.1
		}
		normal {
			wrinkles 0.2
			scale <1,1,20>
		}
	}
	scale <0.5,0.5,1>
}

// some textures for the Earth-like planet
#declare Mer = texture { // sea
	pigment {
		color rgb <0.2,0,0.5>
	}
	finish {
		reflection { 0.2,0.4 }
	}
	normal {
		bumps 0.2
		scale 0.01
	}
}

#declare Ht_Fonds = texture { // the sea that is near the coast
	pigment {
		color rgb <0.2,0.4,0.5>
	}
	finish {
		reflection { 0.2,0.4 }
	}
	normal {
		bumps 0.2
		scale 0.01
	}
}

#declare Terre = texture { // continents' texture
	pigment {
		gradient y
		translate -y/2
		scale 4
		turbulence 0.4
		color_map {
			[ 0.08 color rgb 1 ]
			[ 0.1 color rgb <0.5,0.8,0.3>/2 ]
			[ 0.4 color rgb <0.5,0.5,0.2> ]
			[ 0.6 color rgb <0.5,0.5,0.2> ]
			[ 0.9 color rgb <0.5,0.8,0.3>/2 ]
			[ 1 color rgb 1 ]
		}
	}
}

#declare Planet2 = union { // Earth-like planet itself
	sphere { // ground
		0, 80   
		texture {
			wrinkles
			scale 40
			turbulence 0.1
			texture_map {
				[ 0.5 Mer ]
				[ 0.6 Ht_Fonds ]
				[ 0.61 Terre ]
			}
		}
	}
	sphere { // clouds
		0, 81
		texture {
			pigment {
				bozo
				scale <25,10,25>
				turbulence 1
				color_map {
					[ 0.4 color rgb 0.8 transmit 1 ]
					[ 0.7 color rgb 0.8 ]
				}
			}
		}
	}
}

#declare Planet1 = union { // the other planet
	sphere { // ground
		0, 80
		texture {
			pigment {
   			crackle      
   			scale 4
   			turbulence 0.5
   			solid
   			color_map {
	   			[ 0 color rgb <1.1,0.6,0.2>/1.5 ]
   				[ 1 color rgb -0.2 ]
   			}
			}
			finish {
				ambient rgb <0.1,1.1,0.6>
				specular 0.05
				roughness 0.5
			}
		}
	}
	sphere { // clouds
		0, 81
		texture {
			pigment {
				bumps
				scale <25,10,25>
				rotate <-20,50,0>
				turbulence 1
				color_map {
					[ 0.2 color rgb <0.8,0.6,0.3> transmit 1 ]
					[ 1 color rgb <0.8,0.7,0.3> ]
				}
			}
		}
	}
}

camera {
	location <0,30,-200>
	look_at 10*y
	translate -200*z
}

// the background nebula
#declare galaxy_bgstars = 2;
#declare galaxy_bgnebula = 3;
#declare galaxy_colour1 = <1.2,1.1,1.2> ;
#declare galaxy_colour2 = <0,0.5,1> ;
#declare galaxy_colour3 = <0.4,0.1,1>;
#declare galaxy_turb_origin = <4,1,0>;
#declare galaxy_nebula_ambient  = 0.5;
#include "Galaxy.bg"              

// some stars
#declare star_count = 5000;
#declare star_colour_turb = 0.5;
#declare star_scale = 0.6;
#declare star_distribution = 0.1;
#include "Galaxy.sf"

// the blackhole
#declare galaxy_object_name = "G1";
#declare galaxy_colour1 = <0,0,0>;
#declare galaxy_colour2 = <1.4,-0.5,-0.8>;
#declare galaxy_colour3 = -0.7;
#declare galaxy_object_flatten = 0.5;
#declare galaxy_cluster_objects = 0;
#declare galaxy_object_position = <-15,-20,0>;
#include "Galaxy.obj"

// some bigger stars
#declare galaxy_object_name = "";
#declare galaxy_colour1 = 1;
#declare galaxy_colour2 = 1;
#declare galaxy_colour3 = 1;
#declare galaxy_cluster_objects = 100;
#declare galaxy_cluster_scale = 0.1;
#declare galaxy_cluster_spread = 100;
#include "Galaxy.obj"

light_source {
	<500,500,-1000>
	color rgb 1
	area_light
	<-50,-50,0>,<50,50,0>
	4,4
	circular orient jitter
}

light_source {
	<-100,500,-600>
	color rgb 1
	area_light
	<-50,-50,0>,<50,50,0>
	4,4
	circular orient jitter
}

union {
	object {
		Queue 
		translate -120*z
		rotate <-15,-4,0>
		translate 5*y
	}
	
	object {
		Planet1
		scale 0.7
	}
	translate <100,-40,0>
}

object {
	Planet2
	translate <-50,90,500>
}
