// -D +H768 +W1024
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "glass.inc"

global_settings {
  assumed_gamma 1.8 
  radiosity {
    pretrace_start 0.08
    pretrace_end   0.04
    count 100          
    nearest_count 8    
    error_bound 2      
    recursion_limit 3  
    low_error_factor .5
    gray_threshold 0.0 
    minimum_reuse 0.015
    brightness 1       
    adc_bailout 0.01/2
    normal on          
    media on           
  }
  photons {
    count 25000
    autostop 0
    jitter .5
  }
}

camera {
  location <-2,-5,-15>
  look_at <0,-10,0>
  angle 37.5
}

light_source {
  0*x
  color rgb 0.75
  area_light <10,0,0> <0,0,10> 5, 5
  adaptive 0 jitter
  circular orient
  translate <100,100,-250>
}

light_source {
  0*x
  color rgb 0.75
  spotlight
  translate <0,46,-48>
  point_at <10,10,-25>
  radius 2
  tightness 80
  falloff 8
}

#declare leg   = box { -1,1 scale < 1,  30,   1> }
#declare top   = box { -1,1 scale <41,   1,  11> }
#declare shelf = box { -1,1 scale <40,0.25,  10> }
#declare sides = box { -1,1 scale < 1,  31,  11> }
#declare glass = box { -1,1 hollow scale <39,29, 0.25> }

#declare frame = union {
  object { leg   translate <-40,  0,-10> }
  object { leg   translate < 40,  0,-10> }
  object { leg   translate <-40,  0, 10> }
  object { leg   translate < 40,  0, 10> }
  object { top   translate <  0, 30,  0> }
  object { top   translate <  0,-30,  0> }
  object { shelf translate <  0, 10,  0> }
  object { shelf translate <  0,-10,  0> }
  object { sides translate <-40,  0,  0> }
  object { sides translate < 40,  0,  0> }
  object { sides translate < 40,  0,  0> }
  texture {
    T_Wood7
    rotate y*90
  }
  finish {
    reflection {0.03,0.07}
    diffuse 0.7
    ambient 0.3
  }
}

#declare panes = union {
  object { glass translate <  0,  0,-10.5> }
  object { glass translate <  0,  0, 10.5> }
  hollow
  material{
    texture{
      T_Glass2
      normal {
        bumps .1
        scale 4
      }
      finish{
        reflection { .01,0.99 fresnel }
        conserve_energy
      }
    }
    interior{
      I_Glass
    }
  }
}

#declare cabinet = union {
  object { frame photons { target refraction on reflection on } }
  object { panes }
}

#declare card = box {
  0, 1
  texture {
    pigment {
      image_map {
        jpeg "jPod 3x5 card.jpg" map_type 0 once interpolate 2
      }
    }
    finish {
      ambient 0.375
    }
  }
  scale <5,3,0.025>
  rotate x*20
  translate <-2.5,-1.5,-0.0125>
}

#declare stand = box {
  -1,1
  hollow
  material {
    M_Dark_Green_Glass
  }
  scale <3,0.1,0.5>
}

#declare notecard = union {
  object { card  translate <0,-8.00,0> }
  object { stand translate <0,-9.65,0> }
  translate <0,0,-1>
}

#declare label = height_field {
  sys "shelf label.bmp"
  texture {
    Tinny_Brass
    finish {
      ambient 0.3
    }
  }
  scale <3,0.05,2>*0.75
  translate <-1.5,-9.7575,-7>
}

#declare wall = box {
  -1,1
  texture {
    normal {
      granite scale <0.01,1,0.5>
    }
    pigment {
      color rgb <0.75,0.75,0.65>
    }
  }
  scale <100,100,1>
  translate z*14
}

#declare base = box {
  -1,1
}

#declare ro = 0.375;

#declare roundovery = cylinder {
  -y,y,ro
  scale <1,4.1-ro,1>
}

#declare roundoverx = cylinder {
  -x,x,ro
  scale <2.4-ro,1,1>
}

#declare roundoverz = cylinder {
  -z,z,ro
  scale <1,1,0.57-ro>
}

#declare roundoverc = sphere {
  0,ro
}

#declare unit = merge {
  object { base scale <2.4,4.1-ro,0.57-ro> }
  object { base scale <2.4-ro,4.1,0.57-ro> }
  object { base scale <2.4-ro,4.1-ro,0.57> }
  union {
    object { roundovery translate <-(2.4-ro),0,-(0.57-ro)> }
    object { roundovery translate <-(2.4-ro),0, (0.57-ro)> }
    object { roundovery translate < (2.4-ro),0,-(0.57-ro)> }
    object { roundovery translate < (2.4-ro),0, (0.57-ro)> }
  }
  union {
    object { roundoverx translate <0,-(4.1-ro),-(0.57-ro)> }
    object { roundoverx translate <0,-(4.1-ro), (0.57-ro)> }
    object { roundoverx translate <0, (4.1-ro),-(0.57-ro)> }
    object { roundoverx translate <0, (4.1-ro), (0.57-ro)> }
  }
  union {
    object { roundoverz translate <-(2.4-ro), (4.1-ro),0> }
    object { roundoverz translate <-(2.4-ro),-(4.1-ro),0> }
    object { roundoverz translate < (2.4-ro), (4.1-ro),0> }
    object { roundoverz translate < (2.4-ro),-(4.1-ro),0> }
  }
  union {
    object { roundoverc translate < (2.4-ro),-(4.1-ro),-(0.57-ro)> }
    object { roundoverc translate < (2.4-ro),-(4.1-ro), (0.57-ro)> }
    object { roundoverc translate < (2.4-ro), (4.1-ro),-(0.57-ro)> }
    object { roundoverc translate < (2.4-ro), (4.1-ro), (0.57-ro)> }
    object { roundoverc translate <-(2.4-ro),-(4.1-ro),-(0.57-ro)> }
    object { roundoverc translate <-(2.4-ro),-(4.1-ro), (0.57-ro)> }
    object { roundoverc translate <-(2.4-ro), (4.1-ro),-(0.57-ro)> }
    object { roundoverc translate <-(2.4-ro), (4.1-ro), (0.57-ro)> }
  }
  texture {
    normal {
      crackle 0.5 turbulence 1 scale <1,0.9,1>
      rotate z*15
    }
    pigment {
      bozo
      turbulence 0.5
      color_map {
        [0.0 rgb 0.00]
        [0.1 rgb 0.10]
        [0.3 rgb 0.60]
        [0.4 rgb 0.60]
        [0.7 rgb 0.80]
        [1.0 rgb 1.00]
      }
    }
    finish {
      ambient 0.5
      reflection 0.15
    }
  }
}

#declare dialhole = torus {
  1.1,0.55
  scale <1,0.5,1>
  rotate x*90
  texture {
    normal {
      crackle 0.5 turbulence 1 scale <1,0.9,1>
      rotate z*15
    }
    pigment {
      bozo
      turbulence 0.5
      color_map {
        [0.0 rgb 0.00*0.4]
        [0.1 rgb 0.10*0.4]
        [0.3 rgb 0.60*0.4]
        [0.4 rgb 0.60*0.4]
        [0.7 rgb 0.80*0.4]
        [1.0 rgb 1.00*0.4]
      }
    }
    finish {
      ambient 0.5
      reflection 0.15
    }
  }
  translate <0,-1.5,-0.57>
}

#declare dial = torus {
  1.1,0.55
  scale <1,0.05,1>
  rotate x*90
  texture {
    normal {
      crackle 0.1 turbulence 0.2 scale <1,0.9,1>
      rotate z*15
    }
    pigment {
      bozo
      turbulence 0.5
      color_map {
        [0.0 rgb 0.00*1.5]
        [0.1 rgb 0.10*1.5]
        [0.3 rgb 0.60*1.5]
        [0.4 rgb 0.60*1.5]
        [0.7 rgb 0.80*1.5]
        [1.0 rgb 1.00*1.5]
      }
    }
    finish {
      ambient 0.5
      reflection 0.15
    }
  }
  translate <0,-1.5,-0.57>
}

#declare screen = superellipsoid {
  <0.2,1>
  texture {
    normal {
      bumps 0.1 scale <1,0.1,0.1>
      rotate z*30
    }
    pigment {
      image_map {
        jpeg "jPod screen.jpg" map_type 0 interpolate 2 once
      }
    }
    scale <2,2,2>
    translate <-1,-1,0>
    finish {
      ambient 0
      diffuse 0.75
      reflection {0.03,0.5}
    }
  }
  scale <1.55,1.3,0.1>
  translate <0,2.125,-0.57>
}

#declare jpod = union {
  object { dial rotate y*4 translate z*0.1 }
  difference {
    object { unit }
    union {
      object { dialhole scale <1,1,1> }
      object { screen }
    }
  }
}

#declare scene = union {
  object { notecard translate z*3 }
  object { label }
  object { wall }
  object { cabinet }
  object { jpod scale 0.45 rotate x*90 rotate -y*40 translate <0,-9.5,-3> }
}

object { scene }