// Mega Persistence of Vision Ray Tracer Scene Description File
// File: pbit.pov
// Version: MegaPOV 1.1
// Description: My entry for Nov-Dec IRTC (Topic: Museum)
// Date: 11/16/04
// Author: Paolo Brasolin
// Title: It

//To be rendered at 1024x1024, AA 0.3

//--------------------------------------------------------------------------------------------------Version

#version unofficial MegaPOV 1.1;

//--------------------------------------------------------------------------------------------------Seed

#declare MyStream=seed(26011988);

//--------------------------------------------------------------------------------------------------Includes

#include "pprocess.inc"
#include "rand.inc"
#include "woods.inc"
#include "pbit.inc"

//--------------------------------------------------------------------------------------------------Global Settings

global_settings {
  max_trace_level 16
  motion_blur 20,0.2
  exposure 1
  exposure_gain 1.7
}

//--------------------------------------------------------------------------------------------------Camera

camera {
  fisheye
  angle 128
  location <-5,3.5,-5>
  look_at <0,3.5,2>
  right x
}

//--------------------------------------------------------------------------------------------------Background

background {color rgb 0.05}

//--------------------------------------------------------------------------------------------------Switches

#declare All=0;
#declare DummyOne_Switch=1+All;
#declare DummyTwo_Switch=1+All;
#declare DummyThree_Switch=1+All;
#declare Oven_Switch=1+All;
#declare Shelf_Switch=1+All;
#declare Roof_Lamp_Switch=1+All;
#declare Walls_Switch=1+All;
#declare Text_Switch=1+All;
#declare Drapeau_Switch=1+All;
#declare Lava_Lamp_Switch=1+All;
#declare It_Switch=1+All;
#declare Pendule_switch=1+All;

//--------------------------------------------------------------------------------------------------Dummy 1

#if (DummyOne_Switch=1)

#declare DummyOne = union {
 blob {
   threshold 1
   
   sphere {<0,1.2,0>,0.8,2}
   sphere {<0,0,0>,1,1}
   sphere {<0,-1,0>,2,1}
   sphere {<1,-3,0>,1,1}
   sphere {<-1,-3,0>,1,1}
   
   sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-20 rotate y*60}
   sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}
   sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}
   sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-160 rotate y*-60}
     
   pigment {color rgbf 1 quick_color rgb 1}
     
   hollow
 
   interior {
     media {
       method 1
       samples 1,100
       absorption 8
       scattering { 
         6,
         rgb 1
         diffuse 6 
         reflection 0.5
         reflection_exponent 1
         ratio 1
         frequency 50 
         waves 20,0
         falloff 0.8
         structure { sphere { 0, 4 } }
         pigment { color rgb <0.5,1,0.5> }
         force -10*y
       }
     }
   }
 }
 
 blob {
   threshold 1.2
   
   sphere {<0,1.2,0>,0.8,2}
   sphere {<0,0,0>,1,1}
   sphere {<0,-1,0>,2,1}
   sphere {<1,-3,0>,1,1}
   sphere {<-1,-3,0>,1,1}
   
   sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-20 rotate y*60}              
   sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}           
   sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}          
   sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-160 rotate y*-60}            
   
   pigment {color rgb <0.8,0.6,0.4>}
 }
 
 union {
   union {
     sphere {<0.2,1.2,-0.15>,0.25}
     sphere {<-0.2,1.2,-0.15>,0.25}
     pigment {color rgb 1}
   }
   union {
     sphere {<0.3,1.2,-0.25>,0.15}
     sphere {<-0.3,1.2,-0.25>,0.15}
     pigment {color green 0.7}
   }
   union {
     sphere {<0.35,1.2,-0.3>,0.1}
     sphere {<-0.35,1.2,-0.3>,0.1}
     pigment {color rgb 0}
   }
   finish { specular 1 roughness 0.1 irid { 1 thickness 0.2 turbulence 2 } }
 }
 
  union {
 
    union {
      superellipsoid { <0.3, 0.3> scale 0.85 pigment {noise_pigment { 1, 0, 1 }} finish {ambient 2} }
      difference {
        superellipsoid { <0.3, 0.3> }
        box {<-2,-2,0.6>,<2,2,2>}
        pigment{color blue 0.3}
        finish {
          phong 1
          phong_size 16
        }
      }
      union {
        cylinder{<0,1,0>,<1,2,0>,0.02}
        cylinder{<0,1,0>,<-2,2,0>,0.02}
        sphere {<-2,2,0>,0.04}
        sphere {<1,2,0>,0.04}
        pigment {color rgb 0.6}
        finish {
          ambient 0.2
          brilliance 4
          diffuse 0.3
          metallic
          specular 1
          roughness 0.01
          reflection 0.4
        }
      }
      scale y*0.8
    }
    
    union {
      superellipsoid { <1, 0.1> rotate x*90 scale <1.3,0.1,1.3>}
      sor {
        7,<1.0,0.0><0.5,0.0><0.2,0.5><0.3,0.8><0.1,2.0><0.4,2.9><0.4,2.9>
        scale y*-1
      }
      superellipsoid { <1, 0.1> rotate x*90 scale <1,0.1,1> translate y*-2.8}
      texture {T_Wood24}
      translate y*-0.85
    }
    
    light_source {
      z*1
      color rgb 0.4
      area_light <-0.5,-0.5,0>,<0.5,0.5,0>,3,3
      jitter
      looks_like {
        sphere {
          <0,0,0>,1
          pigment {color rgbf 1}
          hollow
          interior { media { emission rgb 1 density { spherical density_map { [0 rgb 0] [1 rgb 0.5] }}}}
        }
      }
    }
 
   translate z*-2.8
 }
  
  
translate y*3.65

}

#end

//--------------------------------------------------------------------------------------------------Dummy 2

#if (DummyTwo_Switch=1)

#declare DummyTwo = union {
  blob {
    threshold 1
    
    sphere {<0,1.2,0>,0.8,2}
    sphere {<0,0,0>,2,1}
    sphere {<0,-1,0>,2,1}
    sphere {<1,-3,0>,1.5,1}
    sphere {<-1,-3,0>,1.5,1}
    
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-20}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-160}
    
    pigment {color rgbf 1 quick_color rgb 1}
    
    hollow
  
    interior {
      media {
        method 1
        samples 1,100
        absorption 8
        scattering { 
          6,
          rgb 1
          diffuse 6 
          reflection 0.5
          reflection_exponent 1
          ratio 1
          frequency 50 
          waves 20,0
          falloff 0.8
          structure { sphere { 0, 4 } }
          pigment { color rgb <0.5,0.5,1> }
          force -10*y
        }
      }
    }
    
  }
  
  blob {
    threshold 1.2
    
    sphere {<0,1.2,0>,0.8,2}
    sphere {<0,0,0>,2,1}
    sphere {<0,-1,0>,2,1}
    sphere {<1,-3,0>,1.5,1}
    sphere {<-1,-3,0>,1.5,1}
    
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-20}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-160}
    
    pigment {color rgb <0.8,0.6,0.4>}
  }
  
  union {
    union {
      sphere {<0.3,1.2,-0.3>,0.2}
      sphere {<-0.3,1.2,-0.3>,0.2}
      pigment {color rgb 1}
    }
    union {
      sphere {<0.4,1.2,-0.4>,0.1}
      sphere {<-0.4,1.2,-0.4>,0.1}
      pigment {color blue 0.7}
    }
    union {
      sphere {<0.45,1.2,-0.45>,0.05}
      sphere {<-0.45,1.2,-0.45>,0.05}
      pigment {color rgb 0}
    }
    finish { specular 1 roughness 0.1 irid { 1 thickness 0.2 turbulence 2 } }
  }
  
  union {
    union {
      cylinder {<-3,4,0>,<3,4,0>,0.1}
      cylinder {<-3,4,0>,<-3,-5,0>,0.1}
      cylinder {<3,4,0>,<3,-5,0>,0.1}
      cylinder {<-3,-5,2>,<-3,-5,-2>,0.1}
      cylinder {<3,-5,2>,<3,-5,-2>,0.1}
      pigment {color rgb 0.7}
      finish {
        ambient 0.2
        brilliance 1
        diffuse 0.2
        metallic
        specular 1
        roughness 0.04
        reflection 0.05
      }
    }
    union {
      sphere {<3,4,0>,0.2}
      sphere {<-3,4,0>,0.2}
      sphere {<1.8,4,0>,0.15}
      sphere {<-1.8,4,0>,0.15}
      pigment {color rgb 0.5}
      finish {
        ambient 0.1
        brilliance 2
        diffuse 0.1
        metallic
        specular 1
        roughness 0.04
      }
    }
    union {
      cylinder {<2,0,0>,<1.8,4,0>,0.05}
      cylinder {<-2,0,0>,<-1.8,4,0>,0.05}
      pigment {color rgb <0.6,0.4,0.1>}
      normal { granite scale 0.01 bump_size 2 }
    }
    union {
      torus {0.4,0.1 rotate z*90 translate <2,-0.4,0>}
      torus {0.4,0.1 rotate z*90 translate <-2,-0.4,0>}
      pigment {color rgb 0.8}
      finish {
        ambient 0.2
        brilliance 8
        diffuse 0.2
        metallic
        specular 1
        roughness 0.01
        reflection 0.5
      }
    }
    pigment {color rgb 1}
  }
  
  translate y*5
}

#end

//--------------------------------------------------------------------------------------------------Dummy 3

#if (DummyThree_Switch=1)

#declare DummyThree = union {
blob {
  threshold 0.6
  
  sphere {<0,1.2,0>,0.8,2}
  sphere {<0,0,0>,1,1}
  sphere {<0,-1,0>,2,1}
  sphere {<1,-3,0>,1,1}
  sphere {<-1,-3,0>,1,1}
  
  sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-20 rotate y*50}
  sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}
  sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}
  sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-140}
  
  pigment {color rgbf 1 quick_color rgb 1}
  
  hollow

  interior {
    media {
      method 1
      samples 1,100
      absorption 8
      scattering { 
        6,
        rgb 1
        diffuse 6 
        reflection 0.5
        reflection_exponent 1
        ratio 1
        frequency 50 
        waves 20,0
        falloff 0.8
        structure { sphere { 0, 4 } }
        pigment { color rgb <1,0.5,0.5> }
        force -10*y
      }
    }
  }
  
}

blob {
  threshold 0.8
  
  sphere {<0,1.2,0>,0.8,2}
  sphere {<0,0,0>,1,1}
  sphere {<0,-1,0>,2,1}
  sphere {<1,-3,0>,1,1}
  sphere {<-1,-3,0>,1,1}
  
  sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-20 rotate y*50}
  sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}
  sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}
  sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-140}
  
  pigment {color rgb <0.8,0.6,0.4>}
}

union {
  union {
    sphere {<0.25,1.2,-0.25>,0.2}
    sphere {<-0.25,1.2,-0.25>,0.2}
    pigment {color rgb 1}
  }
  union {
    sphere {<0.35,1.2,-0.35>,0.1}
    sphere {<-0.35,1.2,-0.35>,0.1}
    pigment {color red 0.7}
  }
  union {
    sphere {<0.4,1.2,-0.4>,0.05}
    sphere {<-0.4,1.2,-0.4>,0.05}
    pigment {color rgb 0}
  }
  finish { specular 1 roughness 0.1 irid { 1 thickness 0.2 turbulence 2 } }
}

motion_blur {
  type 1
  difference{
    union{
      cylinder {
        <0,0,0>,<2,0,0>,0.1 
        pigment {color rgb 0}
        finish {
          phong 1
          phong_size 16
        }
      }
      cone {
        <2,-0.2,0>,0.8,<2,0.2,0>,1
        pigment {color rgb <0.1,0.3,0.1>}
        finish {
          brilliance 5
          metallic
          specular 1
          roughness 0.04
          reflection 0.2
        }
      }
    }
    cone {
      <2,-0.1,0>,0.8,<2,0.3,0>,1
      pigment {color rgb 0.5}
      finish {
        brilliance 5
        metallic
        specular 1
        roughness 0.04
        reflection 0.4
      }
    }
    rotate z*20
  }
  rotate clock*z*30
  rotate <-20,90,0>
  translate <1.5,-1,-1.5>
}

difference{
  union{
    cylinder {
      <0,0,0>,<2,0,0>,0.1 
      pigment {color rgb 0}
      finish {
        phong 1
        phong_size 16
      }
    }
    cone {
      <2,-0.2,0>,0.8,<2,0.2,0>,1
      pigment {color rgb <0.1,0.3,0.1>}
      finish {
        brilliance 5
        metallic
        specular 1
        roughness 0.04
        reflection 0.2
      }
    }
  }
  cone {
    <2,-0.1,0>,0.8,<2,0.3,0>,1
    pigment {color rgb 0.5}
    finish {
      brilliance 5
      metallic
      specular 1
      roughness 0.04
      reflection 0.4
    }
  }
  rotate z*20
  rotate <-20,90,0>
  translate <1.5,-1,-1.5>
}

motion_blur {
  type 1
  union {
    isosurface {
      function {f_sphere(x,y,z,0.4)-f_noise3d(x,y,z)}
      contained_by {box {-1,1}}
      scale y*0.2
      pigment {color rgb 1}
      finish {
        phong 1
        phong_size 8
      }
    }
    isosurface {
      function {f_sphere(x,y,z,0.4)-f_noise3d(x,y,z)}
      contained_by {box {-1,1}}
      scale <0.5,0.3,0.5>
      pigment {color rgb <1,1,0>}
      finish {
        phong 1
        phong_size 8
      }
    }
  }
  rotate <90*clock,0,20>
  translate <1.5,1,-3>
}

union {
  isosurface {
    function {f_sphere(x,y,z,0.4)-f_noise3d(x,y,z)}
    contained_by {box {-1,1}}
    scale y*0.2
    pigment {color rgb 1}
    finish {
      phong 1
      phong_size 8
    }
  }
  isosurface {
    function {f_sphere(x,y,z,0.4)-f_noise3d(x,y,z)}
    contained_by {box {-1,1}}
    scale <0.5,0.3,0.5>
    pigment {color rgb <1,1,0>}
    finish {
      phong 1
      phong_size 8
    }
  }
rotate z*20
translate <1.5,1,-3>
}

translate y*3.8
}

#end

//--------------------------------------------------------------------------------------------------Oven

#if (Oven_Switch=1)

union {

  difference {
    box {
      <-1,0,-1>,<1,3,1>
      pigment {color rgb 0.6}
      finish {
        ambient 0.2
        brilliance 5
        diffuse 0.2
        metallic
        specular 1
        roughness 0.1
        reflection 0.1
      }
    }
    superellipsoid {
      <0.1,0.9>
      scale <0.9,0.1,0.9>
      translate y*3
      pigment {color rgb 0.8}
      finish {
        ambient 0.4
        brilliance 4
        diffuse 0.4
        metallic
        specular 0.6
        roughness 0.1
        reflection 0.1
      }
    }
  }
  
  union {
    cylinder {<0,3,0>,<0,3.1,0>,0.4}
    union{
      torus {0.5,0.1 rotate z*90}
      torus {0.5,0.1 rotate x*90}
      scale y*0.3
      translate y*2.9
    }
    pigment {color rgb 0}
  }
  
  light_source {
    0
    color rgb <0.1,0.1,0.2>
    area_light <-0.4,0,-0.4>,<0.4,0,0.4>,3,3
    circular
    jitter
    looks_like {
      sphere {y*0.5,0.5
        pigment{color rgbf <1,1,1,1>}
        hollow
        interior {
          media {
            emission 3
            density {spherical color_map{[0 red 0.2][0.5 blue 1][1 rgb 1]} warp{turbulence 1 octaves 5 lambda 5 omega 0.4}}
          }
        }
        scale y*0.5
        translate y*-0.3
      }
    }
    translate y*3.2
  }
  
  translate z*-5
}

#end

//--------------------------------------------------------------------------------------------------Shelf

#if (Shelf_Switch=1)

union {
  
  box {
    <-1,0,-1>,<1,3,1>
    translate <-5,0,-5>
  }
  
  text {
    ttf "times.ttf" "PB" 0.001,0
    h_align_center
    v_align_bottom
    scale 0.8
    rotate x*90+y*35
    translate <-4.7,3.001,-4.75>
  }
  
  texture {T_Wood14}
  normal {wrinkles 0.05 scale 0.2}
  finish {
    phong 0.4
    phong_size 80
    reflection {
      0.05, 0.5
      fresnel on
    }
  }

}

#end

//--------------------------------------------------------------------------------------------------Roof Lamp

#if (Roof_Lamp_Switch=1)

difference {
  cone {<0,5.9,0>,1,<0,6.3,0>,0.8}
  cone {<0,5.8,0>,0.9,<0,6.2,0>,0.7}
  pigment {color rgbf <0.7, 0.5, 0.1, 1>}
  finish {
    specular 1
    roughness 0.1
  }
  interior {
    ior 1.5
    fade_distance 1
    fade_power 2
  }
}

cylinder {
  <0,6.2,0>,<0,20,0>,0.05 
  pigment {color rgb 0}
}

light_source {
  y*6
  color rgb <1,0.9,0.8>
  area_light <-0.3,0,-0.3>,<0.3,0,0.3>,5,5
  circular
  jitter
  looks_like {torus {0.6,0.1 pigment {color rgb <1,0.9,0.8>} finish {ambient 2}}}
}

#end

//--------------------------------------------------------------------------------------------------Dummies

#if (DummyOne_Switch=1)
  object {DummyOne rotate y*150 translate <-2,0,1>}
#end

#if (DummyTwo_Switch=1)
  object {DummyTwo rotate y*-10 translate <3,0,6> }
#end

#if (DummyThree_Switch=1)
  object {DummyThree translate z*-1}
#end

//--------------------------------------------------------------------------------------------------Walls, Roof, Floor

#if (Walls_Switch=1)

union {
  box {<-6,0,-6>,<27,20,-7>}
  box {<-6,0,10>,<27,20,11>}
  box {<-7,0,-7>,<-6,20,11>}
  box {<27,0,-7>,<28,20,11>}
  box {<-7,20,-7>,<28,21,11> pigment {color rgbf 1}}

  pigment {color rgbf <0.97, 0.99, 0.98, 0.9>}
  finish {
    specular 0.6
    roughness 0.005
    ambient 0
    diffuse 0.2
    brilliance 4
    reflection {
      0, 0.2
      fresnel on
    }
    conserve_energy
    irid {
      0.05
      thickness 1
      turbulence 0.1
    }
  }
  interior {
    ior 1.5
    dispersion 1.2
    fade_distance 4
    fade_power 2
  }
}

difference {
  box {<10,0,-6>,<11,10,10>}
  box {<9,-1,-3>,<12,6,1>}
  pigment { color rgb 1}
  pigment {cells color_map {[0 color rgb <0.2,0.1,0>][0.2 color rgb <0.9,0.6,0.3>]} scale 0.2}
}

box {
  <-8,0,-8>,<29,-1,12>
  pigment {
    checker
    pigment {agate agate_turb 1 color_map {[0 color rgb 0.5][0.2 color rgb 1]}}
    pigment {agate agate_turb 1 color_map {[0 color rgb 1][0.2 color rgb 0.5]}rotate 90}
    scale 2
  }
  finish {
    specular 1
    roughness 0.1
  }
  normal {checker 1 scale 2 translate y}
}

#end

//--------------------------------------------------------------------------------------------------Text

#if (Text_Switch=1)

text {
  ttf "arial.ttf" "Lifeforms 21,42b,76a" 0.05,0
  rotate y*180
  scale 2.5
  translate <20,16,11>
}

#end

//--------------------------------------------------------------------------------------------------Drapeau

#if (Drapeau_Switch=1)

object {
  Drapeau
  rotate y*90
  translate <10.5,3,-1>
}

#end

//--------------------------------------------------------------------------------------------------Lava Lamp

#if (Lava_Lamp_Switch=1)

union {
  union {
    difference {
      sphere {0,0.2 scale y*6 translate y*0.2}
      box {<-1,-2,-1>,<1,1,1>}
    }
    cone {<0,0,0>,0.3,<0,0.2,0>,0.2
    }
    pigment {color rgb 0.8}
    finish {
      ambient 0.2
      brilliance 3
      diffuse 0.2
      metallic
      specular 0.80
      roughness 0.02
      reflection 0.35
    }
  }
  intersection {
    sphere {0,0.2 scale y*6 translate y*0.2}
    box {<-1,0.2,-1>,<1,1,1>}
    pigment{color rgbf 1}
    finish {
        specular 0.80
        roughness 0.005
        reflection 0.2
    }
    hollow
    interior {
      ior 1.33
      caustics 1         
      fade_power 1       
      fade_distance 0.5  
      fade_color <0,1,0>
      media {emission rgb<0,1,0>}
    }
  }

  sphere_sweep {
    cubic_spline
    10,              
    <0, 0, 0>, 0.02       
    <0, 0, 0>, 0.02       
    <-0.05, 0, -0.3>, 0.02        
    <0.1, 0.05, -0.4>, 0.02        
    <0.3, 0, -0.3>, 0.02
    <0.5, 0.1, -0.5>, 0.02
    <0.9, 0.02, 0>, 0.02
    <0.6, -0.05, 0.3>, 0.02
    <0.9, -1, 0.4>, 0.02
    <0.9, -1, 0.4>, 0.02
    pigment{color rgb 0}
    finish {
      phong 0.6
      phong_size 16
    }
  }
  translate <-5.1,3,-4.2>
}

#declare m=32;
#declare Lava = array[m][5]
#declare n=0;
#while (n<m)
  #declare Lava[n][0]=rand(MyStream);
  #declare Lava[n][1]=rand(MyStream);
  #declare Lava[n][2]=rand(MyStream);
  #declare Lava[n][3]=rand(MyStream);
  #declare Lava[n][4]=rand(MyStream)*2-1;
  #declare n=n+1;
#end

motion_blur {
  type 0
  blob {
    threshold 1
    #declare n=0;
    #while (n<m)
      sphere {<Lava[n][0]*0.2-0.1,(clock*Lava[n][4])+(Lava[n][1]*(1-0.2)+0.2),Lava[n][2]*0.2-0.1>,Lava[n][3]*0.15,1}
      #declare n=n+1;
    #end
    pigment{color rgbf <0,1,0,0.8>}
    hollow
    interior {
      ior 1.1
      fade_power 1       
      fade_distance 0.2  
      fade_color <0,1,0>
    }
    no_shadow
    translate <-5.1,3,-4.2>
  }
}

blob {
  threshold 1
  #declare n=0;
  #while (n<m)
    sphere {<Lava[n][0]*0.2-0.1,(Lava[n][1]*(1-0.2)+0.2),Lava[n][2]*0.2-0.1>,Lava[n][3]*0.15,1}
    #declare n=n+1;
  #end
  pigment{color rgbf <0,1,0,0.8>}
  hollow
  interior {
    ior 1.1
    fade_power 1       
    fade_distance 0.2  
    fade_color <0,1,0>
  }
  no_shadow
  translate <-5.1,3,-4.2>
}

light_source {
  0.3+0.9/2*y
  color rgb <0.1,0.3,0.1>
  area_light <0, 0.3, 0>,<0, 0.9, 0>,1,5
  jitter    
  translate <-5.1,3,-4.2>
}

#end

//--------------------------------------------------------------------------------------------------It

#if (It_Switch=1)

union {
  sphere {
    <7,9,8>,7
    scale y*0.8
    translate z*1
    rotate z*10
    pigment {color rgbf <0,0,0,1>}
  }
  sphere {0,2 scale x*1.4 rotate z*-15 translate <10,13,0>}
  sphere {0,1 scale x*1.3 rotate z*-10 translate <1,11,0>}
  sphere {0,1 scale x*1.3 rotate z*-5 translate <-1,8,0>}
  sphere {0,1 scale x*1.3 rotate z*5 translate <0,4.5,0>}
  sphere {0,1 scale x*1.2 rotate z*10 translate <3,2.5,0>}
  pigment {color rgb <0.9,0.8,0.7>/2}
  scale z*0.01
  rotate z*-20
  translate <-3,4,11>
}

union {
  sphere {
    <0,4.3+10,2>,8
    scale x*0.7
    translate x*3.5
    pigment {color rgbf <0,0,0,1>}
  }
  union {
    sphere {<0,4.3,0>,3}
    sphere {<7,4.3,0>,3}
    pigment {color rgb 0.9/2}
    scale z*0.5
  }
  union {
    sphere {<0,1.3,0>,1.3}
    sphere {<7,1.3,0>,1.3}
    pigment {
      radial frequency 40
      color_map {
        [1/8*0 color rgb <0.6,0.3,0.2>/4]
        [1/8*1 color rgb <0.6,0.3,0.2>/2]
        [1/8*2 color rgb <0.6,0.3,0.2>/6]
        [1/8*3 color rgb <0.6,0.3,0.2>/1]
        [1/8*4 color rgb <0.6,0.3,0.2>/7]
        [1/8*5 color rgb <0.6,0.3,0.2>/3]
        [1/8*6 color rgb <0.6,0.3,0.2>/8]
        [1/8*7 color rgb <0.6,0.3,0.2>/5]
      }
    }
  }
  union {
    sphere {<0,0,0>,0.5}
    sphere {<7,0,0>,0.5}
    pigment {color rgb 0}
  }
  rotate y*120
  scale 2
  scale y*0.01
  translate <16,21,6>
}

#end

//--------------------------------------------------------------------------------------------------Pendule

#if (Pendule_switch=1)

#declare Pendule = union {
  sphere {<0,-0.5,0>,0.05}
  cylinder {<0,-0.5,0>,<0,0,0>,0.005}
  cylinder {<0,0,-0.01>,<0,0,0.01>,0.02}
}

union{

  box {0,<0.5,0.1,0.2>}
  
  sphere_sweep {
    b_spline 20,                         
    <0.00,0.0,0.0>,0.05
    <0.00,0.0,0.0>,0.05
    <0.00,0.1,0.0>,0.05
    <0.00,0.1,0.0>,0.01
    <0.00,0.7,0.0>,0.01
    <0.05,0.7,0.0>,0.01
    <0.05,0.7,0.2>,0.01
    <0.15,0.7,0.2>,0.01
    <0.15,0.7,0.0>,0.01
    <0.25,0.7,0.0>,0.01
    <0.25,0.7,0.2>,0.01
    <0.35,0.7,0.2>,0.01
    <0.35,0.7,0.0>,0.01
    <0.45,0.7,0.0>,0.01
    <0.45,0.7,0.2>,0.01
    <0.50,0.7,0.2>,0.01
    <0.50,0.1,0.2>,0.01
    <0.50,0.1,0.2>,0.05
    <0.50,0.0,0.2>,0.05
    <0.50,0.0,0.2>,0.05
  }

  object {Pendule translate <0.05,0.7,0.1>}
  object {Pendule translate <0.15,0.7,0.1>}
  object {Pendule translate <0.25,0.7,0.1>}
  object {Pendule translate <0.35,0.7,0.1>}
  object {Pendule rotate z*5 translate <0.45,0.7,0.1>}
  motion_blur {
    type 1
    object {Pendule rotate z*(clock*60+5) translate <0.45,0.7,0.1>}
  }

  pigment {color rgb 0.4}
  finish {
    ambient 0.2
    brilliance 4
    diffuse 0.3
    metallic
    specular 0.70
    roughness 0.01
    reflection 0.2
  }
  normal {
    bozo 0.3
    scale 0.03
  }

rotate y*-70
translate <-4.3,3,-5.1>

}

#end
