/**************************************************************
 * Persistence Of Vision Ray Tracer Scene Description File
 *
 * File name  : telescop.pov
 * Version    : 3.6
 * Date       : December 31, 2004
 * Author     : 
 * Scene scale: 1 POV unit = 1in.
 * Description: Basic refractor telescope on a tripod in the
 *              desert at night.
 **************************************************************/

#include "colors.inc"
#include "glass.inc"
#include "finish.inc"
#include "textures.inc"
#include "metals.inc"
#include "stars.inc"                                                              
#include "skies.inc"                                                 
                      
// --------------------- Control Center --------------------- //
#declare quick_render=1;      
                      
// --------------------- Global Settings -------------------- //
global_settings {
  assumed_gamma 1
  max_trace_level 25         
} 
// --------------------- Camera ----------------------------- //
#declare cl=<3, 20, 100>; //  <-13, -10, 10 >
#declare la=<-13,0,0>;
camera {
  location cl        
  look_at  la
  #if (!quick_render)
    focal_point <0,4,0>    // object in focus
    aperture 1           
    blur_samples 100        // more samples, higher quality image
  #end
} 
    
// --------------------- Lights ----------------------------- //
light_source {
  <-8, 100, 18>
  color rgb <.15, .15, .25> 
  area_light <4,0,0>,  <0,0,4>,  10, 10
}
  
// --------------------- Sky Sphere ------------------------- //
sphere {
  0, 1
  texture {
    Starfield1     
    scale .000001
  }
  scale 10000 
  hollow on
}
plane{
  y,500
  pigment{P_Cloud1 scale 500}
}
                      
// --------------------- Ground ----------------------------- //
#declare t_stone1=
texture{
  pigment{
		image_map { jpeg "textures\stone1.jpg"
			map_type 0
			interpolate 2
		}
	}
} 

#declare t_stone2=
texture{
  pigment{
		image_map { jpeg "textures\org_rag.jpg"
			map_type 2        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
      interpolate 0     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
		}
	}
	rotate z*90
}

height_field{            
  png "hm.png"
  smooth
  translate <-.5,0,-.5>
  scale <1500,250,1000>
  translate <-250,-200,-500> 
  texture{t_stone1 scale 80}
}
cylinder{<0,-75,0>,<0,-100,0>,200 texture{t_stone2 scale 80} }//


// --------------------- Materials -------------------------- //
#declare m_ws=  // white shiny
material {
  texture {
    pigment { rgb 1 }
    finish { // Phong_Glossy = finish {phong 1 phong_size 300 reflection 0.13}
      phong 1
      phong_size 300
      metallic
      ambient 0.2
      diffuse 0.35
      specular 0.85
      roughness .1
      reflection 0.13
      brilliance 1.5
    }
  }
}
#declare m_gs=  // Gray shiny
material {
  texture {
    pigment { rgb .95 }
    finish { // Phong_Glossy = finish {phong 1 phong_size 300 reflection 0.13} 
      phong 1
      phong_size 300
      metallic
      ambient 0.2
      diffuse 0.35
      specular 0.85
      roughness .1
      reflection 0.13
      brilliance 1.5
    }                                                                 
  }
}
#declare m_bs=  // black shiny
material {
  texture {
    pigment { rgb 0 }
    finish { // Phong_Glossy = finish {phong 1 phong_size 300 reflection 0.13} 
      phong 1
      phong_size 300
      metallic
      ambient 0.2
      diffuse 0.35
      specular 0.85
      roughness 0.1
      reflection 0.45
      brilliance 1.5
    }
  }
}
#declare m_bd=  // black dull
material {
  texture {
    pigment { rgb .001 }
    finish { // Dull = finish {specular 0.5 roughness 0.15}
      phong 1
      phong_size 300 
      //metallic
      ambient 0.2
      diffuse 0.35
      specular 0.5
      roughness .15
      reflection 0.01
      brilliance 1.5
    }
  }
}
#declare m_bm=  // blasted metal
material {
  texture {
    pigment { rgb <0.55, 0.5, 0.45> } 
    finish {
      metallic
      ambient 0.2
      diffuse 0.35
      specular 0.85
      roughness .1
      reflection 0.01
      brilliance 1.5
    }
  }                                                      
}
#declare m_sm=  // shiny metal
material {
  texture {
    pigment { rgb <0.55, 0.5, 0.45> } 
    finish {
      metallic
      ambient 0.2
      diffuse 0.35
      specular 0.85
      roughness 0.1
      reflection 0.45
      brilliance 1.5
    }
  }
}
#declare m_dm=  // dull metal
material {
  texture {
    pigment { rgb <0.55, 0.5, 0.45> } 
    finish {
      metallic
      ambient 0.2
      diffuse 0.35
      specular 0.85
      roughness 0.5
      reflection 0.15
      brilliance 1.5
    }
  }
}
// --------------------- Objects ---------------------------- //
#declare y_rot=30;
#declare incline=20;
// --------------------- Wing Nut's
#declare wng_nut=
union{
  intersection{
    union{
      sphere{<.5,0,0>,.25}
      sphere{<-.5,0,0>,.25}
      sphere{<0,.25,0>,.25}
      cylinder{<.5,0,0>,<-.5,0,0>,.25}
    }
    plane{z,.1}
    plane{-z,.1}
  }
  cylinder{<0,0,0>,<0,-1.5,0>,.09}
  material{m_dm}
}
// --------------------- Mounting Brackets
#declare mnt_brkt=  //  
union{
  difference{
    union{
      cylinder{<1,0,0>,<-1,0,0>,2}
      box{<1,.25,3>,<-1,-.25,-3>}
    }
    box{<1.1,.125,3.1>,<-1.1,-.125,-3.1>}  
    material{m_bs}
  }
  union{               // wingnuts? 
    object{wng_nut scale .5 rotate y*10 translate <0,.375,2.5> }
    object{wng_nut scale .5 rotate y*-5 translate <0,.375,-2.5>}
  }
}
// --------------------- Mounting Fixture
#declare mnt_fxtr=
union{
  union{
    object{mnt_brkt translate <3,0,0>} 
    object{mnt_brkt translate <-3,0,0>} 
    union{ 
      box{<4,.2,.5>,<-4,-.2,-.5> material{m_bd}}  //bracket plate
      union{
        cylinder{<3,-.5,0>,<3,1,0>,.1}
        cylinder{<-3,-.5,0>,<-3,1,0>,.1}
        material{m_bm}                                                                
      }
      translate y*-2.2
    }
    translate y*1
  }
  union{
    difference{ // Joint to bracket plate
      union{
        box{<.5,1.5,.5>,<-.5,-.25,-.5>}
        cylinder{<0,-.25,.5>,<0,-.25,-.5>,.5}
      }
      box{<.6,.25,-.4>,<-.6,-.76,.4>}
      material{m_bs}
    }
    union{  // Control rod
      cylinder{<0,.8,0>,<7,.8,0>,.2}   
      sphere{<7,.8,0>,.5}
      
      rotate z*-10 
      rotate y*180
      material{m_bs}
    }
    union{  // Joint knob
      cylinder{<0,-.25,.6>,<0,-.25,.85>,1}
      cylinder{<0,-.25,.95>,<0,-.25,-.75>,.1}
      material{m_dm}
    }
    union{  // vert rod
      cylinder{<0,-.25,.39>,<0,-.25,-.39>,.5}
      box{<.5,-.25,-.4>,<-.5,-1,.4>}
      box{<.5,-.75,-.5>,<-.5,-1,.5>}
      intersection{
        box{<.5,-1,-.5>,<-.5,-2,.5>}
        cone{<0,-1,0>,0.70710678118654752440084436210485,<0,-2,0>,.5}
      }
      cylinder{<0,-1,0>,<0,-8,0>,.5 material{m_sm}}
      cylinder{<0,-7.9,0>,<0,-8.1,0>,.75}
      material{m_bs}
      translate y*.25
      rotate z*-incline
      translate y*-.25
    }  
    
    translate y*-2.9
  }
}
// --------------------- Viewing Assembly
#declare viewer=
union{
  intersection{ // reflector
    box{<-1.5,-1.5,-1.5>,<1.5,1.5,1.5>}
    plane{x,0 rotate z*22.5 translate x*.9}
    plane{-x,0 rotate z*-22.5 translate x*-.9}
    material{m_bd} 
    rotate z*-22.5
  }
  cylinder{<0,0,0>,<3,0,0>,1 material{m_bs}} // reflector to telescope
  union{
    union{ // view piece neck to reflector
      cylinder{<0,0,0>,<-3,0,0>,1} 
      cylinder{<-2.5,0,0>,<-3,0,0>,1.1} 
      material{m_bs}
    }
    union{ // view piece locking screw
      cylinder{<-2.75,0,0>,<-2.75,-1.5,0>,.05}
      cylinder{<-2.75,-1.35,0>,<-2.75,-1.5,0>,.15} 
      material{m_dm}
    }
    difference{ // view piece
      union{
        cylinder{<-3,0,0>,<-4,0,0>,1}
        difference{
          cone{<-4,0,0>,.9,<-4.5,0,0>,1.25}
          cone{<-4,0,0>,.8,<-4.6,0,0>,1.25}
        }
      }
      cylinder{<-3.7,0,0>,<-4.6,0,0>,.3}    
      material{m_bd}
    }
    cylinder{<-3.6,0,0>,<-3.9,0,0>,.3  //lens
      pigment{White}
      finish{ambient .5}
    } 
    rotate z*-45  
  }
}
// --------------------- Spotting Scope
#declare spt_scope=
union{
  union{
    cone{<-3,0,0>,1,<-1,0,0>,.9 }
    box{<-2.9,0,-.2>,<-2.2,1.05,.2>}
    box{<-2.9,-.2,0>,<-2.2,.2,1.05>}  
    material{m_bd}
  }
  union{
    cylinder{<-2.55,0,0>,<-2.55,1.5,0>,.1}
    cylinder{<-2.55,1.25,0>,<-2.55,1.5,0>,.35}
    cylinder{<-2.55,0,0>,<-2.55,0,1.5>,.1}
    cylinder{<-2.55,0,1.25>,<-2.55,0,1.5>,.35}
    material{m_dm}
  }
  cylinder{<.55,0,0>,<-2.9,0,0>,.75 material{m_ws}}
  difference{
    union{
      cylinder{<3,0,0>,<.5,0,0>,.77}
      cylinder{<.5,0,0>,<1,0,0>,.82}
    }
    cylinder{<3.5,0,0>,<-5,0,0>,.7}
    material{m_bs}
  }
  difference{
    cylinder{<-2.9,0,0>,<-5,0,0>,.5}
    cylinder{<-2.9,0,0>,<-5.1,0,0>,.43}
    material{m_bs}
  }
  intersection{
    box{<-1,0,-1>,<1,-4,1>}
    plane{z,0 rotate x*-1 translate z*.1}
    plane{-z,0 rotate x*1 translate z*-.1}
    plane{x,0 rotate z*10 translate x*.1}
    plane{-x,0 translate x*-.5}
    translate x*-2
    material{m_bd}
  }
  intersection{
    box{<-1,-3.9,-1>,<1.2,-4.5,1>}
    plane{z,0 rotate x*-30 translate z*-1.75}
    plane{-z,0 rotate x*30 translate z*1.75}
    plane{-x,0 translate x*-.7}
    translate x*-2
    material{m_bd}
  }
} 
// --------------------- Telescope
#declare telescope=
union{ 
  union{
    union{                                       // end cap
      difference{
        cylinder{<18,0,0>,<12,0,0>,2.5 material{m_gs}}   
        cylinder{<19,0,0>,<11,0,0>,2.45 material{m_bd}}
      }
      cylinder{<12.05,0,0>,<11.95,0,0>,2.6 material{m_bs}}
    }
    cylinder{<12,0,0>,<-12,0,0>,1.75 material{m_ws}} // main body
    union{
      sphere{<-11.5,1.75,0>,.15} 
      sphere{<-11.5,-1.75,0>,.15}
      sphere{<-11.5,0,1.75>,.15}
      sphere{<-11.5,0,-1.75>,.15}
      material{m_sm}
    }    
    object{viewer scale .75 translate x*-17 }
    object{spt_scope scale .75 translate <-12,4.75,0> rotate x*40} 
    cylinder{<-12,0,0>,<-15,0,0>,1.65 material{m_bs}}
    union{
      cylinder{<-13,-4,-2.5>,<-13,-4,2.5>,.2}
      cylinder{<-13,-4,-2.5>,<-13,-4,-1.5>,1}
      cylinder{<-13,-4,1.5>,<-13,-4,2.5>,1}
      union{
        cylinder{<-13,-4,-1>,<-13,-4,1>,1}
        box{<-12,-4,-1>,<-14,-3,1>}
        material{m_bs}
      }
      translate <0,2,0>
      material{m_dm}      
    }
    translate y*1
  }
  object{mnt_fxtr}
  translate y*3.15    // puts pivot at y*0
} 
// --------------------- Tripod Leg 
#declare leg=
union{
  difference{    // top  
    intersection{
      union{
        cylinder{<0,21,0>,<0,20,0>,1.5}
        intersection{
          cylinder{<0,25,0>,<0,20,0>,1.5}
          cylinder{<-5,21,0>,<5,21,0>,1.5}
        }
      }
      box{<1.5,25,1.125>,<-1.5,19.9,-1.125>}
    } 
    box{<.6,23,3>,<-.6,19.9,-3>}
    material{m_bd}
  }
  union{   // leg mount joint
    cylinder{<-.6,21,0>,<.6,21,0>,1.25}
    box{<-.6,-1.25,0>,<.6,1.25,1.6> rotate x*-30 translate y*21 }
    box{<-1,-1.25,1.5>,<1,1.25,3> rotate x*-30 translate y*21 }
    material{m_bd}
  } 
  
  union{
    object{wng_nut rotate y*13 rotate z*-90 translate <1.8,21,0>}
    cylinder{<-2,21,0>,<0,21,0>,.1 }
    cylinder{<-1.7,21,0>,<0,21,0>,.3 }
    material{m_dm}
  }
  
  union{
    difference{    // upper
      intersection{
        cylinder{<0,20,0>,<0,-20,0>,1.5}
        box{<1.5,20.1,1.125>,<-1.5,-20.1,-1.125>}
      }
      cylinder{<0,20.1,0>,<0,-20.1,0>,0.9375 scale z*2}
      material{m_bm}
    }
    union{
      sphere{<1.5,19,0>,.2}
      sphere{<1.5,18,0>,.2}
      sphere{<-1.5,19,0>,.2}
      sphere{<-1.5,18,0>,.2}
      material{m_sm}      
    }
  }
  union{
    intersection{  // lower
      intersection{
        cylinder{<0,20,0>,<0,-20,0>,1.5}
        box{<1.5,20.1,1.125>,<-1.5,-20.1,-1.125>}
      }
      cylinder{<0,20.1,0>,<0,-20.1,0>,0.9 scale z*2}
      material{m_bm}
    }
    union{
      sphere{<0,-19,1.125>,.2}
      sphere{<0,-19,-1.125>,.2}
      material{m_sm}
    }  
    translate y*-30
  }
  union{  // foot
    intersection{
      cone{<0,-20,0>,0.9,<0,-22,0>,.75 scale z*2}
      box{<1.5,-19.9,1.125>,<-1.5,-22.1,-1.125>}
    }
    cone{<0,-22,0>,.5,<0,-24,0>,.1}
    material{m_bd}            
    translate y*-30 
  }     
  union{ // binding
    intersection{  
      cylinder{<0,-18,0>,<0,-20.1,0>,1.6875}
      box{<2.7,20.2,1.3125>,<-2.7,-20.2,-1.3125>}
      material{m_bd}
    }
    object{wng_nut rotate z*-90 rotate x*-20 translate <2,-19,0>}
    union{
      sphere{<-1.6875,-18.5,0>,.2}
      sphere{<-1.6875,-19.5,0>,.2}
      material{m_sm}      
    }
  } 
  translate y*-21     
  rotate x*20         // leg angle
  translate z*-4.5
}
// --------------------- Tripod  
#declare tripod=
union{
  union{
    object{leg}  
    object{leg rotate y*120}
    object{leg rotate y*240}
    translate y*-2.25
    rotate y*20
  }
  cylinder{<0,-.99,0>,<0,-3.51,0>,3 material{m_bd}}   // leg plate
  union{
    difference{ // adjustment cylinder
      union{
        cylinder{<0,-1,0>,<0,1,0>,2}
        box{<1.5,-.9,0>,<-1.5,.9,2>}
      }
      box{<.1,-1.35,0>,<-.1,1.35,3>}
      box{<-2.1,-.1,-1>,<2.1,.1,2.1>} 
      material{m_bd}
    }
    union{  // control knobs
      cylinder{<-.5,.5,1.625>,<4,.5,1.625>,.3}
      cylinder{<.5,-.5,1.625>,<-4,-.5,1.625>,.3}
      cylinder{<3.8,.5,1.625>,<4.1,.5,1.625>,1}
      cylinder{<-3.8,-.5,1.625>,<-4.1,-.5,1.625>,1}
      material{m_bd}
    }
    rotate y*70
  }
  translate y*-.5
}
// --------------------- Scene ------------------------------ //
  
object{telescope rotate z*incline rotate y*y_rot scale 1.5 translate y*1}//                
object{tripod translate y*-3}                