#declare boisBoiserieClaire = texture {
   //*PMRawBegin
   
               T_Wood10 //T_Wood14 //T_Wood21
               finish { specular 0.35 roughness 0.05 ambient 0.3 }
               //translate x*1
               scale 6
               rotate <0, 0, 0>
               //translate y*2
               
   //*PMRawEnd
   //scale 30
}

#declare boisBoiserieFoncee = texture {
   //*PMRawBegin
   
              T_Wood14  
               finish { specular 0.35 roughness 0.05 ambient 0.3 }
               //translate x*1
               scale 2
               rotate <90, 0, 0>
               //translate y*2
               
   //*PMRawEnd
  // scale 30
}

#declare boisBoiserieFonceeXY = texture {
   //*PMRawBegin
   
              T_Wood14  
               finish { specular 0.35 roughness 0.05 ambient 0.3 }
               //translate x*1
               scale 2
               rotate <0, 90, 0>
               translate y*1
               
   //*PMRawEnd
  // scale 30
}

#declare intervalleBois = texture {
   //*PMRawBegin
   pigment {
         color rgb 0
      }
   finish { specular 0. roughness 0.05 ambient 0.3 }
   
}

#macro txboisBoiserieFoncee(lx,lz,rd) // pour planche verticale
  texture {
    T_Wood14  //T_Wood11// T_Wood21
    finish { specular 0.35 roughness 0.05 ambient 0.3 }
    scale 2
    rotate <90, 0, 0>
    translate <lx*rand(rd),0,lx*rand(rd)>
  // scale 30
}

#end

#macro txboisBoiserieClaire(lx,lz,rd) // pour planche verticale
  texture {
    T_Wood10  //T_Wood11// T_Wood21
    finish { specular 0.35 roughness 0.05 ambient 0.3 }
    scale 6
    rotate <0, 0, 0>
    translate <lx*rand(rd),0,lx*rand(rd)>
  // scale 30
}

#end

#macro txboisChoisi(txBois,lx,lz,rd)
#switch (txBois)
  #case (0)
    txboisBoiserieClaire(lx,lz,rd) 
    #break
  #case (1)
    txboisBoiserieFoncee(lx,lz,rd) 
    #break
  #else
    #error "texture non trouvee dans switch"
  #end
#end

// planche dans le plan x,z (largeur X longueur)
// epaisseur de -0,5  0
// 
#macro planche(longueurPlanche,largeurPlanche,jointplanche)
 union {
   box {
      <jointplanche, -0.5, jointplanche>, <largeurPlanche-jointplanche, 0, longueurPlanche-jointplanche>
      
   }
   union {
     box {
        <0, -0.5, 0>, <largeurPlanche, 0, jointplanche>
     }
     box {
        <0, -0.5, longueurPlanche>, <largeurPlanche, 0, longueurPlanche-jointplanche>
     }
     box {
        <0, -0.5, 0>, <jointplanche, 0, longueurPlanche>
     }
     box {
        <largeurPlanche, -0.5, 0>, <largeurPlanche-jointplanche, 0, longueurPlanche>
     }
    texture {
         intervalleBois
      }
    }
}
#end

#macro plancheSimple(longueurPlanche,largeurPlanche)
   box {
      <0, -0.5, 0>, <largeurPlanche, 0, longueurPlanche>
      
   }
#end

#declare largeurplanche= 20;
#declare longueurplanche=50;
#declare jointplanche=0.1; //demi-largeur du joint
     
// planche avec joint
// dcalage d'un demi-planche sur z
#macro plancherRect(xdepart,xarrivee,zdepart,zarrivee,rd,txBois)

#local inversionX=false;
#local xmin=xdepart;
#local xmax=xarrivee;
#if (xdepart > xarrivee)
  #error "macro plancherRect : xdepart > xarrivee non implment"
  #local inversionX=true;
  #local xmin=xarrivee;
  #local xmax=xdepart;
  #end
#local inversionZ=false;
#local zmin=zdepart;
#local zmax=zarrivee;
#if (zdepart > zarrivee)
  #error "macro plancherRect : zdepart > zarrivee non implment"
  #local inversionZ=true;
  #local zmin=zarrivee;
  #local zmax=zdepart;
  #end  

// adaptation largeur
#local nbx=floor((xmax-xmin)/largeurplanche);
#local reste=xmax-xmin-nbx*largeurplanche;
#if (reste > largeurplanche/2)
  #local nbx=nbx+1;
  #end
#local largeur=(xmax-xmin)/nbx;
// adaptation longueur
#local nbz=floor((zmax-zmin)/longueurplanche-0.5);
#local reste=zmax-zmin-(nbx+0.5)*longueurplanche;
#if (reste > longueurplanche/2)
  #local nbz=nbz+1;
  #end
#local longueur=(zmax-zmin)/(nbz+0.5);

#local flagDemiPlanche=true;
  
   union {
   
#local xdecal=xmin;
#while(xdecal<(xmax-largeur*0.9))  //0.9 pour erreurs d'arrondis
  #if (flagDemiPlanche)
    object {
      planche(longueur/2,largeur,jointplanche)
      txboisChoisi(txBois,largeur,longueur,rd) 
      translate <xdecal,0,zmin>
      }
    #local zdecal=zmin+longueur/2;
    #local flagDemiPlanche=false;
  #else
    #local zdecal=zmin;
    #local flagDemiPlanche=true;
  #end

  #while(zdecal < (zmax-longueur*0.9))   
    object {
      planche(longueur,largeur,jointplanche)
      txboisChoisi(txBois,largeur,longueur,rd) 
      translate <xdecal,0,zdecal>
      }

    #local zdecal=zdecal+longueur;
    #end
  #if ( flagDemiPlanche) // si pas au debut (donc prochaine), une  la fin
    object {
      planche(longueur/2,largeur,jointplanche)
      txboisChoisi(txBois,largeur,longueur,rd) 
      translate <xdecal,0,zdecal>
      }
    #end
  #local xdecal=xdecal+largeur;  
  #end 
 
}
#end


// planche sans joint
// pas de dcalage d'un demi-planche sur z
#macro plancherRectSimple(xdepart,xarrivee,zdepart,zarrivee,rd,txBois)

#local inversionX=false;
#local xmin=xdepart;
#local xmax=xarrivee;
#if (xdepart > xarrivee)
  #error "macro plancherRect : xdepart > xarrivee non implment"
  #local inversionX=true;
  #local xmin=xarrivee;
  #local xmax=xdepart;
  #end
#local inversionZ=false;
#local zmin=zdepart;
#local zmax=zarrivee;
#if (zdepart > zarrivee)
  #error "macro plancherRect : zdepart > zarrivee non implment"
  #local inversionZ=true;
  #local zmin=zarrivee;
  #local zmax=zdepart;
  #end  

// adaptation largeur
#local nbx=floor((xmax-xmin)/largeurplanche);
#local reste=xmax-xmin-nbx*largeurplanche;
#if (reste > largeurplanche/2)
  #local nbx=nbx+1;
  #end
#local largeur=(xmax-xmin)/nbx;
// adaptation longueur
#local nbz=floor((zmax-zmin)/longueurplanche);
#local reste=zmax-zmin-nbx*longueurplanche;
#if (reste > longueurplanche/2)
  #local nbz=nbz+1;
  #end
#local longueur=(zmax-zmin)/nbz;

   union {
   
#local xdecal=xmin;
#while(xdecal<(xmax-largeur*0.9))  //0.9 pour erreurs d'arrondis 
  #local zdecal=zmin;
  #while(zdecal < (zmax-longueur*0.9))   
    object {
      plancheSimple(longueur,largeur)
      txboisChoisi(txBois,largeur,longueur,rd) 
      translate <xdecal,0,zdecal>
      }

    #local zdecal=zdecal+longueur;
    #end
  #local xdecal=xdecal+largeur;  
  #end 
 
}
#end
    
#macro moulureSimple(lg)
difference {
   union {
      box {
         <-6, -5, -0.6>, <lg+6, 5, 0>
      }      
      cylinder {
         <-6, 0, 0>, <lg+6, 0, 0>, 2
         translate <0, 3, -0.6>
      }     
      cylinder {
         <-6, 0, 0>, <lg+6, 0, 0>, 1
         scale 1
         rotate <0, 0, 0>
         translate <0, -1, -0.6>
        texture {
          boisBoiserieClaire
          rotate x*90
          }
      }
      
      cylinder {
         <-6, 0, 0>, <lg+6, 0, 0>, 1
         scale 1
         rotate <0, 0, 0>
         translate <0, -4, -0.6>
      }
      
      box {
         <-6, 4, -1>, <lg+6, -4, -0>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   union {
      cylinder {
         <-6, 0, 0>, <lg+6, 0, 0>, 0.5
         scale 1
         rotate <0, 0, 0>
         translate <0, 0.5, -0.6>
      }
      
      cylinder {
         <-6, 0, 0>, <lg+6, 0, 0>, 0.5
         scale 1
         rotate <0, 0, 0>
         translate <0, -2.5, -0.6>
      }
   }
   texture {
      boisBoiserieFoncee
      rotate x*90
   }
}
#end

#macro moulureBiseautee(lg)
difference {
   moulureSimple(lg)

      box {
         <-10, -10, 1>, <0, 10, -4>
         scale 1
         rotate z*45
         translate <0, 0, 0>
      }
      
      box {
         <-10, -10, 1>, <0, 10, -4>
         scale 1
         rotate z*135
         translate x*lg
      }
   texture {
      boisBoiserieFoncee
      rotate x*90
   }
}
#end

#macro cadreMoulure(xmin,xmax,ymin,ymax)
object { // haut
   moulureBiseautee(xmax-xmin)
   rotate <0, 0, 0>
   translate <xmin, ymax, 0>
   }   
  object { //bas
   moulureBiseautee(xmax-xmin)
   rotate <0, 0, 180>
   translate <xmax, ymin, 0>
   }   
  object { // gauche
   moulureBiseautee(ymax-ymin)
   rotate <0, 0, 90>
   translate <xmin, ymin, 0>
   }   
  object { // droite
   moulureBiseautee(ymax-ymin)
   rotate <0, 0, -90>
   translate <xmax, ymax, 0>
   }   
#end

#macro fondBoiserie(xmin,xmax,ztr)
object {
    plancherRectSimple(xmin,xmax,0,300,rdBoiserie,0)
    rotate x*(-90)
    translate z*(ztr+0.5)
    }
#end

#macro panneau()
union {
 /* object {
    plancherRectSimple(0,150,0,300,rdBoiserie,0)
    rotate x*(-90)
    translate z*0.5
    }*/

  object {
    plancherRectSimple(50,100,0,200,rdBoiserie,1)
    rotate x*(-90)
    translate y*50
    }
  object {
   moulureSimple(150) // haute
   rotate <0, 0, 0>
   translate <0, 300, 0>
   }   
  cadreMoulure(15,135,25,275) 
  cadreMoulure(50,100,50,255) 
 }
#end

