#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define nbPhi 10
#define pi 3.1415926535
#define epsilon 1.0e-6
#define degre 4

double cnk[degre];
double memoireNormale[3];

int premiereTgt=0;
double premTgt[3];
double derTgt[3];
/* voile en mesh2

*/

uint premier=1;
  
double norme(double n[3]) {
  double lg=sqrt(n[0]*n[0]+n[1]*n[1]+n[2]*n[2]);
  return lg;
  }

void normer(double n[3]) {
  double lg=sqrt(n[0]*n[0]+n[1]*n[1]+n[2]*n[2]);
  n[0]=n[0]/lg;
  n[1]=n[1]/lg;
  n[2]=n[2]/lg;
  }
void oppose(double n[3]) {
  uint i;
  for (i=0;i<3;i++)
    n[i]=-n[i];
  }
  
void produitVectoriel(double n1[3],double n2[3],double n3[3]) {
  n3[0]=n1[1]*n2[2]-n1[2]*n2[1];
  n3[1]=n1[2]*n2[0]-n1[0]*n2[2];
  n3[2]=n1[0]*n2[1]-n1[1]*n2[0];
  }
  
void orthonormer(double n1[3],double n2[3]) {
  double scal=0.0;
  double norme=0.0;
  uint i;
  for (i=0;i<3;i++) {
    scal=scal+n1[i]*n2[i];
    norme=norme+n1[i]*n1[i];
    }
  for (i=0;i<3;i++)
    n2[i]=n2[i]-scal*n1[i]/norme;
  normer(n2);
  }
  
void combinaison(double res[3],double n0[3],double coef1, double n1[3],double coef2,double n2[3]) {
  uint i;
  for (i=0;i<3;i++) {
    res[i]=n0[i]+coef1*n1[i]+coef2*n2[i];
    }
  return;
  }
  
double calculCnk(int k) {
  double x;
  int n=degre-1;
  if (k==n) return 1;
  if (k>n) {
    printf("erreur cnk avec k=%d et n=%d\n",k,n);
    return 0.0;
    }
  uint i;
  x=1.0;
  for (i=n-k+1; i<=n;i++)
    x=x*i;
  for (i=1;i<k+1;i++)
    x=x/i;
  return x;
  }
  
double puissance(double x,int p,int q) {
   // calcul de x puissance p * (1-x) puissance q
  if (p<=0 && x < epsilon) return 1.0;
  if (q<=0 && (1-x) < epsilon) return 1.0;
  int i;
  double y=1.0;
  i=0;
  while (i<p) {
    y=y*x;
    i++;
    }
  i=0;
  while (i<q) {
    y=y*(1-x);
    i++;
    }
  return y;
  }
    
double bnk(int k, double cnk, double x) {
  int n=degre-1;
  double y=cnk*puissance(x,k,n-k);
  return y;
  }
  
double dbnk(int k, double cnk, double x) {
  int n=degre-1;
  return cnk*(k*puissance(x,k-1,n-k)-(n-k)*puissance(x,k,n-k-1));
  }

double d2bnk(int k, double cnk, double x) {
  int n=degre-1;
  double y;
  y=cnk*k*(k-1)*puissance(x,k-2,n-k);
  y=y-2.0*cnk*(n-k)*k*puissance(x,k-1,n-k-1);
  y=y-+cnk*(n-k)*(n-k-1)*puissance(x,k,n-k-2);
  return y;
  }
  
void positionBezier(double m[3],uint prem,double points[10][3],double t) {
  uint i,k;
  for (i=0;i<3;i++) {
    m[i]=0.0;
    for (k=0;k<degre;k++)
      m[i]=m[i]+bnk(k,cnk[k],t)*points[prem+k][i];  
    }
  }
  
void positionCh(double m[3],uint prem,double points[10][3],double t) {
  uint i,k;
  m[0]=points[prem][0]+t*(points[prem+3][0]-points[prem][0]);
  m[2]=points[prem][2]+t*(points[prem+3][2]-points[prem][2]);
  m[1]=points[prem][1]+(cosh(t)-cosh(0))*(points[prem+3][1]-points[prem][1])/(cosh(1.0)-cosh(0));
  }    
  
void deriveBezier(double m[3],uint prem,double points[10][3],double t) {
  uint i,k;
  for (i=0;i<3;i++) {
    m[i]=0.0;
    for (k=0;k<degre;k++) {
      m[i]=m[i]+dbnk(k,cnk[k],t)*points[prem+k][i];  
      // printf ("derivBz, indice %d, k:%d, t:%f,dbnk %f,points :%f\n",i,k,t,dbnk(k,cnk[k],t),points[prem+k][i]);
      }
    }
  }
  
void deriveCh(double m[3],uint prem,double points[10][3],double t) {
  m[0]=points[prem+3][0]-points[prem][0];
  m[2]=points[prem+3][2]-points[prem][2];
  m[1]=sinh(t)*(points[prem+3][1]-points[prem][1])/(cosh(1.0)-cosh(0));
  }
  
void deriveSecondeBezier(double m[3],uint prem,double points[10][3],double t) {
  uint i,k;
  for (i=0;i<3;i++) {
    m[i]=0.0;
    for (k=0;k<degre;k++) {
      m[i]=m[i]+d2bnk(k,cnk[k],t)*points[prem+k][i];  
      // printf ("derivBz, indice %d, k:%d, t:%f,dbnk %f,points :%f\n",i,k,t,dbnk(k,cnk[k],t),points[prem+k][i]);
      }
    }
  }

void derivesBezier(double tgt[3],double n1[3],double n2[3],uint prem,double points[10][3],double t) {
  deriveBezier(tgt,prem,points, t);
  deriveSecondeBezier(n1,prem,points, t);
  orthonormer(tgt,n1);
  uint i;
  for (i=0;i<2;i++) {
    memoireNormale[i]=n1[i];
    }
  produitVectoriel(tgt,n1,n2);
  normer(n2);
  }  
    
void derivesCh(double tgt[3],double n1[3],double n2[3],uint prem,double points[10][3],double t) {
  deriveBezier(tgt,prem,points, t);
  n1[0]=memoireNormale[0];
  n1[1]=memoireNormale[1];
  n1[2]=memoireNormale[2];
  orthonormer(tgt,n1);
  produitVectoriel(tgt,n1,n2);
  normer(n2);
  }       
 /*  
void normalesBezier(double tgt[3],double n1[3],double n2[3]) {
  double tp=tgt[0]*tgt[0]+tgt[1]*tgt[1];
  if (tp < epsilon) {
    if (normaleBezierPrecFlag==1)
      printf("pb d'initialisation normale Bezier\n");
    n1[0]=normaleBezierPrec[0];
    n1[1]=0.0;
    n1[2]=0.0;
    }
  else {
    n1[0]=-tgt[1];
    n1[1]=tgt[0];
    n1[2]=0.0;
    normaleBezierPrec[0]=n1[0];
    normaleBezierPrecFlag=0;
    }
  normer(n1);
  produitVectoriel(tgt,n1,n2);
  normer(n2);
  } */

 void ecritPointBezier(FILE *file,uint prem,double points[10][3],double t,double rayonSphere) {
  double m[3];
  positionBezier(m,prem,points,t) ;
  fprintf(file," <%f,%f,%f> %f \n",m[0],m[1],m[2],rayonSphere);
  }
  
  void ecritPointCh(FILE *file,uint prem,double points[10][3],double t,double rayonSphere) {
  double m[3];
  positionCh(m,prem,points,t) ;
  fprintf(file," <%f,%f,%f> %f \n",m[0],m[1],m[2],rayonSphere);
  }
  
void ecritPointHelice(FILE *file,uint prem,double points[10][3],double t,double rayonHelice,double theta,double rayonSphere) {
  double m[3],tgt[3],n1[3],n2[3],m2[3];
  positionBezier(m,prem,points,t) ;
  derivesBezier(tgt,n1,n2,prem,points, t);
  //normalesBezier(tgt,n1,n2);
  combinaison(m2,m,rayonHelice*cos(theta),n1,rayonHelice*sin(theta),n2);
  /*
  printf("t=%f, x=%f, y=%f,z=%f, tourn de %f => %f,%f,%f\n",t,m[0],m[1],m[2],theta,m2[0],m2[1],m2[2]);
  printf("tgte %f,%f,%f\n",tgt[0],tgt[1],tgt[2]);
  printf("n1 %f,%f,%f\n",n1[0],n1[1],n1[2]);
  printf("n2 %f,%f,%f\n",n2[0],n2[1],n2[2]);
  printf("cos= %f, sin=%f\n",cos(theta),sin(theta));
  
  fprintf(file,"sphere { <%f,%f,%f> %f texture {test}}\n",m[0],m[1],m[2],rayonSphere/2.0);
  fprintf(file,"sphere { <%f,%f,%f> %f}\n",m2[0],m2[1],m2[2],rayonSphere); */
  
  fprintf(file," <%f,%f,%f> %f \n",m2[0],m2[1],m2[2],rayonSphere);
  }
  
void ecritPointHeliceCh(FILE *file,uint prem,double points[10][3],double t,double rayonHelice,double theta,double rayonSphere) {
  double m[3],tgt[3],n1[3],n2[3],m2[3];
  positionCh(m,prem,points,t) ;
  derivesCh(tgt,n1,n2,prem,points, t);
  //normalesBezier(tgt,n1,n2);
  combinaison(m2,m,rayonHelice*cos(theta),n1,rayonHelice*sin(theta),n2);
  /*
  printf("t=%f, x=%f, y=%f,z=%f, tourn de %f => %f,%f,%f\n",t,m[0],m[1],m[2],theta,m2[0],m2[1],m2[2]);
  printf("tgte %f,%f,%f\n",tgt[0],tgt[1],tgt[2]);
  printf("n1 %f,%f,%f\n",n1[0],n1[1],n1[2]);
  printf("n2 %f,%f,%f\n",n2[0],n2[1],n2[2]);
  printf("cos= %f, sin=%f\n",cos(theta),sin(theta));
  
  fprintf(file,"sphere { <%f,%f,%f> %f texture {test}}\n",m[0],m[1],m[2],rayonSphere/2.0);
  fprintf(file,"sphere { <%f,%f,%f> %f}\n",m2[0],m2[1],m2[2],rayonSphere); */
  
  fprintf(file," <%f,%f,%f> %f \n",m2[0],m2[1],m2[2],rayonSphere);
  }
  
void parcoursBezier(FILE *file,int *nbSphere, uint prem,double points[10][3],double rayonSphere) {  
  double s=0;
  double petitPas;
  double pas;
  double t=0.0;
  double tgt[3];
  double f1,f2;
  uint i;
  printf("debut de parcours, nbsphere=%d\n",*nbSphere);
  for (i=0;i<3;i++) {
    tgt[i]=points[prem+3][i]-points[prem][i];
    }
  pas=norme(tgt)/10.0;
  petitPas=pas/10.0;
  printf("pas parcours,pas=%f petitPas=%f\n",pas,petitPas);
  ecritPointBezier(file,prem,points, t, rayonSphere);
  *nbSphere=*nbSphere+1;
  deriveBezier(tgt,prem,points, t);
  f1=norme(tgt);
  t=t+0.01;
  while (t<1.0) {
    printf("bcle parcours, t=%f\n",t);
    deriveBezier(tgt,prem,points, t);
    f2=norme(tgt);
    s=s+(f1+f2)/2.0;
    f1=f2;
    printf("\t, s=%f\n",s);
    if (s > petitPas) {
      ecritPointBezier(file,prem,points, t, rayonSphere);
      *nbSphere=*nbSphere+1;
      s=0.0;
      }
    t=t+0.01;
    }
  printf("fin de parcours, nbsphere=%d\n",*nbSphere);
  }
  
 void parcoursCh(FILE *file,int *nbSphere, uint prem,double points[10][3],double rayonSphere) {  
  double s=0;
  double petitPas;
  double pas;
  double t=0.0;
  double tgt[3];
  double f1,f2;
  uint i;
  printf("debut de parcours ch, nbsphere=%d\n",*nbSphere);
  fprintf(file,"/* debut de parcours ch, nbsphere=%d*/\n",*nbSphere);
    tgt[0]=points[prem+3][0]-points[prem][0];
    tgt[2]=points[prem+3][2]-points[prem][2];

  pas=norme(tgt)/10.0;
  petitPas=pas/10.0;
  printf("pas parcours,pas=%f petitPas=%f\n",pas,petitPas);
  ecritPointCh(file,prem,points, t, rayonSphere);
  *nbSphere=*nbSphere+1;
  deriveCh(tgt,prem,points, t);
  f1=norme(tgt);
  t=t+0.01;
  while (t<1.0) {
    printf("bcle parcours, t=%f\n",t);
    deriveCh(tgt,prem,points, t);
    f2=norme(tgt);
    s=s+(f1+f2)/2.0;
    f1=f2;
    printf("\t, s=%f\n",s);
    if (s > petitPas) {
      ecritPointCh(file,prem,points, t, rayonSphere);
      *nbSphere=*nbSphere+1;
      s=0.0;
      }
    t=t+0.01;
    }
  printf("fin de parcours, nbsphere=%d\n",*nbSphere);
  } 

void parcoursBezierHelice(FILE *file,int *nbSphere, uint prem,double points[10][3],double rayonHelice,double pasHelice,double *theta0,double rayonSphere) {  
  double s=0;
  double petitPas;
  double pas;
  double t=0.0;
  double tgt[3];
  double theta=*theta0;
  double f1,f2;
  uint i;
  //printf("debut de parcours, nbsphere=%d\n",*nbSphere);
  for (i=0;i<3;i++) {
    tgt[i]=points[prem+3][i]-points[prem][i];
    }
  pas=pasHelice/5.0;
  petitPas=0.01;
  ecritPointHelice(file,prem,points, t, rayonHelice, theta,rayonSphere);
  *nbSphere=*nbSphere+1;
  deriveBezier(tgt,prem,points, t);
  if (premiereTgt==0) {
    for (i=0;i<3;i++) {
      premTgt[i]=tgt[i];
      }
    premiereTgt=1;
    }
  f1=norme(tgt);
  t=t+petitPas;
  while (t<1.0) {
    //printf("bcle parcours, t=%f\n",t);
    deriveBezier(tgt,prem,points, t);
    f2=norme(tgt);
    s=s+(f1+f2)/2.0;
    f1=f2;
   // printf("\t, s=%f\n",s);
    if (s > pas/petitPas) {
      theta=theta -s*petitPas/pasHelice*2.0*pi;
      ecritPointHelice(file,prem,points, t, rayonHelice, theta,rayonSphere);
      *nbSphere=*nbSphere+1;
      s=0.0;
      }
    t=t+petitPas;
    }
  *theta0=theta -s*petitPas/pasHelice*2.0*pi;
  //printf("fin de parcours, nbsphere=%d\n",*nbSphere);
  }
  
void parcoursChHelice(FILE *file,int *nbSphere, uint prem,double points[10][3],double rayonHelice,double pasHelice,double *theta0,double rayonSphere) {  
  double s=0;
  double petitPas;
  double pas;
  double t=0.0;
  double tgt[3];
  double theta=*theta0;
  double f1,f2;
  uint i;
  //printf("debut de parcours, nbsphere=%d\n",*nbSphere);
  for (i=0;i<3;i++) {
    tgt[i]=points[prem+3][i]-points[prem][i];
    }
  pas=pasHelice/5.0;
  petitPas=0.01;
  ecritPointHeliceCh(file,prem,points, t, rayonHelice, theta,rayonSphere);
  *nbSphere=*nbSphere+1;
  deriveCh(tgt,prem,points, t);
  f1=norme(tgt);
  t=t+petitPas;
  while (t<1.0) {
    //printf("bcle parcours, t=%f\n",t);
    deriveCh(tgt,prem,points, t);
    f2=norme(tgt);
    s=s+(f1+f2)/2.0;
    f1=f2;
   // printf("\t, s=%f\n",s);
    if (s > pas/petitPas) {
      theta=theta -s*petitPas/pasHelice*2.0*pi;
      ecritPointHeliceCh(file,prem,points, t, rayonHelice, theta,rayonSphere);
      *nbSphere=*nbSphere+1;
      s=0.0;
      }
    t=t+petitPas;
    }
  // t=1 =>  
    deriveCh(tgt,prem,points, 1.0);
    f2=norme(tgt);
    s=s+(f1+f2)/2.0;
    f1=f2;
   // printf("\t, s=%f\n",s);
   
      theta=theta -s*petitPas/pasHelice*2.0*pi;
      ecritPointHeliceCh(file,prem,points, 1.0, rayonHelice, theta,rayonSphere);
      *nbSphere=*nbSphere+1;
   
  *theta0=theta -s*petitPas/pasHelice*2.0*pi;
  for (i=0;i<3;i++) {
    derTgt[i]=tgt[i];
    }
  //printf("fin de parcours, nbsphere=%d\n",*nbSphere);
  }  
 /*
  * ecrit une simple sphere sweep, le long de la corde, pour mise au point des coordonnes des pt de controle
  *
  */
 void corde0() {
  uint i,k;
  FILE *file1,*file2,*filet;
  char *fichier1="cordelisse.inc";
  char *fichier2="cordett.inc";
  char *fichiert="cordetest.inc";
  for (k=0;k<degre;k++) {
    cnk[k]=calculCnk(k);
    }
 
   
  double rayonSphere=6.0;
  
  int prem;
  double points[10][3];
  if ((file2=fopen(fichier2, "wb"))== NULL)
  	{
	fprintf(stderr, "Erreur ouverture de %s\n",fichier2);
	exit(1);
	}
  if ((filet=fopen(fichiert, "wb"))== NULL)
  	{
	fprintf(stderr, "Erreur ouverture de %s\n",fichiert);
	exit(1);
	}	
  int nbSphere;
  
  nbSphere=0;

  if ((file1=fopen(fichier1, "wb"))== NULL)
  	{
	fprintf(stderr, "Erreur ouverture de %s\n",fichier1);
	exit(1);
	}
  points[0][0]=-90.0; 
  points[0][1]=  rayonSphere; 
  points[0][2]=200.0; 
  
  points[3][0]= 30.0; 
  points[3][1]=  rayonSphere; 
  points[3][2]=220.0;
   
  points[6][0]=150.0; 
  points[6][1]=100.0; 
  points[6][2]=320.0; 
  
 
  points[1][0]=-50.9242; 
  points[1][1]=  rayonSphere; 
  points[1][2]=177.874; 
  
  double tgt[3];
  for (i=0;i<3;i++) {
    tgt[i]=points[6][i]-points[3][i];
    }
  tgt[1]=0.0;
  normer(tgt);
  for (i=0;i<3;i++) {
    points[2][i]=points[3][i]-30*tgt[i]; 
    }
  /* 
  points[2][0]=14.8021; 
  points[2][1]=  rayonSphere; 
  points[2][2]=208.548; 
  */
  points[4][0]=55.3915; 
  points[4][1]=  rayonSphere; 
  points[4][2]=243.08; 
  
  
  points[5][0]=130.433; 
  points[5][1]= 81.8177; 
  points[5][2]=304.68; 
 /*

  double tgt[3];
  for (i=0;i<3;i++) {
    points[1][i]=points[0][i]; 
    tgt[i]=points[6][i]-points[3][i];
    }
  normer(tgt);
  
  for (i=0;i<3;i++) {
    points[2][i]=points[3][i]-tgt[i]; 
    points[4][i]=points[3][i]+tgt[i]; 
    points[5][i]=points[6][i]-tgt[i]; 
    }
  points[1][0]=points[01][0]+1;    
  points[2][1]=points[3][1];
  points[4][1]=points[3][1];
  points[5][1]=points[5][1]-tgt[i]; // pente y *2
  */
  fprintf(filet,"union { \n");  
  for (i=0;i<7;i++) {
    fprintf(filet," sphere {<%f,%f,%f> %f }\n",points[i][0],points[i][1],points[i][2],rayonSphere);
    }
  fprintf(filet," } \n");  
  fclose(filet);
  
  uint premPt;
 // for (i=0;i<2;i++) {
    premPt=0;
    //printf("avant parcours, nbsphere=%d\n",nbSphere);
    parcoursBezier(file1,&nbSphere,premPt, points,rayonSphere);
    premPt=3;
    //printf("avant parcours, nbsphere=%d\n",nbSphere);
    parcoursCh(file1,&nbSphere,premPt, points,rayonSphere);
 //   } //parcoursBezier(FILE *file,int *nbSphere, uint prem,double points[10][3],double rayonSphere) {  
    

  fprintf(file2,"sphere_sweep { cubic_spline %d, \n",nbSphere);  
  fprintf(file2,"#include \"/home/vincent/Documents/kpov/museum/%s\" \n",fichier1);  
  fprintf(file2," } \n");  
  fclose(file1);
  fclose(file2);
  }
   
void corde1() {
  uint i,k;
  FILE *file1,*file2;
  char fichier1[20];
  char *fichier2="cordett.inc";
  for (k=0;k<degre;k++) {
    cnk[k]=calculCnk(k);
    }
 
  
  double rayonHelice=2.5; //rayonHelice=0.0;
  double pasHelice=50.0;
  double theta0;
  double rayonSphere=1.0;
  double hauteur=rayonHelice+rayonSphere;
  //double dx,dy,dz,lg,x,y,z;
  
 /* for (i=0;i<2;i++) {
    printf ("point origine %d en %f,%f,%f\n",i,pto[i][0],pto[i][1],pto[i][2]);
    } */
  int prem;
  double tgte[3];  
  double n1[3];
  double n2[3];
  double coef;
  double points[10][3];
  if ((file2=fopen(fichier2, "wb"))== NULL)
  	{
	fprintf(stderr, "Erreur ouverture de %s\n",fichier2);
	exit(1);
	}
points[0][0]=-90.0; 
  points[0][1]=  hauteur; 
  points[0][2]=200.0; 
  
  points[3][0]= 30.0; 
  points[3][1]=  hauteur; 
  points[3][2]=220.0;
   
  points[6][0]=150.0; 
  points[6][1]=100.0; 
  points[6][2]=320.0; 
  
 
  points[1][0]=-50.9242; 
  points[1][1]=  hauteur; 
  points[1][2]=177.874; 
  
  double tgt[3];
  for (i=0;i<3;i++) {
    tgt[i]=points[6][i]-points[3][i];
    }
  tgt[1]=0.0;
  normer(tgt);
  for (i=0;i<3;i++) {
    points[2][i]=points[3][i]-30*tgt[i]; 
    }
  /* 
  points[2][0]=14.8021; 
  points[2][1]=  rayonSphere; 
  points[2][2]=208.548; 
  */
  points[4][0]=55.3915; 
  points[4][1]=  hauteur; 
  points[4][2]=243.08; 
  
  
  points[5][0]=130.433; 
  points[5][1]= 81.8177; 
  points[5][2]=304.68; 	
  int indToron;
  int nbSphere;
  int nbTorons=8;
  for (indToron=0;indToron<nbTorons;indToron++) {
  //indToron=0; {
  theta0=2*3.14159/nbTorons*indToron;
  nbSphere=0;
  sprintf(fichier1,"corde%1d.inc",indToron);
  if ((file1=fopen(fichier1, "wb"))== NULL)
  	{
	fprintf(stderr, "Erreur ouverture de %s\n",fichier1);
	exit(1);
	}
  
  /*
  for (i=0;i<10;i++) {
    printf ("point %d en %f,%f,%f\n",i,points[i][0],points[i][1],points[i][2]);
    } */

  uint premPt;
 // for (i=0;i<3;i++) {
    premPt=0;
    //printf("avant parcours, nbsphere=%d\n",nbSphere);
    parcoursBezierHelice(file1,&nbSphere,premPt, points, rayonHelice, pasHelice, &theta0,rayonSphere);
    premPt=3;
    //printf("avant parcours, nbsphere=%d\n",nbSphere);
    parcoursChHelice(file1,&nbSphere,premPt, points, rayonHelice, pasHelice, &theta0,rayonSphere);
    printf("theta final %f\n",theta0);
  //  }
    

  fprintf(file2,"sphere_sweep { cubic_spline %d, \n",nbSphere);  
  fprintf(file2,"#include \"/home/vincent/Documents/kpov/museum/%s\" \n",fichier1);  
  fprintf(file2," } \n");  
  fclose(file1);
  } //fin bcl indToron
  fclose(file2);
  }
  
void embout() {
  char *fichier="cordeEmbout.inc";
  FILE *file1;
  if ((file1=fopen(fichier, "wb"))== NULL)
  	{
	fprintf(stderr, "Erreur ouverture de %s\n",fichier);
	exit(1);
	}
  normer(premTgt);
  printf (" tangente : %f %f %f\n",premTgt[0],premTgt[1],premTgt[2]);
  double thx=-asin(premTgt[1])*180.0/pi;
  double thy=90.0-atan(premTgt[2]/premTgt[0])*180.0/pi;
  printf (" th : %f %f\n",thx,thy);
  fprintf(file1," object { boutCorde rotate < %f, %f,0> translate <-90, 3.5, 200>}\n",thx,thy);
  
   normer(derTgt);
  printf (" tangente : %f %f %f\n",derTgt[0],derTgt[1],derTgt[2]);
   thx=asin(derTgt[1])*180.0/pi;
   thy=180.0+atan(derTgt[2]/derTgt[0])*180.0/pi;
  printf (" th : %f %f\n",thx,thy);
  fprintf(file1," object { boutCorde rotate < %f, %f,0> translate <150, 100, 320>}\n",thx,thy);

  }
  
int main(int argc,char **argv) {
  corde1();  
  embout();
  }

