// Persistence Of Vision Ray Tracer Include File
// File: sky.inc
// Vers: 3.5
// Desc: sky for 'balcony.pov' demonstration scene
// Date: July/August 2001
// Auth: Christoph Hormann

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
// plein de modif
// remplacement z par y 
// ajout du rose / soleil 

#version 3.5;


#declare rotationSoleil=5;

#macro brume(coul1,coul2,trsp)

  pigment {
  color rgb coul2 transmit trsp
    /*
      function { abs(y) }
     //gradient y
     color_map {
       [0.0 color rgb coul1 transmit trsp]
       [0.3 color rgb coul2 transmit trsp]
     }
     turbulence 0.05 */
   }

#end


#macro nuages1(coul1,coul2,trsp)
  pigment {
   gradient y
   pigment_map {
     [ 0.0 color rgbt 1]
     [ 0.1
       bozo
       color_map {
         [0.0 color rgb coul1 transmit trsp]
         [0.15 color rgb coul2 transmit trsp]
         [0.35 color rgb coul2 transmit 1.0]
       }
       turbulence 0.75
       lambda 2.4
       omega 0.6
       octaves 8
       scale <0.4,0.15,0.4>
     ]
     [ 0.4
       bozo
       color_map {
         [0.0 color rgb coul1 transmit trsp]
         [0.15 color rgb coul2 transmit trsp]
         [0.35 color rgb coul2 transmit 1.0]
       }
       turbulence 0.75
       lambda 2.4
       omega 0.6
       octaves 8
       scale <0.4,0.15,0.4>
     ]
     [ 0.65 color rgbt 1]

   }
  // rotate 10*y

  }

#end

#macro nuagesPigment(coul1,coul2,trsp)
   wrinkles
   turbulence <0.1, 0.1, 0.1>
   omega 0.707
   lambda 2.2

   color_map {
      [ 0 coul1 transmit trsp
      ]
      [ 0.2 color rgbt 1
      ]
      [ 0.4 color rgbt 1
      ]
      [ 0.7 coul2  transmit trsp
      ]
      [ 1 coul1  transmit trsp
      ]
   }
   scale <1, 0.85, 1>
   rotate <90, 45, 90>
   rotate z*(rotationSoleil)
#end

#macro nuages(coul1,coul2,trsp)

  pigment {
   wrinkles
   turbulence <0.1, 0.1, 0.1>
   omega 0.707
   lambda 2.2

   color_map {
      [ 0 coul1 transmit trsp
      ]
      [ 0.2 color rgbt 1
      ]
      [ 0.4 color rgbt 1
      ]
      [ 0.7 coul2  transmit trsp
      ]
      [ 1 coul1  transmit trsp
      ]
   }
   scale <1, 0.85, 1>
   rotate <90, 45, 90>
  }


#end

#declare rgeSoleil = color rgb <0.760784, 0.101961, 0.0431373>;
#declare rgeSoleilTexture=nuages(rgeSoleil,rgeSoleil,0);
/*#declare rgeSoleil = pigvar(0.4);
#declare rge2 = pigvar(0.9);
#declare rge5 = pigvar(1);
#declare rge1 = pigvar(1);
#declare rgeSoleilTrsp =
texture {
   radial
   texture_map {
    [0 nuages(rgeSoleil,rgeSoleil, 0.4) ]
    [0.2 nuages(rgeSoleil,rgeSoleil,0.4)]
    [0.3 nuages(rgeSoleil,rgeSoleil, 0.4)]
    [0.5 nuages(rgeSoleil,rgeSoleil, 0.4)]
    [0.7 nuages(rgeSoleil,rgeSoleil, 0.4)]
    [0.8 nuages(rgeSoleil,rgeSoleil, 0.4)]
    [1 nuages(rgeSoleil,rgeSoleil,0.4)]
    }
  }
*/
// #local P_Clouds=nuages1(ciel_nuages_gris,ciel_nuages_blanc,0.0);

#declare ciel_nuages_gris_fonce= color rgb <0.41569, 0.41569, 0.41569> ;
#declare ciel_nuages_gris= color rgb < 0.85, 0.88, 0.94> ;
#declare ciel_nuages_blanc= color rgb < 0.91, 0.96, 0.99>;
#declare ciel_bleu_0= color rgb < 0.640, 0.685, 0.800 > ;
#declare ciel_bleu_azi= color rgb < 0.400, 0.550, 0.900 > ;



sphere {
  <0, 0, 0>, 1
  texture {
  brume(ciel_bleu_0,ciel_bleu_azi,0.0)
  finish {
     diffuse 0
     ambient 1
   }
  }
  texture {
  //nuages1(ciel_nuages_gris,ciel_nuages_blanc,0.0)
  nuages(ciel_nuages_gris_fonce,ciel_nuages_blanc,0.)
  finish {
     diffuse 0
     ambient 1
   }
  }
  texture {
  pigment {
   radial
   pigment_map {
   /*
    [0 color rgbt <1.0,0.0,0.0,0.4> ]
    [0.5 color rgbt <1.0,0.0,0.0,0.4>]
    [1 color rgbt <1.0,0.0,0.0,0.4>]
    */
    [0 nuagesPigment(rgeSoleil,rgeSoleil, 0.4) ]
    [0.2 nuagesPigment(rgeSoleil,rgeSoleil,0.4)]
    [0.3 nuagesPigment(rgeSoleil,rgeSoleil, 0.8)]
    [0.5 nuagesPigment(rgeSoleil,rgeSoleil, 1.0)]
    [0.7 nuagesPigment(rgeSoleil,rgeSoleil, 0.8)]
    [0.8 nuagesPigment(rgeSoleil,rgeSoleil, 0.4)]
    [1 nuagesPigment(rgeSoleil,rgeSoleil,0.2)]

    }
    rotate z*(-rotationSoleil)
   }
   finish {
     diffuse 0
     ambient 1
   }
  }

  scale<1000000, 300000, 1000000>
  no_shadow
  hollow on
  photons{ collect off }
}

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
