 ////////////////////////////////
// Name: Dry Run                //
// Vers: 3.5                    //
// Desc: Out Of Place Entry     //
// Auth: Allen Dotson           //
 ////////////////////////////////
 
//INCLUDE FILES//
#include "colors.inc"
#include "stones.inc"
#include "skies.inc"
#include "finish.inc"
#include "textures.inc"
#include "functions.inc"
#include "metals.inc"
//END INCLUDES//

//WHAT TO SHOW//
#declare sub = 1;
#declare rad = 1;
#declare dust = 1;
#declare sand = 1;
#declare skysphere = 1;
#declare moon = 1;
#declare pyramids = 0; //Not Yet Implemented
//END WHAT TO SHOW//

//START DECLARATIONS//
#declare sandtext = 
   texture  // txt_133
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.86, 0.82, 0.67, 0.0, 0.0> ]
            [ 0.5     rgbft <0.91, 0.87, 0.71, 0.0, 0.0> ]
            [ 1.0     rgbft <0.86, 0.84, 0.59, 0.0, 0.0> ]
         }
         turbulence 0.7
         ramp_wave
      }   
      normal
      {
         bumps , 0.1
         scale  0.2
      }   
      finish
      {
         ambient 0.3
         diffuse 1.0
         specular 0.5
         roughness 0.01
         crand 0.25
         reflection
         {
            0.11 , 0.11
            fresnel  off
            falloff  1.0
            exponent 1.0
            metallic 0.0
         }
      }
   }
   texture  // txt_134
   {   
      pigment
      {
         color rgbf <1.0, 1.0, 1.0, 1.0>
      }   
      finish
      {
         ambient 0.0
         brilliance 1.5
         phong 0.9
         phong_size 80.0
      }
   }

#declare SandstP = 
   material  // SandstP
   {   
      texture { sandtext }
   }
   
#declare shipcolor = texture { pigment { color NavyBlue*0.6 } finish { reflection 0.1 } }   
//END DECLARATIONS//
                
//START CAMERA//                
camera { location <2,3,-5> look_at <0,-100,1000> 
rotate y*170}
//END CAMERA//

//START SUB//
#if (sub = 1)
union { object { #include "sub.inc" }
scale .5
rotate y*-190
translate x*-6
translate y*-2.5 
translate z*-25 
 }
#end
//END SUB//

//START ENVIRONMENT//
#if (skysphere = 1)
sphere {
   <0, 0, 0>, 1
   texture {
      pigment {
         gradient z
         pigment_map {
            [0.00 color rgb <0.6667, 0.7255, 0.7725>]
            [0.19
               spherical
               color_map {
                  [0.08 color rgb <0.33, 0.37, 0.90> ]
                  [0.14 color rgb <0.3210, 0.53, 0.9259> ]
                  [0.26 color rgb <0.3610, 0.57, 0.9259> ]
                  [0.50 color rgb < 0.880, 0.935, 0.976 > ]
               }
               scale 1.8
               translate <-0.7, 0.7, 0.24>
            ]
         } 
      }
      finish {
         diffuse 0
         ambient 1
      }
   }
   scale 50000*<20, 20, 4>
   translate -2*z
   no_shadow
   hollow on
   rotate y*180
}
#end

#if (sand = 1)
union { object { #include "sand.inc" } }
#end

#if (dust = 1)
fog {
  fog_type   2
  distance   20
  color rgb < 1, 0.9, 0.65>*0.8
  fog_offset 0.4
  fog_alt    0.4
  turbulence 5
}
#end

#if (moon = 1)
plane {z,0 hollow
  pigment {image_map {tga "moon_alpha.tga" interpolate 2 once} translate <0,0,0>} 
  finish {ambient 1.2 diffuse 0}  
  scale 2500
  translate 5000*z
  translate 700*x
  translate -1000*y
  rotate y*180 
}  
#end
//END ENVIRONMENT//

//START PYRAMIDS//
#if (pyramids = 1)
union { object { #include "pyramids.inc" }
scale .5
rotate y*-190
translate x*-6
translate y*-2.5 
translate z*-25 
 }
#end
//END PYRAMIDS//

//START LIGHTING//
light_source {
  0*x                 // light's position (translated below)
  color rgb 1.0       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <40, 80, -40>*20   // <x y z> position of light
}
//END LIGHTING//

//RADIOSITY//
#if (rad = 1)
global_settings {
  radiosity {
    pretrace_start 0.90           // start pretrace at this size
    pretrace_end   0.02           // end pretrace at this size
    count 150                      // higher -> higher quality (1..1600) [35]
    nearest_count 8               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
  }
}
#end
//END RADIOSITY//