 ////////////////////////////////
// Name: United Federation Navy //
// Vers: 3.5                    //
// Desc: Out Of Place Entry     //
// Auth: Allen Dotson           //
 ////////////////////////////////

//INCLUDE FILES//
#include "colors.inc"
#include "stones.inc"
#include "skies.inc"
#include "finish.inc"
#include "textures.inc"
#include "functions.inc"
#include "metals.inc"
//END INCLUDES//

//WHAT TO SHOW//
#declare rad = 1;
#declare ships = 1;
#declare flare = 1;
#declare carrier = 1;
#declare ufn = 1;
#declare ufnlights = 0; //Not Yet Implimented
#declare planet = 1;
//END THE SHOW//

//CAMERA AND FLARE STUFF//                   
#declare sky_vect = y;
#declare cam_loc = <0,25,-60>;
#declare lookat = <0,0,0>;
#declare light_loc = <-25, 20, 5>;
#declare flare_brightness = 1;
#max_trace_level 30

#declare cam_loc = vrotate(cam_loc, <0, -25, 0>);
//END CAM AND FLARE//

//CAMERA//
camera 
{
	location cam_loc
	look_at lookat
	sky sky_vect
}
//END CAM//

//LIGHTING//
light_source {
  0*x                 // light's position (translated below)
  color rgb 0.8       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  12, 12                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 8          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <-25, 20, 5>   // <x y z> position of light
}  

light_source {
  0*x                 // light's position (translated below)
  color rgb 0.8       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  2, 2                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 8          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <40, 80, -40>*200   // <x y z> position of light
}
//END LIGHTING//

//AIRCRAFT CARRIER//
#if (carrier = 1)
object { #include "carriermesh.inc" scale x*-1
scale .2 }
#end
//END CARRIER//

//ROWS OF SHIPS//
#if (ships = 1)
union {
object { #include "falconrow.inc" 
translate <0,0,0> }
object { #include "falconrow.inc" 
translate <0,0,20> } 
object { #include "falconrow.inc" 
translate <0,0,-20> }
translate z*-10
}
union {
object { #include "falconrow.inc" 
translate <0,0,0> }
object { #include "falconrow.inc" 
translate <0,0,20> } 
translate z*-10
translate x*8
}
//END ROWS//

//FALCONS//
//One Falcon
#declare thrust = 1;
#declare lights = 1;
#declare sthrust = <1,1,1>;
object { #include "falconmesh.inc" rotate y*15
rotate z*-20
rotate x*0 
translate y*9
translate y*6
 }
//End Falcon
//One Falcon 
#declare thrust = 1;
#declare lights = 1;
#declare sthrust = <1,1,1>;
object { #include "falconmesh.inc" rotate y*15
rotate z*-40
rotate x*0
rotate y*5 
translate y*9
translate y*6
translate z*20
 }
//End Falcon
//One Falcon
#declare thrust = 1;
#declare lights = 1;
#declare sthrust = <1,1,1>;
object { #include "falconmesh.inc" rotate y*15
rotate z*-45
rotate x*0
rotate y*20 
translate y*9
translate y*6
translate x*10
translate z*60
 }
//End Falcon
//One Falcon On Deck
#declare thrust = 1;
#declare lights = 1;
#declare sthrust = <1,1,1>;
object { #include "falconmesh.inc"
translate y*9
rotate y*-20
translate <-2,0,-35>
translate y*1 }


//End Falcon 
#end
//END OF FALCONS//

  
//STARFIELD//
   #declare star_count = 2000;
   #declare star_scale = .5;
   #include "GALAXY.SF"

   #declare galaxy_seed = 1;
   #declare star_count = 500;
   #declare star_type = 4;
   #declare star_colour = <1, .9, .7>;
   #declare star_scale = .5;
   #include "GALAXY.SF"
   
#declare galaxy_declare_only = true;
#include "GALAXY.BG"
//END STARFIELD//

//LENS FLARE//   
#if (flare = 1)
#include "space3.flr"
#include "nkflare.inc"
#end
//END FLARE//

//UNITED FEDERATION NAVY//
#if (ufn = 1)
text {
  ttf
  "FINALNEW.TTF",
  "United Federation Navy",
  2,
  0
  texture { T_Chrome_5B }
  scale 3
  rotate y*-90
  rotate y*9
  translate y*3
  translate z*-40
  translate x*0.6
}
#end
//END UNITED FEDERATION NAVY//

//UFN LIGHTS//
#if (ufnlights = 1)

#end
//END LIGHTS//

//RADIOSITY//   
#if (rad = 1)
global_settings {
  radiosity {
    pretrace_start 0.90           // start pretrace at this size
    pretrace_end   0.02           // end pretrace at this size
    count 150                      // higher -> higher quality (1..1600) [35]
    nearest_count 8               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
  }
}
#end
//END RADIOSITY//

//PLANET//
#if (planet = 1)
#include "planet.inc"

//Land&Ocean
sphere { <0, 0, 0>, 200
    texture { LandArea scale 250 }
    texture { OceanArea scale 250 }
translate z*1000
translate y*-600
translate x*100 }

//Clouds
sphere { <0, 0, 0>, 205
    texture { CloudArea scale 300 }
translate z*1000
translate y*-600
translate x*100 }
#end
//END PLANET//