global_settings {
   adc_bailout 0.0039216
   ambient_light rgb <0.3, 0.3, 0.3>
   assumed_gamma 1.7
   noise_generator 2
   
   radiosity {
      always_sample off
      normal on
      pretrace_end 0.02
   }
}

#declare T_Starfield = texture {
   pigment {
      granite
      turbulence <1, 1, 1>
      
      color_map {
         [ 0 color rgb <0, 0, 0>
         ]
         [ 0.27 color rgb <0, 0, 0>
         ]
         [ 0.27 color rgb <0.5, 0.5, 0.4>
         ]
         [ 0.28 color rgb <0.8, 0.8, 0.4>
         ]
         [ 0.28 color rgb <0, 0, 0>
         ]
         [ 0.47 color rgb <0, 0, 0>
         ]
         [ 0.47 color rgb <0.4, 0.4, 0.5>
         ]
         [ 0.48 color rgb <0.4, 0.4, 0.8>
         ]
         [ 0.48 color rgb <0, 0, 0>
         ]
         [ 0.68 color rgb <0, 0, 0>
         ]
         [ 0.68 color rgb <0.5, 0.4, 0.4>
         ]
         [ 0.69 color rgb <0.8, 0.4, 0.4>
         ]
         [ 0.69 color rgb <0, 0, 0>
         ]
         [ 0.88 color rgb <0, 0, 0>
         ]
         [ 0.88 color rgb <0.5, 0.5, 0.5>
         ]
         [ 0.89 color rgb <1, 1, 1>
         ]
         [ 0.89 color rgb <0, 0, 0>
         ]
         [ 1 color rgb <0, 0, 0>
         ]
      }
      frequency 0.07
      phase 2
      sine_wave
      scale 1500
   }
   
   finish {
      ambient rgbft <1, 1, 1, 1, 1>
      diffuse 0
   }
}

#declare T_Water = texture {
   pigment {
      color rgb <0.2, 0.2, 0.2>
   }
   
   normal {
      bumps
      0.07
      turbulence <0.6, 0.6, 0.6>
      scale <1, 0.25, 0.25>
   }
   
   finish {
      ambient rgb <0.05, 0.05, 0.05>
      diffuse 0.55
      brilliance 6
      phong 0.8
      phong_size 120
      
      reflection {
         rgb <0.6, 0.6, 0.6>
      }
   }
}

#declare T_Moon = texture {
   pigment {
      color rgb <0, 0, 0>
   }
}

#declare T_Wood1 = texture {
   pigment {
      wood
      turbulence <0.04, 0.04, 0.04>
      octaves 3
      scale <0.05, 0.05, 1>
      
      color_map {
         [ 0 color rgb <0.88, 0.6, 0.4>
         ]
         [ 0.1 color rgb <0.88, 0.6, 0.4>
         ]
         [ 0.9 color rgb <0.6, 0.3, 0.2>
         ]
         [ 1 color rgb <0.6, 0.3, 0.2>
         ]
      }
   }
}

texture {
   pigment {
      wood
      turbulence <0.1, 0.5, 1>
      octaves 5
      lambda 3.25
      scale <0.15, 0.5, 1>
      rotate <5, 10, 5>
      translate x*(-2)
      
      color_map {
         [ 0 color rgbf <0.55, 0.32, 0.2, 0.1>
         ]
         [ 0.1 color rgbf <0.55, 0.32, 0.2, 0.5>
         ]
         [ 0.1 color rgbf <0.55, 0.35, 0.2, 0.65>
         ]
         [ 0.2 color rgbf <0.88, 0.6, 0.4, 0.975>
         ]
         [ 0.3 color rgbf <0.6, 0.3, 0.2, 1>
         ]
         [ 0.3 color rgbf <0.6, 0.3, 0.2, 0.1>
         ]
         [ 0.4 color rgbf <0.6, 0.3, 0.2, 0.5>
         ]
         [ 0.4 color rgbf <0.6, 0.3, 0.2, 0.65>
         ]
         [ 0.9 color rgbf <0.88, 0.6, 0.4, 0.975>
         ]
         [ 1 color rgbf <0.55, 0.32, 0.2, 1>
         ]
      }
   }
}

#declare T_Wood15 = texture {
   pigment {
      bozo
      turbulence <0.04, 0.04, 0.04>
      scale <0.05, 0.05, 1>
      
      color_map {
         [ 0 color rgb <0.3528, 0.217, 0.0546>
         ]
         [ 0.25 color rgb <0.4248, 0.26, 0.072>
         ]
         [ 0.4 color rgb <0.2735, 0.1665, 0.045>
         ]
         [ 0.5 color rgb <0.3024, 0.186, 0.045>
         ]
         [ 0.7 color rgb <0.2236, 0.1288, 0.0408>
         ]
         [ 0.98 color rgb <0.2124, 0.13, 0.0344>
         ]
         [ 1 color rgb <0.3528, 0.217, 0.0546>
         ]
      }
   }
   
   finish {
      ambient rgb <0, 0, 0>
      diffuse 0.4
      roughness 0.1
   }
}

texture {
   pigment {
      wood
      turbulence <0.04, 0.04, 0.04>
      scale <0.2, 0.2, 1>
      rotate <-2, 2, 0>
      
      color_map {
         [ 0 color rgbf <0.404, 0.21, 0.078, 0.2>
         ]
         [ 0.25 color rgbf <0.431, 0.225, 0.09, 0.8>
         ]
         [ 0.4 color rgbf <0.447, 0.233, 0.09, 0.2>
         ]
         [ 0.5 color rgbf <0.404, 0.21, 0.075, 0.6>
         ]
         [ 0.7 color rgbf <0.459, 0.222, 0.102, 0.2>
         ]
         [ 0.98 color rgbf <0.431, 0.225, 0.086, 0.4>
         ]
         [ 1 color rgbf <0.404, 0.21, 0.078, 0.1>
         ]
      }
   }
   
   finish {
      ambient rgb <0, 0, 0>
      diffuse 0.4
      roughness 0.1
   }
}

#declare T_Pole = texture {
   pigment {
      color rgb <0.878431, 0.792157, 0.4>
   }
}

#declare T_OarHook = texture {
   pigment {
      color rgb <0.443137, 0.470588, 0.470588>
   }
   
   normal {
      bumps
      0.1
   }
   scale 0.05
   
   finish {
      diffuse 0.4
      roughness 0.1
   }
}

#declare T_LampShadeInside = texture {
   pigment {
      color rgb <0.894118, 0.901961, 0.976471>
   }
}

#declare T_Banner = texture {
   uv_mapping
   
   pigment {
      uv_mapping
      
      image_map {
         png
         "pier8.png"
         map_type 0
      }
   }
}

#declare T_BannerRod = texture {
   pigment {
      color rgb <1, 1, 1>
   }
}

#declare T_BannerString = texture {
   pigment {
      color rgb <1, 0.937255, 0.858824>
   }
}

#declare T_Glass1 = texture {
   pigment {
      color rgbf <1, 1, 1, 0.7>
   }
   
   finish {
      ambient rgb <0, 0, 0>
      diffuse 0
      specular 1
      roughness 0.001
      
      reflection {
         rgbft <0.1, 0.1, 0.1, 0.1, 0.1>
      }
   }
}

#declare T_Dori = texture {
   uv_mapping
   T_Wood15
}

#declare T_Towel = texture {
   uv_mapping
   
   pigment {
      uv_mapping
      color rgb <0.439216, 0.580392, 0.764706>
   }
   
   finish {
      diffuse 0.4
      roughness 0.1
   }
}

#declare T_Rope = texture {
   pigment {
      spiral1 3
      
      pigment_map {
         [ 0 color rgb <0.823529, 0.705882, 0.54902>
         ]
         [ 0.9 color rgb <0.823529, 0.705882, 0.54902>
         ]
         [ 0.95 color rgb <0.537255, 0.537255, 0.537255>
         ]
         [ 1 color rgb <0.517647, 0.533333, 0.529412>
         ]
      }
   }
   
   normal {
      spiral1 3
      2
      
      slope_map {
         [ 0 <0, 15>
         ]
         [ 0.9 <0, -15>
         ]
         [ 0.95 <-2, -15>
         ]
         [ 1 <-2, 15>
         ]
      }
   }
   
   finish {
      diffuse 0.4
      roughness 0.1
   }
   rotate y*(-110)
   scale 0.1
}

#declare O_Tyre = mesh {
   smooth_triangle {
      <1.47224, 0.85, 0.5>, <-0.482011, -0.278289, -0.830795>,
      <1.12583, 0.65, 0.5>, <0.227567, 0.131386, -0.964858>,
      <1.7, 1.26763e-07, 0.5>, <-0.556578, 0, -0.830795>
   }
   
   smooth_triangle {
      <1.60215, 0.925, 4.0433e-08>, <-0.866025, -0.5, 0>,
      <1.47224, 0.85, -0.5>, <-0.482011, -0.27829, 0.830795>,
      <0.925, 1.60215, 7.00321e-08>, <-0.5, -0.866025, 0>
   }
   
   smooth_triangle {
      <0.85, 1.47224, -0.5>, <-0.278289, -0.482011, 0.830795>,
      <0.925, 1.60215, 7.00321e-08>, <-0.5, -0.866025, 0>,
      <1.47224, 0.85, -0.5>, <-0.482011, -0.27829, 0.830795>
   }
   
   smooth_triangle {
      <1.1, 7.86805e-08, 0.4>, <0.183943, 1.59784e-07, -0.982937>,
      <1.3, 9.17939e-08, 0.5>, <0.262772, 0, -0.964858>,
      <0.952628, 0.55, 0.4>, <0.1593, 0.0919716, -0.982937>
   }
   
   smooth_triangle {
      <1.12583, 0.65, 0.5>, <0.227567, 0.131386, -0.964858>,
      <0.952628, 0.55, 0.4>, <0.1593, 0.0919716, -0.982937>,
      <1.3, 9.17939e-08, 0.5>, <0.262772, 0, -0.964858>
   }
   
   smooth_triangle {
      <1.3, 9.17939e-08, 0.5>, <0.262771, 0, -0.964858>,
      <1.7, 1.26763e-07, 0.5>, <-0.556578, 0, -0.830795>,
      <1.12583, 0.65, 0.5>, <0.227567, 0.131386, -0.964858>
   }
   
   smooth_triangle {
      <1.60215, 0.925, 4.0433e-08>, <0.866025, 0.5, 1.78814e-07>,
      <1.47224, 0.85, 0.5>, <0.482012, 0.27829, 0.830794>,
      <0.925, 1.60215, 7.00321e-08>, <0.5, 0.866025, 0>
   }
   
   smooth_triangle {
      <1.12583, 0.65, -0.5>, <0.227567, 0.131386, 0.964858>,
      <0.952628, 0.55, -0.4>, <0.159299, 0.0919716, 0.982937>,
      <0.65, 1.12583, -0.5>, <0.131386, 0.227567, 0.964858>
   }
   
   smooth_triangle {
      <0.55, 0.952628, -0.4>, <0.0919714, 0.159299, 0.982937>,
      <0.65, 1.12583, -0.5>, <0.131386, 0.227567, 0.964858>,
      <0.952628, 0.55, -0.4>, <0.159299, 0.0919716, 0.982937>
   }
   
   smooth_triangle {
      <0.952628, 0.55, -0.4>, <0.1593, 0.0919718, 0.982937>,
      <0.866025, 0.5, -0.4>, <0.707109, 0.40825, 0.577347>,
      <0.55, 0.952628, -0.4>, <0.0919716, 0.1593, 0.982937>
   }
   
   smooth_triangle {
      <0.85, 1.47224, 0.5>, <0.27829, 0.482012, 0.830795>,
      <0.925, 1.60215, 7.00321e-08>, <0.5, 0.866025, 0>,
      <1.47224, 0.85, 0.5>, <0.482012, 0.27829, 0.830794>
   }
   
   smooth_triangle {
      <1.47224, 0.85, -0.5>, <-0.482011, -0.27829, 0.830795>,
      <1.12583, 0.65, -0.5>, <0.227567, 0.131386, 0.964858>,
      <0.85, 1.47224, -0.5>, <-0.278289, -0.482011, 0.830795>
   }
   
   smooth_triangle {
      <0.65, 1.12583, -0.5>, <0.131386, 0.227567, 0.964858>,
      <0.85, 1.47224, -0.5>, <-0.278289, -0.482011, 0.830795>,
      <1.12583, 0.65, -0.5>, <0.227567, 0.131386, 0.964858>
   }
   
   smooth_triangle {
      <0.952628, 0.55, 0.4>, <0.1593, 0.0919717, -0.982937>,
      <0.866025, 0.5, 0.4>, <0.707107, 0.408248, -0.57735>,
      <1.1, 7.86805e-08, 0.4>, <0.183943, 1.59784e-07, -0.982937>
   }
   
   smooth_triangle {
      <1.42894, 0.825, 0.45>, <0.467266, 0.269776, 0.841952>,
      <1.55885, 0.9, 3.93403e-08>, <0.866025, 0.5, 0>,
      <1.65, 1.24578e-07, 0.45>, <0.539553, 0, 0.841952>
   }
   
   smooth_triangle {
      <1.65, 1.24578e-07, 0.45>, <0.539553, 0, 0.841952>,
      <1.3, 9.39795e-08, 0.45>, <-0.255292, 0, 0.966864>,
      <1.42894, 0.825, 0.45>, <0.467266, 0.269776, 0.841952>
   }
   
   smooth_triangle {
      <1.12583, 0.65, 0.45>, <-0.22109, -0.127646, 0.966864>,
      <1.42894, 0.825, 0.45>, <0.467266, 0.269776, 0.841952>,
      <1.3, 9.39795e-08, 0.45>, <-0.255292, 0, 0.966864>
   }
   
   smooth_triangle {
      <1.65, 1.63918e-07, -0.45>, <0.539554, 0, -0.841951>,
      <1.8, 1.57361e-07, 6.87847e-15>, <1, 7.94728e-07, 3.47387e-14>,
      <1.42894, 0.825, -0.45>, <0.467266, 0.269777, -0.841952>
   }
   
   smooth_triangle {
      <1.55885, 0.9, 3.93403e-08>, <0.866025, 0.5, 0>,
      <1.42894, 0.825, -0.45>, <0.467266, 0.269777, -0.841952>,
      <1.8, 1.57361e-07, 6.87847e-15>, <1, 7.94728e-07, 3.47387e-14>
   }
   
   smooth_triangle {
      <1.8, 1.57361e-07, 6.87847e-15>, <1, 7.94728e-07, 3.47387e-14>,
      <1.65, 1.24578e-07, 0.45>, <0.539553, 0, 0.841952>,
      <1.55885, 0.9, 3.93403e-08>, <0.866025, 0.5, 0>
   }
   
   smooth_triangle {
      <1.3, 9.39795e-08, 0.45>, <-0.255292, 0, 0.966864>,
      <1.1, 8.08661e-08, 0.35>, <-0.183943, 0, 0.982937>,
      <1.12583, 0.65, 0.45>, <-0.22109, -0.127646, 0.966864>
   }
   
   smooth_triangle {
      <1, 7.21238e-08, 0.35>, <0.816496, 6.87241e-07, 0.577352>,
      <1, 6.99382e-08, 0.4>, <0.816494, 5.84002e-07, -0.577353>,
      <0.866025, 0.5, 0.35>, <0.707105, 0.408247, 0.577353>
   }
   
   smooth_triangle {
      <0.866025, 0.5, 0.4>, <0.707107, 0.408249, -0.57735>,
      <0.866025, 0.5, 0.35>, <0.707105, 0.408247, 0.577353>,
      <1, 6.99382e-08, 0.4>, <0.816494, 5.84002e-07, -0.577353>
   }
   
   smooth_triangle {
      <1, 6.99382e-08, 0.4>, <0.816495, 5.84003e-07, -0.577352>,
      <1.1, 7.86805e-08, 0.4>, <0.183943, 1.59784e-07, -0.982937>,
      <0.866025, 0.5, 0.4>, <0.707107, 0.408248, -0.57735>
   }
   
   smooth_triangle {
      <0.952628, 0.55, 0.35>, <-0.159299, -0.0919715, 0.982937>,
      <1.12583, 0.65, 0.45>, <-0.22109, -0.127646, 0.966864>,
      <1.1, 8.08661e-08, 0.35>, <-0.183943, 0, 0.982937>
   }
   
   smooth_triangle {
      <1.1, 8.08661e-08, 0.35>, <-0.183943, 0, 0.982937>,
      <1, 7.21238e-08, 0.35>, <0.816495, 6.87241e-07, 0.577352>,
      <0.952628, 0.55, 0.35>, <-0.1593, -0.0919717, 0.982937>
   }
   
   smooth_triangle {
      <0.866025, 0.5, 0.35>, <0.707108, 0.408249, 0.577348>,
      <0.952628, 0.55, 0.35>, <-0.1593, -0.0919717, 0.982937>,
      <1, 7.21238e-08, 0.35>, <0.816495, 6.87241e-07, 0.577352>
   }
   
   smooth_triangle {
      <0.952628, 0.55, 0.35>, <-0.1593, -0.0919717, 0.982937>,
      <0.866025, 0.5, 0.35>, <0.707108, 0.408249, 0.577348>,
      <0.55, 0.952628, 0.35>, <-0.0919716, -0.1593, 0.982937>
   }
   
   smooth_triangle {
      <0.5, 0.866026, 0.35>, <0.408248, 0.707106, 0.577351>,
      <0.55, 0.952628, 0.35>, <-0.0919716, -0.1593, 0.982937>,
      <0.866025, 0.5, 0.35>, <0.707108, 0.408249, 0.577348>
   }
   
   smooth_triangle {
      <0.866025, 0.5, 0.35>, <0.707105, 0.408247, 0.577353>,
      <0.866025, 0.5, 0.4>, <0.707107, 0.408249, -0.57735>,
      <0.5, 0.866026, 0.35>, <0.408248, 0.707107, 0.57735>
   }
   
   smooth_triangle {
      <0.65, 1.12583, 0.45>, <-0.127646, -0.22109, 0.966864>,
      <0.825, 1.42894, 0.45>, <0.269776, 0.467267, 0.841952>,
      <1.12583, 0.65, 0.45>, <-0.221089, -0.127646, 0.966864>
   }
   
   smooth_triangle {
      <1.12583, 0.65, 0.45>, <-0.22109, -0.127646, 0.966864>,
      <0.952628, 0.55, 0.35>, <-0.159299, -0.0919714, 0.982937>,
      <0.65, 1.12583, 0.45>, <-0.127646, -0.221089, 0.966864>
   }
   
   smooth_triangle {
      <0.55, 0.952628, 0.35>, <-0.0919714, -0.159299, 0.982937>,
      <0.65, 1.12583, 0.45>, <-0.127646, -0.221089, 0.966864>,
      <0.952628, 0.55, 0.35>, <-0.159299, -0.0919714, 0.982937>
   }
   
   smooth_triangle {
      <0.5, 0.866026, 0.4>, <0.408249, 0.707108, -0.577349>,
      <0.5, 0.866026, 0.35>, <0.408248, 0.707107, 0.57735>,
      <0.866025, 0.5, 0.4>, <0.707107, 0.408249, -0.57735>
   }
   
   smooth_triangle {
      <0.65, 1.12583, 0.5>, <0.131386, 0.227567, -0.964858>,
      <0.55, 0.952628, 0.4>, <0.0919715, 0.159299, -0.982937>,
      <1.12583, 0.65, 0.5>, <0.227567, 0.131386, -0.964858>
   }
   
   smooth_triangle {
      <1.12583, 0.65, 0.5>, <0.227567, 0.131386, -0.964858>,
      <1.47224, 0.85, 0.5>, <-0.482011, -0.278289, -0.830795>,
      <0.65, 1.12583, 0.5>, <0.131385, 0.227566, -0.964858>
   }
   
   smooth_triangle {
      <0.85, 1.47224, 0.5>, <-0.278289, -0.482011, -0.830795>,
      <0.65, 1.12583, 0.5>, <0.131385, 0.227566, -0.964858>,
      <1.47224, 0.85, 0.5>, <-0.482011, -0.278289, -0.830795>
   }
   
   smooth_triangle {
      <0.866025, 0.5, 0.4>, <0.707107, 0.408249, -0.57735>,
      <0.952628, 0.55, 0.4>, <0.1593, 0.0919716, -0.982937>,
      <0.5, 0.866026, 0.4>, <0.408249, 0.707108, -0.577349>
   }
   
   smooth_triangle {
      <0.55, 0.952628, 0.4>, <0.0919712, 0.159299, -0.982937>,
      <0.5, 0.866026, 0.4>, <0.408249, 0.707108, -0.577349>,
      <0.952628, 0.55, 0.4>, <0.1593, 0.0919716, -0.982937>
   }
   
   smooth_triangle {
      <0.952628, 0.55, 0.4>, <0.1593, 0.0919716, -0.982937>,
      <1.12583, 0.65, 0.5>, <0.227567, 0.131386, -0.964858>,
      <0.55, 0.952628, 0.4>, <0.0919715, 0.159299, -0.982937>
   }
   
   smooth_triangle {
      <1.42894, 0.825, 0.45>, <0.467266, 0.269776, 0.841952>,
      <1.12583, 0.65, 0.45>, <-0.221089, -0.127646, 0.966864>,
      <0.825, 1.42894, 0.45>, <0.269776, 0.467267, 0.841952>
   }
   
   smooth_triangle {
      <0.866025, 0.5, -0.35>, <0.707107, 0.408249, -0.577349>,
      <0.952628, 0.55, -0.35>, <-0.1593, -0.0919715, -0.982937>,
      <0.5, 0.866026, -0.35>, <0.408249, 0.707108, -0.577348>
   }
   
   smooth_triangle {
      <0.55, 0.952628, -0.35>, <-0.0919713, -0.159299, -0.982937>,
      <0.5, 0.866026, -0.35>, <0.408249, 0.707108, -0.577348>,
      <0.952628, 0.55, -0.35>, <-0.1593, -0.0919715, -0.982937>
   }
   
   smooth_triangle {
      <0.952628, 0.55, -0.35>, <-0.159299, -0.0919712, -0.982937>,
      <1.12583, 0.65, -0.45>, <-0.22109, -0.127646, -0.966864>,
      <0.55, 0.952628, -0.35>, <-0.0919715, -0.159299, -0.982937>
   }
   
   smooth_triangle {
      <0.5, 0.866026, -0.4>, <0.408248, 0.707106, 0.577351>,
      <0.55, 0.952628, -0.4>, <0.0919716, 0.1593, 0.982937>,
      <0.866025, 0.5, -0.4>, <0.707109, 0.40825, 0.577347>
   }
   
   smooth_triangle {
      <0.866025, 0.5, -0.4>, <0.707105, 0.408248, 0.577353>,
      <0.866025, 0.5, -0.35>, <0.707106, 0.408248, -0.577351>,
      <0.5, 0.866026, -0.4>, <0.408248, 0.707107, 0.57735>
   }
   
   smooth_triangle {
      <0.5, 0.866026, -0.35>, <0.408249, 0.707108, -0.577348>,
      <0.5, 0.866026, -0.4>, <0.408248, 0.707107, 0.57735>,
      <0.866025, 0.5, -0.35>, <0.707106, 0.408248, -0.577351>
   }
   
   smooth_triangle {
      <0.65, 1.12583, -0.45>, <-0.127646, -0.22109, -0.966864>,
      <0.55, 0.952628, -0.35>, <-0.0919715, -0.159299, -0.982937>,
      <1.12583, 0.65, -0.45>, <-0.22109, -0.127646, -0.966864>
   }
   
   smooth_triangle {
      <0.9, 1.55885, 6.81393e-08>, <0.5, 0.866026, 0>,
      <0.825, 1.42894, -0.45>, <0.269776, 0.467266, -0.841952>,
      <1.55885, 0.9, 3.93403e-08>, <0.866025, 0.5, 0>
   }
   
   smooth_triangle {
      <1.55885, 0.9, 3.93403e-08>, <0.866025, 0.5, 0>,
      <1.42894, 0.825, 0.45>, <0.467266, 0.269776, 0.841952>,
      <0.9, 1.55885, 6.81393e-08>, <0.5, 0.866026, 0>
   }
   
   smooth_triangle {
      <0.825, 1.42894, 0.45>, <0.269776, 0.467267, 0.841952>,
      <0.9, 1.55885, 6.81393e-08>, <0.5, 0.866026, 0>,
      <1.42894, 0.825, 0.45>, <0.467266, 0.269776, 0.841952>
   }
   
   smooth_triangle {
      <1.12583, 0.65, -0.45>, <-0.22109, -0.127646, -0.966864>,
      <1.42894, 0.825, -0.45>, <0.467266, 0.269776, -0.841952>,
      <0.65, 1.12583, -0.45>, <-0.127646, -0.22109, -0.966864>
   }
   
   smooth_triangle {
      <0.825, 1.42894, -0.45>, <0.269776, 0.467267, -0.841952>,
      <0.65, 1.12583, -0.45>, <-0.127646, -0.22109, -0.966864>,
      <1.42894, 0.825, -0.45>, <0.467266, 0.269776, -0.841952>
   }
   
   smooth_triangle {
      <1.42894, 0.825, -0.45>, <0.467266, 0.269776, -0.841952>,
      <1.55885, 0.9, 3.93403e-08>, <0.866025, 0.5, 0>,
      <0.825, 1.42894, -0.45>, <0.269776, 0.467266, -0.841952>
   }
   
   smooth_triangle {
      <1.65, 1.63918e-07, -0.45>, <0.539552, 2.3389e-07, -0.841952>,
      <1.3, 1.3332e-07, -0.45>, <-0.255292, 0, -0.966864>,
      <1.42894, -0.825, -0.45>, <0.467266, -0.269776, -0.841952>
   }
   
   smooth_triangle {
      <1.42894, -0.825, -0.45>, <0.467267, -0.269776, -0.841952>,
      <1.55885, -0.9, -3.93402e-08>, <0.866026, -0.5, 0>,
      <1.65, 1.63918e-07, -0.45>, <0.539554, 2.3389e-07, -0.841951>
   }
   
   smooth_triangle {
      <1.8, 1.57361e-07, 6.87847e-15>, <1, 0, 0>,
      <1.65, 1.63918e-07, -0.45>, <0.539554, 2.3389e-07, -0.841951>,
      <1.55885, -0.9, -3.93402e-08>, <0.866026, -0.5, 0>
   }
   
   smooth_triangle {
      <0.952628, -0.55, -0.35>, <-0.1593, 0.0919716, -0.982937>,
      <1.12583, -0.65, -0.45>, <-0.22109, 0.127646, -0.966864>,
      <1.1, 1.11464e-07, -0.35>, <-0.183943, 1.19606e-07, -0.982937>
   }
   
   smooth_triangle {
      <1.3, 1.3332e-07, -0.45>, <-0.255292, 0, -0.966864>,
      <1.1, 1.11464e-07, -0.35>, <-0.183943, 1.19606e-07, -0.982937>,
      <1.12583, -0.65, -0.45>, <-0.22109, 0.127646, -0.966864>
   }
   
   smooth_triangle {
      <1.12583, -0.65, -0.45>, <-0.22109, 0.127646, -0.966864>,
      <1.42894, -0.825, -0.45>, <0.467266, -0.269776, -0.841952>,
      <1.3, 1.3332e-07, -0.45>, <-0.255292, 0, -0.966864>
   }
   
   smooth_triangle {
      <1.55885, -0.9, -3.93402e-08>, <0.866026, -0.5, 0>,
      <1.42894, -0.825, 0.45>, <0.467267, -0.269776, 0.841952>,
      <1.8, 1.57361e-07, 6.87847e-15>, <1, 0, 0>
   }
   
   smooth_triangle {
      <1.12583, -0.65, 0.45>, <-0.221089, 0.127646, 0.966864>,
      <0.952628, -0.55, 0.35>, <-0.159299, 0.0919713, 0.982937>,
      <1.3, 9.39795e-08, 0.45>, <-0.255292, 0, 0.966864>
   }
   
   smooth_triangle {
      <1.1, 8.08661e-08, 0.35>, <-0.183943, -1.19606e-07, 0.982937>,
      <1.3, 9.39795e-08, 0.45>, <-0.255292, 0, 0.966864>,
      <0.952628, -0.55, 0.35>, <-0.159299, 0.0919713, 0.982937>
   }
   
   smooth_triangle {
      <0.952628, -0.55, 0.35>, <-0.159299, 0.091971, 0.982937>,
      <0.866026, -0.5, 0.35>, <0.707106, -0.408248, 0.577351>,
      <1.1, 8.08661e-08, 0.35>, <-0.183943, -1.19605e-07, 0.982937>
   }
   
   smooth_triangle {
      <1.65, 1.24578e-07, 0.45>, <0.539553, 2.3389e-07, 0.841952>,
      <1.8, 1.57361e-07, 6.87847e-15>, <1, 0, 0>,
      <1.42894, -0.825, 0.45>, <0.467267, -0.269776, 0.841952>
   }
   
   smooth_triangle {
      <1.42894, -0.825, 0.45>, <0.467266, -0.269776, 0.841952>,
      <1.12583, -0.65, 0.45>, <-0.22109, 0.127646, 0.966864>,
      <1.65, 1.24578e-07, 0.45>, <0.539553, 2.3389e-07, 0.841952>
   }
   
   smooth_triangle {
      <1.3, 9.39795e-08, 0.45>, <-0.255292, 0, 0.966864>,
      <1.65, 1.24578e-07, 0.45>, <0.539553, 2.3389e-07, 0.841952>,
      <1.12583, -0.65, 0.45>, <-0.22109, 0.127646, 0.966864>
   }
   
   smooth_triangle {
      <1.1, 1.11464e-07, -0.35>, <-0.183942, 1.19605e-07, -0.982937>,
      <1, 1.02722e-07, -0.35>, <0.816495, 0, -0.577352>,
      <0.952628, -0.55, -0.35>, <-0.159299, 0.0919711, -0.982937>
   }
   
   smooth_triangle {
      <1.7, 1.26763e-07, 0.5>, <0.556579, 1.46788e-07, 0.830794>,
      <1.85, 1.61732e-07, 7.06954e-15>, <1, 3.86625e-07, 1.68999e-14>,
      <1.47224, -0.85, 0.5>, <0.482012, -0.278289, 0.830795>
   }
   
   smooth_triangle {
      <1.47224, -0.85, -0.5>, <-0.482011, 0.278289, 0.830795>,
      <1.12583, -0.65, -0.5>, <0.227567, -0.131386, 0.964858>,
      <1.7, 1.70474e-07, -0.5>, <-0.556578, 8.73869e-08, 0.830795>
   }
   
   smooth_triangle {
      <1.3, 1.35505e-07, -0.5>, <0.262771, 0, 0.964858>,
      <1.7, 1.70474e-07, -0.5>, <-0.556578, 8.73869e-08, 0.830795>,
      <1.12583, -0.65, -0.5>, <0.227567, -0.131386, 0.964858>
   }
   
   smooth_triangle {
      <1.60215, -0.925, -4.0433e-08>, <-0.866026, 0.5, -1.78814e-07>,
      <1.47224, -0.85, -0.5>, <-0.482011, 0.278289, 0.830795>,
      <1.85, 1.61732e-07, 7.06954e-15>, <-1, -3.86625e-07, -1.68999e-14>
   }
   
   smooth_triangle {
      <1.7, 1.70474e-07, -0.5>, <-0.556578, 8.73869e-08, 0.830795>,
      <1.85, 1.61732e-07, 7.06954e-15>, <-1, -3.86625e-07, -1.68999e-14>,
      <1.47224, -0.85, -0.5>, <-0.482011, 0.278289, 0.830795>
   }
   
   smooth_triangle {
      <1.60215, -0.925, -4.0433e-08>, <0.866026, -0.5, 0>,
      <1.47224, -0.85, 0.5>, <0.482012, -0.278289, 0.830795>,
      <1.85, 1.61732e-07, 7.06954e-15>, <1, 3.86625e-07, 1.68999e-14>
   }
   
   smooth_triangle {
      <1.12583, -0.65, -0.5>, <0.227567, -0.131386, 0.964858>,
      <0.952628, -0.55, -0.4>, <0.1593, -0.0919715, 0.982937>,
      <1.3, 1.35505e-07, -0.5>, <0.262772, 0, 0.964858>
   }
   
   smooth_triangle {
      <0.866026, -0.5, -0.4>, <0.707106, -0.408248, 0.577351>,
      <0.866026, -0.5, -0.35>, <0.707105, -0.408247, -0.577353>,
      <1, 1.04907e-07, -0.4>, <0.816496, 0, 0.577352>
   }
   
   smooth_triangle {
      <1, 1.02722e-07, -0.35>, <0.816494, 0, -0.577354>,
      <1, 1.04907e-07, -0.4>, <0.816496, 0, 0.577352>,
      <0.866026, -0.5, -0.35>, <0.707105, -0.408247, -0.577353>
   }
   
   smooth_triangle {
      <0.866026, -0.5, -0.35>, <0.707108, -0.408249, -0.577348>,
      <0.952628, -0.55, -0.35>, <-0.159299, 0.0919711, -0.982937>,
      <1, 1.02722e-07, -0.35>, <0.816495, 0, -0.577352>
   }
   
   smooth_triangle {
      <1.1, 1.1365e-07, -0.4>, <0.183944, -1.19606e-07, 0.982937>,
      <1.3, 1.35505e-07, -0.5>, <0.262772, 0, 0.964858>,
      <0.952628, -0.55, -0.4>, <0.1593, -0.0919715, 0.982937>
   }
   
   smooth_triangle {
      <0.952628, -0.55, -0.4>, <0.159299, -0.0919712, 0.982937>,
      <0.866026, -0.5, -0.4>, <0.707107, -0.408248, 0.57735>,
      <1.1, 1.1365e-07, -0.4>, <0.183943, -1.19606e-07, 0.982937>
   }
   
   smooth_triangle {
      <1, 1.04907e-07, -0.4>, <0.816495, 0, 0.577352>,
      <1.1, 1.1365e-07, -0.4>, <0.183943, -1.19606e-07, 0.982937>,
      <0.866026, -0.5, -0.4>, <0.707107, -0.408248, 0.57735>
   }
   
   smooth_triangle {
      <1.1, 1.1365e-07, -0.4>, <0.183943, -1.99963e-07, 0.982937>,
      <1, 1.04907e-07, -0.4>, <0.816495, 3.77526e-07, 0.577352>,
      <0.952628, 0.55, -0.4>, <0.1593, 0.0919716, 0.982937>
   }
   
   smooth_triangle {
      <0.866025, 0.5, -0.4>, <0.707109, 0.408249, 0.577347>,
      <0.952628, 0.55, -0.4>, <0.1593, 0.0919716, 0.982937>,
      <1, 1.04907e-07, -0.4>, <0.816495, 3.77526e-07, 0.577352>
   }
   
   smooth_triangle {
      <1, 1.04907e-07, -0.4>, <0.816496, 3.77526e-07, 0.577352>,
      <1, 1.02722e-07, -0.35>, <0.816494, 5.84002e-07, -0.577354>,
      <0.866025, 0.5, -0.4>, <0.707105, 0.408247, 0.577353>
   }
   
   smooth_triangle {
      <1.12583, 0.65, -0.5>, <0.227567, 0.131386, 0.964858>,
      <1.47224, 0.85, -0.5>, <-0.482011, -0.278289, 0.830795>,
      <1.3, 1.35505e-07, -0.5>, <0.262771, 0, 0.964858>
   }
   
   smooth_triangle {
      <1.3, 1.35505e-07, -0.5>, <0.262772, 0, 0.964858>,
      <1.1, 1.1365e-07, -0.4>, <0.183944, -1.99963e-07, 0.982937>,
      <1.12583, 0.65, -0.5>, <0.227567, 0.131386, 0.964858>
   }
   
   smooth_triangle {
      <0.952628, 0.55, -0.4>, <0.159299, 0.0919713, 0.982937>,
      <1.12583, 0.65, -0.5>, <0.227567, 0.131386, 0.964858>,
      <1.1, 1.1365e-07, -0.4>, <0.183944, -1.99963e-07, 0.982937>
   }
   
   smooth_triangle {
      <0.866025, 0.5, -0.35>, <0.707106, 0.408248, -0.577351>,
      <0.866025, 0.5, -0.4>, <0.707105, 0.408247, 0.577353>,
      <1, 1.02722e-07, -0.35>, <0.816494, 5.84002e-07, -0.577354>
   }
   
   smooth_triangle {
      <1.12583, 0.65, -0.45>, <-0.22109, -0.127646, -0.966864>,
      <0.952628, 0.55, -0.35>, <-0.159299, -0.0919712, -0.982937>,
      <1.3, 1.3332e-07, -0.45>, <-0.255292, 0, -0.966864>
   }
   
   smooth_triangle {
      <1.3, 1.3332e-07, -0.45>, <-0.255292, 0, -0.966864>,
      <1.65, 1.63918e-07, -0.45>, <0.539552, 0, -0.841952>,
      <1.12583, 0.65, -0.45>, <-0.22109, -0.127646, -0.966864>
   }
   
   smooth_triangle {
      <1.42894, 0.825, -0.45>, <0.467265, 0.269776, -0.841952>,
      <1.12583, 0.65, -0.45>, <-0.22109, -0.127646, -0.966864>,
      <1.65, 1.63918e-07, -0.45>, <0.539552, 0, -0.841952>
   }
   
   smooth_triangle {
      <1, 1.02722e-07, -0.35>, <0.816495, 5.84003e-07, -0.577352>,
      <1.1, 1.11464e-07, -0.35>, <-0.183942, -1.19605e-07, -0.982937>,
      <0.866025, 0.5, -0.35>, <0.707107, 0.408249, -0.577349>
   }
   
   smooth_triangle {
      <0.952628, 0.55, -0.35>, <-0.1593, -0.0919715, -0.982937>,
      <0.866025, 0.5, -0.35>, <0.707107, 0.408249, -0.577349>,
      <1.1, 1.11464e-07, -0.35>, <-0.183942, -1.19605e-07, -0.982937>
   }
   
   smooth_triangle {
      <1.1, 1.11464e-07, -0.35>, <-0.183943, -1.19606e-07, -0.982937>,
      <1.3, 1.3332e-07, -0.45>, <-0.255292, 0, -0.966864>,
      <0.952628, 0.55, -0.35>, <-0.159299, -0.0919712, -0.982937>
   }
   
   smooth_triangle {
      <1.7, 1.70474e-07, -0.5>, <-0.556578, -4.08948e-07, 0.830795>,
      <1.3, 1.35505e-07, -0.5>, <0.262771, 0, 0.964858>,
      <1.47224, 0.85, -0.5>, <-0.482011, -0.278289, 0.830795>
   }
   
   smooth_triangle {
      <0.866026, -0.5, 0.4>, <0.707108, -0.408249, -0.577349>,
      <0.952628, -0.55, 0.4>, <0.159299, -0.0919712, -0.982937>,
      <1, 6.99382e-08, 0.4>, <0.816495, 2.06477e-07, -0.577352>
   }
   
   smooth_triangle {
      <1.1, 7.86805e-08, 0.4>, <0.183943, 1.19606e-07, -0.982937>,
      <1, 6.99382e-08, 0.4>, <0.816495, 2.06477e-07, -0.577352>,
      <0.952628, -0.55, 0.4>, <0.159299, -0.0919712, -0.982937>
   }
   
   smooth_triangle {
      <0.952628, -0.55, 0.4>, <0.159299, -0.0919713, -0.982937>,
      <1.12583, -0.65, 0.5>, <0.227567, -0.131386, -0.964858>,
      <1.1, 7.86805e-08, 0.4>, <0.183943, 1.19605e-07, -0.982937>
   }
   
   smooth_triangle {
      <1, 7.21238e-08, 0.35>, <0.816495, -1.03239e-07, 0.577352>,
      <1.1, 8.08661e-08, 0.35>, <-0.183943, -1.19605e-07, 0.982937>,
      <0.866026, -0.5, 0.35>, <0.707106, -0.408248, 0.577351>
   }
   
   smooth_triangle {
      <0.866026, -0.5, 0.35>, <0.707106, -0.408248, 0.577351>,
      <0.866026, -0.5, 0.4>, <0.707105, -0.408247, -0.577353>,
      <1, 7.21238e-08, 0.35>, <0.816496, -1.03239e-07, 0.577352>
   }
   
   smooth_triangle {
      <1, 6.99382e-08, 0.4>, <0.816494, 2.06478e-07, -0.577353>,
      <1, 7.21238e-08, 0.35>, <0.816496, -1.03239e-07, 0.577352>,
      <0.866026, -0.5, 0.4>, <0.707105, -0.408247, -0.577353>
   }
   
   smooth_triangle {
      <1.3, 9.17939e-08, 0.5>, <0.262772, 1.32715e-07, -0.964858>,
      <1.1, 7.86805e-08, 0.4>, <0.183943, 1.19605e-07, -0.982937>,
      <1.12583, -0.65, 0.5>, <0.227567, -0.131386, -0.964858>
   }
   
   smooth_triangle {
      <1.47224, 0.85, -0.5>, <-0.482011, -0.278289, 0.830795>,
      <1.60215, 0.925, 4.0433e-08>, <-0.866025, -0.5, 0>,
      <1.7, 1.70474e-07, -0.5>, <-0.556578, -4.08948e-07, 0.830795>
   }
   
   smooth_triangle {
      <1.85, 1.61732e-07, 7.06954e-15>, <1, 0, 0>,
      <1.7, 1.26763e-07, 0.5>, <0.556579, 0, 0.830794>,
      <1.60215, 0.925, 4.0433e-08>, <0.866025, 0.5, 1.78814e-07>
   }
   
   smooth_triangle {
      <1.47224, 0.85, 0.5>, <0.482012, 0.27829, 0.830794>,
      <1.60215, 0.925, 4.0433e-08>, <0.866025, 0.5, 1.78814e-07>,
      <1.7, 1.26763e-07, 0.5>, <0.556579, 0, 0.830794>
   }
   
   smooth_triangle {
      <1.12583, -0.65, 0.5>, <0.227567, -0.131386, -0.964858>,
      <1.47224, -0.85, 0.5>, <-0.482011, 0.278289, -0.830796>,
      <1.3, 9.17939e-08, 0.5>, <0.262771, 1.32715e-07, -0.964858>
   }
   
   smooth_triangle {
      <1.7, 1.26763e-07, 0.5>, <-0.556578, -1.46787e-07, -0.830795>,
      <1.3, 9.17939e-08, 0.5>, <0.262771, 1.32715e-07, -0.964858>,
      <1.47224, -0.85, 0.5>, <-0.482011, 0.278289, -0.830796>
   }
   
   smooth_triangle {
      <1.85, 1.61732e-07, 7.06954e-15>, <-1, 0, 0>,
      <1.7, 1.70474e-07, -0.5>, <-0.556578, -4.08948e-07, 0.830795>,
      <1.60215, 0.925, 4.0433e-08>, <-0.866025, -0.5, 0>
   }
   
   smooth_triangle {
      <-0.850001, 1.47224, 0.5>, <0.278289, -0.482011, -0.830795>,
      <-0.65, 1.12583, 0.5>, <-0.131386, 0.227567, -0.964858>,
      <-2.02723e-08, 1.7, 0.5>, <0, -0.556578, -0.830796>
   }
   
   smooth_triangle {
      <-0.925001, 1.60215, 7.0032e-08>, <0.5, -0.866025, 0>,
      <-0.850001, 1.47224, -0.5>, <0.27829, -0.482011, 0.830795>,
      <-1.60215, 0.925, 4.0433e-08>, <0.866025, -0.5, 6.1943e-07>
   }
   
   smooth_triangle {
      <-1.47224, 0.85, -0.5>, <0.482011, -0.278289, 0.830795>,
      <-1.60215, 0.925, 4.0433e-08>, <0.866025, -0.5, 6.1943e-07>,
      <-0.850001, 1.47224, -0.5>, <0.27829, -0.482011, 0.830795>
   }
   
   smooth_triangle {
      <-1.31174e-08, 1.1, 0.4>, <0, 0.183943, -0.982937>,
      <-1.55023e-08, 1.3, 0.5>, <-1.44576e-07, 0.262771, -0.964858>,
      <-0.55, 0.952628, 0.4>, <-0.0919713, 0.159299, -0.982937>
   }
   
   smooth_triangle {
      <-0.65, 1.12583, 0.5>, <-0.131386, 0.227567, -0.964858>,
      <-0.55, 0.952628, 0.4>, <-0.0919713, 0.159299, -0.982937>,
      <-1.55023e-08, 1.3, 0.5>, <-1.44576e-07, 0.262771, -0.964858>
   }
   
   smooth_triangle {
      <-1.55023e-08, 1.3, 0.5>, <-1.44576e-07, 0.262771, -0.964858>,
      <-2.02723e-08, 1.7, 0.5>, <0, -0.556578, -0.830796>,
      <-0.65, 1.12583, 0.5>, <-0.131386, 0.227567, -0.964858>
   }
   
   smooth_triangle {
      <-0.925001, 1.60215, 7.0032e-08>, <-0.5, 0.866025, 0>,
      <-0.850001, 1.47224, 0.5>, <-0.27829, 0.482011, 0.830795>,
      <-1.60215, 0.925, 4.0433e-08>, <-0.866025, 0.5, -6.1943e-07>
   }
   
   smooth_triangle {
      <-0.65, 1.12583, -0.5>, <-0.131386, 0.227567, 0.964858>,
      <-0.55, 0.952628, -0.4>, <-0.0919715, 0.159299, 0.982937>,
      <-1.12583, 0.65, -0.5>, <-0.227567, 0.131386, 0.964858>
   }
   
   smooth_triangle {
      <-0.952628, 0.55, -0.4>, <-0.159299, 0.0919716, 0.982937>,
      <-1.12583, 0.65, -0.5>, <-0.227567, 0.131386, 0.964858>,
      <-0.55, 0.952628, -0.4>, <-0.0919715, 0.159299, 0.982937>
   }
   
   smooth_triangle {
      <-0.55, 0.952628, -0.4>, <-0.0919716, 0.159299, 0.982937>,
      <-0.5, 0.866025, -0.4>, <-0.408249, 0.707108, 0.577348>,
      <-0.952628, 0.55, -0.4>, <-0.1593, 0.0919718, 0.982937>
   }
   
   smooth_triangle {
      <-1.47224, 0.85, 0.5>, <-0.482011, 0.278289, 0.830795>,
      <-1.60215, 0.925, 4.0433e-08>, <-0.866025, 0.5, -6.1943e-07>,
      <-0.850001, 1.47224, 0.5>, <-0.27829, 0.482011, 0.830795>
   }
   
   smooth_triangle {
      <-0.850001, 1.47224, -0.5>, <0.27829, -0.482011, 0.830795>,
      <-0.65, 1.12583, -0.5>, <-0.131386, 0.227567, 0.964858>,
      <-1.47224, 0.85, -0.5>, <0.482011, -0.278289, 0.830795>
   }
   
   smooth_triangle {
      <-1.12583, 0.65, -0.5>, <-0.227567, 0.131386, 0.964858>,
      <-1.47224, 0.85, -0.5>, <0.482011, -0.278289, 0.830795>,
      <-0.65, 1.12583, -0.5>, <-0.131386, 0.227567, 0.964858>
   }
   
   smooth_triangle {
      <-0.55, 0.952628, 0.4>, <-0.0919712, 0.159299, -0.982937>,
      <-0.5, 0.866025, 0.4>, <-0.408248, 0.707106, -0.577352>,
      <-1.31174e-08, 1.1, 0.4>, <0, 0.183944, -0.982937>
   }
   
   smooth_triangle {
      <-0.825001, 1.42894, 0.45>, <-0.269776, 0.467267, 0.841952>,
      <-0.900001, 1.55885, 6.81393e-08>, <-0.5, 0.866025, 0>,
      <-1.9676e-08, 1.65, 0.45>, <0, 0.539552, 0.841952>
   }
   
   smooth_triangle {
      <-1.9676e-08, 1.65, 0.45>, <0, 0.539552, 0.841952>,
      <-1.55023e-08, 1.3, 0.45>, <1.40461e-07, -0.255292, 0.966864>,
      <-0.825001, 1.42894, 0.45>, <-0.269776, 0.467267, 0.841952>
   }
   
   smooth_triangle {
      <-0.65, 1.12583, 0.45>, <0.127646, -0.221089, 0.966864>,
      <-0.825001, 1.42894, 0.45>, <-0.269776, 0.467267, 0.841952>,
      <-1.55023e-08, 1.3, 0.45>, <1.40461e-07, -0.255292, 0.966864>
   }
   
   smooth_triangle {
      <-1.9676e-08, 1.65, -0.45>, <0, 0.539553, -0.841952>,
      <-2.14648e-08, 1.8, 7.86805e-08>, <0, 1, 0>,
      <-0.825001, 1.42894, -0.45>, <-0.269776, 0.467266, -0.841952>
   }
   
   smooth_triangle {
      <-0.900001, 1.55885, 6.81393e-08>, <-0.5, 0.866025, 0>,
      <-0.825001, 1.42894, -0.45>, <-0.269776, 0.467266, -0.841952>,
      <-2.14648e-08, 1.8, 7.86805e-08>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-2.14648e-08, 1.8, 7.86805e-08>, <0, 1, 0>,
      <-1.9676e-08, 1.65, 0.45>, <0, 0.539552, 0.841952>,
      <-0.900001, 1.55885, 6.81393e-08>, <-0.5, 0.866025, 0>
   }
   
   smooth_triangle {
      <-1.55023e-08, 1.3, 0.45>, <1.40461e-07, -0.255292, 0.966864>,
      <-1.31174e-08, 1.1, 0.35>, <0, -0.183944, 0.982937>,
      <-0.65, 1.12583, 0.45>, <0.127646, -0.221089, 0.966864>
   }
   
   smooth_triangle {
      <-1.19249e-08, 1, 0.35>, <0, 0.816494, 0.577353>,
      <-1.19249e-08, 1, 0.4>, <0, 0.816494, -0.577353>,
      <-0.5, 0.866025, 0.35>, <-0.408248, 0.707105, 0.577352>
   }
   
   smooth_triangle {
      <-0.5, 0.866025, 0.4>, <-0.408249, 0.707108, -0.577349>,
      <-0.5, 0.866025, 0.35>, <-0.408248, 0.707105, 0.577352>,
      <-1.19249e-08, 1, 0.4>, <0, 0.816494, -0.577353>
   }
   
   smooth_triangle {
      <-1.19249e-08, 1, 0.4>, <0, 0.816497, -0.577349>,
      <-1.31174e-08, 1.1, 0.4>, <0, 0.183944, -0.982937>,
      <-0.5, 0.866025, 0.4>, <-0.408248, 0.707106, -0.577352>
   }
   
   smooth_triangle {
      <-0.55, 0.952628, 0.35>, <0.0919715, -0.159299, 0.982937>,
      <-0.65, 1.12583, 0.45>, <0.127646, -0.221089, 0.966864>,
      <-1.31174e-08, 1.1, 0.35>, <0, -0.183944, 0.982937>
   }
   
   smooth_triangle {
      <-1.31174e-08, 1.1, 0.35>, <0, -0.183943, 0.982937>,
      <-1.19249e-08, 1, 0.35>, <0, 0.816495, 0.577352>,
      <-0.55, 0.952628, 0.35>, <0.091972, -0.1593, 0.982937>
   }
   
   smooth_triangle {
      <-0.5, 0.866025, 0.35>, <-0.408249, 0.707108, 0.577349>,
      <-0.55, 0.952628, 0.35>, <0.091972, -0.1593, 0.982937>,
      <-1.19249e-08, 1, 0.35>, <0, 0.816495, 0.577352>
   }
   
   smooth_triangle {
      <-0.55, 0.952628, 0.35>, <0.091972, -0.1593, 0.982937>,
      <-0.5, 0.866025, 0.35>, <-0.408249, 0.707108, 0.577349>,
      <-0.952628, 0.55, 0.35>, <0.1593, -0.0919717, 0.982937>
   }
   
   smooth_triangle {
      <-0.866026, 0.5, 0.35>, <-0.707107, 0.408248, 0.57735>,
      <-0.952628, 0.55, 0.35>, <0.1593, -0.0919717, 0.982937>,
      <-0.5, 0.866025, 0.35>, <-0.408249, 0.707108, 0.577349>
   }
   
   smooth_triangle {
      <-0.5, 0.866025, 0.35>, <-0.408248, 0.707105, 0.577352>,
      <-0.5, 0.866025, 0.4>, <-0.408249, 0.707108, -0.577349>,
      <-0.866026, 0.5, 0.35>, <-0.707107, 0.408248, 0.57735>
   }
   
   smooth_triangle {
      <-1.12583, 0.65, 0.45>, <0.22109, -0.127646, 0.966864>,
      <-1.42894, 0.825, 0.45>, <-0.467266, 0.269776, 0.841952>,
      <-0.65, 1.12583, 0.45>, <0.127646, -0.22109, 0.966864>
   }
   
   smooth_triangle {
      <-0.65, 1.12583, 0.45>, <0.127646, -0.221089, 0.966864>,
      <-0.55, 0.952628, 0.35>, <0.0919715, -0.159299, 0.982937>,
      <-1.12583, 0.65, 0.45>, <0.22109, -0.127646, 0.966864>
   }
   
   smooth_triangle {
      <-0.952628, 0.55, 0.35>, <0.159299, -0.0919714, 0.982937>,
      <-1.12583, 0.65, 0.45>, <0.22109, -0.127646, 0.966864>,
      <-0.55, 0.952628, 0.35>, <0.0919715, -0.159299, 0.982937>
   }
   
   smooth_triangle {
      <-0.866026, 0.5, 0.4>, <-0.707107, 0.408248, -0.577351>,
      <-0.866026, 0.5, 0.35>, <-0.707107, 0.408248, 0.57735>,
      <-0.5, 0.866025, 0.4>, <-0.408249, 0.707108, -0.577349>
   }
   
   smooth_triangle {
      <-1.12583, 0.65, 0.5>, <-0.227567, 0.131385, -0.964858>,
      <-0.952628, 0.55, 0.4>, <-0.1593, 0.0919715, -0.982937>,
      <-0.65, 1.12583, 0.5>, <-0.131386, 0.227567, -0.964858>
   }
   
   smooth_triangle {
      <-0.65, 1.12583, 0.5>, <-0.131386, 0.227567, -0.964858>,
      <-0.850001, 1.47224, 0.5>, <0.278289, -0.482011, -0.830795>,
      <-1.12583, 0.65, 0.5>, <-0.227567, 0.131386, -0.964858>
   }
   
   smooth_triangle {
      <-1.47224, 0.85, 0.5>, <0.482012, -0.27829, -0.830794>,
      <-1.12583, 0.65, 0.5>, <-0.227567, 0.131386, -0.964858>,
      <-0.850001, 1.47224, 0.5>, <0.278289, -0.482011, -0.830795>
   }
   
   smooth_triangle {
      <-0.5, 0.866025, 0.4>, <-0.408248, 0.707106, -0.577352>,
      <-0.55, 0.952628, 0.4>, <-0.0919714, 0.159299, -0.982937>,
      <-0.866026, 0.5, 0.4>, <-0.707107, 0.408248, -0.577351>
   }
   
   smooth_triangle {
      <-0.952628, 0.55, 0.4>, <-0.1593, 0.0919716, -0.982937>,
      <-0.866026, 0.5, 0.4>, <-0.707107, 0.408248, -0.577351>,
      <-0.55, 0.952628, 0.4>, <-0.0919714, 0.159299, -0.982937>
   }
   
   smooth_triangle {
      <-0.55, 0.952628, 0.4>, <-0.0919715, 0.159299, -0.982937>,
      <-0.65, 1.12583, 0.5>, <-0.131386, 0.227567, -0.964858>,
      <-0.952628, 0.55, 0.4>, <-0.1593, 0.0919715, -0.982937>
   }
   
   smooth_triangle {
      <-0.825001, 1.42894, 0.45>, <-0.269777, 0.467266, 0.841952>,
      <-0.65, 1.12583, 0.45>, <0.127646, -0.22109, 0.966864>,
      <-1.42894, 0.825, 0.45>, <-0.467266, 0.269776, 0.841952>
   }
   
   smooth_triangle {
      <-0.5, 0.866025, -0.35>, <-0.408248, 0.707105, -0.577353>,
      <-0.55, 0.952628, -0.35>, <0.0919717, -0.1593, -0.982937>,
      <-0.866026, 0.5, -0.35>, <-0.707107, 0.408248, -0.57735>
   }
   
   smooth_triangle {
      <-0.952628, 0.55, -0.35>, <0.1593, -0.0919713, -0.982937>,
      <-0.866026, 0.5, -0.35>, <-0.707107, 0.408248, -0.57735>,
      <-0.55, 0.952628, -0.35>, <0.0919717, -0.1593, -0.982937>
   }
   
   smooth_triangle {
      <-0.55, 0.952628, -0.35>, <0.0919714, -0.159299, -0.982937>,
      <-0.65, 1.12583, -0.45>, <0.127646, -0.22109, -0.966864>,
      <-0.952628, 0.55, -0.35>, <0.1593, -0.0919713, -0.982937>
   }
   
   smooth_triangle {
      <-0.866026, 0.5, -0.4>, <-0.707107, 0.408248, 0.577351>,
      <-0.952628, 0.55, -0.4>, <-0.1593, 0.0919718, 0.982937>,
      <-0.5, 0.866025, -0.4>, <-0.408249, 0.707108, 0.577348>
   }
   
   smooth_triangle {
      <-0.5, 0.866025, -0.4>, <-0.408248, 0.707105, 0.577352>,
      <-0.5, 0.866025, -0.35>, <-0.408249, 0.707108, -0.577348>,
      <-0.866026, 0.5, -0.4>, <-0.707106, 0.408248, 0.577351>
   }
   
   smooth_triangle {
      <-0.866026, 0.5, -0.35>, <-0.707106, 0.408248, -0.577351>,
      <-0.866026, 0.5, -0.4>, <-0.707106, 0.408248, 0.577351>,
      <-0.5, 0.866025, -0.35>, <-0.408249, 0.707108, -0.577348>
   }
   
   smooth_triangle {
      <-1.12583, 0.65, -0.45>, <0.22109, -0.127646, -0.966864>,
      <-0.952628, 0.55, -0.35>, <0.1593, -0.0919713, -0.982937>,
      <-0.65, 1.12583, -0.45>, <0.127646, -0.22109, -0.966864>
   }
   
   smooth_triangle {
      <-1.55885, 0.9, 3.93402e-08>, <-0.866026, 0.5, 0>,
      <-1.42894, 0.825, -0.45>, <-0.467267, 0.269776, -0.841952>,
      <-0.900001, 1.55885, 6.81393e-08>, <-0.5, 0.866025, 0>
   }
   
   smooth_triangle {
      <-0.900001, 1.55885, 6.81393e-08>, <-0.5, 0.866025, 0>,
      <-0.825001, 1.42894, 0.45>, <-0.269777, 0.467267, 0.841952>,
      <-1.55885, 0.9, 3.93402e-08>, <-0.866026, 0.5, 1.98682e-07>
   }
   
   smooth_triangle {
      <-1.42894, 0.825, 0.45>, <-0.467266, 0.269776, 0.841952>,
      <-1.55885, 0.9, 3.93402e-08>, <-0.866026, 0.5, 1.98682e-07>,
      <-0.825001, 1.42894, 0.45>, <-0.269777, 0.467267, 0.841952>
   }
   
   smooth_triangle {
      <-0.65, 1.12583, -0.45>, <0.127646, -0.22109, -0.966864>,
      <-0.825001, 1.42894, -0.45>, <-0.269777, 0.467266, -0.841952>,
      <-1.12583, 0.65, -0.45>, <0.22109, -0.127646, -0.966864>
   }
   
   smooth_triangle {
      <-1.42894, 0.825, -0.45>, <-0.467266, 0.269776, -0.841952>,
      <-1.12583, 0.65, -0.45>, <0.22109, -0.127646, -0.966864>,
      <-0.825001, 1.42894, -0.45>, <-0.269777, 0.467266, -0.841952>
   }
   
   smooth_triangle {
      <-0.825001, 1.42894, -0.45>, <-0.269776, 0.467266, -0.841952>,
      <-0.900001, 1.55885, 6.81393e-08>, <-0.5, 0.866025, 0>,
      <-1.42894, 0.825, -0.45>, <-0.467267, 0.269776, -0.841952>
   }
   
   smooth_triangle {
      <-1.9676e-08, 1.65, -0.45>, <0, 0.539552, -0.841952>,
      <-1.55023e-08, 1.3, -0.45>, <1.40461e-07, -0.255292, -0.966864>,
      <0.825, 1.42894, -0.45>, <0.269777, 0.467266, -0.841952>
   }
   
   smooth_triangle {
      <0.825, 1.42894, -0.45>, <0.269776, 0.467266, -0.841952>,
      <0.9, 1.55885, 6.81393e-08>, <0.5, 0.866025, 0>,
      <-1.9676e-08, 1.65, -0.45>, <0, 0.539553, -0.841952>
   }
   
   smooth_triangle {
      <-2.14648e-08, 1.8, 7.86805e-08>, <0, 1, 0>,
      <-1.9676e-08, 1.65, -0.45>, <0, 0.539553, -0.841952>,
      <0.9, 1.55885, 6.81393e-08>, <0.5, 0.866025, 0>
   }
   
   smooth_triangle {
      <0.55, 0.952628, -0.35>, <-0.0919716, -0.159299, -0.982937>,
      <0.65, 1.12583, -0.45>, <-0.127646, -0.22109, -0.966864>,
      <-1.31174e-08, 1.1, -0.35>, <-1.19606e-07, -0.183943, -0.982937>
   }
   
   smooth_triangle {
      <-1.55023e-08, 1.3, -0.45>, <1.40461e-07, -0.255292, -0.966864>,
      <-1.31174e-08, 1.1, -0.35>, <-1.19606e-07, -0.183943, -0.982937>,
      <0.65, 1.12583, -0.45>, <-0.127646, -0.22109, -0.966864>
   }
   
   smooth_triangle {
      <0.65, 1.12583, -0.45>, <-0.127646, -0.22109, -0.966864>,
      <0.825, 1.42894, -0.45>, <0.269777, 0.467266, -0.841952>,
      <-1.55023e-08, 1.3, -0.45>, <1.40461e-07, -0.255292, -0.966864>
   }
   
   smooth_triangle {
      <0.9, 1.55885, 6.81393e-08>, <0.5, 0.866025, 0>,
      <0.825, 1.42894, 0.45>, <0.269777, 0.467267, 0.841952>,
      <-2.14648e-08, 1.8, 7.86805e-08>, <0, 1, 0>
   }
   
   smooth_triangle {
      <0.65, 1.12583, 0.45>, <-0.127646, -0.221089, 0.966864>,
      <0.55, 0.952628, 0.35>, <-0.0919713, -0.159299, 0.982937>,
      <-1.55023e-08, 1.3, 0.45>, <1.40461e-07, -0.255292, 0.966864>
   }
   
   smooth_triangle {
      <-1.31174e-08, 1.1, 0.35>, <-1.19606e-07, -0.183944, 0.982937>,
      <-1.55023e-08, 1.3, 0.45>, <1.40461e-07, -0.255292, 0.966864>,
      <0.55, 0.952628, 0.35>, <-0.0919713, -0.159299, 0.982937>
   }
   
   smooth_triangle {
      <0.55, 0.952628, 0.35>, <-0.0919714, -0.1593, 0.982937>,
      <0.5, 0.866026, 0.35>, <0.408248, 0.707106, 0.577351>,
      <-1.31174e-08, 1.1, 0.35>, <-1.19605e-07, -0.183943, 0.982937>
   }
   
   smooth_triangle {
      <-1.9676e-08, 1.65, 0.45>, <0, 0.539552, 0.841952>,
      <-2.14648e-08, 1.8, 7.86805e-08>, <0, 1, 0>,
      <0.825, 1.42894, 0.45>, <0.269777, 0.467267, 0.841952>
   }
   
   smooth_triangle {
      <0.825, 1.42894, 0.45>, <0.269777, 0.467266, 0.841952>,
      <0.65, 1.12583, 0.45>, <-0.127646, -0.22109, 0.966864>,
      <-1.9676e-08, 1.65, 0.45>, <0, 0.539552, 0.841952>
   }
   
   smooth_triangle {
      <-1.55023e-08, 1.3, 0.45>, <1.40461e-07, -0.255292, 0.966864>,
      <-1.9676e-08, 1.65, 0.45>, <0, 0.539552, 0.841952>,
      <0.65, 1.12583, 0.45>, <-0.127646, -0.22109, 0.966864>
   }
   
   smooth_triangle {
      <-1.31174e-08, 1.1, -0.35>, <-1.19605e-07, -0.183942, -0.982937>,
      <-1.19249e-08, 1, -0.35>, <0, 0.816498, -0.577348>,
      <0.55, 0.952628, -0.35>, <-0.0919714, -0.159299, -0.982937>
   }
   
   smooth_triangle {
      <-2.02723e-08, 1.7, 0.5>, <-2.34175e-07, 0.556579, 0.830794>,
      <-2.2061e-08, 1.85, 8.08661e-08>, <0, 1, 0>,
      <0.85, 1.47224, 0.5>, <0.27829, 0.482012, 0.830795>
   }
   
   smooth_triangle {
      <0.85, 1.47224, -0.5>, <-0.278289, -0.482011, 0.830795>,
      <0.65, 1.12583, -0.5>, <0.131386, 0.227567, 0.964858>,
      <-2.02723e-08, 1.7, -0.5>, <2.34174e-07, -0.556579, 0.830795>
   }
   
   smooth_triangle {
      <-1.55023e-08, 1.3, -0.5>, <-1.44576e-07, 0.262771, 0.964858>,
      <-2.02723e-08, 1.7, -0.5>, <2.34174e-07, -0.556579, 0.830795>,
      <0.65, 1.12583, -0.5>, <0.131386, 0.227567, 0.964858>
   }
   
   smooth_triangle {
      <0.925, 1.60215, 7.00321e-08>, <-0.5, -0.866026, 0>,
      <0.85, 1.47224, -0.5>, <-0.278289, -0.482011, 0.830795>,
      <-2.2061e-08, 1.85, 8.08661e-08>, <0, -1, 0>
   }
   
   smooth_triangle {
      <-2.02723e-08, 1.7, -0.5>, <2.34174e-07, -0.556578, 0.830795>,
      <-2.2061e-08, 1.85, 8.08661e-08>, <0, -1, 0>,
      <0.85, 1.47224, -0.5>, <-0.278289, -0.482011, 0.830795>
   }
   
   smooth_triangle {
      <0.925, 1.60215, 7.00321e-08>, <0.5, 0.866026, 0>,
      <0.85, 1.47224, 0.5>, <0.27829, 0.482012, 0.830795>,
      <-2.2061e-08, 1.85, 8.08661e-08>, <0, 1, 0>
   }
   
   smooth_triangle {
      <0.65, 1.12583, -0.5>, <0.131386, 0.227567, 0.964858>,
      <0.55, 0.952628, -0.4>, <0.0919715, 0.159299, 0.982937>,
      <-1.55023e-08, 1.3, -0.5>, <-1.44576e-07, 0.262771, 0.964858>
   }
   
   smooth_triangle {
      <0.5, 0.866026, -0.4>, <0.408248, 0.707107, 0.57735>,
      <0.5, 0.866026, -0.35>, <0.408249, 0.707109, -0.577348>,
      <-1.19249e-08, 1, -0.4>, <0, 0.816494, 0.577353>
   }
   
   smooth_triangle {
      <-1.19249e-08, 1, -0.35>, <0, 0.816494, -0.577354>,
      <-1.19249e-08, 1, -0.4>, <0, 0.816494, 0.577353>,
      <0.5, 0.866026, -0.35>, <0.408249, 0.707109, -0.577348>
   }
   
   smooth_triangle {
      <0.5, 0.866026, -0.35>, <0.408249, 0.707108, -0.577348>,
      <0.55, 0.952628, -0.35>, <-0.0919714, -0.159299, -0.982937>,
      <-1.19249e-08, 1, -0.35>, <0, 0.816498, -0.577348>
   }
   
   smooth_triangle {
      <-1.31174e-08, 1.1, -0.4>, <1.19605e-07, 0.183943, 0.982937>,
      <-1.55023e-08, 1.3, -0.5>, <-1.44576e-07, 0.262771, 0.964858>,
      <0.55, 0.952628, -0.4>, <0.0919715, 0.159299, 0.982937>
   }
   
   smooth_triangle {
      <0.55, 0.952628, -0.4>, <0.0919717, 0.159299, 0.982937>,
      <0.5, 0.866026, -0.4>, <0.408248, 0.707106, 0.577351>,
      <-1.31174e-08, 1.1, -0.4>, <1.19605e-07, 0.183943, 0.982937>
   }
   
   smooth_triangle {
      <-1.19249e-08, 1, -0.4>, <0, 0.816495, 0.577353>,
      <-1.31174e-08, 1.1, -0.4>, <1.19605e-07, 0.183943, 0.982937>,
      <0.5, 0.866026, -0.4>, <0.408248, 0.707106, 0.577351>
   }
   
   smooth_triangle {
      <-1.31174e-08, 1.1, -0.4>, <0, 0.183943, 0.982937>,
      <-1.19249e-08, 1, -0.4>, <0, 0.816495, 0.577353>,
      <-0.55, 0.952628, -0.4>, <-0.0919718, 0.159299, 0.982937>
   }
   
   smooth_triangle {
      <-0.5, 0.866025, -0.4>, <-0.408249, 0.707108, 0.577348>,
      <-0.55, 0.952628, -0.4>, <-0.0919718, 0.159299, 0.982937>,
      <-1.19249e-08, 1, -0.4>, <0, 0.816495, 0.577353>
   }
   
   smooth_triangle {
      <-1.19249e-08, 1, -0.4>, <0, 0.816494, 0.577353>,
      <-1.19249e-08, 1, -0.35>, <0, 0.816494, -0.577354>,
      <-0.5, 0.866025, -0.4>, <-0.408247, 0.707106, 0.577352>
   }
   
   smooth_triangle {
      <-0.65, 1.12583, -0.5>, <-0.131386, 0.227567, 0.964858>,
      <-0.850001, 1.47224, -0.5>, <0.27829, -0.482011, 0.830795>,
      <-1.55023e-08, 1.3, -0.5>, <-1.44576e-07, 0.262771, 0.964858>
   }
   
   smooth_triangle {
      <-1.55023e-08, 1.3, -0.5>, <-1.44576e-07, 0.262771, 0.964858>,
      <-1.31174e-08, 1.1, -0.4>, <0, 0.183943, 0.982937>,
      <-0.65, 1.12583, -0.5>, <-0.131386, 0.227567, 0.964858>
   }
   
   smooth_triangle {
      <-0.55, 0.952628, -0.4>, <-0.0919716, 0.159299, 0.982937>,
      <-0.65, 1.12583, -0.5>, <-0.131386, 0.227567, 0.964858>,
      <-1.31174e-08, 1.1, -0.4>, <0, 0.183943, 0.982937>
   }
   
   smooth_triangle {
      <-0.5, 0.866025, -0.35>, <-0.408249, 0.707108, -0.577348>,
      <-0.5, 0.866025, -0.4>, <-0.408247, 0.707106, 0.577352>,
      <-1.19249e-08, 1, -0.35>, <0, 0.816494, -0.577354>
   }
   
   smooth_triangle {
      <-0.65, 1.12583, -0.45>, <0.127646, -0.22109, -0.966864>,
      <-0.55, 0.952628, -0.35>, <0.0919714, -0.159299, -0.982937>,
      <-1.55023e-08, 1.3, -0.45>, <1.40461e-07, -0.255292, -0.966864>
   }
   
   smooth_triangle {
      <-1.55023e-08, 1.3, -0.45>, <1.40461e-07, -0.255292, -0.966864>,
      <-1.9676e-08, 1.65, -0.45>, <0, 0.539552, -0.841952>,
      <-0.65, 1.12583, -0.45>, <0.127646, -0.22109, -0.966864>
   }
   
   smooth_triangle {
      <-0.825001, 1.42894, -0.45>, <-0.269776, 0.467267, -0.841952>,
      <-0.65, 1.12583, -0.45>, <0.127646, -0.22109, -0.966864>,
      <-1.9676e-08, 1.65, -0.45>, <0, 0.539552, -0.841952>
   }
   
   smooth_triangle {
      <-1.19249e-08, 1, -0.35>, <0, 0.816498, -0.577348>,
      <-1.31174e-08, 1.1, -0.35>, <0, -0.183942, -0.982937>,
      <-0.5, 0.866025, -0.35>, <-0.408247, 0.707105, -0.577353>
   }
   
   smooth_triangle {
      <-0.55, 0.952628, -0.35>, <0.0919717, -0.1593, -0.982937>,
      <-0.5, 0.866025, -0.35>, <-0.408247, 0.707105, -0.577353>,
      <-1.31174e-08, 1.1, -0.35>, <0, -0.183942, -0.982937>
   }
   
   smooth_triangle {
      <-1.31174e-08, 1.1, -0.35>, <0, -0.183943, -0.982937>,
      <-1.55023e-08, 1.3, -0.45>, <1.40461e-07, -0.255292, -0.966864>,
      <-0.55, 0.952628, -0.35>, <0.0919714, -0.159299, -0.982937>
   }
   
   smooth_triangle {
      <-2.02723e-08, 1.7, -0.5>, <0, -0.556579, 0.830795>,
      <-1.55023e-08, 1.3, -0.5>, <-1.44576e-07, 0.262771, 0.964858>,
      <-0.850001, 1.47224, -0.5>, <0.27829, -0.482011, 0.830795>
   }
   
   smooth_triangle {
      <0.5, 0.866026, 0.4>, <0.408249, 0.707108, -0.577349>,
      <0.55, 0.952628, 0.4>, <0.091971, 0.159299, -0.982937>,
      <-1.19249e-08, 1, 0.4>, <0, 0.816497, -0.577349>
   }
   
   smooth_triangle {
      <-1.31174e-08, 1.1, 0.4>, <1.19606e-07, 0.183944, -0.982937>,
      <-1.19249e-08, 1, 0.4>, <0, 0.816497, -0.577349>,
      <0.55, 0.952628, 0.4>, <0.091971, 0.159299, -0.982937>
   }
   
   smooth_triangle {
      <0.55, 0.952628, 0.4>, <0.0919713, 0.1593, -0.982937>,
      <0.65, 1.12583, 0.5>, <0.131386, 0.227567, -0.964858>,
      <-1.31174e-08, 1.1, 0.4>, <1.19606e-07, 0.183943, -0.982937>
   }
   
   smooth_triangle {
      <-1.19249e-08, 1, 0.35>, <0, 0.816495, 0.577352>,
      <-1.31174e-08, 1.1, 0.35>, <-1.19605e-07, -0.183943, 0.982937>,
      <0.5, 0.866026, 0.35>, <0.408248, 0.707106, 0.577351>
   }
   
   smooth_triangle {
      <0.5, 0.866026, 0.35>, <0.408248, 0.707107, 0.57735>,
      <0.5, 0.866026, 0.4>, <0.408249, 0.707108, -0.577349>,
      <-1.19249e-08, 1, 0.35>, <0, 0.816494, 0.577353>
   }
   
   smooth_triangle {
      <-1.19249e-08, 1, 0.4>, <0, 0.816494, -0.577353>,
      <-1.19249e-08, 1, 0.35>, <0, 0.816494, 0.577353>,
      <0.5, 0.866026, 0.4>, <0.408249, 0.707108, -0.577349>
   }
   
   smooth_triangle {
      <-1.55023e-08, 1.3, 0.5>, <-1.44576e-07, 0.262771, -0.964858>,
      <-1.31174e-08, 1.1, 0.4>, <1.19606e-07, 0.183943, -0.982937>,
      <0.65, 1.12583, 0.5>, <0.131386, 0.227567, -0.964858>
   }
   
   smooth_triangle {
      <-0.850001, 1.47224, -0.5>, <0.27829, -0.482011, 0.830795>,
      <-0.925001, 1.60215, 7.0032e-08>, <0.5, -0.866025, 0>,
      <-2.02723e-08, 1.7, -0.5>, <0, -0.556578, 0.830795>
   }
   
   smooth_triangle {
      <-2.2061e-08, 1.85, 8.08661e-08>, <3.86625e-07, 1, -4.1207e-21>,
      <-2.02723e-08, 1.7, 0.5>, <0, 0.556579, 0.830794>,
      <-0.925001, 1.60215, 7.0032e-08>, <-0.5, 0.866025, 0>
   }
   
   smooth_triangle {
      <-0.850001, 1.47224, 0.5>, <-0.27829, 0.482011, 0.830795>,
      <-0.925001, 1.60215, 7.0032e-08>, <-0.5, 0.866025, 0>,
      <-2.02723e-08, 1.7, 0.5>, <0, 0.556579, 0.830794>
   }
   
   smooth_triangle {
      <0.65, 1.12583, 0.5>, <0.131385, 0.227566, -0.964858>,
      <0.85, 1.47224, 0.5>, <-0.278289, -0.482011, -0.830795>,
      <-1.55023e-08, 1.3, 0.5>, <-1.44576e-07, 0.262771, -0.964858>
   }
   
   smooth_triangle {
      <-2.02723e-08, 1.7, 0.5>, <2.34174e-07, -0.556578, -0.830796>,
      <-1.55023e-08, 1.3, 0.5>, <-1.44576e-07, 0.262771, -0.964858>,
      <0.85, 1.47224, 0.5>, <-0.278289, -0.482011, -0.830795>
   }
   
   smooth_triangle {
      <-2.2061e-08, 1.85, 8.08661e-08>, <-3.86625e-07, -1, -4.1207e-21>,
      <-2.02723e-08, 1.7, -0.5>, <0, -0.556578, 0.830795>,
      <-0.925001, 1.60215, 7.0032e-08>, <0.5, -0.866025, 0>
   }
   
   smooth_triangle {
      <-1.47224, 0.85, 0.5>, <-0.482012, 0.278289, 0.830794>,
      <-1.12583, 0.65, 0.5>, <0.227567, -0.131386, 0.964858>,
      <-1.7, -2.18557e-08, 0.5>, <-0.556578, 0, 0.830795>
   }
   
   smooth_triangle {
      <-1.60215, -0.925, -4.0433e-08>, <0.866025, 0.5, 0>,
      <-1.47224, -0.85, -0.5>, <0.482011, 0.278289, 0.830795>,
      <-0.925, -1.60215, -7.00321e-08>, <0.5, 0.866025, 0>
   }
   
   smooth_triangle {
      <-0.85, -1.47224, -0.5>, <0.278289, 0.482011, 0.830795>,
      <-0.925, -1.60215, -7.00321e-08>, <0.5, 0.866025, 0>,
      <-1.47224, -0.85, -0.5>, <0.482011, 0.278289, 0.830795>
   }
   
   smooth_triangle {
      <-1.3, -2.18557e-08, 0.5>, <-0.262771, 0, -0.964858>,
      <-1.7, -2.18557e-08, 0.5>, <0.556578, 8.73869e-08, -0.830795>,
      <-1.12583, -0.65, 0.5>, <-0.227567, -0.131386, -0.964858>
   }
   
   smooth_triangle {
      <-1.47224, -0.85, 0.5>, <0.482012, 0.27829, -0.830794>,
      <-1.12583, -0.65, 0.5>, <-0.227567, -0.131386, -0.964858>,
      <-1.7, -2.18557e-08, 0.5>, <0.556578, 8.73869e-08, -0.830795>
   }
   
   smooth_triangle {
      <-1.3, -2.18557e-08, 0.5>, <0.262771, 0, 0.964858>,
      <-1.7, -2.18557e-08, 0.5>, <-0.556578, 0, 0.830795>,
      <-1.12583, 0.65, 0.5>, <0.227567, -0.131386, 0.964858>
   }
   
   smooth_triangle {
      <-1.60215, -0.925, -4.0433e-08>, <-0.866025, -0.5, 0>,
      <-1.47224, -0.85, 0.5>, <-0.482011, -0.278289, 0.830795>,
      <-0.925, -1.60215, -7.00321e-08>, <-0.5, -0.866025, 0>
   }
   
   smooth_triangle {
      <-1.12583, -0.65, -0.5>, <-0.227567, -0.131386, 0.964858>,
      <-0.952628, -0.55, -0.4>, <-0.159299, -0.0919713, 0.982937>,
      <-0.65, -1.12583, -0.5>, <-0.131386, -0.227567, 0.964858>
   }
   
   smooth_triangle {
      <-0.55, -0.952628, -0.4>, <-0.0919717, -0.1593, 0.982937>,
      <-0.65, -1.12583, -0.5>, <-0.131386, -0.227567, 0.964858>,
      <-0.952628, -0.55, -0.4>, <-0.159299, -0.0919713, 0.982937>
   }
   
   smooth_triangle {
      <-0.952628, -0.55, -0.4>, <-0.1593, -0.0919718, 0.982937>,
      <-0.866025, -0.5, -0.4>, <-0.707108, -0.408249, 0.577349>,
      <-0.55, -0.952628, -0.4>, <-0.0919714, -0.159299, 0.982937>
   }
   
   smooth_triangle {
      <-0.85, -1.47224, 0.5>, <-0.278289, -0.482011, 0.830795>,
      <-0.925, -1.60215, -7.00321e-08>, <-0.5, -0.866025, 0>,
      <-1.47224, -0.85, 0.5>, <-0.482011, -0.278289, 0.830795>
   }
   
   smooth_triangle {
      <-1.47224, -0.85, -0.5>, <0.482011, 0.278289, 0.830795>,
      <-1.12583, -0.65, -0.5>, <-0.227567, -0.131386, 0.964858>,
      <-0.85, -1.47224, -0.5>, <0.278289, 0.482011, 0.830795>
   }
   
   smooth_triangle {
      <-0.65, -1.12583, -0.5>, <-0.131386, -0.227567, 0.964858>,
      <-0.85, -1.47224, -0.5>, <0.278289, 0.482011, 0.830795>,
      <-1.12583, -0.65, -0.5>, <-0.227567, -0.131386, 0.964858>
   }
   
   smooth_triangle {
      <-1.12583, 0.65, 0.5>, <0.227567, -0.131386, 0.964858>,
      <-0.952628, 0.55, 0.4>, <0.1593, -0.0919715, 0.982937>,
      <-1.3, -2.18557e-08, 0.5>, <0.262772, 0, 0.964858>
   }
   
   smooth_triangle {
      <-0.866025, -0.5, 0.4>, <-0.707107, -0.408248, -0.577351>,
      <-0.866025, -0.5, 0.35>, <-0.707107, -0.408248, 0.577351>,
      <-1, -1.74846e-08, 0.4>, <-0.816494, -4.80763e-07, -0.577353>
   }
   
   smooth_triangle {
      <-1, -1.5299e-08, 0.35>, <0.816496, 0, -0.577352>,
      <-1, -1.74846e-08, 0.4>, <0.816494, 0, 0.577353>,
      <-0.866026, 0.5, 0.35>, <0.707107, -0.408248, -0.57735>
   }
   
   smooth_triangle {
      <-0.866026, 0.5, 0.4>, <0.707107, -0.408248, 0.577351>,
      <-0.866026, 0.5, 0.35>, <0.707107, -0.408248, -0.57735>,
      <-1, -1.74846e-08, 0.4>, <0.816494, 0, 0.577353>
   }
   
   smooth_triangle {
      <-1.1, -1.5299e-08, 0.35>, <-0.183943, 4.0179e-08, -0.982937>,
      <-1, -1.5299e-08, 0.35>, <0.816495, 0, -0.577352>,
      <-0.952628, 0.55, 0.35>, <-0.1593, 0.0919717, -0.982937>
   }
   
   smooth_triangle {
      <-0.866026, 0.5, 0.35>, <0.707107, -0.408248, -0.57735>,
      <-0.952628, 0.55, 0.35>, <-0.1593, 0.0919717, -0.982937>,
      <-1, -1.5299e-08, 0.35>, <0.816495, 0, -0.577352>
   }
   
   smooth_triangle {
      <-1, -1.5299e-08, 0.35>, <-0.816496, -7.9048e-07, 0.577352>,
      <-1, -1.74846e-08, 0.4>, <-0.816494, -4.80763e-07, -0.577353>,
      <-0.866025, -0.5, 0.35>, <-0.707107, -0.408248, 0.577351>
   }
   
   smooth_triangle {
      <-1, -1.74846e-08, 0.4>, <-0.816495, -4.80764e-07, -0.577352>,
      <-1.1, -1.74846e-08, 0.4>, <-0.183943, 1.19606e-07, -0.982937>,
      <-0.866025, -0.5, 0.4>, <-0.707108, -0.408249, -0.577349>
   }
   
   smooth_triangle {
      <-1.1, -1.74846e-08, 0.4>, <-0.183943, 1.19605e-07, -0.982937>,
      <-1.3, -2.18557e-08, 0.5>, <-0.262772, 0, -0.964858>,
      <-0.952628, -0.55, 0.4>, <-0.159299, -0.0919714, -0.982937>
   }
   
   smooth_triangle {
      <-1.12583, -0.65, 0.5>, <-0.227567, -0.131386, -0.964858>,
      <-0.952628, -0.55, 0.4>, <-0.159299, -0.0919714, -0.982937>,
      <-1.3, -2.18557e-08, 0.5>, <-0.262772, 0, -0.964858>
   }
   
   smooth_triangle {
      <-1.1, -1.74846e-08, 0.4>, <0.183943, -4.0179e-08, 0.982937>,
      <-1.3, -2.18557e-08, 0.5>, <0.262772, 0, 0.964858>,
      <-0.952628, 0.55, 0.4>, <0.1593, -0.0919715, 0.982937>
   }
   
   smooth_triangle {
      <-0.952628, -0.55, 0.4>, <-0.1593, -0.0919717, -0.982937>,
      <-0.866025, -0.5, 0.4>, <-0.707108, -0.408249, -0.577349>,
      <-1.1, -1.74846e-08, 0.4>, <-0.183943, 1.19606e-07, -0.982937>
   }
   
   smooth_triangle {
      <-1, -1.74846e-08, 0.4>, <0.816495, 0, 0.577352>,
      <-1.1, -1.74846e-08, 0.4>, <0.183943, -4.01785e-08, 0.982937>,
      <-0.866026, 0.5, 0.4>, <0.707107, -0.408248, 0.577351>
   }
   
   smooth_triangle {
      <-0.952628, 0.55, 0.4>, <0.1593, -0.0919715, 0.982937>,
      <-0.866026, 0.5, 0.4>, <0.707107, -0.408248, 0.577351>,
      <-1.1, -1.74846e-08, 0.4>, <0.183943, -4.01785e-08, 0.982937>
   }
   
   smooth_triangle {
      <-0.952628, -0.55, 0.35>, <0.1593, 0.0919718, 0.982937>,
      <-0.866025, -0.5, 0.35>, <-0.707107, -0.408249, 0.577349>,
      <-0.55, -0.952628, 0.35>, <0.0919712, 0.159299, 0.982937>
   }
   
   smooth_triangle {
      <-0.5, -0.866026, 0.35>, <-0.408248, -0.707107, 0.577351>,
      <-0.55, -0.952628, 0.35>, <0.0919712, 0.159299, 0.982937>,
      <-0.866025, -0.5, 0.35>, <-0.707107, -0.408249, 0.577349>
   }
   
   smooth_triangle {
      <-0.866025, -0.5, 0.35>, <-0.707106, -0.408248, 0.577351>,
      <-0.866025, -0.5, 0.4>, <-0.707106, -0.408248, -0.577351>,
      <-0.5, -0.866026, 0.35>, <-0.408248, -0.707107, 0.577351>
   }
   
   smooth_triangle {
      <-0.65, -1.12583, 0.45>, <0.127646, 0.221089, 0.966864>,
      <-0.825, -1.42894, 0.45>, <-0.269776, -0.467267, 0.841952>,
      <-1.12583, -0.65, 0.45>, <0.22109, 0.127646, 0.966864>
   }
   
   smooth_triangle {
      <-1.12583, -0.65, 0.45>, <0.22109, 0.127646, 0.966864>,
      <-0.952628, -0.55, 0.35>, <0.159299, 0.0919713, 0.982937>,
      <-0.65, -1.12583, 0.45>, <0.127646, 0.22109, 0.966864>
   }
   
   smooth_triangle {
      <-0.55, -0.952628, 0.35>, <0.0919715, 0.159299, 0.982937>,
      <-0.65, -1.12583, 0.45>, <0.127646, 0.22109, 0.966864>,
      <-0.952628, -0.55, 0.35>, <0.159299, 0.0919713, 0.982937>
   }
   
   smooth_triangle {
      <-0.5, -0.866026, 0.4>, <-0.408247, -0.707105, -0.577353>,
      <-0.5, -0.866026, 0.35>, <-0.408248, -0.707107, 0.577351>,
      <-0.866025, -0.5, 0.4>, <-0.707106, -0.408248, -0.577351>
   }
   
   smooth_triangle {
      <-0.65, -1.12583, 0.5>, <-0.131386, -0.227567, -0.964858>,
      <-0.55, -0.952628, 0.4>, <-0.0919714, -0.159299, -0.982937>,
      <-1.12583, -0.65, 0.5>, <-0.227567, -0.131386, -0.964858>
   }
   
   smooth_triangle {
      <-1.12583, -0.65, 0.5>, <-0.227567, -0.131386, -0.964858>,
      <-1.47224, -0.85, 0.5>, <0.482012, 0.27829, -0.830794>,
      <-0.65, -1.12583, 0.5>, <-0.131386, -0.227567, -0.964858>
   }
   
   smooth_triangle {
      <-0.85, -1.47224, 0.5>, <0.27829, 0.482012, -0.830794>,
      <-0.65, -1.12583, 0.5>, <-0.131386, -0.227567, -0.964858>,
      <-1.47224, -0.85, 0.5>, <0.482012, 0.27829, -0.830794>
   }
   
   smooth_triangle {
      <-0.866025, -0.5, 0.4>, <-0.707108, -0.408249, -0.577349>,
      <-0.952628, -0.55, 0.4>, <-0.1593, -0.0919715, -0.982937>,
      <-0.5, -0.866026, 0.4>, <-0.408249, -0.707108, -0.577348>
   }
   
   smooth_triangle {
      <-0.55, -0.952628, 0.4>, <-0.0919713, -0.159299, -0.982937>,
      <-0.5, -0.866026, 0.4>, <-0.408249, -0.707108, -0.577348>,
      <-0.952628, -0.55, 0.4>, <-0.1593, -0.0919715, -0.982937>
   }
   
   smooth_triangle {
      <-0.952628, -0.55, 0.4>, <-0.159299, -0.0919712, -0.982937>,
      <-1.12583, -0.65, 0.5>, <-0.227567, -0.131386, -0.964858>,
      <-0.55, -0.952628, 0.4>, <-0.0919714, -0.159299, -0.982937>
   }
   
   smooth_triangle {
      <-1.42894, -0.825, 0.45>, <-0.467266, -0.269776, 0.841952>,
      <-1.12583, -0.65, 0.45>, <0.22109, 0.127646, 0.966864>,
      <-0.825, -1.42894, 0.45>, <-0.269776, -0.467267, 0.841952>
   }
   
   smooth_triangle {
      <-0.866025, -0.5, -0.35>, <-0.707108, -0.408249, -0.577348>,
      <-0.952628, -0.55, -0.35>, <0.1593, 0.0919715, -0.982937>,
      <-0.5, -0.866026, -0.35>, <-0.408249, -0.707109, -0.577347>
   }
   
   smooth_triangle {
      <-0.55, -0.952628, -0.35>, <0.0919715, 0.159299, -0.982937>,
      <-0.5, -0.866026, -0.35>, <-0.408249, -0.707109, -0.577347>,
      <-0.952628, -0.55, -0.35>, <0.1593, 0.0919715, -0.982937>
   }
   
   smooth_triangle {
      <-0.952628, -0.55, -0.35>, <0.159299, 0.0919712, -0.982937>,
      <-1.12583, -0.65, -0.45>, <0.221089, 0.127646, -0.966864>,
      <-0.55, -0.952628, -0.35>, <0.0919713, 0.159299, -0.982937>
   }
   
   smooth_triangle {
      <-0.5, -0.866026, -0.4>, <-0.408248, -0.707107, 0.577351>,
      <-0.55, -0.952628, -0.4>, <-0.0919714, -0.159299, 0.982937>,
      <-0.866025, -0.5, -0.4>, <-0.707108, -0.408249, 0.577349>
   }
   
   smooth_triangle {
      <-0.866025, -0.5, -0.4>, <-0.707106, -0.408248, 0.577352>,
      <-0.866025, -0.5, -0.35>, <-0.707106, -0.408248, -0.577352>,
      <-0.5, -0.866026, -0.4>, <-0.408248, -0.707106, 0.577351>
   }
   
   smooth_triangle {
      <-0.5, -0.866026, -0.35>, <-0.408247, -0.707105, -0.577354>,
      <-0.5, -0.866026, -0.4>, <-0.408248, -0.707106, 0.577351>,
      <-0.866025, -0.5, -0.35>, <-0.707106, -0.408248, -0.577352>
   }
   
   smooth_triangle {
      <-0.65, -1.12583, -0.45>, <0.127646, 0.22109, -0.966864>,
      <-0.55, -0.952628, -0.35>, <0.0919713, 0.159299, -0.982937>,
      <-1.12583, -0.65, -0.45>, <0.221089, 0.127646, -0.966864>
   }
   
   smooth_triangle {
      <-0.9, -1.55885, -6.81393e-08>, <-0.5, -0.866025, 0>,
      <-0.825, -1.42894, -0.45>, <-0.269776, -0.467267, -0.841951>,
      <-1.55885, -0.9, -3.93403e-08>, <-0.866026, -0.5, -6.88255e-07>
   }
   
   smooth_triangle {
      <-1.55885, -0.9, -3.93403e-08>, <-0.866026, -0.5, 6.88255e-07>,
      <-1.42894, -0.825, 0.45>, <-0.467266, -0.269776, 0.841952>,
      <-0.9, -1.55885, -6.81393e-08>, <-0.5, -0.866025, 1.98682e-07>
   }
   
   smooth_triangle {
      <-0.825, -1.42894, 0.45>, <-0.269776, -0.467266, 0.841952>,
      <-0.9, -1.55885, -6.81393e-08>, <-0.5, -0.866025, 1.98682e-07>,
      <-1.42894, -0.825, 0.45>, <-0.467266, -0.269776, 0.841952>
   }
   
   smooth_triangle {
      <-1.12583, -0.65, -0.45>, <0.221089, 0.127646, -0.966864>,
      <-1.42894, -0.825, -0.45>, <-0.467266, -0.269776, -0.841952>,
      <-0.65, -1.12583, -0.45>, <0.127646, 0.22109, -0.966864>
   }
   
   smooth_triangle {
      <-0.825, -1.42894, -0.45>, <-0.269776, -0.467266, -0.841952>,
      <-0.65, -1.12583, -0.45>, <0.127646, 0.22109, -0.966864>,
      <-1.42894, -0.825, -0.45>, <-0.467266, -0.269776, -0.841952>
   }
   
   smooth_triangle {
      <-1.42894, -0.825, -0.45>, <-0.467267, -0.269776, -0.841952>,
      <-1.55885, -0.9, -3.93403e-08>, <-0.866026, -0.5, -6.88255e-07>,
      <-0.825, -1.42894, -0.45>, <-0.269776, -0.467267, -0.841951>
   }
   
   smooth_triangle {
      <-0.866025, -0.5, -0.4>, <-0.707108, -0.408249, 0.577349>,
      <-0.952628, -0.55, -0.4>, <-0.1593, -0.0919719, 0.982937>,
      <-1, 1.74845e-08, -0.4>, <-0.816495, -4.80764e-07, 0.577352>
   }
   
   smooth_triangle {
      <-1.1, 1.74845e-08, -0.4>, <0.183943, 1.19605e-07, -0.982937>,
      <-1, 1.74845e-08, -0.4>, <0.816495, 2.06477e-07, -0.577352>,
      <-0.952628, 0.55, -0.4>, <0.1593, -0.0919715, -0.982937>
   }
   
   smooth_triangle {
      <-0.866026, 0.5, -0.4>, <0.707107, -0.408248, -0.577351>,
      <-0.952628, 0.55, -0.4>, <0.1593, -0.0919715, -0.982937>,
      <-1, 1.74845e-08, -0.4>, <0.816495, 2.06477e-07, -0.577352>
   }
   
   smooth_triangle {
      <-1.3, 2.18557e-08, -0.5>, <0.262772, 1.32715e-07, -0.964858>,
      <-1.1, 1.74845e-08, -0.4>, <0.183944, 1.19606e-07, -0.982937>,
      <-1.12583, 0.65, -0.5>, <0.227567, -0.131386, -0.964858>
   }
   
   smooth_triangle {
      <-0.952628, 0.55, -0.4>, <0.1593, -0.0919713, -0.982937>,
      <-1.12583, 0.65, -0.5>, <0.227567, -0.131386, -0.964858>,
      <-1.1, 1.74845e-08, -0.4>, <0.183944, 1.19606e-07, -0.982937>
   }
   
   smooth_triangle {
      <-1.1, 1.74845e-08, -0.4>, <-0.183943, 1.19605e-07, 0.982937>,
      <-1, 1.74845e-08, -0.4>, <-0.816495, -4.80764e-07, 0.577352>,
      <-0.952628, -0.55, -0.4>, <-0.1593, -0.0919719, 0.982937>
   }
   
   smooth_triangle {
      <-1, 1.74845e-08, -0.4>, <-0.816496, -4.80764e-07, 0.577352>,
      <-1, 1.5299e-08, -0.35>, <-0.816494, -5.84002e-07, -0.577354>,
      <-0.866025, -0.5, -0.4>, <-0.707106, -0.408248, 0.577352>
   }
   
   smooth_triangle {
      <-1, 1.5299e-08, -0.35>, <-0.816495, -5.84003e-07, -0.577352>,
      <-1.1, 1.5299e-08, -0.35>, <0.183942, 4.01791e-08, -0.982937>,
      <-0.866025, -0.5, -0.35>, <-0.707108, -0.408249, -0.577348>
   }
   
   smooth_triangle {
      <-0.952628, -0.55, -0.35>, <0.1593, 0.0919717, -0.982937>,
      <-0.866025, -0.5, -0.35>, <-0.707108, -0.408249, -0.577348>,
      <-1.1, 1.5299e-08, -0.35>, <0.183942, 4.01791e-08, -0.982937>
   }
   
   smooth_triangle {
      <-1, 1.5299e-08, -0.35>, <0.816495, -1.03239e-07, 0.577352>,
      <-1.1, 1.5299e-08, -0.35>, <-0.183942, -1.19605e-07, 0.982937>,
      <-0.866026, 0.5, -0.35>, <0.707107, -0.408248, 0.57735>
   }
   
   smooth_triangle {
      <-0.866025, -0.5, -0.35>, <-0.707106, -0.408248, -0.577352>,
      <-0.866025, -0.5, -0.4>, <-0.707106, -0.408248, 0.577352>,
      <-1, 1.5299e-08, -0.35>, <-0.816494, -5.84002e-07, -0.577354>
   }
   
   smooth_triangle {
      <-1, 1.74845e-08, -0.4>, <0.816496, 2.06477e-07, -0.577352>,
      <-1, 1.5299e-08, -0.35>, <0.816494, -1.03239e-07, 0.577354>,
      <-0.866026, 0.5, -0.4>, <0.707107, -0.408248, -0.577351>
   }
   
   smooth_triangle {
      <-0.866026, 0.5, -0.35>, <0.707107, -0.408248, 0.577351>,
      <-0.866026, 0.5, -0.4>, <0.707107, -0.408248, -0.577351>,
      <-1, 1.5299e-08, -0.35>, <0.816494, -1.03239e-07, 0.577354>
   }
   
   smooth_triangle {
      <-0.952628, -0.55, -0.4>, <-0.159299, -0.0919715, 0.982937>,
      <-1.12583, -0.65, -0.5>, <-0.227567, -0.131386, 0.964858>,
      <-1.1, 1.74845e-08, -0.4>, <-0.183944, 1.19606e-07, 0.982937>
   }
   
   smooth_triangle {
      <-1.47224, 0.85, -0.5>, <-0.482011, 0.278289, -0.830795>,
      <-1.60215, 0.925, 4.0433e-08>, <-0.866026, 0.5, -6.1943e-07>,
      <-1.7, 2.18557e-08, -0.5>, <-0.556578, 8.73869e-08, -0.830795>
   }
   
   smooth_triangle {
      <-1.85, 0, 0>, <-1, 0, 0>,
      <-1.7, -2.18557e-08, 0.5>, <-0.556579, -8.73868e-08, 0.830794>,
      <-1.60215, -0.925, -4.0433e-08>, <-0.866025, -0.5, 0>
   }
   
   smooth_triangle {
      <-1.47224, -0.85, 0.5>, <-0.482011, -0.278289, 0.830795>,
      <-1.60215, -0.925, -4.0433e-08>, <-0.866025, -0.5, 0>,
      <-1.7, -2.18557e-08, 0.5>, <-0.556579, -8.73868e-08, 0.830794>
   }
   
   smooth_triangle {
      <-1.85, 0, 0>, <1, 0, 0>,
      <-1.7, 2.18557e-08, -0.5>, <0.556578, 0, 0.830795>,
      <-1.60215, -0.925, -4.0433e-08>, <0.866025, 0.5, 0>
   }
   
   smooth_triangle {
      <-1.47224, -0.85, -0.5>, <0.482011, 0.278289, 0.830795>,
      <-1.60215, -0.925, -4.0433e-08>, <0.866025, 0.5, 0>,
      <-1.7, 2.18557e-08, -0.5>, <0.556578, 0, 0.830795>
   }
   
   smooth_triangle {
      <-1.85, 0, 0>, <-1, 0, 0>,
      <-1.7, 2.18557e-08, -0.5>, <-0.556578, 8.73869e-08, -0.830795>,
      <-1.60215, 0.925, 4.0433e-08>, <-0.866026, 0.5, -6.1943e-07>
   }
   
   smooth_triangle {
      <-1.85, 0, 0>, <1, 0, 0>,
      <-1.7, -2.18557e-08, 0.5>, <0.556579, 0, -0.830794>,
      <-1.60215, 0.925, 4.0433e-08>, <0.866026, -0.5, 6.1943e-07>
   }
   
   smooth_triangle {
      <-1.7, 2.18557e-08, -0.5>, <-0.556578, 8.73869e-08, -0.830795>,
      <-1.3, 2.18557e-08, -0.5>, <0.262771, 1.32715e-07, -0.964858>,
      <-1.47224, 0.85, -0.5>, <-0.482011, 0.278289, -0.830795>
   }
   
   smooth_triangle {
      <-1.12583, 0.65, -0.5>, <0.227567, -0.131386, -0.964858>,
      <-1.47224, 0.85, -0.5>, <-0.482011, 0.278289, -0.830795>,
      <-1.3, 2.18557e-08, -0.5>, <0.262771, 1.32715e-07, -0.964858>
   }
   
   smooth_triangle {
      <-1.3, 2.18557e-08, -0.5>, <-0.262772, 0, 0.964858>,
      <-1.1, 1.74845e-08, -0.4>, <-0.183944, 1.19606e-07, 0.982937>,
      <-1.12583, -0.65, -0.5>, <-0.227567, -0.131386, 0.964858>
   }
   
   smooth_triangle {
      <-1.47224, 0.85, 0.5>, <0.482011, -0.278289, -0.830795>,
      <-1.60215, 0.925, 4.0433e-08>, <0.866026, -0.5, 6.1943e-07>,
      <-1.7, -2.18557e-08, 0.5>, <0.556579, 0, -0.830794>
   }
   
   smooth_triangle {
      <-1.7, 2.18557e-08, -0.5>, <0.556578, 0, 0.830795>,
      <-1.3, 2.18557e-08, -0.5>, <-0.262771, 0, 0.964858>,
      <-1.47224, -0.85, -0.5>, <0.482011, 0.278289, 0.830795>
   }
   
   smooth_triangle {
      <-1.12583, -0.65, -0.5>, <-0.227567, -0.131386, 0.964858>,
      <-1.47224, -0.85, -0.5>, <0.482011, 0.278289, 0.830795>,
      <-1.3, 2.18557e-08, -0.5>, <-0.262771, 0, 0.964858>
   }
   
   smooth_triangle {
      <-1.65, -1.96701e-08, 0.45>, <-0.539553, -2.3389e-07, 0.841952>,
      <-1.3, -1.96701e-08, 0.45>, <0.255292, 0, 0.966864>,
      <-1.42894, -0.825, 0.45>, <-0.467266, -0.269776, 0.841952>
   }
   
   smooth_triangle {
      <-1.12583, -0.65, 0.45>, <0.22109, 0.127646, 0.966864>,
      <-1.42894, -0.825, 0.45>, <-0.467266, -0.269776, 0.841952>,
      <-1.3, -1.96701e-08, 0.45>, <0.255292, 0, 0.966864>
   }
   
   smooth_triangle {
      <-1.65, -1.96701e-08, 0.45>, <0.539553, 2.3389e-07, -0.841952>,
      <-1.3, -1.96701e-08, 0.45>, <-0.255292, 0, -0.966864>,
      <-1.42894, 0.825, 0.45>, <0.467266, -0.269776, -0.841952>
   }
   
   smooth_triangle {
      <-1.42894, -0.825, 0.45>, <-0.467266, -0.269776, 0.841952>,
      <-1.55885, -0.9, -3.93403e-08>, <-0.866026, -0.5, 6.88255e-07>,
      <-1.65, -1.96701e-08, 0.45>, <-0.539553, -2.3389e-07, 0.841952>
   }
   
   smooth_triangle {
      <-1.8, 0, 0>, <1, 0, 0>,
      <-1.65, -1.96701e-08, 0.45>, <0.539553, 2.3389e-07, -0.841952>,
      <-1.55885, 0.9, 3.93402e-08>, <0.866026, -0.5, -1.98682e-07>
   }
   
   smooth_triangle {
      <-1.42894, 0.825, 0.45>, <0.467266, -0.269776, -0.841952>,
      <-1.55885, 0.9, 3.93402e-08>, <0.866026, -0.5, -1.98682e-07>,
      <-1.65, -1.96701e-08, 0.45>, <0.539553, 2.3389e-07, -0.841952>
   }
   
   smooth_triangle {
      <-1.12583, 0.65, 0.45>, <-0.22109, 0.127646, -0.966864>,
      <-1.42894, 0.825, 0.45>, <0.467266, -0.269776, -0.841952>,
      <-1.3, -1.96701e-08, 0.45>, <-0.255292, 0, -0.966864>
   }
   
   smooth_triangle {
      <-0.952628, 0.55, 0.35>, <-0.159299, 0.0919714, -0.982937>,
      <-1.12583, 0.65, 0.45>, <-0.22109, 0.127646, -0.966864>,
      <-1.1, -1.5299e-08, 0.35>, <-0.183943, 4.01786e-08, -0.982937>
   }
   
   smooth_triangle {
      <-1.1, -1.5299e-08, 0.35>, <0.183943, -1.19606e-07, 0.982937>,
      <-1, -1.5299e-08, 0.35>, <-0.816495, -7.9048e-07, 0.577352>,
      <-0.952628, -0.55, 0.35>, <0.1593, 0.0919719, 0.982937>
   }
   
   smooth_triangle {
      <-0.866025, -0.5, 0.35>, <-0.707107, -0.408248, 0.577349>,
      <-0.952628, -0.55, 0.35>, <0.1593, 0.0919719, 0.982937>,
      <-1, -1.5299e-08, 0.35>, <-0.816495, -7.9048e-07, 0.577352>
   }
   
   smooth_triangle {
      <-1.3, -1.96701e-08, 0.45>, <0.255292, 0, 0.966864>,
      <-1.1, -1.5299e-08, 0.35>, <0.183943, -1.19606e-07, 0.982937>,
      <-1.12583, -0.65, 0.45>, <0.22109, 0.127646, 0.966864>
   }
   
   smooth_triangle {
      <-0.952628, -0.55, 0.35>, <0.159299, 0.0919715, 0.982937>,
      <-1.12583, -0.65, 0.45>, <0.22109, 0.127646, 0.966864>,
      <-1.1, -1.5299e-08, 0.35>, <0.183943, -1.19606e-07, 0.982937>
   }
   
   smooth_triangle {
      <-1.3, -1.96701e-08, 0.45>, <-0.255292, 0, -0.966864>,
      <-1.1, -1.5299e-08, 0.35>, <-0.183943, 4.01786e-08, -0.982937>,
      <-1.12583, 0.65, 0.45>, <-0.22109, 0.127646, -0.966864>
   }
   
   smooth_triangle {
      <-1.8, 0, 0>, <-1, 0, 0>,
      <-1.65, -1.96701e-08, 0.45>, <-0.539553, -2.3389e-07, 0.841952>,
      <-1.55885, -0.9, -3.93403e-08>, <-0.866026, -0.5, 6.88255e-07>
   }
   
   smooth_triangle {
      <-1.1, 1.5299e-08, -0.35>, <-0.183943, -1.19606e-07, 0.982937>,
      <-1.3, 1.96701e-08, -0.45>, <-0.255292, 0, 0.966864>,
      <-0.952628, 0.55, -0.35>, <-0.159299, 0.0919714, 0.982937>
   }
   
   smooth_triangle {
      <-1.12583, 0.65, -0.45>, <-0.22109, 0.127646, 0.966864>,
      <-0.952628, 0.55, -0.35>, <-0.159299, 0.0919714, 0.982937>,
      <-1.3, 1.96701e-08, -0.45>, <-0.255292, 0, 0.966864>
   }
   
   smooth_triangle {
      <-1.3, 1.96701e-08, -0.45>, <0.255292, 0, -0.966864>,
      <-1.65, 1.96701e-08, -0.45>, <-0.539552, -2.3389e-07, -0.841952>,
      <-1.12583, -0.65, -0.45>, <0.22109, 0.127646, -0.966864>
   }
   
   smooth_triangle {
      <-0.952628, 0.55, -0.35>, <-0.159299, 0.0919714, 0.982937>,
      <-0.866026, 0.5, -0.35>, <0.707107, -0.408248, 0.57735>,
      <-1.1, 1.5299e-08, -0.35>, <-0.183942, -1.19605e-07, 0.982937>
   }
   
   smooth_triangle {
      <-1.1, 1.5299e-08, -0.35>, <0.183943, 4.01786e-08, -0.982937>,
      <-1.3, 1.96701e-08, -0.45>, <0.255292, 0, -0.966864>,
      <-0.952628, -0.55, -0.35>, <0.159299, 0.0919714, -0.982937>
   }
   
   smooth_triangle {
      <-1.12583, -0.65, -0.45>, <0.22109, 0.127646, -0.966864>,
      <-0.952628, -0.55, -0.35>, <0.159299, 0.0919714, -0.982937>,
      <-1.3, 1.96701e-08, -0.45>, <0.255292, 0, -0.966864>
   }
   
   smooth_triangle {
      <-1.42894, -0.825, -0.45>, <-0.467266, -0.269776, -0.841952>,
      <-1.12583, -0.65, -0.45>, <0.22109, 0.127646, -0.966864>,
      <-1.65, 1.96701e-08, -0.45>, <-0.539552, -2.3389e-07, -0.841952>
   }
   
   smooth_triangle {
      <-1.55885, -0.9, -3.93403e-08>, <-0.866026, -0.5, -6.88255e-07>,
      <-1.42894, -0.825, -0.45>, <-0.467267, -0.269776, -0.841952>,
      <-1.8, 0, 0>, <-1, 0, 0>
   }
   
   smooth_triangle {
      <-1.65, 1.96701e-08, -0.45>, <0.539554, 2.3389e-07, 0.841951>,
      <-1.8, 0, 0>, <1, 0, 0>,
      <-1.42894, 0.825, -0.45>, <0.467267, -0.269776, 0.841952>
   }
   
   smooth_triangle {
      <-1.55885, 0.9, 3.93402e-08>, <0.866026, -0.5, 0>,
      <-1.42894, 0.825, -0.45>, <0.467267, -0.269776, 0.841952>,
      <-1.8, 0, 0>, <1, 0, 0>
   }
   
   smooth_triangle {
      <-1.3, 1.96701e-08, -0.45>, <-0.255292, 0, 0.966864>,
      <-1.65, 1.96701e-08, -0.45>, <0.539552, 2.3389e-07, 0.841952>,
      <-1.12583, 0.65, -0.45>, <-0.22109, 0.127646, 0.966864>
   }
   
   smooth_triangle {
      <-1.42894, 0.825, -0.45>, <0.467266, -0.269776, 0.841952>,
      <-1.12583, 0.65, -0.45>, <-0.22109, 0.127646, 0.966864>,
      <-1.65, 1.96701e-08, -0.45>, <0.539552, 2.3389e-07, 0.841952>
   }
   
   smooth_triangle {
      <-1.65, 1.96701e-08, -0.45>, <-0.539554, -2.3389e-07, -0.841951>,
      <-1.8, 0, 0>, <-1, 0, 0>,
      <-1.42894, -0.825, -0.45>, <-0.467267, -0.269776, -0.841952>
   }
   
   smooth_triangle {
      <0.85, -1.47224, 0.5>, <-0.27829, 0.482012, -0.830794>,
      <0.65, -1.12583, 0.5>, <0.131386, -0.227567, -0.964858>,
      <7.43094e-08, -1.7, 0.5>, <-3.21561e-07, 0.556578, -0.830795>
   }
   
   smooth_triangle {
      <0.925, -1.60215, -7.00321e-08>, <-0.5, 0.866025, 0>,
      <0.85, -1.47224, -0.5>, <-0.27829, 0.482011, 0.830795>,
      <1.60215, -0.925, -4.0433e-08>, <-0.866026, 0.5, -1.78814e-07>
   }
   
   smooth_triangle {
      <1.47224, -0.85, -0.5>, <-0.482011, 0.278289, 0.830795>,
      <1.60215, -0.925, -4.0433e-08>, <-0.866026, 0.5, -1.78814e-07>,
      <0.85, -1.47224, -0.5>, <-0.27829, 0.482011, 0.830795>
   }
   
   smooth_triangle {
      <4.80825e-08, -1.1, 0.4>, <0, -0.183942, -0.982937>,
      <5.68248e-08, -1.3, 0.5>, <0, -0.262771, -0.964858>,
      <0.55, -0.952628, 0.4>, <0.0919715, -0.159299, -0.982937>
   }
   
   smooth_triangle {
      <0.65, -1.12583, 0.5>, <0.131386, -0.227567, -0.964858>,
      <0.55, -0.952628, 0.4>, <0.0919715, -0.159299, -0.982937>,
      <5.68248e-08, -1.3, 0.5>, <0, -0.262771, -0.964858>
   }
   
   smooth_triangle {
      <5.68248e-08, -1.3, 0.5>, <0, -0.262771, -0.964858>,
      <7.43094e-08, -1.7, 0.5>, <-3.21561e-07, 0.556578, -0.830795>,
      <0.65, -1.12583, 0.5>, <0.131386, -0.227567, -0.964858>
   }
   
   smooth_triangle {
      <0.925, -1.60215, -7.00321e-08>, <0.5, -0.866025, 0>,
      <0.85, -1.47224, 0.5>, <0.27829, -0.482011, 0.830795>,
      <1.60215, -0.925, -4.0433e-08>, <0.866026, -0.5, 0>
   }
   
   smooth_triangle {
      <0.65, -1.12583, -0.5>, <0.131385, -0.227567, 0.964858>,
      <0.55, -0.952628, -0.4>, <0.0919714, -0.159299, 0.982937>,
      <1.12583, -0.65, -0.5>, <0.227567, -0.131386, 0.964858>
   }
   
   smooth_triangle {
      <0.952628, -0.55, -0.4>, <0.1593, -0.0919716, 0.982937>,
      <1.12583, -0.65, -0.5>, <0.227567, -0.131386, 0.964858>,
      <0.55, -0.952628, -0.4>, <0.0919714, -0.159299, 0.982937>
   }
   
   smooth_triangle {
      <0.55, -0.952628, -0.4>, <0.0919717, -0.1593, 0.982937>,
      <0.5, -0.866026, -0.4>, <0.408249, -0.707106, 0.57735>,
      <0.952628, -0.55, -0.4>, <0.159299, -0.0919713, 0.982937>
   }
   
   smooth_triangle {
      <1.47224, -0.85, 0.5>, <0.482012, -0.27829, 0.830795>,
      <1.60215, -0.925, -4.0433e-08>, <0.866026, -0.5, 0>,
      <0.85, -1.47224, 0.5>, <0.27829, -0.482011, 0.830795>
   }
   
   smooth_triangle {
      <0.85, -1.47224, -0.5>, <-0.27829, 0.482011, 0.830795>,
      <0.65, -1.12583, -0.5>, <0.131386, -0.227567, 0.964858>,
      <1.47224, -0.85, -0.5>, <-0.482011, 0.278289, 0.830795>
   }
   
   smooth_triangle {
      <1.12583, -0.65, -0.5>, <0.227567, -0.131386, 0.964858>,
      <1.47224, -0.85, -0.5>, <-0.482011, 0.278289, 0.830795>,
      <0.65, -1.12583, -0.5>, <0.131386, -0.227567, 0.964858>
   }
   
   smooth_triangle {
      <0.55, -0.952628, 0.4>, <0.0919718, -0.159299, -0.982937>,
      <0.5, -0.866026, 0.4>, <0.408248, -0.707107, -0.57735>,
      <4.80825e-08, -1.1, 0.4>, <0, -0.183943, -0.982937>
   }
   
   smooth_triangle {
      <0.825, -1.42894, 0.45>, <0.269776, -0.467266, 0.841952>,
      <0.9, -1.55885, -6.81393e-08>, <0.5, -0.866026, 1.98682e-07>,
      <7.21238e-08, -1.65, 0.45>, <0, -0.539552, 0.841952>
   }
   
   smooth_triangle {
      <7.21238e-08, -1.65, 0.45>, <0, -0.539552, 0.841952>,
      <5.68248e-08, -1.3, 0.45>, <0, 0.255292, 0.966864>,
      <0.825, -1.42894, 0.45>, <0.269776, -0.467266, 0.841952>
   }
   
   smooth_triangle {
      <0.65, -1.12583, 0.45>, <-0.127646, 0.221089, 0.966864>,
      <0.825, -1.42894, 0.45>, <0.269776, -0.467266, 0.841952>,
      <5.68248e-08, -1.3, 0.45>, <0, 0.255292, 0.966864>
   }
   
   smooth_triangle {
      <7.21238e-08, -1.65, -0.45>, <0, -0.539552, -0.841952>,
      <7.86805e-08, -1.8, -7.86805e-08>, <3.97364e-07, -1, -1.8823e-20>,
      <0.825, -1.42894, -0.45>, <0.269777, -0.467267, -0.841951>
   }
   
   smooth_triangle {
      <0.9, -1.55885, -6.81393e-08>, <0.5, -0.866026, 0>,
      <0.825, -1.42894, -0.45>, <0.269777, -0.467267, -0.841951>,
      <7.86805e-08, -1.8, -7.86805e-08>, <3.97364e-07, -1, -1.8823e-20>
   }
   
   smooth_triangle {
      <7.86805e-08, -1.8, -7.86805e-08>, <3.97364e-07, -1, 1.8823e-20>,
      <7.21238e-08, -1.65, 0.45>, <0, -0.539552, 0.841952>,
      <0.9, -1.55885, -6.81393e-08>, <0.5, -0.866026, 1.98682e-07>
   }
   
   smooth_triangle {
      <5.68248e-08, -1.3, 0.45>, <0, 0.255292, 0.966864>,
      <4.80825e-08, -1.1, 0.35>, <-1.59784e-07, 0.183943, 0.982937>,
      <0.65, -1.12583, 0.45>, <-0.127646, 0.22109, 0.966864>
   }
   
   smooth_triangle {
      <4.37114e-08, -1, 0.35>, <0, -0.816494, 0.577353>,
      <4.37114e-08, -1, 0.4>, <0, -0.816494, -0.577353>,
      <0.5, -0.866026, 0.35>, <0.408248, -0.707107, 0.577351>
   }
   
   smooth_triangle {
      <0.5, -0.866026, 0.4>, <0.408247, -0.707105, -0.577353>,
      <0.5, -0.866026, 0.35>, <0.408248, -0.707107, 0.577351>,
      <4.37114e-08, -1, 0.4>, <0, -0.816494, -0.577353>
   }
   
   smooth_triangle {
      <4.37114e-08, -1, 0.4>, <0, -0.816497, -0.577349>,
      <4.80825e-08, -1.1, 0.4>, <0, -0.183943, -0.982937>,
      <0.5, -0.866026, 0.4>, <0.408248, -0.707107, -0.57735>
   }
   
   smooth_triangle {
      <0.55, -0.952628, 0.35>, <-0.0919717, 0.159299, 0.982937>,
      <0.65, -1.12583, 0.45>, <-0.127646, 0.22109, 0.966864>,
      <4.80825e-08, -1.1, 0.35>, <-1.59784e-07, 0.183943, 0.982937>
   }
   
   smooth_triangle {
      <4.80825e-08, -1.1, 0.35>, <-1.59784e-07, 0.183943, 0.982937>,
      <4.37114e-08, -1, 0.35>, <0, -0.816495, 0.577352>,
      <0.55, -0.952628, 0.35>, <-0.0919719, 0.1593, 0.982937>
   }
   
   smooth_triangle {
      <0.5, -0.866026, 0.35>, <0.408248, -0.707106, 0.577351>,
      <0.55, -0.952628, 0.35>, <-0.0919719, 0.1593, 0.982937>,
      <4.37114e-08, -1, 0.35>, <0, -0.816495, 0.577352>
   }
   
   smooth_triangle {
      <0.55, -0.952628, 0.35>, <-0.0919717, 0.1593, 0.982937>,
      <0.5, -0.866026, 0.35>, <0.408249, -0.707106, 0.577351>,
      <0.952628, -0.55, 0.35>, <-0.159299, 0.0919713, 0.982937>
   }
   
   smooth_triangle {
      <0.866026, -0.5, 0.35>, <0.707107, -0.408248, 0.577351>,
      <0.952628, -0.55, 0.35>, <-0.159299, 0.0919713, 0.982937>,
      <0.5, -0.866026, 0.35>, <0.408249, -0.707106, 0.577351>
   }
   
   smooth_triangle {
      <0.5, -0.866026, 0.35>, <0.408249, -0.707106, 0.577351>,
      <0.5, -0.866026, 0.4>, <0.408248, -0.707105, -0.577353>,
      <0.866026, -0.5, 0.35>, <0.707106, -0.408248, 0.577351>
   }
   
   smooth_triangle {
      <1.12583, -0.65, 0.45>, <-0.22109, 0.127646, 0.966864>,
      <1.42894, -0.825, 0.45>, <0.467266, -0.269776, 0.841952>,
      <0.65, -1.12583, 0.45>, <-0.127646, 0.221089, 0.966864>
   }
   
   smooth_triangle {
      <0.65, -1.12583, 0.45>, <-0.127646, 0.221089, 0.966864>,
      <0.55, -0.952628, 0.35>, <-0.0919714, 0.159299, 0.982937>,
      <1.12583, -0.65, 0.45>, <-0.221089, 0.127646, 0.966864>
   }
   
   smooth_triangle {
      <0.952628, -0.55, 0.35>, <-0.159299, 0.0919716, 0.982937>,
      <1.12583, -0.65, 0.45>, <-0.221089, 0.127646, 0.966864>,
      <0.55, -0.952628, 0.35>, <-0.0919714, 0.159299, 0.982937>
   }
   
   smooth_triangle {
      <0.866026, -0.5, 0.4>, <0.707105, -0.408247, -0.577353>,
      <0.866026, -0.5, 0.35>, <0.707106, -0.408248, 0.577351>,
      <0.5, -0.866026, 0.4>, <0.408248, -0.707105, -0.577353>
   }
   
   smooth_triangle {
      <1.12583, -0.65, 0.5>, <0.227567, -0.131386, -0.964858>,
      <0.952628, -0.55, 0.4>, <0.159299, -0.0919712, -0.982937>,
      <0.65, -1.12583, 0.5>, <0.131386, -0.227567, -0.964858>
   }
   
   smooth_triangle {
      <0.65, -1.12583, 0.5>, <0.131386, -0.227567, -0.964858>,
      <0.85, -1.47224, 0.5>, <-0.27829, 0.482012, -0.830794>,
      <1.12583, -0.65, 0.5>, <0.227567, -0.131385, -0.964858>
   }
   
   smooth_triangle {
      <1.47224, -0.85, 0.5>, <-0.482011, 0.278289, -0.830796>,
      <1.12583, -0.65, 0.5>, <0.227567, -0.131385, -0.964858>,
      <0.85, -1.47224, 0.5>, <-0.27829, 0.482012, -0.830794>
   }
   
   smooth_triangle {
      <0.5, -0.866026, 0.4>, <0.408249, -0.707107, -0.57735>,
      <0.55, -0.952628, 0.4>, <0.0919714, -0.159299, -0.982937>,
      <0.866026, -0.5, 0.4>, <0.707108, -0.408249, -0.577349>
   }
   
   smooth_triangle {
      <0.952628, -0.55, 0.4>, <0.159299, -0.0919711, -0.982937>,
      <0.866026, -0.5, 0.4>, <0.707108, -0.408249, -0.577349>,
      <0.55, -0.952628, 0.4>, <0.0919714, -0.159299, -0.982937>
   }
   
   smooth_triangle {
      <0.55, -0.952628, 0.4>, <0.0919712, -0.159299, -0.982937>,
      <0.65, -1.12583, 0.5>, <0.131386, -0.227567, -0.964858>,
      <0.952628, -0.55, 0.4>, <0.159299, -0.0919712, -0.982937>
   }
   
   smooth_triangle {
      <0.825, -1.42894, 0.45>, <0.269776, -0.467266, 0.841952>,
      <0.65, -1.12583, 0.45>, <-0.127646, 0.221089, 0.966864>,
      <1.42894, -0.825, 0.45>, <0.467266, -0.269776, 0.841952>
   }
   
   smooth_triangle {
      <0.5, -0.866026, -0.35>, <0.408249, -0.707107, -0.577349>,
      <0.55, -0.952628, -0.35>, <-0.0919717, 0.1593, -0.982937>,
      <0.866026, -0.5, -0.35>, <0.707108, -0.408249, -0.577348>
   }
   
   smooth_triangle {
      <0.952628, -0.55, -0.35>, <-0.159299, 0.0919712, -0.982937>,
      <0.866026, -0.5, -0.35>, <0.707108, -0.408249, -0.577348>,
      <0.55, -0.952628, -0.35>, <-0.0919717, 0.1593, -0.982937>
   }
   
   smooth_triangle {
      <0.55, -0.952628, -0.35>, <-0.0919714, 0.159299, -0.982937>,
      <0.65, -1.12583, -0.45>, <-0.127646, 0.22109, -0.966864>,
      <0.952628, -0.55, -0.35>, <-0.1593, 0.0919716, -0.982937>
   }
   
   smooth_triangle {
      <0.866026, -0.5, -0.4>, <0.707107, -0.408248, 0.57735>,
      <0.952628, -0.55, -0.4>, <0.159299, -0.0919713, 0.982937>,
      <0.5, -0.866026, -0.4>, <0.408249, -0.707106, 0.57735>
   }
   
   smooth_triangle {
      <0.5, -0.866026, -0.4>, <0.408248, -0.707106, 0.577352>,
      <0.5, -0.866026, -0.35>, <0.408248, -0.707104, -0.577354>,
      <0.866026, -0.5, -0.4>, <0.707106, -0.408248, 0.577351>
   }
   
   smooth_triangle {
      <0.866026, -0.5, -0.35>, <0.707105, -0.408247, -0.577353>,
      <0.866026, -0.5, -0.4>, <0.707106, -0.408248, 0.577351>,
      <0.5, -0.866026, -0.35>, <0.408248, -0.707104, -0.577354>
   }
   
   smooth_triangle {
      <1.12583, -0.65, -0.45>, <-0.22109, 0.127646, -0.966864>,
      <0.952628, -0.55, -0.35>, <-0.1593, 0.0919716, -0.982937>,
      <0.65, -1.12583, -0.45>, <-0.127646, 0.22109, -0.966864>
   }
   
   smooth_triangle {
      <1.55885, -0.9, -3.93402e-08>, <0.866026, -0.5, 0>,
      <1.42894, -0.825, -0.45>, <0.467267, -0.269776, -0.841952>,
      <0.9, -1.55885, -6.81393e-08>, <0.5, -0.866025, 0>
   }
   
   smooth_triangle {
      <0.9, -1.55885, -6.81393e-08>, <0.5, -0.866025, 1.98682e-07>,
      <0.825, -1.42894, 0.45>, <0.269776, -0.467266, 0.841952>,
      <1.55885, -0.9, -3.93402e-08>, <0.866026, -0.5, 0>
   }
   
   smooth_triangle {
      <1.42894, -0.825, 0.45>, <0.467267, -0.269776, 0.841952>,
      <1.55885, -0.9, -3.93402e-08>, <0.866026, -0.5, 0>,
      <0.825, -1.42894, 0.45>, <0.269776, -0.467266, 0.841952>
   }
   
   smooth_triangle {
      <0.65, -1.12583, -0.45>, <-0.127646, 0.221089, -0.966864>,
      <0.825, -1.42894, -0.45>, <0.269776, -0.467266, -0.841952>,
      <1.12583, -0.65, -0.45>, <-0.22109, 0.127646, -0.966864>
   }
   
   smooth_triangle {
      <1.42894, -0.825, -0.45>, <0.467266, -0.269776, -0.841952>,
      <1.12583, -0.65, -0.45>, <-0.22109, 0.127646, -0.966864>,
      <0.825, -1.42894, -0.45>, <0.269776, -0.467266, -0.841952>
   }
   
   smooth_triangle {
      <0.825, -1.42894, -0.45>, <0.269777, -0.467267, -0.841951>,
      <0.9, -1.55885, -6.81393e-08>, <0.5, -0.866025, 0>,
      <1.42894, -0.825, -0.45>, <0.467267, -0.269776, -0.841952>
   }
   
   smooth_triangle {
      <7.21238e-08, -1.65, -0.45>, <0, -0.539553, -0.841951>,
      <5.68248e-08, -1.3, -0.45>, <0, 0.255292, -0.966864>,
      <-0.825, -1.42894, -0.45>, <-0.269776, -0.467266, -0.841952>
   }
   
   smooth_triangle {
      <-0.825, -1.42894, -0.45>, <-0.269777, -0.467267, -0.841951>,
      <-0.9, -1.55885, -6.81393e-08>, <-0.5, -0.866025, 0>,
      <7.21238e-08, -1.65, -0.45>, <0, -0.539552, -0.841952>
   }
   
   smooth_triangle {
      <7.86805e-08, -1.8, -7.86805e-08>, <0, -1, 0>,
      <7.21238e-08, -1.65, -0.45>, <0, -0.539552, -0.841952>,
      <-0.9, -1.55885, -6.81393e-08>, <-0.5, -0.866025, 0>
   }
   
   smooth_triangle {
      <-0.55, -0.952628, -0.35>, <0.0919711, 0.159299, -0.982937>,
      <-0.65, -1.12583, -0.45>, <0.127646, 0.221089, -0.966864>,
      <4.80825e-08, -1.1, -0.35>, <0, 0.183944, -0.982937>
   }
   
   smooth_triangle {
      <5.68248e-08, -1.3, -0.45>, <0, 0.255292, -0.966864>,
      <4.80825e-08, -1.1, -0.35>, <0, 0.183944, -0.982937>,
      <-0.65, -1.12583, -0.45>, <0.127646, 0.221089, -0.966864>
   }
   
   smooth_triangle {
      <-0.65, -1.12583, -0.45>, <0.127646, 0.22109, -0.966864>,
      <-0.825, -1.42894, -0.45>, <-0.269776, -0.467266, -0.841952>,
      <5.68248e-08, -1.3, -0.45>, <0, 0.255292, -0.966864>
   }
   
   smooth_triangle {
      <-0.9, -1.55885, -6.81393e-08>, <-0.5, -0.866025, 1.98682e-07>,
      <-0.825, -1.42894, 0.45>, <-0.269776, -0.467266, 0.841952>,
      <7.86805e-08, -1.8, -7.86805e-08>, <0, -1, 0>
   }
   
   smooth_triangle {
      <-0.65, -1.12583, 0.45>, <0.127646, 0.221089, 0.966864>,
      <-0.55, -0.952628, 0.35>, <0.0919715, 0.159299, 0.982937>,
      <5.68248e-08, -1.3, 0.45>, <0, 0.255292, 0.966864>
   }
   
   smooth_triangle {
      <4.80825e-08, -1.1, 0.35>, <0, 0.183943, 0.982937>,
      <5.68248e-08, -1.3, 0.45>, <0, 0.255292, 0.966864>,
      <-0.55, -0.952628, 0.35>, <0.0919715, 0.159299, 0.982937>
   }
   
   smooth_triangle {
      <-0.55, -0.952628, 0.35>, <0.0919712, 0.159299, 0.982937>,
      <-0.5, -0.866026, 0.35>, <-0.408248, -0.707106, 0.577351>,
      <4.80825e-08, -1.1, 0.35>, <0, 0.183943, 0.982937>
   }
   
   smooth_triangle {
      <7.21238e-08, -1.65, 0.45>, <0, -0.539552, 0.841952>,
      <7.86805e-08, -1.8, -7.86805e-08>, <0, -1, 0>,
      <-0.825, -1.42894, 0.45>, <-0.269776, -0.467266, 0.841952>
   }
   
   smooth_triangle {
      <-0.825, -1.42894, 0.45>, <-0.269776, -0.467266, 0.841952>,
      <-0.65, -1.12583, 0.45>, <0.127646, 0.221089, 0.966864>,
      <7.21238e-08, -1.65, 0.45>, <0, -0.539552, 0.841952>
   }
   
   smooth_triangle {
      <5.68248e-08, -1.3, 0.45>, <0, 0.255292, 0.966864>,
      <7.21238e-08, -1.65, 0.45>, <0, -0.539552, 0.841952>,
      <-0.65, -1.12583, 0.45>, <0.127646, 0.221089, 0.966864>
   }
   
   smooth_triangle {
      <4.80825e-08, -1.1, -0.35>, <0, 0.183943, -0.982937>,
      <4.37114e-08, -1, -0.35>, <0, -0.816497, -0.577349>,
      <-0.55, -0.952628, -0.35>, <0.0919713, 0.159299, -0.982937>
   }
   
   smooth_triangle {
      <7.43094e-08, -1.7, 0.5>, <-3.21561e-07, -0.556579, 0.830794>,
      <8.08661e-08, -1.85, -8.08661e-08>, <-3.86625e-07, -1, 0>,
      <-0.85, -1.47224, 0.5>, <-0.278289, -0.482011, 0.830795>
   }
   
   smooth_triangle {
      <-0.85, -1.47224, -0.5>, <0.278289, 0.482011, 0.830795>,
      <-0.65, -1.12583, -0.5>, <-0.131386, -0.227567, 0.964858>,
      <7.43094e-08, -1.7, -0.5>, <4.08948e-07, 0.556579, 0.830795>
   }
   
   smooth_triangle {
      <5.68248e-08, -1.3, -0.5>, <0, -0.262771, 0.964858>,
      <7.43094e-08, -1.7, -0.5>, <4.08948e-07, 0.556579, 0.830795>,
      <-0.65, -1.12583, -0.5>, <-0.131386, -0.227567, 0.964858>
   }
   
   smooth_triangle {
      <-0.925, -1.60215, -7.00321e-08>, <0.5, 0.866026, 0>,
      <-0.85, -1.47224, -0.5>, <0.278289, 0.482011, 0.830795>,
      <8.08661e-08, -1.85, -8.08661e-08>, <3.86625e-07, 1, 0>
   }
   
   smooth_triangle {
      <7.43094e-08, -1.7, -0.5>, <4.08948e-07, 0.556579, 0.830795>,
      <8.08661e-08, -1.85, -8.08661e-08>, <3.86625e-07, 1, 0>,
      <-0.85, -1.47224, -0.5>, <0.278289, 0.482011, 0.830795>
   }
   
   smooth_triangle {
      <-0.925, -1.60215, -7.00321e-08>, <-0.5, -0.866026, 0>,
      <-0.85, -1.47224, 0.5>, <-0.278289, -0.482011, 0.830795>,
      <8.08661e-08, -1.85, -8.08661e-08>, <-3.86625e-07, -1, 0>
   }
   
   smooth_triangle {
      <-0.65, -1.12583, -0.5>, <-0.131386, -0.227567, 0.964858>,
      <-0.55, -0.952628, -0.4>, <-0.0919715, -0.1593, 0.982937>,
      <5.68248e-08, -1.3, -0.5>, <0, -0.262771, 0.964858>
   }
   
   smooth_triangle {
      <-0.5, -0.866026, -0.4>, <-0.408248, -0.707106, 0.577351>,
      <-0.5, -0.866026, -0.35>, <-0.408247, -0.707104, -0.577354>,
      <4.37114e-08, -1, -0.4>, <0, -0.816494, 0.577354>
   }
   
   smooth_triangle {
      <4.37114e-08, -1, -0.35>, <0, -0.816494, -0.577354>,
      <4.37114e-08, -1, -0.4>, <0, -0.816494, 0.577354>,
      <-0.5, -0.866026, -0.35>, <-0.408247, -0.707104, -0.577354>
   }
   
   smooth_triangle {
      <-0.5, -0.866026, -0.35>, <-0.408249, -0.707109, -0.577347>,
      <-0.55, -0.952628, -0.35>, <0.0919713, 0.159299, -0.982937>,
      <4.37114e-08, -1, -0.35>, <0, -0.816497, -0.577349>
   }
   
   smooth_triangle {
      <4.80825e-08, -1.1, -0.4>, <0, -0.183943, 0.982937>,
      <5.68248e-08, -1.3, -0.5>, <0, -0.262771, 0.964858>,
      <-0.55, -0.952628, -0.4>, <-0.0919715, -0.1593, 0.982937>
   }
   
   smooth_triangle {
      <-0.55, -0.952628, -0.4>, <-0.0919712, -0.159299, 0.982937>,
      <-0.5, -0.866026, -0.4>, <-0.408248, -0.707106, 0.577351>,
      <4.80825e-08, -1.1, -0.4>, <0, -0.183943, 0.982937>
   }
   
   smooth_triangle {
      <4.37114e-08, -1, -0.4>, <0, -0.816495, 0.577352>,
      <4.80825e-08, -1.1, -0.4>, <0, -0.183943, 0.982937>,
      <-0.5, -0.866026, -0.4>, <-0.408248, -0.707106, 0.577351>
   }
   
   smooth_triangle {
      <4.80825e-08, -1.1, -0.4>, <-1.59784e-07, -0.183943, 0.982937>,
      <4.37114e-08, -1, -0.4>, <0, -0.816495, 0.577352>,
      <0.55, -0.952628, -0.4>, <0.0919718, -0.1593, 0.982937>
   }
   
   smooth_triangle {
      <0.5, -0.866026, -0.4>, <0.408248, -0.707107, 0.57735>,
      <0.55, -0.952628, -0.4>, <0.0919718, -0.1593, 0.982937>,
      <4.37114e-08, -1, -0.4>, <0, -0.816495, 0.577352>
   }
   
   smooth_triangle {
      <4.37114e-08, -1, -0.4>, <0, -0.816494, 0.577354>,
      <4.37114e-08, -1, -0.35>, <0, -0.816494, -0.577354>,
      <0.5, -0.866026, -0.4>, <0.408248, -0.707106, 0.577352>
   }
   
   smooth_triangle {
      <0.65, -1.12583, -0.5>, <0.131386, -0.227567, 0.964858>,
      <0.85, -1.47224, -0.5>, <-0.278289, 0.482012, 0.830795>,
      <5.68248e-08, -1.3, -0.5>, <0, -0.262771, 0.964858>
   }
   
   smooth_triangle {
      <5.68248e-08, -1.3, -0.5>, <0, -0.262771, 0.964858>,
      <4.80825e-08, -1.1, -0.4>, <-1.59784e-07, -0.183943, 0.982937>,
      <0.65, -1.12583, -0.5>, <0.131386, -0.227567, 0.964858>
   }
   
   smooth_triangle {
      <0.55, -0.952628, -0.4>, <0.0919715, -0.159299, 0.982937>,
      <0.65, -1.12583, -0.5>, <0.131386, -0.227567, 0.964858>,
      <4.80825e-08, -1.1, -0.4>, <-1.59784e-07, -0.183943, 0.982937>
   }
   
   smooth_triangle {
      <0.5, -0.866026, -0.35>, <0.408247, -0.707105, -0.577354>,
      <0.5, -0.866026, -0.4>, <0.408248, -0.707106, 0.577352>,
      <4.37114e-08, -1, -0.35>, <0, -0.816494, -0.577354>
   }
   
   smooth_triangle {
      <0.65, -1.12583, -0.45>, <-0.127646, 0.22109, -0.966864>,
      <0.55, -0.952628, -0.35>, <-0.0919717, 0.159299, -0.982937>,
      <5.68248e-08, -1.3, -0.45>, <0, 0.255292, -0.966864>
   }
   
   smooth_triangle {
      <5.68248e-08, -1.3, -0.45>, <0, 0.255292, -0.966864>,
      <7.21238e-08, -1.65, -0.45>, <0, -0.539553, -0.841951>,
      <0.65, -1.12583, -0.45>, <-0.127646, 0.221089, -0.966864>
   }
   
   smooth_triangle {
      <0.825, -1.42894, -0.45>, <0.269776, -0.467266, -0.841952>,
      <0.65, -1.12583, -0.45>, <-0.127646, 0.221089, -0.966864>,
      <7.21238e-08, -1.65, -0.45>, <0, -0.539553, -0.841951>
   }
   
   smooth_triangle {
      <4.37114e-08, -1, -0.35>, <0, -0.816497, -0.577349>,
      <4.80825e-08, -1.1, -0.35>, <0, 0.183943, -0.982937>,
      <0.5, -0.866026, -0.35>, <0.408248, -0.707107, -0.577349>
   }
   
   smooth_triangle {
      <0.55, -0.952628, -0.35>, <-0.0919719, 0.1593, -0.982937>,
      <0.5, -0.866026, -0.35>, <0.408248, -0.707107, -0.577349>,
      <4.80825e-08, -1.1, -0.35>, <0, 0.183943, -0.982937>
   }
   
   smooth_triangle {
      <4.80825e-08, -1.1, -0.35>, <0, 0.183944, -0.982937>,
      <5.68248e-08, -1.3, -0.45>, <0, 0.255292, -0.966864>,
      <0.55, -0.952628, -0.35>, <-0.0919717, 0.159299, -0.982937>
   }
   
   smooth_triangle {
      <7.43094e-08, -1.7, -0.5>, <-4.08948e-07, 0.556579, 0.830795>,
      <5.68248e-08, -1.3, -0.5>, <0, -0.262771, 0.964858>,
      <0.85, -1.47224, -0.5>, <-0.278289, 0.482012, 0.830795>
   }
   
   smooth_triangle {
      <-0.5, -0.866026, 0.4>, <-0.408249, -0.707108, -0.577348>,
      <-0.55, -0.952628, 0.4>, <-0.0919714, -0.159299, -0.982937>,
      <4.37114e-08, -1, 0.4>, <0, -0.816497, -0.577349>
   }
   
   smooth_triangle {
      <4.80825e-08, -1.1, 0.4>, <0, -0.183943, -0.982937>,
      <4.37114e-08, -1, 0.4>, <0, -0.816497, -0.577349>,
      <-0.55, -0.952628, 0.4>, <-0.0919714, -0.159299, -0.982937>
   }
   
   smooth_triangle {
      <-0.55, -0.952628, 0.4>, <-0.0919714, -0.159299, -0.982937>,
      <-0.65, -1.12583, 0.5>, <-0.131386, -0.227567, -0.964858>,
      <4.80825e-08, -1.1, 0.4>, <0, -0.183942, -0.982937>
   }
   
   smooth_triangle {
      <4.37114e-08, -1, 0.35>, <0, -0.816495, 0.577352>,
      <4.80825e-08, -1.1, 0.35>, <0, 0.183943, 0.982937>,
      <-0.5, -0.866026, 0.35>, <-0.408248, -0.707106, 0.577351>
   }
   
   smooth_triangle {
      <-0.5, -0.866026, 0.35>, <-0.408248, -0.707106, 0.577351>,
      <-0.5, -0.866026, 0.4>, <-0.408247, -0.707105, -0.577353>,
      <4.37114e-08, -1, 0.35>, <0, -0.816494, 0.577353>
   }
   
   smooth_triangle {
      <4.37114e-08, -1, 0.4>, <0, -0.816494, -0.577353>,
      <4.37114e-08, -1, 0.35>, <0, -0.816494, 0.577353>,
      <-0.5, -0.866026, 0.4>, <-0.408247, -0.707105, -0.577353>
   }
   
   smooth_triangle {
      <5.68248e-08, -1.3, 0.5>, <0, -0.262771, -0.964858>,
      <4.80825e-08, -1.1, 0.4>, <0, -0.183942, -0.982937>,
      <-0.65, -1.12583, 0.5>, <-0.131386, -0.227567, -0.964858>
   }
   
   smooth_triangle {
      <0.85, -1.47224, -0.5>, <-0.278289, 0.482011, 0.830795>,
      <0.925, -1.60215, -7.00321e-08>, <-0.5, 0.866026, 0>,
      <7.43094e-08, -1.7, -0.5>, <-4.08948e-07, 0.556579, 0.830795>
   }
   
   smooth_triangle {
      <8.08661e-08, -1.85, -8.08661e-08>, <7.73249e-07, -1, 0>,
      <7.43094e-08, -1.7, 0.5>, <3.21561e-07, -0.556579, 0.830794>,
      <0.925, -1.60215, -7.00321e-08>, <0.5, -0.866026, 0>
   }
   
   smooth_triangle {
      <0.85, -1.47224, 0.5>, <0.278289, -0.482011, 0.830795>,
      <0.925, -1.60215, -7.00321e-08>, <0.5, -0.866026, 0>,
      <7.43094e-08, -1.7, 0.5>, <3.21561e-07, -0.556579, 0.830794>
   }
   
   smooth_triangle {
      <-0.65, -1.12583, 0.5>, <-0.131386, -0.227567, -0.964858>,
      <-0.85, -1.47224, 0.5>, <0.27829, 0.482012, -0.830794>,
      <5.68248e-08, -1.3, 0.5>, <0, -0.262771, -0.964858>
   }
   
   smooth_triangle {
      <7.43094e-08, -1.7, 0.5>, <3.21561e-07, 0.556578, -0.830795>,
      <5.68248e-08, -1.3, 0.5>, <0, -0.262771, -0.964858>,
      <-0.85, -1.47224, 0.5>, <0.27829, 0.482012, -0.830794>
   }
   
   smooth_triangle {
      <8.08661e-08, -1.85, -8.08661e-08>, <-7.73249e-07, 1, 0>,
      <7.43094e-08, -1.7, -0.5>, <-4.08948e-07, 0.556579, 0.830795>,
      <0.925, -1.60215, -7.00321e-08>, <-0.5, 0.866026, 0>
   }
}

#declare O_Dori_Left_Side = merge {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0, -9, -5>, <6.98555, -9, -4.79242>, <13.3333, -9, -1.66667>, <20, -9, 0>,
      <0.0718218, -6.5213, -6.62864>, <7.05737, -6.5213, -6.42106>, <16.6667, -6, -1.66667>, <23.3333, -6, 0>,
      <0.143644, -4.0426, -8.25729>, <10.1533, -3.96042, -7.96974>, <16.7385, -3.5213, -3.29531>, <26.6667, -3, 0>,
      <0.215465, -1.5639, -9.88593>, <10.2251, -1.48172, -9.59838>, <20.0718, -0.5213, -3.29531>, <30, 0, 0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <30, 0, 0>, <20.0718, -0.5213, -3.29531>, <10.2251, -1.48172, -9.59838>, <0.215465, -1.5639, -9.88593>,
      <31, 0, 0>, <21.0718, -0.5213, -3.29531>, <10.2251, -1.48172, -9.93172>, <0.215465, -1.5639, -10.2193>,
      <32, 0, 0>, <21.0718, -0.5213, -3.62864>, <10.9706, -1.51181, -10.3199>, <0.215465, -1.5639, -10.5526>,
      <33, 0, 0>, <22.0718, -0.5213, -3.62864>, <10.9706, -1.51181, -10.6533>, <0.215465, -1.5639, -10.8859>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.215465, -1.5639, -9.88593>, <-9.77538, -1.64592, -10.1729>, <-19.9282, -0.854633, -4.47824>, <-30, -0.5, -1.7744>,
      <0.215465, -1.5639, -10.2193>, <-9.77538, -1.64592, -10.5063>, <-19.9282, -0.854633, -4.81158>, <-30, -0.5, -2.10773>,
      <0.215465, -1.5639, -10.5526>, <-10.0175, -1.61345, -10.774>, <-19.9282, -0.854633, -5.14491>, <-30, -0.5, -2.44106>,
      <0.215465, -1.5639, -10.8859>, <-10.0175, -1.61345, -11.1073>, <-19.9282, -0.854633, -5.47824>, <-30, -0.5, -2.7744>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0, -9, -6>, <7.77088, -9, -5.79244>, <15.3333, -9, -2>, <23, -9, 0>,
      <0.0718218, -6.5213, -7.62864>, <7.8427, -6.5213, -7.42108>, <18.6667, -6, -2>, <26.3333, -6, 0>,
      <0.143644, -4.0426, -9.25729>, <10.8988, -3.99051, -9.02463>, <18.7385, -3.5213, -3.62864>, <29.6667, -3, 0>,
      <0.215465, -1.5639, -10.8859>, <10.9706, -1.51181, -10.6533>, <22.0718, -0.5213, -3.62864>, <33, 0, 0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-24, -9, -1>, <-16, -9, -2.66667>, <-7.89181, -9, -6.21079>, <0, -9, -6>,
      <-26, -6.16667, -1.59147>, <-18, -6.16667, -3.25813>, <-7.81998, -6.5213, -7.83943>, <0.0718218, -6.5213, -7.62864>,
      <-28, -3.33333, -2.18293>, <-17.9282, -3.68797, -4.88678>, <-10.0893, -4.09215, -9.47864>, <0.143644, -4.0426, -9.25729>,
      <-30, -0.5, -2.7744>, <-19.9282, -0.854633, -5.47824>, <-10.0175, -1.61345, -11.1073>, <0.215465, -1.5639, -10.8859>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-24, -9, 0>, <-26, -6.16667, -0.591466>, <-28, -3.33333, -1.18293>, <-30, -0.5, -1.7744>,
      <-16, -9, -1.66667>, <-18, -6.16667, -2.25813>, <-17.9282, -3.68797, -3.88678>, <-19.9282, -0.854633, -4.47824>,
      <-7.61767, -9, -5.22636>, <-7.54584, -6.5213, -6.85501>, <-9.8472, -4.12462, -8.5443>, <-9.77538, -1.64592, -10.1729>,
      <0, -9, -5>, <0.0718218, -6.5213, -6.62864>, <0.143644, -4.0426, -8.25729>, <0.215465, -1.5639, -9.88593>
   }
   
   texture {
      uv_mapping
      T_Dori
   }
}

#declare O_Dori_Right_Side = merge {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-24, -9, 0>, <-16, -9, 1.66667>, <-7.61767, -9, 5.22636>, <0, -9, 5>,
      <-26, -6.16667, 0.591466>, <-18, -6.16667, 2.25813>, <-7.54585, -6.5213, 6.85501>, <0.0718218, -6.5213, 6.62864>,
      <-28, -3.33333, 1.18293>, <-17.9282, -3.68797, 3.88678>, <-9.8472, -4.12462, 8.5443>, <0.143644, -4.0426, 8.25729>,
      <-30, -0.5, 1.7744>, <-19.9282, -0.854633, 4.47824>, <-9.77538, -1.64592, 10.1729>, <0.215465, -1.5639, 9.88593>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0, -9, 5>, <6.98555, -9, 4.79242>, <13.3333, -9, 1.66667>, <20, -9, 0>,
      <0.0718218, -6.5213, 6.62864>, <7.05737, -6.5213, 6.42106>, <16.6667, -6, 1.66667>, <23.3333, -6, 0>,
      <0.143644, -4.0426, 8.25729>, <10.1533, -3.96042, 7.96974>, <16.7385, -3.5213, 3.29531>, <26.6667, -3, 0>,
      <0.215465, -1.5639, 9.88593>, <10.2251, -1.48172, 9.59838>, <20.0718, -0.5213, 3.29531>, <30, 0, 0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <30, 0, 0>, <20.0718, -0.5213, 3.29531>, <10.2251, -1.48172, 9.59838>, <0.215465, -1.5639, 9.88593>,
      <31, 0, 0>, <21.0718, -0.5213, 3.29531>, <10.2251, -1.48172, 9.93172>, <0.215465, -1.5639, 10.2193>,
      <32, 0, 0>, <21.0718, -0.5213, 3.62864>, <10.9706, -1.51181, 10.3199>, <0.215465, -1.5639, 10.5526>,
      <33, 0, 0>, <22.0718, -0.5213, 3.62864>, <10.9706, -1.51181, 10.6533>, <0.215465, -1.5639, 10.8859>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.215465, -1.5639, 9.88593>, <-9.77538, -1.64592, 10.1729>, <-19.9282, -0.854633, 4.47824>, <-30, -0.5, 1.7744>,
      <0.215465, -1.5639, 10.2193>, <-9.77538, -1.64592, 10.5063>, <-19.9282, -0.854633, 4.81158>, <-30, -0.5, 2.10773>,
      <0.215465, -1.5639, 10.5526>, <-10.0175, -1.61345, 10.774>, <-19.9282, -0.854633, 5.14491>, <-30, -0.5, 2.44106>,
      <0.215465, -1.5639, 10.8859>, <-10.0175, -1.61345, 11.1073>, <-19.9282, -0.854633, 5.47824>, <-30, -0.5, 2.7744>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0, -9, 6>, <7.77088, -9, 5.79244>, <15.3333, -9, 2>, <23, -9, 0>,
      <0.0718218, -6.5213, 7.62864>, <7.8427, -6.5213, 7.42108>, <18.6667, -6, 2>, <26.3333, -6, 0>,
      <0.143644, -4.0426, 9.25729>, <10.8988, -3.99051, 9.02463>, <18.7385, -3.5213, 3.62864>, <29.6667, -3, 0>,
      <0.215465, -1.5639, 10.8859>, <10.9706, -1.51181, 10.6533>, <22.0718, -0.5213, 3.62864>, <33, 0, 0>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-24, -9, 1>, <-26, -6.16667, 1.59147>, <-28, -3.33333, 2.18293>, <-30, -0.5, 2.7744>,
      <-16, -9, 2.66667>, <-18, -6.16667, 3.25813>, <-17.9282, -3.68797, 4.88678>, <-19.9282, -0.854633, 5.47824>,
      <-7.89181, -9, 6.21079>, <-7.81998, -6.5213, 7.83943>, <-10.0893, -4.09215, 9.47864>, <-10.0175, -1.61345, 11.1073>,
      <0, -9, 6>, <0.0718218, -6.5213, 7.62864>, <0.143644, -4.0426, 9.25729>, <0.215465, -1.5639, 10.8859>
   }
   
   texture {
      uv_mapping
      T_Dori
   }
}

#declare O_Dori_Bottom = merge {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0, -9, -6>, <-7.89181, -9, -6.21079>, <-16, -9, -2.66667>, <-24, -9, -1>,
      <0, -9, -2>, <-7.89181, -9, -2.21079>, <-16, -9, -2>, <-24, -9, -0.333333>,
      <0, -9, 2>, <-7.89181, -9, 2.21079>, <-16, -9, 2>, <-24, -9, 0.333333>,
      <0, -9, 6>, <-7.89181, -9, 6.21079>, <-16, -9, 2.66667>, <-24, -9, 1>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <23, -9, 0>, <15.3333, -9, -2>, <7.77088, -9, -5.79244>, <0, -9, -6>,
      <15.3333, -9, 2>, <7.66666, -9, 0>, <7.77088, -9, -1.79244>, <0, -9, -2>,
      <7.77088, -9, 5.79244>, <7.77088, -9, 3.12577>, <5.18058, -9, 1.86163>, <0, -9, 2>,
      <0.0233117, -9, 5.99937>, <0.00777057, -9, 5.99179>, <0.00777057, -9, 5.99179>, <0, -9, 5.988>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <22, -10, 0>, <14.6667, -10, 1.66667>, <7.51411, -10, 4.75285>, <0, -10, 5>,
      <22.3333, -9.66667, 0>, <15, -9.66667, 1.66667>, <7.51411, -9.66667, 5.08618>, <0, -9.66667, 5.33333>,
      <22.6667, -9.33333, 0>, <15, -9.33333, 2>, <7.77088, -9.33333, 5.45911>, <0, -9.33333, 5.66667>,
      <23, -9, 0>, <15.3333, -9, 2>, <7.77088, -9, 5.79244>, <0, -9, 6>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <22, -10, 0>, <14.6667, -10, -1.66667>, <7.51412, -10, -4.75285>, <0, -10, -5>,
      <14.6667, -10, 1.66667>, <7.33333, -10, 0>, <7.51412, -10, -1.41952>, <0, -10, -1.66667>,
      <7.51411, -10, 4.75285>, <7.51411, -10, 2.53063>, <5.00941, -10, 1.5019>, <0, -10, 1.66667>,
      <0.022541, -10, 4.99925>, <0.00751366, -10, 4.99308>, <0.00751366, -10, 4.99308>, <0, -10, 4.99>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0, -10, -5>, <-7.80331, -10, -5.25666>, <-16, -10, -2.33333>, <-24, -10, -1>,
      <0, -10, -1.66667>, <-7.80331, -10, -1.92333>, <-16, -10, -1.66667>, <-24, -10, -0.333333>,
      <0, -10, 1.66667>, <-7.80331, -10, 1.92333>, <-16, -10, 1.66667>, <-24, -10, 0.333333>,
      <0, -10, 5>, <-7.80331, -10, 5.25666>, <-16, -10, 2.33333>, <-24, -10, 1>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-24, -10, -1>, <-24, -10, -0.333333>, <-24, -10, 0.333333>, <-24, -10, 1>,
      <-24, -9.66667, -1>, <-24, -9.66667, -0.333333>, <-24, -9.66667, 0.333333>, <-24, -9.66667, 1>,
      <-24, -9.33333, -1>, <-24, -9.33333, -0.333333>, <-24, -9.33333, 0.333333>, <-24, -9.33333, 1>,
      <-24, -9, -1>, <-24, -9, -0.333333>, <-24, -9, 0.333333>, <-24, -9, 1>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0, -9, 6>, <-7.89181, -9, 6.21079>, <-16, -9, 2.66667>, <-24, -9, 1>,
      <0, -9.33333, 5.66667>, <-7.89181, -9.33333, 5.87746>, <-16, -9.33333, 2.66667>, <-24, -9.33333, 1>,
      <0, -9.66667, 5.33333>, <-7.80331, -9.66667, 5.58999>, <-16, -9.66667, 2.33333>, <-24, -9.66667, 1>,
      <0, -10, 5>, <-7.80331, -10, 5.25666>, <-16, -10, 2.33333>, <-24, -10, 1>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0, -9, -6>, <-7.89181, -9, -6.21079>, <-16, -9, -2.66667>, <-24, -9, -1>,
      <0, -9.33333, -5.66667>, <-7.89181, -9.33333, -5.87746>, <-16, -9.33333, -2.66667>, <-24, -9.33333, -1>,
      <0, -9.66667, -5.33333>, <-7.80331, -9.66667, -5.58999>, <-16, -9.66667, -2.33333>, <-24, -9.66667, -1>,
      <0, -10, -5>, <-7.80331, -10, -5.25666>, <-16, -10, -2.33333>, <-24, -10, -1>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <23, -9, 0>, <15.3333, -9, -2>, <7.77088, -9, -5.79244>, <0, -9, -6>,
      <22.6667, -9.33333, 0>, <15, -9.33333, -2>, <7.77088, -9.33333, -5.45911>, <0, -9.33333, -5.66667>,
      <22.3333, -9.66667, 0>, <15, -9.66667, -1.66667>, <7.51412, -9.66667, -5.08618>, <0, -9.66667, -5.33333>,
      <22, -10, 0>, <14.6667, -10, -1.66667>, <7.51412, -10, -4.75285>, <0, -10, -5>
   }
   
   texture {
      uv_mapping
      T_Dori
   }
}

#declare O_Dori_Stern = merge {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-31, -0.5, -2>, <-29, -3.33333, -1.58333>, <-27, -6.16667, -1.16667>, <-25, -9, -0.75>,
      <-31, -0.5, -0.666667>, <-29, -3.33333, -0.25>, <-27, -6.16667, -0.666667>, <-25, -9, -0.25>,
      <-31, -0.5, 0.666667>, <-29, -3.33333, 0.25>, <-27, -6.16667, 0.666667>, <-25, -9, 0.25>,
      <-31, -0.5, 2>, <-29, -3.33333, 1.58333>, <-27, -6.16667, 1.16667>, <-25, -9, 0.75>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-30, -0.5, 2.7744>, <-28, -3.33333, 2.18293>, <-26, -6.16667, 1.59147>, <-24, -9, 1>,
      <-30.3333, -0.5, 2.51626>, <-28.3333, -3.33333, 1.9248>, <-26.3333, -6.16667, 1.50813>, <-24.3333, -9, 0.916667>,
      <-30.6667, -0.5, 2.25813>, <-28.6667, -3.33333, 1.84147>, <-26.6667, -6.16667, 1.25>, <-24.6667, -9, 0.833333>,
      <-31, -0.5, 2>, <-29, -3.33333, 1.58333>, <-27, -6.16667, 1.16667>, <-25, -9, 0.75>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-30, -0.5, -2.7744>, <-30, -0.5, -0.924799>, <-30, -0.5, 0.924799>, <-30, -0.5, 2.7744>,
      <-30.3333, -0.5, -2.51626>, <-30.3333, -0.5, -0.666667>, <-30.3333, -0.5, 0.666667>, <-30.3333, -0.5, 2.51626>,
      <-30.6667, -0.5, -2.25813>, <-30.6667, -0.5, -0.924799>, <-30.6667, -0.5, 0.924799>, <-30.6667, -0.5, 2.25813>,
      <-31, -0.5, -2>, <-31, -0.5, -0.666667>, <-31, -0.5, 0.666667>, <-31, -0.5, 2>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-24, -9, -1>, <-24, -9, -0.333333>, <-24, -9, 0.333333>, <-24, -9, 1>,
      <-24.3333, -9, -0.916667>, <-24.3333, -9, -0.25>, <-24.3333, -9, 0.25>, <-24.3333, -9, 0.916667>,
      <-24.6667, -9, -0.833333>, <-24.6667, -9, -0.333333>, <-24.6667, -9, 0.333333>, <-24.6667, -9, 0.833333>,
      <-25, -9, -0.75>, <-25, -9, -0.25>, <-25, -9, 0.25>, <-25, -9, 0.75>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-24, -9, -1>, <-26, -6.16667, -1.59147>, <-28, -3.33333, -2.18293>, <-30, -0.5, -2.7744>,
      <-24.3333, -9, -0.916667>, <-26.3333, -6.16667, -1.50813>, <-28.3333, -3.33333, -1.9248>, <-30.3333, -0.5, -2.51626>,
      <-24.6667, -9, -0.833333>, <-26.6667, -6.16667, -1.25>, <-28.6667, -3.33333, -1.84147>, <-30.6667, -0.5, -2.25813>,
      <-25, -9, -0.75>, <-27, -6.16667, -1.16667>, <-29, -3.33333, -1.58333>, <-31, -0.5, -2>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-24, -9, -1>, <-26, -6.16667, -1.59147>, <-28, -3.33333, -2.18293>, <-30, -0.5, -2.7744>,
      <-24, -9, -0.333333>, <-26, -6.16667, -0.924799>, <-28, -3.33333, -0.333333>, <-30, -0.5, -0.924799>,
      <-24, -9, 0.333333>, <-26, -6.16667, 0.924799>, <-28, -3.33333, 0.333333>, <-30, -0.5, 0.924799>,
      <-24, -9, 1>, <-26, -6.16667, 1.59147>, <-28, -3.33333, 2.18293>, <-30, -0.5, 2.7744>
   }
   
   texture {
      uv_mapping
      T_Dori
   }
}

#declare O_Oar_Hook = merge {
   difference {
      torus {
         1, 0.2
         rotate z*90
      }
      
      box {
         <-0.3, 0, -1.25>, <0.3, 1.25, 1.25>
      }
   }
   
   cylinder {
      <0, 1.5, 1>, <0, 0, 1>, 0.2
   }
   
   cylinder {
      <0, 1.5, -1>, <0, 0, -1>, 0.2
   }
   
   sphere {
      <0, 1.5, 1>, 0.2
   }
   
   sphere {
      <0, 1.5, -1>, 0.2
   }
   
   box {
      <-0.5, -1.3, -1.75>, <0.5, -1.15, 1.75>
   }
   scale 0.5
   rotate y*90
   
   texture {
      T_OarHook
   }
}

#declare O_Dori = union {
   object {
      //*PMName Bottom
      O_Dori_Bottom
   }
   
   object {
      //*PMName Stern
      O_Dori_Stern
   }
   
   object {
      //*PMName LeftSide
      O_Dori_Left_Side
   }
   
   object {
      //*PMName RightSide
      O_Dori_Right_Side
   }
   
   object {
      //*PMName OarHook
      O_Oar_Hook
      translate <0, -0.915, -10.4>
   }
   
   object {
      //*PMName OarHook
      O_Oar_Hook
      translate <0, -0.915, 10.4>
   }
}

#declare O_Banner = union {
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      uv_vectors <1, 1> <0, 1> <0, 0> <1, 0>
      <-0.5, 0, -0.5>, <-0.25, 0, -0.5>, <0.25, 0, -0.5>, <0.5, 0, -0.5>,
      <-0.51179, 0.058037, -0.25295>, <-0.23821, 0.029018, -0.25884>, <0.25, -0.043528, -0.24705>, <0.46464, -0.087055, -0.25>,
      <-0.45286, -0.058037, 0.25589>, <-0.23821, 0.043528, 0.25589>, <0.20286, -0.043528, 0.24705>, <0.53536, 0.1596, 0.25>,
      <-0.5, 0, 0.5>, <-0.25, 0, 0.5>, <0.25, 0, 0.5>, <0.5, 0, 0.5>
      
      texture {
         uv_mapping
         T_Banner
      }
      rotate x*90
      scale <1, 4, 1>
   }
   
   cylinder {
      <0.5, -2, 0>, <-0.5, -2, 0>, 0.02
      
      texture {
         T_BannerRod
      }
   }
   
   cylinder {
      <0.5, 2, 0>, <-0.5, 2, 0>, 0.02
      
      texture {
         T_BannerRod
      }
   }
}

#declare O_Banner_Stay = merge {
   cylinder {
      <-0.6, 0, 0>, <0.6, 0, 0>, 0.025
      
      texture {
         T_Pole
      }
   }
   
   sphere {
      <0.6, 0, 0>, 0.025
      
      texture {
         T_Pole
      }
   }
   
   difference {
      merge {
         cylinder {
            <-0.657, 0.075, 0>, <-0.657, -0.075, 0>, 0.07
         }
         
         box {
            <-0.68, -0.075, 0.125>, <-0.632, 0.075, -0.125>
         }
      }
      
      box {
         <-0.657, -0.075, 0.125>, <-0.655, 0.075, -0.125>
      }
      
      texture {
         T_Pole
      }
   }
   
   union {
      sphere {
         <-0.632, 0, -0.1>, 0.02
      }
      
      sphere {
         <-0.632, 0, 0.1>, 0.02
      }
      
      sphere {
         <-0.68, 0, 0.1>, 0.02
      }
      
      sphere {
         <-0.68, 0, -0.1>, 0.02
      }
      
      texture {
         pigment {
            color rgb <0, 0, 0>
         }
         
         finish {
            diffuse 0
            roughness 0.1
         }
      }
   }
   
   sphere_sweep {
      cubic_spline,
      13,
      <0.6, 0.08, 0>,0.002
      <0.5, 0.03, 0>,0.002
      <0.4, 0.08, 0>,0.002
      <0.3, 0.03, 0>,0.002
      <0.2, 0.08, 0>,0.002
      <0.1, 0.03, 0>,0.002
      <0, 0.08, 0>,0.002
      <-0.1, 0.03, 0>,0.002
      <-0.2, 0.08, 0>,0.002
      <-0.3, 0.03, 0>,0.002
      <-0.4, 0.08, 0>,0.002
      <-0.5, 0.03, 0>,0.002
      <-0.6, 0.08, 0>,0.002
      translate y*(-0.004)
      
      texture {
         T_Pole
      }
   }
}

#declare O_Banner_Stay_String = union {
   object {
      //*PMName Stay
      O_Banner_Stay
   }
   
   sphere_sweep {
      linear_spline,
      14,
      <0.5, 0.18, 0>,0.002
      <0.4, 0.072, 0.004>,0.002
      <0.3, 0.18, 0>,0.002
      <0.2, 0.072, -0.004>,0.002
      <0.2, 0.072, 0.004>,0.002
      <0.1, 0.18, 0>,0.002
      <0, 0.072, -0.004>,0.002
      <0, 0.072, 0.004>,0.002
      <-0.1, 0.18, 0>,0.002
      <-0.2, 0.072, -0.004>,0.002
      <-0.2, 0.072, 0.004>,0.002
      <-0.3, 0.18, 0>,0.002
      <-0.4, 0.072, -0.004>,0.002
      <-0.5, 0.18, 0>,0.002
      
      texture {
      }
   }
}

#declare O_Banner_Stay_Assembly = union {
   object {
      //*PMName Top Stay
      O_Banner_Stay_String
      rotate x*180
      translate y*2.2
   }
   
   object {
      //*PMName Bottom Stay
      O_Banner_Stay_String
      translate y*(-2.2)
   }
}

#declare O_Sun = light_source {
   <0, 0, 0>, rgb <1, 0.99, 0.9>
   area_light <1, 0, 0>, <0, 1, 0>, 3, 3
   adaptive 2
   jitter
   circular
   orient
}

#declare O_Moon = sphere {
   <0, 0, 0>, 0.5
   scale 7
   
   texture {
      T_Moon
   }
   hollow false
}

#declare O_MoonNightQuarter = light_group {
   object {
      O_Sun
      rotate x*(-30)
      translate <0, -10, -15>
   }
   
   object {
      O_Moon
   }
   global_lights off
}

#declare O_Bulb_Shape = sor {
   16,
   <0.1, -0.06>, <0.1575, 0.025>, <0.1625, 0.125>, <0.185, 0.242124>, <0.23, 0.36>, <0.26, 0.42>, <0.29, 0.48>, <0.338973, 0.632548>, <0.326867, 0.759663>, <0.284495, 0.853486>, <0.226991, 0.92007>, <0.145274, 0.971522>, <0.081717, 0.992707>, <0.030265, 0.998761>, <0.005, 1>, <0, 1.00481>
}

#declare O_Bulb_Glass = object {
   //*PMName Outer
   O_Bulb_Shape
}

#declare O_Lamp = union {
   merge {
      //*PMName Pole
      
      cylinder {
         <0, 13.5, 0>, <0, 0, 0>, 0.1
      }
      
      difference {
         torus {
            0.5, 0.1
         }
         
         box {
            <0, 0.12, -0.62>, <0.62, -0.12, 0.62>
         }
         rotate z*270
         translate <0, 13.5, 0.5>
      }
      
      texture {
         T_Pole
      }
   }
   
   lathe {
      //*PMName Shade
      bezier_spline
      4,
      <0, 0>, <0.42, -0.04>, <0.15, -0.07>, <0.5, -0.14>
      
      texture {
         T_Pole
      }
      scale <1.5, 2, 1.5>
      translate <0, 13.5, 1>
      hollow
   }
   
   lathe {
      //*PMName Shade
      bezier_spline
      4,
      <0, 0>, <0.42, -0.04>, <0.15, -0.07>, <0.5, -0.14>
      
      texture {
         T_LampShadeInside
      }
      scale <1.5, 2, 1.5>
      translate <0, 13.497, 1>
      hollow
   }
   
   sphere {
      //*PMName Glass
      <0, 0, 0>, 0.35
      
      texture {
         T_Glass1
      }
      translate <0, 13.15, 1>
   }
   
   object {
      //*PMName Bulb
      O_Bulb_Glass
      scale 0.4
      rotate x*180
      translate <0, 13.415, 1>
      
      texture {
         pigment {
            color rgbf <1, 1, 1, 0.8>
         }
         
         finish {
            specular 1.5
         }
      }
   }
   
   object {
      //*PMName Banner_Stays
      O_Banner_Stay_Assembly
      scale 1.75
      rotate y*90
      translate <0, 9.25, -1.15>
   }
}

#declare O_Boat_Hook = mesh {
   smooth_triangle {
      <0, 0.204826, -0.912476>, <0, 1, 0>,
      <-1.36871, 0.204826, -0.684357>, <0, 1, 0>,
      <-1.5, 0.204826, -0.75>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-1.5, 0.204826, -0.75>, <0, 1, 0>,
      <0, 0.204826, -1>, <0, 1, 0>,
      <0, 0.204826, -0.912476>, <0, 1, 0>
   }
   
   smooth_triangle {
      <1.5, 0.204826, -0.75>, <0, 1, 0>,
      <1.36871, 0.204826, -0.684357>, <0, 1, 0>,
      <0, 0.204826, -0.912476>, <0, 1, 0>
   }
   
   smooth_triangle {
      <0, 0.204826, -0.912476>, <0, 1, 0>,
      <0, 0.204826, -1>, <0, 1, 0>,
      <1.5, 0.204826, -0.75>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-1.82495, 0.204826, -1.86265e-09>, <0, 1, 0>,
      <-1.36871, 0.204826, 0.684357>, <0, 1, 0>,
      <-1.5, 0.204826, 0.75>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-1.5, 0.204826, 0.75>, <0, 1, 0>,
      <-2, 0.204826, -1.49012e-08>, <0, 1, 0>,
      <-1.82495, 0.204826, -1.86265e-09>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-1.5, 0.204826, -0.75>, <0, 1, 0>,
      <-1.36871, 0.204826, -0.684357>, <0, 1, 0>,
      <-1.82495, 0.204826, -1.86265e-09>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-1.82495, 0.204826, -1.86265e-09>, <0, 1, 0>,
      <-2, 0.204826, -1.49012e-08>, <0, 1, 0>,
      <-1.5, 0.204826, -0.75>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-3.27826e-07, 0.204826, 0.912477>, <0, 1, 0>,
      <1.36871, 0.204826, 0.684358>, <0, 1, 0>,
      <1.5, 0.204826, 0.75>, <0, 1, 0>
   }
   
   smooth_triangle {
      <1.5, 0.204826, 0.75>, <0, 1, 0>,
      <-3.57628e-07, 0.204826, 1>, <0, 1, 0>,
      <-3.27826e-07, 0.204826, 0.912477>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-1.5, 0.204826, 0.75>, <0, 1, 0>,
      <-1.36871, 0.204826, 0.684357>, <0, 1, 0>,
      <-3.27826e-07, 0.204826, 0.912477>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-3.27826e-07, 0.204826, 0.912477>, <0, 1, 0>,
      <-3.57628e-07, 0.204826, 1>, <0, 1, 0>,
      <-1.5, 0.204826, 0.75>, <0, 1, 0>
   }
   
   smooth_triangle {
      <1.82495, 0.204826, 3.241e-07>, <0, 1, 0>,
      <1.36871, 0.204826, -0.684357>, <0, 1, 0>,
      <1.5, 0.204826, -0.75>, <0, 1, 0>
   }
   
   smooth_triangle {
      <1.5, 0.204826, -0.75>, <0, 1, 0>,
      <2, 0.204826, 3.42727e-07>, <0, 1, 0>,
      <1.82495, 0.204826, 3.241e-07>, <0, 1, 0>
   }
   
   smooth_triangle {
      <2, 0.204826, 3.42727e-07>, <0, 1, 0>,
      <1.5, 0.204826, 0.75>, <0, 1, 0>,
      <1.36871, 0.204826, 0.684358>, <0, 1, 0>
   }
   
   smooth_triangle {
      <1.36871, 0.204826, 0.684358>, <0, 1, 0>,
      <1.82495, 0.204826, 3.241e-07>, <0, 1, 0>,
      <2, 0.204826, 3.42727e-07>, <0, 1, 0>
   }
   
   smooth_triangle {
      <0.918709, 0.204826, 2.63071e-07>, <0.593258, 0.701157, -0.395505>,
      <0.774672, 0.326698, 2.75672e-07>, <0.593258, 0.701157, -0.395505>,
      <0.581004, 0.326698, -0.290502>, <0.593258, 0.701157, -0.395505>
   }
   
   smooth_triangle {
      <0.581004, 0.326698, -0.290502>, <0.593258, 0.701157, -0.395505>,
      <0.689032, 0.204826, -0.344516>, <0.593258, 0.701157, -0.395505>,
      <0.918709, 0.204826, 2.63071e-07>, <0.593258, 0.701157, -0.395505>
   }
   
   smooth_triangle {
      <0.689032, 0.204826, -0.344516>, <0, 1, 0>,
      <1.36871, 0.204826, -0.684357>, <0, 1, 0>,
      <1.82495, 0.204826, 3.241e-07>, <0, 1, 0>
   }
   
   smooth_triangle {
      <1.82495, 0.204826, 3.241e-07>, <0, 1, 0>,
      <0.918709, 0.204826, 2.63071e-07>, <0, 1, 0>,
      <0.689032, 0.204826, -0.344516>, <0, 1, 0>
   }
   
   smooth_triangle {
      <1.82495, 0.204826, 3.241e-07>, <0, 1, 0>,
      <1.36871, 0.204826, 0.684358>, <0, 1, 0>,
      <0.689032, 0.204826, 0.344516>, <0, 1, 0>
   }
   
   smooth_triangle {
      <0.689032, 0.204826, 0.344516>, <0, 1, 0>,
      <0.918709, 0.204826, 2.63071e-07>, <0, 1, 0>,
      <1.82495, 0.204826, 3.241e-07>, <0, 1, 0>
   }
   
   smooth_triangle {
      <0.918709, 0.204826, 2.63071e-07>, <0.593257, 0.701157, 0.395505>,
      <0.689032, 0.204826, 0.344516>, <0.593257, 0.701157, 0.395505>,
      <0.581004, 0.326698, 0.290502>, <0.593257, 0.701157, 0.395505>
   }
   
   smooth_triangle {
      <0.581004, 0.326698, 0.290502>, <0.593257, 0.701157, 0.395505>,
      <0.774672, 0.326698, 2.75672e-07>, <0.593257, 0.701157, 0.395505>,
      <0.918709, 0.204826, 2.63071e-07>, <0.593257, 0.701157, 0.395505>
   }
   
   smooth_triangle {
      <-1.49012e-07, 0.326698, 0.387336>, <0.142031, 0.50359, 0.852188>,
      <0.581004, 0.326698, 0.290502>, <0.142031, 0.50359, 0.852188>,
      <0.689032, 0.204826, 0.344516>, <0.142031, 0.50359, 0.852188>
   }
   
   smooth_triangle {
      <0.689032, 0.204826, 0.344516>, <0.142031, 0.50359, 0.852188>,
      <-2.03467e-07, 0.204826, 0.459355>, <0.142031, 0.50359, 0.852188>,
      <-1.49012e-07, 0.326698, 0.387336>, <0.142031, 0.50359, 0.852188>
   }
   
   smooth_triangle {
      <-2.03467e-07, 0.204826, 0.459355>, <0, 1, 0>,
      <0.689032, 0.204826, 0.344516>, <0, 1, 0>,
      <1.36871, 0.204826, 0.684358>, <0, 1, 0>
   }
   
   smooth_triangle {
      <1.36871, 0.204826, 0.684358>, <0, 1, 0>,
      <-3.27826e-07, 0.204826, 0.912477>, <0, 1, 0>,
      <-2.03467e-07, 0.204826, 0.459355>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-3.27826e-07, 0.204826, 0.912477>, <0, 1, 0>,
      <-1.36871, 0.204826, 0.684357>, <0, 1, 0>,
      <-0.689032, 0.204826, 0.344516>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-0.689032, 0.204826, 0.344516>, <0, 1, 0>,
      <-2.03467e-07, 0.204826, 0.459355>, <0, 1, 0>,
      <-3.27826e-07, 0.204826, 0.912477>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-0.689032, 0.204826, 0.344516>, <-0.142031, 0.50359, 0.852188>,
      <-0.581004, 0.326698, 0.290502>, <-0.142031, 0.50359, 0.852188>,
      <-1.49012e-07, 0.326698, 0.387336>, <-0.142031, 0.50359, 0.852188>
   }
   
   smooth_triangle {
      <-1.49012e-07, 0.326698, 0.387336>, <-0.142031, 0.50359, 0.852188>,
      <-2.03467e-07, 0.204826, 0.459355>, <-0.142031, 0.50359, 0.852188>,
      <-0.689032, 0.204826, 0.344516>, <-0.142031, 0.50359, 0.852188>
   }
   
   smooth_triangle {
      <-0.918709, 0.204826, 9.98227e-08>, <-0.593257, 0.701157, 0.395505>,
      <-0.774672, 0.326698, 1.39698e-07>, <-0.593257, 0.701157, 0.395505>,
      <-0.581004, 0.326698, 0.290502>, <-0.593257, 0.701157, 0.395505>
   }
   
   smooth_triangle {
      <-0.581004, 0.326698, 0.290502>, <-0.593257, 0.701157, 0.395505>,
      <-0.689032, 0.204826, 0.344516>, <-0.593257, 0.701157, 0.395505>,
      <-0.918709, 0.204826, 9.98227e-08>, <-0.593257, 0.701157, 0.395505>
   }
   
   smooth_triangle {
      <-0.689032, 0.204826, 0.344516>, <0, 1, 0>,
      <-1.36871, 0.204826, 0.684357>, <0, 1, 0>,
      <-1.82495, 0.204826, -1.86265e-09>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-1.82495, 0.204826, -1.86265e-09>, <0, 1, 0>,
      <-0.918709, 0.204826, 9.98227e-08>, <0, 1, 0>,
      <-0.689032, 0.204826, 0.344516>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-1.82495, 0.204826, -1.86265e-09>, <0, 1, 0>,
      <-1.36871, 0.204826, -0.684357>, <0, 1, 0>,
      <-0.689032, 0.204826, -0.344516>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-0.689032, 0.204826, -0.344516>, <0, 1, 0>,
      <-0.918709, 0.204826, 9.98227e-08>, <0, 1, 0>,
      <-1.82495, 0.204826, -1.86265e-09>, <0, 1, 0>
   }
   
   smooth_triangle {
      <-0.689032, 0.204826, -0.344516>, <-0.593257, 0.701157, -0.395505>,
      <-0.581004, 0.326698, -0.290502>, <-0.593257, 0.701157, -0.395505>,
      <-0.774672, 0.326698, 1.39698e-07>, <-0.593257, 0.701157, -0.395505>
   }
   
   smooth_triangle {
      <-0.774672, 0.326698, 1.39698e-07>, <-0.593257, 0.701157, -0.395505>,
      <-0.918709, 0.204826, 9.98227e-08>, <-0.593257, 0.701157, -0.395505>,
      <-0.689032, 0.204826, -0.344516>, <-0.593257, 0.701157, -0.395505>
   }
   
   smooth_triangle {
      <0, 0.326698, -0.387336>, <-0.142031, 0.503591, -0.852188>,
      <-0.581004, 0.326698, -0.290502>, <-0.142031, 0.503591, -0.852188>,
      <-0.689032, 0.204826, -0.344516>, <-0.142031, 0.503591, -0.852188>
   }
   
   smooth_triangle {
      <-0.689032, 0.204826, -0.344516>, <-0.142031, 0.503591, -0.852187>,
      <-3.4952e-08, 0.204826, -0.459354>, <-0.142031, 0.503591, -0.852187>,
      <0, 0.326698, -0.387336>, <-0.142031, 0.503591, -0.852187>
   }
   
   smooth_triangle {
      <-0.689032, 0.204826, -0.344516>, <0, 1, 0>,
      <-1.36871, 0.204826, -0.684357>, <0, 1, 0>,
      <0, 0.204826, -0.912476>, <0, 1, 0>
   }
   
   smooth_triangle {
      <0, 0.204826, -0.912476>, <0, 1, 0>,
      <-3.4952e-08, 0.204826, -0.459354>, <0, 1, 0>,
      <-0.689032, 0.204826, -0.344516>, <0, 1, 0>
   }
   
   smooth_triangle {
      <0, 0.204826, -0.912476>, <0, 1, 0>,
      <1.36871, 0.204826, -0.684357>, <0, 1, 0>,
      <0.689032, 0.204826, -0.344516>, <0, 1, 0>
   }
   
   smooth_triangle {
      <0.689032, 0.204826, -0.344516>, <0, 1, 0>,
      <-3.4952e-08, 0.204826, -0.459354>, <0, 1, 0>,
      <0, 0.204826, -0.912476>, <0, 1, 0>
   }
   
   smooth_triangle {
      <0.689032, 0.204826, -0.344516>, <0.142031, 0.503591, -0.852188>,
      <0.581004, 0.326698, -0.290502>, <0.142031, 0.503591, -0.852188>,
      <0, 0.326698, -0.387336>, <0.142031, 0.503591, -0.852188>
   }
   
   smooth_triangle {
      <0, 0.326698, -0.387336>, <0.142031, 0.503591, -0.852188>,
      <-3.4952e-08, 0.204826, -0.459354>, <0.142031, 0.503591, -0.852188>,
      <0.689032, 0.204826, -0.344516>, <0.142031, 0.503591, -0.852188>
   }
   
   smooth_triangle {
      <0, 0.692312, -0.299812>, <-0.094809, 0, -0.995495>,
      <0, 1.05793, -0.299812>, <-0.094809, 0, -0.995495>,
      <-0.503685, 1.16851, -0.251843>, <-0.094809, 0, -0.995495>
   }
   
   smooth_triangle {
      <-0.503685, 1.16851, -0.251843>, <-0.163944, -0.0743176, -0.983666>,
      <-0.449719, 0.692312, -0.224859>, <-0.163944, -0.0743176, -0.983666>,
      <0, 0.692312, -0.299812>, <-0.163944, -0.0743176, -0.983666>
   }
   
   smooth_triangle {
      <0, 0.692312, -0.299812>, <-0.159999, 0.22981, -0.959994>,
      <-0.449719, 0.692312, -0.224859>, <-0.159999, 0.22981, -0.959994>,
      <-0.581004, 0.326698, -0.290502>, <-0.159999, 0.22981, -0.959994>
   }
   
   smooth_triangle {
      <-0.581004, 0.326698, -0.290502>, <-0.159999, 0.22981, -0.959994>,
      <0, 0.326698, -0.387336>, <-0.159999, 0.22981, -0.959994>,
      <0, 0.692312, -0.299812>, <-0.159999, 0.22981, -0.959994>
   }
   
   smooth_triangle {
      <0, 0.326698, -0.387336>, <0.159999, 0.22981, -0.959994>,
      <0.581004, 0.326698, -0.290502>, <0.159999, 0.22981, -0.959994>,
      <0.449719, 0.692312, -0.224859>, <0.159999, 0.22981, -0.959994>
   }
   
   smooth_triangle {
      <0.449719, 0.692312, -0.224859>, <0.159999, 0.22981, -0.959994>,
      <0, 0.692312, -0.299812>, <0.159999, 0.22981, -0.959994>,
      <0, 0.326698, -0.387336>, <0.159999, 0.22981, -0.959994>
   }
   
   smooth_triangle {
      <0, 0.692312, -0.299812>, <0.163944, -0.0743177, -0.983666>,
      <0.449719, 0.692312, -0.224859>, <0.163944, -0.0743177, -0.983666>,
      <0.503685, 1.16851, -0.251842>, <0.163944, -0.0743177, -0.983666>
   }
   
   smooth_triangle {
      <0.503685, 1.16851, -0.251842>, <0.0948091, 0, -0.995495>,
      <0, 1.05793, -0.299812>, <0.0948091, 0, -0.995495>,
      <0, 0.692312, -0.299812>, <0.0948091, 0, -0.995495>
   }
   
   smooth_triangle {
      <-0.599625, 1.16216, 1.63913e-07>, <-0.83205, -5.27761e-08, 0.5547>,
      <-0.449719, 1.16216, 0.22486>, <-0.83205, -5.27761e-08, 0.5547>,
      <-0.449719, 0.692312, 0.22486>, <-0.83205, -5.27761e-08, 0.5547>
   }
   
   smooth_triangle {
      <-0.449719, 0.692312, 0.22486>, <-0.83205, 0, 0.5547>,
      <-0.599625, 0.692312, 1.63913e-07>, <-0.83205, 0, 0.5547>,
      <-0.599625, 1.16216, 1.63913e-07>, <-0.83205, 0, 0.5547>
   }
   
   smooth_triangle {
      <-0.449719, 0.692312, 0.22486>, <-0.772974, 0.37008, 0.515316>,
      <-0.581004, 0.326698, 0.290502>, <-0.772974, 0.37008, 0.515316>,
      <-0.774672, 0.326698, 1.39698e-07>, <-0.772974, 0.37008, 0.515316>
   }
   
   smooth_triangle {
      <-0.774672, 0.326698, 1.39698e-07>, <-0.772975, 0.370081, 0.515316>,
      <-0.599625, 0.692312, 1.63913e-07>, <-0.772975, 0.370081, 0.515316>,
      <-0.449719, 0.692312, 0.22486>, <-0.772975, 0.370081, 0.515316>
   }
   
   smooth_triangle {
      <-0.774672, 0.326698, 1.39698e-07>, <-0.772974, 0.370081, -0.515316>,
      <-0.581004, 0.326698, -0.290502>, <-0.772974, 0.370081, -0.515316>,
      <-0.449719, 0.692312, -0.224859>, <-0.772974, 0.370081, -0.515316>
   }
   
   smooth_triangle {
      <-0.449719, 0.692312, -0.224859>, <-0.772974, 0.370081, -0.515316>,
      <-0.599625, 0.692312, 1.63913e-07>, <-0.772974, 0.370081, -0.515316>,
      <-0.774672, 0.326698, 1.39698e-07>, <-0.772974, 0.370081, -0.515316>
   }
   
   smooth_triangle {
      <-0.599625, 0.692312, 1.63913e-07>, <-0.825551, -0.124744, -0.550368>,
      <-0.449719, 0.692312, -0.224859>, <-0.825551, -0.124744, -0.550368>,
      <-0.503685, 1.16851, -0.251843>, <-0.825551, -0.124744, -0.550368>
   }
   
   smooth_triangle {
      <-0.503685, 1.16851, -0.251843>, <-0.934488, 0, -0.355995>,
      <-0.599625, 1.16216, 1.63913e-07>, <-0.934488, 0, -0.355995>,
      <-0.599625, 0.692312, 1.63913e-07>, <-0.934488, 0, -0.355995>
   }
   
   smooth_triangle {
      <-1.19209e-07, 1.16216, 0.299813>, <0.164399, 0, 0.986394>,
      <0.449719, 1.16216, 0.22486>, <0.164399, 0, 0.986394>,
      <0.449719, 0.692312, 0.22486>, <0.164399, 0, 0.986394>
   }
   
   smooth_triangle {
      <0.449719, 0.692312, 0.22486>, <0.164399, 0, 0.986394>,
      <-1.19209e-07, 0.692312, 0.299813>, <0.164399, 0, 0.986394>,
      <-1.19209e-07, 1.16216, 0.299813>, <0.164399, 0, 0.986394>
   }
   
   smooth_triangle {
      <-1.19209e-07, 0.692312, 0.299813>, <0.159999, 0.22981, 0.959994>,
      <0.449719, 0.692312, 0.22486>, <0.159999, 0.22981, 0.959994>,
      <0.581004, 0.326698, 0.290502>, <0.159999, 0.22981, 0.959994>
   }
   
   smooth_triangle {
      <0.581004, 0.326698, 0.290502>, <0.159999, 0.22981, 0.959994>,
      <-1.49012e-07, 0.326698, 0.387336>, <0.159999, 0.22981, 0.959994>,
      <-1.19209e-07, 0.692312, 0.299813>, <0.159999, 0.22981, 0.959994>
   }
   
   smooth_triangle {
      <-1.49012e-07, 0.326698, 0.387336>, <-0.159999, 0.22981, 0.959994>,
      <-0.581004, 0.326698, 0.290502>, <-0.159999, 0.22981, 0.959994>,
      <-0.449719, 0.692312, 0.22486>, <-0.159999, 0.22981, 0.959994>
   }
   
   smooth_triangle {
      <-0.449719, 0.692312, 0.22486>, <-0.159999, 0.22981, 0.959994>,
      <-1.19209e-07, 0.692312, 0.299813>, <-0.159999, 0.22981, 0.959994>,
      <-1.49012e-07, 0.326698, 0.387336>, <-0.159999, 0.22981, 0.959994>
   }
   
   smooth_triangle {
      <-1.19209e-07, 0.692312, 0.299813>, <-0.164399, -1.04277e-08, 0.986394>,
      <-0.449719, 0.692312, 0.22486>, <-0.164399, -1.04277e-08, 0.986394>,
      <-0.449719, 1.16216, 0.22486>, <-0.164399, -1.04277e-08, 0.986394>
   }
   
   smooth_triangle {
      <-0.449719, 1.16216, 0.22486>, <-0.164399, 0, 0.986394>,
      <-1.19209e-07, 1.16216, 0.299813>, <-0.164399, 0, 0.986394>,
      <-1.19209e-07, 0.692312, 0.299813>, <-0.164399, 0, 0.986394>
   }
   
   smooth_triangle {
      <0.599625, 0.692312, 2.68221e-07>, <0.934488, 0, -0.355995>,
      <0.599625, 1.16216, 2.68221e-07>, <0.934488, 0, -0.355995>,
      <0.503685, 1.16851, -0.251842>, <0.934488, 0, -0.355995>
   }
   
   smooth_triangle {
      <0.503685, 1.16851, -0.251842>, <0.825551, -0.124743, -0.550367>,
      <0.449719, 0.692312, -0.224859>, <0.825551, -0.124743, -0.550367>,
      <0.599625, 0.692312, 2.68221e-07>, <0.825551, -0.124743, -0.550367>
   }
   
   smooth_triangle {
      <0.449719, 0.692312, -0.224859>, <0.772975, 0.370081, -0.515316>,
      <0.581004, 0.326698, -0.290502>, <0.772975, 0.370081, -0.515316>,
      <0.774672, 0.326698, 2.75672e-07>, <0.772975, 0.370081, -0.515316>
   }
   
   smooth_triangle {
      <0.774672, 0.326698, 2.75672e-07>, <0.772975, 0.370081, -0.515316>,
      <0.599625, 0.692312, 2.68221e-07>, <0.772975, 0.370081, -0.515316>,
      <0.449719, 0.692312, -0.224859>, <0.772975, 0.370081, -0.515316>
   }
   
   smooth_triangle {
      <0.774672, 0.326698, 2.75672e-07>, <0.772974, 0.37008, 0.515316>,
      <0.581004, 0.326698, 0.290502>, <0.772974, 0.37008, 0.515316>,
      <0.449719, 0.692312, 0.22486>, <0.772974, 0.37008, 0.515316>
   }
   
   smooth_triangle {
      <0.449719, 0.692312, 0.22486>, <0.772974, 0.37008, 0.515316>,
      <0.599625, 0.692312, 2.68221e-07>, <0.772974, 0.37008, 0.515316>,
      <0.774672, 0.326698, 2.75672e-07>, <0.772974, 0.37008, 0.515316>
   }
   
   smooth_triangle {
      <0.449719, 0.692312, 0.22486>, <0.83205, 0, 0.5547>,
      <0.449719, 1.16216, 0.22486>, <0.83205, 0, 0.5547>,
      <0.599625, 1.16216, 2.68221e-07>, <0.83205, 0, 0.5547>
   }
   
   smooth_triangle {
      <0.599625, 1.16216, 2.68221e-07>, <0.83205, 0, 0.5547>,
      <0.599625, 0.692312, 2.68221e-07>, <0.83205, 0, 0.5547>,
      <0.449719, 0.692312, 0.22486>, <0.83205, 0, 0.5547>
   }
   
   smooth_triangle {
      <0.599625, 1.16216, 2.68221e-07>, <0.83205, 0, 0.5547>,
      <0.449719, 1.16216, 0.22486>, <0.83205, 0, 0.5547>,
      <0.449719, 1.59673, 0.22486>, <0.83205, 0, 0.5547>
   }
   
   smooth_triangle {
      <0.449719, 1.59673, 0.22486>, <0.83205, 0, 0.5547>,
      <0.599625, 1.59673, 2.68221e-07>, <0.83205, 0, 0.5547>,
      <0.599625, 1.16216, 2.68221e-07>, <0.83205, 0, 0.5547>
   }
   
   smooth_triangle {
      <0.449719, 1.59673, 0.22486>, <0.601988, 0.46618, 0.648295>,
      <0.333125, 1.82836, 0.166563>, <0.601988, 0.46618, 0.648295>,
      <0.449719, 1.90943, 2.55182e-07>, <0.601988, 0.46618, 0.648295>
   }
   
   smooth_triangle {
      <0.449719, 1.90943, 2.55182e-07>, <0.772838, 0.370492, 0.515226>,
      <0.599625, 1.59673, 2.68221e-07>, <0.772838, 0.370492, 0.515226>,
      <0.449719, 1.59673, 0.22486>, <0.772838, 0.370492, 0.515226>
   }
   
   smooth_triangle {
      <-1.04308e-07, 1.90943, 0.22486>, <0.24351, 0.350209, 0.904465>,
      <0.333125, 1.82836, 0.166563>, <0.24351, 0.350209, 0.904465>,
      <0.449719, 1.59673, 0.22486>, <0.24351, 0.350209, 0.904465>
   }
   
   smooth_triangle {
      <0.449719, 1.59673, 0.22486>, <0.159988, 0.230091, 0.959928>,
      <-1.19209e-07, 1.59673, 0.299813>, <0.159988, 0.230091, 0.959928>,
      <-1.04308e-07, 1.90943, 0.22486>, <0.159988, 0.230091, 0.959928>
   }
   
   smooth_triangle {
      <0.449719, 1.59673, 0.22486>, <0.164399, 0, 0.986394>,
      <0.449719, 1.16216, 0.22486>, <0.164399, 0, 0.986394>,
      <-1.19209e-07, 1.16216, 0.299813>, <0.164399, 0, 0.986394>
   }
   
   smooth_triangle {
      <-1.19209e-07, 1.16216, 0.299813>, <0.164399, 0, 0.986394>,
      <-1.19209e-07, 1.59673, 0.299813>, <0.164399, 0, 0.986394>,
      <0.449719, 1.59673, 0.22486>, <0.164399, 0, 0.986394>
   }
   
   smooth_triangle {
      <-1.19209e-07, 1.16216, 0.299813>, <-0.164399, 1.12741e-08, 0.986394>,
      <-0.449719, 1.16216, 0.22486>, <-0.164399, 1.12741e-08, 0.986394>,
      <-0.449719, 1.59673, 0.22486>, <-0.164399, 1.12741e-08, 0.986394>
   }
   
   smooth_triangle {
      <-0.449719, 1.59673, 0.22486>, <-0.164399, 0, 0.986394>,
      <-1.19209e-07, 1.59673, 0.299813>, <-0.164399, 0, 0.986394>,
      <-1.19209e-07, 1.16216, 0.299813>, <-0.164399, 0, 0.986394>
   }
   
   smooth_triangle {
      <-0.449719, 1.59673, 0.22486>, <-0.24351, 0.350209, 0.904465>,
      <-0.333125, 1.82836, 0.166563>, <-0.24351, 0.350209, 0.904465>,
      <-1.04308e-07, 1.90943, 0.22486>, <-0.24351, 0.350209, 0.904465>
   }
   
   smooth_triangle {
      <-1.04308e-07, 1.90943, 0.22486>, <-0.159988, 0.230091, 0.959928>,
      <-1.19209e-07, 1.59673, 0.299813>, <-0.159988, 0.230091, 0.959928>,
      <-0.449719, 1.59673, 0.22486>, <-0.159988, 0.230091, 0.959928>
   }
   
   smooth_triangle {
      <-0.449719, 1.90943, 1.76951e-07>, <-0.601988, 0.46618, 0.648295>,
      <-0.333125, 1.82836, 0.166563>, <-0.601988, 0.46618, 0.648295>,
      <-0.449719, 1.59673, 0.22486>, <-0.601988, 0.46618, 0.648295>
   }
   
   smooth_triangle {
      <-0.449719, 1.59673, 0.22486>, <-0.772838, 0.370492, 0.515225>,
      <-0.599625, 1.59673, 1.63913e-07>, <-0.772838, 0.370492, 0.515225>,
      <-0.449719, 1.90943, 1.76951e-07>, <-0.772838, 0.370492, 0.515225>
   }
   
   smooth_triangle {
      <-0.449719, 1.59673, 0.22486>, <-0.83205, 5.70601e-08, 0.5547>,
      <-0.449719, 1.16216, 0.22486>, <-0.83205, 5.70601e-08, 0.5547>,
      <-0.599625, 1.16216, 1.63913e-07>, <-0.83205, 5.70601e-08, 0.5547>
   }
   
   smooth_triangle {
      <-0.599625, 1.16216, 1.63913e-07>, <-0.83205, 0, 0.5547>,
      <-0.599625, 1.59673, 1.63913e-07>, <-0.83205, 0, 0.5547>,
      <-0.449719, 1.59673, 0.22486>, <-0.83205, 0, 0.5547>
   }
   
   smooth_triangle {
      <0.449719, 1.90943, 2.55182e-07>, <0.287081, 0.766762, 0.574161>,
      <0.333125, 1.82836, 0.166563>, <0.287081, 0.766762, 0.574161>,
      <-1.04308e-07, 1.90943, 0.22486>, <0.287081, 0.766762, 0.574161>
   }
   
   smooth_triangle {
      <-1.04308e-07, 1.90943, 0.22486>, <0.205781, 0.887846, 0.411562>,
      <-5.96046e-08, 2.01367, 2.16067e-07>, <0.205781, 0.887846, 0.411562>,
      <0.449719, 1.90943, 2.55182e-07>, <0.205781, 0.887846, 0.411562>
   }
   
   smooth_triangle {
      <-1.04308e-07, 1.90943, 0.22486>, <-0.287081, 0.766762, 0.574161>,
      <-0.333125, 1.82836, 0.166563>, <-0.287081, 0.766762, 0.574161>,
      <-0.449719, 1.90943, 1.76951e-07>, <-0.287081, 0.766762, 0.574161>
   }
   
   smooth_triangle {
      <-0.449719, 1.90943, 1.76951e-07>, <-0.205781, 0.887846, 0.411562>,
      <-5.96046e-08, 2.01367, 2.16067e-07>, <-0.205781, 0.887846, 0.411562>,
      <-1.04308e-07, 1.90943, 0.22486>, <-0.205781, 0.887846, 0.411562>
   }
   
   smooth_triangle {
      <-0.449719, 1.90943, -0.580221>, <-0.280536, 0.749281, -0.599898>,
      <-0.333125, 1.82836, -0.736003>, <-0.280536, 0.749281, -0.599898>,
      <0, 1.90943, -0.790527>, <-0.280536, 0.749281, -0.599898>
   }
   
   smooth_triangle {
      <0, 1.90943, -0.790527>, <-0.20333, 0.877271, -0.434801>,
      <0, 2.01367, -0.580221>, <-0.20333, 0.877271, -0.434801>,
      <-0.449719, 1.90943, -0.580221>, <-0.20333, 0.877271, -0.434801>
   }
   
   smooth_triangle {
      <0, 1.90943, -0.790527>, <0.280536, 0.749281, -0.599898>,
      <0.333125, 1.82836, -0.736003>, <0.280536, 0.749281, -0.599898>,
      <0.449719, 1.90943, -0.580221>, <0.280536, 0.749281, -0.599898>
   }
   
   smooth_triangle {
      <0.449719, 1.90943, -0.580221>, <0.20333, 0.877271, -0.434801>,
      <0, 2.01367, -0.580221>, <0.20333, 0.877271, -0.434801>,
      <0, 1.90943, -0.790527>, <0.20333, 0.877271, -0.434801>
   }
   
   smooth_triangle {
      <-0.449719, 1.59673, -0.790527>, <-0.584653, 0.452756, -0.673196>,
      <-0.333125, 1.82836, -0.736003>, <-0.584653, 0.452756, -0.673196>,
      <-0.449719, 1.90943, -0.580221>, <-0.584653, 0.452756, -0.673196>
   }
   
   smooth_triangle {
      <-0.449719, 1.90943, -0.580221>, <-0.758556, 0.363645, -0.540699>,
      <-0.599625, 1.59673, -0.580221>, <-0.758556, 0.363645, -0.540699>,
      <-0.449719, 1.59673, -0.790527>, <-0.758556, 0.363645, -0.540699>
   }
   
   smooth_triangle {
      <-0.449719, 1.28403, -0.580221>, <-0.584652, -0.452756, -0.673197>,
      <-0.333125, 1.3651, -0.736003>, <-0.584652, -0.452756, -0.673197>,
      <-0.449719, 1.59673, -0.790527>, <-0.584652, -0.452756, -0.673197>
   }
   
   smooth_triangle {
      <-0.449719, 1.59673, -0.790527>, <-0.758556, -0.363645, -0.540699>,
      <-0.599625, 1.59673, -0.580221>, <-0.758556, -0.363645, -0.540699>,
      <-0.449719, 1.28403, -0.580221>, <-0.758556, -0.363645, -0.540699>
   }
   
   smooth_triangle {
      <0.449719, 1.59673, -0.790527>, <0.584652, -0.452756, -0.673197>,
      <0.333125, 1.3651, -0.736003>, <0.584652, -0.452756, -0.673197>,
      <0.449719, 1.28403, -0.580221>, <0.584652, -0.452756, -0.673197>
   }
   
   smooth_triangle {
      <0.449719, 1.28403, -0.580221>, <0.758556, -0.363645, -0.540699>,
      <0.599625, 1.59673, -0.580221>, <0.758556, -0.363645, -0.540699>,
      <0.449719, 1.59673, -0.790527>, <0.758556, -0.363645, -0.540699>
   }
   
   smooth_triangle {
      <0.449719, 1.90943, -0.580221>, <0.584653, 0.452755, -0.673196>,
      <0.333125, 1.82836, -0.736003>, <0.584653, 0.452755, -0.673196>,
      <0.449719, 1.59673, -0.790527>, <0.584653, 0.452755, -0.673196>
   }
   
   smooth_triangle {
      <0.449719, 1.59673, -0.790527>, <0.758556, 0.363645, -0.540699>,
      <0.599625, 1.59673, -0.580221>, <0.758556, 0.363645, -0.540699>,
      <0.449719, 1.90943, -0.580221>, <0.758556, 0.363645, -0.540699>
   }
   
   smooth_triangle {
      <0, 1.28403, -0.790527>, <-0.280536, -0.74928, -0.599899>,
      <-0.333125, 1.3651, -0.736003>, <-0.280536, -0.74928, -0.599899>,
      <-0.449719, 1.28403, -0.580221>, <-0.280536, -0.74928, -0.599899>
   }
   
   smooth_triangle {
      <-0.449719, 1.28403, -0.580221>, <-0.20333, -0.877271, -0.434801>,
      <0, 1.1798, -0.580221>, <-0.20333, -0.877271, -0.434801>,
      <0, 1.28403, -0.790527>, <-0.20333, -0.877271, -0.434801>
   }
   
   smooth_triangle {
      <0.449719, 1.28403, -0.580221>, <0.280536, -0.74928, -0.599899>,
      <0.333125, 1.3651, -0.736003>, <0.280536, -0.74928, -0.599899>,
      <0, 1.28403, -0.790527>, <0.280536, -0.74928, -0.599899>
   }
   
   smooth_triangle {
      <0, 1.28403, -0.790527>, <0.20333, -0.877271, -0.434801>,
      <0, 1.1798, -0.580221>, <0.20333, -0.877271, -0.434801>,
      <0.449719, 1.28403, -0.580221>, <0.20333, -0.877271, -0.434801>
   }
   
   smooth_triangle {
      <0, 1.90943, -0.790527>, <-0.230389, 0.33134, -0.91495>,
      <-0.333125, 1.82836, -0.736003>, <-0.230389, 0.33134, -0.91495>,
      <-0.449719, 1.59673, -0.790527>, <-0.230389, 0.33134, -0.91495>
   }
   
   smooth_triangle {
      <-0.449719, 1.59673, -0.790527>, <-0.150375, 0.216265, -0.964685>,
      <0, 1.59673, -0.860629>, <-0.150375, 0.216265, -0.964685>,
      <0, 1.90943, -0.790527>, <-0.150375, 0.216265, -0.964685>
   }
   
   smooth_triangle {
      <-0.449719, 1.59673, -0.790527>, <-0.23039, -0.33134, -0.91495>,
      <-0.333125, 1.3651, -0.736003>, <-0.23039, -0.33134, -0.91495>,
      <0, 1.28403, -0.790527>, <-0.23039, -0.33134, -0.91495>
   }
   
   smooth_triangle {
      <0, 1.28403, -0.790527>, <-0.150375, -0.216265, -0.964685>,
      <0, 1.59673, -0.860629>, <-0.150375, -0.216265, -0.964685>,
      <-0.449719, 1.59673, -0.790527>, <-0.150375, -0.216265, -0.964685>
   }
   
   smooth_triangle {
      <0, 1.28403, -0.790527>, <0.23039, -0.33134, -0.91495>,
      <0.333125, 1.3651, -0.736003>, <0.23039, -0.33134, -0.91495>,
      <0.449719, 1.59673, -0.790527>, <0.23039, -0.33134, -0.91495>
   }
   
   smooth_triangle {
      <0.449719, 1.59673, -0.790527>, <0.150375, -0.216265, -0.964685>,
      <0, 1.59673, -0.860629>, <0.150375, -0.216265, -0.964685>,
      <0, 1.28403, -0.790527>, <0.150375, -0.216265, -0.964685>
   }
   
   smooth_triangle {
      <0.449719, 1.59673, -0.790527>, <0.230389, 0.33134, -0.914951>,
      <0.333125, 1.82836, -0.736003>, <0.230389, 0.33134, -0.914951>,
      <0, 1.90943, -0.790527>, <0.230389, 0.33134, -0.914951>
   }
   
   smooth_triangle {
      <0, 1.90943, -0.790527>, <0.150375, 0.216265, -0.964685>,
      <0, 1.59673, -0.860629>, <0.150375, 0.216265, -0.964685>,
      <0.449719, 1.59673, -0.790527>, <0.150375, 0.216265, -0.964685>
   }
   
   smooth_triangle {
      <0, 2.01367, -0.299812>, <-0.22579, 0.974176, 0>,
      <-0.449719, 1.90943, -0.299812>, <-0.22579, 0.974176, 0>,
      <-0.449719, 1.90943, -0.580221>, <-0.22579, 0.974176, 0>
   }
   
   smooth_triangle {
      <-0.449719, 1.90943, -0.580221>, <-0.22579, 0.974176, 0>,
      <0, 2.01367, -0.580221>, <-0.22579, 0.974176, 0>,
      <0, 2.01367, -0.299812>, <-0.22579, 0.974176, 0>
   }
   
   smooth_triangle {
      <-0.449719, 1.90943, -0.580221>, <-0.901737, 0.432285, 0>,
      <-0.449719, 1.90943, -0.299812>, <-0.901737, 0.432285, 0>,
      <-0.599625, 1.59673, -0.299812>, <-0.901737, 0.432285, 0>
   }
   
   smooth_triangle {
      <-0.599625, 1.59673, -0.299812>, <-0.901737, 0.432285, 0>,
      <-0.599625, 1.59673, -0.580221>, <-0.901737, 0.432285, 0>,
      <-0.449719, 1.90943, -0.580221>, <-0.901737, 0.432285, 0>
   }
   
   smooth_triangle {
      <-0.599625, 1.59673, -0.299812>, <-0.901737, -0.432285, -1.83762e-07>,
      <-0.449719, 1.28403, -0.299812>, <-0.901737, -0.432285, -1.83762e-07>,
      <-0.449719, 1.28403, -0.580221>, <-0.901737, -0.432285, -1.83762e-07>
   }
   
   smooth_triangle {
      <-0.449719, 1.28403, -0.580221>, <-0.901737, -0.432285, 0>,
      <-0.599625, 1.59673, -0.580221>, <-0.901737, -0.432285, 0>,
      <-0.599625, 1.59673, -0.299812>, <-0.901737, -0.432285, 0>
   }
   
   smooth_triangle {
      <-0.449719, 1.28403, -0.580221>, <-0.22579, -0.974176, -4.14117e-07>,
      <-0.449719, 1.28403, -0.299812>, <-0.22579, -0.974176, -4.14117e-07>,
      <0, 1.1798, -0.299812>, <-0.22579, -0.974176, -4.14117e-07>
   }
   
   smooth_triangle {
      <0, 1.1798, -0.299812>, <-0.22579, -0.974176, 0>,
      <0, 1.1798, -0.580221>, <-0.22579, -0.974176, 0>,
      <-0.449719, 1.28403, -0.580221>, <-0.22579, -0.974176, 0>
   }
   
   smooth_triangle {
      <-0.449719, 1.28403, -0.299812>, <-0.158229, -0.314714, -0.935905>,
      <-0.503685, 1.16851, -0.251843>, <-0.158229, -0.314714, -0.935905>,
      <0, 1.05793, -0.299812>, <-0.158229, -0.314714, -0.935905>
   }
   
   smooth_triangle {
      <0, 1.05793, -0.299812>, <6.62681e-08, 0, -1>,
      <0, 1.1798, -0.299812>, <6.62681e-08, 0, -1>,
      <-0.449719, 1.28403, -0.299812>, <6.62681e-08, 0, -1>
   }
   
   smooth_triangle {
      <0, 1.05793, -0.299812>, <0.158229, -0.314714, -0.935905>,
      <0.503685, 1.16851, -0.251842>, <0.158229, -0.314714, -0.935905>,
      <0.449719, 1.28403, -0.299812>, <0.158229, -0.314714, -0.935905>
   }
   
   smooth_triangle {
      <0.449719, 1.28403, -0.299812>, <6.62681e-08, 0, -1>,
      <0, 1.1798, -0.299812>, <6.62681e-08, 0, -1>,
      <0, 1.05793, -0.299812>, <6.62681e-08, 0, -1>
   }
   
   smooth_triangle {
      <0, 1.1798, -0.299812>, <0.22579, -0.974176, 0>,
      <0.449719, 1.28403, -0.299812>, <0.22579, -0.974176, 0>,
      <0.449719, 1.28403, -0.580221>, <0.22579, -0.974176, 0>
   }
   
   smooth_triangle {
      <0.449719, 1.28403, -0.580221>, <0.22579, -0.974176, 0>,
      <0, 1.1798, -0.580221>, <0.22579, -0.974176, 0>,
      <0, 1.1798, -0.299812>, <0.22579, -0.974176, 0>
   }
   
   smooth_triangle {
      <0.449719, 1.28403, -0.580221>, <0.901737, -0.432285, 0>,
      <0.449719, 1.28403, -0.299812>, <0.901737, -0.432285, 0>,
      <0.599625, 1.59673, -0.299812>, <0.901737, -0.432285, 0>
   }
   
   smooth_triangle {
      <0.599625, 1.59673, -0.299812>, <0.901737, -0.432285, 0>,
      <0.599625, 1.59673, -0.580221>, <0.901737, -0.432285, 0>,
      <0.449719, 1.28403, -0.580221>, <0.901737, -0.432285, 0>
   }
   
   smooth_triangle {
      <0.599625, 1.59673, -0.299812>, <0.901737, 0.432285, 0>,
      <0.449719, 1.90943, -0.299812>, <0.901737, 0.432285, 0>,
      <0.449719, 1.90943, -0.580221>, <0.901737, 0.432285, 0>
   }
   
   smooth_triangle {
      <0.449719, 1.90943, -0.580221>, <0.901737, 0.432285, 0>,
      <0.599625, 1.59673, -0.580221>, <0.901737, 0.432285, 0>,
      <0.599625, 1.59673, -0.299812>, <0.901737, 0.432285, 0>
   }
   
   smooth_triangle {
      <0.449719, 1.90943, -0.580221>, <0.22579, 0.974176, 0>,
      <0.449719, 1.90943, -0.299812>, <0.22579, 0.974176, 0>,
      <0, 2.01367, -0.299812>, <0.22579, 0.974176, 0>
   }
   
   smooth_triangle {
      <0, 2.01367, -0.299812>, <0.22579, 0.974176, 0>,
      <0, 2.01367, -0.580221>, <0.22579, 0.974176, 0>,
      <0.449719, 1.90943, -0.580221>, <0.22579, 0.974176, 0>
   }
   
   smooth_triangle {
      <-0.449719, 1.90943, -0.299812>, <-0.901737, 0.432285, 0>,
      <-0.449719, 1.90943, 1.76951e-07>, <-0.901737, 0.432285, 0>,
      <-0.599625, 1.59673, 1.63913e-07>, <-0.901737, 0.432285, 0>
   }
   
   smooth_triangle {
      <-0.599625, 1.59673, 1.63913e-07>, <-0.901737, 0.432285, 0>,
      <-0.599625, 1.59673, -0.299812>, <-0.901737, 0.432285, 0>,
      <-0.449719, 1.90943, -0.299812>, <-0.901737, 0.432285, 0>
   }
   
   smooth_triangle {
      <0, 2.01367, -0.299812>, <-0.22579, 0.974176, -4.48885e-08>,
      <-5.96046e-08, 2.01367, 2.16067e-07>, <-0.22579, 0.974176, -4.48885e-08>,
      <-0.449719, 1.90943, 1.76951e-07>, <-0.22579, 0.974176, -4.48885e-08>
   }
   
   smooth_triangle {
      <-0.449719, 1.90943, 1.76951e-07>, <-0.22579, 0.974176, 0>,
      <-0.449719, 1.90943, -0.299812>, <-0.22579, 0.974176, 0>,
      <0, 2.01367, -0.299812>, <-0.22579, 0.974176, 0>
   }
   
   smooth_triangle {
      <0.449719, 1.90943, -0.299812>, <0.22579, 0.974176, 6.73328e-08>,
      <0.449719, 1.90943, 2.55182e-07>, <0.22579, 0.974176, 6.73328e-08>,
      <-5.96046e-08, 2.01367, 2.16067e-07>, <0.22579, 0.974176, 6.73328e-08>
   }
   
   smooth_triangle {
      <-5.96046e-08, 2.01367, 2.16067e-07>, <0.22579, 0.974176, 4.48885e-08>,
      <0, 2.01367, -0.299812>, <0.22579, 0.974176, 4.48885e-08>,
      <0.449719, 1.90943, -0.299812>, <0.22579, 0.974176, 4.48885e-08>
   }
   
   smooth_triangle {
      <0.599625, 1.59673, 2.68221e-07>, <0.901737, 0.432285, 2.68907e-07>,
      <0.449719, 1.90943, 2.55182e-07>, <0.901737, 0.432285, 2.68907e-07>,
      <0.449719, 1.90943, -0.299812>, <0.901737, 0.432285, 2.68907e-07>
   }
   
   smooth_triangle {
      <0.449719, 1.90943, -0.299812>, <0.901737, 0.432285, 1.86658e-07>,
      <0.599625, 1.59673, -0.299812>, <0.901737, 0.432285, 1.86658e-07>,
      <0.599625, 1.59673, 2.68221e-07>, <0.901737, 0.432285, 1.86658e-07>
   }
   
   smooth_triangle {
      <1.5, 0.00154762, 0.75>, <0.83205, 0, 0.5547>,
      <1.5, 0.204826, 0.75>, <0.83205, 0, 0.5547>,
      <2, 0.204826, 3.42727e-07>, <0.83205, 0, 0.5547>
   }
   
   smooth_triangle {
      <2, 0.204826, 3.42727e-07>, <0.83205, 0, 0.5547>,
      <2, 0.00154762, 3.42727e-07>, <0.83205, 0, 0.5547>,
      <1.5, 0.00154762, 0.75>, <0.83205, 0, 0.5547>
   }
   
   smooth_triangle {
      <2, 0.00154762, 3.42727e-07>, <0.832051, 0, -0.5547>,
      <2, 0.204826, 3.42727e-07>, <0.832051, 0, -0.5547>,
      <1.5, 0.204826, -0.75>, <0.832051, 0, -0.5547>
   }
   
   smooth_triangle {
      <1.5, 0.204826, -0.75>, <0.832051, 0, -0.5547>,
      <1.5, 0.00154762, -0.75>, <0.832051, 0, -0.5547>,
      <2, 0.00154762, 3.42727e-07>, <0.832051, 0, -0.5547>
   }
   
   smooth_triangle {
      <-1.5, 0.00154762, 0.75>, <-0.164399, 0, 0.986394>,
      <-1.5, 0.204826, 0.75>, <-0.164399, 0, 0.986394>,
      <-3.57628e-07, 0.204826, 1>, <-0.164399, 0, 0.986394>
   }
   
   smooth_triangle {
      <-3.57628e-07, 0.204826, 1>, <-0.164399, 0, 0.986394>,
      <-3.57628e-07, 0.00154762, 1>, <-0.164399, 0, 0.986394>,
      <-1.5, 0.00154762, 0.75>, <-0.164399, 0, 0.986394>
   }
   
   smooth_triangle {
      <-3.57628e-07, 0.00154762, 1>, <0.164399, 0, 0.986394>,
      <-3.57628e-07, 0.204826, 1>, <0.164399, 0, 0.986394>,
      <1.5, 0.204826, 0.75>, <0.164399, 0, 0.986394>
   }
   
   smooth_triangle {
      <1.5, 0.204826, 0.75>, <0.164399, 0, 0.986394>,
      <1.5, 0.00154762, 0.75>, <0.164399, 0, 0.986394>,
      <-3.57628e-07, 0.00154762, 1>, <0.164399, 0, 0.986394>
   }
   
   smooth_triangle {
      <-1.5, 0.00154762, -0.75>, <-0.83205, 0, -0.5547>,
      <-1.5, 0.204826, -0.75>, <-0.83205, 0, -0.5547>,
      <-2, 0.204826, -1.49012e-08>, <-0.83205, 0, -0.5547>
   }
   
   smooth_triangle {
      <-2, 0.204826, -1.49012e-08>, <-0.83205, 0, -0.5547>,
      <-2, 0.00154762, -1.49012e-08>, <-0.83205, 0, -0.5547>,
      <-1.5, 0.00154762, -0.75>, <-0.83205, 0, -0.5547>
   }
   
   smooth_triangle {
      <-2, 0.00154762, -1.49012e-08>, <-0.83205, 0, 0.5547>,
      <-2, 0.204826, -1.49012e-08>, <-0.83205, 0, 0.5547>,
      <-1.5, 0.204826, 0.75>, <-0.83205, 0, 0.5547>
   }
   
   smooth_triangle {
      <-1.5, 0.204826, 0.75>, <-0.83205, 0, 0.5547>,
      <-1.5, 0.00154762, 0.75>, <-0.83205, 0, 0.5547>,
      <-2, 0.00154762, -1.49012e-08>, <-0.83205, 0, 0.5547>
   }
   
   smooth_triangle {
      <1.5, 0.00154762, -0.75>, <0.164399, 0, -0.986394>,
      <1.5, 0.204826, -0.75>, <0.164399, 0, -0.986394>,
      <0, 0.204826, -1>, <0.164399, 0, -0.986394>
   }
   
   smooth_triangle {
      <0, 0.204826, -1>, <0.164399, 0, -0.986394>,
      <0, 0.00154762, -1>, <0.164399, 0, -0.986394>,
      <1.5, 0.00154762, -0.75>, <0.164399, 0, -0.986394>
   }
   
   smooth_triangle {
      <0, 0.00154762, -1>, <-0.164399, 0, -0.986394>,
      <0, 0.204826, -1>, <-0.164399, 0, -0.986394>,
      <-1.5, 0.204826, -0.75>, <-0.164399, 0, -0.986394>
   }
   
   smooth_triangle {
      <-1.5, 0.204826, -0.75>, <-0.164399, 0, -0.986394>,
      <-1.5, 0.00154762, -0.75>, <-0.164399, 0, -0.986394>,
      <0, 0.00154762, -1>, <-0.164399, 0, -0.986394>
   }
   
   smooth_triangle {
      <0.599625, 1.59673, -0.299812>, <0.39449, -0.189115, -0.899229>,
      <0.449719, 1.28403, -0.299812>, <0.39449, -0.189115, -0.899229>,
      <0.503685, 1.16851, -0.251842>, <0.39449, -0.189115, -0.899229>
   }
   
   smooth_triangle {
      <0.599625, 1.59673, -0.299812>, <0.904672, -0.241975, -0.350737>,
      <0.503685, 1.16851, -0.251842>, <0.904672, -0.241975, -0.350737>,
      <0.599625, 1.16216, 2.68221e-07>, <0.904672, -0.241975, -0.350737>
   }
   
   smooth_triangle {
      <0.599625, 1.16216, 2.68221e-07>, <1, 0, 3.97612e-07>,
      <0.599625, 1.59673, 2.68221e-07>, <1, 0, 3.97612e-07>,
      <0.599625, 1.59673, -0.299812>, <1, 0, 3.97612e-07>
   }
   
   smooth_triangle {
      <-0.449719, 1.28403, -0.299812>, <-0.39449, -0.189115, -0.899229>,
      <-0.599625, 1.59673, -0.299812>, <-0.39449, -0.189115, -0.899229>,
      <-0.503685, 1.16851, -0.251843>, <-0.39449, -0.189115, -0.899229>
   }
   
   smooth_triangle {
      <-0.599625, 1.16216, 1.63913e-07>, <-0.904672, -0.241975, -0.350737>,
      <-0.503685, 1.16851, -0.251843>, <-0.904672, -0.241975, -0.350737>,
      <-0.599625, 1.59673, -0.299812>, <-0.904672, -0.241975, -0.350737>
   }
   
   smooth_triangle {
      <-0.599625, 1.59673, -0.299812>, <-1, 0, 0>,
      <-0.599625, 1.59673, 1.63913e-07>, <-1, 0, 0>,
      <-0.599625, 1.16216, 1.63913e-07>, <-1, 0, 0>
   }
   scale 0.2
   translate y*1.78
}

#declare O_Ladder_Rail = merge {
   difference {
      torus {
         0.8, 0.08
         rotate z*90
         translate y*0.75
      }
      
      box {
         <-0.1, -0.2, -0.9>, <0.1, 0.75, 0.9>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   cylinder {
      <0, 0.75, -0.8>, <0, -5, -0.8>, 0.08
   }
   
   cylinder {
      <0, 0.75, 0.8>, <0, 0, 0.8>, 0.08
   }
   
   cylinder {
      <0, 0, 0>, <0, 0.02, 0>, 0.25
      translate z*0.8
   }
}

#declare O_Ladder_Rung = cylinder {
   <1.2, 0, 0>, <-1.2, 0, 0>, 0.07
   translate z*(-0.8)
}

#declare O_Ladder = union {
   object {
      //*PMName Rail
      O_Ladder_Rail
      translate x*(-1.2)
   }
   
   object {
      //*PMName Rail
      O_Ladder_Rail
      translate x*1.2
   }
   
   object {
      //*PMName Rung
      O_Ladder_Rung
   }
   
   object {
      //*PMName Rung
      O_Ladder_Rung
      translate y*(-1.2)
   }
   
   object {
      //*PMName Rung
      O_Ladder_Rung
      translate y*(-2.4)
   }
   
   object {
      //*PMName Rung
      O_Ladder_Rung
      translate y*(-3.6)
   }
   
   object {
      //*PMName Rung
      O_Ladder_Rung
      translate y*(-4.8)
   }
}

#declare O_Pier_Post = merge {
   cylinder {
      <0, 0, 2>, <0, 0, -0.2>, 0.2
   }
   
   sphere {
      <0, 0, 2>, 0.2
   }
   
   texture {
      T_Wood15
   }
   rotate x*270
}

#declare O_Pier_Brace = box {
   <-0.04, -0.125, -2.9>, <0.04, 0.125, 2.9>
   
   texture {
      T_Wood15
   }
}

#declare O_Pier_Posts_Pair = union {
   object {
      //*PMName Post_Left
      O_Pier_Post
      translate x*(-2.8)
   }
   
   object {
      //*PMName Post_Right
      O_Pier_Post
      translate x*2.8
   }
   
   object {
      //*PMName Brace_1
      O_Pier_Brace
      rotate <0, 90, -12>
      translate <0, 0.6, 0.24>
   }
   
   object {
      //*PMName Brace_2
      O_Pier_Brace
      rotate <0, 90, 12>
      translate <0, 0.6, -0.24>
   }
}

#declare O_Pier_Bearer = box {
   <-0.08, -0.15, -1.2>, <0.08, 0.15, 10.2>
   
   texture {
      T_Wood15
   }
}

#declare O_Pier_Board = box {
   <-0.2, -0.04, -2.6>, <0.2, 0.04, 2.6>
   
   texture {
      T_Wood15
   }
   rotate y*90
}

#declare O_Pier_Boards = union {
   object {
      O_Pier_Board
      translate y*1.74
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 0.41>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 0.82>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 1.23>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 1.64>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 2.05>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 2.46>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 2.87>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 3.28>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 3.69>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 4.1>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 4.51>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 4.92>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 5.33>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 5.74>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 6.15>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 6.56>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 6.97>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 7.38>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 7.79>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 8.2>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 8.61>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 9.02>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 9.43>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 9.84>
   }
   
   object {
      O_Pier_Board
      translate <0, 1.74, 10.25>
   }
}

#declare O_Pier_Assembly = union {
   object {
      //*PMName Posts_First
      O_Pier_Posts_Pair
   }
   
   object {
      //*PMName Posts_Second
      O_Pier_Posts_Pair
      translate z*5
   }
   
   object {
      //*PMName Posts_Third
      O_Pier_Posts_Pair
      translate z*10
   }
   
   object {
      //*PMName Bearer_Left
      O_Pier_Bearer
      translate <-2.52, 1.55, 0>
   }
   
   object {
      //*PMName Bearer_Right
      O_Pier_Bearer
      translate <2.52, 1.55, 0>
   }
   
   object {
      //*PMName Boards
      O_Pier_Boards
      translate z*(-0.25)
   }
   
   object {
      //*PMName Boat_Hook
      O_Boat_Hook
      rotate y*270
      translate <-2.3, 0, 9>
   }
   
   object {
      //*PMName Boat_Hook
      O_Boat_Hook
      rotate y*90
      translate <2.3, 0, 9>
   }
   
   object {
      //*PMName Boat_Hook
      O_Boat_Hook
      rotate y*270
      translate <-2.3, 0, 4>
   }
   
   object {
      //*PMName Boat_Hook
      O_Boat_Hook
      rotate y*90
      translate <2.3, 0, 4>
   }
   
   object {
      //*PMName Boat_Hook
      O_Boat_Hook
      rotate y*90
      translate <2.3, 0, -1>
   }
   
   object {
      //*PMName Ladder
      O_Ladder
      rotate y*180
      scale 0.5
      translate <1.2, 1.78, 10.4>
      
      texture {
         T_Pole
      }
   }
}

#declare O_Pier = union {
   object {
      //*PMName Assemply
      O_Pier_Assembly
   }
   
   union {
      //*PMName Lamp_n_Banner
      
      object {
         //*PMName Lamp
         O_Lamp
      }
      
      object {
         //*PMName Flag
         O_Banner
         scale 1.75
         rotate y*270
         translate <0, 9.25, -1.15>
      }
      scale 0.6
      rotate y*270
      translate <2.66, 1.4, 9.5>
   }
   
   union {
      //*PMName Lamp_n_Banner
      
      object {
         //*PMName Lamp
         O_Lamp
      }
      
      object {
         //*PMName Flag
         O_Banner
         scale 1.75
         rotate y*90
         translate <0, 9.25, -1.15>
      }
      scale 0.6
      rotate y*90
      translate <-2.66, 1.4, 9.5>
   }
   
   object {
      //*PMName Tyre
      O_Tyre
      scale 0.55
      rotate y*90
      translate <2.89, 1, 1.33>
   }
   
   object {
      //*PMName Tyre
      O_Tyre
      scale 0.55
      rotate y*90
      translate <2.89, 1, -1.34>
   }
   
   object {
      //*PMName Tyre
      O_Tyre
      scale 0.55
      rotate y*90
      translate <-2.89, 1, 1.33>
   }
   
   object {
      //*PMName Tyre
      O_Tyre
      scale 0.55
      rotate y*90
      translate <2.89, 1, 3.6>
   }
   
   object {
      //*PMName Tyre
      O_Tyre
      scale 0.55
      rotate y*90
      translate <-2.89, 1, 3.6>
   }
   
   object {
      //*PMName Tyre
      O_Tyre
      scale 0.55
      rotate y*90
      translate <2.89, 1, 6.4>
   }
   
   object {
      //*PMName Tyre
      O_Tyre
      scale 0.55
      rotate y*90
      translate <-2.89, 1, 6.4>
   }
   
   object {
      //*PMName Tyre
      O_Tyre
      scale 0.55
      rotate y*90
      translate <2.89, 1, 8.6>
   }
   
   object {
      //*PMName Tyre
      O_Tyre
      scale 0.55
      rotate y*90
      translate <-2.89, 1, 8.6>
   }
}

#declare O_Prop = sphere {
   <0, 0, 0>, 0.5
   
   pigment {
      color rgb <0.992157, 0.94902, 0.556863>
   }
}

#declare O_SunBather = object {
   O_Prop
}

#declare O_Towel = bicubic_patch {
   type 0
   u_steps 3
   v_steps 3
   uv_vectors <1, 1> <0, 1> <0, 0> <1, 0>
   <-1.2, 0, -3>, <-0.394103, 0.0107691, -2.9464>, <0.401197, -0.00546755, -3>, <1.16688, 0.00257726, -3.0357>,
   <-1.21759, 0.00717942, -1>, <-0.4, 0, -0.87496>, <0.4, 0, -1.2144>, <0.960701, 0.000638717, -1.0536>,
   <-1.1464, 0, 1.0179>, <-0.32855, 0, 1.0893>, <0.38342, 0.07658, 0.8571>, <1.1933, 0.00260021, 1>,
   <-1.2357, 0.00111643, 3.01818>, <-0.41786, 0, 3.0536>, <0.301176, -1.12816e-05, 3.0357>, <1.11082, 0.00367252, 2.98445>
   
   texture {
      uv_mapping
      T_Towel
   }
}

#declare O_FlipFlops = box {
   <-0.5, 0, -1>, <0.5, 0.5, 1>
}

#declare O_Sail_Boat = object {
   O_Prop
}

object {
   //*PMName Moon
   O_MoonNightQuarter
   translate <-60, 27, 85>
}

light_source {
   //*PMName MoonLight
   <-620, 2, 820>, rgb <0.83, 0.95, 0.97>
   area_light <1, 0, 0>, <0, 1, 0>, 2, 2
   adaptive 2
   jitter
   circular
   fade_distance 600
   fade_power 5
}

camera {
   //*PMName Camera2
   perspective
   location <5.3063, 3.1539, -3.1387>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <-1.9861, 3.2141, 3.2974>
   angle 50
}

fog {
   fog_type 2
   distance 65
    rgb <0.05, 0.05, 0.05> 
   turbulence <0.2, 0.2, 0.2>
   lambda 0
   turb_depth 1
   fog_offset 0.2
   fog_alt 0.7
   up <0, 1, 0>
}

sphere {
   //*PMName Sky
   <0, 0, 0>, 0.5
   scale 100000
   
   texture {
      T_Starfield
   }
   no_reflection
   hollow
}

disc {
   //*PMName Ocean
   <0, 0, 0>,<0, 1, 0>, 100000,0
   
   texture {
      T_Water
   }
}

object {
   //*PMName Pier
   O_Pier
   translate <-5, -0.5, 0>
}

light_source {
   //*PMName Lamp_Light
   <-2.94, 8.8, 9.5>, rgb <0.980392, 0.921569, 0.843137>
   area_light <0, 0, 1>, <1, 0, 0>, 3, 3
   adaptive 2
   jitter
   circular
   orient
   fade_distance 7
   fade_power 2
}

light_source {
   //*PMName Lamp_Light
   <-7.06, 8.8, 9.5>, rgb <0.980392, 0.921569, 0.843137>
   area_light <0, 0, 1>, <1, 0, 0>, 3, 3
   adaptive 2
   jitter
   circular
   orient
   fade_distance 7
   fade_power 2
}
//*PMRawBegin
#include "sunbather.inc"
//*PMRawEnd

object {
   //*PMName SunBather
   O_SunBather
   scale 1.18
   rotate y*180
   translate <-5, 1.25, 5.7>
}

object {
   //*PMName Towel
   O_Towel
   scale <0.9, 1, 0.9>
   translate <-5, 1.29, 7>
}
//*PMRawBegin
#include "flipflops.inc"
//*PMRawEnd

object {
   //*PMName FlipFlops
   O_FlipFlops
   scale 1.18
   rotate y*185
   translate <-3.4, 1.28, 7.5>
}

object {
   //*PMName Dori
   O_Dori
   scale 0.2
   rotate <-180, -78, 180>
   translate <-10.4361, 1.37, 3.69794>
}

sphere_sweep {
   b_spline,
   8,
   <-6.8371, 1.3443, 8.9086>,0.05
   <-7.26, 1.4005, 8.9499>,0.05
   <-7.608, 1.3348, 8.5775>,0.05
   <-8.7219, 1.13, 8.2052>,0.05
   <-9.6487, 1.1617, 7.8714>,0.05
   <-10.3332, 1.37755, 7.61556>,0.05
   <-10.6837, 0.898749, 7.37115>,0.05
   <-10.3192, 0.878443, 7.17192>,0.05
   
   texture {
      T_Rope
   }
}

cylinder {
   <0, 2, 0>, <0, -2, 0>, 0.05
   scale 1
   rotate <62, -54.2, 0>
   translate <-12.4706, 1.18443, 3.26636>
   
   texture {
      T_Wood15
   }
}

cylinder {
   <0, 2, 0>, <0, -2, 0>, 0.05
   scale 1
   rotate <62, 26, 0>
   translate <-8.41201, 1.17264, 4.11003>
   
   texture {
      T_Wood15
   }
}