global_settings { assumed_gamma 2.2 }

#include "colors.inc"         
#include "stones.inc"
#include "Woods.inc"
#include "textures.inc"       
#include "glass.inc"

#include "ChessPieces.inc"
#include "ChessBoard.inc"        
#include "CheckerPieces.inc"     
#include "Tables.inc"      
#include "Chairs.inc" 
#include "Books.inc" 
#include "FirePlace.inc"          
#include "myTree.inc"           
#include "OddsAndEnds.inc"
                        
#declare FLOOR = 0;
#declare CEILING = 8 * 12;                       
#declare BACK_WALL = 120;
#declare RIGHT_WALL = 100;                   
                        
// behind the white king's rook      
//camera {
//  location <-7, 8, -5>
//  look_at <2, 0, 5>
//  }  


// look at table            
camera {
  location <-27, 66 + FLOOR, -30>
  look_at <2, 36 + FLOOR, 5>
  }  

/*            
// look at fireplace            
camera {
  location <-27, 66 + FLOOR, -30>
  look_at <-40, 36 + FLOOR, 35>
  }  
*/             

  
// Incandesant lights
light_source { <-37, 90, 7> rgb <0.8,0.8,0.7>}
light_source { < 3, 90, -37> rgb <0.8,0.8,0.7>}
               
               
#declare pieces = array[8][8]                                         
  {                                                                   
    {W_ROOK  ,R_CHECKER,BLANK,BLANK,BLANK,BLANK,B_PAWN,B_ROOK},
    {W_KNIGHT,W_PAWN,BLANK,BLANK,BLANK,BLANK,B_PAWN,B_KNIGHT},
    {W_BISHOP,W_PAWN,BLANK,BLANK,BLANK,BLANK,B_PAWN,B_BISHOP},
    {W_QUEEN ,W_PAWN,BLANK,BLANK,BLANK,BLANK,B_PAWN,B_QUEEN},
    {W_KING  ,BLANK,BLANK,W_PAWN,BLANK,BLANK,B_PAWN,B_KING},
    {W_BISHOP,W_PAWN,BLANK,BLANK,BLANK,BLANK,B_PAWN,B_BISHOP},
    {W_KNIGHT,W_PAWN,BLANK,BLANK,BLANK,BLANK,B_PAWN,B_KNIGHT},
    {W_ROOK  ,W_PAWN,BLANK,BLANK,BLANK,BLANK,B_PAWN,B_ROOK}
  }                                                                                                          
       
#declare myChessBoard = union
  {       
  ChessBoard(pieces) 
  
  translate <-6,36,-10>  
  rotate <0,-30,0>
  }
  
myChessBoard
  
object 
  {
  Table
  translate <0,36,0>
  }             
  
  
// floor
plane
  {
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  FLOOR // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?
  texture 
    {                   
    checker
      texture {T_Grnt19}
      texture {T_Grnt20 rotate <0,90,0>}    
    scale <12,1,12>
    }
  }


// right wall                             
plane
  {
  x,
  RIGHT_WALL
  hollow on
  texture
    {
    pigment {rgb <.8,.8,.8>}
    }
  }       
  
// right wall baseboard
box
  {
  <0,0,0><-0.25,4.00,-25.00*12>
  texture {T_Wood5}
  translate <RIGHT_WALL,FLOOR,BACK_WALL>
  }

// back wall  
plane
  {
  z,
  BACK_WALL
  hollow on
  texture
    {
    pigment {rgb <.8,.8,.8>}
    }
  }  
   
// ceiling
plane
  {
  y,
  CEILING
  hollow on
  texture
    {
    pigment {rgb <.8,.8,.8>}
    }
  }   
                  
                  
                  
// ------------------------------------------------
// Book Shelves and Books
// ------------------------------------------------

BookPile(RIGHT_WALL - 35.5,FLOOR + 0.5,BACK_WALL - 20     ,RIGHT_WALL - 35.5 + 35,FLOOR + 12.5,BACK_WALL,12345)
BookPile(RIGHT_WALL - 35.5,FLOOR + 0.5 + 15,BACK_WALL - 20,RIGHT_WALL - 35.5 + 35,FLOOR + 12.5 + 15,BACK_WALL,12346)
BookPile(RIGHT_WALL - 35.5,FLOOR + 0.5 + 30,BACK_WALL - 20,RIGHT_WALL - 35.5 + 35,FLOOR + 12.5 + 30,BACK_WALL,12347)
BookPile(RIGHT_WALL - 35.5,FLOOR + 0.5 + 45,BACK_WALL - 20,RIGHT_WALL - 35.5 + 35,FLOOR + 12.5 + 45,BACK_WALL,12348)

BookPile(RIGHT_WALL - 71.5,FLOOR + 0.5,BACK_WALL - 20     ,RIGHT_WALL - 71.5 + 35,FLOOR + 12.5,BACK_WALL,12325)
BookPile(RIGHT_WALL - 71.5,FLOOR + 0.5 + 15,BACK_WALL - 20,RIGHT_WALL - 71.5 + 35,FLOOR + 12.5 + 15,BACK_WALL,12326)
BookPile(RIGHT_WALL - 71.5,FLOOR + 0.5 + 30,BACK_WALL - 20,RIGHT_WALL - 71.5 + 35,FLOOR + 12.5 + 30,BACK_WALL,12327)
BookPile(RIGHT_WALL - 71.5,FLOOR + 0.5 + 45,BACK_WALL - 20,RIGHT_WALL - 71.5 + 35,FLOOR + 12.5 + 45,BACK_WALL,12328)
    
  
object 
  {
  BookShelf
  translate <RIGHT_WALL - 36,FLOOR,BACK_WALL>
  }
  
  
object 
  {
  BookShelf
  translate <RIGHT_WALL - 72,FLOOR,BACK_WALL>
  }
  
                       
object
  {
//  box {<0,0,0><2,2,2> texture{pigment{color White}}}
  White_Pawn
  translate <RIGHT_WALL - 40,FLOOR + 30.5,BACK_WALL - 23>
  }              


#declare T_ChessBook = texture
        {  
        pigment {image_map {sys "ChessBook.bmp"}}             
        normal  {bumps 0.01 scale <0.01,0.01,1>}        
        rotate <0,-90,0>
        scale <6,7,6>      
        translate <0,0,-0.5>
        }
  
union
  {
  Book2(2,9,5,T_PAPER,T_ChessBook,texture {pigment {color Red} normal {bumps 0.5 scale 0.01}})
  rotate<0,0,90>
  rotate<0,78,0>
  translate <-14,36,-15>
  }
 
object
  {
  wood_chair
  rotate<0,23,0>
  translate <40,0,40>
  }
  
object
  {
  wood_chair
  rotate<0,-27,0>
  translate <-30,0,35>
  }
  
object
  {
  wood_chair
  rotate<0,104,0>
  translate <10,0,-25>
  }

object
  {
  fireplace
  translate <RIGHT_WALL - 105,0,BACK_WALL - 0>
  }                                               
  
// logs
union
  {
  cone 
    {
    <0,0,0> 3
    <18,0,0> 3
    texture {bark1}
    translate <RIGHT_WALL -105 - 9,17,BACK_WALL - 9>
    }
  cone 
    {
    <0,0,0> 3
    <18,0,0> 3
    texture {bark1}
    translate <RIGHT_WALL -105 - 9,17,BACK_WALL - 15>
    }
  cone 
    {
    <0,0,0> 3
    <18,0,0> 3
    texture {bark1}
    translate <RIGHT_WALL -105 - 9,17 + 4,BACK_WALL - 12>
    }
  }
  

// potted tree
object
  {
  clay_pot
  translate <70,0,32>
  }


 
union
  {
  myTree(<0,0,0>,<0,1,0>,2,seed(132),leaf_3,0.2, bark2)
  scale 0.3
  translate <70,4,32>
  }

  
  
// coffee cup and spill  
object
  {
  coffee_cup  
  rotate<0,132,90>     
  translate <10.5,37.45,13>
  }
                 
object
  {
  coffee_spill
  translate <2,36.0,14>
  }                 