// Tree

#include "colors.inc"

#declare bark1 = 
  texture
    {
    pigment 
      {
      gradient x+z+y
      turbulence 0.9 
      frequency 4
      color_map
        {
        [0.00 color DarkBrown]
        [0.70 color Bronze]
        [0.90 color DarkWood]
        [1.00 color Brown]
        }      
      scale 1.5
      }  
    normal 
      { 
      gradient x+z+y
      turbulence 0.9 
      frequency 4
      scale 1.5
      }
    }

#declare bark2 = 
  texture
    {
    pigment 
      {
      gradient x+z+y
      turbulence 0.9 
      frequency 4
      color_map
        {
        [0.00 color White]
        [0.70 color Bronze]
        [0.90 color DarkWood]
        [1.00 color Brown]
        }      
      scale 1.5
      }  
    normal 
      { 
      gradient x+z+y
      turbulence 0.9 
      frequency 4
      scale 1.5
      }
    }

#declare leaf_1 =  sphere
      {
      <0,0,0>,0.5
      pigment {color Green}
      }                                                              

#declare leaf_2 =  sphere
      {
      <0,0,0>,0.5
      pigment {color Red}
      }                                  
      
#declare leaf_3 = sphere                   
      {
      <0,0,0>,0.5
      pigment {color Green}
      scale <1,2,0.1>
      }                             
      
#declare leaf_4 = sphere //pine needle
      {
      <0,0,0>,0.5
      pigment {color Green}
      translate <0,0.05,0>
      scale <0.1,2,0.1>
      }
                                           
#declare branchWidthVariance=0.2;
#declare branchWidthVarBase=(1.0 - branchWidthVariance) / 2.0;                                
                                                                
                                                                
#macro myTree(startLoc, startVec, startWidth, R, leaf, gravity, bark)
  
  #local endLoc = 20 * rand(R) * sqrt(startWidth) * startVec + startLoc;
                                                       
                  
  #if (startWidth > 0.020)
    #local nextVec1 = vnormalize(<(rand(R)-.5),(rand(R)-.5),(rand(R)-.5)>*0.5 + startVec + <0,-1,0> * 0.3 * sqrt(startWidth) * gravity);
    #local nextVec2 = vnormalize(<(rand(R)-.5),(rand(R)-.5),(rand(R)-.5)>*0.5 + startVec + <0,-1,0> * 0.3 * sqrt(startWidth) * gravity);
    #local nextWidth1 = sqrt(startWidth * startWidth * (branchWidthVarBase + rand(R)*branchWidthVariance));
    #local nextWidth2 = sqrt(startWidth * startWidth - nextWidth1 * nextWidth1);
    #local maxNextWidth = max(nextWidth1,nextWidth2);

    cone 
      {
      startLoc,startWidth,
      endLoc, maxNextWidth
      texture 
        {
        bark
        rotate startVec
        }
      }                                                         
    
    myTree(endLoc,nextVec1,nextWidth1,R,leaf,gravity,bark)
    myTree(endLoc,nextVec2,nextWidth2,R,leaf,gravity,bark)
  #else                    
    object
      {
      leaf
      rotate startVec * 360
      translate startLoc       
      }
  #end                                                       
                                                       
#end                         

#macro pineTree(startLoc, startVec, startWidth, R, leaf, gravity, bark)
  #local endLoc = 6.5 * (rand(R) + rand(R)) * sqrt(startWidth) * startVec + startLoc;
  
  #if (startWidth > 0.020) //branch         
    #local nextVec1 = vnormalize(vcross(<rand(R),rand(R),rand(R)>, startVec) + startVec/2); 
    #local nextVec2 = vaxis_rotate(nextVec1,startVec,75 + 45 * (1.5 - rand(R)));
    #local nextVec3 = vaxis_rotate(nextVec1,startVec,165 + 45 * (1.5 - rand(R)));
    #local nextVec4 = vaxis_rotate(nextVec1,startVec,255 + 45 * (1.5 - rand(R)));
    #local nextVec5 = vnormalize(startVec+<0,-1,0> * 0.3 * sqrt(startWidth) * gravity);
    #local nextWidth1 = sqrt(startWidth * startWidth * (branchWidthVarBase + rand(R)*branchWidthVariance)) / 2.5;
    #local nextWidth2 = sqrt(startWidth * startWidth * (branchWidthVarBase + rand(R)*branchWidthVariance)) / 2.5;
    #local nextWidth3 = sqrt(startWidth * startWidth * (branchWidthVarBase + rand(R)*branchWidthVariance)) / 2.5;
    #local nextWidth4 = sqrt(startWidth * startWidth * (branchWidthVarBase + rand(R)*branchWidthVariance)) / 2.5;
    #local nextwidth5 = sqrt(startWidth * startWidth - nextWidth1 * nextWidth1 - nextWidth2 * nextWidth2 - nextWidth3 * nextWidth3 - nextWidth4 * nextWidth4);
        
    cone 
      {
      startLoc,startWidth,
      endLoc, nextwidth5
      texture 
        {
        bark
        rotate startVec
        }
      }                                                         

    pineTree(endLoc,nextVec1,nextWidth1,R,leaf,gravity,bark)
    pineTree(endLoc,nextVec2,nextWidth2,R,leaf,gravity,bark)
    pineTree(endLoc,nextVec3,nextWidth3,R,leaf,gravity,bark)
    pineTree(endLoc,nextVec4,nextWidth4,R,leaf,gravity,bark)
    pineTree(endLoc,nextVec5,nextwidth5,R,leaf,gravity,bark)
    
  #else //leaf
    object
      {
      leaf
      rotate startVec*360
      translate startLoc
      }
  #end
#end                              


#macro pineTree2(startLoc, startVec, startWidth, R, leaf, gravity, bark)
  #local endLoc = 6.5 * (rand(R) + rand(R)) * sqrt(startWidth) * startVec + startLoc;
  
  #if (startWidth > 0.020) //branch         
    #local nextVec1 = vnormalize(vcross(<rand(R),rand(R),rand(R)>, startVec) + startVec/2); 
    #local nextVec2 = vaxis_rotate(nextVec1,startVec,75 + 45 * (1.5 - rand(R)));
    #local nextVec3 = vaxis_rotate(nextVec1,startVec,165 + 45 * (1.5 - rand(R)));
    #local nextVec4 = vaxis_rotate(nextVec1,startVec,255 + 45 * (1.5 - rand(R)));
    #local nextVec5 = vnormalize(startVec+<0,-1,0> * 0.3 * sqrt(startWidth) * gravity);
    #local nextWidth1 = sqrt(startWidth * startWidth * sqrt(rand(R))*(branchWidthVarBase + branchWidthVariance)) / 2.5;
    #local nextWidth2 = sqrt(startWidth * startWidth * sqrt(rand(R))*(branchWidthVarBase + branchWidthVariance)) / 2.5;
    #local nextWidth3 = sqrt(startWidth * startWidth * sqrt(rand(R))*(branchWidthVarBase + branchWidthVariance)) / 2.5;
    #local nextWidth4 = sqrt(startWidth * startWidth * sqrt(rand(R))*(branchWidthVarBase + branchWidthVariance)) / 2.5;
    #local nextwidth5 = sqrt(startWidth * startWidth - nextWidth1 * nextWidth1 - nextWidth2 * nextWidth2 - nextWidth3 * nextWidth3 - nextWidth4 * nextWidth4);
        
    cone 
      {
      startLoc,startWidth,
      endLoc, nextwidth5
      texture 
        {
        bark
        rotate startVec
        }
      }                                                         

    pineTree(endLoc,nextVec1,nextWidth1,R,leaf,gravity)
    pineTree(endLoc,nextVec2,nextWidth2,R,leaf,gravity)
    pineTree(endLoc,nextVec3,nextWidth3,R,leaf,gravity)
    pineTree(endLoc,nextVec4,nextWidth4,R,leaf,gravity)
    pineTree(endLoc,nextVec5,nextwidth5,R,leaf,gravity)
    
  #else //leaf
    object
      {
      leaf
      rotate startVec*360
      translate startLoc
      }
  #end
#end