// Persistence of Vision Ray Tracer Scene Description File
// File: lifebuoy.pov
// Desc: "The Lonley Buoy"
//   Submitted to the "Out of Place" round of IRTC.
// Date: 25 February 2005
// Auth: Daniel Nilsson (irtc@daniel-nilsson.com)

// Render with 2/1 aspect ratio!
// +W1600 +H800 +AM2 +A0.3
// +W1200 +H600
// +W800 +H400
// +W400 +H200

#declare UseIsosurface = true;
#declare UseAreaLight = true;
#declare UseRadiocity = true;
#declare ShowSky = true;
#declare ShowChromeSphere = false;
#declare Camera = 1;

#if (UseRadiocity)
  #default { finish { ambient 0.0 } }
#end

#include "colors.inc"
#include "woods.inc"
#include "shapes.inc"
#include "functions.inc"
#include "rad_def.inc"
#include "CIE.inc"
#include "lightsys.inc"
#include "lightsys_constants.inc"

global_settings {
  assumed_gamma 1.0
  #if (UseRadiocity)
    radiosity {
      Rad_Settings(Radiosity_OutdoorLight, off, off)
    }  
  #end
}

// LightSys
#declare Lightsys_Brightness = 2.0;
#declare Lightsys_Filter = <1,1,1>;

#include "sunpos.inc"

// Skylight
#declare tmp = SunPos(2005, 01, 11, 15, 40, 0, 20.5, 12.8);
#declare North = z;   
#declare DomeSize = 100000;
#declare Current_Turbidity = 3.0;
#declare Intensity_Mult = 0.5; 

#if (ShowSky)
  #include "CIE_Skylight.inc"
  #declare SunDist = vlength(SolarPosition);

  light_source { SolarPosition Light_Color(SunColor,1)
  
    #if (UseAreaLight)
      // The sun's diameter is about 1/100 of the distance from earth to the sun
      area_light SunDist/100*x, SunDist/100*y, 5, 5
      adaptive 1
      jitter
      circular
      orient
    #end
  
    parallel
  }
  
#else // No Sky
  // Next line is cut'n'pasted from CIE_Skylight.inc
  #declare SolarPosition=vrotate(z,<-Al, Az+degrees(atan2( North.x, North.z)),0>)*DomeSize;
  
  light_source { SolarPosition Light_Color(<1, 1, 1>,1)
  
    #if (UseAreaLight)
      // The sun's diameter is about 1/100 of the distance from earth to the sun
      area_light SunDist/100*x, SunDist/100*y, 4, 4
      adaptive 0
      jitter
      circular
      orient
    #end
  
    parallel
  }

#end


#switch (Camera)
  #case (1)
    camera {
      location <0, 2.0, -5>
      up y
      right x*2
      look_at <0, 1.5, 0>
      rotate y*-30
      translate <5, 0, 0>
    }
    #break
  #case (2)
    camera {
      location <5, 1.5, -2.5>
      up y
      right x*image_width/image_height
      look_at <4, 0.5, -1>
      angle 30
    }
    #break
  #case (3)
    camera {
      location <5, 1.5, -2.5>
      up y
      right x*image_width/image_height
      look_at <4, 0.7, -1>
      angle 15
    }
    #break
#end


#if (ShowChromeSphere)
  sphere { <5, 2, 0>, 1
    texture {
      pigment { Black }
      finish {
        reflection 0.8
      }
    }
  }
#end

#declare M_Sand = material {
  texture {
    pigment { rgb 2 * <pow(0.65, 2.2), pow(0.44, 2.2), pow(0.29, 2.2)> }
  }
}

#declare M_Rope = material {
  texture {
    pigment { bozo
      color_map {
        [ 0 color <0.9, 0.9, 0.9> ]
        [ 1 color <0.4, 0.2, 0.0> ]
      }
      scale 0.05
    }
    normal { quilted 1.0
      control0 0
      control1 1
      scale 0.005
    }
  }
}

#declare M_Bouy = material {
  texture {
    bozo
    scale 0.1
    texture_map {
     [ 0 pigment { checker color <0.95, 0.95, 0.95>, color <0.95, 0.05, 0.00> translate z/2 rotate z*45 scale 100 }
         finish { specular 0.3 roughness 0.01 } ]
     [ 1 pigment { color <0.50, 0.30, 0.15> }
         finish { specular 0.0 } ]
    }
  }
}

#declare M_OldMetal = material {
  texture {
    crackle
    turbulence 0.3
    scale 0.02
    texture_map {
      [ 0.02 pigment { color <0.1, 0.05, 0.0> }
             finish { } ]
      [ 0.03 pigment { color <0.2, 0.2, 0.2> }
             finish { phong 0.7 phong_size 30 reflection { 0.85 } }
             normal { crackle -0.2 turbulence 0.3 } ]
    }
  }
}

#if (UseIsosurface)
  isosurface {
    function { y
      - 5 * f_ridged_mf(x/10, y/5, z/10, 0.1, 1, 5, 0.5, 0, 2)
      + 4 * f_noise3d(x/20, 0, z/4)
    }
    contained_by { box { <-1000, -3, -1000>, <1000, 1.1, 1000> } }
    threshold 1.0
    accuracy 0.001
    max_gradient 2.00
    translate <15, 1.5, 5>
    material { M_Sand }
  }
#else
  plane { y, -0.5
    material { M_Sand }
  }
#end

#declare LifeBuoy = union {
  torus { 0.25, 0.06
    scale <1, 0.5, 1>
    rotate x*90
    material { M_Bouy }  
  }
  sphere_sweep { b_spline 7   // Top
    <0.20, 0.00, 0>, 0.005
    <0.30, 0.01, 0>, 0.005
    <0.38, 0.02, 0>, 0.005
    <0.10, 0.20, -0.10>, 0.005
    <0.02, 0.37, 0>, 0.005
    <0.01, 0.30, 0>, 0.005
    <0.00, 0.20, 0>, 0.005
    material { M_Rope }
    rotate z*45
  }
  sphere_sweep { b_spline 7   // Right
    <0.20, 0.00, 0>, 0.005
    <0.30, 0.01, 0>, 0.005
    <0.40, 0.02, 0>, 0.005
    <0.30, 0.20, 0.03>, 0.005
    <0.03, 0.37, 0>, 0.005
    <0.01, 0.30, 0>, 0.005
    <0.00, 0.20, 0>, 0.005
    material { M_Rope }
    rotate z*-45
  }
  sphere_sweep { b_spline 7   // Left
    <0.20, 0.00, 0>, 0.005
    <0.30, 0.01, 0>, 0.005
    <0.35, 0.02, 0>, 0.005
    <0.22, 0.32, 0.02>, 0.005
    <0.00, 0.38, 0>, 0.005
    <0.01, 0.30, 0>, 0.005
    <0.00, 0.20, 0>, 0.005
    material { M_Rope }
    rotate z*135
  }
  sphere_sweep { b_spline 7   // Bottom
    <0.20, 0.00, 0>, 0.005
    <0.30, 0.01, 0>, 0.005
    <0.37, 0.03, 0>, 0.005
    <0.33, 0.31, 0>, 0.005
    <0.03, 0.36, 0>, 0.005
    <0.01, 0.30, 0>, 0.005
    <0.00, 0.20, 0>, 0.005
    material { M_Rope }
    rotate z*-135
  }
}

#declare BuoyHolder = intersection {
  torus { 0.25, 0.08
    scale <1, 0.5, 1>
    rotate x*90
  }
  torus { 0.25, 0.07
    inverse
    scale <1, 0.5, 1>
    rotate x*90
  }
  box { <-0.07, 0.15, -0.04>, <0.07, 0.25, 0.04> }
  cylinder { <0, 0, -0.04>, <0, 0, 0.04>, 0.23 }
  translate <0, 0.01, 0>
  material { M_OldMetal }
}

#declare Pole = object { Round_Box_Union( <-0.05, 0, -0.025>, <0.05, 1.35, 0.025>, 0.01)
  material {
    texture { T_Wood3
      normal {
        wood 2 
        turbulence 0.04
        octaves 3
        scale <0.05, .05, 1>
        rotate <2,2,0>
      }    
      rotate x*90 scale 0.1
    }
  }
  translate <0, 0, 0.06>
}

union {
  
  object { LifeBuoy
    translate <0, 1, 0>
  }
  
  object { BuoyHolder
    translate <0, 1, 0>
  }

  object { Pole }  
  
  rotate <5, 0, 3>
  translate <4, -0.5, -1>
}

