// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Orthographic Scene Example
//       useful for generating image_maps, heightfields, etc.
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------


// ----------------------------------------
     
#macro MakeTileFromImage2(NomImage,Columns,Rows,Objet,OutFile)
#local myF= function {
          pigment {
            image_map {
              jpeg NomImage
            }
          }
        }
#local RefPos = <0,15,0>;
#local RefDist = 30;
#local nb=0;
#local ex=0;
#fopen fichier OutFile write              
#local i=0;
#while (i<Rows)
  #local j=0;
  #while(j<Columns)      
    #local MV=myF(j/Columns+1/(Columns*2),i/Rows+1/(Rows*2),0);
    #local MVF=<MV.x,MV.y,MV.z>;       
      #write (fichier, "object { ",Objet," translate <",j-(Columns/2),",",i-(Rows/2),",0> pigment{ color rgb <",MVF.x,",",MVF.y,",",MVF.z,"> }}\n")
      #local nb=nb+1;                           
      //#debug concat(vstr(3,TilePos,",",0,1),"-<
//    #if(i=239)
//      #debug concat("i[",str(i,0,0),"][",str(j,0,0),"]=<",vstr(3,MVF,",",0,-1),">\n")
//    #end
    #local j=j+1;
  #end                 
  #local i=i+1;
#end  
#fclose fichier      
#debug concat("written = ",str(nb,0,0))
#end
              

#macro MakeTileFromImage2(NomImage,Columns,Rows,Objet,OutFile, Transform)
#local myF= function {
          pigment {
            image_map {
              jpeg NomImage
            }
          }
        }
#local RefPos = <0,15,0>;
#local RefDist = 30;
#local nb=0;
#local ex=0;
#fopen fichier OutFile write 
#fopen fichierex concat(OutFile,".ex") write             
#local i=0;
#while (i<Rows)
  #local j=0;
  #while(j<Columns)      
    #local MV=myF(j/Columns+1/(Columns*2),i/Rows+1/(Rows*2),0);
    #local MVF=<MV.x,MV.y,MV.z>;       
    #local TilePos=<j-(Columns/2),i,0>;
    #if(vlength(TilePos-RefPos) >= RefDist | TilePos.y < RefPos.y)    
      #write (fichier, "object { ",Objet," translate <",j-(Columns/2),",",i-(Rows/2),",0> pigment{ color rgb <",MVF.x,",",MVF.y,",",MVF.z,"> } ",Transform, "}\n")
      #local nb=nb+1;                           
      //#debug concat(vstr(3,TilePos,",",0,1),"-<
    #else
      #write (fichierex, "object { ",Objet," translate <",j-(Columns/2),",",i-(Rows/2),",0> pigment{ color rgb <",MVF.x,",",MVF.y,",",MVF.z,"> } ",Transform, "}\n")
      #local ex=ex+1;
    #end
//    #if(i=239)
//      #debug concat("i[",str(i,0,0),"][",str(j,0,0),"]=<",vstr(3,MVF,",",0,-1),">\n")
//    #end
    #local j=j+1;
  #end                 
  #local i=i+1;
#end  
#fclose fichier 
#fclose fichierex     
#debug concat("written = ",str(nb,0,0)," points, excluded ",str(ex,0,0),"\n")
#end
              

