#include "colors.inc"     
#include "rand.inc"                                
#include "functions.inc"
#include "grasshalm.pov"

camera {
  location <5, 15, -25>
  look_at <0,4,0>
  angle 30
}          
#declare light = off;
#if(light)
  light_source {
    <-25, 30, -40>
    rgb 1//<1, .8, .5>
  }
#end
         
#declare spikesstep = .0005;

#declare fn_pigm = function { //Funktion that makes the grooves into the kaktus
  pigment {
    gradient x
    frequency 50
    pigment_map {
      [0.00 Red ]
      [0.25 Red ]
      [0.50 Blue]
      [0.75 Blue]
      [1.00 Red ]
    }
    warp {
      spherical
      orientation y
    }
    warp {
      turbulence .05
    }
  }  
}                   

#declare fn_pigm_t = function { //For the torus parts the function has to be warped a different way
  pigment {
    gradient y
    frequency 50
    pigment_map {
      [0.00 Red ]
      [0.25 Red ]
      [0.50 Blue]
      [0.75 Blue]
      [1.00 Red ]
    }
    warp {
      toroidal
      orientation x
    }
    warp {
      turbulence .05
    }               
  }  
}               

#declare snow = texture {
  pigment { rgb <.3,.48,.1> }
  pigment {
    bozo
    pigment_map {
      [0.0 rgb .35*<.3,.48,.1>+.65*<1, 1, 1>]
      [0.4 rgb .45*<.3,.48,.1>+.55*<1, 1, 1>]
      [0.5 rgb .35*<.3,.48,.1>+.65*<.95,.95,1>]
      [0.6 rgb .45*<.3,.48,.1>+.55*<.95,.95,1>]
      [0.7 rgb .35*<.3,.48,.1>+.65*<1, 1, 1>]
      [1.0 rgb .35*<.3,.48,.1>+.65*<1, 1, 1>]
      /*[0.0 rgbt <1, 1, 1, .35>]
      [0.4 rgbt <1, 1, 1, .45>]
      [0.5 rgbt <.95,.95,1,.35>]
      [0.6 rgbt <.95,.95,1,.45>]
      [0.7 rgbt <1, 1, 1, .35>]
      [1.0 rgbt <1, 1, 1, .35>]*/
    }            
  }     
  finish {
    phong 1 phong_size 1 ambient .85 diffuse 5
  }
  normal {
    wrinkles .1
    scale .05
  }
  rotate <23432,2341,1234>
}   

#declare texx1 = texture {
  pigment { rgb <.3,.48,.1> }
  pigment {
    bozo
    pigment_map {
      [0.0 rgb .45*<.3,.48,.1>+.55*<1,1,1>]
      [0.4 rgb .45*<.3,.48,.1>+.55*<1, 1, 1>]
      [0.5 rgb .45*<.3,.48,.1>+.55*<.95,.95,1>]
      [0.6 rgb .45*<.3,.48,.1>+.55*<.95,.95,1>]
      [0.7 rgb .45*<.3,.48,.1>+.55*<1, 1, 1>]
      [1.0 rgb .45*<.3,.48,.1>+.55*<1, 1, 1>]
      /*[0.0 rgbt <1, 1, 1, .45>]
      [0.4 rgbt <1, 1, 1, .45>]
      [0.5 rgbt <.95,.95,1,.45>]
      [0.6 rgbt <.95,.95,1,.45>]
      [0.7 rgbt <1, 1, 1, .45>]
      [1.0 rgbt <1, 1, 1, .45>]*/
    }            
  }     
  finish {
    phong 1 phong_size 1 ambient .65 diffuse 2.5
  }
  normal {
    wrinkles .1
    scale .05
  }     
  rotate <12321,13231,123123>
}   

#declare kaktustex = texture {
    bozo 
    turbulence .5
    texture_map {
      [0.00 texx1]
      [0.50 snow]
      [1.00 texx1]
    }     
    translate 0     
    scale <1.5, 2.5, 1.5>
  }  

/*#declare kaktustex = pigment {
  rgb <.3,.48,.1>
}*/

#declare cyl = isosurface {              //cylinder
  function { sqrt(pow(x,2) + pow(z,2)) - 1 + .025*fn_pigm(x,y,z).red }
  contained_by { box {<-1.001,0,-1.001>, <1.001,5,1.001>}}
  max_gradient 4//9.7
  texture { kaktustex }
  //finish { phong 0 }
}

#declare sph = isosurface {              //cap
  function { sqrt(pow(x,2) + pow((y-5)/3,2) + pow(z,2)) - 1 + .025*fn_pigm(x,y,z).red }
  contained_by { box { <-1.001,5,-1.001>, <1.001,8,1.001> } }
  max_gradient 4//20.9
  texture { kaktustex }
  //finish { phong 0 }
}               

#declare kaktusbody = merge {  //main Body
  object { cyl }
  object { sph }
}

//object { kaktusbody }     
            
//arm1
#declare arm1 = merge {    
  isosurface {//Torus
    function { f_torus(x,y,z,1,.5) + .025*fn_pigm_t(x,y,z).red  }
    contained_by {
      box {
        <-1,-.5,0>, <1.5,.5,1.5>
      }
    }     
    max_gradient 4//2.4          
    rotate x*90
    translate <1,4,0> 
    scale .90 translate y*-.5  
  }         
  isosurface {//Cylinder
    function { sqrt(pow(x,2) + pow(z,2)) - .5 + .025*fn_pigm(x,y,z).red }
    contained_by {
      box {
        <-.5,-.0001,-.5>, <.5,.1,.5>
      }
    }    
    max_gradient 4//3.4  
    rotate y*3             
    translate <2,4,0>
    scale .90 translate y*-.5
  }
  isosurface {//Cap
    function { sqrt(pow(x,2) + pow(y,2) + pow(z,2)) - .5 + .025*fn_pigm(x,y,z).red }
    contained_by {
      box {
        <-.5,0,-.5>, <.5,.5,.5>
      }                       
    }   
    max_gradient 4//50                      
    scale y*3
    rotate y*3
    translate <2,4.0999,0>
    scale .90 translate y*-.5
  }
  texture { kaktustex }
  //finish { phong 0 }    
}      
                     
//arm2                     
#declare arm2 = merge {    
  isosurface {//Bogen
    function { f_torus(x,y,z,1,.5) + .025*fn_pigm_t(x,y,z).red  }
    contained_by {
      box {
        <-1,-.5,0>, <1.5,.5,1.5>
      }
    }     
    max_gradient 4//2.5         
    rotate x*90
    translate <1,4,0>   
    scale .75 translate x*.25 translate y*2 rotate y*160 
  }         
  isosurface {//Cylinder
    function { sqrt(pow(x,2) + pow(z,2)) - .5 + .025*fn_pigm(x,y,z).red }
    contained_by {
      box {
        <-.5,-.0001,-.5>, <.5,.1,.5>
      }
    }    
    max_gradient 4//2.4               
    translate <2,4,0>
    scale .75 translate x*.25 translate y*2 rotate y*160 
  }
  isosurface {//Cap
    function { sqrt(pow(x,2) + pow(y,2) + pow(z,2)) - .5 + .025*fn_pigm(x,y,z).red }
    contained_by {
      box {
        <-.5,0,-.5>, <.5,.5,.5>
      }                       
    }   
    max_gradient 4//41.8                      
    scale y*3
    translate <2,4.0999,0>
    scale .75 translate x*.25 translate y*2 rotate y*160 
  }
  texture { kaktustex }
  //finish { phong 0 }    
}      

//object { arm1 }
//object { arm2 }          

#declare kaktus = union {
  object { kaktusbody }
  object { arm1 }
  object { arm2 }

///////////////////////Spikes

#declare spikestex = texture {
  pigment {rgb <.9,.9,.9>/*rgbt <.8,.8,.8, .25>*/ }
  finish { ambient .9/*.6*/ }
}

#declare S = seed(0);
//Body
#declare i=0;
#while (i<7.9)
  #declare Norm = <0,0,0>;
  #declare A = <0,i,0>;
  #declare P = trace(kaktusbody, A+.8*VRand_In_Sphere(S), VRand_In_Sphere(S), Norm);
  #if (vlength(Norm)!=0)
    cone {
      P, .006, P+.3*vnormalize(P-A), 0
      texture { spikestex }
    }
  #end
  #declare i = i + spikesstep;
#end 

//arm1
#declare i=0;
#while (i<1.43)
  #declare Norm = <0,0,0>;
  #declare A = <1.8,3.1+i,0>;
  #declare P = trace(arm1, A+.36*VRand_In_Sphere(S), VRand_In_Sphere(S), Norm);
  #if (vlength(Norm)!=0)
    cone {
      P, .006*.9, P+.27*vnormalize(P-A), 0
      texture { spikestex }
    }
  #end
  #declare i = i + spikesstep;
#end  

//arm2
#declare i=0;
#while (i<1.2)
  #declare Norm = <0,0,0>;
  #declare A = <-1.658942839,5.075+i,-0.5571432989>;
  #declare P = trace(arm2, A+.30*VRand_In_Sphere(S), VRand_In_Sphere(S), Norm);
  #if (vlength(Norm)!=0)
    cone {
      P, .006*.75, P+.3*.75*vnormalize(P-A), 0
      texture { spikestex }
    }
  #end                                            
  #declare i = i + spikesstep;
#end 
//////////////////////Torus-Parts  
#declare quater_torus = intersection { 
  torus {
    1, .5       
  }
  box {
    <0,-.5,0>, <1.5,.5,1.5>
  } 
}
 
//Torus1
#declare torus1_spikes = union {  
  #declare i = 0;
  #while (i<.5*pi)
    #declare Norm = <0,0,0>;
    #declare A = <sin(i),0,cos(i)>;
    #declare P = trace(quater_torus, A+.40*VRand_In_Sphere(S), VRand_In_Sphere(S), Norm);
    #if (vlength(Norm)!=0)
      cone {
        P, .006, P+.3*vnormalize(P-A), 0
        texture { spikestex }
      }
    #end                                       
  #declare i = i + spikesstep;
  #end 
}

object {
  torus1_spikes
  rotate x*90
  translate <1,4,0> 
  scale .90
  translate y*-.5     
}

//Torus2
#declare torus2_spikes = union {  
  #declare i = 0;
  #while (i<.5*pi)
    #declare Norm = <0,0,0>;
    #declare A = <sin(i),0,cos(i)>;
    #declare P = trace(quater_torus, A+.40*VRand_In_Sphere(S), VRand_In_Sphere(S), Norm);
    #if (vlength(Norm)!=0)
      cone {
        P, .006, P+.3*vnormalize(P-A), 0
        texture { spikestex }
      }
    #end                                           
  #declare i = i + spikesstep;
  #end 
}

object {
  torus2_spikes
  rotate x*90
  translate <1,4,0>   
  scale .75
  translate <.25,2,0>
  rotate y*160 
}                            
                                                              
                                                              
}//Ende union Kaktus                                                             
////////////////////////////////////////////Kaktus End

//object {kaktus}

/*
#declare pl1 = plane {
  y, 0
  pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
      [0.0 rgb <.6,.6,.6> ]
      [0.5 rgb <.9,.9,.9> ]
      [1.0 rgb <.6,.6,.6> ]
    }
    scale 2
    rotate -135*x
  }
}

object {pl1}*/

#declare grass = union {
//Grass1 
#declare R = seed(17);
#declare i = 0;           
#while (i<500)
  object {
    grasshalm
    rotate 40*<rand(R)-.5, rand(R)-.5, rand(R)-.7>
    translate x*(rand(R)*rand(R)+1)
    rotate y*360*rand(R)
    rotate 40*<rand(R)-.5, rand(R)-.5, rand(R)-.7>
  }  
  #declare i = i+1;
#end  
//Grass2   
#declare R = seed(18);
#declare i = 0;           
#while (i<300)
  object {
    grasshalm
    rotate 40*<rand(R)-.5, rand(R)-.5, rand(R)-.7>
    translate x*(2*rand(R)*rand(R))
    rotate y*360*rand(R)
    rotate 20*<rand(R)-.5, rand(R)-.5, rand(R)-.7>
    translate x*1
    translate y*-.2
  }  
  #declare i = i+1;
#end 
}//Ende union 
    
//Eis
#declare eiszapfen = union {
#declare eistex = texture {
  pigment { rgbt <1,1,1,.5> }
  finish { phong 5 phong_size 5 ambient .6/*.3*/ }
  normal { bumps 1 scale <.1, .3, .1> }
} 

#declare A = <-1.658942839,5.075,-0.5571432989>;
cone {
  A-y*.7, .12, A-y*2.2, 0
  texture { eistex }    
  interior { ior 10 }
  translate y*-.1
}  
cone {
  1.1*A-y*.7, .12, 1.1*A-y*2.2, 0
  texture { eistex }   
  interior { ior 10 }
  translate y*-.1
}  
cone {
  .9*A-y*.7, .12, .9*A-y*2.2, 0
  translate y*1.1
  texture { eistex }   
  interior { ior 10 }
  translate y*-.1
}       

}    
              