#include "colors.inc"
#include "kaktus.pov"
#include "snow.pov"

camera {
  location <0, 5, -40>
  look_at 0
  angle 40
}

//camera { location <50, 50, -100> look_at <0,5,-40> angle 20 }

//#default {finish{ambient 1}}

light_source {//main
  (<-2, 20.5, -18.6>+5*<-.6, 4.1, -37.2>)/6
  .25*White
  shadowless
}  
light_source {//back
  <-5,5,0>
  .25*White//Red
  shadowless
  //shadowless
}  
            
#declare RAD = off;

fog {  // <==
  distance 7//25
  rgbt <.9, .9, .9, .6>
  turbulence .2
  turb_depth .3
}

#declare f = 1.1;
sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.00000 0.00013 color rgb f*2.1*<.7,.7,.9>
                       color rgb f*2.1*<.7,.7,.9>]
      [0.00013 0.02000 color rgb f*2*<.6,.6,.9>
                       color rgb f*2*<.4,.4,.6>]
      [0.02000 0.20000 color rgb f*2*<.4,.4,.6>
                       color rgb f*2*<.2,.2,.3>]
    }
    translate -1 
    rotate -135*x
    rotate x*43
    rotate y*-7
  }
  pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
      [0.0 rgbt f*<.5,.6,.7, 1> ]
      [0.5 rgbt f*<.8,.9, 1, 0> ]
      [1.0 rgbt f*<.5,.6,.7, 1> ]
      /*[0.0 rgb <.8,.9,1> ]
      [0.5 rgb <.6,.7,.8> ]
      [1.0 rgb <.8,.9,1> ]  */
      /*[0.0 rgb <.6,.6,.6> ]
      [0.5 rgb <.1,.1,.1> ]
      [1.0 rgb <.6,.6,.6> ]*/
    }
    scale <0.2, 0.1, 0.2>
    rotate -135*x          
    rotate x*-12
  }
  pigment { rgbt f*<.7, .7, .7, .3> } 
  //pigment { rgbt <0,0,0,.9> }        
} 

/*#declare hf1 = height_field {
    sys "xyz01.bmp"
    smooth
    
    translate <-.5, -.5, -.5>
    scale <17, 1.75, 17>
    scale <10, 1, 10>
  pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
      [0.0 rgb <.8,.8,.9> ]
      [0.5 rgb < 1, 1, 1> ]
      [1.0 rgb <.8,.8,.9> ]
    }
    scale 2
    rotate -135*x
  }           
}
object { hf1 }*/

#declare hf2 = height_field {
    sys "xyz01.bmp"
    smooth
    
    rotate x*-45
    translate <-.5, -.5, -.5>
    scale <17, 1.75, 17>
    scale <10, 4, 10>
    translate z*20   
  pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
      [0.00 rgb < .9, .9,1.0> ]
      [0.45 rgb <1.1,1.1,1.1> ]
      [0.50 rgb <1.1,1.1,1.1> ]
      [0.55 rgb <1.1,1.1,1.1> ]
      [1.00 rgb < .9, .9,1.0> ]
      /*[0.0 rgb <.6,.6,.6> ]
      [0.5 rgb <.9,.9,.9> ]
      [1.0 rgb <.6,.6,.6> ]*/
    }
    scale 2
    rotate -135*x
    rotate y*90
  }                            
  finish {ambient .65/*.65/*.5*/*/}        
}              
object { hf2 }


object { kaktus     scale .1 translate <-.6, 4.1, -37.2> }
object { grass      scale .1 translate <-.6, 4.1, -37.2> }
//object { eismantel  scale .1 translate <-.6, 4.1, -37.2> }
object { eiszapfen  scale .1 translate <-.6, 4.1, -37.2> }

//Fill lights

light_source {
  <-12, 22, -40>
  .2*White
  shadowless
}
light_source {
  <-12, -22, -40>
  .1*White
  shadowless
}